<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class ref_multi_delete extends ref_multi
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'ref_multi';

	// Page object name
	public $PageObjName = "ref_multi_delete";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (ref_multi)
		if (!isset($GLOBALS["ref_multi"]) || get_class($GLOBALS["ref_multi"]) == PROJECT_NAMESPACE . "ref_multi") {
			$GLOBALS["ref_multi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ref_multi"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref_multi');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $ref_multi;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($ref_multi);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $TotalRecs = 0;
	public $RecCnt;
	public $RecKeys = array();
	public $StartRowCnt = 1;
	public $RowCnt = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("ref_multilist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->oid->Visible = FALSE;
		$this->_barcode->Visible = FALSE;
		$this->company_id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->Visible = FALSE;
		$this->product_n->Visible = FALSE;
		$this->product_type->setVisibility();
		$this->product_code->Visible = FALSE;
		$this->gcode->Visible = FALSE;
		$this->code->Visible = FALSE;
		$this->product_id->Visible = FALSE;
		$this->print_name->Visible = FALSE;
		$this->batch_no->Visible = FALSE;
		$this->last_price->Visible = FALSE;
		$this->v_01->Visible = FALSE;
		$this->v_02->Visible = FALSE;
		$this->v_03->Visible = FALSE;
		$this->v_04->Visible = FALSE;
		$this->v_05->Visible = FALSE;
		$this->v_06->Visible = FALSE;
		$this->v_07->Visible = FALSE;
		$this->v_08->Visible = FALSE;
		$this->v_09->Visible = FALSE;
		$this->v_10->Visible = FALSE;
		$this->cbm->Visible = FALSE;
		$this->sqm->Visible = FALSE;
		$this->shape->Visible = FALSE;
		$this->b_01->Visible = FALSE;
		$this->b_02->Visible = FALSE;
		$this->b_03->Visible = FALSE;
		$this->b_04->Visible = FALSE;
		$this->b_05->Visible = FALSE;
		$this->b_06->Visible = FALSE;
		$this->b_07->Visible = FALSE;
		$this->b_08->Visible = FALSE;
		$this->b_09->Visible = FALSE;
		$this->b_10->Visible = FALSE;
		$this->b_11->Visible = FALSE;
		$this->b_12->Visible = FALSE;
		$this->b_13->Visible = FALSE;
		$this->b_14->Visible = FALSE;
		$this->b_15->Visible = FALSE;
		$this->t_01->Visible = FALSE;
		$this->t_02->Visible = FALSE;
		$this->t_03->Visible = FALSE;
		$this->t_04->Visible = FALSE;
		$this->t_05->Visible = FALSE;
		$this->t_06->Visible = FALSE;
		$this->t_07->Visible = FALSE;
		$this->t_08->Visible = FALSE;
		$this->t_09->Visible = FALSE;
		$this->t_10->Visible = FALSE;
		$this->t_11->Visible = FALSE;
		$this->t_12->Visible = FALSE;
		$this->t_13->Visible = FALSE;
		$this->t_14->Visible = FALSE;
		$this->t_15->Visible = FALSE;
		$this->d_head_01->Visible = FALSE;
		$this->d_description_01->Visible = FALSE;
		$this->d_head_02->Visible = FALSE;
		$this->d_description_02->Visible = FALSE;
		$this->main_image->Visible = FALSE;
		$this->top_view->Visible = FALSE;
		$this->front_view->Visible = FALSE;
		$this->corner_view->Visible = FALSE;
		$this->back_view->Visible = FALSE;
		$this->color_options->Visible = FALSE;
		$this->other_options->Visible = FALSE;
		$this->image->Visible = FALSE;
		$this->video_url->Visible = FALSE;
		$this->currency->Visible = FALSE;
		$this->hsn->Visible = FALSE;
		$this->minimum_stock->Visible = FALSE;
		$this->in->Visible = FALSE;
		$this->out->Visible = FALSE;
		$this->required->Visible = FALSE;
		$this->blocked->Visible = FALSE;
		$this->ordered->Visible = FALSE;
		$this->status->setVisibility();
		$this->publish->Visible = FALSE;
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->v_01);
		$this->setupLookupOptions($this->v_02);
		$this->setupLookupOptions($this->v_03);
		$this->setupLookupOptions($this->v_04);
		$this->setupLookupOptions($this->v_05);
		$this->setupLookupOptions($this->v_06);
		$this->setupLookupOptions($this->v_07);
		$this->setupLookupOptions($this->v_08);
		$this->setupLookupOptions($this->v_09);
		$this->setupLookupOptions($this->v_10);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->b_03);
		$this->setupLookupOptions($this->b_04);
		$this->setupLookupOptions($this->b_05);
		$this->setupLookupOptions($this->b_06);
		$this->setupLookupOptions($this->b_07);
		$this->setupLookupOptions($this->b_08);
		$this->setupLookupOptions($this->b_09);
		$this->setupLookupOptions($this->b_10);
		$this->setupLookupOptions($this->t_03);
		$this->setupLookupOptions($this->t_04);
		$this->setupLookupOptions($this->t_05);
		$this->setupLookupOptions($this->t_06);
		$this->setupLookupOptions($this->t_07);
		$this->setupLookupOptions($this->t_08);
		$this->setupLookupOptions($this->t_09);
		$this->setupLookupOptions($this->t_10);
		$this->setupLookupOptions($this->t_11);
		$this->setupLookupOptions($this->t_12);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->hsn);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("ref_multilist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecs <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("ref_multilist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->oid->setDbValue($row['oid']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->company_id->setDbValue($row['company_id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->product_n->setDbValue($row['product_n']);
		$this->product_type->setDbValue($row['product_type']);
		$this->product_code->setDbValue($row['product_code']);
		$this->gcode->setDbValue($row['gcode']);
		$this->code->setDbValue($row['code']);
		$this->product_id->setDbValue($row['product_id']);
		$this->print_name->setDbValue($row['print_name']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->last_price->setDbValue($row['last_price']);
		$this->v_01->setDbValue($row['v_01']);
		$this->v_02->setDbValue($row['v_02']);
		$this->v_03->setDbValue($row['v_03']);
		$this->v_04->setDbValue($row['v_04']);
		$this->v_05->setDbValue($row['v_05']);
		$this->v_06->setDbValue($row['v_06']);
		$this->v_07->setDbValue($row['v_07']);
		$this->v_08->setDbValue($row['v_08']);
		$this->v_09->setDbValue($row['v_09']);
		$this->v_10->setDbValue($row['v_10']);
		$this->cbm->setDbValue($row['cbm']);
		$this->sqm->setDbValue($row['sqm']);
		$this->shape->setDbValue($row['shape']);
		$this->b_01->setDbValue($row['b_01']);
		$this->b_02->setDbValue($row['b_02']);
		$this->b_03->setDbValue($row['b_03']);
		$this->b_04->setDbValue($row['b_04']);
		$this->b_05->setDbValue($row['b_05']);
		$this->b_06->setDbValue($row['b_06']);
		$this->b_07->setDbValue($row['b_07']);
		$this->b_08->setDbValue($row['b_08']);
		$this->b_09->setDbValue($row['b_09']);
		$this->b_10->setDbValue($row['b_10']);
		$this->b_11->setDbValue($row['b_11']);
		$this->b_12->setDbValue($row['b_12']);
		$this->b_13->setDbValue($row['b_13']);
		$this->b_14->setDbValue($row['b_14']);
		$this->b_15->setDbValue($row['b_15']);
		$this->t_01->setDbValue($row['t_01']);
		$this->t_02->setDbValue($row['t_02']);
		$this->t_03->setDbValue($row['t_03']);
		$this->t_04->setDbValue($row['t_04']);
		$this->t_05->setDbValue($row['t_05']);
		$this->t_06->setDbValue($row['t_06']);
		$this->t_07->setDbValue($row['t_07']);
		$this->t_08->setDbValue($row['t_08']);
		$this->t_09->setDbValue($row['t_09']);
		$this->t_10->setDbValue($row['t_10']);
		$this->t_11->setDbValue($row['t_11']);
		$this->t_12->setDbValue($row['t_12']);
		$this->t_13->setDbValue($row['t_13']);
		$this->t_14->setDbValue($row['t_14']);
		$this->t_15->setDbValue($row['t_15']);
		$this->d_head_01->setDbValue($row['d_head_01']);
		$this->d_description_01->setDbValue($row['d_description_01']);
		$this->d_head_02->setDbValue($row['d_head_02']);
		$this->d_description_02->setDbValue($row['d_description_02']);
		$this->main_image->Upload->DbValue = $row['main_image'];
		$this->main_image->setDbValue($this->main_image->Upload->DbValue);
		$this->top_view->Upload->DbValue = $row['top_view'];
		$this->top_view->setDbValue($this->top_view->Upload->DbValue);
		$this->front_view->Upload->DbValue = $row['front_view'];
		$this->front_view->setDbValue($this->front_view->Upload->DbValue);
		$this->corner_view->Upload->DbValue = $row['corner_view'];
		$this->corner_view->setDbValue($this->corner_view->Upload->DbValue);
		$this->back_view->Upload->DbValue = $row['back_view'];
		$this->back_view->setDbValue($this->back_view->Upload->DbValue);
		$this->color_options->Upload->DbValue = $row['color_options'];
		$this->color_options->setDbValue($this->color_options->Upload->DbValue);
		$this->other_options->Upload->DbValue = $row['other_options'];
		$this->other_options->setDbValue($this->other_options->Upload->DbValue);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->video_url->setDbValue($row['video_url']);
		$this->currency->setDbValue($row['currency']);
		$this->hsn->setDbValue($row['hsn']);
		$this->minimum_stock->setDbValue($row['minimum_stock']);
		$this->in->setDbValue($row['in']);
		$this->out->setDbValue($row['out']);
		$this->required->setDbValue($row['required']);
		$this->blocked->setDbValue($row['blocked']);
		$this->ordered->setDbValue($row['ordered']);
		$this->status->setDbValue($row['status']);
		$this->publish->setDbValue($row['publish']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['oid'] = NULL;
		$row['barcode'] = NULL;
		$row['company_id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['product_n'] = NULL;
		$row['product_type'] = NULL;
		$row['product_code'] = NULL;
		$row['gcode'] = NULL;
		$row['code'] = NULL;
		$row['product_id'] = NULL;
		$row['print_name'] = NULL;
		$row['batch_no'] = NULL;
		$row['last_price'] = NULL;
		$row['v_01'] = NULL;
		$row['v_02'] = NULL;
		$row['v_03'] = NULL;
		$row['v_04'] = NULL;
		$row['v_05'] = NULL;
		$row['v_06'] = NULL;
		$row['v_07'] = NULL;
		$row['v_08'] = NULL;
		$row['v_09'] = NULL;
		$row['v_10'] = NULL;
		$row['cbm'] = NULL;
		$row['sqm'] = NULL;
		$row['shape'] = NULL;
		$row['b_01'] = NULL;
		$row['b_02'] = NULL;
		$row['b_03'] = NULL;
		$row['b_04'] = NULL;
		$row['b_05'] = NULL;
		$row['b_06'] = NULL;
		$row['b_07'] = NULL;
		$row['b_08'] = NULL;
		$row['b_09'] = NULL;
		$row['b_10'] = NULL;
		$row['b_11'] = NULL;
		$row['b_12'] = NULL;
		$row['b_13'] = NULL;
		$row['b_14'] = NULL;
		$row['b_15'] = NULL;
		$row['t_01'] = NULL;
		$row['t_02'] = NULL;
		$row['t_03'] = NULL;
		$row['t_04'] = NULL;
		$row['t_05'] = NULL;
		$row['t_06'] = NULL;
		$row['t_07'] = NULL;
		$row['t_08'] = NULL;
		$row['t_09'] = NULL;
		$row['t_10'] = NULL;
		$row['t_11'] = NULL;
		$row['t_12'] = NULL;
		$row['t_13'] = NULL;
		$row['t_14'] = NULL;
		$row['t_15'] = NULL;
		$row['d_head_01'] = NULL;
		$row['d_description_01'] = NULL;
		$row['d_head_02'] = NULL;
		$row['d_description_02'] = NULL;
		$row['main_image'] = NULL;
		$row['top_view'] = NULL;
		$row['front_view'] = NULL;
		$row['corner_view'] = NULL;
		$row['back_view'] = NULL;
		$row['color_options'] = NULL;
		$row['other_options'] = NULL;
		$row['image'] = NULL;
		$row['video_url'] = NULL;
		$row['currency'] = NULL;
		$row['hsn'] = NULL;
		$row['minimum_stock'] = NULL;
		$row['in'] = NULL;
		$row['out'] = NULL;
		$row['required'] = NULL;
		$row['blocked'] = NULL;
		$row['ordered'] = NULL;
		$row['status'] = NULL;
		$row['publish'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// oid

		$this->oid->CellCssStyle = "white-space: nowrap;";

		// barcode
		$this->_barcode->CellCssStyle = "white-space: nowrap;";

		// company_id
		// grp
		// s_grp
		// product
		// product_n
		// product_type
		// product_code

		$this->product_code->CellCssStyle = "white-space: nowrap;";

		// gcode
		$this->gcode->CellCssStyle = "white-space: nowrap;";

		// code
		$this->code->CellCssStyle = "white-space: nowrap;";

		// product_id
		$this->product_id->CellCssStyle = "white-space: nowrap;";

		// print_name
		$this->print_name->CellCssStyle = "white-space: nowrap;";

		// batch_no
		$this->batch_no->CellCssStyle = "white-space: nowrap;";

		// last_price
		// v_01
		// v_02
		// v_03
		// v_04
		// v_05
		// v_06
		// v_07
		// v_08
		// v_09
		// v_10
		// cbm
		// sqm
		// shape
		// b_01
		// b_02
		// b_03
		// b_04
		// b_05
		// b_06
		// b_07
		// b_08
		// b_09
		// b_10
		// b_11
		// b_12
		// b_13
		// b_14
		// b_15
		// t_01
		// t_02
		// t_03
		// t_04
		// t_05
		// t_06
		// t_07
		// t_08
		// t_09
		// t_10
		// t_11
		// t_12
		// t_13
		// t_14
		// t_15
		// d_head_01
		// d_description_01
		// d_head_02
		// d_description_02
		// main_image
		// top_view
		// front_view
		// corner_view
		// back_view
		// color_options
		// other_options
		// image
		// video_url
		// currency
		// hsn
		// minimum_stock

		$this->minimum_stock->CellCssStyle = "white-space: nowrap;";

		// in
		$this->in->CellCssStyle = "white-space: nowrap;";

		// out
		$this->out->CellCssStyle = "white-space: nowrap;";

		// required
		$this->required->CellCssStyle = "white-space: nowrap;";

		// blocked
		$this->blocked->CellCssStyle = "white-space: nowrap;";

		// ordered
		$this->ordered->CellCssStyle = "white-space: nowrap;";

		// status
		// publish
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `id` > 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 200000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_n
			$this->product_n->ViewValue = $this->product_n->CurrentValue;
			$this->product_n->ViewCustomAttributes = "";

			// product_type
			$this->product_type->ViewValue = $this->product_type->CurrentValue;
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` = 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// last_price
			$this->last_price->ViewValue = $this->last_price->CurrentValue;
			$this->last_price->ViewCustomAttributes = "";

			// v_01
			$curVal = strval($this->v_01->CurrentValue);
			if ($curVal <> "") {
				$this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
				if ($this->v_01->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_01->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_01->ViewValue->add($this->v_01->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_01->ViewValue = $this->v_01->CurrentValue;
					}
				}
			} else {
				$this->v_01->ViewValue = NULL;
			}
			$this->v_01->ViewCustomAttributes = "";

			// v_02
			$curVal = strval($this->v_02->CurrentValue);
			if ($curVal <> "") {
				$this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
				if ($this->v_02->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_02->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_02->ViewValue->add($this->v_02->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_02->ViewValue = $this->v_02->CurrentValue;
					}
				}
			} else {
				$this->v_02->ViewValue = NULL;
			}
			$this->v_02->ViewCustomAttributes = "";

			// v_03
			$curVal = strval($this->v_03->CurrentValue);
			if ($curVal <> "") {
				$this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
				if ($this->v_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_03->ViewValue->add($this->v_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_03->ViewValue = $this->v_03->CurrentValue;
					}
				}
			} else {
				$this->v_03->ViewValue = NULL;
			}
			$this->v_03->ViewCustomAttributes = "";

			// v_04
			$curVal = strval($this->v_04->CurrentValue);
			if ($curVal <> "") {
				$this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
				if ($this->v_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_04->ViewValue->add($this->v_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_04->ViewValue = $this->v_04->CurrentValue;
					}
				}
			} else {
				$this->v_04->ViewValue = NULL;
			}
			$this->v_04->ViewCustomAttributes = "";

			// v_05
			$curVal = strval($this->v_05->CurrentValue);
			if ($curVal <> "") {
				$this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
				if ($this->v_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_05->ViewValue->add($this->v_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_05->ViewValue = $this->v_05->CurrentValue;
					}
				}
			} else {
				$this->v_05->ViewValue = NULL;
			}
			$this->v_05->ViewCustomAttributes = "";

			// v_06
			$curVal = strval($this->v_06->CurrentValue);
			if ($curVal <> "") {
				$this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
				if ($this->v_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 106 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_06->ViewValue->add($this->v_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_06->ViewValue = $this->v_06->CurrentValue;
					}
				}
			} else {
				$this->v_06->ViewValue = NULL;
			}
			$this->v_06->ViewCustomAttributes = "";

			// v_07
			$curVal = strval($this->v_07->CurrentValue);
			if ($curVal <> "") {
				$this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
				if ($this->v_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 107 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_07->ViewValue->add($this->v_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_07->ViewValue = $this->v_07->CurrentValue;
					}
				}
			} else {
				$this->v_07->ViewValue = NULL;
			}
			$this->v_07->ViewCustomAttributes = "";

			// v_08
			$curVal = strval($this->v_08->CurrentValue);
			if ($curVal <> "") {
				$this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
				if ($this->v_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 108 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_08->ViewValue->add($this->v_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_08->ViewValue = $this->v_08->CurrentValue;
					}
				}
			} else {
				$this->v_08->ViewValue = NULL;
			}
			$this->v_08->ViewCustomAttributes = "";

			// v_09
			$curVal = strval($this->v_09->CurrentValue);
			if ($curVal <> "") {
				$this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
				if ($this->v_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 109 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_09->ViewValue->add($this->v_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_09->ViewValue = $this->v_09->CurrentValue;
					}
				}
			} else {
				$this->v_09->ViewValue = NULL;
			}
			$this->v_09->ViewCustomAttributes = "";

			// v_10
			$curVal = strval($this->v_10->CurrentValue);
			if ($curVal <> "") {
				$this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
				if ($this->v_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 110 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_10->ViewValue->add($this->v_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_10->ViewValue = $this->v_10->CurrentValue;
					}
				}
			} else {
				$this->v_10->ViewValue = NULL;
			}
			$this->v_10->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->shape->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->shape->ViewValue->add($this->shape->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// b_01
			$this->b_01->ViewValue = $this->b_01->CurrentValue;
			$this->b_01->ViewCustomAttributes = "";

			// b_02
			$this->b_02->ViewValue = $this->b_02->CurrentValue;
			$this->b_02->ViewCustomAttributes = "";

			// b_03
			$curVal = strval($this->b_03->CurrentValue);
			if ($curVal <> "") {
				$this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
				if ($this->b_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 203 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_03->ViewValue = $this->b_03->CurrentValue;
					}
				}
			} else {
				$this->b_03->ViewValue = NULL;
			}
			$this->b_03->ViewCustomAttributes = "";

			// b_04
			$curVal = strval($this->b_04->CurrentValue);
			if ($curVal <> "") {
				$this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
				if ($this->b_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 204 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_04->ViewValue = $this->b_04->CurrentValue;
					}
				}
			} else {
				$this->b_04->ViewValue = NULL;
			}
			$this->b_04->ViewCustomAttributes = "";

			// b_05
			$curVal = strval($this->b_05->CurrentValue);
			if ($curVal <> "") {
				$this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
				if ($this->b_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 205 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_05->ViewValue = $this->b_05->CurrentValue;
					}
				}
			} else {
				$this->b_05->ViewValue = NULL;
			}
			$this->b_05->ViewCustomAttributes = "";

			// b_06
			$curVal = strval($this->b_06->CurrentValue);
			if ($curVal <> "") {
				$this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
				if ($this->b_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 206 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_06->ViewValue = $this->b_06->CurrentValue;
					}
				}
			} else {
				$this->b_06->ViewValue = NULL;
			}
			$this->b_06->ViewCustomAttributes = "";

			// b_07
			$curVal = strval($this->b_07->CurrentValue);
			if ($curVal <> "") {
				$this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
				if ($this->b_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 207 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_07->ViewValue = $this->b_07->CurrentValue;
					}
				}
			} else {
				$this->b_07->ViewValue = NULL;
			}
			$this->b_07->ViewCustomAttributes = "";

			// b_08
			$curVal = strval($this->b_08->CurrentValue);
			if ($curVal <> "") {
				$this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
				if ($this->b_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 208 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_08->ViewValue = $this->b_08->CurrentValue;
					}
				}
			} else {
				$this->b_08->ViewValue = NULL;
			}
			$this->b_08->ViewCustomAttributes = "";

			// b_09
			$curVal = strval($this->b_09->CurrentValue);
			if ($curVal <> "") {
				$this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
				if ($this->b_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 209 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_09->ViewValue = $this->b_09->CurrentValue;
					}
				}
			} else {
				$this->b_09->ViewValue = NULL;
			}
			$this->b_09->ViewCustomAttributes = "";

			// b_10
			$curVal = strval($this->b_10->CurrentValue);
			if ($curVal <> "") {
				$this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
				if ($this->b_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 210 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_10->ViewValue = $this->b_10->CurrentValue;
					}
				}
			} else {
				$this->b_10->ViewValue = NULL;
			}
			$this->b_10->ViewCustomAttributes = "";

			// b_11
			$this->b_11->ViewValue = $this->b_11->CurrentValue;
			$this->b_11->ViewCustomAttributes = "";

			// b_12
			$this->b_12->ViewValue = $this->b_12->CurrentValue;
			$this->b_12->ViewCustomAttributes = "";

			// b_13
			$this->b_13->ViewValue = $this->b_13->CurrentValue;
			$this->b_13->ViewCustomAttributes = "";

			// b_14
			$this->b_14->ViewValue = $this->b_14->CurrentValue;
			$this->b_14->ViewCustomAttributes = "";

			// b_15
			$this->b_15->ViewCustomAttributes = "";

			// t_01
			$this->t_01->ViewValue = $this->t_01->CurrentValue;
			$this->t_01->ViewCustomAttributes = "";

			// t_02
			$this->t_02->ViewValue = $this->t_02->CurrentValue;
			$this->t_02->ViewCustomAttributes = "";

			// t_03
			$curVal = strval($this->t_03->CurrentValue);
			if ($curVal <> "") {
				$this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
				if ($this->t_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 303 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_03->ViewValue = $this->t_03->CurrentValue;
					}
				}
			} else {
				$this->t_03->ViewValue = NULL;
			}
			$this->t_03->ViewCustomAttributes = "";

			// t_04
			$curVal = strval($this->t_04->CurrentValue);
			if ($curVal <> "") {
				$this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
				if ($this->t_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 304 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_04->ViewValue = $this->t_04->CurrentValue;
					}
				}
			} else {
				$this->t_04->ViewValue = NULL;
			}
			$this->t_04->ViewCustomAttributes = "";

			// t_05
			$curVal = strval($this->t_05->CurrentValue);
			if ($curVal <> "") {
				$this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
				if ($this->t_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 305 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_05->ViewValue = $this->t_05->CurrentValue;
					}
				}
			} else {
				$this->t_05->ViewValue = NULL;
			}
			$this->t_05->ViewCustomAttributes = "";

			// t_06
			$curVal = strval($this->t_06->CurrentValue);
			if ($curVal <> "") {
				$this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
				if ($this->t_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 306 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_06->ViewValue = $this->t_06->CurrentValue;
					}
				}
			} else {
				$this->t_06->ViewValue = NULL;
			}
			$this->t_06->ViewCustomAttributes = "";

			// t_07
			$curVal = strval($this->t_07->CurrentValue);
			if ($curVal <> "") {
				$this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
				if ($this->t_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 307 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_07->ViewValue = $this->t_07->CurrentValue;
					}
				}
			} else {
				$this->t_07->ViewValue = NULL;
			}
			$this->t_07->ViewCustomAttributes = "";

			// t_08
			$curVal = strval($this->t_08->CurrentValue);
			if ($curVal <> "") {
				$this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
				if ($this->t_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 308 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_08->ViewValue = $this->t_08->CurrentValue;
					}
				}
			} else {
				$this->t_08->ViewValue = NULL;
			}
			$this->t_08->ViewCustomAttributes = "";

			// t_09
			$curVal = strval($this->t_09->CurrentValue);
			if ($curVal <> "") {
				$this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
				if ($this->t_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 309 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_09->ViewValue = $this->t_09->CurrentValue;
					}
				}
			} else {
				$this->t_09->ViewValue = NULL;
			}
			$this->t_09->ViewCustomAttributes = "";

			// t_10
			$curVal = strval($this->t_10->CurrentValue);
			if ($curVal <> "") {
				$this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
				if ($this->t_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 310 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_10->ViewValue = $this->t_10->CurrentValue;
					}
				}
			} else {
				$this->t_10->ViewValue = NULL;
			}
			$this->t_10->ViewCustomAttributes = "";

			// t_11
			$this->t_11->ViewValue = $this->t_11->CurrentValue;
			$curVal = strval($this->t_11->CurrentValue);
			if ($curVal <> "") {
				$this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
				if ($this->t_11->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_11->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_11->ViewValue = $this->t_11->CurrentValue;
					}
				}
			} else {
				$this->t_11->ViewValue = NULL;
			}
			$this->t_11->ViewCustomAttributes = "";

			// t_12
			$this->t_12->ViewValue = $this->t_12->CurrentValue;
			$curVal = strval($this->t_12->CurrentValue);
			if ($curVal <> "") {
				$this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
				if ($this->t_12->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_12->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_12->ViewValue = $this->t_12->CurrentValue;
					}
				}
			} else {
				$this->t_12->ViewValue = NULL;
			}
			$this->t_12->ViewCustomAttributes = "";

			// t_13
			$this->t_13->ViewValue = $this->t_13->CurrentValue;
			$this->t_13->ViewCustomAttributes = "";

			// t_14
			$this->t_14->ViewValue = $this->t_14->CurrentValue;
			$this->t_14->ViewCustomAttributes = "";

			// t_15
			$this->t_15->ViewValue = $this->t_15->CurrentValue;
			$this->t_15->ViewCustomAttributes = "";

			// d_head_01
			$this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;
			$this->d_head_01->ViewCustomAttributes = "";

			// d_description_01
			$this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;
			$this->d_description_01->ViewCustomAttributes = "";

			// d_head_02
			$this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;
			$this->d_head_02->ViewCustomAttributes = "";

			// d_description_02
			$this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;
			$this->d_description_02->ViewCustomAttributes = "";

			// main_image
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->ImageWidth = 0;
				$this->main_image->ImageHeight = 40;
				$this->main_image->ImageAlt = $this->main_image->alt();
				$this->main_image->ViewValue = $this->main_image->Upload->DbValue;
			} else {
				$this->main_image->ViewValue = "";
			}
			$this->main_image->ViewCustomAttributes = "";

			// top_view
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->ImageWidth = 0;
				$this->top_view->ImageHeight = 40;
				$this->top_view->ImageAlt = $this->top_view->alt();
				$this->top_view->ViewValue = $this->top_view->Upload->DbValue;
			} else {
				$this->top_view->ViewValue = "";
			}
			$this->top_view->ViewCustomAttributes = "";

			// front_view
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->ImageWidth = 0;
				$this->front_view->ImageHeight = 40;
				$this->front_view->ImageAlt = $this->front_view->alt();
				$this->front_view->ViewValue = $this->front_view->Upload->DbValue;
			} else {
				$this->front_view->ViewValue = "";
			}
			$this->front_view->ViewCustomAttributes = "";

			// corner_view
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->ImageWidth = 0;
				$this->corner_view->ImageHeight = 40;
				$this->corner_view->ImageAlt = $this->corner_view->alt();
				$this->corner_view->ViewValue = $this->corner_view->Upload->DbValue;
			} else {
				$this->corner_view->ViewValue = "";
			}
			$this->corner_view->ViewCustomAttributes = "";

			// back_view
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->ImageWidth = 0;
				$this->back_view->ImageHeight = 40;
				$this->back_view->ImageAlt = $this->back_view->alt();
				$this->back_view->ViewValue = $this->back_view->Upload->DbValue;
			} else {
				$this->back_view->ViewValue = "";
			}
			$this->back_view->ViewCustomAttributes = "";

			// color_options
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->ImageWidth = 0;
				$this->color_options->ImageHeight = 40;
				$this->color_options->ImageAlt = $this->color_options->alt();
				$this->color_options->ViewValue = $this->color_options->Upload->DbValue;
			} else {
				$this->color_options->ViewValue = "";
			}
			$this->color_options->ViewCustomAttributes = "";

			// other_options
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->ImageWidth = 0;
				$this->other_options->ImageHeight = 40;
				$this->other_options->ImageAlt = $this->other_options->alt();
				$this->other_options->ViewValue = $this->other_options->Upload->DbValue;
			} else {
				$this->other_options->ViewValue = "";
			}
			$this->other_options->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// video_url
			$this->video_url->ViewValue = $this->video_url->CurrentValue;
			$this->video_url->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// hsn
			$curVal = strval($this->hsn->CurrentValue);
			if ($curVal <> "") {
				$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
				if ($this->hsn->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->hsn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->hsn->ViewValue = $this->hsn->CurrentValue;
					}
				}
			} else {
				$this->hsn->ViewValue = NULL;
			}
			$this->hsn->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// publish
			if (strval($this->publish->CurrentValue) <> "") {
				$this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
			} else {
				$this->publish->ViewValue = NULL;
			}
			$this->publish->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();
		if ($this->AuditTrailOnDelete)
			$this->writeAuditTrailDummy($Language->phrase("BatchDeleteBegin")); // Batch delete begin

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
			if ($this->AuditTrailOnDelete)
				$this->writeAuditTrailDummy($Language->phrase("BatchDeleteSuccess")); // Batch delete success
		} else {
			$conn->rollbackTrans(); // Rollback changes
			if ($this->AuditTrailOnDelete)
				$this->writeAuditTrailDummy($Language->phrase("BatchDeleteRollback")); // Batch delete rollback
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ref_multilist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `id` > 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 200000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1 and `id` = 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_01":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_02":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 106 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 107 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 108 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 109 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 110 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 203 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 204 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 205 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 206 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 207 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 208 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 209 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 210 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 303 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 304 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 305 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 306 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 307 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 308 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 309 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 310 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_11":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_12":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_hsn":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_product_type":
							break;
						case "x_v_01":
							break;
						case "x_v_02":
							break;
						case "x_v_03":
							break;
						case "x_v_04":
							break;
						case "x_v_05":
							break;
						case "x_v_06":
							break;
						case "x_v_07":
							break;
						case "x_v_08":
							break;
						case "x_v_09":
							break;
						case "x_v_10":
							break;
						case "x_shape":
							break;
						case "x_b_03":
							break;
						case "x_b_04":
							break;
						case "x_b_05":
							break;
						case "x_b_06":
							break;
						case "x_b_07":
							break;
						case "x_b_08":
							break;
						case "x_b_09":
							break;
						case "x_b_10":
							break;
						case "x_t_03":
							break;
						case "x_t_04":
							break;
						case "x_t_05":
							break;
						case "x_t_06":
							break;
						case "x_t_07":
							break;
						case "x_t_08":
							break;
						case "x_t_09":
							break;
						case "x_t_10":
							break;
						case "x_t_11":
							break;
						case "x_t_12":
							break;
						case "x_currency":
							break;
						case "x_hsn":
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>