<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class ref_multi_list extends ref_multi
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'ref_multi';

	// Page object name
	public $PageObjName = "ref_multi_list";

	// Grid form hidden field names
	public $FormName = "fref_multilist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (ref_multi)
		if (!isset($GLOBALS["ref_multi"]) || get_class($GLOBALS["ref_multi"]) == PROJECT_NAMESPACE . "ref_multi") {
			$GLOBALS["ref_multi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ref_multi"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "ref_multiadd.php?" . TABLE_SHOW_DETAIL . "=";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "ref_multidelete.php";
		$this->MultiUpdateUrl = "ref_multiupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref_multi');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fref_multilistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $ref_multi;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($ref_multi);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->oid->Visible = FALSE;
		$this->_barcode->Visible = FALSE;
		$this->company_id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->Visible = FALSE;
		$this->product_n->Visible = FALSE;
		$this->product_type->setVisibility();
		$this->product_code->Visible = FALSE;
		$this->gcode->Visible = FALSE;
		$this->code->Visible = FALSE;
		$this->product_id->Visible = FALSE;
		$this->print_name->Visible = FALSE;
		$this->batch_no->Visible = FALSE;
		$this->last_price->Visible = FALSE;
		$this->v_01->Visible = FALSE;
		$this->v_02->Visible = FALSE;
		$this->v_03->Visible = FALSE;
		$this->v_04->Visible = FALSE;
		$this->v_05->Visible = FALSE;
		$this->v_06->Visible = FALSE;
		$this->v_07->Visible = FALSE;
		$this->v_08->Visible = FALSE;
		$this->v_09->Visible = FALSE;
		$this->v_10->Visible = FALSE;
		$this->cbm->Visible = FALSE;
		$this->sqm->Visible = FALSE;
		$this->shape->Visible = FALSE;
		$this->b_01->Visible = FALSE;
		$this->b_02->Visible = FALSE;
		$this->b_03->Visible = FALSE;
		$this->b_04->Visible = FALSE;
		$this->b_05->Visible = FALSE;
		$this->b_06->Visible = FALSE;
		$this->b_07->Visible = FALSE;
		$this->b_08->Visible = FALSE;
		$this->b_09->Visible = FALSE;
		$this->b_10->Visible = FALSE;
		$this->b_11->Visible = FALSE;
		$this->b_12->Visible = FALSE;
		$this->b_13->Visible = FALSE;
		$this->b_14->Visible = FALSE;
		$this->b_15->Visible = FALSE;
		$this->t_01->Visible = FALSE;
		$this->t_02->Visible = FALSE;
		$this->t_03->Visible = FALSE;
		$this->t_04->Visible = FALSE;
		$this->t_05->Visible = FALSE;
		$this->t_06->Visible = FALSE;
		$this->t_07->Visible = FALSE;
		$this->t_08->Visible = FALSE;
		$this->t_09->Visible = FALSE;
		$this->t_10->Visible = FALSE;
		$this->t_11->Visible = FALSE;
		$this->t_12->Visible = FALSE;
		$this->t_13->Visible = FALSE;
		$this->t_14->Visible = FALSE;
		$this->t_15->Visible = FALSE;
		$this->d_head_01->Visible = FALSE;
		$this->d_description_01->Visible = FALSE;
		$this->d_head_02->Visible = FALSE;
		$this->d_description_02->Visible = FALSE;
		$this->main_image->Visible = FALSE;
		$this->top_view->Visible = FALSE;
		$this->front_view->Visible = FALSE;
		$this->corner_view->Visible = FALSE;
		$this->back_view->Visible = FALSE;
		$this->color_options->Visible = FALSE;
		$this->other_options->Visible = FALSE;
		$this->image->Visible = FALSE;
		$this->video_url->Visible = FALSE;
		$this->currency->Visible = FALSE;
		$this->hsn->Visible = FALSE;
		$this->minimum_stock->Visible = FALSE;
		$this->in->Visible = FALSE;
		$this->out->Visible = FALSE;
		$this->required->Visible = FALSE;
		$this->blocked->Visible = FALSE;
		$this->ordered->Visible = FALSE;
		$this->status->setVisibility();
		$this->publish->Visible = FALSE;
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->v_01);
		$this->setupLookupOptions($this->v_02);
		$this->setupLookupOptions($this->v_03);
		$this->setupLookupOptions($this->v_04);
		$this->setupLookupOptions($this->v_05);
		$this->setupLookupOptions($this->v_06);
		$this->setupLookupOptions($this->v_07);
		$this->setupLookupOptions($this->v_08);
		$this->setupLookupOptions($this->v_09);
		$this->setupLookupOptions($this->v_10);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->b_03);
		$this->setupLookupOptions($this->b_04);
		$this->setupLookupOptions($this->b_05);
		$this->setupLookupOptions($this->b_06);
		$this->setupLookupOptions($this->b_07);
		$this->setupLookupOptions($this->b_08);
		$this->setupLookupOptions($this->b_09);
		$this->setupLookupOptions($this->b_10);
		$this->setupLookupOptions($this->t_03);
		$this->setupLookupOptions($this->t_04);
		$this->setupLookupOptions($this->t_05);
		$this->setupLookupOptions($this->t_06);
		$this->setupLookupOptions($this->t_07);
		$this->setupLookupOptions($this->t_08);
		$this->setupLookupOptions($this->t_09);
		$this->setupLookupOptions($this->t_10);
		$this->setupLookupOptions($this->t_11);
		$this->setupLookupOptions($this->t_12);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->hsn);
		$this->setupLookupOptions($this->operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}

			// Audit trail on search
			if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
				$searchParm = ServerVar("QUERY_STRING");
				$searchSql = $this->getSessionWhere();
				$this->writeAuditTrailOnSearch($searchParm, $searchSql);
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fref_multilistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
		$filterList = Concat($filterList, $this->grp->AdvancedSearch->toJson(), ","); // Field grp
		$filterList = Concat($filterList, $this->s_grp->AdvancedSearch->toJson(), ","); // Field s_grp
		$filterList = Concat($filterList, $this->product->AdvancedSearch->toJson(), ","); // Field product
		$filterList = Concat($filterList, $this->product_n->AdvancedSearch->toJson(), ","); // Field product_n
		$filterList = Concat($filterList, $this->product_type->AdvancedSearch->toJson(), ","); // Field product_type
		$filterList = Concat($filterList, $this->last_price->AdvancedSearch->toJson(), ","); // Field last_price
		$filterList = Concat($filterList, $this->v_01->AdvancedSearch->toJson(), ","); // Field v_01
		$filterList = Concat($filterList, $this->v_02->AdvancedSearch->toJson(), ","); // Field v_02
		$filterList = Concat($filterList, $this->v_03->AdvancedSearch->toJson(), ","); // Field v_03
		$filterList = Concat($filterList, $this->v_04->AdvancedSearch->toJson(), ","); // Field v_04
		$filterList = Concat($filterList, $this->v_05->AdvancedSearch->toJson(), ","); // Field v_05
		$filterList = Concat($filterList, $this->v_06->AdvancedSearch->toJson(), ","); // Field v_06
		$filterList = Concat($filterList, $this->v_07->AdvancedSearch->toJson(), ","); // Field v_07
		$filterList = Concat($filterList, $this->v_08->AdvancedSearch->toJson(), ","); // Field v_08
		$filterList = Concat($filterList, $this->v_09->AdvancedSearch->toJson(), ","); // Field v_09
		$filterList = Concat($filterList, $this->v_10->AdvancedSearch->toJson(), ","); // Field v_10
		$filterList = Concat($filterList, $this->cbm->AdvancedSearch->toJson(), ","); // Field cbm
		$filterList = Concat($filterList, $this->sqm->AdvancedSearch->toJson(), ","); // Field sqm
		$filterList = Concat($filterList, $this->shape->AdvancedSearch->toJson(), ","); // Field shape
		$filterList = Concat($filterList, $this->b_01->AdvancedSearch->toJson(), ","); // Field b_01
		$filterList = Concat($filterList, $this->b_02->AdvancedSearch->toJson(), ","); // Field b_02
		$filterList = Concat($filterList, $this->b_03->AdvancedSearch->toJson(), ","); // Field b_03
		$filterList = Concat($filterList, $this->b_04->AdvancedSearch->toJson(), ","); // Field b_04
		$filterList = Concat($filterList, $this->b_05->AdvancedSearch->toJson(), ","); // Field b_05
		$filterList = Concat($filterList, $this->b_06->AdvancedSearch->toJson(), ","); // Field b_06
		$filterList = Concat($filterList, $this->b_07->AdvancedSearch->toJson(), ","); // Field b_07
		$filterList = Concat($filterList, $this->b_08->AdvancedSearch->toJson(), ","); // Field b_08
		$filterList = Concat($filterList, $this->b_09->AdvancedSearch->toJson(), ","); // Field b_09
		$filterList = Concat($filterList, $this->b_10->AdvancedSearch->toJson(), ","); // Field b_10
		$filterList = Concat($filterList, $this->b_11->AdvancedSearch->toJson(), ","); // Field b_11
		$filterList = Concat($filterList, $this->b_12->AdvancedSearch->toJson(), ","); // Field b_12
		$filterList = Concat($filterList, $this->b_13->AdvancedSearch->toJson(), ","); // Field b_13
		$filterList = Concat($filterList, $this->b_14->AdvancedSearch->toJson(), ","); // Field b_14
		$filterList = Concat($filterList, $this->b_15->AdvancedSearch->toJson(), ","); // Field b_15
		$filterList = Concat($filterList, $this->t_01->AdvancedSearch->toJson(), ","); // Field t_01
		$filterList = Concat($filterList, $this->t_02->AdvancedSearch->toJson(), ","); // Field t_02
		$filterList = Concat($filterList, $this->t_03->AdvancedSearch->toJson(), ","); // Field t_03
		$filterList = Concat($filterList, $this->t_04->AdvancedSearch->toJson(), ","); // Field t_04
		$filterList = Concat($filterList, $this->t_05->AdvancedSearch->toJson(), ","); // Field t_05
		$filterList = Concat($filterList, $this->t_06->AdvancedSearch->toJson(), ","); // Field t_06
		$filterList = Concat($filterList, $this->t_07->AdvancedSearch->toJson(), ","); // Field t_07
		$filterList = Concat($filterList, $this->t_08->AdvancedSearch->toJson(), ","); // Field t_08
		$filterList = Concat($filterList, $this->t_09->AdvancedSearch->toJson(), ","); // Field t_09
		$filterList = Concat($filterList, $this->t_10->AdvancedSearch->toJson(), ","); // Field t_10
		$filterList = Concat($filterList, $this->t_11->AdvancedSearch->toJson(), ","); // Field t_11
		$filterList = Concat($filterList, $this->t_12->AdvancedSearch->toJson(), ","); // Field t_12
		$filterList = Concat($filterList, $this->t_13->AdvancedSearch->toJson(), ","); // Field t_13
		$filterList = Concat($filterList, $this->t_14->AdvancedSearch->toJson(), ","); // Field t_14
		$filterList = Concat($filterList, $this->t_15->AdvancedSearch->toJson(), ","); // Field t_15
		$filterList = Concat($filterList, $this->d_head_01->AdvancedSearch->toJson(), ","); // Field d_head_01
		$filterList = Concat($filterList, $this->d_description_01->AdvancedSearch->toJson(), ","); // Field d_description_01
		$filterList = Concat($filterList, $this->d_head_02->AdvancedSearch->toJson(), ","); // Field d_head_02
		$filterList = Concat($filterList, $this->d_description_02->AdvancedSearch->toJson(), ","); // Field d_description_02
		$filterList = Concat($filterList, $this->main_image->AdvancedSearch->toJson(), ","); // Field main_image
		$filterList = Concat($filterList, $this->top_view->AdvancedSearch->toJson(), ","); // Field top_view
		$filterList = Concat($filterList, $this->front_view->AdvancedSearch->toJson(), ","); // Field front_view
		$filterList = Concat($filterList, $this->corner_view->AdvancedSearch->toJson(), ","); // Field corner_view
		$filterList = Concat($filterList, $this->back_view->AdvancedSearch->toJson(), ","); // Field back_view
		$filterList = Concat($filterList, $this->color_options->AdvancedSearch->toJson(), ","); // Field color_options
		$filterList = Concat($filterList, $this->other_options->AdvancedSearch->toJson(), ","); // Field other_options
		$filterList = Concat($filterList, $this->image->AdvancedSearch->toJson(), ","); // Field image
		$filterList = Concat($filterList, $this->video_url->AdvancedSearch->toJson(), ","); // Field video_url
		$filterList = Concat($filterList, $this->currency->AdvancedSearch->toJson(), ","); // Field currency
		$filterList = Concat($filterList, $this->hsn->AdvancedSearch->toJson(), ","); // Field hsn
		$filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fref_multilistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field company_id
		$this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
		$this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
		$this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
		$this->company_id->AdvancedSearch->save();

		// Field grp
		$this->grp->AdvancedSearch->SearchValue = @$filter["x_grp"];
		$this->grp->AdvancedSearch->SearchOperator = @$filter["z_grp"];
		$this->grp->AdvancedSearch->SearchCondition = @$filter["v_grp"];
		$this->grp->AdvancedSearch->SearchValue2 = @$filter["y_grp"];
		$this->grp->AdvancedSearch->SearchOperator2 = @$filter["w_grp"];
		$this->grp->AdvancedSearch->save();

		// Field s_grp
		$this->s_grp->AdvancedSearch->SearchValue = @$filter["x_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator = @$filter["z_s_grp"];
		$this->s_grp->AdvancedSearch->SearchCondition = @$filter["v_s_grp"];
		$this->s_grp->AdvancedSearch->SearchValue2 = @$filter["y_s_grp"];
		$this->s_grp->AdvancedSearch->SearchOperator2 = @$filter["w_s_grp"];
		$this->s_grp->AdvancedSearch->save();

		// Field product
		$this->product->AdvancedSearch->SearchValue = @$filter["x_product"];
		$this->product->AdvancedSearch->SearchOperator = @$filter["z_product"];
		$this->product->AdvancedSearch->SearchCondition = @$filter["v_product"];
		$this->product->AdvancedSearch->SearchValue2 = @$filter["y_product"];
		$this->product->AdvancedSearch->SearchOperator2 = @$filter["w_product"];
		$this->product->AdvancedSearch->save();

		// Field product_n
		$this->product_n->AdvancedSearch->SearchValue = @$filter["x_product_n"];
		$this->product_n->AdvancedSearch->SearchOperator = @$filter["z_product_n"];
		$this->product_n->AdvancedSearch->SearchCondition = @$filter["v_product_n"];
		$this->product_n->AdvancedSearch->SearchValue2 = @$filter["y_product_n"];
		$this->product_n->AdvancedSearch->SearchOperator2 = @$filter["w_product_n"];
		$this->product_n->AdvancedSearch->save();

		// Field product_type
		$this->product_type->AdvancedSearch->SearchValue = @$filter["x_product_type"];
		$this->product_type->AdvancedSearch->SearchOperator = @$filter["z_product_type"];
		$this->product_type->AdvancedSearch->SearchCondition = @$filter["v_product_type"];
		$this->product_type->AdvancedSearch->SearchValue2 = @$filter["y_product_type"];
		$this->product_type->AdvancedSearch->SearchOperator2 = @$filter["w_product_type"];
		$this->product_type->AdvancedSearch->save();

		// Field last_price
		$this->last_price->AdvancedSearch->SearchValue = @$filter["x_last_price"];
		$this->last_price->AdvancedSearch->SearchOperator = @$filter["z_last_price"];
		$this->last_price->AdvancedSearch->SearchCondition = @$filter["v_last_price"];
		$this->last_price->AdvancedSearch->SearchValue2 = @$filter["y_last_price"];
		$this->last_price->AdvancedSearch->SearchOperator2 = @$filter["w_last_price"];
		$this->last_price->AdvancedSearch->save();

		// Field v_01
		$this->v_01->AdvancedSearch->SearchValue = @$filter["x_v_01"];
		$this->v_01->AdvancedSearch->SearchOperator = @$filter["z_v_01"];
		$this->v_01->AdvancedSearch->SearchCondition = @$filter["v_v_01"];
		$this->v_01->AdvancedSearch->SearchValue2 = @$filter["y_v_01"];
		$this->v_01->AdvancedSearch->SearchOperator2 = @$filter["w_v_01"];
		$this->v_01->AdvancedSearch->save();

		// Field v_02
		$this->v_02->AdvancedSearch->SearchValue = @$filter["x_v_02"];
		$this->v_02->AdvancedSearch->SearchOperator = @$filter["z_v_02"];
		$this->v_02->AdvancedSearch->SearchCondition = @$filter["v_v_02"];
		$this->v_02->AdvancedSearch->SearchValue2 = @$filter["y_v_02"];
		$this->v_02->AdvancedSearch->SearchOperator2 = @$filter["w_v_02"];
		$this->v_02->AdvancedSearch->save();

		// Field v_03
		$this->v_03->AdvancedSearch->SearchValue = @$filter["x_v_03"];
		$this->v_03->AdvancedSearch->SearchOperator = @$filter["z_v_03"];
		$this->v_03->AdvancedSearch->SearchCondition = @$filter["v_v_03"];
		$this->v_03->AdvancedSearch->SearchValue2 = @$filter["y_v_03"];
		$this->v_03->AdvancedSearch->SearchOperator2 = @$filter["w_v_03"];
		$this->v_03->AdvancedSearch->save();

		// Field v_04
		$this->v_04->AdvancedSearch->SearchValue = @$filter["x_v_04"];
		$this->v_04->AdvancedSearch->SearchOperator = @$filter["z_v_04"];
		$this->v_04->AdvancedSearch->SearchCondition = @$filter["v_v_04"];
		$this->v_04->AdvancedSearch->SearchValue2 = @$filter["y_v_04"];
		$this->v_04->AdvancedSearch->SearchOperator2 = @$filter["w_v_04"];
		$this->v_04->AdvancedSearch->save();

		// Field v_05
		$this->v_05->AdvancedSearch->SearchValue = @$filter["x_v_05"];
		$this->v_05->AdvancedSearch->SearchOperator = @$filter["z_v_05"];
		$this->v_05->AdvancedSearch->SearchCondition = @$filter["v_v_05"];
		$this->v_05->AdvancedSearch->SearchValue2 = @$filter["y_v_05"];
		$this->v_05->AdvancedSearch->SearchOperator2 = @$filter["w_v_05"];
		$this->v_05->AdvancedSearch->save();

		// Field v_06
		$this->v_06->AdvancedSearch->SearchValue = @$filter["x_v_06"];
		$this->v_06->AdvancedSearch->SearchOperator = @$filter["z_v_06"];
		$this->v_06->AdvancedSearch->SearchCondition = @$filter["v_v_06"];
		$this->v_06->AdvancedSearch->SearchValue2 = @$filter["y_v_06"];
		$this->v_06->AdvancedSearch->SearchOperator2 = @$filter["w_v_06"];
		$this->v_06->AdvancedSearch->save();

		// Field v_07
		$this->v_07->AdvancedSearch->SearchValue = @$filter["x_v_07"];
		$this->v_07->AdvancedSearch->SearchOperator = @$filter["z_v_07"];
		$this->v_07->AdvancedSearch->SearchCondition = @$filter["v_v_07"];
		$this->v_07->AdvancedSearch->SearchValue2 = @$filter["y_v_07"];
		$this->v_07->AdvancedSearch->SearchOperator2 = @$filter["w_v_07"];
		$this->v_07->AdvancedSearch->save();

		// Field v_08
		$this->v_08->AdvancedSearch->SearchValue = @$filter["x_v_08"];
		$this->v_08->AdvancedSearch->SearchOperator = @$filter["z_v_08"];
		$this->v_08->AdvancedSearch->SearchCondition = @$filter["v_v_08"];
		$this->v_08->AdvancedSearch->SearchValue2 = @$filter["y_v_08"];
		$this->v_08->AdvancedSearch->SearchOperator2 = @$filter["w_v_08"];
		$this->v_08->AdvancedSearch->save();

		// Field v_09
		$this->v_09->AdvancedSearch->SearchValue = @$filter["x_v_09"];
		$this->v_09->AdvancedSearch->SearchOperator = @$filter["z_v_09"];
		$this->v_09->AdvancedSearch->SearchCondition = @$filter["v_v_09"];
		$this->v_09->AdvancedSearch->SearchValue2 = @$filter["y_v_09"];
		$this->v_09->AdvancedSearch->SearchOperator2 = @$filter["w_v_09"];
		$this->v_09->AdvancedSearch->save();

		// Field v_10
		$this->v_10->AdvancedSearch->SearchValue = @$filter["x_v_10"];
		$this->v_10->AdvancedSearch->SearchOperator = @$filter["z_v_10"];
		$this->v_10->AdvancedSearch->SearchCondition = @$filter["v_v_10"];
		$this->v_10->AdvancedSearch->SearchValue2 = @$filter["y_v_10"];
		$this->v_10->AdvancedSearch->SearchOperator2 = @$filter["w_v_10"];
		$this->v_10->AdvancedSearch->save();

		// Field cbm
		$this->cbm->AdvancedSearch->SearchValue = @$filter["x_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator = @$filter["z_cbm"];
		$this->cbm->AdvancedSearch->SearchCondition = @$filter["v_cbm"];
		$this->cbm->AdvancedSearch->SearchValue2 = @$filter["y_cbm"];
		$this->cbm->AdvancedSearch->SearchOperator2 = @$filter["w_cbm"];
		$this->cbm->AdvancedSearch->save();

		// Field sqm
		$this->sqm->AdvancedSearch->SearchValue = @$filter["x_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator = @$filter["z_sqm"];
		$this->sqm->AdvancedSearch->SearchCondition = @$filter["v_sqm"];
		$this->sqm->AdvancedSearch->SearchValue2 = @$filter["y_sqm"];
		$this->sqm->AdvancedSearch->SearchOperator2 = @$filter["w_sqm"];
		$this->sqm->AdvancedSearch->save();

		// Field shape
		$this->shape->AdvancedSearch->SearchValue = @$filter["x_shape"];
		$this->shape->AdvancedSearch->SearchOperator = @$filter["z_shape"];
		$this->shape->AdvancedSearch->SearchCondition = @$filter["v_shape"];
		$this->shape->AdvancedSearch->SearchValue2 = @$filter["y_shape"];
		$this->shape->AdvancedSearch->SearchOperator2 = @$filter["w_shape"];
		$this->shape->AdvancedSearch->save();

		// Field b_01
		$this->b_01->AdvancedSearch->SearchValue = @$filter["x_b_01"];
		$this->b_01->AdvancedSearch->SearchOperator = @$filter["z_b_01"];
		$this->b_01->AdvancedSearch->SearchCondition = @$filter["v_b_01"];
		$this->b_01->AdvancedSearch->SearchValue2 = @$filter["y_b_01"];
		$this->b_01->AdvancedSearch->SearchOperator2 = @$filter["w_b_01"];
		$this->b_01->AdvancedSearch->save();

		// Field b_02
		$this->b_02->AdvancedSearch->SearchValue = @$filter["x_b_02"];
		$this->b_02->AdvancedSearch->SearchOperator = @$filter["z_b_02"];
		$this->b_02->AdvancedSearch->SearchCondition = @$filter["v_b_02"];
		$this->b_02->AdvancedSearch->SearchValue2 = @$filter["y_b_02"];
		$this->b_02->AdvancedSearch->SearchOperator2 = @$filter["w_b_02"];
		$this->b_02->AdvancedSearch->save();

		// Field b_03
		$this->b_03->AdvancedSearch->SearchValue = @$filter["x_b_03"];
		$this->b_03->AdvancedSearch->SearchOperator = @$filter["z_b_03"];
		$this->b_03->AdvancedSearch->SearchCondition = @$filter["v_b_03"];
		$this->b_03->AdvancedSearch->SearchValue2 = @$filter["y_b_03"];
		$this->b_03->AdvancedSearch->SearchOperator2 = @$filter["w_b_03"];
		$this->b_03->AdvancedSearch->save();

		// Field b_04
		$this->b_04->AdvancedSearch->SearchValue = @$filter["x_b_04"];
		$this->b_04->AdvancedSearch->SearchOperator = @$filter["z_b_04"];
		$this->b_04->AdvancedSearch->SearchCondition = @$filter["v_b_04"];
		$this->b_04->AdvancedSearch->SearchValue2 = @$filter["y_b_04"];
		$this->b_04->AdvancedSearch->SearchOperator2 = @$filter["w_b_04"];
		$this->b_04->AdvancedSearch->save();

		// Field b_05
		$this->b_05->AdvancedSearch->SearchValue = @$filter["x_b_05"];
		$this->b_05->AdvancedSearch->SearchOperator = @$filter["z_b_05"];
		$this->b_05->AdvancedSearch->SearchCondition = @$filter["v_b_05"];
		$this->b_05->AdvancedSearch->SearchValue2 = @$filter["y_b_05"];
		$this->b_05->AdvancedSearch->SearchOperator2 = @$filter["w_b_05"];
		$this->b_05->AdvancedSearch->save();

		// Field b_06
		$this->b_06->AdvancedSearch->SearchValue = @$filter["x_b_06"];
		$this->b_06->AdvancedSearch->SearchOperator = @$filter["z_b_06"];
		$this->b_06->AdvancedSearch->SearchCondition = @$filter["v_b_06"];
		$this->b_06->AdvancedSearch->SearchValue2 = @$filter["y_b_06"];
		$this->b_06->AdvancedSearch->SearchOperator2 = @$filter["w_b_06"];
		$this->b_06->AdvancedSearch->save();

		// Field b_07
		$this->b_07->AdvancedSearch->SearchValue = @$filter["x_b_07"];
		$this->b_07->AdvancedSearch->SearchOperator = @$filter["z_b_07"];
		$this->b_07->AdvancedSearch->SearchCondition = @$filter["v_b_07"];
		$this->b_07->AdvancedSearch->SearchValue2 = @$filter["y_b_07"];
		$this->b_07->AdvancedSearch->SearchOperator2 = @$filter["w_b_07"];
		$this->b_07->AdvancedSearch->save();

		// Field b_08
		$this->b_08->AdvancedSearch->SearchValue = @$filter["x_b_08"];
		$this->b_08->AdvancedSearch->SearchOperator = @$filter["z_b_08"];
		$this->b_08->AdvancedSearch->SearchCondition = @$filter["v_b_08"];
		$this->b_08->AdvancedSearch->SearchValue2 = @$filter["y_b_08"];
		$this->b_08->AdvancedSearch->SearchOperator2 = @$filter["w_b_08"];
		$this->b_08->AdvancedSearch->save();

		// Field b_09
		$this->b_09->AdvancedSearch->SearchValue = @$filter["x_b_09"];
		$this->b_09->AdvancedSearch->SearchOperator = @$filter["z_b_09"];
		$this->b_09->AdvancedSearch->SearchCondition = @$filter["v_b_09"];
		$this->b_09->AdvancedSearch->SearchValue2 = @$filter["y_b_09"];
		$this->b_09->AdvancedSearch->SearchOperator2 = @$filter["w_b_09"];
		$this->b_09->AdvancedSearch->save();

		// Field b_10
		$this->b_10->AdvancedSearch->SearchValue = @$filter["x_b_10"];
		$this->b_10->AdvancedSearch->SearchOperator = @$filter["z_b_10"];
		$this->b_10->AdvancedSearch->SearchCondition = @$filter["v_b_10"];
		$this->b_10->AdvancedSearch->SearchValue2 = @$filter["y_b_10"];
		$this->b_10->AdvancedSearch->SearchOperator2 = @$filter["w_b_10"];
		$this->b_10->AdvancedSearch->save();

		// Field b_11
		$this->b_11->AdvancedSearch->SearchValue = @$filter["x_b_11"];
		$this->b_11->AdvancedSearch->SearchOperator = @$filter["z_b_11"];
		$this->b_11->AdvancedSearch->SearchCondition = @$filter["v_b_11"];
		$this->b_11->AdvancedSearch->SearchValue2 = @$filter["y_b_11"];
		$this->b_11->AdvancedSearch->SearchOperator2 = @$filter["w_b_11"];
		$this->b_11->AdvancedSearch->save();

		// Field b_12
		$this->b_12->AdvancedSearch->SearchValue = @$filter["x_b_12"];
		$this->b_12->AdvancedSearch->SearchOperator = @$filter["z_b_12"];
		$this->b_12->AdvancedSearch->SearchCondition = @$filter["v_b_12"];
		$this->b_12->AdvancedSearch->SearchValue2 = @$filter["y_b_12"];
		$this->b_12->AdvancedSearch->SearchOperator2 = @$filter["w_b_12"];
		$this->b_12->AdvancedSearch->save();

		// Field b_13
		$this->b_13->AdvancedSearch->SearchValue = @$filter["x_b_13"];
		$this->b_13->AdvancedSearch->SearchOperator = @$filter["z_b_13"];
		$this->b_13->AdvancedSearch->SearchCondition = @$filter["v_b_13"];
		$this->b_13->AdvancedSearch->SearchValue2 = @$filter["y_b_13"];
		$this->b_13->AdvancedSearch->SearchOperator2 = @$filter["w_b_13"];
		$this->b_13->AdvancedSearch->save();

		// Field b_14
		$this->b_14->AdvancedSearch->SearchValue = @$filter["x_b_14"];
		$this->b_14->AdvancedSearch->SearchOperator = @$filter["z_b_14"];
		$this->b_14->AdvancedSearch->SearchCondition = @$filter["v_b_14"];
		$this->b_14->AdvancedSearch->SearchValue2 = @$filter["y_b_14"];
		$this->b_14->AdvancedSearch->SearchOperator2 = @$filter["w_b_14"];
		$this->b_14->AdvancedSearch->save();

		// Field b_15
		$this->b_15->AdvancedSearch->SearchValue = @$filter["x_b_15"];
		$this->b_15->AdvancedSearch->SearchOperator = @$filter["z_b_15"];
		$this->b_15->AdvancedSearch->SearchCondition = @$filter["v_b_15"];
		$this->b_15->AdvancedSearch->SearchValue2 = @$filter["y_b_15"];
		$this->b_15->AdvancedSearch->SearchOperator2 = @$filter["w_b_15"];
		$this->b_15->AdvancedSearch->save();

		// Field t_01
		$this->t_01->AdvancedSearch->SearchValue = @$filter["x_t_01"];
		$this->t_01->AdvancedSearch->SearchOperator = @$filter["z_t_01"];
		$this->t_01->AdvancedSearch->SearchCondition = @$filter["v_t_01"];
		$this->t_01->AdvancedSearch->SearchValue2 = @$filter["y_t_01"];
		$this->t_01->AdvancedSearch->SearchOperator2 = @$filter["w_t_01"];
		$this->t_01->AdvancedSearch->save();

		// Field t_02
		$this->t_02->AdvancedSearch->SearchValue = @$filter["x_t_02"];
		$this->t_02->AdvancedSearch->SearchOperator = @$filter["z_t_02"];
		$this->t_02->AdvancedSearch->SearchCondition = @$filter["v_t_02"];
		$this->t_02->AdvancedSearch->SearchValue2 = @$filter["y_t_02"];
		$this->t_02->AdvancedSearch->SearchOperator2 = @$filter["w_t_02"];
		$this->t_02->AdvancedSearch->save();

		// Field t_03
		$this->t_03->AdvancedSearch->SearchValue = @$filter["x_t_03"];
		$this->t_03->AdvancedSearch->SearchOperator = @$filter["z_t_03"];
		$this->t_03->AdvancedSearch->SearchCondition = @$filter["v_t_03"];
		$this->t_03->AdvancedSearch->SearchValue2 = @$filter["y_t_03"];
		$this->t_03->AdvancedSearch->SearchOperator2 = @$filter["w_t_03"];
		$this->t_03->AdvancedSearch->save();

		// Field t_04
		$this->t_04->AdvancedSearch->SearchValue = @$filter["x_t_04"];
		$this->t_04->AdvancedSearch->SearchOperator = @$filter["z_t_04"];
		$this->t_04->AdvancedSearch->SearchCondition = @$filter["v_t_04"];
		$this->t_04->AdvancedSearch->SearchValue2 = @$filter["y_t_04"];
		$this->t_04->AdvancedSearch->SearchOperator2 = @$filter["w_t_04"];
		$this->t_04->AdvancedSearch->save();

		// Field t_05
		$this->t_05->AdvancedSearch->SearchValue = @$filter["x_t_05"];
		$this->t_05->AdvancedSearch->SearchOperator = @$filter["z_t_05"];
		$this->t_05->AdvancedSearch->SearchCondition = @$filter["v_t_05"];
		$this->t_05->AdvancedSearch->SearchValue2 = @$filter["y_t_05"];
		$this->t_05->AdvancedSearch->SearchOperator2 = @$filter["w_t_05"];
		$this->t_05->AdvancedSearch->save();

		// Field t_06
		$this->t_06->AdvancedSearch->SearchValue = @$filter["x_t_06"];
		$this->t_06->AdvancedSearch->SearchOperator = @$filter["z_t_06"];
		$this->t_06->AdvancedSearch->SearchCondition = @$filter["v_t_06"];
		$this->t_06->AdvancedSearch->SearchValue2 = @$filter["y_t_06"];
		$this->t_06->AdvancedSearch->SearchOperator2 = @$filter["w_t_06"];
		$this->t_06->AdvancedSearch->save();

		// Field t_07
		$this->t_07->AdvancedSearch->SearchValue = @$filter["x_t_07"];
		$this->t_07->AdvancedSearch->SearchOperator = @$filter["z_t_07"];
		$this->t_07->AdvancedSearch->SearchCondition = @$filter["v_t_07"];
		$this->t_07->AdvancedSearch->SearchValue2 = @$filter["y_t_07"];
		$this->t_07->AdvancedSearch->SearchOperator2 = @$filter["w_t_07"];
		$this->t_07->AdvancedSearch->save();

		// Field t_08
		$this->t_08->AdvancedSearch->SearchValue = @$filter["x_t_08"];
		$this->t_08->AdvancedSearch->SearchOperator = @$filter["z_t_08"];
		$this->t_08->AdvancedSearch->SearchCondition = @$filter["v_t_08"];
		$this->t_08->AdvancedSearch->SearchValue2 = @$filter["y_t_08"];
		$this->t_08->AdvancedSearch->SearchOperator2 = @$filter["w_t_08"];
		$this->t_08->AdvancedSearch->save();

		// Field t_09
		$this->t_09->AdvancedSearch->SearchValue = @$filter["x_t_09"];
		$this->t_09->AdvancedSearch->SearchOperator = @$filter["z_t_09"];
		$this->t_09->AdvancedSearch->SearchCondition = @$filter["v_t_09"];
		$this->t_09->AdvancedSearch->SearchValue2 = @$filter["y_t_09"];
		$this->t_09->AdvancedSearch->SearchOperator2 = @$filter["w_t_09"];
		$this->t_09->AdvancedSearch->save();

		// Field t_10
		$this->t_10->AdvancedSearch->SearchValue = @$filter["x_t_10"];
		$this->t_10->AdvancedSearch->SearchOperator = @$filter["z_t_10"];
		$this->t_10->AdvancedSearch->SearchCondition = @$filter["v_t_10"];
		$this->t_10->AdvancedSearch->SearchValue2 = @$filter["y_t_10"];
		$this->t_10->AdvancedSearch->SearchOperator2 = @$filter["w_t_10"];
		$this->t_10->AdvancedSearch->save();

		// Field t_11
		$this->t_11->AdvancedSearch->SearchValue = @$filter["x_t_11"];
		$this->t_11->AdvancedSearch->SearchOperator = @$filter["z_t_11"];
		$this->t_11->AdvancedSearch->SearchCondition = @$filter["v_t_11"];
		$this->t_11->AdvancedSearch->SearchValue2 = @$filter["y_t_11"];
		$this->t_11->AdvancedSearch->SearchOperator2 = @$filter["w_t_11"];
		$this->t_11->AdvancedSearch->save();

		// Field t_12
		$this->t_12->AdvancedSearch->SearchValue = @$filter["x_t_12"];
		$this->t_12->AdvancedSearch->SearchOperator = @$filter["z_t_12"];
		$this->t_12->AdvancedSearch->SearchCondition = @$filter["v_t_12"];
		$this->t_12->AdvancedSearch->SearchValue2 = @$filter["y_t_12"];
		$this->t_12->AdvancedSearch->SearchOperator2 = @$filter["w_t_12"];
		$this->t_12->AdvancedSearch->save();

		// Field t_13
		$this->t_13->AdvancedSearch->SearchValue = @$filter["x_t_13"];
		$this->t_13->AdvancedSearch->SearchOperator = @$filter["z_t_13"];
		$this->t_13->AdvancedSearch->SearchCondition = @$filter["v_t_13"];
		$this->t_13->AdvancedSearch->SearchValue2 = @$filter["y_t_13"];
		$this->t_13->AdvancedSearch->SearchOperator2 = @$filter["w_t_13"];
		$this->t_13->AdvancedSearch->save();

		// Field t_14
		$this->t_14->AdvancedSearch->SearchValue = @$filter["x_t_14"];
		$this->t_14->AdvancedSearch->SearchOperator = @$filter["z_t_14"];
		$this->t_14->AdvancedSearch->SearchCondition = @$filter["v_t_14"];
		$this->t_14->AdvancedSearch->SearchValue2 = @$filter["y_t_14"];
		$this->t_14->AdvancedSearch->SearchOperator2 = @$filter["w_t_14"];
		$this->t_14->AdvancedSearch->save();

		// Field t_15
		$this->t_15->AdvancedSearch->SearchValue = @$filter["x_t_15"];
		$this->t_15->AdvancedSearch->SearchOperator = @$filter["z_t_15"];
		$this->t_15->AdvancedSearch->SearchCondition = @$filter["v_t_15"];
		$this->t_15->AdvancedSearch->SearchValue2 = @$filter["y_t_15"];
		$this->t_15->AdvancedSearch->SearchOperator2 = @$filter["w_t_15"];
		$this->t_15->AdvancedSearch->save();

		// Field d_head_01
		$this->d_head_01->AdvancedSearch->SearchValue = @$filter["x_d_head_01"];
		$this->d_head_01->AdvancedSearch->SearchOperator = @$filter["z_d_head_01"];
		$this->d_head_01->AdvancedSearch->SearchCondition = @$filter["v_d_head_01"];
		$this->d_head_01->AdvancedSearch->SearchValue2 = @$filter["y_d_head_01"];
		$this->d_head_01->AdvancedSearch->SearchOperator2 = @$filter["w_d_head_01"];
		$this->d_head_01->AdvancedSearch->save();

		// Field d_description_01
		$this->d_description_01->AdvancedSearch->SearchValue = @$filter["x_d_description_01"];
		$this->d_description_01->AdvancedSearch->SearchOperator = @$filter["z_d_description_01"];
		$this->d_description_01->AdvancedSearch->SearchCondition = @$filter["v_d_description_01"];
		$this->d_description_01->AdvancedSearch->SearchValue2 = @$filter["y_d_description_01"];
		$this->d_description_01->AdvancedSearch->SearchOperator2 = @$filter["w_d_description_01"];
		$this->d_description_01->AdvancedSearch->save();

		// Field d_head_02
		$this->d_head_02->AdvancedSearch->SearchValue = @$filter["x_d_head_02"];
		$this->d_head_02->AdvancedSearch->SearchOperator = @$filter["z_d_head_02"];
		$this->d_head_02->AdvancedSearch->SearchCondition = @$filter["v_d_head_02"];
		$this->d_head_02->AdvancedSearch->SearchValue2 = @$filter["y_d_head_02"];
		$this->d_head_02->AdvancedSearch->SearchOperator2 = @$filter["w_d_head_02"];
		$this->d_head_02->AdvancedSearch->save();

		// Field d_description_02
		$this->d_description_02->AdvancedSearch->SearchValue = @$filter["x_d_description_02"];
		$this->d_description_02->AdvancedSearch->SearchOperator = @$filter["z_d_description_02"];
		$this->d_description_02->AdvancedSearch->SearchCondition = @$filter["v_d_description_02"];
		$this->d_description_02->AdvancedSearch->SearchValue2 = @$filter["y_d_description_02"];
		$this->d_description_02->AdvancedSearch->SearchOperator2 = @$filter["w_d_description_02"];
		$this->d_description_02->AdvancedSearch->save();

		// Field main_image
		$this->main_image->AdvancedSearch->SearchValue = @$filter["x_main_image"];
		$this->main_image->AdvancedSearch->SearchOperator = @$filter["z_main_image"];
		$this->main_image->AdvancedSearch->SearchCondition = @$filter["v_main_image"];
		$this->main_image->AdvancedSearch->SearchValue2 = @$filter["y_main_image"];
		$this->main_image->AdvancedSearch->SearchOperator2 = @$filter["w_main_image"];
		$this->main_image->AdvancedSearch->save();

		// Field top_view
		$this->top_view->AdvancedSearch->SearchValue = @$filter["x_top_view"];
		$this->top_view->AdvancedSearch->SearchOperator = @$filter["z_top_view"];
		$this->top_view->AdvancedSearch->SearchCondition = @$filter["v_top_view"];
		$this->top_view->AdvancedSearch->SearchValue2 = @$filter["y_top_view"];
		$this->top_view->AdvancedSearch->SearchOperator2 = @$filter["w_top_view"];
		$this->top_view->AdvancedSearch->save();

		// Field front_view
		$this->front_view->AdvancedSearch->SearchValue = @$filter["x_front_view"];
		$this->front_view->AdvancedSearch->SearchOperator = @$filter["z_front_view"];
		$this->front_view->AdvancedSearch->SearchCondition = @$filter["v_front_view"];
		$this->front_view->AdvancedSearch->SearchValue2 = @$filter["y_front_view"];
		$this->front_view->AdvancedSearch->SearchOperator2 = @$filter["w_front_view"];
		$this->front_view->AdvancedSearch->save();

		// Field corner_view
		$this->corner_view->AdvancedSearch->SearchValue = @$filter["x_corner_view"];
		$this->corner_view->AdvancedSearch->SearchOperator = @$filter["z_corner_view"];
		$this->corner_view->AdvancedSearch->SearchCondition = @$filter["v_corner_view"];
		$this->corner_view->AdvancedSearch->SearchValue2 = @$filter["y_corner_view"];
		$this->corner_view->AdvancedSearch->SearchOperator2 = @$filter["w_corner_view"];
		$this->corner_view->AdvancedSearch->save();

		// Field back_view
		$this->back_view->AdvancedSearch->SearchValue = @$filter["x_back_view"];
		$this->back_view->AdvancedSearch->SearchOperator = @$filter["z_back_view"];
		$this->back_view->AdvancedSearch->SearchCondition = @$filter["v_back_view"];
		$this->back_view->AdvancedSearch->SearchValue2 = @$filter["y_back_view"];
		$this->back_view->AdvancedSearch->SearchOperator2 = @$filter["w_back_view"];
		$this->back_view->AdvancedSearch->save();

		// Field color_options
		$this->color_options->AdvancedSearch->SearchValue = @$filter["x_color_options"];
		$this->color_options->AdvancedSearch->SearchOperator = @$filter["z_color_options"];
		$this->color_options->AdvancedSearch->SearchCondition = @$filter["v_color_options"];
		$this->color_options->AdvancedSearch->SearchValue2 = @$filter["y_color_options"];
		$this->color_options->AdvancedSearch->SearchOperator2 = @$filter["w_color_options"];
		$this->color_options->AdvancedSearch->save();

		// Field other_options
		$this->other_options->AdvancedSearch->SearchValue = @$filter["x_other_options"];
		$this->other_options->AdvancedSearch->SearchOperator = @$filter["z_other_options"];
		$this->other_options->AdvancedSearch->SearchCondition = @$filter["v_other_options"];
		$this->other_options->AdvancedSearch->SearchValue2 = @$filter["y_other_options"];
		$this->other_options->AdvancedSearch->SearchOperator2 = @$filter["w_other_options"];
		$this->other_options->AdvancedSearch->save();

		// Field image
		$this->image->AdvancedSearch->SearchValue = @$filter["x_image"];
		$this->image->AdvancedSearch->SearchOperator = @$filter["z_image"];
		$this->image->AdvancedSearch->SearchCondition = @$filter["v_image"];
		$this->image->AdvancedSearch->SearchValue2 = @$filter["y_image"];
		$this->image->AdvancedSearch->SearchOperator2 = @$filter["w_image"];
		$this->image->AdvancedSearch->save();

		// Field video_url
		$this->video_url->AdvancedSearch->SearchValue = @$filter["x_video_url"];
		$this->video_url->AdvancedSearch->SearchOperator = @$filter["z_video_url"];
		$this->video_url->AdvancedSearch->SearchCondition = @$filter["v_video_url"];
		$this->video_url->AdvancedSearch->SearchValue2 = @$filter["y_video_url"];
		$this->video_url->AdvancedSearch->SearchOperator2 = @$filter["w_video_url"];
		$this->video_url->AdvancedSearch->save();

		// Field currency
		$this->currency->AdvancedSearch->SearchValue = @$filter["x_currency"];
		$this->currency->AdvancedSearch->SearchOperator = @$filter["z_currency"];
		$this->currency->AdvancedSearch->SearchCondition = @$filter["v_currency"];
		$this->currency->AdvancedSearch->SearchValue2 = @$filter["y_currency"];
		$this->currency->AdvancedSearch->SearchOperator2 = @$filter["w_currency"];
		$this->currency->AdvancedSearch->save();

		// Field hsn
		$this->hsn->AdvancedSearch->SearchValue = @$filter["x_hsn"];
		$this->hsn->AdvancedSearch->SearchOperator = @$filter["z_hsn"];
		$this->hsn->AdvancedSearch->SearchCondition = @$filter["v_hsn"];
		$this->hsn->AdvancedSearch->SearchValue2 = @$filter["y_hsn"];
		$this->hsn->AdvancedSearch->SearchOperator2 = @$filter["w_hsn"];
		$this->hsn->AdvancedSearch->save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->company_id, $default, FALSE); // company_id
		$this->buildSearchSql($where, $this->grp, $default, FALSE); // grp
		$this->buildSearchSql($where, $this->s_grp, $default, FALSE); // s_grp
		$this->buildSearchSql($where, $this->product, $default, FALSE); // product
		$this->buildSearchSql($where, $this->product_n, $default, FALSE); // product_n
		$this->buildSearchSql($where, $this->product_type, $default, FALSE); // product_type
		$this->buildSearchSql($where, $this->last_price, $default, FALSE); // last_price
		$this->buildSearchSql($where, $this->v_01, $default, TRUE); // v_01
		$this->buildSearchSql($where, $this->v_02, $default, TRUE); // v_02
		$this->buildSearchSql($where, $this->v_03, $default, TRUE); // v_03
		$this->buildSearchSql($where, $this->v_04, $default, TRUE); // v_04
		$this->buildSearchSql($where, $this->v_05, $default, TRUE); // v_05
		$this->buildSearchSql($where, $this->v_06, $default, TRUE); // v_06
		$this->buildSearchSql($where, $this->v_07, $default, TRUE); // v_07
		$this->buildSearchSql($where, $this->v_08, $default, TRUE); // v_08
		$this->buildSearchSql($where, $this->v_09, $default, TRUE); // v_09
		$this->buildSearchSql($where, $this->v_10, $default, TRUE); // v_10
		$this->buildSearchSql($where, $this->cbm, $default, FALSE); // cbm
		$this->buildSearchSql($where, $this->sqm, $default, FALSE); // sqm
		$this->buildSearchSql($where, $this->shape, $default, TRUE); // shape
		$this->buildSearchSql($where, $this->b_01, $default, FALSE); // b_01
		$this->buildSearchSql($where, $this->b_02, $default, FALSE); // b_02
		$this->buildSearchSql($where, $this->b_03, $default, TRUE); // b_03
		$this->buildSearchSql($where, $this->b_04, $default, TRUE); // b_04
		$this->buildSearchSql($where, $this->b_05, $default, TRUE); // b_05
		$this->buildSearchSql($where, $this->b_06, $default, TRUE); // b_06
		$this->buildSearchSql($where, $this->b_07, $default, TRUE); // b_07
		$this->buildSearchSql($where, $this->b_08, $default, TRUE); // b_08
		$this->buildSearchSql($where, $this->b_09, $default, TRUE); // b_09
		$this->buildSearchSql($where, $this->b_10, $default, TRUE); // b_10
		$this->buildSearchSql($where, $this->b_11, $default, FALSE); // b_11
		$this->buildSearchSql($where, $this->b_12, $default, FALSE); // b_12
		$this->buildSearchSql($where, $this->b_13, $default, FALSE); // b_13
		$this->buildSearchSql($where, $this->b_14, $default, FALSE); // b_14
		$this->buildSearchSql($where, $this->b_15, $default, FALSE); // b_15
		$this->buildSearchSql($where, $this->t_01, $default, FALSE); // t_01
		$this->buildSearchSql($where, $this->t_02, $default, FALSE); // t_02
		$this->buildSearchSql($where, $this->t_03, $default, TRUE); // t_03
		$this->buildSearchSql($where, $this->t_04, $default, TRUE); // t_04
		$this->buildSearchSql($where, $this->t_05, $default, TRUE); // t_05
		$this->buildSearchSql($where, $this->t_06, $default, TRUE); // t_06
		$this->buildSearchSql($where, $this->t_07, $default, TRUE); // t_07
		$this->buildSearchSql($where, $this->t_08, $default, TRUE); // t_08
		$this->buildSearchSql($where, $this->t_09, $default, TRUE); // t_09
		$this->buildSearchSql($where, $this->t_10, $default, TRUE); // t_10
		$this->buildSearchSql($where, $this->t_11, $default, FALSE); // t_11
		$this->buildSearchSql($where, $this->t_12, $default, FALSE); // t_12
		$this->buildSearchSql($where, $this->t_13, $default, FALSE); // t_13
		$this->buildSearchSql($where, $this->t_14, $default, FALSE); // t_14
		$this->buildSearchSql($where, $this->t_15, $default, FALSE); // t_15
		$this->buildSearchSql($where, $this->d_head_01, $default, FALSE); // d_head_01
		$this->buildSearchSql($where, $this->d_description_01, $default, FALSE); // d_description_01
		$this->buildSearchSql($where, $this->d_head_02, $default, FALSE); // d_head_02
		$this->buildSearchSql($where, $this->d_description_02, $default, FALSE); // d_description_02
		$this->buildSearchSql($where, $this->main_image, $default, FALSE); // main_image
		$this->buildSearchSql($where, $this->top_view, $default, FALSE); // top_view
		$this->buildSearchSql($where, $this->front_view, $default, FALSE); // front_view
		$this->buildSearchSql($where, $this->corner_view, $default, FALSE); // corner_view
		$this->buildSearchSql($where, $this->back_view, $default, FALSE); // back_view
		$this->buildSearchSql($where, $this->color_options, $default, FALSE); // color_options
		$this->buildSearchSql($where, $this->other_options, $default, FALSE); // other_options
		$this->buildSearchSql($where, $this->image, $default, FALSE); // image
		$this->buildSearchSql($where, $this->video_url, $default, FALSE); // video_url
		$this->buildSearchSql($where, $this->currency, $default, FALSE); // currency
		$this->buildSearchSql($where, $this->hsn, $default, FALSE); // hsn
		$this->buildSearchSql($where, $this->status, $default, FALSE); // status
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->company_id->AdvancedSearch->save(); // company_id
			$this->grp->AdvancedSearch->save(); // grp
			$this->s_grp->AdvancedSearch->save(); // s_grp
			$this->product->AdvancedSearch->save(); // product
			$this->product_n->AdvancedSearch->save(); // product_n
			$this->product_type->AdvancedSearch->save(); // product_type
			$this->last_price->AdvancedSearch->save(); // last_price
			$this->v_01->AdvancedSearch->save(); // v_01
			$this->v_02->AdvancedSearch->save(); // v_02
			$this->v_03->AdvancedSearch->save(); // v_03
			$this->v_04->AdvancedSearch->save(); // v_04
			$this->v_05->AdvancedSearch->save(); // v_05
			$this->v_06->AdvancedSearch->save(); // v_06
			$this->v_07->AdvancedSearch->save(); // v_07
			$this->v_08->AdvancedSearch->save(); // v_08
			$this->v_09->AdvancedSearch->save(); // v_09
			$this->v_10->AdvancedSearch->save(); // v_10
			$this->cbm->AdvancedSearch->save(); // cbm
			$this->sqm->AdvancedSearch->save(); // sqm
			$this->shape->AdvancedSearch->save(); // shape
			$this->b_01->AdvancedSearch->save(); // b_01
			$this->b_02->AdvancedSearch->save(); // b_02
			$this->b_03->AdvancedSearch->save(); // b_03
			$this->b_04->AdvancedSearch->save(); // b_04
			$this->b_05->AdvancedSearch->save(); // b_05
			$this->b_06->AdvancedSearch->save(); // b_06
			$this->b_07->AdvancedSearch->save(); // b_07
			$this->b_08->AdvancedSearch->save(); // b_08
			$this->b_09->AdvancedSearch->save(); // b_09
			$this->b_10->AdvancedSearch->save(); // b_10
			$this->b_11->AdvancedSearch->save(); // b_11
			$this->b_12->AdvancedSearch->save(); // b_12
			$this->b_13->AdvancedSearch->save(); // b_13
			$this->b_14->AdvancedSearch->save(); // b_14
			$this->b_15->AdvancedSearch->save(); // b_15
			$this->t_01->AdvancedSearch->save(); // t_01
			$this->t_02->AdvancedSearch->save(); // t_02
			$this->t_03->AdvancedSearch->save(); // t_03
			$this->t_04->AdvancedSearch->save(); // t_04
			$this->t_05->AdvancedSearch->save(); // t_05
			$this->t_06->AdvancedSearch->save(); // t_06
			$this->t_07->AdvancedSearch->save(); // t_07
			$this->t_08->AdvancedSearch->save(); // t_08
			$this->t_09->AdvancedSearch->save(); // t_09
			$this->t_10->AdvancedSearch->save(); // t_10
			$this->t_11->AdvancedSearch->save(); // t_11
			$this->t_12->AdvancedSearch->save(); // t_12
			$this->t_13->AdvancedSearch->save(); // t_13
			$this->t_14->AdvancedSearch->save(); // t_14
			$this->t_15->AdvancedSearch->save(); // t_15
			$this->d_head_01->AdvancedSearch->save(); // d_head_01
			$this->d_description_01->AdvancedSearch->save(); // d_description_01
			$this->d_head_02->AdvancedSearch->save(); // d_head_02
			$this->d_description_02->AdvancedSearch->save(); // d_description_02
			$this->main_image->AdvancedSearch->save(); // main_image
			$this->top_view->AdvancedSearch->save(); // top_view
			$this->front_view->AdvancedSearch->save(); // front_view
			$this->corner_view->AdvancedSearch->save(); // corner_view
			$this->back_view->AdvancedSearch->save(); // back_view
			$this->color_options->AdvancedSearch->save(); // color_options
			$this->other_options->AdvancedSearch->save(); // other_options
			$this->image->AdvancedSearch->save(); // image
			$this->video_url->AdvancedSearch->save(); // video_url
			$this->currency->AdvancedSearch->save(); // currency
			$this->hsn->AdvancedSearch->save(); // hsn
			$this->status->AdvancedSearch->save(); // status
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->company_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_grp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product_n, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->product_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->last_price, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_03, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_04, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_05, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_06, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_07, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_08, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_09, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->v_10, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->cbm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->sqm, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->shape, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_03, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_04, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_05, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_06, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_07, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_08, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_09, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_10, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_11, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_12, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_13, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_14, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_15, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_03, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_04, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_05, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_06, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_07, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_08, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_09, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_10, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_11, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_12, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_13, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_14, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->t_15, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->d_head_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->d_description_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->d_head_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->d_description_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->main_image, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->top_view, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->front_view, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->corner_view, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->back_view, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->color_options, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->other_options, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->image, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->video_url, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->hsn, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->status, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->publish, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->datetime, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->company_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->s_grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product_n->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->product_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->last_price->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_05->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_06->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_07->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_08->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_09->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->v_10->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cbm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->sqm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->shape->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_05->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_06->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_07->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_08->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_09->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_10->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_11->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_12->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_13->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_14->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_15->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_05->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_06->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_07->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_08->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_09->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_10->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_11->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_12->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_13->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_14->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->t_15->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_head_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_description_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_head_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->d_description_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->main_image->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->top_view->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->front_view->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->corner_view->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->back_view->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->color_options->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->other_options->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->image->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->video_url->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->currency->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->hsn->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->company_id->AdvancedSearch->unsetSession();
		$this->grp->AdvancedSearch->unsetSession();
		$this->s_grp->AdvancedSearch->unsetSession();
		$this->product->AdvancedSearch->unsetSession();
		$this->product_n->AdvancedSearch->unsetSession();
		$this->product_type->AdvancedSearch->unsetSession();
		$this->last_price->AdvancedSearch->unsetSession();
		$this->v_01->AdvancedSearch->unsetSession();
		$this->v_02->AdvancedSearch->unsetSession();
		$this->v_03->AdvancedSearch->unsetSession();
		$this->v_04->AdvancedSearch->unsetSession();
		$this->v_05->AdvancedSearch->unsetSession();
		$this->v_06->AdvancedSearch->unsetSession();
		$this->v_07->AdvancedSearch->unsetSession();
		$this->v_08->AdvancedSearch->unsetSession();
		$this->v_09->AdvancedSearch->unsetSession();
		$this->v_10->AdvancedSearch->unsetSession();
		$this->cbm->AdvancedSearch->unsetSession();
		$this->sqm->AdvancedSearch->unsetSession();
		$this->shape->AdvancedSearch->unsetSession();
		$this->b_01->AdvancedSearch->unsetSession();
		$this->b_02->AdvancedSearch->unsetSession();
		$this->b_03->AdvancedSearch->unsetSession();
		$this->b_04->AdvancedSearch->unsetSession();
		$this->b_05->AdvancedSearch->unsetSession();
		$this->b_06->AdvancedSearch->unsetSession();
		$this->b_07->AdvancedSearch->unsetSession();
		$this->b_08->AdvancedSearch->unsetSession();
		$this->b_09->AdvancedSearch->unsetSession();
		$this->b_10->AdvancedSearch->unsetSession();
		$this->b_11->AdvancedSearch->unsetSession();
		$this->b_12->AdvancedSearch->unsetSession();
		$this->b_13->AdvancedSearch->unsetSession();
		$this->b_14->AdvancedSearch->unsetSession();
		$this->b_15->AdvancedSearch->unsetSession();
		$this->t_01->AdvancedSearch->unsetSession();
		$this->t_02->AdvancedSearch->unsetSession();
		$this->t_03->AdvancedSearch->unsetSession();
		$this->t_04->AdvancedSearch->unsetSession();
		$this->t_05->AdvancedSearch->unsetSession();
		$this->t_06->AdvancedSearch->unsetSession();
		$this->t_07->AdvancedSearch->unsetSession();
		$this->t_08->AdvancedSearch->unsetSession();
		$this->t_09->AdvancedSearch->unsetSession();
		$this->t_10->AdvancedSearch->unsetSession();
		$this->t_11->AdvancedSearch->unsetSession();
		$this->t_12->AdvancedSearch->unsetSession();
		$this->t_13->AdvancedSearch->unsetSession();
		$this->t_14->AdvancedSearch->unsetSession();
		$this->t_15->AdvancedSearch->unsetSession();
		$this->d_head_01->AdvancedSearch->unsetSession();
		$this->d_description_01->AdvancedSearch->unsetSession();
		$this->d_head_02->AdvancedSearch->unsetSession();
		$this->d_description_02->AdvancedSearch->unsetSession();
		$this->main_image->AdvancedSearch->unsetSession();
		$this->top_view->AdvancedSearch->unsetSession();
		$this->front_view->AdvancedSearch->unsetSession();
		$this->corner_view->AdvancedSearch->unsetSession();
		$this->back_view->AdvancedSearch->unsetSession();
		$this->color_options->AdvancedSearch->unsetSession();
		$this->other_options->AdvancedSearch->unsetSession();
		$this->image->AdvancedSearch->unsetSession();
		$this->video_url->AdvancedSearch->unsetSession();
		$this->currency->AdvancedSearch->unsetSession();
		$this->hsn->AdvancedSearch->unsetSession();
		$this->status->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->product_n->AdvancedSearch->load();
		$this->product_type->AdvancedSearch->load();
		$this->last_price->AdvancedSearch->load();
		$this->v_01->AdvancedSearch->load();
		$this->v_02->AdvancedSearch->load();
		$this->v_03->AdvancedSearch->load();
		$this->v_04->AdvancedSearch->load();
		$this->v_05->AdvancedSearch->load();
		$this->v_06->AdvancedSearch->load();
		$this->v_07->AdvancedSearch->load();
		$this->v_08->AdvancedSearch->load();
		$this->v_09->AdvancedSearch->load();
		$this->v_10->AdvancedSearch->load();
		$this->cbm->AdvancedSearch->load();
		$this->sqm->AdvancedSearch->load();
		$this->shape->AdvancedSearch->load();
		$this->b_01->AdvancedSearch->load();
		$this->b_02->AdvancedSearch->load();
		$this->b_03->AdvancedSearch->load();
		$this->b_04->AdvancedSearch->load();
		$this->b_05->AdvancedSearch->load();
		$this->b_06->AdvancedSearch->load();
		$this->b_07->AdvancedSearch->load();
		$this->b_08->AdvancedSearch->load();
		$this->b_09->AdvancedSearch->load();
		$this->b_10->AdvancedSearch->load();
		$this->b_11->AdvancedSearch->load();
		$this->b_12->AdvancedSearch->load();
		$this->b_13->AdvancedSearch->load();
		$this->b_14->AdvancedSearch->load();
		$this->b_15->AdvancedSearch->load();
		$this->t_01->AdvancedSearch->load();
		$this->t_02->AdvancedSearch->load();
		$this->t_03->AdvancedSearch->load();
		$this->t_04->AdvancedSearch->load();
		$this->t_05->AdvancedSearch->load();
		$this->t_06->AdvancedSearch->load();
		$this->t_07->AdvancedSearch->load();
		$this->t_08->AdvancedSearch->load();
		$this->t_09->AdvancedSearch->load();
		$this->t_10->AdvancedSearch->load();
		$this->t_11->AdvancedSearch->load();
		$this->t_12->AdvancedSearch->load();
		$this->t_13->AdvancedSearch->load();
		$this->t_14->AdvancedSearch->load();
		$this->t_15->AdvancedSearch->load();
		$this->d_head_01->AdvancedSearch->load();
		$this->d_description_01->AdvancedSearch->load();
		$this->d_head_02->AdvancedSearch->load();
		$this->d_description_02->AdvancedSearch->load();
		$this->main_image->AdvancedSearch->load();
		$this->top_view->AdvancedSearch->load();
		$this->front_view->AdvancedSearch->load();
		$this->corner_view->AdvancedSearch->load();
		$this->back_view->AdvancedSearch->load();
		$this->color_options->AdvancedSearch->load();
		$this->other_options->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
		$this->video_url->AdvancedSearch->load();
		$this->currency->AdvancedSearch->load();
		$this->hsn->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->company_id, $ctrl); // company_id
			$this->updateSort($this->grp, $ctrl); // grp
			$this->updateSort($this->s_grp, $ctrl); // s_grp
			$this->updateSort($this->product_type, $ctrl); // product_type
			$this->updateSort($this->status, $ctrl); // status
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->company_id->setSort("");
				$this->grp->setSort("");
				$this->s_grp->setSort("");
				$this->product_type->setSort("");
				$this->status->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// "detail__ref_view"
		$item = &$this->ListOptions->add("detail__ref_view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->allowList(CurrentProjectID() . 'ref_view') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["_ref_view_grid"]))
			$GLOBALS["_ref_view_grid"] = new _ref_view_grid();

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$item = &$this->ListOptions->add("details");
			$item->CssClass = "text-nowrap";
			$item->Visible = $this->ShowMultipleDetails;
			$item->OnLeft = TRUE;
			$item->ShowInButtonGroup = FALSE;
		}

		// Set up detail pages
		$pages = new SubPages();
		$pages->add("_ref_view");
		$this->DetailPages = $pages;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}
		$detailViewTblVar = "";
		$detailCopyTblVar = "";
		$detailEditTblVar = "";

		// "detail__ref_view"
		$opt = &$this->ListOptions->Items["detail__ref_view"];
		if ($Security->allowList(CurrentProjectID() . 'ref_view')) {
			$body = $Language->phrase("DetailLink") . $Language->TablePhrase("_ref_view", "TblCaption");
			$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("_ref_viewlist.php?" . TABLE_SHOW_MASTER . "=ref_multi&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["_ref_view_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'ref_view')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(TABLE_SHOW_DETAIL . "=_ref_view");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailViewTblVar <> "")
					$detailViewTblVar .= ",";
				$detailViewTblVar .= "_ref_view";
			}
			if ($GLOBALS["_ref_view_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'ref_view')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(TABLE_SHOW_DETAIL . "=_ref_view");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailEditTblVar <> "")
					$detailEditTblVar .= ",";
				$detailEditTblVar .= "_ref_view";
			}
			if ($GLOBALS["_ref_view_grid"]->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'ref_view')) {
				$caption = $Language->phrase("MasterDetailCopyLink");
				$url = $this->getCopyUrl(TABLE_SHOW_DETAIL . "=_ref_view");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailCopyTblVar <> "")
					$detailCopyTblVar .= ",";
				$detailCopyTblVar .= "_ref_view";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
			$opt->Body = $body;
			if ($this->ShowMultipleDetails)
				$opt->Visible = FALSE;
		}
		if ($this->ShowMultipleDetails) {
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
			$links = "";
			if ($detailViewTblVar <> "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=" . $detailViewTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($detailEditTblVar <> "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=" . $detailEditTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($detailCopyTblVar <> "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->GetCopyUrl(TABLE_SHOW_DETAIL . "=" . $detailCopyTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlTitle($Language->phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
				$body .= "<ul class=\"dropdown-menu ew-menu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$opt = &$this->ListOptions->Items["details"];
			$opt->Body = $body;
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["detail"];
		$detailTableLink = "";
		$item = &$option->add("detailadd__ref_view");
		$url = $this->getAddUrl(TABLE_SHOW_DETAIL . "=_ref_view");
		$caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $GLOBALS["_ref_view"]->tableCaption();
		$item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a>";
		$item->Visible = ($GLOBALS["_ref_view"]->DetailAdd && $Security->allowAdd(CurrentProjectID() . 'ref_view') && $Security->canAdd());
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "_ref_view";
		}

		// Add multiple details
		if ($this->ShowMultipleDetails) {
			$item = &$option->add("detailsadd");
			$url = $this->getAddUrl(TABLE_SHOW_DETAIL . "=" . $detailTableLink);
			$caption = $Language->phrase("AddMasterDetailLink");
			$item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a>";
			$item->Visible = ($detailTableLink <> "" && $Security->canAdd());

			// Hide single master/detail items
			$ar = explode(",", $detailTableLink);
			$cnt = count($ar);
			for ($i = 0; $i < $cnt; $i++) {
				if ($item = &$option->getItem("detailadd_" . $ar[$i]))
					$item->Visible = FALSE;
			}
		}
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fref_multilistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fref_multilistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fref_multilist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fref_multilistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"ref_multisrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"ref_multi\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'ref_multisrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
		$links = "";
		$btngrps = "";
		$sqlwrk = "`id`=" . AdjustSql($this->id->CurrentValue, $this->Dbid) . "";

		// Column "detail__ref_view"
		if ($this->DetailPages->Items["_ref_view"]->Visible) {
			$link = "";
			$option = &$this->ListOptions->Items["detail__ref_view"];
			$url = "_ref_viewpreview.php?t=ref_multi&f=" . Encrypt($sqlwrk);
			$btngrp = "<div data-table=\"_ref_view\" data-url=\"" . $url . "\" class=\"btn-group btn-group-sm\">";
			if ($Security->allowList(CurrentProjectID() . 'ref_view')) {
				$label = $Language->TablePhrase("_ref_view", "TblCaption");
				$link = "<li class=\"nav-item\"><a href=\"#\" class=\"nav-link\" data-toggle=\"tab\" data-table=\"_ref_view\" data-url=\"" . $url . "\">" . $label . "</a></li>";
				$links .= $link;
				$detaillnk = JsEncodeAttribute("_ref_viewlist.php?" . TABLE_SHOW_MASTER . "=ref_multi&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . $Language->TablePhrase("_ref_view", "TblCaption") . "\" onclick=\"window.location='" . $detaillnk . "'\">" . $Language->phrase("MasterDetailListLink") . "</button>";
			}
			if (!isset($GLOBALS["_ref_view_grid"]))
				$GLOBALS["_ref_view_grid"] = new _ref_view_grid();
			if ($GLOBALS["_ref_view_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'ref_view')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(TABLE_SHOW_DETAIL . "=_ref_view");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" onclick=\"window.location='" . HtmlEncode($url) . "'\">" . $caption . "</button>";
			}
			if ($GLOBALS["_ref_view_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'ref_view')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(TABLE_SHOW_DETAIL . "=_ref_view");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" onclick=\"window.location='" . HtmlEncode($url) . "'\">" . $caption . "</button>";
			}
			$btngrp .= "</div>";
			if ($link <> "") {
				$btngrps .= $btngrp;
				$option->Body .= "<div class=\"d-none ew-preview\">" . $link . $btngrp . "</div>";
			}
		}

		// Hide detail items if necessary
		$this->ListOptions->hideDetailItemsForDropDown();

		// Column "preview"
		$option = &$this->ListOptions->getItem("preview");
		if (!$option) { // Add preview column
			$option = &$this->ListOptions->add("preview");
			$option->OnLeft = TRUE;
			if ($option->OnLeft) {
				$option->moveTo($this->ListOptions->itemPos("checkbox") + 1);
			} else {
				$option->moveTo($this->ListOptions->itemPos("checkbox"));
			}
			$option->Visible = !($this->isExport() || $this->isGridAdd() || $this->isGridEdit());
			$option->ShowInDropDown = FALSE;
			$option->ShowInButtonGroup = FALSE;
		}
		if ($option) {
			$option->Body = "<i class=\"ew-preview-row-btn ew-icon icon-expand\"></i>";
			$option->Body .= "<div class=\"d-none ew-preview\">" . $links . $btngrps . "</div>";
			if ($option->Visible)
				$option->Visible = $links <> "";
		}

		// Column "details" (Multiple details)
		$option = &$this->ListOptions->getItem("details");
		if ($option) {
			$option->Body .= "<div class=\"d-none ew-preview\">" . $links . $btngrps . "</div>";
			if ($option->Visible)
				$option->Visible = $links <> "";
		}
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue(Get("x_company_id", Get("company_id", "")));
		if ($this->company_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->company_id->AdvancedSearch->setSearchOperator(Get("z_company_id", ""));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue(Get("x_grp", Get("grp", "")));
		if ($this->grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->grp->AdvancedSearch->setSearchOperator(Get("z_grp", ""));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue(Get("x_s_grp", Get("s_grp", "")));
		if ($this->s_grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->s_grp->AdvancedSearch->setSearchOperator(Get("z_s_grp", ""));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue(Get("x_product", Get("product", "")));
		if ($this->product->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product->AdvancedSearch->setSearchOperator(Get("z_product", ""));

		// product_n
		if (!$this->isAddOrEdit())
			$this->product_n->AdvancedSearch->setSearchValue(Get("x_product_n", Get("product_n", "")));
		if ($this->product_n->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product_n->AdvancedSearch->setSearchOperator(Get("z_product_n", ""));

		// product_type
		if (!$this->isAddOrEdit())
			$this->product_type->AdvancedSearch->setSearchValue(Get("x_product_type", Get("product_type", "")));
		if ($this->product_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->product_type->AdvancedSearch->setSearchOperator(Get("z_product_type", ""));

		// last_price
		if (!$this->isAddOrEdit())
			$this->last_price->AdvancedSearch->setSearchValue(Get("x_last_price", Get("last_price", "")));
		if ($this->last_price->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->last_price->AdvancedSearch->setSearchOperator(Get("z_last_price", ""));

		// v_01
		if (!$this->isAddOrEdit())
			$this->v_01->AdvancedSearch->setSearchValue(Get("x_v_01", Get("v_01", "")));
		if ($this->v_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_01->AdvancedSearch->setSearchOperator(Get("z_v_01", ""));
		if (is_array($this->v_01->AdvancedSearch->SearchValue))
			$this->v_01->AdvancedSearch->SearchValue = implode(",", $this->v_01->AdvancedSearch->SearchValue);
		if (is_array($this->v_01->AdvancedSearch->SearchValue2))
			$this->v_01->AdvancedSearch->SearchValue2 = implode(",", $this->v_01->AdvancedSearch->SearchValue2);

		// v_02
		if (!$this->isAddOrEdit())
			$this->v_02->AdvancedSearch->setSearchValue(Get("x_v_02", Get("v_02", "")));
		if ($this->v_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_02->AdvancedSearch->setSearchOperator(Get("z_v_02", ""));
		if (is_array($this->v_02->AdvancedSearch->SearchValue))
			$this->v_02->AdvancedSearch->SearchValue = implode(",", $this->v_02->AdvancedSearch->SearchValue);
		if (is_array($this->v_02->AdvancedSearch->SearchValue2))
			$this->v_02->AdvancedSearch->SearchValue2 = implode(",", $this->v_02->AdvancedSearch->SearchValue2);

		// v_03
		if (!$this->isAddOrEdit())
			$this->v_03->AdvancedSearch->setSearchValue(Get("x_v_03", Get("v_03", "")));
		if ($this->v_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_03->AdvancedSearch->setSearchOperator(Get("z_v_03", ""));
		if (is_array($this->v_03->AdvancedSearch->SearchValue))
			$this->v_03->AdvancedSearch->SearchValue = implode(",", $this->v_03->AdvancedSearch->SearchValue);
		if (is_array($this->v_03->AdvancedSearch->SearchValue2))
			$this->v_03->AdvancedSearch->SearchValue2 = implode(",", $this->v_03->AdvancedSearch->SearchValue2);

		// v_04
		if (!$this->isAddOrEdit())
			$this->v_04->AdvancedSearch->setSearchValue(Get("x_v_04", Get("v_04", "")));
		if ($this->v_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_04->AdvancedSearch->setSearchOperator(Get("z_v_04", ""));
		if (is_array($this->v_04->AdvancedSearch->SearchValue))
			$this->v_04->AdvancedSearch->SearchValue = implode(",", $this->v_04->AdvancedSearch->SearchValue);
		if (is_array($this->v_04->AdvancedSearch->SearchValue2))
			$this->v_04->AdvancedSearch->SearchValue2 = implode(",", $this->v_04->AdvancedSearch->SearchValue2);

		// v_05
		if (!$this->isAddOrEdit())
			$this->v_05->AdvancedSearch->setSearchValue(Get("x_v_05", Get("v_05", "")));
		if ($this->v_05->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_05->AdvancedSearch->setSearchOperator(Get("z_v_05", ""));
		if (is_array($this->v_05->AdvancedSearch->SearchValue))
			$this->v_05->AdvancedSearch->SearchValue = implode(",", $this->v_05->AdvancedSearch->SearchValue);
		if (is_array($this->v_05->AdvancedSearch->SearchValue2))
			$this->v_05->AdvancedSearch->SearchValue2 = implode(",", $this->v_05->AdvancedSearch->SearchValue2);

		// v_06
		if (!$this->isAddOrEdit())
			$this->v_06->AdvancedSearch->setSearchValue(Get("x_v_06", Get("v_06", "")));
		if ($this->v_06->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_06->AdvancedSearch->setSearchOperator(Get("z_v_06", ""));
		if (is_array($this->v_06->AdvancedSearch->SearchValue))
			$this->v_06->AdvancedSearch->SearchValue = implode(",", $this->v_06->AdvancedSearch->SearchValue);
		if (is_array($this->v_06->AdvancedSearch->SearchValue2))
			$this->v_06->AdvancedSearch->SearchValue2 = implode(",", $this->v_06->AdvancedSearch->SearchValue2);

		// v_07
		if (!$this->isAddOrEdit())
			$this->v_07->AdvancedSearch->setSearchValue(Get("x_v_07", Get("v_07", "")));
		if ($this->v_07->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_07->AdvancedSearch->setSearchOperator(Get("z_v_07", ""));
		if (is_array($this->v_07->AdvancedSearch->SearchValue))
			$this->v_07->AdvancedSearch->SearchValue = implode(",", $this->v_07->AdvancedSearch->SearchValue);
		if (is_array($this->v_07->AdvancedSearch->SearchValue2))
			$this->v_07->AdvancedSearch->SearchValue2 = implode(",", $this->v_07->AdvancedSearch->SearchValue2);

		// v_08
		if (!$this->isAddOrEdit())
			$this->v_08->AdvancedSearch->setSearchValue(Get("x_v_08", Get("v_08", "")));
		if ($this->v_08->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_08->AdvancedSearch->setSearchOperator(Get("z_v_08", ""));
		if (is_array($this->v_08->AdvancedSearch->SearchValue))
			$this->v_08->AdvancedSearch->SearchValue = implode(",", $this->v_08->AdvancedSearch->SearchValue);
		if (is_array($this->v_08->AdvancedSearch->SearchValue2))
			$this->v_08->AdvancedSearch->SearchValue2 = implode(",", $this->v_08->AdvancedSearch->SearchValue2);

		// v_09
		if (!$this->isAddOrEdit())
			$this->v_09->AdvancedSearch->setSearchValue(Get("x_v_09", Get("v_09", "")));
		if ($this->v_09->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_09->AdvancedSearch->setSearchOperator(Get("z_v_09", ""));
		if (is_array($this->v_09->AdvancedSearch->SearchValue))
			$this->v_09->AdvancedSearch->SearchValue = implode(",", $this->v_09->AdvancedSearch->SearchValue);
		if (is_array($this->v_09->AdvancedSearch->SearchValue2))
			$this->v_09->AdvancedSearch->SearchValue2 = implode(",", $this->v_09->AdvancedSearch->SearchValue2);

		// v_10
		if (!$this->isAddOrEdit())
			$this->v_10->AdvancedSearch->setSearchValue(Get("x_v_10", Get("v_10", "")));
		if ($this->v_10->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->v_10->AdvancedSearch->setSearchOperator(Get("z_v_10", ""));
		if (is_array($this->v_10->AdvancedSearch->SearchValue))
			$this->v_10->AdvancedSearch->SearchValue = implode(",", $this->v_10->AdvancedSearch->SearchValue);
		if (is_array($this->v_10->AdvancedSearch->SearchValue2))
			$this->v_10->AdvancedSearch->SearchValue2 = implode(",", $this->v_10->AdvancedSearch->SearchValue2);

		// b_01
		if (!$this->isAddOrEdit())
			$this->b_01->AdvancedSearch->setSearchValue(Get("x_b_01", Get("b_01", "")));
		if ($this->b_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_01->AdvancedSearch->setSearchOperator(Get("z_b_01", ""));

		// b_02
		if (!$this->isAddOrEdit())
			$this->b_02->AdvancedSearch->setSearchValue(Get("x_b_02", Get("b_02", "")));
		if ($this->b_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_02->AdvancedSearch->setSearchOperator(Get("z_b_02", ""));

		// b_03
		if (!$this->isAddOrEdit())
			$this->b_03->AdvancedSearch->setSearchValue(Get("x_b_03", Get("b_03", "")));
		if ($this->b_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_03->AdvancedSearch->setSearchOperator(Get("z_b_03", ""));
		if (is_array($this->b_03->AdvancedSearch->SearchValue))
			$this->b_03->AdvancedSearch->SearchValue = implode(",", $this->b_03->AdvancedSearch->SearchValue);
		if (is_array($this->b_03->AdvancedSearch->SearchValue2))
			$this->b_03->AdvancedSearch->SearchValue2 = implode(",", $this->b_03->AdvancedSearch->SearchValue2);

		// b_04
		if (!$this->isAddOrEdit())
			$this->b_04->AdvancedSearch->setSearchValue(Get("x_b_04", Get("b_04", "")));
		if ($this->b_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_04->AdvancedSearch->setSearchOperator(Get("z_b_04", ""));
		if (is_array($this->b_04->AdvancedSearch->SearchValue))
			$this->b_04->AdvancedSearch->SearchValue = implode(",", $this->b_04->AdvancedSearch->SearchValue);
		if (is_array($this->b_04->AdvancedSearch->SearchValue2))
			$this->b_04->AdvancedSearch->SearchValue2 = implode(",", $this->b_04->AdvancedSearch->SearchValue2);

		// b_05
		if (!$this->isAddOrEdit())
			$this->b_05->AdvancedSearch->setSearchValue(Get("x_b_05", Get("b_05", "")));
		if ($this->b_05->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_05->AdvancedSearch->setSearchOperator(Get("z_b_05", ""));
		if (is_array($this->b_05->AdvancedSearch->SearchValue))
			$this->b_05->AdvancedSearch->SearchValue = implode(",", $this->b_05->AdvancedSearch->SearchValue);
		if (is_array($this->b_05->AdvancedSearch->SearchValue2))
			$this->b_05->AdvancedSearch->SearchValue2 = implode(",", $this->b_05->AdvancedSearch->SearchValue2);

		// b_06
		if (!$this->isAddOrEdit())
			$this->b_06->AdvancedSearch->setSearchValue(Get("x_b_06", Get("b_06", "")));
		if ($this->b_06->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_06->AdvancedSearch->setSearchOperator(Get("z_b_06", ""));
		if (is_array($this->b_06->AdvancedSearch->SearchValue))
			$this->b_06->AdvancedSearch->SearchValue = implode(",", $this->b_06->AdvancedSearch->SearchValue);
		if (is_array($this->b_06->AdvancedSearch->SearchValue2))
			$this->b_06->AdvancedSearch->SearchValue2 = implode(",", $this->b_06->AdvancedSearch->SearchValue2);

		// b_07
		if (!$this->isAddOrEdit())
			$this->b_07->AdvancedSearch->setSearchValue(Get("x_b_07", Get("b_07", "")));
		if ($this->b_07->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_07->AdvancedSearch->setSearchOperator(Get("z_b_07", ""));
		if (is_array($this->b_07->AdvancedSearch->SearchValue))
			$this->b_07->AdvancedSearch->SearchValue = implode(",", $this->b_07->AdvancedSearch->SearchValue);
		if (is_array($this->b_07->AdvancedSearch->SearchValue2))
			$this->b_07->AdvancedSearch->SearchValue2 = implode(",", $this->b_07->AdvancedSearch->SearchValue2);

		// b_08
		if (!$this->isAddOrEdit())
			$this->b_08->AdvancedSearch->setSearchValue(Get("x_b_08", Get("b_08", "")));
		if ($this->b_08->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_08->AdvancedSearch->setSearchOperator(Get("z_b_08", ""));
		if (is_array($this->b_08->AdvancedSearch->SearchValue))
			$this->b_08->AdvancedSearch->SearchValue = implode(",", $this->b_08->AdvancedSearch->SearchValue);
		if (is_array($this->b_08->AdvancedSearch->SearchValue2))
			$this->b_08->AdvancedSearch->SearchValue2 = implode(",", $this->b_08->AdvancedSearch->SearchValue2);

		// b_09
		if (!$this->isAddOrEdit())
			$this->b_09->AdvancedSearch->setSearchValue(Get("x_b_09", Get("b_09", "")));
		if ($this->b_09->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_09->AdvancedSearch->setSearchOperator(Get("z_b_09", ""));
		if (is_array($this->b_09->AdvancedSearch->SearchValue))
			$this->b_09->AdvancedSearch->SearchValue = implode(",", $this->b_09->AdvancedSearch->SearchValue);
		if (is_array($this->b_09->AdvancedSearch->SearchValue2))
			$this->b_09->AdvancedSearch->SearchValue2 = implode(",", $this->b_09->AdvancedSearch->SearchValue2);

		// b_10
		if (!$this->isAddOrEdit())
			$this->b_10->AdvancedSearch->setSearchValue(Get("x_b_10", Get("b_10", "")));
		if ($this->b_10->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_10->AdvancedSearch->setSearchOperator(Get("z_b_10", ""));
		if (is_array($this->b_10->AdvancedSearch->SearchValue))
			$this->b_10->AdvancedSearch->SearchValue = implode(",", $this->b_10->AdvancedSearch->SearchValue);
		if (is_array($this->b_10->AdvancedSearch->SearchValue2))
			$this->b_10->AdvancedSearch->SearchValue2 = implode(",", $this->b_10->AdvancedSearch->SearchValue2);

		// b_11
		if (!$this->isAddOrEdit())
			$this->b_11->AdvancedSearch->setSearchValue(Get("x_b_11", Get("b_11", "")));
		if ($this->b_11->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_11->AdvancedSearch->setSearchOperator(Get("z_b_11", ""));

		// b_12
		if (!$this->isAddOrEdit())
			$this->b_12->AdvancedSearch->setSearchValue(Get("x_b_12", Get("b_12", "")));
		if ($this->b_12->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_12->AdvancedSearch->setSearchOperator(Get("z_b_12", ""));

		// b_13
		if (!$this->isAddOrEdit())
			$this->b_13->AdvancedSearch->setSearchValue(Get("x_b_13", Get("b_13", "")));
		if ($this->b_13->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_13->AdvancedSearch->setSearchOperator(Get("z_b_13", ""));

		// b_14
		if (!$this->isAddOrEdit())
			$this->b_14->AdvancedSearch->setSearchValue(Get("x_b_14", Get("b_14", "")));
		if ($this->b_14->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_14->AdvancedSearch->setSearchOperator(Get("z_b_14", ""));

		// b_15
		if (!$this->isAddOrEdit())
			$this->b_15->AdvancedSearch->setSearchValue(Get("x_b_15", Get("b_15", "")));
		if ($this->b_15->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_15->AdvancedSearch->setSearchOperator(Get("z_b_15", ""));

		// t_01
		if (!$this->isAddOrEdit())
			$this->t_01->AdvancedSearch->setSearchValue(Get("x_t_01", Get("t_01", "")));
		if ($this->t_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_01->AdvancedSearch->setSearchOperator(Get("z_t_01", ""));

		// t_02
		if (!$this->isAddOrEdit())
			$this->t_02->AdvancedSearch->setSearchValue(Get("x_t_02", Get("t_02", "")));
		if ($this->t_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_02->AdvancedSearch->setSearchOperator(Get("z_t_02", ""));

		// t_03
		if (!$this->isAddOrEdit())
			$this->t_03->AdvancedSearch->setSearchValue(Get("x_t_03", Get("t_03", "")));
		if ($this->t_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_03->AdvancedSearch->setSearchOperator(Get("z_t_03", ""));
		if (is_array($this->t_03->AdvancedSearch->SearchValue))
			$this->t_03->AdvancedSearch->SearchValue = implode(",", $this->t_03->AdvancedSearch->SearchValue);
		if (is_array($this->t_03->AdvancedSearch->SearchValue2))
			$this->t_03->AdvancedSearch->SearchValue2 = implode(",", $this->t_03->AdvancedSearch->SearchValue2);

		// t_04
		if (!$this->isAddOrEdit())
			$this->t_04->AdvancedSearch->setSearchValue(Get("x_t_04", Get("t_04", "")));
		if ($this->t_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_04->AdvancedSearch->setSearchOperator(Get("z_t_04", ""));
		if (is_array($this->t_04->AdvancedSearch->SearchValue))
			$this->t_04->AdvancedSearch->SearchValue = implode(",", $this->t_04->AdvancedSearch->SearchValue);
		if (is_array($this->t_04->AdvancedSearch->SearchValue2))
			$this->t_04->AdvancedSearch->SearchValue2 = implode(",", $this->t_04->AdvancedSearch->SearchValue2);

		// t_05
		if (!$this->isAddOrEdit())
			$this->t_05->AdvancedSearch->setSearchValue(Get("x_t_05", Get("t_05", "")));
		if ($this->t_05->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_05->AdvancedSearch->setSearchOperator(Get("z_t_05", ""));
		if (is_array($this->t_05->AdvancedSearch->SearchValue))
			$this->t_05->AdvancedSearch->SearchValue = implode(",", $this->t_05->AdvancedSearch->SearchValue);
		if (is_array($this->t_05->AdvancedSearch->SearchValue2))
			$this->t_05->AdvancedSearch->SearchValue2 = implode(",", $this->t_05->AdvancedSearch->SearchValue2);

		// t_06
		if (!$this->isAddOrEdit())
			$this->t_06->AdvancedSearch->setSearchValue(Get("x_t_06", Get("t_06", "")));
		if ($this->t_06->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_06->AdvancedSearch->setSearchOperator(Get("z_t_06", ""));
		if (is_array($this->t_06->AdvancedSearch->SearchValue))
			$this->t_06->AdvancedSearch->SearchValue = implode(",", $this->t_06->AdvancedSearch->SearchValue);
		if (is_array($this->t_06->AdvancedSearch->SearchValue2))
			$this->t_06->AdvancedSearch->SearchValue2 = implode(",", $this->t_06->AdvancedSearch->SearchValue2);

		// t_07
		if (!$this->isAddOrEdit())
			$this->t_07->AdvancedSearch->setSearchValue(Get("x_t_07", Get("t_07", "")));
		if ($this->t_07->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_07->AdvancedSearch->setSearchOperator(Get("z_t_07", ""));
		if (is_array($this->t_07->AdvancedSearch->SearchValue))
			$this->t_07->AdvancedSearch->SearchValue = implode(",", $this->t_07->AdvancedSearch->SearchValue);
		if (is_array($this->t_07->AdvancedSearch->SearchValue2))
			$this->t_07->AdvancedSearch->SearchValue2 = implode(",", $this->t_07->AdvancedSearch->SearchValue2);

		// t_08
		if (!$this->isAddOrEdit())
			$this->t_08->AdvancedSearch->setSearchValue(Get("x_t_08", Get("t_08", "")));
		if ($this->t_08->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_08->AdvancedSearch->setSearchOperator(Get("z_t_08", ""));
		if (is_array($this->t_08->AdvancedSearch->SearchValue))
			$this->t_08->AdvancedSearch->SearchValue = implode(",", $this->t_08->AdvancedSearch->SearchValue);
		if (is_array($this->t_08->AdvancedSearch->SearchValue2))
			$this->t_08->AdvancedSearch->SearchValue2 = implode(",", $this->t_08->AdvancedSearch->SearchValue2);

		// t_09
		if (!$this->isAddOrEdit())
			$this->t_09->AdvancedSearch->setSearchValue(Get("x_t_09", Get("t_09", "")));
		if ($this->t_09->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_09->AdvancedSearch->setSearchOperator(Get("z_t_09", ""));
		if (is_array($this->t_09->AdvancedSearch->SearchValue))
			$this->t_09->AdvancedSearch->SearchValue = implode(",", $this->t_09->AdvancedSearch->SearchValue);
		if (is_array($this->t_09->AdvancedSearch->SearchValue2))
			$this->t_09->AdvancedSearch->SearchValue2 = implode(",", $this->t_09->AdvancedSearch->SearchValue2);

		// t_10
		if (!$this->isAddOrEdit())
			$this->t_10->AdvancedSearch->setSearchValue(Get("x_t_10", Get("t_10", "")));
		if ($this->t_10->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_10->AdvancedSearch->setSearchOperator(Get("z_t_10", ""));
		if (is_array($this->t_10->AdvancedSearch->SearchValue))
			$this->t_10->AdvancedSearch->SearchValue = implode(",", $this->t_10->AdvancedSearch->SearchValue);
		if (is_array($this->t_10->AdvancedSearch->SearchValue2))
			$this->t_10->AdvancedSearch->SearchValue2 = implode(",", $this->t_10->AdvancedSearch->SearchValue2);

		// t_11
		if (!$this->isAddOrEdit())
			$this->t_11->AdvancedSearch->setSearchValue(Get("x_t_11", Get("t_11", "")));
		if ($this->t_11->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_11->AdvancedSearch->setSearchOperator(Get("z_t_11", ""));

		// t_12
		if (!$this->isAddOrEdit())
			$this->t_12->AdvancedSearch->setSearchValue(Get("x_t_12", Get("t_12", "")));
		if ($this->t_12->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_12->AdvancedSearch->setSearchOperator(Get("z_t_12", ""));

		// t_13
		if (!$this->isAddOrEdit())
			$this->t_13->AdvancedSearch->setSearchValue(Get("x_t_13", Get("t_13", "")));
		if ($this->t_13->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_13->AdvancedSearch->setSearchOperator(Get("z_t_13", ""));

		// t_14
		if (!$this->isAddOrEdit())
			$this->t_14->AdvancedSearch->setSearchValue(Get("x_t_14", Get("t_14", "")));
		if ($this->t_14->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_14->AdvancedSearch->setSearchOperator(Get("z_t_14", ""));

		// t_15
		if (!$this->isAddOrEdit())
			$this->t_15->AdvancedSearch->setSearchValue(Get("x_t_15", Get("t_15", "")));
		if ($this->t_15->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->t_15->AdvancedSearch->setSearchOperator(Get("z_t_15", ""));

		// d_head_01
		if (!$this->isAddOrEdit())
			$this->d_head_01->AdvancedSearch->setSearchValue(Get("x_d_head_01", Get("d_head_01", "")));
		if ($this->d_head_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_head_01->AdvancedSearch->setSearchOperator(Get("z_d_head_01", ""));

		// d_description_01
		if (!$this->isAddOrEdit())
			$this->d_description_01->AdvancedSearch->setSearchValue(Get("x_d_description_01", Get("d_description_01", "")));
		if ($this->d_description_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_description_01->AdvancedSearch->setSearchOperator(Get("z_d_description_01", ""));

		// d_head_02
		if (!$this->isAddOrEdit())
			$this->d_head_02->AdvancedSearch->setSearchValue(Get("x_d_head_02", Get("d_head_02", "")));
		if ($this->d_head_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_head_02->AdvancedSearch->setSearchOperator(Get("z_d_head_02", ""));

		// d_description_02
		if (!$this->isAddOrEdit())
			$this->d_description_02->AdvancedSearch->setSearchValue(Get("x_d_description_02", Get("d_description_02", "")));
		if ($this->d_description_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->d_description_02->AdvancedSearch->setSearchOperator(Get("z_d_description_02", ""));

		// main_image
		if (!$this->isAddOrEdit())
			$this->main_image->AdvancedSearch->setSearchValue(Get("x_main_image", Get("main_image", "")));
		if ($this->main_image->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->main_image->AdvancedSearch->setSearchOperator(Get("z_main_image", ""));

		// top_view
		if (!$this->isAddOrEdit())
			$this->top_view->AdvancedSearch->setSearchValue(Get("x_top_view", Get("top_view", "")));
		if ($this->top_view->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->top_view->AdvancedSearch->setSearchOperator(Get("z_top_view", ""));

		// front_view
		if (!$this->isAddOrEdit())
			$this->front_view->AdvancedSearch->setSearchValue(Get("x_front_view", Get("front_view", "")));
		if ($this->front_view->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->front_view->AdvancedSearch->setSearchOperator(Get("z_front_view", ""));

		// corner_view
		if (!$this->isAddOrEdit())
			$this->corner_view->AdvancedSearch->setSearchValue(Get("x_corner_view", Get("corner_view", "")));
		if ($this->corner_view->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->corner_view->AdvancedSearch->setSearchOperator(Get("z_corner_view", ""));

		// back_view
		if (!$this->isAddOrEdit())
			$this->back_view->AdvancedSearch->setSearchValue(Get("x_back_view", Get("back_view", "")));
		if ($this->back_view->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->back_view->AdvancedSearch->setSearchOperator(Get("z_back_view", ""));

		// color_options
		if (!$this->isAddOrEdit())
			$this->color_options->AdvancedSearch->setSearchValue(Get("x_color_options", Get("color_options", "")));
		if ($this->color_options->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->color_options->AdvancedSearch->setSearchOperator(Get("z_color_options", ""));

		// other_options
		if (!$this->isAddOrEdit())
			$this->other_options->AdvancedSearch->setSearchValue(Get("x_other_options", Get("other_options", "")));
		if ($this->other_options->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->other_options->AdvancedSearch->setSearchOperator(Get("z_other_options", ""));

		// image
		if (!$this->isAddOrEdit())
			$this->image->AdvancedSearch->setSearchValue(Get("x_image", Get("image", "")));
		if ($this->image->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->image->AdvancedSearch->setSearchOperator(Get("z_image", ""));

		// video_url
		if (!$this->isAddOrEdit())
			$this->video_url->AdvancedSearch->setSearchValue(Get("x_video_url", Get("video_url", "")));
		if ($this->video_url->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->video_url->AdvancedSearch->setSearchOperator(Get("z_video_url", ""));

		// currency
		if (!$this->isAddOrEdit())
			$this->currency->AdvancedSearch->setSearchValue(Get("x_currency", Get("currency", "")));
		if ($this->currency->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->currency->AdvancedSearch->setSearchOperator(Get("z_currency", ""));

		// hsn
		if (!$this->isAddOrEdit())
			$this->hsn->AdvancedSearch->setSearchValue(Get("x_hsn", Get("hsn", "")));
		if ($this->hsn->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->hsn->AdvancedSearch->setSearchOperator(Get("z_hsn", ""));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue(Get("x_status", Get("status", "")));
		if ($this->status->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->status->AdvancedSearch->setSearchOperator(Get("z_status", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));
		$this->datetime->AdvancedSearch->setSearchCondition(Get("v_datetime", ""));
		$this->datetime->AdvancedSearch->setSearchValue2(Get("y_datetime", ""));
		if ($this->datetime->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator2(Get("w_datetime", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->oid->setDbValue($row['oid']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->company_id->setDbValue($row['company_id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->product_n->setDbValue($row['product_n']);
		$this->product_type->setDbValue($row['product_type']);
		$this->product_code->setDbValue($row['product_code']);
		$this->gcode->setDbValue($row['gcode']);
		$this->code->setDbValue($row['code']);
		$this->product_id->setDbValue($row['product_id']);
		$this->print_name->setDbValue($row['print_name']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->last_price->setDbValue($row['last_price']);
		$this->v_01->setDbValue($row['v_01']);
		$this->v_02->setDbValue($row['v_02']);
		$this->v_03->setDbValue($row['v_03']);
		$this->v_04->setDbValue($row['v_04']);
		$this->v_05->setDbValue($row['v_05']);
		$this->v_06->setDbValue($row['v_06']);
		$this->v_07->setDbValue($row['v_07']);
		$this->v_08->setDbValue($row['v_08']);
		$this->v_09->setDbValue($row['v_09']);
		$this->v_10->setDbValue($row['v_10']);
		$this->cbm->setDbValue($row['cbm']);
		$this->sqm->setDbValue($row['sqm']);
		$this->shape->setDbValue($row['shape']);
		$this->b_01->setDbValue($row['b_01']);
		$this->b_02->setDbValue($row['b_02']);
		$this->b_03->setDbValue($row['b_03']);
		$this->b_04->setDbValue($row['b_04']);
		$this->b_05->setDbValue($row['b_05']);
		$this->b_06->setDbValue($row['b_06']);
		$this->b_07->setDbValue($row['b_07']);
		$this->b_08->setDbValue($row['b_08']);
		$this->b_09->setDbValue($row['b_09']);
		$this->b_10->setDbValue($row['b_10']);
		$this->b_11->setDbValue($row['b_11']);
		$this->b_12->setDbValue($row['b_12']);
		$this->b_13->setDbValue($row['b_13']);
		$this->b_14->setDbValue($row['b_14']);
		$this->b_15->setDbValue($row['b_15']);
		$this->t_01->setDbValue($row['t_01']);
		$this->t_02->setDbValue($row['t_02']);
		$this->t_03->setDbValue($row['t_03']);
		$this->t_04->setDbValue($row['t_04']);
		$this->t_05->setDbValue($row['t_05']);
		$this->t_06->setDbValue($row['t_06']);
		$this->t_07->setDbValue($row['t_07']);
		$this->t_08->setDbValue($row['t_08']);
		$this->t_09->setDbValue($row['t_09']);
		$this->t_10->setDbValue($row['t_10']);
		$this->t_11->setDbValue($row['t_11']);
		$this->t_12->setDbValue($row['t_12']);
		$this->t_13->setDbValue($row['t_13']);
		$this->t_14->setDbValue($row['t_14']);
		$this->t_15->setDbValue($row['t_15']);
		$this->d_head_01->setDbValue($row['d_head_01']);
		$this->d_description_01->setDbValue($row['d_description_01']);
		$this->d_head_02->setDbValue($row['d_head_02']);
		$this->d_description_02->setDbValue($row['d_description_02']);
		$this->main_image->Upload->DbValue = $row['main_image'];
		$this->main_image->setDbValue($this->main_image->Upload->DbValue);
		$this->top_view->Upload->DbValue = $row['top_view'];
		$this->top_view->setDbValue($this->top_view->Upload->DbValue);
		$this->front_view->Upload->DbValue = $row['front_view'];
		$this->front_view->setDbValue($this->front_view->Upload->DbValue);
		$this->corner_view->Upload->DbValue = $row['corner_view'];
		$this->corner_view->setDbValue($this->corner_view->Upload->DbValue);
		$this->back_view->Upload->DbValue = $row['back_view'];
		$this->back_view->setDbValue($this->back_view->Upload->DbValue);
		$this->color_options->Upload->DbValue = $row['color_options'];
		$this->color_options->setDbValue($this->color_options->Upload->DbValue);
		$this->other_options->Upload->DbValue = $row['other_options'];
		$this->other_options->setDbValue($this->other_options->Upload->DbValue);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->video_url->setDbValue($row['video_url']);
		$this->currency->setDbValue($row['currency']);
		$this->hsn->setDbValue($row['hsn']);
		$this->minimum_stock->setDbValue($row['minimum_stock']);
		$this->in->setDbValue($row['in']);
		$this->out->setDbValue($row['out']);
		$this->required->setDbValue($row['required']);
		$this->blocked->setDbValue($row['blocked']);
		$this->ordered->setDbValue($row['ordered']);
		$this->status->setDbValue($row['status']);
		$this->publish->setDbValue($row['publish']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['oid'] = NULL;
		$row['barcode'] = NULL;
		$row['company_id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['product_n'] = NULL;
		$row['product_type'] = NULL;
		$row['product_code'] = NULL;
		$row['gcode'] = NULL;
		$row['code'] = NULL;
		$row['product_id'] = NULL;
		$row['print_name'] = NULL;
		$row['batch_no'] = NULL;
		$row['last_price'] = NULL;
		$row['v_01'] = NULL;
		$row['v_02'] = NULL;
		$row['v_03'] = NULL;
		$row['v_04'] = NULL;
		$row['v_05'] = NULL;
		$row['v_06'] = NULL;
		$row['v_07'] = NULL;
		$row['v_08'] = NULL;
		$row['v_09'] = NULL;
		$row['v_10'] = NULL;
		$row['cbm'] = NULL;
		$row['sqm'] = NULL;
		$row['shape'] = NULL;
		$row['b_01'] = NULL;
		$row['b_02'] = NULL;
		$row['b_03'] = NULL;
		$row['b_04'] = NULL;
		$row['b_05'] = NULL;
		$row['b_06'] = NULL;
		$row['b_07'] = NULL;
		$row['b_08'] = NULL;
		$row['b_09'] = NULL;
		$row['b_10'] = NULL;
		$row['b_11'] = NULL;
		$row['b_12'] = NULL;
		$row['b_13'] = NULL;
		$row['b_14'] = NULL;
		$row['b_15'] = NULL;
		$row['t_01'] = NULL;
		$row['t_02'] = NULL;
		$row['t_03'] = NULL;
		$row['t_04'] = NULL;
		$row['t_05'] = NULL;
		$row['t_06'] = NULL;
		$row['t_07'] = NULL;
		$row['t_08'] = NULL;
		$row['t_09'] = NULL;
		$row['t_10'] = NULL;
		$row['t_11'] = NULL;
		$row['t_12'] = NULL;
		$row['t_13'] = NULL;
		$row['t_14'] = NULL;
		$row['t_15'] = NULL;
		$row['d_head_01'] = NULL;
		$row['d_description_01'] = NULL;
		$row['d_head_02'] = NULL;
		$row['d_description_02'] = NULL;
		$row['main_image'] = NULL;
		$row['top_view'] = NULL;
		$row['front_view'] = NULL;
		$row['corner_view'] = NULL;
		$row['back_view'] = NULL;
		$row['color_options'] = NULL;
		$row['other_options'] = NULL;
		$row['image'] = NULL;
		$row['video_url'] = NULL;
		$row['currency'] = NULL;
		$row['hsn'] = NULL;
		$row['minimum_stock'] = NULL;
		$row['in'] = NULL;
		$row['out'] = NULL;
		$row['required'] = NULL;
		$row['blocked'] = NULL;
		$row['ordered'] = NULL;
		$row['status'] = NULL;
		$row['publish'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// oid

		$this->oid->CellCssStyle = "white-space: nowrap;";

		// barcode
		$this->_barcode->CellCssStyle = "white-space: nowrap;";

		// company_id
		// grp
		// s_grp
		// product
		// product_n
		// product_type
		// product_code

		$this->product_code->CellCssStyle = "white-space: nowrap;";

		// gcode
		$this->gcode->CellCssStyle = "white-space: nowrap;";

		// code
		$this->code->CellCssStyle = "white-space: nowrap;";

		// product_id
		$this->product_id->CellCssStyle = "white-space: nowrap;";

		// print_name
		$this->print_name->CellCssStyle = "white-space: nowrap;";

		// batch_no
		$this->batch_no->CellCssStyle = "white-space: nowrap;";

		// last_price
		// v_01
		// v_02
		// v_03
		// v_04
		// v_05
		// v_06
		// v_07
		// v_08
		// v_09
		// v_10
		// cbm
		// sqm
		// shape
		// b_01
		// b_02
		// b_03
		// b_04
		// b_05
		// b_06
		// b_07
		// b_08
		// b_09
		// b_10
		// b_11
		// b_12
		// b_13
		// b_14
		// b_15
		// t_01
		// t_02
		// t_03
		// t_04
		// t_05
		// t_06
		// t_07
		// t_08
		// t_09
		// t_10
		// t_11
		// t_12
		// t_13
		// t_14
		// t_15
		// d_head_01
		// d_description_01
		// d_head_02
		// d_description_02
		// main_image
		// top_view
		// front_view
		// corner_view
		// back_view
		// color_options
		// other_options
		// image
		// video_url
		// currency
		// hsn
		// minimum_stock

		$this->minimum_stock->CellCssStyle = "white-space: nowrap;";

		// in
		$this->in->CellCssStyle = "white-space: nowrap;";

		// out
		$this->out->CellCssStyle = "white-space: nowrap;";

		// required
		$this->required->CellCssStyle = "white-space: nowrap;";

		// blocked
		$this->blocked->CellCssStyle = "white-space: nowrap;";

		// ordered
		$this->ordered->CellCssStyle = "white-space: nowrap;";

		// status
		// publish
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `id` > 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 200000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_n
			$this->product_n->ViewValue = $this->product_n->CurrentValue;
			$this->product_n->ViewCustomAttributes = "";

			// product_type
			$this->product_type->ViewValue = $this->product_type->CurrentValue;
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` = 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// last_price
			$this->last_price->ViewValue = $this->last_price->CurrentValue;
			$this->last_price->ViewCustomAttributes = "";

			// v_01
			$curVal = strval($this->v_01->CurrentValue);
			if ($curVal <> "") {
				$this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
				if ($this->v_01->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_01->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_01->ViewValue->add($this->v_01->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_01->ViewValue = $this->v_01->CurrentValue;
					}
				}
			} else {
				$this->v_01->ViewValue = NULL;
			}
			$this->v_01->ViewCustomAttributes = "";

			// v_02
			$curVal = strval($this->v_02->CurrentValue);
			if ($curVal <> "") {
				$this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
				if ($this->v_02->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_02->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_02->ViewValue->add($this->v_02->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_02->ViewValue = $this->v_02->CurrentValue;
					}
				}
			} else {
				$this->v_02->ViewValue = NULL;
			}
			$this->v_02->ViewCustomAttributes = "";

			// v_03
			$curVal = strval($this->v_03->CurrentValue);
			if ($curVal <> "") {
				$this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
				if ($this->v_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_03->ViewValue->add($this->v_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_03->ViewValue = $this->v_03->CurrentValue;
					}
				}
			} else {
				$this->v_03->ViewValue = NULL;
			}
			$this->v_03->ViewCustomAttributes = "";

			// v_04
			$curVal = strval($this->v_04->CurrentValue);
			if ($curVal <> "") {
				$this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
				if ($this->v_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_04->ViewValue->add($this->v_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_04->ViewValue = $this->v_04->CurrentValue;
					}
				}
			} else {
				$this->v_04->ViewValue = NULL;
			}
			$this->v_04->ViewCustomAttributes = "";

			// v_05
			$curVal = strval($this->v_05->CurrentValue);
			if ($curVal <> "") {
				$this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
				if ($this->v_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_05->ViewValue->add($this->v_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_05->ViewValue = $this->v_05->CurrentValue;
					}
				}
			} else {
				$this->v_05->ViewValue = NULL;
			}
			$this->v_05->ViewCustomAttributes = "";

			// v_06
			$curVal = strval($this->v_06->CurrentValue);
			if ($curVal <> "") {
				$this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
				if ($this->v_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 106 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_06->ViewValue->add($this->v_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_06->ViewValue = $this->v_06->CurrentValue;
					}
				}
			} else {
				$this->v_06->ViewValue = NULL;
			}
			$this->v_06->ViewCustomAttributes = "";

			// v_07
			$curVal = strval($this->v_07->CurrentValue);
			if ($curVal <> "") {
				$this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
				if ($this->v_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 107 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_07->ViewValue->add($this->v_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_07->ViewValue = $this->v_07->CurrentValue;
					}
				}
			} else {
				$this->v_07->ViewValue = NULL;
			}
			$this->v_07->ViewCustomAttributes = "";

			// v_08
			$curVal = strval($this->v_08->CurrentValue);
			if ($curVal <> "") {
				$this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
				if ($this->v_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 108 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_08->ViewValue->add($this->v_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_08->ViewValue = $this->v_08->CurrentValue;
					}
				}
			} else {
				$this->v_08->ViewValue = NULL;
			}
			$this->v_08->ViewCustomAttributes = "";

			// v_09
			$curVal = strval($this->v_09->CurrentValue);
			if ($curVal <> "") {
				$this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
				if ($this->v_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 109 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_09->ViewValue->add($this->v_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_09->ViewValue = $this->v_09->CurrentValue;
					}
				}
			} else {
				$this->v_09->ViewValue = NULL;
			}
			$this->v_09->ViewCustomAttributes = "";

			// v_10
			$curVal = strval($this->v_10->CurrentValue);
			if ($curVal <> "") {
				$this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
				if ($this->v_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 110 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_10->ViewValue->add($this->v_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_10->ViewValue = $this->v_10->CurrentValue;
					}
				}
			} else {
				$this->v_10->ViewValue = NULL;
			}
			$this->v_10->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->shape->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->shape->ViewValue->add($this->shape->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// b_01
			$this->b_01->ViewValue = $this->b_01->CurrentValue;
			$this->b_01->ViewCustomAttributes = "";

			// b_02
			$this->b_02->ViewValue = $this->b_02->CurrentValue;
			$this->b_02->ViewCustomAttributes = "";

			// b_03
			$curVal = strval($this->b_03->CurrentValue);
			if ($curVal <> "") {
				$this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
				if ($this->b_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 203 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_03->ViewValue = $this->b_03->CurrentValue;
					}
				}
			} else {
				$this->b_03->ViewValue = NULL;
			}
			$this->b_03->ViewCustomAttributes = "";

			// b_04
			$curVal = strval($this->b_04->CurrentValue);
			if ($curVal <> "") {
				$this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
				if ($this->b_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 204 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_04->ViewValue = $this->b_04->CurrentValue;
					}
				}
			} else {
				$this->b_04->ViewValue = NULL;
			}
			$this->b_04->ViewCustomAttributes = "";

			// b_05
			$curVal = strval($this->b_05->CurrentValue);
			if ($curVal <> "") {
				$this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
				if ($this->b_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 205 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_05->ViewValue = $this->b_05->CurrentValue;
					}
				}
			} else {
				$this->b_05->ViewValue = NULL;
			}
			$this->b_05->ViewCustomAttributes = "";

			// b_06
			$curVal = strval($this->b_06->CurrentValue);
			if ($curVal <> "") {
				$this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
				if ($this->b_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 206 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_06->ViewValue = $this->b_06->CurrentValue;
					}
				}
			} else {
				$this->b_06->ViewValue = NULL;
			}
			$this->b_06->ViewCustomAttributes = "";

			// b_07
			$curVal = strval($this->b_07->CurrentValue);
			if ($curVal <> "") {
				$this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
				if ($this->b_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 207 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_07->ViewValue = $this->b_07->CurrentValue;
					}
				}
			} else {
				$this->b_07->ViewValue = NULL;
			}
			$this->b_07->ViewCustomAttributes = "";

			// b_08
			$curVal = strval($this->b_08->CurrentValue);
			if ($curVal <> "") {
				$this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
				if ($this->b_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 208 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_08->ViewValue = $this->b_08->CurrentValue;
					}
				}
			} else {
				$this->b_08->ViewValue = NULL;
			}
			$this->b_08->ViewCustomAttributes = "";

			// b_09
			$curVal = strval($this->b_09->CurrentValue);
			if ($curVal <> "") {
				$this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
				if ($this->b_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 209 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_09->ViewValue = $this->b_09->CurrentValue;
					}
				}
			} else {
				$this->b_09->ViewValue = NULL;
			}
			$this->b_09->ViewCustomAttributes = "";

			// b_10
			$curVal = strval($this->b_10->CurrentValue);
			if ($curVal <> "") {
				$this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
				if ($this->b_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 210 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_10->ViewValue = $this->b_10->CurrentValue;
					}
				}
			} else {
				$this->b_10->ViewValue = NULL;
			}
			$this->b_10->ViewCustomAttributes = "";

			// b_11
			$this->b_11->ViewValue = $this->b_11->CurrentValue;
			$this->b_11->ViewCustomAttributes = "";

			// b_12
			$this->b_12->ViewValue = $this->b_12->CurrentValue;
			$this->b_12->ViewCustomAttributes = "";

			// b_13
			$this->b_13->ViewValue = $this->b_13->CurrentValue;
			$this->b_13->ViewCustomAttributes = "";

			// b_14
			$this->b_14->ViewValue = $this->b_14->CurrentValue;
			$this->b_14->ViewCustomAttributes = "";

			// b_15
			$this->b_15->ViewCustomAttributes = "";

			// t_01
			$this->t_01->ViewValue = $this->t_01->CurrentValue;
			$this->t_01->ViewCustomAttributes = "";

			// t_02
			$this->t_02->ViewValue = $this->t_02->CurrentValue;
			$this->t_02->ViewCustomAttributes = "";

			// t_03
			$curVal = strval($this->t_03->CurrentValue);
			if ($curVal <> "") {
				$this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
				if ($this->t_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 303 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_03->ViewValue = $this->t_03->CurrentValue;
					}
				}
			} else {
				$this->t_03->ViewValue = NULL;
			}
			$this->t_03->ViewCustomAttributes = "";

			// t_04
			$curVal = strval($this->t_04->CurrentValue);
			if ($curVal <> "") {
				$this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
				if ($this->t_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 304 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_04->ViewValue = $this->t_04->CurrentValue;
					}
				}
			} else {
				$this->t_04->ViewValue = NULL;
			}
			$this->t_04->ViewCustomAttributes = "";

			// t_05
			$curVal = strval($this->t_05->CurrentValue);
			if ($curVal <> "") {
				$this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
				if ($this->t_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 305 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_05->ViewValue = $this->t_05->CurrentValue;
					}
				}
			} else {
				$this->t_05->ViewValue = NULL;
			}
			$this->t_05->ViewCustomAttributes = "";

			// t_06
			$curVal = strval($this->t_06->CurrentValue);
			if ($curVal <> "") {
				$this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
				if ($this->t_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 306 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_06->ViewValue = $this->t_06->CurrentValue;
					}
				}
			} else {
				$this->t_06->ViewValue = NULL;
			}
			$this->t_06->ViewCustomAttributes = "";

			// t_07
			$curVal = strval($this->t_07->CurrentValue);
			if ($curVal <> "") {
				$this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
				if ($this->t_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 307 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_07->ViewValue = $this->t_07->CurrentValue;
					}
				}
			} else {
				$this->t_07->ViewValue = NULL;
			}
			$this->t_07->ViewCustomAttributes = "";

			// t_08
			$curVal = strval($this->t_08->CurrentValue);
			if ($curVal <> "") {
				$this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
				if ($this->t_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 308 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_08->ViewValue = $this->t_08->CurrentValue;
					}
				}
			} else {
				$this->t_08->ViewValue = NULL;
			}
			$this->t_08->ViewCustomAttributes = "";

			// t_09
			$curVal = strval($this->t_09->CurrentValue);
			if ($curVal <> "") {
				$this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
				if ($this->t_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 309 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_09->ViewValue = $this->t_09->CurrentValue;
					}
				}
			} else {
				$this->t_09->ViewValue = NULL;
			}
			$this->t_09->ViewCustomAttributes = "";

			// t_10
			$curVal = strval($this->t_10->CurrentValue);
			if ($curVal <> "") {
				$this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
				if ($this->t_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 310 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_10->ViewValue = $this->t_10->CurrentValue;
					}
				}
			} else {
				$this->t_10->ViewValue = NULL;
			}
			$this->t_10->ViewCustomAttributes = "";

			// t_11
			$this->t_11->ViewValue = $this->t_11->CurrentValue;
			$curVal = strval($this->t_11->CurrentValue);
			if ($curVal <> "") {
				$this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
				if ($this->t_11->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_11->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_11->ViewValue = $this->t_11->CurrentValue;
					}
				}
			} else {
				$this->t_11->ViewValue = NULL;
			}
			$this->t_11->ViewCustomAttributes = "";

			// t_12
			$this->t_12->ViewValue = $this->t_12->CurrentValue;
			$curVal = strval($this->t_12->CurrentValue);
			if ($curVal <> "") {
				$this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
				if ($this->t_12->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_12->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_12->ViewValue = $this->t_12->CurrentValue;
					}
				}
			} else {
				$this->t_12->ViewValue = NULL;
			}
			$this->t_12->ViewCustomAttributes = "";

			// t_13
			$this->t_13->ViewValue = $this->t_13->CurrentValue;
			$this->t_13->ViewCustomAttributes = "";

			// t_14
			$this->t_14->ViewValue = $this->t_14->CurrentValue;
			$this->t_14->ViewCustomAttributes = "";

			// t_15
			$this->t_15->ViewValue = $this->t_15->CurrentValue;
			$this->t_15->ViewCustomAttributes = "";

			// d_head_01
			$this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;
			$this->d_head_01->ViewCustomAttributes = "";

			// d_description_01
			$this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;
			$this->d_description_01->ViewCustomAttributes = "";

			// d_head_02
			$this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;
			$this->d_head_02->ViewCustomAttributes = "";

			// d_description_02
			$this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;
			$this->d_description_02->ViewCustomAttributes = "";

			// main_image
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->ImageWidth = 0;
				$this->main_image->ImageHeight = 40;
				$this->main_image->ImageAlt = $this->main_image->alt();
				$this->main_image->ViewValue = $this->main_image->Upload->DbValue;
			} else {
				$this->main_image->ViewValue = "";
			}
			$this->main_image->ViewCustomAttributes = "";

			// top_view
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->ImageWidth = 0;
				$this->top_view->ImageHeight = 40;
				$this->top_view->ImageAlt = $this->top_view->alt();
				$this->top_view->ViewValue = $this->top_view->Upload->DbValue;
			} else {
				$this->top_view->ViewValue = "";
			}
			$this->top_view->ViewCustomAttributes = "";

			// front_view
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->ImageWidth = 0;
				$this->front_view->ImageHeight = 40;
				$this->front_view->ImageAlt = $this->front_view->alt();
				$this->front_view->ViewValue = $this->front_view->Upload->DbValue;
			} else {
				$this->front_view->ViewValue = "";
			}
			$this->front_view->ViewCustomAttributes = "";

			// corner_view
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->ImageWidth = 0;
				$this->corner_view->ImageHeight = 40;
				$this->corner_view->ImageAlt = $this->corner_view->alt();
				$this->corner_view->ViewValue = $this->corner_view->Upload->DbValue;
			} else {
				$this->corner_view->ViewValue = "";
			}
			$this->corner_view->ViewCustomAttributes = "";

			// back_view
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->ImageWidth = 0;
				$this->back_view->ImageHeight = 40;
				$this->back_view->ImageAlt = $this->back_view->alt();
				$this->back_view->ViewValue = $this->back_view->Upload->DbValue;
			} else {
				$this->back_view->ViewValue = "";
			}
			$this->back_view->ViewCustomAttributes = "";

			// color_options
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->ImageWidth = 0;
				$this->color_options->ImageHeight = 40;
				$this->color_options->ImageAlt = $this->color_options->alt();
				$this->color_options->ViewValue = $this->color_options->Upload->DbValue;
			} else {
				$this->color_options->ViewValue = "";
			}
			$this->color_options->ViewCustomAttributes = "";

			// other_options
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->ImageWidth = 0;
				$this->other_options->ImageHeight = 40;
				$this->other_options->ImageAlt = $this->other_options->alt();
				$this->other_options->ViewValue = $this->other_options->Upload->DbValue;
			} else {
				$this->other_options->ViewValue = "";
			}
			$this->other_options->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// video_url
			$this->video_url->ViewValue = $this->video_url->CurrentValue;
			$this->video_url->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// hsn
			$curVal = strval($this->hsn->CurrentValue);
			if ($curVal <> "") {
				$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
				if ($this->hsn->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->hsn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->hsn->ViewValue = $this->hsn->CurrentValue;
					}
				}
			} else {
				$this->hsn->ViewValue = NULL;
			}
			$this->hsn->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// publish
			if (strval($this->publish->CurrentValue) <> "") {
				$this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
			} else {
				$this->publish->ViewValue = NULL;
			}
			$this->publish->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? "`status` = 1 and `id` > 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 200000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->product_type->AdvancedSearch->SearchValue = HtmlDecode($this->product_type->AdvancedSearch->SearchValue);
			$this->product_type->EditValue = HtmlEncode($this->product_type->AdvancedSearch->SearchValue);
			$curVal = strval($this->product_type->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->product_type->EditValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` = 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->product_type->EditValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->EditValue = HtmlEncode($this->product_type->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->product_type->EditValue = NULL;
			}
			$this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->product_n->AdvancedSearch->load();
		$this->product_type->AdvancedSearch->load();
		$this->last_price->AdvancedSearch->load();
		$this->v_01->AdvancedSearch->load();
		$this->v_02->AdvancedSearch->load();
		$this->v_03->AdvancedSearch->load();
		$this->v_04->AdvancedSearch->load();
		$this->v_05->AdvancedSearch->load();
		$this->v_06->AdvancedSearch->load();
		$this->v_07->AdvancedSearch->load();
		$this->v_08->AdvancedSearch->load();
		$this->v_09->AdvancedSearch->load();
		$this->v_10->AdvancedSearch->load();
		$this->b_01->AdvancedSearch->load();
		$this->b_02->AdvancedSearch->load();
		$this->b_03->AdvancedSearch->load();
		$this->b_04->AdvancedSearch->load();
		$this->b_05->AdvancedSearch->load();
		$this->b_06->AdvancedSearch->load();
		$this->b_07->AdvancedSearch->load();
		$this->b_08->AdvancedSearch->load();
		$this->b_09->AdvancedSearch->load();
		$this->b_10->AdvancedSearch->load();
		$this->b_11->AdvancedSearch->load();
		$this->b_12->AdvancedSearch->load();
		$this->b_13->AdvancedSearch->load();
		$this->b_14->AdvancedSearch->load();
		$this->b_15->AdvancedSearch->load();
		$this->t_01->AdvancedSearch->load();
		$this->t_02->AdvancedSearch->load();
		$this->t_03->AdvancedSearch->load();
		$this->t_04->AdvancedSearch->load();
		$this->t_05->AdvancedSearch->load();
		$this->t_06->AdvancedSearch->load();
		$this->t_07->AdvancedSearch->load();
		$this->t_08->AdvancedSearch->load();
		$this->t_09->AdvancedSearch->load();
		$this->t_10->AdvancedSearch->load();
		$this->t_11->AdvancedSearch->load();
		$this->t_12->AdvancedSearch->load();
		$this->t_13->AdvancedSearch->load();
		$this->t_14->AdvancedSearch->load();
		$this->t_15->AdvancedSearch->load();
		$this->d_head_01->AdvancedSearch->load();
		$this->d_description_01->AdvancedSearch->load();
		$this->d_head_02->AdvancedSearch->load();
		$this->d_description_02->AdvancedSearch->load();
		$this->main_image->AdvancedSearch->load();
		$this->top_view->AdvancedSearch->load();
		$this->front_view->AdvancedSearch->load();
		$this->corner_view->AdvancedSearch->load();
		$this->back_view->AdvancedSearch->load();
		$this->color_options->AdvancedSearch->load();
		$this->other_options->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
		$this->video_url->AdvancedSearch->load();
		$this->currency->AdvancedSearch->load();
		$this->hsn->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fref_multilist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fref_multilist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fref_multilist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_ref_multi\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_ref_multi',hdr:ew.language.phrase('ExportToEmailText'),f:document.fref_multilist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `id` > 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 200000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1 and `id` = 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_01":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_02":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 106 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 107 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 108 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 109 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 110 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 203 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 204 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 205 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 206 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 207 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 208 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 209 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 210 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 303 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 304 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 305 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 306 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 307 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 308 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 309 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 310 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_11":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_12":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_hsn":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_product_type":
							break;
						case "x_v_01":
							break;
						case "x_v_02":
							break;
						case "x_v_03":
							break;
						case "x_v_04":
							break;
						case "x_v_05":
							break;
						case "x_v_06":
							break;
						case "x_v_07":
							break;
						case "x_v_08":
							break;
						case "x_v_09":
							break;
						case "x_v_10":
							break;
						case "x_shape":
							break;
						case "x_b_03":
							break;
						case "x_b_04":
							break;
						case "x_b_05":
							break;
						case "x_b_06":
							break;
						case "x_b_07":
							break;
						case "x_b_08":
							break;
						case "x_b_09":
							break;
						case "x_b_10":
							break;
						case "x_t_03":
							break;
						case "x_t_04":
							break;
						case "x_t_05":
							break;
						case "x_t_06":
							break;
						case "x_t_07":
							break;
						case "x_t_08":
							break;
						case "x_t_09":
							break;
						case "x_t_10":
							break;
						case "x_t_11":
							break;
						case "x_t_12":
							break;
						case "x_currency":
							break;
						case "x_hsn":
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'ref_multi');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";
		//$this->ListOptions->Items["new"]->Body = "xxx";

		$this->ListOptions->Add("Print"); 
		$this->ListOptions->Items["Print"]->Body =
			'<a href="print_pd.php?rid=' . $this->id->CurrentValue . '" data-original-title ="Print"><i data-phrase="Print"  class="fa fa-print ew-icon" ></i></a>';
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>