<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class ref_multi_search extends ref_multi
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'ref_multi';

	// Page object name
	public $PageObjName = "ref_multi_search";

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (ref_multi)
		if (!isset($GLOBALS["ref_multi"]) || get_class($GLOBALS["ref_multi"]) == PROJECT_NAMESPACE . "ref_multi") {
			$GLOBALS["ref_multi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ref_multi"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref_multi');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $ref_multi;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($ref_multi);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "ref_multiview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("ref_multilist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->oid->Visible = FALSE;
		$this->_barcode->Visible = FALSE;
		$this->company_id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->product_n->setVisibility();
		$this->product_type->setVisibility();
		$this->product_code->Visible = FALSE;
		$this->gcode->Visible = FALSE;
		$this->code->Visible = FALSE;
		$this->product_id->Visible = FALSE;
		$this->print_name->Visible = FALSE;
		$this->batch_no->Visible = FALSE;
		$this->last_price->setVisibility();
		$this->v_01->setVisibility();
		$this->v_02->setVisibility();
		$this->v_03->setVisibility();
		$this->v_04->setVisibility();
		$this->v_05->setVisibility();
		$this->v_06->setVisibility();
		$this->v_07->setVisibility();
		$this->v_08->setVisibility();
		$this->v_09->setVisibility();
		$this->v_10->setVisibility();
		$this->cbm->Visible = FALSE;
		$this->sqm->Visible = FALSE;
		$this->shape->Visible = FALSE;
		$this->b_01->setVisibility();
		$this->b_02->setVisibility();
		$this->b_03->setVisibility();
		$this->b_04->setVisibility();
		$this->b_05->setVisibility();
		$this->b_06->setVisibility();
		$this->b_07->setVisibility();
		$this->b_08->setVisibility();
		$this->b_09->setVisibility();
		$this->b_10->setVisibility();
		$this->b_11->setVisibility();
		$this->b_12->setVisibility();
		$this->b_13->setVisibility();
		$this->b_14->setVisibility();
		$this->b_15->setVisibility();
		$this->t_01->setVisibility();
		$this->t_02->setVisibility();
		$this->t_03->setVisibility();
		$this->t_04->setVisibility();
		$this->t_05->setVisibility();
		$this->t_06->setVisibility();
		$this->t_07->setVisibility();
		$this->t_08->setVisibility();
		$this->t_09->setVisibility();
		$this->t_10->setVisibility();
		$this->t_11->setVisibility();
		$this->t_12->setVisibility();
		$this->t_13->setVisibility();
		$this->t_14->setVisibility();
		$this->t_15->setVisibility();
		$this->d_head_01->setVisibility();
		$this->d_description_01->setVisibility();
		$this->d_head_02->setVisibility();
		$this->d_description_02->setVisibility();
		$this->main_image->setVisibility();
		$this->top_view->setVisibility();
		$this->front_view->setVisibility();
		$this->corner_view->setVisibility();
		$this->back_view->setVisibility();
		$this->color_options->setVisibility();
		$this->other_options->setVisibility();
		$this->image->setVisibility();
		$this->video_url->setVisibility();
		$this->currency->setVisibility();
		$this->hsn->setVisibility();
		$this->minimum_stock->Visible = FALSE;
		$this->in->Visible = FALSE;
		$this->out->Visible = FALSE;
		$this->required->Visible = FALSE;
		$this->blocked->Visible = FALSE;
		$this->ordered->Visible = FALSE;
		$this->status->setVisibility();
		$this->publish->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->v_01);
		$this->setupLookupOptions($this->v_02);
		$this->setupLookupOptions($this->v_03);
		$this->setupLookupOptions($this->v_04);
		$this->setupLookupOptions($this->v_05);
		$this->setupLookupOptions($this->v_06);
		$this->setupLookupOptions($this->v_07);
		$this->setupLookupOptions($this->v_08);
		$this->setupLookupOptions($this->v_09);
		$this->setupLookupOptions($this->v_10);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->b_03);
		$this->setupLookupOptions($this->b_04);
		$this->setupLookupOptions($this->b_05);
		$this->setupLookupOptions($this->b_06);
		$this->setupLookupOptions($this->b_07);
		$this->setupLookupOptions($this->b_08);
		$this->setupLookupOptions($this->b_09);
		$this->setupLookupOptions($this->b_10);
		$this->setupLookupOptions($this->t_03);
		$this->setupLookupOptions($this->t_04);
		$this->setupLookupOptions($this->t_05);
		$this->setupLookupOptions($this->t_06);
		$this->setupLookupOptions($this->t_07);
		$this->setupLookupOptions($this->t_08);
		$this->setupLookupOptions($this->t_09);
		$this->setupLookupOptions($this->t_10);
		$this->setupLookupOptions($this->t_11);
		$this->setupLookupOptions($this->t_12);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->hsn);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "ref_multilist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->company_id); // company_id
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
		$this->buildSearchUrl($srchUrl, $this->product); // product
		$this->buildSearchUrl($srchUrl, $this->product_n); // product_n
		$this->buildSearchUrl($srchUrl, $this->product_type); // product_type
		$this->buildSearchUrl($srchUrl, $this->last_price); // last_price
		$this->buildSearchUrl($srchUrl, $this->v_01); // v_01
		$this->buildSearchUrl($srchUrl, $this->v_02); // v_02
		$this->buildSearchUrl($srchUrl, $this->v_03); // v_03
		$this->buildSearchUrl($srchUrl, $this->v_04); // v_04
		$this->buildSearchUrl($srchUrl, $this->v_05); // v_05
		$this->buildSearchUrl($srchUrl, $this->v_06); // v_06
		$this->buildSearchUrl($srchUrl, $this->v_07); // v_07
		$this->buildSearchUrl($srchUrl, $this->v_08); // v_08
		$this->buildSearchUrl($srchUrl, $this->v_09); // v_09
		$this->buildSearchUrl($srchUrl, $this->v_10); // v_10
		$this->buildSearchUrl($srchUrl, $this->b_01); // b_01
		$this->buildSearchUrl($srchUrl, $this->b_02); // b_02
		$this->buildSearchUrl($srchUrl, $this->b_03); // b_03
		$this->buildSearchUrl($srchUrl, $this->b_04); // b_04
		$this->buildSearchUrl($srchUrl, $this->b_05); // b_05
		$this->buildSearchUrl($srchUrl, $this->b_06); // b_06
		$this->buildSearchUrl($srchUrl, $this->b_07); // b_07
		$this->buildSearchUrl($srchUrl, $this->b_08); // b_08
		$this->buildSearchUrl($srchUrl, $this->b_09); // b_09
		$this->buildSearchUrl($srchUrl, $this->b_10); // b_10
		$this->buildSearchUrl($srchUrl, $this->b_11); // b_11
		$this->buildSearchUrl($srchUrl, $this->b_12); // b_12
		$this->buildSearchUrl($srchUrl, $this->b_13); // b_13
		$this->buildSearchUrl($srchUrl, $this->b_14); // b_14
		$this->buildSearchUrl($srchUrl, $this->b_15); // b_15
		$this->buildSearchUrl($srchUrl, $this->t_01); // t_01
		$this->buildSearchUrl($srchUrl, $this->t_02); // t_02
		$this->buildSearchUrl($srchUrl, $this->t_03); // t_03
		$this->buildSearchUrl($srchUrl, $this->t_04); // t_04
		$this->buildSearchUrl($srchUrl, $this->t_05); // t_05
		$this->buildSearchUrl($srchUrl, $this->t_06); // t_06
		$this->buildSearchUrl($srchUrl, $this->t_07); // t_07
		$this->buildSearchUrl($srchUrl, $this->t_08); // t_08
		$this->buildSearchUrl($srchUrl, $this->t_09); // t_09
		$this->buildSearchUrl($srchUrl, $this->t_10); // t_10
		$this->buildSearchUrl($srchUrl, $this->t_11); // t_11
		$this->buildSearchUrl($srchUrl, $this->t_12); // t_12
		$this->buildSearchUrl($srchUrl, $this->t_13); // t_13
		$this->buildSearchUrl($srchUrl, $this->t_14); // t_14
		$this->buildSearchUrl($srchUrl, $this->t_15); // t_15
		$this->buildSearchUrl($srchUrl, $this->d_head_01); // d_head_01
		$this->buildSearchUrl($srchUrl, $this->d_description_01); // d_description_01
		$this->buildSearchUrl($srchUrl, $this->d_head_02); // d_head_02
		$this->buildSearchUrl($srchUrl, $this->d_description_02); // d_description_02
		$this->buildSearchUrl($srchUrl, $this->main_image); // main_image
		$this->buildSearchUrl($srchUrl, $this->top_view); // top_view
		$this->buildSearchUrl($srchUrl, $this->front_view); // front_view
		$this->buildSearchUrl($srchUrl, $this->corner_view); // corner_view
		$this->buildSearchUrl($srchUrl, $this->back_view); // back_view
		$this->buildSearchUrl($srchUrl, $this->color_options); // color_options
		$this->buildSearchUrl($srchUrl, $this->other_options); // other_options
		$this->buildSearchUrl($srchUrl, $this->image); // image
		$this->buildSearchUrl($srchUrl, $this->video_url); // video_url
		$this->buildSearchUrl($srchUrl, $this->currency); // currency
		$this->buildSearchUrl($srchUrl, $this->hsn); // hsn
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_company_id"));
		$this->company_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_company_id"));

		// grp
		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_grp"));
		$this->s_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_grp"));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product"));
		$this->product->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product"));

		// product_n
		if (!$this->isAddOrEdit())
			$this->product_n->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_n"));
		$this->product_n->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_n"));

		// product_type
		if (!$this->isAddOrEdit())
			$this->product_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_type"));
		$this->product_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_type"));

		// last_price
		if (!$this->isAddOrEdit())
			$this->last_price->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_last_price"));
		$this->last_price->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_last_price"));

		// v_01
		if (!$this->isAddOrEdit())
			$this->v_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_01"));
		$this->v_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_01"));
		if (is_array($this->v_01->AdvancedSearch->SearchValue))
			$this->v_01->AdvancedSearch->SearchValue = implode(",", $this->v_01->AdvancedSearch->SearchValue);
		if (is_array($this->v_01->AdvancedSearch->SearchValue2))
			$this->v_01->AdvancedSearch->SearchValue2 = implode(",", $this->v_01->AdvancedSearch->SearchValue2);

		// v_02
		if (!$this->isAddOrEdit())
			$this->v_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_02"));
		$this->v_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_02"));
		if (is_array($this->v_02->AdvancedSearch->SearchValue))
			$this->v_02->AdvancedSearch->SearchValue = implode(",", $this->v_02->AdvancedSearch->SearchValue);
		if (is_array($this->v_02->AdvancedSearch->SearchValue2))
			$this->v_02->AdvancedSearch->SearchValue2 = implode(",", $this->v_02->AdvancedSearch->SearchValue2);

		// v_03
		if (!$this->isAddOrEdit())
			$this->v_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_03"));
		$this->v_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_03"));
		if (is_array($this->v_03->AdvancedSearch->SearchValue))
			$this->v_03->AdvancedSearch->SearchValue = implode(",", $this->v_03->AdvancedSearch->SearchValue);
		if (is_array($this->v_03->AdvancedSearch->SearchValue2))
			$this->v_03->AdvancedSearch->SearchValue2 = implode(",", $this->v_03->AdvancedSearch->SearchValue2);

		// v_04
		if (!$this->isAddOrEdit())
			$this->v_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_04"));
		$this->v_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_04"));
		if (is_array($this->v_04->AdvancedSearch->SearchValue))
			$this->v_04->AdvancedSearch->SearchValue = implode(",", $this->v_04->AdvancedSearch->SearchValue);
		if (is_array($this->v_04->AdvancedSearch->SearchValue2))
			$this->v_04->AdvancedSearch->SearchValue2 = implode(",", $this->v_04->AdvancedSearch->SearchValue2);

		// v_05
		if (!$this->isAddOrEdit())
			$this->v_05->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_05"));
		$this->v_05->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_05"));
		if (is_array($this->v_05->AdvancedSearch->SearchValue))
			$this->v_05->AdvancedSearch->SearchValue = implode(",", $this->v_05->AdvancedSearch->SearchValue);
		if (is_array($this->v_05->AdvancedSearch->SearchValue2))
			$this->v_05->AdvancedSearch->SearchValue2 = implode(",", $this->v_05->AdvancedSearch->SearchValue2);

		// v_06
		if (!$this->isAddOrEdit())
			$this->v_06->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_06"));
		$this->v_06->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_06"));
		if (is_array($this->v_06->AdvancedSearch->SearchValue))
			$this->v_06->AdvancedSearch->SearchValue = implode(",", $this->v_06->AdvancedSearch->SearchValue);
		if (is_array($this->v_06->AdvancedSearch->SearchValue2))
			$this->v_06->AdvancedSearch->SearchValue2 = implode(",", $this->v_06->AdvancedSearch->SearchValue2);

		// v_07
		if (!$this->isAddOrEdit())
			$this->v_07->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_07"));
		$this->v_07->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_07"));
		if (is_array($this->v_07->AdvancedSearch->SearchValue))
			$this->v_07->AdvancedSearch->SearchValue = implode(",", $this->v_07->AdvancedSearch->SearchValue);
		if (is_array($this->v_07->AdvancedSearch->SearchValue2))
			$this->v_07->AdvancedSearch->SearchValue2 = implode(",", $this->v_07->AdvancedSearch->SearchValue2);

		// v_08
		if (!$this->isAddOrEdit())
			$this->v_08->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_08"));
		$this->v_08->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_08"));
		if (is_array($this->v_08->AdvancedSearch->SearchValue))
			$this->v_08->AdvancedSearch->SearchValue = implode(",", $this->v_08->AdvancedSearch->SearchValue);
		if (is_array($this->v_08->AdvancedSearch->SearchValue2))
			$this->v_08->AdvancedSearch->SearchValue2 = implode(",", $this->v_08->AdvancedSearch->SearchValue2);

		// v_09
		if (!$this->isAddOrEdit())
			$this->v_09->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_09"));
		$this->v_09->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_09"));
		if (is_array($this->v_09->AdvancedSearch->SearchValue))
			$this->v_09->AdvancedSearch->SearchValue = implode(",", $this->v_09->AdvancedSearch->SearchValue);
		if (is_array($this->v_09->AdvancedSearch->SearchValue2))
			$this->v_09->AdvancedSearch->SearchValue2 = implode(",", $this->v_09->AdvancedSearch->SearchValue2);

		// v_10
		if (!$this->isAddOrEdit())
			$this->v_10->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_v_10"));
		$this->v_10->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_v_10"));
		if (is_array($this->v_10->AdvancedSearch->SearchValue))
			$this->v_10->AdvancedSearch->SearchValue = implode(",", $this->v_10->AdvancedSearch->SearchValue);
		if (is_array($this->v_10->AdvancedSearch->SearchValue2))
			$this->v_10->AdvancedSearch->SearchValue2 = implode(",", $this->v_10->AdvancedSearch->SearchValue2);

		// b_01
		if (!$this->isAddOrEdit())
			$this->b_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_01"));
		$this->b_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_01"));

		// b_02
		if (!$this->isAddOrEdit())
			$this->b_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_02"));
		$this->b_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_02"));

		// b_03
		if (!$this->isAddOrEdit())
			$this->b_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_03"));
		$this->b_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_03"));
		if (is_array($this->b_03->AdvancedSearch->SearchValue))
			$this->b_03->AdvancedSearch->SearchValue = implode(",", $this->b_03->AdvancedSearch->SearchValue);
		if (is_array($this->b_03->AdvancedSearch->SearchValue2))
			$this->b_03->AdvancedSearch->SearchValue2 = implode(",", $this->b_03->AdvancedSearch->SearchValue2);

		// b_04
		if (!$this->isAddOrEdit())
			$this->b_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_04"));
		$this->b_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_04"));
		if (is_array($this->b_04->AdvancedSearch->SearchValue))
			$this->b_04->AdvancedSearch->SearchValue = implode(",", $this->b_04->AdvancedSearch->SearchValue);
		if (is_array($this->b_04->AdvancedSearch->SearchValue2))
			$this->b_04->AdvancedSearch->SearchValue2 = implode(",", $this->b_04->AdvancedSearch->SearchValue2);

		// b_05
		if (!$this->isAddOrEdit())
			$this->b_05->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_05"));
		$this->b_05->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_05"));
		if (is_array($this->b_05->AdvancedSearch->SearchValue))
			$this->b_05->AdvancedSearch->SearchValue = implode(",", $this->b_05->AdvancedSearch->SearchValue);
		if (is_array($this->b_05->AdvancedSearch->SearchValue2))
			$this->b_05->AdvancedSearch->SearchValue2 = implode(",", $this->b_05->AdvancedSearch->SearchValue2);

		// b_06
		if (!$this->isAddOrEdit())
			$this->b_06->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_06"));
		$this->b_06->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_06"));
		if (is_array($this->b_06->AdvancedSearch->SearchValue))
			$this->b_06->AdvancedSearch->SearchValue = implode(",", $this->b_06->AdvancedSearch->SearchValue);
		if (is_array($this->b_06->AdvancedSearch->SearchValue2))
			$this->b_06->AdvancedSearch->SearchValue2 = implode(",", $this->b_06->AdvancedSearch->SearchValue2);

		// b_07
		if (!$this->isAddOrEdit())
			$this->b_07->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_07"));
		$this->b_07->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_07"));
		if (is_array($this->b_07->AdvancedSearch->SearchValue))
			$this->b_07->AdvancedSearch->SearchValue = implode(",", $this->b_07->AdvancedSearch->SearchValue);
		if (is_array($this->b_07->AdvancedSearch->SearchValue2))
			$this->b_07->AdvancedSearch->SearchValue2 = implode(",", $this->b_07->AdvancedSearch->SearchValue2);

		// b_08
		if (!$this->isAddOrEdit())
			$this->b_08->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_08"));
		$this->b_08->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_08"));
		if (is_array($this->b_08->AdvancedSearch->SearchValue))
			$this->b_08->AdvancedSearch->SearchValue = implode(",", $this->b_08->AdvancedSearch->SearchValue);
		if (is_array($this->b_08->AdvancedSearch->SearchValue2))
			$this->b_08->AdvancedSearch->SearchValue2 = implode(",", $this->b_08->AdvancedSearch->SearchValue2);

		// b_09
		if (!$this->isAddOrEdit())
			$this->b_09->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_09"));
		$this->b_09->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_09"));
		if (is_array($this->b_09->AdvancedSearch->SearchValue))
			$this->b_09->AdvancedSearch->SearchValue = implode(",", $this->b_09->AdvancedSearch->SearchValue);
		if (is_array($this->b_09->AdvancedSearch->SearchValue2))
			$this->b_09->AdvancedSearch->SearchValue2 = implode(",", $this->b_09->AdvancedSearch->SearchValue2);

		// b_10
		if (!$this->isAddOrEdit())
			$this->b_10->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_10"));
		$this->b_10->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_10"));
		if (is_array($this->b_10->AdvancedSearch->SearchValue))
			$this->b_10->AdvancedSearch->SearchValue = implode(",", $this->b_10->AdvancedSearch->SearchValue);
		if (is_array($this->b_10->AdvancedSearch->SearchValue2))
			$this->b_10->AdvancedSearch->SearchValue2 = implode(",", $this->b_10->AdvancedSearch->SearchValue2);

		// b_11
		if (!$this->isAddOrEdit())
			$this->b_11->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_11"));
		$this->b_11->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_11"));

		// b_12
		if (!$this->isAddOrEdit())
			$this->b_12->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_12"));
		$this->b_12->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_12"));

		// b_13
		if (!$this->isAddOrEdit())
			$this->b_13->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_13"));
		$this->b_13->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_13"));

		// b_14
		if (!$this->isAddOrEdit())
			$this->b_14->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_14"));
		$this->b_14->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_14"));

		// b_15
		if (!$this->isAddOrEdit())
			$this->b_15->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_15"));
		$this->b_15->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_15"));

		// t_01
		if (!$this->isAddOrEdit())
			$this->t_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_01"));
		$this->t_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_01"));

		// t_02
		if (!$this->isAddOrEdit())
			$this->t_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_02"));
		$this->t_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_02"));

		// t_03
		if (!$this->isAddOrEdit())
			$this->t_03->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_03"));
		$this->t_03->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_03"));
		if (is_array($this->t_03->AdvancedSearch->SearchValue))
			$this->t_03->AdvancedSearch->SearchValue = implode(",", $this->t_03->AdvancedSearch->SearchValue);
		if (is_array($this->t_03->AdvancedSearch->SearchValue2))
			$this->t_03->AdvancedSearch->SearchValue2 = implode(",", $this->t_03->AdvancedSearch->SearchValue2);

		// t_04
		if (!$this->isAddOrEdit())
			$this->t_04->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_04"));
		$this->t_04->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_04"));
		if (is_array($this->t_04->AdvancedSearch->SearchValue))
			$this->t_04->AdvancedSearch->SearchValue = implode(",", $this->t_04->AdvancedSearch->SearchValue);
		if (is_array($this->t_04->AdvancedSearch->SearchValue2))
			$this->t_04->AdvancedSearch->SearchValue2 = implode(",", $this->t_04->AdvancedSearch->SearchValue2);

		// t_05
		if (!$this->isAddOrEdit())
			$this->t_05->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_05"));
		$this->t_05->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_05"));
		if (is_array($this->t_05->AdvancedSearch->SearchValue))
			$this->t_05->AdvancedSearch->SearchValue = implode(",", $this->t_05->AdvancedSearch->SearchValue);
		if (is_array($this->t_05->AdvancedSearch->SearchValue2))
			$this->t_05->AdvancedSearch->SearchValue2 = implode(",", $this->t_05->AdvancedSearch->SearchValue2);

		// t_06
		if (!$this->isAddOrEdit())
			$this->t_06->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_06"));
		$this->t_06->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_06"));
		if (is_array($this->t_06->AdvancedSearch->SearchValue))
			$this->t_06->AdvancedSearch->SearchValue = implode(",", $this->t_06->AdvancedSearch->SearchValue);
		if (is_array($this->t_06->AdvancedSearch->SearchValue2))
			$this->t_06->AdvancedSearch->SearchValue2 = implode(",", $this->t_06->AdvancedSearch->SearchValue2);

		// t_07
		if (!$this->isAddOrEdit())
			$this->t_07->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_07"));
		$this->t_07->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_07"));
		if (is_array($this->t_07->AdvancedSearch->SearchValue))
			$this->t_07->AdvancedSearch->SearchValue = implode(",", $this->t_07->AdvancedSearch->SearchValue);
		if (is_array($this->t_07->AdvancedSearch->SearchValue2))
			$this->t_07->AdvancedSearch->SearchValue2 = implode(",", $this->t_07->AdvancedSearch->SearchValue2);

		// t_08
		if (!$this->isAddOrEdit())
			$this->t_08->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_08"));
		$this->t_08->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_08"));
		if (is_array($this->t_08->AdvancedSearch->SearchValue))
			$this->t_08->AdvancedSearch->SearchValue = implode(",", $this->t_08->AdvancedSearch->SearchValue);
		if (is_array($this->t_08->AdvancedSearch->SearchValue2))
			$this->t_08->AdvancedSearch->SearchValue2 = implode(",", $this->t_08->AdvancedSearch->SearchValue2);

		// t_09
		if (!$this->isAddOrEdit())
			$this->t_09->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_09"));
		$this->t_09->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_09"));
		if (is_array($this->t_09->AdvancedSearch->SearchValue))
			$this->t_09->AdvancedSearch->SearchValue = implode(",", $this->t_09->AdvancedSearch->SearchValue);
		if (is_array($this->t_09->AdvancedSearch->SearchValue2))
			$this->t_09->AdvancedSearch->SearchValue2 = implode(",", $this->t_09->AdvancedSearch->SearchValue2);

		// t_10
		if (!$this->isAddOrEdit())
			$this->t_10->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_10"));
		$this->t_10->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_10"));
		if (is_array($this->t_10->AdvancedSearch->SearchValue))
			$this->t_10->AdvancedSearch->SearchValue = implode(",", $this->t_10->AdvancedSearch->SearchValue);
		if (is_array($this->t_10->AdvancedSearch->SearchValue2))
			$this->t_10->AdvancedSearch->SearchValue2 = implode(",", $this->t_10->AdvancedSearch->SearchValue2);

		// t_11
		if (!$this->isAddOrEdit())
			$this->t_11->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_11"));
		$this->t_11->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_11"));

		// t_12
		if (!$this->isAddOrEdit())
			$this->t_12->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_12"));
		$this->t_12->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_12"));

		// t_13
		if (!$this->isAddOrEdit())
			$this->t_13->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_13"));
		$this->t_13->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_13"));

		// t_14
		if (!$this->isAddOrEdit())
			$this->t_14->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_14"));
		$this->t_14->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_14"));

		// t_15
		if (!$this->isAddOrEdit())
			$this->t_15->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_t_15"));
		$this->t_15->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_t_15"));

		// d_head_01
		if (!$this->isAddOrEdit())
			$this->d_head_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_head_01"));
		$this->d_head_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_head_01"));

		// d_description_01
		if (!$this->isAddOrEdit())
			$this->d_description_01->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_description_01"));
		$this->d_description_01->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_description_01"));

		// d_head_02
		if (!$this->isAddOrEdit())
			$this->d_head_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_head_02"));
		$this->d_head_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_head_02"));

		// d_description_02
		if (!$this->isAddOrEdit())
			$this->d_description_02->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_d_description_02"));
		$this->d_description_02->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_d_description_02"));

		// main_image
		if (!$this->isAddOrEdit())
			$this->main_image->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_main_image"));
		$this->main_image->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_main_image"));

		// top_view
		if (!$this->isAddOrEdit())
			$this->top_view->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_top_view"));
		$this->top_view->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_top_view"));

		// front_view
		if (!$this->isAddOrEdit())
			$this->front_view->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_front_view"));
		$this->front_view->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_front_view"));

		// corner_view
		if (!$this->isAddOrEdit())
			$this->corner_view->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_corner_view"));
		$this->corner_view->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_corner_view"));

		// back_view
		if (!$this->isAddOrEdit())
			$this->back_view->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_back_view"));
		$this->back_view->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_back_view"));

		// color_options
		if (!$this->isAddOrEdit())
			$this->color_options->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_color_options"));
		$this->color_options->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_color_options"));

		// other_options
		if (!$this->isAddOrEdit())
			$this->other_options->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_other_options"));
		$this->other_options->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_other_options"));

		// image
		if (!$this->isAddOrEdit())
			$this->image->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_image"));
		$this->image->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_image"));

		// video_url
		if (!$this->isAddOrEdit())
			$this->video_url->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_video_url"));
		$this->video_url->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_video_url"));

		// currency
		if (!$this->isAddOrEdit())
			$this->currency->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_currency"));
		$this->currency->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_currency"));

		// hsn
		if (!$this->isAddOrEdit())
			$this->hsn->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_hsn"));
		$this->hsn->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_hsn"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));
		$this->datetime->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_datetime"));
		$this->datetime->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_datetime"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// oid
		// barcode
		// company_id
		// grp
		// s_grp
		// product
		// product_n
		// product_type
		// product_code
		// gcode
		// code
		// product_id
		// print_name
		// batch_no
		// last_price
		// v_01
		// v_02
		// v_03
		// v_04
		// v_05
		// v_06
		// v_07
		// v_08
		// v_09
		// v_10
		// cbm
		// sqm
		// shape
		// b_01
		// b_02
		// b_03
		// b_04
		// b_05
		// b_06
		// b_07
		// b_08
		// b_09
		// b_10
		// b_11
		// b_12
		// b_13
		// b_14
		// b_15
		// t_01
		// t_02
		// t_03
		// t_04
		// t_05
		// t_06
		// t_07
		// t_08
		// t_09
		// t_10
		// t_11
		// t_12
		// t_13
		// t_14
		// t_15
		// d_head_01
		// d_description_01
		// d_head_02
		// d_description_02
		// main_image
		// top_view
		// front_view
		// corner_view
		// back_view
		// color_options
		// other_options
		// image
		// video_url
		// currency
		// hsn
		// minimum_stock
		// in
		// out
		// required
		// blocked
		// ordered
		// status
		// publish
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `id` > 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 200000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_n
			$this->product_n->ViewValue = $this->product_n->CurrentValue;
			$this->product_n->ViewCustomAttributes = "";

			// product_type
			$this->product_type->ViewValue = $this->product_type->CurrentValue;
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` = 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// last_price
			$this->last_price->ViewValue = $this->last_price->CurrentValue;
			$this->last_price->ViewCustomAttributes = "";

			// v_01
			$curVal = strval($this->v_01->CurrentValue);
			if ($curVal <> "") {
				$this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
				if ($this->v_01->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_01->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_01->ViewValue->add($this->v_01->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_01->ViewValue = $this->v_01->CurrentValue;
					}
				}
			} else {
				$this->v_01->ViewValue = NULL;
			}
			$this->v_01->ViewCustomAttributes = "";

			// v_02
			$curVal = strval($this->v_02->CurrentValue);
			if ($curVal <> "") {
				$this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
				if ($this->v_02->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_02->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_02->ViewValue->add($this->v_02->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_02->ViewValue = $this->v_02->CurrentValue;
					}
				}
			} else {
				$this->v_02->ViewValue = NULL;
			}
			$this->v_02->ViewCustomAttributes = "";

			// v_03
			$curVal = strval($this->v_03->CurrentValue);
			if ($curVal <> "") {
				$this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
				if ($this->v_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_03->ViewValue->add($this->v_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_03->ViewValue = $this->v_03->CurrentValue;
					}
				}
			} else {
				$this->v_03->ViewValue = NULL;
			}
			$this->v_03->ViewCustomAttributes = "";

			// v_04
			$curVal = strval($this->v_04->CurrentValue);
			if ($curVal <> "") {
				$this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
				if ($this->v_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_04->ViewValue->add($this->v_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_04->ViewValue = $this->v_04->CurrentValue;
					}
				}
			} else {
				$this->v_04->ViewValue = NULL;
			}
			$this->v_04->ViewCustomAttributes = "";

			// v_05
			$curVal = strval($this->v_05->CurrentValue);
			if ($curVal <> "") {
				$this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
				if ($this->v_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_05->ViewValue->add($this->v_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_05->ViewValue = $this->v_05->CurrentValue;
					}
				}
			} else {
				$this->v_05->ViewValue = NULL;
			}
			$this->v_05->ViewCustomAttributes = "";

			// v_06
			$curVal = strval($this->v_06->CurrentValue);
			if ($curVal <> "") {
				$this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
				if ($this->v_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 106 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_06->ViewValue->add($this->v_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_06->ViewValue = $this->v_06->CurrentValue;
					}
				}
			} else {
				$this->v_06->ViewValue = NULL;
			}
			$this->v_06->ViewCustomAttributes = "";

			// v_07
			$curVal = strval($this->v_07->CurrentValue);
			if ($curVal <> "") {
				$this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
				if ($this->v_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 107 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_07->ViewValue->add($this->v_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_07->ViewValue = $this->v_07->CurrentValue;
					}
				}
			} else {
				$this->v_07->ViewValue = NULL;
			}
			$this->v_07->ViewCustomAttributes = "";

			// v_08
			$curVal = strval($this->v_08->CurrentValue);
			if ($curVal <> "") {
				$this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
				if ($this->v_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 108 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_08->ViewValue->add($this->v_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_08->ViewValue = $this->v_08->CurrentValue;
					}
				}
			} else {
				$this->v_08->ViewValue = NULL;
			}
			$this->v_08->ViewCustomAttributes = "";

			// v_09
			$curVal = strval($this->v_09->CurrentValue);
			if ($curVal <> "") {
				$this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
				if ($this->v_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 109 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_09->ViewValue->add($this->v_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_09->ViewValue = $this->v_09->CurrentValue;
					}
				}
			} else {
				$this->v_09->ViewValue = NULL;
			}
			$this->v_09->ViewCustomAttributes = "";

			// v_10
			$curVal = strval($this->v_10->CurrentValue);
			if ($curVal <> "") {
				$this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
				if ($this->v_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 110 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_10->ViewValue->add($this->v_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_10->ViewValue = $this->v_10->CurrentValue;
					}
				}
			} else {
				$this->v_10->ViewValue = NULL;
			}
			$this->v_10->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->shape->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->shape->ViewValue->add($this->shape->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// b_01
			$this->b_01->ViewValue = $this->b_01->CurrentValue;
			$this->b_01->ViewCustomAttributes = "";

			// b_02
			$this->b_02->ViewValue = $this->b_02->CurrentValue;
			$this->b_02->ViewCustomAttributes = "";

			// b_03
			$curVal = strval($this->b_03->CurrentValue);
			if ($curVal <> "") {
				$this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
				if ($this->b_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 203 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_03->ViewValue = $this->b_03->CurrentValue;
					}
				}
			} else {
				$this->b_03->ViewValue = NULL;
			}
			$this->b_03->ViewCustomAttributes = "";

			// b_04
			$curVal = strval($this->b_04->CurrentValue);
			if ($curVal <> "") {
				$this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
				if ($this->b_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 204 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_04->ViewValue = $this->b_04->CurrentValue;
					}
				}
			} else {
				$this->b_04->ViewValue = NULL;
			}
			$this->b_04->ViewCustomAttributes = "";

			// b_05
			$curVal = strval($this->b_05->CurrentValue);
			if ($curVal <> "") {
				$this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
				if ($this->b_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 205 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_05->ViewValue = $this->b_05->CurrentValue;
					}
				}
			} else {
				$this->b_05->ViewValue = NULL;
			}
			$this->b_05->ViewCustomAttributes = "";

			// b_06
			$curVal = strval($this->b_06->CurrentValue);
			if ($curVal <> "") {
				$this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
				if ($this->b_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 206 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_06->ViewValue = $this->b_06->CurrentValue;
					}
				}
			} else {
				$this->b_06->ViewValue = NULL;
			}
			$this->b_06->ViewCustomAttributes = "";

			// b_07
			$curVal = strval($this->b_07->CurrentValue);
			if ($curVal <> "") {
				$this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
				if ($this->b_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 207 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_07->ViewValue = $this->b_07->CurrentValue;
					}
				}
			} else {
				$this->b_07->ViewValue = NULL;
			}
			$this->b_07->ViewCustomAttributes = "";

			// b_08
			$curVal = strval($this->b_08->CurrentValue);
			if ($curVal <> "") {
				$this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
				if ($this->b_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 208 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_08->ViewValue = $this->b_08->CurrentValue;
					}
				}
			} else {
				$this->b_08->ViewValue = NULL;
			}
			$this->b_08->ViewCustomAttributes = "";

			// b_09
			$curVal = strval($this->b_09->CurrentValue);
			if ($curVal <> "") {
				$this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
				if ($this->b_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 209 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_09->ViewValue = $this->b_09->CurrentValue;
					}
				}
			} else {
				$this->b_09->ViewValue = NULL;
			}
			$this->b_09->ViewCustomAttributes = "";

			// b_10
			$curVal = strval($this->b_10->CurrentValue);
			if ($curVal <> "") {
				$this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
				if ($this->b_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 210 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_10->ViewValue = $this->b_10->CurrentValue;
					}
				}
			} else {
				$this->b_10->ViewValue = NULL;
			}
			$this->b_10->ViewCustomAttributes = "";

			// b_11
			$this->b_11->ViewValue = $this->b_11->CurrentValue;
			$this->b_11->ViewCustomAttributes = "";

			// b_12
			$this->b_12->ViewValue = $this->b_12->CurrentValue;
			$this->b_12->ViewCustomAttributes = "";

			// b_13
			$this->b_13->ViewValue = $this->b_13->CurrentValue;
			$this->b_13->ViewCustomAttributes = "";

			// b_14
			$this->b_14->ViewValue = $this->b_14->CurrentValue;
			$this->b_14->ViewCustomAttributes = "";

			// b_15
			$this->b_15->ViewCustomAttributes = "";

			// t_01
			$this->t_01->ViewValue = $this->t_01->CurrentValue;
			$this->t_01->ViewCustomAttributes = "";

			// t_02
			$this->t_02->ViewValue = $this->t_02->CurrentValue;
			$this->t_02->ViewCustomAttributes = "";

			// t_03
			$curVal = strval($this->t_03->CurrentValue);
			if ($curVal <> "") {
				$this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
				if ($this->t_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 303 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_03->ViewValue = $this->t_03->CurrentValue;
					}
				}
			} else {
				$this->t_03->ViewValue = NULL;
			}
			$this->t_03->ViewCustomAttributes = "";

			// t_04
			$curVal = strval($this->t_04->CurrentValue);
			if ($curVal <> "") {
				$this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
				if ($this->t_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 304 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_04->ViewValue = $this->t_04->CurrentValue;
					}
				}
			} else {
				$this->t_04->ViewValue = NULL;
			}
			$this->t_04->ViewCustomAttributes = "";

			// t_05
			$curVal = strval($this->t_05->CurrentValue);
			if ($curVal <> "") {
				$this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
				if ($this->t_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 305 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_05->ViewValue = $this->t_05->CurrentValue;
					}
				}
			} else {
				$this->t_05->ViewValue = NULL;
			}
			$this->t_05->ViewCustomAttributes = "";

			// t_06
			$curVal = strval($this->t_06->CurrentValue);
			if ($curVal <> "") {
				$this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
				if ($this->t_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 306 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_06->ViewValue = $this->t_06->CurrentValue;
					}
				}
			} else {
				$this->t_06->ViewValue = NULL;
			}
			$this->t_06->ViewCustomAttributes = "";

			// t_07
			$curVal = strval($this->t_07->CurrentValue);
			if ($curVal <> "") {
				$this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
				if ($this->t_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 307 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_07->ViewValue = $this->t_07->CurrentValue;
					}
				}
			} else {
				$this->t_07->ViewValue = NULL;
			}
			$this->t_07->ViewCustomAttributes = "";

			// t_08
			$curVal = strval($this->t_08->CurrentValue);
			if ($curVal <> "") {
				$this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
				if ($this->t_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 308 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_08->ViewValue = $this->t_08->CurrentValue;
					}
				}
			} else {
				$this->t_08->ViewValue = NULL;
			}
			$this->t_08->ViewCustomAttributes = "";

			// t_09
			$curVal = strval($this->t_09->CurrentValue);
			if ($curVal <> "") {
				$this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
				if ($this->t_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 309 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_09->ViewValue = $this->t_09->CurrentValue;
					}
				}
			} else {
				$this->t_09->ViewValue = NULL;
			}
			$this->t_09->ViewCustomAttributes = "";

			// t_10
			$curVal = strval($this->t_10->CurrentValue);
			if ($curVal <> "") {
				$this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
				if ($this->t_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 310 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_10->ViewValue = $this->t_10->CurrentValue;
					}
				}
			} else {
				$this->t_10->ViewValue = NULL;
			}
			$this->t_10->ViewCustomAttributes = "";

			// t_11
			$this->t_11->ViewValue = $this->t_11->CurrentValue;
			$curVal = strval($this->t_11->CurrentValue);
			if ($curVal <> "") {
				$this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
				if ($this->t_11->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_11->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_11->ViewValue = $this->t_11->CurrentValue;
					}
				}
			} else {
				$this->t_11->ViewValue = NULL;
			}
			$this->t_11->ViewCustomAttributes = "";

			// t_12
			$this->t_12->ViewValue = $this->t_12->CurrentValue;
			$curVal = strval($this->t_12->CurrentValue);
			if ($curVal <> "") {
				$this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
				if ($this->t_12->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_12->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_12->ViewValue = $this->t_12->CurrentValue;
					}
				}
			} else {
				$this->t_12->ViewValue = NULL;
			}
			$this->t_12->ViewCustomAttributes = "";

			// t_13
			$this->t_13->ViewValue = $this->t_13->CurrentValue;
			$this->t_13->ViewCustomAttributes = "";

			// t_14
			$this->t_14->ViewValue = $this->t_14->CurrentValue;
			$this->t_14->ViewCustomAttributes = "";

			// t_15
			$this->t_15->ViewValue = $this->t_15->CurrentValue;
			$this->t_15->ViewCustomAttributes = "";

			// d_head_01
			$this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;
			$this->d_head_01->ViewCustomAttributes = "";

			// d_description_01
			$this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;
			$this->d_description_01->ViewCustomAttributes = "";

			// d_head_02
			$this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;
			$this->d_head_02->ViewCustomAttributes = "";

			// d_description_02
			$this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;
			$this->d_description_02->ViewCustomAttributes = "";

			// main_image
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->ImageWidth = 0;
				$this->main_image->ImageHeight = 40;
				$this->main_image->ImageAlt = $this->main_image->alt();
				$this->main_image->ViewValue = $this->main_image->Upload->DbValue;
			} else {
				$this->main_image->ViewValue = "";
			}
			$this->main_image->ViewCustomAttributes = "";

			// top_view
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->ImageWidth = 0;
				$this->top_view->ImageHeight = 40;
				$this->top_view->ImageAlt = $this->top_view->alt();
				$this->top_view->ViewValue = $this->top_view->Upload->DbValue;
			} else {
				$this->top_view->ViewValue = "";
			}
			$this->top_view->ViewCustomAttributes = "";

			// front_view
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->ImageWidth = 0;
				$this->front_view->ImageHeight = 40;
				$this->front_view->ImageAlt = $this->front_view->alt();
				$this->front_view->ViewValue = $this->front_view->Upload->DbValue;
			} else {
				$this->front_view->ViewValue = "";
			}
			$this->front_view->ViewCustomAttributes = "";

			// corner_view
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->ImageWidth = 0;
				$this->corner_view->ImageHeight = 40;
				$this->corner_view->ImageAlt = $this->corner_view->alt();
				$this->corner_view->ViewValue = $this->corner_view->Upload->DbValue;
			} else {
				$this->corner_view->ViewValue = "";
			}
			$this->corner_view->ViewCustomAttributes = "";

			// back_view
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->ImageWidth = 0;
				$this->back_view->ImageHeight = 40;
				$this->back_view->ImageAlt = $this->back_view->alt();
				$this->back_view->ViewValue = $this->back_view->Upload->DbValue;
			} else {
				$this->back_view->ViewValue = "";
			}
			$this->back_view->ViewCustomAttributes = "";

			// color_options
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->ImageWidth = 0;
				$this->color_options->ImageHeight = 40;
				$this->color_options->ImageAlt = $this->color_options->alt();
				$this->color_options->ViewValue = $this->color_options->Upload->DbValue;
			} else {
				$this->color_options->ViewValue = "";
			}
			$this->color_options->ViewCustomAttributes = "";

			// other_options
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->ImageWidth = 0;
				$this->other_options->ImageHeight = 40;
				$this->other_options->ImageAlt = $this->other_options->alt();
				$this->other_options->ViewValue = $this->other_options->Upload->DbValue;
			} else {
				$this->other_options->ViewValue = "";
			}
			$this->other_options->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// video_url
			$this->video_url->ViewValue = $this->video_url->CurrentValue;
			$this->video_url->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// hsn
			$curVal = strval($this->hsn->CurrentValue);
			if ($curVal <> "") {
				$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
				if ($this->hsn->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->hsn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->hsn->ViewValue = $this->hsn->CurrentValue;
					}
				}
			} else {
				$this->hsn->ViewValue = NULL;
			}
			$this->hsn->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// publish
			if (strval($this->publish->CurrentValue) <> "") {
				$this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
			} else {
				$this->publish->ViewValue = NULL;
			}
			$this->publish->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "ref_list.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// product_n
			$this->product_n->LinkCustomAttributes = "";
			$this->product_n->HrefValue = "";
			$this->product_n->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// last_price
			$this->last_price->LinkCustomAttributes = "";
			$this->last_price->HrefValue = "";
			$this->last_price->TooltipValue = "";

			// v_01
			$this->v_01->LinkCustomAttributes = "";
			$this->v_01->HrefValue = "";
			$this->v_01->TooltipValue = "";

			// v_02
			$this->v_02->LinkCustomAttributes = "";
			$this->v_02->HrefValue = "";
			$this->v_02->TooltipValue = "";

			// v_03
			$this->v_03->LinkCustomAttributes = "";
			$this->v_03->HrefValue = "";
			$this->v_03->TooltipValue = "";

			// v_04
			$this->v_04->LinkCustomAttributes = "";
			$this->v_04->HrefValue = "";
			$this->v_04->TooltipValue = "";

			// v_05
			$this->v_05->LinkCustomAttributes = "";
			$this->v_05->HrefValue = "";
			$this->v_05->TooltipValue = "";

			// v_06
			$this->v_06->LinkCustomAttributes = "";
			$this->v_06->HrefValue = "";
			$this->v_06->TooltipValue = "";

			// v_07
			$this->v_07->LinkCustomAttributes = "";
			$this->v_07->HrefValue = "";
			$this->v_07->TooltipValue = "";

			// v_08
			$this->v_08->LinkCustomAttributes = "";
			$this->v_08->HrefValue = "";
			$this->v_08->TooltipValue = "";

			// v_09
			$this->v_09->LinkCustomAttributes = "";
			$this->v_09->HrefValue = "";
			$this->v_09->TooltipValue = "";

			// v_10
			$this->v_10->LinkCustomAttributes = "";
			$this->v_10->HrefValue = "";
			$this->v_10->TooltipValue = "";

			// b_01
			$this->b_01->LinkCustomAttributes = "";
			$this->b_01->HrefValue = "";
			$this->b_01->TooltipValue = "";

			// b_02
			$this->b_02->LinkCustomAttributes = "";
			$this->b_02->HrefValue = "";
			$this->b_02->TooltipValue = "";

			// b_03
			$this->b_03->LinkCustomAttributes = "";
			$this->b_03->HrefValue = "";
			$this->b_03->TooltipValue = "";

			// b_04
			$this->b_04->LinkCustomAttributes = "";
			$this->b_04->HrefValue = "";
			$this->b_04->TooltipValue = "";

			// b_05
			$this->b_05->LinkCustomAttributes = "";
			$this->b_05->HrefValue = "";
			$this->b_05->TooltipValue = "";

			// b_06
			$this->b_06->LinkCustomAttributes = "";
			$this->b_06->HrefValue = "";
			$this->b_06->TooltipValue = "";

			// b_07
			$this->b_07->LinkCustomAttributes = "";
			$this->b_07->HrefValue = "";
			$this->b_07->TooltipValue = "";

			// b_08
			$this->b_08->LinkCustomAttributes = "";
			$this->b_08->HrefValue = "";
			$this->b_08->TooltipValue = "";

			// b_09
			$this->b_09->LinkCustomAttributes = "";
			$this->b_09->HrefValue = "";
			$this->b_09->TooltipValue = "";

			// b_10
			$this->b_10->LinkCustomAttributes = "";
			$this->b_10->HrefValue = "";
			$this->b_10->TooltipValue = "";

			// b_11
			$this->b_11->LinkCustomAttributes = "";
			$this->b_11->HrefValue = "";
			$this->b_11->TooltipValue = "";

			// b_12
			$this->b_12->LinkCustomAttributes = "";
			$this->b_12->HrefValue = "";
			$this->b_12->TooltipValue = "";

			// b_13
			$this->b_13->LinkCustomAttributes = "";
			$this->b_13->HrefValue = "";
			$this->b_13->TooltipValue = "";

			// b_14
			$this->b_14->LinkCustomAttributes = "";
			$this->b_14->HrefValue = "";
			$this->b_14->TooltipValue = "";

			// b_15
			$this->b_15->LinkCustomAttributes = "";
			$this->b_15->HrefValue = "";
			$this->b_15->TooltipValue = "";

			// t_01
			$this->t_01->LinkCustomAttributes = "";
			$this->t_01->HrefValue = "";
			$this->t_01->TooltipValue = "";

			// t_02
			$this->t_02->LinkCustomAttributes = "";
			$this->t_02->HrefValue = "";
			$this->t_02->TooltipValue = "";

			// t_03
			$this->t_03->LinkCustomAttributes = "";
			$this->t_03->HrefValue = "";
			$this->t_03->TooltipValue = "";

			// t_04
			$this->t_04->LinkCustomAttributes = "";
			$this->t_04->HrefValue = "";
			$this->t_04->TooltipValue = "";

			// t_05
			$this->t_05->LinkCustomAttributes = "";
			$this->t_05->HrefValue = "";
			$this->t_05->TooltipValue = "";

			// t_06
			$this->t_06->LinkCustomAttributes = "";
			$this->t_06->HrefValue = "";
			$this->t_06->TooltipValue = "";

			// t_07
			$this->t_07->LinkCustomAttributes = "";
			$this->t_07->HrefValue = "";
			$this->t_07->TooltipValue = "";

			// t_08
			$this->t_08->LinkCustomAttributes = "";
			$this->t_08->HrefValue = "";
			$this->t_08->TooltipValue = "";

			// t_09
			$this->t_09->LinkCustomAttributes = "";
			$this->t_09->HrefValue = "";
			$this->t_09->TooltipValue = "";

			// t_10
			$this->t_10->LinkCustomAttributes = "";
			$this->t_10->HrefValue = "";
			$this->t_10->TooltipValue = "";

			// t_11
			$this->t_11->LinkCustomAttributes = "";
			$this->t_11->HrefValue = "";
			$this->t_11->TooltipValue = "";

			// t_12
			$this->t_12->LinkCustomAttributes = "";
			$this->t_12->HrefValue = "";
			$this->t_12->TooltipValue = "";

			// t_13
			$this->t_13->LinkCustomAttributes = "";
			$this->t_13->HrefValue = "";
			$this->t_13->TooltipValue = "";

			// t_14
			$this->t_14->LinkCustomAttributes = "";
			$this->t_14->HrefValue = "";
			$this->t_14->TooltipValue = "";

			// t_15
			$this->t_15->LinkCustomAttributes = "";
			$this->t_15->HrefValue = "";
			$this->t_15->TooltipValue = "";

			// d_head_01
			$this->d_head_01->LinkCustomAttributes = "";
			$this->d_head_01->HrefValue = "";
			$this->d_head_01->TooltipValue = "";

			// d_description_01
			$this->d_description_01->LinkCustomAttributes = "";
			$this->d_description_01->HrefValue = "";
			$this->d_description_01->TooltipValue = "";

			// d_head_02
			$this->d_head_02->LinkCustomAttributes = "";
			$this->d_head_02->HrefValue = "";
			$this->d_head_02->TooltipValue = "";

			// d_description_02
			$this->d_description_02->LinkCustomAttributes = "";
			$this->d_description_02->HrefValue = "";
			$this->d_description_02->TooltipValue = "";

			// main_image
			$this->main_image->LinkCustomAttributes = "";
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->HrefValue = "%u"; // Add prefix/suffix
				$this->main_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
			} else {
				$this->main_image->HrefValue = "";
			}
			$this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
			$this->main_image->TooltipValue = "";
			if ($this->main_image->UseColorbox) {
				if (EmptyValue($this->main_image->TooltipValue))
					$this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->main_image->LinkAttrs["data-rel"] = "ref_multi_x_main_image";
				AppendClass($this->main_image->LinkAttrs["class"], "ew-lightbox");
			}

			// top_view
			$this->top_view->LinkCustomAttributes = "";
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->HrefValue = "%u"; // Add prefix/suffix
				$this->top_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
			} else {
				$this->top_view->HrefValue = "";
			}
			$this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;
			$this->top_view->TooltipValue = "";
			if ($this->top_view->UseColorbox) {
				if (EmptyValue($this->top_view->TooltipValue))
					$this->top_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->top_view->LinkAttrs["data-rel"] = "ref_multi_x_top_view";
				AppendClass($this->top_view->LinkAttrs["class"], "ew-lightbox");
			}

			// front_view
			$this->front_view->LinkCustomAttributes = "";
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->HrefValue = "%u"; // Add prefix/suffix
				$this->front_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
			} else {
				$this->front_view->HrefValue = "";
			}
			$this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;
			$this->front_view->TooltipValue = "";
			if ($this->front_view->UseColorbox) {
				if (EmptyValue($this->front_view->TooltipValue))
					$this->front_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->front_view->LinkAttrs["data-rel"] = "ref_multi_x_front_view";
				AppendClass($this->front_view->LinkAttrs["class"], "ew-lightbox");
			}

			// corner_view
			$this->corner_view->LinkCustomAttributes = "";
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->HrefValue = "%u"; // Add prefix/suffix
				$this->corner_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
			} else {
				$this->corner_view->HrefValue = "";
			}
			$this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;
			$this->corner_view->TooltipValue = "";
			if ($this->corner_view->UseColorbox) {
				if (EmptyValue($this->corner_view->TooltipValue))
					$this->corner_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->corner_view->LinkAttrs["data-rel"] = "ref_multi_x_corner_view";
				AppendClass($this->corner_view->LinkAttrs["class"], "ew-lightbox");
			}

			// back_view
			$this->back_view->LinkCustomAttributes = "";
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->HrefValue = "%u"; // Add prefix/suffix
				$this->back_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
			} else {
				$this->back_view->HrefValue = "";
			}
			$this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;
			$this->back_view->TooltipValue = "";
			if ($this->back_view->UseColorbox) {
				if (EmptyValue($this->back_view->TooltipValue))
					$this->back_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->back_view->LinkAttrs["data-rel"] = "ref_multi_x_back_view";
				AppendClass($this->back_view->LinkAttrs["class"], "ew-lightbox");
			}

			// color_options
			$this->color_options->LinkCustomAttributes = "";
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->HrefValue = "%u"; // Add prefix/suffix
				$this->color_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
			} else {
				$this->color_options->HrefValue = "";
			}
			$this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;
			$this->color_options->TooltipValue = "";
			if ($this->color_options->UseColorbox) {
				if (EmptyValue($this->color_options->TooltipValue))
					$this->color_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->color_options->LinkAttrs["data-rel"] = "ref_multi_x_color_options";
				AppendClass($this->color_options->LinkAttrs["class"], "ew-lightbox");
			}

			// other_options
			$this->other_options->LinkCustomAttributes = "";
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->HrefValue = "%u"; // Add prefix/suffix
				$this->other_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
			} else {
				$this->other_options->HrefValue = "";
			}
			$this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;
			$this->other_options->TooltipValue = "";
			if ($this->other_options->UseColorbox) {
				if (EmptyValue($this->other_options->TooltipValue))
					$this->other_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->other_options->LinkAttrs["data-rel"] = "ref_multi_x_other_options";
				AppendClass($this->other_options->LinkAttrs["class"], "ew-lightbox");
			}

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = "%u"; // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";
			if ($this->image->UseColorbox) {
				if (EmptyValue($this->image->TooltipValue))
					$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->image->LinkAttrs["data-rel"] = "ref_multi_x_image";
				AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
			}

			// video_url
			$this->video_url->LinkCustomAttributes = "";
			$this->video_url->HrefValue = "";
			$this->video_url->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// hsn
			$this->hsn->LinkCustomAttributes = "";
			$this->hsn->HrefValue = "";
			$this->hsn->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? "`status` = 1 and `id` > 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 200000";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->s_grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->lookupCacheOption($curVal);
			else
				$this->s_grp->AdvancedSearch->ViewValue = $this->s_grp->Lookup !== NULL && is_array($this->s_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->s_grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->s_grp->EditValue = array_values($this->s_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->s_grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->s_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->s_grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// product_n
			$this->product_n->EditAttrs["class"] = "form-control";
			$this->product_n->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_n->AdvancedSearch->SearchValue = HtmlDecode($this->product_n->AdvancedSearch->SearchValue);
			$this->product_n->EditValue = HtmlEncode($this->product_n->AdvancedSearch->SearchValue);
			$this->product_n->PlaceHolder = RemoveHtml($this->product_n->caption());

			// product_type
			$this->product_type->EditAttrs["class"] = "form-control";
			$this->product_type->EditCustomAttributes = 'ReadOnly';
			if (REMOVE_XSS)
				$this->product_type->AdvancedSearch->SearchValue = HtmlDecode($this->product_type->AdvancedSearch->SearchValue);
			$this->product_type->EditValue = HtmlEncode($this->product_type->AdvancedSearch->SearchValue);
			$curVal = strval($this->product_type->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->product_type->EditValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` = 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->product_type->EditValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->EditValue = HtmlEncode($this->product_type->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->product_type->EditValue = NULL;
			}
			$this->product_type->PlaceHolder = RemoveHtml($this->product_type->caption());

			// last_price
			$this->last_price->EditAttrs["class"] = "form-control";
			$this->last_price->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->last_price->AdvancedSearch->SearchValue = HtmlDecode($this->last_price->AdvancedSearch->SearchValue);
			$this->last_price->EditValue = HtmlEncode($this->last_price->AdvancedSearch->SearchValue);
			$this->last_price->PlaceHolder = RemoveHtml($this->last_price->caption());

			// v_01
			$this->v_01->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_01->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_01->AdvancedSearch->ViewValue = $this->v_01->lookupCacheOption($curVal);
			else
				$this->v_01->AdvancedSearch->ViewValue = $this->v_01->Lookup !== NULL && is_array($this->v_01->Lookup->Options) ? $curVal : NULL;
			if ($this->v_01->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_01->EditValue = array_values($this->v_01->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 101 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_01->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_01->EditValue = $arwrk;
			}

			// v_02
			$this->v_02->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_02->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_02->AdvancedSearch->ViewValue = $this->v_02->lookupCacheOption($curVal);
			else
				$this->v_02->AdvancedSearch->ViewValue = $this->v_02->Lookup !== NULL && is_array($this->v_02->Lookup->Options) ? $curVal : NULL;
			if ($this->v_02->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_02->EditValue = array_values($this->v_02->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 102 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_02->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_02->EditValue = $arwrk;
			}

			// v_03
			$this->v_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_03->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_03->AdvancedSearch->ViewValue = $this->v_03->lookupCacheOption($curVal);
			else
				$this->v_03->AdvancedSearch->ViewValue = $this->v_03->Lookup !== NULL && is_array($this->v_03->Lookup->Options) ? $curVal : NULL;
			if ($this->v_03->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_03->EditValue = array_values($this->v_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 103 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_03->EditValue = $arwrk;
			}

			// v_04
			$this->v_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_04->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_04->AdvancedSearch->ViewValue = $this->v_04->lookupCacheOption($curVal);
			else
				$this->v_04->AdvancedSearch->ViewValue = $this->v_04->Lookup !== NULL && is_array($this->v_04->Lookup->Options) ? $curVal : NULL;
			if ($this->v_04->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_04->EditValue = array_values($this->v_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 104 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_04->EditValue = $arwrk;
			}

			// v_05
			$this->v_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_05->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_05->AdvancedSearch->ViewValue = $this->v_05->lookupCacheOption($curVal);
			else
				$this->v_05->AdvancedSearch->ViewValue = $this->v_05->Lookup !== NULL && is_array($this->v_05->Lookup->Options) ? $curVal : NULL;
			if ($this->v_05->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_05->EditValue = array_values($this->v_05->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 105 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_05->EditValue = $arwrk;
			}

			// v_06
			$this->v_06->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_06->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_06->AdvancedSearch->ViewValue = $this->v_06->lookupCacheOption($curVal);
			else
				$this->v_06->AdvancedSearch->ViewValue = $this->v_06->Lookup !== NULL && is_array($this->v_06->Lookup->Options) ? $curVal : NULL;
			if ($this->v_06->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_06->EditValue = array_values($this->v_06->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 106 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_06->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_06->EditValue = $arwrk;
			}

			// v_07
			$this->v_07->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_07->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_07->AdvancedSearch->ViewValue = $this->v_07->lookupCacheOption($curVal);
			else
				$this->v_07->AdvancedSearch->ViewValue = $this->v_07->Lookup !== NULL && is_array($this->v_07->Lookup->Options) ? $curVal : NULL;
			if ($this->v_07->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_07->EditValue = array_values($this->v_07->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 107 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_07->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_07->EditValue = $arwrk;
			}

			// v_08
			$this->v_08->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_08->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_08->AdvancedSearch->ViewValue = $this->v_08->lookupCacheOption($curVal);
			else
				$this->v_08->AdvancedSearch->ViewValue = $this->v_08->Lookup !== NULL && is_array($this->v_08->Lookup->Options) ? $curVal : NULL;
			if ($this->v_08->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_08->EditValue = array_values($this->v_08->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 108 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_08->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_08->EditValue = $arwrk;
			}

			// v_09
			$this->v_09->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_09->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_09->AdvancedSearch->ViewValue = $this->v_09->lookupCacheOption($curVal);
			else
				$this->v_09->AdvancedSearch->ViewValue = $this->v_09->Lookup !== NULL && is_array($this->v_09->Lookup->Options) ? $curVal : NULL;
			if ($this->v_09->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_09->EditValue = array_values($this->v_09->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 109 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_09->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_09->EditValue = $arwrk;
			}

			// v_10
			$this->v_10->EditCustomAttributes = "";
			$curVal = trim(strval($this->v_10->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->v_10->AdvancedSearch->ViewValue = $this->v_10->lookupCacheOption($curVal);
			else
				$this->v_10->AdvancedSearch->ViewValue = $this->v_10->Lookup !== NULL && is_array($this->v_10->Lookup->Options) ? $curVal : NULL;
			if ($this->v_10->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->v_10->EditValue = array_values($this->v_10->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 110 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->v_10->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->v_10->EditValue = $arwrk;
			}

			// b_01
			$this->b_01->EditAttrs["class"] = "form-control";
			$this->b_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_01->AdvancedSearch->SearchValue = HtmlDecode($this->b_01->AdvancedSearch->SearchValue);
			$this->b_01->EditValue = HtmlEncode($this->b_01->AdvancedSearch->SearchValue);
			$this->b_01->PlaceHolder = RemoveHtml($this->b_01->caption());

			// b_02
			$this->b_02->EditAttrs["class"] = "form-control";
			$this->b_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_02->AdvancedSearch->SearchValue = HtmlDecode($this->b_02->AdvancedSearch->SearchValue);
			$this->b_02->EditValue = HtmlEncode($this->b_02->AdvancedSearch->SearchValue);
			$this->b_02->PlaceHolder = RemoveHtml($this->b_02->caption());

			// b_03
			$this->b_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_03->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->b_03->AdvancedSearch->ViewValue = $this->b_03->lookupCacheOption($curVal);
			else
				$this->b_03->AdvancedSearch->ViewValue = $this->b_03->Lookup !== NULL && is_array($this->b_03->Lookup->Options) ? $curVal : NULL;
			if ($this->b_03->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->b_03->EditValue = array_values($this->b_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 203 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_03->EditValue = $arwrk;
			}

			// b_04
			$this->b_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_04->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->b_04->AdvancedSearch->ViewValue = $this->b_04->lookupCacheOption($curVal);
			else
				$this->b_04->AdvancedSearch->ViewValue = $this->b_04->Lookup !== NULL && is_array($this->b_04->Lookup->Options) ? $curVal : NULL;
			if ($this->b_04->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->b_04->EditValue = array_values($this->b_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 204 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_04->EditValue = $arwrk;
			}

			// b_05
			$this->b_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_05->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->b_05->AdvancedSearch->ViewValue = $this->b_05->lookupCacheOption($curVal);
			else
				$this->b_05->AdvancedSearch->ViewValue = $this->b_05->Lookup !== NULL && is_array($this->b_05->Lookup->Options) ? $curVal : NULL;
			if ($this->b_05->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->b_05->EditValue = array_values($this->b_05->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 205 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_05->EditValue = $arwrk;
			}

			// b_06
			$this->b_06->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_06->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->b_06->AdvancedSearch->ViewValue = $this->b_06->lookupCacheOption($curVal);
			else
				$this->b_06->AdvancedSearch->ViewValue = $this->b_06->Lookup !== NULL && is_array($this->b_06->Lookup->Options) ? $curVal : NULL;
			if ($this->b_06->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->b_06->EditValue = array_values($this->b_06->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 206 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_06->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_06->EditValue = $arwrk;
			}

			// b_07
			$this->b_07->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_07->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->b_07->AdvancedSearch->ViewValue = $this->b_07->lookupCacheOption($curVal);
			else
				$this->b_07->AdvancedSearch->ViewValue = $this->b_07->Lookup !== NULL && is_array($this->b_07->Lookup->Options) ? $curVal : NULL;
			if ($this->b_07->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->b_07->EditValue = array_values($this->b_07->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 207 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_07->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_07->EditValue = $arwrk;
			}

			// b_08
			$this->b_08->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_08->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->b_08->AdvancedSearch->ViewValue = $this->b_08->lookupCacheOption($curVal);
			else
				$this->b_08->AdvancedSearch->ViewValue = $this->b_08->Lookup !== NULL && is_array($this->b_08->Lookup->Options) ? $curVal : NULL;
			if ($this->b_08->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->b_08->EditValue = array_values($this->b_08->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 208 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_08->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_08->EditValue = $arwrk;
			}

			// b_09
			$this->b_09->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_09->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->b_09->AdvancedSearch->ViewValue = $this->b_09->lookupCacheOption($curVal);
			else
				$this->b_09->AdvancedSearch->ViewValue = $this->b_09->Lookup !== NULL && is_array($this->b_09->Lookup->Options) ? $curVal : NULL;
			if ($this->b_09->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->b_09->EditValue = array_values($this->b_09->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 209 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_09->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_09->EditValue = $arwrk;
			}

			// b_10
			$this->b_10->EditCustomAttributes = "";
			$curVal = trim(strval($this->b_10->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->b_10->AdvancedSearch->ViewValue = $this->b_10->lookupCacheOption($curVal);
			else
				$this->b_10->AdvancedSearch->ViewValue = $this->b_10->Lookup !== NULL && is_array($this->b_10->Lookup->Options) ? $curVal : NULL;
			if ($this->b_10->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->b_10->EditValue = array_values($this->b_10->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 210 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_10->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->b_10->EditValue = $arwrk;
			}

			// b_11
			$this->b_11->EditAttrs["class"] = "form-control";
			$this->b_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_11->AdvancedSearch->SearchValue = HtmlDecode($this->b_11->AdvancedSearch->SearchValue);
			$this->b_11->EditValue = HtmlEncode($this->b_11->AdvancedSearch->SearchValue);
			$this->b_11->PlaceHolder = RemoveHtml($this->b_11->caption());

			// b_12
			$this->b_12->EditAttrs["class"] = "form-control";
			$this->b_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_12->AdvancedSearch->SearchValue = HtmlDecode($this->b_12->AdvancedSearch->SearchValue);
			$this->b_12->EditValue = HtmlEncode($this->b_12->AdvancedSearch->SearchValue);
			$this->b_12->PlaceHolder = RemoveHtml($this->b_12->caption());

			// b_13
			$this->b_13->EditAttrs["class"] = "form-control";
			$this->b_13->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_13->AdvancedSearch->SearchValue = HtmlDecode($this->b_13->AdvancedSearch->SearchValue);
			$this->b_13->EditValue = HtmlEncode($this->b_13->AdvancedSearch->SearchValue);
			$this->b_13->PlaceHolder = RemoveHtml($this->b_13->caption());

			// b_14
			$this->b_14->EditAttrs["class"] = "form-control";
			$this->b_14->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->b_14->AdvancedSearch->SearchValue = HtmlDecode($this->b_14->AdvancedSearch->SearchValue);
			$this->b_14->EditValue = HtmlEncode($this->b_14->AdvancedSearch->SearchValue);
			$this->b_14->PlaceHolder = RemoveHtml($this->b_14->caption());

			// b_15
			$this->b_15->EditAttrs["class"] = "form-control";
			$this->b_15->EditCustomAttributes = "";

			// t_01
			$this->t_01->EditAttrs["class"] = "form-control";
			$this->t_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_01->AdvancedSearch->SearchValue = HtmlDecode($this->t_01->AdvancedSearch->SearchValue);
			$this->t_01->EditValue = HtmlEncode($this->t_01->AdvancedSearch->SearchValue);
			$this->t_01->PlaceHolder = RemoveHtml($this->t_01->caption());

			// t_02
			$this->t_02->EditAttrs["class"] = "form-control";
			$this->t_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_02->AdvancedSearch->SearchValue = HtmlDecode($this->t_02->AdvancedSearch->SearchValue);
			$this->t_02->EditValue = HtmlEncode($this->t_02->AdvancedSearch->SearchValue);
			$this->t_02->PlaceHolder = RemoveHtml($this->t_02->caption());

			// t_03
			$this->t_03->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_03->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->t_03->AdvancedSearch->ViewValue = $this->t_03->lookupCacheOption($curVal);
			else
				$this->t_03->AdvancedSearch->ViewValue = $this->t_03->Lookup !== NULL && is_array($this->t_03->Lookup->Options) ? $curVal : NULL;
			if ($this->t_03->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->t_03->EditValue = array_values($this->t_03->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 303 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_03->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_03->EditValue = $arwrk;
			}

			// t_04
			$this->t_04->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_04->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->t_04->AdvancedSearch->ViewValue = $this->t_04->lookupCacheOption($curVal);
			else
				$this->t_04->AdvancedSearch->ViewValue = $this->t_04->Lookup !== NULL && is_array($this->t_04->Lookup->Options) ? $curVal : NULL;
			if ($this->t_04->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->t_04->EditValue = array_values($this->t_04->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 304 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_04->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_04->EditValue = $arwrk;
			}

			// t_05
			$this->t_05->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_05->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->t_05->AdvancedSearch->ViewValue = $this->t_05->lookupCacheOption($curVal);
			else
				$this->t_05->AdvancedSearch->ViewValue = $this->t_05->Lookup !== NULL && is_array($this->t_05->Lookup->Options) ? $curVal : NULL;
			if ($this->t_05->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->t_05->EditValue = array_values($this->t_05->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 305 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_05->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_05->EditValue = $arwrk;
			}

			// t_06
			$this->t_06->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_06->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->t_06->AdvancedSearch->ViewValue = $this->t_06->lookupCacheOption($curVal);
			else
				$this->t_06->AdvancedSearch->ViewValue = $this->t_06->Lookup !== NULL && is_array($this->t_06->Lookup->Options) ? $curVal : NULL;
			if ($this->t_06->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->t_06->EditValue = array_values($this->t_06->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 306 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_06->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_06->EditValue = $arwrk;
			}

			// t_07
			$this->t_07->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_07->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->t_07->AdvancedSearch->ViewValue = $this->t_07->lookupCacheOption($curVal);
			else
				$this->t_07->AdvancedSearch->ViewValue = $this->t_07->Lookup !== NULL && is_array($this->t_07->Lookup->Options) ? $curVal : NULL;
			if ($this->t_07->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->t_07->EditValue = array_values($this->t_07->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 307 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_07->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_07->EditValue = $arwrk;
			}

			// t_08
			$this->t_08->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_08->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->t_08->AdvancedSearch->ViewValue = $this->t_08->lookupCacheOption($curVal);
			else
				$this->t_08->AdvancedSearch->ViewValue = $this->t_08->Lookup !== NULL && is_array($this->t_08->Lookup->Options) ? $curVal : NULL;
			if ($this->t_08->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->t_08->EditValue = array_values($this->t_08->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 308 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_08->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_08->EditValue = $arwrk;
			}

			// t_09
			$this->t_09->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_09->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->t_09->AdvancedSearch->ViewValue = $this->t_09->lookupCacheOption($curVal);
			else
				$this->t_09->AdvancedSearch->ViewValue = $this->t_09->Lookup !== NULL && is_array($this->t_09->Lookup->Options) ? $curVal : NULL;
			if ($this->t_09->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->t_09->EditValue = array_values($this->t_09->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 309 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_09->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_09->EditValue = $arwrk;
			}

			// t_10
			$this->t_10->EditCustomAttributes = "";
			$curVal = trim(strval($this->t_10->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->t_10->AdvancedSearch->ViewValue = $this->t_10->lookupCacheOption($curVal);
			else
				$this->t_10->AdvancedSearch->ViewValue = $this->t_10->Lookup !== NULL && is_array($this->t_10->Lookup->Options) ? $curVal : NULL;
			if ($this->t_10->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->t_10->EditValue = array_values($this->t_10->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
				}
				$lookupFilter = function() {
					return "`status` = 1 and `no` = 310 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->t_10->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->t_10->EditValue = $arwrk;
			}

			// t_11
			$this->t_11->EditAttrs["class"] = "form-control";
			$this->t_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_11->AdvancedSearch->SearchValue = HtmlDecode($this->t_11->AdvancedSearch->SearchValue);
			$this->t_11->EditValue = HtmlEncode($this->t_11->AdvancedSearch->SearchValue);
			$curVal = strval($this->t_11->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->t_11->EditValue = $this->t_11->lookupCacheOption($curVal);
				if ($this->t_11->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_11->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->t_11->EditValue = $this->t_11->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_11->EditValue = HtmlEncode($this->t_11->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->t_11->EditValue = NULL;
			}
			$this->t_11->PlaceHolder = RemoveHtml($this->t_11->caption());

			// t_12
			$this->t_12->EditAttrs["class"] = "form-control";
			$this->t_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_12->AdvancedSearch->SearchValue = HtmlDecode($this->t_12->AdvancedSearch->SearchValue);
			$this->t_12->EditValue = HtmlEncode($this->t_12->AdvancedSearch->SearchValue);
			$curVal = strval($this->t_12->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->t_12->EditValue = $this->t_12->lookupCacheOption($curVal);
				if ($this->t_12->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_12->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->t_12->EditValue = $this->t_12->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_12->EditValue = HtmlEncode($this->t_12->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->t_12->EditValue = NULL;
			}
			$this->t_12->PlaceHolder = RemoveHtml($this->t_12->caption());

			// t_13
			$this->t_13->EditAttrs["class"] = "form-control";
			$this->t_13->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_13->AdvancedSearch->SearchValue = HtmlDecode($this->t_13->AdvancedSearch->SearchValue);
			$this->t_13->EditValue = HtmlEncode($this->t_13->AdvancedSearch->SearchValue);
			$this->t_13->PlaceHolder = RemoveHtml($this->t_13->caption());

			// t_14
			$this->t_14->EditAttrs["class"] = "form-control";
			$this->t_14->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_14->AdvancedSearch->SearchValue = HtmlDecode($this->t_14->AdvancedSearch->SearchValue);
			$this->t_14->EditValue = HtmlEncode($this->t_14->AdvancedSearch->SearchValue);
			$this->t_14->PlaceHolder = RemoveHtml($this->t_14->caption());

			// t_15
			$this->t_15->EditAttrs["class"] = "form-control";
			$this->t_15->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->t_15->AdvancedSearch->SearchValue = HtmlDecode($this->t_15->AdvancedSearch->SearchValue);
			$this->t_15->EditValue = HtmlEncode($this->t_15->AdvancedSearch->SearchValue);
			$this->t_15->PlaceHolder = RemoveHtml($this->t_15->caption());

			// d_head_01
			$this->d_head_01->EditAttrs["class"] = "form-control";
			$this->d_head_01->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->d_head_01->AdvancedSearch->SearchValue = HtmlDecode($this->d_head_01->AdvancedSearch->SearchValue);
			$this->d_head_01->EditValue = HtmlEncode($this->d_head_01->AdvancedSearch->SearchValue);
			$this->d_head_01->PlaceHolder = RemoveHtml($this->d_head_01->caption());

			// d_description_01
			$this->d_description_01->EditAttrs["class"] = "form-control";
			$this->d_description_01->EditCustomAttributes = "";
			$this->d_description_01->EditValue = HtmlEncode($this->d_description_01->AdvancedSearch->SearchValue);
			$this->d_description_01->PlaceHolder = RemoveHtml($this->d_description_01->caption());

			// d_head_02
			$this->d_head_02->EditAttrs["class"] = "form-control";
			$this->d_head_02->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->d_head_02->AdvancedSearch->SearchValue = HtmlDecode($this->d_head_02->AdvancedSearch->SearchValue);
			$this->d_head_02->EditValue = HtmlEncode($this->d_head_02->AdvancedSearch->SearchValue);
			$this->d_head_02->PlaceHolder = RemoveHtml($this->d_head_02->caption());

			// d_description_02
			$this->d_description_02->EditAttrs["class"] = "form-control";
			$this->d_description_02->EditCustomAttributes = "";
			$this->d_description_02->EditValue = HtmlEncode($this->d_description_02->AdvancedSearch->SearchValue);
			$this->d_description_02->PlaceHolder = RemoveHtml($this->d_description_02->caption());

			// main_image
			$this->main_image->EditAttrs["class"] = "form-control";
			$this->main_image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->main_image->AdvancedSearch->SearchValue = HtmlDecode($this->main_image->AdvancedSearch->SearchValue);
			$this->main_image->EditValue = HtmlEncode($this->main_image->AdvancedSearch->SearchValue);
			$this->main_image->PlaceHolder = RemoveHtml($this->main_image->caption());

			// top_view
			$this->top_view->EditAttrs["class"] = "form-control";
			$this->top_view->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->top_view->AdvancedSearch->SearchValue = HtmlDecode($this->top_view->AdvancedSearch->SearchValue);
			$this->top_view->EditValue = HtmlEncode($this->top_view->AdvancedSearch->SearchValue);
			$this->top_view->PlaceHolder = RemoveHtml($this->top_view->caption());

			// front_view
			$this->front_view->EditAttrs["class"] = "form-control";
			$this->front_view->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->front_view->AdvancedSearch->SearchValue = HtmlDecode($this->front_view->AdvancedSearch->SearchValue);
			$this->front_view->EditValue = HtmlEncode($this->front_view->AdvancedSearch->SearchValue);
			$this->front_view->PlaceHolder = RemoveHtml($this->front_view->caption());

			// corner_view
			$this->corner_view->EditAttrs["class"] = "form-control";
			$this->corner_view->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->corner_view->AdvancedSearch->SearchValue = HtmlDecode($this->corner_view->AdvancedSearch->SearchValue);
			$this->corner_view->EditValue = HtmlEncode($this->corner_view->AdvancedSearch->SearchValue);
			$this->corner_view->PlaceHolder = RemoveHtml($this->corner_view->caption());

			// back_view
			$this->back_view->EditAttrs["class"] = "form-control";
			$this->back_view->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->back_view->AdvancedSearch->SearchValue = HtmlDecode($this->back_view->AdvancedSearch->SearchValue);
			$this->back_view->EditValue = HtmlEncode($this->back_view->AdvancedSearch->SearchValue);
			$this->back_view->PlaceHolder = RemoveHtml($this->back_view->caption());

			// color_options
			$this->color_options->EditAttrs["class"] = "form-control";
			$this->color_options->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->color_options->AdvancedSearch->SearchValue = HtmlDecode($this->color_options->AdvancedSearch->SearchValue);
			$this->color_options->EditValue = HtmlEncode($this->color_options->AdvancedSearch->SearchValue);
			$this->color_options->PlaceHolder = RemoveHtml($this->color_options->caption());

			// other_options
			$this->other_options->EditAttrs["class"] = "form-control";
			$this->other_options->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->other_options->AdvancedSearch->SearchValue = HtmlDecode($this->other_options->AdvancedSearch->SearchValue);
			$this->other_options->EditValue = HtmlEncode($this->other_options->AdvancedSearch->SearchValue);
			$this->other_options->PlaceHolder = RemoveHtml($this->other_options->caption());

			// image
			$this->image->EditAttrs["class"] = "form-control";
			$this->image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->image->AdvancedSearch->SearchValue = HtmlDecode($this->image->AdvancedSearch->SearchValue);
			$this->image->EditValue = HtmlEncode($this->image->AdvancedSearch->SearchValue);
			$this->image->PlaceHolder = RemoveHtml($this->image->caption());

			// video_url
			$this->video_url->EditAttrs["class"] = "form-control";
			$this->video_url->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->video_url->AdvancedSearch->SearchValue = HtmlDecode($this->video_url->AdvancedSearch->SearchValue);
			$this->video_url->EditValue = HtmlEncode($this->video_url->AdvancedSearch->SearchValue);
			$this->video_url->PlaceHolder = RemoveHtml($this->video_url->caption());

			// currency
			$this->currency->EditAttrs["class"] = "form-control";
			$this->currency->EditCustomAttributes = "";
			$curVal = trim(strval($this->currency->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->currency->AdvancedSearch->ViewValue = $this->currency->lookupCacheOption($curVal);
			else
				$this->currency->AdvancedSearch->ViewValue = $this->currency->Lookup !== NULL && is_array($this->currency->Lookup->Options) ? $curVal : NULL;
			if ($this->currency->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->currency->EditValue = array_values($this->currency->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->currency->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->currency->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->currency->EditValue = $arwrk;
			}

			// hsn
			$this->hsn->EditAttrs["class"] = "form-control";
			$this->hsn->EditCustomAttributes = "";
			$curVal = trim(strval($this->hsn->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->hsn->AdvancedSearch->ViewValue = $this->hsn->lookupCacheOption($curVal);
			else
				$this->hsn->AdvancedSearch->ViewValue = $this->hsn->Lookup !== NULL && is_array($this->hsn->Lookup->Options) ? $curVal : NULL;
			if ($this->hsn->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->hsn->EditValue = array_values($this->hsn->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->hsn->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->hsn->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 2, -2, -2, -2);
				}
				$this->hsn->EditValue = $arwrk;
			}

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue2, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckNumber($this->last_price->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->last_price->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->grp->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->product_n->AdvancedSearch->load();
		$this->product_type->AdvancedSearch->load();
		$this->last_price->AdvancedSearch->load();
		$this->v_01->AdvancedSearch->load();
		$this->v_02->AdvancedSearch->load();
		$this->v_03->AdvancedSearch->load();
		$this->v_04->AdvancedSearch->load();
		$this->v_05->AdvancedSearch->load();
		$this->v_06->AdvancedSearch->load();
		$this->v_07->AdvancedSearch->load();
		$this->v_08->AdvancedSearch->load();
		$this->v_09->AdvancedSearch->load();
		$this->v_10->AdvancedSearch->load();
		$this->b_01->AdvancedSearch->load();
		$this->b_02->AdvancedSearch->load();
		$this->b_03->AdvancedSearch->load();
		$this->b_04->AdvancedSearch->load();
		$this->b_05->AdvancedSearch->load();
		$this->b_06->AdvancedSearch->load();
		$this->b_07->AdvancedSearch->load();
		$this->b_08->AdvancedSearch->load();
		$this->b_09->AdvancedSearch->load();
		$this->b_10->AdvancedSearch->load();
		$this->b_11->AdvancedSearch->load();
		$this->b_12->AdvancedSearch->load();
		$this->b_13->AdvancedSearch->load();
		$this->b_14->AdvancedSearch->load();
		$this->b_15->AdvancedSearch->load();
		$this->t_01->AdvancedSearch->load();
		$this->t_02->AdvancedSearch->load();
		$this->t_03->AdvancedSearch->load();
		$this->t_04->AdvancedSearch->load();
		$this->t_05->AdvancedSearch->load();
		$this->t_06->AdvancedSearch->load();
		$this->t_07->AdvancedSearch->load();
		$this->t_08->AdvancedSearch->load();
		$this->t_09->AdvancedSearch->load();
		$this->t_10->AdvancedSearch->load();
		$this->t_11->AdvancedSearch->load();
		$this->t_12->AdvancedSearch->load();
		$this->t_13->AdvancedSearch->load();
		$this->t_14->AdvancedSearch->load();
		$this->t_15->AdvancedSearch->load();
		$this->d_head_01->AdvancedSearch->load();
		$this->d_description_01->AdvancedSearch->load();
		$this->d_head_02->AdvancedSearch->load();
		$this->d_description_02->AdvancedSearch->load();
		$this->main_image->AdvancedSearch->load();
		$this->top_view->AdvancedSearch->load();
		$this->front_view->AdvancedSearch->load();
		$this->corner_view->AdvancedSearch->load();
		$this->back_view->AdvancedSearch->load();
		$this->color_options->AdvancedSearch->load();
		$this->other_options->AdvancedSearch->load();
		$this->image->AdvancedSearch->load();
		$this->video_url->AdvancedSearch->load();
		$this->currency->AdvancedSearch->load();
		$this->hsn->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ref_multilist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `id` > 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 200000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1 and `id` = 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_01":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_02":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 106 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 107 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 108 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 109 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 110 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 203 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 204 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 205 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 206 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 207 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 208 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 209 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 210 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 303 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 304 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 305 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 306 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 307 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 308 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 309 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 310 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_11":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_12":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_hsn":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_product_type":
							break;
						case "x_v_01":
							break;
						case "x_v_02":
							break;
						case "x_v_03":
							break;
						case "x_v_04":
							break;
						case "x_v_05":
							break;
						case "x_v_06":
							break;
						case "x_v_07":
							break;
						case "x_v_08":
							break;
						case "x_v_09":
							break;
						case "x_v_10":
							break;
						case "x_shape":
							break;
						case "x_b_03":
							break;
						case "x_b_04":
							break;
						case "x_b_05":
							break;
						case "x_b_06":
							break;
						case "x_b_07":
							break;
						case "x_b_08":
							break;
						case "x_b_09":
							break;
						case "x_b_10":
							break;
						case "x_t_03":
							break;
						case "x_t_04":
							break;
						case "x_t_05":
							break;
						case "x_t_06":
							break;
						case "x_t_07":
							break;
						case "x_t_08":
							break;
						case "x_t_09":
							break;
						case "x_t_10":
							break;
						case "x_t_11":
							break;
						case "x_t_12":
							break;
						case "x_currency":
							break;
						case "x_hsn":
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'ref_multi');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>