<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class ref_multi_view extends ref_multi
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'ref_multi';

	// Page object name
	public $PageObjName = "ref_multi_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (ref_multi)
		if (!isset($GLOBALS["ref_multi"]) || get_class($GLOBALS["ref_multi"]) == PROJECT_NAMESPACE . "ref_multi") {
			$GLOBALS["ref_multi"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["ref_multi"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'ref_multi');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $ref_multi;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($ref_multi);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "ref_multiview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("ref_multilist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->oid->Visible = FALSE;
		$this->_barcode->Visible = FALSE;
		$this->company_id->setVisibility();
		$this->grp->setVisibility();
		$this->s_grp->setVisibility();
		$this->product->setVisibility();
		$this->product_n->setVisibility();
		$this->product_type->setVisibility();
		$this->product_code->Visible = FALSE;
		$this->gcode->Visible = FALSE;
		$this->code->Visible = FALSE;
		$this->product_id->Visible = FALSE;
		$this->print_name->Visible = FALSE;
		$this->batch_no->Visible = FALSE;
		$this->last_price->setVisibility();
		$this->v_01->setVisibility();
		$this->v_02->setVisibility();
		$this->v_03->setVisibility();
		$this->v_04->setVisibility();
		$this->v_05->setVisibility();
		$this->v_06->setVisibility();
		$this->v_07->setVisibility();
		$this->v_08->setVisibility();
		$this->v_09->setVisibility();
		$this->v_10->setVisibility();
		$this->cbm->setVisibility();
		$this->sqm->setVisibility();
		$this->shape->setVisibility();
		$this->b_01->setVisibility();
		$this->b_02->setVisibility();
		$this->b_03->setVisibility();
		$this->b_04->setVisibility();
		$this->b_05->setVisibility();
		$this->b_06->setVisibility();
		$this->b_07->setVisibility();
		$this->b_08->setVisibility();
		$this->b_09->setVisibility();
		$this->b_10->setVisibility();
		$this->b_11->setVisibility();
		$this->b_12->setVisibility();
		$this->b_13->setVisibility();
		$this->b_14->setVisibility();
		$this->b_15->setVisibility();
		$this->t_01->setVisibility();
		$this->t_02->setVisibility();
		$this->t_03->setVisibility();
		$this->t_04->setVisibility();
		$this->t_05->setVisibility();
		$this->t_06->setVisibility();
		$this->t_07->setVisibility();
		$this->t_08->setVisibility();
		$this->t_09->setVisibility();
		$this->t_10->setVisibility();
		$this->t_11->setVisibility();
		$this->t_12->setVisibility();
		$this->t_13->setVisibility();
		$this->t_14->setVisibility();
		$this->t_15->setVisibility();
		$this->d_head_01->setVisibility();
		$this->d_description_01->setVisibility();
		$this->d_head_02->setVisibility();
		$this->d_description_02->setVisibility();
		$this->main_image->setVisibility();
		$this->top_view->setVisibility();
		$this->front_view->setVisibility();
		$this->corner_view->setVisibility();
		$this->back_view->setVisibility();
		$this->color_options->setVisibility();
		$this->other_options->setVisibility();
		$this->image->setVisibility();
		$this->video_url->setVisibility();
		$this->currency->setVisibility();
		$this->hsn->setVisibility();
		$this->minimum_stock->Visible = FALSE;
		$this->in->Visible = FALSE;
		$this->out->Visible = FALSE;
		$this->required->Visible = FALSE;
		$this->blocked->Visible = FALSE;
		$this->ordered->Visible = FALSE;
		$this->status->setVisibility();
		$this->publish->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->s_grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->product_type);
		$this->setupLookupOptions($this->v_01);
		$this->setupLookupOptions($this->v_02);
		$this->setupLookupOptions($this->v_03);
		$this->setupLookupOptions($this->v_04);
		$this->setupLookupOptions($this->v_05);
		$this->setupLookupOptions($this->v_06);
		$this->setupLookupOptions($this->v_07);
		$this->setupLookupOptions($this->v_08);
		$this->setupLookupOptions($this->v_09);
		$this->setupLookupOptions($this->v_10);
		$this->setupLookupOptions($this->shape);
		$this->setupLookupOptions($this->b_03);
		$this->setupLookupOptions($this->b_04);
		$this->setupLookupOptions($this->b_05);
		$this->setupLookupOptions($this->b_06);
		$this->setupLookupOptions($this->b_07);
		$this->setupLookupOptions($this->b_08);
		$this->setupLookupOptions($this->b_09);
		$this->setupLookupOptions($this->b_10);
		$this->setupLookupOptions($this->t_03);
		$this->setupLookupOptions($this->t_04);
		$this->setupLookupOptions($this->t_05);
		$this->setupLookupOptions($this->t_06);
		$this->setupLookupOptions($this->t_07);
		$this->setupLookupOptions($this->t_08);
		$this->setupLookupOptions($this->t_09);
		$this->setupLookupOptions($this->t_10);
		$this->setupLookupOptions($this->t_11);
		$this->setupLookupOptions($this->t_12);
		$this->setupLookupOptions($this->currency);
		$this->setupLookupOptions($this->hsn);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "ref_multilist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "ref_multilist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "ref_multilist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Set up detail parameters
		$this->setupDetailParms();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->canEdit());

		// Copy
		$item = &$option->add("copy");
		$copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,btn:'AddBtn',url:'" . HtmlEncode($this->CopyUrl) . "'});\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl <> "" && $Security->canAdd());

		// Delete
		$item = &$option->add("delete");
		if ($this->IsModal) // Handle as inline delete
			$item->Body = "<a onclick=\"return ew.confirmDelete(this);\" class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode(UrlAddQuery($this->DeleteUrl, "action=1")) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->canDelete());
		$option = &$options["detail"];
		$detailTableLink = "";
		$detailViewTblVar = "";
		$detailCopyTblVar = "";
		$detailEditTblVar = "";

		// "detail__ref_view"
		$item = &$option->add("detail__ref_view");
		$body = $Language->phrase("ViewPageDetailLink") . $Language->TablePhrase("_ref_view", "TblCaption");
		$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("_ref_viewlist.php?" . TABLE_SHOW_MASTER . "=ref_multi&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "") . "\">" . $body . "</a>";
		$links = "";
		if (!isset($GLOBALS["_ref_view_grid"]))
			$GLOBALS["_ref_view_grid"] = new _ref_view_grid();
		if ($GLOBALS["_ref_view_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 'ref_view')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=_ref_view")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			if ($detailViewTblVar <> "")
				$detailViewTblVar .= ",";
			$detailViewTblVar .= "_ref_view";
		}
		if ($GLOBALS["_ref_view_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 'ref_view')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=_ref_view")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			if ($detailEditTblVar <> "")
				$detailEditTblVar .= ",";
			$detailEditTblVar .= "_ref_view";
		}
		if ($GLOBALS["_ref_view_grid"]->DetailAdd && $Security->canAdd() && $Security->allowAdd(CurrentProjectID() . 'ref_view')) {
			$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(TABLE_SHOW_DETAIL . "=_ref_view")) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			if ($detailCopyTblVar <> "")
				$detailCopyTblVar .= ",";
			$detailCopyTblVar .= "_ref_view";
		}
		if ($links <> "") {
			$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
			$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
		}
		$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
		$item->Body = $body;
		$item->Visible = $Security->allowList(CurrentProjectID() . 'ref_view');
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "_ref_view";
		}
		if ($this->ShowMultipleDetails)
			$item->Visible = FALSE;

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
			$links = "";
			if ($detailViewTblVar <> "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=" . $detailViewTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($detailEditTblVar <> "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=" . $detailEditTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($detailCopyTblVar <> "") {
				$links .= "<li><a class=\"ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->getCopyUrl(TABLE_SHOW_DETAIL . "=" . $detailCopyTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlTitle($Language->phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
				$body .= "<ul class=\"dropdown-menu ew-menu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$opt = &$option->add("details");
			$opt->Body = $body;
		}

		// Set up detail default
		$option = &$options["detail"];
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$ar = explode(",", $detailTableLink);
		$cnt = count($ar);
		$option->UseDropDownButton = ($cnt > 1);
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		if ($this->AuditTrailOnView)
			$this->writeAuditTrailOnView($row);
		$this->id->setDbValue($row['id']);
		$this->oid->setDbValue($row['oid']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->company_id->setDbValue($row['company_id']);
		$this->grp->setDbValue($row['grp']);
		$this->s_grp->setDbValue($row['s_grp']);
		$this->product->setDbValue($row['product']);
		$this->product_n->setDbValue($row['product_n']);
		$this->product_type->setDbValue($row['product_type']);
		$this->product_code->setDbValue($row['product_code']);
		$this->gcode->setDbValue($row['gcode']);
		$this->code->setDbValue($row['code']);
		$this->product_id->setDbValue($row['product_id']);
		$this->print_name->setDbValue($row['print_name']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->last_price->setDbValue($row['last_price']);
		$this->v_01->setDbValue($row['v_01']);
		$this->v_02->setDbValue($row['v_02']);
		$this->v_03->setDbValue($row['v_03']);
		$this->v_04->setDbValue($row['v_04']);
		$this->v_05->setDbValue($row['v_05']);
		$this->v_06->setDbValue($row['v_06']);
		$this->v_07->setDbValue($row['v_07']);
		$this->v_08->setDbValue($row['v_08']);
		$this->v_09->setDbValue($row['v_09']);
		$this->v_10->setDbValue($row['v_10']);
		$this->cbm->setDbValue($row['cbm']);
		$this->sqm->setDbValue($row['sqm']);
		$this->shape->setDbValue($row['shape']);
		$this->b_01->setDbValue($row['b_01']);
		$this->b_02->setDbValue($row['b_02']);
		$this->b_03->setDbValue($row['b_03']);
		$this->b_04->setDbValue($row['b_04']);
		$this->b_05->setDbValue($row['b_05']);
		$this->b_06->setDbValue($row['b_06']);
		$this->b_07->setDbValue($row['b_07']);
		$this->b_08->setDbValue($row['b_08']);
		$this->b_09->setDbValue($row['b_09']);
		$this->b_10->setDbValue($row['b_10']);
		$this->b_11->setDbValue($row['b_11']);
		$this->b_12->setDbValue($row['b_12']);
		$this->b_13->setDbValue($row['b_13']);
		$this->b_14->setDbValue($row['b_14']);
		$this->b_15->setDbValue($row['b_15']);
		$this->t_01->setDbValue($row['t_01']);
		$this->t_02->setDbValue($row['t_02']);
		$this->t_03->setDbValue($row['t_03']);
		$this->t_04->setDbValue($row['t_04']);
		$this->t_05->setDbValue($row['t_05']);
		$this->t_06->setDbValue($row['t_06']);
		$this->t_07->setDbValue($row['t_07']);
		$this->t_08->setDbValue($row['t_08']);
		$this->t_09->setDbValue($row['t_09']);
		$this->t_10->setDbValue($row['t_10']);
		$this->t_11->setDbValue($row['t_11']);
		$this->t_12->setDbValue($row['t_12']);
		$this->t_13->setDbValue($row['t_13']);
		$this->t_14->setDbValue($row['t_14']);
		$this->t_15->setDbValue($row['t_15']);
		$this->d_head_01->setDbValue($row['d_head_01']);
		$this->d_description_01->setDbValue($row['d_description_01']);
		$this->d_head_02->setDbValue($row['d_head_02']);
		$this->d_description_02->setDbValue($row['d_description_02']);
		$this->main_image->Upload->DbValue = $row['main_image'];
		$this->main_image->setDbValue($this->main_image->Upload->DbValue);
		$this->top_view->Upload->DbValue = $row['top_view'];
		$this->top_view->setDbValue($this->top_view->Upload->DbValue);
		$this->front_view->Upload->DbValue = $row['front_view'];
		$this->front_view->setDbValue($this->front_view->Upload->DbValue);
		$this->corner_view->Upload->DbValue = $row['corner_view'];
		$this->corner_view->setDbValue($this->corner_view->Upload->DbValue);
		$this->back_view->Upload->DbValue = $row['back_view'];
		$this->back_view->setDbValue($this->back_view->Upload->DbValue);
		$this->color_options->Upload->DbValue = $row['color_options'];
		$this->color_options->setDbValue($this->color_options->Upload->DbValue);
		$this->other_options->Upload->DbValue = $row['other_options'];
		$this->other_options->setDbValue($this->other_options->Upload->DbValue);
		$this->image->Upload->DbValue = $row['image'];
		$this->image->setDbValue($this->image->Upload->DbValue);
		$this->video_url->setDbValue($row['video_url']);
		$this->currency->setDbValue($row['currency']);
		$this->hsn->setDbValue($row['hsn']);
		$this->minimum_stock->setDbValue($row['minimum_stock']);
		$this->in->setDbValue($row['in']);
		$this->out->setDbValue($row['out']);
		$this->required->setDbValue($row['required']);
		$this->blocked->setDbValue($row['blocked']);
		$this->ordered->setDbValue($row['ordered']);
		$this->status->setDbValue($row['status']);
		$this->publish->setDbValue($row['publish']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['oid'] = NULL;
		$row['barcode'] = NULL;
		$row['company_id'] = NULL;
		$row['grp'] = NULL;
		$row['s_grp'] = NULL;
		$row['product'] = NULL;
		$row['product_n'] = NULL;
		$row['product_type'] = NULL;
		$row['product_code'] = NULL;
		$row['gcode'] = NULL;
		$row['code'] = NULL;
		$row['product_id'] = NULL;
		$row['print_name'] = NULL;
		$row['batch_no'] = NULL;
		$row['last_price'] = NULL;
		$row['v_01'] = NULL;
		$row['v_02'] = NULL;
		$row['v_03'] = NULL;
		$row['v_04'] = NULL;
		$row['v_05'] = NULL;
		$row['v_06'] = NULL;
		$row['v_07'] = NULL;
		$row['v_08'] = NULL;
		$row['v_09'] = NULL;
		$row['v_10'] = NULL;
		$row['cbm'] = NULL;
		$row['sqm'] = NULL;
		$row['shape'] = NULL;
		$row['b_01'] = NULL;
		$row['b_02'] = NULL;
		$row['b_03'] = NULL;
		$row['b_04'] = NULL;
		$row['b_05'] = NULL;
		$row['b_06'] = NULL;
		$row['b_07'] = NULL;
		$row['b_08'] = NULL;
		$row['b_09'] = NULL;
		$row['b_10'] = NULL;
		$row['b_11'] = NULL;
		$row['b_12'] = NULL;
		$row['b_13'] = NULL;
		$row['b_14'] = NULL;
		$row['b_15'] = NULL;
		$row['t_01'] = NULL;
		$row['t_02'] = NULL;
		$row['t_03'] = NULL;
		$row['t_04'] = NULL;
		$row['t_05'] = NULL;
		$row['t_06'] = NULL;
		$row['t_07'] = NULL;
		$row['t_08'] = NULL;
		$row['t_09'] = NULL;
		$row['t_10'] = NULL;
		$row['t_11'] = NULL;
		$row['t_12'] = NULL;
		$row['t_13'] = NULL;
		$row['t_14'] = NULL;
		$row['t_15'] = NULL;
		$row['d_head_01'] = NULL;
		$row['d_description_01'] = NULL;
		$row['d_head_02'] = NULL;
		$row['d_description_02'] = NULL;
		$row['main_image'] = NULL;
		$row['top_view'] = NULL;
		$row['front_view'] = NULL;
		$row['corner_view'] = NULL;
		$row['back_view'] = NULL;
		$row['color_options'] = NULL;
		$row['other_options'] = NULL;
		$row['image'] = NULL;
		$row['video_url'] = NULL;
		$row['currency'] = NULL;
		$row['hsn'] = NULL;
		$row['minimum_stock'] = NULL;
		$row['in'] = NULL;
		$row['out'] = NULL;
		$row['required'] = NULL;
		$row['blocked'] = NULL;
		$row['ordered'] = NULL;
		$row['status'] = NULL;
		$row['publish'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Convert decimal values if posted back
		if ($this->cbm->FormValue == $this->cbm->CurrentValue && is_numeric(ConvertToFloatString($this->cbm->CurrentValue)))
			$this->cbm->CurrentValue = ConvertToFloatString($this->cbm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->sqm->FormValue == $this->sqm->CurrentValue && is_numeric(ConvertToFloatString($this->sqm->CurrentValue)))
			$this->sqm->CurrentValue = ConvertToFloatString($this->sqm->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// oid
		// barcode
		// company_id
		// grp
		// s_grp
		// product
		// product_n
		// product_type
		// product_code
		// gcode
		// code
		// product_id
		// print_name
		// batch_no
		// last_price
		// v_01
		// v_02
		// v_03
		// v_04
		// v_05
		// v_06
		// v_07
		// v_08
		// v_09
		// v_10
		// cbm
		// sqm
		// shape
		// b_01
		// b_02
		// b_03
		// b_04
		// b_05
		// b_06
		// b_07
		// b_08
		// b_09
		// b_10
		// b_11
		// b_12
		// b_13
		// b_14
		// b_15
		// t_01
		// t_02
		// t_03
		// t_04
		// t_05
		// t_06
		// t_07
		// t_08
		// t_09
		// t_10
		// t_11
		// t_12
		// t_13
		// t_14
		// t_15
		// d_head_01
		// d_description_01
		// d_head_02
		// d_description_02
		// main_image
		// top_view
		// front_view
		// corner_view
		// back_view
		// color_options
		// other_options
		// image
		// video_url
		// currency
		// hsn
		// minimum_stock
		// in
		// out
		// required
		// blocked
		// ordered
		// status
		// publish
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `id` > 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 200000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// grp
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			$this->grp->ViewCustomAttributes = "";

			// s_grp
			$curVal = strval($this->s_grp->CurrentValue);
			if ($curVal <> "") {
				$this->s_grp->ViewValue = $this->s_grp->lookupCacheOption($curVal);
				if ($this->s_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->s_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->s_grp->ViewValue = $this->s_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
					}
				}
			} else {
				$this->s_grp->ViewValue = NULL;
			}
			$this->s_grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_n
			$this->product_n->ViewValue = $this->product_n->CurrentValue;
			$this->product_n->ViewCustomAttributes = "";

			// product_type
			$this->product_type->ViewValue = $this->product_type->CurrentValue;
			$curVal = strval($this->product_type->CurrentValue);
			if ($curVal <> "") {
				$this->product_type->ViewValue = $this->product_type->lookupCacheOption($curVal);
				if ($this->product_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `id` = 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_type->ViewValue = $this->product_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_type->ViewValue = $this->product_type->CurrentValue;
					}
				}
			} else {
				$this->product_type->ViewValue = NULL;
			}
			$this->product_type->ViewCustomAttributes = "";

			// last_price
			$this->last_price->ViewValue = $this->last_price->CurrentValue;
			$this->last_price->ViewCustomAttributes = "";

			// v_01
			$curVal = strval($this->v_01->CurrentValue);
			if ($curVal <> "") {
				$this->v_01->ViewValue = $this->v_01->lookupCacheOption($curVal);
				if ($this->v_01->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_01->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_01->ViewValue->add($this->v_01->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_01->ViewValue = $this->v_01->CurrentValue;
					}
				}
			} else {
				$this->v_01->ViewValue = NULL;
			}
			$this->v_01->ViewCustomAttributes = "";

			// v_02
			$curVal = strval($this->v_02->CurrentValue);
			if ($curVal <> "") {
				$this->v_02->ViewValue = $this->v_02->lookupCacheOption($curVal);
				if ($this->v_02->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_02->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_02->ViewValue->add($this->v_02->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_02->ViewValue = $this->v_02->CurrentValue;
					}
				}
			} else {
				$this->v_02->ViewValue = NULL;
			}
			$this->v_02->ViewCustomAttributes = "";

			// v_03
			$curVal = strval($this->v_03->CurrentValue);
			if ($curVal <> "") {
				$this->v_03->ViewValue = $this->v_03->lookupCacheOption($curVal);
				if ($this->v_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_03->ViewValue->add($this->v_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_03->ViewValue = $this->v_03->CurrentValue;
					}
				}
			} else {
				$this->v_03->ViewValue = NULL;
			}
			$this->v_03->ViewCustomAttributes = "";

			// v_04
			$curVal = strval($this->v_04->CurrentValue);
			if ($curVal <> "") {
				$this->v_04->ViewValue = $this->v_04->lookupCacheOption($curVal);
				if ($this->v_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_04->ViewValue->add($this->v_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_04->ViewValue = $this->v_04->CurrentValue;
					}
				}
			} else {
				$this->v_04->ViewValue = NULL;
			}
			$this->v_04->ViewCustomAttributes = "";

			// v_05
			$curVal = strval($this->v_05->CurrentValue);
			if ($curVal <> "") {
				$this->v_05->ViewValue = $this->v_05->lookupCacheOption($curVal);
				if ($this->v_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_05->ViewValue->add($this->v_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_05->ViewValue = $this->v_05->CurrentValue;
					}
				}
			} else {
				$this->v_05->ViewValue = NULL;
			}
			$this->v_05->ViewCustomAttributes = "";

			// v_06
			$curVal = strval($this->v_06->CurrentValue);
			if ($curVal <> "") {
				$this->v_06->ViewValue = $this->v_06->lookupCacheOption($curVal);
				if ($this->v_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 106 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_06->ViewValue->add($this->v_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_06->ViewValue = $this->v_06->CurrentValue;
					}
				}
			} else {
				$this->v_06->ViewValue = NULL;
			}
			$this->v_06->ViewCustomAttributes = "";

			// v_07
			$curVal = strval($this->v_07->CurrentValue);
			if ($curVal <> "") {
				$this->v_07->ViewValue = $this->v_07->lookupCacheOption($curVal);
				if ($this->v_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 107 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_07->ViewValue->add($this->v_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_07->ViewValue = $this->v_07->CurrentValue;
					}
				}
			} else {
				$this->v_07->ViewValue = NULL;
			}
			$this->v_07->ViewCustomAttributes = "";

			// v_08
			$curVal = strval($this->v_08->CurrentValue);
			if ($curVal <> "") {
				$this->v_08->ViewValue = $this->v_08->lookupCacheOption($curVal);
				if ($this->v_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 108 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_08->ViewValue->add($this->v_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_08->ViewValue = $this->v_08->CurrentValue;
					}
				}
			} else {
				$this->v_08->ViewValue = NULL;
			}
			$this->v_08->ViewCustomAttributes = "";

			// v_09
			$curVal = strval($this->v_09->CurrentValue);
			if ($curVal <> "") {
				$this->v_09->ViewValue = $this->v_09->lookupCacheOption($curVal);
				if ($this->v_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 109 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_09->ViewValue->add($this->v_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_09->ViewValue = $this->v_09->CurrentValue;
					}
				}
			} else {
				$this->v_09->ViewValue = NULL;
			}
			$this->v_09->ViewCustomAttributes = "";

			// v_10
			$curVal = strval($this->v_10->CurrentValue);
			if ($curVal <> "") {
				$this->v_10->ViewValue = $this->v_10->lookupCacheOption($curVal);
				if ($this->v_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`code`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 110 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->v_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->v_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = $rswrk->fields('df2');
							$this->v_10->ViewValue->add($this->v_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->v_10->ViewValue = $this->v_10->CurrentValue;
					}
				}
			} else {
				$this->v_10->ViewValue = NULL;
			}
			$this->v_10->ViewCustomAttributes = "";

			// cbm
			$this->cbm->ViewValue = $this->cbm->CurrentValue;
			$this->cbm->ViewCustomAttributes = "";

			// sqm
			$this->sqm->ViewValue = $this->sqm->CurrentValue;
			$this->sqm->ViewCustomAttributes = "";

			// shape
			$curVal = strval($this->shape->CurrentValue);
			if ($curVal <> "") {
				$this->shape->ViewValue = $this->shape->lookupCacheOption($curVal);
				if ($this->shape->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->shape->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->shape->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->shape->ViewValue->add($this->shape->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->shape->ViewValue = $this->shape->CurrentValue;
					}
				}
			} else {
				$this->shape->ViewValue = NULL;
			}
			$this->shape->ViewCustomAttributes = "";

			// b_01
			$this->b_01->ViewValue = $this->b_01->CurrentValue;
			$this->b_01->ViewCustomAttributes = "";

			// b_02
			$this->b_02->ViewValue = $this->b_02->CurrentValue;
			$this->b_02->ViewCustomAttributes = "";

			// b_03
			$curVal = strval($this->b_03->CurrentValue);
			if ($curVal <> "") {
				$this->b_03->ViewValue = $this->b_03->lookupCacheOption($curVal);
				if ($this->b_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 203 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_03->ViewValue->add($this->b_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_03->ViewValue = $this->b_03->CurrentValue;
					}
				}
			} else {
				$this->b_03->ViewValue = NULL;
			}
			$this->b_03->ViewCustomAttributes = "";

			// b_04
			$curVal = strval($this->b_04->CurrentValue);
			if ($curVal <> "") {
				$this->b_04->ViewValue = $this->b_04->lookupCacheOption($curVal);
				if ($this->b_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 204 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_04->ViewValue->add($this->b_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_04->ViewValue = $this->b_04->CurrentValue;
					}
				}
			} else {
				$this->b_04->ViewValue = NULL;
			}
			$this->b_04->ViewCustomAttributes = "";

			// b_05
			$curVal = strval($this->b_05->CurrentValue);
			if ($curVal <> "") {
				$this->b_05->ViewValue = $this->b_05->lookupCacheOption($curVal);
				if ($this->b_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 205 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_05->ViewValue->add($this->b_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_05->ViewValue = $this->b_05->CurrentValue;
					}
				}
			} else {
				$this->b_05->ViewValue = NULL;
			}
			$this->b_05->ViewCustomAttributes = "";

			// b_06
			$curVal = strval($this->b_06->CurrentValue);
			if ($curVal <> "") {
				$this->b_06->ViewValue = $this->b_06->lookupCacheOption($curVal);
				if ($this->b_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 206 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_06->ViewValue->add($this->b_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_06->ViewValue = $this->b_06->CurrentValue;
					}
				}
			} else {
				$this->b_06->ViewValue = NULL;
			}
			$this->b_06->ViewCustomAttributes = "";

			// b_07
			$curVal = strval($this->b_07->CurrentValue);
			if ($curVal <> "") {
				$this->b_07->ViewValue = $this->b_07->lookupCacheOption($curVal);
				if ($this->b_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 207 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_07->ViewValue->add($this->b_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_07->ViewValue = $this->b_07->CurrentValue;
					}
				}
			} else {
				$this->b_07->ViewValue = NULL;
			}
			$this->b_07->ViewCustomAttributes = "";

			// b_08
			$curVal = strval($this->b_08->CurrentValue);
			if ($curVal <> "") {
				$this->b_08->ViewValue = $this->b_08->lookupCacheOption($curVal);
				if ($this->b_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 208 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_08->ViewValue->add($this->b_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_08->ViewValue = $this->b_08->CurrentValue;
					}
				}
			} else {
				$this->b_08->ViewValue = NULL;
			}
			$this->b_08->ViewCustomAttributes = "";

			// b_09
			$curVal = strval($this->b_09->CurrentValue);
			if ($curVal <> "") {
				$this->b_09->ViewValue = $this->b_09->lookupCacheOption($curVal);
				if ($this->b_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 209 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_09->ViewValue->add($this->b_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_09->ViewValue = $this->b_09->CurrentValue;
					}
				}
			} else {
				$this->b_09->ViewValue = NULL;
			}
			$this->b_09->ViewCustomAttributes = "";

			// b_10
			$curVal = strval($this->b_10->CurrentValue);
			if ($curVal <> "") {
				$this->b_10->ViewValue = $this->b_10->lookupCacheOption($curVal);
				if ($this->b_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 210 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->b_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->b_10->ViewValue->add($this->b_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->b_10->ViewValue = $this->b_10->CurrentValue;
					}
				}
			} else {
				$this->b_10->ViewValue = NULL;
			}
			$this->b_10->ViewCustomAttributes = "";

			// b_11
			$this->b_11->ViewValue = $this->b_11->CurrentValue;
			$this->b_11->ViewCustomAttributes = "";

			// b_12
			$this->b_12->ViewValue = $this->b_12->CurrentValue;
			$this->b_12->ViewCustomAttributes = "";

			// b_13
			$this->b_13->ViewValue = $this->b_13->CurrentValue;
			$this->b_13->ViewCustomAttributes = "";

			// b_14
			$this->b_14->ViewValue = $this->b_14->CurrentValue;
			$this->b_14->ViewCustomAttributes = "";

			// b_15
			$this->b_15->ViewCustomAttributes = "";

			// t_01
			$this->t_01->ViewValue = $this->t_01->CurrentValue;
			$this->t_01->ViewCustomAttributes = "";

			// t_02
			$this->t_02->ViewValue = $this->t_02->CurrentValue;
			$this->t_02->ViewCustomAttributes = "";

			// t_03
			$curVal = strval($this->t_03->CurrentValue);
			if ($curVal <> "") {
				$this->t_03->ViewValue = $this->t_03->lookupCacheOption($curVal);
				if ($this->t_03->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 303 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_03->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_03->ViewValue->add($this->t_03->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_03->ViewValue = $this->t_03->CurrentValue;
					}
				}
			} else {
				$this->t_03->ViewValue = NULL;
			}
			$this->t_03->ViewCustomAttributes = "";

			// t_04
			$curVal = strval($this->t_04->CurrentValue);
			if ($curVal <> "") {
				$this->t_04->ViewValue = $this->t_04->lookupCacheOption($curVal);
				if ($this->t_04->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 304 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_04->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_04->ViewValue->add($this->t_04->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_04->ViewValue = $this->t_04->CurrentValue;
					}
				}
			} else {
				$this->t_04->ViewValue = NULL;
			}
			$this->t_04->ViewCustomAttributes = "";

			// t_05
			$curVal = strval($this->t_05->CurrentValue);
			if ($curVal <> "") {
				$this->t_05->ViewValue = $this->t_05->lookupCacheOption($curVal);
				if ($this->t_05->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 305 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_05->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_05->ViewValue->add($this->t_05->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_05->ViewValue = $this->t_05->CurrentValue;
					}
				}
			} else {
				$this->t_05->ViewValue = NULL;
			}
			$this->t_05->ViewCustomAttributes = "";

			// t_06
			$curVal = strval($this->t_06->CurrentValue);
			if ($curVal <> "") {
				$this->t_06->ViewValue = $this->t_06->lookupCacheOption($curVal);
				if ($this->t_06->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 306 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_06->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_06->ViewValue->add($this->t_06->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_06->ViewValue = $this->t_06->CurrentValue;
					}
				}
			} else {
				$this->t_06->ViewValue = NULL;
			}
			$this->t_06->ViewCustomAttributes = "";

			// t_07
			$curVal = strval($this->t_07->CurrentValue);
			if ($curVal <> "") {
				$this->t_07->ViewValue = $this->t_07->lookupCacheOption($curVal);
				if ($this->t_07->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 307 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_07->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_07->ViewValue->add($this->t_07->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_07->ViewValue = $this->t_07->CurrentValue;
					}
				}
			} else {
				$this->t_07->ViewValue = NULL;
			}
			$this->t_07->ViewCustomAttributes = "";

			// t_08
			$curVal = strval($this->t_08->CurrentValue);
			if ($curVal <> "") {
				$this->t_08->ViewValue = $this->t_08->lookupCacheOption($curVal);
				if ($this->t_08->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 308 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_08->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_08->ViewValue->add($this->t_08->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_08->ViewValue = $this->t_08->CurrentValue;
					}
				}
			} else {
				$this->t_08->ViewValue = NULL;
			}
			$this->t_08->ViewCustomAttributes = "";

			// t_09
			$curVal = strval($this->t_09->CurrentValue);
			if ($curVal <> "") {
				$this->t_09->ViewValue = $this->t_09->lookupCacheOption($curVal);
				if ($this->t_09->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 309 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_09->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_09->ViewValue->add($this->t_09->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_09->ViewValue = $this->t_09->CurrentValue;
					}
				}
			} else {
				$this->t_09->ViewValue = NULL;
			}
			$this->t_09->ViewCustomAttributes = "";

			// t_10
			$curVal = strval($this->t_10->CurrentValue);
			if ($curVal <> "") {
				$this->t_10->ViewValue = $this->t_10->lookupCacheOption($curVal);
				if ($this->t_10->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`name`" . SearchString("=", trim($wrk), DATATYPE_STRING, "");
					}
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 310 and (
			(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->t_10->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->t_10->ViewValue->add($this->t_10->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->t_10->ViewValue = $this->t_10->CurrentValue;
					}
				}
			} else {
				$this->t_10->ViewValue = NULL;
			}
			$this->t_10->ViewCustomAttributes = "";

			// t_11
			$this->t_11->ViewValue = $this->t_11->CurrentValue;
			$curVal = strval($this->t_11->CurrentValue);
			if ($curVal <> "") {
				$this->t_11->ViewValue = $this->t_11->lookupCacheOption($curVal);
				if ($this->t_11->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_11->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_11->ViewValue = $this->t_11->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_11->ViewValue = $this->t_11->CurrentValue;
					}
				}
			} else {
				$this->t_11->ViewValue = NULL;
			}
			$this->t_11->ViewCustomAttributes = "";

			// t_12
			$this->t_12->ViewValue = $this->t_12->CurrentValue;
			$curVal = strval($this->t_12->CurrentValue);
			if ($curVal <> "") {
				$this->t_12->ViewValue = $this->t_12->lookupCacheOption($curVal);
				if ($this->t_12->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->t_12->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->t_12->ViewValue = $this->t_12->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->t_12->ViewValue = $this->t_12->CurrentValue;
					}
				}
			} else {
				$this->t_12->ViewValue = NULL;
			}
			$this->t_12->ViewCustomAttributes = "";

			// t_13
			$this->t_13->ViewValue = $this->t_13->CurrentValue;
			$this->t_13->ViewCustomAttributes = "";

			// t_14
			$this->t_14->ViewValue = $this->t_14->CurrentValue;
			$this->t_14->ViewCustomAttributes = "";

			// t_15
			$this->t_15->ViewValue = $this->t_15->CurrentValue;
			$this->t_15->ViewCustomAttributes = "";

			// d_head_01
			$this->d_head_01->ViewValue = $this->d_head_01->CurrentValue;
			$this->d_head_01->ViewCustomAttributes = "";

			// d_description_01
			$this->d_description_01->ViewValue = $this->d_description_01->CurrentValue;
			$this->d_description_01->ViewCustomAttributes = "";

			// d_head_02
			$this->d_head_02->ViewValue = $this->d_head_02->CurrentValue;
			$this->d_head_02->ViewCustomAttributes = "";

			// d_description_02
			$this->d_description_02->ViewValue = $this->d_description_02->CurrentValue;
			$this->d_description_02->ViewCustomAttributes = "";

			// main_image
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->ImageWidth = 0;
				$this->main_image->ImageHeight = 40;
				$this->main_image->ImageAlt = $this->main_image->alt();
				$this->main_image->ViewValue = $this->main_image->Upload->DbValue;
			} else {
				$this->main_image->ViewValue = "";
			}
			$this->main_image->ViewCustomAttributes = "";

			// top_view
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->ImageWidth = 0;
				$this->top_view->ImageHeight = 40;
				$this->top_view->ImageAlt = $this->top_view->alt();
				$this->top_view->ViewValue = $this->top_view->Upload->DbValue;
			} else {
				$this->top_view->ViewValue = "";
			}
			$this->top_view->ViewCustomAttributes = "";

			// front_view
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->ImageWidth = 0;
				$this->front_view->ImageHeight = 40;
				$this->front_view->ImageAlt = $this->front_view->alt();
				$this->front_view->ViewValue = $this->front_view->Upload->DbValue;
			} else {
				$this->front_view->ViewValue = "";
			}
			$this->front_view->ViewCustomAttributes = "";

			// corner_view
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->ImageWidth = 0;
				$this->corner_view->ImageHeight = 40;
				$this->corner_view->ImageAlt = $this->corner_view->alt();
				$this->corner_view->ViewValue = $this->corner_view->Upload->DbValue;
			} else {
				$this->corner_view->ViewValue = "";
			}
			$this->corner_view->ViewCustomAttributes = "";

			// back_view
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->ImageWidth = 0;
				$this->back_view->ImageHeight = 40;
				$this->back_view->ImageAlt = $this->back_view->alt();
				$this->back_view->ViewValue = $this->back_view->Upload->DbValue;
			} else {
				$this->back_view->ViewValue = "";
			}
			$this->back_view->ViewCustomAttributes = "";

			// color_options
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->ImageWidth = 0;
				$this->color_options->ImageHeight = 40;
				$this->color_options->ImageAlt = $this->color_options->alt();
				$this->color_options->ViewValue = $this->color_options->Upload->DbValue;
			} else {
				$this->color_options->ViewValue = "";
			}
			$this->color_options->ViewCustomAttributes = "";

			// other_options
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->ImageWidth = 0;
				$this->other_options->ImageHeight = 40;
				$this->other_options->ImageAlt = $this->other_options->alt();
				$this->other_options->ViewValue = $this->other_options->Upload->DbValue;
			} else {
				$this->other_options->ViewValue = "";
			}
			$this->other_options->ViewCustomAttributes = "";

			// image
			$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->ImageWidth = 0;
				$this->image->ImageHeight = 50;
				$this->image->ImageAlt = $this->image->alt();
				$this->image->ViewValue = $this->image->Upload->DbValue;
			} else {
				$this->image->ViewValue = "";
			}
			$this->image->ViewCustomAttributes = "";

			// video_url
			$this->video_url->ViewValue = $this->video_url->CurrentValue;
			$this->video_url->ViewCustomAttributes = "";

			// currency
			$curVal = strval($this->currency->CurrentValue);
			if ($curVal <> "") {
				$this->currency->ViewValue = $this->currency->lookupCacheOption($curVal);
				if ($this->currency->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->currency->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->currency->ViewValue = $this->currency->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->currency->ViewValue = $this->currency->CurrentValue;
					}
				}
			} else {
				$this->currency->ViewValue = NULL;
			}
			$this->currency->ViewCustomAttributes = "";

			// hsn
			$curVal = strval($this->hsn->CurrentValue);
			if ($curVal <> "") {
				$this->hsn->ViewValue = $this->hsn->lookupCacheOption($curVal);
				if ($this->hsn->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->hsn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$this->hsn->ViewValue = $this->hsn->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->hsn->ViewValue = $this->hsn->CurrentValue;
					}
				}
			} else {
				$this->hsn->ViewValue = NULL;
			}
			$this->hsn->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// publish
			if (strval($this->publish->CurrentValue) <> "") {
				$this->publish->ViewValue = $this->publish->optionCaption($this->publish->CurrentValue);
			} else {
				$this->publish->ViewValue = NULL;
			}
			$this->publish->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			$this->grp->HrefValue = "";
			$this->grp->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "ref_list.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// product_n
			$this->product_n->LinkCustomAttributes = "";
			$this->product_n->HrefValue = "";
			$this->product_n->TooltipValue = "";

			// product_type
			$this->product_type->LinkCustomAttributes = "";
			$this->product_type->HrefValue = "";
			$this->product_type->TooltipValue = "";

			// last_price
			$this->last_price->LinkCustomAttributes = "";
			$this->last_price->HrefValue = "";
			$this->last_price->TooltipValue = "";

			// v_01
			$this->v_01->LinkCustomAttributes = "";
			$this->v_01->HrefValue = "";
			$this->v_01->TooltipValue = "";

			// v_02
			$this->v_02->LinkCustomAttributes = "";
			$this->v_02->HrefValue = "";
			$this->v_02->TooltipValue = "";

			// v_03
			$this->v_03->LinkCustomAttributes = "";
			$this->v_03->HrefValue = "";
			$this->v_03->TooltipValue = "";

			// v_04
			$this->v_04->LinkCustomAttributes = "";
			$this->v_04->HrefValue = "";
			$this->v_04->TooltipValue = "";

			// v_05
			$this->v_05->LinkCustomAttributes = "";
			$this->v_05->HrefValue = "";
			$this->v_05->TooltipValue = "";

			// v_06
			$this->v_06->LinkCustomAttributes = "";
			$this->v_06->HrefValue = "";
			$this->v_06->TooltipValue = "";

			// v_07
			$this->v_07->LinkCustomAttributes = "";
			$this->v_07->HrefValue = "";
			$this->v_07->TooltipValue = "";

			// v_08
			$this->v_08->LinkCustomAttributes = "";
			$this->v_08->HrefValue = "";
			$this->v_08->TooltipValue = "";

			// v_09
			$this->v_09->LinkCustomAttributes = "";
			$this->v_09->HrefValue = "";
			$this->v_09->TooltipValue = "";

			// v_10
			$this->v_10->LinkCustomAttributes = "";
			$this->v_10->HrefValue = "";
			$this->v_10->TooltipValue = "";

			// cbm
			$this->cbm->LinkCustomAttributes = "";
			$this->cbm->HrefValue = "";
			$this->cbm->TooltipValue = "";

			// sqm
			$this->sqm->LinkCustomAttributes = "";
			$this->sqm->HrefValue = "";
			$this->sqm->TooltipValue = "";

			// shape
			$this->shape->LinkCustomAttributes = "";
			$this->shape->HrefValue = "";
			$this->shape->TooltipValue = "";

			// b_01
			$this->b_01->LinkCustomAttributes = "";
			$this->b_01->HrefValue = "";
			$this->b_01->TooltipValue = "";

			// b_02
			$this->b_02->LinkCustomAttributes = "";
			$this->b_02->HrefValue = "";
			$this->b_02->TooltipValue = "";

			// b_03
			$this->b_03->LinkCustomAttributes = "";
			$this->b_03->HrefValue = "";
			$this->b_03->TooltipValue = "";

			// b_04
			$this->b_04->LinkCustomAttributes = "";
			$this->b_04->HrefValue = "";
			$this->b_04->TooltipValue = "";

			// b_05
			$this->b_05->LinkCustomAttributes = "";
			$this->b_05->HrefValue = "";
			$this->b_05->TooltipValue = "";

			// b_06
			$this->b_06->LinkCustomAttributes = "";
			$this->b_06->HrefValue = "";
			$this->b_06->TooltipValue = "";

			// b_07
			$this->b_07->LinkCustomAttributes = "";
			$this->b_07->HrefValue = "";
			$this->b_07->TooltipValue = "";

			// b_08
			$this->b_08->LinkCustomAttributes = "";
			$this->b_08->HrefValue = "";
			$this->b_08->TooltipValue = "";

			// b_09
			$this->b_09->LinkCustomAttributes = "";
			$this->b_09->HrefValue = "";
			$this->b_09->TooltipValue = "";

			// b_10
			$this->b_10->LinkCustomAttributes = "";
			$this->b_10->HrefValue = "";
			$this->b_10->TooltipValue = "";

			// b_11
			$this->b_11->LinkCustomAttributes = "";
			$this->b_11->HrefValue = "";
			$this->b_11->TooltipValue = "";

			// b_12
			$this->b_12->LinkCustomAttributes = "";
			$this->b_12->HrefValue = "";
			$this->b_12->TooltipValue = "";

			// b_13
			$this->b_13->LinkCustomAttributes = "";
			$this->b_13->HrefValue = "";
			$this->b_13->TooltipValue = "";

			// b_14
			$this->b_14->LinkCustomAttributes = "";
			$this->b_14->HrefValue = "";
			$this->b_14->TooltipValue = "";

			// b_15
			$this->b_15->LinkCustomAttributes = "";
			$this->b_15->HrefValue = "";
			$this->b_15->TooltipValue = "";

			// t_01
			$this->t_01->LinkCustomAttributes = "";
			$this->t_01->HrefValue = "";
			$this->t_01->TooltipValue = "";

			// t_02
			$this->t_02->LinkCustomAttributes = "";
			$this->t_02->HrefValue = "";
			$this->t_02->TooltipValue = "";

			// t_03
			$this->t_03->LinkCustomAttributes = "";
			$this->t_03->HrefValue = "";
			$this->t_03->TooltipValue = "";

			// t_04
			$this->t_04->LinkCustomAttributes = "";
			$this->t_04->HrefValue = "";
			$this->t_04->TooltipValue = "";

			// t_05
			$this->t_05->LinkCustomAttributes = "";
			$this->t_05->HrefValue = "";
			$this->t_05->TooltipValue = "";

			// t_06
			$this->t_06->LinkCustomAttributes = "";
			$this->t_06->HrefValue = "";
			$this->t_06->TooltipValue = "";

			// t_07
			$this->t_07->LinkCustomAttributes = "";
			$this->t_07->HrefValue = "";
			$this->t_07->TooltipValue = "";

			// t_08
			$this->t_08->LinkCustomAttributes = "";
			$this->t_08->HrefValue = "";
			$this->t_08->TooltipValue = "";

			// t_09
			$this->t_09->LinkCustomAttributes = "";
			$this->t_09->HrefValue = "";
			$this->t_09->TooltipValue = "";

			// t_10
			$this->t_10->LinkCustomAttributes = "";
			$this->t_10->HrefValue = "";
			$this->t_10->TooltipValue = "";

			// t_11
			$this->t_11->LinkCustomAttributes = "";
			$this->t_11->HrefValue = "";
			$this->t_11->TooltipValue = "";

			// t_12
			$this->t_12->LinkCustomAttributes = "";
			$this->t_12->HrefValue = "";
			$this->t_12->TooltipValue = "";

			// t_13
			$this->t_13->LinkCustomAttributes = "";
			$this->t_13->HrefValue = "";
			$this->t_13->TooltipValue = "";

			// t_14
			$this->t_14->LinkCustomAttributes = "";
			$this->t_14->HrefValue = "";
			$this->t_14->TooltipValue = "";

			// t_15
			$this->t_15->LinkCustomAttributes = "";
			$this->t_15->HrefValue = "";
			$this->t_15->TooltipValue = "";

			// d_head_01
			$this->d_head_01->LinkCustomAttributes = "";
			$this->d_head_01->HrefValue = "";
			$this->d_head_01->TooltipValue = "";

			// d_description_01
			$this->d_description_01->LinkCustomAttributes = "";
			$this->d_description_01->HrefValue = "";
			$this->d_description_01->TooltipValue = "";

			// d_head_02
			$this->d_head_02->LinkCustomAttributes = "";
			$this->d_head_02->HrefValue = "";
			$this->d_head_02->TooltipValue = "";

			// d_description_02
			$this->d_description_02->LinkCustomAttributes = "";
			$this->d_description_02->HrefValue = "";
			$this->d_description_02->TooltipValue = "";

			// main_image
			$this->main_image->LinkCustomAttributes = "";
			$this->main_image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->main_image->Upload->DbValue)) {
				$this->main_image->HrefValue = "%u"; // Add prefix/suffix
				$this->main_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->main_image->HrefValue = FullUrl($this->main_image->HrefValue, "href");
			} else {
				$this->main_image->HrefValue = "";
			}
			$this->main_image->ExportHrefValue = $this->main_image->UploadPath . $this->main_image->Upload->DbValue;
			$this->main_image->TooltipValue = "";
			if ($this->main_image->UseColorbox) {
				if (EmptyValue($this->main_image->TooltipValue))
					$this->main_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->main_image->LinkAttrs["data-rel"] = "ref_multi_x_main_image";
				AppendClass($this->main_image->LinkAttrs["class"], "ew-lightbox");
			}

			// top_view
			$this->top_view->LinkCustomAttributes = "";
			$this->top_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->top_view->Upload->DbValue)) {
				$this->top_view->HrefValue = "%u"; // Add prefix/suffix
				$this->top_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->top_view->HrefValue = FullUrl($this->top_view->HrefValue, "href");
			} else {
				$this->top_view->HrefValue = "";
			}
			$this->top_view->ExportHrefValue = $this->top_view->UploadPath . $this->top_view->Upload->DbValue;
			$this->top_view->TooltipValue = "";
			if ($this->top_view->UseColorbox) {
				if (EmptyValue($this->top_view->TooltipValue))
					$this->top_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->top_view->LinkAttrs["data-rel"] = "ref_multi_x_top_view";
				AppendClass($this->top_view->LinkAttrs["class"], "ew-lightbox");
			}

			// front_view
			$this->front_view->LinkCustomAttributes = "";
			$this->front_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->front_view->Upload->DbValue)) {
				$this->front_view->HrefValue = "%u"; // Add prefix/suffix
				$this->front_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->front_view->HrefValue = FullUrl($this->front_view->HrefValue, "href");
			} else {
				$this->front_view->HrefValue = "";
			}
			$this->front_view->ExportHrefValue = $this->front_view->UploadPath . $this->front_view->Upload->DbValue;
			$this->front_view->TooltipValue = "";
			if ($this->front_view->UseColorbox) {
				if (EmptyValue($this->front_view->TooltipValue))
					$this->front_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->front_view->LinkAttrs["data-rel"] = "ref_multi_x_front_view";
				AppendClass($this->front_view->LinkAttrs["class"], "ew-lightbox");
			}

			// corner_view
			$this->corner_view->LinkCustomAttributes = "";
			$this->corner_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->corner_view->Upload->DbValue)) {
				$this->corner_view->HrefValue = "%u"; // Add prefix/suffix
				$this->corner_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->corner_view->HrefValue = FullUrl($this->corner_view->HrefValue, "href");
			} else {
				$this->corner_view->HrefValue = "";
			}
			$this->corner_view->ExportHrefValue = $this->corner_view->UploadPath . $this->corner_view->Upload->DbValue;
			$this->corner_view->TooltipValue = "";
			if ($this->corner_view->UseColorbox) {
				if (EmptyValue($this->corner_view->TooltipValue))
					$this->corner_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->corner_view->LinkAttrs["data-rel"] = "ref_multi_x_corner_view";
				AppendClass($this->corner_view->LinkAttrs["class"], "ew-lightbox");
			}

			// back_view
			$this->back_view->LinkCustomAttributes = "";
			$this->back_view->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->back_view->Upload->DbValue)) {
				$this->back_view->HrefValue = "%u"; // Add prefix/suffix
				$this->back_view->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->back_view->HrefValue = FullUrl($this->back_view->HrefValue, "href");
			} else {
				$this->back_view->HrefValue = "";
			}
			$this->back_view->ExportHrefValue = $this->back_view->UploadPath . $this->back_view->Upload->DbValue;
			$this->back_view->TooltipValue = "";
			if ($this->back_view->UseColorbox) {
				if (EmptyValue($this->back_view->TooltipValue))
					$this->back_view->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->back_view->LinkAttrs["data-rel"] = "ref_multi_x_back_view";
				AppendClass($this->back_view->LinkAttrs["class"], "ew-lightbox");
			}

			// color_options
			$this->color_options->LinkCustomAttributes = "";
			$this->color_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->color_options->Upload->DbValue)) {
				$this->color_options->HrefValue = "%u"; // Add prefix/suffix
				$this->color_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->color_options->HrefValue = FullUrl($this->color_options->HrefValue, "href");
			} else {
				$this->color_options->HrefValue = "";
			}
			$this->color_options->ExportHrefValue = $this->color_options->UploadPath . $this->color_options->Upload->DbValue;
			$this->color_options->TooltipValue = "";
			if ($this->color_options->UseColorbox) {
				if (EmptyValue($this->color_options->TooltipValue))
					$this->color_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->color_options->LinkAttrs["data-rel"] = "ref_multi_x_color_options";
				AppendClass($this->color_options->LinkAttrs["class"], "ew-lightbox");
			}

			// other_options
			$this->other_options->LinkCustomAttributes = "";
			$this->other_options->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->other_options->Upload->DbValue)) {
				$this->other_options->HrefValue = "%u"; // Add prefix/suffix
				$this->other_options->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->other_options->HrefValue = FullUrl($this->other_options->HrefValue, "href");
			} else {
				$this->other_options->HrefValue = "";
			}
			$this->other_options->ExportHrefValue = $this->other_options->UploadPath . $this->other_options->Upload->DbValue;
			$this->other_options->TooltipValue = "";
			if ($this->other_options->UseColorbox) {
				if (EmptyValue($this->other_options->TooltipValue))
					$this->other_options->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->other_options->LinkAttrs["data-rel"] = "ref_multi_x_other_options";
				AppendClass($this->other_options->LinkAttrs["class"], "ew-lightbox");
			}

			// image
			$this->image->LinkCustomAttributes = "";
			$this->image->UploadPath = '/product_images/o/' . $this->id->CurrentValue . '/' ;
			if (!EmptyValue($this->image->Upload->DbValue)) {
				$this->image->HrefValue = "%u"; // Add prefix/suffix
				$this->image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->image->HrefValue = FullUrl($this->image->HrefValue, "href");
			} else {
				$this->image->HrefValue = "";
			}
			$this->image->ExportHrefValue = $this->image->UploadPath . $this->image->Upload->DbValue;
			$this->image->TooltipValue = "";
			if ($this->image->UseColorbox) {
				if (EmptyValue($this->image->TooltipValue))
					$this->image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->image->LinkAttrs["data-rel"] = "ref_multi_x_image";
				AppendClass($this->image->LinkAttrs["class"], "ew-lightbox");
			}

			// video_url
			$this->video_url->LinkCustomAttributes = "";
			$this->video_url->HrefValue = "";
			$this->video_url->TooltipValue = "";

			// currency
			$this->currency->LinkCustomAttributes = "";
			$this->currency->HrefValue = "";
			$this->currency->TooltipValue = "";

			// hsn
			$this->hsn->LinkCustomAttributes = "";
			$this->hsn->HrefValue = "";
			$this->hsn->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// publish
			$this->publish->LinkCustomAttributes = "";
			$this->publish->HrefValue = "";
			$this->publish->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		if (Get(TABLE_SHOW_DETAIL) !== NULL) {
			$detailTblVar = Get(TABLE_SHOW_DETAIL);
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar <> "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("_ref_view", $detailTblVar)) {
				if (!isset($GLOBALS["_ref_view_grid"]))
					$GLOBALS["_ref_view_grid"] = new _ref_view_grid();
				if ($GLOBALS["_ref_view_grid"]->DetailView) {
					$GLOBALS["_ref_view_grid"]->CurrentMode = "view";

					// Save current master table to detail table
					$GLOBALS["_ref_view_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["_ref_view_grid"]->setStartRecordNumber(1);
					$GLOBALS["_ref_view_grid"]->id->IsDetailKey = TRUE;
					$GLOBALS["_ref_view_grid"]->id->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["_ref_view_grid"]->id->setSessionValue($GLOBALS["_ref_view_grid"]->id->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("ref_multilist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? "`status` = 1 and `id` > 200000" : "`id` = " .  User_Company_ID()  . " and `status` = 1 and `id` > 200000";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_s_grp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_type":
					$lookupFilter = function() {
						return "`status`=1 and `id` = 9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_01":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 101 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_02":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 102 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 103 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 104 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 105 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 106 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 107 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 108 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 109 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_v_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 110 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_shape":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 203 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 204 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 205 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 206 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 207 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 208 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 209 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 210 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_03":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 303 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_04":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 304 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_05":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 305 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_06":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 306 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_07":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 307 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_08":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 308 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_09":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 309 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_10":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 310 and (
(FIND_IN_SET(" . User_Company_ID() . ", `partner`)) || (FIND_IN_SET(0, `partner`)))";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_11":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 311";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_t_12":
					$lookupFilter = function() {
						return "`status` = 1 and `no` = 312";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_currency":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_hsn":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_grp":
							break;
						case "x_s_grp":
							break;
						case "x_product":
							break;
						case "x_product_type":
							break;
						case "x_v_01":
							break;
						case "x_v_02":
							break;
						case "x_v_03":
							break;
						case "x_v_04":
							break;
						case "x_v_05":
							break;
						case "x_v_06":
							break;
						case "x_v_07":
							break;
						case "x_v_08":
							break;
						case "x_v_09":
							break;
						case "x_v_10":
							break;
						case "x_shape":
							break;
						case "x_b_03":
							break;
						case "x_b_04":
							break;
						case "x_b_05":
							break;
						case "x_b_06":
							break;
						case "x_b_07":
							break;
						case "x_b_08":
							break;
						case "x_b_09":
							break;
						case "x_b_10":
							break;
						case "x_t_03":
							break;
						case "x_t_04":
							break;
						case "x_t_05":
							break;
						case "x_t_06":
							break;
						case "x_t_07":
							break;
						case "x_t_08":
							break;
						case "x_t_09":
							break;
						case "x_t_10":
							break;
						case "x_t_11":
							break;
						case "x_t_12":
							break;
						case "x_currency":
							break;
						case "x_hsn":
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'ref_multi');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>