<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for rental_po
 */
class rental_po extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Audit trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $programme_datetime;
	public $location;
	public $item;
	public $company_id;
	public $amount;
	public $job_category;
	public $type;
	public $buyer_instruction;
	public $remarks;
	public $eastimated_amount;
	public $gst;
	public $payment_terms;
	public $uploads;
	public $reports_to;
	public $description_01;
	public $description_02;
	public $description_03;
	public $description_04;
	public $description_05;
	public $description_06;
	public $description_07;
	public $description_08;
	public $description_09;
	public $description_10;
	public $operator;
	public $datetime;
	public $a_operator;
	public $a_datetime;
	public $booking_ref;
	public $contact_person;
	public $programme_end_datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'rental_po';
		$this->TableName = 'rental_po';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`rental_po`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('rental_po', 'rental_po', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// programme_datetime
		$this->programme_datetime = new DbField('rental_po', 'rental_po', 'x_programme_datetime', 'programme_datetime', '`programme_datetime`', CastDateFieldForLike('`programme_datetime`', 0, "DB"), 135, 0, FALSE, '`programme_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->programme_datetime->Sortable = TRUE; // Allow sort
		$this->programme_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['programme_datetime'] = &$this->programme_datetime;

		// location
		$this->location = new DbField('rental_po', 'rental_po', 'x_location', 'location', '`location`', '`location`', 201, -1, FALSE, '`location`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->location->Sortable = TRUE; // Allow sort
		$this->fields['location'] = &$this->location;

		// item
		$this->item = new DbField('rental_po', 'rental_po', 'x_item', 'item', '`item`', '`item`', 200, -1, FALSE, '`item`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->item->Nullable = FALSE; // NOT NULL field
		$this->item->Required = TRUE; // Required field
		$this->item->Sortable = TRUE; // Allow sort
		$this->fields['item'] = &$this->item;

		// company_id
		$this->company_id = new DbField('rental_po', 'rental_po', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->company_id->Required = TRUE; // Required field
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->Lookup = new Lookup('company_id', 'buyer', TRUE, 'id', ["name","","",""], [], ["x_description_01[]","x_description_02[]","x_description_03[]","x_description_04[]","x_description_05[]","x_description_07[]","x_description_08[]","x_description_09[]","x_description_10[]"], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// amount
		$this->amount = new DbField('rental_po', 'rental_po', 'x_amount', 'amount', '`amount`', '`amount`', 200, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Nullable = FALSE; // NOT NULL field
		$this->amount->Required = TRUE; // Required field
		$this->amount->Sortable = TRUE; // Allow sort
		$this->fields['amount'] = &$this->amount;

		// job_category
		$this->job_category = new DbField('rental_po', 'rental_po', 'x_job_category', 'job_category', '`job_category`', '`job_category`', 17, -1, FALSE, '`job_category`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->job_category->Nullable = FALSE; // NOT NULL field
		$this->job_category->Sortable = FALSE; // Allow sort
		$this->job_category->Lookup = new Lookup('job_category', 'rental_po', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->job_category->OptionCount = 2;
		$this->job_category->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['job_category'] = &$this->job_category;

		// type
		$this->type = new DbField('rental_po', 'rental_po', 'x_type', 'type', '`type`', '`type`', 2, -1, FALSE, '`type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->type->Nullable = FALSE; // NOT NULL field
		$this->type->Sortable = TRUE; // Allow sort
		$this->type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->type->Lookup = new Lookup('type', 'rental_po', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->type->OptionCount = 3;
		$this->type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['type'] = &$this->type;

		// buyer_instruction
		$this->buyer_instruction = new DbField('rental_po', 'rental_po', 'x_buyer_instruction', 'buyer_instruction', '`buyer_instruction`', '`buyer_instruction`', 201, -1, FALSE, '`buyer_instruction`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->buyer_instruction->Sortable = FALSE; // Allow sort
		$this->fields['buyer_instruction'] = &$this->buyer_instruction;

		// remarks
		$this->remarks = new DbField('rental_po', 'rental_po', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = FALSE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// eastimated_amount
		$this->eastimated_amount = new DbField('rental_po', 'rental_po', 'x_eastimated_amount', 'eastimated_amount', '`eastimated_amount`', '`eastimated_amount`', 131, -1, FALSE, '`eastimated_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->eastimated_amount->Sortable = FALSE; // Allow sort
		$this->fields['eastimated_amount'] = &$this->eastimated_amount;

		// gst
		$this->gst = new DbField('rental_po', 'rental_po', 'x_gst', 'gst', '`gst`', '`gst`', 18, -1, FALSE, '`gst`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->gst->Nullable = FALSE; // NOT NULL field
		$this->gst->Required = TRUE; // Required field
		$this->gst->Sortable = TRUE; // Allow sort
		$this->gst->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->gst->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->gst->Lookup = new Lookup('gst', 'tax_category', FALSE, 'id', ["item","tax_percent","hsn_code",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->gst->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['gst'] = &$this->gst;

		// payment_terms
		$this->payment_terms = new DbField('rental_po', 'rental_po', 'x_payment_terms', 'payment_terms', '`payment_terms`', '`payment_terms`', 200, -1, FALSE, '`payment_terms`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->payment_terms->Sortable = FALSE; // Allow sort
		$this->payment_terms->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->payment_terms->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->payment_terms->Lookup = new Lookup('payment_terms', 'misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['payment_terms'] = &$this->payment_terms;

		// uploads
		$this->uploads = new DbField('rental_po', 'rental_po', 'x_uploads', 'uploads', '`uploads`', '`uploads`', 201, -1, TRUE, '`uploads`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->uploads->Sortable = FALSE; // Allow sort
		$this->uploads->UploadMultiple = TRUE;
		$this->uploads->Upload->UploadMultiple = TRUE;
		$this->uploads->UploadMaxFileCount = 0;
		$this->fields['uploads'] = &$this->uploads;

		// reports_to
		$this->reports_to = new DbField('rental_po', 'rental_po', 'x_reports_to', 'reports_to', '`reports_to`', '`reports_to`', 2, -1, FALSE, '`reports_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->reports_to->Sortable = TRUE; // Allow sort
		$this->reports_to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->reports_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->reports_to->Lookup = new Lookup('reports_to', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->reports_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['reports_to'] = &$this->reports_to;

		// description_01
		$this->description_01 = new DbField('rental_po', 'rental_po', 'x_description_01', 'description_01', '`description_01`', '`description_01`', 200, -1, FALSE, '`description_01`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->description_01->Sortable = FALSE; // Allow sort
		$this->description_01->Lookup = new Lookup('description_01', 'rental_cart', FALSE, 'id', ["product_code","qty","price","amount"], ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], '`id` ASC', '<span class="text-info">Product : {{:df1}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}} </span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'p_cartedit.php?id={{:lf}}\'});"> Edit </span><a href="p_cartdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->description_01->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_01'] = &$this->description_01;

		// description_02
		$this->description_02 = new DbField('rental_po', 'rental_po', 'x_description_02', 'description_02', '`description_02`', '`description_02`', 200, -1, FALSE, '`description_02`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->description_02->Sortable = FALSE; // Allow sort
		$this->description_02->Lookup = new Lookup('description_02', 'rental_cart', FALSE, 'id', ["product_code","qty","price","amount"], ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], '`id` ASC', '<span class="text-info">Product : {{:df1}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}} </span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'p_cartedit.php?id={{:lf}}\'});"> Edit </span><a href="p_cartdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->description_02->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_02'] = &$this->description_02;

		// description_03
		$this->description_03 = new DbField('rental_po', 'rental_po', 'x_description_03', 'description_03', '`description_03`', '`description_03`', 200, -1, FALSE, '`description_03`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->description_03->Sortable = FALSE; // Allow sort
		$this->description_03->Lookup = new Lookup('description_03', 'rental_cart', FALSE, 'id', ["product_code","qty","price","amount"], ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], '`id` ASC', '<span class="text-info">Product : {{:df1}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}} </span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'p_cartedit.php?id={{:lf}}\'});"> Edit </span><a href="p_cartdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->description_03->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['description_03'] = &$this->description_03;

		// description_04
		$this->description_04 = new DbField('rental_po', 'rental_po', 'x_description_04', 'description_04', '`description_04`', '`description_04`', 200, -1, FALSE, '`description_04`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->description_04->Sortable = FALSE; // Allow sort
		$this->description_04->Lookup = new Lookup('description_04', 'p_cart', FALSE, 'id', ["product_code","qty","price","amount"], ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], '`id` ASC', '<span class="text-info">Product : {{:df1}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}} </span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'p_cartedit.php?id={{:lf}}\'});"> Edit </span><a href="p_cartdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->description_04->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['description_04'] = &$this->description_04;

		// description_05
		$this->description_05 = new DbField('rental_po', 'rental_po', 'x_description_05', 'description_05', '`description_05`', '`description_05`', 200, -1, FALSE, '`description_05`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->description_05->Sortable = FALSE; // Allow sort
		$this->description_05->Lookup = new Lookup('description_05', 'p_cart', FALSE, 'id', ["product_code","qty","price","amount"], ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], '`id` ASC', '<span class="text-info">Product : {{:df1}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}} </span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'p_cartedit.php?id={{:lf}}\'});"> Edit </span><a href="p_cartdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->fields['description_05'] = &$this->description_05;

		// description_06
		$this->description_06 = new DbField('rental_po', 'rental_po', 'x_description_06', 'description_06', '`description_06`', '`description_06`', 200, -1, FALSE, '`description_06`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->description_06->Sortable = FALSE; // Allow sort
		$this->description_06->Lookup = new Lookup('description_06', 'p_cart', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '', '<span class="text-info">Product : {{:df1}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}} </span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'p_cartedit.php?id={{:lf}}\'});"> Edit </span><a href="p_cartdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->fields['description_06'] = &$this->description_06;

		// description_07
		$this->description_07 = new DbField('rental_po', 'rental_po', 'x_description_07', 'description_07', '`description_07`', '`description_07`', 200, -1, FALSE, '`description_07`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->description_07->Sortable = FALSE; // Allow sort
		$this->description_07->Lookup = new Lookup('description_07', 'p_cart', FALSE, 'id', ["product_code","qty","price","amount"], ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], '`id` ASC', '<span class="text-info">Product : {{:df1}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}} </span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'p_cartedit.php?id={{:lf}}\'});"> Edit </span><a href="p_cartdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->description_07->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_07'] = &$this->description_07;

		// description_08
		$this->description_08 = new DbField('rental_po', 'rental_po', 'x_description_08', 'description_08', '`description_08`', '`description_08`', 200, -1, FALSE, '`description_08`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->description_08->Sortable = FALSE; // Allow sort
		$this->description_08->Lookup = new Lookup('description_08', 'p_cart', FALSE, 'id', ["product_code","qty","price","amount"], ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], '`id` ASC', '<span class="text-info">Product : {{:df1}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}} </span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'p_cartedit.php?id={{:lf}}\'});"> Edit </span><a href="p_cartdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->description_08->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['description_08'] = &$this->description_08;

		// description_09
		$this->description_09 = new DbField('rental_po', 'rental_po', 'x_description_09', 'description_09', '`description_09`', '`description_09`', 200, -1, FALSE, '`description_09`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->description_09->Sortable = FALSE; // Allow sort
		$this->description_09->Lookup = new Lookup('description_09', 'p_cart', FALSE, 'id', ["product_code","qty","price","amount"], ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], '`id` ASC', '<span class="text-info">Product : {{:df1}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}} </span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'p_cartedit.php?id={{:lf}}\'});"> Edit </span><a href="p_cartdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->fields['description_09'] = &$this->description_09;

		// description_10
		$this->description_10 = new DbField('rental_po', 'rental_po', 'x_description_10', 'description_10', '`description_10`', '`description_10`', 200, -1, FALSE, '`description_10`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->description_10->Sortable = FALSE; // Allow sort
		$this->description_10->Lookup = new Lookup('description_10', 'p_cart', FALSE, 'id', ["product_code","qty","price","amount"], ["x_company_id"], [], ["company_id"], ["x_company_id"], [], [], '`id` ASC', '<span class="text-info">Product : {{:df1}}, Qty : {{:df2}}, Price : {{:df3}}, Amount : {{:df4}} </span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'p_cartedit.php?id={{:lf}}\'});"> Edit </span><a href="p_cartdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->fields['description_10'] = &$this->description_10;

		// operator
		$this->operator = new DbField('rental_po', 'rental_po', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('rental_po', 'rental_po', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 11, "DB"), 135, 11, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->fields['datetime'] = &$this->datetime;

		// a_operator
		$this->a_operator = new DbField('rental_po', 'rental_po', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 18, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->a_operator->Sortable = FALSE; // Allow sort
		$this->a_operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->a_operator->Lookup = new Lookup('a_operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// a_datetime
		$this->a_datetime = new DbField('rental_po', 'rental_po', 'x_a_datetime', 'a_datetime', '`a_datetime`', CastDateFieldForLike('`a_datetime`', 11, "DB"), 135, 11, FALSE, '`a_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_datetime->Sortable = FALSE; // Allow sort
		$this->fields['a_datetime'] = &$this->a_datetime;

		// booking_ref
		$this->booking_ref = new DbField('rental_po', 'rental_po', 'x_booking_ref', 'booking_ref', '`booking_ref`', '`booking_ref`', 200, -1, FALSE, '`booking_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->booking_ref->Sortable = TRUE; // Allow sort
		$this->fields['booking_ref'] = &$this->booking_ref;

		// contact_person
		$this->contact_person = new DbField('rental_po', 'rental_po', 'x_contact_person', 'contact_person', '`contact_person`', '`contact_person`', 200, -1, FALSE, '`contact_person`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->contact_person->Nullable = FALSE; // NOT NULL field
		$this->contact_person->Required = TRUE; // Required field
		$this->contact_person->Sortable = TRUE; // Allow sort
		$this->fields['contact_person'] = &$this->contact_person;

		// programme_end_datetime
		$this->programme_end_datetime = new DbField('rental_po', 'rental_po', 'x_programme_end_datetime', 'programme_end_datetime', '`programme_end_datetime`', CastDateFieldForLike('`programme_end_datetime`', 0, "DB"), 135, 0, FALSE, '`programme_end_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->programme_end_datetime->Sortable = TRUE; // Allow sort
		$this->programme_end_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['programme_end_datetime'] = &$this->programme_end_datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`rental_po`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
			if ($this->AuditTrailOnAdd)
				$this->writeAuditTrailOnAdd($rs);
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnEdit && $rsold) {
			$rsaudit = $rs;
			$fldname = 'id';
			if (!array_key_exists($fldname, $rsaudit))
				$rsaudit[$fldname] = $rsold[$fldname];
			$this->writeAuditTrailOnEdit($rsold, $rsaudit);
		}
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		if ($success && $this->AuditTrailOnDelete)
			$this->writeAuditTrailOnDelete($rs);
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->programme_datetime->DbValue = $row['programme_datetime'];
		$this->location->DbValue = $row['location'];
		$this->item->DbValue = $row['item'];
		$this->company_id->DbValue = $row['company_id'];
		$this->amount->DbValue = $row['amount'];
		$this->job_category->DbValue = $row['job_category'];
		$this->type->DbValue = $row['type'];
		$this->buyer_instruction->DbValue = $row['buyer_instruction'];
		$this->remarks->DbValue = $row['remarks'];
		$this->eastimated_amount->DbValue = $row['eastimated_amount'];
		$this->gst->DbValue = $row['gst'];
		$this->payment_terms->DbValue = $row['payment_terms'];
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->reports_to->DbValue = $row['reports_to'];
		$this->description_01->DbValue = $row['description_01'];
		$this->description_02->DbValue = $row['description_02'];
		$this->description_03->DbValue = $row['description_03'];
		$this->description_04->DbValue = $row['description_04'];
		$this->description_05->DbValue = $row['description_05'];
		$this->description_06->DbValue = $row['description_06'];
		$this->description_07->DbValue = $row['description_07'];
		$this->description_08->DbValue = $row['description_08'];
		$this->description_09->DbValue = $row['description_09'];
		$this->description_10->DbValue = $row['description_10'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->a_datetime->DbValue = $row['a_datetime'];
		$this->booking_ref->DbValue = $row['booking_ref'];
		$this->contact_person->DbValue = $row['contact_person'];
		$this->programme_end_datetime->DbValue = $row['programme_end_datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->uploads->OldUploadPath = '/.p_uploads/rental/';
		$oldFiles = EmptyValue($row['uploads']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['uploads']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "rental_polist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "rental_poview.php")
			return $Language->phrase("View");
		elseif ($pageName == "rental_poedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "rental_poadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "rental_polist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("rental_poview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("rental_poview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "rental_poadd.php?" . $this->getUrlParm($parm);
		else
			$url = "rental_poadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("rental_poedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("rental_poadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("rental_podelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->programme_datetime->setDbValue($rs->fields('programme_datetime'));
		$this->location->setDbValue($rs->fields('location'));
		$this->item->setDbValue($rs->fields('item'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->job_category->setDbValue($rs->fields('job_category'));
		$this->type->setDbValue($rs->fields('type'));
		$this->buyer_instruction->setDbValue($rs->fields('buyer_instruction'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->eastimated_amount->setDbValue($rs->fields('eastimated_amount'));
		$this->gst->setDbValue($rs->fields('gst'));
		$this->payment_terms->setDbValue($rs->fields('payment_terms'));
		$this->uploads->Upload->DbValue = $rs->fields('uploads');
		$this->reports_to->setDbValue($rs->fields('reports_to'));
		$this->description_01->setDbValue($rs->fields('description_01'));
		$this->description_02->setDbValue($rs->fields('description_02'));
		$this->description_03->setDbValue($rs->fields('description_03'));
		$this->description_04->setDbValue($rs->fields('description_04'));
		$this->description_05->setDbValue($rs->fields('description_05'));
		$this->description_06->setDbValue($rs->fields('description_06'));
		$this->description_07->setDbValue($rs->fields('description_07'));
		$this->description_08->setDbValue($rs->fields('description_08'));
		$this->description_09->setDbValue($rs->fields('description_09'));
		$this->description_10->setDbValue($rs->fields('description_10'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->a_datetime->setDbValue($rs->fields('a_datetime'));
		$this->booking_ref->setDbValue($rs->fields('booking_ref'));
		$this->contact_person->setDbValue($rs->fields('contact_person'));
		$this->programme_end_datetime->setDbValue($rs->fields('programme_end_datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// programme_datetime
		// location
		// item
		// company_id
		// amount
		// job_category

		$this->job_category->CellCssStyle = "white-space: nowrap;";

		// type
		// buyer_instruction

		$this->buyer_instruction->CellCssStyle = "white-space: nowrap;";

		// remarks
		$this->remarks->CellCssStyle = "white-space: nowrap;";

		// eastimated_amount
		$this->eastimated_amount->CellCssStyle = "white-space: nowrap;";

		// gst
		// payment_terms

		$this->payment_terms->CellCssStyle = "white-space: nowrap;";

		// uploads
		$this->uploads->CellCssStyle = "white-space: nowrap;";

		// reports_to
		// description_01

		$this->description_01->CellCssStyle = "white-space: nowrap;";

		// description_02
		$this->description_02->CellCssStyle = "white-space: nowrap;";

		// description_03
		$this->description_03->CellCssStyle = "white-space: nowrap;";

		// description_04
		$this->description_04->CellCssStyle = "white-space: nowrap;";

		// description_05
		$this->description_05->CellCssStyle = "white-space: nowrap;";

		// description_06
		$this->description_06->CellCssStyle = "white-space: nowrap;";

		// description_07
		$this->description_07->CellCssStyle = "white-space: nowrap;";

		// description_08
		$this->description_08->CellCssStyle = "white-space: nowrap;";

		// description_09
		$this->description_09->CellCssStyle = "white-space: nowrap;";

		// description_10
		$this->description_10->CellCssStyle = "white-space: nowrap;";

		// operator
		// datetime
		// a_operator

		$this->a_operator->CellCssStyle = "white-space: nowrap;";

		// a_datetime
		$this->a_datetime->CellCssStyle = "white-space: nowrap;";

		// booking_ref
		// contact_person
		// programme_end_datetime
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// programme_datetime
		$this->programme_datetime->ViewValue = $this->programme_datetime->CurrentValue;
		$this->programme_datetime->ViewValue = FormatDateTime($this->programme_datetime->ViewValue, 0);
		$this->programme_datetime->ViewCustomAttributes = "";

		// location
		$this->location->ViewValue = $this->location->CurrentValue;
		$this->location->ViewCustomAttributes = "";

		// item
		$this->item->ViewValue = $this->item->CurrentValue;
		$this->item->ViewCustomAttributes = "";

		// company_id
		$this->company_id->ViewValue = $this->company_id->CurrentValue;
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "" : "(`status` = 1 and `partner_type` = 2 and `id` >= 1000)") : "(`id` = " .  User_Company_ID()  . " || `id` = " .  User_Company_ID()  . ") and `status` = 1 and `id` >= 1000 and `partner_type` = 2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewCustomAttributes = "";

		// job_category
		if (strval($this->job_category->CurrentValue) <> "") {
			$this->job_category->ViewValue = $this->job_category->optionCaption($this->job_category->CurrentValue);
		} else {
			$this->job_category->ViewValue = NULL;
		}
		$this->job_category->ViewCustomAttributes = "";

		// type
		if (strval($this->type->CurrentValue) <> "") {
			$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
		} else {
			$this->type->ViewValue = NULL;
		}
		$this->type->ViewCustomAttributes = "";

		// buyer_instruction
		$this->buyer_instruction->ViewValue = $this->buyer_instruction->CurrentValue;
		$this->buyer_instruction->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// eastimated_amount
		$this->eastimated_amount->ViewValue = $this->eastimated_amount->CurrentValue;
		$this->eastimated_amount->ViewCustomAttributes = "";

		// gst
		$curVal = strval($this->gst->CurrentValue);
		if ($curVal <> "") {
			$this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
			if ($this->gst->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->gst->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
					$arwrk[3] = $rswrk->fields('df3');
					$this->gst->ViewValue = $this->gst->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->gst->ViewValue = $this->gst->CurrentValue;
				}
			}
		} else {
			$this->gst->ViewValue = NULL;
		}
		$this->gst->ViewCustomAttributes = "";

		// payment_terms
		$curVal = strval($this->payment_terms->CurrentValue);
		if ($curVal <> "") {
			$this->payment_terms->ViewValue = $this->payment_terms->lookupCacheOption($curVal);
			if ($this->payment_terms->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 81";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->payment_terms->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->payment_terms->ViewValue = $this->payment_terms->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->payment_terms->ViewValue = $this->payment_terms->CurrentValue;
				}
			}
		} else {
			$this->payment_terms->ViewValue = NULL;
		}
		$this->payment_terms->ViewCustomAttributes = "";

		// uploads
		$this->uploads->UploadPath = '/.p_uploads/rental/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->ViewValue = "";
		}
		$this->uploads->CssClass = "font-italic";
		$this->uploads->ViewCustomAttributes = "";

		// reports_to
		$curVal = strval($this->reports_to->CurrentValue);
		if ($curVal <> "") {
			$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			if ($this->reports_to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`activated`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
				}
			}
		} else {
			$this->reports_to->ViewValue = NULL;
		}
		$this->reports_to->ViewCustomAttributes = "";

		// description_01
		$curVal = strval($this->description_01->CurrentValue);
		if ($curVal <> "") {
			$this->description_01->ViewValue = $this->description_01->lookupCacheOption($curVal);
			if ($this->description_01->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (17)" : "`s_grp` IN (17) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_01->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->description_01->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->description_01->ViewValue->add($this->description_01->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->description_01->ViewValue = $this->description_01->CurrentValue;
				}
			}
		} else {
			$this->description_01->ViewValue = NULL;
		}
		$this->description_01->ViewCustomAttributes = "";

		// description_02
		$curVal = strval($this->description_02->CurrentValue);
		if ($curVal <> "") {
			$this->description_02->ViewValue = $this->description_02->lookupCacheOption($curVal);
			if ($this->description_02->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (18)" : "`s_grp` IN (18) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_02->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->description_02->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->description_02->ViewValue->add($this->description_02->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->description_02->ViewValue = $this->description_02->CurrentValue;
				}
			}
		} else {
			$this->description_02->ViewValue = NULL;
		}
		$this->description_02->ViewCustomAttributes = "";

		// description_03
		$curVal = strval($this->description_03->CurrentValue);
		if ($curVal <> "") {
			$this->description_03->ViewValue = $this->description_03->lookupCacheOption($curVal);
			if ($this->description_03->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (19)" : "`s_grp` IN (19) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_03->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->description_03->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->description_03->ViewValue->add($this->description_03->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->description_03->ViewValue = $this->description_03->CurrentValue;
				}
			}
		} else {
			$this->description_03->ViewValue = NULL;
		}
		$this->description_03->ViewCustomAttributes = "";

		// description_04
		$curVal = strval($this->description_04->CurrentValue);
		if ($curVal <> "") {
			$this->description_04->ViewValue = $this->description_04->lookupCacheOption($curVal);
			if ($this->description_04->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (114)" : "`s_grp` IN (114) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_04->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->description_04->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->description_04->ViewValue->add($this->description_04->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->description_04->ViewValue = $this->description_04->CurrentValue;
				}
			}
		} else {
			$this->description_04->ViewValue = NULL;
		}
		$this->description_04->ViewCustomAttributes = "";

		// description_05
		$curVal = strval($this->description_05->CurrentValue);
		if ($curVal <> "") {
			$this->description_05->ViewValue = $this->description_05->lookupCacheOption($curVal);
			if ($this->description_05->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126)" : "`s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_05->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->description_05->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->description_05->ViewValue->add($this->description_05->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->description_05->ViewValue = $this->description_05->CurrentValue;
				}
			}
		} else {
			$this->description_05->ViewValue = NULL;
		}
		$this->description_05->ViewCustomAttributes = "";

		// description_06
		$curVal = strval($this->description_06->CurrentValue);
		if ($curVal <> "") {
			$this->description_06->ViewValue = $this->description_06->lookupCacheOption($curVal);
			if ($this->description_06->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (121)" : "`s_grp` IN (121) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_06->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->description_06->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->description_06->ViewValue->add($this->description_06->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->description_06->ViewValue = $this->description_06->CurrentValue;
				}
			}
		} else {
			$this->description_06->ViewValue = NULL;
		}
		$this->description_06->ViewCustomAttributes = "";

		// description_07
		$curVal = strval($this->description_07->CurrentValue);
		if ($curVal <> "") {
			$this->description_07->ViewValue = $this->description_07->lookupCacheOption($curVal);
			if ($this->description_07->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (123)" : "`s_grp` IN (123) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_07->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->description_07->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->description_07->ViewValue->add($this->description_07->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->description_07->ViewValue = $this->description_07->CurrentValue;
				}
			}
		} else {
			$this->description_07->ViewValue = NULL;
		}
		$this->description_07->ViewCustomAttributes = "";

		// description_08
		$curVal = strval($this->description_08->CurrentValue);
		if ($curVal <> "") {
			$this->description_08->ViewValue = $this->description_08->lookupCacheOption($curVal);
			if ($this->description_08->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (125)" : "`s_grp` IN (125) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_08->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->description_08->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->description_08->ViewValue->add($this->description_08->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->description_08->ViewValue = $this->description_08->CurrentValue;
				}
			}
		} else {
			$this->description_08->ViewValue = NULL;
		}
		$this->description_08->ViewCustomAttributes = "";

		// description_09
		$curVal = strval($this->description_09->CurrentValue);
		if ($curVal <> "") {
			$this->description_09->ViewValue = $this->description_09->lookupCacheOption($curVal);
			if ($this->description_09->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (126)" : "`s_grp` IN (126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_09->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->description_09->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->description_09->ViewValue->add($this->description_09->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->description_09->ViewValue = $this->description_09->CurrentValue;
				}
			}
		} else {
			$this->description_09->ViewValue = NULL;
		}
		$this->description_09->ViewCustomAttributes = "";

		// description_10
		$curVal = strval($this->description_10->CurrentValue);
		if ($curVal <> "") {
			$this->description_10->ViewValue = $this->description_10->lookupCacheOption($curVal);
			if ($this->description_10->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (124)" : "`s_grp` IN (124) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->description_10->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->description_10->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->description_10->ViewValue->add($this->description_10->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->description_10->ViewValue = $this->description_10->CurrentValue;
				}
			}
		} else {
			$this->description_10->ViewValue = NULL;
		}
		$this->description_10->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 11);
		$this->datetime->ViewCustomAttributes = "";

		// a_operator
		$curVal = strval($this->a_operator->CurrentValue);
		if ($curVal <> "") {
			$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			if ($this->a_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
				}
			}
		} else {
			$this->a_operator->ViewValue = NULL;
		}
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 11);
		$this->a_datetime->ViewCustomAttributes = "";

		// booking_ref
		$this->booking_ref->ViewValue = $this->booking_ref->CurrentValue;
		$this->booking_ref->ViewCustomAttributes = "";

		// contact_person
		$this->contact_person->ViewValue = $this->contact_person->CurrentValue;
		$this->contact_person->ViewCustomAttributes = "";

		// programme_end_datetime
		$this->programme_end_datetime->ViewValue = $this->programme_end_datetime->CurrentValue;
		$this->programme_end_datetime->ViewValue = FormatDateTime($this->programme_end_datetime->ViewValue, 0);
		$this->programme_end_datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// programme_datetime
		$this->programme_datetime->LinkCustomAttributes = "";
		$this->programme_datetime->HrefValue = "";
		$this->programme_datetime->TooltipValue = "";

		// location
		$this->location->LinkCustomAttributes = "";
		$this->location->HrefValue = "";
		$this->location->TooltipValue = "";

		// item
		$this->item->LinkCustomAttributes = "";
		$this->item->HrefValue = "";
		$this->item->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// job_category
		$this->job_category->LinkCustomAttributes = "";
		$this->job_category->HrefValue = "";
		$this->job_category->TooltipValue = "";

		// type
		$this->type->LinkCustomAttributes = "";
		$this->type->HrefValue = "";
		$this->type->TooltipValue = "";

		// buyer_instruction
		$this->buyer_instruction->LinkCustomAttributes = "";
		$this->buyer_instruction->HrefValue = "";
		$this->buyer_instruction->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// eastimated_amount
		$this->eastimated_amount->LinkCustomAttributes = "";
		$this->eastimated_amount->HrefValue = "";
		$this->eastimated_amount->TooltipValue = "";

		// gst
		$this->gst->LinkCustomAttributes = "";
		$this->gst->HrefValue = "";
		$this->gst->TooltipValue = "";

		// payment_terms
		$this->payment_terms->LinkCustomAttributes = "";
		if (!EmptyValue($this->payment_terms->CurrentValue)) {
			$this->payment_terms->HrefValue = "po_blist.php?x_payment_terms=" . $this->payment_terms->CurrentValue; // Add prefix/suffix
			$this->payment_terms->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->payment_terms->HrefValue = FullUrl($this->payment_terms->HrefValue, "href");
		} else {
			$this->payment_terms->HrefValue = "";
		}
		$this->payment_terms->TooltipValue = "";

		// uploads
		$this->uploads->LinkCustomAttributes = "";
		$this->uploads->UploadPath = '/.p_uploads/rental/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->HrefValue = "%u"; // Add prefix/suffix
			$this->uploads->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
		} else {
			$this->uploads->HrefValue = "";
		}
		$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
		$this->uploads->TooltipValue = "";
		if ($this->uploads->UseColorbox) {
			if (EmptyValue($this->uploads->TooltipValue))
				$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->uploads->LinkAttrs["data-rel"] = "rental_po_x_uploads";
			AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
		}

		// reports_to
		$this->reports_to->LinkCustomAttributes = "";
		$this->reports_to->HrefValue = "";
		$this->reports_to->TooltipValue = "";

		// description_01
		$this->description_01->LinkCustomAttributes = "";
		$this->description_01->HrefValue = "";
		$this->description_01->TooltipValue = "";

		// description_02
		$this->description_02->LinkCustomAttributes = "";
		$this->description_02->HrefValue = "";
		$this->description_02->TooltipValue = "";

		// description_03
		$this->description_03->LinkCustomAttributes = "";
		$this->description_03->HrefValue = "";
		$this->description_03->TooltipValue = "";

		// description_04
		$this->description_04->LinkCustomAttributes = "";
		$this->description_04->HrefValue = "";
		$this->description_04->TooltipValue = "";

		// description_05
		$this->description_05->LinkCustomAttributes = "";
		$this->description_05->HrefValue = "";
		$this->description_05->TooltipValue = "";

		// description_06
		$this->description_06->LinkCustomAttributes = "";
		$this->description_06->HrefValue = "";
		$this->description_06->TooltipValue = "";

		// description_07
		$this->description_07->LinkCustomAttributes = "";
		$this->description_07->HrefValue = "";
		$this->description_07->TooltipValue = "";

		// description_08
		$this->description_08->LinkCustomAttributes = "";
		$this->description_08->HrefValue = "";
		$this->description_08->TooltipValue = "";

		// description_09
		$this->description_09->LinkCustomAttributes = "";
		$this->description_09->HrefValue = "";
		$this->description_09->TooltipValue = "";

		// description_10
		$this->description_10->LinkCustomAttributes = "";
		$this->description_10->HrefValue = "";
		$this->description_10->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// a_datetime
		$this->a_datetime->LinkCustomAttributes = "";
		$this->a_datetime->HrefValue = "";
		$this->a_datetime->TooltipValue = "";

		// booking_ref
		$this->booking_ref->LinkCustomAttributes = "";
		$this->booking_ref->HrefValue = "";
		$this->booking_ref->TooltipValue = "";

		// contact_person
		$this->contact_person->LinkCustomAttributes = "";
		$this->contact_person->HrefValue = "";
		$this->contact_person->TooltipValue = "";

		// programme_end_datetime
		$this->programme_end_datetime->LinkCustomAttributes = "";
		$this->programme_end_datetime->HrefValue = "";
		$this->programme_end_datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// programme_datetime
		$this->programme_datetime->EditAttrs["class"] = "form-control";
		$this->programme_datetime->EditCustomAttributes = "";
		$this->programme_datetime->EditValue = FormatDateTime($this->programme_datetime->CurrentValue, 8);
		$this->programme_datetime->PlaceHolder = RemoveHtml($this->programme_datetime->caption());

		// location
		$this->location->EditAttrs["class"] = "form-control";
		$this->location->EditCustomAttributes = "";
		$this->location->EditValue = $this->location->CurrentValue;
		$this->location->PlaceHolder = RemoveHtml($this->location->caption());

		// item
		$this->item->EditAttrs["class"] = "form-control";
		$this->item->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->item->CurrentValue = HtmlDecode($this->item->CurrentValue);
		$this->item->EditValue = $this->item->CurrentValue;
		$this->item->PlaceHolder = RemoveHtml($this->item->caption());

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$this->company_id->EditValue = $this->company_id->CurrentValue;
		$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->amount->CurrentValue = HtmlDecode($this->amount->CurrentValue);
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

		// job_category
		$this->job_category->EditCustomAttributes = "";
		$this->job_category->EditValue = $this->job_category->options(FALSE);

		// type
		$this->type->EditAttrs["class"] = "form-control";
		$this->type->EditCustomAttributes = "";
		$this->type->EditValue = $this->type->options(TRUE);

		// buyer_instruction
		$this->buyer_instruction->EditAttrs["class"] = "form-control";
		$this->buyer_instruction->EditCustomAttributes = "";
		$this->buyer_instruction->EditValue = $this->buyer_instruction->CurrentValue;
		$this->buyer_instruction->PlaceHolder = RemoveHtml($this->buyer_instruction->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// eastimated_amount
		$this->eastimated_amount->EditAttrs["class"] = "form-control";
		$this->eastimated_amount->EditCustomAttributes = 'ReadOnly';
		$this->eastimated_amount->EditValue = $this->eastimated_amount->CurrentValue;
		$this->eastimated_amount->PlaceHolder = RemoveHtml($this->eastimated_amount->caption());
		if (strval($this->eastimated_amount->EditValue) <> "" && is_numeric($this->eastimated_amount->EditValue))
			$this->eastimated_amount->EditValue = FormatNumber($this->eastimated_amount->EditValue, -2, -1, -2, 0);

		// gst
		$this->gst->EditAttrs["class"] = "form-control";
		$this->gst->EditCustomAttributes = "";

		// payment_terms
		$this->payment_terms->EditAttrs["class"] = "form-control";
		$this->payment_terms->EditCustomAttributes = "";

		// uploads
		$this->uploads->EditAttrs["class"] = "form-control";
		$this->uploads->EditCustomAttributes = "";
		$this->uploads->UploadPath = '/.p_uploads/rental/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->EditValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->EditValue = "";
		}
		if (!EmptyValue($this->uploads->CurrentValue))
				$this->uploads->Upload->FileName = $this->uploads->CurrentValue;

		// reports_to
		$this->reports_to->EditAttrs["class"] = "form-control";
		$this->reports_to->EditCustomAttributes = "";

		// description_01
		$this->description_01->EditCustomAttributes = "";

		// description_02
		$this->description_02->EditCustomAttributes = "";

		// description_03
		$this->description_03->EditCustomAttributes = "";

		// description_04
		$this->description_04->EditCustomAttributes = "";

		// description_05
		$this->description_05->EditCustomAttributes = "";

		// description_06
		$this->description_06->EditCustomAttributes = "";

		// description_07
		$this->description_07->EditCustomAttributes = "";

		// description_08
		$this->description_08->EditCustomAttributes = "";

		// description_09
		$this->description_09->EditCustomAttributes = "";

		// description_10
		$this->description_10->EditCustomAttributes = "";

		// operator
		// datetime
		// a_operator
		// a_datetime
		// booking_ref

		$this->booking_ref->EditAttrs["class"] = "form-control";
		$this->booking_ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->booking_ref->CurrentValue = HtmlDecode($this->booking_ref->CurrentValue);
		$this->booking_ref->EditValue = $this->booking_ref->CurrentValue;
		$this->booking_ref->PlaceHolder = RemoveHtml($this->booking_ref->caption());

		// contact_person
		$this->contact_person->EditAttrs["class"] = "form-control";
		$this->contact_person->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->contact_person->CurrentValue = HtmlDecode($this->contact_person->CurrentValue);
		$this->contact_person->EditValue = $this->contact_person->CurrentValue;
		$this->contact_person->PlaceHolder = RemoveHtml($this->contact_person->caption());

		// programme_end_datetime
		$this->programme_end_datetime->EditAttrs["class"] = "form-control";
		$this->programme_end_datetime->EditCustomAttributes = "";
		$this->programme_end_datetime->EditValue = FormatDateTime($this->programme_end_datetime->CurrentValue, 8);
		$this->programme_end_datetime->PlaceHolder = RemoveHtml($this->programme_end_datetime->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->programme_datetime);
					$doc->exportCaption($this->location);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->gst);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->description_01);
					$doc->exportCaption($this->description_02);
					$doc->exportCaption($this->description_03);
					$doc->exportCaption($this->description_04);
					$doc->exportCaption($this->description_05);
					$doc->exportCaption($this->description_06);
					$doc->exportCaption($this->description_07);
					$doc->exportCaption($this->description_08);
					$doc->exportCaption($this->description_09);
					$doc->exportCaption($this->description_10);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->booking_ref);
					$doc->exportCaption($this->contact_person);
					$doc->exportCaption($this->programme_end_datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->programme_datetime);
					$doc->exportCaption($this->item);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->type);
					$doc->exportCaption($this->gst);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->booking_ref);
					$doc->exportCaption($this->contact_person);
					$doc->exportCaption($this->programme_end_datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->programme_datetime);
						$doc->exportField($this->location);
						$doc->exportField($this->company_id);
						$doc->exportField($this->amount);
						$doc->exportField($this->type);
						$doc->exportField($this->gst);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->description_01);
						$doc->exportField($this->description_02);
						$doc->exportField($this->description_03);
						$doc->exportField($this->description_04);
						$doc->exportField($this->description_05);
						$doc->exportField($this->description_06);
						$doc->exportField($this->description_07);
						$doc->exportField($this->description_08);
						$doc->exportField($this->description_09);
						$doc->exportField($this->description_10);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->booking_ref);
						$doc->exportField($this->contact_person);
						$doc->exportField($this->programme_end_datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->programme_datetime);
						$doc->exportField($this->item);
						$doc->exportField($this->company_id);
						$doc->exportField($this->amount);
						$doc->exportField($this->type);
						$doc->exportField($this->gst);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->booking_ref);
						$doc->exportField($this->contact_person);
						$doc->exportField($this->programme_end_datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'uploads') {
			$fldName = "uploads";
			$fileNameFld = "uploads";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Write Audit Trail start/end for grid update
	public function writeAuditTrailDummy($typ)
	{
		$table = 'rental_po';
		$usr = CurrentUserID();
		WriteAuditTrail("log", DbCurrentDateTime(), ScriptName(), $usr, $typ, $table, "", "", "", "");
	}

	// Write Audit Trail (add page)
	public function writeAuditTrailOnAdd(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnAdd)
			return;
		$table = 'rental_po';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$newvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$newvalue = $rs[$fldname];
					else
						$newvalue = "[MEMO]"; // Memo Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$newvalue = "[XML]"; // XML Field
				} else {
					$newvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $usr, "A", $table, $fldname, $key, "", $newvalue);
			}
		}
	}

	// Write Audit Trail (edit page)
	public function writeAuditTrailOnEdit(&$rsold, &$rsnew)
	{
		global $Language;
		if (!$this->AuditTrailOnEdit)
			return;
		$table = 'rental_po';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rsold['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$usr = CurrentUserID();
		foreach (array_keys($rsnew) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && array_key_exists($fldname, $rsold) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->DataType == DATATYPE_DATE) { // DateTime field
					$modified = (FormatDateTime($rsold[$fldname], 0) <> FormatDateTime($rsnew[$fldname], 0));
				} else {
					$modified = !CompareValue($rsold[$fldname], $rsnew[$fldname]);
				}
				if ($modified) {
					if ($this->fields[$fldname]->HtmlTag == "PASSWORD") { // Password Field
						$oldvalue = $Language->phrase("PasswordMask");
						$newvalue = $Language->phrase("PasswordMask");
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) { // Memo field
						if (AUDIT_TRAIL_TO_DATABASE) {
							$oldvalue = $rsold[$fldname];
							$newvalue = $rsnew[$fldname];
						} else {
							$oldvalue = "[MEMO]";
							$newvalue = "[MEMO]";
						}
					} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) { // XML field
						$oldvalue = "[XML]";
						$newvalue = "[XML]";
					} else {
						$oldvalue = $rsold[$fldname];
						$newvalue = $rsnew[$fldname];
					}
					WriteAuditTrail("log", $dt, $id, $usr, "U", $table, $fldname, $key, $oldvalue, $newvalue);
				}
			}
		}
	}

	// Write Audit Trail (delete page)
	public function writeAuditTrailOnDelete(&$rs)
	{
		global $Language;
		if (!$this->AuditTrailOnDelete)
			return;
		$table = 'rental_po';

		// Get key value
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs['id'];

		// Write Audit Trail
		$dt = DbCurrentDateTime();
		$id = ScriptName();
		$curUser = CurrentUserID();
		foreach (array_keys($rs) as $fldname) {
			if (array_key_exists($fldname, $this->fields) && $this->fields[$fldname]->DataType <> DATATYPE_BLOB) { // Ignore BLOB fields
				if ($this->fields[$fldname]->HtmlTag == "PASSWORD") {
					$oldvalue = $Language->phrase("PasswordMask"); // Password Field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_MEMO) {
					if (AUDIT_TRAIL_TO_DATABASE)
						$oldvalue = $rs[$fldname];
					else
						$oldvalue = "[MEMO]"; // Memo field
				} elseif ($this->fields[$fldname]->DataType == DATATYPE_XML) {
					$oldvalue = "[XML]"; // XML field
				} else {
					$oldvalue = $rs[$fldname];
				}
				WriteAuditTrail("log", $dt, $id, $curUser, "D", $table, $fldname, $key, $oldvalue, "");
			}
		}
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>