<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class rental_po_list extends rental_po
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'rental_po';

	// Page object name
	public $PageObjName = "rental_po_list";

	// Grid form hidden field names
	public $FormName = "frental_polist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Audit Trail
	public $AuditTrailOnAdd = TRUE;
	public $AuditTrailOnEdit = TRUE;
	public $AuditTrailOnDelete = TRUE;
	public $AuditTrailOnView = FALSE;
	public $AuditTrailOnViewData = FALSE;
	public $AuditTrailOnSearch = FALSE;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (rental_po)
		if (!isset($GLOBALS["rental_po"]) || get_class($GLOBALS["rental_po"]) == PROJECT_NAMESPACE . "rental_po") {
			$GLOBALS["rental_po"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["rental_po"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "rental_poadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "rental_podelete.php";
		$this->MultiUpdateUrl = "rental_poupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'rental_po');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option frental_polistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $rental_po;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($rental_po);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->a_operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->a_datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->programme_datetime->setVisibility();
		$this->location->setVisibility();
		$this->item->setVisibility();
		$this->company_id->setVisibility();
		$this->amount->setVisibility();
		$this->job_category->Visible = FALSE;
		$this->type->setVisibility();
		$this->buyer_instruction->Visible = FALSE;
		$this->remarks->Visible = FALSE;
		$this->eastimated_amount->Visible = FALSE;
		$this->gst->setVisibility();
		$this->payment_terms->Visible = FALSE;
		$this->uploads->Visible = FALSE;
		$this->reports_to->setVisibility();
		$this->description_01->Visible = FALSE;
		$this->description_02->Visible = FALSE;
		$this->description_03->Visible = FALSE;
		$this->description_04->Visible = FALSE;
		$this->description_05->Visible = FALSE;
		$this->description_06->Visible = FALSE;
		$this->description_07->Visible = FALSE;
		$this->description_08->Visible = FALSE;
		$this->description_09->Visible = FALSE;
		$this->description_10->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->booking_ref->setVisibility();
		$this->contact_person->setVisibility();
		$this->programme_end_datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->gst);
		$this->setupLookupOptions($this->payment_terms);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->description_01);
		$this->setupLookupOptions($this->description_02);
		$this->setupLookupOptions($this->description_03);
		$this->setupLookupOptions($this->description_04);
		$this->setupLookupOptions($this->description_05);
		$this->setupLookupOptions($this->description_06);
		$this->setupLookupOptions($this->description_07);
		$this->setupLookupOptions($this->description_08);
		$this->setupLookupOptions($this->description_09);
		$this->setupLookupOptions($this->description_10);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export selected records
		if ($this->isExport())
			$this->CurrentFilter = $this->buildExportSelectedFilter();

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}

			// Audit trail on search
			if ($this->AuditTrailOnSearch && $this->Command == "search" && !$this->RestoreSearch) {
				$searchParm = ServerVar("QUERY_STRING");
				$searchSql = $this->getSessionWhere();
				$this->writeAuditTrailOnSearch($searchParm, $searchSql);
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "frental_polistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->programme_datetime->AdvancedSearch->toJson(), ","); // Field programme_datetime
		$filterList = Concat($filterList, $this->location->AdvancedSearch->toJson(), ","); // Field location
		$filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
		$filterList = Concat($filterList, $this->amount->AdvancedSearch->toJson(), ","); // Field amount
		$filterList = Concat($filterList, $this->type->AdvancedSearch->toJson(), ","); // Field type
		$filterList = Concat($filterList, $this->buyer_instruction->AdvancedSearch->toJson(), ","); // Field buyer_instruction
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->gst->AdvancedSearch->toJson(), ","); // Field gst
		$filterList = Concat($filterList, $this->reports_to->AdvancedSearch->toJson(), ","); // Field reports_to
		$filterList = Concat($filterList, $this->description_01->AdvancedSearch->toJson(), ","); // Field description_01
		$filterList = Concat($filterList, $this->description_02->AdvancedSearch->toJson(), ","); // Field description_02
		$filterList = Concat($filterList, $this->description_03->AdvancedSearch->toJson(), ","); // Field description_03
		$filterList = Concat($filterList, $this->description_04->AdvancedSearch->toJson(), ","); // Field description_04
		$filterList = Concat($filterList, $this->description_05->AdvancedSearch->toJson(), ","); // Field description_05
		$filterList = Concat($filterList, $this->description_06->AdvancedSearch->toJson(), ","); // Field description_06
		$filterList = Concat($filterList, $this->description_07->AdvancedSearch->toJson(), ","); // Field description_07
		$filterList = Concat($filterList, $this->description_08->AdvancedSearch->toJson(), ","); // Field description_08
		$filterList = Concat($filterList, $this->description_09->AdvancedSearch->toJson(), ","); // Field description_09
		$filterList = Concat($filterList, $this->description_10->AdvancedSearch->toJson(), ","); // Field description_10
		$filterList = Concat($filterList, $this->booking_ref->AdvancedSearch->toJson(), ","); // Field booking_ref
		$filterList = Concat($filterList, $this->contact_person->AdvancedSearch->toJson(), ","); // Field contact_person
		$filterList = Concat($filterList, $this->programme_end_datetime->AdvancedSearch->toJson(), ","); // Field programme_end_datetime
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "frental_polistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field programme_datetime
		$this->programme_datetime->AdvancedSearch->SearchValue = @$filter["x_programme_datetime"];
		$this->programme_datetime->AdvancedSearch->SearchOperator = @$filter["z_programme_datetime"];
		$this->programme_datetime->AdvancedSearch->SearchCondition = @$filter["v_programme_datetime"];
		$this->programme_datetime->AdvancedSearch->SearchValue2 = @$filter["y_programme_datetime"];
		$this->programme_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_programme_datetime"];
		$this->programme_datetime->AdvancedSearch->save();

		// Field location
		$this->location->AdvancedSearch->SearchValue = @$filter["x_location"];
		$this->location->AdvancedSearch->SearchOperator = @$filter["z_location"];
		$this->location->AdvancedSearch->SearchCondition = @$filter["v_location"];
		$this->location->AdvancedSearch->SearchValue2 = @$filter["y_location"];
		$this->location->AdvancedSearch->SearchOperator2 = @$filter["w_location"];
		$this->location->AdvancedSearch->save();

		// Field company_id
		$this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
		$this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
		$this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
		$this->company_id->AdvancedSearch->save();

		// Field amount
		$this->amount->AdvancedSearch->SearchValue = @$filter["x_amount"];
		$this->amount->AdvancedSearch->SearchOperator = @$filter["z_amount"];
		$this->amount->AdvancedSearch->SearchCondition = @$filter["v_amount"];
		$this->amount->AdvancedSearch->SearchValue2 = @$filter["y_amount"];
		$this->amount->AdvancedSearch->SearchOperator2 = @$filter["w_amount"];
		$this->amount->AdvancedSearch->save();

		// Field type
		$this->type->AdvancedSearch->SearchValue = @$filter["x_type"];
		$this->type->AdvancedSearch->SearchOperator = @$filter["z_type"];
		$this->type->AdvancedSearch->SearchCondition = @$filter["v_type"];
		$this->type->AdvancedSearch->SearchValue2 = @$filter["y_type"];
		$this->type->AdvancedSearch->SearchOperator2 = @$filter["w_type"];
		$this->type->AdvancedSearch->save();

		// Field buyer_instruction
		$this->buyer_instruction->AdvancedSearch->SearchValue = @$filter["x_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchOperator = @$filter["z_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchCondition = @$filter["v_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchValue2 = @$filter["y_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->SearchOperator2 = @$filter["w_buyer_instruction"];
		$this->buyer_instruction->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field gst
		$this->gst->AdvancedSearch->SearchValue = @$filter["x_gst"];
		$this->gst->AdvancedSearch->SearchOperator = @$filter["z_gst"];
		$this->gst->AdvancedSearch->SearchCondition = @$filter["v_gst"];
		$this->gst->AdvancedSearch->SearchValue2 = @$filter["y_gst"];
		$this->gst->AdvancedSearch->SearchOperator2 = @$filter["w_gst"];
		$this->gst->AdvancedSearch->save();

		// Field reports_to
		$this->reports_to->AdvancedSearch->SearchValue = @$filter["x_reports_to"];
		$this->reports_to->AdvancedSearch->SearchOperator = @$filter["z_reports_to"];
		$this->reports_to->AdvancedSearch->SearchCondition = @$filter["v_reports_to"];
		$this->reports_to->AdvancedSearch->SearchValue2 = @$filter["y_reports_to"];
		$this->reports_to->AdvancedSearch->SearchOperator2 = @$filter["w_reports_to"];
		$this->reports_to->AdvancedSearch->save();

		// Field description_01
		$this->description_01->AdvancedSearch->SearchValue = @$filter["x_description_01"];
		$this->description_01->AdvancedSearch->SearchOperator = @$filter["z_description_01"];
		$this->description_01->AdvancedSearch->SearchCondition = @$filter["v_description_01"];
		$this->description_01->AdvancedSearch->SearchValue2 = @$filter["y_description_01"];
		$this->description_01->AdvancedSearch->SearchOperator2 = @$filter["w_description_01"];
		$this->description_01->AdvancedSearch->save();

		// Field description_02
		$this->description_02->AdvancedSearch->SearchValue = @$filter["x_description_02"];
		$this->description_02->AdvancedSearch->SearchOperator = @$filter["z_description_02"];
		$this->description_02->AdvancedSearch->SearchCondition = @$filter["v_description_02"];
		$this->description_02->AdvancedSearch->SearchValue2 = @$filter["y_description_02"];
		$this->description_02->AdvancedSearch->SearchOperator2 = @$filter["w_description_02"];
		$this->description_02->AdvancedSearch->save();

		// Field description_03
		$this->description_03->AdvancedSearch->SearchValue = @$filter["x_description_03"];
		$this->description_03->AdvancedSearch->SearchOperator = @$filter["z_description_03"];
		$this->description_03->AdvancedSearch->SearchCondition = @$filter["v_description_03"];
		$this->description_03->AdvancedSearch->SearchValue2 = @$filter["y_description_03"];
		$this->description_03->AdvancedSearch->SearchOperator2 = @$filter["w_description_03"];
		$this->description_03->AdvancedSearch->save();

		// Field description_04
		$this->description_04->AdvancedSearch->SearchValue = @$filter["x_description_04"];
		$this->description_04->AdvancedSearch->SearchOperator = @$filter["z_description_04"];
		$this->description_04->AdvancedSearch->SearchCondition = @$filter["v_description_04"];
		$this->description_04->AdvancedSearch->SearchValue2 = @$filter["y_description_04"];
		$this->description_04->AdvancedSearch->SearchOperator2 = @$filter["w_description_04"];
		$this->description_04->AdvancedSearch->save();

		// Field description_05
		$this->description_05->AdvancedSearch->SearchValue = @$filter["x_description_05"];
		$this->description_05->AdvancedSearch->SearchOperator = @$filter["z_description_05"];
		$this->description_05->AdvancedSearch->SearchCondition = @$filter["v_description_05"];
		$this->description_05->AdvancedSearch->SearchValue2 = @$filter["y_description_05"];
		$this->description_05->AdvancedSearch->SearchOperator2 = @$filter["w_description_05"];
		$this->description_05->AdvancedSearch->save();

		// Field description_06
		$this->description_06->AdvancedSearch->SearchValue = @$filter["x_description_06"];
		$this->description_06->AdvancedSearch->SearchOperator = @$filter["z_description_06"];
		$this->description_06->AdvancedSearch->SearchCondition = @$filter["v_description_06"];
		$this->description_06->AdvancedSearch->SearchValue2 = @$filter["y_description_06"];
		$this->description_06->AdvancedSearch->SearchOperator2 = @$filter["w_description_06"];
		$this->description_06->AdvancedSearch->save();

		// Field description_07
		$this->description_07->AdvancedSearch->SearchValue = @$filter["x_description_07"];
		$this->description_07->AdvancedSearch->SearchOperator = @$filter["z_description_07"];
		$this->description_07->AdvancedSearch->SearchCondition = @$filter["v_description_07"];
		$this->description_07->AdvancedSearch->SearchValue2 = @$filter["y_description_07"];
		$this->description_07->AdvancedSearch->SearchOperator2 = @$filter["w_description_07"];
		$this->description_07->AdvancedSearch->save();

		// Field description_08
		$this->description_08->AdvancedSearch->SearchValue = @$filter["x_description_08"];
		$this->description_08->AdvancedSearch->SearchOperator = @$filter["z_description_08"];
		$this->description_08->AdvancedSearch->SearchCondition = @$filter["v_description_08"];
		$this->description_08->AdvancedSearch->SearchValue2 = @$filter["y_description_08"];
		$this->description_08->AdvancedSearch->SearchOperator2 = @$filter["w_description_08"];
		$this->description_08->AdvancedSearch->save();

		// Field description_09
		$this->description_09->AdvancedSearch->SearchValue = @$filter["x_description_09"];
		$this->description_09->AdvancedSearch->SearchOperator = @$filter["z_description_09"];
		$this->description_09->AdvancedSearch->SearchCondition = @$filter["v_description_09"];
		$this->description_09->AdvancedSearch->SearchValue2 = @$filter["y_description_09"];
		$this->description_09->AdvancedSearch->SearchOperator2 = @$filter["w_description_09"];
		$this->description_09->AdvancedSearch->save();

		// Field description_10
		$this->description_10->AdvancedSearch->SearchValue = @$filter["x_description_10"];
		$this->description_10->AdvancedSearch->SearchOperator = @$filter["z_description_10"];
		$this->description_10->AdvancedSearch->SearchCondition = @$filter["v_description_10"];
		$this->description_10->AdvancedSearch->SearchValue2 = @$filter["y_description_10"];
		$this->description_10->AdvancedSearch->SearchOperator2 = @$filter["w_description_10"];
		$this->description_10->AdvancedSearch->save();

		// Field booking_ref
		$this->booking_ref->AdvancedSearch->SearchValue = @$filter["x_booking_ref"];
		$this->booking_ref->AdvancedSearch->SearchOperator = @$filter["z_booking_ref"];
		$this->booking_ref->AdvancedSearch->SearchCondition = @$filter["v_booking_ref"];
		$this->booking_ref->AdvancedSearch->SearchValue2 = @$filter["y_booking_ref"];
		$this->booking_ref->AdvancedSearch->SearchOperator2 = @$filter["w_booking_ref"];
		$this->booking_ref->AdvancedSearch->save();

		// Field contact_person
		$this->contact_person->AdvancedSearch->SearchValue = @$filter["x_contact_person"];
		$this->contact_person->AdvancedSearch->SearchOperator = @$filter["z_contact_person"];
		$this->contact_person->AdvancedSearch->SearchCondition = @$filter["v_contact_person"];
		$this->contact_person->AdvancedSearch->SearchValue2 = @$filter["y_contact_person"];
		$this->contact_person->AdvancedSearch->SearchOperator2 = @$filter["w_contact_person"];
		$this->contact_person->AdvancedSearch->save();

		// Field programme_end_datetime
		$this->programme_end_datetime->AdvancedSearch->SearchValue = @$filter["x_programme_end_datetime"];
		$this->programme_end_datetime->AdvancedSearch->SearchOperator = @$filter["z_programme_end_datetime"];
		$this->programme_end_datetime->AdvancedSearch->SearchCondition = @$filter["v_programme_end_datetime"];
		$this->programme_end_datetime->AdvancedSearch->SearchValue2 = @$filter["y_programme_end_datetime"];
		$this->programme_end_datetime->AdvancedSearch->SearchOperator2 = @$filter["w_programme_end_datetime"];
		$this->programme_end_datetime->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->programme_datetime, $default, FALSE); // programme_datetime
		$this->buildSearchSql($where, $this->location, $default, FALSE); // location
		$this->buildSearchSql($where, $this->company_id, $default, FALSE); // company_id
		$this->buildSearchSql($where, $this->amount, $default, FALSE); // amount
		$this->buildSearchSql($where, $this->type, $default, FALSE); // type
		$this->buildSearchSql($where, $this->buyer_instruction, $default, FALSE); // buyer_instruction
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->gst, $default, FALSE); // gst
		$this->buildSearchSql($where, $this->reports_to, $default, FALSE); // reports_to
		$this->buildSearchSql($where, $this->description_01, $default, TRUE); // description_01
		$this->buildSearchSql($where, $this->description_02, $default, TRUE); // description_02
		$this->buildSearchSql($where, $this->description_03, $default, TRUE); // description_03
		$this->buildSearchSql($where, $this->description_04, $default, TRUE); // description_04
		$this->buildSearchSql($where, $this->description_05, $default, TRUE); // description_05
		$this->buildSearchSql($where, $this->description_06, $default, TRUE); // description_06
		$this->buildSearchSql($where, $this->description_07, $default, TRUE); // description_07
		$this->buildSearchSql($where, $this->description_08, $default, TRUE); // description_08
		$this->buildSearchSql($where, $this->description_09, $default, TRUE); // description_09
		$this->buildSearchSql($where, $this->description_10, $default, TRUE); // description_10
		$this->buildSearchSql($where, $this->booking_ref, $default, FALSE); // booking_ref
		$this->buildSearchSql($where, $this->contact_person, $default, FALSE); // contact_person
		$this->buildSearchSql($where, $this->programme_end_datetime, $default, FALSE); // programme_end_datetime

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->programme_datetime->AdvancedSearch->save(); // programme_datetime
			$this->location->AdvancedSearch->save(); // location
			$this->company_id->AdvancedSearch->save(); // company_id
			$this->amount->AdvancedSearch->save(); // amount
			$this->type->AdvancedSearch->save(); // type
			$this->buyer_instruction->AdvancedSearch->save(); // buyer_instruction
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->gst->AdvancedSearch->save(); // gst
			$this->reports_to->AdvancedSearch->save(); // reports_to
			$this->description_01->AdvancedSearch->save(); // description_01
			$this->description_02->AdvancedSearch->save(); // description_02
			$this->description_03->AdvancedSearch->save(); // description_03
			$this->description_04->AdvancedSearch->save(); // description_04
			$this->description_05->AdvancedSearch->save(); // description_05
			$this->description_06->AdvancedSearch->save(); // description_06
			$this->description_07->AdvancedSearch->save(); // description_07
			$this->description_08->AdvancedSearch->save(); // description_08
			$this->description_09->AdvancedSearch->save(); // description_09
			$this->description_10->AdvancedSearch->save(); // description_10
			$this->booking_ref->AdvancedSearch->save(); // booking_ref
			$this->contact_person->AdvancedSearch->save(); // contact_person
			$this->programme_end_datetime->AdvancedSearch->save(); // programme_end_datetime
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->location, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->item, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->company_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->amount, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->gst, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_01, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_02, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->description_03, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->operator, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->datetime, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->booking_ref, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->contact_person, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->programme_datetime->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->location->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->company_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer_instruction->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->gst->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->reports_to->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_01->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_02->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_03->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_04->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_05->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_06->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_07->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_08->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_09->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->description_10->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->booking_ref->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->contact_person->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->programme_end_datetime->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->programme_datetime->AdvancedSearch->unsetSession();
		$this->location->AdvancedSearch->unsetSession();
		$this->company_id->AdvancedSearch->unsetSession();
		$this->amount->AdvancedSearch->unsetSession();
		$this->type->AdvancedSearch->unsetSession();
		$this->buyer_instruction->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->gst->AdvancedSearch->unsetSession();
		$this->reports_to->AdvancedSearch->unsetSession();
		$this->description_01->AdvancedSearch->unsetSession();
		$this->description_02->AdvancedSearch->unsetSession();
		$this->description_03->AdvancedSearch->unsetSession();
		$this->description_04->AdvancedSearch->unsetSession();
		$this->description_05->AdvancedSearch->unsetSession();
		$this->description_06->AdvancedSearch->unsetSession();
		$this->description_07->AdvancedSearch->unsetSession();
		$this->description_08->AdvancedSearch->unsetSession();
		$this->description_09->AdvancedSearch->unsetSession();
		$this->description_10->AdvancedSearch->unsetSession();
		$this->booking_ref->AdvancedSearch->unsetSession();
		$this->contact_person->AdvancedSearch->unsetSession();
		$this->programme_end_datetime->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->programme_datetime->AdvancedSearch->load();
		$this->location->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->type->AdvancedSearch->load();
		$this->buyer_instruction->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->gst->AdvancedSearch->load();
		$this->reports_to->AdvancedSearch->load();
		$this->description_01->AdvancedSearch->load();
		$this->description_02->AdvancedSearch->load();
		$this->description_03->AdvancedSearch->load();
		$this->description_04->AdvancedSearch->load();
		$this->description_05->AdvancedSearch->load();
		$this->description_06->AdvancedSearch->load();
		$this->description_07->AdvancedSearch->load();
		$this->description_08->AdvancedSearch->load();
		$this->description_09->AdvancedSearch->load();
		$this->description_10->AdvancedSearch->load();
		$this->booking_ref->AdvancedSearch->load();
		$this->contact_person->AdvancedSearch->load();
		$this->programme_end_datetime->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->programme_datetime, $ctrl); // programme_datetime
			$this->updateSort($this->location, $ctrl); // location
			$this->updateSort($this->item, $ctrl); // item
			$this->updateSort($this->company_id, $ctrl); // company_id
			$this->updateSort($this->amount, $ctrl); // amount
			$this->updateSort($this->type, $ctrl); // type
			$this->updateSort($this->gst, $ctrl); // gst
			$this->updateSort($this->reports_to, $ctrl); // reports_to
			$this->updateSort($this->operator, $ctrl); // operator
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->updateSort($this->booking_ref, $ctrl); // booking_ref
			$this->updateSort($this->contact_person, $ctrl); // contact_person
			$this->updateSort($this->programme_end_datetime, $ctrl); // programme_end_datetime
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->programme_datetime->setSort("");
				$this->location->setSort("");
				$this->item->setSort("");
				$this->company_id->setSort("");
				$this->amount->setSort("");
				$this->type->setSort("");
				$this->gst->setSort("");
				$this->reports_to->setSort("");
				$this->operator->setSort("");
				$this->datetime->setSort("");
				$this->booking_ref->setSort("");
				$this->contact_person->setSort("");
				$this->programme_end_datetime->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = TRUE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"frental_polistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"frental_polistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.frental_polist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"frental_polistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"rental_posrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"rental_po\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'rental_posrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"frental_polistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// programme_datetime
		if (!$this->isAddOrEdit())
			$this->programme_datetime->AdvancedSearch->setSearchValue(Get("x_programme_datetime", Get("programme_datetime", "")));
		if ($this->programme_datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->programme_datetime->AdvancedSearch->setSearchOperator(Get("z_programme_datetime", ""));

		// location
		if (!$this->isAddOrEdit())
			$this->location->AdvancedSearch->setSearchValue(Get("x_location", Get("location", "")));
		if ($this->location->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->location->AdvancedSearch->setSearchOperator(Get("z_location", ""));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue(Get("x_company_id", Get("company_id", "")));
		if ($this->company_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->company_id->AdvancedSearch->setSearchOperator(Get("z_company_id", ""));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue(Get("x_amount", Get("amount", "")));
		if ($this->amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->amount->AdvancedSearch->setSearchOperator(Get("z_amount", ""));

		// type
		if (!$this->isAddOrEdit())
			$this->type->AdvancedSearch->setSearchValue(Get("x_type", Get("type", "")));
		if ($this->type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->type->AdvancedSearch->setSearchOperator(Get("z_type", ""));

		// buyer_instruction
		if (!$this->isAddOrEdit())
			$this->buyer_instruction->AdvancedSearch->setSearchValue(Get("x_buyer_instruction", Get("buyer_instruction", "")));
		if ($this->buyer_instruction->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer_instruction->AdvancedSearch->setSearchOperator(Get("z_buyer_instruction", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// gst
		if (!$this->isAddOrEdit())
			$this->gst->AdvancedSearch->setSearchValue(Get("x_gst", Get("gst", "")));
		if ($this->gst->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gst->AdvancedSearch->setSearchOperator(Get("z_gst", ""));

		// reports_to
		if (!$this->isAddOrEdit())
			$this->reports_to->AdvancedSearch->setSearchValue(Get("x_reports_to", Get("reports_to", "")));
		if ($this->reports_to->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->reports_to->AdvancedSearch->setSearchOperator(Get("z_reports_to", ""));

		// description_01
		if (!$this->isAddOrEdit())
			$this->description_01->AdvancedSearch->setSearchValue(Get("x_description_01", Get("description_01", "")));
		if ($this->description_01->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_01->AdvancedSearch->setSearchOperator(Get("z_description_01", ""));
		if (is_array($this->description_01->AdvancedSearch->SearchValue))
			$this->description_01->AdvancedSearch->SearchValue = implode(",", $this->description_01->AdvancedSearch->SearchValue);
		if (is_array($this->description_01->AdvancedSearch->SearchValue2))
			$this->description_01->AdvancedSearch->SearchValue2 = implode(",", $this->description_01->AdvancedSearch->SearchValue2);

		// description_02
		if (!$this->isAddOrEdit())
			$this->description_02->AdvancedSearch->setSearchValue(Get("x_description_02", Get("description_02", "")));
		if ($this->description_02->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_02->AdvancedSearch->setSearchOperator(Get("z_description_02", ""));
		if (is_array($this->description_02->AdvancedSearch->SearchValue))
			$this->description_02->AdvancedSearch->SearchValue = implode(",", $this->description_02->AdvancedSearch->SearchValue);
		if (is_array($this->description_02->AdvancedSearch->SearchValue2))
			$this->description_02->AdvancedSearch->SearchValue2 = implode(",", $this->description_02->AdvancedSearch->SearchValue2);

		// description_03
		if (!$this->isAddOrEdit())
			$this->description_03->AdvancedSearch->setSearchValue(Get("x_description_03", Get("description_03", "")));
		if ($this->description_03->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_03->AdvancedSearch->setSearchOperator(Get("z_description_03", ""));
		if (is_array($this->description_03->AdvancedSearch->SearchValue))
			$this->description_03->AdvancedSearch->SearchValue = implode(",", $this->description_03->AdvancedSearch->SearchValue);
		if (is_array($this->description_03->AdvancedSearch->SearchValue2))
			$this->description_03->AdvancedSearch->SearchValue2 = implode(",", $this->description_03->AdvancedSearch->SearchValue2);

		// description_04
		if (!$this->isAddOrEdit())
			$this->description_04->AdvancedSearch->setSearchValue(Get("x_description_04", Get("description_04", "")));
		if ($this->description_04->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_04->AdvancedSearch->setSearchOperator(Get("z_description_04", ""));
		if (is_array($this->description_04->AdvancedSearch->SearchValue))
			$this->description_04->AdvancedSearch->SearchValue = implode(",", $this->description_04->AdvancedSearch->SearchValue);
		if (is_array($this->description_04->AdvancedSearch->SearchValue2))
			$this->description_04->AdvancedSearch->SearchValue2 = implode(",", $this->description_04->AdvancedSearch->SearchValue2);

		// description_05
		if (!$this->isAddOrEdit())
			$this->description_05->AdvancedSearch->setSearchValue(Get("x_description_05", Get("description_05", "")));
		if ($this->description_05->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_05->AdvancedSearch->setSearchOperator(Get("z_description_05", ""));
		if (is_array($this->description_05->AdvancedSearch->SearchValue))
			$this->description_05->AdvancedSearch->SearchValue = implode(",", $this->description_05->AdvancedSearch->SearchValue);
		if (is_array($this->description_05->AdvancedSearch->SearchValue2))
			$this->description_05->AdvancedSearch->SearchValue2 = implode(",", $this->description_05->AdvancedSearch->SearchValue2);

		// description_06
		if (!$this->isAddOrEdit())
			$this->description_06->AdvancedSearch->setSearchValue(Get("x_description_06", Get("description_06", "")));
		if ($this->description_06->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_06->AdvancedSearch->setSearchOperator(Get("z_description_06", ""));
		if (is_array($this->description_06->AdvancedSearch->SearchValue))
			$this->description_06->AdvancedSearch->SearchValue = implode(",", $this->description_06->AdvancedSearch->SearchValue);
		if (is_array($this->description_06->AdvancedSearch->SearchValue2))
			$this->description_06->AdvancedSearch->SearchValue2 = implode(",", $this->description_06->AdvancedSearch->SearchValue2);

		// description_07
		if (!$this->isAddOrEdit())
			$this->description_07->AdvancedSearch->setSearchValue(Get("x_description_07", Get("description_07", "")));
		if ($this->description_07->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_07->AdvancedSearch->setSearchOperator(Get("z_description_07", ""));
		if (is_array($this->description_07->AdvancedSearch->SearchValue))
			$this->description_07->AdvancedSearch->SearchValue = implode(",", $this->description_07->AdvancedSearch->SearchValue);
		if (is_array($this->description_07->AdvancedSearch->SearchValue2))
			$this->description_07->AdvancedSearch->SearchValue2 = implode(",", $this->description_07->AdvancedSearch->SearchValue2);

		// description_08
		if (!$this->isAddOrEdit())
			$this->description_08->AdvancedSearch->setSearchValue(Get("x_description_08", Get("description_08", "")));
		if ($this->description_08->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_08->AdvancedSearch->setSearchOperator(Get("z_description_08", ""));
		if (is_array($this->description_08->AdvancedSearch->SearchValue))
			$this->description_08->AdvancedSearch->SearchValue = implode(",", $this->description_08->AdvancedSearch->SearchValue);
		if (is_array($this->description_08->AdvancedSearch->SearchValue2))
			$this->description_08->AdvancedSearch->SearchValue2 = implode(",", $this->description_08->AdvancedSearch->SearchValue2);

		// description_09
		if (!$this->isAddOrEdit())
			$this->description_09->AdvancedSearch->setSearchValue(Get("x_description_09", Get("description_09", "")));
		if ($this->description_09->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_09->AdvancedSearch->setSearchOperator(Get("z_description_09", ""));
		if (is_array($this->description_09->AdvancedSearch->SearchValue))
			$this->description_09->AdvancedSearch->SearchValue = implode(",", $this->description_09->AdvancedSearch->SearchValue);
		if (is_array($this->description_09->AdvancedSearch->SearchValue2))
			$this->description_09->AdvancedSearch->SearchValue2 = implode(",", $this->description_09->AdvancedSearch->SearchValue2);

		// description_10
		if (!$this->isAddOrEdit())
			$this->description_10->AdvancedSearch->setSearchValue(Get("x_description_10", Get("description_10", "")));
		if ($this->description_10->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->description_10->AdvancedSearch->setSearchOperator(Get("z_description_10", ""));
		if (is_array($this->description_10->AdvancedSearch->SearchValue))
			$this->description_10->AdvancedSearch->SearchValue = implode(",", $this->description_10->AdvancedSearch->SearchValue);
		if (is_array($this->description_10->AdvancedSearch->SearchValue2))
			$this->description_10->AdvancedSearch->SearchValue2 = implode(",", $this->description_10->AdvancedSearch->SearchValue2);

		// booking_ref
		if (!$this->isAddOrEdit())
			$this->booking_ref->AdvancedSearch->setSearchValue(Get("x_booking_ref", Get("booking_ref", "")));
		if ($this->booking_ref->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->booking_ref->AdvancedSearch->setSearchOperator(Get("z_booking_ref", ""));

		// contact_person
		if (!$this->isAddOrEdit())
			$this->contact_person->AdvancedSearch->setSearchValue(Get("x_contact_person", Get("contact_person", "")));
		if ($this->contact_person->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->contact_person->AdvancedSearch->setSearchOperator(Get("z_contact_person", ""));

		// programme_end_datetime
		if (!$this->isAddOrEdit())
			$this->programme_end_datetime->AdvancedSearch->setSearchValue(Get("x_programme_end_datetime", Get("programme_end_datetime", "")));
		if ($this->programme_end_datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->programme_end_datetime->AdvancedSearch->setSearchOperator(Get("z_programme_end_datetime", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->programme_datetime->setDbValue($row['programme_datetime']);
		$this->location->setDbValue($row['location']);
		$this->item->setDbValue($row['item']);
		$this->company_id->setDbValue($row['company_id']);
		$this->amount->setDbValue($row['amount']);
		$this->job_category->setDbValue($row['job_category']);
		$this->type->setDbValue($row['type']);
		$this->buyer_instruction->setDbValue($row['buyer_instruction']);
		$this->remarks->setDbValue($row['remarks']);
		$this->eastimated_amount->setDbValue($row['eastimated_amount']);
		$this->gst->setDbValue($row['gst']);
		$this->payment_terms->setDbValue($row['payment_terms']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->description_01->setDbValue($row['description_01']);
		$this->description_02->setDbValue($row['description_02']);
		$this->description_03->setDbValue($row['description_03']);
		$this->description_04->setDbValue($row['description_04']);
		$this->description_05->setDbValue($row['description_05']);
		$this->description_06->setDbValue($row['description_06']);
		$this->description_07->setDbValue($row['description_07']);
		$this->description_08->setDbValue($row['description_08']);
		$this->description_09->setDbValue($row['description_09']);
		$this->description_10->setDbValue($row['description_10']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->booking_ref->setDbValue($row['booking_ref']);
		$this->contact_person->setDbValue($row['contact_person']);
		$this->programme_end_datetime->setDbValue($row['programme_end_datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['programme_datetime'] = NULL;
		$row['location'] = NULL;
		$row['item'] = NULL;
		$row['company_id'] = NULL;
		$row['amount'] = NULL;
		$row['job_category'] = NULL;
		$row['type'] = NULL;
		$row['buyer_instruction'] = NULL;
		$row['remarks'] = NULL;
		$row['eastimated_amount'] = NULL;
		$row['gst'] = NULL;
		$row['payment_terms'] = NULL;
		$row['uploads'] = NULL;
		$row['reports_to'] = NULL;
		$row['description_01'] = NULL;
		$row['description_02'] = NULL;
		$row['description_03'] = NULL;
		$row['description_04'] = NULL;
		$row['description_05'] = NULL;
		$row['description_06'] = NULL;
		$row['description_07'] = NULL;
		$row['description_08'] = NULL;
		$row['description_09'] = NULL;
		$row['description_10'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		$row['booking_ref'] = NULL;
		$row['contact_person'] = NULL;
		$row['programme_end_datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// programme_datetime
		// location
		// item
		// company_id
		// amount
		// job_category

		$this->job_category->CellCssStyle = "white-space: nowrap;";

		// type
		// buyer_instruction

		$this->buyer_instruction->CellCssStyle = "white-space: nowrap;";

		// remarks
		$this->remarks->CellCssStyle = "white-space: nowrap;";

		// eastimated_amount
		$this->eastimated_amount->CellCssStyle = "white-space: nowrap;";

		// gst
		// payment_terms

		$this->payment_terms->CellCssStyle = "white-space: nowrap;";

		// uploads
		$this->uploads->CellCssStyle = "white-space: nowrap;";

		// reports_to
		// description_01

		$this->description_01->CellCssStyle = "white-space: nowrap;";

		// description_02
		$this->description_02->CellCssStyle = "white-space: nowrap;";

		// description_03
		$this->description_03->CellCssStyle = "white-space: nowrap;";

		// description_04
		$this->description_04->CellCssStyle = "white-space: nowrap;";

		// description_05
		$this->description_05->CellCssStyle = "white-space: nowrap;";

		// description_06
		$this->description_06->CellCssStyle = "white-space: nowrap;";

		// description_07
		$this->description_07->CellCssStyle = "white-space: nowrap;";

		// description_08
		$this->description_08->CellCssStyle = "white-space: nowrap;";

		// description_09
		$this->description_09->CellCssStyle = "white-space: nowrap;";

		// description_10
		$this->description_10->CellCssStyle = "white-space: nowrap;";

		// operator
		// datetime
		// a_operator

		$this->a_operator->CellCssStyle = "white-space: nowrap;";

		// a_datetime
		$this->a_datetime->CellCssStyle = "white-space: nowrap;";

		// booking_ref
		// contact_person
		// programme_end_datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// programme_datetime
			$this->programme_datetime->ViewValue = $this->programme_datetime->CurrentValue;
			$this->programme_datetime->ViewValue = FormatDateTime($this->programme_datetime->ViewValue, 0);
			$this->programme_datetime->ViewCustomAttributes = "";

			// location
			$this->location->ViewValue = $this->location->CurrentValue;
			$this->location->ViewCustomAttributes = "";

			// item
			$this->item->ViewValue = $this->item->CurrentValue;
			$this->item->ViewCustomAttributes = "";

			// company_id
			$this->company_id->ViewValue = $this->company_id->CurrentValue;
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "" : "(`status` = 1 and `partner_type` = 2 and `id` >= 1000)") : "(`id` = " .  User_Company_ID()  . " || `id` = " .  User_Company_ID()  . ") and `status` = 1 and `id` >= 1000 and `partner_type` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewCustomAttributes = "";

			// type
			if (strval($this->type->CurrentValue) <> "") {
				$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// gst
			$curVal = strval($this->gst->CurrentValue);
			if ($curVal <> "") {
				$this->gst->ViewValue = $this->gst->lookupCacheOption($curVal);
				if ($this->gst->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->gst->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 2, -2, -2, -2);
						$arwrk[3] = $rswrk->fields('df3');
						$this->gst->ViewValue = $this->gst->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->gst->ViewValue = $this->gst->CurrentValue;
					}
				}
			} else {
				$this->gst->ViewValue = NULL;
			}
			$this->gst->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 11);
			$this->datetime->ViewCustomAttributes = "";

			// booking_ref
			$this->booking_ref->ViewValue = $this->booking_ref->CurrentValue;
			$this->booking_ref->ViewCustomAttributes = "";

			// contact_person
			$this->contact_person->ViewValue = $this->contact_person->CurrentValue;
			$this->contact_person->ViewCustomAttributes = "";

			// programme_end_datetime
			$this->programme_end_datetime->ViewValue = $this->programme_end_datetime->CurrentValue;
			$this->programme_end_datetime->ViewValue = FormatDateTime($this->programme_end_datetime->ViewValue, 0);
			$this->programme_end_datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// programme_datetime
			$this->programme_datetime->LinkCustomAttributes = "";
			$this->programme_datetime->HrefValue = "";
			$this->programme_datetime->TooltipValue = "";

			// location
			$this->location->LinkCustomAttributes = "";
			$this->location->HrefValue = "";
			$this->location->TooltipValue = "";
			if (!$this->isExport())
				$this->location->ViewValue = $this->highlightValue($this->location);

			// item
			$this->item->LinkCustomAttributes = "";
			$this->item->HrefValue = "";
			$this->item->TooltipValue = "";
			if (!$this->isExport())
				$this->item->ViewValue = $this->highlightValue($this->item);

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";
			if (!$this->isExport())
				$this->amount->ViewValue = $this->highlightValue($this->amount);

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";

			// gst
			$this->gst->LinkCustomAttributes = "";
			$this->gst->HrefValue = "";
			$this->gst->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// booking_ref
			$this->booking_ref->LinkCustomAttributes = "";
			$this->booking_ref->HrefValue = "";
			$this->booking_ref->TooltipValue = "";
			if (!$this->isExport())
				$this->booking_ref->ViewValue = $this->highlightValue($this->booking_ref);

			// contact_person
			$this->contact_person->LinkCustomAttributes = "";
			$this->contact_person->HrefValue = "";
			$this->contact_person->TooltipValue = "";
			if (!$this->isExport())
				$this->contact_person->ViewValue = $this->highlightValue($this->contact_person);

			// programme_end_datetime
			$this->programme_end_datetime->LinkCustomAttributes = "";
			$this->programme_end_datetime->HrefValue = "";
			$this->programme_end_datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// programme_datetime
			$this->programme_datetime->EditAttrs["class"] = "form-control";
			$this->programme_datetime->EditCustomAttributes = "";
			$this->programme_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->programme_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->programme_datetime->PlaceHolder = RemoveHtml($this->programme_datetime->caption());

			// location
			$this->location->EditAttrs["class"] = "form-control";
			$this->location->EditCustomAttributes = "";
			$this->location->EditValue = HtmlEncode($this->location->AdvancedSearch->SearchValue);
			$this->location->PlaceHolder = RemoveHtml($this->location->caption());

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->item->AdvancedSearch->SearchValue = HtmlDecode($this->item->AdvancedSearch->SearchValue);
			$this->item->EditValue = HtmlEncode($this->item->AdvancedSearch->SearchValue);
			$this->item->PlaceHolder = RemoveHtml($this->item->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$this->company_id->EditValue = HtmlEncode($this->company_id->AdvancedSearch->SearchValue);
			$curVal = strval($this->company_id->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "" : "(`status` = 1 and `partner_type` = 2 and `id` >= 1000)") : "(`id` = " .  User_Company_ID()  . " || `id` = " .  User_Company_ID()  . ") and `status` = 1 and `id` >= 1000 and `partner_type` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->EditValue = HtmlEncode($this->company_id->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->company_id->EditValue = NULL;
			}
			$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->amount->AdvancedSearch->SearchValue = HtmlDecode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$this->type->EditValue = $this->type->options(TRUE);

			// gst
			$this->gst->EditAttrs["class"] = "form-control";
			$this->gst->EditCustomAttributes = "";

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 11), 11));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// booking_ref
			$this->booking_ref->EditAttrs["class"] = "form-control";
			$this->booking_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->booking_ref->AdvancedSearch->SearchValue = HtmlDecode($this->booking_ref->AdvancedSearch->SearchValue);
			$this->booking_ref->EditValue = HtmlEncode($this->booking_ref->AdvancedSearch->SearchValue);
			$this->booking_ref->PlaceHolder = RemoveHtml($this->booking_ref->caption());

			// contact_person
			$this->contact_person->EditAttrs["class"] = "form-control";
			$this->contact_person->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->contact_person->AdvancedSearch->SearchValue = HtmlDecode($this->contact_person->AdvancedSearch->SearchValue);
			$this->contact_person->EditValue = HtmlEncode($this->contact_person->AdvancedSearch->SearchValue);
			$this->contact_person->PlaceHolder = RemoveHtml($this->contact_person->caption());

			// programme_end_datetime
			$this->programme_end_datetime->EditAttrs["class"] = "form-control";
			$this->programme_end_datetime->EditCustomAttributes = "";
			$this->programme_end_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->programme_end_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->programme_end_datetime->PlaceHolder = RemoveHtml($this->programme_end_datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->company_id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->company_id->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->programme_datetime->AdvancedSearch->load();
		$this->location->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->type->AdvancedSearch->load();
		$this->buyer_instruction->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->gst->AdvancedSearch->load();
		$this->reports_to->AdvancedSearch->load();
		$this->description_01->AdvancedSearch->load();
		$this->description_02->AdvancedSearch->load();
		$this->description_03->AdvancedSearch->load();
		$this->description_04->AdvancedSearch->load();
		$this->description_05->AdvancedSearch->load();
		$this->description_06->AdvancedSearch->load();
		$this->description_07->AdvancedSearch->load();
		$this->description_08->AdvancedSearch->load();
		$this->description_09->AdvancedSearch->load();
		$this->description_10->AdvancedSearch->load();
		$this->booking_ref->AdvancedSearch->load();
		$this->contact_person->AdvancedSearch->load();
		$this->programme_end_datetime->AdvancedSearch->load();
	}

	// Build export filter for selected records
	protected function buildExportSelectedFilter()
	{
		global $Language;
		$wrkFilter = "";
		if ($this->isExport())
			$wrkFilter = $this->getFilterFromRecordKeys();
		return $wrkFilter;
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.frental_polist,'" . CurrentPageName() . "','excel',true,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.frental_polist,'" . CurrentPageName() . "','excel',false,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.frental_polist,'" . CurrentPageName() . "','word',true,true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.frental_polist,'" . CurrentPageName() . "','word',false,true);\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.frental_polist,'" . CurrentPageName() . "','pdf',true,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.frental_polist,'" . CurrentPageName() . "','pdf',false,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" onclick=\"ew.export(document.frental_polist,'" . CurrentPageName() . "','html',false,true);\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" onclick=\"ew.export(document.frental_polist,'" . CurrentPageName() . "','xml',false,true);\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" onclick=\"ew.export(document.frental_polist,'" . CurrentPageName() . "','csv',false,true);\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" onclick=\"ew.export(document.frental_polist,'" . CurrentPageName() . "','print',false,true);\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_rental_po\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_rental_po',hdr:ew.language.phrase('ExportToEmailText'),f:document.frental_polist,sel:true" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return (User_Company_ID() == 0) ? ((User_Site() == 0) ? "" : "(`status` = 1 and `partner_type` = 2 and `id` >= 1000)") : "(`id` = " .  User_Company_ID()  . " || `id` = " .  User_Company_ID()  . ") and `status` = 1 and `id` >= 1000 and `partner_type` = 2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_gst":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_payment_terms":
					$lookupFilter = function() {
						return "`grp` = 81";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_reports_to":
					$lookupFilter = function() {
						return "`activated`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_01":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (17)" : "`s_grp` IN (17) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_02":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (18)" : "`s_grp` IN (18) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_03":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (19)" : "`s_grp` IN (19) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_04":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (114)" : "`s_grp` IN (114) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_05":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126)" : "`s_grp` NOT IN (101,102,112,114,115,116,121,123,124,125,126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_06":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (121)" : "`s_grp` IN (121) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_07":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (123)" : "`s_grp` IN (123) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_08":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (125)" : "`s_grp` IN (125) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_09":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (126)" : "`s_grp` IN (126) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_description_10":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`po_id` is NULL and `s_grp` IN (124)" : "`s_grp` IN (124) and (`po_id` is NULL || `po_id` = " . $this->id->CurrentValue . ")";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_gst":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
						case "x_payment_terms":
							break;
						case "x_reports_to":
							break;
						case "x_description_01":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_02":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_03":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_04":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_05":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_06":
							break;
						case "x_description_07":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_08":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_09":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_description_10":
							$row[2] = FormatNumber($row[2], 2, -2, -2, -2);
							$row['df2'] = $row[2];
							$row[3] = FormatNumber($row[3], 2, -2, -2, -2);
							$row['df3'] = $row[3];
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>