<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class request_archive_add extends request_archive
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'request_archive';

	// Page object name
	public $PageObjName = "request_archive_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (request_archive)
		if (!isset($GLOBALS["request_archive"]) || get_class($GLOBALS["request_archive"]) == PROJECT_NAMESPACE . "request_archive") {
			$GLOBALS["request_archive"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["request_archive"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'request_archive');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $request_archive;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($request_archive);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "request_archiveview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("request_archivelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->r_from->setVisibility();
		$this->r_to->setVisibility();
		$this->reference->setVisibility();
		$this->message->setVisibility();
		$this->uploads->setVisibility();
		$this->lead_info->setVisibility();
		$this->status->setVisibility();
		$this->Subject->setVisibility();
		$this->datetime->setVisibility();
		$this->QueryGenerator->setVisibility();
		$this->forward_url->setVisibility();
		$this->lead_by->setVisibility();
		$this->lead_status->setVisibility();
		$this->lead_type->setVisibility();
		$this->type->setVisibility();
		$this->alert->Visible = FALSE;
		$this->beep->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->lead_status);
		$this->setupLookupOptions($this->lead_type);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back
			$this->CopyRecord = FALSE;
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("request_archivelist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "request_archivelist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "request_archiveview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->uploads->Upload->Index = $CurrentForm->Index;
		$this->uploads->Upload->uploadFile();
		$this->uploads->CurrentValue = $this->uploads->Upload->FileName;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->r_from->CurrentValue = NULL;
		$this->r_from->OldValue = $this->r_from->CurrentValue;
		$this->r_to->CurrentValue = NULL;
		$this->r_to->OldValue = $this->r_to->CurrentValue;
		$this->reference->CurrentValue = 0;
		$this->message->CurrentValue = NULL;
		$this->message->OldValue = $this->message->CurrentValue;
		$this->uploads->Upload->DbValue = NULL;
		$this->uploads->OldValue = $this->uploads->Upload->DbValue;
		$this->uploads->CurrentValue = NULL; // Clear file related field
		$this->lead_info->CurrentValue = NULL;
		$this->lead_info->OldValue = $this->lead_info->CurrentValue;
		$this->status->CurrentValue = NULL;
		$this->status->OldValue = $this->status->CurrentValue;
		$this->Subject->CurrentValue = NULL;
		$this->Subject->OldValue = $this->Subject->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->QueryGenerator->CurrentValue = NULL;
		$this->QueryGenerator->OldValue = $this->QueryGenerator->CurrentValue;
		$this->forward_url->CurrentValue = NULL;
		$this->forward_url->OldValue = $this->forward_url->CurrentValue;
		$this->lead_by->CurrentValue = NULL;
		$this->lead_by->OldValue = $this->lead_by->CurrentValue;
		$this->lead_status->CurrentValue = NULL;
		$this->lead_status->OldValue = $this->lead_status->CurrentValue;
		$this->lead_type->CurrentValue = NULL;
		$this->lead_type->OldValue = $this->lead_type->CurrentValue;
		$this->type->CurrentValue = 0;
		$this->alert->CurrentValue = NULL;
		$this->alert->OldValue = $this->alert->CurrentValue;
		$this->beep->CurrentValue = NULL;
		$this->beep->OldValue = $this->beep->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->id->Visible = FALSE; // Disable update for API request
			else
				$this->id->setFormValue($val);
		}

		// Check field name 'r_from' first before field var 'x_r_from'
		$val = $CurrentForm->hasValue("r_from") ? $CurrentForm->getValue("r_from") : $CurrentForm->getValue("x_r_from");
		if (!$this->r_from->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->r_from->Visible = FALSE; // Disable update for API request
			else
				$this->r_from->setFormValue($val);
		}

		// Check field name 'r_to' first before field var 'x_r_to'
		$val = $CurrentForm->hasValue("r_to") ? $CurrentForm->getValue("r_to") : $CurrentForm->getValue("x_r_to");
		if (!$this->r_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->r_to->Visible = FALSE; // Disable update for API request
			else
				$this->r_to->setFormValue($val);
		}

		// Check field name 'reference' first before field var 'x_reference'
		$val = $CurrentForm->hasValue("reference") ? $CurrentForm->getValue("reference") : $CurrentForm->getValue("x_reference");
		if (!$this->reference->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reference->Visible = FALSE; // Disable update for API request
			else
				$this->reference->setFormValue($val);
		}

		// Check field name 'message' first before field var 'x_message'
		$val = $CurrentForm->hasValue("message") ? $CurrentForm->getValue("message") : $CurrentForm->getValue("x_message");
		if (!$this->message->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->message->Visible = FALSE; // Disable update for API request
			else
				$this->message->setFormValue($val);
		}

		// Check field name 'lead_info' first before field var 'x_lead_info'
		$val = $CurrentForm->hasValue("lead_info") ? $CurrentForm->getValue("lead_info") : $CurrentForm->getValue("x_lead_info");
		if (!$this->lead_info->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lead_info->Visible = FALSE; // Disable update for API request
			else
				$this->lead_info->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'Subject' first before field var 'x_Subject'
		$val = $CurrentForm->hasValue("Subject") ? $CurrentForm->getValue("Subject") : $CurrentForm->getValue("x_Subject");
		if (!$this->Subject->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Subject->Visible = FALSE; // Disable update for API request
			else
				$this->Subject->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'QueryGenerator' first before field var 'x_QueryGenerator'
		$val = $CurrentForm->hasValue("QueryGenerator") ? $CurrentForm->getValue("QueryGenerator") : $CurrentForm->getValue("x_QueryGenerator");
		if (!$this->QueryGenerator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->QueryGenerator->Visible = FALSE; // Disable update for API request
			else
				$this->QueryGenerator->setFormValue($val);
		}

		// Check field name 'forward_url' first before field var 'x_forward_url'
		$val = $CurrentForm->hasValue("forward_url") ? $CurrentForm->getValue("forward_url") : $CurrentForm->getValue("x_forward_url");
		if (!$this->forward_url->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->forward_url->Visible = FALSE; // Disable update for API request
			else
				$this->forward_url->setFormValue($val);
		}

		// Check field name 'lead_by' first before field var 'x_lead_by'
		$val = $CurrentForm->hasValue("lead_by") ? $CurrentForm->getValue("lead_by") : $CurrentForm->getValue("x_lead_by");
		if (!$this->lead_by->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lead_by->Visible = FALSE; // Disable update for API request
			else
				$this->lead_by->setFormValue($val);
		}

		// Check field name 'lead_status' first before field var 'x_lead_status'
		$val = $CurrentForm->hasValue("lead_status") ? $CurrentForm->getValue("lead_status") : $CurrentForm->getValue("x_lead_status");
		if (!$this->lead_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lead_status->Visible = FALSE; // Disable update for API request
			else
				$this->lead_status->setFormValue($val);
		}

		// Check field name 'lead_type' first before field var 'x_lead_type'
		$val = $CurrentForm->hasValue("lead_type") ? $CurrentForm->getValue("lead_type") : $CurrentForm->getValue("x_lead_type");
		if (!$this->lead_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lead_type->Visible = FALSE; // Disable update for API request
			else
				$this->lead_type->setFormValue($val);
		}

		// Check field name 'type' first before field var 'x_type'
		$val = $CurrentForm->hasValue("type") ? $CurrentForm->getValue("type") : $CurrentForm->getValue("x_type");
		if (!$this->type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->type->Visible = FALSE; // Disable update for API request
			else
				$this->type->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->r_from->CurrentValue = $this->r_from->FormValue;
		$this->r_to->CurrentValue = $this->r_to->FormValue;
		$this->reference->CurrentValue = $this->reference->FormValue;
		$this->message->CurrentValue = $this->message->FormValue;
		$this->lead_info->CurrentValue = $this->lead_info->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->Subject->CurrentValue = $this->Subject->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->QueryGenerator->CurrentValue = $this->QueryGenerator->FormValue;
		$this->forward_url->CurrentValue = $this->forward_url->FormValue;
		$this->lead_by->CurrentValue = $this->lead_by->FormValue;
		$this->lead_status->CurrentValue = $this->lead_status->FormValue;
		$this->lead_type->CurrentValue = $this->lead_type->FormValue;
		$this->type->CurrentValue = $this->type->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->r_from->setDbValue($row['r_from']);
		$this->r_to->setDbValue($row['r_to']);
		$this->reference->setDbValue($row['reference']);
		$this->message->setDbValue($row['message']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->lead_info->setDbValue($row['lead_info']);
		$this->status->setDbValue($row['status']);
		$this->Subject->setDbValue($row['Subject']);
		$this->datetime->setDbValue($row['datetime']);
		$this->QueryGenerator->setDbValue($row['QueryGenerator']);
		$this->forward_url->setDbValue($row['forward_url']);
		$this->lead_by->setDbValue($row['lead_by']);
		$this->lead_status->setDbValue($row['lead_status']);
		$this->lead_type->setDbValue($row['lead_type']);
		$this->type->setDbValue($row['type']);
		$this->alert->setDbValue($row['alert']);
		$this->beep->setDbValue($row['beep']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['r_from'] = $this->r_from->CurrentValue;
		$row['r_to'] = $this->r_to->CurrentValue;
		$row['reference'] = $this->reference->CurrentValue;
		$row['message'] = $this->message->CurrentValue;
		$row['uploads'] = $this->uploads->Upload->DbValue;
		$row['lead_info'] = $this->lead_info->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['Subject'] = $this->Subject->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['QueryGenerator'] = $this->QueryGenerator->CurrentValue;
		$row['forward_url'] = $this->forward_url->CurrentValue;
		$row['lead_by'] = $this->lead_by->CurrentValue;
		$row['lead_status'] = $this->lead_status->CurrentValue;
		$row['lead_type'] = $this->lead_type->CurrentValue;
		$row['type'] = $this->type->CurrentValue;
		$row['alert'] = $this->alert->CurrentValue;
		$row['beep'] = $this->beep->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{
		return FALSE;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->reference->FormValue == $this->reference->CurrentValue && is_numeric(ConvertToFloatString($this->reference->CurrentValue)))
			$this->reference->CurrentValue = ConvertToFloatString($this->reference->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// r_from
		// r_to
		// reference
		// message
		// uploads
		// lead_info
		// status
		// Subject
		// datetime
		// QueryGenerator
		// forward_url
		// lead_by
		// lead_status
		// lead_type
		// type
		// alert
		// beep

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// r_from
			$this->r_from->ViewValue = $this->r_from->CurrentValue;
			$this->r_from->ViewCustomAttributes = "";

			// r_to
			$this->r_to->ViewValue = $this->r_to->CurrentValue;
			$this->r_to->ViewCustomAttributes = "";

			// reference
			$this->reference->ViewValue = $this->reference->CurrentValue;
			$this->reference->ViewValue = FormatNumber($this->reference->ViewValue, 2, -2, -2, -2);
			$this->reference->ViewCustomAttributes = "";

			// message
			$this->message->ViewValue = $this->message->CurrentValue;
			$this->message->ViewCustomAttributes = "";

			// uploads
			$this->uploads->UploadPath = ".p_uploads/request/";
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// lead_info
			$this->lead_info->ViewValue = $this->lead_info->CurrentValue;
			$this->lead_info->ViewCustomAttributes = "";

			// status
			$this->status->ViewValue = $this->status->CurrentValue;
			$this->status->ViewValue = FormatNumber($this->status->ViewValue, 0, -2, -2, -2);
			$this->status->ViewCustomAttributes = "";

			// Subject
			$this->Subject->ViewValue = $this->Subject->CurrentValue;
			$this->Subject->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// QueryGenerator
			$this->QueryGenerator->ViewValue = $this->QueryGenerator->CurrentValue;
			$this->QueryGenerator->ViewCustomAttributes = "";

			// forward_url
			$this->forward_url->ViewValue = $this->forward_url->CurrentValue;
			$this->forward_url->ViewCustomAttributes = "";

			// lead_by
			$this->lead_by->ViewValue = $this->lead_by->CurrentValue;
			$this->lead_by->ViewCustomAttributes = "";

			// lead_status
			$curVal = strval($this->lead_status->CurrentValue);
			if ($curVal <> "") {
				$this->lead_status->ViewValue = $this->lead_status->lookupCacheOption($curVal);
				if ($this->lead_status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`item`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`grp`=12";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->lead_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->lead_status->ViewValue = $this->lead_status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->lead_status->ViewValue = $this->lead_status->CurrentValue;
					}
				}
			} else {
				$this->lead_status->ViewValue = NULL;
			}
			$this->lead_status->ViewCustomAttributes = "";

			// lead_type
			$curVal = strval($this->lead_type->CurrentValue);
			if ($curVal <> "") {
				$this->lead_type->ViewValue = $this->lead_type->lookupCacheOption($curVal);
				if ($this->lead_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`item`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->lead_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->lead_type->ViewValue = $this->lead_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->lead_type->ViewValue = $this->lead_type->CurrentValue;
					}
				}
			} else {
				$this->lead_type->ViewValue = NULL;
			}
			$this->lead_type->ViewCustomAttributes = "";

			// type
			if (strval($this->type->CurrentValue) <> "") {
				$this->type->ViewValue = $this->type->optionCaption($this->type->CurrentValue);
			} else {
				$this->type->ViewValue = NULL;
			}
			$this->type->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// r_from
			$this->r_from->LinkCustomAttributes = "";
			$this->r_from->HrefValue = "";
			$this->r_from->TooltipValue = "";

			// r_to
			$this->r_to->LinkCustomAttributes = "";
			$this->r_to->HrefValue = "";
			$this->r_to->TooltipValue = "";

			// reference
			$this->reference->LinkCustomAttributes = "";
			$this->reference->HrefValue = "";
			$this->reference->TooltipValue = "";

			// message
			$this->message->LinkCustomAttributes = "";
			$this->message->HrefValue = "";
			$this->message->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = ".p_uploads/request/";
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "request_archive_x_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// lead_info
			$this->lead_info->LinkCustomAttributes = "";
			$this->lead_info->HrefValue = "";
			$this->lead_info->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// Subject
			$this->Subject->LinkCustomAttributes = "";
			$this->Subject->HrefValue = "";
			$this->Subject->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// QueryGenerator
			$this->QueryGenerator->LinkCustomAttributes = "";
			$this->QueryGenerator->HrefValue = "";
			$this->QueryGenerator->TooltipValue = "";

			// forward_url
			$this->forward_url->LinkCustomAttributes = "";
			$this->forward_url->HrefValue = "";
			$this->forward_url->TooltipValue = "";

			// lead_by
			$this->lead_by->LinkCustomAttributes = "";
			$this->lead_by->HrefValue = "";
			$this->lead_by->TooltipValue = "";

			// lead_status
			$this->lead_status->LinkCustomAttributes = "";
			$this->lead_status->HrefValue = "";
			$this->lead_status->TooltipValue = "";

			// lead_type
			$this->lead_type->LinkCustomAttributes = "";
			$this->lead_type->HrefValue = "";
			$this->lead_type->TooltipValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
			$this->type->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->CurrentValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// r_from
			$this->r_from->EditAttrs["class"] = "form-control";
			$this->r_from->EditCustomAttributes = "";
			$this->r_from->EditValue = HtmlEncode($this->r_from->CurrentValue);
			$this->r_from->PlaceHolder = RemoveHtml($this->r_from->caption());

			// r_to
			$this->r_to->EditAttrs["class"] = "form-control";
			$this->r_to->EditCustomAttributes = "";
			$this->r_to->EditValue = HtmlEncode($this->r_to->CurrentValue);
			$this->r_to->PlaceHolder = RemoveHtml($this->r_to->caption());

			// reference
			$this->reference->EditAttrs["class"] = "form-control";
			$this->reference->EditCustomAttributes = "";
			$this->reference->EditValue = HtmlEncode($this->reference->CurrentValue);
			$this->reference->PlaceHolder = RemoveHtml($this->reference->caption());
			if (strval($this->reference->EditValue) <> "" && is_numeric($this->reference->EditValue))
				$this->reference->EditValue = FormatNumber($this->reference->EditValue, -2, -2, -2, -2);

			// message
			$this->message->EditAttrs["class"] = "form-control";
			$this->message->EditCustomAttributes = "";
			$this->message->EditValue = HtmlEncode($this->message->CurrentValue);
			$this->message->PlaceHolder = RemoveHtml($this->message->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->UploadPath = ".p_uploads/request/";
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->EditValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->EditValue = "";
			}
			if (!EmptyValue($this->uploads->CurrentValue))
					$this->uploads->Upload->FileName = $this->uploads->CurrentValue;
			if (($this->isShow() || $this->isCopy()) && !$this->EventCancelled)
				RenderUploadField($this->uploads);

			// lead_info
			$this->lead_info->EditAttrs["class"] = "form-control";
			$this->lead_info->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lead_info->CurrentValue = HtmlDecode($this->lead_info->CurrentValue);
			$this->lead_info->EditValue = HtmlEncode($this->lead_info->CurrentValue);
			$this->lead_info->PlaceHolder = RemoveHtml($this->lead_info->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = HtmlEncode($this->status->CurrentValue);
			$this->status->PlaceHolder = RemoveHtml($this->status->caption());

			// Subject
			$this->Subject->EditAttrs["class"] = "form-control";
			$this->Subject->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->Subject->CurrentValue = HtmlDecode($this->Subject->CurrentValue);
			$this->Subject->EditValue = HtmlEncode($this->Subject->CurrentValue);
			$this->Subject->PlaceHolder = RemoveHtml($this->Subject->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime($this->datetime->CurrentValue, 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// QueryGenerator
			$this->QueryGenerator->EditAttrs["class"] = "form-control";
			$this->QueryGenerator->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->QueryGenerator->CurrentValue = HtmlDecode($this->QueryGenerator->CurrentValue);
			$this->QueryGenerator->EditValue = HtmlEncode($this->QueryGenerator->CurrentValue);
			$this->QueryGenerator->PlaceHolder = RemoveHtml($this->QueryGenerator->caption());

			// forward_url
			$this->forward_url->EditAttrs["class"] = "form-control";
			$this->forward_url->EditCustomAttributes = "";
			$this->forward_url->EditValue = HtmlEncode($this->forward_url->CurrentValue);
			$this->forward_url->PlaceHolder = RemoveHtml($this->forward_url->caption());

			// lead_by
			$this->lead_by->EditAttrs["class"] = "form-control";
			$this->lead_by->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lead_by->CurrentValue = HtmlDecode($this->lead_by->CurrentValue);
			$this->lead_by->EditValue = HtmlEncode($this->lead_by->CurrentValue);
			$this->lead_by->PlaceHolder = RemoveHtml($this->lead_by->caption());

			// lead_status
			$this->lead_status->EditCustomAttributes = "";
			$curVal = trim(strval($this->lead_status->CurrentValue));
			if ($curVal <> "")
				$this->lead_status->ViewValue = $this->lead_status->lookupCacheOption($curVal);
			else
				$this->lead_status->ViewValue = $this->lead_status->Lookup !== NULL && is_array($this->lead_status->Lookup->Options) ? $curVal : NULL;
			if ($this->lead_status->ViewValue !== NULL) { // Load from cache
				$this->lead_status->EditValue = array_values($this->lead_status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`item`" . SearchString("=", $this->lead_status->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`grp`=12";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->lead_status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->lead_status->EditValue = $arwrk;
			}

			// lead_type
			$this->lead_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->lead_type->CurrentValue));
			if ($curVal <> "")
				$this->lead_type->ViewValue = $this->lead_type->lookupCacheOption($curVal);
			else
				$this->lead_type->ViewValue = $this->lead_type->Lookup !== NULL && is_array($this->lead_type->Lookup->Options) ? $curVal : NULL;
			if ($this->lead_type->ViewValue !== NULL) { // Load from cache
				$this->lead_type->EditValue = array_values($this->lead_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`item`" . SearchString("=", $this->lead_type->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`grp`=11";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->lead_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->lead_type->EditValue = $arwrk;
			}

			// type
			$this->type->EditAttrs["class"] = "form-control";
			$this->type->EditCustomAttributes = "";
			$this->type->EditValue = $this->type->options(TRUE);

			// Add refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// r_from
			$this->r_from->LinkCustomAttributes = "";
			$this->r_from->HrefValue = "";

			// r_to
			$this->r_to->LinkCustomAttributes = "";
			$this->r_to->HrefValue = "";

			// reference
			$this->reference->LinkCustomAttributes = "";
			$this->reference->HrefValue = "";

			// message
			$this->message->LinkCustomAttributes = "";
			$this->message->HrefValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = ".p_uploads/request/";
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

			// lead_info
			$this->lead_info->LinkCustomAttributes = "";
			$this->lead_info->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// Subject
			$this->Subject->LinkCustomAttributes = "";
			$this->Subject->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// QueryGenerator
			$this->QueryGenerator->LinkCustomAttributes = "";
			$this->QueryGenerator->HrefValue = "";

			// forward_url
			$this->forward_url->LinkCustomAttributes = "";
			$this->forward_url->HrefValue = "";

			// lead_by
			$this->lead_by->LinkCustomAttributes = "";
			$this->lead_by->HrefValue = "";

			// lead_status
			$this->lead_status->LinkCustomAttributes = "";
			$this->lead_status->HrefValue = "";

			// lead_type
			$this->lead_type->LinkCustomAttributes = "";
			$this->lead_type->HrefValue = "";

			// type
			$this->type->LinkCustomAttributes = "";
			$this->type->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->id->FormValue)) {
			AddMessage($FormError, $this->id->errorMessage());
		}
		if ($this->r_from->Required) {
			if (!$this->r_from->IsDetailKey && $this->r_from->FormValue != NULL && $this->r_from->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_from->caption(), $this->r_from->RequiredErrorMessage));
			}
		}
		if ($this->r_to->Required) {
			if (!$this->r_to->IsDetailKey && $this->r_to->FormValue != NULL && $this->r_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_to->caption(), $this->r_to->RequiredErrorMessage));
			}
		}
		if ($this->reference->Required) {
			if (!$this->reference->IsDetailKey && $this->reference->FormValue != NULL && $this->reference->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reference->caption(), $this->reference->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->reference->FormValue)) {
			AddMessage($FormError, $this->reference->errorMessage());
		}
		if ($this->message->Required) {
			if (!$this->message->IsDetailKey && $this->message->FormValue != NULL && $this->message->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->message->caption(), $this->message->RequiredErrorMessage));
			}
		}
		if ($this->uploads->Required) {
			if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}
		if ($this->lead_info->Required) {
			if (!$this->lead_info->IsDetailKey && $this->lead_info->FormValue != NULL && $this->lead_info->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lead_info->caption(), $this->lead_info->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->status->FormValue)) {
			AddMessage($FormError, $this->status->errorMessage());
		}
		if ($this->Subject->Required) {
			if (!$this->Subject->IsDetailKey && $this->Subject->FormValue != NULL && $this->Subject->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Subject->caption(), $this->Subject->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->datetime->FormValue)) {
			AddMessage($FormError, $this->datetime->errorMessage());
		}
		if ($this->QueryGenerator->Required) {
			if (!$this->QueryGenerator->IsDetailKey && $this->QueryGenerator->FormValue != NULL && $this->QueryGenerator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->QueryGenerator->caption(), $this->QueryGenerator->RequiredErrorMessage));
			}
		}
		if ($this->forward_url->Required) {
			if (!$this->forward_url->IsDetailKey && $this->forward_url->FormValue != NULL && $this->forward_url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->forward_url->caption(), $this->forward_url->RequiredErrorMessage));
			}
		}
		if ($this->lead_by->Required) {
			if (!$this->lead_by->IsDetailKey && $this->lead_by->FormValue != NULL && $this->lead_by->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lead_by->caption(), $this->lead_by->RequiredErrorMessage));
			}
		}
		if ($this->lead_status->Required) {
			if ($this->lead_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lead_status->caption(), $this->lead_status->RequiredErrorMessage));
			}
		}
		if ($this->lead_type->Required) {
			if ($this->lead_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lead_type->caption(), $this->lead_type->RequiredErrorMessage));
			}
		}
		if ($this->type->Required) {
			if (!$this->type->IsDetailKey && $this->type->FormValue != NULL && $this->type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->type->caption(), $this->type->RequiredErrorMessage));
			}
		}
		if ($this->alert->Required) {
			if (!$this->alert->IsDetailKey && $this->alert->FormValue != NULL && $this->alert->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->alert->caption(), $this->alert->RequiredErrorMessage));
			}
		}
		if ($this->beep->Required) {
			if (!$this->beep->IsDetailKey && $this->beep->FormValue != NULL && $this->beep->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->beep->caption(), $this->beep->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->uploads->OldUploadPath = ".p_uploads/request/";
			$this->uploads->UploadPath = $this->uploads->OldUploadPath;
		}
		$rsnew = [];

		// id
		$this->id->setDbValueDef($rsnew, $this->id->CurrentValue, NULL, FALSE);

		// r_from
		$this->r_from->setDbValueDef($rsnew, $this->r_from->CurrentValue, NULL, FALSE);

		// r_to
		$this->r_to->setDbValueDef($rsnew, $this->r_to->CurrentValue, NULL, FALSE);

		// reference
		$this->reference->setDbValueDef($rsnew, $this->reference->CurrentValue, 0, strval($this->reference->CurrentValue) == "");

		// message
		$this->message->setDbValueDef($rsnew, $this->message->CurrentValue, NULL, FALSE);

		// uploads
		if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
			$this->uploads->Upload->DbValue = ""; // No need to delete old file
			if ($this->uploads->Upload->FileName == "") {
				$rsnew['uploads'] = NULL;
			} else {
				if ($rsold && $rsold->fields['uploads'] <> "" && $this->uploads->Upload->FileName <> "") {
					$oldFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsold->fields['uploads']);
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->uploads->Upload->FileName);
					$newFileCount = count($newFiles);
					for ($i = 0; $i < $newFileCount; $i++) {
						if ($newFiles[$i] <> "" && in_array($newFiles[$i], $oldFiles)) {
							$tempFile = UniqueFilename($this->uploads->physicalUploadPath(), $newFiles[$i]);
							rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i], UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $tempFile);
							$newFiles[$i] = $tempFile;
						}
					}
					$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				}
				$rsnew['uploads'] = $this->uploads->Upload->FileName;
			}
		}

		// lead_info
		$this->lead_info->setDbValueDef($rsnew, $this->lead_info->CurrentValue, NULL, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, FALSE);

		// Subject
		$this->Subject->setDbValueDef($rsnew, $this->Subject->CurrentValue, "", FALSE);

		// datetime
		$this->datetime->setDbValueDef($rsnew, UnFormatDateTime($this->datetime->CurrentValue, 0), CurrentDate(), FALSE);

		// QueryGenerator
		$this->QueryGenerator->setDbValueDef($rsnew, $this->QueryGenerator->CurrentValue, NULL, FALSE);

		// forward_url
		$this->forward_url->setDbValueDef($rsnew, $this->forward_url->CurrentValue, NULL, FALSE);

		// lead_by
		$this->lead_by->setDbValueDef($rsnew, $this->lead_by->CurrentValue, NULL, FALSE);

		// lead_status
		$this->lead_status->setDbValueDef($rsnew, $this->lead_status->CurrentValue, NULL, FALSE);

		// lead_type
		$this->lead_type->setDbValueDef($rsnew, $this->lead_type->CurrentValue, NULL, FALSE);

		// type
		$this->type->setDbValueDef($rsnew, $this->type->CurrentValue, 0, strval($this->type->CurrentValue) == "");
		if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
			$this->uploads->UploadPath = ".p_uploads/request/";
			$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
			if (!EmptyValue($this->uploads->Upload->FileName)) {
				$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->FileName));
				$NewFileCount = count($newFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					if ($newFiles[$i] <> "") {
						$file = $newFiles[$i];
						if (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file)) {
							if (DELETE_UPLOADED_FILES) {
								$oldFileFound = FALSE;
								$oldFileCount = count($oldFiles);
								for ($j = 0; $j < $oldFileCount; $j++) {
									$oldFile = $oldFiles[$j];
									if ($oldFile == $file) { // Old file found, no need to delete anymore
										unset($oldFiles[$j]);
										$oldFileFound = TRUE;
										break;
									}
								}
								if ($oldFileFound) // No need to check if file exists further
									continue;
							}
							$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1) || file_exists($this->uploads->physicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file, UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1);
								$newFiles[$i] = $file1;
							}
						}
					}
				}
				$this->uploads->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
				$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				$this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
				if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
					$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
					if (!EmptyValue($this->uploads->Upload->FileName)) {
						$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->uploads->Upload->FileName);
						$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['uploads']);
						$newFileCount = count($newFiles);
						for ($i = 0; $i < $newFileCount; $i++) {
							if ($newFiles[$i] <> "") {
								$file = UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i];
								if (file_exists($file)) {
									if (@$newFiles2[$i] <> "") // Use correct file name
										$newFiles[$i] = $newFiles2[$i];
									if (!$this->uploads->Upload->saveToFile($newFiles[$i], TRUE, $i)) { // Just replace
										$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$newFiles = array();
					}
					if (DELETE_UPLOADED_FILES) {
						foreach ($oldFiles as $oldFile) {
							if ($oldFile <> "" && !in_array($oldFile, $newFiles))
								@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
						}
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// uploads
		if ($this->uploads->Upload->FileToken <> "")
			CleanUploadTempPath($this->uploads->Upload->FileToken, $this->uploads->Upload->Index);
		else
			CleanUploadTempPath($this->uploads, $this->uploads->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("request_archivelist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_lead_status":
					$lookupFilter = function() {
						return "`grp`=12";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_lead_type":
					$lookupFilter = function() {
						return "`grp`=11";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_lead_status":
							break;
						case "x_lead_type":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>