<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for required_material_compiled
 */
class required_material_compiled extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $week;
	public $po;
	public $buyer_id;
	public $req_material_sgrp;
	public $req_material_product;
	public $req_material_rid;
	public $req_material_packing;
	public $req_material_qty;
	public $stock;
	public $unit;
	public $company_id;
	public $url;
	public $req_material_grp;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'required_material_compiled';
		$this->TableName = 'required_material_compiled';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`required_material_compiled`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// week
		$this->week = new DbField('required_material_compiled', 'required_material_compiled', 'x_week', 'week', '`week`', '`week`', 201, -1, FALSE, '`week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->week->Required = TRUE; // Required field
		$this->week->Sortable = TRUE; // Allow sort
		$this->week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->week->Lookup = new Lookup('week', 'not_week', FALSE, 'wid', ["week","","",""], [], [], [], [], [], [], '`week` ASC', '');
		$this->week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['week'] = &$this->week;

		// po
		$this->po = new DbField('required_material_compiled', 'required_material_compiled', 'x_po', 'po', '`po`', '`po`', 19, -1, FALSE, '`po`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->po->IsForeignKey = TRUE; // Foreign key field
		$this->po->Sortable = TRUE; // Allow sort
		$this->po->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po'] = &$this->po;

		// buyer_id
		$this->buyer_id = new DbField('required_material_compiled', 'required_material_compiled', 'x_buyer_id', 'buyer_id', '`buyer_id`', '`buyer_id`', 19, -1, FALSE, '`buyer_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->buyer_id->Nullable = FALSE; // NOT NULL field
		$this->buyer_id->Required = TRUE; // Required field
		$this->buyer_id->Sortable = TRUE; // Allow sort
		$this->buyer_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->buyer_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->buyer_id->Lookup = new Lookup('buyer_id', 'buyer_seller_view', FALSE, 'id', ["code","","",""], [], [], [], [], [], [], '`code` ASC', '');
		$this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer_id'] = &$this->buyer_id;

		// req_material_sgrp
		$this->req_material_sgrp = new DbField('required_material_compiled', 'required_material_compiled', 'x_req_material_sgrp', 'req_material_sgrp', '`req_material_sgrp`', '`req_material_sgrp`', 18, -1, FALSE, '`EV__req_material_sgrp`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_sgrp->Sortable = TRUE; // Allow sort
		$this->req_material_sgrp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_sgrp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_sgrp->Lookup = new Lookup('req_material_sgrp', 'product_group', FALSE, 'id', ["product_group","","",""], [], ["x_req_material_product"], [], [], [], [], '`product_group` ASC', '');
		$this->req_material_sgrp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_sgrp'] = &$this->req_material_sgrp;

		// req_material_product
		$this->req_material_product = new DbField('required_material_compiled', 'required_material_compiled', 'x_req_material_product', 'req_material_product', '`req_material_product`', '`req_material_product`', 18, -1, FALSE, '`EV__req_material_product`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_product->Sortable = TRUE; // Allow sort
		$this->req_material_product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_product->Lookup = new Lookup('req_material_product', 'product', FALSE, 'id', ["product","","",""], ["x_req_material_sgrp"], ["x_req_material_rid"], ["s_grp"], ["x_s_grp[]"], [], [], '`product` ASC', '');
		$this->req_material_product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_product'] = &$this->req_material_product;

		// req_material_rid
		$this->req_material_rid = new DbField('required_material_compiled', 'required_material_compiled', 'x_req_material_rid', 'req_material_rid', '`req_material_rid`', '`req_material_rid`', 18, -1, FALSE, '`EV__req_material_rid`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_rid->IsForeignKey = TRUE; // Foreign key field
		$this->req_material_rid->Sortable = TRUE; // Allow sort
		$this->req_material_rid->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_rid->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_rid->Lookup = new Lookup('req_material_rid', 'ref', FALSE, 'id', ["product_code","","",""], ["x_req_material_product"], [], ["product"], ["x_product"], [], [], '`product_code` ASC', '');
		$this->req_material_rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_rid'] = &$this->req_material_rid;

		// req_material_packing
		$this->req_material_packing = new DbField('required_material_compiled', 'required_material_compiled', 'x_req_material_packing', 'req_material_packing', '`req_material_packing`', '`req_material_packing`', 2, -1, FALSE, '`req_material_packing`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_packing->Nullable = FALSE; // NOT NULL field
		$this->req_material_packing->Required = TRUE; // Required field
		$this->req_material_packing->Sortable = TRUE; // Allow sort
		$this->req_material_packing->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_packing->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_packing->Lookup = new Lookup('req_material_packing', 'packing_type', FALSE, 'id', ["packing","","",""], [], [], [], [], [], [], '`packing` ASC', '');
		$this->req_material_packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_packing'] = &$this->req_material_packing;

		// req_material_qty
		$this->req_material_qty = new DbField('required_material_compiled', 'required_material_compiled', 'x_req_material_qty', 'req_material_qty', '`req_material_qty`', '`req_material_qty`', 131, -1, FALSE, '`req_material_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_qty->Sortable = TRUE; // Allow sort
		$this->req_material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['req_material_qty'] = &$this->req_material_qty;

		// stock
		$this->stock = new DbField('required_material_compiled', 'required_material_compiled', 'x_stock', 'stock', '`stock`', '`stock`', 131, -1, FALSE, '`stock`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->stock->Sortable = TRUE; // Allow sort
		$this->stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['stock'] = &$this->stock;

		// unit
		$this->unit = new DbField('required_material_compiled', 'required_material_compiled', 'x_unit', 'unit', '`unit`', '`unit`', 200, -1, FALSE, '`unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->unit->Required = TRUE; // Required field
		$this->unit->Sortable = TRUE; // Allow sort
		$this->unit->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->unit->Lookup = new Lookup('unit', 'unit', FALSE, 'id', ["description","","",""], [], [], [], [], [], [], '`description` ASC', '');
		$this->unit->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unit'] = &$this->unit;

		// company_id
		$this->company_id = new DbField('required_material_compiled', 'required_material_compiled', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 3, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Nullable = FALSE; // NOT NULL field
		$this->company_id->Required = TRUE; // Required field
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'production_partner', TRUE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// url
		$this->url = new DbField('required_material_compiled', 'required_material_compiled', 'x_url', 'url', 'concat(\'material_requiredlist.php?x_po=\', `po`, \'&x_req_material_rid=\', `req_material_rid`)', 'concat(\'material_requiredlist.php?x_po=\', `po`, \'&x_req_material_rid=\', `req_material_rid`)', 200, -1, FALSE, 'concat(\'material_requiredlist.php?x_po=\', `po`, \'&x_req_material_rid=\', `req_material_rid`)', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->IsCustom = TRUE; // Custom field
		$this->url->Sortable = FALSE; // Allow sort
		$this->fields['url'] = &$this->url;

		// req_material_grp
		$this->req_material_grp = new DbField('required_material_compiled', 'required_material_compiled', 'x_req_material_grp', 'req_material_grp', '`req_material_grp`', '`req_material_grp`', 18, -1, FALSE, '`req_material_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_grp->Sortable = FALSE; // Allow sort
		$this->req_material_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_grp'] = &$this->req_material_grp;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "material_required") {
			$detailUrl = $GLOBALS["material_required"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_po=" . urlencode($this->po->CurrentValue);
			$detailUrl .= "&fk_req_material_rid=" . urlencode($this->req_material_rid->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "stock_lcgp") {
			$detailUrl = $GLOBALS["stock_lcgp"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_req_material_rid=" . urlencode($this->req_material_rid->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "required_material_compiledlist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`required_material_compiled`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, concat('material_requiredlist.php?x_po=', `po`, '&x_req_material_rid=', `req_material_rid`) AS `url` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, concat('material_requiredlist.php?x_po=', `po`, '&x_req_material_rid=', `req_material_rid`) AS `url`, (SELECT `product_group` FROM `product_group` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `required_material_compiled`.`req_material_sgrp` LIMIT 1) AS `EV__req_material_sgrp`, (SELECT `product` FROM `product` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `required_material_compiled`.`req_material_product` LIMIT 1) AS `EV__req_material_product`, (SELECT `product_code` FROM `ref` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `required_material_compiled`.`req_material_rid` LIMIT 1) AS `EV__req_material_rid` FROM `required_material_compiled`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->req_material_sgrp->AdvancedSearch->SearchValue <> "" ||
			$this->req_material_sgrp->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->req_material_sgrp->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->req_material_sgrp->VirtualExpression . " "))
			return TRUE;
		if ($this->req_material_product->AdvancedSearch->SearchValue <> "" ||
			$this->req_material_product->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->req_material_product->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->req_material_product->VirtualExpression . " "))
			return TRUE;
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->req_material_rid->AdvancedSearch->SearchValue <> "" ||
			$this->req_material_rid->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->req_material_rid->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->req_material_rid->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();

		// Cascade Update detail table 'material_required'
		$cascadeUpdate = FALSE;
		$rscascade = array();
		if ($rsold && (isset($rs['po']) && $rsold['po'] <> $rs['po'])) { // Update detail field 'po'
			$cascadeUpdate = TRUE;
			$rscascade['po'] = $rs['po']; 
		}
		if ($rsold && (isset($rs['req_material_rid']) && $rsold['req_material_rid'] <> $rs['req_material_rid'])) { // Update detail field 'req_material_rid'
			$cascadeUpdate = TRUE;
			$rscascade['req_material_rid'] = $rs['req_material_rid']; 
		}
		if ($cascadeUpdate) {
			if (!isset($GLOBALS["material_required"]))
				$GLOBALS["material_required"] = new material_required();
			$rswrk = $GLOBALS["material_required"]->loadRs("`po` = " . QuotedValue($rsold['po'], DATATYPE_NUMBER, 'DB') . " AND " . "`req_material_rid` = " . QuotedValue($rsold['req_material_rid'], DATATYPE_NUMBER, 'DB')); 
			while ($rswrk && !$rswrk->EOF) {
				$rskey = array();
				$fldname = 'id';
				$rskey[$fldname] = $rswrk->fields[$fldname];
				$rsdtlold = &$rswrk->fields;
				$rsdtlnew = array_merge($rsdtlold, $rscascade);

				// Call Row_Updating event
				$success = $GLOBALS["material_required"]->Row_Updating($rsdtlold, $rsdtlnew);
				if ($success)
					$success = $GLOBALS["material_required"]->update($rscascade, $rskey, $rswrk->fields);
				if (!$success)
					return FALSE;

				// Call Row_Updated event
				$GLOBALS["material_required"]->Row_Updated($rsdtlold, $rsdtlnew);
				$rswrk->moveNext();
			}
		}
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();

		// Cascade delete detail table 'material_required'
		if (!isset($GLOBALS["material_required"]))
			$GLOBALS["material_required"] = new material_required();
		$rscascade = $GLOBALS["material_required"]->loadRs("`po` = " . QuotedValue($rs['po'], DATATYPE_NUMBER, "DB") . " AND " . "`req_material_rid` = " . QuotedValue($rs['req_material_rid'], DATATYPE_NUMBER, "DB")); 
		$dtlrows = ($rscascade) ? $rscascade->getRows() : array();

		// Call Row Deleting event
		foreach ($dtlrows as $dtlrow) {
			$success = $GLOBALS["material_required"]->Row_Deleting($dtlrow);
			if (!$success)
				break;
		}
		if ($success) {
			foreach ($dtlrows as $dtlrow) {
				$success = $GLOBALS["material_required"]->delete($dtlrow); // Delete
				if (!$success)
					break;
			}
		}

		// Call Row Deleted event
		if ($success) {
			foreach ($dtlrows as $dtlrow)
				$GLOBALS["material_required"]->Row_Deleted($dtlrow);
		}
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->week->DbValue = $row['week'];
		$this->po->DbValue = $row['po'];
		$this->buyer_id->DbValue = $row['buyer_id'];
		$this->req_material_sgrp->DbValue = $row['req_material_sgrp'];
		$this->req_material_product->DbValue = $row['req_material_product'];
		$this->req_material_rid->DbValue = $row['req_material_rid'];
		$this->req_material_packing->DbValue = $row['req_material_packing'];
		$this->req_material_qty->DbValue = $row['req_material_qty'];
		$this->stock->DbValue = $row['stock'];
		$this->unit->DbValue = $row['unit'];
		$this->company_id->DbValue = $row['company_id'];
		$this->url->DbValue = $row['url'];
		$this->req_material_grp->DbValue = $row['req_material_grp'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "required_material_compiledlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "required_material_compiledview.php")
			return $Language->phrase("View");
		elseif ($pageName == "required_material_compilededit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "required_material_compiledadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "required_material_compiledlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("required_material_compiledview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("required_material_compiledview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "required_material_compiledadd.php?" . $this->getUrlParm($parm);
		else
			$url = "required_material_compiledadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("required_material_compilededit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("required_material_compiledadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("required_material_compileddelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->week->setDbValue($rs->fields('week'));
		$this->po->setDbValue($rs->fields('po'));
		$this->buyer_id->setDbValue($rs->fields('buyer_id'));
		$this->req_material_sgrp->setDbValue($rs->fields('req_material_sgrp'));
		$this->req_material_product->setDbValue($rs->fields('req_material_product'));
		$this->req_material_rid->setDbValue($rs->fields('req_material_rid'));
		$this->req_material_packing->setDbValue($rs->fields('req_material_packing'));
		$this->req_material_qty->setDbValue($rs->fields('req_material_qty'));
		$this->stock->setDbValue($rs->fields('stock'));
		$this->unit->setDbValue($rs->fields('unit'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->url->setDbValue($rs->fields('url'));
		$this->req_material_grp->setDbValue($rs->fields('req_material_grp'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// week
		// po
		// buyer_id
		// req_material_sgrp
		// req_material_product
		// req_material_rid
		// req_material_packing
		// req_material_qty
		// stock
		// unit
		// company_id
		// url

		$this->url->CellCssStyle = "white-space: nowrap;";

		// req_material_grp
		$this->req_material_grp->CellCssStyle = "white-space: nowrap;";

		// week
		$curVal = strval($this->week->CurrentValue);
		if ($curVal <> "") {
			$this->week->ViewValue = $this->week->lookupCacheOption($curVal);
			if ($this->week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`wid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->week->ViewValue = $this->week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->week->ViewValue = $this->week->CurrentValue;
				}
			}
		} else {
			$this->week->ViewValue = NULL;
		}
		$this->week->ViewCustomAttributes = "";

		// po
		$this->po->ViewValue = $this->po->CurrentValue;
		$this->po->ViewCustomAttributes = "";

		// buyer_id
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->ViewValue = NULL;
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// req_material_sgrp
		if ($this->req_material_sgrp->VirtualValue <> "") {
			$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->VirtualValue;
		} else {
		$curVal = strval($this->req_material_sgrp->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
			if ($this->req_material_sgrp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_sgrp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
				}
			}
		} else {
			$this->req_material_sgrp->ViewValue = NULL;
		}
		}
		$this->req_material_sgrp->ViewCustomAttributes = "";

		// req_material_product
		if ($this->req_material_product->VirtualValue <> "") {
			$this->req_material_product->ViewValue = $this->req_material_product->VirtualValue;
		} else {
		$curVal = strval($this->req_material_product->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
			if ($this->req_material_product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
				}
			}
		} else {
			$this->req_material_product->ViewValue = NULL;
		}
		}
		$this->req_material_product->ViewCustomAttributes = "";

		// req_material_rid
		if ($this->req_material_rid->VirtualValue <> "") {
			$this->req_material_rid->ViewValue = $this->req_material_rid->VirtualValue;
		} else {
		$curVal = strval($this->req_material_rid->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
			if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
				}
			}
		} else {
			$this->req_material_rid->ViewValue = NULL;
		}
		}
		$this->req_material_rid->ViewCustomAttributes = "";

		// req_material_packing
		$curVal = strval($this->req_material_packing->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			if ($this->req_material_packing->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
				}
			}
		} else {
			$this->req_material_packing->ViewValue = NULL;
		}
		$this->req_material_packing->ViewCustomAttributes = "";

		// req_material_qty
		$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 3, -2, -2, -2);
		$this->req_material_qty->ViewCustomAttributes = "";

		// stock
		$this->stock->ViewValue = $this->stock->CurrentValue;
		$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
		$this->stock->ViewCustomAttributes = "";

		// unit
		$curVal = strval($this->unit->CurrentValue);
		if ($curVal <> "") {
			$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
			if ($this->unit->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->unit->ViewValue = $this->unit->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->unit->ViewValue = $this->unit->CurrentValue;
				}
			}
		} else {
			$this->unit->ViewValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category`=1 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// req_material_grp
		$this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
		$this->req_material_grp->ViewValue = FormatNumber($this->req_material_grp->ViewValue, 0, -2, -2, -2);
		$this->req_material_grp->ViewCustomAttributes = "";

		// week
		$this->week->LinkCustomAttributes = "";
		$this->week->HrefValue = "";
		$this->week->TooltipValue = "";

		// po
		$this->po->LinkCustomAttributes = "";
		if (!EmptyValue($this->po->CurrentValue)) {
			$this->po->HrefValue = "required_material_compiledlist.php?x_po=" . $this->po->CurrentValue; // Add prefix/suffix
			$this->po->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->po->HrefValue = FullUrl($this->po->HrefValue, "href");
		} else {
			$this->po->HrefValue = "";
		}
		$this->po->TooltipValue = "";

		// buyer_id
		$this->buyer_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->buyer_id->CurrentValue)) {
			$this->buyer_id->HrefValue = "required_material_compiledlist.php?x_buyer_id=" . $this->buyer_id->CurrentValue; // Add prefix/suffix
			$this->buyer_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->buyer_id->HrefValue = FullUrl($this->buyer_id->HrefValue, "href");
		} else {
			$this->buyer_id->HrefValue = "";
		}
		$this->buyer_id->TooltipValue = "";

		// req_material_sgrp
		$this->req_material_sgrp->LinkCustomAttributes = "";
		if (!EmptyValue($this->req_material_sgrp->CurrentValue)) {
			$this->req_material_sgrp->HrefValue = "required_material_compiledlist.php?x_required_material_sgrp=" . $this->req_material_sgrp->CurrentValue; // Add prefix/suffix
			$this->req_material_sgrp->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->req_material_sgrp->HrefValue = FullUrl($this->req_material_sgrp->HrefValue, "href");
		} else {
			$this->req_material_sgrp->HrefValue = "";
		}
		$this->req_material_sgrp->TooltipValue = "";

		// req_material_product
		$this->req_material_product->LinkCustomAttributes = "";
		if (!EmptyValue($this->req_material_product->CurrentValue)) {
			$this->req_material_product->HrefValue = "required_material_compiledlist.php?x_required_material_product=" . $this->req_material_product->CurrentValue; // Add prefix/suffix
			$this->req_material_product->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->req_material_product->HrefValue = FullUrl($this->req_material_product->HrefValue, "href");
		} else {
			$this->req_material_product->HrefValue = "";
		}
		$this->req_material_product->TooltipValue = "";

		// req_material_rid
		$this->req_material_rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->url->CurrentValue)) {
			$this->req_material_rid->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
			$this->req_material_rid->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->req_material_rid->HrefValue = FullUrl($this->req_material_rid->HrefValue, "href");
		} else {
			$this->req_material_rid->HrefValue = "";
		}
		$this->req_material_rid->TooltipValue = "";

		// req_material_packing
		$this->req_material_packing->LinkCustomAttributes = "";
		$this->req_material_packing->HrefValue = "";
		$this->req_material_packing->TooltipValue = "";

		// req_material_qty
		$this->req_material_qty->LinkCustomAttributes = "";
		$this->req_material_qty->HrefValue = "";
		$this->req_material_qty->TooltipValue = "";

		// stock
		$this->stock->LinkCustomAttributes = "";
		$this->stock->HrefValue = "";
		$this->stock->TooltipValue = "";

		// unit
		$this->unit->LinkCustomAttributes = "";
		if (!EmptyValue($this->unit->CurrentValue)) {
			$this->unit->HrefValue = "required_material_compiledlist.php?x_unit=" . $this->unit->CurrentValue; // Add prefix/suffix
			$this->unit->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->unit->HrefValue = FullUrl($this->unit->HrefValue, "href");
		} else {
			$this->unit->HrefValue = "";
		}
		$this->unit->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// req_material_grp
		$this->req_material_grp->LinkCustomAttributes = "";
		$this->req_material_grp->HrefValue = "";
		$this->req_material_grp->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// week
		$this->week->EditAttrs["class"] = "form-control";
		$this->week->EditCustomAttributes = 'ReadOnly';
		$curVal = strval($this->week->CurrentValue);
		if ($curVal <> "") {
			$this->week->EditValue = $this->week->lookupCacheOption($curVal);
			if ($this->week->EditValue === NULL) { // Lookup from database
				$filterWrk = "`wid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->week->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->week->EditValue = $this->week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->week->EditValue = $this->week->CurrentValue;
				}
			}
		} else {
			$this->week->EditValue = NULL;
		}
		$this->week->ViewCustomAttributes = "";

		// po
		$this->po->EditAttrs["class"] = "form-control";
		$this->po->EditCustomAttributes = "";
		$this->po->EditValue = $this->po->CurrentValue;
		$this->po->ViewCustomAttributes = "";

		// buyer_id
		$this->buyer_id->EditAttrs["class"] = "form-control";
		$this->buyer_id->EditCustomAttributes = "";
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->EditValue = NULL;
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// req_material_sgrp
		$this->req_material_sgrp->EditAttrs["class"] = "form-control";
		$this->req_material_sgrp->EditCustomAttributes = "";
		if ($this->req_material_sgrp->VirtualValue <> "") {
			$this->req_material_sgrp->EditValue = $this->req_material_sgrp->VirtualValue;
		} else {
		$curVal = strval($this->req_material_sgrp->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_sgrp->EditValue = $this->req_material_sgrp->lookupCacheOption($curVal);
			if ($this->req_material_sgrp->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_sgrp->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_sgrp->EditValue = $this->req_material_sgrp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_sgrp->EditValue = $this->req_material_sgrp->CurrentValue;
				}
			}
		} else {
			$this->req_material_sgrp->EditValue = NULL;
		}
		}
		$this->req_material_sgrp->ViewCustomAttributes = "";

		// req_material_product
		$this->req_material_product->EditAttrs["class"] = "form-control";
		$this->req_material_product->EditCustomAttributes = "";
		if ($this->req_material_product->VirtualValue <> "") {
			$this->req_material_product->EditValue = $this->req_material_product->VirtualValue;
		} else {
		$curVal = strval($this->req_material_product->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_product->EditValue = $this->req_material_product->lookupCacheOption($curVal);
			if ($this->req_material_product->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_product->EditValue = $this->req_material_product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_product->EditValue = $this->req_material_product->CurrentValue;
				}
			}
		} else {
			$this->req_material_product->EditValue = NULL;
		}
		}
		$this->req_material_product->ViewCustomAttributes = "";

		// req_material_rid
		$this->req_material_rid->EditAttrs["class"] = "form-control";
		$this->req_material_rid->EditCustomAttributes = "";
		if ($this->req_material_rid->VirtualValue <> "") {
			$this->req_material_rid->EditValue = $this->req_material_rid->VirtualValue;
		} else {
		$curVal = strval($this->req_material_rid->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
			if ($this->req_material_rid->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
				}
			}
		} else {
			$this->req_material_rid->EditValue = NULL;
		}
		}
		$this->req_material_rid->ViewCustomAttributes = "";

		// req_material_packing
		$this->req_material_packing->EditAttrs["class"] = "form-control";
		$this->req_material_packing->EditCustomAttributes = "";

		// req_material_qty
		$this->req_material_qty->EditAttrs["class"] = "form-control";
		$this->req_material_qty->EditCustomAttributes = "";
		$this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, 3, -2, -2, -2);
		$this->req_material_qty->ViewCustomAttributes = "";

		// stock
		$this->stock->EditAttrs["class"] = "form-control";
		$this->stock->EditCustomAttributes = "";
		$this->stock->EditValue = $this->stock->CurrentValue;
		$this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
		if (strval($this->stock->EditValue) <> "" && is_numeric($this->stock->EditValue))
			$this->stock->EditValue = FormatNumber($this->stock->EditValue, -2, -2, -2, -2);

		// unit
		$this->unit->EditAttrs["class"] = "form-control";
		$this->unit->EditCustomAttributes = "";
		$curVal = strval($this->unit->CurrentValue);
		if ($curVal <> "") {
			$this->unit->EditValue = $this->unit->lookupCacheOption($curVal);
			if ($this->unit->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->unit->EditValue = $this->unit->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->unit->EditValue = $this->unit->CurrentValue;
				}
			}
		} else {
			$this->unit->EditValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// req_material_grp
		$this->req_material_grp->EditAttrs["class"] = "form-control";
		$this->req_material_grp->EditCustomAttributes = "";
		$this->req_material_grp->EditValue = $this->req_material_grp->CurrentValue;
		$this->req_material_grp->PlaceHolder = RemoveHtml($this->req_material_grp->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->req_material_qty->CurrentValue))
				$this->req_material_qty->Total += $this->req_material_qty->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->req_material_qty->CurrentValue = $this->req_material_qty->Total;
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 3, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";
			$this->req_material_qty->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->week);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->req_material_sgrp);
					$doc->exportCaption($this->req_material_product);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->req_material_packing);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->stock);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->company_id);
				} else {
					$doc->exportCaption($this->week);
					$doc->exportCaption($this->po);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->req_material_sgrp);
					$doc->exportCaption($this->req_material_product);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->req_material_packing);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->stock);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->company_id);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->week);
						$doc->exportField($this->po);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->req_material_sgrp);
						$doc->exportField($this->req_material_product);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->req_material_packing);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->stock);
						$doc->exportField($this->unit);
						$doc->exportField($this->company_id);
					} else {
						$doc->exportField($this->week);
						$doc->exportField($this->po);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->req_material_sgrp);
						$doc->exportField($this->req_material_product);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->req_material_packing);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->stock);
						$doc->exportField($this->unit);
						$doc->exportField($this->company_id);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->week, '');
				$doc->exportAggregate($this->po, '');
				$doc->exportAggregate($this->buyer_id, '');
				$doc->exportAggregate($this->req_material_sgrp, '');
				$doc->exportAggregate($this->req_material_product, '');
				$doc->exportAggregate($this->req_material_rid, '');
				$doc->exportAggregate($this->req_material_packing, '');
				$doc->exportAggregate($this->req_material_qty, 'TOTAL');
				$doc->exportAggregate($this->stock, '');
				$doc->exportAggregate($this->unit, '');
				$doc->exportAggregate($this->company_id, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>