<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for required_material_overall_table
 */
class required_material_overall_table extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $pending;
	public $req_material_grp;
	public $req_material_sgrp;
	public $req_material_product;
	public $req_material_rid;
	public $req_material_packing;
	public $batch_no;
	public $unit;
	public $mil;
	public $req_material_qty;
	public $po_s_pending;
	public $po_pending_wbc;
	public $not_loomcard;
	public $stock;
	public $company_id;
	public $last_supplier_id;
	public $internal_external;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'required_material_overall_table';
		$this->TableName = 'required_material_overall_table';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`required_material_overall_table`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_id', 'id', '`id`', '`id`', 3, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->fields['id'] = &$this->id;

		// pending
		$this->pending = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_pending', 'pending', '`pending`', '`pending`', 131, -1, FALSE, '`pending`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pending->Sortable = TRUE; // Allow sort
		$this->pending->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->pending->AdvancedSearch->SearchValueDefault = ">=1";
		$this->pending->AdvancedSearch->SearchOperatorDefault = "=";
		$this->pending->AdvancedSearch->SearchOperatorDefault2 = "";
		$this->pending->AdvancedSearch->SearchConditionDefault = "AND";
		$this->fields['pending'] = &$this->pending;

		// req_material_grp
		$this->req_material_grp = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_req_material_grp', 'req_material_grp', '`req_material_grp`', '`req_material_grp`', 18, -1, FALSE, '`req_material_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_grp->Sortable = FALSE; // Allow sort
		$this->req_material_grp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_grp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_grp->Lookup = new Lookup('req_material_grp', 'grp', FALSE, 'id', ["grp","","",""], [], [], [], [], [], [], '`grp` ASC', '');
		$this->req_material_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_grp'] = &$this->req_material_grp;

		// req_material_sgrp
		$this->req_material_sgrp = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_req_material_sgrp', 'req_material_sgrp', '`req_material_sgrp`', '`req_material_sgrp`', 18, -1, FALSE, '`req_material_sgrp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_sgrp->Nullable = FALSE; // NOT NULL field
		$this->req_material_sgrp->Required = TRUE; // Required field
		$this->req_material_sgrp->Sortable = FALSE; // Allow sort
		$this->req_material_sgrp->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_sgrp->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_sgrp->Lookup = new Lookup('req_material_sgrp', 'product_group', FALSE, 'id', ["product_group","","",""], [], [], [], [], [], [], '`product_group` ASC', '');
		$this->req_material_sgrp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_sgrp'] = &$this->req_material_sgrp;

		// req_material_product
		$this->req_material_product = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_req_material_product', 'req_material_product', '`req_material_product`', '`req_material_product`', 18, -1, FALSE, '`req_material_product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_product->Sortable = TRUE; // Allow sort
		$this->req_material_product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_product->Lookup = new Lookup('req_material_product', 'product', FALSE, 'id', ["product","","",""], [], [], [], [], [], [], '`product` ASC', '');
		$this->req_material_product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_product'] = &$this->req_material_product;

		// req_material_rid
		$this->req_material_rid = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_req_material_rid', 'req_material_rid', '`req_material_rid`', '`req_material_rid`', 18, -1, FALSE, '`req_material_rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_rid->Sortable = TRUE; // Allow sort
		$this->req_material_rid->Lookup = new Lookup('req_material_rid', 'ref', FALSE, 'id', ["product_code","","",""], [], [], [], [], [], [], '`product_code` ASC', '');
		$this->req_material_rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_rid'] = &$this->req_material_rid;

		// req_material_packing
		$this->req_material_packing = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_req_material_packing', 'req_material_packing', '`req_material_packing`', '`req_material_packing`', 2, -1, FALSE, '`req_material_packing`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->req_material_packing->Required = TRUE; // Required field
		$this->req_material_packing->Sortable = TRUE; // Allow sort
		$this->req_material_packing->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->req_material_packing->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->req_material_packing->Lookup = new Lookup('req_material_packing', 'packing_type', FALSE, 'id', ["code","packing","",""], [], [], [], [], [], [], '`code` ASC', '');
		$this->req_material_packing->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_material_packing'] = &$this->req_material_packing;

		// batch_no
		$this->batch_no = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_batch_no', 'batch_no', '`batch_no`', '`batch_no`', 2, -1, FALSE, '`batch_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->batch_no->Sortable = TRUE; // Allow sort
		$this->batch_no->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->batch_no->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->batch_no->Lookup = new Lookup('batch_no', 'batch_no', FALSE, 'id', ["batch_no","","",""], [], [], [], [], [], [], '`batch_no` ASC', '');
		$this->fields['batch_no'] = &$this->batch_no;

		// unit
		$this->unit = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_unit', 'unit', '`unit`', '`unit`', 201, -1, FALSE, '`unit`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->unit->Sortable = TRUE; // Allow sort
		$this->unit->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->unit->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->unit->Lookup = new Lookup('unit', 'unit', FALSE, 'id', ["sign","description","",""], [], [], [], [], [], [], '`sign` ASC', '');
		$this->fields['unit'] = &$this->unit;

		// mil
		$this->mil = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_mil', 'mil', '`mil`', '`mil`', 131, -1, FALSE, '`mil`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->mil->Required = TRUE; // Required field
		$this->mil->Sortable = TRUE; // Allow sort
		$this->mil->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['mil'] = &$this->mil;

		// req_material_qty
		$this->req_material_qty = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_req_material_qty', 'req_material_qty', '`req_material_qty`', '`req_material_qty`', 131, -1, FALSE, '`req_material_qty`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_material_qty->Sortable = TRUE; // Allow sort
		$this->req_material_qty->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['req_material_qty'] = &$this->req_material_qty;

		// po_s_pending
		$this->po_s_pending = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_po_s_pending', 'po_s_pending', '`po_s_pending`', '`po_s_pending`', 131, -1, FALSE, '`po_s_pending`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_s_pending->Required = TRUE; // Required field
		$this->po_s_pending->Sortable = TRUE; // Allow sort
		$this->po_s_pending->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['po_s_pending'] = &$this->po_s_pending;

		// po_pending_wbc
		$this->po_pending_wbc = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_po_pending_wbc', 'po_pending_wbc', '`po_pending_wbc`', '`po_pending_wbc`', 131, -1, FALSE, '`po_pending_wbc`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_pending_wbc->Sortable = TRUE; // Allow sort
		$this->po_pending_wbc->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['po_pending_wbc'] = &$this->po_pending_wbc;

		// not_loomcard
		$this->not_loomcard = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_not_loomcard', 'not_loomcard', '`not_loomcard`', '`not_loomcard`', 131, -1, FALSE, '`not_loomcard`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->not_loomcard->Required = TRUE; // Required field
		$this->not_loomcard->Sortable = TRUE; // Allow sort
		$this->not_loomcard->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['not_loomcard'] = &$this->not_loomcard;

		// stock
		$this->stock = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_stock', 'stock', '`stock`', '`stock`', 131, -1, FALSE, '`stock`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->stock->Sortable = TRUE; // Allow sort
		$this->stock->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['stock'] = &$this->stock;

		// company_id
		$this->company_id = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 3, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Nullable = FALSE; // NOT NULL field
		$this->company_id->Required = TRUE; // Required field
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['company_id'] = &$this->company_id;

		// last_supplier_id
		$this->last_supplier_id = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_last_supplier_id', 'last_supplier_id', '`last_supplier_id`', '`last_supplier_id`', 3, -1, FALSE, '`last_supplier_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->last_supplier_id->Nullable = FALSE; // NOT NULL field
		$this->last_supplier_id->Required = TRUE; // Required field
		$this->last_supplier_id->Sortable = TRUE; // Allow sort
		$this->last_supplier_id->Lookup = new Lookup('last_supplier_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['last_supplier_id'] = &$this->last_supplier_id;

		// internal_external
		$this->internal_external = new DbField('required_material_overall_table', 'required_material_overall_table', 'x_internal_external', 'internal_external', '`internal_external`', '`internal_external`', 17, -1, FALSE, '`internal_external`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->internal_external->Sortable = TRUE; // Allow sort
		$this->internal_external->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->internal_external->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->internal_external->Lookup = new Lookup('internal_external', 'required_material_overall_table', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->internal_external->OptionCount = 3;
		$this->internal_external->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['internal_external'] = &$this->internal_external;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`required_material_overall_table`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`pending` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->pending->DbValue = $row['pending'];
		$this->req_material_grp->DbValue = $row['req_material_grp'];
		$this->req_material_sgrp->DbValue = $row['req_material_sgrp'];
		$this->req_material_product->DbValue = $row['req_material_product'];
		$this->req_material_rid->DbValue = $row['req_material_rid'];
		$this->req_material_packing->DbValue = $row['req_material_packing'];
		$this->batch_no->DbValue = $row['batch_no'];
		$this->unit->DbValue = $row['unit'];
		$this->mil->DbValue = $row['mil'];
		$this->req_material_qty->DbValue = $row['req_material_qty'];
		$this->po_s_pending->DbValue = $row['po_s_pending'];
		$this->po_pending_wbc->DbValue = $row['po_pending_wbc'];
		$this->not_loomcard->DbValue = $row['not_loomcard'];
		$this->stock->DbValue = $row['stock'];
		$this->company_id->DbValue = $row['company_id'];
		$this->last_supplier_id->DbValue = $row['last_supplier_id'];
		$this->internal_external->DbValue = $row['internal_external'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "required_material_overall_tablelist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "required_material_overall_tableview.php")
			return $Language->phrase("View");
		elseif ($pageName == "required_material_overall_tableedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "required_material_overall_tableadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "required_material_overall_tablelist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("required_material_overall_tableview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("required_material_overall_tableview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "required_material_overall_tableadd.php?" . $this->getUrlParm($parm);
		else
			$url = "required_material_overall_tableadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("required_material_overall_tableedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("required_material_overall_tableadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("required_material_overall_tabledelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->pending->setDbValue($rs->fields('pending'));
		$this->req_material_grp->setDbValue($rs->fields('req_material_grp'));
		$this->req_material_sgrp->setDbValue($rs->fields('req_material_sgrp'));
		$this->req_material_product->setDbValue($rs->fields('req_material_product'));
		$this->req_material_rid->setDbValue($rs->fields('req_material_rid'));
		$this->req_material_packing->setDbValue($rs->fields('req_material_packing'));
		$this->batch_no->setDbValue($rs->fields('batch_no'));
		$this->unit->setDbValue($rs->fields('unit'));
		$this->mil->setDbValue($rs->fields('mil'));
		$this->req_material_qty->setDbValue($rs->fields('req_material_qty'));
		$this->po_s_pending->setDbValue($rs->fields('po_s_pending'));
		$this->po_pending_wbc->setDbValue($rs->fields('po_pending_wbc'));
		$this->not_loomcard->setDbValue($rs->fields('not_loomcard'));
		$this->stock->setDbValue($rs->fields('stock'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->last_supplier_id->setDbValue($rs->fields('last_supplier_id'));
		$this->internal_external->setDbValue($rs->fields('internal_external'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// pending
		// req_material_grp

		$this->req_material_grp->CellCssStyle = "white-space: nowrap;";

		// req_material_sgrp
		$this->req_material_sgrp->CellCssStyle = "white-space: nowrap;";

		// req_material_product
		// req_material_rid
		// req_material_packing
		// batch_no
		// unit
		// mil
		// req_material_qty
		// po_s_pending
		// po_pending_wbc
		// not_loomcard
		// stock
		// company_id
		// last_supplier_id
		// internal_external
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// pending
		$this->pending->ViewValue = $this->pending->CurrentValue;
		$this->pending->ViewValue = FormatNumber($this->pending->ViewValue, 2, -2, -2, -2);
		$this->pending->ViewCustomAttributes = "";

		// req_material_grp
		$curVal = strval($this->req_material_grp->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_grp->ViewValue = $this->req_material_grp->lookupCacheOption($curVal);
			if ($this->req_material_grp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_grp->ViewValue = $this->req_material_grp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
				}
			}
		} else {
			$this->req_material_grp->ViewValue = NULL;
		}
		$this->req_material_grp->ViewCustomAttributes = "";

		// req_material_sgrp
		$curVal = strval($this->req_material_sgrp->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->lookupCacheOption($curVal);
			if ($this->req_material_sgrp->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_sgrp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_sgrp->ViewValue = $this->req_material_sgrp->CurrentValue;
				}
			}
		} else {
			$this->req_material_sgrp->ViewValue = NULL;
		}
		$this->req_material_sgrp->ViewCustomAttributes = "";

		// req_material_product
		$curVal = strval($this->req_material_product->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
			if ($this->req_material_product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
				}
			}
		} else {
			$this->req_material_product->ViewValue = NULL;
		}
		$this->req_material_product->ViewCustomAttributes = "";

		// req_material_rid
		$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
		$curVal = strval($this->req_material_rid->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
			if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
				}
			}
		} else {
			$this->req_material_rid->ViewValue = NULL;
		}
		$this->req_material_rid->ViewCustomAttributes = "";

		// req_material_packing
		$curVal = strval($this->req_material_packing->CurrentValue);
		if ($curVal <> "") {
			$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			if ($this->req_material_packing->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
				}
			}
		} else {
			$this->req_material_packing->ViewValue = NULL;
		}
		$this->req_material_packing->ViewCustomAttributes = "";

		// batch_no
		$curVal = strval($this->batch_no->CurrentValue);
		if ($curVal <> "") {
			$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			if ($this->batch_no->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
				}
			}
		} else {
			$this->batch_no->ViewValue = NULL;
		}
		$this->batch_no->ViewCustomAttributes = "";

		// unit
		$curVal = strval($this->unit->CurrentValue);
		if ($curVal <> "") {
			$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
			if ($this->unit->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->unit->ViewValue = $this->unit->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->unit->ViewValue = $this->unit->CurrentValue;
				}
			}
		} else {
			$this->unit->ViewValue = NULL;
		}
		$this->unit->ViewCustomAttributes = "";

		// mil
		$this->mil->ViewValue = $this->mil->CurrentValue;
		$this->mil->ViewValue = FormatNumber($this->mil->ViewValue, 2, -2, -2, -2);
		$this->mil->ViewCustomAttributes = "";

		// req_material_qty
		$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
		$this->req_material_qty->ViewCustomAttributes = "";

		// po_s_pending
		$this->po_s_pending->ViewValue = $this->po_s_pending->CurrentValue;
		$this->po_s_pending->ViewValue = FormatNumber($this->po_s_pending->ViewValue, 2, -2, -2, -2);
		$this->po_s_pending->ViewCustomAttributes = "";

		// po_pending_wbc
		$this->po_pending_wbc->ViewValue = $this->po_pending_wbc->CurrentValue;
		$this->po_pending_wbc->ViewValue = FormatNumber($this->po_pending_wbc->ViewValue, 2, -2, -2, -2);
		$this->po_pending_wbc->ViewCustomAttributes = "";

		// not_loomcard
		$this->not_loomcard->ViewValue = $this->not_loomcard->CurrentValue;
		$this->not_loomcard->ViewValue = FormatNumber($this->not_loomcard->ViewValue, 2, -2, -2, -2);
		$this->not_loomcard->ViewCustomAttributes = "";

		// stock
		$this->stock->ViewValue = $this->stock->CurrentValue;
		$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
		$this->stock->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// last_supplier_id
		$this->last_supplier_id->ViewValue = $this->last_supplier_id->CurrentValue;
		$curVal = strval($this->last_supplier_id->CurrentValue);
		if ($curVal <> "") {
			$this->last_supplier_id->ViewValue = $this->last_supplier_id->lookupCacheOption($curVal);
			if ($this->last_supplier_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`partner_type`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->last_supplier_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->last_supplier_id->ViewValue = $this->last_supplier_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->last_supplier_id->ViewValue = $this->last_supplier_id->CurrentValue;
				}
			}
		} else {
			$this->last_supplier_id->ViewValue = NULL;
		}
		$this->last_supplier_id->ViewCustomAttributes = "";

		// internal_external
		if (strval($this->internal_external->CurrentValue) <> "") {
			$this->internal_external->ViewValue = $this->internal_external->optionCaption($this->internal_external->CurrentValue);
		} else {
			$this->internal_external->ViewValue = NULL;
		}
		$this->internal_external->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// pending
		$this->pending->LinkCustomAttributes = "";
		$this->pending->HrefValue = "";
		$this->pending->TooltipValue = "";

		// req_material_grp
		$this->req_material_grp->LinkCustomAttributes = "";
		$this->req_material_grp->HrefValue = "";
		$this->req_material_grp->TooltipValue = "";

		// req_material_sgrp
		$this->req_material_sgrp->LinkCustomAttributes = "";
		$this->req_material_sgrp->HrefValue = "";
		$this->req_material_sgrp->TooltipValue = "";

		// req_material_product
		$this->req_material_product->LinkCustomAttributes = "";
		$this->req_material_product->HrefValue = "";
		$this->req_material_product->TooltipValue = "";

		// req_material_rid
		$this->req_material_rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->req_material_rid->CurrentValue)) {
			$this->req_material_rid->HrefValue = "required_material_overall_tablelist.php?x_req_material_rid=" . $this->req_material_rid->CurrentValue; // Add prefix/suffix
			$this->req_material_rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->req_material_rid->HrefValue = FullUrl($this->req_material_rid->HrefValue, "href");
		} else {
			$this->req_material_rid->HrefValue = "";
		}
		$this->req_material_rid->TooltipValue = "";

		// req_material_packing
		$this->req_material_packing->LinkCustomAttributes = "";
		if (!EmptyValue($this->req_material_packing->CurrentValue)) {
			$this->req_material_packing->HrefValue = "required_material_overall_tablelist.php?x_req_material_rid=" . $this->req_material_packing->CurrentValue; // Add prefix/suffix
			$this->req_material_packing->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->req_material_packing->HrefValue = FullUrl($this->req_material_packing->HrefValue, "href");
		} else {
			$this->req_material_packing->HrefValue = "";
		}
		$this->req_material_packing->TooltipValue = "";

		// batch_no
		$this->batch_no->LinkCustomAttributes = "";
		if (!EmptyValue($this->batch_no->CurrentValue)) {
			$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
			$this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
		} else {
			$this->batch_no->HrefValue = "";
		}
		$this->batch_no->TooltipValue = "";

		// unit
		$this->unit->LinkCustomAttributes = "";
		$this->unit->HrefValue = "";
		$this->unit->TooltipValue = "";

		// mil
		$this->mil->LinkCustomAttributes = "";
		$this->mil->HrefValue = "";
		$this->mil->TooltipValue = "";

		// req_material_qty
		$this->req_material_qty->LinkCustomAttributes = "";
		$this->req_material_qty->HrefValue = "";
		$this->req_material_qty->TooltipValue = "";

		// po_s_pending
		$this->po_s_pending->LinkCustomAttributes = "";
		$this->po_s_pending->HrefValue = "";
		$this->po_s_pending->TooltipValue = "";

		// po_pending_wbc
		$this->po_pending_wbc->LinkCustomAttributes = "";
		$this->po_pending_wbc->HrefValue = "";
		$this->po_pending_wbc->TooltipValue = "";

		// not_loomcard
		$this->not_loomcard->LinkCustomAttributes = "";
		$this->not_loomcard->HrefValue = "";
		$this->not_loomcard->TooltipValue = "";

		// stock
		$this->stock->LinkCustomAttributes = "";
		$this->stock->HrefValue = "";
		$this->stock->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// last_supplier_id
		$this->last_supplier_id->LinkCustomAttributes = "";
		$this->last_supplier_id->HrefValue = "";
		$this->last_supplier_id->TooltipValue = "";

		// internal_external
		$this->internal_external->LinkCustomAttributes = "";
		$this->internal_external->HrefValue = "";
		$this->internal_external->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// pending
		$this->pending->EditAttrs["class"] = "form-control";
		$this->pending->EditCustomAttributes = "";
		$this->pending->EditValue = $this->pending->CurrentValue;
		$this->pending->PlaceHolder = RemoveHtml($this->pending->caption());
		if (strval($this->pending->EditValue) <> "" && is_numeric($this->pending->EditValue))
			$this->pending->EditValue = FormatNumber($this->pending->EditValue, -2, -2, -2, -2);

		// req_material_grp
		$this->req_material_grp->EditAttrs["class"] = "form-control";
		$this->req_material_grp->EditCustomAttributes = "";

		// req_material_sgrp
		$this->req_material_sgrp->EditAttrs["class"] = "form-control";
		$this->req_material_sgrp->EditCustomAttributes = "";

		// req_material_product
		$this->req_material_product->EditAttrs["class"] = "form-control";
		$this->req_material_product->EditCustomAttributes = "";

		// req_material_rid
		$this->req_material_rid->EditAttrs["class"] = "form-control";
		$this->req_material_rid->EditCustomAttributes = "";
		$this->req_material_rid->EditValue = $this->req_material_rid->CurrentValue;
		$this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());

		// req_material_packing
		$this->req_material_packing->EditAttrs["class"] = "form-control";
		$this->req_material_packing->EditCustomAttributes = "";

		// batch_no
		$this->batch_no->EditAttrs["class"] = "form-control";
		$this->batch_no->EditCustomAttributes = "";

		// unit
		$this->unit->EditAttrs["class"] = "form-control";
		$this->unit->EditCustomAttributes = "";

		// mil
		$this->mil->EditAttrs["class"] = "form-control";
		$this->mil->EditCustomAttributes = "";
		$this->mil->EditValue = $this->mil->CurrentValue;
		$this->mil->PlaceHolder = RemoveHtml($this->mil->caption());
		if (strval($this->mil->EditValue) <> "" && is_numeric($this->mil->EditValue))
			$this->mil->EditValue = FormatNumber($this->mil->EditValue, -2, -2, -2, -2);

		// req_material_qty
		$this->req_material_qty->EditAttrs["class"] = "form-control";
		$this->req_material_qty->EditCustomAttributes = "";
		$this->req_material_qty->EditValue = $this->req_material_qty->CurrentValue;
		$this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());
		if (strval($this->req_material_qty->EditValue) <> "" && is_numeric($this->req_material_qty->EditValue))
			$this->req_material_qty->EditValue = FormatNumber($this->req_material_qty->EditValue, -2, -2, -2, -2);

		// po_s_pending
		$this->po_s_pending->EditAttrs["class"] = "form-control";
		$this->po_s_pending->EditCustomAttributes = "";
		$this->po_s_pending->EditValue = $this->po_s_pending->CurrentValue;
		$this->po_s_pending->PlaceHolder = RemoveHtml($this->po_s_pending->caption());
		if (strval($this->po_s_pending->EditValue) <> "" && is_numeric($this->po_s_pending->EditValue))
			$this->po_s_pending->EditValue = FormatNumber($this->po_s_pending->EditValue, -2, -2, -2, -2);

		// po_pending_wbc
		$this->po_pending_wbc->EditAttrs["class"] = "form-control";
		$this->po_pending_wbc->EditCustomAttributes = "";
		$this->po_pending_wbc->EditValue = $this->po_pending_wbc->CurrentValue;
		$this->po_pending_wbc->PlaceHolder = RemoveHtml($this->po_pending_wbc->caption());
		if (strval($this->po_pending_wbc->EditValue) <> "" && is_numeric($this->po_pending_wbc->EditValue))
			$this->po_pending_wbc->EditValue = FormatNumber($this->po_pending_wbc->EditValue, -2, -2, -2, -2);

		// not_loomcard
		$this->not_loomcard->EditAttrs["class"] = "form-control";
		$this->not_loomcard->EditCustomAttributes = "";
		$this->not_loomcard->EditValue = $this->not_loomcard->CurrentValue;
		$this->not_loomcard->PlaceHolder = RemoveHtml($this->not_loomcard->caption());
		if (strval($this->not_loomcard->EditValue) <> "" && is_numeric($this->not_loomcard->EditValue))
			$this->not_loomcard->EditValue = FormatNumber($this->not_loomcard->EditValue, -2, -2, -2, -2);

		// stock
		$this->stock->EditAttrs["class"] = "form-control";
		$this->stock->EditCustomAttributes = "";
		$this->stock->EditValue = $this->stock->CurrentValue;
		$this->stock->PlaceHolder = RemoveHtml($this->stock->caption());
		if (strval($this->stock->EditValue) <> "" && is_numeric($this->stock->EditValue))
			$this->stock->EditValue = FormatNumber($this->stock->EditValue, -2, -2, -2, -2);

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";

		// last_supplier_id
		$this->last_supplier_id->EditAttrs["class"] = "form-control";
		$this->last_supplier_id->EditCustomAttributes = "";
		$this->last_supplier_id->EditValue = $this->last_supplier_id->CurrentValue;
		$this->last_supplier_id->PlaceHolder = RemoveHtml($this->last_supplier_id->caption());

		// internal_external
		$this->internal_external->EditAttrs["class"] = "form-control";
		$this->internal_external->EditCustomAttributes = "";
		$this->internal_external->EditValue = $this->internal_external->options(TRUE);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->pending->CurrentValue))
				$this->pending->Total += $this->pending->CurrentValue; // Accumulate total
			if (is_numeric($this->req_material_qty->CurrentValue))
				$this->req_material_qty->Total += $this->req_material_qty->CurrentValue; // Accumulate total
			if (is_numeric($this->po_s_pending->CurrentValue))
				$this->po_s_pending->Total += $this->po_s_pending->CurrentValue; // Accumulate total
			if (is_numeric($this->po_pending_wbc->CurrentValue))
				$this->po_pending_wbc->Total += $this->po_pending_wbc->CurrentValue; // Accumulate total
			if (is_numeric($this->not_loomcard->CurrentValue))
				$this->not_loomcard->Total += $this->not_loomcard->CurrentValue; // Accumulate total
			if (is_numeric($this->stock->CurrentValue))
				$this->stock->Total += $this->stock->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->pending->CurrentValue = $this->pending->Total;
			$this->pending->ViewValue = $this->pending->CurrentValue;
			$this->pending->ViewValue = FormatNumber($this->pending->ViewValue, 2, -2, -2, -2);
			$this->pending->ViewCustomAttributes = "";
			$this->pending->HrefValue = ""; // Clear href value
			$this->req_material_qty->CurrentValue = $this->req_material_qty->Total;
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";
			$this->req_material_qty->HrefValue = ""; // Clear href value
			$this->po_s_pending->CurrentValue = $this->po_s_pending->Total;
			$this->po_s_pending->ViewValue = $this->po_s_pending->CurrentValue;
			$this->po_s_pending->ViewValue = FormatNumber($this->po_s_pending->ViewValue, 2, -2, -2, -2);
			$this->po_s_pending->ViewCustomAttributes = "";
			$this->po_s_pending->HrefValue = ""; // Clear href value
			$this->po_pending_wbc->CurrentValue = $this->po_pending_wbc->Total;
			$this->po_pending_wbc->ViewValue = $this->po_pending_wbc->CurrentValue;
			$this->po_pending_wbc->ViewValue = FormatNumber($this->po_pending_wbc->ViewValue, 2, -2, -2, -2);
			$this->po_pending_wbc->ViewCustomAttributes = "";
			$this->po_pending_wbc->HrefValue = ""; // Clear href value
			$this->not_loomcard->CurrentValue = $this->not_loomcard->Total;
			$this->not_loomcard->ViewValue = $this->not_loomcard->CurrentValue;
			$this->not_loomcard->ViewValue = FormatNumber($this->not_loomcard->ViewValue, 2, -2, -2, -2);
			$this->not_loomcard->ViewCustomAttributes = "";
			$this->not_loomcard->HrefValue = ""; // Clear href value
			$this->stock->CurrentValue = $this->stock->Total;
			$this->stock->ViewValue = $this->stock->CurrentValue;
			$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
			$this->stock->ViewCustomAttributes = "";
			$this->stock->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->pending);
					$doc->exportCaption($this->req_material_product);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->req_material_packing);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->mil);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->po_s_pending);
					$doc->exportCaption($this->po_pending_wbc);
					$doc->exportCaption($this->not_loomcard);
					$doc->exportCaption($this->stock);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->last_supplier_id);
					$doc->exportCaption($this->internal_external);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->pending);
					$doc->exportCaption($this->req_material_product);
					$doc->exportCaption($this->req_material_rid);
					$doc->exportCaption($this->req_material_packing);
					$doc->exportCaption($this->batch_no);
					$doc->exportCaption($this->unit);
					$doc->exportCaption($this->mil);
					$doc->exportCaption($this->req_material_qty);
					$doc->exportCaption($this->po_s_pending);
					$doc->exportCaption($this->po_pending_wbc);
					$doc->exportCaption($this->not_loomcard);
					$doc->exportCaption($this->stock);
					$doc->exportCaption($this->last_supplier_id);
					$doc->exportCaption($this->internal_external);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->pending);
						$doc->exportField($this->req_material_product);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->req_material_packing);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->unit);
						$doc->exportField($this->mil);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->po_s_pending);
						$doc->exportField($this->po_pending_wbc);
						$doc->exportField($this->not_loomcard);
						$doc->exportField($this->stock);
						$doc->exportField($this->company_id);
						$doc->exportField($this->last_supplier_id);
						$doc->exportField($this->internal_external);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->pending);
						$doc->exportField($this->req_material_product);
						$doc->exportField($this->req_material_rid);
						$doc->exportField($this->req_material_packing);
						$doc->exportField($this->batch_no);
						$doc->exportField($this->unit);
						$doc->exportField($this->mil);
						$doc->exportField($this->req_material_qty);
						$doc->exportField($this->po_s_pending);
						$doc->exportField($this->po_pending_wbc);
						$doc->exportField($this->not_loomcard);
						$doc->exportField($this->stock);
						$doc->exportField($this->last_supplier_id);
						$doc->exportField($this->internal_external);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->pending, 'TOTAL');
				$doc->exportAggregate($this->req_material_product, '');
				$doc->exportAggregate($this->req_material_rid, '');
				$doc->exportAggregate($this->req_material_packing, '');
				$doc->exportAggregate($this->batch_no, '');
				$doc->exportAggregate($this->unit, '');
				$doc->exportAggregate($this->mil, '');
				$doc->exportAggregate($this->req_material_qty, 'TOTAL');
				$doc->exportAggregate($this->po_s_pending, 'TOTAL');
				$doc->exportAggregate($this->po_pending_wbc, 'TOTAL');
				$doc->exportAggregate($this->not_loomcard, 'TOTAL');
				$doc->exportAggregate($this->stock, 'TOTAL');
				$doc->exportAggregate($this->last_supplier_id, '');
				$doc->exportAggregate($this->internal_external, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>