<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class required_material_overall_table_list extends required_material_overall_table
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'required_material_overall_table';

	// Page object name
	public $PageObjName = "required_material_overall_table_list";

	// Grid form hidden field names
	public $FormName = "frequired_material_overall_tablelist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (required_material_overall_table)
		if (!isset($GLOBALS["required_material_overall_table"]) || get_class($GLOBALS["required_material_overall_table"]) == PROJECT_NAMESPACE . "required_material_overall_table") {
			$GLOBALS["required_material_overall_table"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["required_material_overall_table"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "required_material_overall_tableadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "required_material_overall_tabledelete.php";
		$this->MultiUpdateUrl = "required_material_overall_tableupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'required_material_overall_table');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option frequired_material_overall_tablelistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $required_material_overall_table;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($required_material_overall_table);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->pending->setVisibility();
		$this->req_material_grp->setVisibility();
		$this->req_material_sgrp->Visible = FALSE;
		$this->req_material_product->setVisibility();
		$this->req_material_rid->setVisibility();
		$this->req_material_packing->setVisibility();
		$this->batch_no->setVisibility();
		$this->unit->setVisibility();
		$this->mil->setVisibility();
		$this->req_material_qty->setVisibility();
		$this->po_s_pending->setVisibility();
		$this->po_pending_wbc->setVisibility();
		$this->not_loomcard->setVisibility();
		$this->stock->setVisibility();
		$this->company_id->setVisibility();
		$this->last_supplier_id->setVisibility();
		$this->internal_external->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->req_material_grp);
		$this->setupLookupOptions($this->req_material_sgrp);
		$this->setupLookupOptions($this->req_material_product);
		$this->setupLookupOptions($this->req_material_rid);
		$this->setupLookupOptions($this->req_material_packing);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->unit);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->last_supplier_id);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export selected records
		if ($this->isExport())
			$this->CurrentFilter = $this->buildExportSelectedFilter();

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "frequired_material_overall_tablelistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->pending->AdvancedSearch->toJson(), ","); // Field pending
		$filterList = Concat($filterList, $this->req_material_grp->AdvancedSearch->toJson(), ","); // Field req_material_grp
		$filterList = Concat($filterList, $this->req_material_product->AdvancedSearch->toJson(), ","); // Field req_material_product
		$filterList = Concat($filterList, $this->req_material_rid->AdvancedSearch->toJson(), ","); // Field req_material_rid
		$filterList = Concat($filterList, $this->req_material_packing->AdvancedSearch->toJson(), ","); // Field req_material_packing
		$filterList = Concat($filterList, $this->batch_no->AdvancedSearch->toJson(), ","); // Field batch_no
		$filterList = Concat($filterList, $this->unit->AdvancedSearch->toJson(), ","); // Field unit
		$filterList = Concat($filterList, $this->mil->AdvancedSearch->toJson(), ","); // Field mil
		$filterList = Concat($filterList, $this->req_material_qty->AdvancedSearch->toJson(), ","); // Field req_material_qty
		$filterList = Concat($filterList, $this->po_s_pending->AdvancedSearch->toJson(), ","); // Field po_s_pending
		$filterList = Concat($filterList, $this->po_pending_wbc->AdvancedSearch->toJson(), ","); // Field po_pending_wbc
		$filterList = Concat($filterList, $this->not_loomcard->AdvancedSearch->toJson(), ","); // Field not_loomcard
		$filterList = Concat($filterList, $this->stock->AdvancedSearch->toJson(), ","); // Field stock
		$filterList = Concat($filterList, $this->company_id->AdvancedSearch->toJson(), ","); // Field company_id
		$filterList = Concat($filterList, $this->last_supplier_id->AdvancedSearch->toJson(), ","); // Field last_supplier_id
		$filterList = Concat($filterList, $this->internal_external->AdvancedSearch->toJson(), ","); // Field internal_external
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "frequired_material_overall_tablelistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field pending
		$this->pending->AdvancedSearch->SearchValue = @$filter["x_pending"];
		$this->pending->AdvancedSearch->SearchOperator = @$filter["z_pending"];
		$this->pending->AdvancedSearch->SearchCondition = @$filter["v_pending"];
		$this->pending->AdvancedSearch->SearchValue2 = @$filter["y_pending"];
		$this->pending->AdvancedSearch->SearchOperator2 = @$filter["w_pending"];
		$this->pending->AdvancedSearch->save();

		// Field req_material_grp
		$this->req_material_grp->AdvancedSearch->SearchValue = @$filter["x_req_material_grp"];
		$this->req_material_grp->AdvancedSearch->SearchOperator = @$filter["z_req_material_grp"];
		$this->req_material_grp->AdvancedSearch->SearchCondition = @$filter["v_req_material_grp"];
		$this->req_material_grp->AdvancedSearch->SearchValue2 = @$filter["y_req_material_grp"];
		$this->req_material_grp->AdvancedSearch->SearchOperator2 = @$filter["w_req_material_grp"];
		$this->req_material_grp->AdvancedSearch->save();

		// Field req_material_product
		$this->req_material_product->AdvancedSearch->SearchValue = @$filter["x_req_material_product"];
		$this->req_material_product->AdvancedSearch->SearchOperator = @$filter["z_req_material_product"];
		$this->req_material_product->AdvancedSearch->SearchCondition = @$filter["v_req_material_product"];
		$this->req_material_product->AdvancedSearch->SearchValue2 = @$filter["y_req_material_product"];
		$this->req_material_product->AdvancedSearch->SearchOperator2 = @$filter["w_req_material_product"];
		$this->req_material_product->AdvancedSearch->save();

		// Field req_material_rid
		$this->req_material_rid->AdvancedSearch->SearchValue = @$filter["x_req_material_rid"];
		$this->req_material_rid->AdvancedSearch->SearchOperator = @$filter["z_req_material_rid"];
		$this->req_material_rid->AdvancedSearch->SearchCondition = @$filter["v_req_material_rid"];
		$this->req_material_rid->AdvancedSearch->SearchValue2 = @$filter["y_req_material_rid"];
		$this->req_material_rid->AdvancedSearch->SearchOperator2 = @$filter["w_req_material_rid"];
		$this->req_material_rid->AdvancedSearch->save();

		// Field req_material_packing
		$this->req_material_packing->AdvancedSearch->SearchValue = @$filter["x_req_material_packing"];
		$this->req_material_packing->AdvancedSearch->SearchOperator = @$filter["z_req_material_packing"];
		$this->req_material_packing->AdvancedSearch->SearchCondition = @$filter["v_req_material_packing"];
		$this->req_material_packing->AdvancedSearch->SearchValue2 = @$filter["y_req_material_packing"];
		$this->req_material_packing->AdvancedSearch->SearchOperator2 = @$filter["w_req_material_packing"];
		$this->req_material_packing->AdvancedSearch->save();

		// Field batch_no
		$this->batch_no->AdvancedSearch->SearchValue = @$filter["x_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator = @$filter["z_batch_no"];
		$this->batch_no->AdvancedSearch->SearchCondition = @$filter["v_batch_no"];
		$this->batch_no->AdvancedSearch->SearchValue2 = @$filter["y_batch_no"];
		$this->batch_no->AdvancedSearch->SearchOperator2 = @$filter["w_batch_no"];
		$this->batch_no->AdvancedSearch->save();

		// Field unit
		$this->unit->AdvancedSearch->SearchValue = @$filter["x_unit"];
		$this->unit->AdvancedSearch->SearchOperator = @$filter["z_unit"];
		$this->unit->AdvancedSearch->SearchCondition = @$filter["v_unit"];
		$this->unit->AdvancedSearch->SearchValue2 = @$filter["y_unit"];
		$this->unit->AdvancedSearch->SearchOperator2 = @$filter["w_unit"];
		$this->unit->AdvancedSearch->save();

		// Field mil
		$this->mil->AdvancedSearch->SearchValue = @$filter["x_mil"];
		$this->mil->AdvancedSearch->SearchOperator = @$filter["z_mil"];
		$this->mil->AdvancedSearch->SearchCondition = @$filter["v_mil"];
		$this->mil->AdvancedSearch->SearchValue2 = @$filter["y_mil"];
		$this->mil->AdvancedSearch->SearchOperator2 = @$filter["w_mil"];
		$this->mil->AdvancedSearch->save();

		// Field req_material_qty
		$this->req_material_qty->AdvancedSearch->SearchValue = @$filter["x_req_material_qty"];
		$this->req_material_qty->AdvancedSearch->SearchOperator = @$filter["z_req_material_qty"];
		$this->req_material_qty->AdvancedSearch->SearchCondition = @$filter["v_req_material_qty"];
		$this->req_material_qty->AdvancedSearch->SearchValue2 = @$filter["y_req_material_qty"];
		$this->req_material_qty->AdvancedSearch->SearchOperator2 = @$filter["w_req_material_qty"];
		$this->req_material_qty->AdvancedSearch->save();

		// Field po_s_pending
		$this->po_s_pending->AdvancedSearch->SearchValue = @$filter["x_po_s_pending"];
		$this->po_s_pending->AdvancedSearch->SearchOperator = @$filter["z_po_s_pending"];
		$this->po_s_pending->AdvancedSearch->SearchCondition = @$filter["v_po_s_pending"];
		$this->po_s_pending->AdvancedSearch->SearchValue2 = @$filter["y_po_s_pending"];
		$this->po_s_pending->AdvancedSearch->SearchOperator2 = @$filter["w_po_s_pending"];
		$this->po_s_pending->AdvancedSearch->save();

		// Field po_pending_wbc
		$this->po_pending_wbc->AdvancedSearch->SearchValue = @$filter["x_po_pending_wbc"];
		$this->po_pending_wbc->AdvancedSearch->SearchOperator = @$filter["z_po_pending_wbc"];
		$this->po_pending_wbc->AdvancedSearch->SearchCondition = @$filter["v_po_pending_wbc"];
		$this->po_pending_wbc->AdvancedSearch->SearchValue2 = @$filter["y_po_pending_wbc"];
		$this->po_pending_wbc->AdvancedSearch->SearchOperator2 = @$filter["w_po_pending_wbc"];
		$this->po_pending_wbc->AdvancedSearch->save();

		// Field not_loomcard
		$this->not_loomcard->AdvancedSearch->SearchValue = @$filter["x_not_loomcard"];
		$this->not_loomcard->AdvancedSearch->SearchOperator = @$filter["z_not_loomcard"];
		$this->not_loomcard->AdvancedSearch->SearchCondition = @$filter["v_not_loomcard"];
		$this->not_loomcard->AdvancedSearch->SearchValue2 = @$filter["y_not_loomcard"];
		$this->not_loomcard->AdvancedSearch->SearchOperator2 = @$filter["w_not_loomcard"];
		$this->not_loomcard->AdvancedSearch->save();

		// Field stock
		$this->stock->AdvancedSearch->SearchValue = @$filter["x_stock"];
		$this->stock->AdvancedSearch->SearchOperator = @$filter["z_stock"];
		$this->stock->AdvancedSearch->SearchCondition = @$filter["v_stock"];
		$this->stock->AdvancedSearch->SearchValue2 = @$filter["y_stock"];
		$this->stock->AdvancedSearch->SearchOperator2 = @$filter["w_stock"];
		$this->stock->AdvancedSearch->save();

		// Field company_id
		$this->company_id->AdvancedSearch->SearchValue = @$filter["x_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator = @$filter["z_company_id"];
		$this->company_id->AdvancedSearch->SearchCondition = @$filter["v_company_id"];
		$this->company_id->AdvancedSearch->SearchValue2 = @$filter["y_company_id"];
		$this->company_id->AdvancedSearch->SearchOperator2 = @$filter["w_company_id"];
		$this->company_id->AdvancedSearch->save();

		// Field last_supplier_id
		$this->last_supplier_id->AdvancedSearch->SearchValue = @$filter["x_last_supplier_id"];
		$this->last_supplier_id->AdvancedSearch->SearchOperator = @$filter["z_last_supplier_id"];
		$this->last_supplier_id->AdvancedSearch->SearchCondition = @$filter["v_last_supplier_id"];
		$this->last_supplier_id->AdvancedSearch->SearchValue2 = @$filter["y_last_supplier_id"];
		$this->last_supplier_id->AdvancedSearch->SearchOperator2 = @$filter["w_last_supplier_id"];
		$this->last_supplier_id->AdvancedSearch->save();

		// Field internal_external
		$this->internal_external->AdvancedSearch->SearchValue = @$filter["x_internal_external"];
		$this->internal_external->AdvancedSearch->SearchOperator = @$filter["z_internal_external"];
		$this->internal_external->AdvancedSearch->SearchCondition = @$filter["v_internal_external"];
		$this->internal_external->AdvancedSearch->SearchValue2 = @$filter["y_internal_external"];
		$this->internal_external->AdvancedSearch->SearchOperator2 = @$filter["w_internal_external"];
		$this->internal_external->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->pending, $default, FALSE); // pending
		$this->buildSearchSql($where, $this->req_material_grp, $default, FALSE); // req_material_grp
		$this->buildSearchSql($where, $this->req_material_product, $default, FALSE); // req_material_product
		$this->buildSearchSql($where, $this->req_material_rid, $default, FALSE); // req_material_rid
		$this->buildSearchSql($where, $this->req_material_packing, $default, FALSE); // req_material_packing
		$this->buildSearchSql($where, $this->batch_no, $default, FALSE); // batch_no
		$this->buildSearchSql($where, $this->unit, $default, FALSE); // unit
		$this->buildSearchSql($where, $this->mil, $default, FALSE); // mil
		$this->buildSearchSql($where, $this->req_material_qty, $default, FALSE); // req_material_qty
		$this->buildSearchSql($where, $this->po_s_pending, $default, FALSE); // po_s_pending
		$this->buildSearchSql($where, $this->po_pending_wbc, $default, FALSE); // po_pending_wbc
		$this->buildSearchSql($where, $this->not_loomcard, $default, FALSE); // not_loomcard
		$this->buildSearchSql($where, $this->stock, $default, FALSE); // stock
		$this->buildSearchSql($where, $this->company_id, $default, FALSE); // company_id
		$this->buildSearchSql($where, $this->last_supplier_id, $default, FALSE); // last_supplier_id
		$this->buildSearchSql($where, $this->internal_external, $default, FALSE); // internal_external

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->pending->AdvancedSearch->save(); // pending
			$this->req_material_grp->AdvancedSearch->save(); // req_material_grp
			$this->req_material_product->AdvancedSearch->save(); // req_material_product
			$this->req_material_rid->AdvancedSearch->save(); // req_material_rid
			$this->req_material_packing->AdvancedSearch->save(); // req_material_packing
			$this->batch_no->AdvancedSearch->save(); // batch_no
			$this->unit->AdvancedSearch->save(); // unit
			$this->mil->AdvancedSearch->save(); // mil
			$this->req_material_qty->AdvancedSearch->save(); // req_material_qty
			$this->po_s_pending->AdvancedSearch->save(); // po_s_pending
			$this->po_pending_wbc->AdvancedSearch->save(); // po_pending_wbc
			$this->not_loomcard->AdvancedSearch->save(); // not_loomcard
			$this->stock->AdvancedSearch->save(); // stock
			$this->company_id->AdvancedSearch->save(); // company_id
			$this->last_supplier_id->AdvancedSearch->save(); // last_supplier_id
			$this->internal_external->AdvancedSearch->save(); // internal_external
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->req_material_sgrp, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->req_material_product, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->req_material_rid, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->req_material_packing, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->unit, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->company_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->last_supplier_id, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->pending->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->req_material_grp->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->req_material_product->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->req_material_rid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->req_material_packing->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->batch_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->unit->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->mil->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->req_material_qty->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_s_pending->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->po_pending_wbc->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->not_loomcard->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->stock->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->company_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->last_supplier_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->internal_external->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		$this->pending->AdvancedSearch->loadDefault();
		return TRUE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->pending->AdvancedSearch->unsetSession();
		$this->req_material_grp->AdvancedSearch->unsetSession();
		$this->req_material_product->AdvancedSearch->unsetSession();
		$this->req_material_rid->AdvancedSearch->unsetSession();
		$this->req_material_packing->AdvancedSearch->unsetSession();
		$this->batch_no->AdvancedSearch->unsetSession();
		$this->unit->AdvancedSearch->unsetSession();
		$this->mil->AdvancedSearch->unsetSession();
		$this->req_material_qty->AdvancedSearch->unsetSession();
		$this->po_s_pending->AdvancedSearch->unsetSession();
		$this->po_pending_wbc->AdvancedSearch->unsetSession();
		$this->not_loomcard->AdvancedSearch->unsetSession();
		$this->stock->AdvancedSearch->unsetSession();
		$this->company_id->AdvancedSearch->unsetSession();
		$this->last_supplier_id->AdvancedSearch->unsetSession();
		$this->internal_external->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->pending->AdvancedSearch->load();
		$this->req_material_grp->AdvancedSearch->load();
		$this->req_material_product->AdvancedSearch->load();
		$this->req_material_rid->AdvancedSearch->load();
		$this->req_material_packing->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->unit->AdvancedSearch->load();
		$this->mil->AdvancedSearch->load();
		$this->req_material_qty->AdvancedSearch->load();
		$this->po_s_pending->AdvancedSearch->load();
		$this->po_pending_wbc->AdvancedSearch->load();
		$this->not_loomcard->AdvancedSearch->load();
		$this->stock->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->last_supplier_id->AdvancedSearch->load();
		$this->internal_external->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->pending, $ctrl); // pending
			$this->updateSort($this->req_material_grp, $ctrl); // req_material_grp
			$this->updateSort($this->req_material_product, $ctrl); // req_material_product
			$this->updateSort($this->req_material_rid, $ctrl); // req_material_rid
			$this->updateSort($this->req_material_packing, $ctrl); // req_material_packing
			$this->updateSort($this->batch_no, $ctrl); // batch_no
			$this->updateSort($this->unit, $ctrl); // unit
			$this->updateSort($this->mil, $ctrl); // mil
			$this->updateSort($this->req_material_qty, $ctrl); // req_material_qty
			$this->updateSort($this->po_s_pending, $ctrl); // po_s_pending
			$this->updateSort($this->po_pending_wbc, $ctrl); // po_pending_wbc
			$this->updateSort($this->not_loomcard, $ctrl); // not_loomcard
			$this->updateSort($this->stock, $ctrl); // stock
			$this->updateSort($this->company_id, $ctrl); // company_id
			$this->updateSort($this->last_supplier_id, $ctrl); // last_supplier_id
			$this->updateSort($this->internal_external, $ctrl); // internal_external
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->pending->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->pending->setSort("");
				$this->req_material_grp->setSort("");
				$this->req_material_product->setSort("");
				$this->req_material_rid->setSort("");
				$this->req_material_packing->setSort("");
				$this->batch_no->setSort("");
				$this->unit->setSort("");
				$this->mil->setSort("");
				$this->req_material_qty->setSort("");
				$this->po_s_pending->setSort("");
				$this->po_pending_wbc->setSort("");
				$this->not_loomcard->setSort("");
				$this->stock->setSort("");
				$this->company_id->setSort("");
				$this->last_supplier_id->setSort("");
				$this->internal_external->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = TRUE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = FALSE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"frequired_material_overall_tablelistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"frequired_material_overall_tablelistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.frequired_material_overall_tablelist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"frequired_material_overall_tablelistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ResetSearch") . "\" data-caption=\"" . $Language->phrase("ResetSearch") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ResetSearchBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"required_material_overall_tablesrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"required_material_overall_table\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'required_material_overall_tablesrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"frequired_material_overall_tablelistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// pending
		if (!$this->isAddOrEdit())
			$this->pending->AdvancedSearch->setSearchValue(Get("x_pending", Get("pending", "")));
		if ($this->pending->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pending->AdvancedSearch->setSearchOperator(Get("z_pending", ""));
		$this->pending->AdvancedSearch->setSearchCondition(Get("v_pending", ""));
		$this->pending->AdvancedSearch->setSearchValue2(Get("y_pending", ""));
		if ($this->pending->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->pending->AdvancedSearch->setSearchOperator2(Get("w_pending", ""));

		// req_material_grp
		if (!$this->isAddOrEdit())
			$this->req_material_grp->AdvancedSearch->setSearchValue(Get("x_req_material_grp", Get("req_material_grp", "")));
		if ($this->req_material_grp->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->req_material_grp->AdvancedSearch->setSearchOperator(Get("z_req_material_grp", ""));

		// req_material_product
		if (!$this->isAddOrEdit())
			$this->req_material_product->AdvancedSearch->setSearchValue(Get("x_req_material_product", Get("req_material_product", "")));
		if ($this->req_material_product->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->req_material_product->AdvancedSearch->setSearchOperator(Get("z_req_material_product", ""));

		// req_material_rid
		if (!$this->isAddOrEdit())
			$this->req_material_rid->AdvancedSearch->setSearchValue(Get("x_req_material_rid", Get("req_material_rid", "")));
		if ($this->req_material_rid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->req_material_rid->AdvancedSearch->setSearchOperator(Get("z_req_material_rid", ""));

		// req_material_packing
		if (!$this->isAddOrEdit())
			$this->req_material_packing->AdvancedSearch->setSearchValue(Get("x_req_material_packing", Get("req_material_packing", "")));
		if ($this->req_material_packing->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->req_material_packing->AdvancedSearch->setSearchOperator(Get("z_req_material_packing", ""));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue(Get("x_batch_no", Get("batch_no", "")));
		if ($this->batch_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->batch_no->AdvancedSearch->setSearchOperator(Get("z_batch_no", ""));
		$this->batch_no->AdvancedSearch->setSearchCondition(Get("v_batch_no", ""));
		$this->batch_no->AdvancedSearch->setSearchValue2(Get("y_batch_no", ""));
		if ($this->batch_no->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->batch_no->AdvancedSearch->setSearchOperator2(Get("w_batch_no", ""));

		// unit
		if (!$this->isAddOrEdit())
			$this->unit->AdvancedSearch->setSearchValue(Get("x_unit", Get("unit", "")));
		if ($this->unit->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->unit->AdvancedSearch->setSearchOperator(Get("z_unit", ""));

		// mil
		if (!$this->isAddOrEdit())
			$this->mil->AdvancedSearch->setSearchValue(Get("x_mil", Get("mil", "")));
		if ($this->mil->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->mil->AdvancedSearch->setSearchOperator(Get("z_mil", ""));

		// req_material_qty
		if (!$this->isAddOrEdit())
			$this->req_material_qty->AdvancedSearch->setSearchValue(Get("x_req_material_qty", Get("req_material_qty", "")));
		if ($this->req_material_qty->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->req_material_qty->AdvancedSearch->setSearchOperator(Get("z_req_material_qty", ""));

		// po_s_pending
		if (!$this->isAddOrEdit())
			$this->po_s_pending->AdvancedSearch->setSearchValue(Get("x_po_s_pending", Get("po_s_pending", "")));
		if ($this->po_s_pending->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_s_pending->AdvancedSearch->setSearchOperator(Get("z_po_s_pending", ""));

		// po_pending_wbc
		if (!$this->isAddOrEdit())
			$this->po_pending_wbc->AdvancedSearch->setSearchValue(Get("x_po_pending_wbc", Get("po_pending_wbc", "")));
		if ($this->po_pending_wbc->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->po_pending_wbc->AdvancedSearch->setSearchOperator(Get("z_po_pending_wbc", ""));

		// not_loomcard
		if (!$this->isAddOrEdit())
			$this->not_loomcard->AdvancedSearch->setSearchValue(Get("x_not_loomcard", Get("not_loomcard", "")));
		if ($this->not_loomcard->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->not_loomcard->AdvancedSearch->setSearchOperator(Get("z_not_loomcard", ""));

		// stock
		if (!$this->isAddOrEdit())
			$this->stock->AdvancedSearch->setSearchValue(Get("x_stock", Get("stock", "")));
		if ($this->stock->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->stock->AdvancedSearch->setSearchOperator(Get("z_stock", ""));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue(Get("x_company_id", Get("company_id", "")));
		if ($this->company_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->company_id->AdvancedSearch->setSearchOperator(Get("z_company_id", ""));

		// last_supplier_id
		if (!$this->isAddOrEdit())
			$this->last_supplier_id->AdvancedSearch->setSearchValue(Get("x_last_supplier_id", Get("last_supplier_id", "")));
		if ($this->last_supplier_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->last_supplier_id->AdvancedSearch->setSearchOperator(Get("z_last_supplier_id", ""));

		// internal_external
		if (!$this->isAddOrEdit())
			$this->internal_external->AdvancedSearch->setSearchValue(Get("x_internal_external", Get("internal_external", "")));
		if ($this->internal_external->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->internal_external->AdvancedSearch->setSearchOperator(Get("z_internal_external", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->pending->setDbValue($row['pending']);
		$this->req_material_grp->setDbValue($row['req_material_grp']);
		$this->req_material_sgrp->setDbValue($row['req_material_sgrp']);
		$this->req_material_product->setDbValue($row['req_material_product']);
		$this->req_material_rid->setDbValue($row['req_material_rid']);
		$this->req_material_packing->setDbValue($row['req_material_packing']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->unit->setDbValue($row['unit']);
		$this->mil->setDbValue($row['mil']);
		$this->req_material_qty->setDbValue($row['req_material_qty']);
		$this->po_s_pending->setDbValue($row['po_s_pending']);
		$this->po_pending_wbc->setDbValue($row['po_pending_wbc']);
		$this->not_loomcard->setDbValue($row['not_loomcard']);
		$this->stock->setDbValue($row['stock']);
		$this->company_id->setDbValue($row['company_id']);
		$this->last_supplier_id->setDbValue($row['last_supplier_id']);
		$this->internal_external->setDbValue($row['internal_external']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['pending'] = NULL;
		$row['req_material_grp'] = NULL;
		$row['req_material_sgrp'] = NULL;
		$row['req_material_product'] = NULL;
		$row['req_material_rid'] = NULL;
		$row['req_material_packing'] = NULL;
		$row['batch_no'] = NULL;
		$row['unit'] = NULL;
		$row['mil'] = NULL;
		$row['req_material_qty'] = NULL;
		$row['po_s_pending'] = NULL;
		$row['po_pending_wbc'] = NULL;
		$row['not_loomcard'] = NULL;
		$row['stock'] = NULL;
		$row['company_id'] = NULL;
		$row['last_supplier_id'] = NULL;
		$row['internal_external'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->pending->FormValue == $this->pending->CurrentValue && is_numeric(ConvertToFloatString($this->pending->CurrentValue)))
			$this->pending->CurrentValue = ConvertToFloatString($this->pending->CurrentValue);

		// Convert decimal values if posted back
		if ($this->mil->FormValue == $this->mil->CurrentValue && is_numeric(ConvertToFloatString($this->mil->CurrentValue)))
			$this->mil->CurrentValue = ConvertToFloatString($this->mil->CurrentValue);

		// Convert decimal values if posted back
		if ($this->req_material_qty->FormValue == $this->req_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->req_material_qty->CurrentValue)))
			$this->req_material_qty->CurrentValue = ConvertToFloatString($this->req_material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->po_s_pending->FormValue == $this->po_s_pending->CurrentValue && is_numeric(ConvertToFloatString($this->po_s_pending->CurrentValue)))
			$this->po_s_pending->CurrentValue = ConvertToFloatString($this->po_s_pending->CurrentValue);

		// Convert decimal values if posted back
		if ($this->po_pending_wbc->FormValue == $this->po_pending_wbc->CurrentValue && is_numeric(ConvertToFloatString($this->po_pending_wbc->CurrentValue)))
			$this->po_pending_wbc->CurrentValue = ConvertToFloatString($this->po_pending_wbc->CurrentValue);

		// Convert decimal values if posted back
		if ($this->not_loomcard->FormValue == $this->not_loomcard->CurrentValue && is_numeric(ConvertToFloatString($this->not_loomcard->CurrentValue)))
			$this->not_loomcard->CurrentValue = ConvertToFloatString($this->not_loomcard->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stock->FormValue == $this->stock->CurrentValue && is_numeric(ConvertToFloatString($this->stock->CurrentValue)))
			$this->stock->CurrentValue = ConvertToFloatString($this->stock->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// pending
		// req_material_grp

		$this->req_material_grp->CellCssStyle = "white-space: nowrap;";

		// req_material_sgrp
		$this->req_material_sgrp->CellCssStyle = "white-space: nowrap;";

		// req_material_product
		// req_material_rid
		// req_material_packing
		// batch_no
		// unit
		// mil
		// req_material_qty
		// po_s_pending
		// po_pending_wbc
		// not_loomcard
		// stock
		// company_id
		// last_supplier_id
		// internal_external
		// Accumulate aggregate value

		if ($this->RowType <> ROWTYPE_AGGREGATEINIT && $this->RowType <> ROWTYPE_AGGREGATE) {
			if (is_numeric($this->pending->CurrentValue))
				$this->pending->Total += $this->pending->CurrentValue; // Accumulate total
			if (is_numeric($this->req_material_qty->CurrentValue))
				$this->req_material_qty->Total += $this->req_material_qty->CurrentValue; // Accumulate total
			if (is_numeric($this->po_s_pending->CurrentValue))
				$this->po_s_pending->Total += $this->po_s_pending->CurrentValue; // Accumulate total
			if (is_numeric($this->po_pending_wbc->CurrentValue))
				$this->po_pending_wbc->Total += $this->po_pending_wbc->CurrentValue; // Accumulate total
			if (is_numeric($this->not_loomcard->CurrentValue))
				$this->not_loomcard->Total += $this->not_loomcard->CurrentValue; // Accumulate total
			if (is_numeric($this->stock->CurrentValue))
				$this->stock->Total += $this->stock->CurrentValue; // Accumulate total
		}
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// pending
			$this->pending->ViewValue = $this->pending->CurrentValue;
			$this->pending->ViewValue = FormatNumber($this->pending->ViewValue, 2, -2, -2, -2);
			$this->pending->ViewCustomAttributes = "";

			// req_material_grp
			$curVal = strval($this->req_material_grp->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_grp->ViewValue = $this->req_material_grp->lookupCacheOption($curVal);
				if ($this->req_material_grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_grp->ViewValue = $this->req_material_grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_grp->ViewValue = $this->req_material_grp->CurrentValue;
					}
				}
			} else {
				$this->req_material_grp->ViewValue = NULL;
			}
			$this->req_material_grp->ViewCustomAttributes = "";

			// req_material_product
			$curVal = strval($this->req_material_product->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
				if ($this->req_material_product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
					}
				}
			} else {
				$this->req_material_product->ViewValue = NULL;
			}
			$this->req_material_product->ViewCustomAttributes = "";

			// req_material_rid
			$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
			$curVal = strval($this->req_material_rid->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
					}
				}
			} else {
				$this->req_material_rid->ViewValue = NULL;
			}
			$this->req_material_rid->ViewCustomAttributes = "";

			// req_material_packing
			$curVal = strval($this->req_material_packing->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
				if ($this->req_material_packing->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
					}
				}
			} else {
				$this->req_material_packing->ViewValue = NULL;
			}
			$this->req_material_packing->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// unit
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->unit->ViewValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->ViewValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// mil
			$this->mil->ViewValue = $this->mil->CurrentValue;
			$this->mil->ViewValue = FormatNumber($this->mil->ViewValue, 2, -2, -2, -2);
			$this->mil->ViewCustomAttributes = "";

			// req_material_qty
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";

			// po_s_pending
			$this->po_s_pending->ViewValue = $this->po_s_pending->CurrentValue;
			$this->po_s_pending->ViewValue = FormatNumber($this->po_s_pending->ViewValue, 2, -2, -2, -2);
			$this->po_s_pending->ViewCustomAttributes = "";

			// po_pending_wbc
			$this->po_pending_wbc->ViewValue = $this->po_pending_wbc->CurrentValue;
			$this->po_pending_wbc->ViewValue = FormatNumber($this->po_pending_wbc->ViewValue, 2, -2, -2, -2);
			$this->po_pending_wbc->ViewCustomAttributes = "";

			// not_loomcard
			$this->not_loomcard->ViewValue = $this->not_loomcard->CurrentValue;
			$this->not_loomcard->ViewValue = FormatNumber($this->not_loomcard->ViewValue, 2, -2, -2, -2);
			$this->not_loomcard->ViewCustomAttributes = "";

			// stock
			$this->stock->ViewValue = $this->stock->CurrentValue;
			$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
			$this->stock->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// last_supplier_id
			$this->last_supplier_id->ViewValue = $this->last_supplier_id->CurrentValue;
			$curVal = strval($this->last_supplier_id->CurrentValue);
			if ($curVal <> "") {
				$this->last_supplier_id->ViewValue = $this->last_supplier_id->lookupCacheOption($curVal);
				if ($this->last_supplier_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->last_supplier_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->last_supplier_id->ViewValue = $this->last_supplier_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->last_supplier_id->ViewValue = $this->last_supplier_id->CurrentValue;
					}
				}
			} else {
				$this->last_supplier_id->ViewValue = NULL;
			}
			$this->last_supplier_id->ViewCustomAttributes = "";

			// internal_external
			if (strval($this->internal_external->CurrentValue) <> "") {
				$this->internal_external->ViewValue = $this->internal_external->optionCaption($this->internal_external->CurrentValue);
			} else {
				$this->internal_external->ViewValue = NULL;
			}
			$this->internal_external->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// pending
			$this->pending->LinkCustomAttributes = "";
			$this->pending->HrefValue = "";
			$this->pending->TooltipValue = "";

			// req_material_grp
			$this->req_material_grp->LinkCustomAttributes = "";
			$this->req_material_grp->HrefValue = "";
			$this->req_material_grp->TooltipValue = "";

			// req_material_product
			$this->req_material_product->LinkCustomAttributes = "";
			$this->req_material_product->HrefValue = "";
			$this->req_material_product->TooltipValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->req_material_rid->CurrentValue)) {
				$this->req_material_rid->HrefValue = "required_material_overall_tablelist.php?x_req_material_rid=" . $this->req_material_rid->CurrentValue; // Add prefix/suffix
				$this->req_material_rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->req_material_rid->HrefValue = FullUrl($this->req_material_rid->HrefValue, "href");
			} else {
				$this->req_material_rid->HrefValue = "";
			}
			$this->req_material_rid->TooltipValue = "";
			if (!$this->isExport())
				$this->req_material_rid->ViewValue = $this->highlightValue($this->req_material_rid);

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			if (!EmptyValue($this->req_material_packing->CurrentValue)) {
				$this->req_material_packing->HrefValue = "required_material_overall_tablelist.php?x_req_material_rid=" . $this->req_material_packing->CurrentValue; // Add prefix/suffix
				$this->req_material_packing->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->req_material_packing->HrefValue = FullUrl($this->req_material_packing->HrefValue, "href");
			} else {
				$this->req_material_packing->HrefValue = "";
			}
			$this->req_material_packing->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// mil
			$this->mil->LinkCustomAttributes = "";
			$this->mil->HrefValue = "";
			$this->mil->TooltipValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// po_s_pending
			$this->po_s_pending->LinkCustomAttributes = "";
			$this->po_s_pending->HrefValue = "";
			$this->po_s_pending->TooltipValue = "";

			// po_pending_wbc
			$this->po_pending_wbc->LinkCustomAttributes = "";
			$this->po_pending_wbc->HrefValue = "";
			$this->po_pending_wbc->TooltipValue = "";

			// not_loomcard
			$this->not_loomcard->LinkCustomAttributes = "";
			$this->not_loomcard->HrefValue = "";
			$this->not_loomcard->TooltipValue = "";

			// stock
			$this->stock->LinkCustomAttributes = "";
			$this->stock->HrefValue = "";
			$this->stock->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// last_supplier_id
			$this->last_supplier_id->LinkCustomAttributes = "";
			$this->last_supplier_id->HrefValue = "";
			$this->last_supplier_id->TooltipValue = "";
			if (!$this->isExport())
				$this->last_supplier_id->ViewValue = $this->highlightValue($this->last_supplier_id);

			// internal_external
			$this->internal_external->LinkCustomAttributes = "";
			$this->internal_external->HrefValue = "";
			$this->internal_external->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// pending
			$this->pending->EditAttrs["class"] = "form-control";
			$this->pending->EditCustomAttributes = "";
			$this->pending->EditValue = HtmlEncode($this->pending->AdvancedSearch->SearchValue);
			$this->pending->PlaceHolder = RemoveHtml($this->pending->caption());
			$this->pending->EditAttrs["class"] = "form-control";
			$this->pending->EditCustomAttributes = "";
			$this->pending->EditValue2 = HtmlEncode($this->pending->AdvancedSearch->SearchValue2);
			$this->pending->PlaceHolder = RemoveHtml($this->pending->caption());

			// req_material_grp
			$this->req_material_grp->EditAttrs["class"] = "form-control";
			$this->req_material_grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->req_material_grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->req_material_grp->AdvancedSearch->ViewValue = $this->req_material_grp->lookupCacheOption($curVal);
			else
				$this->req_material_grp->AdvancedSearch->ViewValue = $this->req_material_grp->Lookup !== NULL && is_array($this->req_material_grp->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->req_material_grp->EditValue = array_values($this->req_material_grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_grp->EditValue = $arwrk;
			}

			// req_material_product
			$this->req_material_product->EditAttrs["class"] = "form-control";
			$this->req_material_product->EditCustomAttributes = "";

			// req_material_rid
			$this->req_material_rid->EditAttrs["class"] = "form-control";
			$this->req_material_rid->EditCustomAttributes = "";
			$this->req_material_rid->EditValue = HtmlEncode($this->req_material_rid->AdvancedSearch->SearchValue);
			$curVal = strval($this->req_material_rid->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->EditValue = HtmlEncode($this->req_material_rid->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->req_material_rid->EditValue = NULL;
			}
			$this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());

			// req_material_packing
			$this->req_material_packing->EditAttrs["class"] = "form-control";
			$this->req_material_packing->EditCustomAttributes = "";
			$curVal = trim(strval($this->req_material_packing->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			else
				$this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->Lookup !== NULL && is_array($this->req_material_packing->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_packing->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->req_material_packing->EditValue = array_values($this->req_material_packing->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_packing->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_packing->EditValue = $arwrk;
			}

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->batch_no->EditValue = array_values($this->batch_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue = $arwrk;
			}
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->batch_no->AdvancedSearch->ViewValue2 = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->AdvancedSearch->ViewValue2 = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->batch_no->EditValue2 = array_values($this->batch_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->AdvancedSearch->SearchValue2, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue2 = $arwrk;
			}

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";

			// mil
			$this->mil->EditAttrs["class"] = "form-control";
			$this->mil->EditCustomAttributes = "";
			$this->mil->EditValue = HtmlEncode($this->mil->AdvancedSearch->SearchValue);
			$this->mil->PlaceHolder = RemoveHtml($this->mil->caption());

			// req_material_qty
			$this->req_material_qty->EditAttrs["class"] = "form-control";
			$this->req_material_qty->EditCustomAttributes = "";
			$this->req_material_qty->EditValue = HtmlEncode($this->req_material_qty->AdvancedSearch->SearchValue);
			$this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());

			// po_s_pending
			$this->po_s_pending->EditAttrs["class"] = "form-control";
			$this->po_s_pending->EditCustomAttributes = "";
			$this->po_s_pending->EditValue = HtmlEncode($this->po_s_pending->AdvancedSearch->SearchValue);
			$this->po_s_pending->PlaceHolder = RemoveHtml($this->po_s_pending->caption());

			// po_pending_wbc
			$this->po_pending_wbc->EditAttrs["class"] = "form-control";
			$this->po_pending_wbc->EditCustomAttributes = "";
			$this->po_pending_wbc->EditValue = HtmlEncode($this->po_pending_wbc->AdvancedSearch->SearchValue);
			$this->po_pending_wbc->PlaceHolder = RemoveHtml($this->po_pending_wbc->caption());

			// not_loomcard
			$this->not_loomcard->EditAttrs["class"] = "form-control";
			$this->not_loomcard->EditCustomAttributes = "";
			$this->not_loomcard->EditValue = HtmlEncode($this->not_loomcard->AdvancedSearch->SearchValue);
			$this->not_loomcard->PlaceHolder = RemoveHtml($this->not_loomcard->caption());

			// stock
			$this->stock->EditAttrs["class"] = "form-control";
			$this->stock->EditCustomAttributes = "";
			$this->stock->EditValue = HtmlEncode($this->stock->AdvancedSearch->SearchValue);
			$this->stock->PlaceHolder = RemoveHtml($this->stock->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";

			// last_supplier_id
			$this->last_supplier_id->EditAttrs["class"] = "form-control";
			$this->last_supplier_id->EditCustomAttributes = "";
			$this->last_supplier_id->EditValue = HtmlEncode($this->last_supplier_id->AdvancedSearch->SearchValue);
			$this->last_supplier_id->PlaceHolder = RemoveHtml($this->last_supplier_id->caption());

			// internal_external
			$this->internal_external->EditAttrs["class"] = "form-control";
			$this->internal_external->EditCustomAttributes = "";
			$this->internal_external->EditValue = $this->internal_external->options(TRUE);
		} elseif ($this->RowType == ROWTYPE_AGGREGATEINIT) { // Initialize aggregate row
			$this->pending->Total = 0; // Initialize total
			$this->req_material_qty->Total = 0; // Initialize total
			$this->po_s_pending->Total = 0; // Initialize total
			$this->po_pending_wbc->Total = 0; // Initialize total
			$this->not_loomcard->Total = 0; // Initialize total
			$this->stock->Total = 0; // Initialize total
		} elseif ($this->RowType == ROWTYPE_AGGREGATE) { // Aggregate row
			$this->pending->CurrentValue = $this->pending->Total;
			$this->pending->ViewValue = $this->pending->CurrentValue;
			$this->pending->ViewValue = FormatNumber($this->pending->ViewValue, 2, -2, -2, -2);
			$this->pending->ViewCustomAttributes = "";
			$this->pending->HrefValue = ""; // Clear href value
			$this->req_material_qty->CurrentValue = $this->req_material_qty->Total;
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";
			$this->req_material_qty->HrefValue = ""; // Clear href value
			$this->po_s_pending->CurrentValue = $this->po_s_pending->Total;
			$this->po_s_pending->ViewValue = $this->po_s_pending->CurrentValue;
			$this->po_s_pending->ViewValue = FormatNumber($this->po_s_pending->ViewValue, 2, -2, -2, -2);
			$this->po_s_pending->ViewCustomAttributes = "";
			$this->po_s_pending->HrefValue = ""; // Clear href value
			$this->po_pending_wbc->CurrentValue = $this->po_pending_wbc->Total;
			$this->po_pending_wbc->ViewValue = $this->po_pending_wbc->CurrentValue;
			$this->po_pending_wbc->ViewValue = FormatNumber($this->po_pending_wbc->ViewValue, 2, -2, -2, -2);
			$this->po_pending_wbc->ViewCustomAttributes = "";
			$this->po_pending_wbc->HrefValue = ""; // Clear href value
			$this->not_loomcard->CurrentValue = $this->not_loomcard->Total;
			$this->not_loomcard->ViewValue = $this->not_loomcard->CurrentValue;
			$this->not_loomcard->ViewValue = FormatNumber($this->not_loomcard->ViewValue, 2, -2, -2, -2);
			$this->not_loomcard->ViewCustomAttributes = "";
			$this->not_loomcard->HrefValue = ""; // Clear href value
			$this->stock->CurrentValue = $this->stock->Total;
			$this->stock->ViewValue = $this->stock->CurrentValue;
			$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
			$this->stock->ViewCustomAttributes = "";
			$this->stock->HrefValue = ""; // Clear href value
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckNumber($this->pending->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pending->errorMessage());
		}
		if (!CheckNumber($this->pending->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->pending->errorMessage());
		}
		if (!CheckInteger($this->req_material_rid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->req_material_rid->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->pending->AdvancedSearch->load();
		$this->req_material_grp->AdvancedSearch->load();
		$this->req_material_product->AdvancedSearch->load();
		$this->req_material_rid->AdvancedSearch->load();
		$this->req_material_packing->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->unit->AdvancedSearch->load();
		$this->mil->AdvancedSearch->load();
		$this->req_material_qty->AdvancedSearch->load();
		$this->po_s_pending->AdvancedSearch->load();
		$this->po_pending_wbc->AdvancedSearch->load();
		$this->not_loomcard->AdvancedSearch->load();
		$this->stock->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->last_supplier_id->AdvancedSearch->load();
		$this->internal_external->AdvancedSearch->load();
	}

	// Build export filter for selected records
	protected function buildExportSelectedFilter()
	{
		global $Language;
		$wrkFilter = "";
		if ($this->isExport())
			$wrkFilter = $this->getFilterFromRecordKeys();
		return $wrkFilter;
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.frequired_material_overall_tablelist,'" . CurrentPageName() . "','excel',true,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.frequired_material_overall_tablelist,'" . CurrentPageName() . "','excel',false,true);\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.frequired_material_overall_tablelist,'" . CurrentPageName() . "','word',true,true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.frequired_material_overall_tablelist,'" . CurrentPageName() . "','word',false,true);\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.frequired_material_overall_tablelist,'" . CurrentPageName() . "','pdf',true,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"javascript:void(0);\" class=\" ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.frequired_material_overall_tablelist,'" . CurrentPageName() . "','pdf',false,true);\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" onclick=\"ew.export(document.frequired_material_overall_tablelist,'" . CurrentPageName() . "','html',false,true);\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" onclick=\"ew.export(document.frequired_material_overall_tablelist,'" . CurrentPageName() . "','xml',false,true);\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" onclick=\"ew.export(document.frequired_material_overall_tablelist,'" . CurrentPageName() . "','csv',false,true);\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"javascript:void(0);\" class=\" ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" onclick=\"ew.export(document.frequired_material_overall_tablelist,'" . CurrentPageName() . "','print',false,true);\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_required_material_overall_table\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_required_material_overall_table',hdr:ew.language.phrase('ExportToEmailText'),f:document.frequired_material_overall_tablelist,sel:true" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_req_material_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_sgrp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_product":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_rid":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_packing":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_company_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_last_supplier_id":
					$lookupFilter = function() {
						return "`partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_req_material_grp":
							break;
						case "x_req_material_sgrp":
							break;
						case "x_req_material_product":
							break;
						case "x_req_material_rid":
							break;
						case "x_req_material_packing":
							break;
						case "x_batch_no":
							break;
						case "x_unit":
							break;
						case "x_company_id":
							break;
						case "x_last_supplier_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
		if ((CurrentUserID() == 51) OR (CurrentUserID() == -1) OR ((date("H") > 18) OR (date("H") < 10) ))
		{
			ini_set('max_execution_time', 300);
			$CDT = CurrentDateTime();
			IF (isset($_GET['MRDALL']))
			{
				ExecuteStatement("TRUNCATE TABLE `required_material_overall_table`");
				ExecuteStatement("UPDATE `carpet_setup` set `required_material_overall_update` =  (`required_material_overall_update`+1)");
				header('Location:required_material_overall_tablelist.php');
			}
			else
			{
				$msg .= 'Not permitted to run the query by the current user or between 10:00 AM and 6:00 PM.';
				$_SESSION[SESSION_SUCCESS_MESSAGE] = $msg; 
			}
		}
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {
			$msg = 	$msg = '<a href="required_material_overall_tablelist.php?MRDALL=7fa7" data-original-title ="Re-fresh"><i data-phrase="Re-fresh"  class="fa fa-refresh ew-icon" ></i></a>';;
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		$dt = ExecuteScalar("SELECT DATE_FORMAT(`mr_live_datetime`, '%M, %D %h:%i') from `po_setup`");
		$count = ExecuteScalar("SELECT ifnull((SELECT count(`id`) from `required_material_overall_table` where `batch_no` is NULL and `pending` > 0),0)");
	if ($count == 0)
	{
		$item = &$this->OtherOptions['action']->Add("Create Order");
		$item->Body = "<button class=\"btn btn-danger ew-action\" onclick=\"javascript:CreateOrder()\">Create Order From Selected</button>";
		$item->Visible = True;
	}
		$item = &$this->OtherOptions['action']->Add("Re-fresh");
		$item->Body = '<a href="required_material_overall_tablelist.php?MRDALL=7fa7" data-original-title ="Re-fresh '.$dt.'" style="color:red"><i data-phrase="Re-fresh '.$dt.'"  class="fa fa-refresh ew-icon" ></i>'.$dt.'</a>';
		$item->Visible = True;	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
	$count = ExecuteScalar("SELECT ifnull((SELECT count(`id`) from `required_material_overall_table` where `batch_no` is NULL and `pending` > 0),0)");
	if ($count == 0)
	{
	if(($this->internal_external->CurrentValue == 1) || ($this->internal_external->CurrentValue == 2))
		{
			$this->ListOptions->Add("Create Internal Order"); 
			$this->ListOptions->Items["Create Internal Order"]->Body = '<a href="product_cart_badd.php?CID=1000&PID=200000&grp='.$this->req_material_grp->CurrentValue.'&s_grp='.$this->req_material_sgrp->CurrentValue.'&product='.$this->req_material_product->CurrentValue.'&rid='.$this->req_material_rid->CurrentValue.'&qty='.$this->pending->CurrentValue.'&pt='.$this->req_material_packing->CurrentValue.'" data-original-title ="Create Internal Order"><i data-phrase="Create Internal Order"  style="color:red" class="fa fa-recycle ew-icon" ></i></a>';
		}
	if(($this->internal_external->CurrentValue == 0) || ($this->internal_external->CurrentValue == 2))
		{
			$this->ListOptions->Add("Create Cart"); 
			$this->ListOptions->Items["Create Cart"]->Body = '<a href="product_cart_sadd.php?CID=1000&grp='.$this->req_material_grp->CurrentValue.'&s_grp='.$this->req_material_sgrp->CurrentValue.'&product='.$this->req_material_product->CurrentValue.'&rid='.$this->req_material_rid->CurrentValue.'&qty='.$this->pending->CurrentValue.'&pt='.$this->req_material_packing->CurrentValue.'&partner_id='.$this->company_id->CurrentValue.'" data-original-title ="Create Order"><i data-phrase="Create Cart"  class="fa fa-sign-out ew-icon" ></i></a>';
		}
	}	
		if (is_null($this->batch_no->CurrentValue))
				$this->ListOptions->Items['checkbox']->Body='<i class="fa fa-ban fa-lg"></i>';
		if ($this->pending->CurrentValue <= 0) 
				$this->ListOptions->Items['checkbox']->Body='<i class="fa fa-ban fa-lg" style="color:green"></i>';
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>