<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class required_material_overall_table_search extends required_material_overall_table
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'required_material_overall_table';

	// Page object name
	public $PageObjName = "required_material_overall_table_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (required_material_overall_table)
		if (!isset($GLOBALS["required_material_overall_table"]) || get_class($GLOBALS["required_material_overall_table"]) == PROJECT_NAMESPACE . "required_material_overall_table") {
			$GLOBALS["required_material_overall_table"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["required_material_overall_table"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'required_material_overall_table');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $required_material_overall_table;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($required_material_overall_table);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "required_material_overall_tableview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("required_material_overall_tablelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->pending->setVisibility();
		$this->req_material_grp->Visible = FALSE;
		$this->req_material_sgrp->Visible = FALSE;
		$this->req_material_product->setVisibility();
		$this->req_material_rid->setVisibility();
		$this->req_material_packing->setVisibility();
		$this->batch_no->setVisibility();
		$this->unit->setVisibility();
		$this->mil->setVisibility();
		$this->req_material_qty->setVisibility();
		$this->po_s_pending->setVisibility();
		$this->po_pending_wbc->setVisibility();
		$this->not_loomcard->setVisibility();
		$this->stock->setVisibility();
		$this->company_id->setVisibility();
		$this->last_supplier_id->setVisibility();
		$this->internal_external->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->req_material_grp);
		$this->setupLookupOptions($this->req_material_sgrp);
		$this->setupLookupOptions($this->req_material_product);
		$this->setupLookupOptions($this->req_material_rid);
		$this->setupLookupOptions($this->req_material_packing);
		$this->setupLookupOptions($this->batch_no);
		$this->setupLookupOptions($this->unit);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->last_supplier_id);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "required_material_overall_tablelist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->pending); // pending
		$this->buildSearchUrl($srchUrl, $this->req_material_product); // req_material_product
		$this->buildSearchUrl($srchUrl, $this->req_material_rid); // req_material_rid
		$this->buildSearchUrl($srchUrl, $this->req_material_packing); // req_material_packing
		$this->buildSearchUrl($srchUrl, $this->batch_no); // batch_no
		$this->buildSearchUrl($srchUrl, $this->unit); // unit
		$this->buildSearchUrl($srchUrl, $this->mil); // mil
		$this->buildSearchUrl($srchUrl, $this->req_material_qty); // req_material_qty
		$this->buildSearchUrl($srchUrl, $this->po_s_pending); // po_s_pending
		$this->buildSearchUrl($srchUrl, $this->po_pending_wbc); // po_pending_wbc
		$this->buildSearchUrl($srchUrl, $this->not_loomcard); // not_loomcard
		$this->buildSearchUrl($srchUrl, $this->stock); // stock
		$this->buildSearchUrl($srchUrl, $this->company_id); // company_id
		$this->buildSearchUrl($srchUrl, $this->last_supplier_id); // last_supplier_id
		$this->buildSearchUrl($srchUrl, $this->internal_external); // internal_external
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// pending
		if (!$this->isAddOrEdit())
			$this->pending->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pending"));
		$this->pending->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pending"));
		$this->pending->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_pending"));
		$this->pending->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_pending"));
		$this->pending->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_pending"));

		// req_material_grp
		if (!$this->isAddOrEdit())
			$this->req_material_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_req_material_grp"));
		$this->req_material_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_req_material_grp"));

		// req_material_product
		if (!$this->isAddOrEdit())
			$this->req_material_product->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_req_material_product"));
		$this->req_material_product->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_req_material_product"));

		// req_material_rid
		if (!$this->isAddOrEdit())
			$this->req_material_rid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_req_material_rid"));
		$this->req_material_rid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_req_material_rid"));

		// req_material_packing
		if (!$this->isAddOrEdit())
			$this->req_material_packing->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_req_material_packing"));
		$this->req_material_packing->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_req_material_packing"));

		// batch_no
		if (!$this->isAddOrEdit())
			$this->batch_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_batch_no"));
		$this->batch_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_batch_no"));
		$this->batch_no->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_batch_no"));
		$this->batch_no->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_batch_no"));
		$this->batch_no->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_batch_no"));

		// unit
		if (!$this->isAddOrEdit())
			$this->unit->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_unit"));
		$this->unit->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_unit"));

		// mil
		if (!$this->isAddOrEdit())
			$this->mil->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_mil"));
		$this->mil->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_mil"));

		// req_material_qty
		if (!$this->isAddOrEdit())
			$this->req_material_qty->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_req_material_qty"));
		$this->req_material_qty->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_req_material_qty"));

		// po_s_pending
		if (!$this->isAddOrEdit())
			$this->po_s_pending->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_s_pending"));
		$this->po_s_pending->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_s_pending"));

		// po_pending_wbc
		if (!$this->isAddOrEdit())
			$this->po_pending_wbc->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_pending_wbc"));
		$this->po_pending_wbc->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_pending_wbc"));

		// not_loomcard
		if (!$this->isAddOrEdit())
			$this->not_loomcard->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_not_loomcard"));
		$this->not_loomcard->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_not_loomcard"));

		// stock
		if (!$this->isAddOrEdit())
			$this->stock->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_stock"));
		$this->stock->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_stock"));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_company_id"));
		$this->company_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_company_id"));

		// last_supplier_id
		if (!$this->isAddOrEdit())
			$this->last_supplier_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_last_supplier_id"));
		$this->last_supplier_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_last_supplier_id"));

		// internal_external
		if (!$this->isAddOrEdit())
			$this->internal_external->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_internal_external"));
		$this->internal_external->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_internal_external"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->pending->FormValue == $this->pending->CurrentValue && is_numeric(ConvertToFloatString($this->pending->CurrentValue)))
			$this->pending->CurrentValue = ConvertToFloatString($this->pending->CurrentValue);

		// Convert decimal values if posted back
		if ($this->mil->FormValue == $this->mil->CurrentValue && is_numeric(ConvertToFloatString($this->mil->CurrentValue)))
			$this->mil->CurrentValue = ConvertToFloatString($this->mil->CurrentValue);

		// Convert decimal values if posted back
		if ($this->req_material_qty->FormValue == $this->req_material_qty->CurrentValue && is_numeric(ConvertToFloatString($this->req_material_qty->CurrentValue)))
			$this->req_material_qty->CurrentValue = ConvertToFloatString($this->req_material_qty->CurrentValue);

		// Convert decimal values if posted back
		if ($this->po_s_pending->FormValue == $this->po_s_pending->CurrentValue && is_numeric(ConvertToFloatString($this->po_s_pending->CurrentValue)))
			$this->po_s_pending->CurrentValue = ConvertToFloatString($this->po_s_pending->CurrentValue);

		// Convert decimal values if posted back
		if ($this->po_pending_wbc->FormValue == $this->po_pending_wbc->CurrentValue && is_numeric(ConvertToFloatString($this->po_pending_wbc->CurrentValue)))
			$this->po_pending_wbc->CurrentValue = ConvertToFloatString($this->po_pending_wbc->CurrentValue);

		// Convert decimal values if posted back
		if ($this->not_loomcard->FormValue == $this->not_loomcard->CurrentValue && is_numeric(ConvertToFloatString($this->not_loomcard->CurrentValue)))
			$this->not_loomcard->CurrentValue = ConvertToFloatString($this->not_loomcard->CurrentValue);

		// Convert decimal values if posted back
		if ($this->stock->FormValue == $this->stock->CurrentValue && is_numeric(ConvertToFloatString($this->stock->CurrentValue)))
			$this->stock->CurrentValue = ConvertToFloatString($this->stock->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// pending
		// req_material_grp
		// req_material_sgrp
		// req_material_product
		// req_material_rid
		// req_material_packing
		// batch_no
		// unit
		// mil
		// req_material_qty
		// po_s_pending
		// po_pending_wbc
		// not_loomcard
		// stock
		// company_id
		// last_supplier_id
		// internal_external

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// pending
			$this->pending->ViewValue = $this->pending->CurrentValue;
			$this->pending->ViewValue = FormatNumber($this->pending->ViewValue, 2, -2, -2, -2);
			$this->pending->ViewCustomAttributes = "";

			// req_material_product
			$curVal = strval($this->req_material_product->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_product->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
				if ($this->req_material_product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_product->ViewValue = $this->req_material_product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_product->ViewValue = $this->req_material_product->CurrentValue;
					}
				}
			} else {
				$this->req_material_product->ViewValue = NULL;
			}
			$this->req_material_product->ViewCustomAttributes = "";

			// req_material_rid
			$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
			$curVal = strval($this->req_material_rid->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_rid->ViewValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->req_material_rid->ViewValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->ViewValue = $this->req_material_rid->CurrentValue;
					}
				}
			} else {
				$this->req_material_rid->ViewValue = NULL;
			}
			$this->req_material_rid->ViewCustomAttributes = "";

			// req_material_packing
			$curVal = strval($this->req_material_packing->CurrentValue);
			if ($curVal <> "") {
				$this->req_material_packing->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
				if ($this->req_material_packing->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_packing->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->req_material_packing->ViewValue = $this->req_material_packing->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_packing->ViewValue = $this->req_material_packing->CurrentValue;
					}
				}
			} else {
				$this->req_material_packing->ViewValue = NULL;
			}
			$this->req_material_packing->ViewCustomAttributes = "";

			// batch_no
			$curVal = strval($this->batch_no->CurrentValue);
			if ($curVal <> "") {
				$this->batch_no->ViewValue = $this->batch_no->lookupCacheOption($curVal);
				if ($this->batch_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->batch_no->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->batch_no->ViewValue = $this->batch_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
					}
				}
			} else {
				$this->batch_no->ViewValue = NULL;
			}
			$this->batch_no->ViewCustomAttributes = "";

			// unit
			$curVal = strval($this->unit->CurrentValue);
			if ($curVal <> "") {
				$this->unit->ViewValue = $this->unit->lookupCacheOption($curVal);
				if ($this->unit->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->unit->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->unit->ViewValue = $this->unit->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->unit->ViewValue = $this->unit->CurrentValue;
					}
				}
			} else {
				$this->unit->ViewValue = NULL;
			}
			$this->unit->ViewCustomAttributes = "";

			// mil
			$this->mil->ViewValue = $this->mil->CurrentValue;
			$this->mil->ViewValue = FormatNumber($this->mil->ViewValue, 2, -2, -2, -2);
			$this->mil->ViewCustomAttributes = "";

			// req_material_qty
			$this->req_material_qty->ViewValue = $this->req_material_qty->CurrentValue;
			$this->req_material_qty->ViewValue = FormatNumber($this->req_material_qty->ViewValue, 2, -2, -2, -2);
			$this->req_material_qty->ViewCustomAttributes = "";

			// po_s_pending
			$this->po_s_pending->ViewValue = $this->po_s_pending->CurrentValue;
			$this->po_s_pending->ViewValue = FormatNumber($this->po_s_pending->ViewValue, 2, -2, -2, -2);
			$this->po_s_pending->ViewCustomAttributes = "";

			// po_pending_wbc
			$this->po_pending_wbc->ViewValue = $this->po_pending_wbc->CurrentValue;
			$this->po_pending_wbc->ViewValue = FormatNumber($this->po_pending_wbc->ViewValue, 2, -2, -2, -2);
			$this->po_pending_wbc->ViewCustomAttributes = "";

			// not_loomcard
			$this->not_loomcard->ViewValue = $this->not_loomcard->CurrentValue;
			$this->not_loomcard->ViewValue = FormatNumber($this->not_loomcard->ViewValue, 2, -2, -2, -2);
			$this->not_loomcard->ViewCustomAttributes = "";

			// stock
			$this->stock->ViewValue = $this->stock->CurrentValue;
			$this->stock->ViewValue = FormatNumber($this->stock->ViewValue, 2, -2, -2, -2);
			$this->stock->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// last_supplier_id
			$this->last_supplier_id->ViewValue = $this->last_supplier_id->CurrentValue;
			$curVal = strval($this->last_supplier_id->CurrentValue);
			if ($curVal <> "") {
				$this->last_supplier_id->ViewValue = $this->last_supplier_id->lookupCacheOption($curVal);
				if ($this->last_supplier_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->last_supplier_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->last_supplier_id->ViewValue = $this->last_supplier_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->last_supplier_id->ViewValue = $this->last_supplier_id->CurrentValue;
					}
				}
			} else {
				$this->last_supplier_id->ViewValue = NULL;
			}
			$this->last_supplier_id->ViewCustomAttributes = "";

			// internal_external
			if (strval($this->internal_external->CurrentValue) <> "") {
				$this->internal_external->ViewValue = $this->internal_external->optionCaption($this->internal_external->CurrentValue);
			} else {
				$this->internal_external->ViewValue = NULL;
			}
			$this->internal_external->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// pending
			$this->pending->LinkCustomAttributes = "";
			$this->pending->HrefValue = "";
			$this->pending->TooltipValue = "";

			// req_material_product
			$this->req_material_product->LinkCustomAttributes = "";
			$this->req_material_product->HrefValue = "";
			$this->req_material_product->TooltipValue = "";

			// req_material_rid
			$this->req_material_rid->LinkCustomAttributes = "";
			if (!EmptyValue($this->req_material_rid->CurrentValue)) {
				$this->req_material_rid->HrefValue = "required_material_overall_tablelist.php?x_req_material_rid=" . $this->req_material_rid->CurrentValue; // Add prefix/suffix
				$this->req_material_rid->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->req_material_rid->HrefValue = FullUrl($this->req_material_rid->HrefValue, "href");
			} else {
				$this->req_material_rid->HrefValue = "";
			}
			$this->req_material_rid->TooltipValue = "";

			// req_material_packing
			$this->req_material_packing->LinkCustomAttributes = "";
			if (!EmptyValue($this->req_material_packing->CurrentValue)) {
				$this->req_material_packing->HrefValue = "required_material_overall_tablelist.php?x_req_material_rid=" . $this->req_material_packing->CurrentValue; // Add prefix/suffix
				$this->req_material_packing->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->req_material_packing->HrefValue = FullUrl($this->req_material_packing->HrefValue, "href");
			} else {
				$this->req_material_packing->HrefValue = "";
			}
			$this->req_material_packing->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->batch_no->CurrentValue)) {
				$this->batch_no->HrefValue = "batch_nolist.php?x_id=" . $this->batch_no->CurrentValue; // Add prefix/suffix
				$this->batch_no->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->batch_no->HrefValue = FullUrl($this->batch_no->HrefValue, "href");
			} else {
				$this->batch_no->HrefValue = "";
			}
			$this->batch_no->TooltipValue = "";

			// unit
			$this->unit->LinkCustomAttributes = "";
			$this->unit->HrefValue = "";
			$this->unit->TooltipValue = "";

			// mil
			$this->mil->LinkCustomAttributes = "";
			$this->mil->HrefValue = "";
			$this->mil->TooltipValue = "";

			// req_material_qty
			$this->req_material_qty->LinkCustomAttributes = "";
			$this->req_material_qty->HrefValue = "";
			$this->req_material_qty->TooltipValue = "";

			// po_s_pending
			$this->po_s_pending->LinkCustomAttributes = "";
			$this->po_s_pending->HrefValue = "";
			$this->po_s_pending->TooltipValue = "";

			// po_pending_wbc
			$this->po_pending_wbc->LinkCustomAttributes = "";
			$this->po_pending_wbc->HrefValue = "";
			$this->po_pending_wbc->TooltipValue = "";

			// not_loomcard
			$this->not_loomcard->LinkCustomAttributes = "";
			$this->not_loomcard->HrefValue = "";
			$this->not_loomcard->TooltipValue = "";

			// stock
			$this->stock->LinkCustomAttributes = "";
			$this->stock->HrefValue = "";
			$this->stock->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// last_supplier_id
			$this->last_supplier_id->LinkCustomAttributes = "";
			$this->last_supplier_id->HrefValue = "";
			$this->last_supplier_id->TooltipValue = "";

			// internal_external
			$this->internal_external->LinkCustomAttributes = "";
			$this->internal_external->HrefValue = "";
			$this->internal_external->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// pending
			$this->pending->EditAttrs["class"] = "form-control";
			$this->pending->EditCustomAttributes = "";
			$this->pending->EditValue = HtmlEncode($this->pending->AdvancedSearch->SearchValue);
			$this->pending->PlaceHolder = RemoveHtml($this->pending->caption());
			$this->pending->EditAttrs["class"] = "form-control";
			$this->pending->EditCustomAttributes = "";
			$this->pending->EditValue2 = HtmlEncode($this->pending->AdvancedSearch->SearchValue2);
			$this->pending->PlaceHolder = RemoveHtml($this->pending->caption());

			// req_material_product
			$this->req_material_product->EditAttrs["class"] = "form-control";
			$this->req_material_product->EditCustomAttributes = "";
			$curVal = trim(strval($this->req_material_product->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->req_material_product->AdvancedSearch->ViewValue = $this->req_material_product->lookupCacheOption($curVal);
			else
				$this->req_material_product->AdvancedSearch->ViewValue = $this->req_material_product->Lookup !== NULL && is_array($this->req_material_product->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_product->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->req_material_product->EditValue = array_values($this->req_material_product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_product->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_product->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_product->EditValue = $arwrk;
			}

			// req_material_rid
			$this->req_material_rid->EditAttrs["class"] = "form-control";
			$this->req_material_rid->EditCustomAttributes = "";
			$this->req_material_rid->EditValue = HtmlEncode($this->req_material_rid->AdvancedSearch->SearchValue);
			$curVal = strval($this->req_material_rid->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->req_material_rid->EditValue = $this->req_material_rid->lookupCacheOption($curVal);
				if ($this->req_material_rid->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->req_material_rid->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->req_material_rid->EditValue = $this->req_material_rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->req_material_rid->EditValue = HtmlEncode($this->req_material_rid->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->req_material_rid->EditValue = NULL;
			}
			$this->req_material_rid->PlaceHolder = RemoveHtml($this->req_material_rid->caption());

			// req_material_packing
			$this->req_material_packing->EditAttrs["class"] = "form-control";
			$this->req_material_packing->EditCustomAttributes = "";
			$curVal = trim(strval($this->req_material_packing->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->lookupCacheOption($curVal);
			else
				$this->req_material_packing->AdvancedSearch->ViewValue = $this->req_material_packing->Lookup !== NULL && is_array($this->req_material_packing->Lookup->Options) ? $curVal : NULL;
			if ($this->req_material_packing->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->req_material_packing->EditValue = array_values($this->req_material_packing->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->req_material_packing->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->req_material_packing->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->req_material_packing->EditValue = $arwrk;
			}

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->AdvancedSearch->ViewValue = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->batch_no->EditValue = array_values($this->batch_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue = $arwrk;
			}
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->batch_no->AdvancedSearch->SearchValue2));
			if ($curVal <> "")
				$this->batch_no->AdvancedSearch->ViewValue2 = $this->batch_no->lookupCacheOption($curVal);
			else
				$this->batch_no->AdvancedSearch->ViewValue2 = $this->batch_no->Lookup !== NULL && is_array($this->batch_no->Lookup->Options) ? $curVal : NULL;
			if ($this->batch_no->AdvancedSearch->ViewValue2 !== NULL) { // Load from cache
				$this->batch_no->EditValue2 = array_values($this->batch_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->batch_no->AdvancedSearch->SearchValue2, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->batch_no->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->batch_no->EditValue2 = $arwrk;
			}

			// unit
			$this->unit->EditAttrs["class"] = "form-control";
			$this->unit->EditCustomAttributes = "";
			$curVal = trim(strval($this->unit->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->unit->AdvancedSearch->ViewValue = $this->unit->lookupCacheOption($curVal);
			else
				$this->unit->AdvancedSearch->ViewValue = $this->unit->Lookup !== NULL && is_array($this->unit->Lookup->Options) ? $curVal : NULL;
			if ($this->unit->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->unit->EditValue = array_values($this->unit->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->unit->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->unit->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->unit->EditValue = $arwrk;
			}

			// mil
			$this->mil->EditAttrs["class"] = "form-control";
			$this->mil->EditCustomAttributes = "";
			$this->mil->EditValue = HtmlEncode($this->mil->AdvancedSearch->SearchValue);
			$this->mil->PlaceHolder = RemoveHtml($this->mil->caption());

			// req_material_qty
			$this->req_material_qty->EditAttrs["class"] = "form-control";
			$this->req_material_qty->EditCustomAttributes = "";
			$this->req_material_qty->EditValue = HtmlEncode($this->req_material_qty->AdvancedSearch->SearchValue);
			$this->req_material_qty->PlaceHolder = RemoveHtml($this->req_material_qty->caption());

			// po_s_pending
			$this->po_s_pending->EditAttrs["class"] = "form-control";
			$this->po_s_pending->EditCustomAttributes = "";
			$this->po_s_pending->EditValue = HtmlEncode($this->po_s_pending->AdvancedSearch->SearchValue);
			$this->po_s_pending->PlaceHolder = RemoveHtml($this->po_s_pending->caption());

			// po_pending_wbc
			$this->po_pending_wbc->EditAttrs["class"] = "form-control";
			$this->po_pending_wbc->EditCustomAttributes = "";
			$this->po_pending_wbc->EditValue = HtmlEncode($this->po_pending_wbc->AdvancedSearch->SearchValue);
			$this->po_pending_wbc->PlaceHolder = RemoveHtml($this->po_pending_wbc->caption());

			// not_loomcard
			$this->not_loomcard->EditAttrs["class"] = "form-control";
			$this->not_loomcard->EditCustomAttributes = "";
			$this->not_loomcard->EditValue = HtmlEncode($this->not_loomcard->AdvancedSearch->SearchValue);
			$this->not_loomcard->PlaceHolder = RemoveHtml($this->not_loomcard->caption());

			// stock
			$this->stock->EditAttrs["class"] = "form-control";
			$this->stock->EditCustomAttributes = "";
			$this->stock->EditValue = HtmlEncode($this->stock->AdvancedSearch->SearchValue);
			$this->stock->PlaceHolder = RemoveHtml($this->stock->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// last_supplier_id
			$this->last_supplier_id->EditAttrs["class"] = "form-control";
			$this->last_supplier_id->EditCustomAttributes = "";
			$this->last_supplier_id->EditValue = HtmlEncode($this->last_supplier_id->AdvancedSearch->SearchValue);
			$curVal = strval($this->last_supplier_id->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->last_supplier_id->EditValue = $this->last_supplier_id->lookupCacheOption($curVal);
				if ($this->last_supplier_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->last_supplier_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->last_supplier_id->EditValue = $this->last_supplier_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->last_supplier_id->EditValue = HtmlEncode($this->last_supplier_id->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->last_supplier_id->EditValue = NULL;
			}
			$this->last_supplier_id->PlaceHolder = RemoveHtml($this->last_supplier_id->caption());

			// internal_external
			$this->internal_external->EditAttrs["class"] = "form-control";
			$this->internal_external->EditCustomAttributes = "";
			$this->internal_external->EditValue = $this->internal_external->options(TRUE);
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckNumber($this->pending->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pending->errorMessage());
		}
		if (!CheckNumber($this->pending->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->pending->errorMessage());
		}
		if (!CheckInteger($this->req_material_rid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->req_material_rid->errorMessage());
		}
		if (!CheckNumber($this->mil->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->mil->errorMessage());
		}
		if (!CheckNumber($this->req_material_qty->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->req_material_qty->errorMessage());
		}
		if (!CheckNumber($this->po_s_pending->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po_s_pending->errorMessage());
		}
		if (!CheckNumber($this->po_pending_wbc->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->po_pending_wbc->errorMessage());
		}
		if (!CheckNumber($this->not_loomcard->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->not_loomcard->errorMessage());
		}
		if (!CheckNumber($this->stock->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->stock->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->pending->AdvancedSearch->load();
		$this->req_material_grp->AdvancedSearch->load();
		$this->req_material_product->AdvancedSearch->load();
		$this->req_material_rid->AdvancedSearch->load();
		$this->req_material_packing->AdvancedSearch->load();
		$this->batch_no->AdvancedSearch->load();
		$this->unit->AdvancedSearch->load();
		$this->mil->AdvancedSearch->load();
		$this->req_material_qty->AdvancedSearch->load();
		$this->po_s_pending->AdvancedSearch->load();
		$this->po_pending_wbc->AdvancedSearch->load();
		$this->not_loomcard->AdvancedSearch->load();
		$this->stock->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->last_supplier_id->AdvancedSearch->load();
		$this->internal_external->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("required_material_overall_tablelist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_req_material_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_sgrp":
					$lookupFilter = function() {
						return "`status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_product":
					$lookupFilter = function() {
						return "`status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_rid":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_req_material_packing":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_batch_no":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_company_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_last_supplier_id":
					$lookupFilter = function() {
						return "`partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_req_material_grp":
							break;
						case "x_req_material_sgrp":
							break;
						case "x_req_material_product":
							break;
						case "x_req_material_rid":
							break;
						case "x_req_material_packing":
							break;
						case "x_batch_no":
							break;
						case "x_unit":
							break;
						case "x_company_id":
							break;
						case "x_last_supplier_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>