<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class s_eval_scheme_add extends s_eval_scheme
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 's_eval_scheme';

	// Page object name
	public $PageObjName = "s_eval_scheme_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (s_eval_scheme)
		if (!isset($GLOBALS["s_eval_scheme"]) || get_class($GLOBALS["s_eval_scheme"]) == PROJECT_NAMESPACE . "s_eval_scheme") {
			$GLOBALS["s_eval_scheme"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["s_eval_scheme"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 's_eval_scheme');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $s_eval_scheme;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($s_eval_scheme);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "s_eval_schemeview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("s_eval_schemelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->description->setVisibility();
		$this->test_id->setVisibility();
		$this->sec->setVisibility();
		$this->no_start_end->setVisibility();
		$this->to_attempt->setVisibility();
		$this->marks->setVisibility();
		$this->n_marks->setVisibility();
		$this->t_marks->Visible = FALSE;
		$this->answer_key->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("s_eval_schemelist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "s_eval_schemelist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "s_eval_schemeview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->description->CurrentValue = NULL;
		$this->description->OldValue = $this->description->CurrentValue;
		$this->test_id->CurrentValue = NULL;
		$this->test_id->OldValue = $this->test_id->CurrentValue;
		$this->sec->CurrentValue = NULL;
		$this->sec->OldValue = $this->sec->CurrentValue;
		$this->no_start_end->CurrentValue = NULL;
		$this->no_start_end->OldValue = $this->no_start_end->CurrentValue;
		$this->to_attempt->CurrentValue = NULL;
		$this->to_attempt->OldValue = $this->to_attempt->CurrentValue;
		$this->marks->CurrentValue = NULL;
		$this->marks->OldValue = $this->marks->CurrentValue;
		$this->n_marks->CurrentValue = NULL;
		$this->n_marks->OldValue = $this->n_marks->CurrentValue;
		$this->t_marks->CurrentValue = NULL;
		$this->t_marks->OldValue = $this->t_marks->CurrentValue;
		$this->answer_key->CurrentValue = NULL;
		$this->answer_key->OldValue = $this->answer_key->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'description' first before field var 'x_description'
		$val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
		if (!$this->description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description->Visible = FALSE; // Disable update for API request
			else
				$this->description->setFormValue($val);
		}

		// Check field name 'test_id' first before field var 'x_test_id'
		$val = $CurrentForm->hasValue("test_id") ? $CurrentForm->getValue("test_id") : $CurrentForm->getValue("x_test_id");
		if (!$this->test_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->test_id->Visible = FALSE; // Disable update for API request
			else
				$this->test_id->setFormValue($val);
		}

		// Check field name 'sec' first before field var 'x_sec'
		$val = $CurrentForm->hasValue("sec") ? $CurrentForm->getValue("sec") : $CurrentForm->getValue("x_sec");
		if (!$this->sec->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sec->Visible = FALSE; // Disable update for API request
			else
				$this->sec->setFormValue($val);
		}

		// Check field name 'no_start_end' first before field var 'x_no_start_end'
		$val = $CurrentForm->hasValue("no_start_end") ? $CurrentForm->getValue("no_start_end") : $CurrentForm->getValue("x_no_start_end");
		if (!$this->no_start_end->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->no_start_end->Visible = FALSE; // Disable update for API request
			else
				$this->no_start_end->setFormValue($val);
		}

		// Check field name 'to_attempt' first before field var 'x_to_attempt'
		$val = $CurrentForm->hasValue("to_attempt") ? $CurrentForm->getValue("to_attempt") : $CurrentForm->getValue("x_to_attempt");
		if (!$this->to_attempt->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->to_attempt->Visible = FALSE; // Disable update for API request
			else
				$this->to_attempt->setFormValue($val);
		}

		// Check field name 'marks' first before field var 'x_marks'
		$val = $CurrentForm->hasValue("marks") ? $CurrentForm->getValue("marks") : $CurrentForm->getValue("x_marks");
		if (!$this->marks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->marks->Visible = FALSE; // Disable update for API request
			else
				$this->marks->setFormValue($val);
		}

		// Check field name 'n_marks' first before field var 'x_n_marks'
		$val = $CurrentForm->hasValue("n_marks") ? $CurrentForm->getValue("n_marks") : $CurrentForm->getValue("x_n_marks");
		if (!$this->n_marks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->n_marks->Visible = FALSE; // Disable update for API request
			else
				$this->n_marks->setFormValue($val);
		}

		// Check field name 'answer_key' first before field var 'x_answer_key'
		$val = $CurrentForm->hasValue("answer_key") ? $CurrentForm->getValue("answer_key") : $CurrentForm->getValue("x_answer_key");
		if (!$this->answer_key->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->answer_key->Visible = FALSE; // Disable update for API request
			else
				$this->answer_key->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->description->CurrentValue = $this->description->FormValue;
		$this->test_id->CurrentValue = $this->test_id->FormValue;
		$this->sec->CurrentValue = $this->sec->FormValue;
		$this->no_start_end->CurrentValue = $this->no_start_end->FormValue;
		$this->to_attempt->CurrentValue = $this->to_attempt->FormValue;
		$this->marks->CurrentValue = $this->marks->FormValue;
		$this->n_marks->CurrentValue = $this->n_marks->FormValue;
		$this->answer_key->CurrentValue = $this->answer_key->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->description->setDbValue($row['description']);
		$this->test_id->setDbValue($row['test_id']);
		$this->sec->setDbValue($row['sec']);
		$this->no_start_end->setDbValue($row['no_start_end']);
		$this->to_attempt->setDbValue($row['to_attempt']);
		$this->marks->setDbValue($row['marks']);
		$this->n_marks->setDbValue($row['n_marks']);
		$this->t_marks->setDbValue($row['t_marks']);
		$this->answer_key->setDbValue($row['answer_key']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['description'] = $this->description->CurrentValue;
		$row['test_id'] = $this->test_id->CurrentValue;
		$row['sec'] = $this->sec->CurrentValue;
		$row['no_start_end'] = $this->no_start_end->CurrentValue;
		$row['to_attempt'] = $this->to_attempt->CurrentValue;
		$row['marks'] = $this->marks->CurrentValue;
		$row['n_marks'] = $this->n_marks->CurrentValue;
		$row['t_marks'] = $this->t_marks->CurrentValue;
		$row['answer_key'] = $this->answer_key->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->marks->FormValue == $this->marks->CurrentValue && is_numeric(ConvertToFloatString($this->marks->CurrentValue)))
			$this->marks->CurrentValue = ConvertToFloatString($this->marks->CurrentValue);

		// Convert decimal values if posted back
		if ($this->n_marks->FormValue == $this->n_marks->CurrentValue && is_numeric(ConvertToFloatString($this->n_marks->CurrentValue)))
			$this->n_marks->CurrentValue = ConvertToFloatString($this->n_marks->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// description
		// test_id
		// sec
		// no_start_end
		// to_attempt
		// marks
		// n_marks
		// t_marks
		// answer_key
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// test_id
			$this->test_id->ViewValue = $this->test_id->CurrentValue;
			$this->test_id->ViewCustomAttributes = "";

			// sec
			if (strval($this->sec->CurrentValue) <> "") {
				$this->sec->ViewValue = $this->sec->optionCaption($this->sec->CurrentValue);
			} else {
				$this->sec->ViewValue = NULL;
			}
			$this->sec->ViewCustomAttributes = "";

			// no_start_end
			$this->no_start_end->ViewValue = $this->no_start_end->CurrentValue;
			$this->no_start_end->ViewCustomAttributes = "";

			// to_attempt
			$this->to_attempt->ViewValue = $this->to_attempt->CurrentValue;
			$this->to_attempt->ViewValue = FormatNumber($this->to_attempt->ViewValue, 0, -2, -2, -2);
			$this->to_attempt->ViewCustomAttributes = "";

			// marks
			$this->marks->ViewValue = $this->marks->CurrentValue;
			$this->marks->ViewValue = FormatNumber($this->marks->ViewValue, 2, -2, -2, -2);
			$this->marks->ViewCustomAttributes = "";

			// n_marks
			$this->n_marks->ViewValue = $this->n_marks->CurrentValue;
			$this->n_marks->ViewValue = FormatNumber($this->n_marks->ViewValue, 2, -2, -2, -2);
			$this->n_marks->ViewCustomAttributes = "";

			// t_marks
			$this->t_marks->ViewValue = $this->t_marks->CurrentValue;
			$this->t_marks->ViewValue = FormatNumber($this->t_marks->ViewValue, 2, -2, -2, -2);
			$this->t_marks->ViewCustomAttributes = "";

			// answer_key
			$this->answer_key->ViewValue = $this->answer_key->CurrentValue;
			$this->answer_key->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// test_id
			$this->test_id->LinkCustomAttributes = "";
			$this->test_id->HrefValue = "";
			$this->test_id->TooltipValue = "";

			// sec
			$this->sec->LinkCustomAttributes = "";
			$this->sec->HrefValue = "";
			$this->sec->TooltipValue = "";

			// no_start_end
			$this->no_start_end->LinkCustomAttributes = "";
			$this->no_start_end->HrefValue = "";
			$this->no_start_end->TooltipValue = "";

			// to_attempt
			$this->to_attempt->LinkCustomAttributes = "";
			$this->to_attempt->HrefValue = "";
			$this->to_attempt->TooltipValue = "";

			// marks
			$this->marks->LinkCustomAttributes = "";
			$this->marks->HrefValue = "";
			$this->marks->TooltipValue = "";

			// n_marks
			$this->n_marks->LinkCustomAttributes = "";
			$this->n_marks->HrefValue = "";
			$this->n_marks->TooltipValue = "";

			// answer_key
			$this->answer_key->LinkCustomAttributes = "";
			$this->answer_key->HrefValue = "";
			$this->answer_key->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// description
			$this->description->EditAttrs["class"] = "form-control";
			$this->description->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->description->CurrentValue = HtmlDecode($this->description->CurrentValue);
			$this->description->EditValue = HtmlEncode($this->description->CurrentValue);
			$this->description->PlaceHolder = RemoveHtml($this->description->caption());

			// test_id
			$this->test_id->EditAttrs["class"] = "form-control";
			$this->test_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->test_id->CurrentValue = HtmlDecode($this->test_id->CurrentValue);
			$this->test_id->EditValue = HtmlEncode($this->test_id->CurrentValue);
			$this->test_id->PlaceHolder = RemoveHtml($this->test_id->caption());

			// sec
			$this->sec->EditAttrs["class"] = "form-control";
			$this->sec->EditCustomAttributes = "";
			$this->sec->EditValue = $this->sec->options(TRUE);

			// no_start_end
			$this->no_start_end->EditAttrs["class"] = "form-control";
			$this->no_start_end->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->no_start_end->CurrentValue = HtmlDecode($this->no_start_end->CurrentValue);
			$this->no_start_end->EditValue = HtmlEncode($this->no_start_end->CurrentValue);
			$this->no_start_end->PlaceHolder = RemoveHtml($this->no_start_end->caption());

			// to_attempt
			$this->to_attempt->EditAttrs["class"] = "form-control";
			$this->to_attempt->EditCustomAttributes = "";
			$this->to_attempt->EditValue = HtmlEncode($this->to_attempt->CurrentValue);
			$this->to_attempt->PlaceHolder = RemoveHtml($this->to_attempt->caption());

			// marks
			$this->marks->EditAttrs["class"] = "form-control";
			$this->marks->EditCustomAttributes = "";
			$this->marks->EditValue = HtmlEncode($this->marks->CurrentValue);
			$this->marks->PlaceHolder = RemoveHtml($this->marks->caption());
			if (strval($this->marks->EditValue) <> "" && is_numeric($this->marks->EditValue))
				$this->marks->EditValue = FormatNumber($this->marks->EditValue, -2, -2, -2, -2);

			// n_marks
			$this->n_marks->EditAttrs["class"] = "form-control";
			$this->n_marks->EditCustomAttributes = "";
			$this->n_marks->EditValue = HtmlEncode($this->n_marks->CurrentValue);
			$this->n_marks->PlaceHolder = RemoveHtml($this->n_marks->caption());
			if (strval($this->n_marks->EditValue) <> "" && is_numeric($this->n_marks->EditValue))
				$this->n_marks->EditValue = FormatNumber($this->n_marks->EditValue, -2, -2, -2, -2);

			// answer_key
			$this->answer_key->EditAttrs["class"] = "form-control";
			$this->answer_key->EditCustomAttributes = "";
			$this->answer_key->EditValue = HtmlEncode($this->answer_key->CurrentValue);
			$this->answer_key->PlaceHolder = RemoveHtml($this->answer_key->caption());

			// operator
			// datetime
			// Add refer script
			// description

			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";

			// test_id
			$this->test_id->LinkCustomAttributes = "";
			$this->test_id->HrefValue = "";

			// sec
			$this->sec->LinkCustomAttributes = "";
			$this->sec->HrefValue = "";

			// no_start_end
			$this->no_start_end->LinkCustomAttributes = "";
			$this->no_start_end->HrefValue = "";

			// to_attempt
			$this->to_attempt->LinkCustomAttributes = "";
			$this->to_attempt->HrefValue = "";

			// marks
			$this->marks->LinkCustomAttributes = "";
			$this->marks->HrefValue = "";

			// n_marks
			$this->n_marks->LinkCustomAttributes = "";
			$this->n_marks->HrefValue = "";

			// answer_key
			$this->answer_key->LinkCustomAttributes = "";
			$this->answer_key->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->description->Required) {
			if (!$this->description->IsDetailKey && $this->description->FormValue != NULL && $this->description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
			}
		}
		if ($this->test_id->Required) {
			if (!$this->test_id->IsDetailKey && $this->test_id->FormValue != NULL && $this->test_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->test_id->caption(), $this->test_id->RequiredErrorMessage));
			}
		}
		if ($this->sec->Required) {
			if (!$this->sec->IsDetailKey && $this->sec->FormValue != NULL && $this->sec->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sec->caption(), $this->sec->RequiredErrorMessage));
			}
		}
		if ($this->no_start_end->Required) {
			if (!$this->no_start_end->IsDetailKey && $this->no_start_end->FormValue != NULL && $this->no_start_end->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->no_start_end->caption(), $this->no_start_end->RequiredErrorMessage));
			}
		}
		if ($this->to_attempt->Required) {
			if (!$this->to_attempt->IsDetailKey && $this->to_attempt->FormValue != NULL && $this->to_attempt->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->to_attempt->caption(), $this->to_attempt->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->to_attempt->FormValue)) {
			AddMessage($FormError, $this->to_attempt->errorMessage());
		}
		if ($this->marks->Required) {
			if (!$this->marks->IsDetailKey && $this->marks->FormValue != NULL && $this->marks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->marks->caption(), $this->marks->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->marks->FormValue)) {
			AddMessage($FormError, $this->marks->errorMessage());
		}
		if ($this->n_marks->Required) {
			if (!$this->n_marks->IsDetailKey && $this->n_marks->FormValue != NULL && $this->n_marks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->n_marks->caption(), $this->n_marks->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->n_marks->FormValue)) {
			AddMessage($FormError, $this->n_marks->errorMessage());
		}
		if ($this->t_marks->Required) {
			if (!$this->t_marks->IsDetailKey && $this->t_marks->FormValue != NULL && $this->t_marks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->t_marks->caption(), $this->t_marks->RequiredErrorMessage));
			}
		}
		if ($this->answer_key->Required) {
			if (!$this->answer_key->IsDetailKey && $this->answer_key->FormValue != NULL && $this->answer_key->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->answer_key->caption(), $this->answer_key->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// description
		$this->description->setDbValueDef($rsnew, $this->description->CurrentValue, "", FALSE);

		// test_id
		$this->test_id->setDbValueDef($rsnew, $this->test_id->CurrentValue, "", FALSE);

		// sec
		$this->sec->setDbValueDef($rsnew, $this->sec->CurrentValue, NULL, FALSE);

		// no_start_end
		$this->no_start_end->setDbValueDef($rsnew, $this->no_start_end->CurrentValue, NULL, FALSE);

		// to_attempt
		$this->to_attempt->setDbValueDef($rsnew, $this->to_attempt->CurrentValue, NULL, FALSE);

		// marks
		$this->marks->setDbValueDef($rsnew, $this->marks->CurrentValue, NULL, FALSE);

		// n_marks
		$this->n_marks->setDbValueDef($rsnew, $this->n_marks->CurrentValue, NULL, FALSE);

		// answer_key
		$this->answer_key->setDbValueDef($rsnew, $this->answer_key->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("s_eval_schemelist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>