<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class s_omr_value_edit extends s_omr_value
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 's_omr_value';

	// Page object name
	public $PageObjName = "s_omr_value_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (s_omr_value)
		if (!isset($GLOBALS["s_omr_value"]) || get_class($GLOBALS["s_omr_value"]) == PROJECT_NAMESPACE . "s_omr_value") {
			$GLOBALS["s_omr_value"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["s_omr_value"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 's_omr_value');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $s_omr_value;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($s_omr_value);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "s_omr_valueview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("s_omr_valuelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->roll_no->setVisibility();
		$this->test_id->setVisibility();
		$this->total->setVisibility();
		$this->percent->setVisibility();
		$this->s_1->setVisibility();
		$this->s_2->setVisibility();
		$this->s_3->setVisibility();
		$this->s_4->setVisibility();
		$this->s_5->setVisibility();
		$this->omr_image->setVisibility();
		$this->_1->setVisibility();
		$this->m_1->setVisibility();
		$this->_2->setVisibility();
		$this->m_2->setVisibility();
		$this->_3->setVisibility();
		$this->m_3->setVisibility();
		$this->_4->setVisibility();
		$this->m_4->setVisibility();
		$this->_5->setVisibility();
		$this->m_5->setVisibility();
		$this->_6->setVisibility();
		$this->m_6->setVisibility();
		$this->_7->setVisibility();
		$this->m_7->setVisibility();
		$this->_8->setVisibility();
		$this->m_8->setVisibility();
		$this->_9->setVisibility();
		$this->m_9->setVisibility();
		$this->_10->setVisibility();
		$this->m_10->setVisibility();
		$this->_11->setVisibility();
		$this->m_11->setVisibility();
		$this->_12->setVisibility();
		$this->m_12->setVisibility();
		$this->_13->setVisibility();
		$this->m_13->setVisibility();
		$this->_14->setVisibility();
		$this->m_14->setVisibility();
		$this->_15->setVisibility();
		$this->m_15->setVisibility();
		$this->_16->setVisibility();
		$this->m_16->setVisibility();
		$this->_17->setVisibility();
		$this->m_17->setVisibility();
		$this->_18->setVisibility();
		$this->m_18->setVisibility();
		$this->_19->setVisibility();
		$this->m_19->setVisibility();
		$this->_20->setVisibility();
		$this->m_20->setVisibility();
		$this->_21->setVisibility();
		$this->m_21->setVisibility();
		$this->_22->setVisibility();
		$this->m_22->setVisibility();
		$this->_23->setVisibility();
		$this->m_23->setVisibility();
		$this->_24->setVisibility();
		$this->m_24->setVisibility();
		$this->_25->setVisibility();
		$this->m_25->setVisibility();
		$this->_26->setVisibility();
		$this->m_26->setVisibility();
		$this->_27->setVisibility();
		$this->m_27->setVisibility();
		$this->_28->setVisibility();
		$this->m_28->setVisibility();
		$this->_29->setVisibility();
		$this->m_29->setVisibility();
		$this->_30->setVisibility();
		$this->m_30->setVisibility();
		$this->_31->setVisibility();
		$this->m_31->setVisibility();
		$this->_32->setVisibility();
		$this->m_32->setVisibility();
		$this->_33->setVisibility();
		$this->m_33->setVisibility();
		$this->_34->setVisibility();
		$this->m_34->setVisibility();
		$this->_35->setVisibility();
		$this->m_35->setVisibility();
		$this->_36->setVisibility();
		$this->m_36->setVisibility();
		$this->_37->setVisibility();
		$this->m_37->setVisibility();
		$this->_38->setVisibility();
		$this->m_38->setVisibility();
		$this->_39->setVisibility();
		$this->m_39->setVisibility();
		$this->_40->setVisibility();
		$this->m_40->setVisibility();
		$this->_41->setVisibility();
		$this->m_41->setVisibility();
		$this->_42->setVisibility();
		$this->m_42->setVisibility();
		$this->_43->setVisibility();
		$this->m_43->setVisibility();
		$this->_44->setVisibility();
		$this->m_44->setVisibility();
		$this->_45->setVisibility();
		$this->m_45->setVisibility();
		$this->_46->setVisibility();
		$this->m_46->setVisibility();
		$this->_47->setVisibility();
		$this->m_47->setVisibility();
		$this->_48->setVisibility();
		$this->m_48->setVisibility();
		$this->_49->setVisibility();
		$this->m_49->setVisibility();
		$this->_50->setVisibility();
		$this->m_50->setVisibility();
		$this->_51->setVisibility();
		$this->m_51->setVisibility();
		$this->_52->setVisibility();
		$this->m_52->setVisibility();
		$this->_53->setVisibility();
		$this->m_53->setVisibility();
		$this->_54->setVisibility();
		$this->m_54->setVisibility();
		$this->_55->setVisibility();
		$this->m_55->setVisibility();
		$this->_56->setVisibility();
		$this->m_56->setVisibility();
		$this->_57->setVisibility();
		$this->m_57->setVisibility();
		$this->_58->setVisibility();
		$this->m_58->setVisibility();
		$this->_59->setVisibility();
		$this->m_59->setVisibility();
		$this->_60->setVisibility();
		$this->m_60->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("s_omr_valuelist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "s_omr_valuelist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->omr_image->Upload->Index = $CurrentForm->Index;
		$this->omr_image->Upload->uploadFile();
		$this->omr_image->CurrentValue = $this->omr_image->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'roll_no' first before field var 'x_roll_no'
		$val = $CurrentForm->hasValue("roll_no") ? $CurrentForm->getValue("roll_no") : $CurrentForm->getValue("x_roll_no");
		if (!$this->roll_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->roll_no->Visible = FALSE; // Disable update for API request
			else
				$this->roll_no->setFormValue($val);
		}

		// Check field name 'test_id' first before field var 'x_test_id'
		$val = $CurrentForm->hasValue("test_id") ? $CurrentForm->getValue("test_id") : $CurrentForm->getValue("x_test_id");
		if (!$this->test_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->test_id->Visible = FALSE; // Disable update for API request
			else
				$this->test_id->setFormValue($val);
		}

		// Check field name 'total' first before field var 'x_total'
		$val = $CurrentForm->hasValue("total") ? $CurrentForm->getValue("total") : $CurrentForm->getValue("x_total");
		if (!$this->total->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->total->Visible = FALSE; // Disable update for API request
			else
				$this->total->setFormValue($val);
		}

		// Check field name 'percent' first before field var 'x_percent'
		$val = $CurrentForm->hasValue("percent") ? $CurrentForm->getValue("percent") : $CurrentForm->getValue("x_percent");
		if (!$this->percent->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->percent->Visible = FALSE; // Disable update for API request
			else
				$this->percent->setFormValue($val);
		}

		// Check field name 's_1' first before field var 'x_s_1'
		$val = $CurrentForm->hasValue("s_1") ? $CurrentForm->getValue("s_1") : $CurrentForm->getValue("x_s_1");
		if (!$this->s_1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_1->Visible = FALSE; // Disable update for API request
			else
				$this->s_1->setFormValue($val);
		}

		// Check field name 's_2' first before field var 'x_s_2'
		$val = $CurrentForm->hasValue("s_2") ? $CurrentForm->getValue("s_2") : $CurrentForm->getValue("x_s_2");
		if (!$this->s_2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_2->Visible = FALSE; // Disable update for API request
			else
				$this->s_2->setFormValue($val);
		}

		// Check field name 's_3' first before field var 'x_s_3'
		$val = $CurrentForm->hasValue("s_3") ? $CurrentForm->getValue("s_3") : $CurrentForm->getValue("x_s_3");
		if (!$this->s_3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_3->Visible = FALSE; // Disable update for API request
			else
				$this->s_3->setFormValue($val);
		}

		// Check field name 's_4' first before field var 'x_s_4'
		$val = $CurrentForm->hasValue("s_4") ? $CurrentForm->getValue("s_4") : $CurrentForm->getValue("x_s_4");
		if (!$this->s_4->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_4->Visible = FALSE; // Disable update for API request
			else
				$this->s_4->setFormValue($val);
		}

		// Check field name 's_5' first before field var 'x_s_5'
		$val = $CurrentForm->hasValue("s_5") ? $CurrentForm->getValue("s_5") : $CurrentForm->getValue("x_s_5");
		if (!$this->s_5->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->s_5->Visible = FALSE; // Disable update for API request
			else
				$this->s_5->setFormValue($val);
		}

		// Check field name '1' first before field var 'x__1'
		$val = $CurrentForm->hasValue("1") ? $CurrentForm->getValue("1") : $CurrentForm->getValue("x__1");
		if (!$this->_1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_1->Visible = FALSE; // Disable update for API request
			else
				$this->_1->setFormValue($val);
		}

		// Check field name 'm_1' first before field var 'x_m_1'
		$val = $CurrentForm->hasValue("m_1") ? $CurrentForm->getValue("m_1") : $CurrentForm->getValue("x_m_1");
		if (!$this->m_1->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_1->Visible = FALSE; // Disable update for API request
			else
				$this->m_1->setFormValue($val);
		}

		// Check field name '2' first before field var 'x__2'
		$val = $CurrentForm->hasValue("2") ? $CurrentForm->getValue("2") : $CurrentForm->getValue("x__2");
		if (!$this->_2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_2->Visible = FALSE; // Disable update for API request
			else
				$this->_2->setFormValue($val);
		}

		// Check field name 'm_2' first before field var 'x_m_2'
		$val = $CurrentForm->hasValue("m_2") ? $CurrentForm->getValue("m_2") : $CurrentForm->getValue("x_m_2");
		if (!$this->m_2->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_2->Visible = FALSE; // Disable update for API request
			else
				$this->m_2->setFormValue($val);
		}

		// Check field name '3' first before field var 'x__3'
		$val = $CurrentForm->hasValue("3") ? $CurrentForm->getValue("3") : $CurrentForm->getValue("x__3");
		if (!$this->_3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_3->Visible = FALSE; // Disable update for API request
			else
				$this->_3->setFormValue($val);
		}

		// Check field name 'm_3' first before field var 'x_m_3'
		$val = $CurrentForm->hasValue("m_3") ? $CurrentForm->getValue("m_3") : $CurrentForm->getValue("x_m_3");
		if (!$this->m_3->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_3->Visible = FALSE; // Disable update for API request
			else
				$this->m_3->setFormValue($val);
		}

		// Check field name '4' first before field var 'x__4'
		$val = $CurrentForm->hasValue("4") ? $CurrentForm->getValue("4") : $CurrentForm->getValue("x__4");
		if (!$this->_4->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_4->Visible = FALSE; // Disable update for API request
			else
				$this->_4->setFormValue($val);
		}

		// Check field name 'm_4' first before field var 'x_m_4'
		$val = $CurrentForm->hasValue("m_4") ? $CurrentForm->getValue("m_4") : $CurrentForm->getValue("x_m_4");
		if (!$this->m_4->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_4->Visible = FALSE; // Disable update for API request
			else
				$this->m_4->setFormValue($val);
		}

		// Check field name '5' first before field var 'x__5'
		$val = $CurrentForm->hasValue("5") ? $CurrentForm->getValue("5") : $CurrentForm->getValue("x__5");
		if (!$this->_5->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_5->Visible = FALSE; // Disable update for API request
			else
				$this->_5->setFormValue($val);
		}

		// Check field name 'm_5' first before field var 'x_m_5'
		$val = $CurrentForm->hasValue("m_5") ? $CurrentForm->getValue("m_5") : $CurrentForm->getValue("x_m_5");
		if (!$this->m_5->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_5->Visible = FALSE; // Disable update for API request
			else
				$this->m_5->setFormValue($val);
		}

		// Check field name '6' first before field var 'x__6'
		$val = $CurrentForm->hasValue("6") ? $CurrentForm->getValue("6") : $CurrentForm->getValue("x__6");
		if (!$this->_6->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_6->Visible = FALSE; // Disable update for API request
			else
				$this->_6->setFormValue($val);
		}

		// Check field name 'm_6' first before field var 'x_m_6'
		$val = $CurrentForm->hasValue("m_6") ? $CurrentForm->getValue("m_6") : $CurrentForm->getValue("x_m_6");
		if (!$this->m_6->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_6->Visible = FALSE; // Disable update for API request
			else
				$this->m_6->setFormValue($val);
		}

		// Check field name '7' first before field var 'x__7'
		$val = $CurrentForm->hasValue("7") ? $CurrentForm->getValue("7") : $CurrentForm->getValue("x__7");
		if (!$this->_7->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_7->Visible = FALSE; // Disable update for API request
			else
				$this->_7->setFormValue($val);
		}

		// Check field name 'm_7' first before field var 'x_m_7'
		$val = $CurrentForm->hasValue("m_7") ? $CurrentForm->getValue("m_7") : $CurrentForm->getValue("x_m_7");
		if (!$this->m_7->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_7->Visible = FALSE; // Disable update for API request
			else
				$this->m_7->setFormValue($val);
		}

		// Check field name '8' first before field var 'x__8'
		$val = $CurrentForm->hasValue("8") ? $CurrentForm->getValue("8") : $CurrentForm->getValue("x__8");
		if (!$this->_8->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_8->Visible = FALSE; // Disable update for API request
			else
				$this->_8->setFormValue($val);
		}

		// Check field name 'm_8' first before field var 'x_m_8'
		$val = $CurrentForm->hasValue("m_8") ? $CurrentForm->getValue("m_8") : $CurrentForm->getValue("x_m_8");
		if (!$this->m_8->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_8->Visible = FALSE; // Disable update for API request
			else
				$this->m_8->setFormValue($val);
		}

		// Check field name '9' first before field var 'x__9'
		$val = $CurrentForm->hasValue("9") ? $CurrentForm->getValue("9") : $CurrentForm->getValue("x__9");
		if (!$this->_9->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_9->Visible = FALSE; // Disable update for API request
			else
				$this->_9->setFormValue($val);
		}

		// Check field name 'm_9' first before field var 'x_m_9'
		$val = $CurrentForm->hasValue("m_9") ? $CurrentForm->getValue("m_9") : $CurrentForm->getValue("x_m_9");
		if (!$this->m_9->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_9->Visible = FALSE; // Disable update for API request
			else
				$this->m_9->setFormValue($val);
		}

		// Check field name '10' first before field var 'x__10'
		$val = $CurrentForm->hasValue("10") ? $CurrentForm->getValue("10") : $CurrentForm->getValue("x__10");
		if (!$this->_10->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_10->Visible = FALSE; // Disable update for API request
			else
				$this->_10->setFormValue($val);
		}

		// Check field name 'm_10' first before field var 'x_m_10'
		$val = $CurrentForm->hasValue("m_10") ? $CurrentForm->getValue("m_10") : $CurrentForm->getValue("x_m_10");
		if (!$this->m_10->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_10->Visible = FALSE; // Disable update for API request
			else
				$this->m_10->setFormValue($val);
		}

		// Check field name '11' first before field var 'x__11'
		$val = $CurrentForm->hasValue("11") ? $CurrentForm->getValue("11") : $CurrentForm->getValue("x__11");
		if (!$this->_11->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_11->Visible = FALSE; // Disable update for API request
			else
				$this->_11->setFormValue($val);
		}

		// Check field name 'm_11' first before field var 'x_m_11'
		$val = $CurrentForm->hasValue("m_11") ? $CurrentForm->getValue("m_11") : $CurrentForm->getValue("x_m_11");
		if (!$this->m_11->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_11->Visible = FALSE; // Disable update for API request
			else
				$this->m_11->setFormValue($val);
		}

		// Check field name '12' first before field var 'x__12'
		$val = $CurrentForm->hasValue("12") ? $CurrentForm->getValue("12") : $CurrentForm->getValue("x__12");
		if (!$this->_12->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_12->Visible = FALSE; // Disable update for API request
			else
				$this->_12->setFormValue($val);
		}

		// Check field name 'm_12' first before field var 'x_m_12'
		$val = $CurrentForm->hasValue("m_12") ? $CurrentForm->getValue("m_12") : $CurrentForm->getValue("x_m_12");
		if (!$this->m_12->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_12->Visible = FALSE; // Disable update for API request
			else
				$this->m_12->setFormValue($val);
		}

		// Check field name '13' first before field var 'x__13'
		$val = $CurrentForm->hasValue("13") ? $CurrentForm->getValue("13") : $CurrentForm->getValue("x__13");
		if (!$this->_13->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_13->Visible = FALSE; // Disable update for API request
			else
				$this->_13->setFormValue($val);
		}

		// Check field name 'm_13' first before field var 'x_m_13'
		$val = $CurrentForm->hasValue("m_13") ? $CurrentForm->getValue("m_13") : $CurrentForm->getValue("x_m_13");
		if (!$this->m_13->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_13->Visible = FALSE; // Disable update for API request
			else
				$this->m_13->setFormValue($val);
		}

		// Check field name '14' first before field var 'x__14'
		$val = $CurrentForm->hasValue("14") ? $CurrentForm->getValue("14") : $CurrentForm->getValue("x__14");
		if (!$this->_14->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_14->Visible = FALSE; // Disable update for API request
			else
				$this->_14->setFormValue($val);
		}

		// Check field name 'm_14' first before field var 'x_m_14'
		$val = $CurrentForm->hasValue("m_14") ? $CurrentForm->getValue("m_14") : $CurrentForm->getValue("x_m_14");
		if (!$this->m_14->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_14->Visible = FALSE; // Disable update for API request
			else
				$this->m_14->setFormValue($val);
		}

		// Check field name '15' first before field var 'x__15'
		$val = $CurrentForm->hasValue("15") ? $CurrentForm->getValue("15") : $CurrentForm->getValue("x__15");
		if (!$this->_15->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_15->Visible = FALSE; // Disable update for API request
			else
				$this->_15->setFormValue($val);
		}

		// Check field name 'm_15' first before field var 'x_m_15'
		$val = $CurrentForm->hasValue("m_15") ? $CurrentForm->getValue("m_15") : $CurrentForm->getValue("x_m_15");
		if (!$this->m_15->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_15->Visible = FALSE; // Disable update for API request
			else
				$this->m_15->setFormValue($val);
		}

		// Check field name '16' first before field var 'x__16'
		$val = $CurrentForm->hasValue("16") ? $CurrentForm->getValue("16") : $CurrentForm->getValue("x__16");
		if (!$this->_16->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_16->Visible = FALSE; // Disable update for API request
			else
				$this->_16->setFormValue($val);
		}

		// Check field name 'm_16' first before field var 'x_m_16'
		$val = $CurrentForm->hasValue("m_16") ? $CurrentForm->getValue("m_16") : $CurrentForm->getValue("x_m_16");
		if (!$this->m_16->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_16->Visible = FALSE; // Disable update for API request
			else
				$this->m_16->setFormValue($val);
		}

		// Check field name '17' first before field var 'x__17'
		$val = $CurrentForm->hasValue("17") ? $CurrentForm->getValue("17") : $CurrentForm->getValue("x__17");
		if (!$this->_17->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_17->Visible = FALSE; // Disable update for API request
			else
				$this->_17->setFormValue($val);
		}

		// Check field name 'm_17' first before field var 'x_m_17'
		$val = $CurrentForm->hasValue("m_17") ? $CurrentForm->getValue("m_17") : $CurrentForm->getValue("x_m_17");
		if (!$this->m_17->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_17->Visible = FALSE; // Disable update for API request
			else
				$this->m_17->setFormValue($val);
		}

		// Check field name '18' first before field var 'x__18'
		$val = $CurrentForm->hasValue("18") ? $CurrentForm->getValue("18") : $CurrentForm->getValue("x__18");
		if (!$this->_18->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_18->Visible = FALSE; // Disable update for API request
			else
				$this->_18->setFormValue($val);
		}

		// Check field name 'm_18' first before field var 'x_m_18'
		$val = $CurrentForm->hasValue("m_18") ? $CurrentForm->getValue("m_18") : $CurrentForm->getValue("x_m_18");
		if (!$this->m_18->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_18->Visible = FALSE; // Disable update for API request
			else
				$this->m_18->setFormValue($val);
		}

		// Check field name '19' first before field var 'x__19'
		$val = $CurrentForm->hasValue("19") ? $CurrentForm->getValue("19") : $CurrentForm->getValue("x__19");
		if (!$this->_19->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_19->Visible = FALSE; // Disable update for API request
			else
				$this->_19->setFormValue($val);
		}

		// Check field name 'm_19' first before field var 'x_m_19'
		$val = $CurrentForm->hasValue("m_19") ? $CurrentForm->getValue("m_19") : $CurrentForm->getValue("x_m_19");
		if (!$this->m_19->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_19->Visible = FALSE; // Disable update for API request
			else
				$this->m_19->setFormValue($val);
		}

		// Check field name '20' first before field var 'x__20'
		$val = $CurrentForm->hasValue("20") ? $CurrentForm->getValue("20") : $CurrentForm->getValue("x__20");
		if (!$this->_20->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_20->Visible = FALSE; // Disable update for API request
			else
				$this->_20->setFormValue($val);
		}

		// Check field name 'm_20' first before field var 'x_m_20'
		$val = $CurrentForm->hasValue("m_20") ? $CurrentForm->getValue("m_20") : $CurrentForm->getValue("x_m_20");
		if (!$this->m_20->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_20->Visible = FALSE; // Disable update for API request
			else
				$this->m_20->setFormValue($val);
		}

		// Check field name '21' first before field var 'x__21'
		$val = $CurrentForm->hasValue("21") ? $CurrentForm->getValue("21") : $CurrentForm->getValue("x__21");
		if (!$this->_21->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_21->Visible = FALSE; // Disable update for API request
			else
				$this->_21->setFormValue($val);
		}

		// Check field name 'm_21' first before field var 'x_m_21'
		$val = $CurrentForm->hasValue("m_21") ? $CurrentForm->getValue("m_21") : $CurrentForm->getValue("x_m_21");
		if (!$this->m_21->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_21->Visible = FALSE; // Disable update for API request
			else
				$this->m_21->setFormValue($val);
		}

		// Check field name '22' first before field var 'x__22'
		$val = $CurrentForm->hasValue("22") ? $CurrentForm->getValue("22") : $CurrentForm->getValue("x__22");
		if (!$this->_22->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_22->Visible = FALSE; // Disable update for API request
			else
				$this->_22->setFormValue($val);
		}

		// Check field name 'm_22' first before field var 'x_m_22'
		$val = $CurrentForm->hasValue("m_22") ? $CurrentForm->getValue("m_22") : $CurrentForm->getValue("x_m_22");
		if (!$this->m_22->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_22->Visible = FALSE; // Disable update for API request
			else
				$this->m_22->setFormValue($val);
		}

		// Check field name '23' first before field var 'x__23'
		$val = $CurrentForm->hasValue("23") ? $CurrentForm->getValue("23") : $CurrentForm->getValue("x__23");
		if (!$this->_23->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_23->Visible = FALSE; // Disable update for API request
			else
				$this->_23->setFormValue($val);
		}

		// Check field name 'm_23' first before field var 'x_m_23'
		$val = $CurrentForm->hasValue("m_23") ? $CurrentForm->getValue("m_23") : $CurrentForm->getValue("x_m_23");
		if (!$this->m_23->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_23->Visible = FALSE; // Disable update for API request
			else
				$this->m_23->setFormValue($val);
		}

		// Check field name '24' first before field var 'x__24'
		$val = $CurrentForm->hasValue("24") ? $CurrentForm->getValue("24") : $CurrentForm->getValue("x__24");
		if (!$this->_24->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_24->Visible = FALSE; // Disable update for API request
			else
				$this->_24->setFormValue($val);
		}

		// Check field name 'm_24' first before field var 'x_m_24'
		$val = $CurrentForm->hasValue("m_24") ? $CurrentForm->getValue("m_24") : $CurrentForm->getValue("x_m_24");
		if (!$this->m_24->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_24->Visible = FALSE; // Disable update for API request
			else
				$this->m_24->setFormValue($val);
		}

		// Check field name '25' first before field var 'x__25'
		$val = $CurrentForm->hasValue("25") ? $CurrentForm->getValue("25") : $CurrentForm->getValue("x__25");
		if (!$this->_25->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_25->Visible = FALSE; // Disable update for API request
			else
				$this->_25->setFormValue($val);
		}

		// Check field name 'm_25' first before field var 'x_m_25'
		$val = $CurrentForm->hasValue("m_25") ? $CurrentForm->getValue("m_25") : $CurrentForm->getValue("x_m_25");
		if (!$this->m_25->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_25->Visible = FALSE; // Disable update for API request
			else
				$this->m_25->setFormValue($val);
		}

		// Check field name '26' first before field var 'x__26'
		$val = $CurrentForm->hasValue("26") ? $CurrentForm->getValue("26") : $CurrentForm->getValue("x__26");
		if (!$this->_26->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_26->Visible = FALSE; // Disable update for API request
			else
				$this->_26->setFormValue($val);
		}

		// Check field name 'm_26' first before field var 'x_m_26'
		$val = $CurrentForm->hasValue("m_26") ? $CurrentForm->getValue("m_26") : $CurrentForm->getValue("x_m_26");
		if (!$this->m_26->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_26->Visible = FALSE; // Disable update for API request
			else
				$this->m_26->setFormValue($val);
		}

		// Check field name '27' first before field var 'x__27'
		$val = $CurrentForm->hasValue("27") ? $CurrentForm->getValue("27") : $CurrentForm->getValue("x__27");
		if (!$this->_27->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_27->Visible = FALSE; // Disable update for API request
			else
				$this->_27->setFormValue($val);
		}

		// Check field name 'm_27' first before field var 'x_m_27'
		$val = $CurrentForm->hasValue("m_27") ? $CurrentForm->getValue("m_27") : $CurrentForm->getValue("x_m_27");
		if (!$this->m_27->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_27->Visible = FALSE; // Disable update for API request
			else
				$this->m_27->setFormValue($val);
		}

		// Check field name '28' first before field var 'x__28'
		$val = $CurrentForm->hasValue("28") ? $CurrentForm->getValue("28") : $CurrentForm->getValue("x__28");
		if (!$this->_28->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_28->Visible = FALSE; // Disable update for API request
			else
				$this->_28->setFormValue($val);
		}

		// Check field name 'm_28' first before field var 'x_m_28'
		$val = $CurrentForm->hasValue("m_28") ? $CurrentForm->getValue("m_28") : $CurrentForm->getValue("x_m_28");
		if (!$this->m_28->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_28->Visible = FALSE; // Disable update for API request
			else
				$this->m_28->setFormValue($val);
		}

		// Check field name '29' first before field var 'x__29'
		$val = $CurrentForm->hasValue("29") ? $CurrentForm->getValue("29") : $CurrentForm->getValue("x__29");
		if (!$this->_29->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_29->Visible = FALSE; // Disable update for API request
			else
				$this->_29->setFormValue($val);
		}

		// Check field name 'm_29' first before field var 'x_m_29'
		$val = $CurrentForm->hasValue("m_29") ? $CurrentForm->getValue("m_29") : $CurrentForm->getValue("x_m_29");
		if (!$this->m_29->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_29->Visible = FALSE; // Disable update for API request
			else
				$this->m_29->setFormValue($val);
		}

		// Check field name '30' first before field var 'x__30'
		$val = $CurrentForm->hasValue("30") ? $CurrentForm->getValue("30") : $CurrentForm->getValue("x__30");
		if (!$this->_30->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_30->Visible = FALSE; // Disable update for API request
			else
				$this->_30->setFormValue($val);
		}

		// Check field name 'm_30' first before field var 'x_m_30'
		$val = $CurrentForm->hasValue("m_30") ? $CurrentForm->getValue("m_30") : $CurrentForm->getValue("x_m_30");
		if (!$this->m_30->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_30->Visible = FALSE; // Disable update for API request
			else
				$this->m_30->setFormValue($val);
		}

		// Check field name '31' first before field var 'x__31'
		$val = $CurrentForm->hasValue("31") ? $CurrentForm->getValue("31") : $CurrentForm->getValue("x__31");
		if (!$this->_31->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_31->Visible = FALSE; // Disable update for API request
			else
				$this->_31->setFormValue($val);
		}

		// Check field name 'm_31' first before field var 'x_m_31'
		$val = $CurrentForm->hasValue("m_31") ? $CurrentForm->getValue("m_31") : $CurrentForm->getValue("x_m_31");
		if (!$this->m_31->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_31->Visible = FALSE; // Disable update for API request
			else
				$this->m_31->setFormValue($val);
		}

		// Check field name '32' first before field var 'x__32'
		$val = $CurrentForm->hasValue("32") ? $CurrentForm->getValue("32") : $CurrentForm->getValue("x__32");
		if (!$this->_32->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_32->Visible = FALSE; // Disable update for API request
			else
				$this->_32->setFormValue($val);
		}

		// Check field name 'm_32' first before field var 'x_m_32'
		$val = $CurrentForm->hasValue("m_32") ? $CurrentForm->getValue("m_32") : $CurrentForm->getValue("x_m_32");
		if (!$this->m_32->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_32->Visible = FALSE; // Disable update for API request
			else
				$this->m_32->setFormValue($val);
		}

		// Check field name '33' first before field var 'x__33'
		$val = $CurrentForm->hasValue("33") ? $CurrentForm->getValue("33") : $CurrentForm->getValue("x__33");
		if (!$this->_33->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_33->Visible = FALSE; // Disable update for API request
			else
				$this->_33->setFormValue($val);
		}

		// Check field name 'm_33' first before field var 'x_m_33'
		$val = $CurrentForm->hasValue("m_33") ? $CurrentForm->getValue("m_33") : $CurrentForm->getValue("x_m_33");
		if (!$this->m_33->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_33->Visible = FALSE; // Disable update for API request
			else
				$this->m_33->setFormValue($val);
		}

		// Check field name '34' first before field var 'x__34'
		$val = $CurrentForm->hasValue("34") ? $CurrentForm->getValue("34") : $CurrentForm->getValue("x__34");
		if (!$this->_34->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_34->Visible = FALSE; // Disable update for API request
			else
				$this->_34->setFormValue($val);
		}

		// Check field name 'm_34' first before field var 'x_m_34'
		$val = $CurrentForm->hasValue("m_34") ? $CurrentForm->getValue("m_34") : $CurrentForm->getValue("x_m_34");
		if (!$this->m_34->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_34->Visible = FALSE; // Disable update for API request
			else
				$this->m_34->setFormValue($val);
		}

		// Check field name '35' first before field var 'x__35'
		$val = $CurrentForm->hasValue("35") ? $CurrentForm->getValue("35") : $CurrentForm->getValue("x__35");
		if (!$this->_35->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_35->Visible = FALSE; // Disable update for API request
			else
				$this->_35->setFormValue($val);
		}

		// Check field name 'm_35' first before field var 'x_m_35'
		$val = $CurrentForm->hasValue("m_35") ? $CurrentForm->getValue("m_35") : $CurrentForm->getValue("x_m_35");
		if (!$this->m_35->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_35->Visible = FALSE; // Disable update for API request
			else
				$this->m_35->setFormValue($val);
		}

		// Check field name '36' first before field var 'x__36'
		$val = $CurrentForm->hasValue("36") ? $CurrentForm->getValue("36") : $CurrentForm->getValue("x__36");
		if (!$this->_36->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_36->Visible = FALSE; // Disable update for API request
			else
				$this->_36->setFormValue($val);
		}

		// Check field name 'm_36' first before field var 'x_m_36'
		$val = $CurrentForm->hasValue("m_36") ? $CurrentForm->getValue("m_36") : $CurrentForm->getValue("x_m_36");
		if (!$this->m_36->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_36->Visible = FALSE; // Disable update for API request
			else
				$this->m_36->setFormValue($val);
		}

		// Check field name '37' first before field var 'x__37'
		$val = $CurrentForm->hasValue("37") ? $CurrentForm->getValue("37") : $CurrentForm->getValue("x__37");
		if (!$this->_37->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_37->Visible = FALSE; // Disable update for API request
			else
				$this->_37->setFormValue($val);
		}

		// Check field name 'm_37' first before field var 'x_m_37'
		$val = $CurrentForm->hasValue("m_37") ? $CurrentForm->getValue("m_37") : $CurrentForm->getValue("x_m_37");
		if (!$this->m_37->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_37->Visible = FALSE; // Disable update for API request
			else
				$this->m_37->setFormValue($val);
		}

		// Check field name '38' first before field var 'x__38'
		$val = $CurrentForm->hasValue("38") ? $CurrentForm->getValue("38") : $CurrentForm->getValue("x__38");
		if (!$this->_38->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_38->Visible = FALSE; // Disable update for API request
			else
				$this->_38->setFormValue($val);
		}

		// Check field name 'm_38' first before field var 'x_m_38'
		$val = $CurrentForm->hasValue("m_38") ? $CurrentForm->getValue("m_38") : $CurrentForm->getValue("x_m_38");
		if (!$this->m_38->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_38->Visible = FALSE; // Disable update for API request
			else
				$this->m_38->setFormValue($val);
		}

		// Check field name '39' first before field var 'x__39'
		$val = $CurrentForm->hasValue("39") ? $CurrentForm->getValue("39") : $CurrentForm->getValue("x__39");
		if (!$this->_39->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_39->Visible = FALSE; // Disable update for API request
			else
				$this->_39->setFormValue($val);
		}

		// Check field name 'm_39' first before field var 'x_m_39'
		$val = $CurrentForm->hasValue("m_39") ? $CurrentForm->getValue("m_39") : $CurrentForm->getValue("x_m_39");
		if (!$this->m_39->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_39->Visible = FALSE; // Disable update for API request
			else
				$this->m_39->setFormValue($val);
		}

		// Check field name '40' first before field var 'x__40'
		$val = $CurrentForm->hasValue("40") ? $CurrentForm->getValue("40") : $CurrentForm->getValue("x__40");
		if (!$this->_40->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_40->Visible = FALSE; // Disable update for API request
			else
				$this->_40->setFormValue($val);
		}

		// Check field name 'm_40' first before field var 'x_m_40'
		$val = $CurrentForm->hasValue("m_40") ? $CurrentForm->getValue("m_40") : $CurrentForm->getValue("x_m_40");
		if (!$this->m_40->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_40->Visible = FALSE; // Disable update for API request
			else
				$this->m_40->setFormValue($val);
		}

		// Check field name '41' first before field var 'x__41'
		$val = $CurrentForm->hasValue("41") ? $CurrentForm->getValue("41") : $CurrentForm->getValue("x__41");
		if (!$this->_41->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_41->Visible = FALSE; // Disable update for API request
			else
				$this->_41->setFormValue($val);
		}

		// Check field name 'm_41' first before field var 'x_m_41'
		$val = $CurrentForm->hasValue("m_41") ? $CurrentForm->getValue("m_41") : $CurrentForm->getValue("x_m_41");
		if (!$this->m_41->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_41->Visible = FALSE; // Disable update for API request
			else
				$this->m_41->setFormValue($val);
		}

		// Check field name '42' first before field var 'x__42'
		$val = $CurrentForm->hasValue("42") ? $CurrentForm->getValue("42") : $CurrentForm->getValue("x__42");
		if (!$this->_42->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_42->Visible = FALSE; // Disable update for API request
			else
				$this->_42->setFormValue($val);
		}

		// Check field name 'm_42' first before field var 'x_m_42'
		$val = $CurrentForm->hasValue("m_42") ? $CurrentForm->getValue("m_42") : $CurrentForm->getValue("x_m_42");
		if (!$this->m_42->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_42->Visible = FALSE; // Disable update for API request
			else
				$this->m_42->setFormValue($val);
		}

		// Check field name '43' first before field var 'x__43'
		$val = $CurrentForm->hasValue("43") ? $CurrentForm->getValue("43") : $CurrentForm->getValue("x__43");
		if (!$this->_43->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_43->Visible = FALSE; // Disable update for API request
			else
				$this->_43->setFormValue($val);
		}

		// Check field name 'm_43' first before field var 'x_m_43'
		$val = $CurrentForm->hasValue("m_43") ? $CurrentForm->getValue("m_43") : $CurrentForm->getValue("x_m_43");
		if (!$this->m_43->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_43->Visible = FALSE; // Disable update for API request
			else
				$this->m_43->setFormValue($val);
		}

		// Check field name '44' first before field var 'x__44'
		$val = $CurrentForm->hasValue("44") ? $CurrentForm->getValue("44") : $CurrentForm->getValue("x__44");
		if (!$this->_44->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_44->Visible = FALSE; // Disable update for API request
			else
				$this->_44->setFormValue($val);
		}

		// Check field name 'm_44' first before field var 'x_m_44'
		$val = $CurrentForm->hasValue("m_44") ? $CurrentForm->getValue("m_44") : $CurrentForm->getValue("x_m_44");
		if (!$this->m_44->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_44->Visible = FALSE; // Disable update for API request
			else
				$this->m_44->setFormValue($val);
		}

		// Check field name '45' first before field var 'x__45'
		$val = $CurrentForm->hasValue("45") ? $CurrentForm->getValue("45") : $CurrentForm->getValue("x__45");
		if (!$this->_45->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_45->Visible = FALSE; // Disable update for API request
			else
				$this->_45->setFormValue($val);
		}

		// Check field name 'm_45' first before field var 'x_m_45'
		$val = $CurrentForm->hasValue("m_45") ? $CurrentForm->getValue("m_45") : $CurrentForm->getValue("x_m_45");
		if (!$this->m_45->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_45->Visible = FALSE; // Disable update for API request
			else
				$this->m_45->setFormValue($val);
		}

		// Check field name '46' first before field var 'x__46'
		$val = $CurrentForm->hasValue("46") ? $CurrentForm->getValue("46") : $CurrentForm->getValue("x__46");
		if (!$this->_46->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_46->Visible = FALSE; // Disable update for API request
			else
				$this->_46->setFormValue($val);
		}

		// Check field name 'm_46' first before field var 'x_m_46'
		$val = $CurrentForm->hasValue("m_46") ? $CurrentForm->getValue("m_46") : $CurrentForm->getValue("x_m_46");
		if (!$this->m_46->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_46->Visible = FALSE; // Disable update for API request
			else
				$this->m_46->setFormValue($val);
		}

		// Check field name '47' first before field var 'x__47'
		$val = $CurrentForm->hasValue("47") ? $CurrentForm->getValue("47") : $CurrentForm->getValue("x__47");
		if (!$this->_47->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_47->Visible = FALSE; // Disable update for API request
			else
				$this->_47->setFormValue($val);
		}

		// Check field name 'm_47' first before field var 'x_m_47'
		$val = $CurrentForm->hasValue("m_47") ? $CurrentForm->getValue("m_47") : $CurrentForm->getValue("x_m_47");
		if (!$this->m_47->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_47->Visible = FALSE; // Disable update for API request
			else
				$this->m_47->setFormValue($val);
		}

		// Check field name '48' first before field var 'x__48'
		$val = $CurrentForm->hasValue("48") ? $CurrentForm->getValue("48") : $CurrentForm->getValue("x__48");
		if (!$this->_48->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_48->Visible = FALSE; // Disable update for API request
			else
				$this->_48->setFormValue($val);
		}

		// Check field name 'm_48' first before field var 'x_m_48'
		$val = $CurrentForm->hasValue("m_48") ? $CurrentForm->getValue("m_48") : $CurrentForm->getValue("x_m_48");
		if (!$this->m_48->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_48->Visible = FALSE; // Disable update for API request
			else
				$this->m_48->setFormValue($val);
		}

		// Check field name '49' first before field var 'x__49'
		$val = $CurrentForm->hasValue("49") ? $CurrentForm->getValue("49") : $CurrentForm->getValue("x__49");
		if (!$this->_49->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_49->Visible = FALSE; // Disable update for API request
			else
				$this->_49->setFormValue($val);
		}

		// Check field name 'm_49' first before field var 'x_m_49'
		$val = $CurrentForm->hasValue("m_49") ? $CurrentForm->getValue("m_49") : $CurrentForm->getValue("x_m_49");
		if (!$this->m_49->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_49->Visible = FALSE; // Disable update for API request
			else
				$this->m_49->setFormValue($val);
		}

		// Check field name '50' first before field var 'x__50'
		$val = $CurrentForm->hasValue("50") ? $CurrentForm->getValue("50") : $CurrentForm->getValue("x__50");
		if (!$this->_50->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_50->Visible = FALSE; // Disable update for API request
			else
				$this->_50->setFormValue($val);
		}

		// Check field name 'm_50' first before field var 'x_m_50'
		$val = $CurrentForm->hasValue("m_50") ? $CurrentForm->getValue("m_50") : $CurrentForm->getValue("x_m_50");
		if (!$this->m_50->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_50->Visible = FALSE; // Disable update for API request
			else
				$this->m_50->setFormValue($val);
		}

		// Check field name '51' first before field var 'x__51'
		$val = $CurrentForm->hasValue("51") ? $CurrentForm->getValue("51") : $CurrentForm->getValue("x__51");
		if (!$this->_51->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_51->Visible = FALSE; // Disable update for API request
			else
				$this->_51->setFormValue($val);
		}

		// Check field name 'm_51' first before field var 'x_m_51'
		$val = $CurrentForm->hasValue("m_51") ? $CurrentForm->getValue("m_51") : $CurrentForm->getValue("x_m_51");
		if (!$this->m_51->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_51->Visible = FALSE; // Disable update for API request
			else
				$this->m_51->setFormValue($val);
		}

		// Check field name '52' first before field var 'x__52'
		$val = $CurrentForm->hasValue("52") ? $CurrentForm->getValue("52") : $CurrentForm->getValue("x__52");
		if (!$this->_52->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_52->Visible = FALSE; // Disable update for API request
			else
				$this->_52->setFormValue($val);
		}

		// Check field name 'm_52' first before field var 'x_m_52'
		$val = $CurrentForm->hasValue("m_52") ? $CurrentForm->getValue("m_52") : $CurrentForm->getValue("x_m_52");
		if (!$this->m_52->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_52->Visible = FALSE; // Disable update for API request
			else
				$this->m_52->setFormValue($val);
		}

		// Check field name '53' first before field var 'x__53'
		$val = $CurrentForm->hasValue("53") ? $CurrentForm->getValue("53") : $CurrentForm->getValue("x__53");
		if (!$this->_53->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_53->Visible = FALSE; // Disable update for API request
			else
				$this->_53->setFormValue($val);
		}

		// Check field name 'm_53' first before field var 'x_m_53'
		$val = $CurrentForm->hasValue("m_53") ? $CurrentForm->getValue("m_53") : $CurrentForm->getValue("x_m_53");
		if (!$this->m_53->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_53->Visible = FALSE; // Disable update for API request
			else
				$this->m_53->setFormValue($val);
		}

		// Check field name '54' first before field var 'x__54'
		$val = $CurrentForm->hasValue("54") ? $CurrentForm->getValue("54") : $CurrentForm->getValue("x__54");
		if (!$this->_54->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_54->Visible = FALSE; // Disable update for API request
			else
				$this->_54->setFormValue($val);
		}

		// Check field name 'm_54' first before field var 'x_m_54'
		$val = $CurrentForm->hasValue("m_54") ? $CurrentForm->getValue("m_54") : $CurrentForm->getValue("x_m_54");
		if (!$this->m_54->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_54->Visible = FALSE; // Disable update for API request
			else
				$this->m_54->setFormValue($val);
		}

		// Check field name '55' first before field var 'x__55'
		$val = $CurrentForm->hasValue("55") ? $CurrentForm->getValue("55") : $CurrentForm->getValue("x__55");
		if (!$this->_55->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_55->Visible = FALSE; // Disable update for API request
			else
				$this->_55->setFormValue($val);
		}

		// Check field name 'm_55' first before field var 'x_m_55'
		$val = $CurrentForm->hasValue("m_55") ? $CurrentForm->getValue("m_55") : $CurrentForm->getValue("x_m_55");
		if (!$this->m_55->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_55->Visible = FALSE; // Disable update for API request
			else
				$this->m_55->setFormValue($val);
		}

		// Check field name '56' first before field var 'x__56'
		$val = $CurrentForm->hasValue("56") ? $CurrentForm->getValue("56") : $CurrentForm->getValue("x__56");
		if (!$this->_56->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_56->Visible = FALSE; // Disable update for API request
			else
				$this->_56->setFormValue($val);
		}

		// Check field name 'm_56' first before field var 'x_m_56'
		$val = $CurrentForm->hasValue("m_56") ? $CurrentForm->getValue("m_56") : $CurrentForm->getValue("x_m_56");
		if (!$this->m_56->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_56->Visible = FALSE; // Disable update for API request
			else
				$this->m_56->setFormValue($val);
		}

		// Check field name '57' first before field var 'x__57'
		$val = $CurrentForm->hasValue("57") ? $CurrentForm->getValue("57") : $CurrentForm->getValue("x__57");
		if (!$this->_57->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_57->Visible = FALSE; // Disable update for API request
			else
				$this->_57->setFormValue($val);
		}

		// Check field name 'm_57' first before field var 'x_m_57'
		$val = $CurrentForm->hasValue("m_57") ? $CurrentForm->getValue("m_57") : $CurrentForm->getValue("x_m_57");
		if (!$this->m_57->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_57->Visible = FALSE; // Disable update for API request
			else
				$this->m_57->setFormValue($val);
		}

		// Check field name '58' first before field var 'x__58'
		$val = $CurrentForm->hasValue("58") ? $CurrentForm->getValue("58") : $CurrentForm->getValue("x__58");
		if (!$this->_58->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_58->Visible = FALSE; // Disable update for API request
			else
				$this->_58->setFormValue($val);
		}

		// Check field name 'm_58' first before field var 'x_m_58'
		$val = $CurrentForm->hasValue("m_58") ? $CurrentForm->getValue("m_58") : $CurrentForm->getValue("x_m_58");
		if (!$this->m_58->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_58->Visible = FALSE; // Disable update for API request
			else
				$this->m_58->setFormValue($val);
		}

		// Check field name '59' first before field var 'x__59'
		$val = $CurrentForm->hasValue("59") ? $CurrentForm->getValue("59") : $CurrentForm->getValue("x__59");
		if (!$this->_59->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_59->Visible = FALSE; // Disable update for API request
			else
				$this->_59->setFormValue($val);
		}

		// Check field name 'm_59' first before field var 'x_m_59'
		$val = $CurrentForm->hasValue("m_59") ? $CurrentForm->getValue("m_59") : $CurrentForm->getValue("x_m_59");
		if (!$this->m_59->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_59->Visible = FALSE; // Disable update for API request
			else
				$this->m_59->setFormValue($val);
		}

		// Check field name '60' first before field var 'x__60'
		$val = $CurrentForm->hasValue("60") ? $CurrentForm->getValue("60") : $CurrentForm->getValue("x__60");
		if (!$this->_60->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_60->Visible = FALSE; // Disable update for API request
			else
				$this->_60->setFormValue($val);
		}

		// Check field name 'm_60' first before field var 'x_m_60'
		$val = $CurrentForm->hasValue("m_60") ? $CurrentForm->getValue("m_60") : $CurrentForm->getValue("x_m_60");
		if (!$this->m_60->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_60->Visible = FALSE; // Disable update for API request
			else
				$this->m_60->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->roll_no->CurrentValue = $this->roll_no->FormValue;
		$this->test_id->CurrentValue = $this->test_id->FormValue;
		$this->total->CurrentValue = $this->total->FormValue;
		$this->percent->CurrentValue = $this->percent->FormValue;
		$this->s_1->CurrentValue = $this->s_1->FormValue;
		$this->s_2->CurrentValue = $this->s_2->FormValue;
		$this->s_3->CurrentValue = $this->s_3->FormValue;
		$this->s_4->CurrentValue = $this->s_4->FormValue;
		$this->s_5->CurrentValue = $this->s_5->FormValue;
		$this->_1->CurrentValue = $this->_1->FormValue;
		$this->m_1->CurrentValue = $this->m_1->FormValue;
		$this->_2->CurrentValue = $this->_2->FormValue;
		$this->m_2->CurrentValue = $this->m_2->FormValue;
		$this->_3->CurrentValue = $this->_3->FormValue;
		$this->m_3->CurrentValue = $this->m_3->FormValue;
		$this->_4->CurrentValue = $this->_4->FormValue;
		$this->m_4->CurrentValue = $this->m_4->FormValue;
		$this->_5->CurrentValue = $this->_5->FormValue;
		$this->m_5->CurrentValue = $this->m_5->FormValue;
		$this->_6->CurrentValue = $this->_6->FormValue;
		$this->m_6->CurrentValue = $this->m_6->FormValue;
		$this->_7->CurrentValue = $this->_7->FormValue;
		$this->m_7->CurrentValue = $this->m_7->FormValue;
		$this->_8->CurrentValue = $this->_8->FormValue;
		$this->m_8->CurrentValue = $this->m_8->FormValue;
		$this->_9->CurrentValue = $this->_9->FormValue;
		$this->m_9->CurrentValue = $this->m_9->FormValue;
		$this->_10->CurrentValue = $this->_10->FormValue;
		$this->m_10->CurrentValue = $this->m_10->FormValue;
		$this->_11->CurrentValue = $this->_11->FormValue;
		$this->m_11->CurrentValue = $this->m_11->FormValue;
		$this->_12->CurrentValue = $this->_12->FormValue;
		$this->m_12->CurrentValue = $this->m_12->FormValue;
		$this->_13->CurrentValue = $this->_13->FormValue;
		$this->m_13->CurrentValue = $this->m_13->FormValue;
		$this->_14->CurrentValue = $this->_14->FormValue;
		$this->m_14->CurrentValue = $this->m_14->FormValue;
		$this->_15->CurrentValue = $this->_15->FormValue;
		$this->m_15->CurrentValue = $this->m_15->FormValue;
		$this->_16->CurrentValue = $this->_16->FormValue;
		$this->m_16->CurrentValue = $this->m_16->FormValue;
		$this->_17->CurrentValue = $this->_17->FormValue;
		$this->m_17->CurrentValue = $this->m_17->FormValue;
		$this->_18->CurrentValue = $this->_18->FormValue;
		$this->m_18->CurrentValue = $this->m_18->FormValue;
		$this->_19->CurrentValue = $this->_19->FormValue;
		$this->m_19->CurrentValue = $this->m_19->FormValue;
		$this->_20->CurrentValue = $this->_20->FormValue;
		$this->m_20->CurrentValue = $this->m_20->FormValue;
		$this->_21->CurrentValue = $this->_21->FormValue;
		$this->m_21->CurrentValue = $this->m_21->FormValue;
		$this->_22->CurrentValue = $this->_22->FormValue;
		$this->m_22->CurrentValue = $this->m_22->FormValue;
		$this->_23->CurrentValue = $this->_23->FormValue;
		$this->m_23->CurrentValue = $this->m_23->FormValue;
		$this->_24->CurrentValue = $this->_24->FormValue;
		$this->m_24->CurrentValue = $this->m_24->FormValue;
		$this->_25->CurrentValue = $this->_25->FormValue;
		$this->m_25->CurrentValue = $this->m_25->FormValue;
		$this->_26->CurrentValue = $this->_26->FormValue;
		$this->m_26->CurrentValue = $this->m_26->FormValue;
		$this->_27->CurrentValue = $this->_27->FormValue;
		$this->m_27->CurrentValue = $this->m_27->FormValue;
		$this->_28->CurrentValue = $this->_28->FormValue;
		$this->m_28->CurrentValue = $this->m_28->FormValue;
		$this->_29->CurrentValue = $this->_29->FormValue;
		$this->m_29->CurrentValue = $this->m_29->FormValue;
		$this->_30->CurrentValue = $this->_30->FormValue;
		$this->m_30->CurrentValue = $this->m_30->FormValue;
		$this->_31->CurrentValue = $this->_31->FormValue;
		$this->m_31->CurrentValue = $this->m_31->FormValue;
		$this->_32->CurrentValue = $this->_32->FormValue;
		$this->m_32->CurrentValue = $this->m_32->FormValue;
		$this->_33->CurrentValue = $this->_33->FormValue;
		$this->m_33->CurrentValue = $this->m_33->FormValue;
		$this->_34->CurrentValue = $this->_34->FormValue;
		$this->m_34->CurrentValue = $this->m_34->FormValue;
		$this->_35->CurrentValue = $this->_35->FormValue;
		$this->m_35->CurrentValue = $this->m_35->FormValue;
		$this->_36->CurrentValue = $this->_36->FormValue;
		$this->m_36->CurrentValue = $this->m_36->FormValue;
		$this->_37->CurrentValue = $this->_37->FormValue;
		$this->m_37->CurrentValue = $this->m_37->FormValue;
		$this->_38->CurrentValue = $this->_38->FormValue;
		$this->m_38->CurrentValue = $this->m_38->FormValue;
		$this->_39->CurrentValue = $this->_39->FormValue;
		$this->m_39->CurrentValue = $this->m_39->FormValue;
		$this->_40->CurrentValue = $this->_40->FormValue;
		$this->m_40->CurrentValue = $this->m_40->FormValue;
		$this->_41->CurrentValue = $this->_41->FormValue;
		$this->m_41->CurrentValue = $this->m_41->FormValue;
		$this->_42->CurrentValue = $this->_42->FormValue;
		$this->m_42->CurrentValue = $this->m_42->FormValue;
		$this->_43->CurrentValue = $this->_43->FormValue;
		$this->m_43->CurrentValue = $this->m_43->FormValue;
		$this->_44->CurrentValue = $this->_44->FormValue;
		$this->m_44->CurrentValue = $this->m_44->FormValue;
		$this->_45->CurrentValue = $this->_45->FormValue;
		$this->m_45->CurrentValue = $this->m_45->FormValue;
		$this->_46->CurrentValue = $this->_46->FormValue;
		$this->m_46->CurrentValue = $this->m_46->FormValue;
		$this->_47->CurrentValue = $this->_47->FormValue;
		$this->m_47->CurrentValue = $this->m_47->FormValue;
		$this->_48->CurrentValue = $this->_48->FormValue;
		$this->m_48->CurrentValue = $this->m_48->FormValue;
		$this->_49->CurrentValue = $this->_49->FormValue;
		$this->m_49->CurrentValue = $this->m_49->FormValue;
		$this->_50->CurrentValue = $this->_50->FormValue;
		$this->m_50->CurrentValue = $this->m_50->FormValue;
		$this->_51->CurrentValue = $this->_51->FormValue;
		$this->m_51->CurrentValue = $this->m_51->FormValue;
		$this->_52->CurrentValue = $this->_52->FormValue;
		$this->m_52->CurrentValue = $this->m_52->FormValue;
		$this->_53->CurrentValue = $this->_53->FormValue;
		$this->m_53->CurrentValue = $this->m_53->FormValue;
		$this->_54->CurrentValue = $this->_54->FormValue;
		$this->m_54->CurrentValue = $this->m_54->FormValue;
		$this->_55->CurrentValue = $this->_55->FormValue;
		$this->m_55->CurrentValue = $this->m_55->FormValue;
		$this->_56->CurrentValue = $this->_56->FormValue;
		$this->m_56->CurrentValue = $this->m_56->FormValue;
		$this->_57->CurrentValue = $this->_57->FormValue;
		$this->m_57->CurrentValue = $this->m_57->FormValue;
		$this->_58->CurrentValue = $this->_58->FormValue;
		$this->m_58->CurrentValue = $this->m_58->FormValue;
		$this->_59->CurrentValue = $this->_59->FormValue;
		$this->m_59->CurrentValue = $this->m_59->FormValue;
		$this->_60->CurrentValue = $this->_60->FormValue;
		$this->m_60->CurrentValue = $this->m_60->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->roll_no->setDbValue($row['roll_no']);
		$this->test_id->setDbValue($row['test_id']);
		$this->total->setDbValue($row['total']);
		$this->percent->setDbValue($row['percent']);
		$this->s_1->setDbValue($row['s_1']);
		$this->s_2->setDbValue($row['s_2']);
		$this->s_3->setDbValue($row['s_3']);
		$this->s_4->setDbValue($row['s_4']);
		$this->s_5->setDbValue($row['s_5']);
		$this->omr_image->Upload->DbValue = $row['omr_image'];
		$this->omr_image->setDbValue($this->omr_image->Upload->DbValue);
		$this->_1->setDbValue($row['1']);
		$this->m_1->setDbValue($row['m_1']);
		$this->_2->setDbValue($row['2']);
		$this->m_2->setDbValue($row['m_2']);
		$this->_3->setDbValue($row['3']);
		$this->m_3->setDbValue($row['m_3']);
		$this->_4->setDbValue($row['4']);
		$this->m_4->setDbValue($row['m_4']);
		$this->_5->setDbValue($row['5']);
		$this->m_5->setDbValue($row['m_5']);
		$this->_6->setDbValue($row['6']);
		$this->m_6->setDbValue($row['m_6']);
		$this->_7->setDbValue($row['7']);
		$this->m_7->setDbValue($row['m_7']);
		$this->_8->setDbValue($row['8']);
		$this->m_8->setDbValue($row['m_8']);
		$this->_9->setDbValue($row['9']);
		$this->m_9->setDbValue($row['m_9']);
		$this->_10->setDbValue($row['10']);
		$this->m_10->setDbValue($row['m_10']);
		$this->_11->setDbValue($row['11']);
		$this->m_11->setDbValue($row['m_11']);
		$this->_12->setDbValue($row['12']);
		$this->m_12->setDbValue($row['m_12']);
		$this->_13->setDbValue($row['13']);
		$this->m_13->setDbValue($row['m_13']);
		$this->_14->setDbValue($row['14']);
		$this->m_14->setDbValue($row['m_14']);
		$this->_15->setDbValue($row['15']);
		$this->m_15->setDbValue($row['m_15']);
		$this->_16->setDbValue($row['16']);
		$this->m_16->setDbValue($row['m_16']);
		$this->_17->setDbValue($row['17']);
		$this->m_17->setDbValue($row['m_17']);
		$this->_18->setDbValue($row['18']);
		$this->m_18->setDbValue($row['m_18']);
		$this->_19->setDbValue($row['19']);
		$this->m_19->setDbValue($row['m_19']);
		$this->_20->setDbValue($row['20']);
		$this->m_20->setDbValue($row['m_20']);
		$this->_21->setDbValue($row['21']);
		$this->m_21->setDbValue($row['m_21']);
		$this->_22->setDbValue($row['22']);
		$this->m_22->setDbValue($row['m_22']);
		$this->_23->setDbValue($row['23']);
		$this->m_23->setDbValue($row['m_23']);
		$this->_24->setDbValue($row['24']);
		$this->m_24->setDbValue($row['m_24']);
		$this->_25->setDbValue($row['25']);
		$this->m_25->setDbValue($row['m_25']);
		$this->_26->setDbValue($row['26']);
		$this->m_26->setDbValue($row['m_26']);
		$this->_27->setDbValue($row['27']);
		$this->m_27->setDbValue($row['m_27']);
		$this->_28->setDbValue($row['28']);
		$this->m_28->setDbValue($row['m_28']);
		$this->_29->setDbValue($row['29']);
		$this->m_29->setDbValue($row['m_29']);
		$this->_30->setDbValue($row['30']);
		$this->m_30->setDbValue($row['m_30']);
		$this->_31->setDbValue($row['31']);
		$this->m_31->setDbValue($row['m_31']);
		$this->_32->setDbValue($row['32']);
		$this->m_32->setDbValue($row['m_32']);
		$this->_33->setDbValue($row['33']);
		$this->m_33->setDbValue($row['m_33']);
		$this->_34->setDbValue($row['34']);
		$this->m_34->setDbValue($row['m_34']);
		$this->_35->setDbValue($row['35']);
		$this->m_35->setDbValue($row['m_35']);
		$this->_36->setDbValue($row['36']);
		$this->m_36->setDbValue($row['m_36']);
		$this->_37->setDbValue($row['37']);
		$this->m_37->setDbValue($row['m_37']);
		$this->_38->setDbValue($row['38']);
		$this->m_38->setDbValue($row['m_38']);
		$this->_39->setDbValue($row['39']);
		$this->m_39->setDbValue($row['m_39']);
		$this->_40->setDbValue($row['40']);
		$this->m_40->setDbValue($row['m_40']);
		$this->_41->setDbValue($row['41']);
		$this->m_41->setDbValue($row['m_41']);
		$this->_42->setDbValue($row['42']);
		$this->m_42->setDbValue($row['m_42']);
		$this->_43->setDbValue($row['43']);
		$this->m_43->setDbValue($row['m_43']);
		$this->_44->setDbValue($row['44']);
		$this->m_44->setDbValue($row['m_44']);
		$this->_45->setDbValue($row['45']);
		$this->m_45->setDbValue($row['m_45']);
		$this->_46->setDbValue($row['46']);
		$this->m_46->setDbValue($row['m_46']);
		$this->_47->setDbValue($row['47']);
		$this->m_47->setDbValue($row['m_47']);
		$this->_48->setDbValue($row['48']);
		$this->m_48->setDbValue($row['m_48']);
		$this->_49->setDbValue($row['49']);
		$this->m_49->setDbValue($row['m_49']);
		$this->_50->setDbValue($row['50']);
		$this->m_50->setDbValue($row['m_50']);
		$this->_51->setDbValue($row['51']);
		$this->m_51->setDbValue($row['m_51']);
		$this->_52->setDbValue($row['52']);
		$this->m_52->setDbValue($row['m_52']);
		$this->_53->setDbValue($row['53']);
		$this->m_53->setDbValue($row['m_53']);
		$this->_54->setDbValue($row['54']);
		$this->m_54->setDbValue($row['m_54']);
		$this->_55->setDbValue($row['55']);
		$this->m_55->setDbValue($row['m_55']);
		$this->_56->setDbValue($row['56']);
		$this->m_56->setDbValue($row['m_56']);
		$this->_57->setDbValue($row['57']);
		$this->m_57->setDbValue($row['m_57']);
		$this->_58->setDbValue($row['58']);
		$this->m_58->setDbValue($row['m_58']);
		$this->_59->setDbValue($row['59']);
		$this->m_59->setDbValue($row['m_59']);
		$this->_60->setDbValue($row['60']);
		$this->m_60->setDbValue($row['m_60']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['roll_no'] = NULL;
		$row['test_id'] = NULL;
		$row['total'] = NULL;
		$row['percent'] = NULL;
		$row['s_1'] = NULL;
		$row['s_2'] = NULL;
		$row['s_3'] = NULL;
		$row['s_4'] = NULL;
		$row['s_5'] = NULL;
		$row['omr_image'] = NULL;
		$row['1'] = NULL;
		$row['m_1'] = NULL;
		$row['2'] = NULL;
		$row['m_2'] = NULL;
		$row['3'] = NULL;
		$row['m_3'] = NULL;
		$row['4'] = NULL;
		$row['m_4'] = NULL;
		$row['5'] = NULL;
		$row['m_5'] = NULL;
		$row['6'] = NULL;
		$row['m_6'] = NULL;
		$row['7'] = NULL;
		$row['m_7'] = NULL;
		$row['8'] = NULL;
		$row['m_8'] = NULL;
		$row['9'] = NULL;
		$row['m_9'] = NULL;
		$row['10'] = NULL;
		$row['m_10'] = NULL;
		$row['11'] = NULL;
		$row['m_11'] = NULL;
		$row['12'] = NULL;
		$row['m_12'] = NULL;
		$row['13'] = NULL;
		$row['m_13'] = NULL;
		$row['14'] = NULL;
		$row['m_14'] = NULL;
		$row['15'] = NULL;
		$row['m_15'] = NULL;
		$row['16'] = NULL;
		$row['m_16'] = NULL;
		$row['17'] = NULL;
		$row['m_17'] = NULL;
		$row['18'] = NULL;
		$row['m_18'] = NULL;
		$row['19'] = NULL;
		$row['m_19'] = NULL;
		$row['20'] = NULL;
		$row['m_20'] = NULL;
		$row['21'] = NULL;
		$row['m_21'] = NULL;
		$row['22'] = NULL;
		$row['m_22'] = NULL;
		$row['23'] = NULL;
		$row['m_23'] = NULL;
		$row['24'] = NULL;
		$row['m_24'] = NULL;
		$row['25'] = NULL;
		$row['m_25'] = NULL;
		$row['26'] = NULL;
		$row['m_26'] = NULL;
		$row['27'] = NULL;
		$row['m_27'] = NULL;
		$row['28'] = NULL;
		$row['m_28'] = NULL;
		$row['29'] = NULL;
		$row['m_29'] = NULL;
		$row['30'] = NULL;
		$row['m_30'] = NULL;
		$row['31'] = NULL;
		$row['m_31'] = NULL;
		$row['32'] = NULL;
		$row['m_32'] = NULL;
		$row['33'] = NULL;
		$row['m_33'] = NULL;
		$row['34'] = NULL;
		$row['m_34'] = NULL;
		$row['35'] = NULL;
		$row['m_35'] = NULL;
		$row['36'] = NULL;
		$row['m_36'] = NULL;
		$row['37'] = NULL;
		$row['m_37'] = NULL;
		$row['38'] = NULL;
		$row['m_38'] = NULL;
		$row['39'] = NULL;
		$row['m_39'] = NULL;
		$row['40'] = NULL;
		$row['m_40'] = NULL;
		$row['41'] = NULL;
		$row['m_41'] = NULL;
		$row['42'] = NULL;
		$row['m_42'] = NULL;
		$row['43'] = NULL;
		$row['m_43'] = NULL;
		$row['44'] = NULL;
		$row['m_44'] = NULL;
		$row['45'] = NULL;
		$row['m_45'] = NULL;
		$row['46'] = NULL;
		$row['m_46'] = NULL;
		$row['47'] = NULL;
		$row['m_47'] = NULL;
		$row['48'] = NULL;
		$row['m_48'] = NULL;
		$row['49'] = NULL;
		$row['m_49'] = NULL;
		$row['50'] = NULL;
		$row['m_50'] = NULL;
		$row['51'] = NULL;
		$row['m_51'] = NULL;
		$row['52'] = NULL;
		$row['m_52'] = NULL;
		$row['53'] = NULL;
		$row['m_53'] = NULL;
		$row['54'] = NULL;
		$row['m_54'] = NULL;
		$row['55'] = NULL;
		$row['m_55'] = NULL;
		$row['56'] = NULL;
		$row['m_56'] = NULL;
		$row['57'] = NULL;
		$row['m_57'] = NULL;
		$row['58'] = NULL;
		$row['m_58'] = NULL;
		$row['59'] = NULL;
		$row['m_59'] = NULL;
		$row['60'] = NULL;
		$row['m_60'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->total->FormValue == $this->total->CurrentValue && is_numeric(ConvertToFloatString($this->total->CurrentValue)))
			$this->total->CurrentValue = ConvertToFloatString($this->total->CurrentValue);

		// Convert decimal values if posted back
		if ($this->percent->FormValue == $this->percent->CurrentValue && is_numeric(ConvertToFloatString($this->percent->CurrentValue)))
			$this->percent->CurrentValue = ConvertToFloatString($this->percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_1->FormValue == $this->s_1->CurrentValue && is_numeric(ConvertToFloatString($this->s_1->CurrentValue)))
			$this->s_1->CurrentValue = ConvertToFloatString($this->s_1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_2->FormValue == $this->s_2->CurrentValue && is_numeric(ConvertToFloatString($this->s_2->CurrentValue)))
			$this->s_2->CurrentValue = ConvertToFloatString($this->s_2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_3->FormValue == $this->s_3->CurrentValue && is_numeric(ConvertToFloatString($this->s_3->CurrentValue)))
			$this->s_3->CurrentValue = ConvertToFloatString($this->s_3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_4->FormValue == $this->s_4->CurrentValue && is_numeric(ConvertToFloatString($this->s_4->CurrentValue)))
			$this->s_4->CurrentValue = ConvertToFloatString($this->s_4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_5->FormValue == $this->s_5->CurrentValue && is_numeric(ConvertToFloatString($this->s_5->CurrentValue)))
			$this->s_5->CurrentValue = ConvertToFloatString($this->s_5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_1->FormValue == $this->m_1->CurrentValue && is_numeric(ConvertToFloatString($this->m_1->CurrentValue)))
			$this->m_1->CurrentValue = ConvertToFloatString($this->m_1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_2->FormValue == $this->m_2->CurrentValue && is_numeric(ConvertToFloatString($this->m_2->CurrentValue)))
			$this->m_2->CurrentValue = ConvertToFloatString($this->m_2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_3->FormValue == $this->m_3->CurrentValue && is_numeric(ConvertToFloatString($this->m_3->CurrentValue)))
			$this->m_3->CurrentValue = ConvertToFloatString($this->m_3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_4->FormValue == $this->m_4->CurrentValue && is_numeric(ConvertToFloatString($this->m_4->CurrentValue)))
			$this->m_4->CurrentValue = ConvertToFloatString($this->m_4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_5->FormValue == $this->m_5->CurrentValue && is_numeric(ConvertToFloatString($this->m_5->CurrentValue)))
			$this->m_5->CurrentValue = ConvertToFloatString($this->m_5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_6->FormValue == $this->m_6->CurrentValue && is_numeric(ConvertToFloatString($this->m_6->CurrentValue)))
			$this->m_6->CurrentValue = ConvertToFloatString($this->m_6->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_7->FormValue == $this->m_7->CurrentValue && is_numeric(ConvertToFloatString($this->m_7->CurrentValue)))
			$this->m_7->CurrentValue = ConvertToFloatString($this->m_7->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_8->FormValue == $this->m_8->CurrentValue && is_numeric(ConvertToFloatString($this->m_8->CurrentValue)))
			$this->m_8->CurrentValue = ConvertToFloatString($this->m_8->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_9->FormValue == $this->m_9->CurrentValue && is_numeric(ConvertToFloatString($this->m_9->CurrentValue)))
			$this->m_9->CurrentValue = ConvertToFloatString($this->m_9->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_10->FormValue == $this->m_10->CurrentValue && is_numeric(ConvertToFloatString($this->m_10->CurrentValue)))
			$this->m_10->CurrentValue = ConvertToFloatString($this->m_10->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_11->FormValue == $this->m_11->CurrentValue && is_numeric(ConvertToFloatString($this->m_11->CurrentValue)))
			$this->m_11->CurrentValue = ConvertToFloatString($this->m_11->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_12->FormValue == $this->m_12->CurrentValue && is_numeric(ConvertToFloatString($this->m_12->CurrentValue)))
			$this->m_12->CurrentValue = ConvertToFloatString($this->m_12->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_13->FormValue == $this->m_13->CurrentValue && is_numeric(ConvertToFloatString($this->m_13->CurrentValue)))
			$this->m_13->CurrentValue = ConvertToFloatString($this->m_13->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_14->FormValue == $this->m_14->CurrentValue && is_numeric(ConvertToFloatString($this->m_14->CurrentValue)))
			$this->m_14->CurrentValue = ConvertToFloatString($this->m_14->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_15->FormValue == $this->m_15->CurrentValue && is_numeric(ConvertToFloatString($this->m_15->CurrentValue)))
			$this->m_15->CurrentValue = ConvertToFloatString($this->m_15->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_16->FormValue == $this->m_16->CurrentValue && is_numeric(ConvertToFloatString($this->m_16->CurrentValue)))
			$this->m_16->CurrentValue = ConvertToFloatString($this->m_16->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_17->FormValue == $this->m_17->CurrentValue && is_numeric(ConvertToFloatString($this->m_17->CurrentValue)))
			$this->m_17->CurrentValue = ConvertToFloatString($this->m_17->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_18->FormValue == $this->m_18->CurrentValue && is_numeric(ConvertToFloatString($this->m_18->CurrentValue)))
			$this->m_18->CurrentValue = ConvertToFloatString($this->m_18->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_19->FormValue == $this->m_19->CurrentValue && is_numeric(ConvertToFloatString($this->m_19->CurrentValue)))
			$this->m_19->CurrentValue = ConvertToFloatString($this->m_19->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_20->FormValue == $this->m_20->CurrentValue && is_numeric(ConvertToFloatString($this->m_20->CurrentValue)))
			$this->m_20->CurrentValue = ConvertToFloatString($this->m_20->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_21->FormValue == $this->m_21->CurrentValue && is_numeric(ConvertToFloatString($this->m_21->CurrentValue)))
			$this->m_21->CurrentValue = ConvertToFloatString($this->m_21->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_22->FormValue == $this->m_22->CurrentValue && is_numeric(ConvertToFloatString($this->m_22->CurrentValue)))
			$this->m_22->CurrentValue = ConvertToFloatString($this->m_22->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_23->FormValue == $this->m_23->CurrentValue && is_numeric(ConvertToFloatString($this->m_23->CurrentValue)))
			$this->m_23->CurrentValue = ConvertToFloatString($this->m_23->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_24->FormValue == $this->m_24->CurrentValue && is_numeric(ConvertToFloatString($this->m_24->CurrentValue)))
			$this->m_24->CurrentValue = ConvertToFloatString($this->m_24->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_25->FormValue == $this->m_25->CurrentValue && is_numeric(ConvertToFloatString($this->m_25->CurrentValue)))
			$this->m_25->CurrentValue = ConvertToFloatString($this->m_25->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_26->FormValue == $this->m_26->CurrentValue && is_numeric(ConvertToFloatString($this->m_26->CurrentValue)))
			$this->m_26->CurrentValue = ConvertToFloatString($this->m_26->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_27->FormValue == $this->m_27->CurrentValue && is_numeric(ConvertToFloatString($this->m_27->CurrentValue)))
			$this->m_27->CurrentValue = ConvertToFloatString($this->m_27->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_28->FormValue == $this->m_28->CurrentValue && is_numeric(ConvertToFloatString($this->m_28->CurrentValue)))
			$this->m_28->CurrentValue = ConvertToFloatString($this->m_28->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_29->FormValue == $this->m_29->CurrentValue && is_numeric(ConvertToFloatString($this->m_29->CurrentValue)))
			$this->m_29->CurrentValue = ConvertToFloatString($this->m_29->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_30->FormValue == $this->m_30->CurrentValue && is_numeric(ConvertToFloatString($this->m_30->CurrentValue)))
			$this->m_30->CurrentValue = ConvertToFloatString($this->m_30->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_31->FormValue == $this->m_31->CurrentValue && is_numeric(ConvertToFloatString($this->m_31->CurrentValue)))
			$this->m_31->CurrentValue = ConvertToFloatString($this->m_31->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_32->FormValue == $this->m_32->CurrentValue && is_numeric(ConvertToFloatString($this->m_32->CurrentValue)))
			$this->m_32->CurrentValue = ConvertToFloatString($this->m_32->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_33->FormValue == $this->m_33->CurrentValue && is_numeric(ConvertToFloatString($this->m_33->CurrentValue)))
			$this->m_33->CurrentValue = ConvertToFloatString($this->m_33->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_34->FormValue == $this->m_34->CurrentValue && is_numeric(ConvertToFloatString($this->m_34->CurrentValue)))
			$this->m_34->CurrentValue = ConvertToFloatString($this->m_34->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_35->FormValue == $this->m_35->CurrentValue && is_numeric(ConvertToFloatString($this->m_35->CurrentValue)))
			$this->m_35->CurrentValue = ConvertToFloatString($this->m_35->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_36->FormValue == $this->m_36->CurrentValue && is_numeric(ConvertToFloatString($this->m_36->CurrentValue)))
			$this->m_36->CurrentValue = ConvertToFloatString($this->m_36->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_37->FormValue == $this->m_37->CurrentValue && is_numeric(ConvertToFloatString($this->m_37->CurrentValue)))
			$this->m_37->CurrentValue = ConvertToFloatString($this->m_37->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_38->FormValue == $this->m_38->CurrentValue && is_numeric(ConvertToFloatString($this->m_38->CurrentValue)))
			$this->m_38->CurrentValue = ConvertToFloatString($this->m_38->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_39->FormValue == $this->m_39->CurrentValue && is_numeric(ConvertToFloatString($this->m_39->CurrentValue)))
			$this->m_39->CurrentValue = ConvertToFloatString($this->m_39->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_40->FormValue == $this->m_40->CurrentValue && is_numeric(ConvertToFloatString($this->m_40->CurrentValue)))
			$this->m_40->CurrentValue = ConvertToFloatString($this->m_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_41->FormValue == $this->m_41->CurrentValue && is_numeric(ConvertToFloatString($this->m_41->CurrentValue)))
			$this->m_41->CurrentValue = ConvertToFloatString($this->m_41->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_42->FormValue == $this->m_42->CurrentValue && is_numeric(ConvertToFloatString($this->m_42->CurrentValue)))
			$this->m_42->CurrentValue = ConvertToFloatString($this->m_42->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_43->FormValue == $this->m_43->CurrentValue && is_numeric(ConvertToFloatString($this->m_43->CurrentValue)))
			$this->m_43->CurrentValue = ConvertToFloatString($this->m_43->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_44->FormValue == $this->m_44->CurrentValue && is_numeric(ConvertToFloatString($this->m_44->CurrentValue)))
			$this->m_44->CurrentValue = ConvertToFloatString($this->m_44->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_45->FormValue == $this->m_45->CurrentValue && is_numeric(ConvertToFloatString($this->m_45->CurrentValue)))
			$this->m_45->CurrentValue = ConvertToFloatString($this->m_45->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_46->FormValue == $this->m_46->CurrentValue && is_numeric(ConvertToFloatString($this->m_46->CurrentValue)))
			$this->m_46->CurrentValue = ConvertToFloatString($this->m_46->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_47->FormValue == $this->m_47->CurrentValue && is_numeric(ConvertToFloatString($this->m_47->CurrentValue)))
			$this->m_47->CurrentValue = ConvertToFloatString($this->m_47->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_48->FormValue == $this->m_48->CurrentValue && is_numeric(ConvertToFloatString($this->m_48->CurrentValue)))
			$this->m_48->CurrentValue = ConvertToFloatString($this->m_48->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_49->FormValue == $this->m_49->CurrentValue && is_numeric(ConvertToFloatString($this->m_49->CurrentValue)))
			$this->m_49->CurrentValue = ConvertToFloatString($this->m_49->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_50->FormValue == $this->m_50->CurrentValue && is_numeric(ConvertToFloatString($this->m_50->CurrentValue)))
			$this->m_50->CurrentValue = ConvertToFloatString($this->m_50->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_51->FormValue == $this->m_51->CurrentValue && is_numeric(ConvertToFloatString($this->m_51->CurrentValue)))
			$this->m_51->CurrentValue = ConvertToFloatString($this->m_51->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_52->FormValue == $this->m_52->CurrentValue && is_numeric(ConvertToFloatString($this->m_52->CurrentValue)))
			$this->m_52->CurrentValue = ConvertToFloatString($this->m_52->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_53->FormValue == $this->m_53->CurrentValue && is_numeric(ConvertToFloatString($this->m_53->CurrentValue)))
			$this->m_53->CurrentValue = ConvertToFloatString($this->m_53->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_54->FormValue == $this->m_54->CurrentValue && is_numeric(ConvertToFloatString($this->m_54->CurrentValue)))
			$this->m_54->CurrentValue = ConvertToFloatString($this->m_54->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_55->FormValue == $this->m_55->CurrentValue && is_numeric(ConvertToFloatString($this->m_55->CurrentValue)))
			$this->m_55->CurrentValue = ConvertToFloatString($this->m_55->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_56->FormValue == $this->m_56->CurrentValue && is_numeric(ConvertToFloatString($this->m_56->CurrentValue)))
			$this->m_56->CurrentValue = ConvertToFloatString($this->m_56->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_57->FormValue == $this->m_57->CurrentValue && is_numeric(ConvertToFloatString($this->m_57->CurrentValue)))
			$this->m_57->CurrentValue = ConvertToFloatString($this->m_57->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_58->FormValue == $this->m_58->CurrentValue && is_numeric(ConvertToFloatString($this->m_58->CurrentValue)))
			$this->m_58->CurrentValue = ConvertToFloatString($this->m_58->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_59->FormValue == $this->m_59->CurrentValue && is_numeric(ConvertToFloatString($this->m_59->CurrentValue)))
			$this->m_59->CurrentValue = ConvertToFloatString($this->m_59->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_60->FormValue == $this->m_60->CurrentValue && is_numeric(ConvertToFloatString($this->m_60->CurrentValue)))
			$this->m_60->CurrentValue = ConvertToFloatString($this->m_60->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// roll_no
		// test_id
		// total
		// percent
		// s_1
		// s_2
		// s_3
		// s_4
		// s_5
		// omr_image
		// 1
		// m_1
		// 2
		// m_2
		// 3
		// m_3
		// 4
		// m_4
		// 5
		// m_5
		// 6
		// m_6
		// 7
		// m_7
		// 8
		// m_8
		// 9
		// m_9
		// 10
		// m_10
		// 11
		// m_11
		// 12
		// m_12
		// 13
		// m_13
		// 14
		// m_14
		// 15
		// m_15
		// 16
		// m_16
		// 17
		// m_17
		// 18
		// m_18
		// 19
		// m_19
		// 20
		// m_20
		// 21
		// m_21
		// 22
		// m_22
		// 23
		// m_23
		// 24
		// m_24
		// 25
		// m_25
		// 26
		// m_26
		// 27
		// m_27
		// 28
		// m_28
		// 29
		// m_29
		// 30
		// m_30
		// 31
		// m_31
		// 32
		// m_32
		// 33
		// m_33
		// 34
		// m_34
		// 35
		// m_35
		// 36
		// m_36
		// 37
		// m_37
		// 38
		// m_38
		// 39
		// m_39
		// 40
		// m_40
		// 41
		// m_41
		// 42
		// m_42
		// 43
		// m_43
		// 44
		// m_44
		// 45
		// m_45
		// 46
		// m_46
		// 47
		// m_47
		// 48
		// m_48
		// 49
		// m_49
		// 50
		// m_50
		// 51
		// m_51
		// 52
		// m_52
		// 53
		// m_53
		// 54
		// m_54
		// 55
		// m_55
		// 56
		// m_56
		// 57
		// m_57
		// 58
		// m_58
		// 59
		// m_59
		// 60
		// m_60

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewCustomAttributes = "";

			// test_id
			$this->test_id->ViewValue = $this->test_id->CurrentValue;
			$this->test_id->ViewCustomAttributes = "";

			// total
			$this->total->ViewValue = $this->total->CurrentValue;
			$this->total->ViewValue = FormatNumber($this->total->ViewValue, 2, -2, -2, -2);
			$this->total->ViewCustomAttributes = "";

			// percent
			$this->percent->ViewValue = $this->percent->CurrentValue;
			$this->percent->ViewValue = FormatNumber($this->percent->ViewValue, 2, -2, -2, -2);
			$this->percent->ViewCustomAttributes = "";

			// s_1
			$this->s_1->ViewValue = $this->s_1->CurrentValue;
			$this->s_1->ViewValue = FormatNumber($this->s_1->ViewValue, 2, -2, -2, -2);
			$this->s_1->ViewCustomAttributes = "";

			// s_2
			$this->s_2->ViewValue = $this->s_2->CurrentValue;
			$this->s_2->ViewValue = FormatNumber($this->s_2->ViewValue, 2, -2, -2, -2);
			$this->s_2->ViewCustomAttributes = "";

			// s_3
			$this->s_3->ViewValue = $this->s_3->CurrentValue;
			$this->s_3->ViewValue = FormatNumber($this->s_3->ViewValue, 2, -2, -2, -2);
			$this->s_3->ViewCustomAttributes = "";

			// s_4
			$this->s_4->ViewValue = $this->s_4->CurrentValue;
			$this->s_4->ViewValue = FormatNumber($this->s_4->ViewValue, 2, -2, -2, -2);
			$this->s_4->ViewCustomAttributes = "";

			// s_5
			$this->s_5->ViewValue = $this->s_5->CurrentValue;
			$this->s_5->ViewValue = FormatNumber($this->s_5->ViewValue, 2, -2, -2, -2);
			$this->s_5->ViewCustomAttributes = "";

			// omr_image
			$this->omr_image->UploadPath = '.p_uploads/school/omr/';
			if (!EmptyValue($this->omr_image->Upload->DbValue)) {
				$this->omr_image->ImageWidth = 0;
				$this->omr_image->ImageHeight = 50;
				$this->omr_image->ImageAlt = $this->omr_image->alt();
				$this->omr_image->ViewValue = $this->omr_image->Upload->DbValue;
			} else {
				$this->omr_image->ViewValue = "";
			}
			$this->omr_image->ViewCustomAttributes = "";

			// 1
			$this->_1->ViewValue = $this->_1->CurrentValue;
			$this->_1->ViewCustomAttributes = "";

			// m_1
			$this->m_1->ViewValue = $this->m_1->CurrentValue;
			$this->m_1->ViewValue = FormatNumber($this->m_1->ViewValue, 2, -2, -2, -2);
			$this->m_1->ViewCustomAttributes = "";

			// 2
			$this->_2->ViewValue = $this->_2->CurrentValue;
			$this->_2->ViewCustomAttributes = "";

			// m_2
			$this->m_2->ViewValue = $this->m_2->CurrentValue;
			$this->m_2->ViewValue = FormatNumber($this->m_2->ViewValue, 2, -2, -2, -2);
			$this->m_2->ViewCustomAttributes = "";

			// 3
			$this->_3->ViewValue = $this->_3->CurrentValue;
			$this->_3->ViewCustomAttributes = "";

			// m_3
			$this->m_3->ViewValue = $this->m_3->CurrentValue;
			$this->m_3->ViewValue = FormatNumber($this->m_3->ViewValue, 2, -2, -2, -2);
			$this->m_3->ViewCustomAttributes = "";

			// 4
			$this->_4->ViewValue = $this->_4->CurrentValue;
			$this->_4->ViewCustomAttributes = "";

			// m_4
			$this->m_4->ViewValue = $this->m_4->CurrentValue;
			$this->m_4->ViewValue = FormatNumber($this->m_4->ViewValue, 2, -2, -2, -2);
			$this->m_4->ViewCustomAttributes = "";

			// 5
			$this->_5->ViewValue = $this->_5->CurrentValue;
			$this->_5->ViewCustomAttributes = "";

			// m_5
			$this->m_5->ViewValue = $this->m_5->CurrentValue;
			$this->m_5->ViewValue = FormatNumber($this->m_5->ViewValue, 2, -2, -2, -2);
			$this->m_5->ViewCustomAttributes = "";

			// 6
			$this->_6->ViewValue = $this->_6->CurrentValue;
			$this->_6->ViewCustomAttributes = "";

			// m_6
			$this->m_6->ViewValue = $this->m_6->CurrentValue;
			$this->m_6->ViewValue = FormatNumber($this->m_6->ViewValue, 2, -2, -2, -2);
			$this->m_6->ViewCustomAttributes = "";

			// 7
			$this->_7->ViewValue = $this->_7->CurrentValue;
			$this->_7->ViewCustomAttributes = "";

			// m_7
			$this->m_7->ViewValue = $this->m_7->CurrentValue;
			$this->m_7->ViewValue = FormatNumber($this->m_7->ViewValue, 2, -2, -2, -2);
			$this->m_7->ViewCustomAttributes = "";

			// 8
			$this->_8->ViewValue = $this->_8->CurrentValue;
			$this->_8->ViewCustomAttributes = "";

			// m_8
			$this->m_8->ViewValue = $this->m_8->CurrentValue;
			$this->m_8->ViewValue = FormatNumber($this->m_8->ViewValue, 2, -2, -2, -2);
			$this->m_8->ViewCustomAttributes = "";

			// 9
			$this->_9->ViewValue = $this->_9->CurrentValue;
			$this->_9->ViewCustomAttributes = "";

			// m_9
			$this->m_9->ViewValue = $this->m_9->CurrentValue;
			$this->m_9->ViewValue = FormatNumber($this->m_9->ViewValue, 2, -2, -2, -2);
			$this->m_9->ViewCustomAttributes = "";

			// 10
			$this->_10->ViewValue = $this->_10->CurrentValue;
			$this->_10->ViewCustomAttributes = "";

			// m_10
			$this->m_10->ViewValue = $this->m_10->CurrentValue;
			$this->m_10->ViewValue = FormatNumber($this->m_10->ViewValue, 2, -2, -2, -2);
			$this->m_10->ViewCustomAttributes = "";

			// 11
			$this->_11->ViewValue = $this->_11->CurrentValue;
			$this->_11->ViewCustomAttributes = "";

			// m_11
			$this->m_11->ViewValue = $this->m_11->CurrentValue;
			$this->m_11->ViewValue = FormatNumber($this->m_11->ViewValue, 2, -2, -2, -2);
			$this->m_11->ViewCustomAttributes = "";

			// 12
			$this->_12->ViewValue = $this->_12->CurrentValue;
			$this->_12->ViewCustomAttributes = "";

			// m_12
			$this->m_12->ViewValue = $this->m_12->CurrentValue;
			$this->m_12->ViewValue = FormatNumber($this->m_12->ViewValue, 2, -2, -2, -2);
			$this->m_12->ViewCustomAttributes = "";

			// 13
			$this->_13->ViewValue = $this->_13->CurrentValue;
			$this->_13->ViewCustomAttributes = "";

			// m_13
			$this->m_13->ViewValue = $this->m_13->CurrentValue;
			$this->m_13->ViewValue = FormatNumber($this->m_13->ViewValue, 2, -2, -2, -2);
			$this->m_13->ViewCustomAttributes = "";

			// 14
			$this->_14->ViewValue = $this->_14->CurrentValue;
			$this->_14->ViewCustomAttributes = "";

			// m_14
			$this->m_14->ViewValue = $this->m_14->CurrentValue;
			$this->m_14->ViewValue = FormatNumber($this->m_14->ViewValue, 2, -2, -2, -2);
			$this->m_14->ViewCustomAttributes = "";

			// 15
			$this->_15->ViewValue = $this->_15->CurrentValue;
			$this->_15->ViewCustomAttributes = "";

			// m_15
			$this->m_15->ViewValue = $this->m_15->CurrentValue;
			$this->m_15->ViewValue = FormatNumber($this->m_15->ViewValue, 2, -2, -2, -2);
			$this->m_15->ViewCustomAttributes = "";

			// 16
			$this->_16->ViewValue = $this->_16->CurrentValue;
			$this->_16->ViewCustomAttributes = "";

			// m_16
			$this->m_16->ViewValue = $this->m_16->CurrentValue;
			$this->m_16->ViewValue = FormatNumber($this->m_16->ViewValue, 2, -2, -2, -2);
			$this->m_16->ViewCustomAttributes = "";

			// 17
			$this->_17->ViewValue = $this->_17->CurrentValue;
			$this->_17->ViewCustomAttributes = "";

			// m_17
			$this->m_17->ViewValue = $this->m_17->CurrentValue;
			$this->m_17->ViewValue = FormatNumber($this->m_17->ViewValue, 2, -2, -2, -2);
			$this->m_17->ViewCustomAttributes = "";

			// 18
			$this->_18->ViewValue = $this->_18->CurrentValue;
			$this->_18->ViewCustomAttributes = "";

			// m_18
			$this->m_18->ViewValue = $this->m_18->CurrentValue;
			$this->m_18->ViewValue = FormatNumber($this->m_18->ViewValue, 2, -2, -2, -2);
			$this->m_18->ViewCustomAttributes = "";

			// 19
			$this->_19->ViewValue = $this->_19->CurrentValue;
			$this->_19->ViewCustomAttributes = "";

			// m_19
			$this->m_19->ViewValue = $this->m_19->CurrentValue;
			$this->m_19->ViewValue = FormatNumber($this->m_19->ViewValue, 2, -2, -2, -2);
			$this->m_19->ViewCustomAttributes = "";

			// 20
			$this->_20->ViewValue = $this->_20->CurrentValue;
			$this->_20->ViewCustomAttributes = "";

			// m_20
			$this->m_20->ViewValue = $this->m_20->CurrentValue;
			$this->m_20->ViewValue = FormatNumber($this->m_20->ViewValue, 2, -2, -2, -2);
			$this->m_20->ViewCustomAttributes = "";

			// 21
			$this->_21->ViewValue = $this->_21->CurrentValue;
			$this->_21->ViewCustomAttributes = "";

			// m_21
			$this->m_21->ViewValue = $this->m_21->CurrentValue;
			$this->m_21->ViewValue = FormatNumber($this->m_21->ViewValue, 2, -2, -2, -2);
			$this->m_21->ViewCustomAttributes = "";

			// 22
			$this->_22->ViewValue = $this->_22->CurrentValue;
			$this->_22->ViewCustomAttributes = "";

			// m_22
			$this->m_22->ViewValue = $this->m_22->CurrentValue;
			$this->m_22->ViewValue = FormatNumber($this->m_22->ViewValue, 2, -2, -2, -2);
			$this->m_22->ViewCustomAttributes = "";

			// 23
			$this->_23->ViewValue = $this->_23->CurrentValue;
			$this->_23->ViewCustomAttributes = "";

			// m_23
			$this->m_23->ViewValue = $this->m_23->CurrentValue;
			$this->m_23->ViewValue = FormatNumber($this->m_23->ViewValue, 2, -2, -2, -2);
			$this->m_23->ViewCustomAttributes = "";

			// 24
			$this->_24->ViewValue = $this->_24->CurrentValue;
			$this->_24->ViewCustomAttributes = "";

			// m_24
			$this->m_24->ViewValue = $this->m_24->CurrentValue;
			$this->m_24->ViewValue = FormatNumber($this->m_24->ViewValue, 2, -2, -2, -2);
			$this->m_24->ViewCustomAttributes = "";

			// 25
			$this->_25->ViewValue = $this->_25->CurrentValue;
			$this->_25->ViewCustomAttributes = "";

			// m_25
			$this->m_25->ViewValue = $this->m_25->CurrentValue;
			$this->m_25->ViewValue = FormatNumber($this->m_25->ViewValue, 2, -2, -2, -2);
			$this->m_25->ViewCustomAttributes = "";

			// 26
			$this->_26->ViewValue = $this->_26->CurrentValue;
			$this->_26->ViewCustomAttributes = "";

			// m_26
			$this->m_26->ViewValue = $this->m_26->CurrentValue;
			$this->m_26->ViewValue = FormatNumber($this->m_26->ViewValue, 2, -2, -2, -2);
			$this->m_26->ViewCustomAttributes = "";

			// 27
			$this->_27->ViewValue = $this->_27->CurrentValue;
			$this->_27->ViewCustomAttributes = "";

			// m_27
			$this->m_27->ViewValue = $this->m_27->CurrentValue;
			$this->m_27->ViewValue = FormatNumber($this->m_27->ViewValue, 2, -2, -2, -2);
			$this->m_27->ViewCustomAttributes = "";

			// 28
			$this->_28->ViewValue = $this->_28->CurrentValue;
			$this->_28->ViewCustomAttributes = "";

			// m_28
			$this->m_28->ViewValue = $this->m_28->CurrentValue;
			$this->m_28->ViewValue = FormatNumber($this->m_28->ViewValue, 2, -2, -2, -2);
			$this->m_28->ViewCustomAttributes = "";

			// 29
			$this->_29->ViewValue = $this->_29->CurrentValue;
			$this->_29->ViewCustomAttributes = "";

			// m_29
			$this->m_29->ViewValue = $this->m_29->CurrentValue;
			$this->m_29->ViewValue = FormatNumber($this->m_29->ViewValue, 2, -2, -2, -2);
			$this->m_29->ViewCustomAttributes = "";

			// 30
			$this->_30->ViewValue = $this->_30->CurrentValue;
			$this->_30->ViewCustomAttributes = "";

			// m_30
			$this->m_30->ViewValue = $this->m_30->CurrentValue;
			$this->m_30->ViewValue = FormatNumber($this->m_30->ViewValue, 2, -2, -2, -2);
			$this->m_30->ViewCustomAttributes = "";

			// 31
			$this->_31->ViewValue = $this->_31->CurrentValue;
			$this->_31->ViewCustomAttributes = "";

			// m_31
			$this->m_31->ViewValue = $this->m_31->CurrentValue;
			$this->m_31->ViewValue = FormatNumber($this->m_31->ViewValue, 2, -2, -2, -2);
			$this->m_31->ViewCustomAttributes = "";

			// 32
			$this->_32->ViewValue = $this->_32->CurrentValue;
			$this->_32->ViewCustomAttributes = "";

			// m_32
			$this->m_32->ViewValue = $this->m_32->CurrentValue;
			$this->m_32->ViewValue = FormatNumber($this->m_32->ViewValue, 2, -2, -2, -2);
			$this->m_32->ViewCustomAttributes = "";

			// 33
			$this->_33->ViewValue = $this->_33->CurrentValue;
			$this->_33->ViewCustomAttributes = "";

			// m_33
			$this->m_33->ViewValue = $this->m_33->CurrentValue;
			$this->m_33->ViewValue = FormatNumber($this->m_33->ViewValue, 2, -2, -2, -2);
			$this->m_33->ViewCustomAttributes = "";

			// 34
			$this->_34->ViewValue = $this->_34->CurrentValue;
			$this->_34->ViewCustomAttributes = "";

			// m_34
			$this->m_34->ViewValue = $this->m_34->CurrentValue;
			$this->m_34->ViewValue = FormatNumber($this->m_34->ViewValue, 2, -2, -2, -2);
			$this->m_34->ViewCustomAttributes = "";

			// 35
			$this->_35->ViewValue = $this->_35->CurrentValue;
			$this->_35->ViewCustomAttributes = "";

			// m_35
			$this->m_35->ViewValue = $this->m_35->CurrentValue;
			$this->m_35->ViewValue = FormatNumber($this->m_35->ViewValue, 2, -2, -2, -2);
			$this->m_35->ViewCustomAttributes = "";

			// 36
			$this->_36->ViewValue = $this->_36->CurrentValue;
			$this->_36->ViewCustomAttributes = "";

			// m_36
			$this->m_36->ViewValue = $this->m_36->CurrentValue;
			$this->m_36->ViewValue = FormatNumber($this->m_36->ViewValue, 2, -2, -2, -2);
			$this->m_36->ViewCustomAttributes = "";

			// 37
			$this->_37->ViewValue = $this->_37->CurrentValue;
			$this->_37->ViewCustomAttributes = "";

			// m_37
			$this->m_37->ViewValue = $this->m_37->CurrentValue;
			$this->m_37->ViewValue = FormatNumber($this->m_37->ViewValue, 2, -2, -2, -2);
			$this->m_37->ViewCustomAttributes = "";

			// 38
			$this->_38->ViewValue = $this->_38->CurrentValue;
			$this->_38->ViewCustomAttributes = "";

			// m_38
			$this->m_38->ViewValue = $this->m_38->CurrentValue;
			$this->m_38->ViewValue = FormatNumber($this->m_38->ViewValue, 2, -2, -2, -2);
			$this->m_38->ViewCustomAttributes = "";

			// 39
			$this->_39->ViewValue = $this->_39->CurrentValue;
			$this->_39->ViewCustomAttributes = "";

			// m_39
			$this->m_39->ViewValue = $this->m_39->CurrentValue;
			$this->m_39->ViewValue = FormatNumber($this->m_39->ViewValue, 2, -2, -2, -2);
			$this->m_39->ViewCustomAttributes = "";

			// 40
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewCustomAttributes = "";

			// m_40
			$this->m_40->ViewValue = $this->m_40->CurrentValue;
			$this->m_40->ViewValue = FormatNumber($this->m_40->ViewValue, 2, -2, -2, -2);
			$this->m_40->ViewCustomAttributes = "";

			// 41
			$this->_41->ViewValue = $this->_41->CurrentValue;
			$this->_41->ViewCustomAttributes = "";

			// m_41
			$this->m_41->ViewValue = $this->m_41->CurrentValue;
			$this->m_41->ViewValue = FormatNumber($this->m_41->ViewValue, 2, -2, -2, -2);
			$this->m_41->ViewCustomAttributes = "";

			// 42
			$this->_42->ViewValue = $this->_42->CurrentValue;
			$this->_42->ViewCustomAttributes = "";

			// m_42
			$this->m_42->ViewValue = $this->m_42->CurrentValue;
			$this->m_42->ViewValue = FormatNumber($this->m_42->ViewValue, 2, -2, -2, -2);
			$this->m_42->ViewCustomAttributes = "";

			// 43
			$this->_43->ViewValue = $this->_43->CurrentValue;
			$this->_43->ViewCustomAttributes = "";

			// m_43
			$this->m_43->ViewValue = $this->m_43->CurrentValue;
			$this->m_43->ViewValue = FormatNumber($this->m_43->ViewValue, 2, -2, -2, -2);
			$this->m_43->ViewCustomAttributes = "";

			// 44
			$this->_44->ViewValue = $this->_44->CurrentValue;
			$this->_44->ViewCustomAttributes = "";

			// m_44
			$this->m_44->ViewValue = $this->m_44->CurrentValue;
			$this->m_44->ViewValue = FormatNumber($this->m_44->ViewValue, 2, -2, -2, -2);
			$this->m_44->ViewCustomAttributes = "";

			// 45
			$this->_45->ViewValue = $this->_45->CurrentValue;
			$this->_45->ViewCustomAttributes = "";

			// m_45
			$this->m_45->ViewValue = $this->m_45->CurrentValue;
			$this->m_45->ViewValue = FormatNumber($this->m_45->ViewValue, 2, -2, -2, -2);
			$this->m_45->ViewCustomAttributes = "";

			// 46
			$this->_46->ViewValue = $this->_46->CurrentValue;
			$this->_46->ViewCustomAttributes = "";

			// m_46
			$this->m_46->ViewValue = $this->m_46->CurrentValue;
			$this->m_46->ViewValue = FormatNumber($this->m_46->ViewValue, 2, -2, -2, -2);
			$this->m_46->ViewCustomAttributes = "";

			// 47
			$this->_47->ViewValue = $this->_47->CurrentValue;
			$this->_47->ViewCustomAttributes = "";

			// m_47
			$this->m_47->ViewValue = $this->m_47->CurrentValue;
			$this->m_47->ViewValue = FormatNumber($this->m_47->ViewValue, 2, -2, -2, -2);
			$this->m_47->ViewCustomAttributes = "";

			// 48
			$this->_48->ViewValue = $this->_48->CurrentValue;
			$this->_48->ViewCustomAttributes = "";

			// m_48
			$this->m_48->ViewValue = $this->m_48->CurrentValue;
			$this->m_48->ViewValue = FormatNumber($this->m_48->ViewValue, 2, -2, -2, -2);
			$this->m_48->ViewCustomAttributes = "";

			// 49
			$this->_49->ViewValue = $this->_49->CurrentValue;
			$this->_49->ViewCustomAttributes = "";

			// m_49
			$this->m_49->ViewValue = $this->m_49->CurrentValue;
			$this->m_49->ViewValue = FormatNumber($this->m_49->ViewValue, 2, -2, -2, -2);
			$this->m_49->ViewCustomAttributes = "";

			// 50
			$this->_50->ViewValue = $this->_50->CurrentValue;
			$this->_50->ViewCustomAttributes = "";

			// m_50
			$this->m_50->ViewValue = $this->m_50->CurrentValue;
			$this->m_50->ViewValue = FormatNumber($this->m_50->ViewValue, 2, -2, -2, -2);
			$this->m_50->ViewCustomAttributes = "";

			// 51
			$this->_51->ViewValue = $this->_51->CurrentValue;
			$this->_51->ViewCustomAttributes = "";

			// m_51
			$this->m_51->ViewValue = $this->m_51->CurrentValue;
			$this->m_51->ViewValue = FormatNumber($this->m_51->ViewValue, 2, -2, -2, -2);
			$this->m_51->ViewCustomAttributes = "";

			// 52
			$this->_52->ViewValue = $this->_52->CurrentValue;
			$this->_52->ViewCustomAttributes = "";

			// m_52
			$this->m_52->ViewValue = $this->m_52->CurrentValue;
			$this->m_52->ViewValue = FormatNumber($this->m_52->ViewValue, 2, -2, -2, -2);
			$this->m_52->ViewCustomAttributes = "";

			// 53
			$this->_53->ViewValue = $this->_53->CurrentValue;
			$this->_53->ViewCustomAttributes = "";

			// m_53
			$this->m_53->ViewValue = $this->m_53->CurrentValue;
			$this->m_53->ViewValue = FormatNumber($this->m_53->ViewValue, 2, -2, -2, -2);
			$this->m_53->ViewCustomAttributes = "";

			// 54
			$this->_54->ViewValue = $this->_54->CurrentValue;
			$this->_54->ViewCustomAttributes = "";

			// m_54
			$this->m_54->ViewValue = $this->m_54->CurrentValue;
			$this->m_54->ViewValue = FormatNumber($this->m_54->ViewValue, 2, -2, -2, -2);
			$this->m_54->ViewCustomAttributes = "";

			// 55
			$this->_55->ViewValue = $this->_55->CurrentValue;
			$this->_55->ViewCustomAttributes = "";

			// m_55
			$this->m_55->ViewValue = $this->m_55->CurrentValue;
			$this->m_55->ViewValue = FormatNumber($this->m_55->ViewValue, 2, -2, -2, -2);
			$this->m_55->ViewCustomAttributes = "";

			// 56
			$this->_56->ViewValue = $this->_56->CurrentValue;
			$this->_56->ViewCustomAttributes = "";

			// m_56
			$this->m_56->ViewValue = $this->m_56->CurrentValue;
			$this->m_56->ViewValue = FormatNumber($this->m_56->ViewValue, 2, -2, -2, -2);
			$this->m_56->ViewCustomAttributes = "";

			// 57
			$this->_57->ViewValue = $this->_57->CurrentValue;
			$this->_57->ViewCustomAttributes = "";

			// m_57
			$this->m_57->ViewValue = $this->m_57->CurrentValue;
			$this->m_57->ViewValue = FormatNumber($this->m_57->ViewValue, 2, -2, -2, -2);
			$this->m_57->ViewCustomAttributes = "";

			// 58
			$this->_58->ViewValue = $this->_58->CurrentValue;
			$this->_58->ViewCustomAttributes = "";

			// m_58
			$this->m_58->ViewValue = $this->m_58->CurrentValue;
			$this->m_58->ViewValue = FormatNumber($this->m_58->ViewValue, 2, -2, -2, -2);
			$this->m_58->ViewCustomAttributes = "";

			// 59
			$this->_59->ViewValue = $this->_59->CurrentValue;
			$this->_59->ViewCustomAttributes = "";

			// m_59
			$this->m_59->ViewValue = $this->m_59->CurrentValue;
			$this->m_59->ViewValue = FormatNumber($this->m_59->ViewValue, 2, -2, -2, -2);
			$this->m_59->ViewCustomAttributes = "";

			// 60
			$this->_60->ViewValue = $this->_60->CurrentValue;
			$this->_60->ViewCustomAttributes = "";

			// m_60
			$this->m_60->ViewValue = $this->m_60->CurrentValue;
			$this->m_60->ViewValue = FormatNumber($this->m_60->ViewValue, 2, -2, -2, -2);
			$this->m_60->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// test_id
			$this->test_id->LinkCustomAttributes = "";
			$this->test_id->HrefValue = "";
			$this->test_id->TooltipValue = "";

			// total
			$this->total->LinkCustomAttributes = "";
			$this->total->HrefValue = "";
			$this->total->TooltipValue = "";

			// percent
			$this->percent->LinkCustomAttributes = "";
			$this->percent->HrefValue = "";
			$this->percent->TooltipValue = "";

			// s_1
			$this->s_1->LinkCustomAttributes = "";
			$this->s_1->HrefValue = "";
			$this->s_1->TooltipValue = "";

			// s_2
			$this->s_2->LinkCustomAttributes = "";
			$this->s_2->HrefValue = "";
			$this->s_2->TooltipValue = "";

			// s_3
			$this->s_3->LinkCustomAttributes = "";
			$this->s_3->HrefValue = "";
			$this->s_3->TooltipValue = "";

			// s_4
			$this->s_4->LinkCustomAttributes = "";
			$this->s_4->HrefValue = "";
			$this->s_4->TooltipValue = "";

			// s_5
			$this->s_5->LinkCustomAttributes = "";
			$this->s_5->HrefValue = "";
			$this->s_5->TooltipValue = "";

			// omr_image
			$this->omr_image->LinkCustomAttributes = "";
			$this->omr_image->UploadPath = '.p_uploads/school/omr/';
			if (!EmptyValue($this->omr_image->Upload->DbValue)) {
				$this->omr_image->HrefValue = GetFileUploadUrl($this->omr_image, $this->omr_image->Upload->DbValue); // Add prefix/suffix
				$this->omr_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->omr_image->HrefValue = FullUrl($this->omr_image->HrefValue, "href");
			} else {
				$this->omr_image->HrefValue = "";
			}
			$this->omr_image->ExportHrefValue = $this->omr_image->UploadPath . $this->omr_image->Upload->DbValue;
			$this->omr_image->TooltipValue = "";
			if ($this->omr_image->UseColorbox) {
				if (EmptyValue($this->omr_image->TooltipValue))
					$this->omr_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->omr_image->LinkAttrs["data-rel"] = "s_omr_value_x_omr_image";
				AppendClass($this->omr_image->LinkAttrs["class"], "ew-lightbox");
			}

			// 1
			$this->_1->LinkCustomAttributes = "";
			$this->_1->HrefValue = "";
			$this->_1->TooltipValue = "";

			// m_1
			$this->m_1->LinkCustomAttributes = "";
			$this->m_1->HrefValue = "";
			$this->m_1->TooltipValue = "";

			// 2
			$this->_2->LinkCustomAttributes = "";
			$this->_2->HrefValue = "";
			$this->_2->TooltipValue = "";

			// m_2
			$this->m_2->LinkCustomAttributes = "";
			$this->m_2->HrefValue = "";
			$this->m_2->TooltipValue = "";

			// 3
			$this->_3->LinkCustomAttributes = "";
			$this->_3->HrefValue = "";
			$this->_3->TooltipValue = "";

			// m_3
			$this->m_3->LinkCustomAttributes = "";
			$this->m_3->HrefValue = "";
			$this->m_3->TooltipValue = "";

			// 4
			$this->_4->LinkCustomAttributes = "";
			$this->_4->HrefValue = "";
			$this->_4->TooltipValue = "";

			// m_4
			$this->m_4->LinkCustomAttributes = "";
			$this->m_4->HrefValue = "";
			$this->m_4->TooltipValue = "";

			// 5
			$this->_5->LinkCustomAttributes = "";
			$this->_5->HrefValue = "";
			$this->_5->TooltipValue = "";

			// m_5
			$this->m_5->LinkCustomAttributes = "";
			$this->m_5->HrefValue = "";
			$this->m_5->TooltipValue = "";

			// 6
			$this->_6->LinkCustomAttributes = "";
			$this->_6->HrefValue = "";
			$this->_6->TooltipValue = "";

			// m_6
			$this->m_6->LinkCustomAttributes = "";
			$this->m_6->HrefValue = "";
			$this->m_6->TooltipValue = "";

			// 7
			$this->_7->LinkCustomAttributes = "";
			$this->_7->HrefValue = "";
			$this->_7->TooltipValue = "";

			// m_7
			$this->m_7->LinkCustomAttributes = "";
			$this->m_7->HrefValue = "";
			$this->m_7->TooltipValue = "";

			// 8
			$this->_8->LinkCustomAttributes = "";
			$this->_8->HrefValue = "";
			$this->_8->TooltipValue = "";

			// m_8
			$this->m_8->LinkCustomAttributes = "";
			$this->m_8->HrefValue = "";
			$this->m_8->TooltipValue = "";

			// 9
			$this->_9->LinkCustomAttributes = "";
			$this->_9->HrefValue = "";
			$this->_9->TooltipValue = "";

			// m_9
			$this->m_9->LinkCustomAttributes = "";
			$this->m_9->HrefValue = "";
			$this->m_9->TooltipValue = "";

			// 10
			$this->_10->LinkCustomAttributes = "";
			$this->_10->HrefValue = "";
			$this->_10->TooltipValue = "";

			// m_10
			$this->m_10->LinkCustomAttributes = "";
			$this->m_10->HrefValue = "";
			$this->m_10->TooltipValue = "";

			// 11
			$this->_11->LinkCustomAttributes = "";
			$this->_11->HrefValue = "";
			$this->_11->TooltipValue = "";

			// m_11
			$this->m_11->LinkCustomAttributes = "";
			$this->m_11->HrefValue = "";
			$this->m_11->TooltipValue = "";

			// 12
			$this->_12->LinkCustomAttributes = "";
			$this->_12->HrefValue = "";
			$this->_12->TooltipValue = "";

			// m_12
			$this->m_12->LinkCustomAttributes = "";
			$this->m_12->HrefValue = "";
			$this->m_12->TooltipValue = "";

			// 13
			$this->_13->LinkCustomAttributes = "";
			$this->_13->HrefValue = "";
			$this->_13->TooltipValue = "";

			// m_13
			$this->m_13->LinkCustomAttributes = "";
			$this->m_13->HrefValue = "";
			$this->m_13->TooltipValue = "";

			// 14
			$this->_14->LinkCustomAttributes = "";
			$this->_14->HrefValue = "";
			$this->_14->TooltipValue = "";

			// m_14
			$this->m_14->LinkCustomAttributes = "";
			$this->m_14->HrefValue = "";
			$this->m_14->TooltipValue = "";

			// 15
			$this->_15->LinkCustomAttributes = "";
			$this->_15->HrefValue = "";
			$this->_15->TooltipValue = "";

			// m_15
			$this->m_15->LinkCustomAttributes = "";
			$this->m_15->HrefValue = "";
			$this->m_15->TooltipValue = "";

			// 16
			$this->_16->LinkCustomAttributes = "";
			$this->_16->HrefValue = "";
			$this->_16->TooltipValue = "";

			// m_16
			$this->m_16->LinkCustomAttributes = "";
			$this->m_16->HrefValue = "";
			$this->m_16->TooltipValue = "";

			// 17
			$this->_17->LinkCustomAttributes = "";
			$this->_17->HrefValue = "";
			$this->_17->TooltipValue = "";

			// m_17
			$this->m_17->LinkCustomAttributes = "";
			$this->m_17->HrefValue = "";
			$this->m_17->TooltipValue = "";

			// 18
			$this->_18->LinkCustomAttributes = "";
			$this->_18->HrefValue = "";
			$this->_18->TooltipValue = "";

			// m_18
			$this->m_18->LinkCustomAttributes = "";
			$this->m_18->HrefValue = "";
			$this->m_18->TooltipValue = "";

			// 19
			$this->_19->LinkCustomAttributes = "";
			$this->_19->HrefValue = "";
			$this->_19->TooltipValue = "";

			// m_19
			$this->m_19->LinkCustomAttributes = "";
			$this->m_19->HrefValue = "";
			$this->m_19->TooltipValue = "";

			// 20
			$this->_20->LinkCustomAttributes = "";
			$this->_20->HrefValue = "";
			$this->_20->TooltipValue = "";

			// m_20
			$this->m_20->LinkCustomAttributes = "";
			$this->m_20->HrefValue = "";
			$this->m_20->TooltipValue = "";

			// 21
			$this->_21->LinkCustomAttributes = "";
			$this->_21->HrefValue = "";
			$this->_21->TooltipValue = "";

			// m_21
			$this->m_21->LinkCustomAttributes = "";
			$this->m_21->HrefValue = "";
			$this->m_21->TooltipValue = "";

			// 22
			$this->_22->LinkCustomAttributes = "";
			$this->_22->HrefValue = "";
			$this->_22->TooltipValue = "";

			// m_22
			$this->m_22->LinkCustomAttributes = "";
			$this->m_22->HrefValue = "";
			$this->m_22->TooltipValue = "";

			// 23
			$this->_23->LinkCustomAttributes = "";
			$this->_23->HrefValue = "";
			$this->_23->TooltipValue = "";

			// m_23
			$this->m_23->LinkCustomAttributes = "";
			$this->m_23->HrefValue = "";
			$this->m_23->TooltipValue = "";

			// 24
			$this->_24->LinkCustomAttributes = "";
			$this->_24->HrefValue = "";
			$this->_24->TooltipValue = "";

			// m_24
			$this->m_24->LinkCustomAttributes = "";
			$this->m_24->HrefValue = "";
			$this->m_24->TooltipValue = "";

			// 25
			$this->_25->LinkCustomAttributes = "";
			$this->_25->HrefValue = "";
			$this->_25->TooltipValue = "";

			// m_25
			$this->m_25->LinkCustomAttributes = "";
			$this->m_25->HrefValue = "";
			$this->m_25->TooltipValue = "";

			// 26
			$this->_26->LinkCustomAttributes = "";
			$this->_26->HrefValue = "";
			$this->_26->TooltipValue = "";

			// m_26
			$this->m_26->LinkCustomAttributes = "";
			$this->m_26->HrefValue = "";
			$this->m_26->TooltipValue = "";

			// 27
			$this->_27->LinkCustomAttributes = "";
			$this->_27->HrefValue = "";
			$this->_27->TooltipValue = "";

			// m_27
			$this->m_27->LinkCustomAttributes = "";
			$this->m_27->HrefValue = "";
			$this->m_27->TooltipValue = "";

			// 28
			$this->_28->LinkCustomAttributes = "";
			$this->_28->HrefValue = "";
			$this->_28->TooltipValue = "";

			// m_28
			$this->m_28->LinkCustomAttributes = "";
			$this->m_28->HrefValue = "";
			$this->m_28->TooltipValue = "";

			// 29
			$this->_29->LinkCustomAttributes = "";
			$this->_29->HrefValue = "";
			$this->_29->TooltipValue = "";

			// m_29
			$this->m_29->LinkCustomAttributes = "";
			$this->m_29->HrefValue = "";
			$this->m_29->TooltipValue = "";

			// 30
			$this->_30->LinkCustomAttributes = "";
			$this->_30->HrefValue = "";
			$this->_30->TooltipValue = "";

			// m_30
			$this->m_30->LinkCustomAttributes = "";
			$this->m_30->HrefValue = "";
			$this->m_30->TooltipValue = "";

			// 31
			$this->_31->LinkCustomAttributes = "";
			$this->_31->HrefValue = "";
			$this->_31->TooltipValue = "";

			// m_31
			$this->m_31->LinkCustomAttributes = "";
			$this->m_31->HrefValue = "";
			$this->m_31->TooltipValue = "";

			// 32
			$this->_32->LinkCustomAttributes = "";
			$this->_32->HrefValue = "";
			$this->_32->TooltipValue = "";

			// m_32
			$this->m_32->LinkCustomAttributes = "";
			$this->m_32->HrefValue = "";
			$this->m_32->TooltipValue = "";

			// 33
			$this->_33->LinkCustomAttributes = "";
			$this->_33->HrefValue = "";
			$this->_33->TooltipValue = "";

			// m_33
			$this->m_33->LinkCustomAttributes = "";
			$this->m_33->HrefValue = "";
			$this->m_33->TooltipValue = "";

			// 34
			$this->_34->LinkCustomAttributes = "";
			$this->_34->HrefValue = "";
			$this->_34->TooltipValue = "";

			// m_34
			$this->m_34->LinkCustomAttributes = "";
			$this->m_34->HrefValue = "";
			$this->m_34->TooltipValue = "";

			// 35
			$this->_35->LinkCustomAttributes = "";
			$this->_35->HrefValue = "";
			$this->_35->TooltipValue = "";

			// m_35
			$this->m_35->LinkCustomAttributes = "";
			$this->m_35->HrefValue = "";
			$this->m_35->TooltipValue = "";

			// 36
			$this->_36->LinkCustomAttributes = "";
			$this->_36->HrefValue = "";
			$this->_36->TooltipValue = "";

			// m_36
			$this->m_36->LinkCustomAttributes = "";
			$this->m_36->HrefValue = "";
			$this->m_36->TooltipValue = "";

			// 37
			$this->_37->LinkCustomAttributes = "";
			$this->_37->HrefValue = "";
			$this->_37->TooltipValue = "";

			// m_37
			$this->m_37->LinkCustomAttributes = "";
			$this->m_37->HrefValue = "";
			$this->m_37->TooltipValue = "";

			// 38
			$this->_38->LinkCustomAttributes = "";
			$this->_38->HrefValue = "";
			$this->_38->TooltipValue = "";

			// m_38
			$this->m_38->LinkCustomAttributes = "";
			$this->m_38->HrefValue = "";
			$this->m_38->TooltipValue = "";

			// 39
			$this->_39->LinkCustomAttributes = "";
			$this->_39->HrefValue = "";
			$this->_39->TooltipValue = "";

			// m_39
			$this->m_39->LinkCustomAttributes = "";
			$this->m_39->HrefValue = "";
			$this->m_39->TooltipValue = "";

			// 40
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// m_40
			$this->m_40->LinkCustomAttributes = "";
			$this->m_40->HrefValue = "";
			$this->m_40->TooltipValue = "";

			// 41
			$this->_41->LinkCustomAttributes = "";
			$this->_41->HrefValue = "";
			$this->_41->TooltipValue = "";

			// m_41
			$this->m_41->LinkCustomAttributes = "";
			$this->m_41->HrefValue = "";
			$this->m_41->TooltipValue = "";

			// 42
			$this->_42->LinkCustomAttributes = "";
			$this->_42->HrefValue = "";
			$this->_42->TooltipValue = "";

			// m_42
			$this->m_42->LinkCustomAttributes = "";
			$this->m_42->HrefValue = "";
			$this->m_42->TooltipValue = "";

			// 43
			$this->_43->LinkCustomAttributes = "";
			$this->_43->HrefValue = "";
			$this->_43->TooltipValue = "";

			// m_43
			$this->m_43->LinkCustomAttributes = "";
			$this->m_43->HrefValue = "";
			$this->m_43->TooltipValue = "";

			// 44
			$this->_44->LinkCustomAttributes = "";
			$this->_44->HrefValue = "";
			$this->_44->TooltipValue = "";

			// m_44
			$this->m_44->LinkCustomAttributes = "";
			$this->m_44->HrefValue = "";
			$this->m_44->TooltipValue = "";

			// 45
			$this->_45->LinkCustomAttributes = "";
			$this->_45->HrefValue = "";
			$this->_45->TooltipValue = "";

			// m_45
			$this->m_45->LinkCustomAttributes = "";
			$this->m_45->HrefValue = "";
			$this->m_45->TooltipValue = "";

			// 46
			$this->_46->LinkCustomAttributes = "";
			$this->_46->HrefValue = "";
			$this->_46->TooltipValue = "";

			// m_46
			$this->m_46->LinkCustomAttributes = "";
			$this->m_46->HrefValue = "";
			$this->m_46->TooltipValue = "";

			// 47
			$this->_47->LinkCustomAttributes = "";
			$this->_47->HrefValue = "";
			$this->_47->TooltipValue = "";

			// m_47
			$this->m_47->LinkCustomAttributes = "";
			$this->m_47->HrefValue = "";
			$this->m_47->TooltipValue = "";

			// 48
			$this->_48->LinkCustomAttributes = "";
			$this->_48->HrefValue = "";
			$this->_48->TooltipValue = "";

			// m_48
			$this->m_48->LinkCustomAttributes = "";
			$this->m_48->HrefValue = "";
			$this->m_48->TooltipValue = "";

			// 49
			$this->_49->LinkCustomAttributes = "";
			$this->_49->HrefValue = "";
			$this->_49->TooltipValue = "";

			// m_49
			$this->m_49->LinkCustomAttributes = "";
			$this->m_49->HrefValue = "";
			$this->m_49->TooltipValue = "";

			// 50
			$this->_50->LinkCustomAttributes = "";
			$this->_50->HrefValue = "";
			$this->_50->TooltipValue = "";

			// m_50
			$this->m_50->LinkCustomAttributes = "";
			$this->m_50->HrefValue = "";
			$this->m_50->TooltipValue = "";

			// 51
			$this->_51->LinkCustomAttributes = "";
			$this->_51->HrefValue = "";
			$this->_51->TooltipValue = "";

			// m_51
			$this->m_51->LinkCustomAttributes = "";
			$this->m_51->HrefValue = "";
			$this->m_51->TooltipValue = "";

			// 52
			$this->_52->LinkCustomAttributes = "";
			$this->_52->HrefValue = "";
			$this->_52->TooltipValue = "";

			// m_52
			$this->m_52->LinkCustomAttributes = "";
			$this->m_52->HrefValue = "";
			$this->m_52->TooltipValue = "";

			// 53
			$this->_53->LinkCustomAttributes = "";
			$this->_53->HrefValue = "";
			$this->_53->TooltipValue = "";

			// m_53
			$this->m_53->LinkCustomAttributes = "";
			$this->m_53->HrefValue = "";
			$this->m_53->TooltipValue = "";

			// 54
			$this->_54->LinkCustomAttributes = "";
			$this->_54->HrefValue = "";
			$this->_54->TooltipValue = "";

			// m_54
			$this->m_54->LinkCustomAttributes = "";
			$this->m_54->HrefValue = "";
			$this->m_54->TooltipValue = "";

			// 55
			$this->_55->LinkCustomAttributes = "";
			$this->_55->HrefValue = "";
			$this->_55->TooltipValue = "";

			// m_55
			$this->m_55->LinkCustomAttributes = "";
			$this->m_55->HrefValue = "";
			$this->m_55->TooltipValue = "";

			// 56
			$this->_56->LinkCustomAttributes = "";
			$this->_56->HrefValue = "";
			$this->_56->TooltipValue = "";

			// m_56
			$this->m_56->LinkCustomAttributes = "";
			$this->m_56->HrefValue = "";
			$this->m_56->TooltipValue = "";

			// 57
			$this->_57->LinkCustomAttributes = "";
			$this->_57->HrefValue = "";
			$this->_57->TooltipValue = "";

			// m_57
			$this->m_57->LinkCustomAttributes = "";
			$this->m_57->HrefValue = "";
			$this->m_57->TooltipValue = "";

			// 58
			$this->_58->LinkCustomAttributes = "";
			$this->_58->HrefValue = "";
			$this->_58->TooltipValue = "";

			// m_58
			$this->m_58->LinkCustomAttributes = "";
			$this->m_58->HrefValue = "";
			$this->m_58->TooltipValue = "";

			// 59
			$this->_59->LinkCustomAttributes = "";
			$this->_59->HrefValue = "";
			$this->_59->TooltipValue = "";

			// m_59
			$this->m_59->LinkCustomAttributes = "";
			$this->m_59->HrefValue = "";
			$this->m_59->TooltipValue = "";

			// 60
			$this->_60->LinkCustomAttributes = "";
			$this->_60->HrefValue = "";
			$this->_60->TooltipValue = "";

			// m_60
			$this->m_60->LinkCustomAttributes = "";
			$this->m_60->HrefValue = "";
			$this->m_60->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->EditAttrs["class"] = "form-control";
			$this->roll_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->roll_no->CurrentValue = HtmlDecode($this->roll_no->CurrentValue);
			$this->roll_no->EditValue = HtmlEncode($this->roll_no->CurrentValue);
			$this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

			// test_id
			$this->test_id->EditAttrs["class"] = "form-control";
			$this->test_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->test_id->CurrentValue = HtmlDecode($this->test_id->CurrentValue);
			$this->test_id->EditValue = HtmlEncode($this->test_id->CurrentValue);
			$this->test_id->PlaceHolder = RemoveHtml($this->test_id->caption());

			// total
			$this->total->EditAttrs["class"] = "form-control";
			$this->total->EditCustomAttributes = "";
			$this->total->EditValue = HtmlEncode($this->total->CurrentValue);
			$this->total->PlaceHolder = RemoveHtml($this->total->caption());
			if (strval($this->total->EditValue) <> "" && is_numeric($this->total->EditValue))
				$this->total->EditValue = FormatNumber($this->total->EditValue, -2, -2, -2, -2);

			// percent
			$this->percent->EditAttrs["class"] = "form-control";
			$this->percent->EditCustomAttributes = "";
			$this->percent->EditValue = HtmlEncode($this->percent->CurrentValue);
			$this->percent->PlaceHolder = RemoveHtml($this->percent->caption());
			if (strval($this->percent->EditValue) <> "" && is_numeric($this->percent->EditValue))
				$this->percent->EditValue = FormatNumber($this->percent->EditValue, -2, -2, -2, -2);

			// s_1
			$this->s_1->EditAttrs["class"] = "form-control";
			$this->s_1->EditCustomAttributes = "";
			$this->s_1->EditValue = HtmlEncode($this->s_1->CurrentValue);
			$this->s_1->PlaceHolder = RemoveHtml($this->s_1->caption());
			if (strval($this->s_1->EditValue) <> "" && is_numeric($this->s_1->EditValue))
				$this->s_1->EditValue = FormatNumber($this->s_1->EditValue, -2, -2, -2, -2);

			// s_2
			$this->s_2->EditAttrs["class"] = "form-control";
			$this->s_2->EditCustomAttributes = "";
			$this->s_2->EditValue = HtmlEncode($this->s_2->CurrentValue);
			$this->s_2->PlaceHolder = RemoveHtml($this->s_2->caption());
			if (strval($this->s_2->EditValue) <> "" && is_numeric($this->s_2->EditValue))
				$this->s_2->EditValue = FormatNumber($this->s_2->EditValue, -2, -2, -2, -2);

			// s_3
			$this->s_3->EditAttrs["class"] = "form-control";
			$this->s_3->EditCustomAttributes = "";
			$this->s_3->EditValue = HtmlEncode($this->s_3->CurrentValue);
			$this->s_3->PlaceHolder = RemoveHtml($this->s_3->caption());
			if (strval($this->s_3->EditValue) <> "" && is_numeric($this->s_3->EditValue))
				$this->s_3->EditValue = FormatNumber($this->s_3->EditValue, -2, -2, -2, -2);

			// s_4
			$this->s_4->EditAttrs["class"] = "form-control";
			$this->s_4->EditCustomAttributes = "";
			$this->s_4->EditValue = HtmlEncode($this->s_4->CurrentValue);
			$this->s_4->PlaceHolder = RemoveHtml($this->s_4->caption());
			if (strval($this->s_4->EditValue) <> "" && is_numeric($this->s_4->EditValue))
				$this->s_4->EditValue = FormatNumber($this->s_4->EditValue, -2, -2, -2, -2);

			// s_5
			$this->s_5->EditAttrs["class"] = "form-control";
			$this->s_5->EditCustomAttributes = "";
			$this->s_5->EditValue = HtmlEncode($this->s_5->CurrentValue);
			$this->s_5->PlaceHolder = RemoveHtml($this->s_5->caption());
			if (strval($this->s_5->EditValue) <> "" && is_numeric($this->s_5->EditValue))
				$this->s_5->EditValue = FormatNumber($this->s_5->EditValue, -2, -2, -2, -2);

			// omr_image
			$this->omr_image->EditAttrs["class"] = "form-control";
			$this->omr_image->EditCustomAttributes = "";
			$this->omr_image->UploadPath = '.p_uploads/school/omr/';
			if (!EmptyValue($this->omr_image->Upload->DbValue)) {
				$this->omr_image->ImageWidth = 0;
				$this->omr_image->ImageHeight = 50;
				$this->omr_image->ImageAlt = $this->omr_image->alt();
				$this->omr_image->EditValue = $this->omr_image->Upload->DbValue;
			} else {
				$this->omr_image->EditValue = "";
			}
			if (!EmptyValue($this->omr_image->CurrentValue))
					$this->omr_image->Upload->FileName = $this->omr_image->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->omr_image);

			// 1
			$this->_1->EditAttrs["class"] = "form-control";
			$this->_1->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_1->CurrentValue = HtmlDecode($this->_1->CurrentValue);
			$this->_1->EditValue = HtmlEncode($this->_1->CurrentValue);
			$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

			// m_1
			$this->m_1->EditAttrs["class"] = "form-control";
			$this->m_1->EditCustomAttributes = "";
			$this->m_1->EditValue = HtmlEncode($this->m_1->CurrentValue);
			$this->m_1->PlaceHolder = RemoveHtml($this->m_1->caption());
			if (strval($this->m_1->EditValue) <> "" && is_numeric($this->m_1->EditValue))
				$this->m_1->EditValue = FormatNumber($this->m_1->EditValue, -2, -2, -2, -2);

			// 2
			$this->_2->EditAttrs["class"] = "form-control";
			$this->_2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_2->CurrentValue = HtmlDecode($this->_2->CurrentValue);
			$this->_2->EditValue = HtmlEncode($this->_2->CurrentValue);
			$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

			// m_2
			$this->m_2->EditAttrs["class"] = "form-control";
			$this->m_2->EditCustomAttributes = "";
			$this->m_2->EditValue = HtmlEncode($this->m_2->CurrentValue);
			$this->m_2->PlaceHolder = RemoveHtml($this->m_2->caption());
			if (strval($this->m_2->EditValue) <> "" && is_numeric($this->m_2->EditValue))
				$this->m_2->EditValue = FormatNumber($this->m_2->EditValue, -2, -2, -2, -2);

			// 3
			$this->_3->EditAttrs["class"] = "form-control";
			$this->_3->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_3->CurrentValue = HtmlDecode($this->_3->CurrentValue);
			$this->_3->EditValue = HtmlEncode($this->_3->CurrentValue);
			$this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

			// m_3
			$this->m_3->EditAttrs["class"] = "form-control";
			$this->m_3->EditCustomAttributes = "";
			$this->m_3->EditValue = HtmlEncode($this->m_3->CurrentValue);
			$this->m_3->PlaceHolder = RemoveHtml($this->m_3->caption());
			if (strval($this->m_3->EditValue) <> "" && is_numeric($this->m_3->EditValue))
				$this->m_3->EditValue = FormatNumber($this->m_3->EditValue, -2, -2, -2, -2);

			// 4
			$this->_4->EditAttrs["class"] = "form-control";
			$this->_4->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_4->CurrentValue = HtmlDecode($this->_4->CurrentValue);
			$this->_4->EditValue = HtmlEncode($this->_4->CurrentValue);
			$this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

			// m_4
			$this->m_4->EditAttrs["class"] = "form-control";
			$this->m_4->EditCustomAttributes = "";
			$this->m_4->EditValue = HtmlEncode($this->m_4->CurrentValue);
			$this->m_4->PlaceHolder = RemoveHtml($this->m_4->caption());
			if (strval($this->m_4->EditValue) <> "" && is_numeric($this->m_4->EditValue))
				$this->m_4->EditValue = FormatNumber($this->m_4->EditValue, -2, -2, -2, -2);

			// 5
			$this->_5->EditAttrs["class"] = "form-control";
			$this->_5->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_5->CurrentValue = HtmlDecode($this->_5->CurrentValue);
			$this->_5->EditValue = HtmlEncode($this->_5->CurrentValue);
			$this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

			// m_5
			$this->m_5->EditAttrs["class"] = "form-control";
			$this->m_5->EditCustomAttributes = "";
			$this->m_5->EditValue = HtmlEncode($this->m_5->CurrentValue);
			$this->m_5->PlaceHolder = RemoveHtml($this->m_5->caption());
			if (strval($this->m_5->EditValue) <> "" && is_numeric($this->m_5->EditValue))
				$this->m_5->EditValue = FormatNumber($this->m_5->EditValue, -2, -2, -2, -2);

			// 6
			$this->_6->EditAttrs["class"] = "form-control";
			$this->_6->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_6->CurrentValue = HtmlDecode($this->_6->CurrentValue);
			$this->_6->EditValue = HtmlEncode($this->_6->CurrentValue);
			$this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

			// m_6
			$this->m_6->EditAttrs["class"] = "form-control";
			$this->m_6->EditCustomAttributes = "";
			$this->m_6->EditValue = HtmlEncode($this->m_6->CurrentValue);
			$this->m_6->PlaceHolder = RemoveHtml($this->m_6->caption());
			if (strval($this->m_6->EditValue) <> "" && is_numeric($this->m_6->EditValue))
				$this->m_6->EditValue = FormatNumber($this->m_6->EditValue, -2, -2, -2, -2);

			// 7
			$this->_7->EditAttrs["class"] = "form-control";
			$this->_7->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_7->CurrentValue = HtmlDecode($this->_7->CurrentValue);
			$this->_7->EditValue = HtmlEncode($this->_7->CurrentValue);
			$this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

			// m_7
			$this->m_7->EditAttrs["class"] = "form-control";
			$this->m_7->EditCustomAttributes = "";
			$this->m_7->EditValue = HtmlEncode($this->m_7->CurrentValue);
			$this->m_7->PlaceHolder = RemoveHtml($this->m_7->caption());
			if (strval($this->m_7->EditValue) <> "" && is_numeric($this->m_7->EditValue))
				$this->m_7->EditValue = FormatNumber($this->m_7->EditValue, -2, -2, -2, -2);

			// 8
			$this->_8->EditAttrs["class"] = "form-control";
			$this->_8->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_8->CurrentValue = HtmlDecode($this->_8->CurrentValue);
			$this->_8->EditValue = HtmlEncode($this->_8->CurrentValue);
			$this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

			// m_8
			$this->m_8->EditAttrs["class"] = "form-control";
			$this->m_8->EditCustomAttributes = "";
			$this->m_8->EditValue = HtmlEncode($this->m_8->CurrentValue);
			$this->m_8->PlaceHolder = RemoveHtml($this->m_8->caption());
			if (strval($this->m_8->EditValue) <> "" && is_numeric($this->m_8->EditValue))
				$this->m_8->EditValue = FormatNumber($this->m_8->EditValue, -2, -2, -2, -2);

			// 9
			$this->_9->EditAttrs["class"] = "form-control";
			$this->_9->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_9->CurrentValue = HtmlDecode($this->_9->CurrentValue);
			$this->_9->EditValue = HtmlEncode($this->_9->CurrentValue);
			$this->_9->PlaceHolder = RemoveHtml($this->_9->caption());

			// m_9
			$this->m_9->EditAttrs["class"] = "form-control";
			$this->m_9->EditCustomAttributes = "";
			$this->m_9->EditValue = HtmlEncode($this->m_9->CurrentValue);
			$this->m_9->PlaceHolder = RemoveHtml($this->m_9->caption());
			if (strval($this->m_9->EditValue) <> "" && is_numeric($this->m_9->EditValue))
				$this->m_9->EditValue = FormatNumber($this->m_9->EditValue, -2, -2, -2, -2);

			// 10
			$this->_10->EditAttrs["class"] = "form-control";
			$this->_10->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_10->CurrentValue = HtmlDecode($this->_10->CurrentValue);
			$this->_10->EditValue = HtmlEncode($this->_10->CurrentValue);
			$this->_10->PlaceHolder = RemoveHtml($this->_10->caption());

			// m_10
			$this->m_10->EditAttrs["class"] = "form-control";
			$this->m_10->EditCustomAttributes = "";
			$this->m_10->EditValue = HtmlEncode($this->m_10->CurrentValue);
			$this->m_10->PlaceHolder = RemoveHtml($this->m_10->caption());
			if (strval($this->m_10->EditValue) <> "" && is_numeric($this->m_10->EditValue))
				$this->m_10->EditValue = FormatNumber($this->m_10->EditValue, -2, -2, -2, -2);

			// 11
			$this->_11->EditAttrs["class"] = "form-control";
			$this->_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_11->CurrentValue = HtmlDecode($this->_11->CurrentValue);
			$this->_11->EditValue = HtmlEncode($this->_11->CurrentValue);
			$this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

			// m_11
			$this->m_11->EditAttrs["class"] = "form-control";
			$this->m_11->EditCustomAttributes = "";
			$this->m_11->EditValue = HtmlEncode($this->m_11->CurrentValue);
			$this->m_11->PlaceHolder = RemoveHtml($this->m_11->caption());
			if (strval($this->m_11->EditValue) <> "" && is_numeric($this->m_11->EditValue))
				$this->m_11->EditValue = FormatNumber($this->m_11->EditValue, -2, -2, -2, -2);

			// 12
			$this->_12->EditAttrs["class"] = "form-control";
			$this->_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_12->CurrentValue = HtmlDecode($this->_12->CurrentValue);
			$this->_12->EditValue = HtmlEncode($this->_12->CurrentValue);
			$this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

			// m_12
			$this->m_12->EditAttrs["class"] = "form-control";
			$this->m_12->EditCustomAttributes = "";
			$this->m_12->EditValue = HtmlEncode($this->m_12->CurrentValue);
			$this->m_12->PlaceHolder = RemoveHtml($this->m_12->caption());
			if (strval($this->m_12->EditValue) <> "" && is_numeric($this->m_12->EditValue))
				$this->m_12->EditValue = FormatNumber($this->m_12->EditValue, -2, -2, -2, -2);

			// 13
			$this->_13->EditAttrs["class"] = "form-control";
			$this->_13->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_13->CurrentValue = HtmlDecode($this->_13->CurrentValue);
			$this->_13->EditValue = HtmlEncode($this->_13->CurrentValue);
			$this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

			// m_13
			$this->m_13->EditAttrs["class"] = "form-control";
			$this->m_13->EditCustomAttributes = "";
			$this->m_13->EditValue = HtmlEncode($this->m_13->CurrentValue);
			$this->m_13->PlaceHolder = RemoveHtml($this->m_13->caption());
			if (strval($this->m_13->EditValue) <> "" && is_numeric($this->m_13->EditValue))
				$this->m_13->EditValue = FormatNumber($this->m_13->EditValue, -2, -2, -2, -2);

			// 14
			$this->_14->EditAttrs["class"] = "form-control";
			$this->_14->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_14->CurrentValue = HtmlDecode($this->_14->CurrentValue);
			$this->_14->EditValue = HtmlEncode($this->_14->CurrentValue);
			$this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

			// m_14
			$this->m_14->EditAttrs["class"] = "form-control";
			$this->m_14->EditCustomAttributes = "";
			$this->m_14->EditValue = HtmlEncode($this->m_14->CurrentValue);
			$this->m_14->PlaceHolder = RemoveHtml($this->m_14->caption());
			if (strval($this->m_14->EditValue) <> "" && is_numeric($this->m_14->EditValue))
				$this->m_14->EditValue = FormatNumber($this->m_14->EditValue, -2, -2, -2, -2);

			// 15
			$this->_15->EditAttrs["class"] = "form-control";
			$this->_15->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_15->CurrentValue = HtmlDecode($this->_15->CurrentValue);
			$this->_15->EditValue = HtmlEncode($this->_15->CurrentValue);
			$this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

			// m_15
			$this->m_15->EditAttrs["class"] = "form-control";
			$this->m_15->EditCustomAttributes = "";
			$this->m_15->EditValue = HtmlEncode($this->m_15->CurrentValue);
			$this->m_15->PlaceHolder = RemoveHtml($this->m_15->caption());
			if (strval($this->m_15->EditValue) <> "" && is_numeric($this->m_15->EditValue))
				$this->m_15->EditValue = FormatNumber($this->m_15->EditValue, -2, -2, -2, -2);

			// 16
			$this->_16->EditAttrs["class"] = "form-control";
			$this->_16->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_16->CurrentValue = HtmlDecode($this->_16->CurrentValue);
			$this->_16->EditValue = HtmlEncode($this->_16->CurrentValue);
			$this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

			// m_16
			$this->m_16->EditAttrs["class"] = "form-control";
			$this->m_16->EditCustomAttributes = "";
			$this->m_16->EditValue = HtmlEncode($this->m_16->CurrentValue);
			$this->m_16->PlaceHolder = RemoveHtml($this->m_16->caption());
			if (strval($this->m_16->EditValue) <> "" && is_numeric($this->m_16->EditValue))
				$this->m_16->EditValue = FormatNumber($this->m_16->EditValue, -2, -2, -2, -2);

			// 17
			$this->_17->EditAttrs["class"] = "form-control";
			$this->_17->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_17->CurrentValue = HtmlDecode($this->_17->CurrentValue);
			$this->_17->EditValue = HtmlEncode($this->_17->CurrentValue);
			$this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

			// m_17
			$this->m_17->EditAttrs["class"] = "form-control";
			$this->m_17->EditCustomAttributes = "";
			$this->m_17->EditValue = HtmlEncode($this->m_17->CurrentValue);
			$this->m_17->PlaceHolder = RemoveHtml($this->m_17->caption());
			if (strval($this->m_17->EditValue) <> "" && is_numeric($this->m_17->EditValue))
				$this->m_17->EditValue = FormatNumber($this->m_17->EditValue, -2, -2, -2, -2);

			// 18
			$this->_18->EditAttrs["class"] = "form-control";
			$this->_18->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_18->CurrentValue = HtmlDecode($this->_18->CurrentValue);
			$this->_18->EditValue = HtmlEncode($this->_18->CurrentValue);
			$this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

			// m_18
			$this->m_18->EditAttrs["class"] = "form-control";
			$this->m_18->EditCustomAttributes = "";
			$this->m_18->EditValue = HtmlEncode($this->m_18->CurrentValue);
			$this->m_18->PlaceHolder = RemoveHtml($this->m_18->caption());
			if (strval($this->m_18->EditValue) <> "" && is_numeric($this->m_18->EditValue))
				$this->m_18->EditValue = FormatNumber($this->m_18->EditValue, -2, -2, -2, -2);

			// 19
			$this->_19->EditAttrs["class"] = "form-control";
			$this->_19->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_19->CurrentValue = HtmlDecode($this->_19->CurrentValue);
			$this->_19->EditValue = HtmlEncode($this->_19->CurrentValue);
			$this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

			// m_19
			$this->m_19->EditAttrs["class"] = "form-control";
			$this->m_19->EditCustomAttributes = "";
			$this->m_19->EditValue = HtmlEncode($this->m_19->CurrentValue);
			$this->m_19->PlaceHolder = RemoveHtml($this->m_19->caption());
			if (strval($this->m_19->EditValue) <> "" && is_numeric($this->m_19->EditValue))
				$this->m_19->EditValue = FormatNumber($this->m_19->EditValue, -2, -2, -2, -2);

			// 20
			$this->_20->EditAttrs["class"] = "form-control";
			$this->_20->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_20->CurrentValue = HtmlDecode($this->_20->CurrentValue);
			$this->_20->EditValue = HtmlEncode($this->_20->CurrentValue);
			$this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

			// m_20
			$this->m_20->EditAttrs["class"] = "form-control";
			$this->m_20->EditCustomAttributes = "";
			$this->m_20->EditValue = HtmlEncode($this->m_20->CurrentValue);
			$this->m_20->PlaceHolder = RemoveHtml($this->m_20->caption());
			if (strval($this->m_20->EditValue) <> "" && is_numeric($this->m_20->EditValue))
				$this->m_20->EditValue = FormatNumber($this->m_20->EditValue, -2, -2, -2, -2);

			// 21
			$this->_21->EditAttrs["class"] = "form-control";
			$this->_21->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_21->CurrentValue = HtmlDecode($this->_21->CurrentValue);
			$this->_21->EditValue = HtmlEncode($this->_21->CurrentValue);
			$this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

			// m_21
			$this->m_21->EditAttrs["class"] = "form-control";
			$this->m_21->EditCustomAttributes = "";
			$this->m_21->EditValue = HtmlEncode($this->m_21->CurrentValue);
			$this->m_21->PlaceHolder = RemoveHtml($this->m_21->caption());
			if (strval($this->m_21->EditValue) <> "" && is_numeric($this->m_21->EditValue))
				$this->m_21->EditValue = FormatNumber($this->m_21->EditValue, -2, -2, -2, -2);

			// 22
			$this->_22->EditAttrs["class"] = "form-control";
			$this->_22->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_22->CurrentValue = HtmlDecode($this->_22->CurrentValue);
			$this->_22->EditValue = HtmlEncode($this->_22->CurrentValue);
			$this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

			// m_22
			$this->m_22->EditAttrs["class"] = "form-control";
			$this->m_22->EditCustomAttributes = "";
			$this->m_22->EditValue = HtmlEncode($this->m_22->CurrentValue);
			$this->m_22->PlaceHolder = RemoveHtml($this->m_22->caption());
			if (strval($this->m_22->EditValue) <> "" && is_numeric($this->m_22->EditValue))
				$this->m_22->EditValue = FormatNumber($this->m_22->EditValue, -2, -2, -2, -2);

			// 23
			$this->_23->EditAttrs["class"] = "form-control";
			$this->_23->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_23->CurrentValue = HtmlDecode($this->_23->CurrentValue);
			$this->_23->EditValue = HtmlEncode($this->_23->CurrentValue);
			$this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

			// m_23
			$this->m_23->EditAttrs["class"] = "form-control";
			$this->m_23->EditCustomAttributes = "";
			$this->m_23->EditValue = HtmlEncode($this->m_23->CurrentValue);
			$this->m_23->PlaceHolder = RemoveHtml($this->m_23->caption());
			if (strval($this->m_23->EditValue) <> "" && is_numeric($this->m_23->EditValue))
				$this->m_23->EditValue = FormatNumber($this->m_23->EditValue, -2, -2, -2, -2);

			// 24
			$this->_24->EditAttrs["class"] = "form-control";
			$this->_24->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_24->CurrentValue = HtmlDecode($this->_24->CurrentValue);
			$this->_24->EditValue = HtmlEncode($this->_24->CurrentValue);
			$this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

			// m_24
			$this->m_24->EditAttrs["class"] = "form-control";
			$this->m_24->EditCustomAttributes = "";
			$this->m_24->EditValue = HtmlEncode($this->m_24->CurrentValue);
			$this->m_24->PlaceHolder = RemoveHtml($this->m_24->caption());
			if (strval($this->m_24->EditValue) <> "" && is_numeric($this->m_24->EditValue))
				$this->m_24->EditValue = FormatNumber($this->m_24->EditValue, -2, -2, -2, -2);

			// 25
			$this->_25->EditAttrs["class"] = "form-control";
			$this->_25->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_25->CurrentValue = HtmlDecode($this->_25->CurrentValue);
			$this->_25->EditValue = HtmlEncode($this->_25->CurrentValue);
			$this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

			// m_25
			$this->m_25->EditAttrs["class"] = "form-control";
			$this->m_25->EditCustomAttributes = "";
			$this->m_25->EditValue = HtmlEncode($this->m_25->CurrentValue);
			$this->m_25->PlaceHolder = RemoveHtml($this->m_25->caption());
			if (strval($this->m_25->EditValue) <> "" && is_numeric($this->m_25->EditValue))
				$this->m_25->EditValue = FormatNumber($this->m_25->EditValue, -2, -2, -2, -2);

			// 26
			$this->_26->EditAttrs["class"] = "form-control";
			$this->_26->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_26->CurrentValue = HtmlDecode($this->_26->CurrentValue);
			$this->_26->EditValue = HtmlEncode($this->_26->CurrentValue);
			$this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

			// m_26
			$this->m_26->EditAttrs["class"] = "form-control";
			$this->m_26->EditCustomAttributes = "";
			$this->m_26->EditValue = HtmlEncode($this->m_26->CurrentValue);
			$this->m_26->PlaceHolder = RemoveHtml($this->m_26->caption());
			if (strval($this->m_26->EditValue) <> "" && is_numeric($this->m_26->EditValue))
				$this->m_26->EditValue = FormatNumber($this->m_26->EditValue, -2, -2, -2, -2);

			// 27
			$this->_27->EditAttrs["class"] = "form-control";
			$this->_27->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_27->CurrentValue = HtmlDecode($this->_27->CurrentValue);
			$this->_27->EditValue = HtmlEncode($this->_27->CurrentValue);
			$this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

			// m_27
			$this->m_27->EditAttrs["class"] = "form-control";
			$this->m_27->EditCustomAttributes = "";
			$this->m_27->EditValue = HtmlEncode($this->m_27->CurrentValue);
			$this->m_27->PlaceHolder = RemoveHtml($this->m_27->caption());
			if (strval($this->m_27->EditValue) <> "" && is_numeric($this->m_27->EditValue))
				$this->m_27->EditValue = FormatNumber($this->m_27->EditValue, -2, -2, -2, -2);

			// 28
			$this->_28->EditAttrs["class"] = "form-control";
			$this->_28->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_28->CurrentValue = HtmlDecode($this->_28->CurrentValue);
			$this->_28->EditValue = HtmlEncode($this->_28->CurrentValue);
			$this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

			// m_28
			$this->m_28->EditAttrs["class"] = "form-control";
			$this->m_28->EditCustomAttributes = "";
			$this->m_28->EditValue = HtmlEncode($this->m_28->CurrentValue);
			$this->m_28->PlaceHolder = RemoveHtml($this->m_28->caption());
			if (strval($this->m_28->EditValue) <> "" && is_numeric($this->m_28->EditValue))
				$this->m_28->EditValue = FormatNumber($this->m_28->EditValue, -2, -2, -2, -2);

			// 29
			$this->_29->EditAttrs["class"] = "form-control";
			$this->_29->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_29->CurrentValue = HtmlDecode($this->_29->CurrentValue);
			$this->_29->EditValue = HtmlEncode($this->_29->CurrentValue);
			$this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

			// m_29
			$this->m_29->EditAttrs["class"] = "form-control";
			$this->m_29->EditCustomAttributes = "";
			$this->m_29->EditValue = HtmlEncode($this->m_29->CurrentValue);
			$this->m_29->PlaceHolder = RemoveHtml($this->m_29->caption());
			if (strval($this->m_29->EditValue) <> "" && is_numeric($this->m_29->EditValue))
				$this->m_29->EditValue = FormatNumber($this->m_29->EditValue, -2, -2, -2, -2);

			// 30
			$this->_30->EditAttrs["class"] = "form-control";
			$this->_30->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_30->CurrentValue = HtmlDecode($this->_30->CurrentValue);
			$this->_30->EditValue = HtmlEncode($this->_30->CurrentValue);
			$this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

			// m_30
			$this->m_30->EditAttrs["class"] = "form-control";
			$this->m_30->EditCustomAttributes = "";
			$this->m_30->EditValue = HtmlEncode($this->m_30->CurrentValue);
			$this->m_30->PlaceHolder = RemoveHtml($this->m_30->caption());
			if (strval($this->m_30->EditValue) <> "" && is_numeric($this->m_30->EditValue))
				$this->m_30->EditValue = FormatNumber($this->m_30->EditValue, -2, -2, -2, -2);

			// 31
			$this->_31->EditAttrs["class"] = "form-control";
			$this->_31->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_31->CurrentValue = HtmlDecode($this->_31->CurrentValue);
			$this->_31->EditValue = HtmlEncode($this->_31->CurrentValue);
			$this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

			// m_31
			$this->m_31->EditAttrs["class"] = "form-control";
			$this->m_31->EditCustomAttributes = "";
			$this->m_31->EditValue = HtmlEncode($this->m_31->CurrentValue);
			$this->m_31->PlaceHolder = RemoveHtml($this->m_31->caption());
			if (strval($this->m_31->EditValue) <> "" && is_numeric($this->m_31->EditValue))
				$this->m_31->EditValue = FormatNumber($this->m_31->EditValue, -2, -2, -2, -2);

			// 32
			$this->_32->EditAttrs["class"] = "form-control";
			$this->_32->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_32->CurrentValue = HtmlDecode($this->_32->CurrentValue);
			$this->_32->EditValue = HtmlEncode($this->_32->CurrentValue);
			$this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

			// m_32
			$this->m_32->EditAttrs["class"] = "form-control";
			$this->m_32->EditCustomAttributes = "";
			$this->m_32->EditValue = HtmlEncode($this->m_32->CurrentValue);
			$this->m_32->PlaceHolder = RemoveHtml($this->m_32->caption());
			if (strval($this->m_32->EditValue) <> "" && is_numeric($this->m_32->EditValue))
				$this->m_32->EditValue = FormatNumber($this->m_32->EditValue, -2, -2, -2, -2);

			// 33
			$this->_33->EditAttrs["class"] = "form-control";
			$this->_33->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_33->CurrentValue = HtmlDecode($this->_33->CurrentValue);
			$this->_33->EditValue = HtmlEncode($this->_33->CurrentValue);
			$this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

			// m_33
			$this->m_33->EditAttrs["class"] = "form-control";
			$this->m_33->EditCustomAttributes = "";
			$this->m_33->EditValue = HtmlEncode($this->m_33->CurrentValue);
			$this->m_33->PlaceHolder = RemoveHtml($this->m_33->caption());
			if (strval($this->m_33->EditValue) <> "" && is_numeric($this->m_33->EditValue))
				$this->m_33->EditValue = FormatNumber($this->m_33->EditValue, -2, -2, -2, -2);

			// 34
			$this->_34->EditAttrs["class"] = "form-control";
			$this->_34->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_34->CurrentValue = HtmlDecode($this->_34->CurrentValue);
			$this->_34->EditValue = HtmlEncode($this->_34->CurrentValue);
			$this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

			// m_34
			$this->m_34->EditAttrs["class"] = "form-control";
			$this->m_34->EditCustomAttributes = "";
			$this->m_34->EditValue = HtmlEncode($this->m_34->CurrentValue);
			$this->m_34->PlaceHolder = RemoveHtml($this->m_34->caption());
			if (strval($this->m_34->EditValue) <> "" && is_numeric($this->m_34->EditValue))
				$this->m_34->EditValue = FormatNumber($this->m_34->EditValue, -2, -2, -2, -2);

			// 35
			$this->_35->EditAttrs["class"] = "form-control";
			$this->_35->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_35->CurrentValue = HtmlDecode($this->_35->CurrentValue);
			$this->_35->EditValue = HtmlEncode($this->_35->CurrentValue);
			$this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

			// m_35
			$this->m_35->EditAttrs["class"] = "form-control";
			$this->m_35->EditCustomAttributes = "";
			$this->m_35->EditValue = HtmlEncode($this->m_35->CurrentValue);
			$this->m_35->PlaceHolder = RemoveHtml($this->m_35->caption());
			if (strval($this->m_35->EditValue) <> "" && is_numeric($this->m_35->EditValue))
				$this->m_35->EditValue = FormatNumber($this->m_35->EditValue, -2, -2, -2, -2);

			// 36
			$this->_36->EditAttrs["class"] = "form-control";
			$this->_36->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_36->CurrentValue = HtmlDecode($this->_36->CurrentValue);
			$this->_36->EditValue = HtmlEncode($this->_36->CurrentValue);
			$this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

			// m_36
			$this->m_36->EditAttrs["class"] = "form-control";
			$this->m_36->EditCustomAttributes = "";
			$this->m_36->EditValue = HtmlEncode($this->m_36->CurrentValue);
			$this->m_36->PlaceHolder = RemoveHtml($this->m_36->caption());
			if (strval($this->m_36->EditValue) <> "" && is_numeric($this->m_36->EditValue))
				$this->m_36->EditValue = FormatNumber($this->m_36->EditValue, -2, -2, -2, -2);

			// 37
			$this->_37->EditAttrs["class"] = "form-control";
			$this->_37->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_37->CurrentValue = HtmlDecode($this->_37->CurrentValue);
			$this->_37->EditValue = HtmlEncode($this->_37->CurrentValue);
			$this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

			// m_37
			$this->m_37->EditAttrs["class"] = "form-control";
			$this->m_37->EditCustomAttributes = "";
			$this->m_37->EditValue = HtmlEncode($this->m_37->CurrentValue);
			$this->m_37->PlaceHolder = RemoveHtml($this->m_37->caption());
			if (strval($this->m_37->EditValue) <> "" && is_numeric($this->m_37->EditValue))
				$this->m_37->EditValue = FormatNumber($this->m_37->EditValue, -2, -2, -2, -2);

			// 38
			$this->_38->EditAttrs["class"] = "form-control";
			$this->_38->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_38->CurrentValue = HtmlDecode($this->_38->CurrentValue);
			$this->_38->EditValue = HtmlEncode($this->_38->CurrentValue);
			$this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

			// m_38
			$this->m_38->EditAttrs["class"] = "form-control";
			$this->m_38->EditCustomAttributes = "";
			$this->m_38->EditValue = HtmlEncode($this->m_38->CurrentValue);
			$this->m_38->PlaceHolder = RemoveHtml($this->m_38->caption());
			if (strval($this->m_38->EditValue) <> "" && is_numeric($this->m_38->EditValue))
				$this->m_38->EditValue = FormatNumber($this->m_38->EditValue, -2, -2, -2, -2);

			// 39
			$this->_39->EditAttrs["class"] = "form-control";
			$this->_39->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_39->CurrentValue = HtmlDecode($this->_39->CurrentValue);
			$this->_39->EditValue = HtmlEncode($this->_39->CurrentValue);
			$this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

			// m_39
			$this->m_39->EditAttrs["class"] = "form-control";
			$this->m_39->EditCustomAttributes = "";
			$this->m_39->EditValue = HtmlEncode($this->m_39->CurrentValue);
			$this->m_39->PlaceHolder = RemoveHtml($this->m_39->caption());
			if (strval($this->m_39->EditValue) <> "" && is_numeric($this->m_39->EditValue))
				$this->m_39->EditValue = FormatNumber($this->m_39->EditValue, -2, -2, -2, -2);

			// 40
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_40->CurrentValue = HtmlDecode($this->_40->CurrentValue);
			$this->_40->EditValue = HtmlEncode($this->_40->CurrentValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

			// m_40
			$this->m_40->EditAttrs["class"] = "form-control";
			$this->m_40->EditCustomAttributes = "";
			$this->m_40->EditValue = HtmlEncode($this->m_40->CurrentValue);
			$this->m_40->PlaceHolder = RemoveHtml($this->m_40->caption());
			if (strval($this->m_40->EditValue) <> "" && is_numeric($this->m_40->EditValue))
				$this->m_40->EditValue = FormatNumber($this->m_40->EditValue, -2, -2, -2, -2);

			// 41
			$this->_41->EditAttrs["class"] = "form-control";
			$this->_41->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_41->CurrentValue = HtmlDecode($this->_41->CurrentValue);
			$this->_41->EditValue = HtmlEncode($this->_41->CurrentValue);
			$this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

			// m_41
			$this->m_41->EditAttrs["class"] = "form-control";
			$this->m_41->EditCustomAttributes = "";
			$this->m_41->EditValue = HtmlEncode($this->m_41->CurrentValue);
			$this->m_41->PlaceHolder = RemoveHtml($this->m_41->caption());
			if (strval($this->m_41->EditValue) <> "" && is_numeric($this->m_41->EditValue))
				$this->m_41->EditValue = FormatNumber($this->m_41->EditValue, -2, -2, -2, -2);

			// 42
			$this->_42->EditAttrs["class"] = "form-control";
			$this->_42->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_42->CurrentValue = HtmlDecode($this->_42->CurrentValue);
			$this->_42->EditValue = HtmlEncode($this->_42->CurrentValue);
			$this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

			// m_42
			$this->m_42->EditAttrs["class"] = "form-control";
			$this->m_42->EditCustomAttributes = "";
			$this->m_42->EditValue = HtmlEncode($this->m_42->CurrentValue);
			$this->m_42->PlaceHolder = RemoveHtml($this->m_42->caption());
			if (strval($this->m_42->EditValue) <> "" && is_numeric($this->m_42->EditValue))
				$this->m_42->EditValue = FormatNumber($this->m_42->EditValue, -2, -2, -2, -2);

			// 43
			$this->_43->EditAttrs["class"] = "form-control";
			$this->_43->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_43->CurrentValue = HtmlDecode($this->_43->CurrentValue);
			$this->_43->EditValue = HtmlEncode($this->_43->CurrentValue);
			$this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

			// m_43
			$this->m_43->EditAttrs["class"] = "form-control";
			$this->m_43->EditCustomAttributes = "";
			$this->m_43->EditValue = HtmlEncode($this->m_43->CurrentValue);
			$this->m_43->PlaceHolder = RemoveHtml($this->m_43->caption());
			if (strval($this->m_43->EditValue) <> "" && is_numeric($this->m_43->EditValue))
				$this->m_43->EditValue = FormatNumber($this->m_43->EditValue, -2, -2, -2, -2);

			// 44
			$this->_44->EditAttrs["class"] = "form-control";
			$this->_44->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_44->CurrentValue = HtmlDecode($this->_44->CurrentValue);
			$this->_44->EditValue = HtmlEncode($this->_44->CurrentValue);
			$this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

			// m_44
			$this->m_44->EditAttrs["class"] = "form-control";
			$this->m_44->EditCustomAttributes = "";
			$this->m_44->EditValue = HtmlEncode($this->m_44->CurrentValue);
			$this->m_44->PlaceHolder = RemoveHtml($this->m_44->caption());
			if (strval($this->m_44->EditValue) <> "" && is_numeric($this->m_44->EditValue))
				$this->m_44->EditValue = FormatNumber($this->m_44->EditValue, -2, -2, -2, -2);

			// 45
			$this->_45->EditAttrs["class"] = "form-control";
			$this->_45->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_45->CurrentValue = HtmlDecode($this->_45->CurrentValue);
			$this->_45->EditValue = HtmlEncode($this->_45->CurrentValue);
			$this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

			// m_45
			$this->m_45->EditAttrs["class"] = "form-control";
			$this->m_45->EditCustomAttributes = "";
			$this->m_45->EditValue = HtmlEncode($this->m_45->CurrentValue);
			$this->m_45->PlaceHolder = RemoveHtml($this->m_45->caption());
			if (strval($this->m_45->EditValue) <> "" && is_numeric($this->m_45->EditValue))
				$this->m_45->EditValue = FormatNumber($this->m_45->EditValue, -2, -2, -2, -2);

			// 46
			$this->_46->EditAttrs["class"] = "form-control";
			$this->_46->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_46->CurrentValue = HtmlDecode($this->_46->CurrentValue);
			$this->_46->EditValue = HtmlEncode($this->_46->CurrentValue);
			$this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

			// m_46
			$this->m_46->EditAttrs["class"] = "form-control";
			$this->m_46->EditCustomAttributes = "";
			$this->m_46->EditValue = HtmlEncode($this->m_46->CurrentValue);
			$this->m_46->PlaceHolder = RemoveHtml($this->m_46->caption());
			if (strval($this->m_46->EditValue) <> "" && is_numeric($this->m_46->EditValue))
				$this->m_46->EditValue = FormatNumber($this->m_46->EditValue, -2, -2, -2, -2);

			// 47
			$this->_47->EditAttrs["class"] = "form-control";
			$this->_47->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_47->CurrentValue = HtmlDecode($this->_47->CurrentValue);
			$this->_47->EditValue = HtmlEncode($this->_47->CurrentValue);
			$this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

			// m_47
			$this->m_47->EditAttrs["class"] = "form-control";
			$this->m_47->EditCustomAttributes = "";
			$this->m_47->EditValue = HtmlEncode($this->m_47->CurrentValue);
			$this->m_47->PlaceHolder = RemoveHtml($this->m_47->caption());
			if (strval($this->m_47->EditValue) <> "" && is_numeric($this->m_47->EditValue))
				$this->m_47->EditValue = FormatNumber($this->m_47->EditValue, -2, -2, -2, -2);

			// 48
			$this->_48->EditAttrs["class"] = "form-control";
			$this->_48->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_48->CurrentValue = HtmlDecode($this->_48->CurrentValue);
			$this->_48->EditValue = HtmlEncode($this->_48->CurrentValue);
			$this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

			// m_48
			$this->m_48->EditAttrs["class"] = "form-control";
			$this->m_48->EditCustomAttributes = "";
			$this->m_48->EditValue = HtmlEncode($this->m_48->CurrentValue);
			$this->m_48->PlaceHolder = RemoveHtml($this->m_48->caption());
			if (strval($this->m_48->EditValue) <> "" && is_numeric($this->m_48->EditValue))
				$this->m_48->EditValue = FormatNumber($this->m_48->EditValue, -2, -2, -2, -2);

			// 49
			$this->_49->EditAttrs["class"] = "form-control";
			$this->_49->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_49->CurrentValue = HtmlDecode($this->_49->CurrentValue);
			$this->_49->EditValue = HtmlEncode($this->_49->CurrentValue);
			$this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

			// m_49
			$this->m_49->EditAttrs["class"] = "form-control";
			$this->m_49->EditCustomAttributes = "";
			$this->m_49->EditValue = HtmlEncode($this->m_49->CurrentValue);
			$this->m_49->PlaceHolder = RemoveHtml($this->m_49->caption());
			if (strval($this->m_49->EditValue) <> "" && is_numeric($this->m_49->EditValue))
				$this->m_49->EditValue = FormatNumber($this->m_49->EditValue, -2, -2, -2, -2);

			// 50
			$this->_50->EditAttrs["class"] = "form-control";
			$this->_50->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_50->CurrentValue = HtmlDecode($this->_50->CurrentValue);
			$this->_50->EditValue = HtmlEncode($this->_50->CurrentValue);
			$this->_50->PlaceHolder = RemoveHtml($this->_50->caption());

			// m_50
			$this->m_50->EditAttrs["class"] = "form-control";
			$this->m_50->EditCustomAttributes = "";
			$this->m_50->EditValue = HtmlEncode($this->m_50->CurrentValue);
			$this->m_50->PlaceHolder = RemoveHtml($this->m_50->caption());
			if (strval($this->m_50->EditValue) <> "" && is_numeric($this->m_50->EditValue))
				$this->m_50->EditValue = FormatNumber($this->m_50->EditValue, -2, -2, -2, -2);

			// 51
			$this->_51->EditAttrs["class"] = "form-control";
			$this->_51->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_51->CurrentValue = HtmlDecode($this->_51->CurrentValue);
			$this->_51->EditValue = HtmlEncode($this->_51->CurrentValue);
			$this->_51->PlaceHolder = RemoveHtml($this->_51->caption());

			// m_51
			$this->m_51->EditAttrs["class"] = "form-control";
			$this->m_51->EditCustomAttributes = "";
			$this->m_51->EditValue = HtmlEncode($this->m_51->CurrentValue);
			$this->m_51->PlaceHolder = RemoveHtml($this->m_51->caption());
			if (strval($this->m_51->EditValue) <> "" && is_numeric($this->m_51->EditValue))
				$this->m_51->EditValue = FormatNumber($this->m_51->EditValue, -2, -2, -2, -2);

			// 52
			$this->_52->EditAttrs["class"] = "form-control";
			$this->_52->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_52->CurrentValue = HtmlDecode($this->_52->CurrentValue);
			$this->_52->EditValue = HtmlEncode($this->_52->CurrentValue);
			$this->_52->PlaceHolder = RemoveHtml($this->_52->caption());

			// m_52
			$this->m_52->EditAttrs["class"] = "form-control";
			$this->m_52->EditCustomAttributes = "";
			$this->m_52->EditValue = HtmlEncode($this->m_52->CurrentValue);
			$this->m_52->PlaceHolder = RemoveHtml($this->m_52->caption());
			if (strval($this->m_52->EditValue) <> "" && is_numeric($this->m_52->EditValue))
				$this->m_52->EditValue = FormatNumber($this->m_52->EditValue, -2, -2, -2, -2);

			// 53
			$this->_53->EditAttrs["class"] = "form-control";
			$this->_53->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_53->CurrentValue = HtmlDecode($this->_53->CurrentValue);
			$this->_53->EditValue = HtmlEncode($this->_53->CurrentValue);
			$this->_53->PlaceHolder = RemoveHtml($this->_53->caption());

			// m_53
			$this->m_53->EditAttrs["class"] = "form-control";
			$this->m_53->EditCustomAttributes = "";
			$this->m_53->EditValue = HtmlEncode($this->m_53->CurrentValue);
			$this->m_53->PlaceHolder = RemoveHtml($this->m_53->caption());
			if (strval($this->m_53->EditValue) <> "" && is_numeric($this->m_53->EditValue))
				$this->m_53->EditValue = FormatNumber($this->m_53->EditValue, -2, -2, -2, -2);

			// 54
			$this->_54->EditAttrs["class"] = "form-control";
			$this->_54->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_54->CurrentValue = HtmlDecode($this->_54->CurrentValue);
			$this->_54->EditValue = HtmlEncode($this->_54->CurrentValue);
			$this->_54->PlaceHolder = RemoveHtml($this->_54->caption());

			// m_54
			$this->m_54->EditAttrs["class"] = "form-control";
			$this->m_54->EditCustomAttributes = "";
			$this->m_54->EditValue = HtmlEncode($this->m_54->CurrentValue);
			$this->m_54->PlaceHolder = RemoveHtml($this->m_54->caption());
			if (strval($this->m_54->EditValue) <> "" && is_numeric($this->m_54->EditValue))
				$this->m_54->EditValue = FormatNumber($this->m_54->EditValue, -2, -2, -2, -2);

			// 55
			$this->_55->EditAttrs["class"] = "form-control";
			$this->_55->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_55->CurrentValue = HtmlDecode($this->_55->CurrentValue);
			$this->_55->EditValue = HtmlEncode($this->_55->CurrentValue);
			$this->_55->PlaceHolder = RemoveHtml($this->_55->caption());

			// m_55
			$this->m_55->EditAttrs["class"] = "form-control";
			$this->m_55->EditCustomAttributes = "";
			$this->m_55->EditValue = HtmlEncode($this->m_55->CurrentValue);
			$this->m_55->PlaceHolder = RemoveHtml($this->m_55->caption());
			if (strval($this->m_55->EditValue) <> "" && is_numeric($this->m_55->EditValue))
				$this->m_55->EditValue = FormatNumber($this->m_55->EditValue, -2, -2, -2, -2);

			// 56
			$this->_56->EditAttrs["class"] = "form-control";
			$this->_56->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_56->CurrentValue = HtmlDecode($this->_56->CurrentValue);
			$this->_56->EditValue = HtmlEncode($this->_56->CurrentValue);
			$this->_56->PlaceHolder = RemoveHtml($this->_56->caption());

			// m_56
			$this->m_56->EditAttrs["class"] = "form-control";
			$this->m_56->EditCustomAttributes = "";
			$this->m_56->EditValue = HtmlEncode($this->m_56->CurrentValue);
			$this->m_56->PlaceHolder = RemoveHtml($this->m_56->caption());
			if (strval($this->m_56->EditValue) <> "" && is_numeric($this->m_56->EditValue))
				$this->m_56->EditValue = FormatNumber($this->m_56->EditValue, -2, -2, -2, -2);

			// 57
			$this->_57->EditAttrs["class"] = "form-control";
			$this->_57->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_57->CurrentValue = HtmlDecode($this->_57->CurrentValue);
			$this->_57->EditValue = HtmlEncode($this->_57->CurrentValue);
			$this->_57->PlaceHolder = RemoveHtml($this->_57->caption());

			// m_57
			$this->m_57->EditAttrs["class"] = "form-control";
			$this->m_57->EditCustomAttributes = "";
			$this->m_57->EditValue = HtmlEncode($this->m_57->CurrentValue);
			$this->m_57->PlaceHolder = RemoveHtml($this->m_57->caption());
			if (strval($this->m_57->EditValue) <> "" && is_numeric($this->m_57->EditValue))
				$this->m_57->EditValue = FormatNumber($this->m_57->EditValue, -2, -2, -2, -2);

			// 58
			$this->_58->EditAttrs["class"] = "form-control";
			$this->_58->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_58->CurrentValue = HtmlDecode($this->_58->CurrentValue);
			$this->_58->EditValue = HtmlEncode($this->_58->CurrentValue);
			$this->_58->PlaceHolder = RemoveHtml($this->_58->caption());

			// m_58
			$this->m_58->EditAttrs["class"] = "form-control";
			$this->m_58->EditCustomAttributes = "";
			$this->m_58->EditValue = HtmlEncode($this->m_58->CurrentValue);
			$this->m_58->PlaceHolder = RemoveHtml($this->m_58->caption());
			if (strval($this->m_58->EditValue) <> "" && is_numeric($this->m_58->EditValue))
				$this->m_58->EditValue = FormatNumber($this->m_58->EditValue, -2, -2, -2, -2);

			// 59
			$this->_59->EditAttrs["class"] = "form-control";
			$this->_59->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_59->CurrentValue = HtmlDecode($this->_59->CurrentValue);
			$this->_59->EditValue = HtmlEncode($this->_59->CurrentValue);
			$this->_59->PlaceHolder = RemoveHtml($this->_59->caption());

			// m_59
			$this->m_59->EditAttrs["class"] = "form-control";
			$this->m_59->EditCustomAttributes = "";
			$this->m_59->EditValue = HtmlEncode($this->m_59->CurrentValue);
			$this->m_59->PlaceHolder = RemoveHtml($this->m_59->caption());
			if (strval($this->m_59->EditValue) <> "" && is_numeric($this->m_59->EditValue))
				$this->m_59->EditValue = FormatNumber($this->m_59->EditValue, -2, -2, -2, -2);

			// 60
			$this->_60->EditAttrs["class"] = "form-control";
			$this->_60->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_60->CurrentValue = HtmlDecode($this->_60->CurrentValue);
			$this->_60->EditValue = HtmlEncode($this->_60->CurrentValue);
			$this->_60->PlaceHolder = RemoveHtml($this->_60->caption());

			// m_60
			$this->m_60->EditAttrs["class"] = "form-control";
			$this->m_60->EditCustomAttributes = "";
			$this->m_60->EditValue = HtmlEncode($this->m_60->CurrentValue);
			$this->m_60->PlaceHolder = RemoveHtml($this->m_60->caption());
			if (strval($this->m_60->EditValue) <> "" && is_numeric($this->m_60->EditValue))
				$this->m_60->EditValue = FormatNumber($this->m_60->EditValue, -2, -2, -2, -2);

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";

			// test_id
			$this->test_id->LinkCustomAttributes = "";
			$this->test_id->HrefValue = "";

			// total
			$this->total->LinkCustomAttributes = "";
			$this->total->HrefValue = "";

			// percent
			$this->percent->LinkCustomAttributes = "";
			$this->percent->HrefValue = "";

			// s_1
			$this->s_1->LinkCustomAttributes = "";
			$this->s_1->HrefValue = "";

			// s_2
			$this->s_2->LinkCustomAttributes = "";
			$this->s_2->HrefValue = "";

			// s_3
			$this->s_3->LinkCustomAttributes = "";
			$this->s_3->HrefValue = "";

			// s_4
			$this->s_4->LinkCustomAttributes = "";
			$this->s_4->HrefValue = "";

			// s_5
			$this->s_5->LinkCustomAttributes = "";
			$this->s_5->HrefValue = "";

			// omr_image
			$this->omr_image->LinkCustomAttributes = "";
			$this->omr_image->UploadPath = '.p_uploads/school/omr/';
			if (!EmptyValue($this->omr_image->Upload->DbValue)) {
				$this->omr_image->HrefValue = GetFileUploadUrl($this->omr_image, $this->omr_image->Upload->DbValue); // Add prefix/suffix
				$this->omr_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->omr_image->HrefValue = FullUrl($this->omr_image->HrefValue, "href");
			} else {
				$this->omr_image->HrefValue = "";
			}
			$this->omr_image->ExportHrefValue = $this->omr_image->UploadPath . $this->omr_image->Upload->DbValue;

			// 1
			$this->_1->LinkCustomAttributes = "";
			$this->_1->HrefValue = "";

			// m_1
			$this->m_1->LinkCustomAttributes = "";
			$this->m_1->HrefValue = "";

			// 2
			$this->_2->LinkCustomAttributes = "";
			$this->_2->HrefValue = "";

			// m_2
			$this->m_2->LinkCustomAttributes = "";
			$this->m_2->HrefValue = "";

			// 3
			$this->_3->LinkCustomAttributes = "";
			$this->_3->HrefValue = "";

			// m_3
			$this->m_3->LinkCustomAttributes = "";
			$this->m_3->HrefValue = "";

			// 4
			$this->_4->LinkCustomAttributes = "";
			$this->_4->HrefValue = "";

			// m_4
			$this->m_4->LinkCustomAttributes = "";
			$this->m_4->HrefValue = "";

			// 5
			$this->_5->LinkCustomAttributes = "";
			$this->_5->HrefValue = "";

			// m_5
			$this->m_5->LinkCustomAttributes = "";
			$this->m_5->HrefValue = "";

			// 6
			$this->_6->LinkCustomAttributes = "";
			$this->_6->HrefValue = "";

			// m_6
			$this->m_6->LinkCustomAttributes = "";
			$this->m_6->HrefValue = "";

			// 7
			$this->_7->LinkCustomAttributes = "";
			$this->_7->HrefValue = "";

			// m_7
			$this->m_7->LinkCustomAttributes = "";
			$this->m_7->HrefValue = "";

			// 8
			$this->_8->LinkCustomAttributes = "";
			$this->_8->HrefValue = "";

			// m_8
			$this->m_8->LinkCustomAttributes = "";
			$this->m_8->HrefValue = "";

			// 9
			$this->_9->LinkCustomAttributes = "";
			$this->_9->HrefValue = "";

			// m_9
			$this->m_9->LinkCustomAttributes = "";
			$this->m_9->HrefValue = "";

			// 10
			$this->_10->LinkCustomAttributes = "";
			$this->_10->HrefValue = "";

			// m_10
			$this->m_10->LinkCustomAttributes = "";
			$this->m_10->HrefValue = "";

			// 11
			$this->_11->LinkCustomAttributes = "";
			$this->_11->HrefValue = "";

			// m_11
			$this->m_11->LinkCustomAttributes = "";
			$this->m_11->HrefValue = "";

			// 12
			$this->_12->LinkCustomAttributes = "";
			$this->_12->HrefValue = "";

			// m_12
			$this->m_12->LinkCustomAttributes = "";
			$this->m_12->HrefValue = "";

			// 13
			$this->_13->LinkCustomAttributes = "";
			$this->_13->HrefValue = "";

			// m_13
			$this->m_13->LinkCustomAttributes = "";
			$this->m_13->HrefValue = "";

			// 14
			$this->_14->LinkCustomAttributes = "";
			$this->_14->HrefValue = "";

			// m_14
			$this->m_14->LinkCustomAttributes = "";
			$this->m_14->HrefValue = "";

			// 15
			$this->_15->LinkCustomAttributes = "";
			$this->_15->HrefValue = "";

			// m_15
			$this->m_15->LinkCustomAttributes = "";
			$this->m_15->HrefValue = "";

			// 16
			$this->_16->LinkCustomAttributes = "";
			$this->_16->HrefValue = "";

			// m_16
			$this->m_16->LinkCustomAttributes = "";
			$this->m_16->HrefValue = "";

			// 17
			$this->_17->LinkCustomAttributes = "";
			$this->_17->HrefValue = "";

			// m_17
			$this->m_17->LinkCustomAttributes = "";
			$this->m_17->HrefValue = "";

			// 18
			$this->_18->LinkCustomAttributes = "";
			$this->_18->HrefValue = "";

			// m_18
			$this->m_18->LinkCustomAttributes = "";
			$this->m_18->HrefValue = "";

			// 19
			$this->_19->LinkCustomAttributes = "";
			$this->_19->HrefValue = "";

			// m_19
			$this->m_19->LinkCustomAttributes = "";
			$this->m_19->HrefValue = "";

			// 20
			$this->_20->LinkCustomAttributes = "";
			$this->_20->HrefValue = "";

			// m_20
			$this->m_20->LinkCustomAttributes = "";
			$this->m_20->HrefValue = "";

			// 21
			$this->_21->LinkCustomAttributes = "";
			$this->_21->HrefValue = "";

			// m_21
			$this->m_21->LinkCustomAttributes = "";
			$this->m_21->HrefValue = "";

			// 22
			$this->_22->LinkCustomAttributes = "";
			$this->_22->HrefValue = "";

			// m_22
			$this->m_22->LinkCustomAttributes = "";
			$this->m_22->HrefValue = "";

			// 23
			$this->_23->LinkCustomAttributes = "";
			$this->_23->HrefValue = "";

			// m_23
			$this->m_23->LinkCustomAttributes = "";
			$this->m_23->HrefValue = "";

			// 24
			$this->_24->LinkCustomAttributes = "";
			$this->_24->HrefValue = "";

			// m_24
			$this->m_24->LinkCustomAttributes = "";
			$this->m_24->HrefValue = "";

			// 25
			$this->_25->LinkCustomAttributes = "";
			$this->_25->HrefValue = "";

			// m_25
			$this->m_25->LinkCustomAttributes = "";
			$this->m_25->HrefValue = "";

			// 26
			$this->_26->LinkCustomAttributes = "";
			$this->_26->HrefValue = "";

			// m_26
			$this->m_26->LinkCustomAttributes = "";
			$this->m_26->HrefValue = "";

			// 27
			$this->_27->LinkCustomAttributes = "";
			$this->_27->HrefValue = "";

			// m_27
			$this->m_27->LinkCustomAttributes = "";
			$this->m_27->HrefValue = "";

			// 28
			$this->_28->LinkCustomAttributes = "";
			$this->_28->HrefValue = "";

			// m_28
			$this->m_28->LinkCustomAttributes = "";
			$this->m_28->HrefValue = "";

			// 29
			$this->_29->LinkCustomAttributes = "";
			$this->_29->HrefValue = "";

			// m_29
			$this->m_29->LinkCustomAttributes = "";
			$this->m_29->HrefValue = "";

			// 30
			$this->_30->LinkCustomAttributes = "";
			$this->_30->HrefValue = "";

			// m_30
			$this->m_30->LinkCustomAttributes = "";
			$this->m_30->HrefValue = "";

			// 31
			$this->_31->LinkCustomAttributes = "";
			$this->_31->HrefValue = "";

			// m_31
			$this->m_31->LinkCustomAttributes = "";
			$this->m_31->HrefValue = "";

			// 32
			$this->_32->LinkCustomAttributes = "";
			$this->_32->HrefValue = "";

			// m_32
			$this->m_32->LinkCustomAttributes = "";
			$this->m_32->HrefValue = "";

			// 33
			$this->_33->LinkCustomAttributes = "";
			$this->_33->HrefValue = "";

			// m_33
			$this->m_33->LinkCustomAttributes = "";
			$this->m_33->HrefValue = "";

			// 34
			$this->_34->LinkCustomAttributes = "";
			$this->_34->HrefValue = "";

			// m_34
			$this->m_34->LinkCustomAttributes = "";
			$this->m_34->HrefValue = "";

			// 35
			$this->_35->LinkCustomAttributes = "";
			$this->_35->HrefValue = "";

			// m_35
			$this->m_35->LinkCustomAttributes = "";
			$this->m_35->HrefValue = "";

			// 36
			$this->_36->LinkCustomAttributes = "";
			$this->_36->HrefValue = "";

			// m_36
			$this->m_36->LinkCustomAttributes = "";
			$this->m_36->HrefValue = "";

			// 37
			$this->_37->LinkCustomAttributes = "";
			$this->_37->HrefValue = "";

			// m_37
			$this->m_37->LinkCustomAttributes = "";
			$this->m_37->HrefValue = "";

			// 38
			$this->_38->LinkCustomAttributes = "";
			$this->_38->HrefValue = "";

			// m_38
			$this->m_38->LinkCustomAttributes = "";
			$this->m_38->HrefValue = "";

			// 39
			$this->_39->LinkCustomAttributes = "";
			$this->_39->HrefValue = "";

			// m_39
			$this->m_39->LinkCustomAttributes = "";
			$this->m_39->HrefValue = "";

			// 40
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";

			// m_40
			$this->m_40->LinkCustomAttributes = "";
			$this->m_40->HrefValue = "";

			// 41
			$this->_41->LinkCustomAttributes = "";
			$this->_41->HrefValue = "";

			// m_41
			$this->m_41->LinkCustomAttributes = "";
			$this->m_41->HrefValue = "";

			// 42
			$this->_42->LinkCustomAttributes = "";
			$this->_42->HrefValue = "";

			// m_42
			$this->m_42->LinkCustomAttributes = "";
			$this->m_42->HrefValue = "";

			// 43
			$this->_43->LinkCustomAttributes = "";
			$this->_43->HrefValue = "";

			// m_43
			$this->m_43->LinkCustomAttributes = "";
			$this->m_43->HrefValue = "";

			// 44
			$this->_44->LinkCustomAttributes = "";
			$this->_44->HrefValue = "";

			// m_44
			$this->m_44->LinkCustomAttributes = "";
			$this->m_44->HrefValue = "";

			// 45
			$this->_45->LinkCustomAttributes = "";
			$this->_45->HrefValue = "";

			// m_45
			$this->m_45->LinkCustomAttributes = "";
			$this->m_45->HrefValue = "";

			// 46
			$this->_46->LinkCustomAttributes = "";
			$this->_46->HrefValue = "";

			// m_46
			$this->m_46->LinkCustomAttributes = "";
			$this->m_46->HrefValue = "";

			// 47
			$this->_47->LinkCustomAttributes = "";
			$this->_47->HrefValue = "";

			// m_47
			$this->m_47->LinkCustomAttributes = "";
			$this->m_47->HrefValue = "";

			// 48
			$this->_48->LinkCustomAttributes = "";
			$this->_48->HrefValue = "";

			// m_48
			$this->m_48->LinkCustomAttributes = "";
			$this->m_48->HrefValue = "";

			// 49
			$this->_49->LinkCustomAttributes = "";
			$this->_49->HrefValue = "";

			// m_49
			$this->m_49->LinkCustomAttributes = "";
			$this->m_49->HrefValue = "";

			// 50
			$this->_50->LinkCustomAttributes = "";
			$this->_50->HrefValue = "";

			// m_50
			$this->m_50->LinkCustomAttributes = "";
			$this->m_50->HrefValue = "";

			// 51
			$this->_51->LinkCustomAttributes = "";
			$this->_51->HrefValue = "";

			// m_51
			$this->m_51->LinkCustomAttributes = "";
			$this->m_51->HrefValue = "";

			// 52
			$this->_52->LinkCustomAttributes = "";
			$this->_52->HrefValue = "";

			// m_52
			$this->m_52->LinkCustomAttributes = "";
			$this->m_52->HrefValue = "";

			// 53
			$this->_53->LinkCustomAttributes = "";
			$this->_53->HrefValue = "";

			// m_53
			$this->m_53->LinkCustomAttributes = "";
			$this->m_53->HrefValue = "";

			// 54
			$this->_54->LinkCustomAttributes = "";
			$this->_54->HrefValue = "";

			// m_54
			$this->m_54->LinkCustomAttributes = "";
			$this->m_54->HrefValue = "";

			// 55
			$this->_55->LinkCustomAttributes = "";
			$this->_55->HrefValue = "";

			// m_55
			$this->m_55->LinkCustomAttributes = "";
			$this->m_55->HrefValue = "";

			// 56
			$this->_56->LinkCustomAttributes = "";
			$this->_56->HrefValue = "";

			// m_56
			$this->m_56->LinkCustomAttributes = "";
			$this->m_56->HrefValue = "";

			// 57
			$this->_57->LinkCustomAttributes = "";
			$this->_57->HrefValue = "";

			// m_57
			$this->m_57->LinkCustomAttributes = "";
			$this->m_57->HrefValue = "";

			// 58
			$this->_58->LinkCustomAttributes = "";
			$this->_58->HrefValue = "";

			// m_58
			$this->m_58->LinkCustomAttributes = "";
			$this->m_58->HrefValue = "";

			// 59
			$this->_59->LinkCustomAttributes = "";
			$this->_59->HrefValue = "";

			// m_59
			$this->m_59->LinkCustomAttributes = "";
			$this->m_59->HrefValue = "";

			// 60
			$this->_60->LinkCustomAttributes = "";
			$this->_60->HrefValue = "";

			// m_60
			$this->m_60->LinkCustomAttributes = "";
			$this->m_60->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->roll_no->Required) {
			if (!$this->roll_no->IsDetailKey && $this->roll_no->FormValue != NULL && $this->roll_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->roll_no->caption(), $this->roll_no->RequiredErrorMessage));
			}
		}
		if ($this->test_id->Required) {
			if (!$this->test_id->IsDetailKey && $this->test_id->FormValue != NULL && $this->test_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->test_id->caption(), $this->test_id->RequiredErrorMessage));
			}
		}
		if ($this->total->Required) {
			if (!$this->total->IsDetailKey && $this->total->FormValue != NULL && $this->total->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->total->caption(), $this->total->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->total->FormValue)) {
			AddMessage($FormError, $this->total->errorMessage());
		}
		if ($this->percent->Required) {
			if (!$this->percent->IsDetailKey && $this->percent->FormValue != NULL && $this->percent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->percent->caption(), $this->percent->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->percent->FormValue)) {
			AddMessage($FormError, $this->percent->errorMessage());
		}
		if ($this->s_1->Required) {
			if (!$this->s_1->IsDetailKey && $this->s_1->FormValue != NULL && $this->s_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_1->caption(), $this->s_1->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->s_1->FormValue)) {
			AddMessage($FormError, $this->s_1->errorMessage());
		}
		if ($this->s_2->Required) {
			if (!$this->s_2->IsDetailKey && $this->s_2->FormValue != NULL && $this->s_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_2->caption(), $this->s_2->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->s_2->FormValue)) {
			AddMessage($FormError, $this->s_2->errorMessage());
		}
		if ($this->s_3->Required) {
			if (!$this->s_3->IsDetailKey && $this->s_3->FormValue != NULL && $this->s_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_3->caption(), $this->s_3->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->s_3->FormValue)) {
			AddMessage($FormError, $this->s_3->errorMessage());
		}
		if ($this->s_4->Required) {
			if (!$this->s_4->IsDetailKey && $this->s_4->FormValue != NULL && $this->s_4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_4->caption(), $this->s_4->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->s_4->FormValue)) {
			AddMessage($FormError, $this->s_4->errorMessage());
		}
		if ($this->s_5->Required) {
			if (!$this->s_5->IsDetailKey && $this->s_5->FormValue != NULL && $this->s_5->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->s_5->caption(), $this->s_5->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->s_5->FormValue)) {
			AddMessage($FormError, $this->s_5->errorMessage());
		}
		if ($this->omr_image->Required) {
			if ($this->omr_image->Upload->FileName == "" && !$this->omr_image->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->omr_image->caption(), $this->omr_image->RequiredErrorMessage));
			}
		}
		if ($this->_1->Required) {
			if (!$this->_1->IsDetailKey && $this->_1->FormValue != NULL && $this->_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_1->caption(), $this->_1->RequiredErrorMessage));
			}
		}
		if ($this->m_1->Required) {
			if (!$this->m_1->IsDetailKey && $this->m_1->FormValue != NULL && $this->m_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_1->caption(), $this->m_1->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_1->FormValue)) {
			AddMessage($FormError, $this->m_1->errorMessage());
		}
		if ($this->_2->Required) {
			if (!$this->_2->IsDetailKey && $this->_2->FormValue != NULL && $this->_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_2->caption(), $this->_2->RequiredErrorMessage));
			}
		}
		if ($this->m_2->Required) {
			if (!$this->m_2->IsDetailKey && $this->m_2->FormValue != NULL && $this->m_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_2->caption(), $this->m_2->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_2->FormValue)) {
			AddMessage($FormError, $this->m_2->errorMessage());
		}
		if ($this->_3->Required) {
			if (!$this->_3->IsDetailKey && $this->_3->FormValue != NULL && $this->_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_3->caption(), $this->_3->RequiredErrorMessage));
			}
		}
		if ($this->m_3->Required) {
			if (!$this->m_3->IsDetailKey && $this->m_3->FormValue != NULL && $this->m_3->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_3->caption(), $this->m_3->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_3->FormValue)) {
			AddMessage($FormError, $this->m_3->errorMessage());
		}
		if ($this->_4->Required) {
			if (!$this->_4->IsDetailKey && $this->_4->FormValue != NULL && $this->_4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_4->caption(), $this->_4->RequiredErrorMessage));
			}
		}
		if ($this->m_4->Required) {
			if (!$this->m_4->IsDetailKey && $this->m_4->FormValue != NULL && $this->m_4->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_4->caption(), $this->m_4->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_4->FormValue)) {
			AddMessage($FormError, $this->m_4->errorMessage());
		}
		if ($this->_5->Required) {
			if (!$this->_5->IsDetailKey && $this->_5->FormValue != NULL && $this->_5->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_5->caption(), $this->_5->RequiredErrorMessage));
			}
		}
		if ($this->m_5->Required) {
			if (!$this->m_5->IsDetailKey && $this->m_5->FormValue != NULL && $this->m_5->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_5->caption(), $this->m_5->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_5->FormValue)) {
			AddMessage($FormError, $this->m_5->errorMessage());
		}
		if ($this->_6->Required) {
			if (!$this->_6->IsDetailKey && $this->_6->FormValue != NULL && $this->_6->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_6->caption(), $this->_6->RequiredErrorMessage));
			}
		}
		if ($this->m_6->Required) {
			if (!$this->m_6->IsDetailKey && $this->m_6->FormValue != NULL && $this->m_6->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_6->caption(), $this->m_6->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_6->FormValue)) {
			AddMessage($FormError, $this->m_6->errorMessage());
		}
		if ($this->_7->Required) {
			if (!$this->_7->IsDetailKey && $this->_7->FormValue != NULL && $this->_7->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_7->caption(), $this->_7->RequiredErrorMessage));
			}
		}
		if ($this->m_7->Required) {
			if (!$this->m_7->IsDetailKey && $this->m_7->FormValue != NULL && $this->m_7->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_7->caption(), $this->m_7->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_7->FormValue)) {
			AddMessage($FormError, $this->m_7->errorMessage());
		}
		if ($this->_8->Required) {
			if (!$this->_8->IsDetailKey && $this->_8->FormValue != NULL && $this->_8->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_8->caption(), $this->_8->RequiredErrorMessage));
			}
		}
		if ($this->m_8->Required) {
			if (!$this->m_8->IsDetailKey && $this->m_8->FormValue != NULL && $this->m_8->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_8->caption(), $this->m_8->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_8->FormValue)) {
			AddMessage($FormError, $this->m_8->errorMessage());
		}
		if ($this->_9->Required) {
			if (!$this->_9->IsDetailKey && $this->_9->FormValue != NULL && $this->_9->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_9->caption(), $this->_9->RequiredErrorMessage));
			}
		}
		if ($this->m_9->Required) {
			if (!$this->m_9->IsDetailKey && $this->m_9->FormValue != NULL && $this->m_9->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_9->caption(), $this->m_9->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_9->FormValue)) {
			AddMessage($FormError, $this->m_9->errorMessage());
		}
		if ($this->_10->Required) {
			if (!$this->_10->IsDetailKey && $this->_10->FormValue != NULL && $this->_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_10->caption(), $this->_10->RequiredErrorMessage));
			}
		}
		if ($this->m_10->Required) {
			if (!$this->m_10->IsDetailKey && $this->m_10->FormValue != NULL && $this->m_10->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_10->caption(), $this->m_10->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_10->FormValue)) {
			AddMessage($FormError, $this->m_10->errorMessage());
		}
		if ($this->_11->Required) {
			if (!$this->_11->IsDetailKey && $this->_11->FormValue != NULL && $this->_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_11->caption(), $this->_11->RequiredErrorMessage));
			}
		}
		if ($this->m_11->Required) {
			if (!$this->m_11->IsDetailKey && $this->m_11->FormValue != NULL && $this->m_11->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_11->caption(), $this->m_11->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_11->FormValue)) {
			AddMessage($FormError, $this->m_11->errorMessage());
		}
		if ($this->_12->Required) {
			if (!$this->_12->IsDetailKey && $this->_12->FormValue != NULL && $this->_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_12->caption(), $this->_12->RequiredErrorMessage));
			}
		}
		if ($this->m_12->Required) {
			if (!$this->m_12->IsDetailKey && $this->m_12->FormValue != NULL && $this->m_12->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_12->caption(), $this->m_12->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_12->FormValue)) {
			AddMessage($FormError, $this->m_12->errorMessage());
		}
		if ($this->_13->Required) {
			if (!$this->_13->IsDetailKey && $this->_13->FormValue != NULL && $this->_13->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_13->caption(), $this->_13->RequiredErrorMessage));
			}
		}
		if ($this->m_13->Required) {
			if (!$this->m_13->IsDetailKey && $this->m_13->FormValue != NULL && $this->m_13->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_13->caption(), $this->m_13->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_13->FormValue)) {
			AddMessage($FormError, $this->m_13->errorMessage());
		}
		if ($this->_14->Required) {
			if (!$this->_14->IsDetailKey && $this->_14->FormValue != NULL && $this->_14->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_14->caption(), $this->_14->RequiredErrorMessage));
			}
		}
		if ($this->m_14->Required) {
			if (!$this->m_14->IsDetailKey && $this->m_14->FormValue != NULL && $this->m_14->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_14->caption(), $this->m_14->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_14->FormValue)) {
			AddMessage($FormError, $this->m_14->errorMessage());
		}
		if ($this->_15->Required) {
			if (!$this->_15->IsDetailKey && $this->_15->FormValue != NULL && $this->_15->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_15->caption(), $this->_15->RequiredErrorMessage));
			}
		}
		if ($this->m_15->Required) {
			if (!$this->m_15->IsDetailKey && $this->m_15->FormValue != NULL && $this->m_15->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_15->caption(), $this->m_15->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_15->FormValue)) {
			AddMessage($FormError, $this->m_15->errorMessage());
		}
		if ($this->_16->Required) {
			if (!$this->_16->IsDetailKey && $this->_16->FormValue != NULL && $this->_16->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_16->caption(), $this->_16->RequiredErrorMessage));
			}
		}
		if ($this->m_16->Required) {
			if (!$this->m_16->IsDetailKey && $this->m_16->FormValue != NULL && $this->m_16->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_16->caption(), $this->m_16->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_16->FormValue)) {
			AddMessage($FormError, $this->m_16->errorMessage());
		}
		if ($this->_17->Required) {
			if (!$this->_17->IsDetailKey && $this->_17->FormValue != NULL && $this->_17->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_17->caption(), $this->_17->RequiredErrorMessage));
			}
		}
		if ($this->m_17->Required) {
			if (!$this->m_17->IsDetailKey && $this->m_17->FormValue != NULL && $this->m_17->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_17->caption(), $this->m_17->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_17->FormValue)) {
			AddMessage($FormError, $this->m_17->errorMessage());
		}
		if ($this->_18->Required) {
			if (!$this->_18->IsDetailKey && $this->_18->FormValue != NULL && $this->_18->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_18->caption(), $this->_18->RequiredErrorMessage));
			}
		}
		if ($this->m_18->Required) {
			if (!$this->m_18->IsDetailKey && $this->m_18->FormValue != NULL && $this->m_18->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_18->caption(), $this->m_18->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_18->FormValue)) {
			AddMessage($FormError, $this->m_18->errorMessage());
		}
		if ($this->_19->Required) {
			if (!$this->_19->IsDetailKey && $this->_19->FormValue != NULL && $this->_19->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_19->caption(), $this->_19->RequiredErrorMessage));
			}
		}
		if ($this->m_19->Required) {
			if (!$this->m_19->IsDetailKey && $this->m_19->FormValue != NULL && $this->m_19->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_19->caption(), $this->m_19->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_19->FormValue)) {
			AddMessage($FormError, $this->m_19->errorMessage());
		}
		if ($this->_20->Required) {
			if (!$this->_20->IsDetailKey && $this->_20->FormValue != NULL && $this->_20->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_20->caption(), $this->_20->RequiredErrorMessage));
			}
		}
		if ($this->m_20->Required) {
			if (!$this->m_20->IsDetailKey && $this->m_20->FormValue != NULL && $this->m_20->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_20->caption(), $this->m_20->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_20->FormValue)) {
			AddMessage($FormError, $this->m_20->errorMessage());
		}
		if ($this->_21->Required) {
			if (!$this->_21->IsDetailKey && $this->_21->FormValue != NULL && $this->_21->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_21->caption(), $this->_21->RequiredErrorMessage));
			}
		}
		if ($this->m_21->Required) {
			if (!$this->m_21->IsDetailKey && $this->m_21->FormValue != NULL && $this->m_21->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_21->caption(), $this->m_21->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_21->FormValue)) {
			AddMessage($FormError, $this->m_21->errorMessage());
		}
		if ($this->_22->Required) {
			if (!$this->_22->IsDetailKey && $this->_22->FormValue != NULL && $this->_22->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_22->caption(), $this->_22->RequiredErrorMessage));
			}
		}
		if ($this->m_22->Required) {
			if (!$this->m_22->IsDetailKey && $this->m_22->FormValue != NULL && $this->m_22->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_22->caption(), $this->m_22->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_22->FormValue)) {
			AddMessage($FormError, $this->m_22->errorMessage());
		}
		if ($this->_23->Required) {
			if (!$this->_23->IsDetailKey && $this->_23->FormValue != NULL && $this->_23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_23->caption(), $this->_23->RequiredErrorMessage));
			}
		}
		if ($this->m_23->Required) {
			if (!$this->m_23->IsDetailKey && $this->m_23->FormValue != NULL && $this->m_23->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_23->caption(), $this->m_23->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_23->FormValue)) {
			AddMessage($FormError, $this->m_23->errorMessage());
		}
		if ($this->_24->Required) {
			if (!$this->_24->IsDetailKey && $this->_24->FormValue != NULL && $this->_24->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_24->caption(), $this->_24->RequiredErrorMessage));
			}
		}
		if ($this->m_24->Required) {
			if (!$this->m_24->IsDetailKey && $this->m_24->FormValue != NULL && $this->m_24->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_24->caption(), $this->m_24->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_24->FormValue)) {
			AddMessage($FormError, $this->m_24->errorMessage());
		}
		if ($this->_25->Required) {
			if (!$this->_25->IsDetailKey && $this->_25->FormValue != NULL && $this->_25->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_25->caption(), $this->_25->RequiredErrorMessage));
			}
		}
		if ($this->m_25->Required) {
			if (!$this->m_25->IsDetailKey && $this->m_25->FormValue != NULL && $this->m_25->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_25->caption(), $this->m_25->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_25->FormValue)) {
			AddMessage($FormError, $this->m_25->errorMessage());
		}
		if ($this->_26->Required) {
			if (!$this->_26->IsDetailKey && $this->_26->FormValue != NULL && $this->_26->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_26->caption(), $this->_26->RequiredErrorMessage));
			}
		}
		if ($this->m_26->Required) {
			if (!$this->m_26->IsDetailKey && $this->m_26->FormValue != NULL && $this->m_26->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_26->caption(), $this->m_26->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_26->FormValue)) {
			AddMessage($FormError, $this->m_26->errorMessage());
		}
		if ($this->_27->Required) {
			if (!$this->_27->IsDetailKey && $this->_27->FormValue != NULL && $this->_27->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_27->caption(), $this->_27->RequiredErrorMessage));
			}
		}
		if ($this->m_27->Required) {
			if (!$this->m_27->IsDetailKey && $this->m_27->FormValue != NULL && $this->m_27->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_27->caption(), $this->m_27->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_27->FormValue)) {
			AddMessage($FormError, $this->m_27->errorMessage());
		}
		if ($this->_28->Required) {
			if (!$this->_28->IsDetailKey && $this->_28->FormValue != NULL && $this->_28->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_28->caption(), $this->_28->RequiredErrorMessage));
			}
		}
		if ($this->m_28->Required) {
			if (!$this->m_28->IsDetailKey && $this->m_28->FormValue != NULL && $this->m_28->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_28->caption(), $this->m_28->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_28->FormValue)) {
			AddMessage($FormError, $this->m_28->errorMessage());
		}
		if ($this->_29->Required) {
			if (!$this->_29->IsDetailKey && $this->_29->FormValue != NULL && $this->_29->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_29->caption(), $this->_29->RequiredErrorMessage));
			}
		}
		if ($this->m_29->Required) {
			if (!$this->m_29->IsDetailKey && $this->m_29->FormValue != NULL && $this->m_29->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_29->caption(), $this->m_29->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_29->FormValue)) {
			AddMessage($FormError, $this->m_29->errorMessage());
		}
		if ($this->_30->Required) {
			if (!$this->_30->IsDetailKey && $this->_30->FormValue != NULL && $this->_30->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_30->caption(), $this->_30->RequiredErrorMessage));
			}
		}
		if ($this->m_30->Required) {
			if (!$this->m_30->IsDetailKey && $this->m_30->FormValue != NULL && $this->m_30->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_30->caption(), $this->m_30->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_30->FormValue)) {
			AddMessage($FormError, $this->m_30->errorMessage());
		}
		if ($this->_31->Required) {
			if (!$this->_31->IsDetailKey && $this->_31->FormValue != NULL && $this->_31->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_31->caption(), $this->_31->RequiredErrorMessage));
			}
		}
		if ($this->m_31->Required) {
			if (!$this->m_31->IsDetailKey && $this->m_31->FormValue != NULL && $this->m_31->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_31->caption(), $this->m_31->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_31->FormValue)) {
			AddMessage($FormError, $this->m_31->errorMessage());
		}
		if ($this->_32->Required) {
			if (!$this->_32->IsDetailKey && $this->_32->FormValue != NULL && $this->_32->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_32->caption(), $this->_32->RequiredErrorMessage));
			}
		}
		if ($this->m_32->Required) {
			if (!$this->m_32->IsDetailKey && $this->m_32->FormValue != NULL && $this->m_32->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_32->caption(), $this->m_32->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_32->FormValue)) {
			AddMessage($FormError, $this->m_32->errorMessage());
		}
		if ($this->_33->Required) {
			if (!$this->_33->IsDetailKey && $this->_33->FormValue != NULL && $this->_33->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_33->caption(), $this->_33->RequiredErrorMessage));
			}
		}
		if ($this->m_33->Required) {
			if (!$this->m_33->IsDetailKey && $this->m_33->FormValue != NULL && $this->m_33->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_33->caption(), $this->m_33->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_33->FormValue)) {
			AddMessage($FormError, $this->m_33->errorMessage());
		}
		if ($this->_34->Required) {
			if (!$this->_34->IsDetailKey && $this->_34->FormValue != NULL && $this->_34->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_34->caption(), $this->_34->RequiredErrorMessage));
			}
		}
		if ($this->m_34->Required) {
			if (!$this->m_34->IsDetailKey && $this->m_34->FormValue != NULL && $this->m_34->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_34->caption(), $this->m_34->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_34->FormValue)) {
			AddMessage($FormError, $this->m_34->errorMessage());
		}
		if ($this->_35->Required) {
			if (!$this->_35->IsDetailKey && $this->_35->FormValue != NULL && $this->_35->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_35->caption(), $this->_35->RequiredErrorMessage));
			}
		}
		if ($this->m_35->Required) {
			if (!$this->m_35->IsDetailKey && $this->m_35->FormValue != NULL && $this->m_35->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_35->caption(), $this->m_35->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_35->FormValue)) {
			AddMessage($FormError, $this->m_35->errorMessage());
		}
		if ($this->_36->Required) {
			if (!$this->_36->IsDetailKey && $this->_36->FormValue != NULL && $this->_36->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_36->caption(), $this->_36->RequiredErrorMessage));
			}
		}
		if ($this->m_36->Required) {
			if (!$this->m_36->IsDetailKey && $this->m_36->FormValue != NULL && $this->m_36->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_36->caption(), $this->m_36->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_36->FormValue)) {
			AddMessage($FormError, $this->m_36->errorMessage());
		}
		if ($this->_37->Required) {
			if (!$this->_37->IsDetailKey && $this->_37->FormValue != NULL && $this->_37->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_37->caption(), $this->_37->RequiredErrorMessage));
			}
		}
		if ($this->m_37->Required) {
			if (!$this->m_37->IsDetailKey && $this->m_37->FormValue != NULL && $this->m_37->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_37->caption(), $this->m_37->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_37->FormValue)) {
			AddMessage($FormError, $this->m_37->errorMessage());
		}
		if ($this->_38->Required) {
			if (!$this->_38->IsDetailKey && $this->_38->FormValue != NULL && $this->_38->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_38->caption(), $this->_38->RequiredErrorMessage));
			}
		}
		if ($this->m_38->Required) {
			if (!$this->m_38->IsDetailKey && $this->m_38->FormValue != NULL && $this->m_38->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_38->caption(), $this->m_38->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_38->FormValue)) {
			AddMessage($FormError, $this->m_38->errorMessage());
		}
		if ($this->_39->Required) {
			if (!$this->_39->IsDetailKey && $this->_39->FormValue != NULL && $this->_39->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_39->caption(), $this->_39->RequiredErrorMessage));
			}
		}
		if ($this->m_39->Required) {
			if (!$this->m_39->IsDetailKey && $this->m_39->FormValue != NULL && $this->m_39->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_39->caption(), $this->m_39->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_39->FormValue)) {
			AddMessage($FormError, $this->m_39->errorMessage());
		}
		if ($this->_40->Required) {
			if (!$this->_40->IsDetailKey && $this->_40->FormValue != NULL && $this->_40->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
			}
		}
		if ($this->m_40->Required) {
			if (!$this->m_40->IsDetailKey && $this->m_40->FormValue != NULL && $this->m_40->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_40->caption(), $this->m_40->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_40->FormValue)) {
			AddMessage($FormError, $this->m_40->errorMessage());
		}
		if ($this->_41->Required) {
			if (!$this->_41->IsDetailKey && $this->_41->FormValue != NULL && $this->_41->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_41->caption(), $this->_41->RequiredErrorMessage));
			}
		}
		if ($this->m_41->Required) {
			if (!$this->m_41->IsDetailKey && $this->m_41->FormValue != NULL && $this->m_41->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_41->caption(), $this->m_41->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_41->FormValue)) {
			AddMessage($FormError, $this->m_41->errorMessage());
		}
		if ($this->_42->Required) {
			if (!$this->_42->IsDetailKey && $this->_42->FormValue != NULL && $this->_42->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_42->caption(), $this->_42->RequiredErrorMessage));
			}
		}
		if ($this->m_42->Required) {
			if (!$this->m_42->IsDetailKey && $this->m_42->FormValue != NULL && $this->m_42->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_42->caption(), $this->m_42->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_42->FormValue)) {
			AddMessage($FormError, $this->m_42->errorMessage());
		}
		if ($this->_43->Required) {
			if (!$this->_43->IsDetailKey && $this->_43->FormValue != NULL && $this->_43->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_43->caption(), $this->_43->RequiredErrorMessage));
			}
		}
		if ($this->m_43->Required) {
			if (!$this->m_43->IsDetailKey && $this->m_43->FormValue != NULL && $this->m_43->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_43->caption(), $this->m_43->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_43->FormValue)) {
			AddMessage($FormError, $this->m_43->errorMessage());
		}
		if ($this->_44->Required) {
			if (!$this->_44->IsDetailKey && $this->_44->FormValue != NULL && $this->_44->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_44->caption(), $this->_44->RequiredErrorMessage));
			}
		}
		if ($this->m_44->Required) {
			if (!$this->m_44->IsDetailKey && $this->m_44->FormValue != NULL && $this->m_44->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_44->caption(), $this->m_44->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_44->FormValue)) {
			AddMessage($FormError, $this->m_44->errorMessage());
		}
		if ($this->_45->Required) {
			if (!$this->_45->IsDetailKey && $this->_45->FormValue != NULL && $this->_45->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_45->caption(), $this->_45->RequiredErrorMessage));
			}
		}
		if ($this->m_45->Required) {
			if (!$this->m_45->IsDetailKey && $this->m_45->FormValue != NULL && $this->m_45->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_45->caption(), $this->m_45->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_45->FormValue)) {
			AddMessage($FormError, $this->m_45->errorMessage());
		}
		if ($this->_46->Required) {
			if (!$this->_46->IsDetailKey && $this->_46->FormValue != NULL && $this->_46->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_46->caption(), $this->_46->RequiredErrorMessage));
			}
		}
		if ($this->m_46->Required) {
			if (!$this->m_46->IsDetailKey && $this->m_46->FormValue != NULL && $this->m_46->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_46->caption(), $this->m_46->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_46->FormValue)) {
			AddMessage($FormError, $this->m_46->errorMessage());
		}
		if ($this->_47->Required) {
			if (!$this->_47->IsDetailKey && $this->_47->FormValue != NULL && $this->_47->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_47->caption(), $this->_47->RequiredErrorMessage));
			}
		}
		if ($this->m_47->Required) {
			if (!$this->m_47->IsDetailKey && $this->m_47->FormValue != NULL && $this->m_47->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_47->caption(), $this->m_47->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_47->FormValue)) {
			AddMessage($FormError, $this->m_47->errorMessage());
		}
		if ($this->_48->Required) {
			if (!$this->_48->IsDetailKey && $this->_48->FormValue != NULL && $this->_48->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_48->caption(), $this->_48->RequiredErrorMessage));
			}
		}
		if ($this->m_48->Required) {
			if (!$this->m_48->IsDetailKey && $this->m_48->FormValue != NULL && $this->m_48->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_48->caption(), $this->m_48->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_48->FormValue)) {
			AddMessage($FormError, $this->m_48->errorMessage());
		}
		if ($this->_49->Required) {
			if (!$this->_49->IsDetailKey && $this->_49->FormValue != NULL && $this->_49->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_49->caption(), $this->_49->RequiredErrorMessage));
			}
		}
		if ($this->m_49->Required) {
			if (!$this->m_49->IsDetailKey && $this->m_49->FormValue != NULL && $this->m_49->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_49->caption(), $this->m_49->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_49->FormValue)) {
			AddMessage($FormError, $this->m_49->errorMessage());
		}
		if ($this->_50->Required) {
			if (!$this->_50->IsDetailKey && $this->_50->FormValue != NULL && $this->_50->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_50->caption(), $this->_50->RequiredErrorMessage));
			}
		}
		if ($this->m_50->Required) {
			if (!$this->m_50->IsDetailKey && $this->m_50->FormValue != NULL && $this->m_50->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_50->caption(), $this->m_50->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_50->FormValue)) {
			AddMessage($FormError, $this->m_50->errorMessage());
		}
		if ($this->_51->Required) {
			if (!$this->_51->IsDetailKey && $this->_51->FormValue != NULL && $this->_51->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_51->caption(), $this->_51->RequiredErrorMessage));
			}
		}
		if ($this->m_51->Required) {
			if (!$this->m_51->IsDetailKey && $this->m_51->FormValue != NULL && $this->m_51->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_51->caption(), $this->m_51->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_51->FormValue)) {
			AddMessage($FormError, $this->m_51->errorMessage());
		}
		if ($this->_52->Required) {
			if (!$this->_52->IsDetailKey && $this->_52->FormValue != NULL && $this->_52->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_52->caption(), $this->_52->RequiredErrorMessage));
			}
		}
		if ($this->m_52->Required) {
			if (!$this->m_52->IsDetailKey && $this->m_52->FormValue != NULL && $this->m_52->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_52->caption(), $this->m_52->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_52->FormValue)) {
			AddMessage($FormError, $this->m_52->errorMessage());
		}
		if ($this->_53->Required) {
			if (!$this->_53->IsDetailKey && $this->_53->FormValue != NULL && $this->_53->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_53->caption(), $this->_53->RequiredErrorMessage));
			}
		}
		if ($this->m_53->Required) {
			if (!$this->m_53->IsDetailKey && $this->m_53->FormValue != NULL && $this->m_53->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_53->caption(), $this->m_53->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_53->FormValue)) {
			AddMessage($FormError, $this->m_53->errorMessage());
		}
		if ($this->_54->Required) {
			if (!$this->_54->IsDetailKey && $this->_54->FormValue != NULL && $this->_54->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_54->caption(), $this->_54->RequiredErrorMessage));
			}
		}
		if ($this->m_54->Required) {
			if (!$this->m_54->IsDetailKey && $this->m_54->FormValue != NULL && $this->m_54->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_54->caption(), $this->m_54->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_54->FormValue)) {
			AddMessage($FormError, $this->m_54->errorMessage());
		}
		if ($this->_55->Required) {
			if (!$this->_55->IsDetailKey && $this->_55->FormValue != NULL && $this->_55->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_55->caption(), $this->_55->RequiredErrorMessage));
			}
		}
		if ($this->m_55->Required) {
			if (!$this->m_55->IsDetailKey && $this->m_55->FormValue != NULL && $this->m_55->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_55->caption(), $this->m_55->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_55->FormValue)) {
			AddMessage($FormError, $this->m_55->errorMessage());
		}
		if ($this->_56->Required) {
			if (!$this->_56->IsDetailKey && $this->_56->FormValue != NULL && $this->_56->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_56->caption(), $this->_56->RequiredErrorMessage));
			}
		}
		if ($this->m_56->Required) {
			if (!$this->m_56->IsDetailKey && $this->m_56->FormValue != NULL && $this->m_56->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_56->caption(), $this->m_56->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_56->FormValue)) {
			AddMessage($FormError, $this->m_56->errorMessage());
		}
		if ($this->_57->Required) {
			if (!$this->_57->IsDetailKey && $this->_57->FormValue != NULL && $this->_57->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_57->caption(), $this->_57->RequiredErrorMessage));
			}
		}
		if ($this->m_57->Required) {
			if (!$this->m_57->IsDetailKey && $this->m_57->FormValue != NULL && $this->m_57->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_57->caption(), $this->m_57->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_57->FormValue)) {
			AddMessage($FormError, $this->m_57->errorMessage());
		}
		if ($this->_58->Required) {
			if (!$this->_58->IsDetailKey && $this->_58->FormValue != NULL && $this->_58->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_58->caption(), $this->_58->RequiredErrorMessage));
			}
		}
		if ($this->m_58->Required) {
			if (!$this->m_58->IsDetailKey && $this->m_58->FormValue != NULL && $this->m_58->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_58->caption(), $this->m_58->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_58->FormValue)) {
			AddMessage($FormError, $this->m_58->errorMessage());
		}
		if ($this->_59->Required) {
			if (!$this->_59->IsDetailKey && $this->_59->FormValue != NULL && $this->_59->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_59->caption(), $this->_59->RequiredErrorMessage));
			}
		}
		if ($this->m_59->Required) {
			if (!$this->m_59->IsDetailKey && $this->m_59->FormValue != NULL && $this->m_59->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_59->caption(), $this->m_59->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_59->FormValue)) {
			AddMessage($FormError, $this->m_59->errorMessage());
		}
		if ($this->_60->Required) {
			if (!$this->_60->IsDetailKey && $this->_60->FormValue != NULL && $this->_60->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_60->caption(), $this->_60->RequiredErrorMessage));
			}
		}
		if ($this->m_60->Required) {
			if (!$this->m_60->IsDetailKey && $this->m_60->FormValue != NULL && $this->m_60->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_60->caption(), $this->m_60->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->m_60->FormValue)) {
			AddMessage($FormError, $this->m_60->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->omr_image->OldUploadPath = '.p_uploads/school/omr/';
			$this->omr_image->UploadPath = $this->omr_image->OldUploadPath;
			$rsnew = [];

			// roll_no
			$this->roll_no->setDbValueDef($rsnew, $this->roll_no->CurrentValue, "", $this->roll_no->ReadOnly);

			// test_id
			$this->test_id->setDbValueDef($rsnew, $this->test_id->CurrentValue, "", $this->test_id->ReadOnly);

			// total
			$this->total->setDbValueDef($rsnew, $this->total->CurrentValue, 0, $this->total->ReadOnly);

			// percent
			$this->percent->setDbValueDef($rsnew, $this->percent->CurrentValue, 0, $this->percent->ReadOnly);

			// s_1
			$this->s_1->setDbValueDef($rsnew, $this->s_1->CurrentValue, 0, $this->s_1->ReadOnly);

			// s_2
			$this->s_2->setDbValueDef($rsnew, $this->s_2->CurrentValue, 0, $this->s_2->ReadOnly);

			// s_3
			$this->s_3->setDbValueDef($rsnew, $this->s_3->CurrentValue, 0, $this->s_3->ReadOnly);

			// s_4
			$this->s_4->setDbValueDef($rsnew, $this->s_4->CurrentValue, 0, $this->s_4->ReadOnly);

			// s_5
			$this->s_5->setDbValueDef($rsnew, $this->s_5->CurrentValue, 0, $this->s_5->ReadOnly);

			// omr_image
			if ($this->omr_image->Visible && !$this->omr_image->ReadOnly && !$this->omr_image->Upload->KeepFile) {
				$this->omr_image->Upload->DbValue = $rsold['omr_image']; // Get original value
				if ($this->omr_image->Upload->FileName == "") {
					$rsnew['omr_image'] = NULL;
				} else {
					$rsnew['omr_image'] = $this->omr_image->Upload->FileName;
				}
			}

			// 1
			$this->_1->setDbValueDef($rsnew, $this->_1->CurrentValue, NULL, $this->_1->ReadOnly);

			// m_1
			$this->m_1->setDbValueDef($rsnew, $this->m_1->CurrentValue, NULL, $this->m_1->ReadOnly);

			// 2
			$this->_2->setDbValueDef($rsnew, $this->_2->CurrentValue, NULL, $this->_2->ReadOnly);

			// m_2
			$this->m_2->setDbValueDef($rsnew, $this->m_2->CurrentValue, NULL, $this->m_2->ReadOnly);

			// 3
			$this->_3->setDbValueDef($rsnew, $this->_3->CurrentValue, NULL, $this->_3->ReadOnly);

			// m_3
			$this->m_3->setDbValueDef($rsnew, $this->m_3->CurrentValue, NULL, $this->m_3->ReadOnly);

			// 4
			$this->_4->setDbValueDef($rsnew, $this->_4->CurrentValue, NULL, $this->_4->ReadOnly);

			// m_4
			$this->m_4->setDbValueDef($rsnew, $this->m_4->CurrentValue, NULL, $this->m_4->ReadOnly);

			// 5
			$this->_5->setDbValueDef($rsnew, $this->_5->CurrentValue, NULL, $this->_5->ReadOnly);

			// m_5
			$this->m_5->setDbValueDef($rsnew, $this->m_5->CurrentValue, NULL, $this->m_5->ReadOnly);

			// 6
			$this->_6->setDbValueDef($rsnew, $this->_6->CurrentValue, NULL, $this->_6->ReadOnly);

			// m_6
			$this->m_6->setDbValueDef($rsnew, $this->m_6->CurrentValue, NULL, $this->m_6->ReadOnly);

			// 7
			$this->_7->setDbValueDef($rsnew, $this->_7->CurrentValue, NULL, $this->_7->ReadOnly);

			// m_7
			$this->m_7->setDbValueDef($rsnew, $this->m_7->CurrentValue, NULL, $this->m_7->ReadOnly);

			// 8
			$this->_8->setDbValueDef($rsnew, $this->_8->CurrentValue, NULL, $this->_8->ReadOnly);

			// m_8
			$this->m_8->setDbValueDef($rsnew, $this->m_8->CurrentValue, NULL, $this->m_8->ReadOnly);

			// 9
			$this->_9->setDbValueDef($rsnew, $this->_9->CurrentValue, NULL, $this->_9->ReadOnly);

			// m_9
			$this->m_9->setDbValueDef($rsnew, $this->m_9->CurrentValue, NULL, $this->m_9->ReadOnly);

			// 10
			$this->_10->setDbValueDef($rsnew, $this->_10->CurrentValue, NULL, $this->_10->ReadOnly);

			// m_10
			$this->m_10->setDbValueDef($rsnew, $this->m_10->CurrentValue, NULL, $this->m_10->ReadOnly);

			// 11
			$this->_11->setDbValueDef($rsnew, $this->_11->CurrentValue, NULL, $this->_11->ReadOnly);

			// m_11
			$this->m_11->setDbValueDef($rsnew, $this->m_11->CurrentValue, NULL, $this->m_11->ReadOnly);

			// 12
			$this->_12->setDbValueDef($rsnew, $this->_12->CurrentValue, NULL, $this->_12->ReadOnly);

			// m_12
			$this->m_12->setDbValueDef($rsnew, $this->m_12->CurrentValue, NULL, $this->m_12->ReadOnly);

			// 13
			$this->_13->setDbValueDef($rsnew, $this->_13->CurrentValue, NULL, $this->_13->ReadOnly);

			// m_13
			$this->m_13->setDbValueDef($rsnew, $this->m_13->CurrentValue, NULL, $this->m_13->ReadOnly);

			// 14
			$this->_14->setDbValueDef($rsnew, $this->_14->CurrentValue, NULL, $this->_14->ReadOnly);

			// m_14
			$this->m_14->setDbValueDef($rsnew, $this->m_14->CurrentValue, NULL, $this->m_14->ReadOnly);

			// 15
			$this->_15->setDbValueDef($rsnew, $this->_15->CurrentValue, NULL, $this->_15->ReadOnly);

			// m_15
			$this->m_15->setDbValueDef($rsnew, $this->m_15->CurrentValue, NULL, $this->m_15->ReadOnly);

			// 16
			$this->_16->setDbValueDef($rsnew, $this->_16->CurrentValue, NULL, $this->_16->ReadOnly);

			// m_16
			$this->m_16->setDbValueDef($rsnew, $this->m_16->CurrentValue, NULL, $this->m_16->ReadOnly);

			// 17
			$this->_17->setDbValueDef($rsnew, $this->_17->CurrentValue, NULL, $this->_17->ReadOnly);

			// m_17
			$this->m_17->setDbValueDef($rsnew, $this->m_17->CurrentValue, NULL, $this->m_17->ReadOnly);

			// 18
			$this->_18->setDbValueDef($rsnew, $this->_18->CurrentValue, NULL, $this->_18->ReadOnly);

			// m_18
			$this->m_18->setDbValueDef($rsnew, $this->m_18->CurrentValue, NULL, $this->m_18->ReadOnly);

			// 19
			$this->_19->setDbValueDef($rsnew, $this->_19->CurrentValue, NULL, $this->_19->ReadOnly);

			// m_19
			$this->m_19->setDbValueDef($rsnew, $this->m_19->CurrentValue, NULL, $this->m_19->ReadOnly);

			// 20
			$this->_20->setDbValueDef($rsnew, $this->_20->CurrentValue, NULL, $this->_20->ReadOnly);

			// m_20
			$this->m_20->setDbValueDef($rsnew, $this->m_20->CurrentValue, NULL, $this->m_20->ReadOnly);

			// 21
			$this->_21->setDbValueDef($rsnew, $this->_21->CurrentValue, NULL, $this->_21->ReadOnly);

			// m_21
			$this->m_21->setDbValueDef($rsnew, $this->m_21->CurrentValue, NULL, $this->m_21->ReadOnly);

			// 22
			$this->_22->setDbValueDef($rsnew, $this->_22->CurrentValue, NULL, $this->_22->ReadOnly);

			// m_22
			$this->m_22->setDbValueDef($rsnew, $this->m_22->CurrentValue, NULL, $this->m_22->ReadOnly);

			// 23
			$this->_23->setDbValueDef($rsnew, $this->_23->CurrentValue, NULL, $this->_23->ReadOnly);

			// m_23
			$this->m_23->setDbValueDef($rsnew, $this->m_23->CurrentValue, NULL, $this->m_23->ReadOnly);

			// 24
			$this->_24->setDbValueDef($rsnew, $this->_24->CurrentValue, NULL, $this->_24->ReadOnly);

			// m_24
			$this->m_24->setDbValueDef($rsnew, $this->m_24->CurrentValue, NULL, $this->m_24->ReadOnly);

			// 25
			$this->_25->setDbValueDef($rsnew, $this->_25->CurrentValue, NULL, $this->_25->ReadOnly);

			// m_25
			$this->m_25->setDbValueDef($rsnew, $this->m_25->CurrentValue, NULL, $this->m_25->ReadOnly);

			// 26
			$this->_26->setDbValueDef($rsnew, $this->_26->CurrentValue, NULL, $this->_26->ReadOnly);

			// m_26
			$this->m_26->setDbValueDef($rsnew, $this->m_26->CurrentValue, NULL, $this->m_26->ReadOnly);

			// 27
			$this->_27->setDbValueDef($rsnew, $this->_27->CurrentValue, NULL, $this->_27->ReadOnly);

			// m_27
			$this->m_27->setDbValueDef($rsnew, $this->m_27->CurrentValue, NULL, $this->m_27->ReadOnly);

			// 28
			$this->_28->setDbValueDef($rsnew, $this->_28->CurrentValue, NULL, $this->_28->ReadOnly);

			// m_28
			$this->m_28->setDbValueDef($rsnew, $this->m_28->CurrentValue, NULL, $this->m_28->ReadOnly);

			// 29
			$this->_29->setDbValueDef($rsnew, $this->_29->CurrentValue, NULL, $this->_29->ReadOnly);

			// m_29
			$this->m_29->setDbValueDef($rsnew, $this->m_29->CurrentValue, NULL, $this->m_29->ReadOnly);

			// 30
			$this->_30->setDbValueDef($rsnew, $this->_30->CurrentValue, NULL, $this->_30->ReadOnly);

			// m_30
			$this->m_30->setDbValueDef($rsnew, $this->m_30->CurrentValue, NULL, $this->m_30->ReadOnly);

			// 31
			$this->_31->setDbValueDef($rsnew, $this->_31->CurrentValue, NULL, $this->_31->ReadOnly);

			// m_31
			$this->m_31->setDbValueDef($rsnew, $this->m_31->CurrentValue, NULL, $this->m_31->ReadOnly);

			// 32
			$this->_32->setDbValueDef($rsnew, $this->_32->CurrentValue, NULL, $this->_32->ReadOnly);

			// m_32
			$this->m_32->setDbValueDef($rsnew, $this->m_32->CurrentValue, NULL, $this->m_32->ReadOnly);

			// 33
			$this->_33->setDbValueDef($rsnew, $this->_33->CurrentValue, NULL, $this->_33->ReadOnly);

			// m_33
			$this->m_33->setDbValueDef($rsnew, $this->m_33->CurrentValue, NULL, $this->m_33->ReadOnly);

			// 34
			$this->_34->setDbValueDef($rsnew, $this->_34->CurrentValue, NULL, $this->_34->ReadOnly);

			// m_34
			$this->m_34->setDbValueDef($rsnew, $this->m_34->CurrentValue, NULL, $this->m_34->ReadOnly);

			// 35
			$this->_35->setDbValueDef($rsnew, $this->_35->CurrentValue, NULL, $this->_35->ReadOnly);

			// m_35
			$this->m_35->setDbValueDef($rsnew, $this->m_35->CurrentValue, NULL, $this->m_35->ReadOnly);

			// 36
			$this->_36->setDbValueDef($rsnew, $this->_36->CurrentValue, NULL, $this->_36->ReadOnly);

			// m_36
			$this->m_36->setDbValueDef($rsnew, $this->m_36->CurrentValue, NULL, $this->m_36->ReadOnly);

			// 37
			$this->_37->setDbValueDef($rsnew, $this->_37->CurrentValue, NULL, $this->_37->ReadOnly);

			// m_37
			$this->m_37->setDbValueDef($rsnew, $this->m_37->CurrentValue, NULL, $this->m_37->ReadOnly);

			// 38
			$this->_38->setDbValueDef($rsnew, $this->_38->CurrentValue, NULL, $this->_38->ReadOnly);

			// m_38
			$this->m_38->setDbValueDef($rsnew, $this->m_38->CurrentValue, NULL, $this->m_38->ReadOnly);

			// 39
			$this->_39->setDbValueDef($rsnew, $this->_39->CurrentValue, NULL, $this->_39->ReadOnly);

			// m_39
			$this->m_39->setDbValueDef($rsnew, $this->m_39->CurrentValue, NULL, $this->m_39->ReadOnly);

			// 40
			$this->_40->setDbValueDef($rsnew, $this->_40->CurrentValue, NULL, $this->_40->ReadOnly);

			// m_40
			$this->m_40->setDbValueDef($rsnew, $this->m_40->CurrentValue, NULL, $this->m_40->ReadOnly);

			// 41
			$this->_41->setDbValueDef($rsnew, $this->_41->CurrentValue, NULL, $this->_41->ReadOnly);

			// m_41
			$this->m_41->setDbValueDef($rsnew, $this->m_41->CurrentValue, NULL, $this->m_41->ReadOnly);

			// 42
			$this->_42->setDbValueDef($rsnew, $this->_42->CurrentValue, NULL, $this->_42->ReadOnly);

			// m_42
			$this->m_42->setDbValueDef($rsnew, $this->m_42->CurrentValue, NULL, $this->m_42->ReadOnly);

			// 43
			$this->_43->setDbValueDef($rsnew, $this->_43->CurrentValue, NULL, $this->_43->ReadOnly);

			// m_43
			$this->m_43->setDbValueDef($rsnew, $this->m_43->CurrentValue, NULL, $this->m_43->ReadOnly);

			// 44
			$this->_44->setDbValueDef($rsnew, $this->_44->CurrentValue, NULL, $this->_44->ReadOnly);

			// m_44
			$this->m_44->setDbValueDef($rsnew, $this->m_44->CurrentValue, NULL, $this->m_44->ReadOnly);

			// 45
			$this->_45->setDbValueDef($rsnew, $this->_45->CurrentValue, NULL, $this->_45->ReadOnly);

			// m_45
			$this->m_45->setDbValueDef($rsnew, $this->m_45->CurrentValue, NULL, $this->m_45->ReadOnly);

			// 46
			$this->_46->setDbValueDef($rsnew, $this->_46->CurrentValue, NULL, $this->_46->ReadOnly);

			// m_46
			$this->m_46->setDbValueDef($rsnew, $this->m_46->CurrentValue, NULL, $this->m_46->ReadOnly);

			// 47
			$this->_47->setDbValueDef($rsnew, $this->_47->CurrentValue, NULL, $this->_47->ReadOnly);

			// m_47
			$this->m_47->setDbValueDef($rsnew, $this->m_47->CurrentValue, NULL, $this->m_47->ReadOnly);

			// 48
			$this->_48->setDbValueDef($rsnew, $this->_48->CurrentValue, NULL, $this->_48->ReadOnly);

			// m_48
			$this->m_48->setDbValueDef($rsnew, $this->m_48->CurrentValue, NULL, $this->m_48->ReadOnly);

			// 49
			$this->_49->setDbValueDef($rsnew, $this->_49->CurrentValue, NULL, $this->_49->ReadOnly);

			// m_49
			$this->m_49->setDbValueDef($rsnew, $this->m_49->CurrentValue, NULL, $this->m_49->ReadOnly);

			// 50
			$this->_50->setDbValueDef($rsnew, $this->_50->CurrentValue, NULL, $this->_50->ReadOnly);

			// m_50
			$this->m_50->setDbValueDef($rsnew, $this->m_50->CurrentValue, NULL, $this->m_50->ReadOnly);

			// 51
			$this->_51->setDbValueDef($rsnew, $this->_51->CurrentValue, NULL, $this->_51->ReadOnly);

			// m_51
			$this->m_51->setDbValueDef($rsnew, $this->m_51->CurrentValue, NULL, $this->m_51->ReadOnly);

			// 52
			$this->_52->setDbValueDef($rsnew, $this->_52->CurrentValue, NULL, $this->_52->ReadOnly);

			// m_52
			$this->m_52->setDbValueDef($rsnew, $this->m_52->CurrentValue, NULL, $this->m_52->ReadOnly);

			// 53
			$this->_53->setDbValueDef($rsnew, $this->_53->CurrentValue, NULL, $this->_53->ReadOnly);

			// m_53
			$this->m_53->setDbValueDef($rsnew, $this->m_53->CurrentValue, NULL, $this->m_53->ReadOnly);

			// 54
			$this->_54->setDbValueDef($rsnew, $this->_54->CurrentValue, NULL, $this->_54->ReadOnly);

			// m_54
			$this->m_54->setDbValueDef($rsnew, $this->m_54->CurrentValue, NULL, $this->m_54->ReadOnly);

			// 55
			$this->_55->setDbValueDef($rsnew, $this->_55->CurrentValue, NULL, $this->_55->ReadOnly);

			// m_55
			$this->m_55->setDbValueDef($rsnew, $this->m_55->CurrentValue, NULL, $this->m_55->ReadOnly);

			// 56
			$this->_56->setDbValueDef($rsnew, $this->_56->CurrentValue, NULL, $this->_56->ReadOnly);

			// m_56
			$this->m_56->setDbValueDef($rsnew, $this->m_56->CurrentValue, NULL, $this->m_56->ReadOnly);

			// 57
			$this->_57->setDbValueDef($rsnew, $this->_57->CurrentValue, NULL, $this->_57->ReadOnly);

			// m_57
			$this->m_57->setDbValueDef($rsnew, $this->m_57->CurrentValue, NULL, $this->m_57->ReadOnly);

			// 58
			$this->_58->setDbValueDef($rsnew, $this->_58->CurrentValue, NULL, $this->_58->ReadOnly);

			// m_58
			$this->m_58->setDbValueDef($rsnew, $this->m_58->CurrentValue, NULL, $this->m_58->ReadOnly);

			// 59
			$this->_59->setDbValueDef($rsnew, $this->_59->CurrentValue, NULL, $this->_59->ReadOnly);

			// m_59
			$this->m_59->setDbValueDef($rsnew, $this->m_59->CurrentValue, NULL, $this->m_59->ReadOnly);

			// 60
			$this->_60->setDbValueDef($rsnew, $this->_60->CurrentValue, NULL, $this->_60->ReadOnly);

			// m_60
			$this->m_60->setDbValueDef($rsnew, $this->m_60->CurrentValue, NULL, $this->m_60->ReadOnly);
			if ($this->omr_image->Visible && !$this->omr_image->Upload->KeepFile) {
				$this->omr_image->UploadPath = '.p_uploads/school/omr/';
				$oldFiles = EmptyValue($this->omr_image->Upload->DbValue) ? array() : array($this->omr_image->Upload->DbValue);
				if (!EmptyValue($this->omr_image->Upload->FileName)) {
					$newFiles = array($this->omr_image->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->omr_image, $this->omr_image->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->omr_image->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->omr_image, $this->omr_image->Upload->Index) . $file1) || file_exists($this->omr_image->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->omr_image->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->omr_image, $this->omr_image->Upload->Index) . $file, UploadTempPath($this->omr_image, $this->omr_image->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->omr_image->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->omr_image->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->omr_image->setDbValueDef($rsnew, $this->omr_image->Upload->FileName, "", $this->omr_image->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->omr_image->Visible && !$this->omr_image->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->omr_image->Upload->DbValue) ? array() : array($this->omr_image->Upload->DbValue);
						if (!EmptyValue($this->omr_image->Upload->FileName)) {
							$newFiles = array($this->omr_image->Upload->FileName);
							$newFiles2 = array($rsnew['omr_image']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->omr_image, $this->omr_image->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->omr_image->Upload->saveToFile($newFiles[$i], TRUE, $i)) { // Just replace
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->omr_image->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// omr_image
		if ($this->omr_image->Upload->FileToken <> "")
			CleanUploadTempPath($this->omr_image->Upload->FileToken, $this->omr_image->Upload->Index);
		else
			CleanUploadTempPath($this->omr_image, $this->omr_image->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("s_omr_valuelist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>