<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class s_omr_value_list extends s_omr_value
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 's_omr_value';

	// Page object name
	public $PageObjName = "s_omr_value_list";

	// Grid form hidden field names
	public $FormName = "fs_omr_valuelist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (s_omr_value)
		if (!isset($GLOBALS["s_omr_value"]) || get_class($GLOBALS["s_omr_value"]) == PROJECT_NAMESPACE . "s_omr_value") {
			$GLOBALS["s_omr_value"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["s_omr_value"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "s_omr_valueadd.php";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "s_omr_valuedelete.php";
		$this->MultiUpdateUrl = "s_omr_valueupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 's_omr_value');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option fs_omr_valuelistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $s_omr_value;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($s_omr_value);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->roll_no->setVisibility();
		$this->test_id->setVisibility();
		$this->total->setVisibility();
		$this->percent->setVisibility();
		$this->s_1->setVisibility();
		$this->s_2->setVisibility();
		$this->s_3->setVisibility();
		$this->s_4->setVisibility();
		$this->s_5->setVisibility();
		$this->omr_image->setVisibility();
		$this->_1->setVisibility();
		$this->m_1->setVisibility();
		$this->_2->setVisibility();
		$this->m_2->setVisibility();
		$this->_3->setVisibility();
		$this->m_3->setVisibility();
		$this->_4->setVisibility();
		$this->m_4->setVisibility();
		$this->_5->setVisibility();
		$this->m_5->setVisibility();
		$this->_6->setVisibility();
		$this->m_6->setVisibility();
		$this->_7->setVisibility();
		$this->m_7->setVisibility();
		$this->_8->setVisibility();
		$this->m_8->setVisibility();
		$this->_9->setVisibility();
		$this->m_9->setVisibility();
		$this->_10->setVisibility();
		$this->m_10->setVisibility();
		$this->_11->setVisibility();
		$this->m_11->setVisibility();
		$this->_12->setVisibility();
		$this->m_12->setVisibility();
		$this->_13->setVisibility();
		$this->m_13->setVisibility();
		$this->_14->setVisibility();
		$this->m_14->setVisibility();
		$this->_15->setVisibility();
		$this->m_15->setVisibility();
		$this->_16->setVisibility();
		$this->m_16->setVisibility();
		$this->_17->setVisibility();
		$this->m_17->setVisibility();
		$this->_18->setVisibility();
		$this->m_18->setVisibility();
		$this->_19->setVisibility();
		$this->m_19->setVisibility();
		$this->_20->setVisibility();
		$this->m_20->setVisibility();
		$this->_21->setVisibility();
		$this->m_21->setVisibility();
		$this->_22->setVisibility();
		$this->m_22->setVisibility();
		$this->_23->setVisibility();
		$this->m_23->setVisibility();
		$this->_24->setVisibility();
		$this->m_24->setVisibility();
		$this->_25->setVisibility();
		$this->m_25->setVisibility();
		$this->_26->setVisibility();
		$this->m_26->setVisibility();
		$this->_27->setVisibility();
		$this->m_27->setVisibility();
		$this->_28->setVisibility();
		$this->m_28->setVisibility();
		$this->_29->setVisibility();
		$this->m_29->setVisibility();
		$this->_30->setVisibility();
		$this->m_30->setVisibility();
		$this->_31->setVisibility();
		$this->m_31->setVisibility();
		$this->_32->setVisibility();
		$this->m_32->setVisibility();
		$this->_33->setVisibility();
		$this->m_33->setVisibility();
		$this->_34->setVisibility();
		$this->m_34->setVisibility();
		$this->_35->setVisibility();
		$this->m_35->setVisibility();
		$this->_36->setVisibility();
		$this->m_36->setVisibility();
		$this->_37->setVisibility();
		$this->m_37->setVisibility();
		$this->_38->setVisibility();
		$this->m_38->setVisibility();
		$this->_39->setVisibility();
		$this->m_39->setVisibility();
		$this->_40->setVisibility();
		$this->m_40->setVisibility();
		$this->_41->setVisibility();
		$this->m_41->setVisibility();
		$this->_42->setVisibility();
		$this->m_42->setVisibility();
		$this->_43->setVisibility();
		$this->m_43->setVisibility();
		$this->_44->setVisibility();
		$this->m_44->setVisibility();
		$this->_45->setVisibility();
		$this->m_45->setVisibility();
		$this->_46->setVisibility();
		$this->m_46->setVisibility();
		$this->_47->setVisibility();
		$this->m_47->setVisibility();
		$this->_48->setVisibility();
		$this->m_48->setVisibility();
		$this->_49->setVisibility();
		$this->m_49->setVisibility();
		$this->_50->setVisibility();
		$this->m_50->setVisibility();
		$this->_51->setVisibility();
		$this->m_51->setVisibility();
		$this->_52->setVisibility();
		$this->m_52->setVisibility();
		$this->_53->setVisibility();
		$this->m_53->setVisibility();
		$this->_54->setVisibility();
		$this->m_54->setVisibility();
		$this->_55->setVisibility();
		$this->m_55->setVisibility();
		$this->_56->setVisibility();
		$this->m_56->setVisibility();
		$this->_57->setVisibility();
		$this->m_57->setVisibility();
		$this->_58->setVisibility();
		$this->m_58->setVisibility();
		$this->_59->setVisibility();
		$this->m_59->setVisibility();
		$this->_60->setVisibility();
		$this->m_60->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		// Search filters

		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "fs_omr_valuelistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->roll_no->AdvancedSearch->toJson(), ","); // Field roll_no
		$filterList = Concat($filterList, $this->test_id->AdvancedSearch->toJson(), ","); // Field test_id
		$filterList = Concat($filterList, $this->total->AdvancedSearch->toJson(), ","); // Field total
		$filterList = Concat($filterList, $this->percent->AdvancedSearch->toJson(), ","); // Field percent
		$filterList = Concat($filterList, $this->s_1->AdvancedSearch->toJson(), ","); // Field s_1
		$filterList = Concat($filterList, $this->s_2->AdvancedSearch->toJson(), ","); // Field s_2
		$filterList = Concat($filterList, $this->s_3->AdvancedSearch->toJson(), ","); // Field s_3
		$filterList = Concat($filterList, $this->s_4->AdvancedSearch->toJson(), ","); // Field s_4
		$filterList = Concat($filterList, $this->s_5->AdvancedSearch->toJson(), ","); // Field s_5
		$filterList = Concat($filterList, $this->omr_image->AdvancedSearch->toJson(), ","); // Field omr_image
		$filterList = Concat($filterList, $this->_1->AdvancedSearch->toJson(), ","); // Field 1
		$filterList = Concat($filterList, $this->m_1->AdvancedSearch->toJson(), ","); // Field m_1
		$filterList = Concat($filterList, $this->_2->AdvancedSearch->toJson(), ","); // Field 2
		$filterList = Concat($filterList, $this->m_2->AdvancedSearch->toJson(), ","); // Field m_2
		$filterList = Concat($filterList, $this->_3->AdvancedSearch->toJson(), ","); // Field 3
		$filterList = Concat($filterList, $this->m_3->AdvancedSearch->toJson(), ","); // Field m_3
		$filterList = Concat($filterList, $this->_4->AdvancedSearch->toJson(), ","); // Field 4
		$filterList = Concat($filterList, $this->m_4->AdvancedSearch->toJson(), ","); // Field m_4
		$filterList = Concat($filterList, $this->_5->AdvancedSearch->toJson(), ","); // Field 5
		$filterList = Concat($filterList, $this->m_5->AdvancedSearch->toJson(), ","); // Field m_5
		$filterList = Concat($filterList, $this->_6->AdvancedSearch->toJson(), ","); // Field 6
		$filterList = Concat($filterList, $this->m_6->AdvancedSearch->toJson(), ","); // Field m_6
		$filterList = Concat($filterList, $this->_7->AdvancedSearch->toJson(), ","); // Field 7
		$filterList = Concat($filterList, $this->m_7->AdvancedSearch->toJson(), ","); // Field m_7
		$filterList = Concat($filterList, $this->_8->AdvancedSearch->toJson(), ","); // Field 8
		$filterList = Concat($filterList, $this->m_8->AdvancedSearch->toJson(), ","); // Field m_8
		$filterList = Concat($filterList, $this->_9->AdvancedSearch->toJson(), ","); // Field 9
		$filterList = Concat($filterList, $this->m_9->AdvancedSearch->toJson(), ","); // Field m_9
		$filterList = Concat($filterList, $this->_10->AdvancedSearch->toJson(), ","); // Field 10
		$filterList = Concat($filterList, $this->m_10->AdvancedSearch->toJson(), ","); // Field m_10
		$filterList = Concat($filterList, $this->_11->AdvancedSearch->toJson(), ","); // Field 11
		$filterList = Concat($filterList, $this->m_11->AdvancedSearch->toJson(), ","); // Field m_11
		$filterList = Concat($filterList, $this->_12->AdvancedSearch->toJson(), ","); // Field 12
		$filterList = Concat($filterList, $this->m_12->AdvancedSearch->toJson(), ","); // Field m_12
		$filterList = Concat($filterList, $this->_13->AdvancedSearch->toJson(), ","); // Field 13
		$filterList = Concat($filterList, $this->m_13->AdvancedSearch->toJson(), ","); // Field m_13
		$filterList = Concat($filterList, $this->_14->AdvancedSearch->toJson(), ","); // Field 14
		$filterList = Concat($filterList, $this->m_14->AdvancedSearch->toJson(), ","); // Field m_14
		$filterList = Concat($filterList, $this->_15->AdvancedSearch->toJson(), ","); // Field 15
		$filterList = Concat($filterList, $this->m_15->AdvancedSearch->toJson(), ","); // Field m_15
		$filterList = Concat($filterList, $this->_16->AdvancedSearch->toJson(), ","); // Field 16
		$filterList = Concat($filterList, $this->m_16->AdvancedSearch->toJson(), ","); // Field m_16
		$filterList = Concat($filterList, $this->_17->AdvancedSearch->toJson(), ","); // Field 17
		$filterList = Concat($filterList, $this->m_17->AdvancedSearch->toJson(), ","); // Field m_17
		$filterList = Concat($filterList, $this->_18->AdvancedSearch->toJson(), ","); // Field 18
		$filterList = Concat($filterList, $this->m_18->AdvancedSearch->toJson(), ","); // Field m_18
		$filterList = Concat($filterList, $this->_19->AdvancedSearch->toJson(), ","); // Field 19
		$filterList = Concat($filterList, $this->m_19->AdvancedSearch->toJson(), ","); // Field m_19
		$filterList = Concat($filterList, $this->_20->AdvancedSearch->toJson(), ","); // Field 20
		$filterList = Concat($filterList, $this->m_20->AdvancedSearch->toJson(), ","); // Field m_20
		$filterList = Concat($filterList, $this->_21->AdvancedSearch->toJson(), ","); // Field 21
		$filterList = Concat($filterList, $this->m_21->AdvancedSearch->toJson(), ","); // Field m_21
		$filterList = Concat($filterList, $this->_22->AdvancedSearch->toJson(), ","); // Field 22
		$filterList = Concat($filterList, $this->m_22->AdvancedSearch->toJson(), ","); // Field m_22
		$filterList = Concat($filterList, $this->_23->AdvancedSearch->toJson(), ","); // Field 23
		$filterList = Concat($filterList, $this->m_23->AdvancedSearch->toJson(), ","); // Field m_23
		$filterList = Concat($filterList, $this->_24->AdvancedSearch->toJson(), ","); // Field 24
		$filterList = Concat($filterList, $this->m_24->AdvancedSearch->toJson(), ","); // Field m_24
		$filterList = Concat($filterList, $this->_25->AdvancedSearch->toJson(), ","); // Field 25
		$filterList = Concat($filterList, $this->m_25->AdvancedSearch->toJson(), ","); // Field m_25
		$filterList = Concat($filterList, $this->_26->AdvancedSearch->toJson(), ","); // Field 26
		$filterList = Concat($filterList, $this->m_26->AdvancedSearch->toJson(), ","); // Field m_26
		$filterList = Concat($filterList, $this->_27->AdvancedSearch->toJson(), ","); // Field 27
		$filterList = Concat($filterList, $this->m_27->AdvancedSearch->toJson(), ","); // Field m_27
		$filterList = Concat($filterList, $this->_28->AdvancedSearch->toJson(), ","); // Field 28
		$filterList = Concat($filterList, $this->m_28->AdvancedSearch->toJson(), ","); // Field m_28
		$filterList = Concat($filterList, $this->_29->AdvancedSearch->toJson(), ","); // Field 29
		$filterList = Concat($filterList, $this->m_29->AdvancedSearch->toJson(), ","); // Field m_29
		$filterList = Concat($filterList, $this->_30->AdvancedSearch->toJson(), ","); // Field 30
		$filterList = Concat($filterList, $this->m_30->AdvancedSearch->toJson(), ","); // Field m_30
		$filterList = Concat($filterList, $this->_31->AdvancedSearch->toJson(), ","); // Field 31
		$filterList = Concat($filterList, $this->m_31->AdvancedSearch->toJson(), ","); // Field m_31
		$filterList = Concat($filterList, $this->_32->AdvancedSearch->toJson(), ","); // Field 32
		$filterList = Concat($filterList, $this->m_32->AdvancedSearch->toJson(), ","); // Field m_32
		$filterList = Concat($filterList, $this->_33->AdvancedSearch->toJson(), ","); // Field 33
		$filterList = Concat($filterList, $this->m_33->AdvancedSearch->toJson(), ","); // Field m_33
		$filterList = Concat($filterList, $this->_34->AdvancedSearch->toJson(), ","); // Field 34
		$filterList = Concat($filterList, $this->m_34->AdvancedSearch->toJson(), ","); // Field m_34
		$filterList = Concat($filterList, $this->_35->AdvancedSearch->toJson(), ","); // Field 35
		$filterList = Concat($filterList, $this->m_35->AdvancedSearch->toJson(), ","); // Field m_35
		$filterList = Concat($filterList, $this->_36->AdvancedSearch->toJson(), ","); // Field 36
		$filterList = Concat($filterList, $this->m_36->AdvancedSearch->toJson(), ","); // Field m_36
		$filterList = Concat($filterList, $this->_37->AdvancedSearch->toJson(), ","); // Field 37
		$filterList = Concat($filterList, $this->m_37->AdvancedSearch->toJson(), ","); // Field m_37
		$filterList = Concat($filterList, $this->_38->AdvancedSearch->toJson(), ","); // Field 38
		$filterList = Concat($filterList, $this->m_38->AdvancedSearch->toJson(), ","); // Field m_38
		$filterList = Concat($filterList, $this->_39->AdvancedSearch->toJson(), ","); // Field 39
		$filterList = Concat($filterList, $this->m_39->AdvancedSearch->toJson(), ","); // Field m_39
		$filterList = Concat($filterList, $this->_40->AdvancedSearch->toJson(), ","); // Field 40
		$filterList = Concat($filterList, $this->m_40->AdvancedSearch->toJson(), ","); // Field m_40
		$filterList = Concat($filterList, $this->_41->AdvancedSearch->toJson(), ","); // Field 41
		$filterList = Concat($filterList, $this->m_41->AdvancedSearch->toJson(), ","); // Field m_41
		$filterList = Concat($filterList, $this->_42->AdvancedSearch->toJson(), ","); // Field 42
		$filterList = Concat($filterList, $this->m_42->AdvancedSearch->toJson(), ","); // Field m_42
		$filterList = Concat($filterList, $this->_43->AdvancedSearch->toJson(), ","); // Field 43
		$filterList = Concat($filterList, $this->m_43->AdvancedSearch->toJson(), ","); // Field m_43
		$filterList = Concat($filterList, $this->_44->AdvancedSearch->toJson(), ","); // Field 44
		$filterList = Concat($filterList, $this->m_44->AdvancedSearch->toJson(), ","); // Field m_44
		$filterList = Concat($filterList, $this->_45->AdvancedSearch->toJson(), ","); // Field 45
		$filterList = Concat($filterList, $this->m_45->AdvancedSearch->toJson(), ","); // Field m_45
		$filterList = Concat($filterList, $this->_46->AdvancedSearch->toJson(), ","); // Field 46
		$filterList = Concat($filterList, $this->m_46->AdvancedSearch->toJson(), ","); // Field m_46
		$filterList = Concat($filterList, $this->_47->AdvancedSearch->toJson(), ","); // Field 47
		$filterList = Concat($filterList, $this->m_47->AdvancedSearch->toJson(), ","); // Field m_47
		$filterList = Concat($filterList, $this->_48->AdvancedSearch->toJson(), ","); // Field 48
		$filterList = Concat($filterList, $this->m_48->AdvancedSearch->toJson(), ","); // Field m_48
		$filterList = Concat($filterList, $this->_49->AdvancedSearch->toJson(), ","); // Field 49
		$filterList = Concat($filterList, $this->m_49->AdvancedSearch->toJson(), ","); // Field m_49
		$filterList = Concat($filterList, $this->_50->AdvancedSearch->toJson(), ","); // Field 50
		$filterList = Concat($filterList, $this->m_50->AdvancedSearch->toJson(), ","); // Field m_50
		$filterList = Concat($filterList, $this->_51->AdvancedSearch->toJson(), ","); // Field 51
		$filterList = Concat($filterList, $this->m_51->AdvancedSearch->toJson(), ","); // Field m_51
		$filterList = Concat($filterList, $this->_52->AdvancedSearch->toJson(), ","); // Field 52
		$filterList = Concat($filterList, $this->m_52->AdvancedSearch->toJson(), ","); // Field m_52
		$filterList = Concat($filterList, $this->_53->AdvancedSearch->toJson(), ","); // Field 53
		$filterList = Concat($filterList, $this->m_53->AdvancedSearch->toJson(), ","); // Field m_53
		$filterList = Concat($filterList, $this->_54->AdvancedSearch->toJson(), ","); // Field 54
		$filterList = Concat($filterList, $this->m_54->AdvancedSearch->toJson(), ","); // Field m_54
		$filterList = Concat($filterList, $this->_55->AdvancedSearch->toJson(), ","); // Field 55
		$filterList = Concat($filterList, $this->m_55->AdvancedSearch->toJson(), ","); // Field m_55
		$filterList = Concat($filterList, $this->_56->AdvancedSearch->toJson(), ","); // Field 56
		$filterList = Concat($filterList, $this->m_56->AdvancedSearch->toJson(), ","); // Field m_56
		$filterList = Concat($filterList, $this->_57->AdvancedSearch->toJson(), ","); // Field 57
		$filterList = Concat($filterList, $this->m_57->AdvancedSearch->toJson(), ","); // Field m_57
		$filterList = Concat($filterList, $this->_58->AdvancedSearch->toJson(), ","); // Field 58
		$filterList = Concat($filterList, $this->m_58->AdvancedSearch->toJson(), ","); // Field m_58
		$filterList = Concat($filterList, $this->_59->AdvancedSearch->toJson(), ","); // Field 59
		$filterList = Concat($filterList, $this->m_59->AdvancedSearch->toJson(), ","); // Field m_59
		$filterList = Concat($filterList, $this->_60->AdvancedSearch->toJson(), ","); // Field 60
		$filterList = Concat($filterList, $this->m_60->AdvancedSearch->toJson(), ","); // Field m_60
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "fs_omr_valuelistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field roll_no
		$this->roll_no->AdvancedSearch->SearchValue = @$filter["x_roll_no"];
		$this->roll_no->AdvancedSearch->SearchOperator = @$filter["z_roll_no"];
		$this->roll_no->AdvancedSearch->SearchCondition = @$filter["v_roll_no"];
		$this->roll_no->AdvancedSearch->SearchValue2 = @$filter["y_roll_no"];
		$this->roll_no->AdvancedSearch->SearchOperator2 = @$filter["w_roll_no"];
		$this->roll_no->AdvancedSearch->save();

		// Field test_id
		$this->test_id->AdvancedSearch->SearchValue = @$filter["x_test_id"];
		$this->test_id->AdvancedSearch->SearchOperator = @$filter["z_test_id"];
		$this->test_id->AdvancedSearch->SearchCondition = @$filter["v_test_id"];
		$this->test_id->AdvancedSearch->SearchValue2 = @$filter["y_test_id"];
		$this->test_id->AdvancedSearch->SearchOperator2 = @$filter["w_test_id"];
		$this->test_id->AdvancedSearch->save();

		// Field total
		$this->total->AdvancedSearch->SearchValue = @$filter["x_total"];
		$this->total->AdvancedSearch->SearchOperator = @$filter["z_total"];
		$this->total->AdvancedSearch->SearchCondition = @$filter["v_total"];
		$this->total->AdvancedSearch->SearchValue2 = @$filter["y_total"];
		$this->total->AdvancedSearch->SearchOperator2 = @$filter["w_total"];
		$this->total->AdvancedSearch->save();

		// Field percent
		$this->percent->AdvancedSearch->SearchValue = @$filter["x_percent"];
		$this->percent->AdvancedSearch->SearchOperator = @$filter["z_percent"];
		$this->percent->AdvancedSearch->SearchCondition = @$filter["v_percent"];
		$this->percent->AdvancedSearch->SearchValue2 = @$filter["y_percent"];
		$this->percent->AdvancedSearch->SearchOperator2 = @$filter["w_percent"];
		$this->percent->AdvancedSearch->save();

		// Field s_1
		$this->s_1->AdvancedSearch->SearchValue = @$filter["x_s_1"];
		$this->s_1->AdvancedSearch->SearchOperator = @$filter["z_s_1"];
		$this->s_1->AdvancedSearch->SearchCondition = @$filter["v_s_1"];
		$this->s_1->AdvancedSearch->SearchValue2 = @$filter["y_s_1"];
		$this->s_1->AdvancedSearch->SearchOperator2 = @$filter["w_s_1"];
		$this->s_1->AdvancedSearch->save();

		// Field s_2
		$this->s_2->AdvancedSearch->SearchValue = @$filter["x_s_2"];
		$this->s_2->AdvancedSearch->SearchOperator = @$filter["z_s_2"];
		$this->s_2->AdvancedSearch->SearchCondition = @$filter["v_s_2"];
		$this->s_2->AdvancedSearch->SearchValue2 = @$filter["y_s_2"];
		$this->s_2->AdvancedSearch->SearchOperator2 = @$filter["w_s_2"];
		$this->s_2->AdvancedSearch->save();

		// Field s_3
		$this->s_3->AdvancedSearch->SearchValue = @$filter["x_s_3"];
		$this->s_3->AdvancedSearch->SearchOperator = @$filter["z_s_3"];
		$this->s_3->AdvancedSearch->SearchCondition = @$filter["v_s_3"];
		$this->s_3->AdvancedSearch->SearchValue2 = @$filter["y_s_3"];
		$this->s_3->AdvancedSearch->SearchOperator2 = @$filter["w_s_3"];
		$this->s_3->AdvancedSearch->save();

		// Field s_4
		$this->s_4->AdvancedSearch->SearchValue = @$filter["x_s_4"];
		$this->s_4->AdvancedSearch->SearchOperator = @$filter["z_s_4"];
		$this->s_4->AdvancedSearch->SearchCondition = @$filter["v_s_4"];
		$this->s_4->AdvancedSearch->SearchValue2 = @$filter["y_s_4"];
		$this->s_4->AdvancedSearch->SearchOperator2 = @$filter["w_s_4"];
		$this->s_4->AdvancedSearch->save();

		// Field s_5
		$this->s_5->AdvancedSearch->SearchValue = @$filter["x_s_5"];
		$this->s_5->AdvancedSearch->SearchOperator = @$filter["z_s_5"];
		$this->s_5->AdvancedSearch->SearchCondition = @$filter["v_s_5"];
		$this->s_5->AdvancedSearch->SearchValue2 = @$filter["y_s_5"];
		$this->s_5->AdvancedSearch->SearchOperator2 = @$filter["w_s_5"];
		$this->s_5->AdvancedSearch->save();

		// Field omr_image
		$this->omr_image->AdvancedSearch->SearchValue = @$filter["x_omr_image"];
		$this->omr_image->AdvancedSearch->SearchOperator = @$filter["z_omr_image"];
		$this->omr_image->AdvancedSearch->SearchCondition = @$filter["v_omr_image"];
		$this->omr_image->AdvancedSearch->SearchValue2 = @$filter["y_omr_image"];
		$this->omr_image->AdvancedSearch->SearchOperator2 = @$filter["w_omr_image"];
		$this->omr_image->AdvancedSearch->save();

		// Field 1
		$this->_1->AdvancedSearch->SearchValue = @$filter["x__1"];
		$this->_1->AdvancedSearch->SearchOperator = @$filter["z__1"];
		$this->_1->AdvancedSearch->SearchCondition = @$filter["v__1"];
		$this->_1->AdvancedSearch->SearchValue2 = @$filter["y__1"];
		$this->_1->AdvancedSearch->SearchOperator2 = @$filter["w__1"];
		$this->_1->AdvancedSearch->save();

		// Field m_1
		$this->m_1->AdvancedSearch->SearchValue = @$filter["x_m_1"];
		$this->m_1->AdvancedSearch->SearchOperator = @$filter["z_m_1"];
		$this->m_1->AdvancedSearch->SearchCondition = @$filter["v_m_1"];
		$this->m_1->AdvancedSearch->SearchValue2 = @$filter["y_m_1"];
		$this->m_1->AdvancedSearch->SearchOperator2 = @$filter["w_m_1"];
		$this->m_1->AdvancedSearch->save();

		// Field 2
		$this->_2->AdvancedSearch->SearchValue = @$filter["x__2"];
		$this->_2->AdvancedSearch->SearchOperator = @$filter["z__2"];
		$this->_2->AdvancedSearch->SearchCondition = @$filter["v__2"];
		$this->_2->AdvancedSearch->SearchValue2 = @$filter["y__2"];
		$this->_2->AdvancedSearch->SearchOperator2 = @$filter["w__2"];
		$this->_2->AdvancedSearch->save();

		// Field m_2
		$this->m_2->AdvancedSearch->SearchValue = @$filter["x_m_2"];
		$this->m_2->AdvancedSearch->SearchOperator = @$filter["z_m_2"];
		$this->m_2->AdvancedSearch->SearchCondition = @$filter["v_m_2"];
		$this->m_2->AdvancedSearch->SearchValue2 = @$filter["y_m_2"];
		$this->m_2->AdvancedSearch->SearchOperator2 = @$filter["w_m_2"];
		$this->m_2->AdvancedSearch->save();

		// Field 3
		$this->_3->AdvancedSearch->SearchValue = @$filter["x__3"];
		$this->_3->AdvancedSearch->SearchOperator = @$filter["z__3"];
		$this->_3->AdvancedSearch->SearchCondition = @$filter["v__3"];
		$this->_3->AdvancedSearch->SearchValue2 = @$filter["y__3"];
		$this->_3->AdvancedSearch->SearchOperator2 = @$filter["w__3"];
		$this->_3->AdvancedSearch->save();

		// Field m_3
		$this->m_3->AdvancedSearch->SearchValue = @$filter["x_m_3"];
		$this->m_3->AdvancedSearch->SearchOperator = @$filter["z_m_3"];
		$this->m_3->AdvancedSearch->SearchCondition = @$filter["v_m_3"];
		$this->m_3->AdvancedSearch->SearchValue2 = @$filter["y_m_3"];
		$this->m_3->AdvancedSearch->SearchOperator2 = @$filter["w_m_3"];
		$this->m_3->AdvancedSearch->save();

		// Field 4
		$this->_4->AdvancedSearch->SearchValue = @$filter["x__4"];
		$this->_4->AdvancedSearch->SearchOperator = @$filter["z__4"];
		$this->_4->AdvancedSearch->SearchCondition = @$filter["v__4"];
		$this->_4->AdvancedSearch->SearchValue2 = @$filter["y__4"];
		$this->_4->AdvancedSearch->SearchOperator2 = @$filter["w__4"];
		$this->_4->AdvancedSearch->save();

		// Field m_4
		$this->m_4->AdvancedSearch->SearchValue = @$filter["x_m_4"];
		$this->m_4->AdvancedSearch->SearchOperator = @$filter["z_m_4"];
		$this->m_4->AdvancedSearch->SearchCondition = @$filter["v_m_4"];
		$this->m_4->AdvancedSearch->SearchValue2 = @$filter["y_m_4"];
		$this->m_4->AdvancedSearch->SearchOperator2 = @$filter["w_m_4"];
		$this->m_4->AdvancedSearch->save();

		// Field 5
		$this->_5->AdvancedSearch->SearchValue = @$filter["x__5"];
		$this->_5->AdvancedSearch->SearchOperator = @$filter["z__5"];
		$this->_5->AdvancedSearch->SearchCondition = @$filter["v__5"];
		$this->_5->AdvancedSearch->SearchValue2 = @$filter["y__5"];
		$this->_5->AdvancedSearch->SearchOperator2 = @$filter["w__5"];
		$this->_5->AdvancedSearch->save();

		// Field m_5
		$this->m_5->AdvancedSearch->SearchValue = @$filter["x_m_5"];
		$this->m_5->AdvancedSearch->SearchOperator = @$filter["z_m_5"];
		$this->m_5->AdvancedSearch->SearchCondition = @$filter["v_m_5"];
		$this->m_5->AdvancedSearch->SearchValue2 = @$filter["y_m_5"];
		$this->m_5->AdvancedSearch->SearchOperator2 = @$filter["w_m_5"];
		$this->m_5->AdvancedSearch->save();

		// Field 6
		$this->_6->AdvancedSearch->SearchValue = @$filter["x__6"];
		$this->_6->AdvancedSearch->SearchOperator = @$filter["z__6"];
		$this->_6->AdvancedSearch->SearchCondition = @$filter["v__6"];
		$this->_6->AdvancedSearch->SearchValue2 = @$filter["y__6"];
		$this->_6->AdvancedSearch->SearchOperator2 = @$filter["w__6"];
		$this->_6->AdvancedSearch->save();

		// Field m_6
		$this->m_6->AdvancedSearch->SearchValue = @$filter["x_m_6"];
		$this->m_6->AdvancedSearch->SearchOperator = @$filter["z_m_6"];
		$this->m_6->AdvancedSearch->SearchCondition = @$filter["v_m_6"];
		$this->m_6->AdvancedSearch->SearchValue2 = @$filter["y_m_6"];
		$this->m_6->AdvancedSearch->SearchOperator2 = @$filter["w_m_6"];
		$this->m_6->AdvancedSearch->save();

		// Field 7
		$this->_7->AdvancedSearch->SearchValue = @$filter["x__7"];
		$this->_7->AdvancedSearch->SearchOperator = @$filter["z__7"];
		$this->_7->AdvancedSearch->SearchCondition = @$filter["v__7"];
		$this->_7->AdvancedSearch->SearchValue2 = @$filter["y__7"];
		$this->_7->AdvancedSearch->SearchOperator2 = @$filter["w__7"];
		$this->_7->AdvancedSearch->save();

		// Field m_7
		$this->m_7->AdvancedSearch->SearchValue = @$filter["x_m_7"];
		$this->m_7->AdvancedSearch->SearchOperator = @$filter["z_m_7"];
		$this->m_7->AdvancedSearch->SearchCondition = @$filter["v_m_7"];
		$this->m_7->AdvancedSearch->SearchValue2 = @$filter["y_m_7"];
		$this->m_7->AdvancedSearch->SearchOperator2 = @$filter["w_m_7"];
		$this->m_7->AdvancedSearch->save();

		// Field 8
		$this->_8->AdvancedSearch->SearchValue = @$filter["x__8"];
		$this->_8->AdvancedSearch->SearchOperator = @$filter["z__8"];
		$this->_8->AdvancedSearch->SearchCondition = @$filter["v__8"];
		$this->_8->AdvancedSearch->SearchValue2 = @$filter["y__8"];
		$this->_8->AdvancedSearch->SearchOperator2 = @$filter["w__8"];
		$this->_8->AdvancedSearch->save();

		// Field m_8
		$this->m_8->AdvancedSearch->SearchValue = @$filter["x_m_8"];
		$this->m_8->AdvancedSearch->SearchOperator = @$filter["z_m_8"];
		$this->m_8->AdvancedSearch->SearchCondition = @$filter["v_m_8"];
		$this->m_8->AdvancedSearch->SearchValue2 = @$filter["y_m_8"];
		$this->m_8->AdvancedSearch->SearchOperator2 = @$filter["w_m_8"];
		$this->m_8->AdvancedSearch->save();

		// Field 9
		$this->_9->AdvancedSearch->SearchValue = @$filter["x__9"];
		$this->_9->AdvancedSearch->SearchOperator = @$filter["z__9"];
		$this->_9->AdvancedSearch->SearchCondition = @$filter["v__9"];
		$this->_9->AdvancedSearch->SearchValue2 = @$filter["y__9"];
		$this->_9->AdvancedSearch->SearchOperator2 = @$filter["w__9"];
		$this->_9->AdvancedSearch->save();

		// Field m_9
		$this->m_9->AdvancedSearch->SearchValue = @$filter["x_m_9"];
		$this->m_9->AdvancedSearch->SearchOperator = @$filter["z_m_9"];
		$this->m_9->AdvancedSearch->SearchCondition = @$filter["v_m_9"];
		$this->m_9->AdvancedSearch->SearchValue2 = @$filter["y_m_9"];
		$this->m_9->AdvancedSearch->SearchOperator2 = @$filter["w_m_9"];
		$this->m_9->AdvancedSearch->save();

		// Field 10
		$this->_10->AdvancedSearch->SearchValue = @$filter["x__10"];
		$this->_10->AdvancedSearch->SearchOperator = @$filter["z__10"];
		$this->_10->AdvancedSearch->SearchCondition = @$filter["v__10"];
		$this->_10->AdvancedSearch->SearchValue2 = @$filter["y__10"];
		$this->_10->AdvancedSearch->SearchOperator2 = @$filter["w__10"];
		$this->_10->AdvancedSearch->save();

		// Field m_10
		$this->m_10->AdvancedSearch->SearchValue = @$filter["x_m_10"];
		$this->m_10->AdvancedSearch->SearchOperator = @$filter["z_m_10"];
		$this->m_10->AdvancedSearch->SearchCondition = @$filter["v_m_10"];
		$this->m_10->AdvancedSearch->SearchValue2 = @$filter["y_m_10"];
		$this->m_10->AdvancedSearch->SearchOperator2 = @$filter["w_m_10"];
		$this->m_10->AdvancedSearch->save();

		// Field 11
		$this->_11->AdvancedSearch->SearchValue = @$filter["x__11"];
		$this->_11->AdvancedSearch->SearchOperator = @$filter["z__11"];
		$this->_11->AdvancedSearch->SearchCondition = @$filter["v__11"];
		$this->_11->AdvancedSearch->SearchValue2 = @$filter["y__11"];
		$this->_11->AdvancedSearch->SearchOperator2 = @$filter["w__11"];
		$this->_11->AdvancedSearch->save();

		// Field m_11
		$this->m_11->AdvancedSearch->SearchValue = @$filter["x_m_11"];
		$this->m_11->AdvancedSearch->SearchOperator = @$filter["z_m_11"];
		$this->m_11->AdvancedSearch->SearchCondition = @$filter["v_m_11"];
		$this->m_11->AdvancedSearch->SearchValue2 = @$filter["y_m_11"];
		$this->m_11->AdvancedSearch->SearchOperator2 = @$filter["w_m_11"];
		$this->m_11->AdvancedSearch->save();

		// Field 12
		$this->_12->AdvancedSearch->SearchValue = @$filter["x__12"];
		$this->_12->AdvancedSearch->SearchOperator = @$filter["z__12"];
		$this->_12->AdvancedSearch->SearchCondition = @$filter["v__12"];
		$this->_12->AdvancedSearch->SearchValue2 = @$filter["y__12"];
		$this->_12->AdvancedSearch->SearchOperator2 = @$filter["w__12"];
		$this->_12->AdvancedSearch->save();

		// Field m_12
		$this->m_12->AdvancedSearch->SearchValue = @$filter["x_m_12"];
		$this->m_12->AdvancedSearch->SearchOperator = @$filter["z_m_12"];
		$this->m_12->AdvancedSearch->SearchCondition = @$filter["v_m_12"];
		$this->m_12->AdvancedSearch->SearchValue2 = @$filter["y_m_12"];
		$this->m_12->AdvancedSearch->SearchOperator2 = @$filter["w_m_12"];
		$this->m_12->AdvancedSearch->save();

		// Field 13
		$this->_13->AdvancedSearch->SearchValue = @$filter["x__13"];
		$this->_13->AdvancedSearch->SearchOperator = @$filter["z__13"];
		$this->_13->AdvancedSearch->SearchCondition = @$filter["v__13"];
		$this->_13->AdvancedSearch->SearchValue2 = @$filter["y__13"];
		$this->_13->AdvancedSearch->SearchOperator2 = @$filter["w__13"];
		$this->_13->AdvancedSearch->save();

		// Field m_13
		$this->m_13->AdvancedSearch->SearchValue = @$filter["x_m_13"];
		$this->m_13->AdvancedSearch->SearchOperator = @$filter["z_m_13"];
		$this->m_13->AdvancedSearch->SearchCondition = @$filter["v_m_13"];
		$this->m_13->AdvancedSearch->SearchValue2 = @$filter["y_m_13"];
		$this->m_13->AdvancedSearch->SearchOperator2 = @$filter["w_m_13"];
		$this->m_13->AdvancedSearch->save();

		// Field 14
		$this->_14->AdvancedSearch->SearchValue = @$filter["x__14"];
		$this->_14->AdvancedSearch->SearchOperator = @$filter["z__14"];
		$this->_14->AdvancedSearch->SearchCondition = @$filter["v__14"];
		$this->_14->AdvancedSearch->SearchValue2 = @$filter["y__14"];
		$this->_14->AdvancedSearch->SearchOperator2 = @$filter["w__14"];
		$this->_14->AdvancedSearch->save();

		// Field m_14
		$this->m_14->AdvancedSearch->SearchValue = @$filter["x_m_14"];
		$this->m_14->AdvancedSearch->SearchOperator = @$filter["z_m_14"];
		$this->m_14->AdvancedSearch->SearchCondition = @$filter["v_m_14"];
		$this->m_14->AdvancedSearch->SearchValue2 = @$filter["y_m_14"];
		$this->m_14->AdvancedSearch->SearchOperator2 = @$filter["w_m_14"];
		$this->m_14->AdvancedSearch->save();

		// Field 15
		$this->_15->AdvancedSearch->SearchValue = @$filter["x__15"];
		$this->_15->AdvancedSearch->SearchOperator = @$filter["z__15"];
		$this->_15->AdvancedSearch->SearchCondition = @$filter["v__15"];
		$this->_15->AdvancedSearch->SearchValue2 = @$filter["y__15"];
		$this->_15->AdvancedSearch->SearchOperator2 = @$filter["w__15"];
		$this->_15->AdvancedSearch->save();

		// Field m_15
		$this->m_15->AdvancedSearch->SearchValue = @$filter["x_m_15"];
		$this->m_15->AdvancedSearch->SearchOperator = @$filter["z_m_15"];
		$this->m_15->AdvancedSearch->SearchCondition = @$filter["v_m_15"];
		$this->m_15->AdvancedSearch->SearchValue2 = @$filter["y_m_15"];
		$this->m_15->AdvancedSearch->SearchOperator2 = @$filter["w_m_15"];
		$this->m_15->AdvancedSearch->save();

		// Field 16
		$this->_16->AdvancedSearch->SearchValue = @$filter["x__16"];
		$this->_16->AdvancedSearch->SearchOperator = @$filter["z__16"];
		$this->_16->AdvancedSearch->SearchCondition = @$filter["v__16"];
		$this->_16->AdvancedSearch->SearchValue2 = @$filter["y__16"];
		$this->_16->AdvancedSearch->SearchOperator2 = @$filter["w__16"];
		$this->_16->AdvancedSearch->save();

		// Field m_16
		$this->m_16->AdvancedSearch->SearchValue = @$filter["x_m_16"];
		$this->m_16->AdvancedSearch->SearchOperator = @$filter["z_m_16"];
		$this->m_16->AdvancedSearch->SearchCondition = @$filter["v_m_16"];
		$this->m_16->AdvancedSearch->SearchValue2 = @$filter["y_m_16"];
		$this->m_16->AdvancedSearch->SearchOperator2 = @$filter["w_m_16"];
		$this->m_16->AdvancedSearch->save();

		// Field 17
		$this->_17->AdvancedSearch->SearchValue = @$filter["x__17"];
		$this->_17->AdvancedSearch->SearchOperator = @$filter["z__17"];
		$this->_17->AdvancedSearch->SearchCondition = @$filter["v__17"];
		$this->_17->AdvancedSearch->SearchValue2 = @$filter["y__17"];
		$this->_17->AdvancedSearch->SearchOperator2 = @$filter["w__17"];
		$this->_17->AdvancedSearch->save();

		// Field m_17
		$this->m_17->AdvancedSearch->SearchValue = @$filter["x_m_17"];
		$this->m_17->AdvancedSearch->SearchOperator = @$filter["z_m_17"];
		$this->m_17->AdvancedSearch->SearchCondition = @$filter["v_m_17"];
		$this->m_17->AdvancedSearch->SearchValue2 = @$filter["y_m_17"];
		$this->m_17->AdvancedSearch->SearchOperator2 = @$filter["w_m_17"];
		$this->m_17->AdvancedSearch->save();

		// Field 18
		$this->_18->AdvancedSearch->SearchValue = @$filter["x__18"];
		$this->_18->AdvancedSearch->SearchOperator = @$filter["z__18"];
		$this->_18->AdvancedSearch->SearchCondition = @$filter["v__18"];
		$this->_18->AdvancedSearch->SearchValue2 = @$filter["y__18"];
		$this->_18->AdvancedSearch->SearchOperator2 = @$filter["w__18"];
		$this->_18->AdvancedSearch->save();

		// Field m_18
		$this->m_18->AdvancedSearch->SearchValue = @$filter["x_m_18"];
		$this->m_18->AdvancedSearch->SearchOperator = @$filter["z_m_18"];
		$this->m_18->AdvancedSearch->SearchCondition = @$filter["v_m_18"];
		$this->m_18->AdvancedSearch->SearchValue2 = @$filter["y_m_18"];
		$this->m_18->AdvancedSearch->SearchOperator2 = @$filter["w_m_18"];
		$this->m_18->AdvancedSearch->save();

		// Field 19
		$this->_19->AdvancedSearch->SearchValue = @$filter["x__19"];
		$this->_19->AdvancedSearch->SearchOperator = @$filter["z__19"];
		$this->_19->AdvancedSearch->SearchCondition = @$filter["v__19"];
		$this->_19->AdvancedSearch->SearchValue2 = @$filter["y__19"];
		$this->_19->AdvancedSearch->SearchOperator2 = @$filter["w__19"];
		$this->_19->AdvancedSearch->save();

		// Field m_19
		$this->m_19->AdvancedSearch->SearchValue = @$filter["x_m_19"];
		$this->m_19->AdvancedSearch->SearchOperator = @$filter["z_m_19"];
		$this->m_19->AdvancedSearch->SearchCondition = @$filter["v_m_19"];
		$this->m_19->AdvancedSearch->SearchValue2 = @$filter["y_m_19"];
		$this->m_19->AdvancedSearch->SearchOperator2 = @$filter["w_m_19"];
		$this->m_19->AdvancedSearch->save();

		// Field 20
		$this->_20->AdvancedSearch->SearchValue = @$filter["x__20"];
		$this->_20->AdvancedSearch->SearchOperator = @$filter["z__20"];
		$this->_20->AdvancedSearch->SearchCondition = @$filter["v__20"];
		$this->_20->AdvancedSearch->SearchValue2 = @$filter["y__20"];
		$this->_20->AdvancedSearch->SearchOperator2 = @$filter["w__20"];
		$this->_20->AdvancedSearch->save();

		// Field m_20
		$this->m_20->AdvancedSearch->SearchValue = @$filter["x_m_20"];
		$this->m_20->AdvancedSearch->SearchOperator = @$filter["z_m_20"];
		$this->m_20->AdvancedSearch->SearchCondition = @$filter["v_m_20"];
		$this->m_20->AdvancedSearch->SearchValue2 = @$filter["y_m_20"];
		$this->m_20->AdvancedSearch->SearchOperator2 = @$filter["w_m_20"];
		$this->m_20->AdvancedSearch->save();

		// Field 21
		$this->_21->AdvancedSearch->SearchValue = @$filter["x__21"];
		$this->_21->AdvancedSearch->SearchOperator = @$filter["z__21"];
		$this->_21->AdvancedSearch->SearchCondition = @$filter["v__21"];
		$this->_21->AdvancedSearch->SearchValue2 = @$filter["y__21"];
		$this->_21->AdvancedSearch->SearchOperator2 = @$filter["w__21"];
		$this->_21->AdvancedSearch->save();

		// Field m_21
		$this->m_21->AdvancedSearch->SearchValue = @$filter["x_m_21"];
		$this->m_21->AdvancedSearch->SearchOperator = @$filter["z_m_21"];
		$this->m_21->AdvancedSearch->SearchCondition = @$filter["v_m_21"];
		$this->m_21->AdvancedSearch->SearchValue2 = @$filter["y_m_21"];
		$this->m_21->AdvancedSearch->SearchOperator2 = @$filter["w_m_21"];
		$this->m_21->AdvancedSearch->save();

		// Field 22
		$this->_22->AdvancedSearch->SearchValue = @$filter["x__22"];
		$this->_22->AdvancedSearch->SearchOperator = @$filter["z__22"];
		$this->_22->AdvancedSearch->SearchCondition = @$filter["v__22"];
		$this->_22->AdvancedSearch->SearchValue2 = @$filter["y__22"];
		$this->_22->AdvancedSearch->SearchOperator2 = @$filter["w__22"];
		$this->_22->AdvancedSearch->save();

		// Field m_22
		$this->m_22->AdvancedSearch->SearchValue = @$filter["x_m_22"];
		$this->m_22->AdvancedSearch->SearchOperator = @$filter["z_m_22"];
		$this->m_22->AdvancedSearch->SearchCondition = @$filter["v_m_22"];
		$this->m_22->AdvancedSearch->SearchValue2 = @$filter["y_m_22"];
		$this->m_22->AdvancedSearch->SearchOperator2 = @$filter["w_m_22"];
		$this->m_22->AdvancedSearch->save();

		// Field 23
		$this->_23->AdvancedSearch->SearchValue = @$filter["x__23"];
		$this->_23->AdvancedSearch->SearchOperator = @$filter["z__23"];
		$this->_23->AdvancedSearch->SearchCondition = @$filter["v__23"];
		$this->_23->AdvancedSearch->SearchValue2 = @$filter["y__23"];
		$this->_23->AdvancedSearch->SearchOperator2 = @$filter["w__23"];
		$this->_23->AdvancedSearch->save();

		// Field m_23
		$this->m_23->AdvancedSearch->SearchValue = @$filter["x_m_23"];
		$this->m_23->AdvancedSearch->SearchOperator = @$filter["z_m_23"];
		$this->m_23->AdvancedSearch->SearchCondition = @$filter["v_m_23"];
		$this->m_23->AdvancedSearch->SearchValue2 = @$filter["y_m_23"];
		$this->m_23->AdvancedSearch->SearchOperator2 = @$filter["w_m_23"];
		$this->m_23->AdvancedSearch->save();

		// Field 24
		$this->_24->AdvancedSearch->SearchValue = @$filter["x__24"];
		$this->_24->AdvancedSearch->SearchOperator = @$filter["z__24"];
		$this->_24->AdvancedSearch->SearchCondition = @$filter["v__24"];
		$this->_24->AdvancedSearch->SearchValue2 = @$filter["y__24"];
		$this->_24->AdvancedSearch->SearchOperator2 = @$filter["w__24"];
		$this->_24->AdvancedSearch->save();

		// Field m_24
		$this->m_24->AdvancedSearch->SearchValue = @$filter["x_m_24"];
		$this->m_24->AdvancedSearch->SearchOperator = @$filter["z_m_24"];
		$this->m_24->AdvancedSearch->SearchCondition = @$filter["v_m_24"];
		$this->m_24->AdvancedSearch->SearchValue2 = @$filter["y_m_24"];
		$this->m_24->AdvancedSearch->SearchOperator2 = @$filter["w_m_24"];
		$this->m_24->AdvancedSearch->save();

		// Field 25
		$this->_25->AdvancedSearch->SearchValue = @$filter["x__25"];
		$this->_25->AdvancedSearch->SearchOperator = @$filter["z__25"];
		$this->_25->AdvancedSearch->SearchCondition = @$filter["v__25"];
		$this->_25->AdvancedSearch->SearchValue2 = @$filter["y__25"];
		$this->_25->AdvancedSearch->SearchOperator2 = @$filter["w__25"];
		$this->_25->AdvancedSearch->save();

		// Field m_25
		$this->m_25->AdvancedSearch->SearchValue = @$filter["x_m_25"];
		$this->m_25->AdvancedSearch->SearchOperator = @$filter["z_m_25"];
		$this->m_25->AdvancedSearch->SearchCondition = @$filter["v_m_25"];
		$this->m_25->AdvancedSearch->SearchValue2 = @$filter["y_m_25"];
		$this->m_25->AdvancedSearch->SearchOperator2 = @$filter["w_m_25"];
		$this->m_25->AdvancedSearch->save();

		// Field 26
		$this->_26->AdvancedSearch->SearchValue = @$filter["x__26"];
		$this->_26->AdvancedSearch->SearchOperator = @$filter["z__26"];
		$this->_26->AdvancedSearch->SearchCondition = @$filter["v__26"];
		$this->_26->AdvancedSearch->SearchValue2 = @$filter["y__26"];
		$this->_26->AdvancedSearch->SearchOperator2 = @$filter["w__26"];
		$this->_26->AdvancedSearch->save();

		// Field m_26
		$this->m_26->AdvancedSearch->SearchValue = @$filter["x_m_26"];
		$this->m_26->AdvancedSearch->SearchOperator = @$filter["z_m_26"];
		$this->m_26->AdvancedSearch->SearchCondition = @$filter["v_m_26"];
		$this->m_26->AdvancedSearch->SearchValue2 = @$filter["y_m_26"];
		$this->m_26->AdvancedSearch->SearchOperator2 = @$filter["w_m_26"];
		$this->m_26->AdvancedSearch->save();

		// Field 27
		$this->_27->AdvancedSearch->SearchValue = @$filter["x__27"];
		$this->_27->AdvancedSearch->SearchOperator = @$filter["z__27"];
		$this->_27->AdvancedSearch->SearchCondition = @$filter["v__27"];
		$this->_27->AdvancedSearch->SearchValue2 = @$filter["y__27"];
		$this->_27->AdvancedSearch->SearchOperator2 = @$filter["w__27"];
		$this->_27->AdvancedSearch->save();

		// Field m_27
		$this->m_27->AdvancedSearch->SearchValue = @$filter["x_m_27"];
		$this->m_27->AdvancedSearch->SearchOperator = @$filter["z_m_27"];
		$this->m_27->AdvancedSearch->SearchCondition = @$filter["v_m_27"];
		$this->m_27->AdvancedSearch->SearchValue2 = @$filter["y_m_27"];
		$this->m_27->AdvancedSearch->SearchOperator2 = @$filter["w_m_27"];
		$this->m_27->AdvancedSearch->save();

		// Field 28
		$this->_28->AdvancedSearch->SearchValue = @$filter["x__28"];
		$this->_28->AdvancedSearch->SearchOperator = @$filter["z__28"];
		$this->_28->AdvancedSearch->SearchCondition = @$filter["v__28"];
		$this->_28->AdvancedSearch->SearchValue2 = @$filter["y__28"];
		$this->_28->AdvancedSearch->SearchOperator2 = @$filter["w__28"];
		$this->_28->AdvancedSearch->save();

		// Field m_28
		$this->m_28->AdvancedSearch->SearchValue = @$filter["x_m_28"];
		$this->m_28->AdvancedSearch->SearchOperator = @$filter["z_m_28"];
		$this->m_28->AdvancedSearch->SearchCondition = @$filter["v_m_28"];
		$this->m_28->AdvancedSearch->SearchValue2 = @$filter["y_m_28"];
		$this->m_28->AdvancedSearch->SearchOperator2 = @$filter["w_m_28"];
		$this->m_28->AdvancedSearch->save();

		// Field 29
		$this->_29->AdvancedSearch->SearchValue = @$filter["x__29"];
		$this->_29->AdvancedSearch->SearchOperator = @$filter["z__29"];
		$this->_29->AdvancedSearch->SearchCondition = @$filter["v__29"];
		$this->_29->AdvancedSearch->SearchValue2 = @$filter["y__29"];
		$this->_29->AdvancedSearch->SearchOperator2 = @$filter["w__29"];
		$this->_29->AdvancedSearch->save();

		// Field m_29
		$this->m_29->AdvancedSearch->SearchValue = @$filter["x_m_29"];
		$this->m_29->AdvancedSearch->SearchOperator = @$filter["z_m_29"];
		$this->m_29->AdvancedSearch->SearchCondition = @$filter["v_m_29"];
		$this->m_29->AdvancedSearch->SearchValue2 = @$filter["y_m_29"];
		$this->m_29->AdvancedSearch->SearchOperator2 = @$filter["w_m_29"];
		$this->m_29->AdvancedSearch->save();

		// Field 30
		$this->_30->AdvancedSearch->SearchValue = @$filter["x__30"];
		$this->_30->AdvancedSearch->SearchOperator = @$filter["z__30"];
		$this->_30->AdvancedSearch->SearchCondition = @$filter["v__30"];
		$this->_30->AdvancedSearch->SearchValue2 = @$filter["y__30"];
		$this->_30->AdvancedSearch->SearchOperator2 = @$filter["w__30"];
		$this->_30->AdvancedSearch->save();

		// Field m_30
		$this->m_30->AdvancedSearch->SearchValue = @$filter["x_m_30"];
		$this->m_30->AdvancedSearch->SearchOperator = @$filter["z_m_30"];
		$this->m_30->AdvancedSearch->SearchCondition = @$filter["v_m_30"];
		$this->m_30->AdvancedSearch->SearchValue2 = @$filter["y_m_30"];
		$this->m_30->AdvancedSearch->SearchOperator2 = @$filter["w_m_30"];
		$this->m_30->AdvancedSearch->save();

		// Field 31
		$this->_31->AdvancedSearch->SearchValue = @$filter["x__31"];
		$this->_31->AdvancedSearch->SearchOperator = @$filter["z__31"];
		$this->_31->AdvancedSearch->SearchCondition = @$filter["v__31"];
		$this->_31->AdvancedSearch->SearchValue2 = @$filter["y__31"];
		$this->_31->AdvancedSearch->SearchOperator2 = @$filter["w__31"];
		$this->_31->AdvancedSearch->save();

		// Field m_31
		$this->m_31->AdvancedSearch->SearchValue = @$filter["x_m_31"];
		$this->m_31->AdvancedSearch->SearchOperator = @$filter["z_m_31"];
		$this->m_31->AdvancedSearch->SearchCondition = @$filter["v_m_31"];
		$this->m_31->AdvancedSearch->SearchValue2 = @$filter["y_m_31"];
		$this->m_31->AdvancedSearch->SearchOperator2 = @$filter["w_m_31"];
		$this->m_31->AdvancedSearch->save();

		// Field 32
		$this->_32->AdvancedSearch->SearchValue = @$filter["x__32"];
		$this->_32->AdvancedSearch->SearchOperator = @$filter["z__32"];
		$this->_32->AdvancedSearch->SearchCondition = @$filter["v__32"];
		$this->_32->AdvancedSearch->SearchValue2 = @$filter["y__32"];
		$this->_32->AdvancedSearch->SearchOperator2 = @$filter["w__32"];
		$this->_32->AdvancedSearch->save();

		// Field m_32
		$this->m_32->AdvancedSearch->SearchValue = @$filter["x_m_32"];
		$this->m_32->AdvancedSearch->SearchOperator = @$filter["z_m_32"];
		$this->m_32->AdvancedSearch->SearchCondition = @$filter["v_m_32"];
		$this->m_32->AdvancedSearch->SearchValue2 = @$filter["y_m_32"];
		$this->m_32->AdvancedSearch->SearchOperator2 = @$filter["w_m_32"];
		$this->m_32->AdvancedSearch->save();

		// Field 33
		$this->_33->AdvancedSearch->SearchValue = @$filter["x__33"];
		$this->_33->AdvancedSearch->SearchOperator = @$filter["z__33"];
		$this->_33->AdvancedSearch->SearchCondition = @$filter["v__33"];
		$this->_33->AdvancedSearch->SearchValue2 = @$filter["y__33"];
		$this->_33->AdvancedSearch->SearchOperator2 = @$filter["w__33"];
		$this->_33->AdvancedSearch->save();

		// Field m_33
		$this->m_33->AdvancedSearch->SearchValue = @$filter["x_m_33"];
		$this->m_33->AdvancedSearch->SearchOperator = @$filter["z_m_33"];
		$this->m_33->AdvancedSearch->SearchCondition = @$filter["v_m_33"];
		$this->m_33->AdvancedSearch->SearchValue2 = @$filter["y_m_33"];
		$this->m_33->AdvancedSearch->SearchOperator2 = @$filter["w_m_33"];
		$this->m_33->AdvancedSearch->save();

		// Field 34
		$this->_34->AdvancedSearch->SearchValue = @$filter["x__34"];
		$this->_34->AdvancedSearch->SearchOperator = @$filter["z__34"];
		$this->_34->AdvancedSearch->SearchCondition = @$filter["v__34"];
		$this->_34->AdvancedSearch->SearchValue2 = @$filter["y__34"];
		$this->_34->AdvancedSearch->SearchOperator2 = @$filter["w__34"];
		$this->_34->AdvancedSearch->save();

		// Field m_34
		$this->m_34->AdvancedSearch->SearchValue = @$filter["x_m_34"];
		$this->m_34->AdvancedSearch->SearchOperator = @$filter["z_m_34"];
		$this->m_34->AdvancedSearch->SearchCondition = @$filter["v_m_34"];
		$this->m_34->AdvancedSearch->SearchValue2 = @$filter["y_m_34"];
		$this->m_34->AdvancedSearch->SearchOperator2 = @$filter["w_m_34"];
		$this->m_34->AdvancedSearch->save();

		// Field 35
		$this->_35->AdvancedSearch->SearchValue = @$filter["x__35"];
		$this->_35->AdvancedSearch->SearchOperator = @$filter["z__35"];
		$this->_35->AdvancedSearch->SearchCondition = @$filter["v__35"];
		$this->_35->AdvancedSearch->SearchValue2 = @$filter["y__35"];
		$this->_35->AdvancedSearch->SearchOperator2 = @$filter["w__35"];
		$this->_35->AdvancedSearch->save();

		// Field m_35
		$this->m_35->AdvancedSearch->SearchValue = @$filter["x_m_35"];
		$this->m_35->AdvancedSearch->SearchOperator = @$filter["z_m_35"];
		$this->m_35->AdvancedSearch->SearchCondition = @$filter["v_m_35"];
		$this->m_35->AdvancedSearch->SearchValue2 = @$filter["y_m_35"];
		$this->m_35->AdvancedSearch->SearchOperator2 = @$filter["w_m_35"];
		$this->m_35->AdvancedSearch->save();

		// Field 36
		$this->_36->AdvancedSearch->SearchValue = @$filter["x__36"];
		$this->_36->AdvancedSearch->SearchOperator = @$filter["z__36"];
		$this->_36->AdvancedSearch->SearchCondition = @$filter["v__36"];
		$this->_36->AdvancedSearch->SearchValue2 = @$filter["y__36"];
		$this->_36->AdvancedSearch->SearchOperator2 = @$filter["w__36"];
		$this->_36->AdvancedSearch->save();

		// Field m_36
		$this->m_36->AdvancedSearch->SearchValue = @$filter["x_m_36"];
		$this->m_36->AdvancedSearch->SearchOperator = @$filter["z_m_36"];
		$this->m_36->AdvancedSearch->SearchCondition = @$filter["v_m_36"];
		$this->m_36->AdvancedSearch->SearchValue2 = @$filter["y_m_36"];
		$this->m_36->AdvancedSearch->SearchOperator2 = @$filter["w_m_36"];
		$this->m_36->AdvancedSearch->save();

		// Field 37
		$this->_37->AdvancedSearch->SearchValue = @$filter["x__37"];
		$this->_37->AdvancedSearch->SearchOperator = @$filter["z__37"];
		$this->_37->AdvancedSearch->SearchCondition = @$filter["v__37"];
		$this->_37->AdvancedSearch->SearchValue2 = @$filter["y__37"];
		$this->_37->AdvancedSearch->SearchOperator2 = @$filter["w__37"];
		$this->_37->AdvancedSearch->save();

		// Field m_37
		$this->m_37->AdvancedSearch->SearchValue = @$filter["x_m_37"];
		$this->m_37->AdvancedSearch->SearchOperator = @$filter["z_m_37"];
		$this->m_37->AdvancedSearch->SearchCondition = @$filter["v_m_37"];
		$this->m_37->AdvancedSearch->SearchValue2 = @$filter["y_m_37"];
		$this->m_37->AdvancedSearch->SearchOperator2 = @$filter["w_m_37"];
		$this->m_37->AdvancedSearch->save();

		// Field 38
		$this->_38->AdvancedSearch->SearchValue = @$filter["x__38"];
		$this->_38->AdvancedSearch->SearchOperator = @$filter["z__38"];
		$this->_38->AdvancedSearch->SearchCondition = @$filter["v__38"];
		$this->_38->AdvancedSearch->SearchValue2 = @$filter["y__38"];
		$this->_38->AdvancedSearch->SearchOperator2 = @$filter["w__38"];
		$this->_38->AdvancedSearch->save();

		// Field m_38
		$this->m_38->AdvancedSearch->SearchValue = @$filter["x_m_38"];
		$this->m_38->AdvancedSearch->SearchOperator = @$filter["z_m_38"];
		$this->m_38->AdvancedSearch->SearchCondition = @$filter["v_m_38"];
		$this->m_38->AdvancedSearch->SearchValue2 = @$filter["y_m_38"];
		$this->m_38->AdvancedSearch->SearchOperator2 = @$filter["w_m_38"];
		$this->m_38->AdvancedSearch->save();

		// Field 39
		$this->_39->AdvancedSearch->SearchValue = @$filter["x__39"];
		$this->_39->AdvancedSearch->SearchOperator = @$filter["z__39"];
		$this->_39->AdvancedSearch->SearchCondition = @$filter["v__39"];
		$this->_39->AdvancedSearch->SearchValue2 = @$filter["y__39"];
		$this->_39->AdvancedSearch->SearchOperator2 = @$filter["w__39"];
		$this->_39->AdvancedSearch->save();

		// Field m_39
		$this->m_39->AdvancedSearch->SearchValue = @$filter["x_m_39"];
		$this->m_39->AdvancedSearch->SearchOperator = @$filter["z_m_39"];
		$this->m_39->AdvancedSearch->SearchCondition = @$filter["v_m_39"];
		$this->m_39->AdvancedSearch->SearchValue2 = @$filter["y_m_39"];
		$this->m_39->AdvancedSearch->SearchOperator2 = @$filter["w_m_39"];
		$this->m_39->AdvancedSearch->save();

		// Field 40
		$this->_40->AdvancedSearch->SearchValue = @$filter["x__40"];
		$this->_40->AdvancedSearch->SearchOperator = @$filter["z__40"];
		$this->_40->AdvancedSearch->SearchCondition = @$filter["v__40"];
		$this->_40->AdvancedSearch->SearchValue2 = @$filter["y__40"];
		$this->_40->AdvancedSearch->SearchOperator2 = @$filter["w__40"];
		$this->_40->AdvancedSearch->save();

		// Field m_40
		$this->m_40->AdvancedSearch->SearchValue = @$filter["x_m_40"];
		$this->m_40->AdvancedSearch->SearchOperator = @$filter["z_m_40"];
		$this->m_40->AdvancedSearch->SearchCondition = @$filter["v_m_40"];
		$this->m_40->AdvancedSearch->SearchValue2 = @$filter["y_m_40"];
		$this->m_40->AdvancedSearch->SearchOperator2 = @$filter["w_m_40"];
		$this->m_40->AdvancedSearch->save();

		// Field 41
		$this->_41->AdvancedSearch->SearchValue = @$filter["x__41"];
		$this->_41->AdvancedSearch->SearchOperator = @$filter["z__41"];
		$this->_41->AdvancedSearch->SearchCondition = @$filter["v__41"];
		$this->_41->AdvancedSearch->SearchValue2 = @$filter["y__41"];
		$this->_41->AdvancedSearch->SearchOperator2 = @$filter["w__41"];
		$this->_41->AdvancedSearch->save();

		// Field m_41
		$this->m_41->AdvancedSearch->SearchValue = @$filter["x_m_41"];
		$this->m_41->AdvancedSearch->SearchOperator = @$filter["z_m_41"];
		$this->m_41->AdvancedSearch->SearchCondition = @$filter["v_m_41"];
		$this->m_41->AdvancedSearch->SearchValue2 = @$filter["y_m_41"];
		$this->m_41->AdvancedSearch->SearchOperator2 = @$filter["w_m_41"];
		$this->m_41->AdvancedSearch->save();

		// Field 42
		$this->_42->AdvancedSearch->SearchValue = @$filter["x__42"];
		$this->_42->AdvancedSearch->SearchOperator = @$filter["z__42"];
		$this->_42->AdvancedSearch->SearchCondition = @$filter["v__42"];
		$this->_42->AdvancedSearch->SearchValue2 = @$filter["y__42"];
		$this->_42->AdvancedSearch->SearchOperator2 = @$filter["w__42"];
		$this->_42->AdvancedSearch->save();

		// Field m_42
		$this->m_42->AdvancedSearch->SearchValue = @$filter["x_m_42"];
		$this->m_42->AdvancedSearch->SearchOperator = @$filter["z_m_42"];
		$this->m_42->AdvancedSearch->SearchCondition = @$filter["v_m_42"];
		$this->m_42->AdvancedSearch->SearchValue2 = @$filter["y_m_42"];
		$this->m_42->AdvancedSearch->SearchOperator2 = @$filter["w_m_42"];
		$this->m_42->AdvancedSearch->save();

		// Field 43
		$this->_43->AdvancedSearch->SearchValue = @$filter["x__43"];
		$this->_43->AdvancedSearch->SearchOperator = @$filter["z__43"];
		$this->_43->AdvancedSearch->SearchCondition = @$filter["v__43"];
		$this->_43->AdvancedSearch->SearchValue2 = @$filter["y__43"];
		$this->_43->AdvancedSearch->SearchOperator2 = @$filter["w__43"];
		$this->_43->AdvancedSearch->save();

		// Field m_43
		$this->m_43->AdvancedSearch->SearchValue = @$filter["x_m_43"];
		$this->m_43->AdvancedSearch->SearchOperator = @$filter["z_m_43"];
		$this->m_43->AdvancedSearch->SearchCondition = @$filter["v_m_43"];
		$this->m_43->AdvancedSearch->SearchValue2 = @$filter["y_m_43"];
		$this->m_43->AdvancedSearch->SearchOperator2 = @$filter["w_m_43"];
		$this->m_43->AdvancedSearch->save();

		// Field 44
		$this->_44->AdvancedSearch->SearchValue = @$filter["x__44"];
		$this->_44->AdvancedSearch->SearchOperator = @$filter["z__44"];
		$this->_44->AdvancedSearch->SearchCondition = @$filter["v__44"];
		$this->_44->AdvancedSearch->SearchValue2 = @$filter["y__44"];
		$this->_44->AdvancedSearch->SearchOperator2 = @$filter["w__44"];
		$this->_44->AdvancedSearch->save();

		// Field m_44
		$this->m_44->AdvancedSearch->SearchValue = @$filter["x_m_44"];
		$this->m_44->AdvancedSearch->SearchOperator = @$filter["z_m_44"];
		$this->m_44->AdvancedSearch->SearchCondition = @$filter["v_m_44"];
		$this->m_44->AdvancedSearch->SearchValue2 = @$filter["y_m_44"];
		$this->m_44->AdvancedSearch->SearchOperator2 = @$filter["w_m_44"];
		$this->m_44->AdvancedSearch->save();

		// Field 45
		$this->_45->AdvancedSearch->SearchValue = @$filter["x__45"];
		$this->_45->AdvancedSearch->SearchOperator = @$filter["z__45"];
		$this->_45->AdvancedSearch->SearchCondition = @$filter["v__45"];
		$this->_45->AdvancedSearch->SearchValue2 = @$filter["y__45"];
		$this->_45->AdvancedSearch->SearchOperator2 = @$filter["w__45"];
		$this->_45->AdvancedSearch->save();

		// Field m_45
		$this->m_45->AdvancedSearch->SearchValue = @$filter["x_m_45"];
		$this->m_45->AdvancedSearch->SearchOperator = @$filter["z_m_45"];
		$this->m_45->AdvancedSearch->SearchCondition = @$filter["v_m_45"];
		$this->m_45->AdvancedSearch->SearchValue2 = @$filter["y_m_45"];
		$this->m_45->AdvancedSearch->SearchOperator2 = @$filter["w_m_45"];
		$this->m_45->AdvancedSearch->save();

		// Field 46
		$this->_46->AdvancedSearch->SearchValue = @$filter["x__46"];
		$this->_46->AdvancedSearch->SearchOperator = @$filter["z__46"];
		$this->_46->AdvancedSearch->SearchCondition = @$filter["v__46"];
		$this->_46->AdvancedSearch->SearchValue2 = @$filter["y__46"];
		$this->_46->AdvancedSearch->SearchOperator2 = @$filter["w__46"];
		$this->_46->AdvancedSearch->save();

		// Field m_46
		$this->m_46->AdvancedSearch->SearchValue = @$filter["x_m_46"];
		$this->m_46->AdvancedSearch->SearchOperator = @$filter["z_m_46"];
		$this->m_46->AdvancedSearch->SearchCondition = @$filter["v_m_46"];
		$this->m_46->AdvancedSearch->SearchValue2 = @$filter["y_m_46"];
		$this->m_46->AdvancedSearch->SearchOperator2 = @$filter["w_m_46"];
		$this->m_46->AdvancedSearch->save();

		// Field 47
		$this->_47->AdvancedSearch->SearchValue = @$filter["x__47"];
		$this->_47->AdvancedSearch->SearchOperator = @$filter["z__47"];
		$this->_47->AdvancedSearch->SearchCondition = @$filter["v__47"];
		$this->_47->AdvancedSearch->SearchValue2 = @$filter["y__47"];
		$this->_47->AdvancedSearch->SearchOperator2 = @$filter["w__47"];
		$this->_47->AdvancedSearch->save();

		// Field m_47
		$this->m_47->AdvancedSearch->SearchValue = @$filter["x_m_47"];
		$this->m_47->AdvancedSearch->SearchOperator = @$filter["z_m_47"];
		$this->m_47->AdvancedSearch->SearchCondition = @$filter["v_m_47"];
		$this->m_47->AdvancedSearch->SearchValue2 = @$filter["y_m_47"];
		$this->m_47->AdvancedSearch->SearchOperator2 = @$filter["w_m_47"];
		$this->m_47->AdvancedSearch->save();

		// Field 48
		$this->_48->AdvancedSearch->SearchValue = @$filter["x__48"];
		$this->_48->AdvancedSearch->SearchOperator = @$filter["z__48"];
		$this->_48->AdvancedSearch->SearchCondition = @$filter["v__48"];
		$this->_48->AdvancedSearch->SearchValue2 = @$filter["y__48"];
		$this->_48->AdvancedSearch->SearchOperator2 = @$filter["w__48"];
		$this->_48->AdvancedSearch->save();

		// Field m_48
		$this->m_48->AdvancedSearch->SearchValue = @$filter["x_m_48"];
		$this->m_48->AdvancedSearch->SearchOperator = @$filter["z_m_48"];
		$this->m_48->AdvancedSearch->SearchCondition = @$filter["v_m_48"];
		$this->m_48->AdvancedSearch->SearchValue2 = @$filter["y_m_48"];
		$this->m_48->AdvancedSearch->SearchOperator2 = @$filter["w_m_48"];
		$this->m_48->AdvancedSearch->save();

		// Field 49
		$this->_49->AdvancedSearch->SearchValue = @$filter["x__49"];
		$this->_49->AdvancedSearch->SearchOperator = @$filter["z__49"];
		$this->_49->AdvancedSearch->SearchCondition = @$filter["v__49"];
		$this->_49->AdvancedSearch->SearchValue2 = @$filter["y__49"];
		$this->_49->AdvancedSearch->SearchOperator2 = @$filter["w__49"];
		$this->_49->AdvancedSearch->save();

		// Field m_49
		$this->m_49->AdvancedSearch->SearchValue = @$filter["x_m_49"];
		$this->m_49->AdvancedSearch->SearchOperator = @$filter["z_m_49"];
		$this->m_49->AdvancedSearch->SearchCondition = @$filter["v_m_49"];
		$this->m_49->AdvancedSearch->SearchValue2 = @$filter["y_m_49"];
		$this->m_49->AdvancedSearch->SearchOperator2 = @$filter["w_m_49"];
		$this->m_49->AdvancedSearch->save();

		// Field 50
		$this->_50->AdvancedSearch->SearchValue = @$filter["x__50"];
		$this->_50->AdvancedSearch->SearchOperator = @$filter["z__50"];
		$this->_50->AdvancedSearch->SearchCondition = @$filter["v__50"];
		$this->_50->AdvancedSearch->SearchValue2 = @$filter["y__50"];
		$this->_50->AdvancedSearch->SearchOperator2 = @$filter["w__50"];
		$this->_50->AdvancedSearch->save();

		// Field m_50
		$this->m_50->AdvancedSearch->SearchValue = @$filter["x_m_50"];
		$this->m_50->AdvancedSearch->SearchOperator = @$filter["z_m_50"];
		$this->m_50->AdvancedSearch->SearchCondition = @$filter["v_m_50"];
		$this->m_50->AdvancedSearch->SearchValue2 = @$filter["y_m_50"];
		$this->m_50->AdvancedSearch->SearchOperator2 = @$filter["w_m_50"];
		$this->m_50->AdvancedSearch->save();

		// Field 51
		$this->_51->AdvancedSearch->SearchValue = @$filter["x__51"];
		$this->_51->AdvancedSearch->SearchOperator = @$filter["z__51"];
		$this->_51->AdvancedSearch->SearchCondition = @$filter["v__51"];
		$this->_51->AdvancedSearch->SearchValue2 = @$filter["y__51"];
		$this->_51->AdvancedSearch->SearchOperator2 = @$filter["w__51"];
		$this->_51->AdvancedSearch->save();

		// Field m_51
		$this->m_51->AdvancedSearch->SearchValue = @$filter["x_m_51"];
		$this->m_51->AdvancedSearch->SearchOperator = @$filter["z_m_51"];
		$this->m_51->AdvancedSearch->SearchCondition = @$filter["v_m_51"];
		$this->m_51->AdvancedSearch->SearchValue2 = @$filter["y_m_51"];
		$this->m_51->AdvancedSearch->SearchOperator2 = @$filter["w_m_51"];
		$this->m_51->AdvancedSearch->save();

		// Field 52
		$this->_52->AdvancedSearch->SearchValue = @$filter["x__52"];
		$this->_52->AdvancedSearch->SearchOperator = @$filter["z__52"];
		$this->_52->AdvancedSearch->SearchCondition = @$filter["v__52"];
		$this->_52->AdvancedSearch->SearchValue2 = @$filter["y__52"];
		$this->_52->AdvancedSearch->SearchOperator2 = @$filter["w__52"];
		$this->_52->AdvancedSearch->save();

		// Field m_52
		$this->m_52->AdvancedSearch->SearchValue = @$filter["x_m_52"];
		$this->m_52->AdvancedSearch->SearchOperator = @$filter["z_m_52"];
		$this->m_52->AdvancedSearch->SearchCondition = @$filter["v_m_52"];
		$this->m_52->AdvancedSearch->SearchValue2 = @$filter["y_m_52"];
		$this->m_52->AdvancedSearch->SearchOperator2 = @$filter["w_m_52"];
		$this->m_52->AdvancedSearch->save();

		// Field 53
		$this->_53->AdvancedSearch->SearchValue = @$filter["x__53"];
		$this->_53->AdvancedSearch->SearchOperator = @$filter["z__53"];
		$this->_53->AdvancedSearch->SearchCondition = @$filter["v__53"];
		$this->_53->AdvancedSearch->SearchValue2 = @$filter["y__53"];
		$this->_53->AdvancedSearch->SearchOperator2 = @$filter["w__53"];
		$this->_53->AdvancedSearch->save();

		// Field m_53
		$this->m_53->AdvancedSearch->SearchValue = @$filter["x_m_53"];
		$this->m_53->AdvancedSearch->SearchOperator = @$filter["z_m_53"];
		$this->m_53->AdvancedSearch->SearchCondition = @$filter["v_m_53"];
		$this->m_53->AdvancedSearch->SearchValue2 = @$filter["y_m_53"];
		$this->m_53->AdvancedSearch->SearchOperator2 = @$filter["w_m_53"];
		$this->m_53->AdvancedSearch->save();

		// Field 54
		$this->_54->AdvancedSearch->SearchValue = @$filter["x__54"];
		$this->_54->AdvancedSearch->SearchOperator = @$filter["z__54"];
		$this->_54->AdvancedSearch->SearchCondition = @$filter["v__54"];
		$this->_54->AdvancedSearch->SearchValue2 = @$filter["y__54"];
		$this->_54->AdvancedSearch->SearchOperator2 = @$filter["w__54"];
		$this->_54->AdvancedSearch->save();

		// Field m_54
		$this->m_54->AdvancedSearch->SearchValue = @$filter["x_m_54"];
		$this->m_54->AdvancedSearch->SearchOperator = @$filter["z_m_54"];
		$this->m_54->AdvancedSearch->SearchCondition = @$filter["v_m_54"];
		$this->m_54->AdvancedSearch->SearchValue2 = @$filter["y_m_54"];
		$this->m_54->AdvancedSearch->SearchOperator2 = @$filter["w_m_54"];
		$this->m_54->AdvancedSearch->save();

		// Field 55
		$this->_55->AdvancedSearch->SearchValue = @$filter["x__55"];
		$this->_55->AdvancedSearch->SearchOperator = @$filter["z__55"];
		$this->_55->AdvancedSearch->SearchCondition = @$filter["v__55"];
		$this->_55->AdvancedSearch->SearchValue2 = @$filter["y__55"];
		$this->_55->AdvancedSearch->SearchOperator2 = @$filter["w__55"];
		$this->_55->AdvancedSearch->save();

		// Field m_55
		$this->m_55->AdvancedSearch->SearchValue = @$filter["x_m_55"];
		$this->m_55->AdvancedSearch->SearchOperator = @$filter["z_m_55"];
		$this->m_55->AdvancedSearch->SearchCondition = @$filter["v_m_55"];
		$this->m_55->AdvancedSearch->SearchValue2 = @$filter["y_m_55"];
		$this->m_55->AdvancedSearch->SearchOperator2 = @$filter["w_m_55"];
		$this->m_55->AdvancedSearch->save();

		// Field 56
		$this->_56->AdvancedSearch->SearchValue = @$filter["x__56"];
		$this->_56->AdvancedSearch->SearchOperator = @$filter["z__56"];
		$this->_56->AdvancedSearch->SearchCondition = @$filter["v__56"];
		$this->_56->AdvancedSearch->SearchValue2 = @$filter["y__56"];
		$this->_56->AdvancedSearch->SearchOperator2 = @$filter["w__56"];
		$this->_56->AdvancedSearch->save();

		// Field m_56
		$this->m_56->AdvancedSearch->SearchValue = @$filter["x_m_56"];
		$this->m_56->AdvancedSearch->SearchOperator = @$filter["z_m_56"];
		$this->m_56->AdvancedSearch->SearchCondition = @$filter["v_m_56"];
		$this->m_56->AdvancedSearch->SearchValue2 = @$filter["y_m_56"];
		$this->m_56->AdvancedSearch->SearchOperator2 = @$filter["w_m_56"];
		$this->m_56->AdvancedSearch->save();

		// Field 57
		$this->_57->AdvancedSearch->SearchValue = @$filter["x__57"];
		$this->_57->AdvancedSearch->SearchOperator = @$filter["z__57"];
		$this->_57->AdvancedSearch->SearchCondition = @$filter["v__57"];
		$this->_57->AdvancedSearch->SearchValue2 = @$filter["y__57"];
		$this->_57->AdvancedSearch->SearchOperator2 = @$filter["w__57"];
		$this->_57->AdvancedSearch->save();

		// Field m_57
		$this->m_57->AdvancedSearch->SearchValue = @$filter["x_m_57"];
		$this->m_57->AdvancedSearch->SearchOperator = @$filter["z_m_57"];
		$this->m_57->AdvancedSearch->SearchCondition = @$filter["v_m_57"];
		$this->m_57->AdvancedSearch->SearchValue2 = @$filter["y_m_57"];
		$this->m_57->AdvancedSearch->SearchOperator2 = @$filter["w_m_57"];
		$this->m_57->AdvancedSearch->save();

		// Field 58
		$this->_58->AdvancedSearch->SearchValue = @$filter["x__58"];
		$this->_58->AdvancedSearch->SearchOperator = @$filter["z__58"];
		$this->_58->AdvancedSearch->SearchCondition = @$filter["v__58"];
		$this->_58->AdvancedSearch->SearchValue2 = @$filter["y__58"];
		$this->_58->AdvancedSearch->SearchOperator2 = @$filter["w__58"];
		$this->_58->AdvancedSearch->save();

		// Field m_58
		$this->m_58->AdvancedSearch->SearchValue = @$filter["x_m_58"];
		$this->m_58->AdvancedSearch->SearchOperator = @$filter["z_m_58"];
		$this->m_58->AdvancedSearch->SearchCondition = @$filter["v_m_58"];
		$this->m_58->AdvancedSearch->SearchValue2 = @$filter["y_m_58"];
		$this->m_58->AdvancedSearch->SearchOperator2 = @$filter["w_m_58"];
		$this->m_58->AdvancedSearch->save();

		// Field 59
		$this->_59->AdvancedSearch->SearchValue = @$filter["x__59"];
		$this->_59->AdvancedSearch->SearchOperator = @$filter["z__59"];
		$this->_59->AdvancedSearch->SearchCondition = @$filter["v__59"];
		$this->_59->AdvancedSearch->SearchValue2 = @$filter["y__59"];
		$this->_59->AdvancedSearch->SearchOperator2 = @$filter["w__59"];
		$this->_59->AdvancedSearch->save();

		// Field m_59
		$this->m_59->AdvancedSearch->SearchValue = @$filter["x_m_59"];
		$this->m_59->AdvancedSearch->SearchOperator = @$filter["z_m_59"];
		$this->m_59->AdvancedSearch->SearchCondition = @$filter["v_m_59"];
		$this->m_59->AdvancedSearch->SearchValue2 = @$filter["y_m_59"];
		$this->m_59->AdvancedSearch->SearchOperator2 = @$filter["w_m_59"];
		$this->m_59->AdvancedSearch->save();

		// Field 60
		$this->_60->AdvancedSearch->SearchValue = @$filter["x__60"];
		$this->_60->AdvancedSearch->SearchOperator = @$filter["z__60"];
		$this->_60->AdvancedSearch->SearchCondition = @$filter["v__60"];
		$this->_60->AdvancedSearch->SearchValue2 = @$filter["y__60"];
		$this->_60->AdvancedSearch->SearchOperator2 = @$filter["w__60"];
		$this->_60->AdvancedSearch->save();

		// Field m_60
		$this->m_60->AdvancedSearch->SearchValue = @$filter["x_m_60"];
		$this->m_60->AdvancedSearch->SearchOperator = @$filter["z_m_60"];
		$this->m_60->AdvancedSearch->SearchCondition = @$filter["v_m_60"];
		$this->m_60->AdvancedSearch->SearchValue2 = @$filter["y_m_60"];
		$this->m_60->AdvancedSearch->SearchOperator2 = @$filter["w_m_60"];
		$this->m_60->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->roll_no, $default, FALSE); // roll_no
		$this->buildSearchSql($where, $this->test_id, $default, FALSE); // test_id
		$this->buildSearchSql($where, $this->total, $default, FALSE); // total
		$this->buildSearchSql($where, $this->percent, $default, FALSE); // percent
		$this->buildSearchSql($where, $this->s_1, $default, FALSE); // s_1
		$this->buildSearchSql($where, $this->s_2, $default, FALSE); // s_2
		$this->buildSearchSql($where, $this->s_3, $default, FALSE); // s_3
		$this->buildSearchSql($where, $this->s_4, $default, FALSE); // s_4
		$this->buildSearchSql($where, $this->s_5, $default, FALSE); // s_5
		$this->buildSearchSql($where, $this->omr_image, $default, FALSE); // omr_image
		$this->buildSearchSql($where, $this->_1, $default, FALSE); // 1
		$this->buildSearchSql($where, $this->m_1, $default, FALSE); // m_1
		$this->buildSearchSql($where, $this->_2, $default, FALSE); // 2
		$this->buildSearchSql($where, $this->m_2, $default, FALSE); // m_2
		$this->buildSearchSql($where, $this->_3, $default, FALSE); // 3
		$this->buildSearchSql($where, $this->m_3, $default, FALSE); // m_3
		$this->buildSearchSql($where, $this->_4, $default, FALSE); // 4
		$this->buildSearchSql($where, $this->m_4, $default, FALSE); // m_4
		$this->buildSearchSql($where, $this->_5, $default, FALSE); // 5
		$this->buildSearchSql($where, $this->m_5, $default, FALSE); // m_5
		$this->buildSearchSql($where, $this->_6, $default, FALSE); // 6
		$this->buildSearchSql($where, $this->m_6, $default, FALSE); // m_6
		$this->buildSearchSql($where, $this->_7, $default, FALSE); // 7
		$this->buildSearchSql($where, $this->m_7, $default, FALSE); // m_7
		$this->buildSearchSql($where, $this->_8, $default, FALSE); // 8
		$this->buildSearchSql($where, $this->m_8, $default, FALSE); // m_8
		$this->buildSearchSql($where, $this->_9, $default, FALSE); // 9
		$this->buildSearchSql($where, $this->m_9, $default, FALSE); // m_9
		$this->buildSearchSql($where, $this->_10, $default, FALSE); // 10
		$this->buildSearchSql($where, $this->m_10, $default, FALSE); // m_10
		$this->buildSearchSql($where, $this->_11, $default, FALSE); // 11
		$this->buildSearchSql($where, $this->m_11, $default, FALSE); // m_11
		$this->buildSearchSql($where, $this->_12, $default, FALSE); // 12
		$this->buildSearchSql($where, $this->m_12, $default, FALSE); // m_12
		$this->buildSearchSql($where, $this->_13, $default, FALSE); // 13
		$this->buildSearchSql($where, $this->m_13, $default, FALSE); // m_13
		$this->buildSearchSql($where, $this->_14, $default, FALSE); // 14
		$this->buildSearchSql($where, $this->m_14, $default, FALSE); // m_14
		$this->buildSearchSql($where, $this->_15, $default, FALSE); // 15
		$this->buildSearchSql($where, $this->m_15, $default, FALSE); // m_15
		$this->buildSearchSql($where, $this->_16, $default, FALSE); // 16
		$this->buildSearchSql($where, $this->m_16, $default, FALSE); // m_16
		$this->buildSearchSql($where, $this->_17, $default, FALSE); // 17
		$this->buildSearchSql($where, $this->m_17, $default, FALSE); // m_17
		$this->buildSearchSql($where, $this->_18, $default, FALSE); // 18
		$this->buildSearchSql($where, $this->m_18, $default, FALSE); // m_18
		$this->buildSearchSql($where, $this->_19, $default, FALSE); // 19
		$this->buildSearchSql($where, $this->m_19, $default, FALSE); // m_19
		$this->buildSearchSql($where, $this->_20, $default, FALSE); // 20
		$this->buildSearchSql($where, $this->m_20, $default, FALSE); // m_20
		$this->buildSearchSql($where, $this->_21, $default, FALSE); // 21
		$this->buildSearchSql($where, $this->m_21, $default, FALSE); // m_21
		$this->buildSearchSql($where, $this->_22, $default, FALSE); // 22
		$this->buildSearchSql($where, $this->m_22, $default, FALSE); // m_22
		$this->buildSearchSql($where, $this->_23, $default, FALSE); // 23
		$this->buildSearchSql($where, $this->m_23, $default, FALSE); // m_23
		$this->buildSearchSql($where, $this->_24, $default, FALSE); // 24
		$this->buildSearchSql($where, $this->m_24, $default, FALSE); // m_24
		$this->buildSearchSql($where, $this->_25, $default, FALSE); // 25
		$this->buildSearchSql($where, $this->m_25, $default, FALSE); // m_25
		$this->buildSearchSql($where, $this->_26, $default, FALSE); // 26
		$this->buildSearchSql($where, $this->m_26, $default, FALSE); // m_26
		$this->buildSearchSql($where, $this->_27, $default, FALSE); // 27
		$this->buildSearchSql($where, $this->m_27, $default, FALSE); // m_27
		$this->buildSearchSql($where, $this->_28, $default, FALSE); // 28
		$this->buildSearchSql($where, $this->m_28, $default, FALSE); // m_28
		$this->buildSearchSql($where, $this->_29, $default, FALSE); // 29
		$this->buildSearchSql($where, $this->m_29, $default, FALSE); // m_29
		$this->buildSearchSql($where, $this->_30, $default, FALSE); // 30
		$this->buildSearchSql($where, $this->m_30, $default, FALSE); // m_30
		$this->buildSearchSql($where, $this->_31, $default, FALSE); // 31
		$this->buildSearchSql($where, $this->m_31, $default, FALSE); // m_31
		$this->buildSearchSql($where, $this->_32, $default, FALSE); // 32
		$this->buildSearchSql($where, $this->m_32, $default, FALSE); // m_32
		$this->buildSearchSql($where, $this->_33, $default, FALSE); // 33
		$this->buildSearchSql($where, $this->m_33, $default, FALSE); // m_33
		$this->buildSearchSql($where, $this->_34, $default, FALSE); // 34
		$this->buildSearchSql($where, $this->m_34, $default, FALSE); // m_34
		$this->buildSearchSql($where, $this->_35, $default, FALSE); // 35
		$this->buildSearchSql($where, $this->m_35, $default, FALSE); // m_35
		$this->buildSearchSql($where, $this->_36, $default, FALSE); // 36
		$this->buildSearchSql($where, $this->m_36, $default, FALSE); // m_36
		$this->buildSearchSql($where, $this->_37, $default, FALSE); // 37
		$this->buildSearchSql($where, $this->m_37, $default, FALSE); // m_37
		$this->buildSearchSql($where, $this->_38, $default, FALSE); // 38
		$this->buildSearchSql($where, $this->m_38, $default, FALSE); // m_38
		$this->buildSearchSql($where, $this->_39, $default, FALSE); // 39
		$this->buildSearchSql($where, $this->m_39, $default, FALSE); // m_39
		$this->buildSearchSql($where, $this->_40, $default, FALSE); // 40
		$this->buildSearchSql($where, $this->m_40, $default, FALSE); // m_40
		$this->buildSearchSql($where, $this->_41, $default, FALSE); // 41
		$this->buildSearchSql($where, $this->m_41, $default, FALSE); // m_41
		$this->buildSearchSql($where, $this->_42, $default, FALSE); // 42
		$this->buildSearchSql($where, $this->m_42, $default, FALSE); // m_42
		$this->buildSearchSql($where, $this->_43, $default, FALSE); // 43
		$this->buildSearchSql($where, $this->m_43, $default, FALSE); // m_43
		$this->buildSearchSql($where, $this->_44, $default, FALSE); // 44
		$this->buildSearchSql($where, $this->m_44, $default, FALSE); // m_44
		$this->buildSearchSql($where, $this->_45, $default, FALSE); // 45
		$this->buildSearchSql($where, $this->m_45, $default, FALSE); // m_45
		$this->buildSearchSql($where, $this->_46, $default, FALSE); // 46
		$this->buildSearchSql($where, $this->m_46, $default, FALSE); // m_46
		$this->buildSearchSql($where, $this->_47, $default, FALSE); // 47
		$this->buildSearchSql($where, $this->m_47, $default, FALSE); // m_47
		$this->buildSearchSql($where, $this->_48, $default, FALSE); // 48
		$this->buildSearchSql($where, $this->m_48, $default, FALSE); // m_48
		$this->buildSearchSql($where, $this->_49, $default, FALSE); // 49
		$this->buildSearchSql($where, $this->m_49, $default, FALSE); // m_49
		$this->buildSearchSql($where, $this->_50, $default, FALSE); // 50
		$this->buildSearchSql($where, $this->m_50, $default, FALSE); // m_50
		$this->buildSearchSql($where, $this->_51, $default, FALSE); // 51
		$this->buildSearchSql($where, $this->m_51, $default, FALSE); // m_51
		$this->buildSearchSql($where, $this->_52, $default, FALSE); // 52
		$this->buildSearchSql($where, $this->m_52, $default, FALSE); // m_52
		$this->buildSearchSql($where, $this->_53, $default, FALSE); // 53
		$this->buildSearchSql($where, $this->m_53, $default, FALSE); // m_53
		$this->buildSearchSql($where, $this->_54, $default, FALSE); // 54
		$this->buildSearchSql($where, $this->m_54, $default, FALSE); // m_54
		$this->buildSearchSql($where, $this->_55, $default, FALSE); // 55
		$this->buildSearchSql($where, $this->m_55, $default, FALSE); // m_55
		$this->buildSearchSql($where, $this->_56, $default, FALSE); // 56
		$this->buildSearchSql($where, $this->m_56, $default, FALSE); // m_56
		$this->buildSearchSql($where, $this->_57, $default, FALSE); // 57
		$this->buildSearchSql($where, $this->m_57, $default, FALSE); // m_57
		$this->buildSearchSql($where, $this->_58, $default, FALSE); // 58
		$this->buildSearchSql($where, $this->m_58, $default, FALSE); // m_58
		$this->buildSearchSql($where, $this->_59, $default, FALSE); // 59
		$this->buildSearchSql($where, $this->m_59, $default, FALSE); // m_59
		$this->buildSearchSql($where, $this->_60, $default, FALSE); // 60
		$this->buildSearchSql($where, $this->m_60, $default, FALSE); // m_60

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->roll_no->AdvancedSearch->save(); // roll_no
			$this->test_id->AdvancedSearch->save(); // test_id
			$this->total->AdvancedSearch->save(); // total
			$this->percent->AdvancedSearch->save(); // percent
			$this->s_1->AdvancedSearch->save(); // s_1
			$this->s_2->AdvancedSearch->save(); // s_2
			$this->s_3->AdvancedSearch->save(); // s_3
			$this->s_4->AdvancedSearch->save(); // s_4
			$this->s_5->AdvancedSearch->save(); // s_5
			$this->omr_image->AdvancedSearch->save(); // omr_image
			$this->_1->AdvancedSearch->save(); // 1
			$this->m_1->AdvancedSearch->save(); // m_1
			$this->_2->AdvancedSearch->save(); // 2
			$this->m_2->AdvancedSearch->save(); // m_2
			$this->_3->AdvancedSearch->save(); // 3
			$this->m_3->AdvancedSearch->save(); // m_3
			$this->_4->AdvancedSearch->save(); // 4
			$this->m_4->AdvancedSearch->save(); // m_4
			$this->_5->AdvancedSearch->save(); // 5
			$this->m_5->AdvancedSearch->save(); // m_5
			$this->_6->AdvancedSearch->save(); // 6
			$this->m_6->AdvancedSearch->save(); // m_6
			$this->_7->AdvancedSearch->save(); // 7
			$this->m_7->AdvancedSearch->save(); // m_7
			$this->_8->AdvancedSearch->save(); // 8
			$this->m_8->AdvancedSearch->save(); // m_8
			$this->_9->AdvancedSearch->save(); // 9
			$this->m_9->AdvancedSearch->save(); // m_9
			$this->_10->AdvancedSearch->save(); // 10
			$this->m_10->AdvancedSearch->save(); // m_10
			$this->_11->AdvancedSearch->save(); // 11
			$this->m_11->AdvancedSearch->save(); // m_11
			$this->_12->AdvancedSearch->save(); // 12
			$this->m_12->AdvancedSearch->save(); // m_12
			$this->_13->AdvancedSearch->save(); // 13
			$this->m_13->AdvancedSearch->save(); // m_13
			$this->_14->AdvancedSearch->save(); // 14
			$this->m_14->AdvancedSearch->save(); // m_14
			$this->_15->AdvancedSearch->save(); // 15
			$this->m_15->AdvancedSearch->save(); // m_15
			$this->_16->AdvancedSearch->save(); // 16
			$this->m_16->AdvancedSearch->save(); // m_16
			$this->_17->AdvancedSearch->save(); // 17
			$this->m_17->AdvancedSearch->save(); // m_17
			$this->_18->AdvancedSearch->save(); // 18
			$this->m_18->AdvancedSearch->save(); // m_18
			$this->_19->AdvancedSearch->save(); // 19
			$this->m_19->AdvancedSearch->save(); // m_19
			$this->_20->AdvancedSearch->save(); // 20
			$this->m_20->AdvancedSearch->save(); // m_20
			$this->_21->AdvancedSearch->save(); // 21
			$this->m_21->AdvancedSearch->save(); // m_21
			$this->_22->AdvancedSearch->save(); // 22
			$this->m_22->AdvancedSearch->save(); // m_22
			$this->_23->AdvancedSearch->save(); // 23
			$this->m_23->AdvancedSearch->save(); // m_23
			$this->_24->AdvancedSearch->save(); // 24
			$this->m_24->AdvancedSearch->save(); // m_24
			$this->_25->AdvancedSearch->save(); // 25
			$this->m_25->AdvancedSearch->save(); // m_25
			$this->_26->AdvancedSearch->save(); // 26
			$this->m_26->AdvancedSearch->save(); // m_26
			$this->_27->AdvancedSearch->save(); // 27
			$this->m_27->AdvancedSearch->save(); // m_27
			$this->_28->AdvancedSearch->save(); // 28
			$this->m_28->AdvancedSearch->save(); // m_28
			$this->_29->AdvancedSearch->save(); // 29
			$this->m_29->AdvancedSearch->save(); // m_29
			$this->_30->AdvancedSearch->save(); // 30
			$this->m_30->AdvancedSearch->save(); // m_30
			$this->_31->AdvancedSearch->save(); // 31
			$this->m_31->AdvancedSearch->save(); // m_31
			$this->_32->AdvancedSearch->save(); // 32
			$this->m_32->AdvancedSearch->save(); // m_32
			$this->_33->AdvancedSearch->save(); // 33
			$this->m_33->AdvancedSearch->save(); // m_33
			$this->_34->AdvancedSearch->save(); // 34
			$this->m_34->AdvancedSearch->save(); // m_34
			$this->_35->AdvancedSearch->save(); // 35
			$this->m_35->AdvancedSearch->save(); // m_35
			$this->_36->AdvancedSearch->save(); // 36
			$this->m_36->AdvancedSearch->save(); // m_36
			$this->_37->AdvancedSearch->save(); // 37
			$this->m_37->AdvancedSearch->save(); // m_37
			$this->_38->AdvancedSearch->save(); // 38
			$this->m_38->AdvancedSearch->save(); // m_38
			$this->_39->AdvancedSearch->save(); // 39
			$this->m_39->AdvancedSearch->save(); // m_39
			$this->_40->AdvancedSearch->save(); // 40
			$this->m_40->AdvancedSearch->save(); // m_40
			$this->_41->AdvancedSearch->save(); // 41
			$this->m_41->AdvancedSearch->save(); // m_41
			$this->_42->AdvancedSearch->save(); // 42
			$this->m_42->AdvancedSearch->save(); // m_42
			$this->_43->AdvancedSearch->save(); // 43
			$this->m_43->AdvancedSearch->save(); // m_43
			$this->_44->AdvancedSearch->save(); // 44
			$this->m_44->AdvancedSearch->save(); // m_44
			$this->_45->AdvancedSearch->save(); // 45
			$this->m_45->AdvancedSearch->save(); // m_45
			$this->_46->AdvancedSearch->save(); // 46
			$this->m_46->AdvancedSearch->save(); // m_46
			$this->_47->AdvancedSearch->save(); // 47
			$this->m_47->AdvancedSearch->save(); // m_47
			$this->_48->AdvancedSearch->save(); // 48
			$this->m_48->AdvancedSearch->save(); // m_48
			$this->_49->AdvancedSearch->save(); // 49
			$this->m_49->AdvancedSearch->save(); // m_49
			$this->_50->AdvancedSearch->save(); // 50
			$this->m_50->AdvancedSearch->save(); // m_50
			$this->_51->AdvancedSearch->save(); // 51
			$this->m_51->AdvancedSearch->save(); // m_51
			$this->_52->AdvancedSearch->save(); // 52
			$this->m_52->AdvancedSearch->save(); // m_52
			$this->_53->AdvancedSearch->save(); // 53
			$this->m_53->AdvancedSearch->save(); // m_53
			$this->_54->AdvancedSearch->save(); // 54
			$this->m_54->AdvancedSearch->save(); // m_54
			$this->_55->AdvancedSearch->save(); // 55
			$this->m_55->AdvancedSearch->save(); // m_55
			$this->_56->AdvancedSearch->save(); // 56
			$this->m_56->AdvancedSearch->save(); // m_56
			$this->_57->AdvancedSearch->save(); // 57
			$this->m_57->AdvancedSearch->save(); // m_57
			$this->_58->AdvancedSearch->save(); // 58
			$this->m_58->AdvancedSearch->save(); // m_58
			$this->_59->AdvancedSearch->save(); // 59
			$this->m_59->AdvancedSearch->save(); // m_59
			$this->_60->AdvancedSearch->save(); // 60
			$this->m_60->AdvancedSearch->save(); // m_60
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->roll_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->test_id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->total, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->percent, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_1, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_2, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_3, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_4, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->s_5, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->omr_image, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_1, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->m_1, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_2, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->m_2, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_3, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_4, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_5, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_6, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_7, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_8, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_9, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_10, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_11, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_12, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_13, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_14, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_15, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_16, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_17, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_18, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_19, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_20, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_21, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_22, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_23, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_24, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_25, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_26, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_27, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_28, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_29, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_30, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_31, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_32, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_33, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_34, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_35, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_36, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_37, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_38, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_39, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_40, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_41, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_42, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_43, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_44, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_45, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_46, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_47, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_48, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_49, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_50, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_51, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_52, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_53, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_54, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_55, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_56, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_57, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_58, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_59, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->_60, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->roll_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->test_id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->total->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->percent->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->s_1->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->s_2->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->s_3->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->s_4->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->s_5->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->omr_image->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_1->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_1->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_2->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_2->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_3->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_3->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_4->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_4->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_5->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_5->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_6->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_6->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_7->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_7->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_8->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_8->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_9->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_9->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_10->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_10->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_11->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_11->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_12->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_12->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_13->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_13->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_14->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_14->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_15->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_15->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_16->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_16->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_17->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_17->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_18->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_18->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_19->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_19->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_20->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_20->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_21->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_21->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_22->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_22->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_23->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_23->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_24->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_24->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_25->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_25->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_26->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_26->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_27->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_27->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_28->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_28->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_29->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_29->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_30->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_30->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_31->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_31->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_32->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_32->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_33->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_33->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_34->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_34->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_35->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_35->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_36->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_36->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_37->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_37->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_38->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_38->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_39->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_39->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_40->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_40->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_41->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_41->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_42->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_42->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_43->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_43->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_44->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_44->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_45->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_45->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_46->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_46->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_47->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_47->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_48->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_48->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_49->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_49->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_50->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_50->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_51->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_51->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_52->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_52->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_53->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_53->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_54->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_54->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_55->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_55->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_56->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_56->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_57->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_57->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_58->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_58->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_59->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_59->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_60->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_60->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->roll_no->AdvancedSearch->unsetSession();
		$this->test_id->AdvancedSearch->unsetSession();
		$this->total->AdvancedSearch->unsetSession();
		$this->percent->AdvancedSearch->unsetSession();
		$this->s_1->AdvancedSearch->unsetSession();
		$this->s_2->AdvancedSearch->unsetSession();
		$this->s_3->AdvancedSearch->unsetSession();
		$this->s_4->AdvancedSearch->unsetSession();
		$this->s_5->AdvancedSearch->unsetSession();
		$this->omr_image->AdvancedSearch->unsetSession();
		$this->_1->AdvancedSearch->unsetSession();
		$this->m_1->AdvancedSearch->unsetSession();
		$this->_2->AdvancedSearch->unsetSession();
		$this->m_2->AdvancedSearch->unsetSession();
		$this->_3->AdvancedSearch->unsetSession();
		$this->m_3->AdvancedSearch->unsetSession();
		$this->_4->AdvancedSearch->unsetSession();
		$this->m_4->AdvancedSearch->unsetSession();
		$this->_5->AdvancedSearch->unsetSession();
		$this->m_5->AdvancedSearch->unsetSession();
		$this->_6->AdvancedSearch->unsetSession();
		$this->m_6->AdvancedSearch->unsetSession();
		$this->_7->AdvancedSearch->unsetSession();
		$this->m_7->AdvancedSearch->unsetSession();
		$this->_8->AdvancedSearch->unsetSession();
		$this->m_8->AdvancedSearch->unsetSession();
		$this->_9->AdvancedSearch->unsetSession();
		$this->m_9->AdvancedSearch->unsetSession();
		$this->_10->AdvancedSearch->unsetSession();
		$this->m_10->AdvancedSearch->unsetSession();
		$this->_11->AdvancedSearch->unsetSession();
		$this->m_11->AdvancedSearch->unsetSession();
		$this->_12->AdvancedSearch->unsetSession();
		$this->m_12->AdvancedSearch->unsetSession();
		$this->_13->AdvancedSearch->unsetSession();
		$this->m_13->AdvancedSearch->unsetSession();
		$this->_14->AdvancedSearch->unsetSession();
		$this->m_14->AdvancedSearch->unsetSession();
		$this->_15->AdvancedSearch->unsetSession();
		$this->m_15->AdvancedSearch->unsetSession();
		$this->_16->AdvancedSearch->unsetSession();
		$this->m_16->AdvancedSearch->unsetSession();
		$this->_17->AdvancedSearch->unsetSession();
		$this->m_17->AdvancedSearch->unsetSession();
		$this->_18->AdvancedSearch->unsetSession();
		$this->m_18->AdvancedSearch->unsetSession();
		$this->_19->AdvancedSearch->unsetSession();
		$this->m_19->AdvancedSearch->unsetSession();
		$this->_20->AdvancedSearch->unsetSession();
		$this->m_20->AdvancedSearch->unsetSession();
		$this->_21->AdvancedSearch->unsetSession();
		$this->m_21->AdvancedSearch->unsetSession();
		$this->_22->AdvancedSearch->unsetSession();
		$this->m_22->AdvancedSearch->unsetSession();
		$this->_23->AdvancedSearch->unsetSession();
		$this->m_23->AdvancedSearch->unsetSession();
		$this->_24->AdvancedSearch->unsetSession();
		$this->m_24->AdvancedSearch->unsetSession();
		$this->_25->AdvancedSearch->unsetSession();
		$this->m_25->AdvancedSearch->unsetSession();
		$this->_26->AdvancedSearch->unsetSession();
		$this->m_26->AdvancedSearch->unsetSession();
		$this->_27->AdvancedSearch->unsetSession();
		$this->m_27->AdvancedSearch->unsetSession();
		$this->_28->AdvancedSearch->unsetSession();
		$this->m_28->AdvancedSearch->unsetSession();
		$this->_29->AdvancedSearch->unsetSession();
		$this->m_29->AdvancedSearch->unsetSession();
		$this->_30->AdvancedSearch->unsetSession();
		$this->m_30->AdvancedSearch->unsetSession();
		$this->_31->AdvancedSearch->unsetSession();
		$this->m_31->AdvancedSearch->unsetSession();
		$this->_32->AdvancedSearch->unsetSession();
		$this->m_32->AdvancedSearch->unsetSession();
		$this->_33->AdvancedSearch->unsetSession();
		$this->m_33->AdvancedSearch->unsetSession();
		$this->_34->AdvancedSearch->unsetSession();
		$this->m_34->AdvancedSearch->unsetSession();
		$this->_35->AdvancedSearch->unsetSession();
		$this->m_35->AdvancedSearch->unsetSession();
		$this->_36->AdvancedSearch->unsetSession();
		$this->m_36->AdvancedSearch->unsetSession();
		$this->_37->AdvancedSearch->unsetSession();
		$this->m_37->AdvancedSearch->unsetSession();
		$this->_38->AdvancedSearch->unsetSession();
		$this->m_38->AdvancedSearch->unsetSession();
		$this->_39->AdvancedSearch->unsetSession();
		$this->m_39->AdvancedSearch->unsetSession();
		$this->_40->AdvancedSearch->unsetSession();
		$this->m_40->AdvancedSearch->unsetSession();
		$this->_41->AdvancedSearch->unsetSession();
		$this->m_41->AdvancedSearch->unsetSession();
		$this->_42->AdvancedSearch->unsetSession();
		$this->m_42->AdvancedSearch->unsetSession();
		$this->_43->AdvancedSearch->unsetSession();
		$this->m_43->AdvancedSearch->unsetSession();
		$this->_44->AdvancedSearch->unsetSession();
		$this->m_44->AdvancedSearch->unsetSession();
		$this->_45->AdvancedSearch->unsetSession();
		$this->m_45->AdvancedSearch->unsetSession();
		$this->_46->AdvancedSearch->unsetSession();
		$this->m_46->AdvancedSearch->unsetSession();
		$this->_47->AdvancedSearch->unsetSession();
		$this->m_47->AdvancedSearch->unsetSession();
		$this->_48->AdvancedSearch->unsetSession();
		$this->m_48->AdvancedSearch->unsetSession();
		$this->_49->AdvancedSearch->unsetSession();
		$this->m_49->AdvancedSearch->unsetSession();
		$this->_50->AdvancedSearch->unsetSession();
		$this->m_50->AdvancedSearch->unsetSession();
		$this->_51->AdvancedSearch->unsetSession();
		$this->m_51->AdvancedSearch->unsetSession();
		$this->_52->AdvancedSearch->unsetSession();
		$this->m_52->AdvancedSearch->unsetSession();
		$this->_53->AdvancedSearch->unsetSession();
		$this->m_53->AdvancedSearch->unsetSession();
		$this->_54->AdvancedSearch->unsetSession();
		$this->m_54->AdvancedSearch->unsetSession();
		$this->_55->AdvancedSearch->unsetSession();
		$this->m_55->AdvancedSearch->unsetSession();
		$this->_56->AdvancedSearch->unsetSession();
		$this->m_56->AdvancedSearch->unsetSession();
		$this->_57->AdvancedSearch->unsetSession();
		$this->m_57->AdvancedSearch->unsetSession();
		$this->_58->AdvancedSearch->unsetSession();
		$this->m_58->AdvancedSearch->unsetSession();
		$this->_59->AdvancedSearch->unsetSession();
		$this->m_59->AdvancedSearch->unsetSession();
		$this->_60->AdvancedSearch->unsetSession();
		$this->m_60->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->roll_no->AdvancedSearch->load();
		$this->test_id->AdvancedSearch->load();
		$this->total->AdvancedSearch->load();
		$this->percent->AdvancedSearch->load();
		$this->s_1->AdvancedSearch->load();
		$this->s_2->AdvancedSearch->load();
		$this->s_3->AdvancedSearch->load();
		$this->s_4->AdvancedSearch->load();
		$this->s_5->AdvancedSearch->load();
		$this->omr_image->AdvancedSearch->load();
		$this->_1->AdvancedSearch->load();
		$this->m_1->AdvancedSearch->load();
		$this->_2->AdvancedSearch->load();
		$this->m_2->AdvancedSearch->load();
		$this->_3->AdvancedSearch->load();
		$this->m_3->AdvancedSearch->load();
		$this->_4->AdvancedSearch->load();
		$this->m_4->AdvancedSearch->load();
		$this->_5->AdvancedSearch->load();
		$this->m_5->AdvancedSearch->load();
		$this->_6->AdvancedSearch->load();
		$this->m_6->AdvancedSearch->load();
		$this->_7->AdvancedSearch->load();
		$this->m_7->AdvancedSearch->load();
		$this->_8->AdvancedSearch->load();
		$this->m_8->AdvancedSearch->load();
		$this->_9->AdvancedSearch->load();
		$this->m_9->AdvancedSearch->load();
		$this->_10->AdvancedSearch->load();
		$this->m_10->AdvancedSearch->load();
		$this->_11->AdvancedSearch->load();
		$this->m_11->AdvancedSearch->load();
		$this->_12->AdvancedSearch->load();
		$this->m_12->AdvancedSearch->load();
		$this->_13->AdvancedSearch->load();
		$this->m_13->AdvancedSearch->load();
		$this->_14->AdvancedSearch->load();
		$this->m_14->AdvancedSearch->load();
		$this->_15->AdvancedSearch->load();
		$this->m_15->AdvancedSearch->load();
		$this->_16->AdvancedSearch->load();
		$this->m_16->AdvancedSearch->load();
		$this->_17->AdvancedSearch->load();
		$this->m_17->AdvancedSearch->load();
		$this->_18->AdvancedSearch->load();
		$this->m_18->AdvancedSearch->load();
		$this->_19->AdvancedSearch->load();
		$this->m_19->AdvancedSearch->load();
		$this->_20->AdvancedSearch->load();
		$this->m_20->AdvancedSearch->load();
		$this->_21->AdvancedSearch->load();
		$this->m_21->AdvancedSearch->load();
		$this->_22->AdvancedSearch->load();
		$this->m_22->AdvancedSearch->load();
		$this->_23->AdvancedSearch->load();
		$this->m_23->AdvancedSearch->load();
		$this->_24->AdvancedSearch->load();
		$this->m_24->AdvancedSearch->load();
		$this->_25->AdvancedSearch->load();
		$this->m_25->AdvancedSearch->load();
		$this->_26->AdvancedSearch->load();
		$this->m_26->AdvancedSearch->load();
		$this->_27->AdvancedSearch->load();
		$this->m_27->AdvancedSearch->load();
		$this->_28->AdvancedSearch->load();
		$this->m_28->AdvancedSearch->load();
		$this->_29->AdvancedSearch->load();
		$this->m_29->AdvancedSearch->load();
		$this->_30->AdvancedSearch->load();
		$this->m_30->AdvancedSearch->load();
		$this->_31->AdvancedSearch->load();
		$this->m_31->AdvancedSearch->load();
		$this->_32->AdvancedSearch->load();
		$this->m_32->AdvancedSearch->load();
		$this->_33->AdvancedSearch->load();
		$this->m_33->AdvancedSearch->load();
		$this->_34->AdvancedSearch->load();
		$this->m_34->AdvancedSearch->load();
		$this->_35->AdvancedSearch->load();
		$this->m_35->AdvancedSearch->load();
		$this->_36->AdvancedSearch->load();
		$this->m_36->AdvancedSearch->load();
		$this->_37->AdvancedSearch->load();
		$this->m_37->AdvancedSearch->load();
		$this->_38->AdvancedSearch->load();
		$this->m_38->AdvancedSearch->load();
		$this->_39->AdvancedSearch->load();
		$this->m_39->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->m_40->AdvancedSearch->load();
		$this->_41->AdvancedSearch->load();
		$this->m_41->AdvancedSearch->load();
		$this->_42->AdvancedSearch->load();
		$this->m_42->AdvancedSearch->load();
		$this->_43->AdvancedSearch->load();
		$this->m_43->AdvancedSearch->load();
		$this->_44->AdvancedSearch->load();
		$this->m_44->AdvancedSearch->load();
		$this->_45->AdvancedSearch->load();
		$this->m_45->AdvancedSearch->load();
		$this->_46->AdvancedSearch->load();
		$this->m_46->AdvancedSearch->load();
		$this->_47->AdvancedSearch->load();
		$this->m_47->AdvancedSearch->load();
		$this->_48->AdvancedSearch->load();
		$this->m_48->AdvancedSearch->load();
		$this->_49->AdvancedSearch->load();
		$this->m_49->AdvancedSearch->load();
		$this->_50->AdvancedSearch->load();
		$this->m_50->AdvancedSearch->load();
		$this->_51->AdvancedSearch->load();
		$this->m_51->AdvancedSearch->load();
		$this->_52->AdvancedSearch->load();
		$this->m_52->AdvancedSearch->load();
		$this->_53->AdvancedSearch->load();
		$this->m_53->AdvancedSearch->load();
		$this->_54->AdvancedSearch->load();
		$this->m_54->AdvancedSearch->load();
		$this->_55->AdvancedSearch->load();
		$this->m_55->AdvancedSearch->load();
		$this->_56->AdvancedSearch->load();
		$this->m_56->AdvancedSearch->load();
		$this->_57->AdvancedSearch->load();
		$this->m_57->AdvancedSearch->load();
		$this->_58->AdvancedSearch->load();
		$this->m_58->AdvancedSearch->load();
		$this->_59->AdvancedSearch->load();
		$this->m_59->AdvancedSearch->load();
		$this->_60->AdvancedSearch->load();
		$this->m_60->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->roll_no, $ctrl); // roll_no
			$this->updateSort($this->test_id, $ctrl); // test_id
			$this->updateSort($this->total, $ctrl); // total
			$this->updateSort($this->percent, $ctrl); // percent
			$this->updateSort($this->s_1, $ctrl); // s_1
			$this->updateSort($this->s_2, $ctrl); // s_2
			$this->updateSort($this->s_3, $ctrl); // s_3
			$this->updateSort($this->s_4, $ctrl); // s_4
			$this->updateSort($this->s_5, $ctrl); // s_5
			$this->updateSort($this->omr_image, $ctrl); // omr_image
			$this->updateSort($this->_1, $ctrl); // 1
			$this->updateSort($this->m_1, $ctrl); // m_1
			$this->updateSort($this->_2, $ctrl); // 2
			$this->updateSort($this->m_2, $ctrl); // m_2
			$this->updateSort($this->_3, $ctrl); // 3
			$this->updateSort($this->m_3, $ctrl); // m_3
			$this->updateSort($this->_4, $ctrl); // 4
			$this->updateSort($this->m_4, $ctrl); // m_4
			$this->updateSort($this->_5, $ctrl); // 5
			$this->updateSort($this->m_5, $ctrl); // m_5
			$this->updateSort($this->_6, $ctrl); // 6
			$this->updateSort($this->m_6, $ctrl); // m_6
			$this->updateSort($this->_7, $ctrl); // 7
			$this->updateSort($this->m_7, $ctrl); // m_7
			$this->updateSort($this->_8, $ctrl); // 8
			$this->updateSort($this->m_8, $ctrl); // m_8
			$this->updateSort($this->_9, $ctrl); // 9
			$this->updateSort($this->m_9, $ctrl); // m_9
			$this->updateSort($this->_10, $ctrl); // 10
			$this->updateSort($this->m_10, $ctrl); // m_10
			$this->updateSort($this->_11, $ctrl); // 11
			$this->updateSort($this->m_11, $ctrl); // m_11
			$this->updateSort($this->_12, $ctrl); // 12
			$this->updateSort($this->m_12, $ctrl); // m_12
			$this->updateSort($this->_13, $ctrl); // 13
			$this->updateSort($this->m_13, $ctrl); // m_13
			$this->updateSort($this->_14, $ctrl); // 14
			$this->updateSort($this->m_14, $ctrl); // m_14
			$this->updateSort($this->_15, $ctrl); // 15
			$this->updateSort($this->m_15, $ctrl); // m_15
			$this->updateSort($this->_16, $ctrl); // 16
			$this->updateSort($this->m_16, $ctrl); // m_16
			$this->updateSort($this->_17, $ctrl); // 17
			$this->updateSort($this->m_17, $ctrl); // m_17
			$this->updateSort($this->_18, $ctrl); // 18
			$this->updateSort($this->m_18, $ctrl); // m_18
			$this->updateSort($this->_19, $ctrl); // 19
			$this->updateSort($this->m_19, $ctrl); // m_19
			$this->updateSort($this->_20, $ctrl); // 20
			$this->updateSort($this->m_20, $ctrl); // m_20
			$this->updateSort($this->_21, $ctrl); // 21
			$this->updateSort($this->m_21, $ctrl); // m_21
			$this->updateSort($this->_22, $ctrl); // 22
			$this->updateSort($this->m_22, $ctrl); // m_22
			$this->updateSort($this->_23, $ctrl); // 23
			$this->updateSort($this->m_23, $ctrl); // m_23
			$this->updateSort($this->_24, $ctrl); // 24
			$this->updateSort($this->m_24, $ctrl); // m_24
			$this->updateSort($this->_25, $ctrl); // 25
			$this->updateSort($this->m_25, $ctrl); // m_25
			$this->updateSort($this->_26, $ctrl); // 26
			$this->updateSort($this->m_26, $ctrl); // m_26
			$this->updateSort($this->_27, $ctrl); // 27
			$this->updateSort($this->m_27, $ctrl); // m_27
			$this->updateSort($this->_28, $ctrl); // 28
			$this->updateSort($this->m_28, $ctrl); // m_28
			$this->updateSort($this->_29, $ctrl); // 29
			$this->updateSort($this->m_29, $ctrl); // m_29
			$this->updateSort($this->_30, $ctrl); // 30
			$this->updateSort($this->m_30, $ctrl); // m_30
			$this->updateSort($this->_31, $ctrl); // 31
			$this->updateSort($this->m_31, $ctrl); // m_31
			$this->updateSort($this->_32, $ctrl); // 32
			$this->updateSort($this->m_32, $ctrl); // m_32
			$this->updateSort($this->_33, $ctrl); // 33
			$this->updateSort($this->m_33, $ctrl); // m_33
			$this->updateSort($this->_34, $ctrl); // 34
			$this->updateSort($this->m_34, $ctrl); // m_34
			$this->updateSort($this->_35, $ctrl); // 35
			$this->updateSort($this->m_35, $ctrl); // m_35
			$this->updateSort($this->_36, $ctrl); // 36
			$this->updateSort($this->m_36, $ctrl); // m_36
			$this->updateSort($this->_37, $ctrl); // 37
			$this->updateSort($this->m_37, $ctrl); // m_37
			$this->updateSort($this->_38, $ctrl); // 38
			$this->updateSort($this->m_38, $ctrl); // m_38
			$this->updateSort($this->_39, $ctrl); // 39
			$this->updateSort($this->m_39, $ctrl); // m_39
			$this->updateSort($this->_40, $ctrl); // 40
			$this->updateSort($this->m_40, $ctrl); // m_40
			$this->updateSort($this->_41, $ctrl); // 41
			$this->updateSort($this->m_41, $ctrl); // m_41
			$this->updateSort($this->_42, $ctrl); // 42
			$this->updateSort($this->m_42, $ctrl); // m_42
			$this->updateSort($this->_43, $ctrl); // 43
			$this->updateSort($this->m_43, $ctrl); // m_43
			$this->updateSort($this->_44, $ctrl); // 44
			$this->updateSort($this->m_44, $ctrl); // m_44
			$this->updateSort($this->_45, $ctrl); // 45
			$this->updateSort($this->m_45, $ctrl); // m_45
			$this->updateSort($this->_46, $ctrl); // 46
			$this->updateSort($this->m_46, $ctrl); // m_46
			$this->updateSort($this->_47, $ctrl); // 47
			$this->updateSort($this->m_47, $ctrl); // m_47
			$this->updateSort($this->_48, $ctrl); // 48
			$this->updateSort($this->m_48, $ctrl); // m_48
			$this->updateSort($this->_49, $ctrl); // 49
			$this->updateSort($this->m_49, $ctrl); // m_49
			$this->updateSort($this->_50, $ctrl); // 50
			$this->updateSort($this->m_50, $ctrl); // m_50
			$this->updateSort($this->_51, $ctrl); // 51
			$this->updateSort($this->m_51, $ctrl); // m_51
			$this->updateSort($this->_52, $ctrl); // 52
			$this->updateSort($this->m_52, $ctrl); // m_52
			$this->updateSort($this->_53, $ctrl); // 53
			$this->updateSort($this->m_53, $ctrl); // m_53
			$this->updateSort($this->_54, $ctrl); // 54
			$this->updateSort($this->m_54, $ctrl); // m_54
			$this->updateSort($this->_55, $ctrl); // 55
			$this->updateSort($this->m_55, $ctrl); // m_55
			$this->updateSort($this->_56, $ctrl); // 56
			$this->updateSort($this->m_56, $ctrl); // m_56
			$this->updateSort($this->_57, $ctrl); // 57
			$this->updateSort($this->m_57, $ctrl); // m_57
			$this->updateSort($this->_58, $ctrl); // 58
			$this->updateSort($this->m_58, $ctrl); // m_58
			$this->updateSort($this->_59, $ctrl); // 59
			$this->updateSort($this->m_59, $ctrl); // m_59
			$this->updateSort($this->_60, $ctrl); // 60
			$this->updateSort($this->m_60, $ctrl); // m_60
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("");
				$this->roll_no->setSort("");
				$this->test_id->setSort("");
				$this->total->setSort("");
				$this->percent->setSort("");
				$this->s_1->setSort("");
				$this->s_2->setSort("");
				$this->s_3->setSort("");
				$this->s_4->setSort("");
				$this->s_5->setSort("");
				$this->omr_image->setSort("");
				$this->_1->setSort("");
				$this->m_1->setSort("");
				$this->_2->setSort("");
				$this->m_2->setSort("");
				$this->_3->setSort("");
				$this->m_3->setSort("");
				$this->_4->setSort("");
				$this->m_4->setSort("");
				$this->_5->setSort("");
				$this->m_5->setSort("");
				$this->_6->setSort("");
				$this->m_6->setSort("");
				$this->_7->setSort("");
				$this->m_7->setSort("");
				$this->_8->setSort("");
				$this->m_8->setSort("");
				$this->_9->setSort("");
				$this->m_9->setSort("");
				$this->_10->setSort("");
				$this->m_10->setSort("");
				$this->_11->setSort("");
				$this->m_11->setSort("");
				$this->_12->setSort("");
				$this->m_12->setSort("");
				$this->_13->setSort("");
				$this->m_13->setSort("");
				$this->_14->setSort("");
				$this->m_14->setSort("");
				$this->_15->setSort("");
				$this->m_15->setSort("");
				$this->_16->setSort("");
				$this->m_16->setSort("");
				$this->_17->setSort("");
				$this->m_17->setSort("");
				$this->_18->setSort("");
				$this->m_18->setSort("");
				$this->_19->setSort("");
				$this->m_19->setSort("");
				$this->_20->setSort("");
				$this->m_20->setSort("");
				$this->_21->setSort("");
				$this->m_21->setSort("");
				$this->_22->setSort("");
				$this->m_22->setSort("");
				$this->_23->setSort("");
				$this->m_23->setSort("");
				$this->_24->setSort("");
				$this->m_24->setSort("");
				$this->_25->setSort("");
				$this->m_25->setSort("");
				$this->_26->setSort("");
				$this->m_26->setSort("");
				$this->_27->setSort("");
				$this->m_27->setSort("");
				$this->_28->setSort("");
				$this->m_28->setSort("");
				$this->_29->setSort("");
				$this->m_29->setSort("");
				$this->_30->setSort("");
				$this->m_30->setSort("");
				$this->_31->setSort("");
				$this->m_31->setSort("");
				$this->_32->setSort("");
				$this->m_32->setSort("");
				$this->_33->setSort("");
				$this->m_33->setSort("");
				$this->_34->setSort("");
				$this->m_34->setSort("");
				$this->_35->setSort("");
				$this->m_35->setSort("");
				$this->_36->setSort("");
				$this->m_36->setSort("");
				$this->_37->setSort("");
				$this->m_37->setSort("");
				$this->_38->setSort("");
				$this->m_38->setSort("");
				$this->_39->setSort("");
				$this->m_39->setSort("");
				$this->_40->setSort("");
				$this->m_40->setSort("");
				$this->_41->setSort("");
				$this->m_41->setSort("");
				$this->_42->setSort("");
				$this->m_42->setSort("");
				$this->_43->setSort("");
				$this->m_43->setSort("");
				$this->_44->setSort("");
				$this->m_44->setSort("");
				$this->_45->setSort("");
				$this->m_45->setSort("");
				$this->_46->setSort("");
				$this->m_46->setSort("");
				$this->_47->setSort("");
				$this->m_47->setSort("");
				$this->_48->setSort("");
				$this->m_48->setSort("");
				$this->_49->setSort("");
				$this->m_49->setSort("");
				$this->_50->setSort("");
				$this->m_50->setSort("");
				$this->_51->setSort("");
				$this->m_51->setSort("");
				$this->_52->setSort("");
				$this->m_52->setSort("");
				$this->_53->setSort("");
				$this->m_53->setSort("");
				$this->_54->setSort("");
				$this->m_54->setSort("");
				$this->_55->setSort("");
				$this->m_55->setSort("");
				$this->_56->setSort("");
				$this->m_56->setSort("");
				$this->_57->setSort("");
				$this->m_57->setSort("");
				$this->_58->setSort("");
				$this->m_58->setSort("");
				$this->_59->setSort("");
				$this->m_59->setSort("");
				$this->_60->setSort("");
				$this->m_60->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// "delete"
		$item = &$this->ListOptions->add("delete");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canDelete();
		$item->OnLeft = TRUE;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "delete"
		$opt = &$this->ListOptions->Items["delete"];
		if ($Security->canDelete())
			$opt->Body = "<a class=\"ew-row-link ew-delete\"" . "" . " title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("DeleteLink") . "</a>";
		else
			$opt->Body = "";

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"fs_omr_valuelistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"fs_omr_valuelistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.fs_omr_valuelist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"fs_omr_valuelistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"s_omr_valuesrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"s_omr_value\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'s_omr_valuesrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"fs_omr_valuelistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// roll_no
		if (!$this->isAddOrEdit())
			$this->roll_no->AdvancedSearch->setSearchValue(Get("x_roll_no", Get("roll_no", "")));
		if ($this->roll_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->roll_no->AdvancedSearch->setSearchOperator(Get("z_roll_no", ""));

		// test_id
		if (!$this->isAddOrEdit())
			$this->test_id->AdvancedSearch->setSearchValue(Get("x_test_id", Get("test_id", "")));
		if ($this->test_id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->test_id->AdvancedSearch->setSearchOperator(Get("z_test_id", ""));

		// total
		if (!$this->isAddOrEdit())
			$this->total->AdvancedSearch->setSearchValue(Get("x_total", Get("total", "")));
		if ($this->total->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->total->AdvancedSearch->setSearchOperator(Get("z_total", ""));
		$this->total->AdvancedSearch->setSearchCondition(Get("v_total", ""));
		$this->total->AdvancedSearch->setSearchValue2(Get("y_total", ""));
		if ($this->total->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->total->AdvancedSearch->setSearchOperator2(Get("w_total", ""));

		// percent
		if (!$this->isAddOrEdit())
			$this->percent->AdvancedSearch->setSearchValue(Get("x_percent", Get("percent", "")));
		if ($this->percent->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->percent->AdvancedSearch->setSearchOperator(Get("z_percent", ""));
		$this->percent->AdvancedSearch->setSearchCondition(Get("v_percent", ""));
		$this->percent->AdvancedSearch->setSearchValue2(Get("y_percent", ""));
		if ($this->percent->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->percent->AdvancedSearch->setSearchOperator2(Get("w_percent", ""));

		// s_1
		if (!$this->isAddOrEdit())
			$this->s_1->AdvancedSearch->setSearchValue(Get("x_s_1", Get("s_1", "")));
		if ($this->s_1->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->s_1->AdvancedSearch->setSearchOperator(Get("z_s_1", ""));

		// s_2
		if (!$this->isAddOrEdit())
			$this->s_2->AdvancedSearch->setSearchValue(Get("x_s_2", Get("s_2", "")));
		if ($this->s_2->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->s_2->AdvancedSearch->setSearchOperator(Get("z_s_2", ""));

		// s_3
		if (!$this->isAddOrEdit())
			$this->s_3->AdvancedSearch->setSearchValue(Get("x_s_3", Get("s_3", "")));
		if ($this->s_3->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->s_3->AdvancedSearch->setSearchOperator(Get("z_s_3", ""));

		// s_4
		if (!$this->isAddOrEdit())
			$this->s_4->AdvancedSearch->setSearchValue(Get("x_s_4", Get("s_4", "")));
		if ($this->s_4->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->s_4->AdvancedSearch->setSearchOperator(Get("z_s_4", ""));

		// s_5
		if (!$this->isAddOrEdit())
			$this->s_5->AdvancedSearch->setSearchValue(Get("x_s_5", Get("s_5", "")));
		if ($this->s_5->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->s_5->AdvancedSearch->setSearchOperator(Get("z_s_5", ""));

		// omr_image
		if (!$this->isAddOrEdit())
			$this->omr_image->AdvancedSearch->setSearchValue(Get("x_omr_image", Get("omr_image", "")));
		if ($this->omr_image->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->omr_image->AdvancedSearch->setSearchOperator(Get("z_omr_image", ""));

		// 1
		if (!$this->isAddOrEdit())
			$this->_1->AdvancedSearch->setSearchValue(Get("x__1", Get("_1", "")));
		if ($this->_1->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_1->AdvancedSearch->setSearchOperator(Get("z__1", ""));

		// m_1
		if (!$this->isAddOrEdit())
			$this->m_1->AdvancedSearch->setSearchValue(Get("x_m_1", Get("m_1", "")));
		if ($this->m_1->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_1->AdvancedSearch->setSearchOperator(Get("z_m_1", ""));

		// 2
		if (!$this->isAddOrEdit())
			$this->_2->AdvancedSearch->setSearchValue(Get("x__2", Get("_2", "")));
		if ($this->_2->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_2->AdvancedSearch->setSearchOperator(Get("z__2", ""));

		// m_2
		if (!$this->isAddOrEdit())
			$this->m_2->AdvancedSearch->setSearchValue(Get("x_m_2", Get("m_2", "")));
		if ($this->m_2->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_2->AdvancedSearch->setSearchOperator(Get("z_m_2", ""));

		// 3
		if (!$this->isAddOrEdit())
			$this->_3->AdvancedSearch->setSearchValue(Get("x__3", Get("_3", "")));
		if ($this->_3->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_3->AdvancedSearch->setSearchOperator(Get("z__3", ""));

		// m_3
		if (!$this->isAddOrEdit())
			$this->m_3->AdvancedSearch->setSearchValue(Get("x_m_3", Get("m_3", "")));
		if ($this->m_3->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_3->AdvancedSearch->setSearchOperator(Get("z_m_3", ""));

		// 4
		if (!$this->isAddOrEdit())
			$this->_4->AdvancedSearch->setSearchValue(Get("x__4", Get("_4", "")));
		if ($this->_4->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_4->AdvancedSearch->setSearchOperator(Get("z__4", ""));

		// m_4
		if (!$this->isAddOrEdit())
			$this->m_4->AdvancedSearch->setSearchValue(Get("x_m_4", Get("m_4", "")));
		if ($this->m_4->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_4->AdvancedSearch->setSearchOperator(Get("z_m_4", ""));

		// 5
		if (!$this->isAddOrEdit())
			$this->_5->AdvancedSearch->setSearchValue(Get("x__5", Get("_5", "")));
		if ($this->_5->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_5->AdvancedSearch->setSearchOperator(Get("z__5", ""));

		// m_5
		if (!$this->isAddOrEdit())
			$this->m_5->AdvancedSearch->setSearchValue(Get("x_m_5", Get("m_5", "")));
		if ($this->m_5->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_5->AdvancedSearch->setSearchOperator(Get("z_m_5", ""));

		// 6
		if (!$this->isAddOrEdit())
			$this->_6->AdvancedSearch->setSearchValue(Get("x__6", Get("_6", "")));
		if ($this->_6->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_6->AdvancedSearch->setSearchOperator(Get("z__6", ""));

		// m_6
		if (!$this->isAddOrEdit())
			$this->m_6->AdvancedSearch->setSearchValue(Get("x_m_6", Get("m_6", "")));
		if ($this->m_6->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_6->AdvancedSearch->setSearchOperator(Get("z_m_6", ""));

		// 7
		if (!$this->isAddOrEdit())
			$this->_7->AdvancedSearch->setSearchValue(Get("x__7", Get("_7", "")));
		if ($this->_7->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_7->AdvancedSearch->setSearchOperator(Get("z__7", ""));

		// m_7
		if (!$this->isAddOrEdit())
			$this->m_7->AdvancedSearch->setSearchValue(Get("x_m_7", Get("m_7", "")));
		if ($this->m_7->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_7->AdvancedSearch->setSearchOperator(Get("z_m_7", ""));

		// 8
		if (!$this->isAddOrEdit())
			$this->_8->AdvancedSearch->setSearchValue(Get("x__8", Get("_8", "")));
		if ($this->_8->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_8->AdvancedSearch->setSearchOperator(Get("z__8", ""));

		// m_8
		if (!$this->isAddOrEdit())
			$this->m_8->AdvancedSearch->setSearchValue(Get("x_m_8", Get("m_8", "")));
		if ($this->m_8->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_8->AdvancedSearch->setSearchOperator(Get("z_m_8", ""));

		// 9
		if (!$this->isAddOrEdit())
			$this->_9->AdvancedSearch->setSearchValue(Get("x__9", Get("_9", "")));
		if ($this->_9->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_9->AdvancedSearch->setSearchOperator(Get("z__9", ""));

		// m_9
		if (!$this->isAddOrEdit())
			$this->m_9->AdvancedSearch->setSearchValue(Get("x_m_9", Get("m_9", "")));
		if ($this->m_9->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_9->AdvancedSearch->setSearchOperator(Get("z_m_9", ""));

		// 10
		if (!$this->isAddOrEdit())
			$this->_10->AdvancedSearch->setSearchValue(Get("x__10", Get("_10", "")));
		if ($this->_10->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_10->AdvancedSearch->setSearchOperator(Get("z__10", ""));

		// m_10
		if (!$this->isAddOrEdit())
			$this->m_10->AdvancedSearch->setSearchValue(Get("x_m_10", Get("m_10", "")));
		if ($this->m_10->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_10->AdvancedSearch->setSearchOperator(Get("z_m_10", ""));

		// 11
		if (!$this->isAddOrEdit())
			$this->_11->AdvancedSearch->setSearchValue(Get("x__11", Get("_11", "")));
		if ($this->_11->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_11->AdvancedSearch->setSearchOperator(Get("z__11", ""));

		// m_11
		if (!$this->isAddOrEdit())
			$this->m_11->AdvancedSearch->setSearchValue(Get("x_m_11", Get("m_11", "")));
		if ($this->m_11->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_11->AdvancedSearch->setSearchOperator(Get("z_m_11", ""));

		// 12
		if (!$this->isAddOrEdit())
			$this->_12->AdvancedSearch->setSearchValue(Get("x__12", Get("_12", "")));
		if ($this->_12->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_12->AdvancedSearch->setSearchOperator(Get("z__12", ""));

		// m_12
		if (!$this->isAddOrEdit())
			$this->m_12->AdvancedSearch->setSearchValue(Get("x_m_12", Get("m_12", "")));
		if ($this->m_12->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_12->AdvancedSearch->setSearchOperator(Get("z_m_12", ""));

		// 13
		if (!$this->isAddOrEdit())
			$this->_13->AdvancedSearch->setSearchValue(Get("x__13", Get("_13", "")));
		if ($this->_13->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_13->AdvancedSearch->setSearchOperator(Get("z__13", ""));

		// m_13
		if (!$this->isAddOrEdit())
			$this->m_13->AdvancedSearch->setSearchValue(Get("x_m_13", Get("m_13", "")));
		if ($this->m_13->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_13->AdvancedSearch->setSearchOperator(Get("z_m_13", ""));

		// 14
		if (!$this->isAddOrEdit())
			$this->_14->AdvancedSearch->setSearchValue(Get("x__14", Get("_14", "")));
		if ($this->_14->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_14->AdvancedSearch->setSearchOperator(Get("z__14", ""));

		// m_14
		if (!$this->isAddOrEdit())
			$this->m_14->AdvancedSearch->setSearchValue(Get("x_m_14", Get("m_14", "")));
		if ($this->m_14->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_14->AdvancedSearch->setSearchOperator(Get("z_m_14", ""));

		// 15
		if (!$this->isAddOrEdit())
			$this->_15->AdvancedSearch->setSearchValue(Get("x__15", Get("_15", "")));
		if ($this->_15->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_15->AdvancedSearch->setSearchOperator(Get("z__15", ""));

		// m_15
		if (!$this->isAddOrEdit())
			$this->m_15->AdvancedSearch->setSearchValue(Get("x_m_15", Get("m_15", "")));
		if ($this->m_15->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_15->AdvancedSearch->setSearchOperator(Get("z_m_15", ""));

		// 16
		if (!$this->isAddOrEdit())
			$this->_16->AdvancedSearch->setSearchValue(Get("x__16", Get("_16", "")));
		if ($this->_16->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_16->AdvancedSearch->setSearchOperator(Get("z__16", ""));

		// m_16
		if (!$this->isAddOrEdit())
			$this->m_16->AdvancedSearch->setSearchValue(Get("x_m_16", Get("m_16", "")));
		if ($this->m_16->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_16->AdvancedSearch->setSearchOperator(Get("z_m_16", ""));

		// 17
		if (!$this->isAddOrEdit())
			$this->_17->AdvancedSearch->setSearchValue(Get("x__17", Get("_17", "")));
		if ($this->_17->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_17->AdvancedSearch->setSearchOperator(Get("z__17", ""));

		// m_17
		if (!$this->isAddOrEdit())
			$this->m_17->AdvancedSearch->setSearchValue(Get("x_m_17", Get("m_17", "")));
		if ($this->m_17->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_17->AdvancedSearch->setSearchOperator(Get("z_m_17", ""));

		// 18
		if (!$this->isAddOrEdit())
			$this->_18->AdvancedSearch->setSearchValue(Get("x__18", Get("_18", "")));
		if ($this->_18->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_18->AdvancedSearch->setSearchOperator(Get("z__18", ""));

		// m_18
		if (!$this->isAddOrEdit())
			$this->m_18->AdvancedSearch->setSearchValue(Get("x_m_18", Get("m_18", "")));
		if ($this->m_18->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_18->AdvancedSearch->setSearchOperator(Get("z_m_18", ""));

		// 19
		if (!$this->isAddOrEdit())
			$this->_19->AdvancedSearch->setSearchValue(Get("x__19", Get("_19", "")));
		if ($this->_19->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_19->AdvancedSearch->setSearchOperator(Get("z__19", ""));

		// m_19
		if (!$this->isAddOrEdit())
			$this->m_19->AdvancedSearch->setSearchValue(Get("x_m_19", Get("m_19", "")));
		if ($this->m_19->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_19->AdvancedSearch->setSearchOperator(Get("z_m_19", ""));

		// 20
		if (!$this->isAddOrEdit())
			$this->_20->AdvancedSearch->setSearchValue(Get("x__20", Get("_20", "")));
		if ($this->_20->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_20->AdvancedSearch->setSearchOperator(Get("z__20", ""));

		// m_20
		if (!$this->isAddOrEdit())
			$this->m_20->AdvancedSearch->setSearchValue(Get("x_m_20", Get("m_20", "")));
		if ($this->m_20->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_20->AdvancedSearch->setSearchOperator(Get("z_m_20", ""));

		// 21
		if (!$this->isAddOrEdit())
			$this->_21->AdvancedSearch->setSearchValue(Get("x__21", Get("_21", "")));
		if ($this->_21->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_21->AdvancedSearch->setSearchOperator(Get("z__21", ""));

		// m_21
		if (!$this->isAddOrEdit())
			$this->m_21->AdvancedSearch->setSearchValue(Get("x_m_21", Get("m_21", "")));
		if ($this->m_21->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_21->AdvancedSearch->setSearchOperator(Get("z_m_21", ""));

		// 22
		if (!$this->isAddOrEdit())
			$this->_22->AdvancedSearch->setSearchValue(Get("x__22", Get("_22", "")));
		if ($this->_22->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_22->AdvancedSearch->setSearchOperator(Get("z__22", ""));

		// m_22
		if (!$this->isAddOrEdit())
			$this->m_22->AdvancedSearch->setSearchValue(Get("x_m_22", Get("m_22", "")));
		if ($this->m_22->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_22->AdvancedSearch->setSearchOperator(Get("z_m_22", ""));

		// 23
		if (!$this->isAddOrEdit())
			$this->_23->AdvancedSearch->setSearchValue(Get("x__23", Get("_23", "")));
		if ($this->_23->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_23->AdvancedSearch->setSearchOperator(Get("z__23", ""));

		// m_23
		if (!$this->isAddOrEdit())
			$this->m_23->AdvancedSearch->setSearchValue(Get("x_m_23", Get("m_23", "")));
		if ($this->m_23->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_23->AdvancedSearch->setSearchOperator(Get("z_m_23", ""));

		// 24
		if (!$this->isAddOrEdit())
			$this->_24->AdvancedSearch->setSearchValue(Get("x__24", Get("_24", "")));
		if ($this->_24->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_24->AdvancedSearch->setSearchOperator(Get("z__24", ""));

		// m_24
		if (!$this->isAddOrEdit())
			$this->m_24->AdvancedSearch->setSearchValue(Get("x_m_24", Get("m_24", "")));
		if ($this->m_24->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_24->AdvancedSearch->setSearchOperator(Get("z_m_24", ""));

		// 25
		if (!$this->isAddOrEdit())
			$this->_25->AdvancedSearch->setSearchValue(Get("x__25", Get("_25", "")));
		if ($this->_25->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_25->AdvancedSearch->setSearchOperator(Get("z__25", ""));

		// m_25
		if (!$this->isAddOrEdit())
			$this->m_25->AdvancedSearch->setSearchValue(Get("x_m_25", Get("m_25", "")));
		if ($this->m_25->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_25->AdvancedSearch->setSearchOperator(Get("z_m_25", ""));

		// 26
		if (!$this->isAddOrEdit())
			$this->_26->AdvancedSearch->setSearchValue(Get("x__26", Get("_26", "")));
		if ($this->_26->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_26->AdvancedSearch->setSearchOperator(Get("z__26", ""));

		// m_26
		if (!$this->isAddOrEdit())
			$this->m_26->AdvancedSearch->setSearchValue(Get("x_m_26", Get("m_26", "")));
		if ($this->m_26->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_26->AdvancedSearch->setSearchOperator(Get("z_m_26", ""));

		// 27
		if (!$this->isAddOrEdit())
			$this->_27->AdvancedSearch->setSearchValue(Get("x__27", Get("_27", "")));
		if ($this->_27->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_27->AdvancedSearch->setSearchOperator(Get("z__27", ""));

		// m_27
		if (!$this->isAddOrEdit())
			$this->m_27->AdvancedSearch->setSearchValue(Get("x_m_27", Get("m_27", "")));
		if ($this->m_27->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_27->AdvancedSearch->setSearchOperator(Get("z_m_27", ""));

		// 28
		if (!$this->isAddOrEdit())
			$this->_28->AdvancedSearch->setSearchValue(Get("x__28", Get("_28", "")));
		if ($this->_28->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_28->AdvancedSearch->setSearchOperator(Get("z__28", ""));

		// m_28
		if (!$this->isAddOrEdit())
			$this->m_28->AdvancedSearch->setSearchValue(Get("x_m_28", Get("m_28", "")));
		if ($this->m_28->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_28->AdvancedSearch->setSearchOperator(Get("z_m_28", ""));

		// 29
		if (!$this->isAddOrEdit())
			$this->_29->AdvancedSearch->setSearchValue(Get("x__29", Get("_29", "")));
		if ($this->_29->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_29->AdvancedSearch->setSearchOperator(Get("z__29", ""));

		// m_29
		if (!$this->isAddOrEdit())
			$this->m_29->AdvancedSearch->setSearchValue(Get("x_m_29", Get("m_29", "")));
		if ($this->m_29->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_29->AdvancedSearch->setSearchOperator(Get("z_m_29", ""));

		// 30
		if (!$this->isAddOrEdit())
			$this->_30->AdvancedSearch->setSearchValue(Get("x__30", Get("_30", "")));
		if ($this->_30->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_30->AdvancedSearch->setSearchOperator(Get("z__30", ""));

		// m_30
		if (!$this->isAddOrEdit())
			$this->m_30->AdvancedSearch->setSearchValue(Get("x_m_30", Get("m_30", "")));
		if ($this->m_30->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_30->AdvancedSearch->setSearchOperator(Get("z_m_30", ""));

		// 31
		if (!$this->isAddOrEdit())
			$this->_31->AdvancedSearch->setSearchValue(Get("x__31", Get("_31", "")));
		if ($this->_31->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_31->AdvancedSearch->setSearchOperator(Get("z__31", ""));

		// m_31
		if (!$this->isAddOrEdit())
			$this->m_31->AdvancedSearch->setSearchValue(Get("x_m_31", Get("m_31", "")));
		if ($this->m_31->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_31->AdvancedSearch->setSearchOperator(Get("z_m_31", ""));

		// 32
		if (!$this->isAddOrEdit())
			$this->_32->AdvancedSearch->setSearchValue(Get("x__32", Get("_32", "")));
		if ($this->_32->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_32->AdvancedSearch->setSearchOperator(Get("z__32", ""));

		// m_32
		if (!$this->isAddOrEdit())
			$this->m_32->AdvancedSearch->setSearchValue(Get("x_m_32", Get("m_32", "")));
		if ($this->m_32->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_32->AdvancedSearch->setSearchOperator(Get("z_m_32", ""));

		// 33
		if (!$this->isAddOrEdit())
			$this->_33->AdvancedSearch->setSearchValue(Get("x__33", Get("_33", "")));
		if ($this->_33->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_33->AdvancedSearch->setSearchOperator(Get("z__33", ""));

		// m_33
		if (!$this->isAddOrEdit())
			$this->m_33->AdvancedSearch->setSearchValue(Get("x_m_33", Get("m_33", "")));
		if ($this->m_33->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_33->AdvancedSearch->setSearchOperator(Get("z_m_33", ""));

		// 34
		if (!$this->isAddOrEdit())
			$this->_34->AdvancedSearch->setSearchValue(Get("x__34", Get("_34", "")));
		if ($this->_34->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_34->AdvancedSearch->setSearchOperator(Get("z__34", ""));

		// m_34
		if (!$this->isAddOrEdit())
			$this->m_34->AdvancedSearch->setSearchValue(Get("x_m_34", Get("m_34", "")));
		if ($this->m_34->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_34->AdvancedSearch->setSearchOperator(Get("z_m_34", ""));

		// 35
		if (!$this->isAddOrEdit())
			$this->_35->AdvancedSearch->setSearchValue(Get("x__35", Get("_35", "")));
		if ($this->_35->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_35->AdvancedSearch->setSearchOperator(Get("z__35", ""));

		// m_35
		if (!$this->isAddOrEdit())
			$this->m_35->AdvancedSearch->setSearchValue(Get("x_m_35", Get("m_35", "")));
		if ($this->m_35->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_35->AdvancedSearch->setSearchOperator(Get("z_m_35", ""));

		// 36
		if (!$this->isAddOrEdit())
			$this->_36->AdvancedSearch->setSearchValue(Get("x__36", Get("_36", "")));
		if ($this->_36->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_36->AdvancedSearch->setSearchOperator(Get("z__36", ""));

		// m_36
		if (!$this->isAddOrEdit())
			$this->m_36->AdvancedSearch->setSearchValue(Get("x_m_36", Get("m_36", "")));
		if ($this->m_36->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_36->AdvancedSearch->setSearchOperator(Get("z_m_36", ""));

		// 37
		if (!$this->isAddOrEdit())
			$this->_37->AdvancedSearch->setSearchValue(Get("x__37", Get("_37", "")));
		if ($this->_37->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_37->AdvancedSearch->setSearchOperator(Get("z__37", ""));

		// m_37
		if (!$this->isAddOrEdit())
			$this->m_37->AdvancedSearch->setSearchValue(Get("x_m_37", Get("m_37", "")));
		if ($this->m_37->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_37->AdvancedSearch->setSearchOperator(Get("z_m_37", ""));

		// 38
		if (!$this->isAddOrEdit())
			$this->_38->AdvancedSearch->setSearchValue(Get("x__38", Get("_38", "")));
		if ($this->_38->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_38->AdvancedSearch->setSearchOperator(Get("z__38", ""));

		// m_38
		if (!$this->isAddOrEdit())
			$this->m_38->AdvancedSearch->setSearchValue(Get("x_m_38", Get("m_38", "")));
		if ($this->m_38->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_38->AdvancedSearch->setSearchOperator(Get("z_m_38", ""));

		// 39
		if (!$this->isAddOrEdit())
			$this->_39->AdvancedSearch->setSearchValue(Get("x__39", Get("_39", "")));
		if ($this->_39->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_39->AdvancedSearch->setSearchOperator(Get("z__39", ""));

		// m_39
		if (!$this->isAddOrEdit())
			$this->m_39->AdvancedSearch->setSearchValue(Get("x_m_39", Get("m_39", "")));
		if ($this->m_39->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_39->AdvancedSearch->setSearchOperator(Get("z_m_39", ""));

		// 40
		if (!$this->isAddOrEdit())
			$this->_40->AdvancedSearch->setSearchValue(Get("x__40", Get("_40", "")));
		if ($this->_40->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_40->AdvancedSearch->setSearchOperator(Get("z__40", ""));

		// m_40
		if (!$this->isAddOrEdit())
			$this->m_40->AdvancedSearch->setSearchValue(Get("x_m_40", Get("m_40", "")));
		if ($this->m_40->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_40->AdvancedSearch->setSearchOperator(Get("z_m_40", ""));

		// 41
		if (!$this->isAddOrEdit())
			$this->_41->AdvancedSearch->setSearchValue(Get("x__41", Get("_41", "")));
		if ($this->_41->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_41->AdvancedSearch->setSearchOperator(Get("z__41", ""));

		// m_41
		if (!$this->isAddOrEdit())
			$this->m_41->AdvancedSearch->setSearchValue(Get("x_m_41", Get("m_41", "")));
		if ($this->m_41->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_41->AdvancedSearch->setSearchOperator(Get("z_m_41", ""));

		// 42
		if (!$this->isAddOrEdit())
			$this->_42->AdvancedSearch->setSearchValue(Get("x__42", Get("_42", "")));
		if ($this->_42->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_42->AdvancedSearch->setSearchOperator(Get("z__42", ""));

		// m_42
		if (!$this->isAddOrEdit())
			$this->m_42->AdvancedSearch->setSearchValue(Get("x_m_42", Get("m_42", "")));
		if ($this->m_42->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_42->AdvancedSearch->setSearchOperator(Get("z_m_42", ""));

		// 43
		if (!$this->isAddOrEdit())
			$this->_43->AdvancedSearch->setSearchValue(Get("x__43", Get("_43", "")));
		if ($this->_43->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_43->AdvancedSearch->setSearchOperator(Get("z__43", ""));

		// m_43
		if (!$this->isAddOrEdit())
			$this->m_43->AdvancedSearch->setSearchValue(Get("x_m_43", Get("m_43", "")));
		if ($this->m_43->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_43->AdvancedSearch->setSearchOperator(Get("z_m_43", ""));

		// 44
		if (!$this->isAddOrEdit())
			$this->_44->AdvancedSearch->setSearchValue(Get("x__44", Get("_44", "")));
		if ($this->_44->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_44->AdvancedSearch->setSearchOperator(Get("z__44", ""));

		// m_44
		if (!$this->isAddOrEdit())
			$this->m_44->AdvancedSearch->setSearchValue(Get("x_m_44", Get("m_44", "")));
		if ($this->m_44->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_44->AdvancedSearch->setSearchOperator(Get("z_m_44", ""));

		// 45
		if (!$this->isAddOrEdit())
			$this->_45->AdvancedSearch->setSearchValue(Get("x__45", Get("_45", "")));
		if ($this->_45->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_45->AdvancedSearch->setSearchOperator(Get("z__45", ""));

		// m_45
		if (!$this->isAddOrEdit())
			$this->m_45->AdvancedSearch->setSearchValue(Get("x_m_45", Get("m_45", "")));
		if ($this->m_45->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_45->AdvancedSearch->setSearchOperator(Get("z_m_45", ""));

		// 46
		if (!$this->isAddOrEdit())
			$this->_46->AdvancedSearch->setSearchValue(Get("x__46", Get("_46", "")));
		if ($this->_46->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_46->AdvancedSearch->setSearchOperator(Get("z__46", ""));

		// m_46
		if (!$this->isAddOrEdit())
			$this->m_46->AdvancedSearch->setSearchValue(Get("x_m_46", Get("m_46", "")));
		if ($this->m_46->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_46->AdvancedSearch->setSearchOperator(Get("z_m_46", ""));

		// 47
		if (!$this->isAddOrEdit())
			$this->_47->AdvancedSearch->setSearchValue(Get("x__47", Get("_47", "")));
		if ($this->_47->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_47->AdvancedSearch->setSearchOperator(Get("z__47", ""));

		// m_47
		if (!$this->isAddOrEdit())
			$this->m_47->AdvancedSearch->setSearchValue(Get("x_m_47", Get("m_47", "")));
		if ($this->m_47->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_47->AdvancedSearch->setSearchOperator(Get("z_m_47", ""));

		// 48
		if (!$this->isAddOrEdit())
			$this->_48->AdvancedSearch->setSearchValue(Get("x__48", Get("_48", "")));
		if ($this->_48->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_48->AdvancedSearch->setSearchOperator(Get("z__48", ""));

		// m_48
		if (!$this->isAddOrEdit())
			$this->m_48->AdvancedSearch->setSearchValue(Get("x_m_48", Get("m_48", "")));
		if ($this->m_48->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_48->AdvancedSearch->setSearchOperator(Get("z_m_48", ""));

		// 49
		if (!$this->isAddOrEdit())
			$this->_49->AdvancedSearch->setSearchValue(Get("x__49", Get("_49", "")));
		if ($this->_49->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_49->AdvancedSearch->setSearchOperator(Get("z__49", ""));

		// m_49
		if (!$this->isAddOrEdit())
			$this->m_49->AdvancedSearch->setSearchValue(Get("x_m_49", Get("m_49", "")));
		if ($this->m_49->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_49->AdvancedSearch->setSearchOperator(Get("z_m_49", ""));

		// 50
		if (!$this->isAddOrEdit())
			$this->_50->AdvancedSearch->setSearchValue(Get("x__50", Get("_50", "")));
		if ($this->_50->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_50->AdvancedSearch->setSearchOperator(Get("z__50", ""));

		// m_50
		if (!$this->isAddOrEdit())
			$this->m_50->AdvancedSearch->setSearchValue(Get("x_m_50", Get("m_50", "")));
		if ($this->m_50->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_50->AdvancedSearch->setSearchOperator(Get("z_m_50", ""));

		// 51
		if (!$this->isAddOrEdit())
			$this->_51->AdvancedSearch->setSearchValue(Get("x__51", Get("_51", "")));
		if ($this->_51->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_51->AdvancedSearch->setSearchOperator(Get("z__51", ""));

		// m_51
		if (!$this->isAddOrEdit())
			$this->m_51->AdvancedSearch->setSearchValue(Get("x_m_51", Get("m_51", "")));
		if ($this->m_51->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_51->AdvancedSearch->setSearchOperator(Get("z_m_51", ""));

		// 52
		if (!$this->isAddOrEdit())
			$this->_52->AdvancedSearch->setSearchValue(Get("x__52", Get("_52", "")));
		if ($this->_52->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_52->AdvancedSearch->setSearchOperator(Get("z__52", ""));

		// m_52
		if (!$this->isAddOrEdit())
			$this->m_52->AdvancedSearch->setSearchValue(Get("x_m_52", Get("m_52", "")));
		if ($this->m_52->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_52->AdvancedSearch->setSearchOperator(Get("z_m_52", ""));

		// 53
		if (!$this->isAddOrEdit())
			$this->_53->AdvancedSearch->setSearchValue(Get("x__53", Get("_53", "")));
		if ($this->_53->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_53->AdvancedSearch->setSearchOperator(Get("z__53", ""));

		// m_53
		if (!$this->isAddOrEdit())
			$this->m_53->AdvancedSearch->setSearchValue(Get("x_m_53", Get("m_53", "")));
		if ($this->m_53->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_53->AdvancedSearch->setSearchOperator(Get("z_m_53", ""));

		// 54
		if (!$this->isAddOrEdit())
			$this->_54->AdvancedSearch->setSearchValue(Get("x__54", Get("_54", "")));
		if ($this->_54->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_54->AdvancedSearch->setSearchOperator(Get("z__54", ""));

		// m_54
		if (!$this->isAddOrEdit())
			$this->m_54->AdvancedSearch->setSearchValue(Get("x_m_54", Get("m_54", "")));
		if ($this->m_54->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_54->AdvancedSearch->setSearchOperator(Get("z_m_54", ""));

		// 55
		if (!$this->isAddOrEdit())
			$this->_55->AdvancedSearch->setSearchValue(Get("x__55", Get("_55", "")));
		if ($this->_55->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_55->AdvancedSearch->setSearchOperator(Get("z__55", ""));

		// m_55
		if (!$this->isAddOrEdit())
			$this->m_55->AdvancedSearch->setSearchValue(Get("x_m_55", Get("m_55", "")));
		if ($this->m_55->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_55->AdvancedSearch->setSearchOperator(Get("z_m_55", ""));

		// 56
		if (!$this->isAddOrEdit())
			$this->_56->AdvancedSearch->setSearchValue(Get("x__56", Get("_56", "")));
		if ($this->_56->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_56->AdvancedSearch->setSearchOperator(Get("z__56", ""));

		// m_56
		if (!$this->isAddOrEdit())
			$this->m_56->AdvancedSearch->setSearchValue(Get("x_m_56", Get("m_56", "")));
		if ($this->m_56->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_56->AdvancedSearch->setSearchOperator(Get("z_m_56", ""));

		// 57
		if (!$this->isAddOrEdit())
			$this->_57->AdvancedSearch->setSearchValue(Get("x__57", Get("_57", "")));
		if ($this->_57->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_57->AdvancedSearch->setSearchOperator(Get("z__57", ""));

		// m_57
		if (!$this->isAddOrEdit())
			$this->m_57->AdvancedSearch->setSearchValue(Get("x_m_57", Get("m_57", "")));
		if ($this->m_57->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_57->AdvancedSearch->setSearchOperator(Get("z_m_57", ""));

		// 58
		if (!$this->isAddOrEdit())
			$this->_58->AdvancedSearch->setSearchValue(Get("x__58", Get("_58", "")));
		if ($this->_58->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_58->AdvancedSearch->setSearchOperator(Get("z__58", ""));

		// m_58
		if (!$this->isAddOrEdit())
			$this->m_58->AdvancedSearch->setSearchValue(Get("x_m_58", Get("m_58", "")));
		if ($this->m_58->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_58->AdvancedSearch->setSearchOperator(Get("z_m_58", ""));

		// 59
		if (!$this->isAddOrEdit())
			$this->_59->AdvancedSearch->setSearchValue(Get("x__59", Get("_59", "")));
		if ($this->_59->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_59->AdvancedSearch->setSearchOperator(Get("z__59", ""));

		// m_59
		if (!$this->isAddOrEdit())
			$this->m_59->AdvancedSearch->setSearchValue(Get("x_m_59", Get("m_59", "")));
		if ($this->m_59->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_59->AdvancedSearch->setSearchOperator(Get("z_m_59", ""));

		// 60
		if (!$this->isAddOrEdit())
			$this->_60->AdvancedSearch->setSearchValue(Get("x__60", Get("_60", "")));
		if ($this->_60->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_60->AdvancedSearch->setSearchOperator(Get("z__60", ""));

		// m_60
		if (!$this->isAddOrEdit())
			$this->m_60->AdvancedSearch->setSearchValue(Get("x_m_60", Get("m_60", "")));
		if ($this->m_60->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_60->AdvancedSearch->setSearchOperator(Get("z_m_60", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->roll_no->setDbValue($row['roll_no']);
		$this->test_id->setDbValue($row['test_id']);
		$this->total->setDbValue($row['total']);
		$this->percent->setDbValue($row['percent']);
		$this->s_1->setDbValue($row['s_1']);
		$this->s_2->setDbValue($row['s_2']);
		$this->s_3->setDbValue($row['s_3']);
		$this->s_4->setDbValue($row['s_4']);
		$this->s_5->setDbValue($row['s_5']);
		$this->omr_image->Upload->DbValue = $row['omr_image'];
		$this->omr_image->setDbValue($this->omr_image->Upload->DbValue);
		$this->_1->setDbValue($row['1']);
		$this->m_1->setDbValue($row['m_1']);
		$this->_2->setDbValue($row['2']);
		$this->m_2->setDbValue($row['m_2']);
		$this->_3->setDbValue($row['3']);
		$this->m_3->setDbValue($row['m_3']);
		$this->_4->setDbValue($row['4']);
		$this->m_4->setDbValue($row['m_4']);
		$this->_5->setDbValue($row['5']);
		$this->m_5->setDbValue($row['m_5']);
		$this->_6->setDbValue($row['6']);
		$this->m_6->setDbValue($row['m_6']);
		$this->_7->setDbValue($row['7']);
		$this->m_7->setDbValue($row['m_7']);
		$this->_8->setDbValue($row['8']);
		$this->m_8->setDbValue($row['m_8']);
		$this->_9->setDbValue($row['9']);
		$this->m_9->setDbValue($row['m_9']);
		$this->_10->setDbValue($row['10']);
		$this->m_10->setDbValue($row['m_10']);
		$this->_11->setDbValue($row['11']);
		$this->m_11->setDbValue($row['m_11']);
		$this->_12->setDbValue($row['12']);
		$this->m_12->setDbValue($row['m_12']);
		$this->_13->setDbValue($row['13']);
		$this->m_13->setDbValue($row['m_13']);
		$this->_14->setDbValue($row['14']);
		$this->m_14->setDbValue($row['m_14']);
		$this->_15->setDbValue($row['15']);
		$this->m_15->setDbValue($row['m_15']);
		$this->_16->setDbValue($row['16']);
		$this->m_16->setDbValue($row['m_16']);
		$this->_17->setDbValue($row['17']);
		$this->m_17->setDbValue($row['m_17']);
		$this->_18->setDbValue($row['18']);
		$this->m_18->setDbValue($row['m_18']);
		$this->_19->setDbValue($row['19']);
		$this->m_19->setDbValue($row['m_19']);
		$this->_20->setDbValue($row['20']);
		$this->m_20->setDbValue($row['m_20']);
		$this->_21->setDbValue($row['21']);
		$this->m_21->setDbValue($row['m_21']);
		$this->_22->setDbValue($row['22']);
		$this->m_22->setDbValue($row['m_22']);
		$this->_23->setDbValue($row['23']);
		$this->m_23->setDbValue($row['m_23']);
		$this->_24->setDbValue($row['24']);
		$this->m_24->setDbValue($row['m_24']);
		$this->_25->setDbValue($row['25']);
		$this->m_25->setDbValue($row['m_25']);
		$this->_26->setDbValue($row['26']);
		$this->m_26->setDbValue($row['m_26']);
		$this->_27->setDbValue($row['27']);
		$this->m_27->setDbValue($row['m_27']);
		$this->_28->setDbValue($row['28']);
		$this->m_28->setDbValue($row['m_28']);
		$this->_29->setDbValue($row['29']);
		$this->m_29->setDbValue($row['m_29']);
		$this->_30->setDbValue($row['30']);
		$this->m_30->setDbValue($row['m_30']);
		$this->_31->setDbValue($row['31']);
		$this->m_31->setDbValue($row['m_31']);
		$this->_32->setDbValue($row['32']);
		$this->m_32->setDbValue($row['m_32']);
		$this->_33->setDbValue($row['33']);
		$this->m_33->setDbValue($row['m_33']);
		$this->_34->setDbValue($row['34']);
		$this->m_34->setDbValue($row['m_34']);
		$this->_35->setDbValue($row['35']);
		$this->m_35->setDbValue($row['m_35']);
		$this->_36->setDbValue($row['36']);
		$this->m_36->setDbValue($row['m_36']);
		$this->_37->setDbValue($row['37']);
		$this->m_37->setDbValue($row['m_37']);
		$this->_38->setDbValue($row['38']);
		$this->m_38->setDbValue($row['m_38']);
		$this->_39->setDbValue($row['39']);
		$this->m_39->setDbValue($row['m_39']);
		$this->_40->setDbValue($row['40']);
		$this->m_40->setDbValue($row['m_40']);
		$this->_41->setDbValue($row['41']);
		$this->m_41->setDbValue($row['m_41']);
		$this->_42->setDbValue($row['42']);
		$this->m_42->setDbValue($row['m_42']);
		$this->_43->setDbValue($row['43']);
		$this->m_43->setDbValue($row['m_43']);
		$this->_44->setDbValue($row['44']);
		$this->m_44->setDbValue($row['m_44']);
		$this->_45->setDbValue($row['45']);
		$this->m_45->setDbValue($row['m_45']);
		$this->_46->setDbValue($row['46']);
		$this->m_46->setDbValue($row['m_46']);
		$this->_47->setDbValue($row['47']);
		$this->m_47->setDbValue($row['m_47']);
		$this->_48->setDbValue($row['48']);
		$this->m_48->setDbValue($row['m_48']);
		$this->_49->setDbValue($row['49']);
		$this->m_49->setDbValue($row['m_49']);
		$this->_50->setDbValue($row['50']);
		$this->m_50->setDbValue($row['m_50']);
		$this->_51->setDbValue($row['51']);
		$this->m_51->setDbValue($row['m_51']);
		$this->_52->setDbValue($row['52']);
		$this->m_52->setDbValue($row['m_52']);
		$this->_53->setDbValue($row['53']);
		$this->m_53->setDbValue($row['m_53']);
		$this->_54->setDbValue($row['54']);
		$this->m_54->setDbValue($row['m_54']);
		$this->_55->setDbValue($row['55']);
		$this->m_55->setDbValue($row['m_55']);
		$this->_56->setDbValue($row['56']);
		$this->m_56->setDbValue($row['m_56']);
		$this->_57->setDbValue($row['57']);
		$this->m_57->setDbValue($row['m_57']);
		$this->_58->setDbValue($row['58']);
		$this->m_58->setDbValue($row['m_58']);
		$this->_59->setDbValue($row['59']);
		$this->m_59->setDbValue($row['m_59']);
		$this->_60->setDbValue($row['60']);
		$this->m_60->setDbValue($row['m_60']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['roll_no'] = NULL;
		$row['test_id'] = NULL;
		$row['total'] = NULL;
		$row['percent'] = NULL;
		$row['s_1'] = NULL;
		$row['s_2'] = NULL;
		$row['s_3'] = NULL;
		$row['s_4'] = NULL;
		$row['s_5'] = NULL;
		$row['omr_image'] = NULL;
		$row['1'] = NULL;
		$row['m_1'] = NULL;
		$row['2'] = NULL;
		$row['m_2'] = NULL;
		$row['3'] = NULL;
		$row['m_3'] = NULL;
		$row['4'] = NULL;
		$row['m_4'] = NULL;
		$row['5'] = NULL;
		$row['m_5'] = NULL;
		$row['6'] = NULL;
		$row['m_6'] = NULL;
		$row['7'] = NULL;
		$row['m_7'] = NULL;
		$row['8'] = NULL;
		$row['m_8'] = NULL;
		$row['9'] = NULL;
		$row['m_9'] = NULL;
		$row['10'] = NULL;
		$row['m_10'] = NULL;
		$row['11'] = NULL;
		$row['m_11'] = NULL;
		$row['12'] = NULL;
		$row['m_12'] = NULL;
		$row['13'] = NULL;
		$row['m_13'] = NULL;
		$row['14'] = NULL;
		$row['m_14'] = NULL;
		$row['15'] = NULL;
		$row['m_15'] = NULL;
		$row['16'] = NULL;
		$row['m_16'] = NULL;
		$row['17'] = NULL;
		$row['m_17'] = NULL;
		$row['18'] = NULL;
		$row['m_18'] = NULL;
		$row['19'] = NULL;
		$row['m_19'] = NULL;
		$row['20'] = NULL;
		$row['m_20'] = NULL;
		$row['21'] = NULL;
		$row['m_21'] = NULL;
		$row['22'] = NULL;
		$row['m_22'] = NULL;
		$row['23'] = NULL;
		$row['m_23'] = NULL;
		$row['24'] = NULL;
		$row['m_24'] = NULL;
		$row['25'] = NULL;
		$row['m_25'] = NULL;
		$row['26'] = NULL;
		$row['m_26'] = NULL;
		$row['27'] = NULL;
		$row['m_27'] = NULL;
		$row['28'] = NULL;
		$row['m_28'] = NULL;
		$row['29'] = NULL;
		$row['m_29'] = NULL;
		$row['30'] = NULL;
		$row['m_30'] = NULL;
		$row['31'] = NULL;
		$row['m_31'] = NULL;
		$row['32'] = NULL;
		$row['m_32'] = NULL;
		$row['33'] = NULL;
		$row['m_33'] = NULL;
		$row['34'] = NULL;
		$row['m_34'] = NULL;
		$row['35'] = NULL;
		$row['m_35'] = NULL;
		$row['36'] = NULL;
		$row['m_36'] = NULL;
		$row['37'] = NULL;
		$row['m_37'] = NULL;
		$row['38'] = NULL;
		$row['m_38'] = NULL;
		$row['39'] = NULL;
		$row['m_39'] = NULL;
		$row['40'] = NULL;
		$row['m_40'] = NULL;
		$row['41'] = NULL;
		$row['m_41'] = NULL;
		$row['42'] = NULL;
		$row['m_42'] = NULL;
		$row['43'] = NULL;
		$row['m_43'] = NULL;
		$row['44'] = NULL;
		$row['m_44'] = NULL;
		$row['45'] = NULL;
		$row['m_45'] = NULL;
		$row['46'] = NULL;
		$row['m_46'] = NULL;
		$row['47'] = NULL;
		$row['m_47'] = NULL;
		$row['48'] = NULL;
		$row['m_48'] = NULL;
		$row['49'] = NULL;
		$row['m_49'] = NULL;
		$row['50'] = NULL;
		$row['m_50'] = NULL;
		$row['51'] = NULL;
		$row['m_51'] = NULL;
		$row['52'] = NULL;
		$row['m_52'] = NULL;
		$row['53'] = NULL;
		$row['m_53'] = NULL;
		$row['54'] = NULL;
		$row['m_54'] = NULL;
		$row['55'] = NULL;
		$row['m_55'] = NULL;
		$row['56'] = NULL;
		$row['m_56'] = NULL;
		$row['57'] = NULL;
		$row['m_57'] = NULL;
		$row['58'] = NULL;
		$row['m_58'] = NULL;
		$row['59'] = NULL;
		$row['m_59'] = NULL;
		$row['60'] = NULL;
		$row['m_60'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->total->FormValue == $this->total->CurrentValue && is_numeric(ConvertToFloatString($this->total->CurrentValue)))
			$this->total->CurrentValue = ConvertToFloatString($this->total->CurrentValue);

		// Convert decimal values if posted back
		if ($this->percent->FormValue == $this->percent->CurrentValue && is_numeric(ConvertToFloatString($this->percent->CurrentValue)))
			$this->percent->CurrentValue = ConvertToFloatString($this->percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_1->FormValue == $this->s_1->CurrentValue && is_numeric(ConvertToFloatString($this->s_1->CurrentValue)))
			$this->s_1->CurrentValue = ConvertToFloatString($this->s_1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_2->FormValue == $this->s_2->CurrentValue && is_numeric(ConvertToFloatString($this->s_2->CurrentValue)))
			$this->s_2->CurrentValue = ConvertToFloatString($this->s_2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_3->FormValue == $this->s_3->CurrentValue && is_numeric(ConvertToFloatString($this->s_3->CurrentValue)))
			$this->s_3->CurrentValue = ConvertToFloatString($this->s_3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_4->FormValue == $this->s_4->CurrentValue && is_numeric(ConvertToFloatString($this->s_4->CurrentValue)))
			$this->s_4->CurrentValue = ConvertToFloatString($this->s_4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_5->FormValue == $this->s_5->CurrentValue && is_numeric(ConvertToFloatString($this->s_5->CurrentValue)))
			$this->s_5->CurrentValue = ConvertToFloatString($this->s_5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_1->FormValue == $this->m_1->CurrentValue && is_numeric(ConvertToFloatString($this->m_1->CurrentValue)))
			$this->m_1->CurrentValue = ConvertToFloatString($this->m_1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_2->FormValue == $this->m_2->CurrentValue && is_numeric(ConvertToFloatString($this->m_2->CurrentValue)))
			$this->m_2->CurrentValue = ConvertToFloatString($this->m_2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_3->FormValue == $this->m_3->CurrentValue && is_numeric(ConvertToFloatString($this->m_3->CurrentValue)))
			$this->m_3->CurrentValue = ConvertToFloatString($this->m_3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_4->FormValue == $this->m_4->CurrentValue && is_numeric(ConvertToFloatString($this->m_4->CurrentValue)))
			$this->m_4->CurrentValue = ConvertToFloatString($this->m_4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_5->FormValue == $this->m_5->CurrentValue && is_numeric(ConvertToFloatString($this->m_5->CurrentValue)))
			$this->m_5->CurrentValue = ConvertToFloatString($this->m_5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_6->FormValue == $this->m_6->CurrentValue && is_numeric(ConvertToFloatString($this->m_6->CurrentValue)))
			$this->m_6->CurrentValue = ConvertToFloatString($this->m_6->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_7->FormValue == $this->m_7->CurrentValue && is_numeric(ConvertToFloatString($this->m_7->CurrentValue)))
			$this->m_7->CurrentValue = ConvertToFloatString($this->m_7->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_8->FormValue == $this->m_8->CurrentValue && is_numeric(ConvertToFloatString($this->m_8->CurrentValue)))
			$this->m_8->CurrentValue = ConvertToFloatString($this->m_8->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_9->FormValue == $this->m_9->CurrentValue && is_numeric(ConvertToFloatString($this->m_9->CurrentValue)))
			$this->m_9->CurrentValue = ConvertToFloatString($this->m_9->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_10->FormValue == $this->m_10->CurrentValue && is_numeric(ConvertToFloatString($this->m_10->CurrentValue)))
			$this->m_10->CurrentValue = ConvertToFloatString($this->m_10->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_11->FormValue == $this->m_11->CurrentValue && is_numeric(ConvertToFloatString($this->m_11->CurrentValue)))
			$this->m_11->CurrentValue = ConvertToFloatString($this->m_11->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_12->FormValue == $this->m_12->CurrentValue && is_numeric(ConvertToFloatString($this->m_12->CurrentValue)))
			$this->m_12->CurrentValue = ConvertToFloatString($this->m_12->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_13->FormValue == $this->m_13->CurrentValue && is_numeric(ConvertToFloatString($this->m_13->CurrentValue)))
			$this->m_13->CurrentValue = ConvertToFloatString($this->m_13->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_14->FormValue == $this->m_14->CurrentValue && is_numeric(ConvertToFloatString($this->m_14->CurrentValue)))
			$this->m_14->CurrentValue = ConvertToFloatString($this->m_14->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_15->FormValue == $this->m_15->CurrentValue && is_numeric(ConvertToFloatString($this->m_15->CurrentValue)))
			$this->m_15->CurrentValue = ConvertToFloatString($this->m_15->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_16->FormValue == $this->m_16->CurrentValue && is_numeric(ConvertToFloatString($this->m_16->CurrentValue)))
			$this->m_16->CurrentValue = ConvertToFloatString($this->m_16->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_17->FormValue == $this->m_17->CurrentValue && is_numeric(ConvertToFloatString($this->m_17->CurrentValue)))
			$this->m_17->CurrentValue = ConvertToFloatString($this->m_17->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_18->FormValue == $this->m_18->CurrentValue && is_numeric(ConvertToFloatString($this->m_18->CurrentValue)))
			$this->m_18->CurrentValue = ConvertToFloatString($this->m_18->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_19->FormValue == $this->m_19->CurrentValue && is_numeric(ConvertToFloatString($this->m_19->CurrentValue)))
			$this->m_19->CurrentValue = ConvertToFloatString($this->m_19->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_20->FormValue == $this->m_20->CurrentValue && is_numeric(ConvertToFloatString($this->m_20->CurrentValue)))
			$this->m_20->CurrentValue = ConvertToFloatString($this->m_20->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_21->FormValue == $this->m_21->CurrentValue && is_numeric(ConvertToFloatString($this->m_21->CurrentValue)))
			$this->m_21->CurrentValue = ConvertToFloatString($this->m_21->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_22->FormValue == $this->m_22->CurrentValue && is_numeric(ConvertToFloatString($this->m_22->CurrentValue)))
			$this->m_22->CurrentValue = ConvertToFloatString($this->m_22->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_23->FormValue == $this->m_23->CurrentValue && is_numeric(ConvertToFloatString($this->m_23->CurrentValue)))
			$this->m_23->CurrentValue = ConvertToFloatString($this->m_23->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_24->FormValue == $this->m_24->CurrentValue && is_numeric(ConvertToFloatString($this->m_24->CurrentValue)))
			$this->m_24->CurrentValue = ConvertToFloatString($this->m_24->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_25->FormValue == $this->m_25->CurrentValue && is_numeric(ConvertToFloatString($this->m_25->CurrentValue)))
			$this->m_25->CurrentValue = ConvertToFloatString($this->m_25->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_26->FormValue == $this->m_26->CurrentValue && is_numeric(ConvertToFloatString($this->m_26->CurrentValue)))
			$this->m_26->CurrentValue = ConvertToFloatString($this->m_26->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_27->FormValue == $this->m_27->CurrentValue && is_numeric(ConvertToFloatString($this->m_27->CurrentValue)))
			$this->m_27->CurrentValue = ConvertToFloatString($this->m_27->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_28->FormValue == $this->m_28->CurrentValue && is_numeric(ConvertToFloatString($this->m_28->CurrentValue)))
			$this->m_28->CurrentValue = ConvertToFloatString($this->m_28->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_29->FormValue == $this->m_29->CurrentValue && is_numeric(ConvertToFloatString($this->m_29->CurrentValue)))
			$this->m_29->CurrentValue = ConvertToFloatString($this->m_29->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_30->FormValue == $this->m_30->CurrentValue && is_numeric(ConvertToFloatString($this->m_30->CurrentValue)))
			$this->m_30->CurrentValue = ConvertToFloatString($this->m_30->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_31->FormValue == $this->m_31->CurrentValue && is_numeric(ConvertToFloatString($this->m_31->CurrentValue)))
			$this->m_31->CurrentValue = ConvertToFloatString($this->m_31->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_32->FormValue == $this->m_32->CurrentValue && is_numeric(ConvertToFloatString($this->m_32->CurrentValue)))
			$this->m_32->CurrentValue = ConvertToFloatString($this->m_32->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_33->FormValue == $this->m_33->CurrentValue && is_numeric(ConvertToFloatString($this->m_33->CurrentValue)))
			$this->m_33->CurrentValue = ConvertToFloatString($this->m_33->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_34->FormValue == $this->m_34->CurrentValue && is_numeric(ConvertToFloatString($this->m_34->CurrentValue)))
			$this->m_34->CurrentValue = ConvertToFloatString($this->m_34->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_35->FormValue == $this->m_35->CurrentValue && is_numeric(ConvertToFloatString($this->m_35->CurrentValue)))
			$this->m_35->CurrentValue = ConvertToFloatString($this->m_35->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_36->FormValue == $this->m_36->CurrentValue && is_numeric(ConvertToFloatString($this->m_36->CurrentValue)))
			$this->m_36->CurrentValue = ConvertToFloatString($this->m_36->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_37->FormValue == $this->m_37->CurrentValue && is_numeric(ConvertToFloatString($this->m_37->CurrentValue)))
			$this->m_37->CurrentValue = ConvertToFloatString($this->m_37->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_38->FormValue == $this->m_38->CurrentValue && is_numeric(ConvertToFloatString($this->m_38->CurrentValue)))
			$this->m_38->CurrentValue = ConvertToFloatString($this->m_38->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_39->FormValue == $this->m_39->CurrentValue && is_numeric(ConvertToFloatString($this->m_39->CurrentValue)))
			$this->m_39->CurrentValue = ConvertToFloatString($this->m_39->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_40->FormValue == $this->m_40->CurrentValue && is_numeric(ConvertToFloatString($this->m_40->CurrentValue)))
			$this->m_40->CurrentValue = ConvertToFloatString($this->m_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_41->FormValue == $this->m_41->CurrentValue && is_numeric(ConvertToFloatString($this->m_41->CurrentValue)))
			$this->m_41->CurrentValue = ConvertToFloatString($this->m_41->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_42->FormValue == $this->m_42->CurrentValue && is_numeric(ConvertToFloatString($this->m_42->CurrentValue)))
			$this->m_42->CurrentValue = ConvertToFloatString($this->m_42->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_43->FormValue == $this->m_43->CurrentValue && is_numeric(ConvertToFloatString($this->m_43->CurrentValue)))
			$this->m_43->CurrentValue = ConvertToFloatString($this->m_43->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_44->FormValue == $this->m_44->CurrentValue && is_numeric(ConvertToFloatString($this->m_44->CurrentValue)))
			$this->m_44->CurrentValue = ConvertToFloatString($this->m_44->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_45->FormValue == $this->m_45->CurrentValue && is_numeric(ConvertToFloatString($this->m_45->CurrentValue)))
			$this->m_45->CurrentValue = ConvertToFloatString($this->m_45->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_46->FormValue == $this->m_46->CurrentValue && is_numeric(ConvertToFloatString($this->m_46->CurrentValue)))
			$this->m_46->CurrentValue = ConvertToFloatString($this->m_46->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_47->FormValue == $this->m_47->CurrentValue && is_numeric(ConvertToFloatString($this->m_47->CurrentValue)))
			$this->m_47->CurrentValue = ConvertToFloatString($this->m_47->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_48->FormValue == $this->m_48->CurrentValue && is_numeric(ConvertToFloatString($this->m_48->CurrentValue)))
			$this->m_48->CurrentValue = ConvertToFloatString($this->m_48->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_49->FormValue == $this->m_49->CurrentValue && is_numeric(ConvertToFloatString($this->m_49->CurrentValue)))
			$this->m_49->CurrentValue = ConvertToFloatString($this->m_49->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_50->FormValue == $this->m_50->CurrentValue && is_numeric(ConvertToFloatString($this->m_50->CurrentValue)))
			$this->m_50->CurrentValue = ConvertToFloatString($this->m_50->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_51->FormValue == $this->m_51->CurrentValue && is_numeric(ConvertToFloatString($this->m_51->CurrentValue)))
			$this->m_51->CurrentValue = ConvertToFloatString($this->m_51->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_52->FormValue == $this->m_52->CurrentValue && is_numeric(ConvertToFloatString($this->m_52->CurrentValue)))
			$this->m_52->CurrentValue = ConvertToFloatString($this->m_52->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_53->FormValue == $this->m_53->CurrentValue && is_numeric(ConvertToFloatString($this->m_53->CurrentValue)))
			$this->m_53->CurrentValue = ConvertToFloatString($this->m_53->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_54->FormValue == $this->m_54->CurrentValue && is_numeric(ConvertToFloatString($this->m_54->CurrentValue)))
			$this->m_54->CurrentValue = ConvertToFloatString($this->m_54->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_55->FormValue == $this->m_55->CurrentValue && is_numeric(ConvertToFloatString($this->m_55->CurrentValue)))
			$this->m_55->CurrentValue = ConvertToFloatString($this->m_55->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_56->FormValue == $this->m_56->CurrentValue && is_numeric(ConvertToFloatString($this->m_56->CurrentValue)))
			$this->m_56->CurrentValue = ConvertToFloatString($this->m_56->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_57->FormValue == $this->m_57->CurrentValue && is_numeric(ConvertToFloatString($this->m_57->CurrentValue)))
			$this->m_57->CurrentValue = ConvertToFloatString($this->m_57->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_58->FormValue == $this->m_58->CurrentValue && is_numeric(ConvertToFloatString($this->m_58->CurrentValue)))
			$this->m_58->CurrentValue = ConvertToFloatString($this->m_58->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_59->FormValue == $this->m_59->CurrentValue && is_numeric(ConvertToFloatString($this->m_59->CurrentValue)))
			$this->m_59->CurrentValue = ConvertToFloatString($this->m_59->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_60->FormValue == $this->m_60->CurrentValue && is_numeric(ConvertToFloatString($this->m_60->CurrentValue)))
			$this->m_60->CurrentValue = ConvertToFloatString($this->m_60->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// roll_no
		// test_id
		// total
		// percent
		// s_1
		// s_2
		// s_3
		// s_4
		// s_5
		// omr_image
		// 1
		// m_1
		// 2
		// m_2
		// 3
		// m_3
		// 4
		// m_4
		// 5
		// m_5
		// 6
		// m_6
		// 7
		// m_7
		// 8
		// m_8
		// 9
		// m_9
		// 10
		// m_10
		// 11
		// m_11
		// 12
		// m_12
		// 13
		// m_13
		// 14
		// m_14
		// 15
		// m_15
		// 16
		// m_16
		// 17
		// m_17
		// 18
		// m_18
		// 19
		// m_19
		// 20
		// m_20
		// 21
		// m_21
		// 22
		// m_22
		// 23
		// m_23
		// 24
		// m_24
		// 25
		// m_25
		// 26
		// m_26
		// 27
		// m_27
		// 28
		// m_28
		// 29
		// m_29
		// 30
		// m_30
		// 31
		// m_31
		// 32
		// m_32
		// 33
		// m_33
		// 34
		// m_34
		// 35
		// m_35
		// 36
		// m_36
		// 37
		// m_37
		// 38
		// m_38
		// 39
		// m_39
		// 40
		// m_40
		// 41
		// m_41
		// 42
		// m_42
		// 43
		// m_43
		// 44
		// m_44
		// 45
		// m_45
		// 46
		// m_46
		// 47
		// m_47
		// 48
		// m_48
		// 49
		// m_49
		// 50
		// m_50
		// 51
		// m_51
		// 52
		// m_52
		// 53
		// m_53
		// 54
		// m_54
		// 55
		// m_55
		// 56
		// m_56
		// 57
		// m_57
		// 58
		// m_58
		// 59
		// m_59
		// 60
		// m_60

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewCustomAttributes = "";

			// test_id
			$this->test_id->ViewValue = $this->test_id->CurrentValue;
			$this->test_id->ViewCustomAttributes = "";

			// total
			$this->total->ViewValue = $this->total->CurrentValue;
			$this->total->ViewValue = FormatNumber($this->total->ViewValue, 2, -2, -2, -2);
			$this->total->ViewCustomAttributes = "";

			// percent
			$this->percent->ViewValue = $this->percent->CurrentValue;
			$this->percent->ViewValue = FormatNumber($this->percent->ViewValue, 2, -2, -2, -2);
			$this->percent->ViewCustomAttributes = "";

			// s_1
			$this->s_1->ViewValue = $this->s_1->CurrentValue;
			$this->s_1->ViewValue = FormatNumber($this->s_1->ViewValue, 2, -2, -2, -2);
			$this->s_1->ViewCustomAttributes = "";

			// s_2
			$this->s_2->ViewValue = $this->s_2->CurrentValue;
			$this->s_2->ViewValue = FormatNumber($this->s_2->ViewValue, 2, -2, -2, -2);
			$this->s_2->ViewCustomAttributes = "";

			// s_3
			$this->s_3->ViewValue = $this->s_3->CurrentValue;
			$this->s_3->ViewValue = FormatNumber($this->s_3->ViewValue, 2, -2, -2, -2);
			$this->s_3->ViewCustomAttributes = "";

			// s_4
			$this->s_4->ViewValue = $this->s_4->CurrentValue;
			$this->s_4->ViewValue = FormatNumber($this->s_4->ViewValue, 2, -2, -2, -2);
			$this->s_4->ViewCustomAttributes = "";

			// s_5
			$this->s_5->ViewValue = $this->s_5->CurrentValue;
			$this->s_5->ViewValue = FormatNumber($this->s_5->ViewValue, 2, -2, -2, -2);
			$this->s_5->ViewCustomAttributes = "";

			// omr_image
			$this->omr_image->UploadPath = '.p_uploads/school/omr/';
			if (!EmptyValue($this->omr_image->Upload->DbValue)) {
				$this->omr_image->ImageWidth = 0;
				$this->omr_image->ImageHeight = 50;
				$this->omr_image->ImageAlt = $this->omr_image->alt();
				$this->omr_image->ViewValue = $this->omr_image->Upload->DbValue;
			} else {
				$this->omr_image->ViewValue = "";
			}
			$this->omr_image->ViewCustomAttributes = "";

			// 1
			$this->_1->ViewValue = $this->_1->CurrentValue;
			$this->_1->ViewCustomAttributes = "";

			// m_1
			$this->m_1->ViewValue = $this->m_1->CurrentValue;
			$this->m_1->ViewValue = FormatNumber($this->m_1->ViewValue, 2, -2, -2, -2);
			$this->m_1->ViewCustomAttributes = "";

			// 2
			$this->_2->ViewValue = $this->_2->CurrentValue;
			$this->_2->ViewCustomAttributes = "";

			// m_2
			$this->m_2->ViewValue = $this->m_2->CurrentValue;
			$this->m_2->ViewValue = FormatNumber($this->m_2->ViewValue, 2, -2, -2, -2);
			$this->m_2->ViewCustomAttributes = "";

			// 3
			$this->_3->ViewValue = $this->_3->CurrentValue;
			$this->_3->ViewCustomAttributes = "";

			// m_3
			$this->m_3->ViewValue = $this->m_3->CurrentValue;
			$this->m_3->ViewValue = FormatNumber($this->m_3->ViewValue, 2, -2, -2, -2);
			$this->m_3->ViewCustomAttributes = "";

			// 4
			$this->_4->ViewValue = $this->_4->CurrentValue;
			$this->_4->ViewCustomAttributes = "";

			// m_4
			$this->m_4->ViewValue = $this->m_4->CurrentValue;
			$this->m_4->ViewValue = FormatNumber($this->m_4->ViewValue, 2, -2, -2, -2);
			$this->m_4->ViewCustomAttributes = "";

			// 5
			$this->_5->ViewValue = $this->_5->CurrentValue;
			$this->_5->ViewCustomAttributes = "";

			// m_5
			$this->m_5->ViewValue = $this->m_5->CurrentValue;
			$this->m_5->ViewValue = FormatNumber($this->m_5->ViewValue, 2, -2, -2, -2);
			$this->m_5->ViewCustomAttributes = "";

			// 6
			$this->_6->ViewValue = $this->_6->CurrentValue;
			$this->_6->ViewCustomAttributes = "";

			// m_6
			$this->m_6->ViewValue = $this->m_6->CurrentValue;
			$this->m_6->ViewValue = FormatNumber($this->m_6->ViewValue, 2, -2, -2, -2);
			$this->m_6->ViewCustomAttributes = "";

			// 7
			$this->_7->ViewValue = $this->_7->CurrentValue;
			$this->_7->ViewCustomAttributes = "";

			// m_7
			$this->m_7->ViewValue = $this->m_7->CurrentValue;
			$this->m_7->ViewValue = FormatNumber($this->m_7->ViewValue, 2, -2, -2, -2);
			$this->m_7->ViewCustomAttributes = "";

			// 8
			$this->_8->ViewValue = $this->_8->CurrentValue;
			$this->_8->ViewCustomAttributes = "";

			// m_8
			$this->m_8->ViewValue = $this->m_8->CurrentValue;
			$this->m_8->ViewValue = FormatNumber($this->m_8->ViewValue, 2, -2, -2, -2);
			$this->m_8->ViewCustomAttributes = "";

			// 9
			$this->_9->ViewValue = $this->_9->CurrentValue;
			$this->_9->ViewCustomAttributes = "";

			// m_9
			$this->m_9->ViewValue = $this->m_9->CurrentValue;
			$this->m_9->ViewValue = FormatNumber($this->m_9->ViewValue, 2, -2, -2, -2);
			$this->m_9->ViewCustomAttributes = "";

			// 10
			$this->_10->ViewValue = $this->_10->CurrentValue;
			$this->_10->ViewCustomAttributes = "";

			// m_10
			$this->m_10->ViewValue = $this->m_10->CurrentValue;
			$this->m_10->ViewValue = FormatNumber($this->m_10->ViewValue, 2, -2, -2, -2);
			$this->m_10->ViewCustomAttributes = "";

			// 11
			$this->_11->ViewValue = $this->_11->CurrentValue;
			$this->_11->ViewCustomAttributes = "";

			// m_11
			$this->m_11->ViewValue = $this->m_11->CurrentValue;
			$this->m_11->ViewValue = FormatNumber($this->m_11->ViewValue, 2, -2, -2, -2);
			$this->m_11->ViewCustomAttributes = "";

			// 12
			$this->_12->ViewValue = $this->_12->CurrentValue;
			$this->_12->ViewCustomAttributes = "";

			// m_12
			$this->m_12->ViewValue = $this->m_12->CurrentValue;
			$this->m_12->ViewValue = FormatNumber($this->m_12->ViewValue, 2, -2, -2, -2);
			$this->m_12->ViewCustomAttributes = "";

			// 13
			$this->_13->ViewValue = $this->_13->CurrentValue;
			$this->_13->ViewCustomAttributes = "";

			// m_13
			$this->m_13->ViewValue = $this->m_13->CurrentValue;
			$this->m_13->ViewValue = FormatNumber($this->m_13->ViewValue, 2, -2, -2, -2);
			$this->m_13->ViewCustomAttributes = "";

			// 14
			$this->_14->ViewValue = $this->_14->CurrentValue;
			$this->_14->ViewCustomAttributes = "";

			// m_14
			$this->m_14->ViewValue = $this->m_14->CurrentValue;
			$this->m_14->ViewValue = FormatNumber($this->m_14->ViewValue, 2, -2, -2, -2);
			$this->m_14->ViewCustomAttributes = "";

			// 15
			$this->_15->ViewValue = $this->_15->CurrentValue;
			$this->_15->ViewCustomAttributes = "";

			// m_15
			$this->m_15->ViewValue = $this->m_15->CurrentValue;
			$this->m_15->ViewValue = FormatNumber($this->m_15->ViewValue, 2, -2, -2, -2);
			$this->m_15->ViewCustomAttributes = "";

			// 16
			$this->_16->ViewValue = $this->_16->CurrentValue;
			$this->_16->ViewCustomAttributes = "";

			// m_16
			$this->m_16->ViewValue = $this->m_16->CurrentValue;
			$this->m_16->ViewValue = FormatNumber($this->m_16->ViewValue, 2, -2, -2, -2);
			$this->m_16->ViewCustomAttributes = "";

			// 17
			$this->_17->ViewValue = $this->_17->CurrentValue;
			$this->_17->ViewCustomAttributes = "";

			// m_17
			$this->m_17->ViewValue = $this->m_17->CurrentValue;
			$this->m_17->ViewValue = FormatNumber($this->m_17->ViewValue, 2, -2, -2, -2);
			$this->m_17->ViewCustomAttributes = "";

			// 18
			$this->_18->ViewValue = $this->_18->CurrentValue;
			$this->_18->ViewCustomAttributes = "";

			// m_18
			$this->m_18->ViewValue = $this->m_18->CurrentValue;
			$this->m_18->ViewValue = FormatNumber($this->m_18->ViewValue, 2, -2, -2, -2);
			$this->m_18->ViewCustomAttributes = "";

			// 19
			$this->_19->ViewValue = $this->_19->CurrentValue;
			$this->_19->ViewCustomAttributes = "";

			// m_19
			$this->m_19->ViewValue = $this->m_19->CurrentValue;
			$this->m_19->ViewValue = FormatNumber($this->m_19->ViewValue, 2, -2, -2, -2);
			$this->m_19->ViewCustomAttributes = "";

			// 20
			$this->_20->ViewValue = $this->_20->CurrentValue;
			$this->_20->ViewCustomAttributes = "";

			// m_20
			$this->m_20->ViewValue = $this->m_20->CurrentValue;
			$this->m_20->ViewValue = FormatNumber($this->m_20->ViewValue, 2, -2, -2, -2);
			$this->m_20->ViewCustomAttributes = "";

			// 21
			$this->_21->ViewValue = $this->_21->CurrentValue;
			$this->_21->ViewCustomAttributes = "";

			// m_21
			$this->m_21->ViewValue = $this->m_21->CurrentValue;
			$this->m_21->ViewValue = FormatNumber($this->m_21->ViewValue, 2, -2, -2, -2);
			$this->m_21->ViewCustomAttributes = "";

			// 22
			$this->_22->ViewValue = $this->_22->CurrentValue;
			$this->_22->ViewCustomAttributes = "";

			// m_22
			$this->m_22->ViewValue = $this->m_22->CurrentValue;
			$this->m_22->ViewValue = FormatNumber($this->m_22->ViewValue, 2, -2, -2, -2);
			$this->m_22->ViewCustomAttributes = "";

			// 23
			$this->_23->ViewValue = $this->_23->CurrentValue;
			$this->_23->ViewCustomAttributes = "";

			// m_23
			$this->m_23->ViewValue = $this->m_23->CurrentValue;
			$this->m_23->ViewValue = FormatNumber($this->m_23->ViewValue, 2, -2, -2, -2);
			$this->m_23->ViewCustomAttributes = "";

			// 24
			$this->_24->ViewValue = $this->_24->CurrentValue;
			$this->_24->ViewCustomAttributes = "";

			// m_24
			$this->m_24->ViewValue = $this->m_24->CurrentValue;
			$this->m_24->ViewValue = FormatNumber($this->m_24->ViewValue, 2, -2, -2, -2);
			$this->m_24->ViewCustomAttributes = "";

			// 25
			$this->_25->ViewValue = $this->_25->CurrentValue;
			$this->_25->ViewCustomAttributes = "";

			// m_25
			$this->m_25->ViewValue = $this->m_25->CurrentValue;
			$this->m_25->ViewValue = FormatNumber($this->m_25->ViewValue, 2, -2, -2, -2);
			$this->m_25->ViewCustomAttributes = "";

			// 26
			$this->_26->ViewValue = $this->_26->CurrentValue;
			$this->_26->ViewCustomAttributes = "";

			// m_26
			$this->m_26->ViewValue = $this->m_26->CurrentValue;
			$this->m_26->ViewValue = FormatNumber($this->m_26->ViewValue, 2, -2, -2, -2);
			$this->m_26->ViewCustomAttributes = "";

			// 27
			$this->_27->ViewValue = $this->_27->CurrentValue;
			$this->_27->ViewCustomAttributes = "";

			// m_27
			$this->m_27->ViewValue = $this->m_27->CurrentValue;
			$this->m_27->ViewValue = FormatNumber($this->m_27->ViewValue, 2, -2, -2, -2);
			$this->m_27->ViewCustomAttributes = "";

			// 28
			$this->_28->ViewValue = $this->_28->CurrentValue;
			$this->_28->ViewCustomAttributes = "";

			// m_28
			$this->m_28->ViewValue = $this->m_28->CurrentValue;
			$this->m_28->ViewValue = FormatNumber($this->m_28->ViewValue, 2, -2, -2, -2);
			$this->m_28->ViewCustomAttributes = "";

			// 29
			$this->_29->ViewValue = $this->_29->CurrentValue;
			$this->_29->ViewCustomAttributes = "";

			// m_29
			$this->m_29->ViewValue = $this->m_29->CurrentValue;
			$this->m_29->ViewValue = FormatNumber($this->m_29->ViewValue, 2, -2, -2, -2);
			$this->m_29->ViewCustomAttributes = "";

			// 30
			$this->_30->ViewValue = $this->_30->CurrentValue;
			$this->_30->ViewCustomAttributes = "";

			// m_30
			$this->m_30->ViewValue = $this->m_30->CurrentValue;
			$this->m_30->ViewValue = FormatNumber($this->m_30->ViewValue, 2, -2, -2, -2);
			$this->m_30->ViewCustomAttributes = "";

			// 31
			$this->_31->ViewValue = $this->_31->CurrentValue;
			$this->_31->ViewCustomAttributes = "";

			// m_31
			$this->m_31->ViewValue = $this->m_31->CurrentValue;
			$this->m_31->ViewValue = FormatNumber($this->m_31->ViewValue, 2, -2, -2, -2);
			$this->m_31->ViewCustomAttributes = "";

			// 32
			$this->_32->ViewValue = $this->_32->CurrentValue;
			$this->_32->ViewCustomAttributes = "";

			// m_32
			$this->m_32->ViewValue = $this->m_32->CurrentValue;
			$this->m_32->ViewValue = FormatNumber($this->m_32->ViewValue, 2, -2, -2, -2);
			$this->m_32->ViewCustomAttributes = "";

			// 33
			$this->_33->ViewValue = $this->_33->CurrentValue;
			$this->_33->ViewCustomAttributes = "";

			// m_33
			$this->m_33->ViewValue = $this->m_33->CurrentValue;
			$this->m_33->ViewValue = FormatNumber($this->m_33->ViewValue, 2, -2, -2, -2);
			$this->m_33->ViewCustomAttributes = "";

			// 34
			$this->_34->ViewValue = $this->_34->CurrentValue;
			$this->_34->ViewCustomAttributes = "";

			// m_34
			$this->m_34->ViewValue = $this->m_34->CurrentValue;
			$this->m_34->ViewValue = FormatNumber($this->m_34->ViewValue, 2, -2, -2, -2);
			$this->m_34->ViewCustomAttributes = "";

			// 35
			$this->_35->ViewValue = $this->_35->CurrentValue;
			$this->_35->ViewCustomAttributes = "";

			// m_35
			$this->m_35->ViewValue = $this->m_35->CurrentValue;
			$this->m_35->ViewValue = FormatNumber($this->m_35->ViewValue, 2, -2, -2, -2);
			$this->m_35->ViewCustomAttributes = "";

			// 36
			$this->_36->ViewValue = $this->_36->CurrentValue;
			$this->_36->ViewCustomAttributes = "";

			// m_36
			$this->m_36->ViewValue = $this->m_36->CurrentValue;
			$this->m_36->ViewValue = FormatNumber($this->m_36->ViewValue, 2, -2, -2, -2);
			$this->m_36->ViewCustomAttributes = "";

			// 37
			$this->_37->ViewValue = $this->_37->CurrentValue;
			$this->_37->ViewCustomAttributes = "";

			// m_37
			$this->m_37->ViewValue = $this->m_37->CurrentValue;
			$this->m_37->ViewValue = FormatNumber($this->m_37->ViewValue, 2, -2, -2, -2);
			$this->m_37->ViewCustomAttributes = "";

			// 38
			$this->_38->ViewValue = $this->_38->CurrentValue;
			$this->_38->ViewCustomAttributes = "";

			// m_38
			$this->m_38->ViewValue = $this->m_38->CurrentValue;
			$this->m_38->ViewValue = FormatNumber($this->m_38->ViewValue, 2, -2, -2, -2);
			$this->m_38->ViewCustomAttributes = "";

			// 39
			$this->_39->ViewValue = $this->_39->CurrentValue;
			$this->_39->ViewCustomAttributes = "";

			// m_39
			$this->m_39->ViewValue = $this->m_39->CurrentValue;
			$this->m_39->ViewValue = FormatNumber($this->m_39->ViewValue, 2, -2, -2, -2);
			$this->m_39->ViewCustomAttributes = "";

			// 40
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewCustomAttributes = "";

			// m_40
			$this->m_40->ViewValue = $this->m_40->CurrentValue;
			$this->m_40->ViewValue = FormatNumber($this->m_40->ViewValue, 2, -2, -2, -2);
			$this->m_40->ViewCustomAttributes = "";

			// 41
			$this->_41->ViewValue = $this->_41->CurrentValue;
			$this->_41->ViewCustomAttributes = "";

			// m_41
			$this->m_41->ViewValue = $this->m_41->CurrentValue;
			$this->m_41->ViewValue = FormatNumber($this->m_41->ViewValue, 2, -2, -2, -2);
			$this->m_41->ViewCustomAttributes = "";

			// 42
			$this->_42->ViewValue = $this->_42->CurrentValue;
			$this->_42->ViewCustomAttributes = "";

			// m_42
			$this->m_42->ViewValue = $this->m_42->CurrentValue;
			$this->m_42->ViewValue = FormatNumber($this->m_42->ViewValue, 2, -2, -2, -2);
			$this->m_42->ViewCustomAttributes = "";

			// 43
			$this->_43->ViewValue = $this->_43->CurrentValue;
			$this->_43->ViewCustomAttributes = "";

			// m_43
			$this->m_43->ViewValue = $this->m_43->CurrentValue;
			$this->m_43->ViewValue = FormatNumber($this->m_43->ViewValue, 2, -2, -2, -2);
			$this->m_43->ViewCustomAttributes = "";

			// 44
			$this->_44->ViewValue = $this->_44->CurrentValue;
			$this->_44->ViewCustomAttributes = "";

			// m_44
			$this->m_44->ViewValue = $this->m_44->CurrentValue;
			$this->m_44->ViewValue = FormatNumber($this->m_44->ViewValue, 2, -2, -2, -2);
			$this->m_44->ViewCustomAttributes = "";

			// 45
			$this->_45->ViewValue = $this->_45->CurrentValue;
			$this->_45->ViewCustomAttributes = "";

			// m_45
			$this->m_45->ViewValue = $this->m_45->CurrentValue;
			$this->m_45->ViewValue = FormatNumber($this->m_45->ViewValue, 2, -2, -2, -2);
			$this->m_45->ViewCustomAttributes = "";

			// 46
			$this->_46->ViewValue = $this->_46->CurrentValue;
			$this->_46->ViewCustomAttributes = "";

			// m_46
			$this->m_46->ViewValue = $this->m_46->CurrentValue;
			$this->m_46->ViewValue = FormatNumber($this->m_46->ViewValue, 2, -2, -2, -2);
			$this->m_46->ViewCustomAttributes = "";

			// 47
			$this->_47->ViewValue = $this->_47->CurrentValue;
			$this->_47->ViewCustomAttributes = "";

			// m_47
			$this->m_47->ViewValue = $this->m_47->CurrentValue;
			$this->m_47->ViewValue = FormatNumber($this->m_47->ViewValue, 2, -2, -2, -2);
			$this->m_47->ViewCustomAttributes = "";

			// 48
			$this->_48->ViewValue = $this->_48->CurrentValue;
			$this->_48->ViewCustomAttributes = "";

			// m_48
			$this->m_48->ViewValue = $this->m_48->CurrentValue;
			$this->m_48->ViewValue = FormatNumber($this->m_48->ViewValue, 2, -2, -2, -2);
			$this->m_48->ViewCustomAttributes = "";

			// 49
			$this->_49->ViewValue = $this->_49->CurrentValue;
			$this->_49->ViewCustomAttributes = "";

			// m_49
			$this->m_49->ViewValue = $this->m_49->CurrentValue;
			$this->m_49->ViewValue = FormatNumber($this->m_49->ViewValue, 2, -2, -2, -2);
			$this->m_49->ViewCustomAttributes = "";

			// 50
			$this->_50->ViewValue = $this->_50->CurrentValue;
			$this->_50->ViewCustomAttributes = "";

			// m_50
			$this->m_50->ViewValue = $this->m_50->CurrentValue;
			$this->m_50->ViewValue = FormatNumber($this->m_50->ViewValue, 2, -2, -2, -2);
			$this->m_50->ViewCustomAttributes = "";

			// 51
			$this->_51->ViewValue = $this->_51->CurrentValue;
			$this->_51->ViewCustomAttributes = "";

			// m_51
			$this->m_51->ViewValue = $this->m_51->CurrentValue;
			$this->m_51->ViewValue = FormatNumber($this->m_51->ViewValue, 2, -2, -2, -2);
			$this->m_51->ViewCustomAttributes = "";

			// 52
			$this->_52->ViewValue = $this->_52->CurrentValue;
			$this->_52->ViewCustomAttributes = "";

			// m_52
			$this->m_52->ViewValue = $this->m_52->CurrentValue;
			$this->m_52->ViewValue = FormatNumber($this->m_52->ViewValue, 2, -2, -2, -2);
			$this->m_52->ViewCustomAttributes = "";

			// 53
			$this->_53->ViewValue = $this->_53->CurrentValue;
			$this->_53->ViewCustomAttributes = "";

			// m_53
			$this->m_53->ViewValue = $this->m_53->CurrentValue;
			$this->m_53->ViewValue = FormatNumber($this->m_53->ViewValue, 2, -2, -2, -2);
			$this->m_53->ViewCustomAttributes = "";

			// 54
			$this->_54->ViewValue = $this->_54->CurrentValue;
			$this->_54->ViewCustomAttributes = "";

			// m_54
			$this->m_54->ViewValue = $this->m_54->CurrentValue;
			$this->m_54->ViewValue = FormatNumber($this->m_54->ViewValue, 2, -2, -2, -2);
			$this->m_54->ViewCustomAttributes = "";

			// 55
			$this->_55->ViewValue = $this->_55->CurrentValue;
			$this->_55->ViewCustomAttributes = "";

			// m_55
			$this->m_55->ViewValue = $this->m_55->CurrentValue;
			$this->m_55->ViewValue = FormatNumber($this->m_55->ViewValue, 2, -2, -2, -2);
			$this->m_55->ViewCustomAttributes = "";

			// 56
			$this->_56->ViewValue = $this->_56->CurrentValue;
			$this->_56->ViewCustomAttributes = "";

			// m_56
			$this->m_56->ViewValue = $this->m_56->CurrentValue;
			$this->m_56->ViewValue = FormatNumber($this->m_56->ViewValue, 2, -2, -2, -2);
			$this->m_56->ViewCustomAttributes = "";

			// 57
			$this->_57->ViewValue = $this->_57->CurrentValue;
			$this->_57->ViewCustomAttributes = "";

			// m_57
			$this->m_57->ViewValue = $this->m_57->CurrentValue;
			$this->m_57->ViewValue = FormatNumber($this->m_57->ViewValue, 2, -2, -2, -2);
			$this->m_57->ViewCustomAttributes = "";

			// 58
			$this->_58->ViewValue = $this->_58->CurrentValue;
			$this->_58->ViewCustomAttributes = "";

			// m_58
			$this->m_58->ViewValue = $this->m_58->CurrentValue;
			$this->m_58->ViewValue = FormatNumber($this->m_58->ViewValue, 2, -2, -2, -2);
			$this->m_58->ViewCustomAttributes = "";

			// 59
			$this->_59->ViewValue = $this->_59->CurrentValue;
			$this->_59->ViewCustomAttributes = "";

			// m_59
			$this->m_59->ViewValue = $this->m_59->CurrentValue;
			$this->m_59->ViewValue = FormatNumber($this->m_59->ViewValue, 2, -2, -2, -2);
			$this->m_59->ViewCustomAttributes = "";

			// 60
			$this->_60->ViewValue = $this->_60->CurrentValue;
			$this->_60->ViewCustomAttributes = "";

			// m_60
			$this->m_60->ViewValue = $this->m_60->CurrentValue;
			$this->m_60->ViewValue = FormatNumber($this->m_60->ViewValue, 2, -2, -2, -2);
			$this->m_60->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";
			if (!$this->isExport())
				$this->roll_no->ViewValue = $this->highlightValue($this->roll_no);

			// test_id
			$this->test_id->LinkCustomAttributes = "";
			$this->test_id->HrefValue = "";
			$this->test_id->TooltipValue = "";
			if (!$this->isExport())
				$this->test_id->ViewValue = $this->highlightValue($this->test_id);

			// total
			$this->total->LinkCustomAttributes = "";
			$this->total->HrefValue = "";
			$this->total->TooltipValue = "";

			// percent
			$this->percent->LinkCustomAttributes = "";
			$this->percent->HrefValue = "";
			$this->percent->TooltipValue = "";

			// s_1
			$this->s_1->LinkCustomAttributes = "";
			$this->s_1->HrefValue = "";
			$this->s_1->TooltipValue = "";

			// s_2
			$this->s_2->LinkCustomAttributes = "";
			$this->s_2->HrefValue = "";
			$this->s_2->TooltipValue = "";

			// s_3
			$this->s_3->LinkCustomAttributes = "";
			$this->s_3->HrefValue = "";
			$this->s_3->TooltipValue = "";

			// s_4
			$this->s_4->LinkCustomAttributes = "";
			$this->s_4->HrefValue = "";
			$this->s_4->TooltipValue = "";

			// s_5
			$this->s_5->LinkCustomAttributes = "";
			$this->s_5->HrefValue = "";
			$this->s_5->TooltipValue = "";

			// omr_image
			$this->omr_image->LinkCustomAttributes = "";
			$this->omr_image->UploadPath = '.p_uploads/school/omr/';
			if (!EmptyValue($this->omr_image->Upload->DbValue)) {
				$this->omr_image->HrefValue = GetFileUploadUrl($this->omr_image, $this->omr_image->Upload->DbValue); // Add prefix/suffix
				$this->omr_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->omr_image->HrefValue = FullUrl($this->omr_image->HrefValue, "href");
			} else {
				$this->omr_image->HrefValue = "";
			}
			$this->omr_image->ExportHrefValue = $this->omr_image->UploadPath . $this->omr_image->Upload->DbValue;
			$this->omr_image->TooltipValue = "";
			if ($this->omr_image->UseColorbox) {
				if (EmptyValue($this->omr_image->TooltipValue))
					$this->omr_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->omr_image->LinkAttrs["data-rel"] = "s_omr_value_x" . $this->RowCnt . "_omr_image";
				AppendClass($this->omr_image->LinkAttrs["class"], "ew-lightbox");
			}

			// 1
			$this->_1->LinkCustomAttributes = "";
			$this->_1->HrefValue = "";
			$this->_1->TooltipValue = "";
			if (!$this->isExport())
				$this->_1->ViewValue = $this->highlightValue($this->_1);

			// m_1
			$this->m_1->LinkCustomAttributes = "";
			$this->m_1->HrefValue = "";
			$this->m_1->TooltipValue = "";

			// 2
			$this->_2->LinkCustomAttributes = "";
			$this->_2->HrefValue = "";
			$this->_2->TooltipValue = "";
			if (!$this->isExport())
				$this->_2->ViewValue = $this->highlightValue($this->_2);

			// m_2
			$this->m_2->LinkCustomAttributes = "";
			$this->m_2->HrefValue = "";
			$this->m_2->TooltipValue = "";

			// 3
			$this->_3->LinkCustomAttributes = "";
			$this->_3->HrefValue = "";
			$this->_3->TooltipValue = "";
			if (!$this->isExport())
				$this->_3->ViewValue = $this->highlightValue($this->_3);

			// m_3
			$this->m_3->LinkCustomAttributes = "";
			$this->m_3->HrefValue = "";
			$this->m_3->TooltipValue = "";

			// 4
			$this->_4->LinkCustomAttributes = "";
			$this->_4->HrefValue = "";
			$this->_4->TooltipValue = "";
			if (!$this->isExport())
				$this->_4->ViewValue = $this->highlightValue($this->_4);

			// m_4
			$this->m_4->LinkCustomAttributes = "";
			$this->m_4->HrefValue = "";
			$this->m_4->TooltipValue = "";

			// 5
			$this->_5->LinkCustomAttributes = "";
			$this->_5->HrefValue = "";
			$this->_5->TooltipValue = "";
			if (!$this->isExport())
				$this->_5->ViewValue = $this->highlightValue($this->_5);

			// m_5
			$this->m_5->LinkCustomAttributes = "";
			$this->m_5->HrefValue = "";
			$this->m_5->TooltipValue = "";

			// 6
			$this->_6->LinkCustomAttributes = "";
			$this->_6->HrefValue = "";
			$this->_6->TooltipValue = "";
			if (!$this->isExport())
				$this->_6->ViewValue = $this->highlightValue($this->_6);

			// m_6
			$this->m_6->LinkCustomAttributes = "";
			$this->m_6->HrefValue = "";
			$this->m_6->TooltipValue = "";

			// 7
			$this->_7->LinkCustomAttributes = "";
			$this->_7->HrefValue = "";
			$this->_7->TooltipValue = "";
			if (!$this->isExport())
				$this->_7->ViewValue = $this->highlightValue($this->_7);

			// m_7
			$this->m_7->LinkCustomAttributes = "";
			$this->m_7->HrefValue = "";
			$this->m_7->TooltipValue = "";

			// 8
			$this->_8->LinkCustomAttributes = "";
			$this->_8->HrefValue = "";
			$this->_8->TooltipValue = "";
			if (!$this->isExport())
				$this->_8->ViewValue = $this->highlightValue($this->_8);

			// m_8
			$this->m_8->LinkCustomAttributes = "";
			$this->m_8->HrefValue = "";
			$this->m_8->TooltipValue = "";

			// 9
			$this->_9->LinkCustomAttributes = "";
			$this->_9->HrefValue = "";
			$this->_9->TooltipValue = "";
			if (!$this->isExport())
				$this->_9->ViewValue = $this->highlightValue($this->_9);

			// m_9
			$this->m_9->LinkCustomAttributes = "";
			$this->m_9->HrefValue = "";
			$this->m_9->TooltipValue = "";

			// 10
			$this->_10->LinkCustomAttributes = "";
			$this->_10->HrefValue = "";
			$this->_10->TooltipValue = "";
			if (!$this->isExport())
				$this->_10->ViewValue = $this->highlightValue($this->_10);

			// m_10
			$this->m_10->LinkCustomAttributes = "";
			$this->m_10->HrefValue = "";
			$this->m_10->TooltipValue = "";

			// 11
			$this->_11->LinkCustomAttributes = "";
			$this->_11->HrefValue = "";
			$this->_11->TooltipValue = "";
			if (!$this->isExport())
				$this->_11->ViewValue = $this->highlightValue($this->_11);

			// m_11
			$this->m_11->LinkCustomAttributes = "";
			$this->m_11->HrefValue = "";
			$this->m_11->TooltipValue = "";

			// 12
			$this->_12->LinkCustomAttributes = "";
			$this->_12->HrefValue = "";
			$this->_12->TooltipValue = "";
			if (!$this->isExport())
				$this->_12->ViewValue = $this->highlightValue($this->_12);

			// m_12
			$this->m_12->LinkCustomAttributes = "";
			$this->m_12->HrefValue = "";
			$this->m_12->TooltipValue = "";

			// 13
			$this->_13->LinkCustomAttributes = "";
			$this->_13->HrefValue = "";
			$this->_13->TooltipValue = "";
			if (!$this->isExport())
				$this->_13->ViewValue = $this->highlightValue($this->_13);

			// m_13
			$this->m_13->LinkCustomAttributes = "";
			$this->m_13->HrefValue = "";
			$this->m_13->TooltipValue = "";

			// 14
			$this->_14->LinkCustomAttributes = "";
			$this->_14->HrefValue = "";
			$this->_14->TooltipValue = "";
			if (!$this->isExport())
				$this->_14->ViewValue = $this->highlightValue($this->_14);

			// m_14
			$this->m_14->LinkCustomAttributes = "";
			$this->m_14->HrefValue = "";
			$this->m_14->TooltipValue = "";

			// 15
			$this->_15->LinkCustomAttributes = "";
			$this->_15->HrefValue = "";
			$this->_15->TooltipValue = "";
			if (!$this->isExport())
				$this->_15->ViewValue = $this->highlightValue($this->_15);

			// m_15
			$this->m_15->LinkCustomAttributes = "";
			$this->m_15->HrefValue = "";
			$this->m_15->TooltipValue = "";

			// 16
			$this->_16->LinkCustomAttributes = "";
			$this->_16->HrefValue = "";
			$this->_16->TooltipValue = "";
			if (!$this->isExport())
				$this->_16->ViewValue = $this->highlightValue($this->_16);

			// m_16
			$this->m_16->LinkCustomAttributes = "";
			$this->m_16->HrefValue = "";
			$this->m_16->TooltipValue = "";

			// 17
			$this->_17->LinkCustomAttributes = "";
			$this->_17->HrefValue = "";
			$this->_17->TooltipValue = "";
			if (!$this->isExport())
				$this->_17->ViewValue = $this->highlightValue($this->_17);

			// m_17
			$this->m_17->LinkCustomAttributes = "";
			$this->m_17->HrefValue = "";
			$this->m_17->TooltipValue = "";

			// 18
			$this->_18->LinkCustomAttributes = "";
			$this->_18->HrefValue = "";
			$this->_18->TooltipValue = "";
			if (!$this->isExport())
				$this->_18->ViewValue = $this->highlightValue($this->_18);

			// m_18
			$this->m_18->LinkCustomAttributes = "";
			$this->m_18->HrefValue = "";
			$this->m_18->TooltipValue = "";

			// 19
			$this->_19->LinkCustomAttributes = "";
			$this->_19->HrefValue = "";
			$this->_19->TooltipValue = "";
			if (!$this->isExport())
				$this->_19->ViewValue = $this->highlightValue($this->_19);

			// m_19
			$this->m_19->LinkCustomAttributes = "";
			$this->m_19->HrefValue = "";
			$this->m_19->TooltipValue = "";

			// 20
			$this->_20->LinkCustomAttributes = "";
			$this->_20->HrefValue = "";
			$this->_20->TooltipValue = "";
			if (!$this->isExport())
				$this->_20->ViewValue = $this->highlightValue($this->_20);

			// m_20
			$this->m_20->LinkCustomAttributes = "";
			$this->m_20->HrefValue = "";
			$this->m_20->TooltipValue = "";

			// 21
			$this->_21->LinkCustomAttributes = "";
			$this->_21->HrefValue = "";
			$this->_21->TooltipValue = "";
			if (!$this->isExport())
				$this->_21->ViewValue = $this->highlightValue($this->_21);

			// m_21
			$this->m_21->LinkCustomAttributes = "";
			$this->m_21->HrefValue = "";
			$this->m_21->TooltipValue = "";

			// 22
			$this->_22->LinkCustomAttributes = "";
			$this->_22->HrefValue = "";
			$this->_22->TooltipValue = "";
			if (!$this->isExport())
				$this->_22->ViewValue = $this->highlightValue($this->_22);

			// m_22
			$this->m_22->LinkCustomAttributes = "";
			$this->m_22->HrefValue = "";
			$this->m_22->TooltipValue = "";

			// 23
			$this->_23->LinkCustomAttributes = "";
			$this->_23->HrefValue = "";
			$this->_23->TooltipValue = "";
			if (!$this->isExport())
				$this->_23->ViewValue = $this->highlightValue($this->_23);

			// m_23
			$this->m_23->LinkCustomAttributes = "";
			$this->m_23->HrefValue = "";
			$this->m_23->TooltipValue = "";

			// 24
			$this->_24->LinkCustomAttributes = "";
			$this->_24->HrefValue = "";
			$this->_24->TooltipValue = "";
			if (!$this->isExport())
				$this->_24->ViewValue = $this->highlightValue($this->_24);

			// m_24
			$this->m_24->LinkCustomAttributes = "";
			$this->m_24->HrefValue = "";
			$this->m_24->TooltipValue = "";

			// 25
			$this->_25->LinkCustomAttributes = "";
			$this->_25->HrefValue = "";
			$this->_25->TooltipValue = "";
			if (!$this->isExport())
				$this->_25->ViewValue = $this->highlightValue($this->_25);

			// m_25
			$this->m_25->LinkCustomAttributes = "";
			$this->m_25->HrefValue = "";
			$this->m_25->TooltipValue = "";

			// 26
			$this->_26->LinkCustomAttributes = "";
			$this->_26->HrefValue = "";
			$this->_26->TooltipValue = "";
			if (!$this->isExport())
				$this->_26->ViewValue = $this->highlightValue($this->_26);

			// m_26
			$this->m_26->LinkCustomAttributes = "";
			$this->m_26->HrefValue = "";
			$this->m_26->TooltipValue = "";

			// 27
			$this->_27->LinkCustomAttributes = "";
			$this->_27->HrefValue = "";
			$this->_27->TooltipValue = "";
			if (!$this->isExport())
				$this->_27->ViewValue = $this->highlightValue($this->_27);

			// m_27
			$this->m_27->LinkCustomAttributes = "";
			$this->m_27->HrefValue = "";
			$this->m_27->TooltipValue = "";

			// 28
			$this->_28->LinkCustomAttributes = "";
			$this->_28->HrefValue = "";
			$this->_28->TooltipValue = "";
			if (!$this->isExport())
				$this->_28->ViewValue = $this->highlightValue($this->_28);

			// m_28
			$this->m_28->LinkCustomAttributes = "";
			$this->m_28->HrefValue = "";
			$this->m_28->TooltipValue = "";

			// 29
			$this->_29->LinkCustomAttributes = "";
			$this->_29->HrefValue = "";
			$this->_29->TooltipValue = "";
			if (!$this->isExport())
				$this->_29->ViewValue = $this->highlightValue($this->_29);

			// m_29
			$this->m_29->LinkCustomAttributes = "";
			$this->m_29->HrefValue = "";
			$this->m_29->TooltipValue = "";

			// 30
			$this->_30->LinkCustomAttributes = "";
			$this->_30->HrefValue = "";
			$this->_30->TooltipValue = "";
			if (!$this->isExport())
				$this->_30->ViewValue = $this->highlightValue($this->_30);

			// m_30
			$this->m_30->LinkCustomAttributes = "";
			$this->m_30->HrefValue = "";
			$this->m_30->TooltipValue = "";

			// 31
			$this->_31->LinkCustomAttributes = "";
			$this->_31->HrefValue = "";
			$this->_31->TooltipValue = "";
			if (!$this->isExport())
				$this->_31->ViewValue = $this->highlightValue($this->_31);

			// m_31
			$this->m_31->LinkCustomAttributes = "";
			$this->m_31->HrefValue = "";
			$this->m_31->TooltipValue = "";

			// 32
			$this->_32->LinkCustomAttributes = "";
			$this->_32->HrefValue = "";
			$this->_32->TooltipValue = "";
			if (!$this->isExport())
				$this->_32->ViewValue = $this->highlightValue($this->_32);

			// m_32
			$this->m_32->LinkCustomAttributes = "";
			$this->m_32->HrefValue = "";
			$this->m_32->TooltipValue = "";

			// 33
			$this->_33->LinkCustomAttributes = "";
			$this->_33->HrefValue = "";
			$this->_33->TooltipValue = "";
			if (!$this->isExport())
				$this->_33->ViewValue = $this->highlightValue($this->_33);

			// m_33
			$this->m_33->LinkCustomAttributes = "";
			$this->m_33->HrefValue = "";
			$this->m_33->TooltipValue = "";

			// 34
			$this->_34->LinkCustomAttributes = "";
			$this->_34->HrefValue = "";
			$this->_34->TooltipValue = "";
			if (!$this->isExport())
				$this->_34->ViewValue = $this->highlightValue($this->_34);

			// m_34
			$this->m_34->LinkCustomAttributes = "";
			$this->m_34->HrefValue = "";
			$this->m_34->TooltipValue = "";

			// 35
			$this->_35->LinkCustomAttributes = "";
			$this->_35->HrefValue = "";
			$this->_35->TooltipValue = "";
			if (!$this->isExport())
				$this->_35->ViewValue = $this->highlightValue($this->_35);

			// m_35
			$this->m_35->LinkCustomAttributes = "";
			$this->m_35->HrefValue = "";
			$this->m_35->TooltipValue = "";

			// 36
			$this->_36->LinkCustomAttributes = "";
			$this->_36->HrefValue = "";
			$this->_36->TooltipValue = "";
			if (!$this->isExport())
				$this->_36->ViewValue = $this->highlightValue($this->_36);

			// m_36
			$this->m_36->LinkCustomAttributes = "";
			$this->m_36->HrefValue = "";
			$this->m_36->TooltipValue = "";

			// 37
			$this->_37->LinkCustomAttributes = "";
			$this->_37->HrefValue = "";
			$this->_37->TooltipValue = "";
			if (!$this->isExport())
				$this->_37->ViewValue = $this->highlightValue($this->_37);

			// m_37
			$this->m_37->LinkCustomAttributes = "";
			$this->m_37->HrefValue = "";
			$this->m_37->TooltipValue = "";

			// 38
			$this->_38->LinkCustomAttributes = "";
			$this->_38->HrefValue = "";
			$this->_38->TooltipValue = "";
			if (!$this->isExport())
				$this->_38->ViewValue = $this->highlightValue($this->_38);

			// m_38
			$this->m_38->LinkCustomAttributes = "";
			$this->m_38->HrefValue = "";
			$this->m_38->TooltipValue = "";

			// 39
			$this->_39->LinkCustomAttributes = "";
			$this->_39->HrefValue = "";
			$this->_39->TooltipValue = "";
			if (!$this->isExport())
				$this->_39->ViewValue = $this->highlightValue($this->_39);

			// m_39
			$this->m_39->LinkCustomAttributes = "";
			$this->m_39->HrefValue = "";
			$this->m_39->TooltipValue = "";

			// 40
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";
			if (!$this->isExport())
				$this->_40->ViewValue = $this->highlightValue($this->_40);

			// m_40
			$this->m_40->LinkCustomAttributes = "";
			$this->m_40->HrefValue = "";
			$this->m_40->TooltipValue = "";

			// 41
			$this->_41->LinkCustomAttributes = "";
			$this->_41->HrefValue = "";
			$this->_41->TooltipValue = "";
			if (!$this->isExport())
				$this->_41->ViewValue = $this->highlightValue($this->_41);

			// m_41
			$this->m_41->LinkCustomAttributes = "";
			$this->m_41->HrefValue = "";
			$this->m_41->TooltipValue = "";

			// 42
			$this->_42->LinkCustomAttributes = "";
			$this->_42->HrefValue = "";
			$this->_42->TooltipValue = "";
			if (!$this->isExport())
				$this->_42->ViewValue = $this->highlightValue($this->_42);

			// m_42
			$this->m_42->LinkCustomAttributes = "";
			$this->m_42->HrefValue = "";
			$this->m_42->TooltipValue = "";

			// 43
			$this->_43->LinkCustomAttributes = "";
			$this->_43->HrefValue = "";
			$this->_43->TooltipValue = "";
			if (!$this->isExport())
				$this->_43->ViewValue = $this->highlightValue($this->_43);

			// m_43
			$this->m_43->LinkCustomAttributes = "";
			$this->m_43->HrefValue = "";
			$this->m_43->TooltipValue = "";

			// 44
			$this->_44->LinkCustomAttributes = "";
			$this->_44->HrefValue = "";
			$this->_44->TooltipValue = "";
			if (!$this->isExport())
				$this->_44->ViewValue = $this->highlightValue($this->_44);

			// m_44
			$this->m_44->LinkCustomAttributes = "";
			$this->m_44->HrefValue = "";
			$this->m_44->TooltipValue = "";

			// 45
			$this->_45->LinkCustomAttributes = "";
			$this->_45->HrefValue = "";
			$this->_45->TooltipValue = "";
			if (!$this->isExport())
				$this->_45->ViewValue = $this->highlightValue($this->_45);

			// m_45
			$this->m_45->LinkCustomAttributes = "";
			$this->m_45->HrefValue = "";
			$this->m_45->TooltipValue = "";

			// 46
			$this->_46->LinkCustomAttributes = "";
			$this->_46->HrefValue = "";
			$this->_46->TooltipValue = "";
			if (!$this->isExport())
				$this->_46->ViewValue = $this->highlightValue($this->_46);

			// m_46
			$this->m_46->LinkCustomAttributes = "";
			$this->m_46->HrefValue = "";
			$this->m_46->TooltipValue = "";

			// 47
			$this->_47->LinkCustomAttributes = "";
			$this->_47->HrefValue = "";
			$this->_47->TooltipValue = "";
			if (!$this->isExport())
				$this->_47->ViewValue = $this->highlightValue($this->_47);

			// m_47
			$this->m_47->LinkCustomAttributes = "";
			$this->m_47->HrefValue = "";
			$this->m_47->TooltipValue = "";

			// 48
			$this->_48->LinkCustomAttributes = "";
			$this->_48->HrefValue = "";
			$this->_48->TooltipValue = "";
			if (!$this->isExport())
				$this->_48->ViewValue = $this->highlightValue($this->_48);

			// m_48
			$this->m_48->LinkCustomAttributes = "";
			$this->m_48->HrefValue = "";
			$this->m_48->TooltipValue = "";

			// 49
			$this->_49->LinkCustomAttributes = "";
			$this->_49->HrefValue = "";
			$this->_49->TooltipValue = "";
			if (!$this->isExport())
				$this->_49->ViewValue = $this->highlightValue($this->_49);

			// m_49
			$this->m_49->LinkCustomAttributes = "";
			$this->m_49->HrefValue = "";
			$this->m_49->TooltipValue = "";

			// 50
			$this->_50->LinkCustomAttributes = "";
			$this->_50->HrefValue = "";
			$this->_50->TooltipValue = "";
			if (!$this->isExport())
				$this->_50->ViewValue = $this->highlightValue($this->_50);

			// m_50
			$this->m_50->LinkCustomAttributes = "";
			$this->m_50->HrefValue = "";
			$this->m_50->TooltipValue = "";

			// 51
			$this->_51->LinkCustomAttributes = "";
			$this->_51->HrefValue = "";
			$this->_51->TooltipValue = "";
			if (!$this->isExport())
				$this->_51->ViewValue = $this->highlightValue($this->_51);

			// m_51
			$this->m_51->LinkCustomAttributes = "";
			$this->m_51->HrefValue = "";
			$this->m_51->TooltipValue = "";

			// 52
			$this->_52->LinkCustomAttributes = "";
			$this->_52->HrefValue = "";
			$this->_52->TooltipValue = "";
			if (!$this->isExport())
				$this->_52->ViewValue = $this->highlightValue($this->_52);

			// m_52
			$this->m_52->LinkCustomAttributes = "";
			$this->m_52->HrefValue = "";
			$this->m_52->TooltipValue = "";

			// 53
			$this->_53->LinkCustomAttributes = "";
			$this->_53->HrefValue = "";
			$this->_53->TooltipValue = "";
			if (!$this->isExport())
				$this->_53->ViewValue = $this->highlightValue($this->_53);

			// m_53
			$this->m_53->LinkCustomAttributes = "";
			$this->m_53->HrefValue = "";
			$this->m_53->TooltipValue = "";

			// 54
			$this->_54->LinkCustomAttributes = "";
			$this->_54->HrefValue = "";
			$this->_54->TooltipValue = "";
			if (!$this->isExport())
				$this->_54->ViewValue = $this->highlightValue($this->_54);

			// m_54
			$this->m_54->LinkCustomAttributes = "";
			$this->m_54->HrefValue = "";
			$this->m_54->TooltipValue = "";

			// 55
			$this->_55->LinkCustomAttributes = "";
			$this->_55->HrefValue = "";
			$this->_55->TooltipValue = "";
			if (!$this->isExport())
				$this->_55->ViewValue = $this->highlightValue($this->_55);

			// m_55
			$this->m_55->LinkCustomAttributes = "";
			$this->m_55->HrefValue = "";
			$this->m_55->TooltipValue = "";

			// 56
			$this->_56->LinkCustomAttributes = "";
			$this->_56->HrefValue = "";
			$this->_56->TooltipValue = "";
			if (!$this->isExport())
				$this->_56->ViewValue = $this->highlightValue($this->_56);

			// m_56
			$this->m_56->LinkCustomAttributes = "";
			$this->m_56->HrefValue = "";
			$this->m_56->TooltipValue = "";

			// 57
			$this->_57->LinkCustomAttributes = "";
			$this->_57->HrefValue = "";
			$this->_57->TooltipValue = "";
			if (!$this->isExport())
				$this->_57->ViewValue = $this->highlightValue($this->_57);

			// m_57
			$this->m_57->LinkCustomAttributes = "";
			$this->m_57->HrefValue = "";
			$this->m_57->TooltipValue = "";

			// 58
			$this->_58->LinkCustomAttributes = "";
			$this->_58->HrefValue = "";
			$this->_58->TooltipValue = "";
			if (!$this->isExport())
				$this->_58->ViewValue = $this->highlightValue($this->_58);

			// m_58
			$this->m_58->LinkCustomAttributes = "";
			$this->m_58->HrefValue = "";
			$this->m_58->TooltipValue = "";

			// 59
			$this->_59->LinkCustomAttributes = "";
			$this->_59->HrefValue = "";
			$this->_59->TooltipValue = "";
			if (!$this->isExport())
				$this->_59->ViewValue = $this->highlightValue($this->_59);

			// m_59
			$this->m_59->LinkCustomAttributes = "";
			$this->m_59->HrefValue = "";
			$this->m_59->TooltipValue = "";

			// 60
			$this->_60->LinkCustomAttributes = "";
			$this->_60->HrefValue = "";
			$this->_60->TooltipValue = "";
			if (!$this->isExport())
				$this->_60->ViewValue = $this->highlightValue($this->_60);

			// m_60
			$this->m_60->LinkCustomAttributes = "";
			$this->m_60->HrefValue = "";
			$this->m_60->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// roll_no
			$this->roll_no->EditAttrs["class"] = "form-control";
			$this->roll_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->roll_no->AdvancedSearch->SearchValue = HtmlDecode($this->roll_no->AdvancedSearch->SearchValue);
			$this->roll_no->EditValue = HtmlEncode($this->roll_no->AdvancedSearch->SearchValue);
			$this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

			// test_id
			$this->test_id->EditAttrs["class"] = "form-control";
			$this->test_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->test_id->AdvancedSearch->SearchValue = HtmlDecode($this->test_id->AdvancedSearch->SearchValue);
			$this->test_id->EditValue = HtmlEncode($this->test_id->AdvancedSearch->SearchValue);
			$this->test_id->PlaceHolder = RemoveHtml($this->test_id->caption());

			// total
			$this->total->EditAttrs["class"] = "form-control";
			$this->total->EditCustomAttributes = "";
			$this->total->EditValue = HtmlEncode($this->total->AdvancedSearch->SearchValue);
			$this->total->PlaceHolder = RemoveHtml($this->total->caption());
			$this->total->EditAttrs["class"] = "form-control";
			$this->total->EditCustomAttributes = "";
			$this->total->EditValue2 = HtmlEncode($this->total->AdvancedSearch->SearchValue2);
			$this->total->PlaceHolder = RemoveHtml($this->total->caption());

			// percent
			$this->percent->EditAttrs["class"] = "form-control";
			$this->percent->EditCustomAttributes = "";
			$this->percent->EditValue = HtmlEncode($this->percent->AdvancedSearch->SearchValue);
			$this->percent->PlaceHolder = RemoveHtml($this->percent->caption());
			$this->percent->EditAttrs["class"] = "form-control";
			$this->percent->EditCustomAttributes = "";
			$this->percent->EditValue2 = HtmlEncode($this->percent->AdvancedSearch->SearchValue2);
			$this->percent->PlaceHolder = RemoveHtml($this->percent->caption());

			// s_1
			$this->s_1->EditAttrs["class"] = "form-control";
			$this->s_1->EditCustomAttributes = "";
			$this->s_1->EditValue = HtmlEncode($this->s_1->AdvancedSearch->SearchValue);
			$this->s_1->PlaceHolder = RemoveHtml($this->s_1->caption());

			// s_2
			$this->s_2->EditAttrs["class"] = "form-control";
			$this->s_2->EditCustomAttributes = "";
			$this->s_2->EditValue = HtmlEncode($this->s_2->AdvancedSearch->SearchValue);
			$this->s_2->PlaceHolder = RemoveHtml($this->s_2->caption());

			// s_3
			$this->s_3->EditAttrs["class"] = "form-control";
			$this->s_3->EditCustomAttributes = "";
			$this->s_3->EditValue = HtmlEncode($this->s_3->AdvancedSearch->SearchValue);
			$this->s_3->PlaceHolder = RemoveHtml($this->s_3->caption());

			// s_4
			$this->s_4->EditAttrs["class"] = "form-control";
			$this->s_4->EditCustomAttributes = "";
			$this->s_4->EditValue = HtmlEncode($this->s_4->AdvancedSearch->SearchValue);
			$this->s_4->PlaceHolder = RemoveHtml($this->s_4->caption());

			// s_5
			$this->s_5->EditAttrs["class"] = "form-control";
			$this->s_5->EditCustomAttributes = "";
			$this->s_5->EditValue = HtmlEncode($this->s_5->AdvancedSearch->SearchValue);
			$this->s_5->PlaceHolder = RemoveHtml($this->s_5->caption());

			// omr_image
			$this->omr_image->EditAttrs["class"] = "form-control";
			$this->omr_image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->omr_image->AdvancedSearch->SearchValue = HtmlDecode($this->omr_image->AdvancedSearch->SearchValue);
			$this->omr_image->EditValue = HtmlEncode($this->omr_image->AdvancedSearch->SearchValue);
			$this->omr_image->PlaceHolder = RemoveHtml($this->omr_image->caption());

			// 1
			$this->_1->EditAttrs["class"] = "form-control";
			$this->_1->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_1->AdvancedSearch->SearchValue = HtmlDecode($this->_1->AdvancedSearch->SearchValue);
			$this->_1->EditValue = HtmlEncode($this->_1->AdvancedSearch->SearchValue);
			$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

			// m_1
			$this->m_1->EditAttrs["class"] = "form-control";
			$this->m_1->EditCustomAttributes = "";
			$this->m_1->EditValue = HtmlEncode($this->m_1->AdvancedSearch->SearchValue);
			$this->m_1->PlaceHolder = RemoveHtml($this->m_1->caption());

			// 2
			$this->_2->EditAttrs["class"] = "form-control";
			$this->_2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_2->AdvancedSearch->SearchValue = HtmlDecode($this->_2->AdvancedSearch->SearchValue);
			$this->_2->EditValue = HtmlEncode($this->_2->AdvancedSearch->SearchValue);
			$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

			// m_2
			$this->m_2->EditAttrs["class"] = "form-control";
			$this->m_2->EditCustomAttributes = "";
			$this->m_2->EditValue = HtmlEncode($this->m_2->AdvancedSearch->SearchValue);
			$this->m_2->PlaceHolder = RemoveHtml($this->m_2->caption());

			// 3
			$this->_3->EditAttrs["class"] = "form-control";
			$this->_3->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_3->AdvancedSearch->SearchValue = HtmlDecode($this->_3->AdvancedSearch->SearchValue);
			$this->_3->EditValue = HtmlEncode($this->_3->AdvancedSearch->SearchValue);
			$this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

			// m_3
			$this->m_3->EditAttrs["class"] = "form-control";
			$this->m_3->EditCustomAttributes = "";
			$this->m_3->EditValue = HtmlEncode($this->m_3->AdvancedSearch->SearchValue);
			$this->m_3->PlaceHolder = RemoveHtml($this->m_3->caption());

			// 4
			$this->_4->EditAttrs["class"] = "form-control";
			$this->_4->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_4->AdvancedSearch->SearchValue = HtmlDecode($this->_4->AdvancedSearch->SearchValue);
			$this->_4->EditValue = HtmlEncode($this->_4->AdvancedSearch->SearchValue);
			$this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

			// m_4
			$this->m_4->EditAttrs["class"] = "form-control";
			$this->m_4->EditCustomAttributes = "";
			$this->m_4->EditValue = HtmlEncode($this->m_4->AdvancedSearch->SearchValue);
			$this->m_4->PlaceHolder = RemoveHtml($this->m_4->caption());

			// 5
			$this->_5->EditAttrs["class"] = "form-control";
			$this->_5->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_5->AdvancedSearch->SearchValue = HtmlDecode($this->_5->AdvancedSearch->SearchValue);
			$this->_5->EditValue = HtmlEncode($this->_5->AdvancedSearch->SearchValue);
			$this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

			// m_5
			$this->m_5->EditAttrs["class"] = "form-control";
			$this->m_5->EditCustomAttributes = "";
			$this->m_5->EditValue = HtmlEncode($this->m_5->AdvancedSearch->SearchValue);
			$this->m_5->PlaceHolder = RemoveHtml($this->m_5->caption());

			// 6
			$this->_6->EditAttrs["class"] = "form-control";
			$this->_6->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_6->AdvancedSearch->SearchValue = HtmlDecode($this->_6->AdvancedSearch->SearchValue);
			$this->_6->EditValue = HtmlEncode($this->_6->AdvancedSearch->SearchValue);
			$this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

			// m_6
			$this->m_6->EditAttrs["class"] = "form-control";
			$this->m_6->EditCustomAttributes = "";
			$this->m_6->EditValue = HtmlEncode($this->m_6->AdvancedSearch->SearchValue);
			$this->m_6->PlaceHolder = RemoveHtml($this->m_6->caption());

			// 7
			$this->_7->EditAttrs["class"] = "form-control";
			$this->_7->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_7->AdvancedSearch->SearchValue = HtmlDecode($this->_7->AdvancedSearch->SearchValue);
			$this->_7->EditValue = HtmlEncode($this->_7->AdvancedSearch->SearchValue);
			$this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

			// m_7
			$this->m_7->EditAttrs["class"] = "form-control";
			$this->m_7->EditCustomAttributes = "";
			$this->m_7->EditValue = HtmlEncode($this->m_7->AdvancedSearch->SearchValue);
			$this->m_7->PlaceHolder = RemoveHtml($this->m_7->caption());

			// 8
			$this->_8->EditAttrs["class"] = "form-control";
			$this->_8->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_8->AdvancedSearch->SearchValue = HtmlDecode($this->_8->AdvancedSearch->SearchValue);
			$this->_8->EditValue = HtmlEncode($this->_8->AdvancedSearch->SearchValue);
			$this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

			// m_8
			$this->m_8->EditAttrs["class"] = "form-control";
			$this->m_8->EditCustomAttributes = "";
			$this->m_8->EditValue = HtmlEncode($this->m_8->AdvancedSearch->SearchValue);
			$this->m_8->PlaceHolder = RemoveHtml($this->m_8->caption());

			// 9
			$this->_9->EditAttrs["class"] = "form-control";
			$this->_9->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_9->AdvancedSearch->SearchValue = HtmlDecode($this->_9->AdvancedSearch->SearchValue);
			$this->_9->EditValue = HtmlEncode($this->_9->AdvancedSearch->SearchValue);
			$this->_9->PlaceHolder = RemoveHtml($this->_9->caption());

			// m_9
			$this->m_9->EditAttrs["class"] = "form-control";
			$this->m_9->EditCustomAttributes = "";
			$this->m_9->EditValue = HtmlEncode($this->m_9->AdvancedSearch->SearchValue);
			$this->m_9->PlaceHolder = RemoveHtml($this->m_9->caption());

			// 10
			$this->_10->EditAttrs["class"] = "form-control";
			$this->_10->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_10->AdvancedSearch->SearchValue = HtmlDecode($this->_10->AdvancedSearch->SearchValue);
			$this->_10->EditValue = HtmlEncode($this->_10->AdvancedSearch->SearchValue);
			$this->_10->PlaceHolder = RemoveHtml($this->_10->caption());

			// m_10
			$this->m_10->EditAttrs["class"] = "form-control";
			$this->m_10->EditCustomAttributes = "";
			$this->m_10->EditValue = HtmlEncode($this->m_10->AdvancedSearch->SearchValue);
			$this->m_10->PlaceHolder = RemoveHtml($this->m_10->caption());

			// 11
			$this->_11->EditAttrs["class"] = "form-control";
			$this->_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_11->AdvancedSearch->SearchValue = HtmlDecode($this->_11->AdvancedSearch->SearchValue);
			$this->_11->EditValue = HtmlEncode($this->_11->AdvancedSearch->SearchValue);
			$this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

			// m_11
			$this->m_11->EditAttrs["class"] = "form-control";
			$this->m_11->EditCustomAttributes = "";
			$this->m_11->EditValue = HtmlEncode($this->m_11->AdvancedSearch->SearchValue);
			$this->m_11->PlaceHolder = RemoveHtml($this->m_11->caption());

			// 12
			$this->_12->EditAttrs["class"] = "form-control";
			$this->_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_12->AdvancedSearch->SearchValue = HtmlDecode($this->_12->AdvancedSearch->SearchValue);
			$this->_12->EditValue = HtmlEncode($this->_12->AdvancedSearch->SearchValue);
			$this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

			// m_12
			$this->m_12->EditAttrs["class"] = "form-control";
			$this->m_12->EditCustomAttributes = "";
			$this->m_12->EditValue = HtmlEncode($this->m_12->AdvancedSearch->SearchValue);
			$this->m_12->PlaceHolder = RemoveHtml($this->m_12->caption());

			// 13
			$this->_13->EditAttrs["class"] = "form-control";
			$this->_13->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_13->AdvancedSearch->SearchValue = HtmlDecode($this->_13->AdvancedSearch->SearchValue);
			$this->_13->EditValue = HtmlEncode($this->_13->AdvancedSearch->SearchValue);
			$this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

			// m_13
			$this->m_13->EditAttrs["class"] = "form-control";
			$this->m_13->EditCustomAttributes = "";
			$this->m_13->EditValue = HtmlEncode($this->m_13->AdvancedSearch->SearchValue);
			$this->m_13->PlaceHolder = RemoveHtml($this->m_13->caption());

			// 14
			$this->_14->EditAttrs["class"] = "form-control";
			$this->_14->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_14->AdvancedSearch->SearchValue = HtmlDecode($this->_14->AdvancedSearch->SearchValue);
			$this->_14->EditValue = HtmlEncode($this->_14->AdvancedSearch->SearchValue);
			$this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

			// m_14
			$this->m_14->EditAttrs["class"] = "form-control";
			$this->m_14->EditCustomAttributes = "";
			$this->m_14->EditValue = HtmlEncode($this->m_14->AdvancedSearch->SearchValue);
			$this->m_14->PlaceHolder = RemoveHtml($this->m_14->caption());

			// 15
			$this->_15->EditAttrs["class"] = "form-control";
			$this->_15->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_15->AdvancedSearch->SearchValue = HtmlDecode($this->_15->AdvancedSearch->SearchValue);
			$this->_15->EditValue = HtmlEncode($this->_15->AdvancedSearch->SearchValue);
			$this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

			// m_15
			$this->m_15->EditAttrs["class"] = "form-control";
			$this->m_15->EditCustomAttributes = "";
			$this->m_15->EditValue = HtmlEncode($this->m_15->AdvancedSearch->SearchValue);
			$this->m_15->PlaceHolder = RemoveHtml($this->m_15->caption());

			// 16
			$this->_16->EditAttrs["class"] = "form-control";
			$this->_16->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_16->AdvancedSearch->SearchValue = HtmlDecode($this->_16->AdvancedSearch->SearchValue);
			$this->_16->EditValue = HtmlEncode($this->_16->AdvancedSearch->SearchValue);
			$this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

			// m_16
			$this->m_16->EditAttrs["class"] = "form-control";
			$this->m_16->EditCustomAttributes = "";
			$this->m_16->EditValue = HtmlEncode($this->m_16->AdvancedSearch->SearchValue);
			$this->m_16->PlaceHolder = RemoveHtml($this->m_16->caption());

			// 17
			$this->_17->EditAttrs["class"] = "form-control";
			$this->_17->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_17->AdvancedSearch->SearchValue = HtmlDecode($this->_17->AdvancedSearch->SearchValue);
			$this->_17->EditValue = HtmlEncode($this->_17->AdvancedSearch->SearchValue);
			$this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

			// m_17
			$this->m_17->EditAttrs["class"] = "form-control";
			$this->m_17->EditCustomAttributes = "";
			$this->m_17->EditValue = HtmlEncode($this->m_17->AdvancedSearch->SearchValue);
			$this->m_17->PlaceHolder = RemoveHtml($this->m_17->caption());

			// 18
			$this->_18->EditAttrs["class"] = "form-control";
			$this->_18->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_18->AdvancedSearch->SearchValue = HtmlDecode($this->_18->AdvancedSearch->SearchValue);
			$this->_18->EditValue = HtmlEncode($this->_18->AdvancedSearch->SearchValue);
			$this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

			// m_18
			$this->m_18->EditAttrs["class"] = "form-control";
			$this->m_18->EditCustomAttributes = "";
			$this->m_18->EditValue = HtmlEncode($this->m_18->AdvancedSearch->SearchValue);
			$this->m_18->PlaceHolder = RemoveHtml($this->m_18->caption());

			// 19
			$this->_19->EditAttrs["class"] = "form-control";
			$this->_19->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_19->AdvancedSearch->SearchValue = HtmlDecode($this->_19->AdvancedSearch->SearchValue);
			$this->_19->EditValue = HtmlEncode($this->_19->AdvancedSearch->SearchValue);
			$this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

			// m_19
			$this->m_19->EditAttrs["class"] = "form-control";
			$this->m_19->EditCustomAttributes = "";
			$this->m_19->EditValue = HtmlEncode($this->m_19->AdvancedSearch->SearchValue);
			$this->m_19->PlaceHolder = RemoveHtml($this->m_19->caption());

			// 20
			$this->_20->EditAttrs["class"] = "form-control";
			$this->_20->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_20->AdvancedSearch->SearchValue = HtmlDecode($this->_20->AdvancedSearch->SearchValue);
			$this->_20->EditValue = HtmlEncode($this->_20->AdvancedSearch->SearchValue);
			$this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

			// m_20
			$this->m_20->EditAttrs["class"] = "form-control";
			$this->m_20->EditCustomAttributes = "";
			$this->m_20->EditValue = HtmlEncode($this->m_20->AdvancedSearch->SearchValue);
			$this->m_20->PlaceHolder = RemoveHtml($this->m_20->caption());

			// 21
			$this->_21->EditAttrs["class"] = "form-control";
			$this->_21->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_21->AdvancedSearch->SearchValue = HtmlDecode($this->_21->AdvancedSearch->SearchValue);
			$this->_21->EditValue = HtmlEncode($this->_21->AdvancedSearch->SearchValue);
			$this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

			// m_21
			$this->m_21->EditAttrs["class"] = "form-control";
			$this->m_21->EditCustomAttributes = "";
			$this->m_21->EditValue = HtmlEncode($this->m_21->AdvancedSearch->SearchValue);
			$this->m_21->PlaceHolder = RemoveHtml($this->m_21->caption());

			// 22
			$this->_22->EditAttrs["class"] = "form-control";
			$this->_22->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_22->AdvancedSearch->SearchValue = HtmlDecode($this->_22->AdvancedSearch->SearchValue);
			$this->_22->EditValue = HtmlEncode($this->_22->AdvancedSearch->SearchValue);
			$this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

			// m_22
			$this->m_22->EditAttrs["class"] = "form-control";
			$this->m_22->EditCustomAttributes = "";
			$this->m_22->EditValue = HtmlEncode($this->m_22->AdvancedSearch->SearchValue);
			$this->m_22->PlaceHolder = RemoveHtml($this->m_22->caption());

			// 23
			$this->_23->EditAttrs["class"] = "form-control";
			$this->_23->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_23->AdvancedSearch->SearchValue = HtmlDecode($this->_23->AdvancedSearch->SearchValue);
			$this->_23->EditValue = HtmlEncode($this->_23->AdvancedSearch->SearchValue);
			$this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

			// m_23
			$this->m_23->EditAttrs["class"] = "form-control";
			$this->m_23->EditCustomAttributes = "";
			$this->m_23->EditValue = HtmlEncode($this->m_23->AdvancedSearch->SearchValue);
			$this->m_23->PlaceHolder = RemoveHtml($this->m_23->caption());

			// 24
			$this->_24->EditAttrs["class"] = "form-control";
			$this->_24->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_24->AdvancedSearch->SearchValue = HtmlDecode($this->_24->AdvancedSearch->SearchValue);
			$this->_24->EditValue = HtmlEncode($this->_24->AdvancedSearch->SearchValue);
			$this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

			// m_24
			$this->m_24->EditAttrs["class"] = "form-control";
			$this->m_24->EditCustomAttributes = "";
			$this->m_24->EditValue = HtmlEncode($this->m_24->AdvancedSearch->SearchValue);
			$this->m_24->PlaceHolder = RemoveHtml($this->m_24->caption());

			// 25
			$this->_25->EditAttrs["class"] = "form-control";
			$this->_25->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_25->AdvancedSearch->SearchValue = HtmlDecode($this->_25->AdvancedSearch->SearchValue);
			$this->_25->EditValue = HtmlEncode($this->_25->AdvancedSearch->SearchValue);
			$this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

			// m_25
			$this->m_25->EditAttrs["class"] = "form-control";
			$this->m_25->EditCustomAttributes = "";
			$this->m_25->EditValue = HtmlEncode($this->m_25->AdvancedSearch->SearchValue);
			$this->m_25->PlaceHolder = RemoveHtml($this->m_25->caption());

			// 26
			$this->_26->EditAttrs["class"] = "form-control";
			$this->_26->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_26->AdvancedSearch->SearchValue = HtmlDecode($this->_26->AdvancedSearch->SearchValue);
			$this->_26->EditValue = HtmlEncode($this->_26->AdvancedSearch->SearchValue);
			$this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

			// m_26
			$this->m_26->EditAttrs["class"] = "form-control";
			$this->m_26->EditCustomAttributes = "";
			$this->m_26->EditValue = HtmlEncode($this->m_26->AdvancedSearch->SearchValue);
			$this->m_26->PlaceHolder = RemoveHtml($this->m_26->caption());

			// 27
			$this->_27->EditAttrs["class"] = "form-control";
			$this->_27->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_27->AdvancedSearch->SearchValue = HtmlDecode($this->_27->AdvancedSearch->SearchValue);
			$this->_27->EditValue = HtmlEncode($this->_27->AdvancedSearch->SearchValue);
			$this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

			// m_27
			$this->m_27->EditAttrs["class"] = "form-control";
			$this->m_27->EditCustomAttributes = "";
			$this->m_27->EditValue = HtmlEncode($this->m_27->AdvancedSearch->SearchValue);
			$this->m_27->PlaceHolder = RemoveHtml($this->m_27->caption());

			// 28
			$this->_28->EditAttrs["class"] = "form-control";
			$this->_28->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_28->AdvancedSearch->SearchValue = HtmlDecode($this->_28->AdvancedSearch->SearchValue);
			$this->_28->EditValue = HtmlEncode($this->_28->AdvancedSearch->SearchValue);
			$this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

			// m_28
			$this->m_28->EditAttrs["class"] = "form-control";
			$this->m_28->EditCustomAttributes = "";
			$this->m_28->EditValue = HtmlEncode($this->m_28->AdvancedSearch->SearchValue);
			$this->m_28->PlaceHolder = RemoveHtml($this->m_28->caption());

			// 29
			$this->_29->EditAttrs["class"] = "form-control";
			$this->_29->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_29->AdvancedSearch->SearchValue = HtmlDecode($this->_29->AdvancedSearch->SearchValue);
			$this->_29->EditValue = HtmlEncode($this->_29->AdvancedSearch->SearchValue);
			$this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

			// m_29
			$this->m_29->EditAttrs["class"] = "form-control";
			$this->m_29->EditCustomAttributes = "";
			$this->m_29->EditValue = HtmlEncode($this->m_29->AdvancedSearch->SearchValue);
			$this->m_29->PlaceHolder = RemoveHtml($this->m_29->caption());

			// 30
			$this->_30->EditAttrs["class"] = "form-control";
			$this->_30->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_30->AdvancedSearch->SearchValue = HtmlDecode($this->_30->AdvancedSearch->SearchValue);
			$this->_30->EditValue = HtmlEncode($this->_30->AdvancedSearch->SearchValue);
			$this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

			// m_30
			$this->m_30->EditAttrs["class"] = "form-control";
			$this->m_30->EditCustomAttributes = "";
			$this->m_30->EditValue = HtmlEncode($this->m_30->AdvancedSearch->SearchValue);
			$this->m_30->PlaceHolder = RemoveHtml($this->m_30->caption());

			// 31
			$this->_31->EditAttrs["class"] = "form-control";
			$this->_31->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_31->AdvancedSearch->SearchValue = HtmlDecode($this->_31->AdvancedSearch->SearchValue);
			$this->_31->EditValue = HtmlEncode($this->_31->AdvancedSearch->SearchValue);
			$this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

			// m_31
			$this->m_31->EditAttrs["class"] = "form-control";
			$this->m_31->EditCustomAttributes = "";
			$this->m_31->EditValue = HtmlEncode($this->m_31->AdvancedSearch->SearchValue);
			$this->m_31->PlaceHolder = RemoveHtml($this->m_31->caption());

			// 32
			$this->_32->EditAttrs["class"] = "form-control";
			$this->_32->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_32->AdvancedSearch->SearchValue = HtmlDecode($this->_32->AdvancedSearch->SearchValue);
			$this->_32->EditValue = HtmlEncode($this->_32->AdvancedSearch->SearchValue);
			$this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

			// m_32
			$this->m_32->EditAttrs["class"] = "form-control";
			$this->m_32->EditCustomAttributes = "";
			$this->m_32->EditValue = HtmlEncode($this->m_32->AdvancedSearch->SearchValue);
			$this->m_32->PlaceHolder = RemoveHtml($this->m_32->caption());

			// 33
			$this->_33->EditAttrs["class"] = "form-control";
			$this->_33->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_33->AdvancedSearch->SearchValue = HtmlDecode($this->_33->AdvancedSearch->SearchValue);
			$this->_33->EditValue = HtmlEncode($this->_33->AdvancedSearch->SearchValue);
			$this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

			// m_33
			$this->m_33->EditAttrs["class"] = "form-control";
			$this->m_33->EditCustomAttributes = "";
			$this->m_33->EditValue = HtmlEncode($this->m_33->AdvancedSearch->SearchValue);
			$this->m_33->PlaceHolder = RemoveHtml($this->m_33->caption());

			// 34
			$this->_34->EditAttrs["class"] = "form-control";
			$this->_34->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_34->AdvancedSearch->SearchValue = HtmlDecode($this->_34->AdvancedSearch->SearchValue);
			$this->_34->EditValue = HtmlEncode($this->_34->AdvancedSearch->SearchValue);
			$this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

			// m_34
			$this->m_34->EditAttrs["class"] = "form-control";
			$this->m_34->EditCustomAttributes = "";
			$this->m_34->EditValue = HtmlEncode($this->m_34->AdvancedSearch->SearchValue);
			$this->m_34->PlaceHolder = RemoveHtml($this->m_34->caption());

			// 35
			$this->_35->EditAttrs["class"] = "form-control";
			$this->_35->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_35->AdvancedSearch->SearchValue = HtmlDecode($this->_35->AdvancedSearch->SearchValue);
			$this->_35->EditValue = HtmlEncode($this->_35->AdvancedSearch->SearchValue);
			$this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

			// m_35
			$this->m_35->EditAttrs["class"] = "form-control";
			$this->m_35->EditCustomAttributes = "";
			$this->m_35->EditValue = HtmlEncode($this->m_35->AdvancedSearch->SearchValue);
			$this->m_35->PlaceHolder = RemoveHtml($this->m_35->caption());

			// 36
			$this->_36->EditAttrs["class"] = "form-control";
			$this->_36->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_36->AdvancedSearch->SearchValue = HtmlDecode($this->_36->AdvancedSearch->SearchValue);
			$this->_36->EditValue = HtmlEncode($this->_36->AdvancedSearch->SearchValue);
			$this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

			// m_36
			$this->m_36->EditAttrs["class"] = "form-control";
			$this->m_36->EditCustomAttributes = "";
			$this->m_36->EditValue = HtmlEncode($this->m_36->AdvancedSearch->SearchValue);
			$this->m_36->PlaceHolder = RemoveHtml($this->m_36->caption());

			// 37
			$this->_37->EditAttrs["class"] = "form-control";
			$this->_37->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_37->AdvancedSearch->SearchValue = HtmlDecode($this->_37->AdvancedSearch->SearchValue);
			$this->_37->EditValue = HtmlEncode($this->_37->AdvancedSearch->SearchValue);
			$this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

			// m_37
			$this->m_37->EditAttrs["class"] = "form-control";
			$this->m_37->EditCustomAttributes = "";
			$this->m_37->EditValue = HtmlEncode($this->m_37->AdvancedSearch->SearchValue);
			$this->m_37->PlaceHolder = RemoveHtml($this->m_37->caption());

			// 38
			$this->_38->EditAttrs["class"] = "form-control";
			$this->_38->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_38->AdvancedSearch->SearchValue = HtmlDecode($this->_38->AdvancedSearch->SearchValue);
			$this->_38->EditValue = HtmlEncode($this->_38->AdvancedSearch->SearchValue);
			$this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

			// m_38
			$this->m_38->EditAttrs["class"] = "form-control";
			$this->m_38->EditCustomAttributes = "";
			$this->m_38->EditValue = HtmlEncode($this->m_38->AdvancedSearch->SearchValue);
			$this->m_38->PlaceHolder = RemoveHtml($this->m_38->caption());

			// 39
			$this->_39->EditAttrs["class"] = "form-control";
			$this->_39->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_39->AdvancedSearch->SearchValue = HtmlDecode($this->_39->AdvancedSearch->SearchValue);
			$this->_39->EditValue = HtmlEncode($this->_39->AdvancedSearch->SearchValue);
			$this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

			// m_39
			$this->m_39->EditAttrs["class"] = "form-control";
			$this->m_39->EditCustomAttributes = "";
			$this->m_39->EditValue = HtmlEncode($this->m_39->AdvancedSearch->SearchValue);
			$this->m_39->PlaceHolder = RemoveHtml($this->m_39->caption());

			// 40
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_40->AdvancedSearch->SearchValue = HtmlDecode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

			// m_40
			$this->m_40->EditAttrs["class"] = "form-control";
			$this->m_40->EditCustomAttributes = "";
			$this->m_40->EditValue = HtmlEncode($this->m_40->AdvancedSearch->SearchValue);
			$this->m_40->PlaceHolder = RemoveHtml($this->m_40->caption());

			// 41
			$this->_41->EditAttrs["class"] = "form-control";
			$this->_41->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_41->AdvancedSearch->SearchValue = HtmlDecode($this->_41->AdvancedSearch->SearchValue);
			$this->_41->EditValue = HtmlEncode($this->_41->AdvancedSearch->SearchValue);
			$this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

			// m_41
			$this->m_41->EditAttrs["class"] = "form-control";
			$this->m_41->EditCustomAttributes = "";
			$this->m_41->EditValue = HtmlEncode($this->m_41->AdvancedSearch->SearchValue);
			$this->m_41->PlaceHolder = RemoveHtml($this->m_41->caption());

			// 42
			$this->_42->EditAttrs["class"] = "form-control";
			$this->_42->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_42->AdvancedSearch->SearchValue = HtmlDecode($this->_42->AdvancedSearch->SearchValue);
			$this->_42->EditValue = HtmlEncode($this->_42->AdvancedSearch->SearchValue);
			$this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

			// m_42
			$this->m_42->EditAttrs["class"] = "form-control";
			$this->m_42->EditCustomAttributes = "";
			$this->m_42->EditValue = HtmlEncode($this->m_42->AdvancedSearch->SearchValue);
			$this->m_42->PlaceHolder = RemoveHtml($this->m_42->caption());

			// 43
			$this->_43->EditAttrs["class"] = "form-control";
			$this->_43->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_43->AdvancedSearch->SearchValue = HtmlDecode($this->_43->AdvancedSearch->SearchValue);
			$this->_43->EditValue = HtmlEncode($this->_43->AdvancedSearch->SearchValue);
			$this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

			// m_43
			$this->m_43->EditAttrs["class"] = "form-control";
			$this->m_43->EditCustomAttributes = "";
			$this->m_43->EditValue = HtmlEncode($this->m_43->AdvancedSearch->SearchValue);
			$this->m_43->PlaceHolder = RemoveHtml($this->m_43->caption());

			// 44
			$this->_44->EditAttrs["class"] = "form-control";
			$this->_44->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_44->AdvancedSearch->SearchValue = HtmlDecode($this->_44->AdvancedSearch->SearchValue);
			$this->_44->EditValue = HtmlEncode($this->_44->AdvancedSearch->SearchValue);
			$this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

			// m_44
			$this->m_44->EditAttrs["class"] = "form-control";
			$this->m_44->EditCustomAttributes = "";
			$this->m_44->EditValue = HtmlEncode($this->m_44->AdvancedSearch->SearchValue);
			$this->m_44->PlaceHolder = RemoveHtml($this->m_44->caption());

			// 45
			$this->_45->EditAttrs["class"] = "form-control";
			$this->_45->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_45->AdvancedSearch->SearchValue = HtmlDecode($this->_45->AdvancedSearch->SearchValue);
			$this->_45->EditValue = HtmlEncode($this->_45->AdvancedSearch->SearchValue);
			$this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

			// m_45
			$this->m_45->EditAttrs["class"] = "form-control";
			$this->m_45->EditCustomAttributes = "";
			$this->m_45->EditValue = HtmlEncode($this->m_45->AdvancedSearch->SearchValue);
			$this->m_45->PlaceHolder = RemoveHtml($this->m_45->caption());

			// 46
			$this->_46->EditAttrs["class"] = "form-control";
			$this->_46->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_46->AdvancedSearch->SearchValue = HtmlDecode($this->_46->AdvancedSearch->SearchValue);
			$this->_46->EditValue = HtmlEncode($this->_46->AdvancedSearch->SearchValue);
			$this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

			// m_46
			$this->m_46->EditAttrs["class"] = "form-control";
			$this->m_46->EditCustomAttributes = "";
			$this->m_46->EditValue = HtmlEncode($this->m_46->AdvancedSearch->SearchValue);
			$this->m_46->PlaceHolder = RemoveHtml($this->m_46->caption());

			// 47
			$this->_47->EditAttrs["class"] = "form-control";
			$this->_47->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_47->AdvancedSearch->SearchValue = HtmlDecode($this->_47->AdvancedSearch->SearchValue);
			$this->_47->EditValue = HtmlEncode($this->_47->AdvancedSearch->SearchValue);
			$this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

			// m_47
			$this->m_47->EditAttrs["class"] = "form-control";
			$this->m_47->EditCustomAttributes = "";
			$this->m_47->EditValue = HtmlEncode($this->m_47->AdvancedSearch->SearchValue);
			$this->m_47->PlaceHolder = RemoveHtml($this->m_47->caption());

			// 48
			$this->_48->EditAttrs["class"] = "form-control";
			$this->_48->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_48->AdvancedSearch->SearchValue = HtmlDecode($this->_48->AdvancedSearch->SearchValue);
			$this->_48->EditValue = HtmlEncode($this->_48->AdvancedSearch->SearchValue);
			$this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

			// m_48
			$this->m_48->EditAttrs["class"] = "form-control";
			$this->m_48->EditCustomAttributes = "";
			$this->m_48->EditValue = HtmlEncode($this->m_48->AdvancedSearch->SearchValue);
			$this->m_48->PlaceHolder = RemoveHtml($this->m_48->caption());

			// 49
			$this->_49->EditAttrs["class"] = "form-control";
			$this->_49->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_49->AdvancedSearch->SearchValue = HtmlDecode($this->_49->AdvancedSearch->SearchValue);
			$this->_49->EditValue = HtmlEncode($this->_49->AdvancedSearch->SearchValue);
			$this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

			// m_49
			$this->m_49->EditAttrs["class"] = "form-control";
			$this->m_49->EditCustomAttributes = "";
			$this->m_49->EditValue = HtmlEncode($this->m_49->AdvancedSearch->SearchValue);
			$this->m_49->PlaceHolder = RemoveHtml($this->m_49->caption());

			// 50
			$this->_50->EditAttrs["class"] = "form-control";
			$this->_50->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_50->AdvancedSearch->SearchValue = HtmlDecode($this->_50->AdvancedSearch->SearchValue);
			$this->_50->EditValue = HtmlEncode($this->_50->AdvancedSearch->SearchValue);
			$this->_50->PlaceHolder = RemoveHtml($this->_50->caption());

			// m_50
			$this->m_50->EditAttrs["class"] = "form-control";
			$this->m_50->EditCustomAttributes = "";
			$this->m_50->EditValue = HtmlEncode($this->m_50->AdvancedSearch->SearchValue);
			$this->m_50->PlaceHolder = RemoveHtml($this->m_50->caption());

			// 51
			$this->_51->EditAttrs["class"] = "form-control";
			$this->_51->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_51->AdvancedSearch->SearchValue = HtmlDecode($this->_51->AdvancedSearch->SearchValue);
			$this->_51->EditValue = HtmlEncode($this->_51->AdvancedSearch->SearchValue);
			$this->_51->PlaceHolder = RemoveHtml($this->_51->caption());

			// m_51
			$this->m_51->EditAttrs["class"] = "form-control";
			$this->m_51->EditCustomAttributes = "";
			$this->m_51->EditValue = HtmlEncode($this->m_51->AdvancedSearch->SearchValue);
			$this->m_51->PlaceHolder = RemoveHtml($this->m_51->caption());

			// 52
			$this->_52->EditAttrs["class"] = "form-control";
			$this->_52->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_52->AdvancedSearch->SearchValue = HtmlDecode($this->_52->AdvancedSearch->SearchValue);
			$this->_52->EditValue = HtmlEncode($this->_52->AdvancedSearch->SearchValue);
			$this->_52->PlaceHolder = RemoveHtml($this->_52->caption());

			// m_52
			$this->m_52->EditAttrs["class"] = "form-control";
			$this->m_52->EditCustomAttributes = "";
			$this->m_52->EditValue = HtmlEncode($this->m_52->AdvancedSearch->SearchValue);
			$this->m_52->PlaceHolder = RemoveHtml($this->m_52->caption());

			// 53
			$this->_53->EditAttrs["class"] = "form-control";
			$this->_53->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_53->AdvancedSearch->SearchValue = HtmlDecode($this->_53->AdvancedSearch->SearchValue);
			$this->_53->EditValue = HtmlEncode($this->_53->AdvancedSearch->SearchValue);
			$this->_53->PlaceHolder = RemoveHtml($this->_53->caption());

			// m_53
			$this->m_53->EditAttrs["class"] = "form-control";
			$this->m_53->EditCustomAttributes = "";
			$this->m_53->EditValue = HtmlEncode($this->m_53->AdvancedSearch->SearchValue);
			$this->m_53->PlaceHolder = RemoveHtml($this->m_53->caption());

			// 54
			$this->_54->EditAttrs["class"] = "form-control";
			$this->_54->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_54->AdvancedSearch->SearchValue = HtmlDecode($this->_54->AdvancedSearch->SearchValue);
			$this->_54->EditValue = HtmlEncode($this->_54->AdvancedSearch->SearchValue);
			$this->_54->PlaceHolder = RemoveHtml($this->_54->caption());

			// m_54
			$this->m_54->EditAttrs["class"] = "form-control";
			$this->m_54->EditCustomAttributes = "";
			$this->m_54->EditValue = HtmlEncode($this->m_54->AdvancedSearch->SearchValue);
			$this->m_54->PlaceHolder = RemoveHtml($this->m_54->caption());

			// 55
			$this->_55->EditAttrs["class"] = "form-control";
			$this->_55->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_55->AdvancedSearch->SearchValue = HtmlDecode($this->_55->AdvancedSearch->SearchValue);
			$this->_55->EditValue = HtmlEncode($this->_55->AdvancedSearch->SearchValue);
			$this->_55->PlaceHolder = RemoveHtml($this->_55->caption());

			// m_55
			$this->m_55->EditAttrs["class"] = "form-control";
			$this->m_55->EditCustomAttributes = "";
			$this->m_55->EditValue = HtmlEncode($this->m_55->AdvancedSearch->SearchValue);
			$this->m_55->PlaceHolder = RemoveHtml($this->m_55->caption());

			// 56
			$this->_56->EditAttrs["class"] = "form-control";
			$this->_56->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_56->AdvancedSearch->SearchValue = HtmlDecode($this->_56->AdvancedSearch->SearchValue);
			$this->_56->EditValue = HtmlEncode($this->_56->AdvancedSearch->SearchValue);
			$this->_56->PlaceHolder = RemoveHtml($this->_56->caption());

			// m_56
			$this->m_56->EditAttrs["class"] = "form-control";
			$this->m_56->EditCustomAttributes = "";
			$this->m_56->EditValue = HtmlEncode($this->m_56->AdvancedSearch->SearchValue);
			$this->m_56->PlaceHolder = RemoveHtml($this->m_56->caption());

			// 57
			$this->_57->EditAttrs["class"] = "form-control";
			$this->_57->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_57->AdvancedSearch->SearchValue = HtmlDecode($this->_57->AdvancedSearch->SearchValue);
			$this->_57->EditValue = HtmlEncode($this->_57->AdvancedSearch->SearchValue);
			$this->_57->PlaceHolder = RemoveHtml($this->_57->caption());

			// m_57
			$this->m_57->EditAttrs["class"] = "form-control";
			$this->m_57->EditCustomAttributes = "";
			$this->m_57->EditValue = HtmlEncode($this->m_57->AdvancedSearch->SearchValue);
			$this->m_57->PlaceHolder = RemoveHtml($this->m_57->caption());

			// 58
			$this->_58->EditAttrs["class"] = "form-control";
			$this->_58->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_58->AdvancedSearch->SearchValue = HtmlDecode($this->_58->AdvancedSearch->SearchValue);
			$this->_58->EditValue = HtmlEncode($this->_58->AdvancedSearch->SearchValue);
			$this->_58->PlaceHolder = RemoveHtml($this->_58->caption());

			// m_58
			$this->m_58->EditAttrs["class"] = "form-control";
			$this->m_58->EditCustomAttributes = "";
			$this->m_58->EditValue = HtmlEncode($this->m_58->AdvancedSearch->SearchValue);
			$this->m_58->PlaceHolder = RemoveHtml($this->m_58->caption());

			// 59
			$this->_59->EditAttrs["class"] = "form-control";
			$this->_59->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_59->AdvancedSearch->SearchValue = HtmlDecode($this->_59->AdvancedSearch->SearchValue);
			$this->_59->EditValue = HtmlEncode($this->_59->AdvancedSearch->SearchValue);
			$this->_59->PlaceHolder = RemoveHtml($this->_59->caption());

			// m_59
			$this->m_59->EditAttrs["class"] = "form-control";
			$this->m_59->EditCustomAttributes = "";
			$this->m_59->EditValue = HtmlEncode($this->m_59->AdvancedSearch->SearchValue);
			$this->m_59->PlaceHolder = RemoveHtml($this->m_59->caption());

			// 60
			$this->_60->EditAttrs["class"] = "form-control";
			$this->_60->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_60->AdvancedSearch->SearchValue = HtmlDecode($this->_60->AdvancedSearch->SearchValue);
			$this->_60->EditValue = HtmlEncode($this->_60->AdvancedSearch->SearchValue);
			$this->_60->PlaceHolder = RemoveHtml($this->_60->caption());

			// m_60
			$this->m_60->EditAttrs["class"] = "form-control";
			$this->m_60->EditCustomAttributes = "";
			$this->m_60->EditValue = HtmlEncode($this->m_60->AdvancedSearch->SearchValue);
			$this->m_60->PlaceHolder = RemoveHtml($this->m_60->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->roll_no->AdvancedSearch->load();
		$this->test_id->AdvancedSearch->load();
		$this->total->AdvancedSearch->load();
		$this->percent->AdvancedSearch->load();
		$this->s_1->AdvancedSearch->load();
		$this->s_2->AdvancedSearch->load();
		$this->s_3->AdvancedSearch->load();
		$this->s_4->AdvancedSearch->load();
		$this->s_5->AdvancedSearch->load();
		$this->omr_image->AdvancedSearch->load();
		$this->_1->AdvancedSearch->load();
		$this->m_1->AdvancedSearch->load();
		$this->_2->AdvancedSearch->load();
		$this->m_2->AdvancedSearch->load();
		$this->_3->AdvancedSearch->load();
		$this->m_3->AdvancedSearch->load();
		$this->_4->AdvancedSearch->load();
		$this->m_4->AdvancedSearch->load();
		$this->_5->AdvancedSearch->load();
		$this->m_5->AdvancedSearch->load();
		$this->_6->AdvancedSearch->load();
		$this->m_6->AdvancedSearch->load();
		$this->_7->AdvancedSearch->load();
		$this->m_7->AdvancedSearch->load();
		$this->_8->AdvancedSearch->load();
		$this->m_8->AdvancedSearch->load();
		$this->_9->AdvancedSearch->load();
		$this->m_9->AdvancedSearch->load();
		$this->_10->AdvancedSearch->load();
		$this->m_10->AdvancedSearch->load();
		$this->_11->AdvancedSearch->load();
		$this->m_11->AdvancedSearch->load();
		$this->_12->AdvancedSearch->load();
		$this->m_12->AdvancedSearch->load();
		$this->_13->AdvancedSearch->load();
		$this->m_13->AdvancedSearch->load();
		$this->_14->AdvancedSearch->load();
		$this->m_14->AdvancedSearch->load();
		$this->_15->AdvancedSearch->load();
		$this->m_15->AdvancedSearch->load();
		$this->_16->AdvancedSearch->load();
		$this->m_16->AdvancedSearch->load();
		$this->_17->AdvancedSearch->load();
		$this->m_17->AdvancedSearch->load();
		$this->_18->AdvancedSearch->load();
		$this->m_18->AdvancedSearch->load();
		$this->_19->AdvancedSearch->load();
		$this->m_19->AdvancedSearch->load();
		$this->_20->AdvancedSearch->load();
		$this->m_20->AdvancedSearch->load();
		$this->_21->AdvancedSearch->load();
		$this->m_21->AdvancedSearch->load();
		$this->_22->AdvancedSearch->load();
		$this->m_22->AdvancedSearch->load();
		$this->_23->AdvancedSearch->load();
		$this->m_23->AdvancedSearch->load();
		$this->_24->AdvancedSearch->load();
		$this->m_24->AdvancedSearch->load();
		$this->_25->AdvancedSearch->load();
		$this->m_25->AdvancedSearch->load();
		$this->_26->AdvancedSearch->load();
		$this->m_26->AdvancedSearch->load();
		$this->_27->AdvancedSearch->load();
		$this->m_27->AdvancedSearch->load();
		$this->_28->AdvancedSearch->load();
		$this->m_28->AdvancedSearch->load();
		$this->_29->AdvancedSearch->load();
		$this->m_29->AdvancedSearch->load();
		$this->_30->AdvancedSearch->load();
		$this->m_30->AdvancedSearch->load();
		$this->_31->AdvancedSearch->load();
		$this->m_31->AdvancedSearch->load();
		$this->_32->AdvancedSearch->load();
		$this->m_32->AdvancedSearch->load();
		$this->_33->AdvancedSearch->load();
		$this->m_33->AdvancedSearch->load();
		$this->_34->AdvancedSearch->load();
		$this->m_34->AdvancedSearch->load();
		$this->_35->AdvancedSearch->load();
		$this->m_35->AdvancedSearch->load();
		$this->_36->AdvancedSearch->load();
		$this->m_36->AdvancedSearch->load();
		$this->_37->AdvancedSearch->load();
		$this->m_37->AdvancedSearch->load();
		$this->_38->AdvancedSearch->load();
		$this->m_38->AdvancedSearch->load();
		$this->_39->AdvancedSearch->load();
		$this->m_39->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->m_40->AdvancedSearch->load();
		$this->_41->AdvancedSearch->load();
		$this->m_41->AdvancedSearch->load();
		$this->_42->AdvancedSearch->load();
		$this->m_42->AdvancedSearch->load();
		$this->_43->AdvancedSearch->load();
		$this->m_43->AdvancedSearch->load();
		$this->_44->AdvancedSearch->load();
		$this->m_44->AdvancedSearch->load();
		$this->_45->AdvancedSearch->load();
		$this->m_45->AdvancedSearch->load();
		$this->_46->AdvancedSearch->load();
		$this->m_46->AdvancedSearch->load();
		$this->_47->AdvancedSearch->load();
		$this->m_47->AdvancedSearch->load();
		$this->_48->AdvancedSearch->load();
		$this->m_48->AdvancedSearch->load();
		$this->_49->AdvancedSearch->load();
		$this->m_49->AdvancedSearch->load();
		$this->_50->AdvancedSearch->load();
		$this->m_50->AdvancedSearch->load();
		$this->_51->AdvancedSearch->load();
		$this->m_51->AdvancedSearch->load();
		$this->_52->AdvancedSearch->load();
		$this->m_52->AdvancedSearch->load();
		$this->_53->AdvancedSearch->load();
		$this->m_53->AdvancedSearch->load();
		$this->_54->AdvancedSearch->load();
		$this->m_54->AdvancedSearch->load();
		$this->_55->AdvancedSearch->load();
		$this->m_55->AdvancedSearch->load();
		$this->_56->AdvancedSearch->load();
		$this->m_56->AdvancedSearch->load();
		$this->_57->AdvancedSearch->load();
		$this->m_57->AdvancedSearch->load();
		$this->_58->AdvancedSearch->load();
		$this->m_58->AdvancedSearch->load();
		$this->_59->AdvancedSearch->load();
		$this->m_59->AdvancedSearch->load();
		$this->_60->AdvancedSearch->load();
		$this->m_60->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.fs_omr_valuelist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.fs_omr_valuelist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.fs_omr_valuelist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_s_omr_value\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_s_omr_value',hdr:ew.language.phrase('ExportToEmailText'),f:document.fs_omr_valuelist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>