<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class s_omr_value_search extends s_omr_value
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 's_omr_value';

	// Page object name
	public $PageObjName = "s_omr_value_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (s_omr_value)
		if (!isset($GLOBALS["s_omr_value"]) || get_class($GLOBALS["s_omr_value"]) == PROJECT_NAMESPACE . "s_omr_value") {
			$GLOBALS["s_omr_value"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["s_omr_value"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 's_omr_value');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $s_omr_value;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($s_omr_value);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "s_omr_valueview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("s_omr_valuelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->roll_no->setVisibility();
		$this->test_id->setVisibility();
		$this->total->setVisibility();
		$this->percent->setVisibility();
		$this->s_1->setVisibility();
		$this->s_2->setVisibility();
		$this->s_3->setVisibility();
		$this->s_4->setVisibility();
		$this->s_5->setVisibility();
		$this->omr_image->setVisibility();
		$this->_1->setVisibility();
		$this->m_1->setVisibility();
		$this->_2->setVisibility();
		$this->m_2->setVisibility();
		$this->_3->setVisibility();
		$this->m_3->setVisibility();
		$this->_4->setVisibility();
		$this->m_4->setVisibility();
		$this->_5->setVisibility();
		$this->m_5->setVisibility();
		$this->_6->setVisibility();
		$this->m_6->setVisibility();
		$this->_7->setVisibility();
		$this->m_7->setVisibility();
		$this->_8->setVisibility();
		$this->m_8->setVisibility();
		$this->_9->setVisibility();
		$this->m_9->setVisibility();
		$this->_10->setVisibility();
		$this->m_10->setVisibility();
		$this->_11->setVisibility();
		$this->m_11->setVisibility();
		$this->_12->setVisibility();
		$this->m_12->setVisibility();
		$this->_13->setVisibility();
		$this->m_13->setVisibility();
		$this->_14->setVisibility();
		$this->m_14->setVisibility();
		$this->_15->setVisibility();
		$this->m_15->setVisibility();
		$this->_16->setVisibility();
		$this->m_16->setVisibility();
		$this->_17->setVisibility();
		$this->m_17->setVisibility();
		$this->_18->setVisibility();
		$this->m_18->setVisibility();
		$this->_19->setVisibility();
		$this->m_19->setVisibility();
		$this->_20->setVisibility();
		$this->m_20->setVisibility();
		$this->_21->setVisibility();
		$this->m_21->setVisibility();
		$this->_22->setVisibility();
		$this->m_22->setVisibility();
		$this->_23->setVisibility();
		$this->m_23->setVisibility();
		$this->_24->setVisibility();
		$this->m_24->setVisibility();
		$this->_25->setVisibility();
		$this->m_25->setVisibility();
		$this->_26->setVisibility();
		$this->m_26->setVisibility();
		$this->_27->setVisibility();
		$this->m_27->setVisibility();
		$this->_28->setVisibility();
		$this->m_28->setVisibility();
		$this->_29->setVisibility();
		$this->m_29->setVisibility();
		$this->_30->setVisibility();
		$this->m_30->setVisibility();
		$this->_31->setVisibility();
		$this->m_31->setVisibility();
		$this->_32->setVisibility();
		$this->m_32->setVisibility();
		$this->_33->setVisibility();
		$this->m_33->setVisibility();
		$this->_34->setVisibility();
		$this->m_34->setVisibility();
		$this->_35->setVisibility();
		$this->m_35->setVisibility();
		$this->_36->setVisibility();
		$this->m_36->setVisibility();
		$this->_37->setVisibility();
		$this->m_37->setVisibility();
		$this->_38->setVisibility();
		$this->m_38->setVisibility();
		$this->_39->setVisibility();
		$this->m_39->setVisibility();
		$this->_40->setVisibility();
		$this->m_40->setVisibility();
		$this->_41->setVisibility();
		$this->m_41->setVisibility();
		$this->_42->setVisibility();
		$this->m_42->setVisibility();
		$this->_43->setVisibility();
		$this->m_43->setVisibility();
		$this->_44->setVisibility();
		$this->m_44->setVisibility();
		$this->_45->setVisibility();
		$this->m_45->setVisibility();
		$this->_46->setVisibility();
		$this->m_46->setVisibility();
		$this->_47->setVisibility();
		$this->m_47->setVisibility();
		$this->_48->setVisibility();
		$this->m_48->setVisibility();
		$this->_49->setVisibility();
		$this->m_49->setVisibility();
		$this->_50->setVisibility();
		$this->m_50->setVisibility();
		$this->_51->setVisibility();
		$this->m_51->setVisibility();
		$this->_52->setVisibility();
		$this->m_52->setVisibility();
		$this->_53->setVisibility();
		$this->m_53->setVisibility();
		$this->_54->setVisibility();
		$this->m_54->setVisibility();
		$this->_55->setVisibility();
		$this->m_55->setVisibility();
		$this->_56->setVisibility();
		$this->m_56->setVisibility();
		$this->_57->setVisibility();
		$this->m_57->setVisibility();
		$this->_58->setVisibility();
		$this->m_58->setVisibility();
		$this->_59->setVisibility();
		$this->m_59->setVisibility();
		$this->_60->setVisibility();
		$this->m_60->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Set up Breadcrumb

		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "s_omr_valuelist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->roll_no); // roll_no
		$this->buildSearchUrl($srchUrl, $this->test_id); // test_id
		$this->buildSearchUrl($srchUrl, $this->total); // total
		$this->buildSearchUrl($srchUrl, $this->percent); // percent
		$this->buildSearchUrl($srchUrl, $this->s_1); // s_1
		$this->buildSearchUrl($srchUrl, $this->s_2); // s_2
		$this->buildSearchUrl($srchUrl, $this->s_3); // s_3
		$this->buildSearchUrl($srchUrl, $this->s_4); // s_4
		$this->buildSearchUrl($srchUrl, $this->s_5); // s_5
		$this->buildSearchUrl($srchUrl, $this->omr_image); // omr_image
		$this->buildSearchUrl($srchUrl, $this->_1); // 1
		$this->buildSearchUrl($srchUrl, $this->m_1); // m_1
		$this->buildSearchUrl($srchUrl, $this->_2); // 2
		$this->buildSearchUrl($srchUrl, $this->m_2); // m_2
		$this->buildSearchUrl($srchUrl, $this->_3); // 3
		$this->buildSearchUrl($srchUrl, $this->m_3); // m_3
		$this->buildSearchUrl($srchUrl, $this->_4); // 4
		$this->buildSearchUrl($srchUrl, $this->m_4); // m_4
		$this->buildSearchUrl($srchUrl, $this->_5); // 5
		$this->buildSearchUrl($srchUrl, $this->m_5); // m_5
		$this->buildSearchUrl($srchUrl, $this->_6); // 6
		$this->buildSearchUrl($srchUrl, $this->m_6); // m_6
		$this->buildSearchUrl($srchUrl, $this->_7); // 7
		$this->buildSearchUrl($srchUrl, $this->m_7); // m_7
		$this->buildSearchUrl($srchUrl, $this->_8); // 8
		$this->buildSearchUrl($srchUrl, $this->m_8); // m_8
		$this->buildSearchUrl($srchUrl, $this->_9); // 9
		$this->buildSearchUrl($srchUrl, $this->m_9); // m_9
		$this->buildSearchUrl($srchUrl, $this->_10); // 10
		$this->buildSearchUrl($srchUrl, $this->m_10); // m_10
		$this->buildSearchUrl($srchUrl, $this->_11); // 11
		$this->buildSearchUrl($srchUrl, $this->m_11); // m_11
		$this->buildSearchUrl($srchUrl, $this->_12); // 12
		$this->buildSearchUrl($srchUrl, $this->m_12); // m_12
		$this->buildSearchUrl($srchUrl, $this->_13); // 13
		$this->buildSearchUrl($srchUrl, $this->m_13); // m_13
		$this->buildSearchUrl($srchUrl, $this->_14); // 14
		$this->buildSearchUrl($srchUrl, $this->m_14); // m_14
		$this->buildSearchUrl($srchUrl, $this->_15); // 15
		$this->buildSearchUrl($srchUrl, $this->m_15); // m_15
		$this->buildSearchUrl($srchUrl, $this->_16); // 16
		$this->buildSearchUrl($srchUrl, $this->m_16); // m_16
		$this->buildSearchUrl($srchUrl, $this->_17); // 17
		$this->buildSearchUrl($srchUrl, $this->m_17); // m_17
		$this->buildSearchUrl($srchUrl, $this->_18); // 18
		$this->buildSearchUrl($srchUrl, $this->m_18); // m_18
		$this->buildSearchUrl($srchUrl, $this->_19); // 19
		$this->buildSearchUrl($srchUrl, $this->m_19); // m_19
		$this->buildSearchUrl($srchUrl, $this->_20); // 20
		$this->buildSearchUrl($srchUrl, $this->m_20); // m_20
		$this->buildSearchUrl($srchUrl, $this->_21); // 21
		$this->buildSearchUrl($srchUrl, $this->m_21); // m_21
		$this->buildSearchUrl($srchUrl, $this->_22); // 22
		$this->buildSearchUrl($srchUrl, $this->m_22); // m_22
		$this->buildSearchUrl($srchUrl, $this->_23); // 23
		$this->buildSearchUrl($srchUrl, $this->m_23); // m_23
		$this->buildSearchUrl($srchUrl, $this->_24); // 24
		$this->buildSearchUrl($srchUrl, $this->m_24); // m_24
		$this->buildSearchUrl($srchUrl, $this->_25); // 25
		$this->buildSearchUrl($srchUrl, $this->m_25); // m_25
		$this->buildSearchUrl($srchUrl, $this->_26); // 26
		$this->buildSearchUrl($srchUrl, $this->m_26); // m_26
		$this->buildSearchUrl($srchUrl, $this->_27); // 27
		$this->buildSearchUrl($srchUrl, $this->m_27); // m_27
		$this->buildSearchUrl($srchUrl, $this->_28); // 28
		$this->buildSearchUrl($srchUrl, $this->m_28); // m_28
		$this->buildSearchUrl($srchUrl, $this->_29); // 29
		$this->buildSearchUrl($srchUrl, $this->m_29); // m_29
		$this->buildSearchUrl($srchUrl, $this->_30); // 30
		$this->buildSearchUrl($srchUrl, $this->m_30); // m_30
		$this->buildSearchUrl($srchUrl, $this->_31); // 31
		$this->buildSearchUrl($srchUrl, $this->m_31); // m_31
		$this->buildSearchUrl($srchUrl, $this->_32); // 32
		$this->buildSearchUrl($srchUrl, $this->m_32); // m_32
		$this->buildSearchUrl($srchUrl, $this->_33); // 33
		$this->buildSearchUrl($srchUrl, $this->m_33); // m_33
		$this->buildSearchUrl($srchUrl, $this->_34); // 34
		$this->buildSearchUrl($srchUrl, $this->m_34); // m_34
		$this->buildSearchUrl($srchUrl, $this->_35); // 35
		$this->buildSearchUrl($srchUrl, $this->m_35); // m_35
		$this->buildSearchUrl($srchUrl, $this->_36); // 36
		$this->buildSearchUrl($srchUrl, $this->m_36); // m_36
		$this->buildSearchUrl($srchUrl, $this->_37); // 37
		$this->buildSearchUrl($srchUrl, $this->m_37); // m_37
		$this->buildSearchUrl($srchUrl, $this->_38); // 38
		$this->buildSearchUrl($srchUrl, $this->m_38); // m_38
		$this->buildSearchUrl($srchUrl, $this->_39); // 39
		$this->buildSearchUrl($srchUrl, $this->m_39); // m_39
		$this->buildSearchUrl($srchUrl, $this->_40); // 40
		$this->buildSearchUrl($srchUrl, $this->m_40); // m_40
		$this->buildSearchUrl($srchUrl, $this->_41); // 41
		$this->buildSearchUrl($srchUrl, $this->m_41); // m_41
		$this->buildSearchUrl($srchUrl, $this->_42); // 42
		$this->buildSearchUrl($srchUrl, $this->m_42); // m_42
		$this->buildSearchUrl($srchUrl, $this->_43); // 43
		$this->buildSearchUrl($srchUrl, $this->m_43); // m_43
		$this->buildSearchUrl($srchUrl, $this->_44); // 44
		$this->buildSearchUrl($srchUrl, $this->m_44); // m_44
		$this->buildSearchUrl($srchUrl, $this->_45); // 45
		$this->buildSearchUrl($srchUrl, $this->m_45); // m_45
		$this->buildSearchUrl($srchUrl, $this->_46); // 46
		$this->buildSearchUrl($srchUrl, $this->m_46); // m_46
		$this->buildSearchUrl($srchUrl, $this->_47); // 47
		$this->buildSearchUrl($srchUrl, $this->m_47); // m_47
		$this->buildSearchUrl($srchUrl, $this->_48); // 48
		$this->buildSearchUrl($srchUrl, $this->m_48); // m_48
		$this->buildSearchUrl($srchUrl, $this->_49); // 49
		$this->buildSearchUrl($srchUrl, $this->m_49); // m_49
		$this->buildSearchUrl($srchUrl, $this->_50); // 50
		$this->buildSearchUrl($srchUrl, $this->m_50); // m_50
		$this->buildSearchUrl($srchUrl, $this->_51); // 51
		$this->buildSearchUrl($srchUrl, $this->m_51); // m_51
		$this->buildSearchUrl($srchUrl, $this->_52); // 52
		$this->buildSearchUrl($srchUrl, $this->m_52); // m_52
		$this->buildSearchUrl($srchUrl, $this->_53); // 53
		$this->buildSearchUrl($srchUrl, $this->m_53); // m_53
		$this->buildSearchUrl($srchUrl, $this->_54); // 54
		$this->buildSearchUrl($srchUrl, $this->m_54); // m_54
		$this->buildSearchUrl($srchUrl, $this->_55); // 55
		$this->buildSearchUrl($srchUrl, $this->m_55); // m_55
		$this->buildSearchUrl($srchUrl, $this->_56); // 56
		$this->buildSearchUrl($srchUrl, $this->m_56); // m_56
		$this->buildSearchUrl($srchUrl, $this->_57); // 57
		$this->buildSearchUrl($srchUrl, $this->m_57); // m_57
		$this->buildSearchUrl($srchUrl, $this->_58); // 58
		$this->buildSearchUrl($srchUrl, $this->m_58); // m_58
		$this->buildSearchUrl($srchUrl, $this->_59); // 59
		$this->buildSearchUrl($srchUrl, $this->m_59); // m_59
		$this->buildSearchUrl($srchUrl, $this->_60); // 60
		$this->buildSearchUrl($srchUrl, $this->m_60); // m_60
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// roll_no
		if (!$this->isAddOrEdit())
			$this->roll_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_roll_no"));
		$this->roll_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_roll_no"));

		// test_id
		if (!$this->isAddOrEdit())
			$this->test_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_test_id"));
		$this->test_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_test_id"));

		// total
		if (!$this->isAddOrEdit())
			$this->total->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_total"));
		$this->total->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_total"));
		$this->total->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_total"));
		$this->total->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_total"));
		$this->total->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_total"));

		// percent
		if (!$this->isAddOrEdit())
			$this->percent->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_percent"));
		$this->percent->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_percent"));
		$this->percent->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_percent"));
		$this->percent->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_percent"));
		$this->percent->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_percent"));

		// s_1
		if (!$this->isAddOrEdit())
			$this->s_1->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_1"));
		$this->s_1->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_1"));

		// s_2
		if (!$this->isAddOrEdit())
			$this->s_2->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_2"));
		$this->s_2->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_2"));

		// s_3
		if (!$this->isAddOrEdit())
			$this->s_3->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_3"));
		$this->s_3->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_3"));

		// s_4
		if (!$this->isAddOrEdit())
			$this->s_4->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_4"));
		$this->s_4->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_4"));

		// s_5
		if (!$this->isAddOrEdit())
			$this->s_5->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_5"));
		$this->s_5->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_5"));

		// omr_image
		if (!$this->isAddOrEdit())
			$this->omr_image->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_omr_image"));
		$this->omr_image->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_omr_image"));

		// 1
		if (!$this->isAddOrEdit())
			$this->_1->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__1"));
		$this->_1->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__1"));

		// m_1
		if (!$this->isAddOrEdit())
			$this->m_1->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_1"));
		$this->m_1->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_1"));

		// 2
		if (!$this->isAddOrEdit())
			$this->_2->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__2"));
		$this->_2->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__2"));

		// m_2
		if (!$this->isAddOrEdit())
			$this->m_2->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_2"));
		$this->m_2->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_2"));

		// 3
		if (!$this->isAddOrEdit())
			$this->_3->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__3"));
		$this->_3->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__3"));

		// m_3
		if (!$this->isAddOrEdit())
			$this->m_3->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_3"));
		$this->m_3->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_3"));

		// 4
		if (!$this->isAddOrEdit())
			$this->_4->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__4"));
		$this->_4->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__4"));

		// m_4
		if (!$this->isAddOrEdit())
			$this->m_4->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_4"));
		$this->m_4->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_4"));

		// 5
		if (!$this->isAddOrEdit())
			$this->_5->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__5"));
		$this->_5->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__5"));

		// m_5
		if (!$this->isAddOrEdit())
			$this->m_5->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_5"));
		$this->m_5->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_5"));

		// 6
		if (!$this->isAddOrEdit())
			$this->_6->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__6"));
		$this->_6->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__6"));

		// m_6
		if (!$this->isAddOrEdit())
			$this->m_6->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_6"));
		$this->m_6->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_6"));

		// 7
		if (!$this->isAddOrEdit())
			$this->_7->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__7"));
		$this->_7->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__7"));

		// m_7
		if (!$this->isAddOrEdit())
			$this->m_7->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_7"));
		$this->m_7->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_7"));

		// 8
		if (!$this->isAddOrEdit())
			$this->_8->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__8"));
		$this->_8->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__8"));

		// m_8
		if (!$this->isAddOrEdit())
			$this->m_8->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_8"));
		$this->m_8->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_8"));

		// 9
		if (!$this->isAddOrEdit())
			$this->_9->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__9"));
		$this->_9->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__9"));

		// m_9
		if (!$this->isAddOrEdit())
			$this->m_9->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_9"));
		$this->m_9->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_9"));

		// 10
		if (!$this->isAddOrEdit())
			$this->_10->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__10"));
		$this->_10->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__10"));

		// m_10
		if (!$this->isAddOrEdit())
			$this->m_10->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_10"));
		$this->m_10->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_10"));

		// 11
		if (!$this->isAddOrEdit())
			$this->_11->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__11"));
		$this->_11->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__11"));

		// m_11
		if (!$this->isAddOrEdit())
			$this->m_11->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_11"));
		$this->m_11->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_11"));

		// 12
		if (!$this->isAddOrEdit())
			$this->_12->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__12"));
		$this->_12->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__12"));

		// m_12
		if (!$this->isAddOrEdit())
			$this->m_12->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_12"));
		$this->m_12->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_12"));

		// 13
		if (!$this->isAddOrEdit())
			$this->_13->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__13"));
		$this->_13->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__13"));

		// m_13
		if (!$this->isAddOrEdit())
			$this->m_13->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_13"));
		$this->m_13->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_13"));

		// 14
		if (!$this->isAddOrEdit())
			$this->_14->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__14"));
		$this->_14->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__14"));

		// m_14
		if (!$this->isAddOrEdit())
			$this->m_14->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_14"));
		$this->m_14->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_14"));

		// 15
		if (!$this->isAddOrEdit())
			$this->_15->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__15"));
		$this->_15->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__15"));

		// m_15
		if (!$this->isAddOrEdit())
			$this->m_15->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_15"));
		$this->m_15->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_15"));

		// 16
		if (!$this->isAddOrEdit())
			$this->_16->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__16"));
		$this->_16->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__16"));

		// m_16
		if (!$this->isAddOrEdit())
			$this->m_16->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_16"));
		$this->m_16->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_16"));

		// 17
		if (!$this->isAddOrEdit())
			$this->_17->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__17"));
		$this->_17->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__17"));

		// m_17
		if (!$this->isAddOrEdit())
			$this->m_17->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_17"));
		$this->m_17->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_17"));

		// 18
		if (!$this->isAddOrEdit())
			$this->_18->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__18"));
		$this->_18->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__18"));

		// m_18
		if (!$this->isAddOrEdit())
			$this->m_18->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_18"));
		$this->m_18->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_18"));

		// 19
		if (!$this->isAddOrEdit())
			$this->_19->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__19"));
		$this->_19->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__19"));

		// m_19
		if (!$this->isAddOrEdit())
			$this->m_19->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_19"));
		$this->m_19->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_19"));

		// 20
		if (!$this->isAddOrEdit())
			$this->_20->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__20"));
		$this->_20->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__20"));

		// m_20
		if (!$this->isAddOrEdit())
			$this->m_20->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_20"));
		$this->m_20->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_20"));

		// 21
		if (!$this->isAddOrEdit())
			$this->_21->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__21"));
		$this->_21->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__21"));

		// m_21
		if (!$this->isAddOrEdit())
			$this->m_21->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_21"));
		$this->m_21->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_21"));

		// 22
		if (!$this->isAddOrEdit())
			$this->_22->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__22"));
		$this->_22->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__22"));

		// m_22
		if (!$this->isAddOrEdit())
			$this->m_22->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_22"));
		$this->m_22->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_22"));

		// 23
		if (!$this->isAddOrEdit())
			$this->_23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__23"));
		$this->_23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__23"));

		// m_23
		if (!$this->isAddOrEdit())
			$this->m_23->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_23"));
		$this->m_23->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_23"));

		// 24
		if (!$this->isAddOrEdit())
			$this->_24->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__24"));
		$this->_24->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__24"));

		// m_24
		if (!$this->isAddOrEdit())
			$this->m_24->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_24"));
		$this->m_24->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_24"));

		// 25
		if (!$this->isAddOrEdit())
			$this->_25->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__25"));
		$this->_25->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__25"));

		// m_25
		if (!$this->isAddOrEdit())
			$this->m_25->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_25"));
		$this->m_25->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_25"));

		// 26
		if (!$this->isAddOrEdit())
			$this->_26->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__26"));
		$this->_26->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__26"));

		// m_26
		if (!$this->isAddOrEdit())
			$this->m_26->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_26"));
		$this->m_26->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_26"));

		// 27
		if (!$this->isAddOrEdit())
			$this->_27->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__27"));
		$this->_27->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__27"));

		// m_27
		if (!$this->isAddOrEdit())
			$this->m_27->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_27"));
		$this->m_27->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_27"));

		// 28
		if (!$this->isAddOrEdit())
			$this->_28->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__28"));
		$this->_28->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__28"));

		// m_28
		if (!$this->isAddOrEdit())
			$this->m_28->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_28"));
		$this->m_28->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_28"));

		// 29
		if (!$this->isAddOrEdit())
			$this->_29->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__29"));
		$this->_29->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__29"));

		// m_29
		if (!$this->isAddOrEdit())
			$this->m_29->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_29"));
		$this->m_29->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_29"));

		// 30
		if (!$this->isAddOrEdit())
			$this->_30->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__30"));
		$this->_30->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__30"));

		// m_30
		if (!$this->isAddOrEdit())
			$this->m_30->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_30"));
		$this->m_30->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_30"));

		// 31
		if (!$this->isAddOrEdit())
			$this->_31->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__31"));
		$this->_31->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__31"));

		// m_31
		if (!$this->isAddOrEdit())
			$this->m_31->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_31"));
		$this->m_31->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_31"));

		// 32
		if (!$this->isAddOrEdit())
			$this->_32->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__32"));
		$this->_32->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__32"));

		// m_32
		if (!$this->isAddOrEdit())
			$this->m_32->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_32"));
		$this->m_32->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_32"));

		// 33
		if (!$this->isAddOrEdit())
			$this->_33->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__33"));
		$this->_33->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__33"));

		// m_33
		if (!$this->isAddOrEdit())
			$this->m_33->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_33"));
		$this->m_33->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_33"));

		// 34
		if (!$this->isAddOrEdit())
			$this->_34->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__34"));
		$this->_34->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__34"));

		// m_34
		if (!$this->isAddOrEdit())
			$this->m_34->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_34"));
		$this->m_34->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_34"));

		// 35
		if (!$this->isAddOrEdit())
			$this->_35->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__35"));
		$this->_35->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__35"));

		// m_35
		if (!$this->isAddOrEdit())
			$this->m_35->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_35"));
		$this->m_35->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_35"));

		// 36
		if (!$this->isAddOrEdit())
			$this->_36->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__36"));
		$this->_36->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__36"));

		// m_36
		if (!$this->isAddOrEdit())
			$this->m_36->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_36"));
		$this->m_36->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_36"));

		// 37
		if (!$this->isAddOrEdit())
			$this->_37->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__37"));
		$this->_37->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__37"));

		// m_37
		if (!$this->isAddOrEdit())
			$this->m_37->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_37"));
		$this->m_37->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_37"));

		// 38
		if (!$this->isAddOrEdit())
			$this->_38->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__38"));
		$this->_38->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__38"));

		// m_38
		if (!$this->isAddOrEdit())
			$this->m_38->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_38"));
		$this->m_38->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_38"));

		// 39
		if (!$this->isAddOrEdit())
			$this->_39->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__39"));
		$this->_39->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__39"));

		// m_39
		if (!$this->isAddOrEdit())
			$this->m_39->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_39"));
		$this->m_39->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_39"));

		// 40
		if (!$this->isAddOrEdit())
			$this->_40->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__40"));
		$this->_40->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__40"));

		// m_40
		if (!$this->isAddOrEdit())
			$this->m_40->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_40"));
		$this->m_40->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_40"));

		// 41
		if (!$this->isAddOrEdit())
			$this->_41->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__41"));
		$this->_41->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__41"));

		// m_41
		if (!$this->isAddOrEdit())
			$this->m_41->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_41"));
		$this->m_41->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_41"));

		// 42
		if (!$this->isAddOrEdit())
			$this->_42->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__42"));
		$this->_42->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__42"));

		// m_42
		if (!$this->isAddOrEdit())
			$this->m_42->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_42"));
		$this->m_42->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_42"));

		// 43
		if (!$this->isAddOrEdit())
			$this->_43->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__43"));
		$this->_43->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__43"));

		// m_43
		if (!$this->isAddOrEdit())
			$this->m_43->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_43"));
		$this->m_43->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_43"));

		// 44
		if (!$this->isAddOrEdit())
			$this->_44->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__44"));
		$this->_44->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__44"));

		// m_44
		if (!$this->isAddOrEdit())
			$this->m_44->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_44"));
		$this->m_44->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_44"));

		// 45
		if (!$this->isAddOrEdit())
			$this->_45->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__45"));
		$this->_45->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__45"));

		// m_45
		if (!$this->isAddOrEdit())
			$this->m_45->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_45"));
		$this->m_45->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_45"));

		// 46
		if (!$this->isAddOrEdit())
			$this->_46->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__46"));
		$this->_46->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__46"));

		// m_46
		if (!$this->isAddOrEdit())
			$this->m_46->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_46"));
		$this->m_46->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_46"));

		// 47
		if (!$this->isAddOrEdit())
			$this->_47->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__47"));
		$this->_47->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__47"));

		// m_47
		if (!$this->isAddOrEdit())
			$this->m_47->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_47"));
		$this->m_47->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_47"));

		// 48
		if (!$this->isAddOrEdit())
			$this->_48->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__48"));
		$this->_48->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__48"));

		// m_48
		if (!$this->isAddOrEdit())
			$this->m_48->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_48"));
		$this->m_48->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_48"));

		// 49
		if (!$this->isAddOrEdit())
			$this->_49->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__49"));
		$this->_49->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__49"));

		// m_49
		if (!$this->isAddOrEdit())
			$this->m_49->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_49"));
		$this->m_49->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_49"));

		// 50
		if (!$this->isAddOrEdit())
			$this->_50->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__50"));
		$this->_50->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__50"));

		// m_50
		if (!$this->isAddOrEdit())
			$this->m_50->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_50"));
		$this->m_50->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_50"));

		// 51
		if (!$this->isAddOrEdit())
			$this->_51->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__51"));
		$this->_51->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__51"));

		// m_51
		if (!$this->isAddOrEdit())
			$this->m_51->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_51"));
		$this->m_51->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_51"));

		// 52
		if (!$this->isAddOrEdit())
			$this->_52->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__52"));
		$this->_52->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__52"));

		// m_52
		if (!$this->isAddOrEdit())
			$this->m_52->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_52"));
		$this->m_52->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_52"));

		// 53
		if (!$this->isAddOrEdit())
			$this->_53->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__53"));
		$this->_53->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__53"));

		// m_53
		if (!$this->isAddOrEdit())
			$this->m_53->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_53"));
		$this->m_53->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_53"));

		// 54
		if (!$this->isAddOrEdit())
			$this->_54->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__54"));
		$this->_54->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__54"));

		// m_54
		if (!$this->isAddOrEdit())
			$this->m_54->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_54"));
		$this->m_54->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_54"));

		// 55
		if (!$this->isAddOrEdit())
			$this->_55->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__55"));
		$this->_55->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__55"));

		// m_55
		if (!$this->isAddOrEdit())
			$this->m_55->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_55"));
		$this->m_55->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_55"));

		// 56
		if (!$this->isAddOrEdit())
			$this->_56->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__56"));
		$this->_56->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__56"));

		// m_56
		if (!$this->isAddOrEdit())
			$this->m_56->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_56"));
		$this->m_56->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_56"));

		// 57
		if (!$this->isAddOrEdit())
			$this->_57->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__57"));
		$this->_57->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__57"));

		// m_57
		if (!$this->isAddOrEdit())
			$this->m_57->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_57"));
		$this->m_57->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_57"));

		// 58
		if (!$this->isAddOrEdit())
			$this->_58->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__58"));
		$this->_58->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__58"));

		// m_58
		if (!$this->isAddOrEdit())
			$this->m_58->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_58"));
		$this->m_58->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_58"));

		// 59
		if (!$this->isAddOrEdit())
			$this->_59->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__59"));
		$this->_59->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__59"));

		// m_59
		if (!$this->isAddOrEdit())
			$this->m_59->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_59"));
		$this->m_59->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_59"));

		// 60
		if (!$this->isAddOrEdit())
			$this->_60->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__60"));
		$this->_60->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__60"));

		// m_60
		if (!$this->isAddOrEdit())
			$this->m_60->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_60"));
		$this->m_60->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_60"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->total->FormValue == $this->total->CurrentValue && is_numeric(ConvertToFloatString($this->total->CurrentValue)))
			$this->total->CurrentValue = ConvertToFloatString($this->total->CurrentValue);

		// Convert decimal values if posted back
		if ($this->percent->FormValue == $this->percent->CurrentValue && is_numeric(ConvertToFloatString($this->percent->CurrentValue)))
			$this->percent->CurrentValue = ConvertToFloatString($this->percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_1->FormValue == $this->s_1->CurrentValue && is_numeric(ConvertToFloatString($this->s_1->CurrentValue)))
			$this->s_1->CurrentValue = ConvertToFloatString($this->s_1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_2->FormValue == $this->s_2->CurrentValue && is_numeric(ConvertToFloatString($this->s_2->CurrentValue)))
			$this->s_2->CurrentValue = ConvertToFloatString($this->s_2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_3->FormValue == $this->s_3->CurrentValue && is_numeric(ConvertToFloatString($this->s_3->CurrentValue)))
			$this->s_3->CurrentValue = ConvertToFloatString($this->s_3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_4->FormValue == $this->s_4->CurrentValue && is_numeric(ConvertToFloatString($this->s_4->CurrentValue)))
			$this->s_4->CurrentValue = ConvertToFloatString($this->s_4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_5->FormValue == $this->s_5->CurrentValue && is_numeric(ConvertToFloatString($this->s_5->CurrentValue)))
			$this->s_5->CurrentValue = ConvertToFloatString($this->s_5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_1->FormValue == $this->m_1->CurrentValue && is_numeric(ConvertToFloatString($this->m_1->CurrentValue)))
			$this->m_1->CurrentValue = ConvertToFloatString($this->m_1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_2->FormValue == $this->m_2->CurrentValue && is_numeric(ConvertToFloatString($this->m_2->CurrentValue)))
			$this->m_2->CurrentValue = ConvertToFloatString($this->m_2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_3->FormValue == $this->m_3->CurrentValue && is_numeric(ConvertToFloatString($this->m_3->CurrentValue)))
			$this->m_3->CurrentValue = ConvertToFloatString($this->m_3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_4->FormValue == $this->m_4->CurrentValue && is_numeric(ConvertToFloatString($this->m_4->CurrentValue)))
			$this->m_4->CurrentValue = ConvertToFloatString($this->m_4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_5->FormValue == $this->m_5->CurrentValue && is_numeric(ConvertToFloatString($this->m_5->CurrentValue)))
			$this->m_5->CurrentValue = ConvertToFloatString($this->m_5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_6->FormValue == $this->m_6->CurrentValue && is_numeric(ConvertToFloatString($this->m_6->CurrentValue)))
			$this->m_6->CurrentValue = ConvertToFloatString($this->m_6->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_7->FormValue == $this->m_7->CurrentValue && is_numeric(ConvertToFloatString($this->m_7->CurrentValue)))
			$this->m_7->CurrentValue = ConvertToFloatString($this->m_7->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_8->FormValue == $this->m_8->CurrentValue && is_numeric(ConvertToFloatString($this->m_8->CurrentValue)))
			$this->m_8->CurrentValue = ConvertToFloatString($this->m_8->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_9->FormValue == $this->m_9->CurrentValue && is_numeric(ConvertToFloatString($this->m_9->CurrentValue)))
			$this->m_9->CurrentValue = ConvertToFloatString($this->m_9->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_10->FormValue == $this->m_10->CurrentValue && is_numeric(ConvertToFloatString($this->m_10->CurrentValue)))
			$this->m_10->CurrentValue = ConvertToFloatString($this->m_10->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_11->FormValue == $this->m_11->CurrentValue && is_numeric(ConvertToFloatString($this->m_11->CurrentValue)))
			$this->m_11->CurrentValue = ConvertToFloatString($this->m_11->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_12->FormValue == $this->m_12->CurrentValue && is_numeric(ConvertToFloatString($this->m_12->CurrentValue)))
			$this->m_12->CurrentValue = ConvertToFloatString($this->m_12->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_13->FormValue == $this->m_13->CurrentValue && is_numeric(ConvertToFloatString($this->m_13->CurrentValue)))
			$this->m_13->CurrentValue = ConvertToFloatString($this->m_13->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_14->FormValue == $this->m_14->CurrentValue && is_numeric(ConvertToFloatString($this->m_14->CurrentValue)))
			$this->m_14->CurrentValue = ConvertToFloatString($this->m_14->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_15->FormValue == $this->m_15->CurrentValue && is_numeric(ConvertToFloatString($this->m_15->CurrentValue)))
			$this->m_15->CurrentValue = ConvertToFloatString($this->m_15->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_16->FormValue == $this->m_16->CurrentValue && is_numeric(ConvertToFloatString($this->m_16->CurrentValue)))
			$this->m_16->CurrentValue = ConvertToFloatString($this->m_16->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_17->FormValue == $this->m_17->CurrentValue && is_numeric(ConvertToFloatString($this->m_17->CurrentValue)))
			$this->m_17->CurrentValue = ConvertToFloatString($this->m_17->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_18->FormValue == $this->m_18->CurrentValue && is_numeric(ConvertToFloatString($this->m_18->CurrentValue)))
			$this->m_18->CurrentValue = ConvertToFloatString($this->m_18->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_19->FormValue == $this->m_19->CurrentValue && is_numeric(ConvertToFloatString($this->m_19->CurrentValue)))
			$this->m_19->CurrentValue = ConvertToFloatString($this->m_19->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_20->FormValue == $this->m_20->CurrentValue && is_numeric(ConvertToFloatString($this->m_20->CurrentValue)))
			$this->m_20->CurrentValue = ConvertToFloatString($this->m_20->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_21->FormValue == $this->m_21->CurrentValue && is_numeric(ConvertToFloatString($this->m_21->CurrentValue)))
			$this->m_21->CurrentValue = ConvertToFloatString($this->m_21->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_22->FormValue == $this->m_22->CurrentValue && is_numeric(ConvertToFloatString($this->m_22->CurrentValue)))
			$this->m_22->CurrentValue = ConvertToFloatString($this->m_22->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_23->FormValue == $this->m_23->CurrentValue && is_numeric(ConvertToFloatString($this->m_23->CurrentValue)))
			$this->m_23->CurrentValue = ConvertToFloatString($this->m_23->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_24->FormValue == $this->m_24->CurrentValue && is_numeric(ConvertToFloatString($this->m_24->CurrentValue)))
			$this->m_24->CurrentValue = ConvertToFloatString($this->m_24->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_25->FormValue == $this->m_25->CurrentValue && is_numeric(ConvertToFloatString($this->m_25->CurrentValue)))
			$this->m_25->CurrentValue = ConvertToFloatString($this->m_25->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_26->FormValue == $this->m_26->CurrentValue && is_numeric(ConvertToFloatString($this->m_26->CurrentValue)))
			$this->m_26->CurrentValue = ConvertToFloatString($this->m_26->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_27->FormValue == $this->m_27->CurrentValue && is_numeric(ConvertToFloatString($this->m_27->CurrentValue)))
			$this->m_27->CurrentValue = ConvertToFloatString($this->m_27->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_28->FormValue == $this->m_28->CurrentValue && is_numeric(ConvertToFloatString($this->m_28->CurrentValue)))
			$this->m_28->CurrentValue = ConvertToFloatString($this->m_28->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_29->FormValue == $this->m_29->CurrentValue && is_numeric(ConvertToFloatString($this->m_29->CurrentValue)))
			$this->m_29->CurrentValue = ConvertToFloatString($this->m_29->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_30->FormValue == $this->m_30->CurrentValue && is_numeric(ConvertToFloatString($this->m_30->CurrentValue)))
			$this->m_30->CurrentValue = ConvertToFloatString($this->m_30->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_31->FormValue == $this->m_31->CurrentValue && is_numeric(ConvertToFloatString($this->m_31->CurrentValue)))
			$this->m_31->CurrentValue = ConvertToFloatString($this->m_31->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_32->FormValue == $this->m_32->CurrentValue && is_numeric(ConvertToFloatString($this->m_32->CurrentValue)))
			$this->m_32->CurrentValue = ConvertToFloatString($this->m_32->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_33->FormValue == $this->m_33->CurrentValue && is_numeric(ConvertToFloatString($this->m_33->CurrentValue)))
			$this->m_33->CurrentValue = ConvertToFloatString($this->m_33->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_34->FormValue == $this->m_34->CurrentValue && is_numeric(ConvertToFloatString($this->m_34->CurrentValue)))
			$this->m_34->CurrentValue = ConvertToFloatString($this->m_34->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_35->FormValue == $this->m_35->CurrentValue && is_numeric(ConvertToFloatString($this->m_35->CurrentValue)))
			$this->m_35->CurrentValue = ConvertToFloatString($this->m_35->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_36->FormValue == $this->m_36->CurrentValue && is_numeric(ConvertToFloatString($this->m_36->CurrentValue)))
			$this->m_36->CurrentValue = ConvertToFloatString($this->m_36->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_37->FormValue == $this->m_37->CurrentValue && is_numeric(ConvertToFloatString($this->m_37->CurrentValue)))
			$this->m_37->CurrentValue = ConvertToFloatString($this->m_37->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_38->FormValue == $this->m_38->CurrentValue && is_numeric(ConvertToFloatString($this->m_38->CurrentValue)))
			$this->m_38->CurrentValue = ConvertToFloatString($this->m_38->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_39->FormValue == $this->m_39->CurrentValue && is_numeric(ConvertToFloatString($this->m_39->CurrentValue)))
			$this->m_39->CurrentValue = ConvertToFloatString($this->m_39->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_40->FormValue == $this->m_40->CurrentValue && is_numeric(ConvertToFloatString($this->m_40->CurrentValue)))
			$this->m_40->CurrentValue = ConvertToFloatString($this->m_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_41->FormValue == $this->m_41->CurrentValue && is_numeric(ConvertToFloatString($this->m_41->CurrentValue)))
			$this->m_41->CurrentValue = ConvertToFloatString($this->m_41->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_42->FormValue == $this->m_42->CurrentValue && is_numeric(ConvertToFloatString($this->m_42->CurrentValue)))
			$this->m_42->CurrentValue = ConvertToFloatString($this->m_42->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_43->FormValue == $this->m_43->CurrentValue && is_numeric(ConvertToFloatString($this->m_43->CurrentValue)))
			$this->m_43->CurrentValue = ConvertToFloatString($this->m_43->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_44->FormValue == $this->m_44->CurrentValue && is_numeric(ConvertToFloatString($this->m_44->CurrentValue)))
			$this->m_44->CurrentValue = ConvertToFloatString($this->m_44->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_45->FormValue == $this->m_45->CurrentValue && is_numeric(ConvertToFloatString($this->m_45->CurrentValue)))
			$this->m_45->CurrentValue = ConvertToFloatString($this->m_45->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_46->FormValue == $this->m_46->CurrentValue && is_numeric(ConvertToFloatString($this->m_46->CurrentValue)))
			$this->m_46->CurrentValue = ConvertToFloatString($this->m_46->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_47->FormValue == $this->m_47->CurrentValue && is_numeric(ConvertToFloatString($this->m_47->CurrentValue)))
			$this->m_47->CurrentValue = ConvertToFloatString($this->m_47->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_48->FormValue == $this->m_48->CurrentValue && is_numeric(ConvertToFloatString($this->m_48->CurrentValue)))
			$this->m_48->CurrentValue = ConvertToFloatString($this->m_48->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_49->FormValue == $this->m_49->CurrentValue && is_numeric(ConvertToFloatString($this->m_49->CurrentValue)))
			$this->m_49->CurrentValue = ConvertToFloatString($this->m_49->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_50->FormValue == $this->m_50->CurrentValue && is_numeric(ConvertToFloatString($this->m_50->CurrentValue)))
			$this->m_50->CurrentValue = ConvertToFloatString($this->m_50->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_51->FormValue == $this->m_51->CurrentValue && is_numeric(ConvertToFloatString($this->m_51->CurrentValue)))
			$this->m_51->CurrentValue = ConvertToFloatString($this->m_51->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_52->FormValue == $this->m_52->CurrentValue && is_numeric(ConvertToFloatString($this->m_52->CurrentValue)))
			$this->m_52->CurrentValue = ConvertToFloatString($this->m_52->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_53->FormValue == $this->m_53->CurrentValue && is_numeric(ConvertToFloatString($this->m_53->CurrentValue)))
			$this->m_53->CurrentValue = ConvertToFloatString($this->m_53->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_54->FormValue == $this->m_54->CurrentValue && is_numeric(ConvertToFloatString($this->m_54->CurrentValue)))
			$this->m_54->CurrentValue = ConvertToFloatString($this->m_54->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_55->FormValue == $this->m_55->CurrentValue && is_numeric(ConvertToFloatString($this->m_55->CurrentValue)))
			$this->m_55->CurrentValue = ConvertToFloatString($this->m_55->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_56->FormValue == $this->m_56->CurrentValue && is_numeric(ConvertToFloatString($this->m_56->CurrentValue)))
			$this->m_56->CurrentValue = ConvertToFloatString($this->m_56->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_57->FormValue == $this->m_57->CurrentValue && is_numeric(ConvertToFloatString($this->m_57->CurrentValue)))
			$this->m_57->CurrentValue = ConvertToFloatString($this->m_57->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_58->FormValue == $this->m_58->CurrentValue && is_numeric(ConvertToFloatString($this->m_58->CurrentValue)))
			$this->m_58->CurrentValue = ConvertToFloatString($this->m_58->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_59->FormValue == $this->m_59->CurrentValue && is_numeric(ConvertToFloatString($this->m_59->CurrentValue)))
			$this->m_59->CurrentValue = ConvertToFloatString($this->m_59->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_60->FormValue == $this->m_60->CurrentValue && is_numeric(ConvertToFloatString($this->m_60->CurrentValue)))
			$this->m_60->CurrentValue = ConvertToFloatString($this->m_60->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// roll_no
		// test_id
		// total
		// percent
		// s_1
		// s_2
		// s_3
		// s_4
		// s_5
		// omr_image
		// 1
		// m_1
		// 2
		// m_2
		// 3
		// m_3
		// 4
		// m_4
		// 5
		// m_5
		// 6
		// m_6
		// 7
		// m_7
		// 8
		// m_8
		// 9
		// m_9
		// 10
		// m_10
		// 11
		// m_11
		// 12
		// m_12
		// 13
		// m_13
		// 14
		// m_14
		// 15
		// m_15
		// 16
		// m_16
		// 17
		// m_17
		// 18
		// m_18
		// 19
		// m_19
		// 20
		// m_20
		// 21
		// m_21
		// 22
		// m_22
		// 23
		// m_23
		// 24
		// m_24
		// 25
		// m_25
		// 26
		// m_26
		// 27
		// m_27
		// 28
		// m_28
		// 29
		// m_29
		// 30
		// m_30
		// 31
		// m_31
		// 32
		// m_32
		// 33
		// m_33
		// 34
		// m_34
		// 35
		// m_35
		// 36
		// m_36
		// 37
		// m_37
		// 38
		// m_38
		// 39
		// m_39
		// 40
		// m_40
		// 41
		// m_41
		// 42
		// m_42
		// 43
		// m_43
		// 44
		// m_44
		// 45
		// m_45
		// 46
		// m_46
		// 47
		// m_47
		// 48
		// m_48
		// 49
		// m_49
		// 50
		// m_50
		// 51
		// m_51
		// 52
		// m_52
		// 53
		// m_53
		// 54
		// m_54
		// 55
		// m_55
		// 56
		// m_56
		// 57
		// m_57
		// 58
		// m_58
		// 59
		// m_59
		// 60
		// m_60

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewCustomAttributes = "";

			// test_id
			$this->test_id->ViewValue = $this->test_id->CurrentValue;
			$this->test_id->ViewCustomAttributes = "";

			// total
			$this->total->ViewValue = $this->total->CurrentValue;
			$this->total->ViewValue = FormatNumber($this->total->ViewValue, 2, -2, -2, -2);
			$this->total->ViewCustomAttributes = "";

			// percent
			$this->percent->ViewValue = $this->percent->CurrentValue;
			$this->percent->ViewValue = FormatNumber($this->percent->ViewValue, 2, -2, -2, -2);
			$this->percent->ViewCustomAttributes = "";

			// s_1
			$this->s_1->ViewValue = $this->s_1->CurrentValue;
			$this->s_1->ViewValue = FormatNumber($this->s_1->ViewValue, 2, -2, -2, -2);
			$this->s_1->ViewCustomAttributes = "";

			// s_2
			$this->s_2->ViewValue = $this->s_2->CurrentValue;
			$this->s_2->ViewValue = FormatNumber($this->s_2->ViewValue, 2, -2, -2, -2);
			$this->s_2->ViewCustomAttributes = "";

			// s_3
			$this->s_3->ViewValue = $this->s_3->CurrentValue;
			$this->s_3->ViewValue = FormatNumber($this->s_3->ViewValue, 2, -2, -2, -2);
			$this->s_3->ViewCustomAttributes = "";

			// s_4
			$this->s_4->ViewValue = $this->s_4->CurrentValue;
			$this->s_4->ViewValue = FormatNumber($this->s_4->ViewValue, 2, -2, -2, -2);
			$this->s_4->ViewCustomAttributes = "";

			// s_5
			$this->s_5->ViewValue = $this->s_5->CurrentValue;
			$this->s_5->ViewValue = FormatNumber($this->s_5->ViewValue, 2, -2, -2, -2);
			$this->s_5->ViewCustomAttributes = "";

			// omr_image
			$this->omr_image->UploadPath = '.p_uploads/school/omr/';
			if (!EmptyValue($this->omr_image->Upload->DbValue)) {
				$this->omr_image->ImageWidth = 0;
				$this->omr_image->ImageHeight = 50;
				$this->omr_image->ImageAlt = $this->omr_image->alt();
				$this->omr_image->ViewValue = $this->omr_image->Upload->DbValue;
			} else {
				$this->omr_image->ViewValue = "";
			}
			$this->omr_image->ViewCustomAttributes = "";

			// 1
			$this->_1->ViewValue = $this->_1->CurrentValue;
			$this->_1->ViewCustomAttributes = "";

			// m_1
			$this->m_1->ViewValue = $this->m_1->CurrentValue;
			$this->m_1->ViewValue = FormatNumber($this->m_1->ViewValue, 2, -2, -2, -2);
			$this->m_1->ViewCustomAttributes = "";

			// 2
			$this->_2->ViewValue = $this->_2->CurrentValue;
			$this->_2->ViewCustomAttributes = "";

			// m_2
			$this->m_2->ViewValue = $this->m_2->CurrentValue;
			$this->m_2->ViewValue = FormatNumber($this->m_2->ViewValue, 2, -2, -2, -2);
			$this->m_2->ViewCustomAttributes = "";

			// 3
			$this->_3->ViewValue = $this->_3->CurrentValue;
			$this->_3->ViewCustomAttributes = "";

			// m_3
			$this->m_3->ViewValue = $this->m_3->CurrentValue;
			$this->m_3->ViewValue = FormatNumber($this->m_3->ViewValue, 2, -2, -2, -2);
			$this->m_3->ViewCustomAttributes = "";

			// 4
			$this->_4->ViewValue = $this->_4->CurrentValue;
			$this->_4->ViewCustomAttributes = "";

			// m_4
			$this->m_4->ViewValue = $this->m_4->CurrentValue;
			$this->m_4->ViewValue = FormatNumber($this->m_4->ViewValue, 2, -2, -2, -2);
			$this->m_4->ViewCustomAttributes = "";

			// 5
			$this->_5->ViewValue = $this->_5->CurrentValue;
			$this->_5->ViewCustomAttributes = "";

			// m_5
			$this->m_5->ViewValue = $this->m_5->CurrentValue;
			$this->m_5->ViewValue = FormatNumber($this->m_5->ViewValue, 2, -2, -2, -2);
			$this->m_5->ViewCustomAttributes = "";

			// 6
			$this->_6->ViewValue = $this->_6->CurrentValue;
			$this->_6->ViewCustomAttributes = "";

			// m_6
			$this->m_6->ViewValue = $this->m_6->CurrentValue;
			$this->m_6->ViewValue = FormatNumber($this->m_6->ViewValue, 2, -2, -2, -2);
			$this->m_6->ViewCustomAttributes = "";

			// 7
			$this->_7->ViewValue = $this->_7->CurrentValue;
			$this->_7->ViewCustomAttributes = "";

			// m_7
			$this->m_7->ViewValue = $this->m_7->CurrentValue;
			$this->m_7->ViewValue = FormatNumber($this->m_7->ViewValue, 2, -2, -2, -2);
			$this->m_7->ViewCustomAttributes = "";

			// 8
			$this->_8->ViewValue = $this->_8->CurrentValue;
			$this->_8->ViewCustomAttributes = "";

			// m_8
			$this->m_8->ViewValue = $this->m_8->CurrentValue;
			$this->m_8->ViewValue = FormatNumber($this->m_8->ViewValue, 2, -2, -2, -2);
			$this->m_8->ViewCustomAttributes = "";

			// 9
			$this->_9->ViewValue = $this->_9->CurrentValue;
			$this->_9->ViewCustomAttributes = "";

			// m_9
			$this->m_9->ViewValue = $this->m_9->CurrentValue;
			$this->m_9->ViewValue = FormatNumber($this->m_9->ViewValue, 2, -2, -2, -2);
			$this->m_9->ViewCustomAttributes = "";

			// 10
			$this->_10->ViewValue = $this->_10->CurrentValue;
			$this->_10->ViewCustomAttributes = "";

			// m_10
			$this->m_10->ViewValue = $this->m_10->CurrentValue;
			$this->m_10->ViewValue = FormatNumber($this->m_10->ViewValue, 2, -2, -2, -2);
			$this->m_10->ViewCustomAttributes = "";

			// 11
			$this->_11->ViewValue = $this->_11->CurrentValue;
			$this->_11->ViewCustomAttributes = "";

			// m_11
			$this->m_11->ViewValue = $this->m_11->CurrentValue;
			$this->m_11->ViewValue = FormatNumber($this->m_11->ViewValue, 2, -2, -2, -2);
			$this->m_11->ViewCustomAttributes = "";

			// 12
			$this->_12->ViewValue = $this->_12->CurrentValue;
			$this->_12->ViewCustomAttributes = "";

			// m_12
			$this->m_12->ViewValue = $this->m_12->CurrentValue;
			$this->m_12->ViewValue = FormatNumber($this->m_12->ViewValue, 2, -2, -2, -2);
			$this->m_12->ViewCustomAttributes = "";

			// 13
			$this->_13->ViewValue = $this->_13->CurrentValue;
			$this->_13->ViewCustomAttributes = "";

			// m_13
			$this->m_13->ViewValue = $this->m_13->CurrentValue;
			$this->m_13->ViewValue = FormatNumber($this->m_13->ViewValue, 2, -2, -2, -2);
			$this->m_13->ViewCustomAttributes = "";

			// 14
			$this->_14->ViewValue = $this->_14->CurrentValue;
			$this->_14->ViewCustomAttributes = "";

			// m_14
			$this->m_14->ViewValue = $this->m_14->CurrentValue;
			$this->m_14->ViewValue = FormatNumber($this->m_14->ViewValue, 2, -2, -2, -2);
			$this->m_14->ViewCustomAttributes = "";

			// 15
			$this->_15->ViewValue = $this->_15->CurrentValue;
			$this->_15->ViewCustomAttributes = "";

			// m_15
			$this->m_15->ViewValue = $this->m_15->CurrentValue;
			$this->m_15->ViewValue = FormatNumber($this->m_15->ViewValue, 2, -2, -2, -2);
			$this->m_15->ViewCustomAttributes = "";

			// 16
			$this->_16->ViewValue = $this->_16->CurrentValue;
			$this->_16->ViewCustomAttributes = "";

			// m_16
			$this->m_16->ViewValue = $this->m_16->CurrentValue;
			$this->m_16->ViewValue = FormatNumber($this->m_16->ViewValue, 2, -2, -2, -2);
			$this->m_16->ViewCustomAttributes = "";

			// 17
			$this->_17->ViewValue = $this->_17->CurrentValue;
			$this->_17->ViewCustomAttributes = "";

			// m_17
			$this->m_17->ViewValue = $this->m_17->CurrentValue;
			$this->m_17->ViewValue = FormatNumber($this->m_17->ViewValue, 2, -2, -2, -2);
			$this->m_17->ViewCustomAttributes = "";

			// 18
			$this->_18->ViewValue = $this->_18->CurrentValue;
			$this->_18->ViewCustomAttributes = "";

			// m_18
			$this->m_18->ViewValue = $this->m_18->CurrentValue;
			$this->m_18->ViewValue = FormatNumber($this->m_18->ViewValue, 2, -2, -2, -2);
			$this->m_18->ViewCustomAttributes = "";

			// 19
			$this->_19->ViewValue = $this->_19->CurrentValue;
			$this->_19->ViewCustomAttributes = "";

			// m_19
			$this->m_19->ViewValue = $this->m_19->CurrentValue;
			$this->m_19->ViewValue = FormatNumber($this->m_19->ViewValue, 2, -2, -2, -2);
			$this->m_19->ViewCustomAttributes = "";

			// 20
			$this->_20->ViewValue = $this->_20->CurrentValue;
			$this->_20->ViewCustomAttributes = "";

			// m_20
			$this->m_20->ViewValue = $this->m_20->CurrentValue;
			$this->m_20->ViewValue = FormatNumber($this->m_20->ViewValue, 2, -2, -2, -2);
			$this->m_20->ViewCustomAttributes = "";

			// 21
			$this->_21->ViewValue = $this->_21->CurrentValue;
			$this->_21->ViewCustomAttributes = "";

			// m_21
			$this->m_21->ViewValue = $this->m_21->CurrentValue;
			$this->m_21->ViewValue = FormatNumber($this->m_21->ViewValue, 2, -2, -2, -2);
			$this->m_21->ViewCustomAttributes = "";

			// 22
			$this->_22->ViewValue = $this->_22->CurrentValue;
			$this->_22->ViewCustomAttributes = "";

			// m_22
			$this->m_22->ViewValue = $this->m_22->CurrentValue;
			$this->m_22->ViewValue = FormatNumber($this->m_22->ViewValue, 2, -2, -2, -2);
			$this->m_22->ViewCustomAttributes = "";

			// 23
			$this->_23->ViewValue = $this->_23->CurrentValue;
			$this->_23->ViewCustomAttributes = "";

			// m_23
			$this->m_23->ViewValue = $this->m_23->CurrentValue;
			$this->m_23->ViewValue = FormatNumber($this->m_23->ViewValue, 2, -2, -2, -2);
			$this->m_23->ViewCustomAttributes = "";

			// 24
			$this->_24->ViewValue = $this->_24->CurrentValue;
			$this->_24->ViewCustomAttributes = "";

			// m_24
			$this->m_24->ViewValue = $this->m_24->CurrentValue;
			$this->m_24->ViewValue = FormatNumber($this->m_24->ViewValue, 2, -2, -2, -2);
			$this->m_24->ViewCustomAttributes = "";

			// 25
			$this->_25->ViewValue = $this->_25->CurrentValue;
			$this->_25->ViewCustomAttributes = "";

			// m_25
			$this->m_25->ViewValue = $this->m_25->CurrentValue;
			$this->m_25->ViewValue = FormatNumber($this->m_25->ViewValue, 2, -2, -2, -2);
			$this->m_25->ViewCustomAttributes = "";

			// 26
			$this->_26->ViewValue = $this->_26->CurrentValue;
			$this->_26->ViewCustomAttributes = "";

			// m_26
			$this->m_26->ViewValue = $this->m_26->CurrentValue;
			$this->m_26->ViewValue = FormatNumber($this->m_26->ViewValue, 2, -2, -2, -2);
			$this->m_26->ViewCustomAttributes = "";

			// 27
			$this->_27->ViewValue = $this->_27->CurrentValue;
			$this->_27->ViewCustomAttributes = "";

			// m_27
			$this->m_27->ViewValue = $this->m_27->CurrentValue;
			$this->m_27->ViewValue = FormatNumber($this->m_27->ViewValue, 2, -2, -2, -2);
			$this->m_27->ViewCustomAttributes = "";

			// 28
			$this->_28->ViewValue = $this->_28->CurrentValue;
			$this->_28->ViewCustomAttributes = "";

			// m_28
			$this->m_28->ViewValue = $this->m_28->CurrentValue;
			$this->m_28->ViewValue = FormatNumber($this->m_28->ViewValue, 2, -2, -2, -2);
			$this->m_28->ViewCustomAttributes = "";

			// 29
			$this->_29->ViewValue = $this->_29->CurrentValue;
			$this->_29->ViewCustomAttributes = "";

			// m_29
			$this->m_29->ViewValue = $this->m_29->CurrentValue;
			$this->m_29->ViewValue = FormatNumber($this->m_29->ViewValue, 2, -2, -2, -2);
			$this->m_29->ViewCustomAttributes = "";

			// 30
			$this->_30->ViewValue = $this->_30->CurrentValue;
			$this->_30->ViewCustomAttributes = "";

			// m_30
			$this->m_30->ViewValue = $this->m_30->CurrentValue;
			$this->m_30->ViewValue = FormatNumber($this->m_30->ViewValue, 2, -2, -2, -2);
			$this->m_30->ViewCustomAttributes = "";

			// 31
			$this->_31->ViewValue = $this->_31->CurrentValue;
			$this->_31->ViewCustomAttributes = "";

			// m_31
			$this->m_31->ViewValue = $this->m_31->CurrentValue;
			$this->m_31->ViewValue = FormatNumber($this->m_31->ViewValue, 2, -2, -2, -2);
			$this->m_31->ViewCustomAttributes = "";

			// 32
			$this->_32->ViewValue = $this->_32->CurrentValue;
			$this->_32->ViewCustomAttributes = "";

			// m_32
			$this->m_32->ViewValue = $this->m_32->CurrentValue;
			$this->m_32->ViewValue = FormatNumber($this->m_32->ViewValue, 2, -2, -2, -2);
			$this->m_32->ViewCustomAttributes = "";

			// 33
			$this->_33->ViewValue = $this->_33->CurrentValue;
			$this->_33->ViewCustomAttributes = "";

			// m_33
			$this->m_33->ViewValue = $this->m_33->CurrentValue;
			$this->m_33->ViewValue = FormatNumber($this->m_33->ViewValue, 2, -2, -2, -2);
			$this->m_33->ViewCustomAttributes = "";

			// 34
			$this->_34->ViewValue = $this->_34->CurrentValue;
			$this->_34->ViewCustomAttributes = "";

			// m_34
			$this->m_34->ViewValue = $this->m_34->CurrentValue;
			$this->m_34->ViewValue = FormatNumber($this->m_34->ViewValue, 2, -2, -2, -2);
			$this->m_34->ViewCustomAttributes = "";

			// 35
			$this->_35->ViewValue = $this->_35->CurrentValue;
			$this->_35->ViewCustomAttributes = "";

			// m_35
			$this->m_35->ViewValue = $this->m_35->CurrentValue;
			$this->m_35->ViewValue = FormatNumber($this->m_35->ViewValue, 2, -2, -2, -2);
			$this->m_35->ViewCustomAttributes = "";

			// 36
			$this->_36->ViewValue = $this->_36->CurrentValue;
			$this->_36->ViewCustomAttributes = "";

			// m_36
			$this->m_36->ViewValue = $this->m_36->CurrentValue;
			$this->m_36->ViewValue = FormatNumber($this->m_36->ViewValue, 2, -2, -2, -2);
			$this->m_36->ViewCustomAttributes = "";

			// 37
			$this->_37->ViewValue = $this->_37->CurrentValue;
			$this->_37->ViewCustomAttributes = "";

			// m_37
			$this->m_37->ViewValue = $this->m_37->CurrentValue;
			$this->m_37->ViewValue = FormatNumber($this->m_37->ViewValue, 2, -2, -2, -2);
			$this->m_37->ViewCustomAttributes = "";

			// 38
			$this->_38->ViewValue = $this->_38->CurrentValue;
			$this->_38->ViewCustomAttributes = "";

			// m_38
			$this->m_38->ViewValue = $this->m_38->CurrentValue;
			$this->m_38->ViewValue = FormatNumber($this->m_38->ViewValue, 2, -2, -2, -2);
			$this->m_38->ViewCustomAttributes = "";

			// 39
			$this->_39->ViewValue = $this->_39->CurrentValue;
			$this->_39->ViewCustomAttributes = "";

			// m_39
			$this->m_39->ViewValue = $this->m_39->CurrentValue;
			$this->m_39->ViewValue = FormatNumber($this->m_39->ViewValue, 2, -2, -2, -2);
			$this->m_39->ViewCustomAttributes = "";

			// 40
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewCustomAttributes = "";

			// m_40
			$this->m_40->ViewValue = $this->m_40->CurrentValue;
			$this->m_40->ViewValue = FormatNumber($this->m_40->ViewValue, 2, -2, -2, -2);
			$this->m_40->ViewCustomAttributes = "";

			// 41
			$this->_41->ViewValue = $this->_41->CurrentValue;
			$this->_41->ViewCustomAttributes = "";

			// m_41
			$this->m_41->ViewValue = $this->m_41->CurrentValue;
			$this->m_41->ViewValue = FormatNumber($this->m_41->ViewValue, 2, -2, -2, -2);
			$this->m_41->ViewCustomAttributes = "";

			// 42
			$this->_42->ViewValue = $this->_42->CurrentValue;
			$this->_42->ViewCustomAttributes = "";

			// m_42
			$this->m_42->ViewValue = $this->m_42->CurrentValue;
			$this->m_42->ViewValue = FormatNumber($this->m_42->ViewValue, 2, -2, -2, -2);
			$this->m_42->ViewCustomAttributes = "";

			// 43
			$this->_43->ViewValue = $this->_43->CurrentValue;
			$this->_43->ViewCustomAttributes = "";

			// m_43
			$this->m_43->ViewValue = $this->m_43->CurrentValue;
			$this->m_43->ViewValue = FormatNumber($this->m_43->ViewValue, 2, -2, -2, -2);
			$this->m_43->ViewCustomAttributes = "";

			// 44
			$this->_44->ViewValue = $this->_44->CurrentValue;
			$this->_44->ViewCustomAttributes = "";

			// m_44
			$this->m_44->ViewValue = $this->m_44->CurrentValue;
			$this->m_44->ViewValue = FormatNumber($this->m_44->ViewValue, 2, -2, -2, -2);
			$this->m_44->ViewCustomAttributes = "";

			// 45
			$this->_45->ViewValue = $this->_45->CurrentValue;
			$this->_45->ViewCustomAttributes = "";

			// m_45
			$this->m_45->ViewValue = $this->m_45->CurrentValue;
			$this->m_45->ViewValue = FormatNumber($this->m_45->ViewValue, 2, -2, -2, -2);
			$this->m_45->ViewCustomAttributes = "";

			// 46
			$this->_46->ViewValue = $this->_46->CurrentValue;
			$this->_46->ViewCustomAttributes = "";

			// m_46
			$this->m_46->ViewValue = $this->m_46->CurrentValue;
			$this->m_46->ViewValue = FormatNumber($this->m_46->ViewValue, 2, -2, -2, -2);
			$this->m_46->ViewCustomAttributes = "";

			// 47
			$this->_47->ViewValue = $this->_47->CurrentValue;
			$this->_47->ViewCustomAttributes = "";

			// m_47
			$this->m_47->ViewValue = $this->m_47->CurrentValue;
			$this->m_47->ViewValue = FormatNumber($this->m_47->ViewValue, 2, -2, -2, -2);
			$this->m_47->ViewCustomAttributes = "";

			// 48
			$this->_48->ViewValue = $this->_48->CurrentValue;
			$this->_48->ViewCustomAttributes = "";

			// m_48
			$this->m_48->ViewValue = $this->m_48->CurrentValue;
			$this->m_48->ViewValue = FormatNumber($this->m_48->ViewValue, 2, -2, -2, -2);
			$this->m_48->ViewCustomAttributes = "";

			// 49
			$this->_49->ViewValue = $this->_49->CurrentValue;
			$this->_49->ViewCustomAttributes = "";

			// m_49
			$this->m_49->ViewValue = $this->m_49->CurrentValue;
			$this->m_49->ViewValue = FormatNumber($this->m_49->ViewValue, 2, -2, -2, -2);
			$this->m_49->ViewCustomAttributes = "";

			// 50
			$this->_50->ViewValue = $this->_50->CurrentValue;
			$this->_50->ViewCustomAttributes = "";

			// m_50
			$this->m_50->ViewValue = $this->m_50->CurrentValue;
			$this->m_50->ViewValue = FormatNumber($this->m_50->ViewValue, 2, -2, -2, -2);
			$this->m_50->ViewCustomAttributes = "";

			// 51
			$this->_51->ViewValue = $this->_51->CurrentValue;
			$this->_51->ViewCustomAttributes = "";

			// m_51
			$this->m_51->ViewValue = $this->m_51->CurrentValue;
			$this->m_51->ViewValue = FormatNumber($this->m_51->ViewValue, 2, -2, -2, -2);
			$this->m_51->ViewCustomAttributes = "";

			// 52
			$this->_52->ViewValue = $this->_52->CurrentValue;
			$this->_52->ViewCustomAttributes = "";

			// m_52
			$this->m_52->ViewValue = $this->m_52->CurrentValue;
			$this->m_52->ViewValue = FormatNumber($this->m_52->ViewValue, 2, -2, -2, -2);
			$this->m_52->ViewCustomAttributes = "";

			// 53
			$this->_53->ViewValue = $this->_53->CurrentValue;
			$this->_53->ViewCustomAttributes = "";

			// m_53
			$this->m_53->ViewValue = $this->m_53->CurrentValue;
			$this->m_53->ViewValue = FormatNumber($this->m_53->ViewValue, 2, -2, -2, -2);
			$this->m_53->ViewCustomAttributes = "";

			// 54
			$this->_54->ViewValue = $this->_54->CurrentValue;
			$this->_54->ViewCustomAttributes = "";

			// m_54
			$this->m_54->ViewValue = $this->m_54->CurrentValue;
			$this->m_54->ViewValue = FormatNumber($this->m_54->ViewValue, 2, -2, -2, -2);
			$this->m_54->ViewCustomAttributes = "";

			// 55
			$this->_55->ViewValue = $this->_55->CurrentValue;
			$this->_55->ViewCustomAttributes = "";

			// m_55
			$this->m_55->ViewValue = $this->m_55->CurrentValue;
			$this->m_55->ViewValue = FormatNumber($this->m_55->ViewValue, 2, -2, -2, -2);
			$this->m_55->ViewCustomAttributes = "";

			// 56
			$this->_56->ViewValue = $this->_56->CurrentValue;
			$this->_56->ViewCustomAttributes = "";

			// m_56
			$this->m_56->ViewValue = $this->m_56->CurrentValue;
			$this->m_56->ViewValue = FormatNumber($this->m_56->ViewValue, 2, -2, -2, -2);
			$this->m_56->ViewCustomAttributes = "";

			// 57
			$this->_57->ViewValue = $this->_57->CurrentValue;
			$this->_57->ViewCustomAttributes = "";

			// m_57
			$this->m_57->ViewValue = $this->m_57->CurrentValue;
			$this->m_57->ViewValue = FormatNumber($this->m_57->ViewValue, 2, -2, -2, -2);
			$this->m_57->ViewCustomAttributes = "";

			// 58
			$this->_58->ViewValue = $this->_58->CurrentValue;
			$this->_58->ViewCustomAttributes = "";

			// m_58
			$this->m_58->ViewValue = $this->m_58->CurrentValue;
			$this->m_58->ViewValue = FormatNumber($this->m_58->ViewValue, 2, -2, -2, -2);
			$this->m_58->ViewCustomAttributes = "";

			// 59
			$this->_59->ViewValue = $this->_59->CurrentValue;
			$this->_59->ViewCustomAttributes = "";

			// m_59
			$this->m_59->ViewValue = $this->m_59->CurrentValue;
			$this->m_59->ViewValue = FormatNumber($this->m_59->ViewValue, 2, -2, -2, -2);
			$this->m_59->ViewCustomAttributes = "";

			// 60
			$this->_60->ViewValue = $this->_60->CurrentValue;
			$this->_60->ViewCustomAttributes = "";

			// m_60
			$this->m_60->ViewValue = $this->m_60->CurrentValue;
			$this->m_60->ViewValue = FormatNumber($this->m_60->ViewValue, 2, -2, -2, -2);
			$this->m_60->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// test_id
			$this->test_id->LinkCustomAttributes = "";
			$this->test_id->HrefValue = "";
			$this->test_id->TooltipValue = "";

			// total
			$this->total->LinkCustomAttributes = "";
			$this->total->HrefValue = "";
			$this->total->TooltipValue = "";

			// percent
			$this->percent->LinkCustomAttributes = "";
			$this->percent->HrefValue = "";
			$this->percent->TooltipValue = "";

			// s_1
			$this->s_1->LinkCustomAttributes = "";
			$this->s_1->HrefValue = "";
			$this->s_1->TooltipValue = "";

			// s_2
			$this->s_2->LinkCustomAttributes = "";
			$this->s_2->HrefValue = "";
			$this->s_2->TooltipValue = "";

			// s_3
			$this->s_3->LinkCustomAttributes = "";
			$this->s_3->HrefValue = "";
			$this->s_3->TooltipValue = "";

			// s_4
			$this->s_4->LinkCustomAttributes = "";
			$this->s_4->HrefValue = "";
			$this->s_4->TooltipValue = "";

			// s_5
			$this->s_5->LinkCustomAttributes = "";
			$this->s_5->HrefValue = "";
			$this->s_5->TooltipValue = "";

			// omr_image
			$this->omr_image->LinkCustomAttributes = "";
			$this->omr_image->UploadPath = '.p_uploads/school/omr/';
			if (!EmptyValue($this->omr_image->Upload->DbValue)) {
				$this->omr_image->HrefValue = GetFileUploadUrl($this->omr_image, $this->omr_image->Upload->DbValue); // Add prefix/suffix
				$this->omr_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->omr_image->HrefValue = FullUrl($this->omr_image->HrefValue, "href");
			} else {
				$this->omr_image->HrefValue = "";
			}
			$this->omr_image->ExportHrefValue = $this->omr_image->UploadPath . $this->omr_image->Upload->DbValue;
			$this->omr_image->TooltipValue = "";
			if ($this->omr_image->UseColorbox) {
				if (EmptyValue($this->omr_image->TooltipValue))
					$this->omr_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->omr_image->LinkAttrs["data-rel"] = "s_omr_value_x_omr_image";
				AppendClass($this->omr_image->LinkAttrs["class"], "ew-lightbox");
			}

			// 1
			$this->_1->LinkCustomAttributes = "";
			$this->_1->HrefValue = "";
			$this->_1->TooltipValue = "";

			// m_1
			$this->m_1->LinkCustomAttributes = "";
			$this->m_1->HrefValue = "";
			$this->m_1->TooltipValue = "";

			// 2
			$this->_2->LinkCustomAttributes = "";
			$this->_2->HrefValue = "";
			$this->_2->TooltipValue = "";

			// m_2
			$this->m_2->LinkCustomAttributes = "";
			$this->m_2->HrefValue = "";
			$this->m_2->TooltipValue = "";

			// 3
			$this->_3->LinkCustomAttributes = "";
			$this->_3->HrefValue = "";
			$this->_3->TooltipValue = "";

			// m_3
			$this->m_3->LinkCustomAttributes = "";
			$this->m_3->HrefValue = "";
			$this->m_3->TooltipValue = "";

			// 4
			$this->_4->LinkCustomAttributes = "";
			$this->_4->HrefValue = "";
			$this->_4->TooltipValue = "";

			// m_4
			$this->m_4->LinkCustomAttributes = "";
			$this->m_4->HrefValue = "";
			$this->m_4->TooltipValue = "";

			// 5
			$this->_5->LinkCustomAttributes = "";
			$this->_5->HrefValue = "";
			$this->_5->TooltipValue = "";

			// m_5
			$this->m_5->LinkCustomAttributes = "";
			$this->m_5->HrefValue = "";
			$this->m_5->TooltipValue = "";

			// 6
			$this->_6->LinkCustomAttributes = "";
			$this->_6->HrefValue = "";
			$this->_6->TooltipValue = "";

			// m_6
			$this->m_6->LinkCustomAttributes = "";
			$this->m_6->HrefValue = "";
			$this->m_6->TooltipValue = "";

			// 7
			$this->_7->LinkCustomAttributes = "";
			$this->_7->HrefValue = "";
			$this->_7->TooltipValue = "";

			// m_7
			$this->m_7->LinkCustomAttributes = "";
			$this->m_7->HrefValue = "";
			$this->m_7->TooltipValue = "";

			// 8
			$this->_8->LinkCustomAttributes = "";
			$this->_8->HrefValue = "";
			$this->_8->TooltipValue = "";

			// m_8
			$this->m_8->LinkCustomAttributes = "";
			$this->m_8->HrefValue = "";
			$this->m_8->TooltipValue = "";

			// 9
			$this->_9->LinkCustomAttributes = "";
			$this->_9->HrefValue = "";
			$this->_9->TooltipValue = "";

			// m_9
			$this->m_9->LinkCustomAttributes = "";
			$this->m_9->HrefValue = "";
			$this->m_9->TooltipValue = "";

			// 10
			$this->_10->LinkCustomAttributes = "";
			$this->_10->HrefValue = "";
			$this->_10->TooltipValue = "";

			// m_10
			$this->m_10->LinkCustomAttributes = "";
			$this->m_10->HrefValue = "";
			$this->m_10->TooltipValue = "";

			// 11
			$this->_11->LinkCustomAttributes = "";
			$this->_11->HrefValue = "";
			$this->_11->TooltipValue = "";

			// m_11
			$this->m_11->LinkCustomAttributes = "";
			$this->m_11->HrefValue = "";
			$this->m_11->TooltipValue = "";

			// 12
			$this->_12->LinkCustomAttributes = "";
			$this->_12->HrefValue = "";
			$this->_12->TooltipValue = "";

			// m_12
			$this->m_12->LinkCustomAttributes = "";
			$this->m_12->HrefValue = "";
			$this->m_12->TooltipValue = "";

			// 13
			$this->_13->LinkCustomAttributes = "";
			$this->_13->HrefValue = "";
			$this->_13->TooltipValue = "";

			// m_13
			$this->m_13->LinkCustomAttributes = "";
			$this->m_13->HrefValue = "";
			$this->m_13->TooltipValue = "";

			// 14
			$this->_14->LinkCustomAttributes = "";
			$this->_14->HrefValue = "";
			$this->_14->TooltipValue = "";

			// m_14
			$this->m_14->LinkCustomAttributes = "";
			$this->m_14->HrefValue = "";
			$this->m_14->TooltipValue = "";

			// 15
			$this->_15->LinkCustomAttributes = "";
			$this->_15->HrefValue = "";
			$this->_15->TooltipValue = "";

			// m_15
			$this->m_15->LinkCustomAttributes = "";
			$this->m_15->HrefValue = "";
			$this->m_15->TooltipValue = "";

			// 16
			$this->_16->LinkCustomAttributes = "";
			$this->_16->HrefValue = "";
			$this->_16->TooltipValue = "";

			// m_16
			$this->m_16->LinkCustomAttributes = "";
			$this->m_16->HrefValue = "";
			$this->m_16->TooltipValue = "";

			// 17
			$this->_17->LinkCustomAttributes = "";
			$this->_17->HrefValue = "";
			$this->_17->TooltipValue = "";

			// m_17
			$this->m_17->LinkCustomAttributes = "";
			$this->m_17->HrefValue = "";
			$this->m_17->TooltipValue = "";

			// 18
			$this->_18->LinkCustomAttributes = "";
			$this->_18->HrefValue = "";
			$this->_18->TooltipValue = "";

			// m_18
			$this->m_18->LinkCustomAttributes = "";
			$this->m_18->HrefValue = "";
			$this->m_18->TooltipValue = "";

			// 19
			$this->_19->LinkCustomAttributes = "";
			$this->_19->HrefValue = "";
			$this->_19->TooltipValue = "";

			// m_19
			$this->m_19->LinkCustomAttributes = "";
			$this->m_19->HrefValue = "";
			$this->m_19->TooltipValue = "";

			// 20
			$this->_20->LinkCustomAttributes = "";
			$this->_20->HrefValue = "";
			$this->_20->TooltipValue = "";

			// m_20
			$this->m_20->LinkCustomAttributes = "";
			$this->m_20->HrefValue = "";
			$this->m_20->TooltipValue = "";

			// 21
			$this->_21->LinkCustomAttributes = "";
			$this->_21->HrefValue = "";
			$this->_21->TooltipValue = "";

			// m_21
			$this->m_21->LinkCustomAttributes = "";
			$this->m_21->HrefValue = "";
			$this->m_21->TooltipValue = "";

			// 22
			$this->_22->LinkCustomAttributes = "";
			$this->_22->HrefValue = "";
			$this->_22->TooltipValue = "";

			// m_22
			$this->m_22->LinkCustomAttributes = "";
			$this->m_22->HrefValue = "";
			$this->m_22->TooltipValue = "";

			// 23
			$this->_23->LinkCustomAttributes = "";
			$this->_23->HrefValue = "";
			$this->_23->TooltipValue = "";

			// m_23
			$this->m_23->LinkCustomAttributes = "";
			$this->m_23->HrefValue = "";
			$this->m_23->TooltipValue = "";

			// 24
			$this->_24->LinkCustomAttributes = "";
			$this->_24->HrefValue = "";
			$this->_24->TooltipValue = "";

			// m_24
			$this->m_24->LinkCustomAttributes = "";
			$this->m_24->HrefValue = "";
			$this->m_24->TooltipValue = "";

			// 25
			$this->_25->LinkCustomAttributes = "";
			$this->_25->HrefValue = "";
			$this->_25->TooltipValue = "";

			// m_25
			$this->m_25->LinkCustomAttributes = "";
			$this->m_25->HrefValue = "";
			$this->m_25->TooltipValue = "";

			// 26
			$this->_26->LinkCustomAttributes = "";
			$this->_26->HrefValue = "";
			$this->_26->TooltipValue = "";

			// m_26
			$this->m_26->LinkCustomAttributes = "";
			$this->m_26->HrefValue = "";
			$this->m_26->TooltipValue = "";

			// 27
			$this->_27->LinkCustomAttributes = "";
			$this->_27->HrefValue = "";
			$this->_27->TooltipValue = "";

			// m_27
			$this->m_27->LinkCustomAttributes = "";
			$this->m_27->HrefValue = "";
			$this->m_27->TooltipValue = "";

			// 28
			$this->_28->LinkCustomAttributes = "";
			$this->_28->HrefValue = "";
			$this->_28->TooltipValue = "";

			// m_28
			$this->m_28->LinkCustomAttributes = "";
			$this->m_28->HrefValue = "";
			$this->m_28->TooltipValue = "";

			// 29
			$this->_29->LinkCustomAttributes = "";
			$this->_29->HrefValue = "";
			$this->_29->TooltipValue = "";

			// m_29
			$this->m_29->LinkCustomAttributes = "";
			$this->m_29->HrefValue = "";
			$this->m_29->TooltipValue = "";

			// 30
			$this->_30->LinkCustomAttributes = "";
			$this->_30->HrefValue = "";
			$this->_30->TooltipValue = "";

			// m_30
			$this->m_30->LinkCustomAttributes = "";
			$this->m_30->HrefValue = "";
			$this->m_30->TooltipValue = "";

			// 31
			$this->_31->LinkCustomAttributes = "";
			$this->_31->HrefValue = "";
			$this->_31->TooltipValue = "";

			// m_31
			$this->m_31->LinkCustomAttributes = "";
			$this->m_31->HrefValue = "";
			$this->m_31->TooltipValue = "";

			// 32
			$this->_32->LinkCustomAttributes = "";
			$this->_32->HrefValue = "";
			$this->_32->TooltipValue = "";

			// m_32
			$this->m_32->LinkCustomAttributes = "";
			$this->m_32->HrefValue = "";
			$this->m_32->TooltipValue = "";

			// 33
			$this->_33->LinkCustomAttributes = "";
			$this->_33->HrefValue = "";
			$this->_33->TooltipValue = "";

			// m_33
			$this->m_33->LinkCustomAttributes = "";
			$this->m_33->HrefValue = "";
			$this->m_33->TooltipValue = "";

			// 34
			$this->_34->LinkCustomAttributes = "";
			$this->_34->HrefValue = "";
			$this->_34->TooltipValue = "";

			// m_34
			$this->m_34->LinkCustomAttributes = "";
			$this->m_34->HrefValue = "";
			$this->m_34->TooltipValue = "";

			// 35
			$this->_35->LinkCustomAttributes = "";
			$this->_35->HrefValue = "";
			$this->_35->TooltipValue = "";

			// m_35
			$this->m_35->LinkCustomAttributes = "";
			$this->m_35->HrefValue = "";
			$this->m_35->TooltipValue = "";

			// 36
			$this->_36->LinkCustomAttributes = "";
			$this->_36->HrefValue = "";
			$this->_36->TooltipValue = "";

			// m_36
			$this->m_36->LinkCustomAttributes = "";
			$this->m_36->HrefValue = "";
			$this->m_36->TooltipValue = "";

			// 37
			$this->_37->LinkCustomAttributes = "";
			$this->_37->HrefValue = "";
			$this->_37->TooltipValue = "";

			// m_37
			$this->m_37->LinkCustomAttributes = "";
			$this->m_37->HrefValue = "";
			$this->m_37->TooltipValue = "";

			// 38
			$this->_38->LinkCustomAttributes = "";
			$this->_38->HrefValue = "";
			$this->_38->TooltipValue = "";

			// m_38
			$this->m_38->LinkCustomAttributes = "";
			$this->m_38->HrefValue = "";
			$this->m_38->TooltipValue = "";

			// 39
			$this->_39->LinkCustomAttributes = "";
			$this->_39->HrefValue = "";
			$this->_39->TooltipValue = "";

			// m_39
			$this->m_39->LinkCustomAttributes = "";
			$this->m_39->HrefValue = "";
			$this->m_39->TooltipValue = "";

			// 40
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// m_40
			$this->m_40->LinkCustomAttributes = "";
			$this->m_40->HrefValue = "";
			$this->m_40->TooltipValue = "";

			// 41
			$this->_41->LinkCustomAttributes = "";
			$this->_41->HrefValue = "";
			$this->_41->TooltipValue = "";

			// m_41
			$this->m_41->LinkCustomAttributes = "";
			$this->m_41->HrefValue = "";
			$this->m_41->TooltipValue = "";

			// 42
			$this->_42->LinkCustomAttributes = "";
			$this->_42->HrefValue = "";
			$this->_42->TooltipValue = "";

			// m_42
			$this->m_42->LinkCustomAttributes = "";
			$this->m_42->HrefValue = "";
			$this->m_42->TooltipValue = "";

			// 43
			$this->_43->LinkCustomAttributes = "";
			$this->_43->HrefValue = "";
			$this->_43->TooltipValue = "";

			// m_43
			$this->m_43->LinkCustomAttributes = "";
			$this->m_43->HrefValue = "";
			$this->m_43->TooltipValue = "";

			// 44
			$this->_44->LinkCustomAttributes = "";
			$this->_44->HrefValue = "";
			$this->_44->TooltipValue = "";

			// m_44
			$this->m_44->LinkCustomAttributes = "";
			$this->m_44->HrefValue = "";
			$this->m_44->TooltipValue = "";

			// 45
			$this->_45->LinkCustomAttributes = "";
			$this->_45->HrefValue = "";
			$this->_45->TooltipValue = "";

			// m_45
			$this->m_45->LinkCustomAttributes = "";
			$this->m_45->HrefValue = "";
			$this->m_45->TooltipValue = "";

			// 46
			$this->_46->LinkCustomAttributes = "";
			$this->_46->HrefValue = "";
			$this->_46->TooltipValue = "";

			// m_46
			$this->m_46->LinkCustomAttributes = "";
			$this->m_46->HrefValue = "";
			$this->m_46->TooltipValue = "";

			// 47
			$this->_47->LinkCustomAttributes = "";
			$this->_47->HrefValue = "";
			$this->_47->TooltipValue = "";

			// m_47
			$this->m_47->LinkCustomAttributes = "";
			$this->m_47->HrefValue = "";
			$this->m_47->TooltipValue = "";

			// 48
			$this->_48->LinkCustomAttributes = "";
			$this->_48->HrefValue = "";
			$this->_48->TooltipValue = "";

			// m_48
			$this->m_48->LinkCustomAttributes = "";
			$this->m_48->HrefValue = "";
			$this->m_48->TooltipValue = "";

			// 49
			$this->_49->LinkCustomAttributes = "";
			$this->_49->HrefValue = "";
			$this->_49->TooltipValue = "";

			// m_49
			$this->m_49->LinkCustomAttributes = "";
			$this->m_49->HrefValue = "";
			$this->m_49->TooltipValue = "";

			// 50
			$this->_50->LinkCustomAttributes = "";
			$this->_50->HrefValue = "";
			$this->_50->TooltipValue = "";

			// m_50
			$this->m_50->LinkCustomAttributes = "";
			$this->m_50->HrefValue = "";
			$this->m_50->TooltipValue = "";

			// 51
			$this->_51->LinkCustomAttributes = "";
			$this->_51->HrefValue = "";
			$this->_51->TooltipValue = "";

			// m_51
			$this->m_51->LinkCustomAttributes = "";
			$this->m_51->HrefValue = "";
			$this->m_51->TooltipValue = "";

			// 52
			$this->_52->LinkCustomAttributes = "";
			$this->_52->HrefValue = "";
			$this->_52->TooltipValue = "";

			// m_52
			$this->m_52->LinkCustomAttributes = "";
			$this->m_52->HrefValue = "";
			$this->m_52->TooltipValue = "";

			// 53
			$this->_53->LinkCustomAttributes = "";
			$this->_53->HrefValue = "";
			$this->_53->TooltipValue = "";

			// m_53
			$this->m_53->LinkCustomAttributes = "";
			$this->m_53->HrefValue = "";
			$this->m_53->TooltipValue = "";

			// 54
			$this->_54->LinkCustomAttributes = "";
			$this->_54->HrefValue = "";
			$this->_54->TooltipValue = "";

			// m_54
			$this->m_54->LinkCustomAttributes = "";
			$this->m_54->HrefValue = "";
			$this->m_54->TooltipValue = "";

			// 55
			$this->_55->LinkCustomAttributes = "";
			$this->_55->HrefValue = "";
			$this->_55->TooltipValue = "";

			// m_55
			$this->m_55->LinkCustomAttributes = "";
			$this->m_55->HrefValue = "";
			$this->m_55->TooltipValue = "";

			// 56
			$this->_56->LinkCustomAttributes = "";
			$this->_56->HrefValue = "";
			$this->_56->TooltipValue = "";

			// m_56
			$this->m_56->LinkCustomAttributes = "";
			$this->m_56->HrefValue = "";
			$this->m_56->TooltipValue = "";

			// 57
			$this->_57->LinkCustomAttributes = "";
			$this->_57->HrefValue = "";
			$this->_57->TooltipValue = "";

			// m_57
			$this->m_57->LinkCustomAttributes = "";
			$this->m_57->HrefValue = "";
			$this->m_57->TooltipValue = "";

			// 58
			$this->_58->LinkCustomAttributes = "";
			$this->_58->HrefValue = "";
			$this->_58->TooltipValue = "";

			// m_58
			$this->m_58->LinkCustomAttributes = "";
			$this->m_58->HrefValue = "";
			$this->m_58->TooltipValue = "";

			// 59
			$this->_59->LinkCustomAttributes = "";
			$this->_59->HrefValue = "";
			$this->_59->TooltipValue = "";

			// m_59
			$this->m_59->LinkCustomAttributes = "";
			$this->m_59->HrefValue = "";
			$this->m_59->TooltipValue = "";

			// 60
			$this->_60->LinkCustomAttributes = "";
			$this->_60->HrefValue = "";
			$this->_60->TooltipValue = "";

			// m_60
			$this->m_60->LinkCustomAttributes = "";
			$this->m_60->HrefValue = "";
			$this->m_60->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// roll_no
			$this->roll_no->EditAttrs["class"] = "form-control";
			$this->roll_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->roll_no->AdvancedSearch->SearchValue = HtmlDecode($this->roll_no->AdvancedSearch->SearchValue);
			$this->roll_no->EditValue = HtmlEncode($this->roll_no->AdvancedSearch->SearchValue);
			$this->roll_no->PlaceHolder = RemoveHtml($this->roll_no->caption());

			// test_id
			$this->test_id->EditAttrs["class"] = "form-control";
			$this->test_id->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->test_id->AdvancedSearch->SearchValue = HtmlDecode($this->test_id->AdvancedSearch->SearchValue);
			$this->test_id->EditValue = HtmlEncode($this->test_id->AdvancedSearch->SearchValue);
			$this->test_id->PlaceHolder = RemoveHtml($this->test_id->caption());

			// total
			$this->total->EditAttrs["class"] = "form-control";
			$this->total->EditCustomAttributes = "";
			$this->total->EditValue = HtmlEncode($this->total->AdvancedSearch->SearchValue);
			$this->total->PlaceHolder = RemoveHtml($this->total->caption());
			$this->total->EditAttrs["class"] = "form-control";
			$this->total->EditCustomAttributes = "";
			$this->total->EditValue2 = HtmlEncode($this->total->AdvancedSearch->SearchValue2);
			$this->total->PlaceHolder = RemoveHtml($this->total->caption());

			// percent
			$this->percent->EditAttrs["class"] = "form-control";
			$this->percent->EditCustomAttributes = "";
			$this->percent->EditValue = HtmlEncode($this->percent->AdvancedSearch->SearchValue);
			$this->percent->PlaceHolder = RemoveHtml($this->percent->caption());
			$this->percent->EditAttrs["class"] = "form-control";
			$this->percent->EditCustomAttributes = "";
			$this->percent->EditValue2 = HtmlEncode($this->percent->AdvancedSearch->SearchValue2);
			$this->percent->PlaceHolder = RemoveHtml($this->percent->caption());

			// s_1
			$this->s_1->EditAttrs["class"] = "form-control";
			$this->s_1->EditCustomAttributes = "";
			$this->s_1->EditValue = HtmlEncode($this->s_1->AdvancedSearch->SearchValue);
			$this->s_1->PlaceHolder = RemoveHtml($this->s_1->caption());

			// s_2
			$this->s_2->EditAttrs["class"] = "form-control";
			$this->s_2->EditCustomAttributes = "";
			$this->s_2->EditValue = HtmlEncode($this->s_2->AdvancedSearch->SearchValue);
			$this->s_2->PlaceHolder = RemoveHtml($this->s_2->caption());

			// s_3
			$this->s_3->EditAttrs["class"] = "form-control";
			$this->s_3->EditCustomAttributes = "";
			$this->s_3->EditValue = HtmlEncode($this->s_3->AdvancedSearch->SearchValue);
			$this->s_3->PlaceHolder = RemoveHtml($this->s_3->caption());

			// s_4
			$this->s_4->EditAttrs["class"] = "form-control";
			$this->s_4->EditCustomAttributes = "";
			$this->s_4->EditValue = HtmlEncode($this->s_4->AdvancedSearch->SearchValue);
			$this->s_4->PlaceHolder = RemoveHtml($this->s_4->caption());

			// s_5
			$this->s_5->EditAttrs["class"] = "form-control";
			$this->s_5->EditCustomAttributes = "";
			$this->s_5->EditValue = HtmlEncode($this->s_5->AdvancedSearch->SearchValue);
			$this->s_5->PlaceHolder = RemoveHtml($this->s_5->caption());

			// omr_image
			$this->omr_image->EditAttrs["class"] = "form-control";
			$this->omr_image->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->omr_image->AdvancedSearch->SearchValue = HtmlDecode($this->omr_image->AdvancedSearch->SearchValue);
			$this->omr_image->EditValue = HtmlEncode($this->omr_image->AdvancedSearch->SearchValue);
			$this->omr_image->PlaceHolder = RemoveHtml($this->omr_image->caption());

			// 1
			$this->_1->EditAttrs["class"] = "form-control";
			$this->_1->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_1->AdvancedSearch->SearchValue = HtmlDecode($this->_1->AdvancedSearch->SearchValue);
			$this->_1->EditValue = HtmlEncode($this->_1->AdvancedSearch->SearchValue);
			$this->_1->PlaceHolder = RemoveHtml($this->_1->caption());

			// m_1
			$this->m_1->EditAttrs["class"] = "form-control";
			$this->m_1->EditCustomAttributes = "";
			$this->m_1->EditValue = HtmlEncode($this->m_1->AdvancedSearch->SearchValue);
			$this->m_1->PlaceHolder = RemoveHtml($this->m_1->caption());

			// 2
			$this->_2->EditAttrs["class"] = "form-control";
			$this->_2->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_2->AdvancedSearch->SearchValue = HtmlDecode($this->_2->AdvancedSearch->SearchValue);
			$this->_2->EditValue = HtmlEncode($this->_2->AdvancedSearch->SearchValue);
			$this->_2->PlaceHolder = RemoveHtml($this->_2->caption());

			// m_2
			$this->m_2->EditAttrs["class"] = "form-control";
			$this->m_2->EditCustomAttributes = "";
			$this->m_2->EditValue = HtmlEncode($this->m_2->AdvancedSearch->SearchValue);
			$this->m_2->PlaceHolder = RemoveHtml($this->m_2->caption());

			// 3
			$this->_3->EditAttrs["class"] = "form-control";
			$this->_3->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_3->AdvancedSearch->SearchValue = HtmlDecode($this->_3->AdvancedSearch->SearchValue);
			$this->_3->EditValue = HtmlEncode($this->_3->AdvancedSearch->SearchValue);
			$this->_3->PlaceHolder = RemoveHtml($this->_3->caption());

			// m_3
			$this->m_3->EditAttrs["class"] = "form-control";
			$this->m_3->EditCustomAttributes = "";
			$this->m_3->EditValue = HtmlEncode($this->m_3->AdvancedSearch->SearchValue);
			$this->m_3->PlaceHolder = RemoveHtml($this->m_3->caption());

			// 4
			$this->_4->EditAttrs["class"] = "form-control";
			$this->_4->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_4->AdvancedSearch->SearchValue = HtmlDecode($this->_4->AdvancedSearch->SearchValue);
			$this->_4->EditValue = HtmlEncode($this->_4->AdvancedSearch->SearchValue);
			$this->_4->PlaceHolder = RemoveHtml($this->_4->caption());

			// m_4
			$this->m_4->EditAttrs["class"] = "form-control";
			$this->m_4->EditCustomAttributes = "";
			$this->m_4->EditValue = HtmlEncode($this->m_4->AdvancedSearch->SearchValue);
			$this->m_4->PlaceHolder = RemoveHtml($this->m_4->caption());

			// 5
			$this->_5->EditAttrs["class"] = "form-control";
			$this->_5->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_5->AdvancedSearch->SearchValue = HtmlDecode($this->_5->AdvancedSearch->SearchValue);
			$this->_5->EditValue = HtmlEncode($this->_5->AdvancedSearch->SearchValue);
			$this->_5->PlaceHolder = RemoveHtml($this->_5->caption());

			// m_5
			$this->m_5->EditAttrs["class"] = "form-control";
			$this->m_5->EditCustomAttributes = "";
			$this->m_5->EditValue = HtmlEncode($this->m_5->AdvancedSearch->SearchValue);
			$this->m_5->PlaceHolder = RemoveHtml($this->m_5->caption());

			// 6
			$this->_6->EditAttrs["class"] = "form-control";
			$this->_6->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_6->AdvancedSearch->SearchValue = HtmlDecode($this->_6->AdvancedSearch->SearchValue);
			$this->_6->EditValue = HtmlEncode($this->_6->AdvancedSearch->SearchValue);
			$this->_6->PlaceHolder = RemoveHtml($this->_6->caption());

			// m_6
			$this->m_6->EditAttrs["class"] = "form-control";
			$this->m_6->EditCustomAttributes = "";
			$this->m_6->EditValue = HtmlEncode($this->m_6->AdvancedSearch->SearchValue);
			$this->m_6->PlaceHolder = RemoveHtml($this->m_6->caption());

			// 7
			$this->_7->EditAttrs["class"] = "form-control";
			$this->_7->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_7->AdvancedSearch->SearchValue = HtmlDecode($this->_7->AdvancedSearch->SearchValue);
			$this->_7->EditValue = HtmlEncode($this->_7->AdvancedSearch->SearchValue);
			$this->_7->PlaceHolder = RemoveHtml($this->_7->caption());

			// m_7
			$this->m_7->EditAttrs["class"] = "form-control";
			$this->m_7->EditCustomAttributes = "";
			$this->m_7->EditValue = HtmlEncode($this->m_7->AdvancedSearch->SearchValue);
			$this->m_7->PlaceHolder = RemoveHtml($this->m_7->caption());

			// 8
			$this->_8->EditAttrs["class"] = "form-control";
			$this->_8->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_8->AdvancedSearch->SearchValue = HtmlDecode($this->_8->AdvancedSearch->SearchValue);
			$this->_8->EditValue = HtmlEncode($this->_8->AdvancedSearch->SearchValue);
			$this->_8->PlaceHolder = RemoveHtml($this->_8->caption());

			// m_8
			$this->m_8->EditAttrs["class"] = "form-control";
			$this->m_8->EditCustomAttributes = "";
			$this->m_8->EditValue = HtmlEncode($this->m_8->AdvancedSearch->SearchValue);
			$this->m_8->PlaceHolder = RemoveHtml($this->m_8->caption());

			// 9
			$this->_9->EditAttrs["class"] = "form-control";
			$this->_9->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_9->AdvancedSearch->SearchValue = HtmlDecode($this->_9->AdvancedSearch->SearchValue);
			$this->_9->EditValue = HtmlEncode($this->_9->AdvancedSearch->SearchValue);
			$this->_9->PlaceHolder = RemoveHtml($this->_9->caption());

			// m_9
			$this->m_9->EditAttrs["class"] = "form-control";
			$this->m_9->EditCustomAttributes = "";
			$this->m_9->EditValue = HtmlEncode($this->m_9->AdvancedSearch->SearchValue);
			$this->m_9->PlaceHolder = RemoveHtml($this->m_9->caption());

			// 10
			$this->_10->EditAttrs["class"] = "form-control";
			$this->_10->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_10->AdvancedSearch->SearchValue = HtmlDecode($this->_10->AdvancedSearch->SearchValue);
			$this->_10->EditValue = HtmlEncode($this->_10->AdvancedSearch->SearchValue);
			$this->_10->PlaceHolder = RemoveHtml($this->_10->caption());

			// m_10
			$this->m_10->EditAttrs["class"] = "form-control";
			$this->m_10->EditCustomAttributes = "";
			$this->m_10->EditValue = HtmlEncode($this->m_10->AdvancedSearch->SearchValue);
			$this->m_10->PlaceHolder = RemoveHtml($this->m_10->caption());

			// 11
			$this->_11->EditAttrs["class"] = "form-control";
			$this->_11->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_11->AdvancedSearch->SearchValue = HtmlDecode($this->_11->AdvancedSearch->SearchValue);
			$this->_11->EditValue = HtmlEncode($this->_11->AdvancedSearch->SearchValue);
			$this->_11->PlaceHolder = RemoveHtml($this->_11->caption());

			// m_11
			$this->m_11->EditAttrs["class"] = "form-control";
			$this->m_11->EditCustomAttributes = "";
			$this->m_11->EditValue = HtmlEncode($this->m_11->AdvancedSearch->SearchValue);
			$this->m_11->PlaceHolder = RemoveHtml($this->m_11->caption());

			// 12
			$this->_12->EditAttrs["class"] = "form-control";
			$this->_12->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_12->AdvancedSearch->SearchValue = HtmlDecode($this->_12->AdvancedSearch->SearchValue);
			$this->_12->EditValue = HtmlEncode($this->_12->AdvancedSearch->SearchValue);
			$this->_12->PlaceHolder = RemoveHtml($this->_12->caption());

			// m_12
			$this->m_12->EditAttrs["class"] = "form-control";
			$this->m_12->EditCustomAttributes = "";
			$this->m_12->EditValue = HtmlEncode($this->m_12->AdvancedSearch->SearchValue);
			$this->m_12->PlaceHolder = RemoveHtml($this->m_12->caption());

			// 13
			$this->_13->EditAttrs["class"] = "form-control";
			$this->_13->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_13->AdvancedSearch->SearchValue = HtmlDecode($this->_13->AdvancedSearch->SearchValue);
			$this->_13->EditValue = HtmlEncode($this->_13->AdvancedSearch->SearchValue);
			$this->_13->PlaceHolder = RemoveHtml($this->_13->caption());

			// m_13
			$this->m_13->EditAttrs["class"] = "form-control";
			$this->m_13->EditCustomAttributes = "";
			$this->m_13->EditValue = HtmlEncode($this->m_13->AdvancedSearch->SearchValue);
			$this->m_13->PlaceHolder = RemoveHtml($this->m_13->caption());

			// 14
			$this->_14->EditAttrs["class"] = "form-control";
			$this->_14->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_14->AdvancedSearch->SearchValue = HtmlDecode($this->_14->AdvancedSearch->SearchValue);
			$this->_14->EditValue = HtmlEncode($this->_14->AdvancedSearch->SearchValue);
			$this->_14->PlaceHolder = RemoveHtml($this->_14->caption());

			// m_14
			$this->m_14->EditAttrs["class"] = "form-control";
			$this->m_14->EditCustomAttributes = "";
			$this->m_14->EditValue = HtmlEncode($this->m_14->AdvancedSearch->SearchValue);
			$this->m_14->PlaceHolder = RemoveHtml($this->m_14->caption());

			// 15
			$this->_15->EditAttrs["class"] = "form-control";
			$this->_15->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_15->AdvancedSearch->SearchValue = HtmlDecode($this->_15->AdvancedSearch->SearchValue);
			$this->_15->EditValue = HtmlEncode($this->_15->AdvancedSearch->SearchValue);
			$this->_15->PlaceHolder = RemoveHtml($this->_15->caption());

			// m_15
			$this->m_15->EditAttrs["class"] = "form-control";
			$this->m_15->EditCustomAttributes = "";
			$this->m_15->EditValue = HtmlEncode($this->m_15->AdvancedSearch->SearchValue);
			$this->m_15->PlaceHolder = RemoveHtml($this->m_15->caption());

			// 16
			$this->_16->EditAttrs["class"] = "form-control";
			$this->_16->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_16->AdvancedSearch->SearchValue = HtmlDecode($this->_16->AdvancedSearch->SearchValue);
			$this->_16->EditValue = HtmlEncode($this->_16->AdvancedSearch->SearchValue);
			$this->_16->PlaceHolder = RemoveHtml($this->_16->caption());

			// m_16
			$this->m_16->EditAttrs["class"] = "form-control";
			$this->m_16->EditCustomAttributes = "";
			$this->m_16->EditValue = HtmlEncode($this->m_16->AdvancedSearch->SearchValue);
			$this->m_16->PlaceHolder = RemoveHtml($this->m_16->caption());

			// 17
			$this->_17->EditAttrs["class"] = "form-control";
			$this->_17->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_17->AdvancedSearch->SearchValue = HtmlDecode($this->_17->AdvancedSearch->SearchValue);
			$this->_17->EditValue = HtmlEncode($this->_17->AdvancedSearch->SearchValue);
			$this->_17->PlaceHolder = RemoveHtml($this->_17->caption());

			// m_17
			$this->m_17->EditAttrs["class"] = "form-control";
			$this->m_17->EditCustomAttributes = "";
			$this->m_17->EditValue = HtmlEncode($this->m_17->AdvancedSearch->SearchValue);
			$this->m_17->PlaceHolder = RemoveHtml($this->m_17->caption());

			// 18
			$this->_18->EditAttrs["class"] = "form-control";
			$this->_18->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_18->AdvancedSearch->SearchValue = HtmlDecode($this->_18->AdvancedSearch->SearchValue);
			$this->_18->EditValue = HtmlEncode($this->_18->AdvancedSearch->SearchValue);
			$this->_18->PlaceHolder = RemoveHtml($this->_18->caption());

			// m_18
			$this->m_18->EditAttrs["class"] = "form-control";
			$this->m_18->EditCustomAttributes = "";
			$this->m_18->EditValue = HtmlEncode($this->m_18->AdvancedSearch->SearchValue);
			$this->m_18->PlaceHolder = RemoveHtml($this->m_18->caption());

			// 19
			$this->_19->EditAttrs["class"] = "form-control";
			$this->_19->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_19->AdvancedSearch->SearchValue = HtmlDecode($this->_19->AdvancedSearch->SearchValue);
			$this->_19->EditValue = HtmlEncode($this->_19->AdvancedSearch->SearchValue);
			$this->_19->PlaceHolder = RemoveHtml($this->_19->caption());

			// m_19
			$this->m_19->EditAttrs["class"] = "form-control";
			$this->m_19->EditCustomAttributes = "";
			$this->m_19->EditValue = HtmlEncode($this->m_19->AdvancedSearch->SearchValue);
			$this->m_19->PlaceHolder = RemoveHtml($this->m_19->caption());

			// 20
			$this->_20->EditAttrs["class"] = "form-control";
			$this->_20->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_20->AdvancedSearch->SearchValue = HtmlDecode($this->_20->AdvancedSearch->SearchValue);
			$this->_20->EditValue = HtmlEncode($this->_20->AdvancedSearch->SearchValue);
			$this->_20->PlaceHolder = RemoveHtml($this->_20->caption());

			// m_20
			$this->m_20->EditAttrs["class"] = "form-control";
			$this->m_20->EditCustomAttributes = "";
			$this->m_20->EditValue = HtmlEncode($this->m_20->AdvancedSearch->SearchValue);
			$this->m_20->PlaceHolder = RemoveHtml($this->m_20->caption());

			// 21
			$this->_21->EditAttrs["class"] = "form-control";
			$this->_21->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_21->AdvancedSearch->SearchValue = HtmlDecode($this->_21->AdvancedSearch->SearchValue);
			$this->_21->EditValue = HtmlEncode($this->_21->AdvancedSearch->SearchValue);
			$this->_21->PlaceHolder = RemoveHtml($this->_21->caption());

			// m_21
			$this->m_21->EditAttrs["class"] = "form-control";
			$this->m_21->EditCustomAttributes = "";
			$this->m_21->EditValue = HtmlEncode($this->m_21->AdvancedSearch->SearchValue);
			$this->m_21->PlaceHolder = RemoveHtml($this->m_21->caption());

			// 22
			$this->_22->EditAttrs["class"] = "form-control";
			$this->_22->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_22->AdvancedSearch->SearchValue = HtmlDecode($this->_22->AdvancedSearch->SearchValue);
			$this->_22->EditValue = HtmlEncode($this->_22->AdvancedSearch->SearchValue);
			$this->_22->PlaceHolder = RemoveHtml($this->_22->caption());

			// m_22
			$this->m_22->EditAttrs["class"] = "form-control";
			$this->m_22->EditCustomAttributes = "";
			$this->m_22->EditValue = HtmlEncode($this->m_22->AdvancedSearch->SearchValue);
			$this->m_22->PlaceHolder = RemoveHtml($this->m_22->caption());

			// 23
			$this->_23->EditAttrs["class"] = "form-control";
			$this->_23->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_23->AdvancedSearch->SearchValue = HtmlDecode($this->_23->AdvancedSearch->SearchValue);
			$this->_23->EditValue = HtmlEncode($this->_23->AdvancedSearch->SearchValue);
			$this->_23->PlaceHolder = RemoveHtml($this->_23->caption());

			// m_23
			$this->m_23->EditAttrs["class"] = "form-control";
			$this->m_23->EditCustomAttributes = "";
			$this->m_23->EditValue = HtmlEncode($this->m_23->AdvancedSearch->SearchValue);
			$this->m_23->PlaceHolder = RemoveHtml($this->m_23->caption());

			// 24
			$this->_24->EditAttrs["class"] = "form-control";
			$this->_24->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_24->AdvancedSearch->SearchValue = HtmlDecode($this->_24->AdvancedSearch->SearchValue);
			$this->_24->EditValue = HtmlEncode($this->_24->AdvancedSearch->SearchValue);
			$this->_24->PlaceHolder = RemoveHtml($this->_24->caption());

			// m_24
			$this->m_24->EditAttrs["class"] = "form-control";
			$this->m_24->EditCustomAttributes = "";
			$this->m_24->EditValue = HtmlEncode($this->m_24->AdvancedSearch->SearchValue);
			$this->m_24->PlaceHolder = RemoveHtml($this->m_24->caption());

			// 25
			$this->_25->EditAttrs["class"] = "form-control";
			$this->_25->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_25->AdvancedSearch->SearchValue = HtmlDecode($this->_25->AdvancedSearch->SearchValue);
			$this->_25->EditValue = HtmlEncode($this->_25->AdvancedSearch->SearchValue);
			$this->_25->PlaceHolder = RemoveHtml($this->_25->caption());

			// m_25
			$this->m_25->EditAttrs["class"] = "form-control";
			$this->m_25->EditCustomAttributes = "";
			$this->m_25->EditValue = HtmlEncode($this->m_25->AdvancedSearch->SearchValue);
			$this->m_25->PlaceHolder = RemoveHtml($this->m_25->caption());

			// 26
			$this->_26->EditAttrs["class"] = "form-control";
			$this->_26->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_26->AdvancedSearch->SearchValue = HtmlDecode($this->_26->AdvancedSearch->SearchValue);
			$this->_26->EditValue = HtmlEncode($this->_26->AdvancedSearch->SearchValue);
			$this->_26->PlaceHolder = RemoveHtml($this->_26->caption());

			// m_26
			$this->m_26->EditAttrs["class"] = "form-control";
			$this->m_26->EditCustomAttributes = "";
			$this->m_26->EditValue = HtmlEncode($this->m_26->AdvancedSearch->SearchValue);
			$this->m_26->PlaceHolder = RemoveHtml($this->m_26->caption());

			// 27
			$this->_27->EditAttrs["class"] = "form-control";
			$this->_27->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_27->AdvancedSearch->SearchValue = HtmlDecode($this->_27->AdvancedSearch->SearchValue);
			$this->_27->EditValue = HtmlEncode($this->_27->AdvancedSearch->SearchValue);
			$this->_27->PlaceHolder = RemoveHtml($this->_27->caption());

			// m_27
			$this->m_27->EditAttrs["class"] = "form-control";
			$this->m_27->EditCustomAttributes = "";
			$this->m_27->EditValue = HtmlEncode($this->m_27->AdvancedSearch->SearchValue);
			$this->m_27->PlaceHolder = RemoveHtml($this->m_27->caption());

			// 28
			$this->_28->EditAttrs["class"] = "form-control";
			$this->_28->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_28->AdvancedSearch->SearchValue = HtmlDecode($this->_28->AdvancedSearch->SearchValue);
			$this->_28->EditValue = HtmlEncode($this->_28->AdvancedSearch->SearchValue);
			$this->_28->PlaceHolder = RemoveHtml($this->_28->caption());

			// m_28
			$this->m_28->EditAttrs["class"] = "form-control";
			$this->m_28->EditCustomAttributes = "";
			$this->m_28->EditValue = HtmlEncode($this->m_28->AdvancedSearch->SearchValue);
			$this->m_28->PlaceHolder = RemoveHtml($this->m_28->caption());

			// 29
			$this->_29->EditAttrs["class"] = "form-control";
			$this->_29->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_29->AdvancedSearch->SearchValue = HtmlDecode($this->_29->AdvancedSearch->SearchValue);
			$this->_29->EditValue = HtmlEncode($this->_29->AdvancedSearch->SearchValue);
			$this->_29->PlaceHolder = RemoveHtml($this->_29->caption());

			// m_29
			$this->m_29->EditAttrs["class"] = "form-control";
			$this->m_29->EditCustomAttributes = "";
			$this->m_29->EditValue = HtmlEncode($this->m_29->AdvancedSearch->SearchValue);
			$this->m_29->PlaceHolder = RemoveHtml($this->m_29->caption());

			// 30
			$this->_30->EditAttrs["class"] = "form-control";
			$this->_30->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_30->AdvancedSearch->SearchValue = HtmlDecode($this->_30->AdvancedSearch->SearchValue);
			$this->_30->EditValue = HtmlEncode($this->_30->AdvancedSearch->SearchValue);
			$this->_30->PlaceHolder = RemoveHtml($this->_30->caption());

			// m_30
			$this->m_30->EditAttrs["class"] = "form-control";
			$this->m_30->EditCustomAttributes = "";
			$this->m_30->EditValue = HtmlEncode($this->m_30->AdvancedSearch->SearchValue);
			$this->m_30->PlaceHolder = RemoveHtml($this->m_30->caption());

			// 31
			$this->_31->EditAttrs["class"] = "form-control";
			$this->_31->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_31->AdvancedSearch->SearchValue = HtmlDecode($this->_31->AdvancedSearch->SearchValue);
			$this->_31->EditValue = HtmlEncode($this->_31->AdvancedSearch->SearchValue);
			$this->_31->PlaceHolder = RemoveHtml($this->_31->caption());

			// m_31
			$this->m_31->EditAttrs["class"] = "form-control";
			$this->m_31->EditCustomAttributes = "";
			$this->m_31->EditValue = HtmlEncode($this->m_31->AdvancedSearch->SearchValue);
			$this->m_31->PlaceHolder = RemoveHtml($this->m_31->caption());

			// 32
			$this->_32->EditAttrs["class"] = "form-control";
			$this->_32->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_32->AdvancedSearch->SearchValue = HtmlDecode($this->_32->AdvancedSearch->SearchValue);
			$this->_32->EditValue = HtmlEncode($this->_32->AdvancedSearch->SearchValue);
			$this->_32->PlaceHolder = RemoveHtml($this->_32->caption());

			// m_32
			$this->m_32->EditAttrs["class"] = "form-control";
			$this->m_32->EditCustomAttributes = "";
			$this->m_32->EditValue = HtmlEncode($this->m_32->AdvancedSearch->SearchValue);
			$this->m_32->PlaceHolder = RemoveHtml($this->m_32->caption());

			// 33
			$this->_33->EditAttrs["class"] = "form-control";
			$this->_33->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_33->AdvancedSearch->SearchValue = HtmlDecode($this->_33->AdvancedSearch->SearchValue);
			$this->_33->EditValue = HtmlEncode($this->_33->AdvancedSearch->SearchValue);
			$this->_33->PlaceHolder = RemoveHtml($this->_33->caption());

			// m_33
			$this->m_33->EditAttrs["class"] = "form-control";
			$this->m_33->EditCustomAttributes = "";
			$this->m_33->EditValue = HtmlEncode($this->m_33->AdvancedSearch->SearchValue);
			$this->m_33->PlaceHolder = RemoveHtml($this->m_33->caption());

			// 34
			$this->_34->EditAttrs["class"] = "form-control";
			$this->_34->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_34->AdvancedSearch->SearchValue = HtmlDecode($this->_34->AdvancedSearch->SearchValue);
			$this->_34->EditValue = HtmlEncode($this->_34->AdvancedSearch->SearchValue);
			$this->_34->PlaceHolder = RemoveHtml($this->_34->caption());

			// m_34
			$this->m_34->EditAttrs["class"] = "form-control";
			$this->m_34->EditCustomAttributes = "";
			$this->m_34->EditValue = HtmlEncode($this->m_34->AdvancedSearch->SearchValue);
			$this->m_34->PlaceHolder = RemoveHtml($this->m_34->caption());

			// 35
			$this->_35->EditAttrs["class"] = "form-control";
			$this->_35->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_35->AdvancedSearch->SearchValue = HtmlDecode($this->_35->AdvancedSearch->SearchValue);
			$this->_35->EditValue = HtmlEncode($this->_35->AdvancedSearch->SearchValue);
			$this->_35->PlaceHolder = RemoveHtml($this->_35->caption());

			// m_35
			$this->m_35->EditAttrs["class"] = "form-control";
			$this->m_35->EditCustomAttributes = "";
			$this->m_35->EditValue = HtmlEncode($this->m_35->AdvancedSearch->SearchValue);
			$this->m_35->PlaceHolder = RemoveHtml($this->m_35->caption());

			// 36
			$this->_36->EditAttrs["class"] = "form-control";
			$this->_36->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_36->AdvancedSearch->SearchValue = HtmlDecode($this->_36->AdvancedSearch->SearchValue);
			$this->_36->EditValue = HtmlEncode($this->_36->AdvancedSearch->SearchValue);
			$this->_36->PlaceHolder = RemoveHtml($this->_36->caption());

			// m_36
			$this->m_36->EditAttrs["class"] = "form-control";
			$this->m_36->EditCustomAttributes = "";
			$this->m_36->EditValue = HtmlEncode($this->m_36->AdvancedSearch->SearchValue);
			$this->m_36->PlaceHolder = RemoveHtml($this->m_36->caption());

			// 37
			$this->_37->EditAttrs["class"] = "form-control";
			$this->_37->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_37->AdvancedSearch->SearchValue = HtmlDecode($this->_37->AdvancedSearch->SearchValue);
			$this->_37->EditValue = HtmlEncode($this->_37->AdvancedSearch->SearchValue);
			$this->_37->PlaceHolder = RemoveHtml($this->_37->caption());

			// m_37
			$this->m_37->EditAttrs["class"] = "form-control";
			$this->m_37->EditCustomAttributes = "";
			$this->m_37->EditValue = HtmlEncode($this->m_37->AdvancedSearch->SearchValue);
			$this->m_37->PlaceHolder = RemoveHtml($this->m_37->caption());

			// 38
			$this->_38->EditAttrs["class"] = "form-control";
			$this->_38->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_38->AdvancedSearch->SearchValue = HtmlDecode($this->_38->AdvancedSearch->SearchValue);
			$this->_38->EditValue = HtmlEncode($this->_38->AdvancedSearch->SearchValue);
			$this->_38->PlaceHolder = RemoveHtml($this->_38->caption());

			// m_38
			$this->m_38->EditAttrs["class"] = "form-control";
			$this->m_38->EditCustomAttributes = "";
			$this->m_38->EditValue = HtmlEncode($this->m_38->AdvancedSearch->SearchValue);
			$this->m_38->PlaceHolder = RemoveHtml($this->m_38->caption());

			// 39
			$this->_39->EditAttrs["class"] = "form-control";
			$this->_39->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_39->AdvancedSearch->SearchValue = HtmlDecode($this->_39->AdvancedSearch->SearchValue);
			$this->_39->EditValue = HtmlEncode($this->_39->AdvancedSearch->SearchValue);
			$this->_39->PlaceHolder = RemoveHtml($this->_39->caption());

			// m_39
			$this->m_39->EditAttrs["class"] = "form-control";
			$this->m_39->EditCustomAttributes = "";
			$this->m_39->EditValue = HtmlEncode($this->m_39->AdvancedSearch->SearchValue);
			$this->m_39->PlaceHolder = RemoveHtml($this->m_39->caption());

			// 40
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_40->AdvancedSearch->SearchValue = HtmlDecode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

			// m_40
			$this->m_40->EditAttrs["class"] = "form-control";
			$this->m_40->EditCustomAttributes = "";
			$this->m_40->EditValue = HtmlEncode($this->m_40->AdvancedSearch->SearchValue);
			$this->m_40->PlaceHolder = RemoveHtml($this->m_40->caption());

			// 41
			$this->_41->EditAttrs["class"] = "form-control";
			$this->_41->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_41->AdvancedSearch->SearchValue = HtmlDecode($this->_41->AdvancedSearch->SearchValue);
			$this->_41->EditValue = HtmlEncode($this->_41->AdvancedSearch->SearchValue);
			$this->_41->PlaceHolder = RemoveHtml($this->_41->caption());

			// m_41
			$this->m_41->EditAttrs["class"] = "form-control";
			$this->m_41->EditCustomAttributes = "";
			$this->m_41->EditValue = HtmlEncode($this->m_41->AdvancedSearch->SearchValue);
			$this->m_41->PlaceHolder = RemoveHtml($this->m_41->caption());

			// 42
			$this->_42->EditAttrs["class"] = "form-control";
			$this->_42->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_42->AdvancedSearch->SearchValue = HtmlDecode($this->_42->AdvancedSearch->SearchValue);
			$this->_42->EditValue = HtmlEncode($this->_42->AdvancedSearch->SearchValue);
			$this->_42->PlaceHolder = RemoveHtml($this->_42->caption());

			// m_42
			$this->m_42->EditAttrs["class"] = "form-control";
			$this->m_42->EditCustomAttributes = "";
			$this->m_42->EditValue = HtmlEncode($this->m_42->AdvancedSearch->SearchValue);
			$this->m_42->PlaceHolder = RemoveHtml($this->m_42->caption());

			// 43
			$this->_43->EditAttrs["class"] = "form-control";
			$this->_43->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_43->AdvancedSearch->SearchValue = HtmlDecode($this->_43->AdvancedSearch->SearchValue);
			$this->_43->EditValue = HtmlEncode($this->_43->AdvancedSearch->SearchValue);
			$this->_43->PlaceHolder = RemoveHtml($this->_43->caption());

			// m_43
			$this->m_43->EditAttrs["class"] = "form-control";
			$this->m_43->EditCustomAttributes = "";
			$this->m_43->EditValue = HtmlEncode($this->m_43->AdvancedSearch->SearchValue);
			$this->m_43->PlaceHolder = RemoveHtml($this->m_43->caption());

			// 44
			$this->_44->EditAttrs["class"] = "form-control";
			$this->_44->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_44->AdvancedSearch->SearchValue = HtmlDecode($this->_44->AdvancedSearch->SearchValue);
			$this->_44->EditValue = HtmlEncode($this->_44->AdvancedSearch->SearchValue);
			$this->_44->PlaceHolder = RemoveHtml($this->_44->caption());

			// m_44
			$this->m_44->EditAttrs["class"] = "form-control";
			$this->m_44->EditCustomAttributes = "";
			$this->m_44->EditValue = HtmlEncode($this->m_44->AdvancedSearch->SearchValue);
			$this->m_44->PlaceHolder = RemoveHtml($this->m_44->caption());

			// 45
			$this->_45->EditAttrs["class"] = "form-control";
			$this->_45->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_45->AdvancedSearch->SearchValue = HtmlDecode($this->_45->AdvancedSearch->SearchValue);
			$this->_45->EditValue = HtmlEncode($this->_45->AdvancedSearch->SearchValue);
			$this->_45->PlaceHolder = RemoveHtml($this->_45->caption());

			// m_45
			$this->m_45->EditAttrs["class"] = "form-control";
			$this->m_45->EditCustomAttributes = "";
			$this->m_45->EditValue = HtmlEncode($this->m_45->AdvancedSearch->SearchValue);
			$this->m_45->PlaceHolder = RemoveHtml($this->m_45->caption());

			// 46
			$this->_46->EditAttrs["class"] = "form-control";
			$this->_46->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_46->AdvancedSearch->SearchValue = HtmlDecode($this->_46->AdvancedSearch->SearchValue);
			$this->_46->EditValue = HtmlEncode($this->_46->AdvancedSearch->SearchValue);
			$this->_46->PlaceHolder = RemoveHtml($this->_46->caption());

			// m_46
			$this->m_46->EditAttrs["class"] = "form-control";
			$this->m_46->EditCustomAttributes = "";
			$this->m_46->EditValue = HtmlEncode($this->m_46->AdvancedSearch->SearchValue);
			$this->m_46->PlaceHolder = RemoveHtml($this->m_46->caption());

			// 47
			$this->_47->EditAttrs["class"] = "form-control";
			$this->_47->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_47->AdvancedSearch->SearchValue = HtmlDecode($this->_47->AdvancedSearch->SearchValue);
			$this->_47->EditValue = HtmlEncode($this->_47->AdvancedSearch->SearchValue);
			$this->_47->PlaceHolder = RemoveHtml($this->_47->caption());

			// m_47
			$this->m_47->EditAttrs["class"] = "form-control";
			$this->m_47->EditCustomAttributes = "";
			$this->m_47->EditValue = HtmlEncode($this->m_47->AdvancedSearch->SearchValue);
			$this->m_47->PlaceHolder = RemoveHtml($this->m_47->caption());

			// 48
			$this->_48->EditAttrs["class"] = "form-control";
			$this->_48->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_48->AdvancedSearch->SearchValue = HtmlDecode($this->_48->AdvancedSearch->SearchValue);
			$this->_48->EditValue = HtmlEncode($this->_48->AdvancedSearch->SearchValue);
			$this->_48->PlaceHolder = RemoveHtml($this->_48->caption());

			// m_48
			$this->m_48->EditAttrs["class"] = "form-control";
			$this->m_48->EditCustomAttributes = "";
			$this->m_48->EditValue = HtmlEncode($this->m_48->AdvancedSearch->SearchValue);
			$this->m_48->PlaceHolder = RemoveHtml($this->m_48->caption());

			// 49
			$this->_49->EditAttrs["class"] = "form-control";
			$this->_49->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_49->AdvancedSearch->SearchValue = HtmlDecode($this->_49->AdvancedSearch->SearchValue);
			$this->_49->EditValue = HtmlEncode($this->_49->AdvancedSearch->SearchValue);
			$this->_49->PlaceHolder = RemoveHtml($this->_49->caption());

			// m_49
			$this->m_49->EditAttrs["class"] = "form-control";
			$this->m_49->EditCustomAttributes = "";
			$this->m_49->EditValue = HtmlEncode($this->m_49->AdvancedSearch->SearchValue);
			$this->m_49->PlaceHolder = RemoveHtml($this->m_49->caption());

			// 50
			$this->_50->EditAttrs["class"] = "form-control";
			$this->_50->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_50->AdvancedSearch->SearchValue = HtmlDecode($this->_50->AdvancedSearch->SearchValue);
			$this->_50->EditValue = HtmlEncode($this->_50->AdvancedSearch->SearchValue);
			$this->_50->PlaceHolder = RemoveHtml($this->_50->caption());

			// m_50
			$this->m_50->EditAttrs["class"] = "form-control";
			$this->m_50->EditCustomAttributes = "";
			$this->m_50->EditValue = HtmlEncode($this->m_50->AdvancedSearch->SearchValue);
			$this->m_50->PlaceHolder = RemoveHtml($this->m_50->caption());

			// 51
			$this->_51->EditAttrs["class"] = "form-control";
			$this->_51->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_51->AdvancedSearch->SearchValue = HtmlDecode($this->_51->AdvancedSearch->SearchValue);
			$this->_51->EditValue = HtmlEncode($this->_51->AdvancedSearch->SearchValue);
			$this->_51->PlaceHolder = RemoveHtml($this->_51->caption());

			// m_51
			$this->m_51->EditAttrs["class"] = "form-control";
			$this->m_51->EditCustomAttributes = "";
			$this->m_51->EditValue = HtmlEncode($this->m_51->AdvancedSearch->SearchValue);
			$this->m_51->PlaceHolder = RemoveHtml($this->m_51->caption());

			// 52
			$this->_52->EditAttrs["class"] = "form-control";
			$this->_52->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_52->AdvancedSearch->SearchValue = HtmlDecode($this->_52->AdvancedSearch->SearchValue);
			$this->_52->EditValue = HtmlEncode($this->_52->AdvancedSearch->SearchValue);
			$this->_52->PlaceHolder = RemoveHtml($this->_52->caption());

			// m_52
			$this->m_52->EditAttrs["class"] = "form-control";
			$this->m_52->EditCustomAttributes = "";
			$this->m_52->EditValue = HtmlEncode($this->m_52->AdvancedSearch->SearchValue);
			$this->m_52->PlaceHolder = RemoveHtml($this->m_52->caption());

			// 53
			$this->_53->EditAttrs["class"] = "form-control";
			$this->_53->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_53->AdvancedSearch->SearchValue = HtmlDecode($this->_53->AdvancedSearch->SearchValue);
			$this->_53->EditValue = HtmlEncode($this->_53->AdvancedSearch->SearchValue);
			$this->_53->PlaceHolder = RemoveHtml($this->_53->caption());

			// m_53
			$this->m_53->EditAttrs["class"] = "form-control";
			$this->m_53->EditCustomAttributes = "";
			$this->m_53->EditValue = HtmlEncode($this->m_53->AdvancedSearch->SearchValue);
			$this->m_53->PlaceHolder = RemoveHtml($this->m_53->caption());

			// 54
			$this->_54->EditAttrs["class"] = "form-control";
			$this->_54->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_54->AdvancedSearch->SearchValue = HtmlDecode($this->_54->AdvancedSearch->SearchValue);
			$this->_54->EditValue = HtmlEncode($this->_54->AdvancedSearch->SearchValue);
			$this->_54->PlaceHolder = RemoveHtml($this->_54->caption());

			// m_54
			$this->m_54->EditAttrs["class"] = "form-control";
			$this->m_54->EditCustomAttributes = "";
			$this->m_54->EditValue = HtmlEncode($this->m_54->AdvancedSearch->SearchValue);
			$this->m_54->PlaceHolder = RemoveHtml($this->m_54->caption());

			// 55
			$this->_55->EditAttrs["class"] = "form-control";
			$this->_55->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_55->AdvancedSearch->SearchValue = HtmlDecode($this->_55->AdvancedSearch->SearchValue);
			$this->_55->EditValue = HtmlEncode($this->_55->AdvancedSearch->SearchValue);
			$this->_55->PlaceHolder = RemoveHtml($this->_55->caption());

			// m_55
			$this->m_55->EditAttrs["class"] = "form-control";
			$this->m_55->EditCustomAttributes = "";
			$this->m_55->EditValue = HtmlEncode($this->m_55->AdvancedSearch->SearchValue);
			$this->m_55->PlaceHolder = RemoveHtml($this->m_55->caption());

			// 56
			$this->_56->EditAttrs["class"] = "form-control";
			$this->_56->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_56->AdvancedSearch->SearchValue = HtmlDecode($this->_56->AdvancedSearch->SearchValue);
			$this->_56->EditValue = HtmlEncode($this->_56->AdvancedSearch->SearchValue);
			$this->_56->PlaceHolder = RemoveHtml($this->_56->caption());

			// m_56
			$this->m_56->EditAttrs["class"] = "form-control";
			$this->m_56->EditCustomAttributes = "";
			$this->m_56->EditValue = HtmlEncode($this->m_56->AdvancedSearch->SearchValue);
			$this->m_56->PlaceHolder = RemoveHtml($this->m_56->caption());

			// 57
			$this->_57->EditAttrs["class"] = "form-control";
			$this->_57->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_57->AdvancedSearch->SearchValue = HtmlDecode($this->_57->AdvancedSearch->SearchValue);
			$this->_57->EditValue = HtmlEncode($this->_57->AdvancedSearch->SearchValue);
			$this->_57->PlaceHolder = RemoveHtml($this->_57->caption());

			// m_57
			$this->m_57->EditAttrs["class"] = "form-control";
			$this->m_57->EditCustomAttributes = "";
			$this->m_57->EditValue = HtmlEncode($this->m_57->AdvancedSearch->SearchValue);
			$this->m_57->PlaceHolder = RemoveHtml($this->m_57->caption());

			// 58
			$this->_58->EditAttrs["class"] = "form-control";
			$this->_58->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_58->AdvancedSearch->SearchValue = HtmlDecode($this->_58->AdvancedSearch->SearchValue);
			$this->_58->EditValue = HtmlEncode($this->_58->AdvancedSearch->SearchValue);
			$this->_58->PlaceHolder = RemoveHtml($this->_58->caption());

			// m_58
			$this->m_58->EditAttrs["class"] = "form-control";
			$this->m_58->EditCustomAttributes = "";
			$this->m_58->EditValue = HtmlEncode($this->m_58->AdvancedSearch->SearchValue);
			$this->m_58->PlaceHolder = RemoveHtml($this->m_58->caption());

			// 59
			$this->_59->EditAttrs["class"] = "form-control";
			$this->_59->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_59->AdvancedSearch->SearchValue = HtmlDecode($this->_59->AdvancedSearch->SearchValue);
			$this->_59->EditValue = HtmlEncode($this->_59->AdvancedSearch->SearchValue);
			$this->_59->PlaceHolder = RemoveHtml($this->_59->caption());

			// m_59
			$this->m_59->EditAttrs["class"] = "form-control";
			$this->m_59->EditCustomAttributes = "";
			$this->m_59->EditValue = HtmlEncode($this->m_59->AdvancedSearch->SearchValue);
			$this->m_59->PlaceHolder = RemoveHtml($this->m_59->caption());

			// 60
			$this->_60->EditAttrs["class"] = "form-control";
			$this->_60->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->_60->AdvancedSearch->SearchValue = HtmlDecode($this->_60->AdvancedSearch->SearchValue);
			$this->_60->EditValue = HtmlEncode($this->_60->AdvancedSearch->SearchValue);
			$this->_60->PlaceHolder = RemoveHtml($this->_60->caption());

			// m_60
			$this->m_60->EditAttrs["class"] = "form-control";
			$this->m_60->EditCustomAttributes = "";
			$this->m_60->EditValue = HtmlEncode($this->m_60->AdvancedSearch->SearchValue);
			$this->m_60->PlaceHolder = RemoveHtml($this->m_60->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckNumber($this->total->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->total->errorMessage());
		}
		if (!CheckNumber($this->total->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->total->errorMessage());
		}
		if (!CheckNumber($this->percent->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->percent->errorMessage());
		}
		if (!CheckNumber($this->percent->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->percent->errorMessage());
		}
		if (!CheckNumber($this->s_1->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->s_1->errorMessage());
		}
		if (!CheckNumber($this->s_2->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->s_2->errorMessage());
		}
		if (!CheckNumber($this->s_3->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->s_3->errorMessage());
		}
		if (!CheckNumber($this->s_4->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->s_4->errorMessage());
		}
		if (!CheckNumber($this->s_5->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->s_5->errorMessage());
		}
		if (!CheckNumber($this->m_1->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_1->errorMessage());
		}
		if (!CheckNumber($this->m_2->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_2->errorMessage());
		}
		if (!CheckNumber($this->m_3->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_3->errorMessage());
		}
		if (!CheckNumber($this->m_4->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_4->errorMessage());
		}
		if (!CheckNumber($this->m_5->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_5->errorMessage());
		}
		if (!CheckNumber($this->m_6->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_6->errorMessage());
		}
		if (!CheckNumber($this->m_7->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_7->errorMessage());
		}
		if (!CheckNumber($this->m_8->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_8->errorMessage());
		}
		if (!CheckNumber($this->m_9->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_9->errorMessage());
		}
		if (!CheckNumber($this->m_10->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_10->errorMessage());
		}
		if (!CheckNumber($this->m_11->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_11->errorMessage());
		}
		if (!CheckNumber($this->m_12->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_12->errorMessage());
		}
		if (!CheckNumber($this->m_13->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_13->errorMessage());
		}
		if (!CheckNumber($this->m_14->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_14->errorMessage());
		}
		if (!CheckNumber($this->m_15->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_15->errorMessage());
		}
		if (!CheckNumber($this->m_16->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_16->errorMessage());
		}
		if (!CheckNumber($this->m_17->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_17->errorMessage());
		}
		if (!CheckNumber($this->m_18->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_18->errorMessage());
		}
		if (!CheckNumber($this->m_19->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_19->errorMessage());
		}
		if (!CheckNumber($this->m_20->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_20->errorMessage());
		}
		if (!CheckNumber($this->m_21->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_21->errorMessage());
		}
		if (!CheckNumber($this->m_22->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_22->errorMessage());
		}
		if (!CheckNumber($this->m_23->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_23->errorMessage());
		}
		if (!CheckNumber($this->m_24->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_24->errorMessage());
		}
		if (!CheckNumber($this->m_25->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_25->errorMessage());
		}
		if (!CheckNumber($this->m_26->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_26->errorMessage());
		}
		if (!CheckNumber($this->m_27->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_27->errorMessage());
		}
		if (!CheckNumber($this->m_28->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_28->errorMessage());
		}
		if (!CheckNumber($this->m_29->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_29->errorMessage());
		}
		if (!CheckNumber($this->m_30->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_30->errorMessage());
		}
		if (!CheckNumber($this->m_31->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_31->errorMessage());
		}
		if (!CheckNumber($this->m_32->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_32->errorMessage());
		}
		if (!CheckNumber($this->m_33->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_33->errorMessage());
		}
		if (!CheckNumber($this->m_34->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_34->errorMessage());
		}
		if (!CheckNumber($this->m_35->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_35->errorMessage());
		}
		if (!CheckNumber($this->m_36->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_36->errorMessage());
		}
		if (!CheckNumber($this->m_37->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_37->errorMessage());
		}
		if (!CheckNumber($this->m_38->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_38->errorMessage());
		}
		if (!CheckNumber($this->m_39->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_39->errorMessage());
		}
		if (!CheckNumber($this->m_40->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_40->errorMessage());
		}
		if (!CheckNumber($this->m_41->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_41->errorMessage());
		}
		if (!CheckNumber($this->m_42->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_42->errorMessage());
		}
		if (!CheckNumber($this->m_43->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_43->errorMessage());
		}
		if (!CheckNumber($this->m_44->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_44->errorMessage());
		}
		if (!CheckNumber($this->m_45->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_45->errorMessage());
		}
		if (!CheckNumber($this->m_46->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_46->errorMessage());
		}
		if (!CheckNumber($this->m_47->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_47->errorMessage());
		}
		if (!CheckNumber($this->m_48->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_48->errorMessage());
		}
		if (!CheckNumber($this->m_49->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_49->errorMessage());
		}
		if (!CheckNumber($this->m_50->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_50->errorMessage());
		}
		if (!CheckNumber($this->m_51->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_51->errorMessage());
		}
		if (!CheckNumber($this->m_52->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_52->errorMessage());
		}
		if (!CheckNumber($this->m_53->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_53->errorMessage());
		}
		if (!CheckNumber($this->m_54->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_54->errorMessage());
		}
		if (!CheckNumber($this->m_55->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_55->errorMessage());
		}
		if (!CheckNumber($this->m_56->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_56->errorMessage());
		}
		if (!CheckNumber($this->m_57->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_57->errorMessage());
		}
		if (!CheckNumber($this->m_58->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_58->errorMessage());
		}
		if (!CheckNumber($this->m_59->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_59->errorMessage());
		}
		if (!CheckNumber($this->m_60->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->m_60->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->roll_no->AdvancedSearch->load();
		$this->test_id->AdvancedSearch->load();
		$this->total->AdvancedSearch->load();
		$this->percent->AdvancedSearch->load();
		$this->s_1->AdvancedSearch->load();
		$this->s_2->AdvancedSearch->load();
		$this->s_3->AdvancedSearch->load();
		$this->s_4->AdvancedSearch->load();
		$this->s_5->AdvancedSearch->load();
		$this->omr_image->AdvancedSearch->load();
		$this->_1->AdvancedSearch->load();
		$this->m_1->AdvancedSearch->load();
		$this->_2->AdvancedSearch->load();
		$this->m_2->AdvancedSearch->load();
		$this->_3->AdvancedSearch->load();
		$this->m_3->AdvancedSearch->load();
		$this->_4->AdvancedSearch->load();
		$this->m_4->AdvancedSearch->load();
		$this->_5->AdvancedSearch->load();
		$this->m_5->AdvancedSearch->load();
		$this->_6->AdvancedSearch->load();
		$this->m_6->AdvancedSearch->load();
		$this->_7->AdvancedSearch->load();
		$this->m_7->AdvancedSearch->load();
		$this->_8->AdvancedSearch->load();
		$this->m_8->AdvancedSearch->load();
		$this->_9->AdvancedSearch->load();
		$this->m_9->AdvancedSearch->load();
		$this->_10->AdvancedSearch->load();
		$this->m_10->AdvancedSearch->load();
		$this->_11->AdvancedSearch->load();
		$this->m_11->AdvancedSearch->load();
		$this->_12->AdvancedSearch->load();
		$this->m_12->AdvancedSearch->load();
		$this->_13->AdvancedSearch->load();
		$this->m_13->AdvancedSearch->load();
		$this->_14->AdvancedSearch->load();
		$this->m_14->AdvancedSearch->load();
		$this->_15->AdvancedSearch->load();
		$this->m_15->AdvancedSearch->load();
		$this->_16->AdvancedSearch->load();
		$this->m_16->AdvancedSearch->load();
		$this->_17->AdvancedSearch->load();
		$this->m_17->AdvancedSearch->load();
		$this->_18->AdvancedSearch->load();
		$this->m_18->AdvancedSearch->load();
		$this->_19->AdvancedSearch->load();
		$this->m_19->AdvancedSearch->load();
		$this->_20->AdvancedSearch->load();
		$this->m_20->AdvancedSearch->load();
		$this->_21->AdvancedSearch->load();
		$this->m_21->AdvancedSearch->load();
		$this->_22->AdvancedSearch->load();
		$this->m_22->AdvancedSearch->load();
		$this->_23->AdvancedSearch->load();
		$this->m_23->AdvancedSearch->load();
		$this->_24->AdvancedSearch->load();
		$this->m_24->AdvancedSearch->load();
		$this->_25->AdvancedSearch->load();
		$this->m_25->AdvancedSearch->load();
		$this->_26->AdvancedSearch->load();
		$this->m_26->AdvancedSearch->load();
		$this->_27->AdvancedSearch->load();
		$this->m_27->AdvancedSearch->load();
		$this->_28->AdvancedSearch->load();
		$this->m_28->AdvancedSearch->load();
		$this->_29->AdvancedSearch->load();
		$this->m_29->AdvancedSearch->load();
		$this->_30->AdvancedSearch->load();
		$this->m_30->AdvancedSearch->load();
		$this->_31->AdvancedSearch->load();
		$this->m_31->AdvancedSearch->load();
		$this->_32->AdvancedSearch->load();
		$this->m_32->AdvancedSearch->load();
		$this->_33->AdvancedSearch->load();
		$this->m_33->AdvancedSearch->load();
		$this->_34->AdvancedSearch->load();
		$this->m_34->AdvancedSearch->load();
		$this->_35->AdvancedSearch->load();
		$this->m_35->AdvancedSearch->load();
		$this->_36->AdvancedSearch->load();
		$this->m_36->AdvancedSearch->load();
		$this->_37->AdvancedSearch->load();
		$this->m_37->AdvancedSearch->load();
		$this->_38->AdvancedSearch->load();
		$this->m_38->AdvancedSearch->load();
		$this->_39->AdvancedSearch->load();
		$this->m_39->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->m_40->AdvancedSearch->load();
		$this->_41->AdvancedSearch->load();
		$this->m_41->AdvancedSearch->load();
		$this->_42->AdvancedSearch->load();
		$this->m_42->AdvancedSearch->load();
		$this->_43->AdvancedSearch->load();
		$this->m_43->AdvancedSearch->load();
		$this->_44->AdvancedSearch->load();
		$this->m_44->AdvancedSearch->load();
		$this->_45->AdvancedSearch->load();
		$this->m_45->AdvancedSearch->load();
		$this->_46->AdvancedSearch->load();
		$this->m_46->AdvancedSearch->load();
		$this->_47->AdvancedSearch->load();
		$this->m_47->AdvancedSearch->load();
		$this->_48->AdvancedSearch->load();
		$this->m_48->AdvancedSearch->load();
		$this->_49->AdvancedSearch->load();
		$this->m_49->AdvancedSearch->load();
		$this->_50->AdvancedSearch->load();
		$this->m_50->AdvancedSearch->load();
		$this->_51->AdvancedSearch->load();
		$this->m_51->AdvancedSearch->load();
		$this->_52->AdvancedSearch->load();
		$this->m_52->AdvancedSearch->load();
		$this->_53->AdvancedSearch->load();
		$this->m_53->AdvancedSearch->load();
		$this->_54->AdvancedSearch->load();
		$this->m_54->AdvancedSearch->load();
		$this->_55->AdvancedSearch->load();
		$this->m_55->AdvancedSearch->load();
		$this->_56->AdvancedSearch->load();
		$this->m_56->AdvancedSearch->load();
		$this->_57->AdvancedSearch->load();
		$this->m_57->AdvancedSearch->load();
		$this->_58->AdvancedSearch->load();
		$this->m_58->AdvancedSearch->load();
		$this->_59->AdvancedSearch->load();
		$this->m_59->AdvancedSearch->load();
		$this->_60->AdvancedSearch->load();
		$this->m_60->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("s_omr_valuelist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>