<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class s_omr_value_view extends s_omr_value
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 's_omr_value';

	// Page object name
	public $PageObjName = "s_omr_value_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (s_omr_value)
		if (!isset($GLOBALS["s_omr_value"]) || get_class($GLOBALS["s_omr_value"]) == PROJECT_NAMESPACE . "s_omr_value") {
			$GLOBALS["s_omr_value"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["s_omr_value"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 's_omr_value');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $s_omr_value;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($s_omr_value);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "s_omr_valueview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("s_omr_valuelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->roll_no->setVisibility();
		$this->test_id->setVisibility();
		$this->total->setVisibility();
		$this->percent->setVisibility();
		$this->s_1->setVisibility();
		$this->s_2->setVisibility();
		$this->s_3->setVisibility();
		$this->s_4->setVisibility();
		$this->s_5->setVisibility();
		$this->omr_image->setVisibility();
		$this->_1->setVisibility();
		$this->m_1->setVisibility();
		$this->_2->setVisibility();
		$this->m_2->setVisibility();
		$this->_3->setVisibility();
		$this->m_3->setVisibility();
		$this->_4->setVisibility();
		$this->m_4->setVisibility();
		$this->_5->setVisibility();
		$this->m_5->setVisibility();
		$this->_6->setVisibility();
		$this->m_6->setVisibility();
		$this->_7->setVisibility();
		$this->m_7->setVisibility();
		$this->_8->setVisibility();
		$this->m_8->setVisibility();
		$this->_9->setVisibility();
		$this->m_9->setVisibility();
		$this->_10->setVisibility();
		$this->m_10->setVisibility();
		$this->_11->setVisibility();
		$this->m_11->setVisibility();
		$this->_12->setVisibility();
		$this->m_12->setVisibility();
		$this->_13->setVisibility();
		$this->m_13->setVisibility();
		$this->_14->setVisibility();
		$this->m_14->setVisibility();
		$this->_15->setVisibility();
		$this->m_15->setVisibility();
		$this->_16->setVisibility();
		$this->m_16->setVisibility();
		$this->_17->setVisibility();
		$this->m_17->setVisibility();
		$this->_18->setVisibility();
		$this->m_18->setVisibility();
		$this->_19->setVisibility();
		$this->m_19->setVisibility();
		$this->_20->setVisibility();
		$this->m_20->setVisibility();
		$this->_21->setVisibility();
		$this->m_21->setVisibility();
		$this->_22->setVisibility();
		$this->m_22->setVisibility();
		$this->_23->setVisibility();
		$this->m_23->setVisibility();
		$this->_24->setVisibility();
		$this->m_24->setVisibility();
		$this->_25->setVisibility();
		$this->m_25->setVisibility();
		$this->_26->setVisibility();
		$this->m_26->setVisibility();
		$this->_27->setVisibility();
		$this->m_27->setVisibility();
		$this->_28->setVisibility();
		$this->m_28->setVisibility();
		$this->_29->setVisibility();
		$this->m_29->setVisibility();
		$this->_30->setVisibility();
		$this->m_30->setVisibility();
		$this->_31->setVisibility();
		$this->m_31->setVisibility();
		$this->_32->setVisibility();
		$this->m_32->setVisibility();
		$this->_33->setVisibility();
		$this->m_33->setVisibility();
		$this->_34->setVisibility();
		$this->m_34->setVisibility();
		$this->_35->setVisibility();
		$this->m_35->setVisibility();
		$this->_36->setVisibility();
		$this->m_36->setVisibility();
		$this->_37->setVisibility();
		$this->m_37->setVisibility();
		$this->_38->setVisibility();
		$this->m_38->setVisibility();
		$this->_39->setVisibility();
		$this->m_39->setVisibility();
		$this->_40->setVisibility();
		$this->m_40->setVisibility();
		$this->_41->setVisibility();
		$this->m_41->setVisibility();
		$this->_42->setVisibility();
		$this->m_42->setVisibility();
		$this->_43->setVisibility();
		$this->m_43->setVisibility();
		$this->_44->setVisibility();
		$this->m_44->setVisibility();
		$this->_45->setVisibility();
		$this->m_45->setVisibility();
		$this->_46->setVisibility();
		$this->m_46->setVisibility();
		$this->_47->setVisibility();
		$this->m_47->setVisibility();
		$this->_48->setVisibility();
		$this->m_48->setVisibility();
		$this->_49->setVisibility();
		$this->m_49->setVisibility();
		$this->_50->setVisibility();
		$this->m_50->setVisibility();
		$this->_51->setVisibility();
		$this->m_51->setVisibility();
		$this->_52->setVisibility();
		$this->m_52->setVisibility();
		$this->_53->setVisibility();
		$this->m_53->setVisibility();
		$this->_54->setVisibility();
		$this->m_54->setVisibility();
		$this->_55->setVisibility();
		$this->m_55->setVisibility();
		$this->_56->setVisibility();
		$this->m_56->setVisibility();
		$this->_57->setVisibility();
		$this->m_57->setVisibility();
		$this->_58->setVisibility();
		$this->m_58->setVisibility();
		$this->_59->setVisibility();
		$this->m_59->setVisibility();
		$this->_60->setVisibility();
		$this->m_60->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		// Check modal

		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "s_omr_valuelist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "s_omr_valuelist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "s_omr_valuelist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("ViewPageAddLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->AddUrl) . "'});\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("ViewPageAddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->canEdit());

		// Copy
		$item = &$option->add("copy");
		$copycaption = HtmlTitle($Language->phrase("ViewPageCopyLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,btn:'AddBtn',url:'" . HtmlEncode($this->CopyUrl) . "'});\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("ViewPageCopyLink") . "</a>";
		$item->Visible = ($this->CopyUrl <> "" && $Security->canAdd());

		// Delete
		$item = &$option->add("delete");
		if ($this->IsModal) // Handle as inline delete
			$item->Body = "<a onclick=\"return ew.confirmDelete(this);\" class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode(UrlAddQuery($this->DeleteUrl, "action=1")) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-delete\" title=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("ViewPageDeleteLink")) . "\" href=\"" . HtmlEncode($this->DeleteUrl) . "\">" . $Language->phrase("ViewPageDeleteLink") . "</a>";
		$item->Visible = ($this->DeleteUrl <> "" && $Security->canDelete());

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->roll_no->setDbValue($row['roll_no']);
		$this->test_id->setDbValue($row['test_id']);
		$this->total->setDbValue($row['total']);
		$this->percent->setDbValue($row['percent']);
		$this->s_1->setDbValue($row['s_1']);
		$this->s_2->setDbValue($row['s_2']);
		$this->s_3->setDbValue($row['s_3']);
		$this->s_4->setDbValue($row['s_4']);
		$this->s_5->setDbValue($row['s_5']);
		$this->omr_image->Upload->DbValue = $row['omr_image'];
		$this->omr_image->setDbValue($this->omr_image->Upload->DbValue);
		$this->_1->setDbValue($row['1']);
		$this->m_1->setDbValue($row['m_1']);
		$this->_2->setDbValue($row['2']);
		$this->m_2->setDbValue($row['m_2']);
		$this->_3->setDbValue($row['3']);
		$this->m_3->setDbValue($row['m_3']);
		$this->_4->setDbValue($row['4']);
		$this->m_4->setDbValue($row['m_4']);
		$this->_5->setDbValue($row['5']);
		$this->m_5->setDbValue($row['m_5']);
		$this->_6->setDbValue($row['6']);
		$this->m_6->setDbValue($row['m_6']);
		$this->_7->setDbValue($row['7']);
		$this->m_7->setDbValue($row['m_7']);
		$this->_8->setDbValue($row['8']);
		$this->m_8->setDbValue($row['m_8']);
		$this->_9->setDbValue($row['9']);
		$this->m_9->setDbValue($row['m_9']);
		$this->_10->setDbValue($row['10']);
		$this->m_10->setDbValue($row['m_10']);
		$this->_11->setDbValue($row['11']);
		$this->m_11->setDbValue($row['m_11']);
		$this->_12->setDbValue($row['12']);
		$this->m_12->setDbValue($row['m_12']);
		$this->_13->setDbValue($row['13']);
		$this->m_13->setDbValue($row['m_13']);
		$this->_14->setDbValue($row['14']);
		$this->m_14->setDbValue($row['m_14']);
		$this->_15->setDbValue($row['15']);
		$this->m_15->setDbValue($row['m_15']);
		$this->_16->setDbValue($row['16']);
		$this->m_16->setDbValue($row['m_16']);
		$this->_17->setDbValue($row['17']);
		$this->m_17->setDbValue($row['m_17']);
		$this->_18->setDbValue($row['18']);
		$this->m_18->setDbValue($row['m_18']);
		$this->_19->setDbValue($row['19']);
		$this->m_19->setDbValue($row['m_19']);
		$this->_20->setDbValue($row['20']);
		$this->m_20->setDbValue($row['m_20']);
		$this->_21->setDbValue($row['21']);
		$this->m_21->setDbValue($row['m_21']);
		$this->_22->setDbValue($row['22']);
		$this->m_22->setDbValue($row['m_22']);
		$this->_23->setDbValue($row['23']);
		$this->m_23->setDbValue($row['m_23']);
		$this->_24->setDbValue($row['24']);
		$this->m_24->setDbValue($row['m_24']);
		$this->_25->setDbValue($row['25']);
		$this->m_25->setDbValue($row['m_25']);
		$this->_26->setDbValue($row['26']);
		$this->m_26->setDbValue($row['m_26']);
		$this->_27->setDbValue($row['27']);
		$this->m_27->setDbValue($row['m_27']);
		$this->_28->setDbValue($row['28']);
		$this->m_28->setDbValue($row['m_28']);
		$this->_29->setDbValue($row['29']);
		$this->m_29->setDbValue($row['m_29']);
		$this->_30->setDbValue($row['30']);
		$this->m_30->setDbValue($row['m_30']);
		$this->_31->setDbValue($row['31']);
		$this->m_31->setDbValue($row['m_31']);
		$this->_32->setDbValue($row['32']);
		$this->m_32->setDbValue($row['m_32']);
		$this->_33->setDbValue($row['33']);
		$this->m_33->setDbValue($row['m_33']);
		$this->_34->setDbValue($row['34']);
		$this->m_34->setDbValue($row['m_34']);
		$this->_35->setDbValue($row['35']);
		$this->m_35->setDbValue($row['m_35']);
		$this->_36->setDbValue($row['36']);
		$this->m_36->setDbValue($row['m_36']);
		$this->_37->setDbValue($row['37']);
		$this->m_37->setDbValue($row['m_37']);
		$this->_38->setDbValue($row['38']);
		$this->m_38->setDbValue($row['m_38']);
		$this->_39->setDbValue($row['39']);
		$this->m_39->setDbValue($row['m_39']);
		$this->_40->setDbValue($row['40']);
		$this->m_40->setDbValue($row['m_40']);
		$this->_41->setDbValue($row['41']);
		$this->m_41->setDbValue($row['m_41']);
		$this->_42->setDbValue($row['42']);
		$this->m_42->setDbValue($row['m_42']);
		$this->_43->setDbValue($row['43']);
		$this->m_43->setDbValue($row['m_43']);
		$this->_44->setDbValue($row['44']);
		$this->m_44->setDbValue($row['m_44']);
		$this->_45->setDbValue($row['45']);
		$this->m_45->setDbValue($row['m_45']);
		$this->_46->setDbValue($row['46']);
		$this->m_46->setDbValue($row['m_46']);
		$this->_47->setDbValue($row['47']);
		$this->m_47->setDbValue($row['m_47']);
		$this->_48->setDbValue($row['48']);
		$this->m_48->setDbValue($row['m_48']);
		$this->_49->setDbValue($row['49']);
		$this->m_49->setDbValue($row['m_49']);
		$this->_50->setDbValue($row['50']);
		$this->m_50->setDbValue($row['m_50']);
		$this->_51->setDbValue($row['51']);
		$this->m_51->setDbValue($row['m_51']);
		$this->_52->setDbValue($row['52']);
		$this->m_52->setDbValue($row['m_52']);
		$this->_53->setDbValue($row['53']);
		$this->m_53->setDbValue($row['m_53']);
		$this->_54->setDbValue($row['54']);
		$this->m_54->setDbValue($row['m_54']);
		$this->_55->setDbValue($row['55']);
		$this->m_55->setDbValue($row['m_55']);
		$this->_56->setDbValue($row['56']);
		$this->m_56->setDbValue($row['m_56']);
		$this->_57->setDbValue($row['57']);
		$this->m_57->setDbValue($row['m_57']);
		$this->_58->setDbValue($row['58']);
		$this->m_58->setDbValue($row['m_58']);
		$this->_59->setDbValue($row['59']);
		$this->m_59->setDbValue($row['m_59']);
		$this->_60->setDbValue($row['60']);
		$this->m_60->setDbValue($row['m_60']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['roll_no'] = NULL;
		$row['test_id'] = NULL;
		$row['total'] = NULL;
		$row['percent'] = NULL;
		$row['s_1'] = NULL;
		$row['s_2'] = NULL;
		$row['s_3'] = NULL;
		$row['s_4'] = NULL;
		$row['s_5'] = NULL;
		$row['omr_image'] = NULL;
		$row['1'] = NULL;
		$row['m_1'] = NULL;
		$row['2'] = NULL;
		$row['m_2'] = NULL;
		$row['3'] = NULL;
		$row['m_3'] = NULL;
		$row['4'] = NULL;
		$row['m_4'] = NULL;
		$row['5'] = NULL;
		$row['m_5'] = NULL;
		$row['6'] = NULL;
		$row['m_6'] = NULL;
		$row['7'] = NULL;
		$row['m_7'] = NULL;
		$row['8'] = NULL;
		$row['m_8'] = NULL;
		$row['9'] = NULL;
		$row['m_9'] = NULL;
		$row['10'] = NULL;
		$row['m_10'] = NULL;
		$row['11'] = NULL;
		$row['m_11'] = NULL;
		$row['12'] = NULL;
		$row['m_12'] = NULL;
		$row['13'] = NULL;
		$row['m_13'] = NULL;
		$row['14'] = NULL;
		$row['m_14'] = NULL;
		$row['15'] = NULL;
		$row['m_15'] = NULL;
		$row['16'] = NULL;
		$row['m_16'] = NULL;
		$row['17'] = NULL;
		$row['m_17'] = NULL;
		$row['18'] = NULL;
		$row['m_18'] = NULL;
		$row['19'] = NULL;
		$row['m_19'] = NULL;
		$row['20'] = NULL;
		$row['m_20'] = NULL;
		$row['21'] = NULL;
		$row['m_21'] = NULL;
		$row['22'] = NULL;
		$row['m_22'] = NULL;
		$row['23'] = NULL;
		$row['m_23'] = NULL;
		$row['24'] = NULL;
		$row['m_24'] = NULL;
		$row['25'] = NULL;
		$row['m_25'] = NULL;
		$row['26'] = NULL;
		$row['m_26'] = NULL;
		$row['27'] = NULL;
		$row['m_27'] = NULL;
		$row['28'] = NULL;
		$row['m_28'] = NULL;
		$row['29'] = NULL;
		$row['m_29'] = NULL;
		$row['30'] = NULL;
		$row['m_30'] = NULL;
		$row['31'] = NULL;
		$row['m_31'] = NULL;
		$row['32'] = NULL;
		$row['m_32'] = NULL;
		$row['33'] = NULL;
		$row['m_33'] = NULL;
		$row['34'] = NULL;
		$row['m_34'] = NULL;
		$row['35'] = NULL;
		$row['m_35'] = NULL;
		$row['36'] = NULL;
		$row['m_36'] = NULL;
		$row['37'] = NULL;
		$row['m_37'] = NULL;
		$row['38'] = NULL;
		$row['m_38'] = NULL;
		$row['39'] = NULL;
		$row['m_39'] = NULL;
		$row['40'] = NULL;
		$row['m_40'] = NULL;
		$row['41'] = NULL;
		$row['m_41'] = NULL;
		$row['42'] = NULL;
		$row['m_42'] = NULL;
		$row['43'] = NULL;
		$row['m_43'] = NULL;
		$row['44'] = NULL;
		$row['m_44'] = NULL;
		$row['45'] = NULL;
		$row['m_45'] = NULL;
		$row['46'] = NULL;
		$row['m_46'] = NULL;
		$row['47'] = NULL;
		$row['m_47'] = NULL;
		$row['48'] = NULL;
		$row['m_48'] = NULL;
		$row['49'] = NULL;
		$row['m_49'] = NULL;
		$row['50'] = NULL;
		$row['m_50'] = NULL;
		$row['51'] = NULL;
		$row['m_51'] = NULL;
		$row['52'] = NULL;
		$row['m_52'] = NULL;
		$row['53'] = NULL;
		$row['m_53'] = NULL;
		$row['54'] = NULL;
		$row['m_54'] = NULL;
		$row['55'] = NULL;
		$row['m_55'] = NULL;
		$row['56'] = NULL;
		$row['m_56'] = NULL;
		$row['57'] = NULL;
		$row['m_57'] = NULL;
		$row['58'] = NULL;
		$row['m_58'] = NULL;
		$row['59'] = NULL;
		$row['m_59'] = NULL;
		$row['60'] = NULL;
		$row['m_60'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Convert decimal values if posted back
		if ($this->total->FormValue == $this->total->CurrentValue && is_numeric(ConvertToFloatString($this->total->CurrentValue)))
			$this->total->CurrentValue = ConvertToFloatString($this->total->CurrentValue);

		// Convert decimal values if posted back
		if ($this->percent->FormValue == $this->percent->CurrentValue && is_numeric(ConvertToFloatString($this->percent->CurrentValue)))
			$this->percent->CurrentValue = ConvertToFloatString($this->percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_1->FormValue == $this->s_1->CurrentValue && is_numeric(ConvertToFloatString($this->s_1->CurrentValue)))
			$this->s_1->CurrentValue = ConvertToFloatString($this->s_1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_2->FormValue == $this->s_2->CurrentValue && is_numeric(ConvertToFloatString($this->s_2->CurrentValue)))
			$this->s_2->CurrentValue = ConvertToFloatString($this->s_2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_3->FormValue == $this->s_3->CurrentValue && is_numeric(ConvertToFloatString($this->s_3->CurrentValue)))
			$this->s_3->CurrentValue = ConvertToFloatString($this->s_3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_4->FormValue == $this->s_4->CurrentValue && is_numeric(ConvertToFloatString($this->s_4->CurrentValue)))
			$this->s_4->CurrentValue = ConvertToFloatString($this->s_4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->s_5->FormValue == $this->s_5->CurrentValue && is_numeric(ConvertToFloatString($this->s_5->CurrentValue)))
			$this->s_5->CurrentValue = ConvertToFloatString($this->s_5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_1->FormValue == $this->m_1->CurrentValue && is_numeric(ConvertToFloatString($this->m_1->CurrentValue)))
			$this->m_1->CurrentValue = ConvertToFloatString($this->m_1->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_2->FormValue == $this->m_2->CurrentValue && is_numeric(ConvertToFloatString($this->m_2->CurrentValue)))
			$this->m_2->CurrentValue = ConvertToFloatString($this->m_2->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_3->FormValue == $this->m_3->CurrentValue && is_numeric(ConvertToFloatString($this->m_3->CurrentValue)))
			$this->m_3->CurrentValue = ConvertToFloatString($this->m_3->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_4->FormValue == $this->m_4->CurrentValue && is_numeric(ConvertToFloatString($this->m_4->CurrentValue)))
			$this->m_4->CurrentValue = ConvertToFloatString($this->m_4->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_5->FormValue == $this->m_5->CurrentValue && is_numeric(ConvertToFloatString($this->m_5->CurrentValue)))
			$this->m_5->CurrentValue = ConvertToFloatString($this->m_5->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_6->FormValue == $this->m_6->CurrentValue && is_numeric(ConvertToFloatString($this->m_6->CurrentValue)))
			$this->m_6->CurrentValue = ConvertToFloatString($this->m_6->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_7->FormValue == $this->m_7->CurrentValue && is_numeric(ConvertToFloatString($this->m_7->CurrentValue)))
			$this->m_7->CurrentValue = ConvertToFloatString($this->m_7->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_8->FormValue == $this->m_8->CurrentValue && is_numeric(ConvertToFloatString($this->m_8->CurrentValue)))
			$this->m_8->CurrentValue = ConvertToFloatString($this->m_8->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_9->FormValue == $this->m_9->CurrentValue && is_numeric(ConvertToFloatString($this->m_9->CurrentValue)))
			$this->m_9->CurrentValue = ConvertToFloatString($this->m_9->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_10->FormValue == $this->m_10->CurrentValue && is_numeric(ConvertToFloatString($this->m_10->CurrentValue)))
			$this->m_10->CurrentValue = ConvertToFloatString($this->m_10->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_11->FormValue == $this->m_11->CurrentValue && is_numeric(ConvertToFloatString($this->m_11->CurrentValue)))
			$this->m_11->CurrentValue = ConvertToFloatString($this->m_11->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_12->FormValue == $this->m_12->CurrentValue && is_numeric(ConvertToFloatString($this->m_12->CurrentValue)))
			$this->m_12->CurrentValue = ConvertToFloatString($this->m_12->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_13->FormValue == $this->m_13->CurrentValue && is_numeric(ConvertToFloatString($this->m_13->CurrentValue)))
			$this->m_13->CurrentValue = ConvertToFloatString($this->m_13->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_14->FormValue == $this->m_14->CurrentValue && is_numeric(ConvertToFloatString($this->m_14->CurrentValue)))
			$this->m_14->CurrentValue = ConvertToFloatString($this->m_14->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_15->FormValue == $this->m_15->CurrentValue && is_numeric(ConvertToFloatString($this->m_15->CurrentValue)))
			$this->m_15->CurrentValue = ConvertToFloatString($this->m_15->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_16->FormValue == $this->m_16->CurrentValue && is_numeric(ConvertToFloatString($this->m_16->CurrentValue)))
			$this->m_16->CurrentValue = ConvertToFloatString($this->m_16->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_17->FormValue == $this->m_17->CurrentValue && is_numeric(ConvertToFloatString($this->m_17->CurrentValue)))
			$this->m_17->CurrentValue = ConvertToFloatString($this->m_17->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_18->FormValue == $this->m_18->CurrentValue && is_numeric(ConvertToFloatString($this->m_18->CurrentValue)))
			$this->m_18->CurrentValue = ConvertToFloatString($this->m_18->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_19->FormValue == $this->m_19->CurrentValue && is_numeric(ConvertToFloatString($this->m_19->CurrentValue)))
			$this->m_19->CurrentValue = ConvertToFloatString($this->m_19->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_20->FormValue == $this->m_20->CurrentValue && is_numeric(ConvertToFloatString($this->m_20->CurrentValue)))
			$this->m_20->CurrentValue = ConvertToFloatString($this->m_20->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_21->FormValue == $this->m_21->CurrentValue && is_numeric(ConvertToFloatString($this->m_21->CurrentValue)))
			$this->m_21->CurrentValue = ConvertToFloatString($this->m_21->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_22->FormValue == $this->m_22->CurrentValue && is_numeric(ConvertToFloatString($this->m_22->CurrentValue)))
			$this->m_22->CurrentValue = ConvertToFloatString($this->m_22->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_23->FormValue == $this->m_23->CurrentValue && is_numeric(ConvertToFloatString($this->m_23->CurrentValue)))
			$this->m_23->CurrentValue = ConvertToFloatString($this->m_23->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_24->FormValue == $this->m_24->CurrentValue && is_numeric(ConvertToFloatString($this->m_24->CurrentValue)))
			$this->m_24->CurrentValue = ConvertToFloatString($this->m_24->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_25->FormValue == $this->m_25->CurrentValue && is_numeric(ConvertToFloatString($this->m_25->CurrentValue)))
			$this->m_25->CurrentValue = ConvertToFloatString($this->m_25->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_26->FormValue == $this->m_26->CurrentValue && is_numeric(ConvertToFloatString($this->m_26->CurrentValue)))
			$this->m_26->CurrentValue = ConvertToFloatString($this->m_26->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_27->FormValue == $this->m_27->CurrentValue && is_numeric(ConvertToFloatString($this->m_27->CurrentValue)))
			$this->m_27->CurrentValue = ConvertToFloatString($this->m_27->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_28->FormValue == $this->m_28->CurrentValue && is_numeric(ConvertToFloatString($this->m_28->CurrentValue)))
			$this->m_28->CurrentValue = ConvertToFloatString($this->m_28->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_29->FormValue == $this->m_29->CurrentValue && is_numeric(ConvertToFloatString($this->m_29->CurrentValue)))
			$this->m_29->CurrentValue = ConvertToFloatString($this->m_29->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_30->FormValue == $this->m_30->CurrentValue && is_numeric(ConvertToFloatString($this->m_30->CurrentValue)))
			$this->m_30->CurrentValue = ConvertToFloatString($this->m_30->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_31->FormValue == $this->m_31->CurrentValue && is_numeric(ConvertToFloatString($this->m_31->CurrentValue)))
			$this->m_31->CurrentValue = ConvertToFloatString($this->m_31->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_32->FormValue == $this->m_32->CurrentValue && is_numeric(ConvertToFloatString($this->m_32->CurrentValue)))
			$this->m_32->CurrentValue = ConvertToFloatString($this->m_32->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_33->FormValue == $this->m_33->CurrentValue && is_numeric(ConvertToFloatString($this->m_33->CurrentValue)))
			$this->m_33->CurrentValue = ConvertToFloatString($this->m_33->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_34->FormValue == $this->m_34->CurrentValue && is_numeric(ConvertToFloatString($this->m_34->CurrentValue)))
			$this->m_34->CurrentValue = ConvertToFloatString($this->m_34->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_35->FormValue == $this->m_35->CurrentValue && is_numeric(ConvertToFloatString($this->m_35->CurrentValue)))
			$this->m_35->CurrentValue = ConvertToFloatString($this->m_35->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_36->FormValue == $this->m_36->CurrentValue && is_numeric(ConvertToFloatString($this->m_36->CurrentValue)))
			$this->m_36->CurrentValue = ConvertToFloatString($this->m_36->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_37->FormValue == $this->m_37->CurrentValue && is_numeric(ConvertToFloatString($this->m_37->CurrentValue)))
			$this->m_37->CurrentValue = ConvertToFloatString($this->m_37->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_38->FormValue == $this->m_38->CurrentValue && is_numeric(ConvertToFloatString($this->m_38->CurrentValue)))
			$this->m_38->CurrentValue = ConvertToFloatString($this->m_38->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_39->FormValue == $this->m_39->CurrentValue && is_numeric(ConvertToFloatString($this->m_39->CurrentValue)))
			$this->m_39->CurrentValue = ConvertToFloatString($this->m_39->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_40->FormValue == $this->m_40->CurrentValue && is_numeric(ConvertToFloatString($this->m_40->CurrentValue)))
			$this->m_40->CurrentValue = ConvertToFloatString($this->m_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_41->FormValue == $this->m_41->CurrentValue && is_numeric(ConvertToFloatString($this->m_41->CurrentValue)))
			$this->m_41->CurrentValue = ConvertToFloatString($this->m_41->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_42->FormValue == $this->m_42->CurrentValue && is_numeric(ConvertToFloatString($this->m_42->CurrentValue)))
			$this->m_42->CurrentValue = ConvertToFloatString($this->m_42->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_43->FormValue == $this->m_43->CurrentValue && is_numeric(ConvertToFloatString($this->m_43->CurrentValue)))
			$this->m_43->CurrentValue = ConvertToFloatString($this->m_43->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_44->FormValue == $this->m_44->CurrentValue && is_numeric(ConvertToFloatString($this->m_44->CurrentValue)))
			$this->m_44->CurrentValue = ConvertToFloatString($this->m_44->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_45->FormValue == $this->m_45->CurrentValue && is_numeric(ConvertToFloatString($this->m_45->CurrentValue)))
			$this->m_45->CurrentValue = ConvertToFloatString($this->m_45->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_46->FormValue == $this->m_46->CurrentValue && is_numeric(ConvertToFloatString($this->m_46->CurrentValue)))
			$this->m_46->CurrentValue = ConvertToFloatString($this->m_46->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_47->FormValue == $this->m_47->CurrentValue && is_numeric(ConvertToFloatString($this->m_47->CurrentValue)))
			$this->m_47->CurrentValue = ConvertToFloatString($this->m_47->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_48->FormValue == $this->m_48->CurrentValue && is_numeric(ConvertToFloatString($this->m_48->CurrentValue)))
			$this->m_48->CurrentValue = ConvertToFloatString($this->m_48->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_49->FormValue == $this->m_49->CurrentValue && is_numeric(ConvertToFloatString($this->m_49->CurrentValue)))
			$this->m_49->CurrentValue = ConvertToFloatString($this->m_49->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_50->FormValue == $this->m_50->CurrentValue && is_numeric(ConvertToFloatString($this->m_50->CurrentValue)))
			$this->m_50->CurrentValue = ConvertToFloatString($this->m_50->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_51->FormValue == $this->m_51->CurrentValue && is_numeric(ConvertToFloatString($this->m_51->CurrentValue)))
			$this->m_51->CurrentValue = ConvertToFloatString($this->m_51->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_52->FormValue == $this->m_52->CurrentValue && is_numeric(ConvertToFloatString($this->m_52->CurrentValue)))
			$this->m_52->CurrentValue = ConvertToFloatString($this->m_52->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_53->FormValue == $this->m_53->CurrentValue && is_numeric(ConvertToFloatString($this->m_53->CurrentValue)))
			$this->m_53->CurrentValue = ConvertToFloatString($this->m_53->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_54->FormValue == $this->m_54->CurrentValue && is_numeric(ConvertToFloatString($this->m_54->CurrentValue)))
			$this->m_54->CurrentValue = ConvertToFloatString($this->m_54->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_55->FormValue == $this->m_55->CurrentValue && is_numeric(ConvertToFloatString($this->m_55->CurrentValue)))
			$this->m_55->CurrentValue = ConvertToFloatString($this->m_55->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_56->FormValue == $this->m_56->CurrentValue && is_numeric(ConvertToFloatString($this->m_56->CurrentValue)))
			$this->m_56->CurrentValue = ConvertToFloatString($this->m_56->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_57->FormValue == $this->m_57->CurrentValue && is_numeric(ConvertToFloatString($this->m_57->CurrentValue)))
			$this->m_57->CurrentValue = ConvertToFloatString($this->m_57->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_58->FormValue == $this->m_58->CurrentValue && is_numeric(ConvertToFloatString($this->m_58->CurrentValue)))
			$this->m_58->CurrentValue = ConvertToFloatString($this->m_58->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_59->FormValue == $this->m_59->CurrentValue && is_numeric(ConvertToFloatString($this->m_59->CurrentValue)))
			$this->m_59->CurrentValue = ConvertToFloatString($this->m_59->CurrentValue);

		// Convert decimal values if posted back
		if ($this->m_60->FormValue == $this->m_60->CurrentValue && is_numeric(ConvertToFloatString($this->m_60->CurrentValue)))
			$this->m_60->CurrentValue = ConvertToFloatString($this->m_60->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// roll_no
		// test_id
		// total
		// percent
		// s_1
		// s_2
		// s_3
		// s_4
		// s_5
		// omr_image
		// 1
		// m_1
		// 2
		// m_2
		// 3
		// m_3
		// 4
		// m_4
		// 5
		// m_5
		// 6
		// m_6
		// 7
		// m_7
		// 8
		// m_8
		// 9
		// m_9
		// 10
		// m_10
		// 11
		// m_11
		// 12
		// m_12
		// 13
		// m_13
		// 14
		// m_14
		// 15
		// m_15
		// 16
		// m_16
		// 17
		// m_17
		// 18
		// m_18
		// 19
		// m_19
		// 20
		// m_20
		// 21
		// m_21
		// 22
		// m_22
		// 23
		// m_23
		// 24
		// m_24
		// 25
		// m_25
		// 26
		// m_26
		// 27
		// m_27
		// 28
		// m_28
		// 29
		// m_29
		// 30
		// m_30
		// 31
		// m_31
		// 32
		// m_32
		// 33
		// m_33
		// 34
		// m_34
		// 35
		// m_35
		// 36
		// m_36
		// 37
		// m_37
		// 38
		// m_38
		// 39
		// m_39
		// 40
		// m_40
		// 41
		// m_41
		// 42
		// m_42
		// 43
		// m_43
		// 44
		// m_44
		// 45
		// m_45
		// 46
		// m_46
		// 47
		// m_47
		// 48
		// m_48
		// 49
		// m_49
		// 50
		// m_50
		// 51
		// m_51
		// 52
		// m_52
		// 53
		// m_53
		// 54
		// m_54
		// 55
		// m_55
		// 56
		// m_56
		// 57
		// m_57
		// 58
		// m_58
		// 59
		// m_59
		// 60
		// m_60

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// roll_no
			$this->roll_no->ViewValue = $this->roll_no->CurrentValue;
			$this->roll_no->ViewCustomAttributes = "";

			// test_id
			$this->test_id->ViewValue = $this->test_id->CurrentValue;
			$this->test_id->ViewCustomAttributes = "";

			// total
			$this->total->ViewValue = $this->total->CurrentValue;
			$this->total->ViewValue = FormatNumber($this->total->ViewValue, 2, -2, -2, -2);
			$this->total->ViewCustomAttributes = "";

			// percent
			$this->percent->ViewValue = $this->percent->CurrentValue;
			$this->percent->ViewValue = FormatNumber($this->percent->ViewValue, 2, -2, -2, -2);
			$this->percent->ViewCustomAttributes = "";

			// s_1
			$this->s_1->ViewValue = $this->s_1->CurrentValue;
			$this->s_1->ViewValue = FormatNumber($this->s_1->ViewValue, 2, -2, -2, -2);
			$this->s_1->ViewCustomAttributes = "";

			// s_2
			$this->s_2->ViewValue = $this->s_2->CurrentValue;
			$this->s_2->ViewValue = FormatNumber($this->s_2->ViewValue, 2, -2, -2, -2);
			$this->s_2->ViewCustomAttributes = "";

			// s_3
			$this->s_3->ViewValue = $this->s_3->CurrentValue;
			$this->s_3->ViewValue = FormatNumber($this->s_3->ViewValue, 2, -2, -2, -2);
			$this->s_3->ViewCustomAttributes = "";

			// s_4
			$this->s_4->ViewValue = $this->s_4->CurrentValue;
			$this->s_4->ViewValue = FormatNumber($this->s_4->ViewValue, 2, -2, -2, -2);
			$this->s_4->ViewCustomAttributes = "";

			// s_5
			$this->s_5->ViewValue = $this->s_5->CurrentValue;
			$this->s_5->ViewValue = FormatNumber($this->s_5->ViewValue, 2, -2, -2, -2);
			$this->s_5->ViewCustomAttributes = "";

			// omr_image
			$this->omr_image->UploadPath = '.p_uploads/school/omr/';
			if (!EmptyValue($this->omr_image->Upload->DbValue)) {
				$this->omr_image->ImageWidth = 0;
				$this->omr_image->ImageHeight = 50;
				$this->omr_image->ImageAlt = $this->omr_image->alt();
				$this->omr_image->ViewValue = $this->omr_image->Upload->DbValue;
			} else {
				$this->omr_image->ViewValue = "";
			}
			$this->omr_image->ViewCustomAttributes = "";

			// 1
			$this->_1->ViewValue = $this->_1->CurrentValue;
			$this->_1->ViewCustomAttributes = "";

			// m_1
			$this->m_1->ViewValue = $this->m_1->CurrentValue;
			$this->m_1->ViewValue = FormatNumber($this->m_1->ViewValue, 2, -2, -2, -2);
			$this->m_1->ViewCustomAttributes = "";

			// 2
			$this->_2->ViewValue = $this->_2->CurrentValue;
			$this->_2->ViewCustomAttributes = "";

			// m_2
			$this->m_2->ViewValue = $this->m_2->CurrentValue;
			$this->m_2->ViewValue = FormatNumber($this->m_2->ViewValue, 2, -2, -2, -2);
			$this->m_2->ViewCustomAttributes = "";

			// 3
			$this->_3->ViewValue = $this->_3->CurrentValue;
			$this->_3->ViewCustomAttributes = "";

			// m_3
			$this->m_3->ViewValue = $this->m_3->CurrentValue;
			$this->m_3->ViewValue = FormatNumber($this->m_3->ViewValue, 2, -2, -2, -2);
			$this->m_3->ViewCustomAttributes = "";

			// 4
			$this->_4->ViewValue = $this->_4->CurrentValue;
			$this->_4->ViewCustomAttributes = "";

			// m_4
			$this->m_4->ViewValue = $this->m_4->CurrentValue;
			$this->m_4->ViewValue = FormatNumber($this->m_4->ViewValue, 2, -2, -2, -2);
			$this->m_4->ViewCustomAttributes = "";

			// 5
			$this->_5->ViewValue = $this->_5->CurrentValue;
			$this->_5->ViewCustomAttributes = "";

			// m_5
			$this->m_5->ViewValue = $this->m_5->CurrentValue;
			$this->m_5->ViewValue = FormatNumber($this->m_5->ViewValue, 2, -2, -2, -2);
			$this->m_5->ViewCustomAttributes = "";

			// 6
			$this->_6->ViewValue = $this->_6->CurrentValue;
			$this->_6->ViewCustomAttributes = "";

			// m_6
			$this->m_6->ViewValue = $this->m_6->CurrentValue;
			$this->m_6->ViewValue = FormatNumber($this->m_6->ViewValue, 2, -2, -2, -2);
			$this->m_6->ViewCustomAttributes = "";

			// 7
			$this->_7->ViewValue = $this->_7->CurrentValue;
			$this->_7->ViewCustomAttributes = "";

			// m_7
			$this->m_7->ViewValue = $this->m_7->CurrentValue;
			$this->m_7->ViewValue = FormatNumber($this->m_7->ViewValue, 2, -2, -2, -2);
			$this->m_7->ViewCustomAttributes = "";

			// 8
			$this->_8->ViewValue = $this->_8->CurrentValue;
			$this->_8->ViewCustomAttributes = "";

			// m_8
			$this->m_8->ViewValue = $this->m_8->CurrentValue;
			$this->m_8->ViewValue = FormatNumber($this->m_8->ViewValue, 2, -2, -2, -2);
			$this->m_8->ViewCustomAttributes = "";

			// 9
			$this->_9->ViewValue = $this->_9->CurrentValue;
			$this->_9->ViewCustomAttributes = "";

			// m_9
			$this->m_9->ViewValue = $this->m_9->CurrentValue;
			$this->m_9->ViewValue = FormatNumber($this->m_9->ViewValue, 2, -2, -2, -2);
			$this->m_9->ViewCustomAttributes = "";

			// 10
			$this->_10->ViewValue = $this->_10->CurrentValue;
			$this->_10->ViewCustomAttributes = "";

			// m_10
			$this->m_10->ViewValue = $this->m_10->CurrentValue;
			$this->m_10->ViewValue = FormatNumber($this->m_10->ViewValue, 2, -2, -2, -2);
			$this->m_10->ViewCustomAttributes = "";

			// 11
			$this->_11->ViewValue = $this->_11->CurrentValue;
			$this->_11->ViewCustomAttributes = "";

			// m_11
			$this->m_11->ViewValue = $this->m_11->CurrentValue;
			$this->m_11->ViewValue = FormatNumber($this->m_11->ViewValue, 2, -2, -2, -2);
			$this->m_11->ViewCustomAttributes = "";

			// 12
			$this->_12->ViewValue = $this->_12->CurrentValue;
			$this->_12->ViewCustomAttributes = "";

			// m_12
			$this->m_12->ViewValue = $this->m_12->CurrentValue;
			$this->m_12->ViewValue = FormatNumber($this->m_12->ViewValue, 2, -2, -2, -2);
			$this->m_12->ViewCustomAttributes = "";

			// 13
			$this->_13->ViewValue = $this->_13->CurrentValue;
			$this->_13->ViewCustomAttributes = "";

			// m_13
			$this->m_13->ViewValue = $this->m_13->CurrentValue;
			$this->m_13->ViewValue = FormatNumber($this->m_13->ViewValue, 2, -2, -2, -2);
			$this->m_13->ViewCustomAttributes = "";

			// 14
			$this->_14->ViewValue = $this->_14->CurrentValue;
			$this->_14->ViewCustomAttributes = "";

			// m_14
			$this->m_14->ViewValue = $this->m_14->CurrentValue;
			$this->m_14->ViewValue = FormatNumber($this->m_14->ViewValue, 2, -2, -2, -2);
			$this->m_14->ViewCustomAttributes = "";

			// 15
			$this->_15->ViewValue = $this->_15->CurrentValue;
			$this->_15->ViewCustomAttributes = "";

			// m_15
			$this->m_15->ViewValue = $this->m_15->CurrentValue;
			$this->m_15->ViewValue = FormatNumber($this->m_15->ViewValue, 2, -2, -2, -2);
			$this->m_15->ViewCustomAttributes = "";

			// 16
			$this->_16->ViewValue = $this->_16->CurrentValue;
			$this->_16->ViewCustomAttributes = "";

			// m_16
			$this->m_16->ViewValue = $this->m_16->CurrentValue;
			$this->m_16->ViewValue = FormatNumber($this->m_16->ViewValue, 2, -2, -2, -2);
			$this->m_16->ViewCustomAttributes = "";

			// 17
			$this->_17->ViewValue = $this->_17->CurrentValue;
			$this->_17->ViewCustomAttributes = "";

			// m_17
			$this->m_17->ViewValue = $this->m_17->CurrentValue;
			$this->m_17->ViewValue = FormatNumber($this->m_17->ViewValue, 2, -2, -2, -2);
			$this->m_17->ViewCustomAttributes = "";

			// 18
			$this->_18->ViewValue = $this->_18->CurrentValue;
			$this->_18->ViewCustomAttributes = "";

			// m_18
			$this->m_18->ViewValue = $this->m_18->CurrentValue;
			$this->m_18->ViewValue = FormatNumber($this->m_18->ViewValue, 2, -2, -2, -2);
			$this->m_18->ViewCustomAttributes = "";

			// 19
			$this->_19->ViewValue = $this->_19->CurrentValue;
			$this->_19->ViewCustomAttributes = "";

			// m_19
			$this->m_19->ViewValue = $this->m_19->CurrentValue;
			$this->m_19->ViewValue = FormatNumber($this->m_19->ViewValue, 2, -2, -2, -2);
			$this->m_19->ViewCustomAttributes = "";

			// 20
			$this->_20->ViewValue = $this->_20->CurrentValue;
			$this->_20->ViewCustomAttributes = "";

			// m_20
			$this->m_20->ViewValue = $this->m_20->CurrentValue;
			$this->m_20->ViewValue = FormatNumber($this->m_20->ViewValue, 2, -2, -2, -2);
			$this->m_20->ViewCustomAttributes = "";

			// 21
			$this->_21->ViewValue = $this->_21->CurrentValue;
			$this->_21->ViewCustomAttributes = "";

			// m_21
			$this->m_21->ViewValue = $this->m_21->CurrentValue;
			$this->m_21->ViewValue = FormatNumber($this->m_21->ViewValue, 2, -2, -2, -2);
			$this->m_21->ViewCustomAttributes = "";

			// 22
			$this->_22->ViewValue = $this->_22->CurrentValue;
			$this->_22->ViewCustomAttributes = "";

			// m_22
			$this->m_22->ViewValue = $this->m_22->CurrentValue;
			$this->m_22->ViewValue = FormatNumber($this->m_22->ViewValue, 2, -2, -2, -2);
			$this->m_22->ViewCustomAttributes = "";

			// 23
			$this->_23->ViewValue = $this->_23->CurrentValue;
			$this->_23->ViewCustomAttributes = "";

			// m_23
			$this->m_23->ViewValue = $this->m_23->CurrentValue;
			$this->m_23->ViewValue = FormatNumber($this->m_23->ViewValue, 2, -2, -2, -2);
			$this->m_23->ViewCustomAttributes = "";

			// 24
			$this->_24->ViewValue = $this->_24->CurrentValue;
			$this->_24->ViewCustomAttributes = "";

			// m_24
			$this->m_24->ViewValue = $this->m_24->CurrentValue;
			$this->m_24->ViewValue = FormatNumber($this->m_24->ViewValue, 2, -2, -2, -2);
			$this->m_24->ViewCustomAttributes = "";

			// 25
			$this->_25->ViewValue = $this->_25->CurrentValue;
			$this->_25->ViewCustomAttributes = "";

			// m_25
			$this->m_25->ViewValue = $this->m_25->CurrentValue;
			$this->m_25->ViewValue = FormatNumber($this->m_25->ViewValue, 2, -2, -2, -2);
			$this->m_25->ViewCustomAttributes = "";

			// 26
			$this->_26->ViewValue = $this->_26->CurrentValue;
			$this->_26->ViewCustomAttributes = "";

			// m_26
			$this->m_26->ViewValue = $this->m_26->CurrentValue;
			$this->m_26->ViewValue = FormatNumber($this->m_26->ViewValue, 2, -2, -2, -2);
			$this->m_26->ViewCustomAttributes = "";

			// 27
			$this->_27->ViewValue = $this->_27->CurrentValue;
			$this->_27->ViewCustomAttributes = "";

			// m_27
			$this->m_27->ViewValue = $this->m_27->CurrentValue;
			$this->m_27->ViewValue = FormatNumber($this->m_27->ViewValue, 2, -2, -2, -2);
			$this->m_27->ViewCustomAttributes = "";

			// 28
			$this->_28->ViewValue = $this->_28->CurrentValue;
			$this->_28->ViewCustomAttributes = "";

			// m_28
			$this->m_28->ViewValue = $this->m_28->CurrentValue;
			$this->m_28->ViewValue = FormatNumber($this->m_28->ViewValue, 2, -2, -2, -2);
			$this->m_28->ViewCustomAttributes = "";

			// 29
			$this->_29->ViewValue = $this->_29->CurrentValue;
			$this->_29->ViewCustomAttributes = "";

			// m_29
			$this->m_29->ViewValue = $this->m_29->CurrentValue;
			$this->m_29->ViewValue = FormatNumber($this->m_29->ViewValue, 2, -2, -2, -2);
			$this->m_29->ViewCustomAttributes = "";

			// 30
			$this->_30->ViewValue = $this->_30->CurrentValue;
			$this->_30->ViewCustomAttributes = "";

			// m_30
			$this->m_30->ViewValue = $this->m_30->CurrentValue;
			$this->m_30->ViewValue = FormatNumber($this->m_30->ViewValue, 2, -2, -2, -2);
			$this->m_30->ViewCustomAttributes = "";

			// 31
			$this->_31->ViewValue = $this->_31->CurrentValue;
			$this->_31->ViewCustomAttributes = "";

			// m_31
			$this->m_31->ViewValue = $this->m_31->CurrentValue;
			$this->m_31->ViewValue = FormatNumber($this->m_31->ViewValue, 2, -2, -2, -2);
			$this->m_31->ViewCustomAttributes = "";

			// 32
			$this->_32->ViewValue = $this->_32->CurrentValue;
			$this->_32->ViewCustomAttributes = "";

			// m_32
			$this->m_32->ViewValue = $this->m_32->CurrentValue;
			$this->m_32->ViewValue = FormatNumber($this->m_32->ViewValue, 2, -2, -2, -2);
			$this->m_32->ViewCustomAttributes = "";

			// 33
			$this->_33->ViewValue = $this->_33->CurrentValue;
			$this->_33->ViewCustomAttributes = "";

			// m_33
			$this->m_33->ViewValue = $this->m_33->CurrentValue;
			$this->m_33->ViewValue = FormatNumber($this->m_33->ViewValue, 2, -2, -2, -2);
			$this->m_33->ViewCustomAttributes = "";

			// 34
			$this->_34->ViewValue = $this->_34->CurrentValue;
			$this->_34->ViewCustomAttributes = "";

			// m_34
			$this->m_34->ViewValue = $this->m_34->CurrentValue;
			$this->m_34->ViewValue = FormatNumber($this->m_34->ViewValue, 2, -2, -2, -2);
			$this->m_34->ViewCustomAttributes = "";

			// 35
			$this->_35->ViewValue = $this->_35->CurrentValue;
			$this->_35->ViewCustomAttributes = "";

			// m_35
			$this->m_35->ViewValue = $this->m_35->CurrentValue;
			$this->m_35->ViewValue = FormatNumber($this->m_35->ViewValue, 2, -2, -2, -2);
			$this->m_35->ViewCustomAttributes = "";

			// 36
			$this->_36->ViewValue = $this->_36->CurrentValue;
			$this->_36->ViewCustomAttributes = "";

			// m_36
			$this->m_36->ViewValue = $this->m_36->CurrentValue;
			$this->m_36->ViewValue = FormatNumber($this->m_36->ViewValue, 2, -2, -2, -2);
			$this->m_36->ViewCustomAttributes = "";

			// 37
			$this->_37->ViewValue = $this->_37->CurrentValue;
			$this->_37->ViewCustomAttributes = "";

			// m_37
			$this->m_37->ViewValue = $this->m_37->CurrentValue;
			$this->m_37->ViewValue = FormatNumber($this->m_37->ViewValue, 2, -2, -2, -2);
			$this->m_37->ViewCustomAttributes = "";

			// 38
			$this->_38->ViewValue = $this->_38->CurrentValue;
			$this->_38->ViewCustomAttributes = "";

			// m_38
			$this->m_38->ViewValue = $this->m_38->CurrentValue;
			$this->m_38->ViewValue = FormatNumber($this->m_38->ViewValue, 2, -2, -2, -2);
			$this->m_38->ViewCustomAttributes = "";

			// 39
			$this->_39->ViewValue = $this->_39->CurrentValue;
			$this->_39->ViewCustomAttributes = "";

			// m_39
			$this->m_39->ViewValue = $this->m_39->CurrentValue;
			$this->m_39->ViewValue = FormatNumber($this->m_39->ViewValue, 2, -2, -2, -2);
			$this->m_39->ViewCustomAttributes = "";

			// 40
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewCustomAttributes = "";

			// m_40
			$this->m_40->ViewValue = $this->m_40->CurrentValue;
			$this->m_40->ViewValue = FormatNumber($this->m_40->ViewValue, 2, -2, -2, -2);
			$this->m_40->ViewCustomAttributes = "";

			// 41
			$this->_41->ViewValue = $this->_41->CurrentValue;
			$this->_41->ViewCustomAttributes = "";

			// m_41
			$this->m_41->ViewValue = $this->m_41->CurrentValue;
			$this->m_41->ViewValue = FormatNumber($this->m_41->ViewValue, 2, -2, -2, -2);
			$this->m_41->ViewCustomAttributes = "";

			// 42
			$this->_42->ViewValue = $this->_42->CurrentValue;
			$this->_42->ViewCustomAttributes = "";

			// m_42
			$this->m_42->ViewValue = $this->m_42->CurrentValue;
			$this->m_42->ViewValue = FormatNumber($this->m_42->ViewValue, 2, -2, -2, -2);
			$this->m_42->ViewCustomAttributes = "";

			// 43
			$this->_43->ViewValue = $this->_43->CurrentValue;
			$this->_43->ViewCustomAttributes = "";

			// m_43
			$this->m_43->ViewValue = $this->m_43->CurrentValue;
			$this->m_43->ViewValue = FormatNumber($this->m_43->ViewValue, 2, -2, -2, -2);
			$this->m_43->ViewCustomAttributes = "";

			// 44
			$this->_44->ViewValue = $this->_44->CurrentValue;
			$this->_44->ViewCustomAttributes = "";

			// m_44
			$this->m_44->ViewValue = $this->m_44->CurrentValue;
			$this->m_44->ViewValue = FormatNumber($this->m_44->ViewValue, 2, -2, -2, -2);
			$this->m_44->ViewCustomAttributes = "";

			// 45
			$this->_45->ViewValue = $this->_45->CurrentValue;
			$this->_45->ViewCustomAttributes = "";

			// m_45
			$this->m_45->ViewValue = $this->m_45->CurrentValue;
			$this->m_45->ViewValue = FormatNumber($this->m_45->ViewValue, 2, -2, -2, -2);
			$this->m_45->ViewCustomAttributes = "";

			// 46
			$this->_46->ViewValue = $this->_46->CurrentValue;
			$this->_46->ViewCustomAttributes = "";

			// m_46
			$this->m_46->ViewValue = $this->m_46->CurrentValue;
			$this->m_46->ViewValue = FormatNumber($this->m_46->ViewValue, 2, -2, -2, -2);
			$this->m_46->ViewCustomAttributes = "";

			// 47
			$this->_47->ViewValue = $this->_47->CurrentValue;
			$this->_47->ViewCustomAttributes = "";

			// m_47
			$this->m_47->ViewValue = $this->m_47->CurrentValue;
			$this->m_47->ViewValue = FormatNumber($this->m_47->ViewValue, 2, -2, -2, -2);
			$this->m_47->ViewCustomAttributes = "";

			// 48
			$this->_48->ViewValue = $this->_48->CurrentValue;
			$this->_48->ViewCustomAttributes = "";

			// m_48
			$this->m_48->ViewValue = $this->m_48->CurrentValue;
			$this->m_48->ViewValue = FormatNumber($this->m_48->ViewValue, 2, -2, -2, -2);
			$this->m_48->ViewCustomAttributes = "";

			// 49
			$this->_49->ViewValue = $this->_49->CurrentValue;
			$this->_49->ViewCustomAttributes = "";

			// m_49
			$this->m_49->ViewValue = $this->m_49->CurrentValue;
			$this->m_49->ViewValue = FormatNumber($this->m_49->ViewValue, 2, -2, -2, -2);
			$this->m_49->ViewCustomAttributes = "";

			// 50
			$this->_50->ViewValue = $this->_50->CurrentValue;
			$this->_50->ViewCustomAttributes = "";

			// m_50
			$this->m_50->ViewValue = $this->m_50->CurrentValue;
			$this->m_50->ViewValue = FormatNumber($this->m_50->ViewValue, 2, -2, -2, -2);
			$this->m_50->ViewCustomAttributes = "";

			// 51
			$this->_51->ViewValue = $this->_51->CurrentValue;
			$this->_51->ViewCustomAttributes = "";

			// m_51
			$this->m_51->ViewValue = $this->m_51->CurrentValue;
			$this->m_51->ViewValue = FormatNumber($this->m_51->ViewValue, 2, -2, -2, -2);
			$this->m_51->ViewCustomAttributes = "";

			// 52
			$this->_52->ViewValue = $this->_52->CurrentValue;
			$this->_52->ViewCustomAttributes = "";

			// m_52
			$this->m_52->ViewValue = $this->m_52->CurrentValue;
			$this->m_52->ViewValue = FormatNumber($this->m_52->ViewValue, 2, -2, -2, -2);
			$this->m_52->ViewCustomAttributes = "";

			// 53
			$this->_53->ViewValue = $this->_53->CurrentValue;
			$this->_53->ViewCustomAttributes = "";

			// m_53
			$this->m_53->ViewValue = $this->m_53->CurrentValue;
			$this->m_53->ViewValue = FormatNumber($this->m_53->ViewValue, 2, -2, -2, -2);
			$this->m_53->ViewCustomAttributes = "";

			// 54
			$this->_54->ViewValue = $this->_54->CurrentValue;
			$this->_54->ViewCustomAttributes = "";

			// m_54
			$this->m_54->ViewValue = $this->m_54->CurrentValue;
			$this->m_54->ViewValue = FormatNumber($this->m_54->ViewValue, 2, -2, -2, -2);
			$this->m_54->ViewCustomAttributes = "";

			// 55
			$this->_55->ViewValue = $this->_55->CurrentValue;
			$this->_55->ViewCustomAttributes = "";

			// m_55
			$this->m_55->ViewValue = $this->m_55->CurrentValue;
			$this->m_55->ViewValue = FormatNumber($this->m_55->ViewValue, 2, -2, -2, -2);
			$this->m_55->ViewCustomAttributes = "";

			// 56
			$this->_56->ViewValue = $this->_56->CurrentValue;
			$this->_56->ViewCustomAttributes = "";

			// m_56
			$this->m_56->ViewValue = $this->m_56->CurrentValue;
			$this->m_56->ViewValue = FormatNumber($this->m_56->ViewValue, 2, -2, -2, -2);
			$this->m_56->ViewCustomAttributes = "";

			// 57
			$this->_57->ViewValue = $this->_57->CurrentValue;
			$this->_57->ViewCustomAttributes = "";

			// m_57
			$this->m_57->ViewValue = $this->m_57->CurrentValue;
			$this->m_57->ViewValue = FormatNumber($this->m_57->ViewValue, 2, -2, -2, -2);
			$this->m_57->ViewCustomAttributes = "";

			// 58
			$this->_58->ViewValue = $this->_58->CurrentValue;
			$this->_58->ViewCustomAttributes = "";

			// m_58
			$this->m_58->ViewValue = $this->m_58->CurrentValue;
			$this->m_58->ViewValue = FormatNumber($this->m_58->ViewValue, 2, -2, -2, -2);
			$this->m_58->ViewCustomAttributes = "";

			// 59
			$this->_59->ViewValue = $this->_59->CurrentValue;
			$this->_59->ViewCustomAttributes = "";

			// m_59
			$this->m_59->ViewValue = $this->m_59->CurrentValue;
			$this->m_59->ViewValue = FormatNumber($this->m_59->ViewValue, 2, -2, -2, -2);
			$this->m_59->ViewCustomAttributes = "";

			// 60
			$this->_60->ViewValue = $this->_60->CurrentValue;
			$this->_60->ViewCustomAttributes = "";

			// m_60
			$this->m_60->ViewValue = $this->m_60->CurrentValue;
			$this->m_60->ViewValue = FormatNumber($this->m_60->ViewValue, 2, -2, -2, -2);
			$this->m_60->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// roll_no
			$this->roll_no->LinkCustomAttributes = "";
			$this->roll_no->HrefValue = "";
			$this->roll_no->TooltipValue = "";

			// test_id
			$this->test_id->LinkCustomAttributes = "";
			$this->test_id->HrefValue = "";
			$this->test_id->TooltipValue = "";

			// total
			$this->total->LinkCustomAttributes = "";
			$this->total->HrefValue = "";
			$this->total->TooltipValue = "";

			// percent
			$this->percent->LinkCustomAttributes = "";
			$this->percent->HrefValue = "";
			$this->percent->TooltipValue = "";

			// s_1
			$this->s_1->LinkCustomAttributes = "";
			$this->s_1->HrefValue = "";
			$this->s_1->TooltipValue = "";

			// s_2
			$this->s_2->LinkCustomAttributes = "";
			$this->s_2->HrefValue = "";
			$this->s_2->TooltipValue = "";

			// s_3
			$this->s_3->LinkCustomAttributes = "";
			$this->s_3->HrefValue = "";
			$this->s_3->TooltipValue = "";

			// s_4
			$this->s_4->LinkCustomAttributes = "";
			$this->s_4->HrefValue = "";
			$this->s_4->TooltipValue = "";

			// s_5
			$this->s_5->LinkCustomAttributes = "";
			$this->s_5->HrefValue = "";
			$this->s_5->TooltipValue = "";

			// omr_image
			$this->omr_image->LinkCustomAttributes = "";
			$this->omr_image->UploadPath = '.p_uploads/school/omr/';
			if (!EmptyValue($this->omr_image->Upload->DbValue)) {
				$this->omr_image->HrefValue = GetFileUploadUrl($this->omr_image, $this->omr_image->Upload->DbValue); // Add prefix/suffix
				$this->omr_image->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->omr_image->HrefValue = FullUrl($this->omr_image->HrefValue, "href");
			} else {
				$this->omr_image->HrefValue = "";
			}
			$this->omr_image->ExportHrefValue = $this->omr_image->UploadPath . $this->omr_image->Upload->DbValue;
			$this->omr_image->TooltipValue = "";
			if ($this->omr_image->UseColorbox) {
				if (EmptyValue($this->omr_image->TooltipValue))
					$this->omr_image->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->omr_image->LinkAttrs["data-rel"] = "s_omr_value_x_omr_image";
				AppendClass($this->omr_image->LinkAttrs["class"], "ew-lightbox");
			}

			// 1
			$this->_1->LinkCustomAttributes = "";
			$this->_1->HrefValue = "";
			$this->_1->TooltipValue = "";

			// m_1
			$this->m_1->LinkCustomAttributes = "";
			$this->m_1->HrefValue = "";
			$this->m_1->TooltipValue = "";

			// 2
			$this->_2->LinkCustomAttributes = "";
			$this->_2->HrefValue = "";
			$this->_2->TooltipValue = "";

			// m_2
			$this->m_2->LinkCustomAttributes = "";
			$this->m_2->HrefValue = "";
			$this->m_2->TooltipValue = "";

			// 3
			$this->_3->LinkCustomAttributes = "";
			$this->_3->HrefValue = "";
			$this->_3->TooltipValue = "";

			// m_3
			$this->m_3->LinkCustomAttributes = "";
			$this->m_3->HrefValue = "";
			$this->m_3->TooltipValue = "";

			// 4
			$this->_4->LinkCustomAttributes = "";
			$this->_4->HrefValue = "";
			$this->_4->TooltipValue = "";

			// m_4
			$this->m_4->LinkCustomAttributes = "";
			$this->m_4->HrefValue = "";
			$this->m_4->TooltipValue = "";

			// 5
			$this->_5->LinkCustomAttributes = "";
			$this->_5->HrefValue = "";
			$this->_5->TooltipValue = "";

			// m_5
			$this->m_5->LinkCustomAttributes = "";
			$this->m_5->HrefValue = "";
			$this->m_5->TooltipValue = "";

			// 6
			$this->_6->LinkCustomAttributes = "";
			$this->_6->HrefValue = "";
			$this->_6->TooltipValue = "";

			// m_6
			$this->m_6->LinkCustomAttributes = "";
			$this->m_6->HrefValue = "";
			$this->m_6->TooltipValue = "";

			// 7
			$this->_7->LinkCustomAttributes = "";
			$this->_7->HrefValue = "";
			$this->_7->TooltipValue = "";

			// m_7
			$this->m_7->LinkCustomAttributes = "";
			$this->m_7->HrefValue = "";
			$this->m_7->TooltipValue = "";

			// 8
			$this->_8->LinkCustomAttributes = "";
			$this->_8->HrefValue = "";
			$this->_8->TooltipValue = "";

			// m_8
			$this->m_8->LinkCustomAttributes = "";
			$this->m_8->HrefValue = "";
			$this->m_8->TooltipValue = "";

			// 9
			$this->_9->LinkCustomAttributes = "";
			$this->_9->HrefValue = "";
			$this->_9->TooltipValue = "";

			// m_9
			$this->m_9->LinkCustomAttributes = "";
			$this->m_9->HrefValue = "";
			$this->m_9->TooltipValue = "";

			// 10
			$this->_10->LinkCustomAttributes = "";
			$this->_10->HrefValue = "";
			$this->_10->TooltipValue = "";

			// m_10
			$this->m_10->LinkCustomAttributes = "";
			$this->m_10->HrefValue = "";
			$this->m_10->TooltipValue = "";

			// 11
			$this->_11->LinkCustomAttributes = "";
			$this->_11->HrefValue = "";
			$this->_11->TooltipValue = "";

			// m_11
			$this->m_11->LinkCustomAttributes = "";
			$this->m_11->HrefValue = "";
			$this->m_11->TooltipValue = "";

			// 12
			$this->_12->LinkCustomAttributes = "";
			$this->_12->HrefValue = "";
			$this->_12->TooltipValue = "";

			// m_12
			$this->m_12->LinkCustomAttributes = "";
			$this->m_12->HrefValue = "";
			$this->m_12->TooltipValue = "";

			// 13
			$this->_13->LinkCustomAttributes = "";
			$this->_13->HrefValue = "";
			$this->_13->TooltipValue = "";

			// m_13
			$this->m_13->LinkCustomAttributes = "";
			$this->m_13->HrefValue = "";
			$this->m_13->TooltipValue = "";

			// 14
			$this->_14->LinkCustomAttributes = "";
			$this->_14->HrefValue = "";
			$this->_14->TooltipValue = "";

			// m_14
			$this->m_14->LinkCustomAttributes = "";
			$this->m_14->HrefValue = "";
			$this->m_14->TooltipValue = "";

			// 15
			$this->_15->LinkCustomAttributes = "";
			$this->_15->HrefValue = "";
			$this->_15->TooltipValue = "";

			// m_15
			$this->m_15->LinkCustomAttributes = "";
			$this->m_15->HrefValue = "";
			$this->m_15->TooltipValue = "";

			// 16
			$this->_16->LinkCustomAttributes = "";
			$this->_16->HrefValue = "";
			$this->_16->TooltipValue = "";

			// m_16
			$this->m_16->LinkCustomAttributes = "";
			$this->m_16->HrefValue = "";
			$this->m_16->TooltipValue = "";

			// 17
			$this->_17->LinkCustomAttributes = "";
			$this->_17->HrefValue = "";
			$this->_17->TooltipValue = "";

			// m_17
			$this->m_17->LinkCustomAttributes = "";
			$this->m_17->HrefValue = "";
			$this->m_17->TooltipValue = "";

			// 18
			$this->_18->LinkCustomAttributes = "";
			$this->_18->HrefValue = "";
			$this->_18->TooltipValue = "";

			// m_18
			$this->m_18->LinkCustomAttributes = "";
			$this->m_18->HrefValue = "";
			$this->m_18->TooltipValue = "";

			// 19
			$this->_19->LinkCustomAttributes = "";
			$this->_19->HrefValue = "";
			$this->_19->TooltipValue = "";

			// m_19
			$this->m_19->LinkCustomAttributes = "";
			$this->m_19->HrefValue = "";
			$this->m_19->TooltipValue = "";

			// 20
			$this->_20->LinkCustomAttributes = "";
			$this->_20->HrefValue = "";
			$this->_20->TooltipValue = "";

			// m_20
			$this->m_20->LinkCustomAttributes = "";
			$this->m_20->HrefValue = "";
			$this->m_20->TooltipValue = "";

			// 21
			$this->_21->LinkCustomAttributes = "";
			$this->_21->HrefValue = "";
			$this->_21->TooltipValue = "";

			// m_21
			$this->m_21->LinkCustomAttributes = "";
			$this->m_21->HrefValue = "";
			$this->m_21->TooltipValue = "";

			// 22
			$this->_22->LinkCustomAttributes = "";
			$this->_22->HrefValue = "";
			$this->_22->TooltipValue = "";

			// m_22
			$this->m_22->LinkCustomAttributes = "";
			$this->m_22->HrefValue = "";
			$this->m_22->TooltipValue = "";

			// 23
			$this->_23->LinkCustomAttributes = "";
			$this->_23->HrefValue = "";
			$this->_23->TooltipValue = "";

			// m_23
			$this->m_23->LinkCustomAttributes = "";
			$this->m_23->HrefValue = "";
			$this->m_23->TooltipValue = "";

			// 24
			$this->_24->LinkCustomAttributes = "";
			$this->_24->HrefValue = "";
			$this->_24->TooltipValue = "";

			// m_24
			$this->m_24->LinkCustomAttributes = "";
			$this->m_24->HrefValue = "";
			$this->m_24->TooltipValue = "";

			// 25
			$this->_25->LinkCustomAttributes = "";
			$this->_25->HrefValue = "";
			$this->_25->TooltipValue = "";

			// m_25
			$this->m_25->LinkCustomAttributes = "";
			$this->m_25->HrefValue = "";
			$this->m_25->TooltipValue = "";

			// 26
			$this->_26->LinkCustomAttributes = "";
			$this->_26->HrefValue = "";
			$this->_26->TooltipValue = "";

			// m_26
			$this->m_26->LinkCustomAttributes = "";
			$this->m_26->HrefValue = "";
			$this->m_26->TooltipValue = "";

			// 27
			$this->_27->LinkCustomAttributes = "";
			$this->_27->HrefValue = "";
			$this->_27->TooltipValue = "";

			// m_27
			$this->m_27->LinkCustomAttributes = "";
			$this->m_27->HrefValue = "";
			$this->m_27->TooltipValue = "";

			// 28
			$this->_28->LinkCustomAttributes = "";
			$this->_28->HrefValue = "";
			$this->_28->TooltipValue = "";

			// m_28
			$this->m_28->LinkCustomAttributes = "";
			$this->m_28->HrefValue = "";
			$this->m_28->TooltipValue = "";

			// 29
			$this->_29->LinkCustomAttributes = "";
			$this->_29->HrefValue = "";
			$this->_29->TooltipValue = "";

			// m_29
			$this->m_29->LinkCustomAttributes = "";
			$this->m_29->HrefValue = "";
			$this->m_29->TooltipValue = "";

			// 30
			$this->_30->LinkCustomAttributes = "";
			$this->_30->HrefValue = "";
			$this->_30->TooltipValue = "";

			// m_30
			$this->m_30->LinkCustomAttributes = "";
			$this->m_30->HrefValue = "";
			$this->m_30->TooltipValue = "";

			// 31
			$this->_31->LinkCustomAttributes = "";
			$this->_31->HrefValue = "";
			$this->_31->TooltipValue = "";

			// m_31
			$this->m_31->LinkCustomAttributes = "";
			$this->m_31->HrefValue = "";
			$this->m_31->TooltipValue = "";

			// 32
			$this->_32->LinkCustomAttributes = "";
			$this->_32->HrefValue = "";
			$this->_32->TooltipValue = "";

			// m_32
			$this->m_32->LinkCustomAttributes = "";
			$this->m_32->HrefValue = "";
			$this->m_32->TooltipValue = "";

			// 33
			$this->_33->LinkCustomAttributes = "";
			$this->_33->HrefValue = "";
			$this->_33->TooltipValue = "";

			// m_33
			$this->m_33->LinkCustomAttributes = "";
			$this->m_33->HrefValue = "";
			$this->m_33->TooltipValue = "";

			// 34
			$this->_34->LinkCustomAttributes = "";
			$this->_34->HrefValue = "";
			$this->_34->TooltipValue = "";

			// m_34
			$this->m_34->LinkCustomAttributes = "";
			$this->m_34->HrefValue = "";
			$this->m_34->TooltipValue = "";

			// 35
			$this->_35->LinkCustomAttributes = "";
			$this->_35->HrefValue = "";
			$this->_35->TooltipValue = "";

			// m_35
			$this->m_35->LinkCustomAttributes = "";
			$this->m_35->HrefValue = "";
			$this->m_35->TooltipValue = "";

			// 36
			$this->_36->LinkCustomAttributes = "";
			$this->_36->HrefValue = "";
			$this->_36->TooltipValue = "";

			// m_36
			$this->m_36->LinkCustomAttributes = "";
			$this->m_36->HrefValue = "";
			$this->m_36->TooltipValue = "";

			// 37
			$this->_37->LinkCustomAttributes = "";
			$this->_37->HrefValue = "";
			$this->_37->TooltipValue = "";

			// m_37
			$this->m_37->LinkCustomAttributes = "";
			$this->m_37->HrefValue = "";
			$this->m_37->TooltipValue = "";

			// 38
			$this->_38->LinkCustomAttributes = "";
			$this->_38->HrefValue = "";
			$this->_38->TooltipValue = "";

			// m_38
			$this->m_38->LinkCustomAttributes = "";
			$this->m_38->HrefValue = "";
			$this->m_38->TooltipValue = "";

			// 39
			$this->_39->LinkCustomAttributes = "";
			$this->_39->HrefValue = "";
			$this->_39->TooltipValue = "";

			// m_39
			$this->m_39->LinkCustomAttributes = "";
			$this->m_39->HrefValue = "";
			$this->m_39->TooltipValue = "";

			// 40
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// m_40
			$this->m_40->LinkCustomAttributes = "";
			$this->m_40->HrefValue = "";
			$this->m_40->TooltipValue = "";

			// 41
			$this->_41->LinkCustomAttributes = "";
			$this->_41->HrefValue = "";
			$this->_41->TooltipValue = "";

			// m_41
			$this->m_41->LinkCustomAttributes = "";
			$this->m_41->HrefValue = "";
			$this->m_41->TooltipValue = "";

			// 42
			$this->_42->LinkCustomAttributes = "";
			$this->_42->HrefValue = "";
			$this->_42->TooltipValue = "";

			// m_42
			$this->m_42->LinkCustomAttributes = "";
			$this->m_42->HrefValue = "";
			$this->m_42->TooltipValue = "";

			// 43
			$this->_43->LinkCustomAttributes = "";
			$this->_43->HrefValue = "";
			$this->_43->TooltipValue = "";

			// m_43
			$this->m_43->LinkCustomAttributes = "";
			$this->m_43->HrefValue = "";
			$this->m_43->TooltipValue = "";

			// 44
			$this->_44->LinkCustomAttributes = "";
			$this->_44->HrefValue = "";
			$this->_44->TooltipValue = "";

			// m_44
			$this->m_44->LinkCustomAttributes = "";
			$this->m_44->HrefValue = "";
			$this->m_44->TooltipValue = "";

			// 45
			$this->_45->LinkCustomAttributes = "";
			$this->_45->HrefValue = "";
			$this->_45->TooltipValue = "";

			// m_45
			$this->m_45->LinkCustomAttributes = "";
			$this->m_45->HrefValue = "";
			$this->m_45->TooltipValue = "";

			// 46
			$this->_46->LinkCustomAttributes = "";
			$this->_46->HrefValue = "";
			$this->_46->TooltipValue = "";

			// m_46
			$this->m_46->LinkCustomAttributes = "";
			$this->m_46->HrefValue = "";
			$this->m_46->TooltipValue = "";

			// 47
			$this->_47->LinkCustomAttributes = "";
			$this->_47->HrefValue = "";
			$this->_47->TooltipValue = "";

			// m_47
			$this->m_47->LinkCustomAttributes = "";
			$this->m_47->HrefValue = "";
			$this->m_47->TooltipValue = "";

			// 48
			$this->_48->LinkCustomAttributes = "";
			$this->_48->HrefValue = "";
			$this->_48->TooltipValue = "";

			// m_48
			$this->m_48->LinkCustomAttributes = "";
			$this->m_48->HrefValue = "";
			$this->m_48->TooltipValue = "";

			// 49
			$this->_49->LinkCustomAttributes = "";
			$this->_49->HrefValue = "";
			$this->_49->TooltipValue = "";

			// m_49
			$this->m_49->LinkCustomAttributes = "";
			$this->m_49->HrefValue = "";
			$this->m_49->TooltipValue = "";

			// 50
			$this->_50->LinkCustomAttributes = "";
			$this->_50->HrefValue = "";
			$this->_50->TooltipValue = "";

			// m_50
			$this->m_50->LinkCustomAttributes = "";
			$this->m_50->HrefValue = "";
			$this->m_50->TooltipValue = "";

			// 51
			$this->_51->LinkCustomAttributes = "";
			$this->_51->HrefValue = "";
			$this->_51->TooltipValue = "";

			// m_51
			$this->m_51->LinkCustomAttributes = "";
			$this->m_51->HrefValue = "";
			$this->m_51->TooltipValue = "";

			// 52
			$this->_52->LinkCustomAttributes = "";
			$this->_52->HrefValue = "";
			$this->_52->TooltipValue = "";

			// m_52
			$this->m_52->LinkCustomAttributes = "";
			$this->m_52->HrefValue = "";
			$this->m_52->TooltipValue = "";

			// 53
			$this->_53->LinkCustomAttributes = "";
			$this->_53->HrefValue = "";
			$this->_53->TooltipValue = "";

			// m_53
			$this->m_53->LinkCustomAttributes = "";
			$this->m_53->HrefValue = "";
			$this->m_53->TooltipValue = "";

			// 54
			$this->_54->LinkCustomAttributes = "";
			$this->_54->HrefValue = "";
			$this->_54->TooltipValue = "";

			// m_54
			$this->m_54->LinkCustomAttributes = "";
			$this->m_54->HrefValue = "";
			$this->m_54->TooltipValue = "";

			// 55
			$this->_55->LinkCustomAttributes = "";
			$this->_55->HrefValue = "";
			$this->_55->TooltipValue = "";

			// m_55
			$this->m_55->LinkCustomAttributes = "";
			$this->m_55->HrefValue = "";
			$this->m_55->TooltipValue = "";

			// 56
			$this->_56->LinkCustomAttributes = "";
			$this->_56->HrefValue = "";
			$this->_56->TooltipValue = "";

			// m_56
			$this->m_56->LinkCustomAttributes = "";
			$this->m_56->HrefValue = "";
			$this->m_56->TooltipValue = "";

			// 57
			$this->_57->LinkCustomAttributes = "";
			$this->_57->HrefValue = "";
			$this->_57->TooltipValue = "";

			// m_57
			$this->m_57->LinkCustomAttributes = "";
			$this->m_57->HrefValue = "";
			$this->m_57->TooltipValue = "";

			// 58
			$this->_58->LinkCustomAttributes = "";
			$this->_58->HrefValue = "";
			$this->_58->TooltipValue = "";

			// m_58
			$this->m_58->LinkCustomAttributes = "";
			$this->m_58->HrefValue = "";
			$this->m_58->TooltipValue = "";

			// 59
			$this->_59->LinkCustomAttributes = "";
			$this->_59->HrefValue = "";
			$this->_59->TooltipValue = "";

			// m_59
			$this->m_59->LinkCustomAttributes = "";
			$this->m_59->HrefValue = "";
			$this->m_59->TooltipValue = "";

			// 60
			$this->_60->LinkCustomAttributes = "";
			$this->_60->HrefValue = "";
			$this->_60->TooltipValue = "";

			// m_60
			$this->m_60->LinkCustomAttributes = "";
			$this->m_60->HrefValue = "";
			$this->m_60->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("s_omr_valuelist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>