<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class salary_expenses_edit extends salary_expenses
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'salary_expenses';

	// Page object name
	public $PageObjName = "salary_expenses_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (salary_expenses)
		if (!isset($GLOBALS["salary_expenses"]) || get_class($GLOBALS["salary_expenses"]) == PROJECT_NAMESPACE . "salary_expenses") {
			$GLOBALS["salary_expenses"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["salary_expenses"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'salary_expenses');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $salary_expenses;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($salary_expenses);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "salary_expensesview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("salary_expenseslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->employee_id->setVisibility();
		$this->expense_type->setVisibility();
		$this->expense_sub_type->setVisibility();
		$this->basic_salary->setVisibility();
		$this->ded_add->setVisibility();
		$this->final_amount->setVisibility();
		$this->dated->setVisibility();
		$this->remarks->setVisibility();
		$this->uploads->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->employee_id);
		$this->setupLookupOptions($this->expense_type);
		$this->setupLookupOptions($this->expense_sub_type);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("salary_expenseslist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = "salary_expenseslist.php";
				if (GetPageName($returnUrl) == "salary_expenseslist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->uploads->Upload->Index = $CurrentForm->Index;
		$this->uploads->Upload->uploadFile();
		$this->uploads->CurrentValue = $this->uploads->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'employee_id' first before field var 'x_employee_id'
		$val = $CurrentForm->hasValue("employee_id") ? $CurrentForm->getValue("employee_id") : $CurrentForm->getValue("x_employee_id");
		if (!$this->employee_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->employee_id->Visible = FALSE; // Disable update for API request
			else
				$this->employee_id->setFormValue($val);
		}

		// Check field name 'expense_type' first before field var 'x_expense_type'
		$val = $CurrentForm->hasValue("expense_type") ? $CurrentForm->getValue("expense_type") : $CurrentForm->getValue("x_expense_type");
		if (!$this->expense_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->expense_type->Visible = FALSE; // Disable update for API request
			else
				$this->expense_type->setFormValue($val);
		}

		// Check field name 'expense_sub_type' first before field var 'x_expense_sub_type'
		$val = $CurrentForm->hasValue("expense_sub_type") ? $CurrentForm->getValue("expense_sub_type") : $CurrentForm->getValue("x_expense_sub_type");
		if (!$this->expense_sub_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->expense_sub_type->Visible = FALSE; // Disable update for API request
			else
				$this->expense_sub_type->setFormValue($val);
		}

		// Check field name 'basic_salary' first before field var 'x_basic_salary'
		$val = $CurrentForm->hasValue("basic_salary") ? $CurrentForm->getValue("basic_salary") : $CurrentForm->getValue("x_basic_salary");
		if (!$this->basic_salary->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->basic_salary->Visible = FALSE; // Disable update for API request
			else
				$this->basic_salary->setFormValue($val);
		}

		// Check field name 'ded_add' first before field var 'x_ded_add'
		$val = $CurrentForm->hasValue("ded_add") ? $CurrentForm->getValue("ded_add") : $CurrentForm->getValue("x_ded_add");
		if (!$this->ded_add->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ded_add->Visible = FALSE; // Disable update for API request
			else
				$this->ded_add->setFormValue($val);
		}

		// Check field name 'final_amount' first before field var 'x_final_amount'
		$val = $CurrentForm->hasValue("final_amount") ? $CurrentForm->getValue("final_amount") : $CurrentForm->getValue("x_final_amount");
		if (!$this->final_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->final_amount->Visible = FALSE; // Disable update for API request
			else
				$this->final_amount->setFormValue($val);
		}

		// Check field name 'dated' first before field var 'x_dated'
		$val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
		if (!$this->dated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dated->Visible = FALSE; // Disable update for API request
			else
				$this->dated->setFormValue($val);
			$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->employee_id->CurrentValue = $this->employee_id->FormValue;
		$this->expense_type->CurrentValue = $this->expense_type->FormValue;
		$this->expense_sub_type->CurrentValue = $this->expense_sub_type->FormValue;
		$this->basic_salary->CurrentValue = $this->basic_salary->FormValue;
		$this->ded_add->CurrentValue = $this->ded_add->FormValue;
		$this->final_amount->CurrentValue = $this->final_amount->FormValue;
		$this->dated->CurrentValue = $this->dated->FormValue;
		$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->employee_id->setDbValue($row['employee_id']);
		$this->expense_type->setDbValue($row['expense_type']);
		$this->expense_sub_type->setDbValue($row['expense_sub_type']);
		$this->basic_salary->setDbValue($row['basic_salary']);
		$this->ded_add->setDbValue($row['ded_add']);
		$this->final_amount->setDbValue($row['final_amount']);
		$this->dated->setDbValue($row['dated']);
		$this->remarks->setDbValue($row['remarks']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['employee_id'] = NULL;
		$row['expense_type'] = NULL;
		$row['expense_sub_type'] = NULL;
		$row['basic_salary'] = NULL;
		$row['ded_add'] = NULL;
		$row['final_amount'] = NULL;
		$row['dated'] = NULL;
		$row['remarks'] = NULL;
		$row['uploads'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->basic_salary->FormValue == $this->basic_salary->CurrentValue && is_numeric(ConvertToFloatString($this->basic_salary->CurrentValue)))
			$this->basic_salary->CurrentValue = ConvertToFloatString($this->basic_salary->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ded_add->FormValue == $this->ded_add->CurrentValue && is_numeric(ConvertToFloatString($this->ded_add->CurrentValue)))
			$this->ded_add->CurrentValue = ConvertToFloatString($this->ded_add->CurrentValue);

		// Convert decimal values if posted back
		if ($this->final_amount->FormValue == $this->final_amount->CurrentValue && is_numeric(ConvertToFloatString($this->final_amount->CurrentValue)))
			$this->final_amount->CurrentValue = ConvertToFloatString($this->final_amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// employee_id
		// expense_type
		// expense_sub_type
		// basic_salary
		// ded_add
		// final_amount
		// dated
		// remarks
		// uploads
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// employee_id
			$curVal = strval($this->employee_id->CurrentValue);
			if ($curVal <> "") {
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
				if ($this->employee_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = FormatNumber($rswrk->fields('df3'), 0, -2, -2, -2);
						$this->employee_id->ViewValue = $this->employee_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
					}
				}
			} else {
				$this->employee_id->ViewValue = NULL;
			}
			$this->employee_id->ViewCustomAttributes = "";

			// expense_type
			$curVal = strval($this->expense_type->CurrentValue);
			if ($curVal <> "") {
				$this->expense_type->ViewValue = $this->expense_type->lookupCacheOption($curVal);
				if ($this->expense_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 1 || FIND_IN_SET(`id`, '9,10')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->expense_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->expense_type->ViewValue = $this->expense_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->expense_type->ViewValue = $this->expense_type->CurrentValue;
					}
				}
			} else {
				$this->expense_type->ViewValue = NULL;
			}
			$this->expense_type->ViewCustomAttributes = "";

			// expense_sub_type
			$curVal = strval($this->expense_sub_type->CurrentValue);
			if ($curVal <> "") {
				$this->expense_sub_type->ViewValue = $this->expense_sub_type->lookupCacheOption($curVal);
				if ($this->expense_sub_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->expense_sub_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->expense_sub_type->ViewValue = $this->expense_sub_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->expense_sub_type->ViewValue = $this->expense_sub_type->CurrentValue;
					}
				}
			} else {
				$this->expense_sub_type->ViewValue = NULL;
			}
			$this->expense_sub_type->ViewCustomAttributes = "";

			// basic_salary
			$this->basic_salary->ViewValue = $this->basic_salary->CurrentValue;
			$this->basic_salary->ViewValue = FormatNumber($this->basic_salary->ViewValue, 2, -2, -2, -2);
			$this->basic_salary->ViewCustomAttributes = "";

			// ded_add
			$this->ded_add->ViewValue = $this->ded_add->CurrentValue;
			$this->ded_add->ViewValue = FormatNumber($this->ded_add->ViewValue, 2, -2, -2, -2);
			$this->ded_add->ViewCustomAttributes = "";

			// final_amount
			$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
			$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 0, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// uploads
			$this->uploads->UploadPath = '.p_uploads/salary/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			$this->employee_id->HrefValue = "";
			$this->employee_id->TooltipValue = "";

			// expense_type
			$this->expense_type->LinkCustomAttributes = "";
			$this->expense_type->HrefValue = "";
			$this->expense_type->TooltipValue = "";

			// expense_sub_type
			$this->expense_sub_type->LinkCustomAttributes = "";
			$this->expense_sub_type->HrefValue = "";
			$this->expense_sub_type->TooltipValue = "";

			// basic_salary
			$this->basic_salary->LinkCustomAttributes = "";
			$this->basic_salary->HrefValue = "";
			$this->basic_salary->TooltipValue = "";

			// ded_add
			$this->ded_add->LinkCustomAttributes = "";
			$this->ded_add->HrefValue = "";
			$this->ded_add->TooltipValue = "";

			// final_amount
			$this->final_amount->LinkCustomAttributes = "";
			$this->final_amount->HrefValue = "";
			$this->final_amount->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/salary/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = GetFileUploadUrl($this->uploads, $this->uploads->Upload->DbValue); // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "salary_expenses_x_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// employee_id
			$this->employee_id->EditAttrs["class"] = "form-control";
			$this->employee_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->employee_id->CurrentValue));
			if ($curVal <> "")
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
			else
				$this->employee_id->ViewValue = $this->employee_id->Lookup !== NULL && is_array($this->employee_id->Lookup->Options) ? $curVal : NULL;
			if ($this->employee_id->ViewValue !== NULL) { // Load from cache
				$this->employee_id->EditValue = array_values($this->employee_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->employee_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
					$arwrk[$i][3] = FormatNumber($arwrk[$i][3], 0, -2, -2, -2);
				}
				$this->employee_id->EditValue = $arwrk;
			}

			// expense_type
			$this->expense_type->EditAttrs["class"] = "form-control";
			$this->expense_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->expense_type->CurrentValue));
			if ($curVal <> "")
				$this->expense_type->ViewValue = $this->expense_type->lookupCacheOption($curVal);
			else
				$this->expense_type->ViewValue = $this->expense_type->Lookup !== NULL && is_array($this->expense_type->Lookup->Options) ? $curVal : NULL;
			if ($this->expense_type->ViewValue !== NULL) { // Load from cache
				$this->expense_type->EditValue = array_values($this->expense_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->expense_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` = 1 and `grp` = 1 || FIND_IN_SET(`id`, '9,10')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->expense_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->expense_type->EditValue = $arwrk;
			}

			// expense_sub_type
			$this->expense_sub_type->EditAttrs["class"] = "form-control";
			$this->expense_sub_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->expense_sub_type->CurrentValue));
			if ($curVal <> "")
				$this->expense_sub_type->ViewValue = $this->expense_sub_type->lookupCacheOption($curVal);
			else
				$this->expense_sub_type->ViewValue = $this->expense_sub_type->Lookup !== NULL && is_array($this->expense_sub_type->Lookup->Options) ? $curVal : NULL;
			if ($this->expense_sub_type->ViewValue !== NULL) { // Load from cache
				$this->expense_sub_type->EditValue = array_values($this->expense_sub_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->expense_sub_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id` > 100";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->expense_sub_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->expense_sub_type->EditValue = $arwrk;
			}

			// basic_salary
			$this->basic_salary->EditAttrs["class"] = "form-control";
			$this->basic_salary->EditCustomAttributes = "";
			$this->basic_salary->EditValue = HtmlEncode($this->basic_salary->CurrentValue);
			$this->basic_salary->PlaceHolder = RemoveHtml($this->basic_salary->caption());
			if (strval($this->basic_salary->EditValue) <> "" && is_numeric($this->basic_salary->EditValue))
				$this->basic_salary->EditValue = FormatNumber($this->basic_salary->EditValue, -2, -2, -2, -2);

			// ded_add
			$this->ded_add->EditAttrs["class"] = "form-control";
			$this->ded_add->EditCustomAttributes = "";
			$this->ded_add->EditValue = HtmlEncode($this->ded_add->CurrentValue);
			$this->ded_add->PlaceHolder = RemoveHtml($this->ded_add->caption());
			if (strval($this->ded_add->EditValue) <> "" && is_numeric($this->ded_add->EditValue))
				$this->ded_add->EditValue = FormatNumber($this->ded_add->EditValue, -2, -2, -2, -2);

			// final_amount
			$this->final_amount->EditAttrs["class"] = "form-control";
			$this->final_amount->EditCustomAttributes = 'ReadOnly';
			$this->final_amount->EditValue = HtmlEncode($this->final_amount->CurrentValue);
			$this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());
			if (strval($this->final_amount->EditValue) <> "" && is_numeric($this->final_amount->EditValue))
				$this->final_amount->EditValue = FormatNumber($this->final_amount->EditValue, -2, -2, -2, -2);

			// dated
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, 8));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/salary/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->EditValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->EditValue = "";
			}
			if (!EmptyValue($this->uploads->CurrentValue))
					$this->uploads->Upload->FileName = $this->uploads->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->uploads);

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			$this->employee_id->HrefValue = "";

			// expense_type
			$this->expense_type->LinkCustomAttributes = "";
			$this->expense_type->HrefValue = "";

			// expense_sub_type
			$this->expense_sub_type->LinkCustomAttributes = "";
			$this->expense_sub_type->HrefValue = "";

			// basic_salary
			$this->basic_salary->LinkCustomAttributes = "";
			$this->basic_salary->HrefValue = "";

			// ded_add
			$this->ded_add->LinkCustomAttributes = "";
			$this->ded_add->HrefValue = "";

			// final_amount
			$this->final_amount->LinkCustomAttributes = "";
			$this->final_amount->HrefValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/salary/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = GetFileUploadUrl($this->uploads, $this->uploads->Upload->DbValue); // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->employee_id->Required) {
			if (!$this->employee_id->IsDetailKey && $this->employee_id->FormValue != NULL && $this->employee_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_id->caption(), $this->employee_id->RequiredErrorMessage));
			}
		}
		if ($this->expense_type->Required) {
			if (!$this->expense_type->IsDetailKey && $this->expense_type->FormValue != NULL && $this->expense_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->expense_type->caption(), $this->expense_type->RequiredErrorMessage));
			}
		}
		if ($this->expense_sub_type->Required) {
			if (!$this->expense_sub_type->IsDetailKey && $this->expense_sub_type->FormValue != NULL && $this->expense_sub_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->expense_sub_type->caption(), $this->expense_sub_type->RequiredErrorMessage));
			}
		}
		if ($this->basic_salary->Required) {
			if (!$this->basic_salary->IsDetailKey && $this->basic_salary->FormValue != NULL && $this->basic_salary->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->basic_salary->caption(), $this->basic_salary->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->basic_salary->FormValue)) {
			AddMessage($FormError, $this->basic_salary->errorMessage());
		}
		if ($this->ded_add->Required) {
			if (!$this->ded_add->IsDetailKey && $this->ded_add->FormValue != NULL && $this->ded_add->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ded_add->caption(), $this->ded_add->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->ded_add->FormValue)) {
			AddMessage($FormError, $this->ded_add->errorMessage());
		}
		if ($this->final_amount->Required) {
			if (!$this->final_amount->IsDetailKey && $this->final_amount->FormValue != NULL && $this->final_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->final_amount->caption(), $this->final_amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->final_amount->FormValue)) {
			AddMessage($FormError, $this->final_amount->errorMessage());
		}
		if ($this->dated->Required) {
			if (!$this->dated->IsDetailKey && $this->dated->FormValue != NULL && $this->dated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dated->FormValue)) {
			AddMessage($FormError, $this->dated->errorMessage());
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->uploads->Required) {
			if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->uploads->OldUploadPath = '.p_uploads/salary/';
			$this->uploads->UploadPath = $this->uploads->OldUploadPath;
			$rsnew = [];

			// employee_id
			$this->employee_id->setDbValueDef($rsnew, $this->employee_id->CurrentValue, 0, $this->employee_id->ReadOnly);

			// expense_type
			$this->expense_type->setDbValueDef($rsnew, $this->expense_type->CurrentValue, 0, $this->expense_type->ReadOnly);

			// expense_sub_type
			$this->expense_sub_type->setDbValueDef($rsnew, $this->expense_sub_type->CurrentValue, NULL, $this->expense_sub_type->ReadOnly);

			// basic_salary
			$this->basic_salary->setDbValueDef($rsnew, $this->basic_salary->CurrentValue, 0, $this->basic_salary->ReadOnly);

			// ded_add
			$this->ded_add->setDbValueDef($rsnew, $this->ded_add->CurrentValue, 0, $this->ded_add->ReadOnly);

			// final_amount
			$this->final_amount->setDbValueDef($rsnew, $this->final_amount->CurrentValue, 0, $this->final_amount->ReadOnly);

			// dated
			$this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, 0), CurrentDate(), $this->dated->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// uploads
			if ($this->uploads->Visible && !$this->uploads->ReadOnly && !$this->uploads->Upload->KeepFile) {
				$this->uploads->Upload->DbValue = $rsold['uploads']; // Get original value
				if ($this->uploads->Upload->FileName == "") {
					$rsnew['uploads'] = NULL;
				} else {
					$rsnew['uploads'] = $this->uploads->Upload->FileName;
				}
				$this->uploads->ImageWidth = 0; // Resize width
				$this->uploads->ImageHeight = 640; // Resize height
			}

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;
			if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
				$this->uploads->UploadPath = '.p_uploads/salary/';
				$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : array($this->uploads->Upload->DbValue);
				if (!EmptyValue($this->uploads->Upload->FileName)) {
					$newFiles = array($this->uploads->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1) || file_exists($this->uploads->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file, UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->uploads->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, NULL, $this->uploads->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : array($this->uploads->Upload->DbValue);
						if (!EmptyValue($this->uploads->Upload->FileName)) {
							$newFiles = array($this->uploads->Upload->FileName);
							$newFiles2 = array($rsnew['uploads']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->uploads->Upload->resizeAndSaveToFile($this->uploads->ImageWidth, $this->uploads->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// uploads
		if ($this->uploads->Upload->FileToken <> "")
			CleanUploadTempPath($this->uploads->Upload->FileToken, $this->uploads->Upload->Index);
		else
			CleanUploadTempPath($this->uploads, $this->uploads->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("salary_expenseslist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_employee_id":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_expense_type":
					$lookupFilter = function() {
						return "`status` = 1 and `grp` = 1 || FIND_IN_SET(`id`, '9,10')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_expense_sub_type":
					$lookupFilter = function() {
						return "`id` > 100";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_employee_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							$row[3] = FormatNumber($row[3], 0, -2, -2, -2);
							$row['df3'] = $row[3];
							break;
						case "x_expense_type":
							break;
						case "x_expense_sub_type":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>