<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for sample_req_cart
 */
class sample_req_cart extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $request_by;
	public $old_ref;
	public $upload;
	public $design;
	public $color;
	public $size;
	public $quantity;
	public $comments;
	public $operator;
	public $datetime;
	public $po_id;
	public $status;
	public $shipping_mode;
	public $delivery_week;
	public $purpose;
	public $label;
	public $ssd;
	public $shipping_address;
	public $shipping_address_2;
	public $company_id;
	public $partner_id;
	public $sp_remarks;
	public $pp_remarks;
	public $po_remarks;
	public $price;
	public $declaration;
	public $remarks;
	public $a_operator;
	public $a_datetime;
	public $app_operator;
	public $app_datetime;
	public $po_operator;
	public $po_datetime;
	public $bom;
	public $dispatch;
	public $pd_upload;
	public $d_operator;
	public $d_datetime;
	public $r_comments;
	public $r_operator;
	public $r_datetime;
	public $f_yn;
	public $feedback;
	public $f_upload;
	public $f_operator;
	public $f_datetime;
	public $r_text;
	public $_barcode;
	public $fr_operator;
	public $fr_datetime;
	public $app_status;
	public $da_comments;
	public $da_status;
	public $da_operator;
	public $da_datetime;
	public $req_chat_id;
	public $pd_operator;
	public $pd_comments;
	public $pd_datetime;
	public $d_upload;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'sample_req_cart';
		$this->TableName = 'sample_req_cart';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`sample_req_cart`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('sample_req_cart', 'sample_req_cart', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// request_by
		$this->request_by = new DbField('sample_req_cart', 'sample_req_cart', 'x_request_by', 'request_by', '`request_by`', '`request_by`', 18, -1, FALSE, '`request_by`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->request_by->Nullable = FALSE; // NOT NULL field
		$this->request_by->Required = TRUE; // Required field
		$this->request_by->Sortable = TRUE; // Allow sort
		$this->request_by->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->request_by->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->request_by->Lookup = new Lookup('request_by', 'admin_office', FALSE, 'id', ["user_name","formal_name","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->request_by->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['request_by'] = &$this->request_by;

		// old_ref
		$this->old_ref = new DbField('sample_req_cart', 'sample_req_cart', 'x_old_ref', 'old_ref', '`old_ref`', '`old_ref`', 200, -1, FALSE, '`old_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->old_ref->Sortable = TRUE; // Allow sort
		$this->fields['old_ref'] = &$this->old_ref;

		// upload
		$this->upload = new DbField('sample_req_cart', 'sample_req_cart', 'x_upload', 'upload', '`upload`', '`upload`', 201, -1, TRUE, '`upload`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->upload->Sortable = TRUE; // Allow sort
		$this->upload->UploadMultiple = TRUE;
		$this->upload->Upload->UploadMultiple = TRUE;
		$this->upload->UploadMaxFileCount = 0;
		$this->fields['upload'] = &$this->upload;

		// design
		$this->design = new DbField('sample_req_cart', 'sample_req_cart', 'x_design', 'design', '`design`', '`design`', 200, -1, FALSE, '`design`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design->Nullable = FALSE; // NOT NULL field
		$this->design->Required = TRUE; // Required field
		$this->design->Sortable = TRUE; // Allow sort
		$this->design->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['design'] = &$this->design;

		// color
		$this->color = new DbField('sample_req_cart', 'sample_req_cart', 'x_color', 'color', '`color`', '`color`', 200, -1, FALSE, '`color`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->color->Nullable = FALSE; // NOT NULL field
		$this->color->Required = TRUE; // Required field
		$this->color->Sortable = TRUE; // Allow sort
		$this->color->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['color'] = &$this->color;

		// size
		$this->size = new DbField('sample_req_cart', 'sample_req_cart', 'x_size', 'size', '`size`', '`size`', 200, -1, FALSE, '`size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size->Nullable = FALSE; // NOT NULL field
		$this->size->Required = TRUE; // Required field
		$this->size->Sortable = TRUE; // Allow sort
		$this->size->DefaultErrorMessage = $Language->phrase("IncorrectField");
		$this->fields['size'] = &$this->size;

		// quantity
		$this->quantity = new DbField('sample_req_cart', 'sample_req_cart', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 18, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity'] = &$this->quantity;

		// comments
		$this->comments = new DbField('sample_req_cart', 'sample_req_cart', 'x_comments', 'comments', '`comments`', '`comments`', 200, -1, FALSE, '`comments`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->comments->Sortable = TRUE; // Allow sort
		$this->fields['comments'] = &$this->comments;

		// operator
		$this->operator = new DbField('sample_req_cart', 'sample_req_cart', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('sample_req_cart', 'sample_req_cart', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// po_id
		$this->po_id = new DbField('sample_req_cart', 'sample_req_cart', 'x_po_id', 'po_id', '`po_id`', '`po_id`', 18, -1, FALSE, '`po_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_id->Sortable = FALSE; // Allow sort
		$this->po_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_id'] = &$this->po_id;

		// status
		$this->status = new DbField('sample_req_cart', 'sample_req_cart', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Sortable = FALSE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'sample_request_status', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// shipping_mode
		$this->shipping_mode = new DbField('sample_req_cart', 'sample_req_cart', 'x_shipping_mode', 'shipping_mode', '`shipping_mode`', '`shipping_mode`', 3, -1, FALSE, '`shipping_mode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shipping_mode->Sortable = FALSE; // Allow sort
		$this->shipping_mode->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->shipping_mode->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->shipping_mode->Lookup = new Lookup('shipping_mode', 'sample_req_cart', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->shipping_mode->OptionCount = 3;
		$this->shipping_mode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shipping_mode'] = &$this->shipping_mode;

		// delivery_week
		$this->delivery_week = new DbField('sample_req_cart', 'sample_req_cart', 'x_delivery_week', 'delivery_week', '`delivery_week`', '`delivery_week`', 18, -1, FALSE, '`delivery_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->delivery_week->Sortable = FALSE; // Allow sort
		$this->delivery_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->delivery_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->delivery_week->Lookup = new Lookup('delivery_week', 'not_week', FALSE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->delivery_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['delivery_week'] = &$this->delivery_week;

		// purpose
		$this->purpose = new DbField('sample_req_cart', 'sample_req_cart', 'x_purpose', 'purpose', '`purpose`', '`purpose`', 2, -1, FALSE, '`purpose`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->purpose->Sortable = FALSE; // Allow sort
		$this->purpose->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->purpose->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->purpose->Lookup = new Lookup('purpose', 'sample_req_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->purpose->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['purpose'] = &$this->purpose;

		// label
		$this->label = new DbField('sample_req_cart', 'sample_req_cart', 'x_label', 'label', '`label`', '`label`', 200, -1, FALSE, '`label`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->label->Sortable = FALSE; // Allow sort
		$this->label->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->label->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->label->Lookup = new Lookup('label', 'sample_req_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['label'] = &$this->label;

		// ssd
		$this->ssd = new DbField('sample_req_cart', 'sample_req_cart', 'x_ssd', 'ssd', '`ssd`', CastDateFieldForLike('`ssd`', 0, "DB"), 133, 0, FALSE, '`ssd`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ssd->Sortable = FALSE; // Allow sort
		$this->ssd->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['ssd'] = &$this->ssd;

		// shipping_address
		$this->shipping_address = new DbField('sample_req_cart', 'sample_req_cart', 'x_shipping_address', 'shipping_address', '`shipping_address`', '`shipping_address`', 2, -1, FALSE, '`shipping_address`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shipping_address->Sortable = FALSE; // Allow sort
		$this->shipping_address->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->shipping_address->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->shipping_address->Lookup = new Lookup('shipping_address', 'shipping_address', FALSE, 'id', ["formal_name","address","city_name","gst_number"], [], [], [], [], ["r_text"], ["x_shipping_address_2"], '`name` ASC', '');
		$this->shipping_address->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shipping_address'] = &$this->shipping_address;

		// shipping_address_2
		$this->shipping_address_2 = new DbField('sample_req_cart', 'sample_req_cart', 'x_shipping_address_2', 'shipping_address_2', '`shipping_address_2`', '`shipping_address_2`', 201, -1, FALSE, '`shipping_address_2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->shipping_address_2->Sortable = FALSE; // Allow sort
		$this->fields['shipping_address_2'] = &$this->shipping_address_2;

		// company_id
		$this->company_id = new DbField('sample_req_cart', 'sample_req_cart', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Sortable = FALSE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// partner_id
		$this->partner_id = new DbField('sample_req_cart', 'sample_req_cart', 'x_partner_id', 'partner_id', '`partner_id`', '`partner_id`', 19, -1, FALSE, '`EV__partner_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_id->Required = TRUE; // Required field
		$this->partner_id->Sortable = FALSE; // Allow sort
		$this->partner_id->Lookup = new Lookup('partner_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->partner_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['partner_id'] = &$this->partner_id;

		// sp_remarks
		$this->sp_remarks = new DbField('sample_req_cart', 'sample_req_cart', 'x_sp_remarks', 'sp_remarks', '`sp_remarks`', '`sp_remarks`', 201, -1, FALSE, '`sp_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->sp_remarks->Sortable = FALSE; // Allow sort
		$this->fields['sp_remarks'] = &$this->sp_remarks;

		// pp_remarks
		$this->pp_remarks = new DbField('sample_req_cart', 'sample_req_cart', 'x_pp_remarks', 'pp_remarks', '`pp_remarks`', '`pp_remarks`', 201, -1, FALSE, '`pp_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pp_remarks->Sortable = FALSE; // Allow sort
		$this->fields['pp_remarks'] = &$this->pp_remarks;

		// po_remarks
		$this->po_remarks = new DbField('sample_req_cart', 'sample_req_cart', 'x_po_remarks', 'po_remarks', '`po_remarks`', '`po_remarks`', 200, -1, FALSE, '`po_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_remarks->Sortable = FALSE; // Allow sort
		$this->fields['po_remarks'] = &$this->po_remarks;

		// price
		$this->price = new DbField('sample_req_cart', 'sample_req_cart', 'x_price', 'price', '`price`', '`price`', 200, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Sortable = FALSE; // Allow sort
		$this->fields['price'] = &$this->price;

		// declaration
		$this->declaration = new DbField('sample_req_cart', 'sample_req_cart', 'x_declaration', 'declaration', '`declaration`', '`declaration`', 200, -1, FALSE, '`declaration`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->declaration->Sortable = FALSE; // Allow sort
		$this->fields['declaration'] = &$this->declaration;

		// remarks
		$this->remarks = new DbField('sample_req_cart', 'sample_req_cart', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = FALSE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// a_operator
		$this->a_operator = new DbField('sample_req_cart', 'sample_req_cart', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 18, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->a_operator->Sortable = FALSE; // Allow sort
		$this->a_operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->a_operator->Lookup = new Lookup('a_operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// a_datetime
		$this->a_datetime = new DbField('sample_req_cart', 'sample_req_cart', 'x_a_datetime', 'a_datetime', '`a_datetime`', CastDateFieldForLike('`a_datetime`', 0, "DB"), 135, 0, FALSE, '`a_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_datetime->Sortable = FALSE; // Allow sort
		$this->fields['a_datetime'] = &$this->a_datetime;

		// app_operator
		$this->app_operator = new DbField('sample_req_cart', 'sample_req_cart', 'x_app_operator', 'app_operator', '`app_operator`', '`app_operator`', 18, -1, FALSE, '`app_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->app_operator->Sortable = FALSE; // Allow sort
		$this->app_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['app_operator'] = &$this->app_operator;

		// app_datetime
		$this->app_datetime = new DbField('sample_req_cart', 'sample_req_cart', 'x_app_datetime', 'app_datetime', '`app_datetime`', CastDateFieldForLike('`app_datetime`', 0, "DB"), 135, 0, FALSE, '`app_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->app_datetime->Sortable = FALSE; // Allow sort
		$this->app_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['app_datetime'] = &$this->app_datetime;

		// po_operator
		$this->po_operator = new DbField('sample_req_cart', 'sample_req_cart', 'x_po_operator', 'po_operator', '`po_operator`', '`po_operator`', 2, -1, FALSE, '`po_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_operator->Sortable = FALSE; // Allow sort
		$this->po_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['po_operator'] = &$this->po_operator;

		// po_datetime
		$this->po_datetime = new DbField('sample_req_cart', 'sample_req_cart', 'x_po_datetime', 'po_datetime', '`po_datetime`', CastDateFieldForLike('`po_datetime`', 0, "DB"), 135, 0, FALSE, '`po_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_datetime->Sortable = FALSE; // Allow sort
		$this->po_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['po_datetime'] = &$this->po_datetime;

		// bom
		$this->bom = new DbField('sample_req_cart', 'sample_req_cart', 'x_bom', 'bom', '`bom`', '`bom`', 201, -1, FALSE, '`bom`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->bom->Nullable = FALSE; // NOT NULL field
		$this->bom->Sortable = FALSE; // Allow sort
		$this->fields['bom'] = &$this->bom;

		// dispatch
		$this->dispatch = new DbField('sample_req_cart', 'sample_req_cart', 'x_dispatch', 'dispatch', '`dispatch`', '`dispatch`', 200, -1, FALSE, '`dispatch`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dispatch->Sortable = FALSE; // Allow sort
		$this->fields['dispatch'] = &$this->dispatch;

		// pd_upload
		$this->pd_upload = new DbField('sample_req_cart', 'sample_req_cart', 'x_pd_upload', 'pd_upload', '`pd_upload`', '`pd_upload`', 201, -1, FALSE, '`pd_upload`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->pd_upload->Sortable = FALSE; // Allow sort
		$this->fields['pd_upload'] = &$this->pd_upload;

		// d_operator
		$this->d_operator = new DbField('sample_req_cart', 'sample_req_cart', 'x_d_operator', 'd_operator', '`d_operator`', '`d_operator`', 2, -1, FALSE, '`d_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_operator->Sortable = FALSE; // Allow sort
		$this->d_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['d_operator'] = &$this->d_operator;

		// d_datetime
		$this->d_datetime = new DbField('sample_req_cart', 'sample_req_cart', 'x_d_datetime', 'd_datetime', '`d_datetime`', CastDateFieldForLike('`d_datetime`', 0, "DB"), 135, 0, FALSE, '`d_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_datetime->Sortable = FALSE; // Allow sort
		$this->d_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['d_datetime'] = &$this->d_datetime;

		// r_comments
		$this->r_comments = new DbField('sample_req_cart', 'sample_req_cart', 'x_r_comments', 'r_comments', '`r_comments`', '`r_comments`', 200, -1, FALSE, '`r_comments`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->r_comments->Sortable = FALSE; // Allow sort
		$this->fields['r_comments'] = &$this->r_comments;

		// r_operator
		$this->r_operator = new DbField('sample_req_cart', 'sample_req_cart', 'x_r_operator', 'r_operator', '`r_operator`', '`r_operator`', 2, -1, FALSE, '`r_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->r_operator->Sortable = FALSE; // Allow sort
		$this->r_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['r_operator'] = &$this->r_operator;

		// r_datetime
		$this->r_datetime = new DbField('sample_req_cart', 'sample_req_cart', 'x_r_datetime', 'r_datetime', '`r_datetime`', CastDateFieldForLike('`r_datetime`', 0, "DB"), 135, 0, FALSE, '`r_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->r_datetime->Sortable = FALSE; // Allow sort
		$this->r_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['r_datetime'] = &$this->r_datetime;

		// f_yn
		$this->f_yn = new DbField('sample_req_cart', 'sample_req_cart', 'x_f_yn', 'f_yn', '`f_yn`', '`f_yn`', 18, -1, FALSE, '`f_yn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->f_yn->Sortable = FALSE; // Allow sort
		$this->f_yn->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['f_yn'] = &$this->f_yn;

		// feedback
		$this->feedback = new DbField('sample_req_cart', 'sample_req_cart', 'x_feedback', 'feedback', '`feedback`', '`feedback`', 201, -1, FALSE, '`feedback`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->feedback->Sortable = FALSE; // Allow sort
		$this->fields['feedback'] = &$this->feedback;

		// f_upload
		$this->f_upload = new DbField('sample_req_cart', 'sample_req_cart', 'x_f_upload', 'f_upload', '`f_upload`', '`f_upload`', 200, -1, FALSE, '`f_upload`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->f_upload->Sortable = FALSE; // Allow sort
		$this->fields['f_upload'] = &$this->f_upload;

		// f_operator
		$this->f_operator = new DbField('sample_req_cart', 'sample_req_cart', 'x_f_operator', 'f_operator', '`f_operator`', '`f_operator`', 2, -1, FALSE, '`f_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->f_operator->Sortable = FALSE; // Allow sort
		$this->f_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['f_operator'] = &$this->f_operator;

		// f_datetime
		$this->f_datetime = new DbField('sample_req_cart', 'sample_req_cart', 'x_f_datetime', 'f_datetime', '`f_datetime`', CastDateFieldForLike('`f_datetime`', 0, "DB"), 135, 0, FALSE, '`f_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->f_datetime->Sortable = FALSE; // Allow sort
		$this->f_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['f_datetime'] = &$this->f_datetime;

		// r_text
		$this->r_text = new DbField('sample_req_cart', 'sample_req_cart', 'x_r_text', 'r_text', '`r_text`', '`r_text`', 201, -1, FALSE, '`r_text`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->r_text->Sortable = FALSE; // Allow sort
		$this->fields['r_text'] = &$this->r_text;

		// barcode
		$this->_barcode = new DbField('sample_req_cart', 'sample_req_cart', 'x__barcode', 'barcode', '`barcode`', '`barcode`', 201, -1, FALSE, '`barcode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->_barcode->Sortable = FALSE; // Allow sort
		$this->fields['barcode'] = &$this->_barcode;

		// fr_operator
		$this->fr_operator = new DbField('sample_req_cart', 'sample_req_cart', 'x_fr_operator', 'fr_operator', '`fr_operator`', '`fr_operator`', 2, -1, FALSE, '`fr_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fr_operator->Sortable = FALSE; // Allow sort
		$this->fr_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['fr_operator'] = &$this->fr_operator;

		// fr_datetime
		$this->fr_datetime = new DbField('sample_req_cart', 'sample_req_cart', 'x_fr_datetime', 'fr_datetime', '`fr_datetime`', CastDateFieldForLike('`fr_datetime`', 0, "DB"), 135, 0, FALSE, '`fr_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fr_datetime->Sortable = FALSE; // Allow sort
		$this->fr_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['fr_datetime'] = &$this->fr_datetime;

		// app_status
		$this->app_status = new DbField('sample_req_cart', 'sample_req_cart', 'x_app_status', 'app_status', '`app_status`', '`app_status`', 2, -1, FALSE, '`app_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->app_status->Nullable = FALSE; // NOT NULL field
		$this->app_status->Required = TRUE; // Required field
		$this->app_status->Sortable = FALSE; // Allow sort
		$this->app_status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->app_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->app_status->Lookup = new Lookup('app_status', 'sample_req_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->app_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['app_status'] = &$this->app_status;

		// da_comments
		$this->da_comments = new DbField('sample_req_cart', 'sample_req_cart', 'x_da_comments', 'da_comments', '`da_comments`', '`da_comments`', 201, -1, FALSE, '`da_comments`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->da_comments->Sortable = FALSE; // Allow sort
		$this->fields['da_comments'] = &$this->da_comments;

		// da_status
		$this->da_status = new DbField('sample_req_cart', 'sample_req_cart', 'x_da_status', 'da_status', '`da_status`', '`da_status`', 2, -1, FALSE, '`da_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->da_status->Sortable = FALSE; // Allow sort
		$this->da_status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->da_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->da_status->Lookup = new Lookup('da_status', 'sample_req_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->da_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['da_status'] = &$this->da_status;

		// da_operator
		$this->da_operator = new DbField('sample_req_cart', 'sample_req_cart', 'x_da_operator', 'da_operator', '`da_operator`', '`da_operator`', 18, -1, FALSE, '`da_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->da_operator->Sortable = FALSE; // Allow sort
		$this->da_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['da_operator'] = &$this->da_operator;

		// da_datetime
		$this->da_datetime = new DbField('sample_req_cart', 'sample_req_cart', 'x_da_datetime', 'da_datetime', '`da_datetime`', CastDateFieldForLike('`da_datetime`', 0, "DB"), 135, 0, FALSE, '`da_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->da_datetime->Sortable = FALSE; // Allow sort
		$this->da_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['da_datetime'] = &$this->da_datetime;

		// req_chat_id
		$this->req_chat_id = new DbField('sample_req_cart', 'sample_req_cart', 'x_req_chat_id', 'req_chat_id', '`req_chat_id`', '`req_chat_id`', 200, -1, FALSE, '`req_chat_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_chat_id->Sortable = FALSE; // Allow sort
		$this->req_chat_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_chat_id'] = &$this->req_chat_id;

		// pd_operator
		$this->pd_operator = new DbField('sample_req_cart', 'sample_req_cart', 'x_pd_operator', 'pd_operator', '`pd_operator`', '`pd_operator`', 2, -1, FALSE, '`pd_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pd_operator->Nullable = FALSE; // NOT NULL field
		$this->pd_operator->Required = TRUE; // Required field
		$this->pd_operator->Sortable = FALSE; // Allow sort
		$this->pd_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['pd_operator'] = &$this->pd_operator;

		// pd_comments
		$this->pd_comments = new DbField('sample_req_cart', 'sample_req_cart', 'x_pd_comments', 'pd_comments', '`pd_comments`', '`pd_comments`', 201, -1, FALSE, '`pd_comments`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->pd_comments->Sortable = FALSE; // Allow sort
		$this->fields['pd_comments'] = &$this->pd_comments;

		// pd_datetime
		$this->pd_datetime = new DbField('sample_req_cart', 'sample_req_cart', 'x_pd_datetime', 'pd_datetime', '`pd_datetime`', CastDateFieldForLike('`pd_datetime`', 0, "DB"), 135, 0, FALSE, '`pd_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pd_datetime->Sortable = FALSE; // Allow sort
		$this->pd_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['pd_datetime'] = &$this->pd_datetime;

		// d_upload
		$this->d_upload = new DbField('sample_req_cart', 'sample_req_cart', 'x_d_upload', 'd_upload', '`d_upload`', '`d_upload`', 200, -1, FALSE, '`d_upload`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->d_upload->Sortable = FALSE; // Allow sort
		$this->fields['d_upload'] = &$this->d_upload;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`sample_req_cart`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `name` FROM `buyer_seller_view` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `sample_req_cart`.`partner_id` LIMIT 1) AS `EV__partner_id` FROM `sample_req_cart`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = CurrentUserLevel() == 0 ? "`operator` = ".  CurrentUserID() : "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->partner_id->AdvancedSearch->SearchValue <> "" ||
			$this->partner_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->request_by->DbValue = $row['request_by'];
		$this->old_ref->DbValue = $row['old_ref'];
		$this->upload->Upload->DbValue = $row['upload'];
		$this->design->DbValue = $row['design'];
		$this->color->DbValue = $row['color'];
		$this->size->DbValue = $row['size'];
		$this->quantity->DbValue = $row['quantity'];
		$this->comments->DbValue = $row['comments'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->po_id->DbValue = $row['po_id'];
		$this->status->DbValue = $row['status'];
		$this->shipping_mode->DbValue = $row['shipping_mode'];
		$this->delivery_week->DbValue = $row['delivery_week'];
		$this->purpose->DbValue = $row['purpose'];
		$this->label->DbValue = $row['label'];
		$this->ssd->DbValue = $row['ssd'];
		$this->shipping_address->DbValue = $row['shipping_address'];
		$this->shipping_address_2->DbValue = $row['shipping_address_2'];
		$this->company_id->DbValue = $row['company_id'];
		$this->partner_id->DbValue = $row['partner_id'];
		$this->sp_remarks->DbValue = $row['sp_remarks'];
		$this->pp_remarks->DbValue = $row['pp_remarks'];
		$this->po_remarks->DbValue = $row['po_remarks'];
		$this->price->DbValue = $row['price'];
		$this->declaration->DbValue = $row['declaration'];
		$this->remarks->DbValue = $row['remarks'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->a_datetime->DbValue = $row['a_datetime'];
		$this->app_operator->DbValue = $row['app_operator'];
		$this->app_datetime->DbValue = $row['app_datetime'];
		$this->po_operator->DbValue = $row['po_operator'];
		$this->po_datetime->DbValue = $row['po_datetime'];
		$this->bom->DbValue = $row['bom'];
		$this->dispatch->DbValue = $row['dispatch'];
		$this->pd_upload->DbValue = $row['pd_upload'];
		$this->d_operator->DbValue = $row['d_operator'];
		$this->d_datetime->DbValue = $row['d_datetime'];
		$this->r_comments->DbValue = $row['r_comments'];
		$this->r_operator->DbValue = $row['r_operator'];
		$this->r_datetime->DbValue = $row['r_datetime'];
		$this->f_yn->DbValue = $row['f_yn'];
		$this->feedback->DbValue = $row['feedback'];
		$this->f_upload->DbValue = $row['f_upload'];
		$this->f_operator->DbValue = $row['f_operator'];
		$this->f_datetime->DbValue = $row['f_datetime'];
		$this->r_text->DbValue = $row['r_text'];
		$this->_barcode->DbValue = $row['barcode'];
		$this->fr_operator->DbValue = $row['fr_operator'];
		$this->fr_datetime->DbValue = $row['fr_datetime'];
		$this->app_status->DbValue = $row['app_status'];
		$this->da_comments->DbValue = $row['da_comments'];
		$this->da_status->DbValue = $row['da_status'];
		$this->da_operator->DbValue = $row['da_operator'];
		$this->da_datetime->DbValue = $row['da_datetime'];
		$this->req_chat_id->DbValue = $row['req_chat_id'];
		$this->pd_operator->DbValue = $row['pd_operator'];
		$this->pd_comments->DbValue = $row['pd_comments'];
		$this->pd_datetime->DbValue = $row['pd_datetime'];
		$this->d_upload->DbValue = $row['d_upload'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->upload->OldUploadPath = 'product_images/o/sample_cart/';
		$oldFiles = EmptyValue($row['upload']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['upload']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->upload->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->upload->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "sample_req_cartlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "sample_req_cartview.php")
			return $Language->phrase("View");
		elseif ($pageName == "sample_req_cartedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "sample_req_cartadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "sample_req_cartlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("sample_req_cartview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("sample_req_cartview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "sample_req_cartadd.php?" . $this->getUrlParm($parm);
		else
			$url = "sample_req_cartadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("sample_req_cartedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("sample_req_cartadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("sample_req_cartdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->request_by->setDbValue($rs->fields('request_by'));
		$this->old_ref->setDbValue($rs->fields('old_ref'));
		$this->upload->Upload->DbValue = $rs->fields('upload');
		$this->design->setDbValue($rs->fields('design'));
		$this->color->setDbValue($rs->fields('color'));
		$this->size->setDbValue($rs->fields('size'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->comments->setDbValue($rs->fields('comments'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->po_id->setDbValue($rs->fields('po_id'));
		$this->status->setDbValue($rs->fields('status'));
		$this->shipping_mode->setDbValue($rs->fields('shipping_mode'));
		$this->delivery_week->setDbValue($rs->fields('delivery_week'));
		$this->purpose->setDbValue($rs->fields('purpose'));
		$this->label->setDbValue($rs->fields('label'));
		$this->ssd->setDbValue($rs->fields('ssd'));
		$this->shipping_address->setDbValue($rs->fields('shipping_address'));
		$this->shipping_address_2->setDbValue($rs->fields('shipping_address_2'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->partner_id->setDbValue($rs->fields('partner_id'));
		$this->sp_remarks->setDbValue($rs->fields('sp_remarks'));
		$this->pp_remarks->setDbValue($rs->fields('pp_remarks'));
		$this->po_remarks->setDbValue($rs->fields('po_remarks'));
		$this->price->setDbValue($rs->fields('price'));
		$this->declaration->setDbValue($rs->fields('declaration'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->a_datetime->setDbValue($rs->fields('a_datetime'));
		$this->app_operator->setDbValue($rs->fields('app_operator'));
		$this->app_datetime->setDbValue($rs->fields('app_datetime'));
		$this->po_operator->setDbValue($rs->fields('po_operator'));
		$this->po_datetime->setDbValue($rs->fields('po_datetime'));
		$this->bom->setDbValue($rs->fields('bom'));
		$this->dispatch->setDbValue($rs->fields('dispatch'));
		$this->pd_upload->setDbValue($rs->fields('pd_upload'));
		$this->d_operator->setDbValue($rs->fields('d_operator'));
		$this->d_datetime->setDbValue($rs->fields('d_datetime'));
		$this->r_comments->setDbValue($rs->fields('r_comments'));
		$this->r_operator->setDbValue($rs->fields('r_operator'));
		$this->r_datetime->setDbValue($rs->fields('r_datetime'));
		$this->f_yn->setDbValue($rs->fields('f_yn'));
		$this->feedback->setDbValue($rs->fields('feedback'));
		$this->f_upload->setDbValue($rs->fields('f_upload'));
		$this->f_operator->setDbValue($rs->fields('f_operator'));
		$this->f_datetime->setDbValue($rs->fields('f_datetime'));
		$this->r_text->setDbValue($rs->fields('r_text'));
		$this->_barcode->setDbValue($rs->fields('barcode'));
		$this->fr_operator->setDbValue($rs->fields('fr_operator'));
		$this->fr_datetime->setDbValue($rs->fields('fr_datetime'));
		$this->app_status->setDbValue($rs->fields('app_status'));
		$this->da_comments->setDbValue($rs->fields('da_comments'));
		$this->da_status->setDbValue($rs->fields('da_status'));
		$this->da_operator->setDbValue($rs->fields('da_operator'));
		$this->da_datetime->setDbValue($rs->fields('da_datetime'));
		$this->req_chat_id->setDbValue($rs->fields('req_chat_id'));
		$this->pd_operator->setDbValue($rs->fields('pd_operator'));
		$this->pd_comments->setDbValue($rs->fields('pd_comments'));
		$this->pd_datetime->setDbValue($rs->fields('pd_datetime'));
		$this->d_upload->setDbValue($rs->fields('d_upload'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// request_by
		// old_ref
		// upload
		// design
		// color
		// size
		// quantity
		// comments
		// operator
		// datetime
		// po_id

		$this->po_id->CellCssStyle = "white-space: nowrap;";

		// status
		$this->status->CellCssStyle = "white-space: nowrap;";

		// shipping_mode
		$this->shipping_mode->CellCssStyle = "white-space: nowrap;";

		// delivery_week
		$this->delivery_week->CellCssStyle = "white-space: nowrap;";

		// purpose
		$this->purpose->CellCssStyle = "white-space: nowrap;";

		// label
		$this->label->CellCssStyle = "white-space: nowrap;";

		// ssd
		$this->ssd->CellCssStyle = "white-space: nowrap;";

		// shipping_address
		$this->shipping_address->CellCssStyle = "white-space: nowrap;";

		// shipping_address_2
		$this->shipping_address_2->CellCssStyle = "white-space: nowrap;";

		// company_id
		$this->company_id->CellCssStyle = "white-space: nowrap;";

		// partner_id
		$this->partner_id->CellCssStyle = "white-space: nowrap;";

		// sp_remarks
		$this->sp_remarks->CellCssStyle = "white-space: nowrap;";

		// pp_remarks
		$this->pp_remarks->CellCssStyle = "white-space: nowrap;";

		// po_remarks
		$this->po_remarks->CellCssStyle = "white-space: nowrap;";

		// price
		$this->price->CellCssStyle = "white-space: nowrap;";

		// declaration
		$this->declaration->CellCssStyle = "white-space: nowrap;";

		// remarks
		$this->remarks->CellCssStyle = "white-space: nowrap;";

		// a_operator
		$this->a_operator->CellCssStyle = "white-space: nowrap;";

		// a_datetime
		$this->a_datetime->CellCssStyle = "white-space: nowrap;";

		// app_operator
		$this->app_operator->CellCssStyle = "white-space: nowrap;";

		// app_datetime
		$this->app_datetime->CellCssStyle = "white-space: nowrap;";

		// po_operator
		$this->po_operator->CellCssStyle = "white-space: nowrap;";

		// po_datetime
		$this->po_datetime->CellCssStyle = "white-space: nowrap;";

		// bom
		$this->bom->CellCssStyle = "white-space: nowrap;";

		// dispatch
		$this->dispatch->CellCssStyle = "white-space: nowrap;";

		// pd_upload
		$this->pd_upload->CellCssStyle = "white-space: nowrap;";

		// d_operator
		$this->d_operator->CellCssStyle = "white-space: nowrap;";

		// d_datetime
		$this->d_datetime->CellCssStyle = "white-space: nowrap;";

		// r_comments
		$this->r_comments->CellCssStyle = "white-space: nowrap;";

		// r_operator
		$this->r_operator->CellCssStyle = "white-space: nowrap;";

		// r_datetime
		$this->r_datetime->CellCssStyle = "white-space: nowrap;";

		// f_yn
		$this->f_yn->CellCssStyle = "white-space: nowrap;";

		// feedback
		$this->feedback->CellCssStyle = "white-space: nowrap;";

		// f_upload
		$this->f_upload->CellCssStyle = "white-space: nowrap;";

		// f_operator
		$this->f_operator->CellCssStyle = "white-space: nowrap;";

		// f_datetime
		$this->f_datetime->CellCssStyle = "white-space: nowrap;";

		// r_text
		$this->r_text->CellCssStyle = "white-space: nowrap;";

		// barcode
		$this->_barcode->CellCssStyle = "white-space: nowrap;";

		// fr_operator
		$this->fr_operator->CellCssStyle = "white-space: nowrap;";

		// fr_datetime
		$this->fr_datetime->CellCssStyle = "white-space: nowrap;";

		// app_status
		$this->app_status->CellCssStyle = "white-space: nowrap;";

		// da_comments
		$this->da_comments->CellCssStyle = "white-space: nowrap;";

		// da_status
		$this->da_status->CellCssStyle = "white-space: nowrap;";

		// da_operator
		$this->da_operator->CellCssStyle = "white-space: nowrap;";

		// da_datetime
		$this->da_datetime->CellCssStyle = "white-space: nowrap;";

		// req_chat_id
		$this->req_chat_id->CellCssStyle = "white-space: nowrap;";

		// pd_operator
		$this->pd_operator->CellCssStyle = "white-space: nowrap;";

		// pd_comments
		$this->pd_comments->CellCssStyle = "white-space: nowrap;";

		// pd_datetime
		$this->pd_datetime->CellCssStyle = "white-space: nowrap;";

		// d_upload
		$this->d_upload->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// request_by
		$curVal = strval($this->request_by->CurrentValue);
		if ($curVal <> "") {
			$this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
			if ($this->request_by->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return ((CurrentUserLevel() == 0) || (CurrentUserLevel() == 1002)) ? "((`userlevel`= 0) || (`userlevel` = 1002)) and `activated` = 1" : "`activated` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->request_by->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->request_by->ViewValue = $this->request_by->CurrentValue;
				}
			}
		} else {
			$this->request_by->ViewValue = NULL;
		}
		$this->request_by->ViewCustomAttributes = "";

		// old_ref
		$this->old_ref->ViewValue = $this->old_ref->CurrentValue;
		$this->old_ref->ViewCustomAttributes = "";

		// upload
		$this->upload->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->ImageWidth = 0;
			$this->upload->ImageHeight = 50;
			$this->upload->ImageAlt = $this->upload->alt();
			$this->upload->ViewValue = $this->upload->Upload->DbValue;
		} else {
			$this->upload->ViewValue = "";
		}
		$this->upload->ViewCustomAttributes = "";

		// design
		$this->design->ViewValue = $this->design->CurrentValue;
		$this->design->ViewCustomAttributes = "";

		// color
		$this->color->ViewValue = $this->color->CurrentValue;
		$this->color->ViewCustomAttributes = "";

		// size
		$this->size->ViewValue = $this->size->CurrentValue;
		$this->size->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// comments
		$this->comments->ViewValue = $this->comments->CurrentValue;
		$this->comments->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// po_id
		$this->po_id->ViewValue = $this->po_id->CurrentValue;
		$this->po_id->ViewValue = FormatNumber($this->po_id->ViewValue, 0, -2, -2, -2);
		$this->po_id->ViewCustomAttributes = "";

		// status
		$curVal = strval($this->status->CurrentValue);
		if ($curVal <> "") {
			$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
			if ($this->status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->status->ViewValue = $this->status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->status->ViewValue = $this->status->CurrentValue;
				}
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// shipping_mode
		if (strval($this->shipping_mode->CurrentValue) <> "") {
			$this->shipping_mode->ViewValue = $this->shipping_mode->optionCaption($this->shipping_mode->CurrentValue);
		} else {
			$this->shipping_mode->ViewValue = NULL;
		}
		$this->shipping_mode->ViewCustomAttributes = "";

		// delivery_week
		$curVal = strval($this->delivery_week->CurrentValue);
		if ($curVal <> "") {
			$this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
			if ($this->delivery_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add" || CurrentPageID() == "addopt") ? "`weekstartday` > NOW()" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->delivery_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->delivery_week->ViewValue = $this->delivery_week->CurrentValue;
				}
			}
		} else {
			$this->delivery_week->ViewValue = NULL;
		}
		$this->delivery_week->ViewCustomAttributes = "";

		// purpose
		$curVal = strval($this->purpose->CurrentValue);
		if ($curVal <> "") {
			$this->purpose->ViewValue = $this->purpose->lookupCacheOption($curVal);
			if ($this->purpose->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=3 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->purpose->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->purpose->ViewValue = $this->purpose->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->purpose->ViewValue = $this->purpose->CurrentValue;
				}
			}
		} else {
			$this->purpose->ViewValue = NULL;
		}
		$this->purpose->ViewCustomAttributes = "";

		// label
		$curVal = strval($this->label->CurrentValue);
		if ($curVal <> "") {
			$this->label->ViewValue = $this->label->lookupCacheOption($curVal);
			if ($this->label->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=3 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->label->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->label->ViewValue = $this->label->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->label->ViewValue = $this->label->CurrentValue;
				}
			}
		} else {
			$this->label->ViewValue = NULL;
		}
		$this->label->ViewCustomAttributes = "";

		// ssd
		$this->ssd->ViewValue = $this->ssd->CurrentValue;
		$this->ssd->ViewValue = FormatDateTime($this->ssd->ViewValue, 0);
		$this->ssd->ViewCustomAttributes = "";

		// shipping_address
		$curVal = strval($this->shipping_address->CurrentValue);
		if ($curVal <> "") {
			$this->shipping_address->ViewValue = $this->shipping_address->lookupCacheOption($curVal);
			if ($this->shipping_address->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->shipping_address->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->shipping_address->ViewValue = $this->shipping_address->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->shipping_address->ViewValue = $this->shipping_address->CurrentValue;
				}
			}
		} else {
			$this->shipping_address->ViewValue = NULL;
		}
		$this->shipping_address->ViewCustomAttributes = "";

		// shipping_address_2
		$this->shipping_address_2->ViewValue = $this->shipping_address_2->CurrentValue;
		$this->shipping_address_2->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return User_Company_ID() == 0 ? "`status`=1 and `partner_type`=2" : "id= ".  User_Company_ID() . "  and `partner_type`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// partner_id
		if ($this->partner_id->VirtualValue <> "") {
			$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
		} else {
			$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `partner_type`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		}
		$this->partner_id->ViewCustomAttributes = "";

		// sp_remarks
		$this->sp_remarks->ViewValue = $this->sp_remarks->CurrentValue;
		$this->sp_remarks->ViewCustomAttributes = "";

		// pp_remarks
		$this->pp_remarks->ViewValue = $this->pp_remarks->CurrentValue;
		$this->pp_remarks->ViewCustomAttributes = "";

		// po_remarks
		$this->po_remarks->ViewValue = $this->po_remarks->CurrentValue;
		$this->po_remarks->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewCustomAttributes = "";

		// declaration
		$this->declaration->ViewValue = $this->declaration->CurrentValue;
		$this->declaration->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// a_operator
		$curVal = strval($this->a_operator->CurrentValue);
		if ($curVal <> "") {
			$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			if ($this->a_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
				}
			}
		} else {
			$this->a_operator->ViewValue = NULL;
		}
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 0);
		$this->a_datetime->ViewCustomAttributes = "";

		// app_operator
		$this->app_operator->ViewValue = $this->app_operator->CurrentValue;
		$this->app_operator->ViewValue = FormatNumber($this->app_operator->ViewValue, 0, -2, -2, -2);
		$this->app_operator->ViewCustomAttributes = "";

		// app_datetime
		$this->app_datetime->ViewValue = $this->app_datetime->CurrentValue;
		$this->app_datetime->ViewValue = FormatDateTime($this->app_datetime->ViewValue, 0);
		$this->app_datetime->ViewCustomAttributes = "";

		// po_operator
		$this->po_operator->ViewValue = $this->po_operator->CurrentValue;
		$this->po_operator->ViewValue = FormatNumber($this->po_operator->ViewValue, 0, -2, -2, -2);
		$this->po_operator->ViewCustomAttributes = "";

		// po_datetime
		$this->po_datetime->ViewValue = $this->po_datetime->CurrentValue;
		$this->po_datetime->ViewValue = FormatDateTime($this->po_datetime->ViewValue, 0);
		$this->po_datetime->ViewCustomAttributes = "";

		// bom
		$this->bom->ViewValue = $this->bom->CurrentValue;
		$this->bom->ViewCustomAttributes = "";

		// dispatch
		$this->dispatch->ViewValue = $this->dispatch->CurrentValue;
		$this->dispatch->ViewCustomAttributes = "";

		// pd_upload
		$this->pd_upload->ViewValue = $this->pd_upload->CurrentValue;
		$this->pd_upload->ViewCustomAttributes = "";

		// d_operator
		$this->d_operator->ViewValue = $this->d_operator->CurrentValue;
		$this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, 0, -2, -2, -2);
		$this->d_operator->ViewCustomAttributes = "";

		// d_datetime
		$this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
		$this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, 0);
		$this->d_datetime->ViewCustomAttributes = "";

		// r_comments
		$this->r_comments->ViewValue = $this->r_comments->CurrentValue;
		$this->r_comments->ViewCustomAttributes = "";

		// r_operator
		$this->r_operator->ViewValue = $this->r_operator->CurrentValue;
		$this->r_operator->ViewValue = FormatNumber($this->r_operator->ViewValue, 0, -2, -2, -2);
		$this->r_operator->ViewCustomAttributes = "";

		// r_datetime
		$this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
		$this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, 0);
		$this->r_datetime->ViewCustomAttributes = "";

		// f_yn
		$this->f_yn->ViewValue = $this->f_yn->CurrentValue;
		$this->f_yn->ViewValue = FormatNumber($this->f_yn->ViewValue, 0, -2, -2, -2);
		$this->f_yn->ViewCustomAttributes = "";

		// feedback
		$this->feedback->ViewValue = $this->feedback->CurrentValue;
		$this->feedback->ViewCustomAttributes = "";

		// f_upload
		$this->f_upload->ViewValue = $this->f_upload->CurrentValue;
		$this->f_upload->ViewCustomAttributes = "";

		// f_operator
		$this->f_operator->ViewValue = $this->f_operator->CurrentValue;
		$this->f_operator->ViewValue = FormatNumber($this->f_operator->ViewValue, 0, -2, -2, -2);
		$this->f_operator->ViewCustomAttributes = "";

		// f_datetime
		$this->f_datetime->ViewValue = $this->f_datetime->CurrentValue;
		$this->f_datetime->ViewValue = FormatDateTime($this->f_datetime->ViewValue, 0);
		$this->f_datetime->ViewCustomAttributes = "";

		// r_text
		$this->r_text->ViewValue = $this->r_text->CurrentValue;
		$this->r_text->ViewCustomAttributes = "";

		// barcode
		$this->_barcode->ViewValue = $this->_barcode->CurrentValue;
		$this->_barcode->ViewCustomAttributes = "";

		// fr_operator
		$this->fr_operator->ViewValue = $this->fr_operator->CurrentValue;
		$this->fr_operator->ViewValue = FormatNumber($this->fr_operator->ViewValue, 0, -2, -2, -2);
		$this->fr_operator->ViewCustomAttributes = "";

		// fr_datetime
		$this->fr_datetime->ViewValue = $this->fr_datetime->CurrentValue;
		$this->fr_datetime->ViewValue = FormatDateTime($this->fr_datetime->ViewValue, 0);
		$this->fr_datetime->ViewCustomAttributes = "";

		// app_status
		$curVal = strval($this->app_status->CurrentValue);
		if ($curVal <> "") {
			$this->app_status->ViewValue = $this->app_status->lookupCacheOption($curVal);
			if ($this->app_status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 6 and `status` = 1 and (`id` = 602 || `id` = 609)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->app_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->app_status->ViewValue = $this->app_status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->app_status->ViewValue = $this->app_status->CurrentValue;
				}
			}
		} else {
			$this->app_status->ViewValue = NULL;
		}
		$this->app_status->ViewCustomAttributes = "";

		// da_comments
		$this->da_comments->ViewValue = $this->da_comments->CurrentValue;
		$this->da_comments->ViewCustomAttributes = "";

		// da_status
		$curVal = strval($this->da_status->CurrentValue);
		if ($curVal <> "") {
			$this->da_status->ViewValue = $this->da_status->lookupCacheOption($curVal);
			if ($this->da_status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 7 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->da_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->da_status->ViewValue = $this->da_status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->da_status->ViewValue = $this->da_status->CurrentValue;
				}
			}
		} else {
			$this->da_status->ViewValue = NULL;
		}
		$this->da_status->ViewCustomAttributes = "";

		// da_operator
		$this->da_operator->ViewValue = $this->da_operator->CurrentValue;
		$this->da_operator->ViewValue = FormatNumber($this->da_operator->ViewValue, 0, -2, -2, -2);
		$this->da_operator->ViewCustomAttributes = "";

		// da_datetime
		$this->da_datetime->ViewValue = $this->da_datetime->CurrentValue;
		$this->da_datetime->ViewValue = FormatDateTime($this->da_datetime->ViewValue, 0);
		$this->da_datetime->ViewCustomAttributes = "";

		// req_chat_id
		$this->req_chat_id->ViewValue = $this->req_chat_id->CurrentValue;
		$this->req_chat_id->ViewCustomAttributes = "";

		// pd_operator
		$this->pd_operator->ViewValue = $this->pd_operator->CurrentValue;
		$this->pd_operator->ViewValue = FormatNumber($this->pd_operator->ViewValue, 0, -2, -2, -2);
		$this->pd_operator->ViewCustomAttributes = "";

		// pd_comments
		$this->pd_comments->ViewValue = $this->pd_comments->CurrentValue;
		$this->pd_comments->ViewCustomAttributes = "";

		// pd_datetime
		$this->pd_datetime->ViewValue = $this->pd_datetime->CurrentValue;
		$this->pd_datetime->ViewValue = FormatDateTime($this->pd_datetime->ViewValue, 0);
		$this->pd_datetime->ViewCustomAttributes = "";

		// d_upload
		$this->d_upload->ViewValue = $this->d_upload->CurrentValue;
		$this->d_upload->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// request_by
		$this->request_by->LinkCustomAttributes = "";
		$this->request_by->HrefValue = "";
		$this->request_by->TooltipValue = "";

		// old_ref
		$this->old_ref->LinkCustomAttributes = "";
		if (!EmptyValue($this->old_ref->CurrentValue)) {
			$this->old_ref->HrefValue = "sample_req_cart_statuslist.php?x__barcode=" . $this->old_ref->CurrentValue . "&z__barcode=LIKE"; // Add prefix/suffix
			$this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
		} else {
			$this->old_ref->HrefValue = "";
		}
		$this->old_ref->TooltipValue = "";

		// upload
		$this->upload->LinkCustomAttributes = "";
		$this->upload->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->HrefValue = "%u"; // Add prefix/suffix
			$this->upload->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
		} else {
			$this->upload->HrefValue = "";
		}
		$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
		$this->upload->TooltipValue = "";
		if ($this->upload->UseColorbox) {
			if (EmptyValue($this->upload->TooltipValue))
				$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->upload->LinkAttrs["data-rel"] = "sample_req_cart_x_upload";
			AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
		}

		// design
		$this->design->LinkCustomAttributes = "";
		$this->design->HrefValue = "";
		$this->design->TooltipValue = "";

		// color
		$this->color->LinkCustomAttributes = "";
		$this->color->HrefValue = "";
		$this->color->TooltipValue = "";

		// size
		$this->size->LinkCustomAttributes = "";
		$this->size->HrefValue = "";
		$this->size->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// comments
		$this->comments->LinkCustomAttributes = "";
		$this->comments->HrefValue = "";
		$this->comments->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// po_id
		$this->po_id->LinkCustomAttributes = "";
		$this->po_id->HrefValue = "";
		$this->po_id->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// shipping_mode
		$this->shipping_mode->LinkCustomAttributes = "";
		$this->shipping_mode->HrefValue = "";
		$this->shipping_mode->TooltipValue = "";

		// delivery_week
		$this->delivery_week->LinkCustomAttributes = "";
		$this->delivery_week->HrefValue = "";
		$this->delivery_week->TooltipValue = "";

		// purpose
		$this->purpose->LinkCustomAttributes = "";
		$this->purpose->HrefValue = "";
		$this->purpose->TooltipValue = "";

		// label
		$this->label->LinkCustomAttributes = "";
		$this->label->HrefValue = "";
		$this->label->TooltipValue = "";

		// ssd
		$this->ssd->LinkCustomAttributes = "";
		$this->ssd->HrefValue = "";
		$this->ssd->TooltipValue = "";

		// shipping_address
		$this->shipping_address->LinkCustomAttributes = "";
		$this->shipping_address->HrefValue = "";
		$this->shipping_address->TooltipValue = "";

		// shipping_address_2
		$this->shipping_address_2->LinkCustomAttributes = "";
		$this->shipping_address_2->HrefValue = "";
		$this->shipping_address_2->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// partner_id
		$this->partner_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->partner_id->CurrentValue)) {
			$this->partner_id->HrefValue = "po_blist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
			$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
		} else {
			$this->partner_id->HrefValue = "";
		}
		$this->partner_id->TooltipValue = "";

		// sp_remarks
		$this->sp_remarks->LinkCustomAttributes = "";
		$this->sp_remarks->HrefValue = "";
		$this->sp_remarks->TooltipValue = "";

		// pp_remarks
		$this->pp_remarks->LinkCustomAttributes = "";
		$this->pp_remarks->HrefValue = "";
		$this->pp_remarks->TooltipValue = "";

		// po_remarks
		$this->po_remarks->LinkCustomAttributes = "";
		$this->po_remarks->HrefValue = "";
		$this->po_remarks->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// declaration
		$this->declaration->LinkCustomAttributes = "";
		$this->declaration->HrefValue = "";
		$this->declaration->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// a_datetime
		$this->a_datetime->LinkCustomAttributes = "";
		$this->a_datetime->HrefValue = "";
		$this->a_datetime->TooltipValue = "";

		// app_operator
		$this->app_operator->LinkCustomAttributes = "";
		$this->app_operator->HrefValue = "";
		$this->app_operator->TooltipValue = "";

		// app_datetime
		$this->app_datetime->LinkCustomAttributes = "";
		$this->app_datetime->HrefValue = "";
		$this->app_datetime->TooltipValue = "";

		// po_operator
		$this->po_operator->LinkCustomAttributes = "";
		$this->po_operator->HrefValue = "";
		$this->po_operator->TooltipValue = "";

		// po_datetime
		$this->po_datetime->LinkCustomAttributes = "";
		$this->po_datetime->HrefValue = "";
		$this->po_datetime->TooltipValue = "";

		// bom
		$this->bom->LinkCustomAttributes = "";
		$this->bom->HrefValue = "";
		$this->bom->TooltipValue = "";

		// dispatch
		$this->dispatch->LinkCustomAttributes = "";
		$this->dispatch->HrefValue = "";
		$this->dispatch->TooltipValue = "";

		// pd_upload
		$this->pd_upload->LinkCustomAttributes = "";
		$this->pd_upload->HrefValue = "";
		$this->pd_upload->TooltipValue = "";

		// d_operator
		$this->d_operator->LinkCustomAttributes = "";
		$this->d_operator->HrefValue = "";
		$this->d_operator->TooltipValue = "";

		// d_datetime
		$this->d_datetime->LinkCustomAttributes = "";
		$this->d_datetime->HrefValue = "";
		$this->d_datetime->TooltipValue = "";

		// r_comments
		$this->r_comments->LinkCustomAttributes = "";
		$this->r_comments->HrefValue = "";
		$this->r_comments->TooltipValue = "";

		// r_operator
		$this->r_operator->LinkCustomAttributes = "";
		$this->r_operator->HrefValue = "";
		$this->r_operator->TooltipValue = "";

		// r_datetime
		$this->r_datetime->LinkCustomAttributes = "";
		$this->r_datetime->HrefValue = "";
		$this->r_datetime->TooltipValue = "";

		// f_yn
		$this->f_yn->LinkCustomAttributes = "";
		$this->f_yn->HrefValue = "";
		$this->f_yn->TooltipValue = "";

		// feedback
		$this->feedback->LinkCustomAttributes = "";
		$this->feedback->HrefValue = "";
		$this->feedback->TooltipValue = "";

		// f_upload
		$this->f_upload->LinkCustomAttributes = "";
		$this->f_upload->HrefValue = "";
		$this->f_upload->TooltipValue = "";

		// f_operator
		$this->f_operator->LinkCustomAttributes = "";
		$this->f_operator->HrefValue = "";
		$this->f_operator->TooltipValue = "";

		// f_datetime
		$this->f_datetime->LinkCustomAttributes = "";
		$this->f_datetime->HrefValue = "";
		$this->f_datetime->TooltipValue = "";

		// r_text
		$this->r_text->LinkCustomAttributes = "";
		$this->r_text->HrefValue = "";
		$this->r_text->TooltipValue = "";

		// barcode
		$this->_barcode->LinkCustomAttributes = "";
		$this->_barcode->HrefValue = "";
		$this->_barcode->TooltipValue = "";

		// fr_operator
		$this->fr_operator->LinkCustomAttributes = "";
		$this->fr_operator->HrefValue = "";
		$this->fr_operator->TooltipValue = "";

		// fr_datetime
		$this->fr_datetime->LinkCustomAttributes = "";
		$this->fr_datetime->HrefValue = "";
		$this->fr_datetime->TooltipValue = "";

		// app_status
		$this->app_status->LinkCustomAttributes = "";
		$this->app_status->HrefValue = "";
		$this->app_status->TooltipValue = "";

		// da_comments
		$this->da_comments->LinkCustomAttributes = "";
		$this->da_comments->HrefValue = "";
		$this->da_comments->TooltipValue = "";

		// da_status
		$this->da_status->LinkCustomAttributes = "";
		$this->da_status->HrefValue = "";
		$this->da_status->TooltipValue = "";

		// da_operator
		$this->da_operator->LinkCustomAttributes = "";
		$this->da_operator->HrefValue = "";
		$this->da_operator->TooltipValue = "";

		// da_datetime
		$this->da_datetime->LinkCustomAttributes = "";
		$this->da_datetime->HrefValue = "";
		$this->da_datetime->TooltipValue = "";

		// req_chat_id
		$this->req_chat_id->LinkCustomAttributes = "";
		$this->req_chat_id->HrefValue = "";
		$this->req_chat_id->TooltipValue = "";

		// pd_operator
		$this->pd_operator->LinkCustomAttributes = "";
		$this->pd_operator->HrefValue = "";
		$this->pd_operator->TooltipValue = "";

		// pd_comments
		$this->pd_comments->LinkCustomAttributes = "";
		$this->pd_comments->HrefValue = "";
		$this->pd_comments->TooltipValue = "";

		// pd_datetime
		$this->pd_datetime->LinkCustomAttributes = "";
		$this->pd_datetime->HrefValue = "";
		$this->pd_datetime->TooltipValue = "";

		// d_upload
		$this->d_upload->LinkCustomAttributes = "";
		$this->d_upload->HrefValue = "";
		$this->d_upload->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// request_by
		$this->request_by->EditAttrs["class"] = "form-control";
		$this->request_by->EditCustomAttributes = "";
		$curVal = strval($this->request_by->CurrentValue);
		if ($curVal <> "") {
			$this->request_by->EditValue = $this->request_by->lookupCacheOption($curVal);
			if ($this->request_by->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return ((CurrentUserLevel() == 0) || (CurrentUserLevel() == 1002)) ? "((`userlevel`= 0) || (`userlevel` = 1002)) and `activated` = 1" : "`activated` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->request_by->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->request_by->EditValue = $this->request_by->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->request_by->EditValue = $this->request_by->CurrentValue;
				}
			}
		} else {
			$this->request_by->EditValue = NULL;
		}
		$this->request_by->ViewCustomAttributes = "";

		// old_ref
		$this->old_ref->EditAttrs["class"] = "form-control";
		$this->old_ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->old_ref->CurrentValue = HtmlDecode($this->old_ref->CurrentValue);
		$this->old_ref->EditValue = $this->old_ref->CurrentValue;
		$this->old_ref->PlaceHolder = RemoveHtml($this->old_ref->caption());

		// upload
		$this->upload->EditAttrs["class"] = "form-control";
		$this->upload->EditCustomAttributes = "";
		$this->upload->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->ImageWidth = 0;
			$this->upload->ImageHeight = 50;
			$this->upload->ImageAlt = $this->upload->alt();
			$this->upload->EditValue = $this->upload->Upload->DbValue;
		} else {
			$this->upload->EditValue = "";
		}
		if (!EmptyValue($this->upload->CurrentValue))
				$this->upload->Upload->FileName = $this->upload->CurrentValue;

		// design
		$this->design->EditAttrs["class"] = "form-control";
		$this->design->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
		$this->design->EditValue = $this->design->CurrentValue;
		$this->design->PlaceHolder = RemoveHtml($this->design->caption());

		// color
		$this->color->EditAttrs["class"] = "form-control";
		$this->color->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->color->CurrentValue = HtmlDecode($this->color->CurrentValue);
		$this->color->EditValue = $this->color->CurrentValue;
		$this->color->PlaceHolder = RemoveHtml($this->color->caption());

		// size
		$this->size->EditAttrs["class"] = "form-control";
		$this->size->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
		$this->size->EditValue = $this->size->CurrentValue;
		$this->size->PlaceHolder = RemoveHtml($this->size->caption());

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

		// comments
		$this->comments->EditAttrs["class"] = "form-control";
		$this->comments->EditCustomAttributes = "";
		$this->comments->EditValue = $this->comments->CurrentValue;
		$this->comments->PlaceHolder = RemoveHtml($this->comments->caption());

		// operator
		// datetime
		// po_id

		$this->po_id->EditAttrs["class"] = "form-control";
		$this->po_id->EditCustomAttributes = "";
		$this->po_id->EditValue = $this->po_id->CurrentValue;
		$this->po_id->PlaceHolder = RemoveHtml($this->po_id->caption());

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";

		// shipping_mode
		$this->shipping_mode->EditAttrs["class"] = "form-control";
		$this->shipping_mode->EditCustomAttributes = "";
		$this->shipping_mode->EditValue = $this->shipping_mode->options(TRUE);

		// delivery_week
		$this->delivery_week->EditAttrs["class"] = "form-control";
		$this->delivery_week->EditCustomAttributes = "";

		// purpose
		$this->purpose->EditAttrs["class"] = "form-control";
		$this->purpose->EditCustomAttributes = "";

		// label
		$this->label->EditAttrs["class"] = "form-control";
		$this->label->EditCustomAttributes = "";

		// ssd
		$this->ssd->EditAttrs["class"] = "form-control";
		$this->ssd->EditCustomAttributes = "";
		$this->ssd->EditValue = FormatDateTime($this->ssd->CurrentValue, 8);
		$this->ssd->PlaceHolder = RemoveHtml($this->ssd->caption());

		// shipping_address
		$this->shipping_address->EditAttrs["class"] = "form-control";
		$this->shipping_address->EditCustomAttributes = "";

		// shipping_address_2
		$this->shipping_address_2->EditAttrs["class"] = "form-control";
		$this->shipping_address_2->EditCustomAttributes = "";
		$this->shipping_address_2->EditValue = $this->shipping_address_2->CurrentValue;
		$this->shipping_address_2->PlaceHolder = RemoveHtml($this->shipping_address_2->caption());

		// company_id
		$this->company_id->EditCustomAttributes = "";

		// partner_id
		$this->partner_id->EditAttrs["class"] = "form-control";
		$this->partner_id->EditCustomAttributes = "";
		$this->partner_id->EditValue = $this->partner_id->CurrentValue;
		$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

		// sp_remarks
		$this->sp_remarks->EditAttrs["class"] = "form-control";
		$this->sp_remarks->EditCustomAttributes = "";
		$this->sp_remarks->EditValue = $this->sp_remarks->CurrentValue;
		$this->sp_remarks->PlaceHolder = RemoveHtml($this->sp_remarks->caption());

		// pp_remarks
		$this->pp_remarks->EditAttrs["class"] = "form-control";
		$this->pp_remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pp_remarks->CurrentValue = HtmlDecode($this->pp_remarks->CurrentValue);
		$this->pp_remarks->EditValue = $this->pp_remarks->CurrentValue;
		$this->pp_remarks->PlaceHolder = RemoveHtml($this->pp_remarks->caption());

		// po_remarks
		$this->po_remarks->EditAttrs["class"] = "form-control";
		$this->po_remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->po_remarks->CurrentValue = HtmlDecode($this->po_remarks->CurrentValue);
		$this->po_remarks->EditValue = $this->po_remarks->CurrentValue;
		$this->po_remarks->PlaceHolder = RemoveHtml($this->po_remarks->caption());

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->price->CurrentValue = HtmlDecode($this->price->CurrentValue);
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->PlaceHolder = RemoveHtml($this->price->caption());

		// declaration
		$this->declaration->EditAttrs["class"] = "form-control";
		$this->declaration->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->declaration->CurrentValue = HtmlDecode($this->declaration->CurrentValue);
		$this->declaration->EditValue = $this->declaration->CurrentValue;
		$this->declaration->PlaceHolder = RemoveHtml($this->declaration->caption());

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// a_operator
		// a_datetime
		// app_operator
		// app_datetime
		// po_operator
		// po_datetime
		// bom

		$this->bom->EditAttrs["class"] = "form-control";
		$this->bom->EditCustomAttributes = "";
		$this->bom->EditValue = $this->bom->CurrentValue;
		$this->bom->PlaceHolder = RemoveHtml($this->bom->caption());

		// dispatch
		$this->dispatch->EditAttrs["class"] = "form-control";
		$this->dispatch->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->dispatch->CurrentValue = HtmlDecode($this->dispatch->CurrentValue);
		$this->dispatch->EditValue = $this->dispatch->CurrentValue;
		$this->dispatch->PlaceHolder = RemoveHtml($this->dispatch->caption());

		// pd_upload
		$this->pd_upload->EditAttrs["class"] = "form-control";
		$this->pd_upload->EditCustomAttributes = "";
		$this->pd_upload->EditValue = $this->pd_upload->CurrentValue;
		$this->pd_upload->PlaceHolder = RemoveHtml($this->pd_upload->caption());

		// d_operator
		$this->d_operator->EditAttrs["class"] = "form-control";
		$this->d_operator->EditCustomAttributes = "";
		$this->d_operator->EditValue = $this->d_operator->CurrentValue;
		$this->d_operator->PlaceHolder = RemoveHtml($this->d_operator->caption());

		// d_datetime
		$this->d_datetime->EditAttrs["class"] = "form-control";
		$this->d_datetime->EditCustomAttributes = "";
		$this->d_datetime->EditValue = FormatDateTime($this->d_datetime->CurrentValue, 8);
		$this->d_datetime->PlaceHolder = RemoveHtml($this->d_datetime->caption());

		// r_comments
		$this->r_comments->EditAttrs["class"] = "form-control";
		$this->r_comments->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->r_comments->CurrentValue = HtmlDecode($this->r_comments->CurrentValue);
		$this->r_comments->EditValue = $this->r_comments->CurrentValue;
		$this->r_comments->PlaceHolder = RemoveHtml($this->r_comments->caption());

		// r_operator
		$this->r_operator->EditAttrs["class"] = "form-control";
		$this->r_operator->EditCustomAttributes = "";
		$this->r_operator->EditValue = $this->r_operator->CurrentValue;
		$this->r_operator->PlaceHolder = RemoveHtml($this->r_operator->caption());

		// r_datetime
		$this->r_datetime->EditAttrs["class"] = "form-control";
		$this->r_datetime->EditCustomAttributes = "";
		$this->r_datetime->EditValue = FormatDateTime($this->r_datetime->CurrentValue, 8);
		$this->r_datetime->PlaceHolder = RemoveHtml($this->r_datetime->caption());

		// f_yn
		$this->f_yn->EditAttrs["class"] = "form-control";
		$this->f_yn->EditCustomAttributes = "";
		$this->f_yn->EditValue = $this->f_yn->CurrentValue;
		$this->f_yn->PlaceHolder = RemoveHtml($this->f_yn->caption());

		// feedback
		$this->feedback->EditAttrs["class"] = "form-control";
		$this->feedback->EditCustomAttributes = "";
		$this->feedback->EditValue = $this->feedback->CurrentValue;
		$this->feedback->PlaceHolder = RemoveHtml($this->feedback->caption());

		// f_upload
		$this->f_upload->EditAttrs["class"] = "form-control";
		$this->f_upload->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->f_upload->CurrentValue = HtmlDecode($this->f_upload->CurrentValue);
		$this->f_upload->EditValue = $this->f_upload->CurrentValue;
		$this->f_upload->PlaceHolder = RemoveHtml($this->f_upload->caption());

		// f_operator
		$this->f_operator->EditAttrs["class"] = "form-control";
		$this->f_operator->EditCustomAttributes = "";
		$this->f_operator->EditValue = $this->f_operator->CurrentValue;
		$this->f_operator->PlaceHolder = RemoveHtml($this->f_operator->caption());

		// f_datetime
		$this->f_datetime->EditAttrs["class"] = "form-control";
		$this->f_datetime->EditCustomAttributes = "";
		$this->f_datetime->EditValue = FormatDateTime($this->f_datetime->CurrentValue, 8);
		$this->f_datetime->PlaceHolder = RemoveHtml($this->f_datetime->caption());

		// r_text
		$this->r_text->EditAttrs["class"] = "form-control";
		$this->r_text->EditCustomAttributes = "";
		$this->r_text->EditValue = $this->r_text->CurrentValue;
		$this->r_text->PlaceHolder = RemoveHtml($this->r_text->caption());

		// barcode
		$this->_barcode->EditAttrs["class"] = "form-control";
		$this->_barcode->EditCustomAttributes = "";
		$this->_barcode->EditValue = $this->_barcode->CurrentValue;
		$this->_barcode->PlaceHolder = RemoveHtml($this->_barcode->caption());

		// fr_operator
		$this->fr_operator->EditAttrs["class"] = "form-control";
		$this->fr_operator->EditCustomAttributes = "";
		$this->fr_operator->EditValue = $this->fr_operator->CurrentValue;
		$this->fr_operator->PlaceHolder = RemoveHtml($this->fr_operator->caption());

		// fr_datetime
		$this->fr_datetime->EditAttrs["class"] = "form-control";
		$this->fr_datetime->EditCustomAttributes = "";
		$this->fr_datetime->EditValue = FormatDateTime($this->fr_datetime->CurrentValue, 8);
		$this->fr_datetime->PlaceHolder = RemoveHtml($this->fr_datetime->caption());

		// app_status
		$this->app_status->EditAttrs["class"] = "form-control";
		$this->app_status->EditCustomAttributes = "";

		// da_comments
		$this->da_comments->EditAttrs["class"] = "form-control";
		$this->da_comments->EditCustomAttributes = "";
		$this->da_comments->EditValue = $this->da_comments->CurrentValue;
		$this->da_comments->PlaceHolder = RemoveHtml($this->da_comments->caption());

		// da_status
		$this->da_status->EditAttrs["class"] = "form-control";
		$this->da_status->EditCustomAttributes = "";

		// da_operator
		$this->da_operator->EditAttrs["class"] = "form-control";
		$this->da_operator->EditCustomAttributes = "";
		$this->da_operator->EditValue = $this->da_operator->CurrentValue;
		$this->da_operator->PlaceHolder = RemoveHtml($this->da_operator->caption());

		// da_datetime
		$this->da_datetime->EditAttrs["class"] = "form-control";
		$this->da_datetime->EditCustomAttributes = "";
		$this->da_datetime->EditValue = FormatDateTime($this->da_datetime->CurrentValue, 8);
		$this->da_datetime->PlaceHolder = RemoveHtml($this->da_datetime->caption());

		// req_chat_id
		$this->req_chat_id->EditAttrs["class"] = "form-control";
		$this->req_chat_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->req_chat_id->CurrentValue = HtmlDecode($this->req_chat_id->CurrentValue);
		$this->req_chat_id->EditValue = $this->req_chat_id->CurrentValue;
		$this->req_chat_id->PlaceHolder = RemoveHtml($this->req_chat_id->caption());

		// pd_operator
		$this->pd_operator->EditAttrs["class"] = "form-control";
		$this->pd_operator->EditCustomAttributes = "";
		$this->pd_operator->EditValue = $this->pd_operator->CurrentValue;
		$this->pd_operator->PlaceHolder = RemoveHtml($this->pd_operator->caption());

		// pd_comments
		$this->pd_comments->EditAttrs["class"] = "form-control";
		$this->pd_comments->EditCustomAttributes = "";
		$this->pd_comments->EditValue = $this->pd_comments->CurrentValue;
		$this->pd_comments->PlaceHolder = RemoveHtml($this->pd_comments->caption());

		// pd_datetime
		$this->pd_datetime->EditAttrs["class"] = "form-control";
		$this->pd_datetime->EditCustomAttributes = "";
		$this->pd_datetime->EditValue = FormatDateTime($this->pd_datetime->CurrentValue, 8);
		$this->pd_datetime->PlaceHolder = RemoveHtml($this->pd_datetime->caption());

		// d_upload
		$this->d_upload->EditAttrs["class"] = "form-control";
		$this->d_upload->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->d_upload->CurrentValue = HtmlDecode($this->d_upload->CurrentValue);
		$this->d_upload->EditValue = $this->d_upload->CurrentValue;
		$this->d_upload->PlaceHolder = RemoveHtml($this->d_upload->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->request_by);
					$doc->exportCaption($this->old_ref);
					$doc->exportCaption($this->upload);
					$doc->exportCaption($this->design);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->comments);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->po_id);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->request_by);
					$doc->exportCaption($this->old_ref);
					$doc->exportCaption($this->design);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->comments);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->request_by);
						$doc->exportField($this->old_ref);
						$doc->exportField($this->upload);
						$doc->exportField($this->design);
						$doc->exportField($this->color);
						$doc->exportField($this->size);
						$doc->exportField($this->quantity);
						$doc->exportField($this->comments);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->po_id);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->request_by);
						$doc->exportField($this->old_ref);
						$doc->exportField($this->design);
						$doc->exportField($this->color);
						$doc->exportField($this->size);
						$doc->exportField($this->quantity);
						$doc->exportField($this->comments);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'upload') {
			$fldName = "upload";
			$fileNameFld = "upload";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>