<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class sample_req_cart_add extends sample_req_cart
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'sample_req_cart';

	// Page object name
	public $PageObjName = "sample_req_cart_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (sample_req_cart)
		if (!isset($GLOBALS["sample_req_cart"]) || get_class($GLOBALS["sample_req_cart"]) == PROJECT_NAMESPACE . "sample_req_cart") {
			$GLOBALS["sample_req_cart"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["sample_req_cart"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $sample_req_cart;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($sample_req_cart);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "sample_req_cartview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("sample_req_cartlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->request_by->setVisibility();
		$this->old_ref->setVisibility();
		$this->upload->setVisibility();
		$this->design->setVisibility();
		$this->color->setVisibility();
		$this->size->setVisibility();
		$this->quantity->setVisibility();
		$this->comments->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->po_id->Visible = FALSE;
		$this->status->Visible = FALSE;
		$this->shipping_mode->Visible = FALSE;
		$this->delivery_week->Visible = FALSE;
		$this->purpose->Visible = FALSE;
		$this->label->Visible = FALSE;
		$this->ssd->Visible = FALSE;
		$this->shipping_address->Visible = FALSE;
		$this->shipping_address_2->Visible = FALSE;
		$this->company_id->Visible = FALSE;
		$this->partner_id->Visible = FALSE;
		$this->sp_remarks->Visible = FALSE;
		$this->pp_remarks->Visible = FALSE;
		$this->po_remarks->Visible = FALSE;
		$this->price->Visible = FALSE;
		$this->declaration->Visible = FALSE;
		$this->remarks->Visible = FALSE;
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->app_operator->Visible = FALSE;
		$this->app_datetime->Visible = FALSE;
		$this->po_operator->Visible = FALSE;
		$this->po_datetime->Visible = FALSE;
		$this->bom->Visible = FALSE;
		$this->dispatch->Visible = FALSE;
		$this->pd_upload->Visible = FALSE;
		$this->d_operator->Visible = FALSE;
		$this->d_datetime->Visible = FALSE;
		$this->r_comments->Visible = FALSE;
		$this->r_operator->Visible = FALSE;
		$this->r_datetime->Visible = FALSE;
		$this->f_yn->Visible = FALSE;
		$this->feedback->Visible = FALSE;
		$this->f_upload->Visible = FALSE;
		$this->f_operator->Visible = FALSE;
		$this->f_datetime->Visible = FALSE;
		$this->r_text->Visible = FALSE;
		$this->_barcode->Visible = FALSE;
		$this->fr_operator->Visible = FALSE;
		$this->fr_datetime->Visible = FALSE;
		$this->app_status->Visible = FALSE;
		$this->da_comments->Visible = FALSE;
		$this->da_status->Visible = FALSE;
		$this->da_operator->Visible = FALSE;
		$this->da_datetime->Visible = FALSE;
		$this->req_chat_id->Visible = FALSE;
		$this->pd_operator->Visible = FALSE;
		$this->pd_comments->Visible = FALSE;
		$this->pd_datetime->Visible = FALSE;
		$this->d_upload->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->request_by);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->delivery_week);
		$this->setupLookupOptions($this->purpose);
		$this->setupLookupOptions($this->label);
		$this->setupLookupOptions($this->shipping_address);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->a_operator);
		$this->setupLookupOptions($this->app_status);
		$this->setupLookupOptions($this->da_status);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("sample_req_cartlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = "sample_req_cartlist.php";
					if (GetPageName($returnUrl) == "sample_req_cartlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "sample_req_cartview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->upload->Upload->Index = $CurrentForm->Index;
		$this->upload->Upload->uploadFile();
		$this->upload->CurrentValue = $this->upload->Upload->FileName;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->request_by->CurrentValue = ((isset($_COOKIE["buye"]))? $_COOKIE["buye"]:CurrentUserID());
		$this->old_ref->CurrentValue = NULL;
		$this->old_ref->OldValue = $this->old_ref->CurrentValue;
		$this->upload->Upload->DbValue = NULL;
		$this->upload->OldValue = $this->upload->Upload->DbValue;
		$this->upload->CurrentValue = NULL; // Clear file related field
		$this->design->CurrentValue = NULL;
		$this->design->OldValue = $this->design->CurrentValue;
		$this->color->CurrentValue = NULL;
		$this->color->OldValue = $this->color->CurrentValue;
		$this->size->CurrentValue = NULL;
		$this->size->OldValue = $this->size->CurrentValue;
		$this->quantity->CurrentValue = NULL;
		$this->quantity->OldValue = $this->quantity->CurrentValue;
		$this->comments->CurrentValue = NULL;
		$this->comments->OldValue = $this->comments->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->po_id->CurrentValue = NULL;
		$this->po_id->OldValue = $this->po_id->CurrentValue;
		$this->status->CurrentValue = NULL;
		$this->status->OldValue = $this->status->CurrentValue;
		$this->shipping_mode->CurrentValue = NULL;
		$this->shipping_mode->OldValue = $this->shipping_mode->CurrentValue;
		$this->delivery_week->CurrentValue = NULL;
		$this->delivery_week->OldValue = $this->delivery_week->CurrentValue;
		$this->purpose->CurrentValue = NULL;
		$this->purpose->OldValue = $this->purpose->CurrentValue;
		$this->label->CurrentValue = NULL;
		$this->label->OldValue = $this->label->CurrentValue;
		$this->ssd->CurrentValue = NULL;
		$this->ssd->OldValue = $this->ssd->CurrentValue;
		$this->shipping_address->CurrentValue = NULL;
		$this->shipping_address->OldValue = $this->shipping_address->CurrentValue;
		$this->shipping_address_2->CurrentValue = NULL;
		$this->shipping_address_2->OldValue = $this->shipping_address_2->CurrentValue;
		$this->company_id->CurrentValue = (isset($_GET["CID"]))? $_GET["CID"]:User_Company_ID();
		$this->partner_id->CurrentValue = (isset($_GET["PID"]))? $_GET["PID"]:'';
		$this->sp_remarks->CurrentValue = NULL;
		$this->sp_remarks->OldValue = $this->sp_remarks->CurrentValue;
		$this->pp_remarks->CurrentValue = NULL;
		$this->pp_remarks->OldValue = $this->pp_remarks->CurrentValue;
		$this->po_remarks->CurrentValue = NULL;
		$this->po_remarks->OldValue = $this->po_remarks->CurrentValue;
		$this->price->CurrentValue = NULL;
		$this->price->OldValue = $this->price->CurrentValue;
		$this->declaration->CurrentValue = NULL;
		$this->declaration->OldValue = $this->declaration->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->a_operator->CurrentValue = NULL;
		$this->a_operator->OldValue = $this->a_operator->CurrentValue;
		$this->a_datetime->CurrentValue = NULL;
		$this->a_datetime->OldValue = $this->a_datetime->CurrentValue;
		$this->app_operator->CurrentValue = NULL;
		$this->app_operator->OldValue = $this->app_operator->CurrentValue;
		$this->app_datetime->CurrentValue = NULL;
		$this->app_datetime->OldValue = $this->app_datetime->CurrentValue;
		$this->po_operator->CurrentValue = NULL;
		$this->po_operator->OldValue = $this->po_operator->CurrentValue;
		$this->po_datetime->CurrentValue = NULL;
		$this->po_datetime->OldValue = $this->po_datetime->CurrentValue;
		$this->bom->CurrentValue = "Please Update Product Specification i.e. BOM, CBM, Weight/SQM, Price, MOQ etc";
		$this->dispatch->CurrentValue = NULL;
		$this->dispatch->OldValue = $this->dispatch->CurrentValue;
		$this->pd_upload->CurrentValue = NULL;
		$this->pd_upload->OldValue = $this->pd_upload->CurrentValue;
		$this->d_operator->CurrentValue = NULL;
		$this->d_operator->OldValue = $this->d_operator->CurrentValue;
		$this->d_datetime->CurrentValue = NULL;
		$this->d_datetime->OldValue = $this->d_datetime->CurrentValue;
		$this->r_comments->CurrentValue = NULL;
		$this->r_comments->OldValue = $this->r_comments->CurrentValue;
		$this->r_operator->CurrentValue = NULL;
		$this->r_operator->OldValue = $this->r_operator->CurrentValue;
		$this->r_datetime->CurrentValue = NULL;
		$this->r_datetime->OldValue = $this->r_datetime->CurrentValue;
		$this->f_yn->CurrentValue = NULL;
		$this->f_yn->OldValue = $this->f_yn->CurrentValue;
		$this->feedback->CurrentValue = NULL;
		$this->feedback->OldValue = $this->feedback->CurrentValue;
		$this->f_upload->CurrentValue = NULL;
		$this->f_upload->OldValue = $this->f_upload->CurrentValue;
		$this->f_operator->CurrentValue = NULL;
		$this->f_operator->OldValue = $this->f_operator->CurrentValue;
		$this->f_datetime->CurrentValue = NULL;
		$this->f_datetime->OldValue = $this->f_datetime->CurrentValue;
		$this->r_text->CurrentValue = NULL;
		$this->r_text->OldValue = $this->r_text->CurrentValue;
		$this->_barcode->CurrentValue = NULL;
		$this->_barcode->OldValue = $this->_barcode->CurrentValue;
		$this->fr_operator->CurrentValue = NULL;
		$this->fr_operator->OldValue = $this->fr_operator->CurrentValue;
		$this->fr_datetime->CurrentValue = NULL;
		$this->fr_datetime->OldValue = $this->fr_datetime->CurrentValue;
		$this->app_status->CurrentValue = 0;
		$this->da_comments->CurrentValue = NULL;
		$this->da_comments->OldValue = $this->da_comments->CurrentValue;
		$this->da_status->CurrentValue = 0;
		$this->da_operator->CurrentValue = NULL;
		$this->da_operator->OldValue = $this->da_operator->CurrentValue;
		$this->da_datetime->CurrentValue = NULL;
		$this->da_datetime->OldValue = $this->da_datetime->CurrentValue;
		$this->req_chat_id->CurrentValue = NULL;
		$this->req_chat_id->OldValue = $this->req_chat_id->CurrentValue;
		$this->pd_operator->CurrentValue = NULL;
		$this->pd_operator->OldValue = $this->pd_operator->CurrentValue;
		$this->pd_comments->CurrentValue = NULL;
		$this->pd_comments->OldValue = $this->pd_comments->CurrentValue;
		$this->pd_datetime->CurrentValue = NULL;
		$this->pd_datetime->OldValue = $this->pd_datetime->CurrentValue;
		$this->d_upload->CurrentValue = NULL;
		$this->d_upload->OldValue = $this->d_upload->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'request_by' first before field var 'x_request_by'
		$val = $CurrentForm->hasValue("request_by") ? $CurrentForm->getValue("request_by") : $CurrentForm->getValue("x_request_by");
		if (!$this->request_by->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->request_by->Visible = FALSE; // Disable update for API request
			else
				$this->request_by->setFormValue($val);
		}

		// Check field name 'old_ref' first before field var 'x_old_ref'
		$val = $CurrentForm->hasValue("old_ref") ? $CurrentForm->getValue("old_ref") : $CurrentForm->getValue("x_old_ref");
		if (!$this->old_ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->old_ref->Visible = FALSE; // Disable update for API request
			else
				$this->old_ref->setFormValue($val);
		}

		// Check field name 'design' first before field var 'x_design'
		$val = $CurrentForm->hasValue("design") ? $CurrentForm->getValue("design") : $CurrentForm->getValue("x_design");
		if (!$this->design->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->design->Visible = FALSE; // Disable update for API request
			else
				$this->design->setFormValue($val);
		}

		// Check field name 'color' first before field var 'x_color'
		$val = $CurrentForm->hasValue("color") ? $CurrentForm->getValue("color") : $CurrentForm->getValue("x_color");
		if (!$this->color->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->color->Visible = FALSE; // Disable update for API request
			else
				$this->color->setFormValue($val);
		}

		// Check field name 'size' first before field var 'x_size'
		$val = $CurrentForm->hasValue("size") ? $CurrentForm->getValue("size") : $CurrentForm->getValue("x_size");
		if (!$this->size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->size->Visible = FALSE; // Disable update for API request
			else
				$this->size->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'comments' first before field var 'x_comments'
		$val = $CurrentForm->hasValue("comments") ? $CurrentForm->getValue("comments") : $CurrentForm->getValue("x_comments");
		if (!$this->comments->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->comments->Visible = FALSE; // Disable update for API request
			else
				$this->comments->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->request_by->CurrentValue = $this->request_by->FormValue;
		$this->old_ref->CurrentValue = $this->old_ref->FormValue;
		$this->design->CurrentValue = $this->design->FormValue;
		$this->color->CurrentValue = $this->color->FormValue;
		$this->size->CurrentValue = $this->size->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->comments->CurrentValue = $this->comments->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->request_by->setDbValue($row['request_by']);
		$this->old_ref->setDbValue($row['old_ref']);
		$this->upload->Upload->DbValue = $row['upload'];
		$this->upload->setDbValue($this->upload->Upload->DbValue);
		$this->design->setDbValue($row['design']);
		$this->color->setDbValue($row['color']);
		$this->size->setDbValue($row['size']);
		$this->quantity->setDbValue($row['quantity']);
		$this->comments->setDbValue($row['comments']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->po_id->setDbValue($row['po_id']);
		$this->status->setDbValue($row['status']);
		$this->shipping_mode->setDbValue($row['shipping_mode']);
		$this->delivery_week->setDbValue($row['delivery_week']);
		$this->purpose->setDbValue($row['purpose']);
		$this->label->setDbValue($row['label']);
		$this->ssd->setDbValue($row['ssd']);
		$this->shipping_address->setDbValue($row['shipping_address']);
		$this->shipping_address_2->setDbValue($row['shipping_address_2']);
		$this->company_id->setDbValue($row['company_id']);
		$this->partner_id->setDbValue($row['partner_id']);
		if (array_key_exists('EV__partner_id', $rs->fields)) {
			$this->partner_id->VirtualValue = $rs->fields('EV__partner_id'); // Set up virtual field value
		} else {
			$this->partner_id->VirtualValue = ""; // Clear value
		}
		$this->sp_remarks->setDbValue($row['sp_remarks']);
		$this->pp_remarks->setDbValue($row['pp_remarks']);
		$this->po_remarks->setDbValue($row['po_remarks']);
		$this->price->setDbValue($row['price']);
		$this->declaration->setDbValue($row['declaration']);
		$this->remarks->setDbValue($row['remarks']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->app_operator->setDbValue($row['app_operator']);
		$this->app_datetime->setDbValue($row['app_datetime']);
		$this->po_operator->setDbValue($row['po_operator']);
		$this->po_datetime->setDbValue($row['po_datetime']);
		$this->bom->setDbValue($row['bom']);
		$this->dispatch->setDbValue($row['dispatch']);
		$this->pd_upload->setDbValue($row['pd_upload']);
		$this->d_operator->setDbValue($row['d_operator']);
		$this->d_datetime->setDbValue($row['d_datetime']);
		$this->r_comments->setDbValue($row['r_comments']);
		$this->r_operator->setDbValue($row['r_operator']);
		$this->r_datetime->setDbValue($row['r_datetime']);
		$this->f_yn->setDbValue($row['f_yn']);
		$this->feedback->setDbValue($row['feedback']);
		$this->f_upload->setDbValue($row['f_upload']);
		$this->f_operator->setDbValue($row['f_operator']);
		$this->f_datetime->setDbValue($row['f_datetime']);
		$this->r_text->setDbValue($row['r_text']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->fr_operator->setDbValue($row['fr_operator']);
		$this->fr_datetime->setDbValue($row['fr_datetime']);
		$this->app_status->setDbValue($row['app_status']);
		$this->da_comments->setDbValue($row['da_comments']);
		$this->da_status->setDbValue($row['da_status']);
		$this->da_operator->setDbValue($row['da_operator']);
		$this->da_datetime->setDbValue($row['da_datetime']);
		$this->req_chat_id->setDbValue($row['req_chat_id']);
		$this->pd_operator->setDbValue($row['pd_operator']);
		$this->pd_comments->setDbValue($row['pd_comments']);
		$this->pd_datetime->setDbValue($row['pd_datetime']);
		$this->d_upload->setDbValue($row['d_upload']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['request_by'] = $this->request_by->CurrentValue;
		$row['old_ref'] = $this->old_ref->CurrentValue;
		$row['upload'] = $this->upload->Upload->DbValue;
		$row['design'] = $this->design->CurrentValue;
		$row['color'] = $this->color->CurrentValue;
		$row['size'] = $this->size->CurrentValue;
		$row['quantity'] = $this->quantity->CurrentValue;
		$row['comments'] = $this->comments->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['po_id'] = $this->po_id->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['shipping_mode'] = $this->shipping_mode->CurrentValue;
		$row['delivery_week'] = $this->delivery_week->CurrentValue;
		$row['purpose'] = $this->purpose->CurrentValue;
		$row['label'] = $this->label->CurrentValue;
		$row['ssd'] = $this->ssd->CurrentValue;
		$row['shipping_address'] = $this->shipping_address->CurrentValue;
		$row['shipping_address_2'] = $this->shipping_address_2->CurrentValue;
		$row['company_id'] = $this->company_id->CurrentValue;
		$row['partner_id'] = $this->partner_id->CurrentValue;
		$row['sp_remarks'] = $this->sp_remarks->CurrentValue;
		$row['pp_remarks'] = $this->pp_remarks->CurrentValue;
		$row['po_remarks'] = $this->po_remarks->CurrentValue;
		$row['price'] = $this->price->CurrentValue;
		$row['declaration'] = $this->declaration->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['a_operator'] = $this->a_operator->CurrentValue;
		$row['a_datetime'] = $this->a_datetime->CurrentValue;
		$row['app_operator'] = $this->app_operator->CurrentValue;
		$row['app_datetime'] = $this->app_datetime->CurrentValue;
		$row['po_operator'] = $this->po_operator->CurrentValue;
		$row['po_datetime'] = $this->po_datetime->CurrentValue;
		$row['bom'] = $this->bom->CurrentValue;
		$row['dispatch'] = $this->dispatch->CurrentValue;
		$row['pd_upload'] = $this->pd_upload->CurrentValue;
		$row['d_operator'] = $this->d_operator->CurrentValue;
		$row['d_datetime'] = $this->d_datetime->CurrentValue;
		$row['r_comments'] = $this->r_comments->CurrentValue;
		$row['r_operator'] = $this->r_operator->CurrentValue;
		$row['r_datetime'] = $this->r_datetime->CurrentValue;
		$row['f_yn'] = $this->f_yn->CurrentValue;
		$row['feedback'] = $this->feedback->CurrentValue;
		$row['f_upload'] = $this->f_upload->CurrentValue;
		$row['f_operator'] = $this->f_operator->CurrentValue;
		$row['f_datetime'] = $this->f_datetime->CurrentValue;
		$row['r_text'] = $this->r_text->CurrentValue;
		$row['barcode'] = $this->_barcode->CurrentValue;
		$row['fr_operator'] = $this->fr_operator->CurrentValue;
		$row['fr_datetime'] = $this->fr_datetime->CurrentValue;
		$row['app_status'] = $this->app_status->CurrentValue;
		$row['da_comments'] = $this->da_comments->CurrentValue;
		$row['da_status'] = $this->da_status->CurrentValue;
		$row['da_operator'] = $this->da_operator->CurrentValue;
		$row['da_datetime'] = $this->da_datetime->CurrentValue;
		$row['req_chat_id'] = $this->req_chat_id->CurrentValue;
		$row['pd_operator'] = $this->pd_operator->CurrentValue;
		$row['pd_comments'] = $this->pd_comments->CurrentValue;
		$row['pd_datetime'] = $this->pd_datetime->CurrentValue;
		$row['d_upload'] = $this->d_upload->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// request_by
		// old_ref
		// upload
		// design
		// color
		// size
		// quantity
		// comments
		// operator
		// datetime
		// po_id
		// status
		// shipping_mode
		// delivery_week
		// purpose
		// label
		// ssd
		// shipping_address
		// shipping_address_2
		// company_id
		// partner_id
		// sp_remarks
		// pp_remarks
		// po_remarks
		// price
		// declaration
		// remarks
		// a_operator
		// a_datetime
		// app_operator
		// app_datetime
		// po_operator
		// po_datetime
		// bom
		// dispatch
		// pd_upload
		// d_operator
		// d_datetime
		// r_comments
		// r_operator
		// r_datetime
		// f_yn
		// feedback
		// f_upload
		// f_operator
		// f_datetime
		// r_text
		// barcode
		// fr_operator
		// fr_datetime
		// app_status
		// da_comments
		// da_status
		// da_operator
		// da_datetime
		// req_chat_id
		// pd_operator
		// pd_comments
		// pd_datetime
		// d_upload

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// request_by
			$curVal = strval($this->request_by->CurrentValue);
			if ($curVal <> "") {
				$this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
				if ($this->request_by->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((CurrentUserLevel() == 0) || (CurrentUserLevel() == 1002)) ? "((`userlevel`= 0) || (`userlevel` = 1002)) and `activated` = 1" : "`activated` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->request_by->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->request_by->ViewValue = $this->request_by->CurrentValue;
					}
				}
			} else {
				$this->request_by->ViewValue = NULL;
			}
			$this->request_by->ViewCustomAttributes = "";

			// old_ref
			$this->old_ref->ViewValue = $this->old_ref->CurrentValue;
			$this->old_ref->ViewCustomAttributes = "";

			// upload
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->ViewValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->ViewValue = "";
			}
			$this->upload->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// comments
			$this->comments->ViewValue = $this->comments->CurrentValue;
			$this->comments->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// request_by
			$this->request_by->LinkCustomAttributes = "";
			$this->request_by->HrefValue = "";
			$this->request_by->TooltipValue = "";

			// old_ref
			$this->old_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->old_ref->CurrentValue)) {
				$this->old_ref->HrefValue = "sample_req_cart_statuslist.php?x__barcode=" . $this->old_ref->CurrentValue . "&z__barcode=LIKE"; // Add prefix/suffix
				$this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
			} else {
				$this->old_ref->HrefValue = "";
			}
			$this->old_ref->TooltipValue = "";

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = "%u"; // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
			$this->upload->TooltipValue = "";
			if ($this->upload->UseColorbox) {
				if (EmptyValue($this->upload->TooltipValue))
					$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->upload->LinkAttrs["data-rel"] = "sample_req_cart_x_upload";
				AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
			}

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// comments
			$this->comments->LinkCustomAttributes = "";
			$this->comments->HrefValue = "";
			$this->comments->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// request_by
			$this->request_by->EditAttrs["class"] = "form-control";
			$this->request_by->EditCustomAttributes = "";
			$curVal = trim(strval($this->request_by->CurrentValue));
			if ($curVal <> "")
				$this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
			else
				$this->request_by->ViewValue = $this->request_by->Lookup !== NULL && is_array($this->request_by->Lookup->Options) ? $curVal : NULL;
			if ($this->request_by->ViewValue !== NULL) { // Load from cache
				$this->request_by->EditValue = array_values($this->request_by->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->request_by->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return ((CurrentUserLevel() == 0) || (CurrentUserLevel() == 1002)) ? "((`userlevel`= 0) || (`userlevel` = 1002)) and `activated` = 1" : "`activated` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->request_by->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->request_by->EditValue = $arwrk;
			}

			// old_ref
			$this->old_ref->EditAttrs["class"] = "form-control";
			$this->old_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->old_ref->CurrentValue = HtmlDecode($this->old_ref->CurrentValue);
			$this->old_ref->EditValue = HtmlEncode($this->old_ref->CurrentValue);
			$this->old_ref->PlaceHolder = RemoveHtml($this->old_ref->caption());

			// upload
			$this->upload->EditAttrs["class"] = "form-control";
			$this->upload->EditCustomAttributes = "";
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->EditValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->EditValue = "";
			}
			if (!EmptyValue($this->upload->CurrentValue))
					$this->upload->Upload->FileName = $this->upload->CurrentValue;
			if (($this->isShow() || $this->isCopy()) && !$this->EventCancelled)
				RenderUploadField($this->upload);

			// design
			$this->design->EditAttrs["class"] = "form-control";
			$this->design->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->design->CurrentValue = HtmlDecode($this->design->CurrentValue);
			$this->design->EditValue = HtmlEncode($this->design->CurrentValue);
			$this->design->PlaceHolder = RemoveHtml($this->design->caption());

			// color
			$this->color->EditAttrs["class"] = "form-control";
			$this->color->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->color->CurrentValue = HtmlDecode($this->color->CurrentValue);
			$this->color->EditValue = HtmlEncode($this->color->CurrentValue);
			$this->color->PlaceHolder = RemoveHtml($this->color->caption());

			// size
			$this->size->EditAttrs["class"] = "form-control";
			$this->size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size->CurrentValue = HtmlDecode($this->size->CurrentValue);
			$this->size->EditValue = HtmlEncode($this->size->CurrentValue);
			$this->size->PlaceHolder = RemoveHtml($this->size->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// comments
			$this->comments->EditAttrs["class"] = "form-control";
			$this->comments->EditCustomAttributes = "";
			$this->comments->EditValue = HtmlEncode($this->comments->CurrentValue);
			$this->comments->PlaceHolder = RemoveHtml($this->comments->caption());

			// operator
			// datetime
			// Add refer script
			// request_by

			$this->request_by->LinkCustomAttributes = "";
			$this->request_by->HrefValue = "";

			// old_ref
			$this->old_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->old_ref->CurrentValue)) {
				$this->old_ref->HrefValue = "sample_req_cart_statuslist.php?x__barcode=" . $this->old_ref->CurrentValue . "&z__barcode=LIKE"; // Add prefix/suffix
				$this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
			} else {
				$this->old_ref->HrefValue = "";
			}

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = "%u"; // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// comments
			$this->comments->LinkCustomAttributes = "";
			$this->comments->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->request_by->Required) {
			if (!$this->request_by->IsDetailKey && $this->request_by->FormValue != NULL && $this->request_by->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->request_by->caption(), $this->request_by->RequiredErrorMessage));
			}
		}
		if ($this->old_ref->Required) {
			if (!$this->old_ref->IsDetailKey && $this->old_ref->FormValue != NULL && $this->old_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->old_ref->caption(), $this->old_ref->RequiredErrorMessage));
			}
		}
		if ($this->upload->Required) {
			if ($this->upload->Upload->FileName == "" && !$this->upload->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->upload->caption(), $this->upload->RequiredErrorMessage));
			}
		}
		if ($this->design->Required) {
			if (!$this->design->IsDetailKey && $this->design->FormValue != NULL && $this->design->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->design->caption(), $this->design->RequiredErrorMessage));
			}
		}
		if ($this->color->Required) {
			if (!$this->color->IsDetailKey && $this->color->FormValue != NULL && $this->color->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->color->caption(), $this->color->RequiredErrorMessage));
			}
		}
		if ($this->size->Required) {
			if (!$this->size->IsDetailKey && $this->size->FormValue != NULL && $this->size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size->caption(), $this->size->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->comments->Required) {
			if (!$this->comments->IsDetailKey && $this->comments->FormValue != NULL && $this->comments->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->comments->caption(), $this->comments->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->po_id->Required) {
			if (!$this->po_id->IsDetailKey && $this->po_id->FormValue != NULL && $this->po_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_id->caption(), $this->po_id->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->shipping_mode->Required) {
			if (!$this->shipping_mode->IsDetailKey && $this->shipping_mode->FormValue != NULL && $this->shipping_mode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_mode->caption(), $this->shipping_mode->RequiredErrorMessage));
			}
		}
		if ($this->delivery_week->Required) {
			if (!$this->delivery_week->IsDetailKey && $this->delivery_week->FormValue != NULL && $this->delivery_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_week->caption(), $this->delivery_week->RequiredErrorMessage));
			}
		}
		if ($this->purpose->Required) {
			if (!$this->purpose->IsDetailKey && $this->purpose->FormValue != NULL && $this->purpose->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->purpose->caption(), $this->purpose->RequiredErrorMessage));
			}
		}
		if ($this->label->Required) {
			if (!$this->label->IsDetailKey && $this->label->FormValue != NULL && $this->label->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->label->caption(), $this->label->RequiredErrorMessage));
			}
		}
		if ($this->ssd->Required) {
			if (!$this->ssd->IsDetailKey && $this->ssd->FormValue != NULL && $this->ssd->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ssd->caption(), $this->ssd->RequiredErrorMessage));
			}
		}
		if ($this->shipping_address->Required) {
			if (!$this->shipping_address->IsDetailKey && $this->shipping_address->FormValue != NULL && $this->shipping_address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_address->caption(), $this->shipping_address->RequiredErrorMessage));
			}
		}
		if ($this->shipping_address_2->Required) {
			if (!$this->shipping_address_2->IsDetailKey && $this->shipping_address_2->FormValue != NULL && $this->shipping_address_2->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_address_2->caption(), $this->shipping_address_2->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if ($this->partner_id->Required) {
			if (!$this->partner_id->IsDetailKey && $this->partner_id->FormValue != NULL && $this->partner_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
			}
		}
		if ($this->sp_remarks->Required) {
			if (!$this->sp_remarks->IsDetailKey && $this->sp_remarks->FormValue != NULL && $this->sp_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sp_remarks->caption(), $this->sp_remarks->RequiredErrorMessage));
			}
		}
		if ($this->pp_remarks->Required) {
			if (!$this->pp_remarks->IsDetailKey && $this->pp_remarks->FormValue != NULL && $this->pp_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_remarks->caption(), $this->pp_remarks->RequiredErrorMessage));
			}
		}
		if ($this->po_remarks->Required) {
			if (!$this->po_remarks->IsDetailKey && $this->po_remarks->FormValue != NULL && $this->po_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_remarks->caption(), $this->po_remarks->RequiredErrorMessage));
			}
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if ($this->declaration->Required) {
			if (!$this->declaration->IsDetailKey && $this->declaration->FormValue != NULL && $this->declaration->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->declaration->caption(), $this->declaration->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if ($this->a_datetime->Required) {
			if (!$this->a_datetime->IsDetailKey && $this->a_datetime->FormValue != NULL && $this->a_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_datetime->caption(), $this->a_datetime->RequiredErrorMessage));
			}
		}
		if ($this->app_operator->Required) {
			if (!$this->app_operator->IsDetailKey && $this->app_operator->FormValue != NULL && $this->app_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->app_operator->caption(), $this->app_operator->RequiredErrorMessage));
			}
		}
		if ($this->app_datetime->Required) {
			if (!$this->app_datetime->IsDetailKey && $this->app_datetime->FormValue != NULL && $this->app_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->app_datetime->caption(), $this->app_datetime->RequiredErrorMessage));
			}
		}
		if ($this->po_operator->Required) {
			if (!$this->po_operator->IsDetailKey && $this->po_operator->FormValue != NULL && $this->po_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_operator->caption(), $this->po_operator->RequiredErrorMessage));
			}
		}
		if ($this->po_datetime->Required) {
			if (!$this->po_datetime->IsDetailKey && $this->po_datetime->FormValue != NULL && $this->po_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_datetime->caption(), $this->po_datetime->RequiredErrorMessage));
			}
		}
		if ($this->bom->Required) {
			if (!$this->bom->IsDetailKey && $this->bom->FormValue != NULL && $this->bom->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bom->caption(), $this->bom->RequiredErrorMessage));
			}
		}
		if ($this->dispatch->Required) {
			if (!$this->dispatch->IsDetailKey && $this->dispatch->FormValue != NULL && $this->dispatch->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dispatch->caption(), $this->dispatch->RequiredErrorMessage));
			}
		}
		if ($this->pd_upload->Required) {
			if (!$this->pd_upload->IsDetailKey && $this->pd_upload->FormValue != NULL && $this->pd_upload->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pd_upload->caption(), $this->pd_upload->RequiredErrorMessage));
			}
		}
		if ($this->d_operator->Required) {
			if (!$this->d_operator->IsDetailKey && $this->d_operator->FormValue != NULL && $this->d_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_operator->caption(), $this->d_operator->RequiredErrorMessage));
			}
		}
		if ($this->d_datetime->Required) {
			if (!$this->d_datetime->IsDetailKey && $this->d_datetime->FormValue != NULL && $this->d_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_datetime->caption(), $this->d_datetime->RequiredErrorMessage));
			}
		}
		if ($this->r_comments->Required) {
			if (!$this->r_comments->IsDetailKey && $this->r_comments->FormValue != NULL && $this->r_comments->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_comments->caption(), $this->r_comments->RequiredErrorMessage));
			}
		}
		if ($this->r_operator->Required) {
			if (!$this->r_operator->IsDetailKey && $this->r_operator->FormValue != NULL && $this->r_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_operator->caption(), $this->r_operator->RequiredErrorMessage));
			}
		}
		if ($this->r_datetime->Required) {
			if (!$this->r_datetime->IsDetailKey && $this->r_datetime->FormValue != NULL && $this->r_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_datetime->caption(), $this->r_datetime->RequiredErrorMessage));
			}
		}
		if ($this->f_yn->Required) {
			if (!$this->f_yn->IsDetailKey && $this->f_yn->FormValue != NULL && $this->f_yn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->f_yn->caption(), $this->f_yn->RequiredErrorMessage));
			}
		}
		if ($this->feedback->Required) {
			if (!$this->feedback->IsDetailKey && $this->feedback->FormValue != NULL && $this->feedback->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->feedback->caption(), $this->feedback->RequiredErrorMessage));
			}
		}
		if ($this->f_upload->Required) {
			if (!$this->f_upload->IsDetailKey && $this->f_upload->FormValue != NULL && $this->f_upload->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->f_upload->caption(), $this->f_upload->RequiredErrorMessage));
			}
		}
		if ($this->f_operator->Required) {
			if (!$this->f_operator->IsDetailKey && $this->f_operator->FormValue != NULL && $this->f_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->f_operator->caption(), $this->f_operator->RequiredErrorMessage));
			}
		}
		if ($this->f_datetime->Required) {
			if (!$this->f_datetime->IsDetailKey && $this->f_datetime->FormValue != NULL && $this->f_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->f_datetime->caption(), $this->f_datetime->RequiredErrorMessage));
			}
		}
		if ($this->r_text->Required) {
			if (!$this->r_text->IsDetailKey && $this->r_text->FormValue != NULL && $this->r_text->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->r_text->caption(), $this->r_text->RequiredErrorMessage));
			}
		}
		if ($this->_barcode->Required) {
			if (!$this->_barcode->IsDetailKey && $this->_barcode->FormValue != NULL && $this->_barcode->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_barcode->caption(), $this->_barcode->RequiredErrorMessage));
			}
		}
		if ($this->fr_operator->Required) {
			if (!$this->fr_operator->IsDetailKey && $this->fr_operator->FormValue != NULL && $this->fr_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fr_operator->caption(), $this->fr_operator->RequiredErrorMessage));
			}
		}
		if ($this->fr_datetime->Required) {
			if (!$this->fr_datetime->IsDetailKey && $this->fr_datetime->FormValue != NULL && $this->fr_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fr_datetime->caption(), $this->fr_datetime->RequiredErrorMessage));
			}
		}
		if ($this->app_status->Required) {
			if (!$this->app_status->IsDetailKey && $this->app_status->FormValue != NULL && $this->app_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->app_status->caption(), $this->app_status->RequiredErrorMessage));
			}
		}
		if ($this->da_comments->Required) {
			if (!$this->da_comments->IsDetailKey && $this->da_comments->FormValue != NULL && $this->da_comments->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->da_comments->caption(), $this->da_comments->RequiredErrorMessage));
			}
		}
		if ($this->da_status->Required) {
			if (!$this->da_status->IsDetailKey && $this->da_status->FormValue != NULL && $this->da_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->da_status->caption(), $this->da_status->RequiredErrorMessage));
			}
		}
		if ($this->da_operator->Required) {
			if (!$this->da_operator->IsDetailKey && $this->da_operator->FormValue != NULL && $this->da_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->da_operator->caption(), $this->da_operator->RequiredErrorMessage));
			}
		}
		if ($this->da_datetime->Required) {
			if (!$this->da_datetime->IsDetailKey && $this->da_datetime->FormValue != NULL && $this->da_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->da_datetime->caption(), $this->da_datetime->RequiredErrorMessage));
			}
		}
		if ($this->req_chat_id->Required) {
			if (!$this->req_chat_id->IsDetailKey && $this->req_chat_id->FormValue != NULL && $this->req_chat_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_chat_id->caption(), $this->req_chat_id->RequiredErrorMessage));
			}
		}
		if ($this->pd_operator->Required) {
			if (!$this->pd_operator->IsDetailKey && $this->pd_operator->FormValue != NULL && $this->pd_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pd_operator->caption(), $this->pd_operator->RequiredErrorMessage));
			}
		}
		if ($this->pd_comments->Required) {
			if (!$this->pd_comments->IsDetailKey && $this->pd_comments->FormValue != NULL && $this->pd_comments->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pd_comments->caption(), $this->pd_comments->RequiredErrorMessage));
			}
		}
		if ($this->pd_datetime->Required) {
			if (!$this->pd_datetime->IsDetailKey && $this->pd_datetime->FormValue != NULL && $this->pd_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pd_datetime->caption(), $this->pd_datetime->RequiredErrorMessage));
			}
		}
		if ($this->d_upload->Required) {
			if (!$this->d_upload->IsDetailKey && $this->d_upload->FormValue != NULL && $this->d_upload->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_upload->caption(), $this->d_upload->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->upload->OldUploadPath = 'product_images/o/sample_cart/';
			$this->upload->UploadPath = $this->upload->OldUploadPath;
		}
		$rsnew = [];

		// request_by
		$this->request_by->setDbValueDef($rsnew, $this->request_by->CurrentValue, 0, FALSE);

		// old_ref
		$this->old_ref->setDbValueDef($rsnew, $this->old_ref->CurrentValue, NULL, FALSE);

		// upload
		if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
			$this->upload->Upload->DbValue = ""; // No need to delete old file
			if ($this->upload->Upload->FileName == "") {
				$rsnew['upload'] = NULL;
			} else {
				if ($rsold && $rsold->fields['upload'] <> "" && $this->upload->Upload->FileName <> "") {
					$oldFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsold->fields['upload']);
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->upload->Upload->FileName);
					$newFileCount = count($newFiles);
					for ($i = 0; $i < $newFileCount; $i++) {
						if ($newFiles[$i] <> "" && in_array($newFiles[$i], $oldFiles)) {
							$tempFile = UniqueFilename($this->upload->physicalUploadPath(), $newFiles[$i]);
							rename(UploadTempPath($this->upload, $this->upload->Upload->Index) . $newFiles[$i], UploadTempPath($this->upload, $this->upload->Upload->Index) . $tempFile);
							$newFiles[$i] = $tempFile;
						}
					}
					$this->upload->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				}
				$rsnew['upload'] = $this->upload->Upload->FileName;
			}
			$this->upload->ImageWidth = 640; // Resize width
			$this->upload->ImageHeight = 640; // Resize height
		}

		// design
		$this->design->setDbValueDef($rsnew, $this->design->CurrentValue, "", strval($this->design->CurrentValue) == "");

		// color
		$this->color->setDbValueDef($rsnew, $this->color->CurrentValue, "", strval($this->color->CurrentValue) == "");

		// size
		$this->size->setDbValueDef($rsnew, $this->size->CurrentValue, "", strval($this->size->CurrentValue) == "");

		// quantity
		$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, 0, strval($this->quantity->CurrentValue) == "");

		// comments
		$this->comments->setDbValueDef($rsnew, $this->comments->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;
		if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			$oldFiles = EmptyValue($this->upload->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->upload->Upload->DbValue));
			if (!EmptyValue($this->upload->Upload->FileName)) {
				$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->upload->Upload->FileName));
				$NewFileCount = count($newFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					if ($newFiles[$i] <> "") {
						$file = $newFiles[$i];
						if (file_exists(UploadTempPath($this->upload, $this->upload->Upload->Index) . $file)) {
							if (DELETE_UPLOADED_FILES) {
								$oldFileFound = FALSE;
								$oldFileCount = count($oldFiles);
								for ($j = 0; $j < $oldFileCount; $j++) {
									$oldFile = $oldFiles[$j];
									if ($oldFile == $file) { // Old file found, no need to delete anymore
										unset($oldFiles[$j]);
										$oldFileFound = TRUE;
										break;
									}
								}
								if ($oldFileFound) // No need to check if file exists further
									continue;
							}
							$file1 = UniqueFilename($this->upload->physicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(UploadTempPath($this->upload, $this->upload->Upload->Index) . $file1) || file_exists($this->upload->physicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = UniqueFilename($this->upload->physicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(UploadTempPath($this->upload, $this->upload->Upload->Index) . $file, UploadTempPath($this->upload, $this->upload->Upload->Index) . $file1);
								$newFiles[$i] = $file1;
							}
						}
					}
				}
				$this->upload->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
				$this->upload->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				$this->upload->setDbValueDef($rsnew, $this->upload->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
				if ($this->upload->Visible && !$this->upload->Upload->KeepFile) {
					$oldFiles = EmptyValue($this->upload->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->upload->Upload->DbValue));
					if (!EmptyValue($this->upload->Upload->FileName)) {
						$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->upload->Upload->FileName);
						$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['upload']);
						$newFileCount = count($newFiles);
						for ($i = 0; $i < $newFileCount; $i++) {
							if ($newFiles[$i] <> "") {
								$file = UploadTempPath($this->upload, $this->upload->Upload->Index) . $newFiles[$i];
								if (file_exists($file)) {
									if (@$newFiles2[$i] <> "") // Use correct file name
										$newFiles[$i] = $newFiles2[$i];
									if (!$this->upload->Upload->resizeAndSaveToFile($this->upload->ImageWidth, $this->upload->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
										$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$newFiles = array();
					}
					if (DELETE_UPLOADED_FILES) {
						foreach ($oldFiles as $oldFile) {
							if ($oldFile <> "" && !in_array($oldFile, $newFiles))
								@unlink($this->upload->oldPhysicalUploadPath() . $oldFile);
						}
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// upload
		if ($this->upload->Upload->FileToken <> "")
			CleanUploadTempPath($this->upload->Upload->FileToken, $this->upload->Upload->Index);
		else
			CleanUploadTempPath($this->upload, $this->upload->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("sample_req_cartlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_request_by":
					$lookupFilter = function() {
						return ((CurrentUserLevel() == 0) || (CurrentUserLevel() == 1002)) ? "((`userlevel`= 0) || (`userlevel` = 1002)) and `activated` = 1" : "`activated` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_delivery_week":
					$lookupFilter = function() {
						return (CurrentPageID() == "add" || CurrentPageID() == "addopt") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_purpose":
					$lookupFilter = function() {
						return "`grp`=3 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_label":
					$lookupFilter = function() {
						return "`grp`=3 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_company_id":
					$lookupFilter = function() {
						return User_Company_ID() == 0 ? "`status`=1 and `partner_type`=2" : "id= ".  User_Company_ID() . "  and `partner_type`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_app_status":
					$lookupFilter = function() {
						return "`grp` = 6 and `status` = 1 and (`id` = 602 || `id` = 609)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_da_status":
					$lookupFilter = function() {
						return "`grp` = 7 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_request_by":
							break;
						case "x_operator":
							break;
						case "x_status":
							break;
						case "x_delivery_week":
							break;
						case "x_purpose":
							break;
						case "x_label":
							break;
						case "x_shipping_address":
							break;
						case "x_company_id":
							break;
						case "x_partner_id":
							break;
						case "x_a_operator":
							break;
						case "x_app_status":
							break;
						case "x_da_status":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'sample_req_cart');		
		IF (CurrentUserLevel() <= 0)
		{
		$this->request_by->ReadOnly = True;
		}
		else
		{
		$this->request_by->ReadOnly = False;
		}
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>