<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for sample_req_cart_auth
 */
class sample_req_cart_auth extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $datetime;
	public $r_text;
	public $old_ref;
	public $status;
	public $request_by;
	public $company_id;
	public $partner_id;
	public $upload;
	public $req_chat_id;
	public $operator;
	public $design;
	public $color;
	public $size;
	public $quantity;
	public $shipping_mode;
	public $delivery_week;
	public $purpose;
	public $label;
	public $ssd;
	public $shipping_address_2;
	public $remarks;
	public $sp_remarks;
	public $a_operator;
	public $a_datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'sample_req_cart_auth';
		$this->TableName = 'sample_req_cart_auth';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`sample_req_cart_auth`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// datetime
		$this->datetime = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 2, "DB"), 135, 2, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Required = TRUE; // Required field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// r_text
		$this->r_text = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_r_text', 'r_text', '`r_text`', '`r_text`', 201, -1, FALSE, '`r_text`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->r_text->Sortable = TRUE; // Allow sort
		$this->fields['r_text'] = &$this->r_text;

		// old_ref
		$this->old_ref = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_old_ref', 'old_ref', '`old_ref`', '`old_ref`', 200, -1, FALSE, '`old_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->old_ref->Sortable = FALSE; // Allow sort
		$this->fields['old_ref'] = &$this->old_ref;

		// status
		$this->status = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'sample_request_status', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// request_by
		$this->request_by = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_request_by', 'request_by', '`request_by`', '`request_by`', 18, -1, FALSE, '`request_by`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->request_by->Nullable = FALSE; // NOT NULL field
		$this->request_by->Required = TRUE; // Required field
		$this->request_by->Sortable = TRUE; // Allow sort
		$this->request_by->Lookup = new Lookup('request_by', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->request_by->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['request_by'] = &$this->request_by;

		// company_id
		$this->company_id = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Sortable = FALSE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// partner_id
		$this->partner_id = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_partner_id', 'partner_id', '`partner_id`', '`partner_id`', 19, -1, FALSE, '`EV__partner_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_id->Required = TRUE; // Required field
		$this->partner_id->Sortable = FALSE; // Allow sort
		$this->partner_id->Lookup = new Lookup('partner_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->partner_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['partner_id'] = &$this->partner_id;

		// upload
		$this->upload = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_upload', 'upload', '`upload`', '`upload`', 201, -1, TRUE, '`upload`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->upload->Sortable = FALSE; // Allow sort
		$this->upload->UploadMultiple = TRUE;
		$this->upload->Upload->UploadMultiple = TRUE;
		$this->upload->UploadMaxFileCount = 0;
		$this->fields['upload'] = &$this->upload;

		// req_chat_id
		$this->req_chat_id = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_req_chat_id', 'req_chat_id', '`req_chat_id`', '`req_chat_id`', 200, -1, FALSE, '`req_chat_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_chat_id->Sortable = FALSE; // Allow sort
		$this->req_chat_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['req_chat_id'] = &$this->req_chat_id;

		// operator
		$this->operator = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Required = TRUE; // Required field
		$this->operator->Sortable = FALSE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// design
		$this->design = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_design', 'design', '`design`', '`design`', 200, -1, FALSE, '`design`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design->Nullable = FALSE; // NOT NULL field
		$this->design->Sortable = TRUE; // Allow sort
		$this->fields['design'] = &$this->design;

		// color
		$this->color = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_color', 'color', '`color`', '`color`', 200, -1, FALSE, '`color`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->color->Nullable = FALSE; // NOT NULL field
		$this->color->Sortable = TRUE; // Allow sort
		$this->fields['color'] = &$this->color;

		// size
		$this->size = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_size', 'size', '`size`', '`size`', 200, -1, FALSE, '`size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size->Nullable = FALSE; // NOT NULL field
		$this->size->Sortable = TRUE; // Allow sort
		$this->fields['size'] = &$this->size;

		// quantity
		$this->quantity = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 18, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity'] = &$this->quantity;

		// shipping_mode
		$this->shipping_mode = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_shipping_mode', 'shipping_mode', '`shipping_mode`', '`shipping_mode`', 3, -1, FALSE, '`shipping_mode`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->shipping_mode->Sortable = TRUE; // Allow sort
		$this->shipping_mode->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->shipping_mode->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->shipping_mode->Lookup = new Lookup('shipping_mode', 'sample_req_cart_auth', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->shipping_mode->OptionCount = 3;
		$this->shipping_mode->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['shipping_mode'] = &$this->shipping_mode;

		// delivery_week
		$this->delivery_week = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_delivery_week', 'delivery_week', '`delivery_week`', '`delivery_week`', 18, -1, FALSE, '`delivery_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->delivery_week->Sortable = TRUE; // Allow sort
		$this->delivery_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->delivery_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->delivery_week->Lookup = new Lookup('delivery_week', 'not_week', FALSE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->delivery_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['delivery_week'] = &$this->delivery_week;

		// purpose
		$this->purpose = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_purpose', 'purpose', '`purpose`', '`purpose`', 2, -1, FALSE, '`purpose`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->purpose->Sortable = FALSE; // Allow sort
		$this->purpose->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->purpose->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->purpose->Lookup = new Lookup('purpose', 'sample_req_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->purpose->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['purpose'] = &$this->purpose;

		// label
		$this->label = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_label', 'label', '`label`', '`label`', 200, -1, FALSE, '`label`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->label->Sortable = FALSE; // Allow sort
		$this->label->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->label->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->label->Lookup = new Lookup('label', 'sample_req_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['label'] = &$this->label;

		// ssd
		$this->ssd = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_ssd', 'ssd', '`ssd`', CastDateFieldForLike('`ssd`', 2, "DB"), 133, 2, FALSE, '`ssd`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ssd->Sortable = FALSE; // Allow sort
		$this->ssd->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['ssd'] = &$this->ssd;

		// shipping_address_2
		$this->shipping_address_2 = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_shipping_address_2', 'shipping_address_2', '`shipping_address_2`', '`shipping_address_2`', 201, -1, FALSE, '`shipping_address_2`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->shipping_address_2->Sortable = FALSE; // Allow sort
		$this->fields['shipping_address_2'] = &$this->shipping_address_2;

		// remarks
		$this->remarks = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = FALSE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// sp_remarks
		$this->sp_remarks = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_sp_remarks', 'sp_remarks', '`sp_remarks`', '`sp_remarks`', 201, -1, FALSE, '`sp_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->sp_remarks->Sortable = FALSE; // Allow sort
		$this->fields['sp_remarks'] = &$this->sp_remarks;

		// a_operator
		$this->a_operator = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 18, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->a_operator->Sortable = FALSE; // Allow sort
		$this->a_operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->a_operator->Lookup = new Lookup('a_operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// a_datetime
		$this->a_datetime = new DbField('sample_req_cart_auth', 'sample_req_cart_auth', 'x_a_datetime', 'a_datetime', '`a_datetime`', CastDateFieldForLike('`a_datetime`', 2, "DB"), 135, 2, FALSE, '`a_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->a_datetime->Sortable = FALSE; // Allow sort
		$this->fields['a_datetime'] = &$this->a_datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`sample_req_cart_auth`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `name` FROM `buyer_seller_view` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `sample_req_cart_auth`.`partner_id` LIMIT 1) AS `EV__partner_id` FROM `sample_req_cart_auth`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->partner_id->AdvancedSearch->SearchValue <> "" ||
			$this->partner_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->datetime->DbValue = $row['datetime'];
		$this->r_text->DbValue = $row['r_text'];
		$this->old_ref->DbValue = $row['old_ref'];
		$this->status->DbValue = $row['status'];
		$this->request_by->DbValue = $row['request_by'];
		$this->company_id->DbValue = $row['company_id'];
		$this->partner_id->DbValue = $row['partner_id'];
		$this->upload->Upload->DbValue = $row['upload'];
		$this->req_chat_id->DbValue = $row['req_chat_id'];
		$this->operator->DbValue = $row['operator'];
		$this->design->DbValue = $row['design'];
		$this->color->DbValue = $row['color'];
		$this->size->DbValue = $row['size'];
		$this->quantity->DbValue = $row['quantity'];
		$this->shipping_mode->DbValue = $row['shipping_mode'];
		$this->delivery_week->DbValue = $row['delivery_week'];
		$this->purpose->DbValue = $row['purpose'];
		$this->label->DbValue = $row['label'];
		$this->ssd->DbValue = $row['ssd'];
		$this->shipping_address_2->DbValue = $row['shipping_address_2'];
		$this->remarks->DbValue = $row['remarks'];
		$this->sp_remarks->DbValue = $row['sp_remarks'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->a_datetime->DbValue = $row['a_datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->upload->OldUploadPath = 'product_images/o/sample_cart/';
		$oldFiles = EmptyValue($row['upload']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['upload']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->upload->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->upload->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "sample_req_cart_authlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "sample_req_cart_authview.php")
			return $Language->phrase("View");
		elseif ($pageName == "sample_req_cart_authedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "sample_req_cart_authadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "sample_req_cart_authlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("sample_req_cart_authview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("sample_req_cart_authview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "sample_req_cart_authadd.php?" . $this->getUrlParm($parm);
		else
			$url = "sample_req_cart_authadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("sample_req_cart_authedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("sample_req_cart_authadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("sample_req_cart_authdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->r_text->setDbValue($rs->fields('r_text'));
		$this->old_ref->setDbValue($rs->fields('old_ref'));
		$this->status->setDbValue($rs->fields('status'));
		$this->request_by->setDbValue($rs->fields('request_by'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->partner_id->setDbValue($rs->fields('partner_id'));
		$this->upload->Upload->DbValue = $rs->fields('upload');
		$this->req_chat_id->setDbValue($rs->fields('req_chat_id'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->design->setDbValue($rs->fields('design'));
		$this->color->setDbValue($rs->fields('color'));
		$this->size->setDbValue($rs->fields('size'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->shipping_mode->setDbValue($rs->fields('shipping_mode'));
		$this->delivery_week->setDbValue($rs->fields('delivery_week'));
		$this->purpose->setDbValue($rs->fields('purpose'));
		$this->label->setDbValue($rs->fields('label'));
		$this->ssd->setDbValue($rs->fields('ssd'));
		$this->shipping_address_2->setDbValue($rs->fields('shipping_address_2'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->sp_remarks->setDbValue($rs->fields('sp_remarks'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->a_datetime->setDbValue($rs->fields('a_datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// datetime
		// r_text
		// old_ref

		$this->old_ref->CellCssStyle = "white-space: nowrap;";

		// status
		// request_by
		// company_id

		$this->company_id->CellCssStyle = "white-space: nowrap;";

		// partner_id
		$this->partner_id->CellCssStyle = "white-space: nowrap;";

		// upload
		// req_chat_id

		$this->req_chat_id->CellCssStyle = "white-space: nowrap;";

		// operator
		$this->operator->CellCssStyle = "white-space: nowrap;";

		// design
		// color
		// size
		// quantity
		// shipping_mode
		// delivery_week
		// purpose

		$this->purpose->CellCssStyle = "white-space: nowrap;";

		// label
		$this->label->CellCssStyle = "white-space: nowrap;";

		// ssd
		$this->ssd->CellCssStyle = "white-space: nowrap;";

		// shipping_address_2
		$this->shipping_address_2->CellCssStyle = "white-space: nowrap;";

		// remarks
		$this->remarks->CellCssStyle = "white-space: nowrap;";

		// sp_remarks
		$this->sp_remarks->CellCssStyle = "white-space: nowrap;";

		// a_operator
		$this->a_operator->CellCssStyle = "white-space: nowrap;";

		// a_datetime
		$this->a_datetime->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 2);
		$this->datetime->ViewCustomAttributes = "";

		// r_text
		$this->r_text->ViewValue = $this->r_text->CurrentValue;
		$this->r_text->ViewCustomAttributes = "";

		// old_ref
		$this->old_ref->ViewValue = $this->old_ref->CurrentValue;
		$this->old_ref->ViewCustomAttributes = "";

		// status
		$curVal = strval($this->status->CurrentValue);
		if ($curVal <> "") {
			$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
			if ($this->status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->status->ViewValue = $this->status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->status->ViewValue = $this->status->CurrentValue;
				}
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// request_by
		$this->request_by->ViewValue = $this->request_by->CurrentValue;
		$curVal = strval($this->request_by->CurrentValue);
		if ($curVal <> "") {
			$this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
			if ($this->request_by->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->request_by->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->request_by->ViewValue = $this->request_by->CurrentValue;
				}
			}
		} else {
			$this->request_by->ViewValue = NULL;
		}
		$this->request_by->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `partner_type`=2";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// partner_id
		if ($this->partner_id->VirtualValue <> "") {
			$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
		} else {
			$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `partner_type`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		}
		$this->partner_id->ViewCustomAttributes = "";

		// upload
		$this->upload->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->ImageWidth = 0;
			$this->upload->ImageHeight = 50;
			$this->upload->ImageAlt = $this->upload->alt();
			$this->upload->ViewValue = $this->upload->Upload->DbValue;
		} else {
			$this->upload->ViewValue = "";
		}
		$this->upload->ViewCustomAttributes = "";

		// req_chat_id
		$this->req_chat_id->ViewValue = $this->req_chat_id->CurrentValue;
		$this->req_chat_id->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// design
		$this->design->ViewValue = $this->design->CurrentValue;
		$this->design->ViewCustomAttributes = "";

		// color
		$this->color->ViewValue = $this->color->CurrentValue;
		$this->color->ViewCustomAttributes = "";

		// size
		$this->size->ViewValue = $this->size->CurrentValue;
		$this->size->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// shipping_mode
		if (strval($this->shipping_mode->CurrentValue) <> "") {
			$this->shipping_mode->ViewValue = $this->shipping_mode->optionCaption($this->shipping_mode->CurrentValue);
		} else {
			$this->shipping_mode->ViewValue = NULL;
		}
		$this->shipping_mode->ViewCustomAttributes = "";

		// delivery_week
		$curVal = strval($this->delivery_week->CurrentValue);
		if ($curVal <> "") {
			$this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
			if ($this->delivery_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add" || CurrentPageID() == "addopt") ? "`weekstartday` > NOW()" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->delivery_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->delivery_week->ViewValue = $this->delivery_week->CurrentValue;
				}
			}
		} else {
			$this->delivery_week->ViewValue = NULL;
		}
		$this->delivery_week->ViewCustomAttributes = "";

		// purpose
		$curVal = strval($this->purpose->CurrentValue);
		if ($curVal <> "") {
			$this->purpose->ViewValue = $this->purpose->lookupCacheOption($curVal);
			if ($this->purpose->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->purpose->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->purpose->ViewValue = $this->purpose->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->purpose->ViewValue = $this->purpose->CurrentValue;
				}
			}
		} else {
			$this->purpose->ViewValue = NULL;
		}
		$this->purpose->ViewCustomAttributes = "";

		// label
		$curVal = strval($this->label->CurrentValue);
		if ($curVal <> "") {
			$this->label->ViewValue = $this->label->lookupCacheOption($curVal);
			if ($this->label->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->label->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->label->ViewValue = $this->label->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->label->ViewValue = $this->label->CurrentValue;
				}
			}
		} else {
			$this->label->ViewValue = NULL;
		}
		$this->label->ViewCustomAttributes = "";

		// ssd
		$this->ssd->ViewValue = $this->ssd->CurrentValue;
		$this->ssd->ViewValue = FormatDateTime($this->ssd->ViewValue, 2);
		$this->ssd->ViewCustomAttributes = "";

		// shipping_address_2
		$this->shipping_address_2->ViewValue = $this->shipping_address_2->CurrentValue;
		$this->shipping_address_2->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// sp_remarks
		$this->sp_remarks->ViewValue = $this->sp_remarks->CurrentValue;
		$this->sp_remarks->ViewCustomAttributes = "";

		// a_operator
		$curVal = strval($this->a_operator->CurrentValue);
		if ($curVal <> "") {
			$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			if ($this->a_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
				}
			}
		} else {
			$this->a_operator->ViewValue = NULL;
		}
		$this->a_operator->ViewCustomAttributes = "";

		// a_datetime
		$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
		$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 2);
		$this->a_datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// r_text
		$this->r_text->LinkCustomAttributes = "";
		$this->r_text->HrefValue = "";
		$this->r_text->TooltipValue = "";

		// old_ref
		$this->old_ref->LinkCustomAttributes = "";
		if (!EmptyValue($this->old_ref->CurrentValue)) {
			$this->old_ref->HrefValue = "sample_req_cart_statuslist.php?x__barcode=" . $this->old_ref->CurrentValue . "&z__barcode=LIKE"; // Add prefix/suffix
			$this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
		} else {
			$this->old_ref->HrefValue = "";
		}
		$this->old_ref->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// request_by
		$this->request_by->LinkCustomAttributes = "";
		$this->request_by->HrefValue = "";
		$this->request_by->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// partner_id
		$this->partner_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->partner_id->CurrentValue)) {
			$this->partner_id->HrefValue = "po_blist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
			$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
		} else {
			$this->partner_id->HrefValue = "";
		}
		$this->partner_id->TooltipValue = "";

		// upload
		$this->upload->LinkCustomAttributes = "";
		$this->upload->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->HrefValue = "%u"; // Add prefix/suffix
			$this->upload->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
		} else {
			$this->upload->HrefValue = "";
		}
		$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
		$this->upload->TooltipValue = "";
		if ($this->upload->UseColorbox) {
			if (EmptyValue($this->upload->TooltipValue))
				$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->upload->LinkAttrs["data-rel"] = "sample_req_cart_auth_x_upload";
			AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
		}

		// req_chat_id
		$this->req_chat_id->LinkCustomAttributes = "";
		$this->req_chat_id->HrefValue = "";
		$this->req_chat_id->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// design
		$this->design->LinkCustomAttributes = "";
		$this->design->HrefValue = "";
		$this->design->TooltipValue = "";

		// color
		$this->color->LinkCustomAttributes = "";
		$this->color->HrefValue = "";
		$this->color->TooltipValue = "";

		// size
		$this->size->LinkCustomAttributes = "";
		$this->size->HrefValue = "";
		$this->size->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// shipping_mode
		$this->shipping_mode->LinkCustomAttributes = "";
		$this->shipping_mode->HrefValue = "";
		$this->shipping_mode->TooltipValue = "";

		// delivery_week
		$this->delivery_week->LinkCustomAttributes = "";
		$this->delivery_week->HrefValue = "";
		$this->delivery_week->TooltipValue = "";

		// purpose
		$this->purpose->LinkCustomAttributes = "";
		$this->purpose->HrefValue = "";
		$this->purpose->TooltipValue = "";

		// label
		$this->label->LinkCustomAttributes = "";
		$this->label->HrefValue = "";
		$this->label->TooltipValue = "";

		// ssd
		$this->ssd->LinkCustomAttributes = "";
		$this->ssd->HrefValue = "";
		$this->ssd->TooltipValue = "";

		// shipping_address_2
		$this->shipping_address_2->LinkCustomAttributes = "";
		$this->shipping_address_2->HrefValue = "";
		$this->shipping_address_2->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// sp_remarks
		$this->sp_remarks->LinkCustomAttributes = "";
		$this->sp_remarks->HrefValue = "";
		$this->sp_remarks->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// a_datetime
		$this->a_datetime->LinkCustomAttributes = "";
		$this->a_datetime->HrefValue = "";
		$this->a_datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// datetime
		$this->datetime->EditAttrs["class"] = "form-control";
		$this->datetime->EditCustomAttributes = "";
		$this->datetime->EditValue = $this->datetime->CurrentValue;
		$this->datetime->EditValue = FormatDateTime($this->datetime->EditValue, 2);
		$this->datetime->ViewCustomAttributes = "";

		// r_text
		$this->r_text->EditAttrs["class"] = "form-control";
		$this->r_text->EditCustomAttributes = "";
		$this->r_text->EditValue = $this->r_text->CurrentValue;
		$this->r_text->ViewCustomAttributes = "";

		// old_ref
		$this->old_ref->EditAttrs["class"] = "form-control";
		$this->old_ref->EditCustomAttributes = "";
		$this->old_ref->EditValue = $this->old_ref->CurrentValue;
		$this->old_ref->ViewCustomAttributes = "";

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		$curVal = strval($this->status->CurrentValue);
		if ($curVal <> "") {
			$this->status->EditValue = $this->status->lookupCacheOption($curVal);
			if ($this->status->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->status->EditValue = $this->status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->status->EditValue = $this->status->CurrentValue;
				}
			}
		} else {
			$this->status->EditValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// request_by
		$this->request_by->EditAttrs["class"] = "form-control";
		$this->request_by->EditCustomAttributes = "";
		$this->request_by->EditValue = $this->request_by->CurrentValue;
		$curVal = strval($this->request_by->CurrentValue);
		if ($curVal <> "") {
			$this->request_by->EditValue = $this->request_by->lookupCacheOption($curVal);
			if ($this->request_by->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->request_by->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->request_by->EditValue = $this->request_by->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->request_by->EditValue = $this->request_by->CurrentValue;
				}
			}
		} else {
			$this->request_by->EditValue = NULL;
		}
		$this->request_by->ViewCustomAttributes = "";

		// company_id
		$this->company_id->EditCustomAttributes = "";

		// partner_id
		$this->partner_id->EditAttrs["class"] = "form-control";
		$this->partner_id->EditCustomAttributes = "";
		$this->partner_id->EditValue = $this->partner_id->CurrentValue;
		$this->partner_id->PlaceHolder = RemoveHtml($this->partner_id->caption());

		// upload
		$this->upload->EditAttrs["class"] = "form-control";
		$this->upload->EditCustomAttributes = "";
		$this->upload->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->ImageWidth = 0;
			$this->upload->ImageHeight = 50;
			$this->upload->ImageAlt = $this->upload->alt();
			$this->upload->EditValue = $this->upload->Upload->DbValue;
		} else {
			$this->upload->EditValue = "";
		}
		$this->upload->ViewCustomAttributes = "";

		// req_chat_id
		$this->req_chat_id->EditAttrs["class"] = "form-control";
		$this->req_chat_id->EditCustomAttributes = "";
		$this->req_chat_id->EditValue = $this->req_chat_id->CurrentValue;
		$this->req_chat_id->ViewCustomAttributes = "";

		// operator
		$this->operator->EditAttrs["class"] = "form-control";
		$this->operator->EditCustomAttributes = "";
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->EditValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->EditValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->EditValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->EditValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// design
		$this->design->EditAttrs["class"] = "form-control";
		$this->design->EditCustomAttributes = "";
		$this->design->EditValue = $this->design->CurrentValue;
		$this->design->ViewCustomAttributes = "";

		// color
		$this->color->EditAttrs["class"] = "form-control";
		$this->color->EditCustomAttributes = "";
		$this->color->EditValue = $this->color->CurrentValue;
		$this->color->ViewCustomAttributes = "";

		// size
		$this->size->EditAttrs["class"] = "form-control";
		$this->size->EditCustomAttributes = "";
		$this->size->EditValue = $this->size->CurrentValue;
		$this->size->ViewCustomAttributes = "";

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// shipping_mode
		$this->shipping_mode->EditAttrs["class"] = "form-control";
		$this->shipping_mode->EditCustomAttributes = "";
		if (strval($this->shipping_mode->CurrentValue) <> "") {
			$this->shipping_mode->EditValue = $this->shipping_mode->optionCaption($this->shipping_mode->CurrentValue);
		} else {
			$this->shipping_mode->EditValue = NULL;
		}
		$this->shipping_mode->ViewCustomAttributes = "";

		// delivery_week
		$this->delivery_week->EditAttrs["class"] = "form-control";
		$this->delivery_week->EditCustomAttributes = "";
		$curVal = strval($this->delivery_week->CurrentValue);
		if ($curVal <> "") {
			$this->delivery_week->EditValue = $this->delivery_week->lookupCacheOption($curVal);
			if ($this->delivery_week->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add" || CurrentPageID() == "addopt") ? "`weekstartday` > NOW()" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->delivery_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->delivery_week->EditValue = $this->delivery_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->delivery_week->EditValue = $this->delivery_week->CurrentValue;
				}
			}
		} else {
			$this->delivery_week->EditValue = NULL;
		}
		$this->delivery_week->ViewCustomAttributes = "";

		// purpose
		$this->purpose->EditAttrs["class"] = "form-control";
		$this->purpose->EditCustomAttributes = "";
		$curVal = strval($this->purpose->CurrentValue);
		if ($curVal <> "") {
			$this->purpose->EditValue = $this->purpose->lookupCacheOption($curVal);
			if ($this->purpose->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->purpose->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->purpose->EditValue = $this->purpose->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->purpose->EditValue = $this->purpose->CurrentValue;
				}
			}
		} else {
			$this->purpose->EditValue = NULL;
		}
		$this->purpose->ViewCustomAttributes = "";

		// label
		$this->label->EditAttrs["class"] = "form-control";
		$this->label->EditCustomAttributes = "";
		$curVal = strval($this->label->CurrentValue);
		if ($curVal <> "") {
			$this->label->EditValue = $this->label->lookupCacheOption($curVal);
			if ($this->label->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->label->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->label->EditValue = $this->label->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->label->EditValue = $this->label->CurrentValue;
				}
			}
		} else {
			$this->label->EditValue = NULL;
		}
		$this->label->ViewCustomAttributes = "";

		// ssd
		$this->ssd->EditAttrs["class"] = "form-control";
		$this->ssd->EditCustomAttributes = "";
		$this->ssd->EditValue = $this->ssd->CurrentValue;
		$this->ssd->EditValue = FormatDateTime($this->ssd->EditValue, 2);
		$this->ssd->ViewCustomAttributes = "";

		// shipping_address_2
		$this->shipping_address_2->EditAttrs["class"] = "form-control";
		$this->shipping_address_2->EditCustomAttributes = "";
		$this->shipping_address_2->EditValue = $this->shipping_address_2->CurrentValue;
		$this->shipping_address_2->ViewCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// sp_remarks
		$this->sp_remarks->EditAttrs["class"] = "form-control";
		$this->sp_remarks->EditCustomAttributes = "";
		$this->sp_remarks->EditValue = $this->sp_remarks->CurrentValue;
		$this->sp_remarks->PlaceHolder = RemoveHtml($this->sp_remarks->caption());

		// a_operator
		// a_datetime
		// Call Row Rendered event

		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->r_text);
					$doc->exportCaption($this->old_ref);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->request_by);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->upload);
					$doc->exportCaption($this->req_chat_id);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->design);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->shipping_mode);
					$doc->exportCaption($this->delivery_week);
					$doc->exportCaption($this->purpose);
					$doc->exportCaption($this->label);
					$doc->exportCaption($this->ssd);
					$doc->exportCaption($this->shipping_address_2);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->sp_remarks);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->a_datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->r_text);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->request_by);
					$doc->exportCaption($this->design);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->shipping_mode);
					$doc->exportCaption($this->delivery_week);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->datetime);
						$doc->exportField($this->r_text);
						$doc->exportField($this->old_ref);
						$doc->exportField($this->status);
						$doc->exportField($this->request_by);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->upload);
						$doc->exportField($this->req_chat_id);
						$doc->exportField($this->operator);
						$doc->exportField($this->design);
						$doc->exportField($this->color);
						$doc->exportField($this->size);
						$doc->exportField($this->quantity);
						$doc->exportField($this->shipping_mode);
						$doc->exportField($this->delivery_week);
						$doc->exportField($this->purpose);
						$doc->exportField($this->label);
						$doc->exportField($this->ssd);
						$doc->exportField($this->shipping_address_2);
						$doc->exportField($this->remarks);
						$doc->exportField($this->sp_remarks);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->a_datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->datetime);
						$doc->exportField($this->r_text);
						$doc->exportField($this->status);
						$doc->exportField($this->request_by);
						$doc->exportField($this->design);
						$doc->exportField($this->color);
						$doc->exportField($this->size);
						$doc->exportField($this->quantity);
						$doc->exportField($this->shipping_mode);
						$doc->exportField($this->delivery_week);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'upload') {
			$fldName = "upload";
			$fileNameFld = "upload";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>