<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class sample_req_cart_delete extends sample_req_cart
{

	// Page ID
	public $PageID = "delete";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'sample_req_cart';

	// Page object name
	public $PageObjName = "sample_req_cart_delete";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (sample_req_cart)
		if (!isset($GLOBALS["sample_req_cart"]) || get_class($GLOBALS["sample_req_cart"]) == PROJECT_NAMESPACE . "sample_req_cart") {
			$GLOBALS["sample_req_cart"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["sample_req_cart"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'delete');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $sample_req_cart;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($sample_req_cart);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $TotalRecs = 0;
	public $RecCnt;
	public $RecKeys = array();
	public $StartRowCnt = 1;
	public $RowCnt = 0;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canDelete()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("sample_req_cartlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->request_by->setVisibility();
		$this->old_ref->setVisibility();
		$this->upload->setVisibility();
		$this->design->setVisibility();
		$this->color->setVisibility();
		$this->size->setVisibility();
		$this->quantity->setVisibility();
		$this->comments->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->po_id->Visible = FALSE;
		$this->status->setVisibility();
		$this->shipping_mode->Visible = FALSE;
		$this->delivery_week->Visible = FALSE;
		$this->purpose->Visible = FALSE;
		$this->label->Visible = FALSE;
		$this->ssd->Visible = FALSE;
		$this->shipping_address->Visible = FALSE;
		$this->shipping_address_2->Visible = FALSE;
		$this->company_id->Visible = FALSE;
		$this->partner_id->Visible = FALSE;
		$this->sp_remarks->Visible = FALSE;
		$this->pp_remarks->Visible = FALSE;
		$this->po_remarks->Visible = FALSE;
		$this->price->Visible = FALSE;
		$this->declaration->Visible = FALSE;
		$this->remarks->Visible = FALSE;
		$this->a_operator->Visible = FALSE;
		$this->a_datetime->Visible = FALSE;
		$this->app_operator->Visible = FALSE;
		$this->app_datetime->Visible = FALSE;
		$this->po_operator->Visible = FALSE;
		$this->po_datetime->Visible = FALSE;
		$this->bom->Visible = FALSE;
		$this->dispatch->Visible = FALSE;
		$this->pd_upload->Visible = FALSE;
		$this->d_operator->Visible = FALSE;
		$this->d_datetime->Visible = FALSE;
		$this->r_comments->Visible = FALSE;
		$this->r_operator->Visible = FALSE;
		$this->r_datetime->Visible = FALSE;
		$this->f_yn->Visible = FALSE;
		$this->feedback->Visible = FALSE;
		$this->f_upload->Visible = FALSE;
		$this->f_operator->Visible = FALSE;
		$this->f_datetime->Visible = FALSE;
		$this->r_text->Visible = FALSE;
		$this->_barcode->Visible = FALSE;
		$this->fr_operator->Visible = FALSE;
		$this->fr_datetime->Visible = FALSE;
		$this->app_status->Visible = FALSE;
		$this->da_comments->Visible = FALSE;
		$this->da_status->Visible = FALSE;
		$this->da_operator->Visible = FALSE;
		$this->da_datetime->Visible = FALSE;
		$this->req_chat_id->Visible = FALSE;
		$this->pd_operator->Visible = FALSE;
		$this->pd_comments->Visible = FALSE;
		$this->pd_datetime->Visible = FALSE;
		$this->d_upload->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->request_by);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->delivery_week);
		$this->setupLookupOptions($this->purpose);
		$this->setupLookupOptions($this->label);
		$this->setupLookupOptions($this->shipping_address);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->a_operator);
		$this->setupLookupOptions($this->app_status);
		$this->setupLookupOptions($this->da_status);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Load key parameters
		$this->RecKeys = $this->getRecordKeys(); // Load record keys
		$filter = $this->getFilterFromRecordKeys();
		if ($filter == "") {
			$this->terminate("sample_req_cartlist.php"); // Prevent SQL injection, return to list
			return;
		}

		// Set up filter (WHERE Clause)
		$this->CurrentFilter = $filter;

		// Get action
		if (IsApi()) {
			$this->CurrentAction = "delete"; // Delete record directly
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action");
		} elseif (Get("action") == "1") {
			$this->CurrentAction = "delete"; // Delete record directly
		} else {
			$this->CurrentAction = "show"; // Display record
		}
		if ($this->isDelete()) {
			$this->SendEmail = TRUE; // Send email on delete success
			if ($this->deleteRows()) { // Delete rows
				if ($this->getSuccessMessage() == "")
					$this->setSuccessMessage($Language->phrase("DeleteSuccess")); // Set up success message
				if (IsApi()) {
					$this->terminate(TRUE);
					return;
				} else {
					$this->terminate($this->getReturnUrl()); // Return to caller
				}
			} else { // Delete failed
				if (IsApi()) {
					$this->terminate();
					return;
				}
				$this->CurrentAction = "show"; // Display record
			}
		}
		if ($this->isShow()) { // Load records for display
			if ($this->Recordset = $this->loadRecordset())
				$this->TotalRecs = $this->Recordset->RecordCount(); // Get record count
			if ($this->TotalRecs <= 0) { // No record found, exit
				if ($this->Recordset)
					$this->Recordset->close();
				$this->terminate("sample_req_cartlist.php"); // Return to list
			}
		}
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->request_by->setDbValue($row['request_by']);
		$this->old_ref->setDbValue($row['old_ref']);
		$this->upload->Upload->DbValue = $row['upload'];
		$this->upload->setDbValue($this->upload->Upload->DbValue);
		$this->design->setDbValue($row['design']);
		$this->color->setDbValue($row['color']);
		$this->size->setDbValue($row['size']);
		$this->quantity->setDbValue($row['quantity']);
		$this->comments->setDbValue($row['comments']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->po_id->setDbValue($row['po_id']);
		$this->status->setDbValue($row['status']);
		$this->shipping_mode->setDbValue($row['shipping_mode']);
		$this->delivery_week->setDbValue($row['delivery_week']);
		$this->purpose->setDbValue($row['purpose']);
		$this->label->setDbValue($row['label']);
		$this->ssd->setDbValue($row['ssd']);
		$this->shipping_address->setDbValue($row['shipping_address']);
		$this->shipping_address_2->setDbValue($row['shipping_address_2']);
		$this->company_id->setDbValue($row['company_id']);
		$this->partner_id->setDbValue($row['partner_id']);
		if (array_key_exists('EV__partner_id', $rs->fields)) {
			$this->partner_id->VirtualValue = $rs->fields('EV__partner_id'); // Set up virtual field value
		} else {
			$this->partner_id->VirtualValue = ""; // Clear value
		}
		$this->sp_remarks->setDbValue($row['sp_remarks']);
		$this->pp_remarks->setDbValue($row['pp_remarks']);
		$this->po_remarks->setDbValue($row['po_remarks']);
		$this->price->setDbValue($row['price']);
		$this->declaration->setDbValue($row['declaration']);
		$this->remarks->setDbValue($row['remarks']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->app_operator->setDbValue($row['app_operator']);
		$this->app_datetime->setDbValue($row['app_datetime']);
		$this->po_operator->setDbValue($row['po_operator']);
		$this->po_datetime->setDbValue($row['po_datetime']);
		$this->bom->setDbValue($row['bom']);
		$this->dispatch->setDbValue($row['dispatch']);
		$this->pd_upload->setDbValue($row['pd_upload']);
		$this->d_operator->setDbValue($row['d_operator']);
		$this->d_datetime->setDbValue($row['d_datetime']);
		$this->r_comments->setDbValue($row['r_comments']);
		$this->r_operator->setDbValue($row['r_operator']);
		$this->r_datetime->setDbValue($row['r_datetime']);
		$this->f_yn->setDbValue($row['f_yn']);
		$this->feedback->setDbValue($row['feedback']);
		$this->f_upload->setDbValue($row['f_upload']);
		$this->f_operator->setDbValue($row['f_operator']);
		$this->f_datetime->setDbValue($row['f_datetime']);
		$this->r_text->setDbValue($row['r_text']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->fr_operator->setDbValue($row['fr_operator']);
		$this->fr_datetime->setDbValue($row['fr_datetime']);
		$this->app_status->setDbValue($row['app_status']);
		$this->da_comments->setDbValue($row['da_comments']);
		$this->da_status->setDbValue($row['da_status']);
		$this->da_operator->setDbValue($row['da_operator']);
		$this->da_datetime->setDbValue($row['da_datetime']);
		$this->req_chat_id->setDbValue($row['req_chat_id']);
		$this->pd_operator->setDbValue($row['pd_operator']);
		$this->pd_comments->setDbValue($row['pd_comments']);
		$this->pd_datetime->setDbValue($row['pd_datetime']);
		$this->d_upload->setDbValue($row['d_upload']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['request_by'] = NULL;
		$row['old_ref'] = NULL;
		$row['upload'] = NULL;
		$row['design'] = NULL;
		$row['color'] = NULL;
		$row['size'] = NULL;
		$row['quantity'] = NULL;
		$row['comments'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['po_id'] = NULL;
		$row['status'] = NULL;
		$row['shipping_mode'] = NULL;
		$row['delivery_week'] = NULL;
		$row['purpose'] = NULL;
		$row['label'] = NULL;
		$row['ssd'] = NULL;
		$row['shipping_address'] = NULL;
		$row['shipping_address_2'] = NULL;
		$row['company_id'] = NULL;
		$row['partner_id'] = NULL;
		$row['sp_remarks'] = NULL;
		$row['pp_remarks'] = NULL;
		$row['po_remarks'] = NULL;
		$row['price'] = NULL;
		$row['declaration'] = NULL;
		$row['remarks'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		$row['app_operator'] = NULL;
		$row['app_datetime'] = NULL;
		$row['po_operator'] = NULL;
		$row['po_datetime'] = NULL;
		$row['bom'] = NULL;
		$row['dispatch'] = NULL;
		$row['pd_upload'] = NULL;
		$row['d_operator'] = NULL;
		$row['d_datetime'] = NULL;
		$row['r_comments'] = NULL;
		$row['r_operator'] = NULL;
		$row['r_datetime'] = NULL;
		$row['f_yn'] = NULL;
		$row['feedback'] = NULL;
		$row['f_upload'] = NULL;
		$row['f_operator'] = NULL;
		$row['f_datetime'] = NULL;
		$row['r_text'] = NULL;
		$row['barcode'] = NULL;
		$row['fr_operator'] = NULL;
		$row['fr_datetime'] = NULL;
		$row['app_status'] = NULL;
		$row['da_comments'] = NULL;
		$row['da_status'] = NULL;
		$row['da_operator'] = NULL;
		$row['da_datetime'] = NULL;
		$row['req_chat_id'] = NULL;
		$row['pd_operator'] = NULL;
		$row['pd_comments'] = NULL;
		$row['pd_datetime'] = NULL;
		$row['d_upload'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// request_by
		// old_ref
		// upload
		// design
		// color
		// size
		// quantity
		// comments
		// operator
		// datetime
		// po_id

		$this->po_id->CellCssStyle = "white-space: nowrap;";

		// status
		$this->status->CellCssStyle = "white-space: nowrap;";

		// shipping_mode
		$this->shipping_mode->CellCssStyle = "white-space: nowrap;";

		// delivery_week
		$this->delivery_week->CellCssStyle = "white-space: nowrap;";

		// purpose
		$this->purpose->CellCssStyle = "white-space: nowrap;";

		// label
		$this->label->CellCssStyle = "white-space: nowrap;";

		// ssd
		$this->ssd->CellCssStyle = "white-space: nowrap;";

		// shipping_address
		$this->shipping_address->CellCssStyle = "white-space: nowrap;";

		// shipping_address_2
		$this->shipping_address_2->CellCssStyle = "white-space: nowrap;";

		// company_id
		$this->company_id->CellCssStyle = "white-space: nowrap;";

		// partner_id
		$this->partner_id->CellCssStyle = "white-space: nowrap;";

		// sp_remarks
		$this->sp_remarks->CellCssStyle = "white-space: nowrap;";

		// pp_remarks
		$this->pp_remarks->CellCssStyle = "white-space: nowrap;";

		// po_remarks
		$this->po_remarks->CellCssStyle = "white-space: nowrap;";

		// price
		$this->price->CellCssStyle = "white-space: nowrap;";

		// declaration
		$this->declaration->CellCssStyle = "white-space: nowrap;";

		// remarks
		$this->remarks->CellCssStyle = "white-space: nowrap;";

		// a_operator
		$this->a_operator->CellCssStyle = "white-space: nowrap;";

		// a_datetime
		$this->a_datetime->CellCssStyle = "white-space: nowrap;";

		// app_operator
		$this->app_operator->CellCssStyle = "white-space: nowrap;";

		// app_datetime
		$this->app_datetime->CellCssStyle = "white-space: nowrap;";

		// po_operator
		$this->po_operator->CellCssStyle = "white-space: nowrap;";

		// po_datetime
		$this->po_datetime->CellCssStyle = "white-space: nowrap;";

		// bom
		$this->bom->CellCssStyle = "white-space: nowrap;";

		// dispatch
		$this->dispatch->CellCssStyle = "white-space: nowrap;";

		// pd_upload
		$this->pd_upload->CellCssStyle = "white-space: nowrap;";

		// d_operator
		$this->d_operator->CellCssStyle = "white-space: nowrap;";

		// d_datetime
		$this->d_datetime->CellCssStyle = "white-space: nowrap;";

		// r_comments
		$this->r_comments->CellCssStyle = "white-space: nowrap;";

		// r_operator
		$this->r_operator->CellCssStyle = "white-space: nowrap;";

		// r_datetime
		$this->r_datetime->CellCssStyle = "white-space: nowrap;";

		// f_yn
		$this->f_yn->CellCssStyle = "white-space: nowrap;";

		// feedback
		$this->feedback->CellCssStyle = "white-space: nowrap;";

		// f_upload
		$this->f_upload->CellCssStyle = "white-space: nowrap;";

		// f_operator
		$this->f_operator->CellCssStyle = "white-space: nowrap;";

		// f_datetime
		$this->f_datetime->CellCssStyle = "white-space: nowrap;";

		// r_text
		$this->r_text->CellCssStyle = "white-space: nowrap;";

		// barcode
		$this->_barcode->CellCssStyle = "white-space: nowrap;";

		// fr_operator
		$this->fr_operator->CellCssStyle = "white-space: nowrap;";

		// fr_datetime
		$this->fr_datetime->CellCssStyle = "white-space: nowrap;";

		// app_status
		$this->app_status->CellCssStyle = "white-space: nowrap;";

		// da_comments
		$this->da_comments->CellCssStyle = "white-space: nowrap;";

		// da_status
		$this->da_status->CellCssStyle = "white-space: nowrap;";

		// da_operator
		$this->da_operator->CellCssStyle = "white-space: nowrap;";

		// da_datetime
		$this->da_datetime->CellCssStyle = "white-space: nowrap;";

		// req_chat_id
		$this->req_chat_id->CellCssStyle = "white-space: nowrap;";

		// pd_operator
		$this->pd_operator->CellCssStyle = "white-space: nowrap;";

		// pd_comments
		$this->pd_comments->CellCssStyle = "white-space: nowrap;";

		// pd_datetime
		$this->pd_datetime->CellCssStyle = "white-space: nowrap;";

		// d_upload
		$this->d_upload->CellCssStyle = "white-space: nowrap;";
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// request_by
			$curVal = strval($this->request_by->CurrentValue);
			if ($curVal <> "") {
				$this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
				if ($this->request_by->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return ((CurrentUserLevel() == 0) || (CurrentUserLevel() == 1002)) ? "((`userlevel`= 0) || (`userlevel` = 1002)) and `activated` = 1" : "`activated` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->request_by->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->request_by->ViewValue = $this->request_by->CurrentValue;
					}
				}
			} else {
				$this->request_by->ViewValue = NULL;
			}
			$this->request_by->ViewCustomAttributes = "";

			// old_ref
			$this->old_ref->ViewValue = $this->old_ref->CurrentValue;
			$this->old_ref->ViewCustomAttributes = "";

			// upload
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->ViewValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->ViewValue = "";
			}
			$this->upload->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// comments
			$this->comments->ViewValue = $this->comments->CurrentValue;
			$this->comments->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// request_by
			$this->request_by->LinkCustomAttributes = "";
			$this->request_by->HrefValue = "";
			$this->request_by->TooltipValue = "";

			// old_ref
			$this->old_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->old_ref->CurrentValue)) {
				$this->old_ref->HrefValue = "sample_req_cart_statuslist.php?x__barcode=" . $this->old_ref->CurrentValue . "&z__barcode=LIKE"; // Add prefix/suffix
				$this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
			} else {
				$this->old_ref->HrefValue = "";
			}
			$this->old_ref->TooltipValue = "";

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = "%u"; // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
			$this->upload->TooltipValue = "";
			if ($this->upload->UseColorbox) {
				if (EmptyValue($this->upload->TooltipValue))
					$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->upload->LinkAttrs["data-rel"] = "sample_req_cart_x_upload";
				AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
			}

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// comments
			$this->comments->LinkCustomAttributes = "";
			$this->comments->HrefValue = "";
			$this->comments->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];
		$conn->beginTrans();

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}
		if ($deleteRows) {
			$conn->commitTrans(); // Commit the changes
		} else {
			$conn->rollbackTrans(); // Rollback changes
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("sample_req_cartlist.php"), "", $this->TableVar, TRUE);
		$pageId = "delete";
		$Breadcrumb->add("delete", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_request_by":
					$lookupFilter = function() {
						return ((CurrentUserLevel() == 0) || (CurrentUserLevel() == 1002)) ? "((`userlevel`= 0) || (`userlevel` = 1002)) and `activated` = 1" : "`activated` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_delivery_week":
					$lookupFilter = function() {
						return (CurrentPageID() == "add" || CurrentPageID() == "addopt") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_purpose":
					$lookupFilter = function() {
						return "`grp`=3 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_label":
					$lookupFilter = function() {
						return "`grp`=3 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_company_id":
					$lookupFilter = function() {
						return User_Company_ID() == 0 ? "`status`=1 and `partner_type`=2" : "id= ".  User_Company_ID() . "  and `partner_type`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_app_status":
					$lookupFilter = function() {
						return "`grp` = 6 and `status` = 1 and (`id` = 602 || `id` = 609)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_da_status":
					$lookupFilter = function() {
						return "`grp` = 7 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_request_by":
							break;
						case "x_operator":
							break;
						case "x_status":
							break;
						case "x_delivery_week":
							break;
						case "x_purpose":
							break;
						case "x_label":
							break;
						case "x_shipping_address":
							break;
						case "x_company_id":
							break;
						case "x_partner_id":
							break;
						case "x_a_operator":
							break;
						case "x_app_status":
							break;
						case "x_da_status":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'sample_req_cart');		
		if (($this->status->CurrentValue) >= 3)
		{
			$msg = 'Not Allowed';
			header('Location: sample_req_cartlist.php');
			exit;
		}	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>