<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for sample_req_cart_dispatch_app
 */
class sample_req_cart_dispatch_app extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $company_id;
	public $partner_id;
	public $old_ref;
	public $design;
	public $color;
	public $size;
	public $quantity;
	public $delivery_week;
	public $status;
	public $upload;
	public $remarks;
	public $sp_remarks;
	public $pp_remarks;
	public $po_remarks;
	public $price;
	public $declaration;
	public $bom;
	public $purpose;
	public $label;
	public $ssd;
	public $pd_upload;
	public $da_comments;
	public $da_status;
	public $da_operator;
	public $da_datetime;
	public $req_chat_id;
	public $url;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'sample_req_cart_dispatch_app';
		$this->TableName = 'sample_req_cart_dispatch_app';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`sample_req_cart_dispatch_app`";
		$this->Dbid = 'DB';
		$this->ExportAll = FALSE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// company_id
		$this->company_id = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->company_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->company_id->Lookup = new Lookup('company_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// partner_id
		$this->partner_id = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_partner_id', 'partner_id', '`partner_id`', '`partner_id`', 19, -1, FALSE, '`EV__partner_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->partner_id->Required = TRUE; // Required field
		$this->partner_id->Sortable = TRUE; // Allow sort
		$this->partner_id->Lookup = new Lookup('partner_id', 'buyer_seller_view', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->partner_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['partner_id'] = &$this->partner_id;

		// old_ref
		$this->old_ref = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_old_ref', 'old_ref', '`old_ref`', '`old_ref`', 200, -1, FALSE, '`old_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->old_ref->Sortable = TRUE; // Allow sort
		$this->fields['old_ref'] = &$this->old_ref;

		// design
		$this->design = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_design', 'design', '`design`', '`design`', 200, -1, FALSE, '`design`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->design->Nullable = FALSE; // NOT NULL field
		$this->design->Sortable = TRUE; // Allow sort
		$this->fields['design'] = &$this->design;

		// color
		$this->color = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_color', 'color', '`color`', '`color`', 200, -1, FALSE, '`color`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->color->Nullable = FALSE; // NOT NULL field
		$this->color->Sortable = TRUE; // Allow sort
		$this->fields['color'] = &$this->color;

		// size
		$this->size = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_size', 'size', '`size`', '`size`', 200, -1, FALSE, '`size`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->size->Nullable = FALSE; // NOT NULL field
		$this->size->Sortable = TRUE; // Allow sort
		$this->fields['size'] = &$this->size;

		// quantity
		$this->quantity = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 18, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Nullable = FALSE; // NOT NULL field
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity'] = &$this->quantity;

		// delivery_week
		$this->delivery_week = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_delivery_week', 'delivery_week', '`delivery_week`', '`delivery_week`', 18, -1, FALSE, '`delivery_week`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->delivery_week->Sortable = TRUE; // Allow sort
		$this->delivery_week->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->delivery_week->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->delivery_week->Lookup = new Lookup('delivery_week', 'not_week', FALSE, 'id', ["wid","wed","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->delivery_week->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['delivery_week'] = &$this->delivery_week;

		// status
		$this->status = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Sortable = FALSE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'sample_request_status', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`id` ASC', '');
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// upload
		$this->upload = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_upload', 'upload', '`upload`', '`upload`', 201, -1, TRUE, '`upload`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->upload->Sortable = TRUE; // Allow sort
		$this->upload->ImageResize = TRUE;
		$this->upload->UploadMultiple = TRUE;
		$this->upload->Upload->UploadMultiple = TRUE;
		$this->upload->UploadMaxFileCount = 0;
		$this->fields['upload'] = &$this->upload;

		// remarks
		$this->remarks = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = FALSE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// sp_remarks
		$this->sp_remarks = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_sp_remarks', 'sp_remarks', '`sp_remarks`', '`sp_remarks`', 201, -1, FALSE, '`sp_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->sp_remarks->Sortable = TRUE; // Allow sort
		$this->fields['sp_remarks'] = &$this->sp_remarks;

		// pp_remarks
		$this->pp_remarks = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_pp_remarks', 'pp_remarks', '`pp_remarks`', '`pp_remarks`', 201, -1, FALSE, '`pp_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->pp_remarks->Sortable = FALSE; // Allow sort
		$this->fields['pp_remarks'] = &$this->pp_remarks;

		// po_remarks
		$this->po_remarks = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_po_remarks', 'po_remarks', '`po_remarks`', '`po_remarks`', 200, -1, FALSE, '`po_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->po_remarks->Sortable = TRUE; // Allow sort
		$this->fields['po_remarks'] = &$this->po_remarks;

		// price
		$this->price = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_price', 'price', '`price`', '`price`', 200, -1, FALSE, '`price`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->price->Sortable = FALSE; // Allow sort
		$this->fields['price'] = &$this->price;

		// declaration
		$this->declaration = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_declaration', 'declaration', '`declaration`', '`declaration`', 200, -1, FALSE, '`declaration`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->declaration->Sortable = FALSE; // Allow sort
		$this->fields['declaration'] = &$this->declaration;

		// bom
		$this->bom = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_bom', 'bom', '`bom`', '`bom`', 201, -1, FALSE, '`bom`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->bom->Nullable = FALSE; // NOT NULL field
		$this->bom->Required = TRUE; // Required field
		$this->bom->Sortable = TRUE; // Allow sort
		$this->fields['bom'] = &$this->bom;

		// purpose
		$this->purpose = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_purpose', 'purpose', '`purpose`', '`purpose`', 2, -1, FALSE, '`purpose`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->purpose->Sortable = FALSE; // Allow sort
		$this->purpose->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->purpose->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->purpose->Lookup = new Lookup('purpose', 'sample_req_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->purpose->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['purpose'] = &$this->purpose;

		// label
		$this->label = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_label', 'label', '`label`', '`label`', 200, -1, FALSE, '`label`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->label->Sortable = FALSE; // Allow sort
		$this->label->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->label->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->label->Lookup = new Lookup('label', 'sample_req_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['label'] = &$this->label;

		// ssd
		$this->ssd = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_ssd', 'ssd', '`ssd`', CastDateFieldForLike('`ssd`', 0, "DB"), 133, 0, FALSE, '`ssd`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ssd->Sortable = FALSE; // Allow sort
		$this->ssd->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['ssd'] = &$this->ssd;

		// pd_upload
		$this->pd_upload = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_pd_upload', 'pd_upload', '`pd_upload`', '`pd_upload`', 201, -1, TRUE, '`pd_upload`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'FILE');
		$this->pd_upload->Sortable = TRUE; // Allow sort
		$this->pd_upload->UploadMultiple = TRUE;
		$this->pd_upload->Upload->UploadMultiple = TRUE;
		$this->pd_upload->UploadMaxFileCount = 0;
		$this->fields['pd_upload'] = &$this->pd_upload;

		// da_comments
		$this->da_comments = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_da_comments', 'da_comments', '`da_comments`', '`da_comments`', 201, -1, FALSE, '`da_comments`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->da_comments->Sortable = TRUE; // Allow sort
		$this->fields['da_comments'] = &$this->da_comments;

		// da_status
		$this->da_status = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_da_status', 'da_status', '`da_status`', '`da_status`', 2, -1, FALSE, '`da_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->da_status->Required = TRUE; // Required field
		$this->da_status->Sortable = TRUE; // Allow sort
		$this->da_status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->da_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->da_status->Lookup = new Lookup('da_status', 'sample_req_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->da_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['da_status'] = &$this->da_status;

		// da_operator
		$this->da_operator = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_da_operator', 'da_operator', '`da_operator`', '`da_operator`', 18, -1, FALSE, '`da_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->da_operator->Sortable = TRUE; // Allow sort
		$this->da_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['da_operator'] = &$this->da_operator;

		// da_datetime
		$this->da_datetime = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_da_datetime', 'da_datetime', '`da_datetime`', CastDateFieldForLike('`da_datetime`', 0, "DB"), 135, 0, FALSE, '`da_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->da_datetime->Sortable = TRUE; // Allow sort
		$this->da_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['da_datetime'] = &$this->da_datetime;

		// req_chat_id
		$this->req_chat_id = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_req_chat_id', 'req_chat_id', '`req_chat_id`', '`req_chat_id`', 200, -1, FALSE, '`req_chat_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->req_chat_id->Sortable = FALSE; // Allow sort
		$this->fields['req_chat_id'] = &$this->req_chat_id;

		// url
		$this->url = new DbField('sample_req_cart_dispatch_app', 'sample_req_cart_dispatch_app', 'x_url', 'url', 'if ((left(`req_chat_id`,1) = \'¨\'), concat(\'request_archivelist.php?x_reference=\', replace(`req_chat_id`,\'¨\',\'\')), concat(\'request_grouplist.php?x_reference=\', `req_chat_id`))', 'if ((left(`req_chat_id`,1) = \'¨\'), concat(\'request_archivelist.php?x_reference=\', replace(`req_chat_id`,\'¨\',\'\')), concat(\'request_grouplist.php?x_reference=\', `req_chat_id`))', 200, -1, FALSE, 'if ((left(`req_chat_id`,1) = \'¨\'), concat(\'request_archivelist.php?x_reference=\', replace(`req_chat_id`,\'¨\',\'\')), concat(\'request_grouplist.php?x_reference=\', `req_chat_id`))', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->url->IsCustom = TRUE; // Custom field
		$this->url->Sortable = FALSE; // Allow sort
		$this->fields['url'] = &$this->url;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`sample_req_cart_dispatch_app`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, if ((left(`req_chat_id`,1) = '¨'), concat('request_archivelist.php?x_reference=', replace(`req_chat_id`,'¨','')), concat('request_grouplist.php?x_reference=', `req_chat_id`)) AS `url` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, if ((left(`req_chat_id`,1) = '¨'), concat('request_archivelist.php?x_reference=', replace(`req_chat_id`,'¨','')), concat('request_grouplist.php?x_reference=', `req_chat_id`)) AS `url`, (SELECT `name` FROM `buyer_seller_view` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `sample_req_cart_dispatch_app`.`partner_id` LIMIT 1) AS `EV__partner_id` FROM `sample_req_cart_dispatch_app`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->partner_id->AdvancedSearch->SearchValue <> "" ||
			$this->partner_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->partner_id->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->company_id->DbValue = $row['company_id'];
		$this->partner_id->DbValue = $row['partner_id'];
		$this->old_ref->DbValue = $row['old_ref'];
		$this->design->DbValue = $row['design'];
		$this->color->DbValue = $row['color'];
		$this->size->DbValue = $row['size'];
		$this->quantity->DbValue = $row['quantity'];
		$this->delivery_week->DbValue = $row['delivery_week'];
		$this->status->DbValue = $row['status'];
		$this->upload->Upload->DbValue = $row['upload'];
		$this->remarks->DbValue = $row['remarks'];
		$this->sp_remarks->DbValue = $row['sp_remarks'];
		$this->pp_remarks->DbValue = $row['pp_remarks'];
		$this->po_remarks->DbValue = $row['po_remarks'];
		$this->price->DbValue = $row['price'];
		$this->declaration->DbValue = $row['declaration'];
		$this->bom->DbValue = $row['bom'];
		$this->purpose->DbValue = $row['purpose'];
		$this->label->DbValue = $row['label'];
		$this->ssd->DbValue = $row['ssd'];
		$this->pd_upload->Upload->DbValue = $row['pd_upload'];
		$this->da_comments->DbValue = $row['da_comments'];
		$this->da_status->DbValue = $row['da_status'];
		$this->da_operator->DbValue = $row['da_operator'];
		$this->da_datetime->DbValue = $row['da_datetime'];
		$this->req_chat_id->DbValue = $row['req_chat_id'];
		$this->url->DbValue = $row['url'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->upload->OldUploadPath = 'product_images/o/sample_cart/';
		$oldFiles = EmptyValue($row['upload']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['upload']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->upload->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->upload->oldPhysicalUploadPath() . $oldFile);
		}
		$this->pd_upload->OldUploadPath = '.p_uploads/sample_cart/dispatch/'. $this->id->CurrentValue . '';
		$oldFiles = EmptyValue($row['pd_upload']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['pd_upload']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->pd_upload->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->pd_upload->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "sample_req_cart_dispatch_applist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "sample_req_cart_dispatch_appview.php")
			return $Language->phrase("View");
		elseif ($pageName == "sample_req_cart_dispatch_appedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "sample_req_cart_dispatch_appadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "sample_req_cart_dispatch_applist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("sample_req_cart_dispatch_appview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("sample_req_cart_dispatch_appview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "sample_req_cart_dispatch_appadd.php?" . $this->getUrlParm($parm);
		else
			$url = "sample_req_cart_dispatch_appadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("sample_req_cart_dispatch_appedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("sample_req_cart_dispatch_appadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("sample_req_cart_dispatch_appdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->partner_id->setDbValue($rs->fields('partner_id'));
		$this->old_ref->setDbValue($rs->fields('old_ref'));
		$this->design->setDbValue($rs->fields('design'));
		$this->color->setDbValue($rs->fields('color'));
		$this->size->setDbValue($rs->fields('size'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->delivery_week->setDbValue($rs->fields('delivery_week'));
		$this->status->setDbValue($rs->fields('status'));
		$this->upload->Upload->DbValue = $rs->fields('upload');
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->sp_remarks->setDbValue($rs->fields('sp_remarks'));
		$this->pp_remarks->setDbValue($rs->fields('pp_remarks'));
		$this->po_remarks->setDbValue($rs->fields('po_remarks'));
		$this->price->setDbValue($rs->fields('price'));
		$this->declaration->setDbValue($rs->fields('declaration'));
		$this->bom->setDbValue($rs->fields('bom'));
		$this->purpose->setDbValue($rs->fields('purpose'));
		$this->label->setDbValue($rs->fields('label'));
		$this->ssd->setDbValue($rs->fields('ssd'));
		$this->pd_upload->Upload->DbValue = $rs->fields('pd_upload');
		$this->da_comments->setDbValue($rs->fields('da_comments'));
		$this->da_status->setDbValue($rs->fields('da_status'));
		$this->da_operator->setDbValue($rs->fields('da_operator'));
		$this->da_datetime->setDbValue($rs->fields('da_datetime'));
		$this->req_chat_id->setDbValue($rs->fields('req_chat_id'));
		$this->url->setDbValue($rs->fields('url'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// company_id
		// partner_id
		// old_ref
		// design
		// color
		// size
		// quantity
		// delivery_week
		// status

		$this->status->CellCssStyle = "white-space: nowrap;";

		// upload
		// remarks

		$this->remarks->CellCssStyle = "white-space: nowrap;";

		// sp_remarks
		// pp_remarks

		$this->pp_remarks->CellCssStyle = "white-space: nowrap;";

		// po_remarks
		// price

		$this->price->CellCssStyle = "white-space: nowrap;";

		// declaration
		$this->declaration->CellCssStyle = "white-space: nowrap;";

		// bom
		// purpose

		$this->purpose->CellCssStyle = "white-space: nowrap;";

		// label
		$this->label->CellCssStyle = "white-space: nowrap;";

		// ssd
		$this->ssd->CellCssStyle = "white-space: nowrap;";

		// pd_upload
		// da_comments
		// da_status
		// da_operator
		// da_datetime
		// req_chat_id

		$this->req_chat_id->CellCssStyle = "white-space: nowrap;";

		// url
		$this->url->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// company_id
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->ViewValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->ViewValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// partner_id
		if ($this->partner_id->VirtualValue <> "") {
			$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
		} else {
			$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `partner_type`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->ViewValue = NULL;
		}
		}
		$this->partner_id->ViewCustomAttributes = "";

		// old_ref
		$this->old_ref->ViewValue = $this->old_ref->CurrentValue;
		$this->old_ref->ViewCustomAttributes = "";

		// design
		$this->design->ViewValue = $this->design->CurrentValue;
		$this->design->ViewCustomAttributes = "";

		// color
		$this->color->ViewValue = $this->color->CurrentValue;
		$this->color->ViewCustomAttributes = "";

		// size
		$this->size->ViewValue = $this->size->CurrentValue;
		$this->size->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// delivery_week
		$curVal = strval($this->delivery_week->CurrentValue);
		if ($curVal <> "") {
			$this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
			if ($this->delivery_week->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->delivery_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->delivery_week->ViewValue = $this->delivery_week->CurrentValue;
				}
			}
		} else {
			$this->delivery_week->ViewValue = NULL;
		}
		$this->delivery_week->ViewCustomAttributes = "";

		// status
		$curVal = strval($this->status->CurrentValue);
		if ($curVal <> "") {
			$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
			if ($this->status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->status->ViewValue = $this->status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->status->ViewValue = $this->status->CurrentValue;
				}
			}
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// upload
		$this->upload->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->ImageWidth = 0;
			$this->upload->ImageHeight = 50;
			$this->upload->ImageAlt = $this->upload->alt();
			$this->upload->ViewValue = $this->upload->Upload->DbValue;
		} else {
			$this->upload->ViewValue = "";
		}
		$this->upload->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// sp_remarks
		$this->sp_remarks->ViewValue = $this->sp_remarks->CurrentValue;
		$this->sp_remarks->ViewCustomAttributes = "";

		// pp_remarks
		$this->pp_remarks->ViewValue = $this->pp_remarks->CurrentValue;
		$this->pp_remarks->ViewCustomAttributes = "";

		// po_remarks
		$this->po_remarks->ViewValue = $this->po_remarks->CurrentValue;
		$this->po_remarks->ViewCustomAttributes = "";

		// price
		$this->price->ViewValue = $this->price->CurrentValue;
		$this->price->ViewCustomAttributes = "";

		// declaration
		$this->declaration->ViewValue = $this->declaration->CurrentValue;
		$this->declaration->ViewCustomAttributes = "";

		// bom
		$this->bom->ViewValue = $this->bom->CurrentValue;
		$this->bom->ViewCustomAttributes = "";

		// purpose
		$curVal = strval($this->purpose->CurrentValue);
		if ($curVal <> "") {
			$this->purpose->ViewValue = $this->purpose->lookupCacheOption($curVal);
			if ($this->purpose->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->purpose->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->purpose->ViewValue = $this->purpose->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->purpose->ViewValue = $this->purpose->CurrentValue;
				}
			}
		} else {
			$this->purpose->ViewValue = NULL;
		}
		$this->purpose->ViewCustomAttributes = "";

		// label
		$curVal = strval($this->label->CurrentValue);
		if ($curVal <> "") {
			$this->label->ViewValue = $this->label->lookupCacheOption($curVal);
			if ($this->label->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->label->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->label->ViewValue = $this->label->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->label->ViewValue = $this->label->CurrentValue;
				}
			}
		} else {
			$this->label->ViewValue = NULL;
		}
		$this->label->ViewCustomAttributes = "";

		// ssd
		$this->ssd->ViewValue = $this->ssd->CurrentValue;
		$this->ssd->ViewValue = FormatDateTime($this->ssd->ViewValue, 0);
		$this->ssd->ViewCustomAttributes = "";

		// pd_upload
		$this->pd_upload->UploadPath = '.p_uploads/sample_cart/dispatch/'. $this->id->CurrentValue . '';
		if (!EmptyValue($this->pd_upload->Upload->DbValue)) {
			$this->pd_upload->ViewValue = $this->pd_upload->Upload->DbValue;
		} else {
			$this->pd_upload->ViewValue = "";
		}
		$this->pd_upload->ViewCustomAttributes = "";

		// da_comments
		$this->da_comments->ViewValue = $this->da_comments->CurrentValue;
		$this->da_comments->ViewCustomAttributes = "";

		// da_status
		$curVal = strval($this->da_status->CurrentValue);
		if ($curVal <> "") {
			$this->da_status->ViewValue = $this->da_status->lookupCacheOption($curVal);
			if ($this->da_status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "edit") ? "`grp` = 7 and `status` = 1 and `id` = 702" : "`grp` = 7 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->da_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->da_status->ViewValue = $this->da_status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->da_status->ViewValue = $this->da_status->CurrentValue;
				}
			}
		} else {
			$this->da_status->ViewValue = NULL;
		}
		$this->da_status->ViewCustomAttributes = "";

		// da_operator
		$this->da_operator->ViewValue = $this->da_operator->CurrentValue;
		$this->da_operator->ViewValue = FormatNumber($this->da_operator->ViewValue, 0, -2, -2, -2);
		$this->da_operator->ViewCustomAttributes = "";

		// da_datetime
		$this->da_datetime->ViewValue = $this->da_datetime->CurrentValue;
		$this->da_datetime->ViewValue = FormatDateTime($this->da_datetime->ViewValue, 0);
		$this->da_datetime->ViewCustomAttributes = "";

		// req_chat_id
		$this->req_chat_id->ViewValue = $this->req_chat_id->CurrentValue;
		$this->req_chat_id->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// partner_id
		$this->partner_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->partner_id->CurrentValue)) {
			$this->partner_id->HrefValue = "po_blist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
			$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
		} else {
			$this->partner_id->HrefValue = "";
		}
		$this->partner_id->TooltipValue = "";

		// old_ref
		$this->old_ref->LinkCustomAttributes = "";
		if (!EmptyValue($this->old_ref->CurrentValue)) {
			$this->old_ref->HrefValue = "sample_req_cart_statuslist.php?x__barcode=" . $this->old_ref->CurrentValue . "&z__barcode=LIKE"; // Add prefix/suffix
			$this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
		} else {
			$this->old_ref->HrefValue = "";
		}
		$this->old_ref->TooltipValue = "";

		// design
		$this->design->LinkCustomAttributes = "";
		$this->design->HrefValue = "";
		$this->design->TooltipValue = "";

		// color
		$this->color->LinkCustomAttributes = "";
		$this->color->HrefValue = "";
		$this->color->TooltipValue = "";

		// size
		$this->size->LinkCustomAttributes = "";
		$this->size->HrefValue = "";
		$this->size->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// delivery_week
		$this->delivery_week->LinkCustomAttributes = "";
		$this->delivery_week->HrefValue = "";
		$this->delivery_week->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// upload
		$this->upload->LinkCustomAttributes = "";
		$this->upload->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->HrefValue = "%u"; // Add prefix/suffix
			$this->upload->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
		} else {
			$this->upload->HrefValue = "";
		}
		$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
		$this->upload->TooltipValue = "";
		if ($this->upload->UseColorbox) {
			if (EmptyValue($this->upload->TooltipValue))
				$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->upload->LinkAttrs["data-rel"] = "sample_req_cart_dispatch_app_x_upload";
			AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
		}

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// sp_remarks
		$this->sp_remarks->LinkCustomAttributes = "";
		$this->sp_remarks->HrefValue = "";
		$this->sp_remarks->TooltipValue = "";

		// pp_remarks
		$this->pp_remarks->LinkCustomAttributes = "";
		$this->pp_remarks->HrefValue = "";
		$this->pp_remarks->TooltipValue = "";

		// po_remarks
		$this->po_remarks->LinkCustomAttributes = "";
		$this->po_remarks->HrefValue = "";
		$this->po_remarks->TooltipValue = "";

		// price
		$this->price->LinkCustomAttributes = "";
		$this->price->HrefValue = "";
		$this->price->TooltipValue = "";

		// declaration
		$this->declaration->LinkCustomAttributes = "";
		$this->declaration->HrefValue = "";
		$this->declaration->TooltipValue = "";

		// bom
		$this->bom->LinkCustomAttributes = "";
		$this->bom->HrefValue = "";
		$this->bom->TooltipValue = "";

		// purpose
		$this->purpose->LinkCustomAttributes = "";
		$this->purpose->HrefValue = "";
		$this->purpose->TooltipValue = "";

		// label
		$this->label->LinkCustomAttributes = "";
		$this->label->HrefValue = "";
		$this->label->TooltipValue = "";

		// ssd
		$this->ssd->LinkCustomAttributes = "";
		$this->ssd->HrefValue = "";
		$this->ssd->TooltipValue = "";

		// pd_upload
		$this->pd_upload->LinkCustomAttributes = "";
		$this->pd_upload->UploadPath = '.p_uploads/sample_cart/dispatch/'. $this->id->CurrentValue . '';
		if (!EmptyValue($this->pd_upload->Upload->DbValue)) {
			$this->pd_upload->HrefValue = "%u"; // Add prefix/suffix
			$this->pd_upload->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->pd_upload->HrefValue = FullUrl($this->pd_upload->HrefValue, "href");
		} else {
			$this->pd_upload->HrefValue = "";
		}
		$this->pd_upload->ExportHrefValue = $this->pd_upload->UploadPath . $this->pd_upload->Upload->DbValue;
		$this->pd_upload->TooltipValue = "";

		// da_comments
		$this->da_comments->LinkCustomAttributes = "";
		$this->da_comments->HrefValue = "";
		$this->da_comments->TooltipValue = "";

		// da_status
		$this->da_status->LinkCustomAttributes = "";
		$this->da_status->HrefValue = "";
		$this->da_status->TooltipValue = "";

		// da_operator
		$this->da_operator->LinkCustomAttributes = "";
		$this->da_operator->HrefValue = "";
		$this->da_operator->TooltipValue = "";

		// da_datetime
		$this->da_datetime->LinkCustomAttributes = "";
		$this->da_datetime->HrefValue = "";
		$this->da_datetime->TooltipValue = "";

		// req_chat_id
		$this->req_chat_id->LinkCustomAttributes = "";
		if (!EmptyValue($this->url->CurrentValue)) {
			$this->req_chat_id->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
			$this->req_chat_id->LinkAttrs["target"] = "_blank"; // Add target
			if ($this->isExport()) $this->req_chat_id->HrefValue = FullUrl($this->req_chat_id->HrefValue, "href");
		} else {
			$this->req_chat_id->HrefValue = "";
		}
		$this->req_chat_id->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$curVal = strval($this->company_id->CurrentValue);
		if ($curVal <> "") {
			$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
			if ($this->company_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->company_id->EditValue = $this->company_id->CurrentValue;
				}
			}
		} else {
			$this->company_id->EditValue = NULL;
		}
		$this->company_id->ViewCustomAttributes = "";

		// partner_id
		$this->partner_id->EditAttrs["class"] = "form-control";
		$this->partner_id->EditCustomAttributes = "";
		if ($this->partner_id->VirtualValue <> "") {
			$this->partner_id->EditValue = $this->partner_id->VirtualValue;
		} else {
			$this->partner_id->EditValue = $this->partner_id->CurrentValue;
		$curVal = strval($this->partner_id->CurrentValue);
		if ($curVal <> "") {
			$this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
			if ($this->partner_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1 and `partner_type`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->partner_id->EditValue = $this->partner_id->CurrentValue;
				}
			}
		} else {
			$this->partner_id->EditValue = NULL;
		}
		}
		$this->partner_id->ViewCustomAttributes = "";

		// old_ref
		$this->old_ref->EditAttrs["class"] = "form-control";
		$this->old_ref->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->old_ref->CurrentValue = HtmlDecode($this->old_ref->CurrentValue);
		$this->old_ref->EditValue = $this->old_ref->CurrentValue;
		$this->old_ref->PlaceHolder = RemoveHtml($this->old_ref->caption());

		// design
		$this->design->EditAttrs["class"] = "form-control";
		$this->design->EditCustomAttributes = "";
		$this->design->EditValue = $this->design->CurrentValue;
		$this->design->ViewCustomAttributes = "";

		// color
		$this->color->EditAttrs["class"] = "form-control";
		$this->color->EditCustomAttributes = "";
		$this->color->EditValue = $this->color->CurrentValue;
		$this->color->ViewCustomAttributes = "";

		// size
		$this->size->EditAttrs["class"] = "form-control";
		$this->size->EditCustomAttributes = "";
		$this->size->EditValue = $this->size->CurrentValue;
		$this->size->ViewCustomAttributes = "";

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// delivery_week
		$this->delivery_week->EditAttrs["class"] = "form-control";
		$this->delivery_week->EditCustomAttributes = "";
		$curVal = strval($this->delivery_week->CurrentValue);
		if ($curVal <> "") {
			$this->delivery_week->EditValue = $this->delivery_week->lookupCacheOption($curVal);
			if ($this->delivery_week->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->delivery_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->delivery_week->EditValue = $this->delivery_week->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->delivery_week->EditValue = $this->delivery_week->CurrentValue;
				}
			}
		} else {
			$this->delivery_week->EditValue = NULL;
		}
		$this->delivery_week->ViewCustomAttributes = "";

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";

		// upload
		$this->upload->EditAttrs["class"] = "form-control";
		$this->upload->EditCustomAttributes = "";
		$this->upload->UploadPath = 'product_images/o/sample_cart/';
		if (!EmptyValue($this->upload->Upload->DbValue)) {
			$this->upload->ImageWidth = 0;
			$this->upload->ImageHeight = 50;
			$this->upload->ImageAlt = $this->upload->alt();
			$this->upload->EditValue = $this->upload->Upload->DbValue;
		} else {
			$this->upload->EditValue = "";
		}
		$this->upload->ViewCustomAttributes = "";

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// sp_remarks
		$this->sp_remarks->EditAttrs["class"] = "form-control";
		$this->sp_remarks->EditCustomAttributes = "";
		$this->sp_remarks->EditValue = $this->sp_remarks->CurrentValue;
		$this->sp_remarks->ViewCustomAttributes = "";

		// pp_remarks
		$this->pp_remarks->EditAttrs["class"] = "form-control";
		$this->pp_remarks->EditCustomAttributes = "";
		$this->pp_remarks->EditValue = $this->pp_remarks->CurrentValue;
		$this->pp_remarks->ViewCustomAttributes = "";

		// po_remarks
		$this->po_remarks->EditAttrs["class"] = "form-control";
		$this->po_remarks->EditCustomAttributes = "";
		$this->po_remarks->EditValue = $this->po_remarks->CurrentValue;
		$this->po_remarks->ViewCustomAttributes = "";

		// price
		$this->price->EditAttrs["class"] = "form-control";
		$this->price->EditCustomAttributes = "";
		$this->price->EditValue = $this->price->CurrentValue;
		$this->price->ViewCustomAttributes = "";

		// declaration
		$this->declaration->EditAttrs["class"] = "form-control";
		$this->declaration->EditCustomAttributes = "";
		$this->declaration->EditValue = $this->declaration->CurrentValue;
		$this->declaration->ViewCustomAttributes = "";

		// bom
		$this->bom->EditAttrs["class"] = "form-control";
		$this->bom->EditCustomAttributes = "";
		$this->bom->EditValue = $this->bom->CurrentValue;
		$this->bom->ViewCustomAttributes = "";

		// purpose
		$this->purpose->EditAttrs["class"] = "form-control";
		$this->purpose->EditCustomAttributes = "";
		$curVal = strval($this->purpose->CurrentValue);
		if ($curVal <> "") {
			$this->purpose->EditValue = $this->purpose->lookupCacheOption($curVal);
			if ($this->purpose->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->purpose->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->purpose->EditValue = $this->purpose->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->purpose->EditValue = $this->purpose->CurrentValue;
				}
			}
		} else {
			$this->purpose->EditValue = NULL;
		}
		$this->purpose->ViewCustomAttributes = "";

		// label
		$this->label->EditAttrs["class"] = "form-control";
		$this->label->EditCustomAttributes = "";
		$curVal = strval($this->label->CurrentValue);
		if ($curVal <> "") {
			$this->label->EditValue = $this->label->lookupCacheOption($curVal);
			if ($this->label->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->label->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->label->EditValue = $this->label->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->label->EditValue = $this->label->CurrentValue;
				}
			}
		} else {
			$this->label->EditValue = NULL;
		}
		$this->label->ViewCustomAttributes = "";

		// ssd
		$this->ssd->EditAttrs["class"] = "form-control";
		$this->ssd->EditCustomAttributes = "";
		$this->ssd->EditValue = $this->ssd->CurrentValue;
		$this->ssd->EditValue = FormatDateTime($this->ssd->EditValue, 0);
		$this->ssd->ViewCustomAttributes = "";

		// pd_upload
		$this->pd_upload->EditAttrs["class"] = "form-control";
		$this->pd_upload->EditCustomAttributes = "";
		$this->pd_upload->UploadPath = '.p_uploads/sample_cart/dispatch/'. $this->id->CurrentValue . '';
		if (!EmptyValue($this->pd_upload->Upload->DbValue)) {
			$this->pd_upload->EditValue = $this->pd_upload->Upload->DbValue;
		} else {
			$this->pd_upload->EditValue = "";
		}
		$this->pd_upload->ViewCustomAttributes = "";

		// da_comments
		$this->da_comments->EditAttrs["class"] = "form-control";
		$this->da_comments->EditCustomAttributes = "";
		$this->da_comments->EditValue = $this->da_comments->CurrentValue;
		$this->da_comments->PlaceHolder = RemoveHtml($this->da_comments->caption());

		// da_status
		$this->da_status->EditAttrs["class"] = "form-control";
		$this->da_status->EditCustomAttributes = "";

		// da_operator
		// da_datetime
		// req_chat_id

		$this->req_chat_id->EditAttrs["class"] = "form-control";
		$this->req_chat_id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->req_chat_id->CurrentValue = HtmlDecode($this->req_chat_id->CurrentValue);
		$this->req_chat_id->EditValue = $this->req_chat_id->CurrentValue;
		$this->req_chat_id->PlaceHolder = RemoveHtml($this->req_chat_id->caption());

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->url->CurrentValue = HtmlDecode($this->url->CurrentValue);
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->old_ref);
					$doc->exportCaption($this->design);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->delivery_week);
					$doc->exportCaption($this->upload);
					$doc->exportCaption($this->sp_remarks);
					$doc->exportCaption($this->po_remarks);
					$doc->exportCaption($this->bom);
					$doc->exportCaption($this->pd_upload);
					$doc->exportCaption($this->da_comments);
					$doc->exportCaption($this->da_status);
					$doc->exportCaption($this->da_operator);
					$doc->exportCaption($this->da_datetime);
					$doc->exportCaption($this->req_chat_id);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->partner_id);
					$doc->exportCaption($this->old_ref);
					$doc->exportCaption($this->design);
					$doc->exportCaption($this->color);
					$doc->exportCaption($this->size);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->delivery_week);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->upload);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->pp_remarks);
					$doc->exportCaption($this->po_remarks);
					$doc->exportCaption($this->price);
					$doc->exportCaption($this->declaration);
					$doc->exportCaption($this->bom);
					$doc->exportCaption($this->da_status);
					$doc->exportCaption($this->da_operator);
					$doc->exportCaption($this->da_datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->old_ref);
						$doc->exportField($this->design);
						$doc->exportField($this->color);
						$doc->exportField($this->size);
						$doc->exportField($this->quantity);
						$doc->exportField($this->delivery_week);
						$doc->exportField($this->upload);
						$doc->exportField($this->sp_remarks);
						$doc->exportField($this->po_remarks);
						$doc->exportField($this->bom);
						$doc->exportField($this->pd_upload);
						$doc->exportField($this->da_comments);
						$doc->exportField($this->da_status);
						$doc->exportField($this->da_operator);
						$doc->exportField($this->da_datetime);
						$doc->exportField($this->req_chat_id);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->company_id);
						$doc->exportField($this->partner_id);
						$doc->exportField($this->old_ref);
						$doc->exportField($this->design);
						$doc->exportField($this->color);
						$doc->exportField($this->size);
						$doc->exportField($this->quantity);
						$doc->exportField($this->delivery_week);
						$doc->exportField($this->status);
						$doc->exportField($this->upload);
						$doc->exportField($this->remarks);
						$doc->exportField($this->pp_remarks);
						$doc->exportField($this->po_remarks);
						$doc->exportField($this->price);
						$doc->exportField($this->declaration);
						$doc->exportField($this->bom);
						$doc->exportField($this->da_status);
						$doc->exportField($this->da_operator);
						$doc->exportField($this->da_datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'upload') {
			$fldName = "upload";
			$fileNameFld = "upload";
		} elseif ($fldparm == 'pd_upload') {
			$fldName = "pd_upload";
			$fileNameFld = "pd_upload";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>