<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class sample_req_cart_dispatch_edit extends sample_req_cart_dispatch
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'sample_req_cart_dispatch';

	// Page object name
	public $PageObjName = "sample_req_cart_dispatch_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (sample_req_cart_dispatch)
		if (!isset($GLOBALS["sample_req_cart_dispatch"]) || get_class($GLOBALS["sample_req_cart_dispatch"]) == PROJECT_NAMESPACE . "sample_req_cart_dispatch") {
			$GLOBALS["sample_req_cart_dispatch"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["sample_req_cart_dispatch"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart_dispatch');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $sample_req_cart_dispatch;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($sample_req_cart_dispatch);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "sample_req_cart_dispatchview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("sample_req_cart_dispatchlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->company_id->setVisibility();
		$this->partner_id->setVisibility();
		$this->old_ref->setVisibility();
		$this->design->setVisibility();
		$this->color->setVisibility();
		$this->size->setVisibility();
		$this->quantity->setVisibility();
		$this->delivery_week->setVisibility();
		$this->status->Visible = FALSE;
		$this->upload->setVisibility();
		$this->remarks->setVisibility();
		$this->sp_remarks->setVisibility();
		$this->pp_remarks->setVisibility();
		$this->po_remarks->setVisibility();
		$this->price->setVisibility();
		$this->declaration->setVisibility();
		$this->dispatch->setVisibility();
		$this->bom->setVisibility();
		$this->d_upload->setVisibility();
		$this->da_comments->setVisibility();
		$this->da_status->setVisibility();
		$this->d_operator->setVisibility();
		$this->d_datetime->setVisibility();
		$this->purpose->setVisibility();
		$this->label->setVisibility();
		$this->ssd->setVisibility();
		$this->shipping_address->setVisibility();
		$this->req_chat_id->Visible = FALSE;
		$this->url->Visible = FALSE;
		$this->hideFieldsForAddEdit();
		$this->partner_id->Required = FALSE;
		$this->quantity->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->delivery_week);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->da_status);
		$this->setupLookupOptions($this->purpose);
		$this->setupLookupOptions($this->label);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("sample_req_cart_dispatchlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "sample_req_cart_dispatchlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->upload->Upload->Index = $CurrentForm->Index;
		$this->upload->Upload->uploadFile();
		$this->upload->CurrentValue = $this->upload->Upload->FileName;
		$this->d_upload->Upload->Index = $CurrentForm->Index;
		$this->d_upload->Upload->uploadFile();
		$this->d_upload->CurrentValue = $this->d_upload->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'company_id' first before field var 'x_company_id'
		$val = $CurrentForm->hasValue("company_id") ? $CurrentForm->getValue("company_id") : $CurrentForm->getValue("x_company_id");
		if (!$this->company_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->company_id->Visible = FALSE; // Disable update for API request
			else
				$this->company_id->setFormValue($val);
		}

		// Check field name 'partner_id' first before field var 'x_partner_id'
		$val = $CurrentForm->hasValue("partner_id") ? $CurrentForm->getValue("partner_id") : $CurrentForm->getValue("x_partner_id");
		if (!$this->partner_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->partner_id->Visible = FALSE; // Disable update for API request
			else
				$this->partner_id->setFormValue($val);
		}

		// Check field name 'old_ref' first before field var 'x_old_ref'
		$val = $CurrentForm->hasValue("old_ref") ? $CurrentForm->getValue("old_ref") : $CurrentForm->getValue("x_old_ref");
		if (!$this->old_ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->old_ref->Visible = FALSE; // Disable update for API request
			else
				$this->old_ref->setFormValue($val);
		}

		// Check field name 'design' first before field var 'x_design'
		$val = $CurrentForm->hasValue("design") ? $CurrentForm->getValue("design") : $CurrentForm->getValue("x_design");
		if (!$this->design->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->design->Visible = FALSE; // Disable update for API request
			else
				$this->design->setFormValue($val);
		}

		// Check field name 'color' first before field var 'x_color'
		$val = $CurrentForm->hasValue("color") ? $CurrentForm->getValue("color") : $CurrentForm->getValue("x_color");
		if (!$this->color->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->color->Visible = FALSE; // Disable update for API request
			else
				$this->color->setFormValue($val);
		}

		// Check field name 'size' first before field var 'x_size'
		$val = $CurrentForm->hasValue("size") ? $CurrentForm->getValue("size") : $CurrentForm->getValue("x_size");
		if (!$this->size->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->size->Visible = FALSE; // Disable update for API request
			else
				$this->size->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'delivery_week' first before field var 'x_delivery_week'
		$val = $CurrentForm->hasValue("delivery_week") ? $CurrentForm->getValue("delivery_week") : $CurrentForm->getValue("x_delivery_week");
		if (!$this->delivery_week->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery_week->Visible = FALSE; // Disable update for API request
			else
				$this->delivery_week->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'sp_remarks' first before field var 'x_sp_remarks'
		$val = $CurrentForm->hasValue("sp_remarks") ? $CurrentForm->getValue("sp_remarks") : $CurrentForm->getValue("x_sp_remarks");
		if (!$this->sp_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->sp_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->sp_remarks->setFormValue($val);
		}

		// Check field name 'pp_remarks' first before field var 'x_pp_remarks'
		$val = $CurrentForm->hasValue("pp_remarks") ? $CurrentForm->getValue("pp_remarks") : $CurrentForm->getValue("x_pp_remarks");
		if (!$this->pp_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->pp_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->pp_remarks->setFormValue($val);
		}

		// Check field name 'po_remarks' first before field var 'x_po_remarks'
		$val = $CurrentForm->hasValue("po_remarks") ? $CurrentForm->getValue("po_remarks") : $CurrentForm->getValue("x_po_remarks");
		if (!$this->po_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->po_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->po_remarks->setFormValue($val);
		}

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}

		// Check field name 'declaration' first before field var 'x_declaration'
		$val = $CurrentForm->hasValue("declaration") ? $CurrentForm->getValue("declaration") : $CurrentForm->getValue("x_declaration");
		if (!$this->declaration->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->declaration->Visible = FALSE; // Disable update for API request
			else
				$this->declaration->setFormValue($val);
		}

		// Check field name 'dispatch' first before field var 'x_dispatch'
		$val = $CurrentForm->hasValue("dispatch") ? $CurrentForm->getValue("dispatch") : $CurrentForm->getValue("x_dispatch");
		if (!$this->dispatch->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dispatch->Visible = FALSE; // Disable update for API request
			else
				$this->dispatch->setFormValue($val);
		}

		// Check field name 'bom' first before field var 'x_bom'
		$val = $CurrentForm->hasValue("bom") ? $CurrentForm->getValue("bom") : $CurrentForm->getValue("x_bom");
		if (!$this->bom->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->bom->Visible = FALSE; // Disable update for API request
			else
				$this->bom->setFormValue($val);
		}

		// Check field name 'da_comments' first before field var 'x_da_comments'
		$val = $CurrentForm->hasValue("da_comments") ? $CurrentForm->getValue("da_comments") : $CurrentForm->getValue("x_da_comments");
		if (!$this->da_comments->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->da_comments->Visible = FALSE; // Disable update for API request
			else
				$this->da_comments->setFormValue($val);
		}

		// Check field name 'da_status' first before field var 'x_da_status'
		$val = $CurrentForm->hasValue("da_status") ? $CurrentForm->getValue("da_status") : $CurrentForm->getValue("x_da_status");
		if (!$this->da_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->da_status->Visible = FALSE; // Disable update for API request
			else
				$this->da_status->setFormValue($val);
		}

		// Check field name 'd_operator' first before field var 'x_d_operator'
		$val = $CurrentForm->hasValue("d_operator") ? $CurrentForm->getValue("d_operator") : $CurrentForm->getValue("x_d_operator");
		if (!$this->d_operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_operator->Visible = FALSE; // Disable update for API request
			else
				$this->d_operator->setFormValue($val);
		}

		// Check field name 'd_datetime' first before field var 'x_d_datetime'
		$val = $CurrentForm->hasValue("d_datetime") ? $CurrentForm->getValue("d_datetime") : $CurrentForm->getValue("x_d_datetime");
		if (!$this->d_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->d_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->d_datetime->setFormValue($val);
			$this->d_datetime->CurrentValue = UnFormatDateTime($this->d_datetime->CurrentValue, 0);
		}

		// Check field name 'purpose' first before field var 'x_purpose'
		$val = $CurrentForm->hasValue("purpose") ? $CurrentForm->getValue("purpose") : $CurrentForm->getValue("x_purpose");
		if (!$this->purpose->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->purpose->Visible = FALSE; // Disable update for API request
			else
				$this->purpose->setFormValue($val);
		}

		// Check field name 'label' first before field var 'x_label'
		$val = $CurrentForm->hasValue("label") ? $CurrentForm->getValue("label") : $CurrentForm->getValue("x_label");
		if (!$this->label->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->label->Visible = FALSE; // Disable update for API request
			else
				$this->label->setFormValue($val);
		}

		// Check field name 'ssd' first before field var 'x_ssd'
		$val = $CurrentForm->hasValue("ssd") ? $CurrentForm->getValue("ssd") : $CurrentForm->getValue("x_ssd");
		if (!$this->ssd->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ssd->Visible = FALSE; // Disable update for API request
			else
				$this->ssd->setFormValue($val);
			$this->ssd->CurrentValue = UnFormatDateTime($this->ssd->CurrentValue, 0);
		}

		// Check field name 'shipping_address' first before field var 'x_shipping_address'
		$val = $CurrentForm->hasValue("shipping_address") ? $CurrentForm->getValue("shipping_address") : $CurrentForm->getValue("x_shipping_address");
		if (!$this->shipping_address->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->shipping_address->Visible = FALSE; // Disable update for API request
			else
				$this->shipping_address->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->company_id->CurrentValue = $this->company_id->FormValue;
		$this->partner_id->CurrentValue = $this->partner_id->FormValue;
		$this->old_ref->CurrentValue = $this->old_ref->FormValue;
		$this->design->CurrentValue = $this->design->FormValue;
		$this->color->CurrentValue = $this->color->FormValue;
		$this->size->CurrentValue = $this->size->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->delivery_week->CurrentValue = $this->delivery_week->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->sp_remarks->CurrentValue = $this->sp_remarks->FormValue;
		$this->pp_remarks->CurrentValue = $this->pp_remarks->FormValue;
		$this->po_remarks->CurrentValue = $this->po_remarks->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->declaration->CurrentValue = $this->declaration->FormValue;
		$this->dispatch->CurrentValue = $this->dispatch->FormValue;
		$this->bom->CurrentValue = $this->bom->FormValue;
		$this->da_comments->CurrentValue = $this->da_comments->FormValue;
		$this->da_status->CurrentValue = $this->da_status->FormValue;
		$this->d_operator->CurrentValue = $this->d_operator->FormValue;
		$this->d_datetime->CurrentValue = $this->d_datetime->FormValue;
		$this->d_datetime->CurrentValue = UnFormatDateTime($this->d_datetime->CurrentValue, 0);
		$this->purpose->CurrentValue = $this->purpose->FormValue;
		$this->label->CurrentValue = $this->label->FormValue;
		$this->ssd->CurrentValue = $this->ssd->FormValue;
		$this->ssd->CurrentValue = UnFormatDateTime($this->ssd->CurrentValue, 0);
		$this->shipping_address->CurrentValue = $this->shipping_address->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->company_id->setDbValue($row['company_id']);
		$this->partner_id->setDbValue($row['partner_id']);
		if (array_key_exists('EV__partner_id', $rs->fields)) {
			$this->partner_id->VirtualValue = $rs->fields('EV__partner_id'); // Set up virtual field value
		} else {
			$this->partner_id->VirtualValue = ""; // Clear value
		}
		$this->old_ref->setDbValue($row['old_ref']);
		$this->design->setDbValue($row['design']);
		$this->color->setDbValue($row['color']);
		$this->size->setDbValue($row['size']);
		$this->quantity->setDbValue($row['quantity']);
		$this->delivery_week->setDbValue($row['delivery_week']);
		$this->status->setDbValue($row['status']);
		$this->upload->Upload->DbValue = $row['upload'];
		$this->upload->setDbValue($this->upload->Upload->DbValue);
		$this->remarks->setDbValue($row['remarks']);
		$this->sp_remarks->setDbValue($row['sp_remarks']);
		$this->pp_remarks->setDbValue($row['pp_remarks']);
		$this->po_remarks->setDbValue($row['po_remarks']);
		$this->price->setDbValue($row['price']);
		$this->declaration->setDbValue($row['declaration']);
		$this->dispatch->setDbValue($row['dispatch']);
		$this->bom->setDbValue($row['bom']);
		$this->d_upload->Upload->DbValue = $row['d_upload'];
		$this->d_upload->setDbValue($this->d_upload->Upload->DbValue);
		$this->da_comments->setDbValue($row['da_comments']);
		$this->da_status->setDbValue($row['da_status']);
		$this->d_operator->setDbValue($row['d_operator']);
		$this->d_datetime->setDbValue($row['d_datetime']);
		$this->purpose->setDbValue($row['purpose']);
		$this->label->setDbValue($row['label']);
		$this->ssd->setDbValue($row['ssd']);
		$this->shipping_address->setDbValue($row['shipping_address']);
		$this->req_chat_id->setDbValue($row['req_chat_id']);
		$this->url->setDbValue($row['url']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['company_id'] = NULL;
		$row['partner_id'] = NULL;
		$row['old_ref'] = NULL;
		$row['design'] = NULL;
		$row['color'] = NULL;
		$row['size'] = NULL;
		$row['quantity'] = NULL;
		$row['delivery_week'] = NULL;
		$row['status'] = NULL;
		$row['upload'] = NULL;
		$row['remarks'] = NULL;
		$row['sp_remarks'] = NULL;
		$row['pp_remarks'] = NULL;
		$row['po_remarks'] = NULL;
		$row['price'] = NULL;
		$row['declaration'] = NULL;
		$row['dispatch'] = NULL;
		$row['bom'] = NULL;
		$row['d_upload'] = NULL;
		$row['da_comments'] = NULL;
		$row['da_status'] = NULL;
		$row['d_operator'] = NULL;
		$row['d_datetime'] = NULL;
		$row['purpose'] = NULL;
		$row['label'] = NULL;
		$row['ssd'] = NULL;
		$row['shipping_address'] = NULL;
		$row['req_chat_id'] = NULL;
		$row['url'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// company_id
		// partner_id
		// old_ref
		// design
		// color
		// size
		// quantity
		// delivery_week
		// status
		// upload
		// remarks
		// sp_remarks
		// pp_remarks
		// po_remarks
		// price
		// declaration
		// dispatch
		// bom
		// d_upload
		// da_comments
		// da_status
		// d_operator
		// d_datetime
		// purpose
		// label
		// ssd
		// shipping_address
		// req_chat_id
		// url

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// old_ref
			$this->old_ref->ViewValue = $this->old_ref->CurrentValue;
			$this->old_ref->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// delivery_week
			$curVal = strval($this->delivery_week->CurrentValue);
			if ($curVal <> "") {
				$this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
				if ($this->delivery_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->delivery_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->delivery_week->ViewValue = $this->delivery_week->CurrentValue;
					}
				}
			} else {
				$this->delivery_week->ViewValue = NULL;
			}
			$this->delivery_week->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// upload
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->ViewValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->ViewValue = "";
			}
			$this->upload->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// sp_remarks
			$this->sp_remarks->ViewValue = $this->sp_remarks->CurrentValue;
			$this->sp_remarks->ViewCustomAttributes = "";

			// pp_remarks
			$this->pp_remarks->ViewValue = $this->pp_remarks->CurrentValue;
			$this->pp_remarks->ViewCustomAttributes = "";

			// po_remarks
			$this->po_remarks->ViewValue = $this->po_remarks->CurrentValue;
			$this->po_remarks->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewCustomAttributes = "";

			// declaration
			$this->declaration->ViewValue = $this->declaration->CurrentValue;
			$this->declaration->ViewCustomAttributes = "";

			// dispatch
			$this->dispatch->ViewValue = $this->dispatch->CurrentValue;
			$this->dispatch->ViewCustomAttributes = "";

			// bom
			$this->bom->ViewValue = $this->bom->CurrentValue;
			$this->bom->ViewCustomAttributes = "";

			// d_upload
			$this->d_upload->UploadPath = '.p_uploads/sample_cart/dispatch/'. $this->id->CurrentValue . '';
			if (!EmptyValue($this->d_upload->Upload->DbValue)) {
				$this->d_upload->ViewValue = $this->d_upload->Upload->DbValue;
			} else {
				$this->d_upload->ViewValue = "";
			}
			$this->d_upload->ViewCustomAttributes = "";

			// da_comments
			$this->da_comments->ViewValue = $this->da_comments->CurrentValue;
			$this->da_comments->ViewCustomAttributes = "";

			// da_status
			$curVal = strval($this->da_status->CurrentValue);
			if ($curVal <> "") {
				$this->da_status->ViewValue = $this->da_status->lookupCacheOption($curVal);
				if ($this->da_status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "edit") ? "`grp` = 7 and `status` = 1 and `id` = 703" : "`grp` = 7 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->da_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->da_status->ViewValue = $this->da_status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->da_status->ViewValue = $this->da_status->CurrentValue;
					}
				}
			} else {
				$this->da_status->ViewValue = NULL;
			}
			$this->da_status->ViewCustomAttributes = "";

			// d_operator
			$this->d_operator->ViewValue = $this->d_operator->CurrentValue;
			$this->d_operator->ViewValue = FormatNumber($this->d_operator->ViewValue, 0, -2, -2, -2);
			$this->d_operator->ViewCustomAttributes = "";

			// d_datetime
			$this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
			$this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, 0);
			$this->d_datetime->ViewCustomAttributes = "";

			// purpose
			$curVal = strval($this->purpose->CurrentValue);
			if ($curVal <> "") {
				$this->purpose->ViewValue = $this->purpose->lookupCacheOption($curVal);
				if ($this->purpose->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->purpose->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->purpose->ViewValue = $this->purpose->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->purpose->ViewValue = $this->purpose->CurrentValue;
					}
				}
			} else {
				$this->purpose->ViewValue = NULL;
			}
			$this->purpose->ViewCustomAttributes = "";

			// label
			$curVal = strval($this->label->CurrentValue);
			if ($curVal <> "") {
				$this->label->ViewValue = $this->label->lookupCacheOption($curVal);
				if ($this->label->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->label->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->label->ViewValue = $this->label->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->label->ViewValue = $this->label->CurrentValue;
					}
				}
			} else {
				$this->label->ViewValue = NULL;
			}
			$this->label->ViewCustomAttributes = "";

			// ssd
			$this->ssd->ViewValue = $this->ssd->CurrentValue;
			$this->ssd->ViewValue = FormatDateTime($this->ssd->ViewValue, 0);
			$this->ssd->ViewCustomAttributes = "";

			// shipping_address
			$this->shipping_address->ViewValue = $this->shipping_address->CurrentValue;
			$this->shipping_address->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->partner_id->CurrentValue)) {
				$this->partner_id->HrefValue = "po_blist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
				$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
			} else {
				$this->partner_id->HrefValue = "";
			}
			$this->partner_id->TooltipValue = "";

			// old_ref
			$this->old_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->old_ref->CurrentValue)) {
				$this->old_ref->HrefValue = "sample_req_cart_statuslist.php?x__barcode=" . $this->old_ref->CurrentValue . "&z__barcode=LIKE"; // Add prefix/suffix
				$this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
			} else {
				$this->old_ref->HrefValue = "";
			}
			$this->old_ref->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// delivery_week
			$this->delivery_week->LinkCustomAttributes = "";
			$this->delivery_week->HrefValue = "";
			$this->delivery_week->TooltipValue = "";

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = "%u"; // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
			$this->upload->TooltipValue = "";
			if ($this->upload->UseColorbox) {
				if (EmptyValue($this->upload->TooltipValue))
					$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->upload->LinkAttrs["data-rel"] = "sample_req_cart_dispatch_x_upload";
				AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
			}

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// sp_remarks
			$this->sp_remarks->LinkCustomAttributes = "";
			$this->sp_remarks->HrefValue = "";
			$this->sp_remarks->TooltipValue = "";

			// pp_remarks
			$this->pp_remarks->LinkCustomAttributes = "";
			$this->pp_remarks->HrefValue = "";
			$this->pp_remarks->TooltipValue = "";

			// po_remarks
			$this->po_remarks->LinkCustomAttributes = "";
			$this->po_remarks->HrefValue = "";
			$this->po_remarks->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// declaration
			$this->declaration->LinkCustomAttributes = "";
			$this->declaration->HrefValue = "";
			$this->declaration->TooltipValue = "";

			// dispatch
			$this->dispatch->LinkCustomAttributes = "";
			$this->dispatch->HrefValue = "";
			$this->dispatch->TooltipValue = "";

			// bom
			$this->bom->LinkCustomAttributes = "";
			$this->bom->HrefValue = "";
			$this->bom->TooltipValue = "";

			// d_upload
			$this->d_upload->LinkCustomAttributes = "";
			$this->d_upload->HrefValue = "";
			$this->d_upload->ExportHrefValue = $this->d_upload->UploadPath . $this->d_upload->Upload->DbValue;
			$this->d_upload->TooltipValue = "";

			// da_comments
			$this->da_comments->LinkCustomAttributes = "";
			$this->da_comments->HrefValue = "";
			$this->da_comments->TooltipValue = "";

			// da_status
			$this->da_status->LinkCustomAttributes = "";
			$this->da_status->HrefValue = "";
			$this->da_status->TooltipValue = "";

			// d_operator
			$this->d_operator->LinkCustomAttributes = "";
			$this->d_operator->HrefValue = "";
			$this->d_operator->TooltipValue = "";

			// d_datetime
			$this->d_datetime->LinkCustomAttributes = "";
			$this->d_datetime->HrefValue = "";
			$this->d_datetime->TooltipValue = "";

			// purpose
			$this->purpose->LinkCustomAttributes = "";
			$this->purpose->HrefValue = "";
			$this->purpose->TooltipValue = "";

			// label
			$this->label->LinkCustomAttributes = "";
			$this->label->HrefValue = "";
			$this->label->TooltipValue = "";

			// ssd
			$this->ssd->LinkCustomAttributes = "";
			$this->ssd->HrefValue = "";
			$this->ssd->TooltipValue = "";

			// shipping_address
			$this->shipping_address->LinkCustomAttributes = "";
			$this->shipping_address->HrefValue = "";
			$this->shipping_address->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->EditValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->EditValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->EditValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->EditValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// partner_id
			$this->partner_id->EditAttrs["class"] = "form-control";
			$this->partner_id->EditCustomAttributes = "";
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->EditValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->EditValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->EditValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_id->EditValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->EditValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->EditValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// old_ref
			$this->old_ref->EditAttrs["class"] = "form-control";
			$this->old_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->old_ref->CurrentValue = HtmlDecode($this->old_ref->CurrentValue);
			$this->old_ref->EditValue = HtmlEncode($this->old_ref->CurrentValue);
			$this->old_ref->PlaceHolder = RemoveHtml($this->old_ref->caption());

			// design
			$this->design->EditAttrs["class"] = "form-control";
			$this->design->EditCustomAttributes = "";
			$this->design->EditValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// color
			$this->color->EditAttrs["class"] = "form-control";
			$this->color->EditCustomAttributes = "";
			$this->color->EditValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// size
			$this->size->EditAttrs["class"] = "form-control";
			$this->size->EditCustomAttributes = "";
			$this->size->EditValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = $this->quantity->CurrentValue;
			$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// delivery_week
			$this->delivery_week->EditAttrs["class"] = "form-control";
			$this->delivery_week->EditCustomAttributes = "";
			$curVal = strval($this->delivery_week->CurrentValue);
			if ($curVal <> "") {
				$this->delivery_week->EditValue = $this->delivery_week->lookupCacheOption($curVal);
				if ($this->delivery_week->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->delivery_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->delivery_week->EditValue = $this->delivery_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->delivery_week->EditValue = $this->delivery_week->CurrentValue;
					}
				}
			} else {
				$this->delivery_week->EditValue = NULL;
			}
			$this->delivery_week->ViewCustomAttributes = "";

			// upload
			$this->upload->EditAttrs["class"] = "form-control";
			$this->upload->EditCustomAttributes = "";
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->EditValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->EditValue = "";
			}
			$this->upload->ViewCustomAttributes = "";

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// sp_remarks
			$this->sp_remarks->EditAttrs["class"] = "form-control";
			$this->sp_remarks->EditCustomAttributes = "";
			$this->sp_remarks->EditValue = $this->sp_remarks->CurrentValue;
			$this->sp_remarks->ViewCustomAttributes = "";

			// pp_remarks
			$this->pp_remarks->EditAttrs["class"] = "form-control";
			$this->pp_remarks->EditCustomAttributes = "";
			$this->pp_remarks->EditValue = $this->pp_remarks->CurrentValue;
			$this->pp_remarks->ViewCustomAttributes = "";

			// po_remarks
			$this->po_remarks->EditAttrs["class"] = "form-control";
			$this->po_remarks->EditCustomAttributes = "";
			$this->po_remarks->EditValue = $this->po_remarks->CurrentValue;
			$this->po_remarks->ViewCustomAttributes = "";

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = $this->price->CurrentValue;
			$this->price->ViewCustomAttributes = "";

			// declaration
			$this->declaration->EditAttrs["class"] = "form-control";
			$this->declaration->EditCustomAttributes = "";
			$this->declaration->EditValue = $this->declaration->CurrentValue;
			$this->declaration->ViewCustomAttributes = "";

			// dispatch
			$this->dispatch->EditAttrs["class"] = "form-control";
			$this->dispatch->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->dispatch->CurrentValue = HtmlDecode($this->dispatch->CurrentValue);
			$this->dispatch->EditValue = HtmlEncode($this->dispatch->CurrentValue);
			$this->dispatch->PlaceHolder = RemoveHtml($this->dispatch->caption());

			// bom
			$this->bom->EditAttrs["class"] = "form-control";
			$this->bom->EditCustomAttributes = "";
			$this->bom->EditValue = HtmlEncode($this->bom->CurrentValue);
			$this->bom->PlaceHolder = RemoveHtml($this->bom->caption());

			// d_upload
			$this->d_upload->EditAttrs["class"] = "form-control";
			$this->d_upload->EditCustomAttributes = "";
			$this->d_upload->UploadPath = '.p_uploads/sample_cart/dispatch/'. $this->id->CurrentValue . '';
			if (!EmptyValue($this->d_upload->Upload->DbValue)) {
				$this->d_upload->EditValue = $this->d_upload->Upload->DbValue;
			} else {
				$this->d_upload->EditValue = "";
			}
			if (!EmptyValue($this->d_upload->CurrentValue))
					$this->d_upload->Upload->FileName = $this->d_upload->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->d_upload);

			// da_comments
			$this->da_comments->EditAttrs["class"] = "form-control";
			$this->da_comments->EditCustomAttributes = "";
			$this->da_comments->EditValue = HtmlEncode($this->da_comments->CurrentValue);
			$this->da_comments->PlaceHolder = RemoveHtml($this->da_comments->caption());

			// da_status
			$this->da_status->EditAttrs["class"] = "form-control";
			$this->da_status->EditCustomAttributes = "";
			$curVal = trim(strval($this->da_status->CurrentValue));
			if ($curVal <> "")
				$this->da_status->ViewValue = $this->da_status->lookupCacheOption($curVal);
			else
				$this->da_status->ViewValue = $this->da_status->Lookup !== NULL && is_array($this->da_status->Lookup->Options) ? $curVal : NULL;
			if ($this->da_status->ViewValue !== NULL) { // Load from cache
				$this->da_status->EditValue = array_values($this->da_status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->da_status->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "edit") ? "`grp` = 7 and `status` = 1 and `id` = 703" : "`grp` = 7 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->da_status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->da_status->EditValue = $arwrk;
			}

			// d_operator
			// d_datetime
			// purpose

			$this->purpose->EditAttrs["class"] = "form-control";
			$this->purpose->EditCustomAttributes = "";
			$curVal = strval($this->purpose->CurrentValue);
			if ($curVal <> "") {
				$this->purpose->EditValue = $this->purpose->lookupCacheOption($curVal);
				if ($this->purpose->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->purpose->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->purpose->EditValue = $this->purpose->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->purpose->EditValue = $this->purpose->CurrentValue;
					}
				}
			} else {
				$this->purpose->EditValue = NULL;
			}
			$this->purpose->ViewCustomAttributes = "";

			// label
			$this->label->EditAttrs["class"] = "form-control";
			$this->label->EditCustomAttributes = "";
			$curVal = strval($this->label->CurrentValue);
			if ($curVal <> "") {
				$this->label->EditValue = $this->label->lookupCacheOption($curVal);
				if ($this->label->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->label->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->label->EditValue = $this->label->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->label->EditValue = $this->label->CurrentValue;
					}
				}
			} else {
				$this->label->EditValue = NULL;
			}
			$this->label->ViewCustomAttributes = "";

			// ssd
			$this->ssd->EditAttrs["class"] = "form-control";
			$this->ssd->EditCustomAttributes = "";
			$this->ssd->EditValue = $this->ssd->CurrentValue;
			$this->ssd->EditValue = FormatDateTime($this->ssd->EditValue, 0);
			$this->ssd->ViewCustomAttributes = "";

			// shipping_address
			$this->shipping_address->EditAttrs["class"] = "form-control";
			$this->shipping_address->EditCustomAttributes = "";
			$this->shipping_address->EditValue = $this->shipping_address->CurrentValue;
			$this->shipping_address->ViewCustomAttributes = "";

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->partner_id->CurrentValue)) {
				$this->partner_id->HrefValue = "po_blist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
				$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
			} else {
				$this->partner_id->HrefValue = "";
			}
			$this->partner_id->TooltipValue = "";

			// old_ref
			$this->old_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->old_ref->CurrentValue)) {
				$this->old_ref->HrefValue = "sample_req_cart_statuslist.php?x__barcode=" . $this->old_ref->CurrentValue . "&z__barcode=LIKE"; // Add prefix/suffix
				$this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
			} else {
				$this->old_ref->HrefValue = "";
			}

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// delivery_week
			$this->delivery_week->LinkCustomAttributes = "";
			$this->delivery_week->HrefValue = "";
			$this->delivery_week->TooltipValue = "";

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = "%u"; // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
			$this->upload->TooltipValue = "";
			if ($this->upload->UseColorbox) {
				if (EmptyValue($this->upload->TooltipValue))
					$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->upload->LinkAttrs["data-rel"] = "sample_req_cart_dispatch_x_upload";
				AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
			}

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// sp_remarks
			$this->sp_remarks->LinkCustomAttributes = "";
			$this->sp_remarks->HrefValue = "";
			$this->sp_remarks->TooltipValue = "";

			// pp_remarks
			$this->pp_remarks->LinkCustomAttributes = "";
			$this->pp_remarks->HrefValue = "";
			$this->pp_remarks->TooltipValue = "";

			// po_remarks
			$this->po_remarks->LinkCustomAttributes = "";
			$this->po_remarks->HrefValue = "";
			$this->po_remarks->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// declaration
			$this->declaration->LinkCustomAttributes = "";
			$this->declaration->HrefValue = "";
			$this->declaration->TooltipValue = "";

			// dispatch
			$this->dispatch->LinkCustomAttributes = "";
			$this->dispatch->HrefValue = "";

			// bom
			$this->bom->LinkCustomAttributes = "";
			$this->bom->HrefValue = "";

			// d_upload
			$this->d_upload->LinkCustomAttributes = "";
			$this->d_upload->HrefValue = "";
			$this->d_upload->ExportHrefValue = $this->d_upload->UploadPath . $this->d_upload->Upload->DbValue;

			// da_comments
			$this->da_comments->LinkCustomAttributes = "";
			$this->da_comments->HrefValue = "";

			// da_status
			$this->da_status->LinkCustomAttributes = "";
			$this->da_status->HrefValue = "";

			// d_operator
			$this->d_operator->LinkCustomAttributes = "";
			$this->d_operator->HrefValue = "";

			// d_datetime
			$this->d_datetime->LinkCustomAttributes = "";
			$this->d_datetime->HrefValue = "";

			// purpose
			$this->purpose->LinkCustomAttributes = "";
			$this->purpose->HrefValue = "";
			$this->purpose->TooltipValue = "";

			// label
			$this->label->LinkCustomAttributes = "";
			$this->label->HrefValue = "";
			$this->label->TooltipValue = "";

			// ssd
			$this->ssd->LinkCustomAttributes = "";
			$this->ssd->HrefValue = "";
			$this->ssd->TooltipValue = "";

			// shipping_address
			$this->shipping_address->LinkCustomAttributes = "";
			$this->shipping_address->HrefValue = "";
			$this->shipping_address->TooltipValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->company_id->Required) {
			if (!$this->company_id->IsDetailKey && $this->company_id->FormValue != NULL && $this->company_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->company_id->caption(), $this->company_id->RequiredErrorMessage));
			}
		}
		if ($this->partner_id->Required) {
			if (!$this->partner_id->IsDetailKey && $this->partner_id->FormValue != NULL && $this->partner_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->partner_id->caption(), $this->partner_id->RequiredErrorMessage));
			}
		}
		if ($this->old_ref->Required) {
			if (!$this->old_ref->IsDetailKey && $this->old_ref->FormValue != NULL && $this->old_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->old_ref->caption(), $this->old_ref->RequiredErrorMessage));
			}
		}
		if ($this->design->Required) {
			if (!$this->design->IsDetailKey && $this->design->FormValue != NULL && $this->design->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->design->caption(), $this->design->RequiredErrorMessage));
			}
		}
		if ($this->color->Required) {
			if (!$this->color->IsDetailKey && $this->color->FormValue != NULL && $this->color->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->color->caption(), $this->color->RequiredErrorMessage));
			}
		}
		if ($this->size->Required) {
			if (!$this->size->IsDetailKey && $this->size->FormValue != NULL && $this->size->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->size->caption(), $this->size->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if ($this->delivery_week->Required) {
			if (!$this->delivery_week->IsDetailKey && $this->delivery_week->FormValue != NULL && $this->delivery_week->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_week->caption(), $this->delivery_week->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->upload->Required) {
			if ($this->upload->Upload->FileName == "" && !$this->upload->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->upload->caption(), $this->upload->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->sp_remarks->Required) {
			if (!$this->sp_remarks->IsDetailKey && $this->sp_remarks->FormValue != NULL && $this->sp_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->sp_remarks->caption(), $this->sp_remarks->RequiredErrorMessage));
			}
		}
		if ($this->pp_remarks->Required) {
			if (!$this->pp_remarks->IsDetailKey && $this->pp_remarks->FormValue != NULL && $this->pp_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pp_remarks->caption(), $this->pp_remarks->RequiredErrorMessage));
			}
		}
		if ($this->po_remarks->Required) {
			if (!$this->po_remarks->IsDetailKey && $this->po_remarks->FormValue != NULL && $this->po_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po_remarks->caption(), $this->po_remarks->RequiredErrorMessage));
			}
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if ($this->declaration->Required) {
			if (!$this->declaration->IsDetailKey && $this->declaration->FormValue != NULL && $this->declaration->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->declaration->caption(), $this->declaration->RequiredErrorMessage));
			}
		}
		if ($this->dispatch->Required) {
			if (!$this->dispatch->IsDetailKey && $this->dispatch->FormValue != NULL && $this->dispatch->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dispatch->caption(), $this->dispatch->RequiredErrorMessage));
			}
		}
		if ($this->bom->Required) {
			if (!$this->bom->IsDetailKey && $this->bom->FormValue != NULL && $this->bom->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->bom->caption(), $this->bom->RequiredErrorMessage));
			}
		}
		if ($this->d_upload->Required) {
			if ($this->d_upload->Upload->FileName == "" && !$this->d_upload->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->d_upload->caption(), $this->d_upload->RequiredErrorMessage));
			}
		}
		if ($this->da_comments->Required) {
			if (!$this->da_comments->IsDetailKey && $this->da_comments->FormValue != NULL && $this->da_comments->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->da_comments->caption(), $this->da_comments->RequiredErrorMessage));
			}
		}
		if ($this->da_status->Required) {
			if (!$this->da_status->IsDetailKey && $this->da_status->FormValue != NULL && $this->da_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->da_status->caption(), $this->da_status->RequiredErrorMessage));
			}
		}
		if ($this->d_operator->Required) {
			if (!$this->d_operator->IsDetailKey && $this->d_operator->FormValue != NULL && $this->d_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_operator->caption(), $this->d_operator->RequiredErrorMessage));
			}
		}
		if ($this->d_datetime->Required) {
			if (!$this->d_datetime->IsDetailKey && $this->d_datetime->FormValue != NULL && $this->d_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->d_datetime->caption(), $this->d_datetime->RequiredErrorMessage));
			}
		}
		if ($this->purpose->Required) {
			if (!$this->purpose->IsDetailKey && $this->purpose->FormValue != NULL && $this->purpose->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->purpose->caption(), $this->purpose->RequiredErrorMessage));
			}
		}
		if ($this->label->Required) {
			if (!$this->label->IsDetailKey && $this->label->FormValue != NULL && $this->label->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->label->caption(), $this->label->RequiredErrorMessage));
			}
		}
		if ($this->ssd->Required) {
			if (!$this->ssd->IsDetailKey && $this->ssd->FormValue != NULL && $this->ssd->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ssd->caption(), $this->ssd->RequiredErrorMessage));
			}
		}
		if ($this->shipping_address->Required) {
			if (!$this->shipping_address->IsDetailKey && $this->shipping_address->FormValue != NULL && $this->shipping_address->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->shipping_address->caption(), $this->shipping_address->RequiredErrorMessage));
			}
		}
		if ($this->req_chat_id->Required) {
			if (!$this->req_chat_id->IsDetailKey && $this->req_chat_id->FormValue != NULL && $this->req_chat_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->req_chat_id->caption(), $this->req_chat_id->RequiredErrorMessage));
			}
		}
		if ($this->url->Required) {
			if (!$this->url->IsDetailKey && $this->url->FormValue != NULL && $this->url->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->url->caption(), $this->url->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->upload->OldUploadPath = 'product_images/o/sample_cart/';
			$this->upload->UploadPath = $this->upload->OldUploadPath;
			$this->d_upload->OldUploadPath = '.p_uploads/sample_cart/dispatch/'. $this->id->CurrentValue . '';
			$this->d_upload->UploadPath = $this->d_upload->OldUploadPath;
			$rsnew = [];

			// old_ref
			$this->old_ref->setDbValueDef($rsnew, $this->old_ref->CurrentValue, NULL, $this->old_ref->ReadOnly);

			// dispatch
			$this->dispatch->setDbValueDef($rsnew, $this->dispatch->CurrentValue, NULL, $this->dispatch->ReadOnly);

			// bom
			$this->bom->setDbValueDef($rsnew, $this->bom->CurrentValue, "", $this->bom->ReadOnly);

			// d_upload
			if ($this->d_upload->Visible && !$this->d_upload->ReadOnly && !$this->d_upload->Upload->KeepFile) {
				$this->d_upload->Upload->DbValue = $rsold['d_upload']; // Get original value
				if ($this->d_upload->Upload->FileName == "") {
					$rsnew['d_upload'] = NULL;
				} else {
					$rsnew['d_upload'] = $this->d_upload->Upload->FileName;
				}
				$this->d_upload->ImageWidth = 640; // Resize width
				$this->d_upload->ImageHeight = 640; // Resize height
			}

			// da_comments
			$this->da_comments->setDbValueDef($rsnew, $this->da_comments->CurrentValue, NULL, $this->da_comments->ReadOnly);

			// da_status
			$this->da_status->setDbValueDef($rsnew, $this->da_status->CurrentValue, NULL, $this->da_status->ReadOnly);

			// d_operator
			$this->d_operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['d_operator'] = &$this->d_operator->DbValue;

			// d_datetime
			$this->d_datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['d_datetime'] = &$this->d_datetime->DbValue;
			if ($this->d_upload->Visible && !$this->d_upload->Upload->KeepFile) {
				$this->d_upload->UploadPath = '.p_uploads/sample_cart/dispatch/'. $this->id->CurrentValue . '';
				$oldFiles = EmptyValue($this->d_upload->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->d_upload->Upload->DbValue));
				if (!EmptyValue($this->d_upload->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->d_upload->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->d_upload, $this->d_upload->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->d_upload->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->d_upload, $this->d_upload->Upload->Index) . $file1) || file_exists($this->d_upload->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->d_upload->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->d_upload, $this->d_upload->Upload->Index) . $file, UploadTempPath($this->d_upload, $this->d_upload->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->d_upload->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->d_upload->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->d_upload->setDbValueDef($rsnew, $this->d_upload->Upload->FileName, NULL, $this->d_upload->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->d_upload->Visible && !$this->d_upload->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->d_upload->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->d_upload->Upload->DbValue));
						if (!EmptyValue($this->d_upload->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->d_upload->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['d_upload']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->d_upload, $this->d_upload->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->d_upload->Upload->resizeAndSaveToFile($this->d_upload->ImageWidth, $this->d_upload->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->d_upload->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// d_upload
		if ($this->d_upload->Upload->FileToken <> "")
			CleanUploadTempPath($this->d_upload->Upload->FileToken, $this->d_upload->Upload->Index);
		else
			CleanUploadTempPath($this->d_upload, $this->d_upload->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("sample_req_cart_dispatchlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_delivery_week":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_da_status":
					$lookupFilter = function() {
						return (CurrentPageID() == "edit") ? "`grp` = 7 and `status` = 1 and `id` = 703" : "`grp` = 7 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_partner_id":
							break;
						case "x_delivery_week":
							break;
						case "x_status":
							break;
						case "x_da_status":
							break;
						case "x_purpose":
							break;
						case "x_label":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>