<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class sample_req_cart_feedback_view extends sample_req_cart_feedback
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'sample_req_cart_feedback';

	// Page object name
	public $PageObjName = "sample_req_cart_feedback_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (sample_req_cart_feedback)
		if (!isset($GLOBALS["sample_req_cart_feedback"]) || get_class($GLOBALS["sample_req_cart_feedback"]) == PROJECT_NAMESPACE . "sample_req_cart_feedback") {
			$GLOBALS["sample_req_cart_feedback"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["sample_req_cart_feedback"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart_feedback');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $sample_req_cart_feedback;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($sample_req_cart_feedback);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "sample_req_cart_feedbackview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("sample_req_cart_feedbacklist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->request_by->setVisibility();
		$this->company_id->Visible = FALSE;
		$this->partner_id->Visible = FALSE;
		$this->old_ref->setVisibility();
		$this->design->setVisibility();
		$this->color->setVisibility();
		$this->size->setVisibility();
		$this->f_yn->setVisibility();
		$this->feedback->setVisibility();
		$this->f_upload->setVisibility();
		$this->quantity->setVisibility();
		$this->delivery_week->setVisibility();
		$this->status->Visible = FALSE;
		$this->upload->setVisibility();
		$this->remarks->Visible = FALSE;
		$this->sp_remarks->setVisibility();
		$this->pp_remarks->Visible = FALSE;
		$this->po_remarks->setVisibility();
		$this->price->Visible = FALSE;
		$this->declaration->Visible = FALSE;
		$this->dispatch->setVisibility();
		$this->bom->setVisibility();
		$this->purpose->Visible = FALSE;
		$this->label->Visible = FALSE;
		$this->ssd->Visible = FALSE;
		$this->pd_upload->setVisibility();
		$this->d_upload->setVisibility();
		$this->shipping_address->Visible = FALSE;
		$this->f_operator->setVisibility();
		$this->f_datetime->setVisibility();
		$this->req_chat_id->setVisibility();
		$this->url->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->request_by);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->f_yn);
		$this->setupLookupOptions($this->delivery_week);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->purpose);
		$this->setupLookupOptions($this->label);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "sample_req_cart_feedbacklist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "sample_req_cart_feedbacklist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "sample_req_cart_feedbacklist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Edit
		$item = &$option->add("edit");
		$editcaption = HtmlTitle($Language->phrase("ViewPageEditLink"));
		if ($this->IsModal) // Modal
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"javascript:void(0);\" onclick=\"ew.modalDialogShow({lnk:this,url:'" . HtmlEncode($this->EditUrl) . "'});\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		else
			$item->Body = "<a class=\"ew-action ew-edit\" title=\"" . $editcaption . "\" data-caption=\"" . $editcaption . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("ViewPageEditLink") . "</a>";
		$item->Visible = ($this->EditUrl <> "" && $Security->canEdit());

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->request_by->setDbValue($row['request_by']);
		$this->company_id->setDbValue($row['company_id']);
		$this->partner_id->setDbValue($row['partner_id']);
		if (array_key_exists('EV__partner_id', $rs->fields)) {
			$this->partner_id->VirtualValue = $rs->fields('EV__partner_id'); // Set up virtual field value
		} else {
			$this->partner_id->VirtualValue = ""; // Clear value
		}
		$this->old_ref->setDbValue($row['old_ref']);
		$this->design->setDbValue($row['design']);
		$this->color->setDbValue($row['color']);
		$this->size->setDbValue($row['size']);
		$this->f_yn->setDbValue($row['f_yn']);
		$this->feedback->setDbValue($row['feedback']);
		$this->f_upload->Upload->DbValue = $row['f_upload'];
		$this->f_upload->setDbValue($this->f_upload->Upload->DbValue);
		$this->quantity->setDbValue($row['quantity']);
		$this->delivery_week->setDbValue($row['delivery_week']);
		$this->status->setDbValue($row['status']);
		$this->upload->Upload->DbValue = $row['upload'];
		$this->upload->setDbValue($this->upload->Upload->DbValue);
		$this->remarks->setDbValue($row['remarks']);
		$this->sp_remarks->setDbValue($row['sp_remarks']);
		$this->pp_remarks->setDbValue($row['pp_remarks']);
		$this->po_remarks->setDbValue($row['po_remarks']);
		$this->price->setDbValue($row['price']);
		$this->declaration->setDbValue($row['declaration']);
		$this->dispatch->setDbValue($row['dispatch']);
		$this->bom->setDbValue($row['bom']);
		$this->purpose->setDbValue($row['purpose']);
		$this->label->setDbValue($row['label']);
		$this->ssd->setDbValue($row['ssd']);
		$this->pd_upload->setDbValue($row['pd_upload']);
		$this->d_upload->setDbValue($row['d_upload']);
		$this->shipping_address->setDbValue($row['shipping_address']);
		$this->f_operator->setDbValue($row['f_operator']);
		$this->f_datetime->setDbValue($row['f_datetime']);
		$this->req_chat_id->setDbValue($row['req_chat_id']);
		$this->url->setDbValue($row['url']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['request_by'] = NULL;
		$row['company_id'] = NULL;
		$row['partner_id'] = NULL;
		$row['old_ref'] = NULL;
		$row['design'] = NULL;
		$row['color'] = NULL;
		$row['size'] = NULL;
		$row['f_yn'] = NULL;
		$row['feedback'] = NULL;
		$row['f_upload'] = NULL;
		$row['quantity'] = NULL;
		$row['delivery_week'] = NULL;
		$row['status'] = NULL;
		$row['upload'] = NULL;
		$row['remarks'] = NULL;
		$row['sp_remarks'] = NULL;
		$row['pp_remarks'] = NULL;
		$row['po_remarks'] = NULL;
		$row['price'] = NULL;
		$row['declaration'] = NULL;
		$row['dispatch'] = NULL;
		$row['bom'] = NULL;
		$row['purpose'] = NULL;
		$row['label'] = NULL;
		$row['ssd'] = NULL;
		$row['pd_upload'] = NULL;
		$row['d_upload'] = NULL;
		$row['shipping_address'] = NULL;
		$row['f_operator'] = NULL;
		$row['f_datetime'] = NULL;
		$row['req_chat_id'] = NULL;
		$row['url'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// request_by
		// company_id
		// partner_id
		// old_ref
		// design
		// color
		// size
		// f_yn
		// feedback
		// f_upload
		// quantity
		// delivery_week
		// status
		// upload
		// remarks
		// sp_remarks
		// pp_remarks
		// po_remarks
		// price
		// declaration
		// dispatch
		// bom
		// purpose
		// label
		// ssd
		// pd_upload
		// d_upload
		// shipping_address
		// f_operator
		// f_datetime
		// req_chat_id
		// url

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// request_by
			$this->request_by->ViewValue = $this->request_by->CurrentValue;
			$curVal = strval($this->request_by->CurrentValue);
			if ($curVal <> "") {
				$this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
				if ($this->request_by->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->request_by->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->request_by->ViewValue = $this->request_by->CurrentValue;
					}
				}
			} else {
				$this->request_by->ViewValue = NULL;
			}
			$this->request_by->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return User_Company_ID() == 0 ? "`status`=1 and `partner_type`=2" : "id= ".  User_Company_ID() . "  and `partner_type`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// old_ref
			$this->old_ref->ViewValue = $this->old_ref->CurrentValue;
			$this->old_ref->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// f_yn
			$curVal = strval($this->f_yn->CurrentValue);
			if ($curVal <> "") {
				$this->f_yn->ViewValue = $this->f_yn->lookupCacheOption($curVal);
				if ($this->f_yn->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=94 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->f_yn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->f_yn->ViewValue = $this->f_yn->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->f_yn->ViewValue = $this->f_yn->CurrentValue;
					}
				}
			} else {
				$this->f_yn->ViewValue = NULL;
			}
			$this->f_yn->ViewCustomAttributes = "";

			// feedback
			$this->feedback->ViewValue = $this->feedback->CurrentValue;
			$this->feedback->ViewCustomAttributes = "";

			// f_upload
			$this->f_upload->UploadPath = '.p_uploads/sample_cart/feedback/'. $this->id->CurrentValue . '';
			if (!EmptyValue($this->f_upload->Upload->DbValue)) {
				$this->f_upload->ImageWidth = 0;
				$this->f_upload->ImageHeight = 50;
				$this->f_upload->ImageAlt = $this->f_upload->alt();
				$this->f_upload->ViewValue = $this->f_upload->Upload->DbValue;
			} else {
				$this->f_upload->ViewValue = "";
			}
			$this->f_upload->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// delivery_week
			$curVal = strval($this->delivery_week->CurrentValue);
			if ($curVal <> "") {
				$this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
				if ($this->delivery_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->delivery_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->delivery_week->ViewValue = $this->delivery_week->CurrentValue;
					}
				}
			} else {
				$this->delivery_week->ViewValue = NULL;
			}
			$this->delivery_week->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// upload
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->ViewValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->ViewValue = "";
			}
			$this->upload->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// sp_remarks
			$this->sp_remarks->ViewValue = $this->sp_remarks->CurrentValue;
			$this->sp_remarks->ViewCustomAttributes = "";

			// pp_remarks
			$this->pp_remarks->ViewValue = $this->pp_remarks->CurrentValue;
			$this->pp_remarks->ViewCustomAttributes = "";

			// po_remarks
			$this->po_remarks->ViewValue = $this->po_remarks->CurrentValue;
			$this->po_remarks->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewCustomAttributes = "";

			// declaration
			$this->declaration->ViewValue = $this->declaration->CurrentValue;
			$this->declaration->ViewCustomAttributes = "";

			// dispatch
			$this->dispatch->ViewValue = $this->dispatch->CurrentValue;
			$this->dispatch->ViewCustomAttributes = "";

			// bom
			$this->bom->ViewValue = $this->bom->CurrentValue;
			$this->bom->ViewCustomAttributes = "";

			// pd_upload
			$this->pd_upload->ViewValue = $this->pd_upload->CurrentValue;
			$this->pd_upload->ViewCustomAttributes = "";

			// d_upload
			$this->d_upload->ViewValue = $this->d_upload->CurrentValue;
			$this->d_upload->ViewCustomAttributes = "";

			// f_operator
			$this->f_operator->ViewValue = $this->f_operator->CurrentValue;
			$this->f_operator->ViewValue = FormatNumber($this->f_operator->ViewValue, 0, -2, -2, -2);
			$this->f_operator->ViewCustomAttributes = "";

			// f_datetime
			$this->f_datetime->ViewValue = $this->f_datetime->CurrentValue;
			$this->f_datetime->ViewValue = FormatDateTime($this->f_datetime->ViewValue, 0);
			$this->f_datetime->ViewCustomAttributes = "";

			// req_chat_id
			$this->req_chat_id->ViewValue = $this->req_chat_id->CurrentValue;
			$this->req_chat_id->ViewCustomAttributes = "";

			// url
			$this->url->ViewValue = $this->url->CurrentValue;
			$this->url->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// request_by
			$this->request_by->LinkCustomAttributes = "";
			$this->request_by->HrefValue = "";
			$this->request_by->TooltipValue = "";

			// old_ref
			$this->old_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->old_ref->CurrentValue)) {
				$this->old_ref->HrefValue = "sample_req_cart_statuslist.php?x__barcode=" . $this->old_ref->CurrentValue . "&z__barcode=LIKE"; // Add prefix/suffix
				$this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
			} else {
				$this->old_ref->HrefValue = "";
			}
			$this->old_ref->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// f_yn
			$this->f_yn->LinkCustomAttributes = "";
			$this->f_yn->HrefValue = "";
			$this->f_yn->TooltipValue = "";

			// feedback
			$this->feedback->LinkCustomAttributes = "";
			$this->feedback->HrefValue = "";
			$this->feedback->TooltipValue = "";

			// f_upload
			$this->f_upload->LinkCustomAttributes = "";
			$this->f_upload->UploadPath = '.p_uploads/sample_cart/feedback/'. $this->id->CurrentValue . '';
			if (!EmptyValue($this->f_upload->Upload->DbValue)) {
				$this->f_upload->HrefValue = "%u"; // Add prefix/suffix
				$this->f_upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->f_upload->HrefValue = FullUrl($this->f_upload->HrefValue, "href");
			} else {
				$this->f_upload->HrefValue = "";
			}
			$this->f_upload->ExportHrefValue = $this->f_upload->UploadPath . $this->f_upload->Upload->DbValue;
			$this->f_upload->TooltipValue = "";
			if ($this->f_upload->UseColorbox) {
				if (EmptyValue($this->f_upload->TooltipValue))
					$this->f_upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->f_upload->LinkAttrs["data-rel"] = "sample_req_cart_feedback_x_f_upload";
				AppendClass($this->f_upload->LinkAttrs["class"], "ew-lightbox");
			}

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// delivery_week
			$this->delivery_week->LinkCustomAttributes = "";
			$this->delivery_week->HrefValue = "";
			$this->delivery_week->TooltipValue = "";

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = "%u"; // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
			$this->upload->TooltipValue = "";
			if ($this->upload->UseColorbox) {
				if (EmptyValue($this->upload->TooltipValue))
					$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->upload->LinkAttrs["data-rel"] = "sample_req_cart_feedback_x_upload";
				AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
			}

			// sp_remarks
			$this->sp_remarks->LinkCustomAttributes = "";
			$this->sp_remarks->HrefValue = "";
			$this->sp_remarks->TooltipValue = "";

			// po_remarks
			$this->po_remarks->LinkCustomAttributes = "";
			$this->po_remarks->HrefValue = "";
			$this->po_remarks->TooltipValue = "";

			// dispatch
			$this->dispatch->LinkCustomAttributes = "";
			$this->dispatch->HrefValue = "";
			$this->dispatch->TooltipValue = "";

			// bom
			$this->bom->LinkCustomAttributes = "";
			$this->bom->HrefValue = "";
			$this->bom->TooltipValue = "";

			// pd_upload
			$this->pd_upload->LinkCustomAttributes = "";
			$this->pd_upload->HrefValue = "";
			$this->pd_upload->TooltipValue = "";

			// d_upload
			$this->d_upload->LinkCustomAttributes = "";
			$this->d_upload->HrefValue = "";
			$this->d_upload->TooltipValue = "";

			// f_operator
			$this->f_operator->LinkCustomAttributes = "";
			$this->f_operator->HrefValue = "";
			$this->f_operator->TooltipValue = "";

			// f_datetime
			$this->f_datetime->LinkCustomAttributes = "";
			$this->f_datetime->HrefValue = "";
			$this->f_datetime->TooltipValue = "";

			// req_chat_id
			$this->req_chat_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->req_chat_id->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->req_chat_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->req_chat_id->HrefValue = FullUrl($this->req_chat_id->HrefValue, "href");
			} else {
				$this->req_chat_id->HrefValue = "";
			}
			$this->req_chat_id->TooltipValue = "";

			// url
			$this->url->LinkCustomAttributes = "";
			$this->url->HrefValue = "";
			$this->url->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("sample_req_cart_feedbacklist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_company_id":
					$lookupFilter = function() {
						return User_Company_ID() == 0 ? "`status`=1 and `partner_type`=2" : "id= ".  User_Company_ID() . "  and `partner_type`=2";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_f_yn":
					$lookupFilter = function() {
						return "`grp`=94 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_delivery_week":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_request_by":
							break;
						case "x_company_id":
							break;
						case "x_partner_id":
							break;
						case "x_f_yn":
							break;
						case "x_delivery_week":
							break;
						case "x_status":
							break;
						case "x_purpose":
							break;
						case "x_label":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>