<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class sample_req_cart_pre_dispatch_search extends sample_req_cart_pre_dispatch
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'sample_req_cart_pre_dispatch';

	// Page object name
	public $PageObjName = "sample_req_cart_pre_dispatch_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (sample_req_cart_pre_dispatch)
		if (!isset($GLOBALS["sample_req_cart_pre_dispatch"]) || get_class($GLOBALS["sample_req_cart_pre_dispatch"]) == PROJECT_NAMESPACE . "sample_req_cart_pre_dispatch") {
			$GLOBALS["sample_req_cart_pre_dispatch"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["sample_req_cart_pre_dispatch"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart_pre_dispatch');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $sample_req_cart_pre_dispatch;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($sample_req_cart_pre_dispatch);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "sample_req_cart_pre_dispatchview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("sample_req_cart_pre_dispatchlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->company_id->Visible = FALSE;
		$this->partner_id->Visible = FALSE;
		$this->old_ref->setVisibility();
		$this->design->setVisibility();
		$this->color->setVisibility();
		$this->size->setVisibility();
		$this->quantity->setVisibility();
		$this->delivery_week->setVisibility();
		$this->status->setVisibility();
		$this->upload->setVisibility();
		$this->remarks->Visible = FALSE;
		$this->purpose->Visible = FALSE;
		$this->po_remarks->setVisibility();
		$this->sp_remarks->setVisibility();
		$this->pp_remarks->Visible = FALSE;
		$this->price->Visible = FALSE;
		$this->declaration->Visible = FALSE;
		$this->bom->setVisibility();
		$this->label->Visible = FALSE;
		$this->ssd->Visible = FALSE;
		$this->pd_upload->setVisibility();
		$this->pd_comments->setVisibility();
		$this->da_status->setVisibility();
		$this->pd_operator->setVisibility();
		$this->pd_datetime->setVisibility();
		$this->req_chat_id->Visible = FALSE;
		$this->url->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->delivery_week);
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->purpose);
		$this->setupLookupOptions($this->label);
		$this->setupLookupOptions($this->da_status);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "sample_req_cart_pre_dispatchlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->old_ref); // old_ref
		$this->buildSearchUrl($srchUrl, $this->design); // design
		$this->buildSearchUrl($srchUrl, $this->color); // color
		$this->buildSearchUrl($srchUrl, $this->size); // size
		$this->buildSearchUrl($srchUrl, $this->quantity); // quantity
		$this->buildSearchUrl($srchUrl, $this->delivery_week); // delivery_week
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->upload); // upload
		$this->buildSearchUrl($srchUrl, $this->po_remarks); // po_remarks
		$this->buildSearchUrl($srchUrl, $this->sp_remarks); // sp_remarks
		$this->buildSearchUrl($srchUrl, $this->bom); // bom
		$this->buildSearchUrl($srchUrl, $this->pd_upload); // pd_upload
		$this->buildSearchUrl($srchUrl, $this->pd_comments); // pd_comments
		$this->buildSearchUrl($srchUrl, $this->da_status); // da_status
		$this->buildSearchUrl($srchUrl, $this->pd_operator); // pd_operator
		$this->buildSearchUrl($srchUrl, $this->pd_datetime); // pd_datetime
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// partner_id
		if (!$this->isAddOrEdit())
			$this->partner_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_partner_id"));
		$this->partner_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_partner_id"));

		// old_ref
		if (!$this->isAddOrEdit())
			$this->old_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_old_ref"));
		$this->old_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_old_ref"));

		// design
		if (!$this->isAddOrEdit())
			$this->design->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_design"));
		$this->design->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_design"));

		// color
		if (!$this->isAddOrEdit())
			$this->color->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_color"));
		$this->color->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_color"));

		// size
		if (!$this->isAddOrEdit())
			$this->size->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_size"));
		$this->size->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_size"));

		// quantity
		if (!$this->isAddOrEdit())
			$this->quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_quantity"));
		$this->quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_quantity"));

		// delivery_week
		if (!$this->isAddOrEdit())
			$this->delivery_week->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_delivery_week"));
		$this->delivery_week->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_delivery_week"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// upload
		if (!$this->isAddOrEdit())
			$this->upload->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_upload"));
		$this->upload->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_upload"));

		// po_remarks
		if (!$this->isAddOrEdit())
			$this->po_remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_po_remarks"));
		$this->po_remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_po_remarks"));

		// sp_remarks
		if (!$this->isAddOrEdit())
			$this->sp_remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_sp_remarks"));
		$this->sp_remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_sp_remarks"));

		// bom
		if (!$this->isAddOrEdit())
			$this->bom->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_bom"));
		$this->bom->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_bom"));

		// pd_upload
		if (!$this->isAddOrEdit())
			$this->pd_upload->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pd_upload"));
		$this->pd_upload->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pd_upload"));

		// pd_comments
		if (!$this->isAddOrEdit())
			$this->pd_comments->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pd_comments"));
		$this->pd_comments->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pd_comments"));

		// da_status
		if (!$this->isAddOrEdit())
			$this->da_status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_da_status"));
		$this->da_status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_da_status"));

		// pd_operator
		if (!$this->isAddOrEdit())
			$this->pd_operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pd_operator"));
		$this->pd_operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pd_operator"));

		// pd_datetime
		if (!$this->isAddOrEdit())
			$this->pd_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_pd_datetime"));
		$this->pd_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_pd_datetime"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// company_id
		// partner_id
		// old_ref
		// design
		// color
		// size
		// quantity
		// delivery_week
		// status
		// upload
		// remarks
		// purpose
		// po_remarks
		// sp_remarks
		// pp_remarks
		// price
		// declaration
		// bom
		// label
		// ssd
		// pd_upload
		// pd_comments
		// da_status
		// pd_operator
		// pd_datetime
		// req_chat_id
		// url

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// old_ref
			$this->old_ref->ViewValue = $this->old_ref->CurrentValue;
			$this->old_ref->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// delivery_week
			$curVal = strval($this->delivery_week->CurrentValue);
			if ($curVal <> "") {
				$this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
				if ($this->delivery_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->delivery_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->delivery_week->ViewValue = $this->delivery_week->CurrentValue;
					}
				}
			} else {
				$this->delivery_week->ViewValue = NULL;
			}
			$this->delivery_week->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// upload
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->ViewValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->ViewValue = "";
			}
			$this->upload->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// po_remarks
			$this->po_remarks->ViewValue = $this->po_remarks->CurrentValue;
			$this->po_remarks->ViewCustomAttributes = "";

			// sp_remarks
			$this->sp_remarks->ViewValue = $this->sp_remarks->CurrentValue;
			$this->sp_remarks->ViewCustomAttributes = "";

			// pp_remarks
			$this->pp_remarks->ViewValue = $this->pp_remarks->CurrentValue;
			$this->pp_remarks->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewCustomAttributes = "";

			// declaration
			$this->declaration->ViewValue = $this->declaration->CurrentValue;
			$this->declaration->ViewCustomAttributes = "";

			// bom
			$this->bom->ViewValue = $this->bom->CurrentValue;
			$this->bom->ViewCustomAttributes = "";

			// pd_upload
			$this->pd_upload->UploadPath = '.p_uploads/sample_cart/dispatch/'. $this->id->CurrentValue . '';
			if (!EmptyValue($this->pd_upload->Upload->DbValue)) {
				$this->pd_upload->ViewValue = $this->pd_upload->Upload->DbValue;
			} else {
				$this->pd_upload->ViewValue = "";
			}
			$this->pd_upload->ViewCustomAttributes = "";

			// pd_comments
			$this->pd_comments->ViewValue = $this->pd_comments->CurrentValue;
			$this->pd_comments->ViewCustomAttributes = "";

			// da_status
			$curVal = strval($this->da_status->CurrentValue);
			if ($curVal <> "") {
				$this->da_status->ViewValue = $this->da_status->lookupCacheOption($curVal);
				if ($this->da_status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "edit") ? "`grp` = 7 and `status` = 1 and `id` = 701" : "`grp` = 7 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->da_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->da_status->ViewValue = $this->da_status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->da_status->ViewValue = $this->da_status->CurrentValue;
					}
				}
			} else {
				$this->da_status->ViewValue = NULL;
			}
			$this->da_status->ViewCustomAttributes = "";

			// pd_operator
			$this->pd_operator->ViewValue = $this->pd_operator->CurrentValue;
			$this->pd_operator->ViewValue = FormatNumber($this->pd_operator->ViewValue, 0, -2, -2, -2);
			$this->pd_operator->ViewCustomAttributes = "";

			// pd_datetime
			$this->pd_datetime->ViewValue = $this->pd_datetime->CurrentValue;
			$this->pd_datetime->ViewValue = FormatDateTime($this->pd_datetime->ViewValue, 0);
			$this->pd_datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// old_ref
			$this->old_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->old_ref->CurrentValue)) {
				$this->old_ref->HrefValue = "sample_req_cart_statuslist.php?x__barcode=" . $this->old_ref->CurrentValue . "&z__barcode=LIKE"; // Add prefix/suffix
				$this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
			} else {
				$this->old_ref->HrefValue = "";
			}
			$this->old_ref->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// delivery_week
			$this->delivery_week->LinkCustomAttributes = "";
			$this->delivery_week->HrefValue = "";
			$this->delivery_week->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = "%u"; // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
			$this->upload->TooltipValue = "";
			if ($this->upload->UseColorbox) {
				if (EmptyValue($this->upload->TooltipValue))
					$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->upload->LinkAttrs["data-rel"] = "sample_req_cart_pre_dispatch_x_upload";
				AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
			}

			// po_remarks
			$this->po_remarks->LinkCustomAttributes = "";
			$this->po_remarks->HrefValue = "";
			$this->po_remarks->TooltipValue = "";

			// sp_remarks
			$this->sp_remarks->LinkCustomAttributes = "";
			$this->sp_remarks->HrefValue = "";
			$this->sp_remarks->TooltipValue = "";

			// bom
			$this->bom->LinkCustomAttributes = "";
			$this->bom->HrefValue = "";
			$this->bom->TooltipValue = "";

			// pd_upload
			$this->pd_upload->LinkCustomAttributes = "";
			$this->pd_upload->HrefValue = "";
			$this->pd_upload->ExportHrefValue = $this->pd_upload->UploadPath . $this->pd_upload->Upload->DbValue;
			$this->pd_upload->TooltipValue = "";

			// pd_comments
			$this->pd_comments->LinkCustomAttributes = "";
			$this->pd_comments->HrefValue = "";
			$this->pd_comments->TooltipValue = "";

			// da_status
			$this->da_status->LinkCustomAttributes = "";
			$this->da_status->HrefValue = "";
			$this->da_status->TooltipValue = "";

			// pd_operator
			$this->pd_operator->LinkCustomAttributes = "";
			$this->pd_operator->HrefValue = "";
			$this->pd_operator->TooltipValue = "";

			// pd_datetime
			$this->pd_datetime->LinkCustomAttributes = "";
			$this->pd_datetime->HrefValue = "";
			$this->pd_datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// old_ref
			$this->old_ref->EditAttrs["class"] = "form-control";
			$this->old_ref->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->old_ref->AdvancedSearch->SearchValue = HtmlDecode($this->old_ref->AdvancedSearch->SearchValue);
			$this->old_ref->EditValue = HtmlEncode($this->old_ref->AdvancedSearch->SearchValue);
			$this->old_ref->PlaceHolder = RemoveHtml($this->old_ref->caption());

			// design
			$this->design->EditAttrs["class"] = "form-control";
			$this->design->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->design->AdvancedSearch->SearchValue = HtmlDecode($this->design->AdvancedSearch->SearchValue);
			$this->design->EditValue = HtmlEncode($this->design->AdvancedSearch->SearchValue);
			$this->design->PlaceHolder = RemoveHtml($this->design->caption());

			// color
			$this->color->EditAttrs["class"] = "form-control";
			$this->color->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->color->AdvancedSearch->SearchValue = HtmlDecode($this->color->AdvancedSearch->SearchValue);
			$this->color->EditValue = HtmlEncode($this->color->AdvancedSearch->SearchValue);
			$this->color->PlaceHolder = RemoveHtml($this->color->caption());

			// size
			$this->size->EditAttrs["class"] = "form-control";
			$this->size->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->size->AdvancedSearch->SearchValue = HtmlDecode($this->size->AdvancedSearch->SearchValue);
			$this->size->EditValue = HtmlEncode($this->size->AdvancedSearch->SearchValue);
			$this->size->PlaceHolder = RemoveHtml($this->size->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->AdvancedSearch->SearchValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// delivery_week
			$this->delivery_week->EditAttrs["class"] = "form-control";
			$this->delivery_week->EditCustomAttributes = "";
			$curVal = trim(strval($this->delivery_week->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->delivery_week->AdvancedSearch->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
			else
				$this->delivery_week->AdvancedSearch->ViewValue = $this->delivery_week->Lookup !== NULL && is_array($this->delivery_week->Lookup->Options) ? $curVal : NULL;
			if ($this->delivery_week->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->delivery_week->EditValue = array_values($this->delivery_week->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->delivery_week->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->delivery_week->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->delivery_week->EditValue = $arwrk;
			}

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$curVal = trim(strval($this->status->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->status->AdvancedSearch->ViewValue = $this->status->lookupCacheOption($curVal);
			else
				$this->status->AdvancedSearch->ViewValue = $this->status->Lookup !== NULL && is_array($this->status->Lookup->Options) ? $curVal : NULL;
			if ($this->status->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->status->EditValue = array_values($this->status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->status->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->status->EditValue = $arwrk;
			}

			// upload
			$this->upload->EditAttrs["class"] = "form-control";
			$this->upload->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->upload->AdvancedSearch->SearchValue = HtmlDecode($this->upload->AdvancedSearch->SearchValue);
			$this->upload->EditValue = HtmlEncode($this->upload->AdvancedSearch->SearchValue);
			$this->upload->PlaceHolder = RemoveHtml($this->upload->caption());

			// po_remarks
			$this->po_remarks->EditAttrs["class"] = "form-control";
			$this->po_remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po_remarks->AdvancedSearch->SearchValue = HtmlDecode($this->po_remarks->AdvancedSearch->SearchValue);
			$this->po_remarks->EditValue = HtmlEncode($this->po_remarks->AdvancedSearch->SearchValue);
			$this->po_remarks->PlaceHolder = RemoveHtml($this->po_remarks->caption());

			// sp_remarks
			$this->sp_remarks->EditAttrs["class"] = "form-control";
			$this->sp_remarks->EditCustomAttributes = "";
			$this->sp_remarks->EditValue = HtmlEncode($this->sp_remarks->AdvancedSearch->SearchValue);
			$this->sp_remarks->PlaceHolder = RemoveHtml($this->sp_remarks->caption());

			// bom
			$this->bom->EditAttrs["class"] = "form-control";
			$this->bom->EditCustomAttributes = "";
			$this->bom->EditValue = HtmlEncode($this->bom->AdvancedSearch->SearchValue);
			$this->bom->PlaceHolder = RemoveHtml($this->bom->caption());

			// pd_upload
			$this->pd_upload->EditAttrs["class"] = "form-control";
			$this->pd_upload->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->pd_upload->AdvancedSearch->SearchValue = HtmlDecode($this->pd_upload->AdvancedSearch->SearchValue);
			$this->pd_upload->EditValue = HtmlEncode($this->pd_upload->AdvancedSearch->SearchValue);
			$this->pd_upload->PlaceHolder = RemoveHtml($this->pd_upload->caption());

			// pd_comments
			$this->pd_comments->EditAttrs["class"] = "form-control";
			$this->pd_comments->EditCustomAttributes = "";
			$this->pd_comments->EditValue = HtmlEncode($this->pd_comments->AdvancedSearch->SearchValue);
			$this->pd_comments->PlaceHolder = RemoveHtml($this->pd_comments->caption());

			// da_status
			$this->da_status->EditAttrs["class"] = "form-control";
			$this->da_status->EditCustomAttributes = "";
			$curVal = trim(strval($this->da_status->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->da_status->AdvancedSearch->ViewValue = $this->da_status->lookupCacheOption($curVal);
			else
				$this->da_status->AdvancedSearch->ViewValue = $this->da_status->Lookup !== NULL && is_array($this->da_status->Lookup->Options) ? $curVal : NULL;
			if ($this->da_status->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->da_status->EditValue = array_values($this->da_status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->da_status->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "edit") ? "`grp` = 7 and `status` = 1 and `id` = 701" : "`grp` = 7 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->da_status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->da_status->EditValue = $arwrk;
			}

			// pd_operator
			$this->pd_operator->EditAttrs["class"] = "form-control";
			$this->pd_operator->EditCustomAttributes = "";
			$this->pd_operator->EditValue = HtmlEncode($this->pd_operator->AdvancedSearch->SearchValue);
			$this->pd_operator->PlaceHolder = RemoveHtml($this->pd_operator->caption());

			// pd_datetime
			$this->pd_datetime->EditAttrs["class"] = "form-control";
			$this->pd_datetime->EditCustomAttributes = "";
			$this->pd_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->pd_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->pd_datetime->PlaceHolder = RemoveHtml($this->pd_datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->quantity->errorMessage());
		}
		if (!CheckInteger($this->pd_operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pd_operator->errorMessage());
		}
		if (!CheckDate($this->pd_datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->pd_datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->partner_id->AdvancedSearch->load();
		$this->old_ref->AdvancedSearch->load();
		$this->design->AdvancedSearch->load();
		$this->color->AdvancedSearch->load();
		$this->size->AdvancedSearch->load();
		$this->quantity->AdvancedSearch->load();
		$this->delivery_week->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->upload->AdvancedSearch->load();
		$this->po_remarks->AdvancedSearch->load();
		$this->sp_remarks->AdvancedSearch->load();
		$this->bom->AdvancedSearch->load();
		$this->pd_upload->AdvancedSearch->load();
		$this->pd_comments->AdvancedSearch->load();
		$this->da_status->AdvancedSearch->load();
		$this->pd_operator->AdvancedSearch->load();
		$this->pd_datetime->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("sample_req_cart_pre_dispatchlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_delivery_week":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_da_status":
					$lookupFilter = function() {
						return (CurrentPageID() == "edit") ? "`grp` = 7 and `status` = 1 and `id` = 701" : "`grp` = 7 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_company_id":
							break;
						case "x_partner_id":
							break;
						case "x_delivery_week":
							break;
						case "x_status":
							break;
						case "x_purpose":
							break;
						case "x_label":
							break;
						case "x_da_status":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'sample_req_cart_pre_dispatch');				
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>