<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class sample_req_cart_status_view extends sample_req_cart_status
{

	// Page ID
	public $PageID = "view";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'sample_req_cart_status';

	// Page object name
	public $PageObjName = "sample_req_cart_status_view";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (sample_req_cart_status)
		if (!isset($GLOBALS["sample_req_cart_status"]) || get_class($GLOBALS["sample_req_cart_status"]) == PROJECT_NAMESPACE . "sample_req_cart_status") {
			$GLOBALS["sample_req_cart_status"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["sample_req_cart_status"];
		}
		$keyUrl = "";
		if (Get("id") !== NULL) {
			$this->RecKey["id"] = Get("id");
			$keyUrl .= "&amp;id=" . urlencode($this->RecKey["id"]);
		}
		$this->ExportPrintUrl = $this->pageUrl() . "export=print" . $keyUrl;
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html" . $keyUrl;
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel" . $keyUrl;
		$this->ExportWordUrl = $this->pageUrl() . "export=word" . $keyUrl;
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml" . $keyUrl;
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv" . $keyUrl;
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf" . $keyUrl;
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'view');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'sample_req_cart_status');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $sample_req_cart_status;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($sample_req_cart_status);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "sample_req_cart_statusview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $ExportOptions; // Export options
	public $OtherOptions; // Other options
	public $DisplayRecs = 1;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $RecCnt;
	public $RecKey = array();
	public $IsModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SkipHeaderFooter, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canView()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("sample_req_cart_statuslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->datetime->setVisibility();
		$this->po_id->Visible = FALSE;
		$this->r_text->setVisibility();
		$this->old_ref->setVisibility();
		$this->status->setVisibility();
		$this->request_by->setVisibility();
		$this->company_id->setVisibility();
		$this->partner_id->setVisibility();
		$this->upload->setVisibility();
		$this->operator->setVisibility();
		$this->design->setVisibility();
		$this->color->setVisibility();
		$this->size->setVisibility();
		$this->quantity->setVisibility();
		$this->shipping_mode->setVisibility();
		$this->delivery_week->setVisibility();
		$this->purpose->setVisibility();
		$this->label->setVisibility();
		$this->ssd->setVisibility();
		$this->remarks->setVisibility();
		$this->shipping_address->Visible = FALSE;
		$this->shipping_address_2->setVisibility();
		$this->sp_remarks->setVisibility();
		$this->a_operator->setVisibility();
		$this->a_datetime->setVisibility();
		$this->pp_remarks->setVisibility();
		$this->price->setVisibility();
		$this->declaration->setVisibility();
		$this->app_status->setVisibility();
		$this->app_operator->setVisibility();
		$this->app_datetime->setVisibility();
		$this->po_remarks->setVisibility();
		$this->po_operator->setVisibility();
		$this->po_datetime->setVisibility();
		$this->bom->setVisibility();
		$this->pd_upload->setVisibility();
		$this->pd_comments->setVisibility();
		$this->pd_operator->setVisibility();
		$this->pd_datetime->setVisibility();
		$this->da_comments->setVisibility();
		$this->da_status->setVisibility();
		$this->da_operator->setVisibility();
		$this->da_datetime->setVisibility();
		$this->dispatch->setVisibility();
		$this->d_operator->setVisibility();
		$this->d_datetime->setVisibility();
		$this->r_comments->setVisibility();
		$this->r_operator->setVisibility();
		$this->r_datetime->setVisibility();
		$this->f_yn->setVisibility();
		$this->feedback->setVisibility();
		$this->f_operator->setVisibility();
		$this->f_datetime->setVisibility();
		$this->f_upload->setVisibility();
		$this->fr_operator->setVisibility();
		$this->fr_datetime->setVisibility();
		$this->req_chat_id->setVisibility();
		$this->_barcode->Visible = FALSE;
		$this->url->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->status);
		$this->setupLookupOptions($this->request_by);
		$this->setupLookupOptions($this->company_id);
		$this->setupLookupOptions($this->partner_id);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->delivery_week);
		$this->setupLookupOptions($this->purpose);
		$this->setupLookupOptions($this->label);
		$this->setupLookupOptions($this->a_operator);
		$this->setupLookupOptions($this->app_status);
		$this->setupLookupOptions($this->app_operator);
		$this->setupLookupOptions($this->po_operator);
		$this->setupLookupOptions($this->pd_operator);
		$this->setupLookupOptions($this->da_status);
		$this->setupLookupOptions($this->da_operator);
		$this->setupLookupOptions($this->d_operator);
		$this->setupLookupOptions($this->r_operator);
		$this->setupLookupOptions($this->f_yn);
		$this->setupLookupOptions($this->f_operator);
		$this->setupLookupOptions($this->fr_operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;

		// Load current record
		$loadCurrentRecord = FALSE;
		$returnUrl = "";
		$matchRecord = FALSE;
		if ($this->isPageRequest()) { // Validate request
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (IsApi() && Key(0) != NULL) {
				$this->id->setQueryStringValue(Key(0));
				$this->RecKey["id"] = $this->id->QueryStringValue;
			} elseif (Post("id") !== NULL) {
				$this->id->setFormValue(Post("id"));
				$this->RecKey["id"] = $this->id->FormValue;
			} elseif (IsApi() && Route(2) != NULL) {
				$this->id->setFormValue(Route(2));
				$this->RecKey["id"] = $this->id->FormValue;
			} else {
				$returnUrl = "sample_req_cart_statuslist.php"; // Return to list
			}

			// Get action
			$this->CurrentAction = "show"; // Display
			switch ($this->CurrentAction) {
				case "show": // Get a record to display

					// Load record based on key
					if (IsApi()) {
						$filter = $this->getRecordFilter();
						$this->CurrentFilter = $filter;
						$sql = $this->getCurrentSql();
						$conn = &$this->getConnection();
						$this->Recordset = LoadRecordset($sql, $conn);
						$res = $this->Recordset && !$this->Recordset->EOF;
					} else {
						$res = $this->loadRow();
					}
					if (!$res) { // Load record based on key
						if ($this->getSuccessMessage() == "" && $this->getFailureMessage() == "")
							$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
						$returnUrl = "sample_req_cart_statuslist.php"; // No matching record, return to list
					}
			}
		} else {
			$returnUrl = "sample_req_cart_statuslist.php"; // Not page request, return to list
		}
		if ($returnUrl <> "") {
			$this->terminate($returnUrl);
			return;
		}

		// Set up Breadcrumb
		if (!$this->isExport())
			$this->setupBreadcrumb();

		// Render row
		$this->RowType = ROWTYPE_VIEW;
		$this->resetAttributes();
		$this->renderRow();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset, TRUE); // Get current record only
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows]);
			$this->terminate(TRUE);
		}
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = &$options["action"];

		// Set up action default
		$option = &$options["action"];
		$option->DropDownButtonPhrase = $Language->phrase("ButtonActions");
		$option->UseDropDownButton = FALSE;
		$option->UseButtonGroup = TRUE;
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->datetime->setDbValue($row['datetime']);
		$this->po_id->setDbValue($row['po_id']);
		$this->r_text->setDbValue($row['r_text']);
		$this->old_ref->setDbValue($row['old_ref']);
		$this->status->setDbValue($row['status']);
		$this->request_by->setDbValue($row['request_by']);
		if (array_key_exists('EV__request_by', $rs->fields)) {
			$this->request_by->VirtualValue = $rs->fields('EV__request_by'); // Set up virtual field value
		} else {
			$this->request_by->VirtualValue = ""; // Clear value
		}
		$this->company_id->setDbValue($row['company_id']);
		$this->partner_id->setDbValue($row['partner_id']);
		if (array_key_exists('EV__partner_id', $rs->fields)) {
			$this->partner_id->VirtualValue = $rs->fields('EV__partner_id'); // Set up virtual field value
		} else {
			$this->partner_id->VirtualValue = ""; // Clear value
		}
		$this->upload->Upload->DbValue = $row['upload'];
		$this->upload->setDbValue($this->upload->Upload->DbValue);
		$this->operator->setDbValue($row['operator']);
		$this->design->setDbValue($row['design']);
		$this->color->setDbValue($row['color']);
		$this->size->setDbValue($row['size']);
		$this->quantity->setDbValue($row['quantity']);
		$this->shipping_mode->setDbValue($row['shipping_mode']);
		$this->delivery_week->setDbValue($row['delivery_week']);
		$this->purpose->setDbValue($row['purpose']);
		$this->label->setDbValue($row['label']);
		$this->ssd->setDbValue($row['ssd']);
		$this->remarks->setDbValue($row['remarks']);
		$this->shipping_address->setDbValue($row['shipping_address']);
		$this->shipping_address_2->setDbValue($row['shipping_address_2']);
		$this->sp_remarks->setDbValue($row['sp_remarks']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->a_datetime->setDbValue($row['a_datetime']);
		$this->pp_remarks->setDbValue($row['pp_remarks']);
		$this->price->setDbValue($row['price']);
		$this->declaration->setDbValue($row['declaration']);
		$this->app_status->setDbValue($row['app_status']);
		$this->app_operator->setDbValue($row['app_operator']);
		$this->app_datetime->setDbValue($row['app_datetime']);
		$this->po_remarks->setDbValue($row['po_remarks']);
		$this->po_operator->setDbValue($row['po_operator']);
		$this->po_datetime->setDbValue($row['po_datetime']);
		$this->bom->setDbValue($row['bom']);
		$this->pd_upload->Upload->DbValue = $row['pd_upload'];
		$this->pd_upload->setDbValue($this->pd_upload->Upload->DbValue);
		$this->pd_comments->setDbValue($row['pd_comments']);
		$this->pd_operator->setDbValue($row['pd_operator']);
		$this->pd_datetime->setDbValue($row['pd_datetime']);
		$this->da_comments->setDbValue($row['da_comments']);
		$this->da_status->setDbValue($row['da_status']);
		$this->da_operator->setDbValue($row['da_operator']);
		$this->da_datetime->setDbValue($row['da_datetime']);
		$this->dispatch->setDbValue($row['dispatch']);
		$this->d_operator->setDbValue($row['d_operator']);
		$this->d_datetime->setDbValue($row['d_datetime']);
		$this->r_comments->setDbValue($row['r_comments']);
		$this->r_operator->setDbValue($row['r_operator']);
		$this->r_datetime->setDbValue($row['r_datetime']);
		$this->f_yn->setDbValue($row['f_yn']);
		$this->feedback->setDbValue($row['feedback']);
		$this->f_operator->setDbValue($row['f_operator']);
		$this->f_datetime->setDbValue($row['f_datetime']);
		$this->f_upload->Upload->DbValue = $row['f_upload'];
		$this->f_upload->setDbValue($this->f_upload->Upload->DbValue);
		$this->fr_operator->setDbValue($row['fr_operator']);
		$this->fr_datetime->setDbValue($row['fr_datetime']);
		$this->req_chat_id->setDbValue($row['req_chat_id']);
		$this->_barcode->setDbValue($row['barcode']);
		$this->url->setDbValue($row['url']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['datetime'] = NULL;
		$row['po_id'] = NULL;
		$row['r_text'] = NULL;
		$row['old_ref'] = NULL;
		$row['status'] = NULL;
		$row['request_by'] = NULL;
		$row['company_id'] = NULL;
		$row['partner_id'] = NULL;
		$row['upload'] = NULL;
		$row['operator'] = NULL;
		$row['design'] = NULL;
		$row['color'] = NULL;
		$row['size'] = NULL;
		$row['quantity'] = NULL;
		$row['shipping_mode'] = NULL;
		$row['delivery_week'] = NULL;
		$row['purpose'] = NULL;
		$row['label'] = NULL;
		$row['ssd'] = NULL;
		$row['remarks'] = NULL;
		$row['shipping_address'] = NULL;
		$row['shipping_address_2'] = NULL;
		$row['sp_remarks'] = NULL;
		$row['a_operator'] = NULL;
		$row['a_datetime'] = NULL;
		$row['pp_remarks'] = NULL;
		$row['price'] = NULL;
		$row['declaration'] = NULL;
		$row['app_status'] = NULL;
		$row['app_operator'] = NULL;
		$row['app_datetime'] = NULL;
		$row['po_remarks'] = NULL;
		$row['po_operator'] = NULL;
		$row['po_datetime'] = NULL;
		$row['bom'] = NULL;
		$row['pd_upload'] = NULL;
		$row['pd_comments'] = NULL;
		$row['pd_operator'] = NULL;
		$row['pd_datetime'] = NULL;
		$row['da_comments'] = NULL;
		$row['da_status'] = NULL;
		$row['da_operator'] = NULL;
		$row['da_datetime'] = NULL;
		$row['dispatch'] = NULL;
		$row['d_operator'] = NULL;
		$row['d_datetime'] = NULL;
		$row['r_comments'] = NULL;
		$row['r_operator'] = NULL;
		$row['r_datetime'] = NULL;
		$row['f_yn'] = NULL;
		$row['feedback'] = NULL;
		$row['f_operator'] = NULL;
		$row['f_datetime'] = NULL;
		$row['f_upload'] = NULL;
		$row['fr_operator'] = NULL;
		$row['fr_datetime'] = NULL;
		$row['req_chat_id'] = NULL;
		$row['barcode'] = NULL;
		$row['url'] = NULL;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->AddUrl = $this->getAddUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();
		$this->ListUrl = $this->getListUrl();
		$this->setupOtherOptions();

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// datetime
		// po_id
		// r_text
		// old_ref
		// status
		// request_by
		// company_id
		// partner_id
		// upload
		// operator
		// design
		// color
		// size
		// quantity
		// shipping_mode
		// delivery_week
		// purpose
		// label
		// ssd
		// remarks
		// shipping_address
		// shipping_address_2
		// sp_remarks
		// a_operator
		// a_datetime
		// pp_remarks
		// price
		// declaration
		// app_status
		// app_operator
		// app_datetime
		// po_remarks
		// po_operator
		// po_datetime
		// bom
		// pd_upload
		// pd_comments
		// pd_operator
		// pd_datetime
		// da_comments
		// da_status
		// da_operator
		// da_datetime
		// dispatch
		// d_operator
		// d_datetime
		// r_comments
		// r_operator
		// r_datetime
		// f_yn
		// feedback
		// f_operator
		// f_datetime
		// f_upload
		// fr_operator
		// fr_datetime
		// req_chat_id
		// barcode
		// url

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 2);
			$this->datetime->ViewCustomAttributes = "";

			// r_text
			$this->r_text->ViewValue = $this->r_text->CurrentValue;
			$this->r_text->ViewCustomAttributes = "";

			// old_ref
			$this->old_ref->ViewValue = $this->old_ref->CurrentValue;
			$this->old_ref->ViewCustomAttributes = "";

			// status
			$curVal = strval($this->status->CurrentValue);
			if ($curVal <> "") {
				$this->status->ViewValue = $this->status->lookupCacheOption($curVal);
				if ($this->status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->status->ViewValue = $this->status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->status->ViewValue = $this->status->CurrentValue;
					}
				}
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// request_by
			if ($this->request_by->VirtualValue <> "") {
				$this->request_by->ViewValue = $this->request_by->VirtualValue;
			} else {
				$this->request_by->ViewValue = $this->request_by->CurrentValue;
			$curVal = strval($this->request_by->CurrentValue);
			if ($curVal <> "") {
				$this->request_by->ViewValue = $this->request_by->lookupCacheOption($curVal);
				if ($this->request_by->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->request_by->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->request_by->ViewValue = $this->request_by->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->request_by->ViewValue = $this->request_by->CurrentValue;
					}
				}
			} else {
				$this->request_by->ViewValue = NULL;
			}
			}
			$this->request_by->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// partner_id
			if ($this->partner_id->VirtualValue <> "") {
				$this->partner_id->ViewValue = $this->partner_id->VirtualValue;
			} else {
				$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
			$curVal = strval($this->partner_id->CurrentValue);
			if ($curVal <> "") {
				$this->partner_id->ViewValue = $this->partner_id->lookupCacheOption($curVal);
				if ($this->partner_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->partner_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->partner_id->ViewValue = $this->partner_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->partner_id->ViewValue = $this->partner_id->CurrentValue;
					}
				}
			} else {
				$this->partner_id->ViewValue = NULL;
			}
			}
			$this->partner_id->ViewCustomAttributes = "";

			// upload
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->ImageWidth = 0;
				$this->upload->ImageHeight = 50;
				$this->upload->ImageAlt = $this->upload->alt();
				$this->upload->ViewValue = $this->upload->Upload->DbValue;
			} else {
				$this->upload->ViewValue = "";
			}
			$this->upload->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// design
			$this->design->ViewValue = $this->design->CurrentValue;
			$this->design->ViewCustomAttributes = "";

			// color
			$this->color->ViewValue = $this->color->CurrentValue;
			$this->color->ViewCustomAttributes = "";

			// size
			$this->size->ViewValue = $this->size->CurrentValue;
			$this->size->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// shipping_mode
			if (strval($this->shipping_mode->CurrentValue) <> "") {
				$this->shipping_mode->ViewValue = $this->shipping_mode->optionCaption($this->shipping_mode->CurrentValue);
			} else {
				$this->shipping_mode->ViewValue = NULL;
			}
			$this->shipping_mode->ViewCustomAttributes = "";

			// delivery_week
			$curVal = strval($this->delivery_week->CurrentValue);
			if ($curVal <> "") {
				$this->delivery_week->ViewValue = $this->delivery_week->lookupCacheOption($curVal);
				if ($this->delivery_week->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add" || CurrentPageID() == "addopt") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->delivery_week->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->delivery_week->ViewValue = $this->delivery_week->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->delivery_week->ViewValue = $this->delivery_week->CurrentValue;
					}
				}
			} else {
				$this->delivery_week->ViewValue = NULL;
			}
			$this->delivery_week->ViewCustomAttributes = "";

			// purpose
			$curVal = strval($this->purpose->CurrentValue);
			if ($curVal <> "") {
				$this->purpose->ViewValue = $this->purpose->lookupCacheOption($curVal);
				if ($this->purpose->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->purpose->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->purpose->ViewValue = $this->purpose->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->purpose->ViewValue = $this->purpose->CurrentValue;
					}
				}
			} else {
				$this->purpose->ViewValue = NULL;
			}
			$this->purpose->ViewCustomAttributes = "";

			// label
			$curVal = strval($this->label->CurrentValue);
			if ($curVal <> "") {
				$this->label->ViewValue = $this->label->lookupCacheOption($curVal);
				if ($this->label->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->label->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->label->ViewValue = $this->label->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->label->ViewValue = $this->label->CurrentValue;
					}
				}
			} else {
				$this->label->ViewValue = NULL;
			}
			$this->label->ViewCustomAttributes = "";

			// ssd
			$this->ssd->ViewValue = $this->ssd->CurrentValue;
			$this->ssd->ViewValue = FormatDateTime($this->ssd->ViewValue, 2);
			$this->ssd->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// shipping_address_2
			$this->shipping_address_2->ViewValue = $this->shipping_address_2->CurrentValue;
			$this->shipping_address_2->ViewCustomAttributes = "";

			// sp_remarks
			$this->sp_remarks->ViewValue = $this->sp_remarks->CurrentValue;
			$this->sp_remarks->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// a_datetime
			$this->a_datetime->ViewValue = $this->a_datetime->CurrentValue;
			$this->a_datetime->ViewValue = FormatDateTime($this->a_datetime->ViewValue, 2);
			$this->a_datetime->ViewCustomAttributes = "";

			// pp_remarks
			$this->pp_remarks->ViewValue = $this->pp_remarks->CurrentValue;
			$this->pp_remarks->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewCustomAttributes = "";

			// declaration
			$this->declaration->ViewValue = $this->declaration->CurrentValue;
			$this->declaration->ViewCustomAttributes = "";

			// app_status
			$curVal = strval($this->app_status->CurrentValue);
			if ($curVal <> "") {
				$this->app_status->ViewValue = $this->app_status->lookupCacheOption($curVal);
				if ($this->app_status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 6 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->app_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->app_status->ViewValue = $this->app_status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->app_status->ViewValue = $this->app_status->CurrentValue;
					}
				}
			} else {
				$this->app_status->ViewValue = NULL;
			}
			$this->app_status->ViewCustomAttributes = "";

			// app_operator
			$this->app_operator->ViewValue = $this->app_operator->CurrentValue;
			$curVal = strval($this->app_operator->CurrentValue);
			if ($curVal <> "") {
				$this->app_operator->ViewValue = $this->app_operator->lookupCacheOption($curVal);
				if ($this->app_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->app_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->app_operator->ViewValue = $this->app_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->app_operator->ViewValue = $this->app_operator->CurrentValue;
					}
				}
			} else {
				$this->app_operator->ViewValue = NULL;
			}
			$this->app_operator->ViewCustomAttributes = "";

			// app_datetime
			$this->app_datetime->ViewValue = $this->app_datetime->CurrentValue;
			$this->app_datetime->ViewValue = FormatDateTime($this->app_datetime->ViewValue, 2);
			$this->app_datetime->ViewCustomAttributes = "";

			// po_remarks
			$this->po_remarks->ViewValue = $this->po_remarks->CurrentValue;
			$this->po_remarks->ViewCustomAttributes = "";

			// po_operator
			$curVal = strval($this->po_operator->CurrentValue);
			if ($curVal <> "") {
				$this->po_operator->ViewValue = $this->po_operator->lookupCacheOption($curVal);
				if ($this->po_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->po_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->po_operator->ViewValue = $this->po_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->po_operator->ViewValue = $this->po_operator->CurrentValue;
					}
				}
			} else {
				$this->po_operator->ViewValue = NULL;
			}
			$this->po_operator->ViewCustomAttributes = "";

			// po_datetime
			$this->po_datetime->ViewValue = $this->po_datetime->CurrentValue;
			$this->po_datetime->ViewValue = FormatDateTime($this->po_datetime->ViewValue, 2);
			$this->po_datetime->ViewCustomAttributes = "";

			// bom
			$this->bom->ViewValue = $this->bom->CurrentValue;
			$this->bom->ViewCustomAttributes = "";

			// pd_upload
			$this->pd_upload->UploadPath = '.p_uploads/sample_cart/dispatch/'. $this->id->CurrentValue . '';
			if (!EmptyValue($this->pd_upload->Upload->DbValue)) {
				$this->pd_upload->ViewValue = $this->pd_upload->Upload->DbValue;
			} else {
				$this->pd_upload->ViewValue = "";
			}
			$this->pd_upload->ViewCustomAttributes = "";

			// pd_comments
			$this->pd_comments->ViewValue = $this->pd_comments->CurrentValue;
			$this->pd_comments->ViewCustomAttributes = "";

			// pd_operator
			$curVal = strval($this->pd_operator->CurrentValue);
			if ($curVal <> "") {
				$this->pd_operator->ViewValue = $this->pd_operator->lookupCacheOption($curVal);
				if ($this->pd_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->pd_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->pd_operator->ViewValue = $this->pd_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->pd_operator->ViewValue = $this->pd_operator->CurrentValue;
					}
				}
			} else {
				$this->pd_operator->ViewValue = NULL;
			}
			$this->pd_operator->ViewCustomAttributes = "";

			// pd_datetime
			$this->pd_datetime->ViewValue = $this->pd_datetime->CurrentValue;
			$this->pd_datetime->ViewValue = FormatDateTime($this->pd_datetime->ViewValue, 0);
			$this->pd_datetime->ViewCustomAttributes = "";

			// da_comments
			$this->da_comments->ViewValue = $this->da_comments->CurrentValue;
			$this->da_comments->ViewCustomAttributes = "";

			// da_status
			$curVal = strval($this->da_status->CurrentValue);
			if ($curVal <> "") {
				$this->da_status->ViewValue = $this->da_status->lookupCacheOption($curVal);
				if ($this->da_status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 7 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->da_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->da_status->ViewValue = $this->da_status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->da_status->ViewValue = $this->da_status->CurrentValue;
					}
				}
			} else {
				$this->da_status->ViewValue = NULL;
			}
			$this->da_status->ViewCustomAttributes = "";

			// da_operator
			$curVal = strval($this->da_operator->CurrentValue);
			if ($curVal <> "") {
				$this->da_operator->ViewValue = $this->da_operator->lookupCacheOption($curVal);
				if ($this->da_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->da_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->da_operator->ViewValue = $this->da_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->da_operator->ViewValue = $this->da_operator->CurrentValue;
					}
				}
			} else {
				$this->da_operator->ViewValue = NULL;
			}
			$this->da_operator->ViewCustomAttributes = "";

			// da_datetime
			$this->da_datetime->ViewValue = $this->da_datetime->CurrentValue;
			$this->da_datetime->ViewValue = FormatDateTime($this->da_datetime->ViewValue, 0);
			$this->da_datetime->ViewCustomAttributes = "";

			// dispatch
			$this->dispatch->ViewValue = $this->dispatch->CurrentValue;
			$this->dispatch->ViewCustomAttributes = "";

			// d_operator
			$curVal = strval($this->d_operator->CurrentValue);
			if ($curVal <> "") {
				$this->d_operator->ViewValue = $this->d_operator->lookupCacheOption($curVal);
				if ($this->d_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->d_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->d_operator->ViewValue = $this->d_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->d_operator->ViewValue = $this->d_operator->CurrentValue;
					}
				}
			} else {
				$this->d_operator->ViewValue = NULL;
			}
			$this->d_operator->ViewCustomAttributes = "";

			// d_datetime
			$this->d_datetime->ViewValue = $this->d_datetime->CurrentValue;
			$this->d_datetime->ViewValue = FormatDateTime($this->d_datetime->ViewValue, 2);
			$this->d_datetime->ViewCustomAttributes = "";

			// r_comments
			$this->r_comments->ViewValue = $this->r_comments->CurrentValue;
			$this->r_comments->ViewCustomAttributes = "";

			// r_operator
			$curVal = strval($this->r_operator->CurrentValue);
			if ($curVal <> "") {
				$this->r_operator->ViewValue = $this->r_operator->lookupCacheOption($curVal);
				if ($this->r_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->r_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->r_operator->ViewValue = $this->r_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->r_operator->ViewValue = $this->r_operator->CurrentValue;
					}
				}
			} else {
				$this->r_operator->ViewValue = NULL;
			}
			$this->r_operator->ViewCustomAttributes = "";

			// r_datetime
			$this->r_datetime->ViewValue = $this->r_datetime->CurrentValue;
			$this->r_datetime->ViewValue = FormatDateTime($this->r_datetime->ViewValue, 0);
			$this->r_datetime->ViewCustomAttributes = "";

			// f_yn
			$curVal = strval($this->f_yn->CurrentValue);
			if ($curVal <> "") {
				$this->f_yn->ViewValue = $this->f_yn->lookupCacheOption($curVal);
				if ($this->f_yn->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=94 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->f_yn->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->f_yn->ViewValue = $this->f_yn->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->f_yn->ViewValue = $this->f_yn->CurrentValue;
					}
				}
			} else {
				$this->f_yn->ViewValue = NULL;
			}
			$this->f_yn->ViewCustomAttributes = "";

			// feedback
			$this->feedback->ViewValue = $this->feedback->CurrentValue;
			$this->feedback->ViewCustomAttributes = "";

			// f_operator
			$this->f_operator->ViewValue = $this->f_operator->CurrentValue;
			$curVal = strval($this->f_operator->CurrentValue);
			if ($curVal <> "") {
				$this->f_operator->ViewValue = $this->f_operator->lookupCacheOption($curVal);
				if ($this->f_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->f_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->f_operator->ViewValue = $this->f_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->f_operator->ViewValue = $this->f_operator->CurrentValue;
					}
				}
			} else {
				$this->f_operator->ViewValue = NULL;
			}
			$this->f_operator->ViewCustomAttributes = "";

			// f_datetime
			$this->f_datetime->ViewValue = $this->f_datetime->CurrentValue;
			$this->f_datetime->ViewValue = FormatDateTime($this->f_datetime->ViewValue, 2);
			$this->f_datetime->ViewCustomAttributes = "";

			// f_upload
			$this->f_upload->UploadPath = '.p_uploads/sample_cart/feedback/'. $this->id->CurrentValue . '';
			if (!EmptyValue($this->f_upload->Upload->DbValue)) {
				$this->f_upload->ImageWidth = 0;
				$this->f_upload->ImageHeight = 50;
				$this->f_upload->ImageAlt = $this->f_upload->alt();
				$this->f_upload->ViewValue = $this->f_upload->Upload->DbValue;
			} else {
				$this->f_upload->ViewValue = "";
			}
			$this->f_upload->ViewCustomAttributes = "";

			// fr_operator
			$curVal = strval($this->fr_operator->CurrentValue);
			if ($curVal <> "") {
				$this->fr_operator->ViewValue = $this->fr_operator->lookupCacheOption($curVal);
				if ($this->fr_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->fr_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->fr_operator->ViewValue = $this->fr_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->fr_operator->ViewValue = $this->fr_operator->CurrentValue;
					}
				}
			} else {
				$this->fr_operator->ViewValue = NULL;
			}
			$this->fr_operator->ViewCustomAttributes = "";

			// fr_datetime
			$this->fr_datetime->ViewValue = $this->fr_datetime->CurrentValue;
			$this->fr_datetime->ViewValue = FormatDateTime($this->fr_datetime->ViewValue, 0);
			$this->fr_datetime->ViewCustomAttributes = "";

			// req_chat_id
			$this->req_chat_id->ViewValue = $this->req_chat_id->CurrentValue;
			$this->req_chat_id->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// r_text
			$this->r_text->LinkCustomAttributes = "";
			$this->r_text->HrefValue = "";
			$this->r_text->TooltipValue = "";

			// old_ref
			$this->old_ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->old_ref->CurrentValue)) {
				$this->old_ref->HrefValue = "sample_req_cart_statuslist.php?x__barcode=" . $this->old_ref->CurrentValue . "&z__barcode=LIKE"; // Add prefix/suffix
				$this->old_ref->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->old_ref->HrefValue = FullUrl($this->old_ref->HrefValue, "href");
			} else {
				$this->old_ref->HrefValue = "";
			}
			$this->old_ref->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// request_by
			$this->request_by->LinkCustomAttributes = "";
			$this->request_by->HrefValue = "";
			$this->request_by->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// partner_id
			$this->partner_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->partner_id->CurrentValue)) {
				$this->partner_id->HrefValue = "po_blist.php?x_partner_id=" . $this->partner_id->CurrentValue; // Add prefix/suffix
				$this->partner_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->partner_id->HrefValue = FullUrl($this->partner_id->HrefValue, "href");
			} else {
				$this->partner_id->HrefValue = "";
			}
			$this->partner_id->TooltipValue = "";

			// upload
			$this->upload->LinkCustomAttributes = "";
			$this->upload->UploadPath = 'product_images/o/sample_cart/';
			if (!EmptyValue($this->upload->Upload->DbValue)) {
				$this->upload->HrefValue = "%u"; // Add prefix/suffix
				$this->upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->upload->HrefValue = FullUrl($this->upload->HrefValue, "href");
			} else {
				$this->upload->HrefValue = "";
			}
			$this->upload->ExportHrefValue = $this->upload->UploadPath . $this->upload->Upload->DbValue;
			$this->upload->TooltipValue = "";
			if ($this->upload->UseColorbox) {
				if (EmptyValue($this->upload->TooltipValue))
					$this->upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->upload->LinkAttrs["data-rel"] = "sample_req_cart_status_x_upload";
				AppendClass($this->upload->LinkAttrs["class"], "ew-lightbox");
			}

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// design
			$this->design->LinkCustomAttributes = "";
			$this->design->HrefValue = "";
			$this->design->TooltipValue = "";

			// color
			$this->color->LinkCustomAttributes = "";
			$this->color->HrefValue = "";
			$this->color->TooltipValue = "";

			// size
			$this->size->LinkCustomAttributes = "";
			$this->size->HrefValue = "";
			$this->size->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// shipping_mode
			$this->shipping_mode->LinkCustomAttributes = "";
			$this->shipping_mode->HrefValue = "";
			$this->shipping_mode->TooltipValue = "";

			// delivery_week
			$this->delivery_week->LinkCustomAttributes = "";
			$this->delivery_week->HrefValue = "";
			$this->delivery_week->TooltipValue = "";

			// purpose
			$this->purpose->LinkCustomAttributes = "";
			$this->purpose->HrefValue = "";
			$this->purpose->TooltipValue = "";

			// label
			$this->label->LinkCustomAttributes = "";
			$this->label->HrefValue = "";
			$this->label->TooltipValue = "";

			// ssd
			$this->ssd->LinkCustomAttributes = "";
			$this->ssd->HrefValue = "";
			$this->ssd->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// shipping_address_2
			$this->shipping_address_2->LinkCustomAttributes = "";
			$this->shipping_address_2->HrefValue = "";
			$this->shipping_address_2->TooltipValue = "";

			// sp_remarks
			$this->sp_remarks->LinkCustomAttributes = "";
			$this->sp_remarks->HrefValue = "";
			$this->sp_remarks->TooltipValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";
			$this->a_operator->TooltipValue = "";

			// a_datetime
			$this->a_datetime->LinkCustomAttributes = "";
			$this->a_datetime->HrefValue = "";
			$this->a_datetime->TooltipValue = "";

			// pp_remarks
			$this->pp_remarks->LinkCustomAttributes = "";
			$this->pp_remarks->HrefValue = "";
			$this->pp_remarks->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// declaration
			$this->declaration->LinkCustomAttributes = "";
			$this->declaration->HrefValue = "";
			$this->declaration->TooltipValue = "";

			// app_status
			$this->app_status->LinkCustomAttributes = "";
			$this->app_status->HrefValue = "";
			$this->app_status->TooltipValue = "";

			// app_operator
			$this->app_operator->LinkCustomAttributes = "";
			$this->app_operator->HrefValue = "";
			$this->app_operator->TooltipValue = "";

			// app_datetime
			$this->app_datetime->LinkCustomAttributes = "";
			$this->app_datetime->HrefValue = "";
			$this->app_datetime->TooltipValue = "";

			// po_remarks
			$this->po_remarks->LinkCustomAttributes = "";
			$this->po_remarks->HrefValue = "";
			$this->po_remarks->TooltipValue = "";

			// po_operator
			$this->po_operator->LinkCustomAttributes = "";
			$this->po_operator->HrefValue = "";
			$this->po_operator->TooltipValue = "";

			// po_datetime
			$this->po_datetime->LinkCustomAttributes = "";
			$this->po_datetime->HrefValue = "";
			$this->po_datetime->TooltipValue = "";

			// bom
			$this->bom->LinkCustomAttributes = "";
			$this->bom->HrefValue = "";
			$this->bom->TooltipValue = "";

			// pd_upload
			$this->pd_upload->LinkCustomAttributes = "";
			$this->pd_upload->UploadPath = '.p_uploads/sample_cart/dispatch/'. $this->id->CurrentValue . '';
			if (!EmptyValue($this->pd_upload->Upload->DbValue)) {
				$this->pd_upload->HrefValue = "%u"; // Add prefix/suffix
				$this->pd_upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->pd_upload->HrefValue = FullUrl($this->pd_upload->HrefValue, "href");
			} else {
				$this->pd_upload->HrefValue = "";
			}
			$this->pd_upload->ExportHrefValue = $this->pd_upload->UploadPath . $this->pd_upload->Upload->DbValue;
			$this->pd_upload->TooltipValue = "";

			// pd_comments
			$this->pd_comments->LinkCustomAttributes = "";
			$this->pd_comments->HrefValue = "";
			$this->pd_comments->TooltipValue = "";

			// pd_operator
			$this->pd_operator->LinkCustomAttributes = "";
			$this->pd_operator->HrefValue = "";
			$this->pd_operator->TooltipValue = "";

			// pd_datetime
			$this->pd_datetime->LinkCustomAttributes = "";
			$this->pd_datetime->HrefValue = "";
			$this->pd_datetime->TooltipValue = "";

			// da_comments
			$this->da_comments->LinkCustomAttributes = "";
			$this->da_comments->HrefValue = "";
			$this->da_comments->TooltipValue = "";

			// da_status
			$this->da_status->LinkCustomAttributes = "";
			$this->da_status->HrefValue = "";
			$this->da_status->TooltipValue = "";

			// da_operator
			$this->da_operator->LinkCustomAttributes = "";
			$this->da_operator->HrefValue = "";
			$this->da_operator->TooltipValue = "";

			// da_datetime
			$this->da_datetime->LinkCustomAttributes = "";
			$this->da_datetime->HrefValue = "";
			$this->da_datetime->TooltipValue = "";

			// dispatch
			$this->dispatch->LinkCustomAttributes = "";
			$this->dispatch->HrefValue = "";
			$this->dispatch->TooltipValue = "";

			// d_operator
			$this->d_operator->LinkCustomAttributes = "";
			$this->d_operator->HrefValue = "";
			$this->d_operator->TooltipValue = "";

			// d_datetime
			$this->d_datetime->LinkCustomAttributes = "";
			$this->d_datetime->HrefValue = "";
			$this->d_datetime->TooltipValue = "";

			// r_comments
			$this->r_comments->LinkCustomAttributes = "";
			$this->r_comments->HrefValue = "";
			$this->r_comments->TooltipValue = "";

			// r_operator
			$this->r_operator->LinkCustomAttributes = "";
			$this->r_operator->HrefValue = "";
			$this->r_operator->TooltipValue = "";

			// r_datetime
			$this->r_datetime->LinkCustomAttributes = "";
			$this->r_datetime->HrefValue = "";
			$this->r_datetime->TooltipValue = "";

			// f_yn
			$this->f_yn->LinkCustomAttributes = "";
			$this->f_yn->HrefValue = "";
			$this->f_yn->TooltipValue = "";

			// feedback
			$this->feedback->LinkCustomAttributes = "";
			$this->feedback->HrefValue = "";
			$this->feedback->TooltipValue = "";

			// f_operator
			$this->f_operator->LinkCustomAttributes = "";
			$this->f_operator->HrefValue = "";
			$this->f_operator->TooltipValue = "";

			// f_datetime
			$this->f_datetime->LinkCustomAttributes = "";
			$this->f_datetime->HrefValue = "";
			$this->f_datetime->TooltipValue = "";

			// f_upload
			$this->f_upload->LinkCustomAttributes = "";
			$this->f_upload->UploadPath = '.p_uploads/sample_cart/feedback/'. $this->id->CurrentValue . '';
			if (!EmptyValue($this->f_upload->Upload->DbValue)) {
				$this->f_upload->HrefValue = GetFileUploadUrl($this->f_upload, $this->f_upload->Upload->DbValue); // Add prefix/suffix
				$this->f_upload->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->f_upload->HrefValue = FullUrl($this->f_upload->HrefValue, "href");
			} else {
				$this->f_upload->HrefValue = "";
			}
			$this->f_upload->ExportHrefValue = $this->f_upload->UploadPath . $this->f_upload->Upload->DbValue;
			$this->f_upload->TooltipValue = "";
			if ($this->f_upload->UseColorbox) {
				if (EmptyValue($this->f_upload->TooltipValue))
					$this->f_upload->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->f_upload->LinkAttrs["data-rel"] = "sample_req_cart_status_x_f_upload";
				AppendClass($this->f_upload->LinkAttrs["class"], "ew-lightbox");
			}

			// fr_operator
			$this->fr_operator->LinkCustomAttributes = "";
			$this->fr_operator->HrefValue = "";
			$this->fr_operator->TooltipValue = "";

			// fr_datetime
			$this->fr_datetime->LinkCustomAttributes = "";
			$this->fr_datetime->HrefValue = "";
			$this->fr_datetime->TooltipValue = "";

			// req_chat_id
			$this->req_chat_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->url->CurrentValue)) {
				$this->req_chat_id->HrefValue = $this->url->CurrentValue; // Add prefix/suffix
				$this->req_chat_id->LinkAttrs["target"] = "_blank"; // Add target
				if ($this->isExport()) $this->req_chat_id->HrefValue = FullUrl($this->req_chat_id->HrefValue, "href");
			} else {
				$this->req_chat_id->HrefValue = "";
			}
			$this->req_chat_id->TooltipValue = "";
		}

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("sample_req_cart_statuslist.php"), "", $this->TableVar, TRUE);
		$pageId = "view";
		$Breadcrumb->add("view", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$pages->add(8);
		$pages->add(9);
		$pages->add(10);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_status":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_partner_id":
					$lookupFilter = function() {
						return "`status`=1 and `partner_type`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_delivery_week":
					$lookupFilter = function() {
						return (CurrentPageID() == "add" || CurrentPageID() == "addopt") ? "`weekstartday` > NOW()" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_app_status":
					$lookupFilter = function() {
						return "`grp` = 6 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_da_status":
					$lookupFilter = function() {
						return "`grp` = 7 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_f_yn":
					$lookupFilter = function() {
						return "`grp`=94 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_status":
							break;
						case "x_request_by":
							break;
						case "x_company_id":
							break;
						case "x_partner_id":
							break;
						case "x_operator":
							break;
						case "x_delivery_week":
							break;
						case "x_purpose":
							break;
						case "x_label":
							break;
						case "x_a_operator":
							break;
						case "x_app_status":
							break;
						case "x_app_operator":
							break;
						case "x_po_operator":
							break;
						case "x_pd_operator":
							break;
						case "x_da_status":
							break;
						case "x_da_operator":
							break;
						case "x_d_operator":
							break;
						case "x_r_operator":
							break;
						case "x_f_yn":
							break;
						case "x_f_operator":
							break;
						case "x_fr_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
		$CUID = CurrentUserID();
		$CDT = CurrentDateTime();
		$ID = $_GET['id'];
		isset($_GET['t']) ? $t = $_GET['t'] : $t = ''; 
		if ($t == 'fbr')
		{
		ExecuteStatement("UPDATE `sample_req_cart` set `fr_operator` = $CUID, `fr_datetime` = '$CDT' where `id` = $ID");
		header("location: sample_req_cart_statusview.php?id=" . $ID);
		}
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'sample_request_cart_status');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}
}
?>