<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class scouring_table_add extends scouring_table
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'scouring_table';

	// Page object name
	public $PageObjName = "scouring_table_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (scouring_table)
		if (!isset($GLOBALS["scouring_table"]) || get_class($GLOBALS["scouring_table"]) == PROJECT_NAMESPACE . "scouring_table") {
			$GLOBALS["scouring_table"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["scouring_table"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'scouring_table');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $scouring_table;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($scouring_table);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "scouring_tableview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("scouring_tablelist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->rid->Visible = FALSE;
		$this->product->setVisibility();
		$this->ref->setVisibility();
		$this->scouring_type->setVisibility();
		$this->packing_type->setVisibility();
		$this->quantity_avg_act->setVisibility();
		$this->packets->setVisibility();
		$this->avg_yield->setVisibility();
		$this->quantity->setVisibility();
		$this->max_qty->setVisibility();
		$this->godown->setVisibility();
		$this->dated->setVisibility();
		$this->employee_id->setVisibility();
		$this->next_issue_yn->setVisibility();
		$this->next_process->setVisibility();
		$this->next_godown->setVisibility();
		$this->remarks->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->ref);
		$this->setupLookupOptions($this->scouring_type);
		$this->setupLookupOptions($this->packing_type);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->employee_id);
		$this->setupLookupOptions($this->next_process);
		$this->setupLookupOptions($this->next_godown);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("scouring_tablelist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = 'autoprogramme.php?apcid=f33ba15effa5c10e873bf3842afb46a6';
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->rid->CurrentValue = NULL;
		$this->rid->OldValue = $this->rid->CurrentValue;
		$this->product->CurrentValue = NULL;
		$this->product->OldValue = $this->product->CurrentValue;
		$this->ref->CurrentValue = NULL;
		$this->ref->OldValue = $this->ref->CurrentValue;
		$this->scouring_type->CurrentValue = NULL;
		$this->scouring_type->OldValue = $this->scouring_type->CurrentValue;
		$this->packing_type->CurrentValue = 2;
		$this->quantity_avg_act->CurrentValue = 1;
		$this->packets->CurrentValue = NULL;
		$this->packets->OldValue = $this->packets->CurrentValue;
		$this->avg_yield->CurrentValue = NULL;
		$this->avg_yield->OldValue = $this->avg_yield->CurrentValue;
		$this->quantity->CurrentValue = NULL;
		$this->quantity->OldValue = $this->quantity->CurrentValue;
		$this->max_qty->CurrentValue = NULL;
		$this->max_qty->OldValue = $this->max_qty->CurrentValue;
		$this->godown->CurrentValue = NULL;
		$this->godown->OldValue = $this->godown->CurrentValue;
		$this->dated->CurrentValue = CurrentDate();
		$this->employee_id->CurrentValue = 1001;
		$this->next_issue_yn->CurrentValue = 0;
		$this->next_process->CurrentValue = NULL;
		$this->next_process->OldValue = $this->next_process->CurrentValue;
		$this->next_godown->CurrentValue = NULL;
		$this->next_godown->OldValue = $this->next_godown->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product->Visible = FALSE; // Disable update for API request
			else
				$this->product->setFormValue($val);
		}

		// Check field name 'ref' first before field var 'x_ref'
		$val = $CurrentForm->hasValue("ref") ? $CurrentForm->getValue("ref") : $CurrentForm->getValue("x_ref");
		if (!$this->ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ref->Visible = FALSE; // Disable update for API request
			else
				$this->ref->setFormValue($val);
		}

		// Check field name 'scouring_type' first before field var 'x_scouring_type'
		$val = $CurrentForm->hasValue("scouring_type") ? $CurrentForm->getValue("scouring_type") : $CurrentForm->getValue("x_scouring_type");
		if (!$this->scouring_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->scouring_type->Visible = FALSE; // Disable update for API request
			else
				$this->scouring_type->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'quantity_avg_act' first before field var 'x_quantity_avg_act'
		$val = $CurrentForm->hasValue("quantity_avg_act") ? $CurrentForm->getValue("quantity_avg_act") : $CurrentForm->getValue("x_quantity_avg_act");
		if (!$this->quantity_avg_act->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity_avg_act->Visible = FALSE; // Disable update for API request
			else
				$this->quantity_avg_act->setFormValue($val);
		}

		// Check field name 'packets' first before field var 'x_packets'
		$val = $CurrentForm->hasValue("packets") ? $CurrentForm->getValue("packets") : $CurrentForm->getValue("x_packets");
		if (!$this->packets->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packets->Visible = FALSE; // Disable update for API request
			else
				$this->packets->setFormValue($val);
		}

		// Check field name 'avg_yield' first before field var 'x_avg_yield'
		$val = $CurrentForm->hasValue("avg_yield") ? $CurrentForm->getValue("avg_yield") : $CurrentForm->getValue("x_avg_yield");
		if (!$this->avg_yield->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->avg_yield->Visible = FALSE; // Disable update for API request
			else
				$this->avg_yield->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'max_qty' first before field var 'x_max_qty'
		$val = $CurrentForm->hasValue("max_qty") ? $CurrentForm->getValue("max_qty") : $CurrentForm->getValue("x_max_qty");
		if (!$this->max_qty->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->max_qty->Visible = FALSE; // Disable update for API request
			else
				$this->max_qty->setFormValue($val);
		}

		// Check field name 'godown' first before field var 'x_godown'
		$val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
		if (!$this->godown->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->godown->Visible = FALSE; // Disable update for API request
			else
				$this->godown->setFormValue($val);
		}

		// Check field name 'dated' first before field var 'x_dated'
		$val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
		if (!$this->dated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dated->Visible = FALSE; // Disable update for API request
			else
				$this->dated->setFormValue($val);
			$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		}

		// Check field name 'employee_id' first before field var 'x_employee_id'
		$val = $CurrentForm->hasValue("employee_id") ? $CurrentForm->getValue("employee_id") : $CurrentForm->getValue("x_employee_id");
		if (!$this->employee_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->employee_id->Visible = FALSE; // Disable update for API request
			else
				$this->employee_id->setFormValue($val);
		}

		// Check field name 'next_issue_yn' first before field var 'x_next_issue_yn'
		$val = $CurrentForm->hasValue("next_issue_yn") ? $CurrentForm->getValue("next_issue_yn") : $CurrentForm->getValue("x_next_issue_yn");
		if (!$this->next_issue_yn->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->next_issue_yn->Visible = FALSE; // Disable update for API request
			else
				$this->next_issue_yn->setFormValue($val);
		}

		// Check field name 'next_process' first before field var 'x_next_process'
		$val = $CurrentForm->hasValue("next_process") ? $CurrentForm->getValue("next_process") : $CurrentForm->getValue("x_next_process");
		if (!$this->next_process->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->next_process->Visible = FALSE; // Disable update for API request
			else
				$this->next_process->setFormValue($val);
		}

		// Check field name 'next_godown' first before field var 'x_next_godown'
		$val = $CurrentForm->hasValue("next_godown") ? $CurrentForm->getValue("next_godown") : $CurrentForm->getValue("x_next_godown");
		if (!$this->next_godown->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->next_godown->Visible = FALSE; // Disable update for API request
			else
				$this->next_godown->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->product->CurrentValue = $this->product->FormValue;
		$this->ref->CurrentValue = $this->ref->FormValue;
		$this->scouring_type->CurrentValue = $this->scouring_type->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->quantity_avg_act->CurrentValue = $this->quantity_avg_act->FormValue;
		$this->packets->CurrentValue = $this->packets->FormValue;
		$this->avg_yield->CurrentValue = $this->avg_yield->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->max_qty->CurrentValue = $this->max_qty->FormValue;
		$this->godown->CurrentValue = $this->godown->FormValue;
		$this->dated->CurrentValue = $this->dated->FormValue;
		$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		$this->employee_id->CurrentValue = $this->employee_id->FormValue;
		$this->next_issue_yn->CurrentValue = $this->next_issue_yn->FormValue;
		$this->next_process->CurrentValue = $this->next_process->FormValue;
		$this->next_godown->CurrentValue = $this->next_godown->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->rid->setDbValue($row['rid']);
		$this->product->setDbValue($row['product']);
		$this->ref->setDbValue($row['ref']);
		if (array_key_exists('EV__ref', $rs->fields)) {
			$this->ref->VirtualValue = $rs->fields('EV__ref'); // Set up virtual field value
		} else {
			$this->ref->VirtualValue = ""; // Clear value
		}
		$this->scouring_type->setDbValue($row['scouring_type']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->quantity_avg_act->setDbValue($row['quantity_avg_act']);
		$this->packets->setDbValue($row['packets']);
		$this->avg_yield->setDbValue($row['avg_yield']);
		$this->quantity->setDbValue($row['quantity']);
		$this->max_qty->setDbValue($row['max_qty']);
		$this->godown->setDbValue($row['godown']);
		$this->dated->setDbValue($row['dated']);
		$this->employee_id->setDbValue($row['employee_id']);
		$this->next_issue_yn->setDbValue($row['next_issue_yn']);
		$this->next_process->setDbValue($row['next_process']);
		$this->next_godown->setDbValue($row['next_godown']);
		$this->remarks->setDbValue($row['remarks']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['rid'] = $this->rid->CurrentValue;
		$row['product'] = $this->product->CurrentValue;
		$row['ref'] = $this->ref->CurrentValue;
		$row['scouring_type'] = $this->scouring_type->CurrentValue;
		$row['packing_type'] = $this->packing_type->CurrentValue;
		$row['quantity_avg_act'] = $this->quantity_avg_act->CurrentValue;
		$row['packets'] = $this->packets->CurrentValue;
		$row['avg_yield'] = $this->avg_yield->CurrentValue;
		$row['quantity'] = $this->quantity->CurrentValue;
		$row['max_qty'] = $this->max_qty->CurrentValue;
		$row['godown'] = $this->godown->CurrentValue;
		$row['dated'] = $this->dated->CurrentValue;
		$row['employee_id'] = $this->employee_id->CurrentValue;
		$row['next_issue_yn'] = $this->next_issue_yn->CurrentValue;
		$row['next_process'] = $this->next_process->CurrentValue;
		$row['next_godown'] = $this->next_godown->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->quantity->FormValue == $this->quantity->CurrentValue && is_numeric(ConvertToFloatString($this->quantity->CurrentValue)))
			$this->quantity->CurrentValue = ConvertToFloatString($this->quantity->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// rid
		// product
		// ref
		// scouring_type
		// packing_type
		// quantity_avg_act
		// packets
		// avg_yield
		// quantity
		// max_qty
		// godown
		// dated
		// employee_id
		// next_issue_yn
		// next_process
		// next_godown
		// remarks
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// rid
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`product`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// ref
			if ($this->ref->VirtualValue <> "") {
				$this->ref->ViewValue = $this->ref->VirtualValue;
			} else {
			$curVal = strval($this->ref->CurrentValue);
			if ($curVal <> "") {
				$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
				if ($this->ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`Balance` > 0 AND `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 2, -2, -2, -2);
						$this->ref->ViewValue = $this->ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->ref->ViewValue = $this->ref->CurrentValue;
					}
				}
			} else {
				$this->ref->ViewValue = NULL;
			}
			}
			$this->ref->ViewCustomAttributes = "";

			// scouring_type
			$curVal = strval($this->scouring_type->CurrentValue);
			if ($curVal <> "") {
				$this->scouring_type->ViewValue = $this->scouring_type->lookupCacheOption($curVal);
				if ($this->scouring_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "grp = 1 and `process` = 12 and `status` = 1 and `name` not like 'Un-Scoured'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->scouring_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$this->scouring_type->ViewValue = $this->scouring_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->scouring_type->ViewValue = $this->scouring_type->CurrentValue;
					}
				}
			} else {
				$this->scouring_type->ViewValue = NULL;
			}
			$this->scouring_type->ViewCustomAttributes = "";

			// packing_type
			$curVal = strval($this->packing_type->CurrentValue);
			if ($curVal <> "") {
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
				if ($this->packing_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
					}
				}
			} else {
				$this->packing_type->ViewValue = NULL;
			}
			$this->packing_type->ViewCustomAttributes = "";

			// quantity_avg_act
			if (strval($this->quantity_avg_act->CurrentValue) <> "") {
				$this->quantity_avg_act->ViewValue = $this->quantity_avg_act->optionCaption($this->quantity_avg_act->CurrentValue);
			} else {
				$this->quantity_avg_act->ViewValue = NULL;
			}
			$this->quantity_avg_act->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewCustomAttributes = "";

			// avg_yield
			$this->avg_yield->ViewValue = $this->avg_yield->CurrentValue;
			$this->avg_yield->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewCustomAttributes = "";

			// max_qty
			$this->max_qty->ViewValue = $this->max_qty->CurrentValue;
			$this->max_qty->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET(`grp`, '0,1')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// employee_id
			$curVal = strval($this->employee_id->CurrentValue);
			if ($curVal <> "") {
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
				if ($this->employee_id->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return "`process` like '%12%'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->employee_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->employee_id->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
							$arwrk[2] = $rswrk->fields('df2');
							$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->employee_id->ViewValue = $this->employee_id->CurrentValue;
					}
				}
			} else {
				$this->employee_id->ViewValue = NULL;
			}
			$this->employee_id->ViewCustomAttributes = "";

			// next_issue_yn
			if (strval($this->next_issue_yn->CurrentValue) <> "") {
				$this->next_issue_yn->ViewValue = $this->next_issue_yn->optionCaption($this->next_issue_yn->CurrentValue);
			} else {
				$this->next_issue_yn->ViewValue = NULL;
			}
			$this->next_issue_yn->ViewCustomAttributes = "";

			// next_process
			$curVal = strval($this->next_process->CurrentValue);
			if ($curVal <> "") {
				$this->next_process->ViewValue = $this->next_process->lookupCacheOption($curVal);
				if ($this->next_process->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=1 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->next_process->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->next_process->ViewValue = $this->next_process->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->next_process->ViewValue = $this->next_process->CurrentValue;
					}
				}
			} else {
				$this->next_process->ViewValue = NULL;
			}
			$this->next_process->ViewCustomAttributes = "";

			// next_godown
			$curVal = strval($this->next_godown->CurrentValue);
			if ($curVal <> "") {
				$this->next_godown->ViewValue = $this->next_godown->lookupCacheOption($curVal);
				if ($this->next_godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET(`grp`, '0,1')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->next_godown->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->next_godown->ViewValue = $this->next_godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->next_godown->ViewValue = $this->next_godown->CurrentValue;
					}
				}
			} else {
				$this->next_godown->ViewValue = NULL;
			}
			$this->next_godown->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "scouring_tablelist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// ref
			$this->ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->ref->CurrentValue)) {
				$this->ref->HrefValue = "scouring_tablelist.php?x_ref=" . $this->ref->CurrentValue; // Add prefix/suffix
				$this->ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
			} else {
				$this->ref->HrefValue = "";
			}
			$this->ref->TooltipValue = "";

			// scouring_type
			$this->scouring_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->scouring_type->CurrentValue)) {
				$this->scouring_type->HrefValue = "scouring_tablelist.php?x_scouring_type=" . $this->scouring_type->CurrentValue; // Add prefix/suffix
				$this->scouring_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->scouring_type->HrefValue = FullUrl($this->scouring_type->HrefValue, "href");
			} else {
				$this->scouring_type->HrefValue = "";
			}
			$this->scouring_type->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "scouring_tablelist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_parent"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}
			$this->packing_type->TooltipValue = "";

			// quantity_avg_act
			$this->quantity_avg_act->LinkCustomAttributes = "";
			$this->quantity_avg_act->HrefValue = "";
			$this->quantity_avg_act->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// avg_yield
			$this->avg_yield->LinkCustomAttributes = "";
			$this->avg_yield->HrefValue = "";
			$this->avg_yield->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// max_qty
			$this->max_qty->LinkCustomAttributes = "";
			$this->max_qty->HrefValue = "";
			$this->max_qty->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "scouring_tablelist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->employee_id->CurrentValue)) {
				$this->employee_id->HrefValue = "scouring_tablelist.php?x_employee_id=" . $this->employee_id->CurrentValue; // Add prefix/suffix
				$this->employee_id->LinkAttrs["target"] = "_parent"; // Add target
				if ($this->isExport()) $this->employee_id->HrefValue = FullUrl($this->employee_id->HrefValue, "href");
			} else {
				$this->employee_id->HrefValue = "";
			}
			$this->employee_id->TooltipValue = "";

			// next_issue_yn
			$this->next_issue_yn->LinkCustomAttributes = "";
			$this->next_issue_yn->HrefValue = "";
			$this->next_issue_yn->TooltipValue = "";

			// next_process
			$this->next_process->LinkCustomAttributes = "";
			if (!EmptyValue($this->next_process->CurrentValue)) {
				$this->next_process->HrefValue = "scouring_tablelist.php?x_next_process=" . $this->next_process->CurrentValue; // Add prefix/suffix
				$this->next_process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->next_process->HrefValue = FullUrl($this->next_process->HrefValue, "href");
			} else {
				$this->next_process->HrefValue = "";
			}
			$this->next_process->TooltipValue = "";

			// next_godown
			$this->next_godown->LinkCustomAttributes = "";
			$this->next_godown->HrefValue = "";
			$this->next_godown->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->CurrentValue));
			if ($curVal <> "")
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`product`" . SearchString("=", $this->product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// ref
			$this->ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->ref->CurrentValue));
			if ($curVal <> "")
				$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
			else
				$this->ref->ViewValue = $this->ref->Lookup !== NULL && is_array($this->ref->Lookup->Options) ? $curVal : NULL;
			if ($this->ref->ViewValue !== NULL) { // Load from cache
				$this->ref->EditValue = array_values($this->ref->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->ref->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`Balance` > 0 AND `status`= 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->ref->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][4] = FormatNumber($arwrk[$i][4], 2, -2, -2, -2);
				}
				$this->ref->EditValue = $arwrk;
			}

			// scouring_type
			$this->scouring_type->EditAttrs["class"] = "form-control";
			$this->scouring_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->scouring_type->CurrentValue));
			if ($curVal <> "")
				$this->scouring_type->ViewValue = $this->scouring_type->lookupCacheOption($curVal);
			else
				$this->scouring_type->ViewValue = $this->scouring_type->Lookup !== NULL && is_array($this->scouring_type->Lookup->Options) ? $curVal : NULL;
			if ($this->scouring_type->ViewValue !== NULL) { // Load from cache
				$this->scouring_type->EditValue = array_values($this->scouring_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->scouring_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "grp = 1 and `process` = 12 and `status` = 1 and `name` not like 'Un-Scoured'";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->scouring_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->scouring_type->EditValue = $arwrk;
			}

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->packing_type->CurrentValue));
			if ($curVal <> "")
				$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			else
				$this->packing_type->ViewValue = $this->packing_type->Lookup !== NULL && is_array($this->packing_type->Lookup->Options) ? $curVal : NULL;
			if ($this->packing_type->ViewValue !== NULL) { // Load from cache
				$this->packing_type->EditValue = array_values($this->packing_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->packing_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->packing_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->packing_type->EditValue = $arwrk;
			}

			// quantity_avg_act
			$this->quantity_avg_act->EditCustomAttributes = "";
			$this->quantity_avg_act->EditValue = $this->quantity_avg_act->options(FALSE);

			// packets
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = "";
			$this->packets->EditValue = HtmlEncode($this->packets->CurrentValue);
			$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

			// avg_yield
			$this->avg_yield->EditAttrs["class"] = "form-control";
			$this->avg_yield->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->avg_yield->CurrentValue = HtmlDecode($this->avg_yield->CurrentValue);
			$this->avg_yield->EditValue = HtmlEncode($this->avg_yield->CurrentValue);
			$this->avg_yield->PlaceHolder = RemoveHtml($this->avg_yield->caption());

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());
			if (strval($this->quantity->EditValue) <> "" && is_numeric($this->quantity->EditValue))
				$this->quantity->EditValue = FormatNumber($this->quantity->EditValue, -2, -1, -2, 0);

			// max_qty
			$this->max_qty->EditAttrs["class"] = "form-control";
			$this->max_qty->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->max_qty->CurrentValue = HtmlDecode($this->max_qty->CurrentValue);
			$this->max_qty->EditValue = HtmlEncode($this->max_qty->CurrentValue);
			$this->max_qty->PlaceHolder = RemoveHtml($this->max_qty->caption());

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$curVal = trim(strval($this->godown->CurrentValue));
			if ($curVal <> "")
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			else
				$this->godown->ViewValue = $this->godown->Lookup !== NULL && is_array($this->godown->Lookup->Options) ? $curVal : NULL;
			if ($this->godown->ViewValue !== NULL) { // Load from cache
				$this->godown->EditValue = array_values($this->godown->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->godown->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "FIND_IN_SET(`grp`, '0,1')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->godown->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->godown->EditValue = $arwrk;
			}

			// dated
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, 8));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

			// employee_id
			$this->employee_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->employee_id->CurrentValue));
			if ($curVal <> "")
				$this->employee_id->ViewValue = $this->employee_id->lookupCacheOption($curVal);
			else
				$this->employee_id->ViewValue = $this->employee_id->Lookup !== NULL && is_array($this->employee_id->Lookup->Options) ? $curVal : NULL;
			if ($this->employee_id->ViewValue !== NULL) { // Load from cache
				$this->employee_id->EditValue = array_values($this->employee_id->Lookup->Options);
				if ($this->employee_id->ViewValue == "")
					$this->employee_id->ViewValue = $Language->phrase("PleaseSelect");
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return "`process` like '%12%'";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->employee_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->employee_id->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = HtmlEncode(FormatNumber($rswrk->fields('df'), 0, -2, -2, -2));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$this->employee_id->ViewValue->add($this->employee_id->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->MoveFirst();
				} else {
					$this->employee_id->ViewValue = $Language->phrase("PleaseSelect");
				}
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 0, -2, -2, -2);
				}
				$this->employee_id->EditValue = $arwrk;
			}

			// next_issue_yn
			$this->next_issue_yn->EditCustomAttributes = "";
			$this->next_issue_yn->EditValue = $this->next_issue_yn->options(FALSE);

			// next_process
			$this->next_process->EditCustomAttributes = "";
			$curVal = trim(strval($this->next_process->CurrentValue));
			if ($curVal <> "")
				$this->next_process->ViewValue = $this->next_process->lookupCacheOption($curVal);
			else
				$this->next_process->ViewValue = $this->next_process->Lookup !== NULL && is_array($this->next_process->Lookup->Options) ? $curVal : NULL;
			if ($this->next_process->ViewValue !== NULL) { // Load from cache
				$this->next_process->EditValue = array_values($this->next_process->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->next_process->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=1 and `status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->next_process->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->next_process->EditValue = $arwrk;
			}

			// next_godown
			$this->next_godown->EditAttrs["class"] = "form-control";
			$this->next_godown->EditCustomAttributes = "";
			$curVal = trim(strval($this->next_godown->CurrentValue));
			if ($curVal <> "")
				$this->next_godown->ViewValue = $this->next_godown->lookupCacheOption($curVal);
			else
				$this->next_godown->ViewValue = $this->next_godown->Lookup !== NULL && is_array($this->next_godown->Lookup->Options) ? $curVal : NULL;
			if ($this->next_godown->ViewValue !== NULL) { // Load from cache
				$this->next_godown->EditValue = array_values($this->next_godown->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->next_godown->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "FIND_IN_SET(`grp`, '0,1')";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->next_godown->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->next_godown->EditValue = $arwrk;
			}

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// operator
			// datetime
			// Add refer script
			// product

			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "scouring_tablelist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// ref
			$this->ref->LinkCustomAttributes = "";
			if (!EmptyValue($this->ref->CurrentValue)) {
				$this->ref->HrefValue = "scouring_tablelist.php?x_ref=" . $this->ref->CurrentValue; // Add prefix/suffix
				$this->ref->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
			} else {
				$this->ref->HrefValue = "";
			}

			// scouring_type
			$this->scouring_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->scouring_type->CurrentValue)) {
				$this->scouring_type->HrefValue = "scouring_tablelist.php?x_scouring_type=" . $this->scouring_type->CurrentValue; // Add prefix/suffix
				$this->scouring_type->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->scouring_type->HrefValue = FullUrl($this->scouring_type->HrefValue, "href");
			} else {
				$this->scouring_type->HrefValue = "";
			}

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			if (!EmptyValue($this->packing_type->CurrentValue)) {
				$this->packing_type->HrefValue = "scouring_tablelist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
				$this->packing_type->LinkAttrs["target"] = "_parent"; // Add target
				if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
			} else {
				$this->packing_type->HrefValue = "";
			}

			// quantity_avg_act
			$this->quantity_avg_act->LinkCustomAttributes = "";
			$this->quantity_avg_act->HrefValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";

			// avg_yield
			$this->avg_yield->LinkCustomAttributes = "";
			$this->avg_yield->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// max_qty
			$this->max_qty->LinkCustomAttributes = "";
			$this->max_qty->HrefValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "scouring_tablelist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";

			// employee_id
			$this->employee_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->employee_id->CurrentValue)) {
				$this->employee_id->HrefValue = "scouring_tablelist.php?x_employee_id=" . $this->employee_id->CurrentValue; // Add prefix/suffix
				$this->employee_id->LinkAttrs["target"] = "_parent"; // Add target
				if ($this->isExport()) $this->employee_id->HrefValue = FullUrl($this->employee_id->HrefValue, "href");
			} else {
				$this->employee_id->HrefValue = "";
			}

			// next_issue_yn
			$this->next_issue_yn->LinkCustomAttributes = "";
			$this->next_issue_yn->HrefValue = "";

			// next_process
			$this->next_process->LinkCustomAttributes = "";
			if (!EmptyValue($this->next_process->CurrentValue)) {
				$this->next_process->HrefValue = "scouring_tablelist.php?x_next_process=" . $this->next_process->CurrentValue; // Add prefix/suffix
				$this->next_process->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->next_process->HrefValue = FullUrl($this->next_process->HrefValue, "href");
			} else {
				$this->next_process->HrefValue = "";
			}

			// next_godown
			$this->next_godown->LinkCustomAttributes = "";
			$this->next_godown->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->ref->Required) {
			if ($this->ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ref->caption(), $this->ref->RequiredErrorMessage));
			}
		}
		if ($this->scouring_type->Required) {
			if (!$this->scouring_type->IsDetailKey && $this->scouring_type->FormValue != NULL && $this->scouring_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->scouring_type->caption(), $this->scouring_type->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->quantity_avg_act->Required) {
			if ($this->quantity_avg_act->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity_avg_act->caption(), $this->quantity_avg_act->RequiredErrorMessage));
			}
		}
		if ($this->packets->Required) {
			if (!$this->packets->IsDetailKey && $this->packets->FormValue != NULL && $this->packets->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packets->caption(), $this->packets->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->packets->FormValue)) {
			AddMessage($FormError, $this->packets->errorMessage());
		}
		if ($this->avg_yield->Required) {
			if (!$this->avg_yield->IsDetailKey && $this->avg_yield->FormValue != NULL && $this->avg_yield->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->avg_yield->caption(), $this->avg_yield->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->max_qty->Required) {
			if (!$this->max_qty->IsDetailKey && $this->max_qty->FormValue != NULL && $this->max_qty->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->max_qty->caption(), $this->max_qty->RequiredErrorMessage));
			}
		}
		if ($this->godown->Required) {
			if (!$this->godown->IsDetailKey && $this->godown->FormValue != NULL && $this->godown->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
			}
		}
		if ($this->dated->Required) {
			if (!$this->dated->IsDetailKey && $this->dated->FormValue != NULL && $this->dated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dated->FormValue)) {
			AddMessage($FormError, $this->dated->errorMessage());
		}
		if ($this->employee_id->Required) {
			if ($this->employee_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->employee_id->caption(), $this->employee_id->RequiredErrorMessage));
			}
		}
		if ($this->next_issue_yn->Required) {
			if ($this->next_issue_yn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->next_issue_yn->caption(), $this->next_issue_yn->RequiredErrorMessage));
			}
		}
		if ($this->next_process->Required) {
			if ($this->next_process->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->next_process->caption(), $this->next_process->RequiredErrorMessage));
			}
		}
		if ($this->next_godown->Required) {
			if (!$this->next_godown->IsDetailKey && $this->next_godown->FormValue != NULL && $this->next_godown->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->next_godown->caption(), $this->next_godown->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// product
		$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, 0, FALSE);

		// ref
		$this->ref->setDbValueDef($rsnew, $this->ref->CurrentValue, NULL, FALSE);

		// scouring_type
		$this->scouring_type->setDbValueDef($rsnew, $this->scouring_type->CurrentValue, NULL, FALSE);

		// packing_type
		$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, NULL, FALSE);

		// quantity_avg_act
		$this->quantity_avg_act->setDbValueDef($rsnew, $this->quantity_avg_act->CurrentValue, NULL, strval($this->quantity_avg_act->CurrentValue) == "");

		// packets
		$this->packets->setDbValueDef($rsnew, $this->packets->CurrentValue, NULL, FALSE);

		// avg_yield
		$this->avg_yield->setDbValueDef($rsnew, $this->avg_yield->CurrentValue, "", FALSE);

		// quantity
		$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, NULL, FALSE);

		// max_qty
		$this->max_qty->setDbValueDef($rsnew, $this->max_qty->CurrentValue, "", FALSE);

		// godown
		$this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, NULL, FALSE);

		// dated
		$this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, 0), NULL, FALSE);

		// employee_id
		$this->employee_id->setDbValueDef($rsnew, $this->employee_id->CurrentValue, "", FALSE);

		// next_issue_yn
		$this->next_issue_yn->setDbValueDef($rsnew, $this->next_issue_yn->CurrentValue, 0, FALSE);

		// next_process
		$this->next_process->setDbValueDef($rsnew, $this->next_process->CurrentValue, NULL, FALSE);

		// next_godown
		$this->next_godown->setDbValueDef($rsnew, $this->next_godown->CurrentValue, 0, FALSE);

		// remarks
		$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("scouring_tablelist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_product":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_ref":
					$lookupFilter = function() {
						return "`Balance` > 0 AND `status`= 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_scouring_type":
					$lookupFilter = function() {
						return "grp = 1 and `process` = 12 and `status` = 1 and `name` not like 'Un-Scoured'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_packing_type":
					$lookupFilter = function() {
						return "`grp`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_godown":
					$lookupFilter = function() {
						return "FIND_IN_SET(`grp`, '0,1')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_employee_id":
					$lookupFilter = function() {
						return "`process` like '%12%'";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_next_process":
					$lookupFilter = function() {
						return "`grp`=1 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_next_godown":
					$lookupFilter = function() {
						return "FIND_IN_SET(`grp`, '0,1')";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_rid":
							break;
						case "x_product":
							break;
						case "x_ref":
							$row[4] = FormatNumber($row[4], 2, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_scouring_type":
							break;
						case "x_packing_type":
							break;
						case "x_godown":
							break;
						case "x_employee_id":
							$row[1] = FormatNumber($row[1], 0, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_next_process":
							break;
						case "x_next_godown":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
		//	$this->product->ReadOnly = TRUE;

			$this->avg_yield->ReadOnly = TRUE;
			$this->max_qty->ReadOnly = TRUE;
			$this->godown->ReadOnly = TRUE;
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>