<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for service_report
 */
class service_report extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $buyer_id;
	public $hardware_id;
	public $service_executive;
	public $entry_time;
	public $current_reading;
	public $error_ref;
	public $service_type;
	public $complaint;
	public $observation;
	public $product_replaced;
	public $consumable_replaced;
	public $out_time;
	public $work_detail;
	public $future_task;
	public $last_status;
	public $operator;
	public $datetime;
	public $a_operator;
	public $invoice;
	public $invoice_date;
	public $uploads;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'service_report';
		$this->TableName = 'service_report';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`service_report`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('service_report', 'service_report', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// buyer_id
		$this->buyer_id = new DbField('service_report', 'service_report', 'x_buyer_id', 'buyer_id', '`buyer_id`', '`buyer_id`', 19, -1, FALSE, '`buyer_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_id->Nullable = FALSE; // NOT NULL field
		$this->buyer_id->Required = TRUE; // Required field
		$this->buyer_id->Sortable = TRUE; // Allow sort
		$this->buyer_id->Lookup = new Lookup('buyer_id', 'buyer', FALSE, 'id', ["name","code","mobile","city_name"], [], ["x_hardware_id","x_error_ref","x_product_replaced[]","x_consumable_replaced[]"], [], [], [], [], '`name` ASC', '');
		$this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer_id'] = &$this->buyer_id;

		// hardware_id
		$this->hardware_id = new DbField('service_report', 'service_report', 'x_hardware_id', 'hardware_id', '`hardware_id`', '`hardware_id`', 18, -1, FALSE, '`hardware_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->hardware_id->Required = TRUE; // Required field
		$this->hardware_id->Sortable = TRUE; // Allow sort
		$this->hardware_id->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->hardware_id->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->hardware_id->Lookup = new Lookup('hardware_id', 'client_hardware_data', FALSE, 'id', ["ref","name_ref","harward_code","serial_no"], ["x_buyer_id"], [], ["partner_id"], ["x_partner_id"], [], [], '`name_ref` ASC', '');
		$this->hardware_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['hardware_id'] = &$this->hardware_id;

		// service_executive
		$this->service_executive = new DbField('service_report', 'service_report', 'x_service_executive', 'service_executive', '`service_executive`', '`service_executive`', 18, -1, FALSE, '`service_executive`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->service_executive->Required = TRUE; // Required field
		$this->service_executive->Sortable = TRUE; // Allow sort
		$this->service_executive->Lookup = new Lookup('service_executive', 'admin', FALSE, 'id', ["user_name","","",""], [], ["x_error_ref"], [], [], [], [], '`user_name` ASC', '');
		$this->service_executive->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['service_executive'] = &$this->service_executive;

		// entry_time
		$this->entry_time = new DbField('service_report', 'service_report', 'x_entry_time', 'entry_time', '`entry_time`', CastDateFieldForLike('`entry_time`', 0, "DB"), 135, 0, FALSE, '`entry_time`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->entry_time->Sortable = TRUE; // Allow sort
		$this->entry_time->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['entry_time'] = &$this->entry_time;

		// current_reading
		$this->current_reading = new DbField('service_report', 'service_report', 'x_current_reading', 'current_reading', '`current_reading`', '`current_reading`', 19, -1, FALSE, '`current_reading`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->current_reading->Nullable = FALSE; // NOT NULL field
		$this->current_reading->Required = TRUE; // Required field
		$this->current_reading->Sortable = TRUE; // Allow sort
		$this->current_reading->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['current_reading'] = &$this->current_reading;

		// error_ref
		$this->error_ref = new DbField('service_report', 'service_report', 'x_error_ref', 'error_ref', '`error_ref`', '`error_ref`', 201, -1, FALSE, '`error_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->error_ref->Sortable = TRUE; // Allow sort
		$this->error_ref->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->error_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->error_ref->Lookup = new Lookup('error_ref', 'service_request', FALSE, 'id', ["datetime","rid_1","",""], ["x_service_executive","x_buyer_id"], [], ["service_executive","buyer_id"], ["x_service_executive","x_buyer_id"], ["error"], ["x_complaint"], '`id` ASC', '');
		$this->error_ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['error_ref'] = &$this->error_ref;

		// service_type
		$this->service_type = new DbField('service_report', 'service_report', 'x_service_type', 'service_type', '`service_type`', '`service_type`', 18, -1, FALSE, '`service_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->service_type->Required = TRUE; // Required field
		$this->service_type->Sortable = TRUE; // Allow sort
		$this->service_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->service_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->service_type->Lookup = new Lookup('service_type', 'service_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->service_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['service_type'] = &$this->service_type;

		// complaint
		$this->complaint = new DbField('service_report', 'service_report', 'x_complaint', 'complaint', '`complaint`', '`complaint`', 200, -1, FALSE, '`complaint`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->complaint->Required = TRUE; // Required field
		$this->complaint->Sortable = TRUE; // Allow sort
		$this->complaint->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->complaint->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->complaint->Lookup = new Lookup('complaint', 'service_misc', FALSE, 'item', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['complaint'] = &$this->complaint;

		// observation
		$this->observation = new DbField('service_report', 'service_report', 'x_observation', 'observation', '`observation`', '`observation`', 200, -1, FALSE, '`observation`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->observation->Required = TRUE; // Required field
		$this->observation->Sortable = TRUE; // Allow sort
		$this->fields['observation'] = &$this->observation;

		// product_replaced
		$this->product_replaced = new DbField('service_report', 'service_report', 'x_product_replaced', 'product_replaced', '`product_replaced`', '`product_replaced`', 200, -1, FALSE, '`product_replaced`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->product_replaced->Sortable = TRUE; // Allow sort
		$this->product_replaced->Lookup = new Lookup('product_replaced', 'material_out_wbc', FALSE, 'id', ["rid_name","quantity","",""], ["x_buyer_id"], [], ["issue_to"], ["x_issue_to"], [], [], '`rid_name` ASC', '<span class="text-info">{{:df1}}, Qty : {{:df2}}</span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'material_out_wbcedit.php?id={{:lf}}\'});"> Edit </span><a href="material_out_wbcdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->product_replaced->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_replaced'] = &$this->product_replaced;

		// consumable_replaced
		$this->consumable_replaced = new DbField('service_report', 'service_report', 'x_consumable_replaced', 'consumable_replaced', '`consumable_replaced`', '`consumable_replaced`', 200, -1, FALSE, '`consumable_replaced`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'CHECKBOX');
		$this->consumable_replaced->Sortable = TRUE; // Allow sort
		$this->consumable_replaced->Lookup = new Lookup('consumable_replaced', 'material_out_wbc', FALSE, 'id', ["rid_name","quantity","",""], ["x_buyer_id"], [], ["issue_to"], ["x_issue_to"], [], [], '`rid_name` ASC', '<span class="text-info">{{:df1}}, Qty : {{:df2}}</span><span style="color:blue" onclick="ew.modalDialogShow({lnk:this,btn:\'SaveBtn\',url:\'material_out_wbcedit.php?id={{:lf}}\'});"> Edit </span><a href="material_out_wbcdelete.php?id={{:lf}}"><span style="color:red"> Delete </span></a>');
		$this->consumable_replaced->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['consumable_replaced'] = &$this->consumable_replaced;

		// out_time
		$this->out_time = new DbField('service_report', 'service_report', 'x_out_time', 'out_time', '`out_time`', CastDateFieldForLike('`out_time`', 0, "DB"), 135, 0, FALSE, '`out_time`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->out_time->Sortable = TRUE; // Allow sort
		$this->out_time->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['out_time'] = &$this->out_time;

		// work_detail
		$this->work_detail = new DbField('service_report', 'service_report', 'x_work_detail', 'work_detail', '`work_detail`', '`work_detail`', 200, -1, FALSE, '`work_detail`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->work_detail->Required = TRUE; // Required field
		$this->work_detail->Sortable = TRUE; // Allow sort
		$this->fields['work_detail'] = &$this->work_detail;

		// future_task
		$this->future_task = new DbField('service_report', 'service_report', 'x_future_task', 'future_task', '`future_task`', '`future_task`', 201, -1, FALSE, '`future_task`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->future_task->Sortable = TRUE; // Allow sort
		$this->fields['future_task'] = &$this->future_task;

		// last_status
		$this->last_status = new DbField('service_report', 'service_report', 'x_last_status', 'last_status', '`last_status`', '`last_status`', 18, -1, FALSE, '`last_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->last_status->Required = TRUE; // Required field
		$this->last_status->Sortable = TRUE; // Allow sort
		$this->last_status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->last_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->last_status->Lookup = new Lookup('last_status', 'service_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->last_status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['last_status'] = &$this->last_status;

		// operator
		$this->operator = new DbField('service_report', 'service_report', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('service_report', 'service_report', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// a_operator
		$this->a_operator = new DbField('service_report', 'service_report', 'x_a_operator', 'a_operator', '`a_operator`', '`a_operator`', 18, -1, FALSE, '`a_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->a_operator->Sortable = TRUE; // Allow sort
		$this->a_operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->a_operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->a_operator->Lookup = new Lookup('a_operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->a_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['a_operator'] = &$this->a_operator;

		// invoice
		$this->invoice = new DbField('service_report', 'service_report', 'x_invoice', 'invoice', '`invoice`', '`invoice`', 200, -1, FALSE, '`invoice`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice->Sortable = TRUE; // Allow sort
		$this->fields['invoice'] = &$this->invoice;

		// invoice_date
		$this->invoice_date = new DbField('service_report', 'service_report', 'x_invoice_date', 'invoice_date', '`invoice_date`', CastDateFieldForLike('`invoice_date`', 0, "DB"), 135, 0, FALSE, '`invoice_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice_date->Sortable = TRUE; // Allow sort
		$this->invoice_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['invoice_date'] = &$this->invoice_date;

		// uploads
		$this->uploads = new DbField('service_report', 'service_report', 'x_uploads', 'uploads', '`uploads`', '`uploads`', 201, -1, FALSE, '`uploads`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->uploads->Sortable = TRUE; // Allow sort
		$this->fields['uploads'] = &$this->uploads;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`service_report`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Category() == 92) ? "`service_executive` = " .  CurrentUserID() . ' and `last_status` NOT IN (4104,4105) and `out_time` is NULL' : "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->buyer_id->DbValue = $row['buyer_id'];
		$this->hardware_id->DbValue = $row['hardware_id'];
		$this->service_executive->DbValue = $row['service_executive'];
		$this->entry_time->DbValue = $row['entry_time'];
		$this->current_reading->DbValue = $row['current_reading'];
		$this->error_ref->DbValue = $row['error_ref'];
		$this->service_type->DbValue = $row['service_type'];
		$this->complaint->DbValue = $row['complaint'];
		$this->observation->DbValue = $row['observation'];
		$this->product_replaced->DbValue = $row['product_replaced'];
		$this->consumable_replaced->DbValue = $row['consumable_replaced'];
		$this->out_time->DbValue = $row['out_time'];
		$this->work_detail->DbValue = $row['work_detail'];
		$this->future_task->DbValue = $row['future_task'];
		$this->last_status->DbValue = $row['last_status'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->a_operator->DbValue = $row['a_operator'];
		$this->invoice->DbValue = $row['invoice'];
		$this->invoice_date->DbValue = $row['invoice_date'];
		$this->uploads->DbValue = $row['uploads'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "service_reportlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "service_reportview.php")
			return $Language->phrase("View");
		elseif ($pageName == "service_reportedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "service_reportadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "service_reportlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("service_reportview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("service_reportview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "service_reportadd.php?" . $this->getUrlParm($parm);
		else
			$url = "service_reportadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("service_reportedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("service_reportadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("service_reportdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->buyer_id->setDbValue($rs->fields('buyer_id'));
		$this->hardware_id->setDbValue($rs->fields('hardware_id'));
		$this->service_executive->setDbValue($rs->fields('service_executive'));
		$this->entry_time->setDbValue($rs->fields('entry_time'));
		$this->current_reading->setDbValue($rs->fields('current_reading'));
		$this->error_ref->setDbValue($rs->fields('error_ref'));
		$this->service_type->setDbValue($rs->fields('service_type'));
		$this->complaint->setDbValue($rs->fields('complaint'));
		$this->observation->setDbValue($rs->fields('observation'));
		$this->product_replaced->setDbValue($rs->fields('product_replaced'));
		$this->consumable_replaced->setDbValue($rs->fields('consumable_replaced'));
		$this->out_time->setDbValue($rs->fields('out_time'));
		$this->work_detail->setDbValue($rs->fields('work_detail'));
		$this->future_task->setDbValue($rs->fields('future_task'));
		$this->last_status->setDbValue($rs->fields('last_status'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->a_operator->setDbValue($rs->fields('a_operator'));
		$this->invoice->setDbValue($rs->fields('invoice'));
		$this->invoice_date->setDbValue($rs->fields('invoice_date'));
		$this->uploads->setDbValue($rs->fields('uploads'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// buyer_id
		// hardware_id
		// service_executive
		// entry_time
		// current_reading
		// error_ref
		// service_type
		// complaint
		// observation
		// product_replaced
		// consumable_replaced
		// out_time
		// work_detail
		// future_task
		// last_status
		// operator
		// datetime
		// a_operator
		// invoice
		// invoice_date
		// uploads
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// buyer_id
		$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id`>1000 and `status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->ViewValue = NULL;
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// hardware_id
		$curVal = strval($this->hardware_id->CurrentValue);
		if ($curVal <> "") {
			$this->hardware_id->ViewValue = $this->hardware_id->lookupCacheOption($curVal);
			if ($this->hardware_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->hardware_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->hardware_id->ViewValue = $this->hardware_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->hardware_id->ViewValue = $this->hardware_id->CurrentValue;
				}
			}
		} else {
			$this->hardware_id->ViewValue = NULL;
		}
		$this->hardware_id->ViewCustomAttributes = "";

		// service_executive
		$this->service_executive->ViewValue = $this->service_executive->CurrentValue;
		$curVal = strval($this->service_executive->CurrentValue);
		if ($curVal <> "") {
			$this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
			if ($this->service_executive->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "FIND_IN_SET('92', `category`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->service_executive->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->service_executive->ViewValue = $this->service_executive->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->service_executive->ViewValue = $this->service_executive->CurrentValue;
				}
			}
		} else {
			$this->service_executive->ViewValue = NULL;
		}
		$this->service_executive->ViewCustomAttributes = "";

		// entry_time
		$this->entry_time->ViewValue = $this->entry_time->CurrentValue;
		$this->entry_time->ViewValue = FormatDateTime($this->entry_time->ViewValue, 0);
		$this->entry_time->ViewCustomAttributes = "";

		// current_reading
		$this->current_reading->ViewValue = $this->current_reading->CurrentValue;
		$this->current_reading->ViewValue = FormatNumber($this->current_reading->ViewValue, 0, -2, -2, -2);
		$this->current_reading->ViewCustomAttributes = "";

		// error_ref
		$curVal = strval($this->error_ref->CurrentValue);
		if ($curVal <> "") {
			$this->error_ref->ViewValue = $this->error_ref->lookupCacheOption($curVal);
			if ($this->error_ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status` !=9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->error_ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatDateTime($rswrk->fields('df'), 0);
					$arwrk[2] = $rswrk->fields('df2');
					$this->error_ref->ViewValue = $this->error_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->error_ref->ViewValue = $this->error_ref->CurrentValue;
				}
			}
		} else {
			$this->error_ref->ViewValue = NULL;
		}
		$this->error_ref->ViewCustomAttributes = "";

		// service_type
		$curVal = strval($this->service_type->CurrentValue);
		if ($curVal <> "") {
			$this->service_type->ViewValue = $this->service_type->lookupCacheOption($curVal);
			if ($this->service_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp`=11  and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->service_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->service_type->ViewValue = $this->service_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->service_type->ViewValue = $this->service_type->CurrentValue;
				}
			}
		} else {
			$this->service_type->ViewValue = NULL;
		}
		$this->service_type->ViewCustomAttributes = "";

		// complaint
		$curVal = strval($this->complaint->CurrentValue);
		if ($curVal <> "") {
			$this->complaint->ViewValue = $this->complaint->lookupCacheOption($curVal);
			if ($this->complaint->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`item`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$lookupFilter = function() {
					return "`grp` = 21 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->complaint->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->complaint->ViewValue = $this->complaint->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->complaint->ViewValue = $this->complaint->CurrentValue;
				}
			}
		} else {
			$this->complaint->ViewValue = NULL;
		}
		$this->complaint->ViewCustomAttributes = "";

		// observation
		$this->observation->ViewValue = $this->observation->CurrentValue;
		$this->observation->ViewCustomAttributes = "";

		// product_replaced
		$curVal = strval($this->product_replaced->CurrentValue);
		if ($curVal <> "") {
			$this->product_replaced->ViewValue = $this->product_replaced->lookupCacheOption($curVal);
			if ($this->product_replaced->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '3,4,8,10') and FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')"));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_replaced->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->product_replaced->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -1, -1, -1);
						$this->product_replaced->ViewValue->add($this->product_replaced->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->product_replaced->ViewValue = $this->product_replaced->CurrentValue;
				}
			}
		} else {
			$this->product_replaced->ViewValue = NULL;
		}
		$this->product_replaced->ViewCustomAttributes = "";

		// consumable_replaced
		$curVal = strval($this->consumable_replaced->CurrentValue);
		if ($curVal <> "") {
			$this->consumable_replaced->ViewValue = $this->consumable_replaced->lookupCacheOption($curVal);
			if ($this->consumable_replaced->ViewValue === NULL) { // Lookup from database
				$arwrk = explode(",", $curVal);
				$filterWrk = "";
				foreach ($arwrk as $wrk) {
					if ($filterWrk <> "")
						$filterWrk .= " OR ";
					$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '5,6,7,9') and FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')"));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->consumable_replaced->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$this->consumable_replaced->ViewValue = new OptionValues();
					$ari = 0;
					while (!$rswrk->EOF) {
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -1, -1, -1);
						$this->consumable_replaced->ViewValue->add($this->consumable_replaced->displayValue($arwrk));
						$rswrk->MoveNext();
						$ari++;
					}
					$rswrk->Close();
				} else {
					$this->consumable_replaced->ViewValue = $this->consumable_replaced->CurrentValue;
				}
			}
		} else {
			$this->consumable_replaced->ViewValue = NULL;
		}
		$this->consumable_replaced->ViewCustomAttributes = "";

		// out_time
		$this->out_time->ViewValue = $this->out_time->CurrentValue;
		$this->out_time->ViewValue = FormatDateTime($this->out_time->ViewValue, 0);
		$this->out_time->ViewCustomAttributes = "";

		// work_detail
		$this->work_detail->ViewValue = $this->work_detail->CurrentValue;
		$this->work_detail->ViewCustomAttributes = "";

		// future_task
		$this->future_task->ViewValue = $this->future_task->CurrentValue;
		$this->future_task->ViewCustomAttributes = "";

		// last_status
		$curVal = strval($this->last_status->CurrentValue);
		if ($curVal <> "") {
			$this->last_status->ViewValue = $this->last_status->lookupCacheOption($curVal);
			if ($this->last_status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 41 and `status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->last_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->last_status->ViewValue = $this->last_status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->last_status->ViewValue = $this->last_status->CurrentValue;
				}
			}
		} else {
			$this->last_status->ViewValue = NULL;
		}
		$this->last_status->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// a_operator
		$curVal = strval($this->a_operator->CurrentValue);
		if ($curVal <> "") {
			$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			if ($this->a_operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
				}
			}
		} else {
			$this->a_operator->ViewValue = NULL;
		}
		$this->a_operator->ViewCustomAttributes = "";

		// invoice
		$this->invoice->ViewValue = $this->invoice->CurrentValue;
		$this->invoice->ViewCustomAttributes = "";

		// invoice_date
		$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
		$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
		$this->invoice_date->ViewCustomAttributes = "";

		// uploads
		$this->uploads->ViewValue = $this->uploads->CurrentValue;
		$this->uploads->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// buyer_id
		$this->buyer_id->LinkCustomAttributes = "";
		$this->buyer_id->HrefValue = "";
		$this->buyer_id->TooltipValue = "";

		// hardware_id
		$this->hardware_id->LinkCustomAttributes = "";
		$this->hardware_id->HrefValue = "";
		$this->hardware_id->TooltipValue = "";

		// service_executive
		$this->service_executive->LinkCustomAttributes = "";
		$this->service_executive->HrefValue = "";
		$this->service_executive->TooltipValue = "";

		// entry_time
		$this->entry_time->LinkCustomAttributes = "";
		$this->entry_time->HrefValue = "";
		$this->entry_time->TooltipValue = "";

		// current_reading
		$this->current_reading->LinkCustomAttributes = "";
		$this->current_reading->HrefValue = "";
		$this->current_reading->TooltipValue = "";

		// error_ref
		$this->error_ref->LinkCustomAttributes = "";
		$this->error_ref->HrefValue = "";
		$this->error_ref->TooltipValue = "";

		// service_type
		$this->service_type->LinkCustomAttributes = "";
		$this->service_type->HrefValue = "";
		$this->service_type->TooltipValue = "";

		// complaint
		$this->complaint->LinkCustomAttributes = "";
		$this->complaint->HrefValue = "";
		$this->complaint->TooltipValue = "";

		// observation
		$this->observation->LinkCustomAttributes = "";
		$this->observation->HrefValue = "";
		$this->observation->TooltipValue = "";

		// product_replaced
		$this->product_replaced->LinkCustomAttributes = "";
		$this->product_replaced->HrefValue = "";
		$this->product_replaced->TooltipValue = "";

		// consumable_replaced
		$this->consumable_replaced->LinkCustomAttributes = "";
		$this->consumable_replaced->HrefValue = "";
		$this->consumable_replaced->TooltipValue = "";

		// out_time
		$this->out_time->LinkCustomAttributes = "";
		$this->out_time->HrefValue = "";
		$this->out_time->TooltipValue = "";

		// work_detail
		$this->work_detail->LinkCustomAttributes = "";
		$this->work_detail->HrefValue = "";
		$this->work_detail->TooltipValue = "";

		// future_task
		$this->future_task->LinkCustomAttributes = "";
		$this->future_task->HrefValue = "";
		$this->future_task->TooltipValue = "";

		// last_status
		$this->last_status->LinkCustomAttributes = "";
		$this->last_status->HrefValue = "";
		$this->last_status->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// a_operator
		$this->a_operator->LinkCustomAttributes = "";
		$this->a_operator->HrefValue = "";
		$this->a_operator->TooltipValue = "";

		// invoice
		$this->invoice->LinkCustomAttributes = "";
		$this->invoice->HrefValue = "";
		$this->invoice->TooltipValue = "";

		// invoice_date
		$this->invoice_date->LinkCustomAttributes = "";
		$this->invoice_date->HrefValue = "";
		$this->invoice_date->TooltipValue = "";

		// uploads
		$this->uploads->LinkCustomAttributes = "";
		$this->uploads->HrefValue = "";
		$this->uploads->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// buyer_id
		$this->buyer_id->EditAttrs["class"] = "form-control";
		$this->buyer_id->EditCustomAttributes = "";
		$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id`>1000 and `status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->EditValue = NULL;
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// hardware_id
		$this->hardware_id->EditAttrs["class"] = "form-control";
		$this->hardware_id->EditCustomAttributes = "";
		$curVal = strval($this->hardware_id->CurrentValue);
		if ($curVal <> "") {
			$this->hardware_id->EditValue = $this->hardware_id->lookupCacheOption($curVal);
			if ($this->hardware_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->hardware_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->hardware_id->EditValue = $this->hardware_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->hardware_id->EditValue = $this->hardware_id->CurrentValue;
				}
			}
		} else {
			$this->hardware_id->EditValue = NULL;
		}
		$this->hardware_id->ViewCustomAttributes = "";

		// service_executive
		$this->service_executive->EditAttrs["class"] = "form-control";
		$this->service_executive->EditCustomAttributes = "";
		$this->service_executive->EditValue = $this->service_executive->CurrentValue;
		$curVal = strval($this->service_executive->CurrentValue);
		if ($curVal <> "") {
			$this->service_executive->EditValue = $this->service_executive->lookupCacheOption($curVal);
			if ($this->service_executive->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "FIND_IN_SET('92', `category`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->service_executive->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->service_executive->EditValue = $this->service_executive->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->service_executive->EditValue = $this->service_executive->CurrentValue;
				}
			}
		} else {
			$this->service_executive->EditValue = NULL;
		}
		$this->service_executive->ViewCustomAttributes = "";

		// entry_time
		$this->entry_time->EditAttrs["class"] = "form-control";
		$this->entry_time->EditCustomAttributes = "";
		$this->entry_time->EditValue = FormatDateTime($this->entry_time->CurrentValue, 8);
		$this->entry_time->PlaceHolder = RemoveHtml($this->entry_time->caption());

		// current_reading
		$this->current_reading->EditAttrs["class"] = "form-control";
		$this->current_reading->EditCustomAttributes = "";
		$this->current_reading->EditValue = $this->current_reading->CurrentValue;
		$this->current_reading->PlaceHolder = RemoveHtml($this->current_reading->caption());

		// error_ref
		$this->error_ref->EditAttrs["class"] = "form-control";
		$this->error_ref->EditCustomAttributes = "";

		// service_type
		$this->service_type->EditAttrs["class"] = "form-control";
		$this->service_type->EditCustomAttributes = "";

		// complaint
		$this->complaint->EditAttrs["class"] = "form-control";
		$this->complaint->EditCustomAttributes = "";
		$curVal = strval($this->complaint->CurrentValue);
		if ($curVal <> "") {
			$this->complaint->EditValue = $this->complaint->lookupCacheOption($curVal);
			if ($this->complaint->EditValue === NULL) { // Lookup from database
				$filterWrk = "`item`" . SearchString("=", $curVal, DATATYPE_STRING, "");
				$lookupFilter = function() {
					return "`grp` = 21 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->complaint->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->complaint->EditValue = $this->complaint->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->complaint->EditValue = $this->complaint->CurrentValue;
				}
			}
		} else {
			$this->complaint->EditValue = NULL;
		}
		$this->complaint->ViewCustomAttributes = "";

		// observation
		$this->observation->EditAttrs["class"] = "form-control";
		$this->observation->EditCustomAttributes = "";
		$this->observation->EditValue = $this->observation->CurrentValue;
		$this->observation->PlaceHolder = RemoveHtml($this->observation->caption());

		// product_replaced
		$this->product_replaced->EditCustomAttributes = 'selected';

		// consumable_replaced
		$this->consumable_replaced->EditCustomAttributes = "";

		// out_time
		$this->out_time->EditAttrs["class"] = "form-control";
		$this->out_time->EditCustomAttributes = "";
		$this->out_time->EditValue = FormatDateTime($this->out_time->CurrentValue, 8);
		$this->out_time->PlaceHolder = RemoveHtml($this->out_time->caption());

		// work_detail
		$this->work_detail->EditAttrs["class"] = "form-control";
		$this->work_detail->EditCustomAttributes = "";
		$this->work_detail->EditValue = $this->work_detail->CurrentValue;
		$this->work_detail->PlaceHolder = RemoveHtml($this->work_detail->caption());

		// future_task
		$this->future_task->EditAttrs["class"] = "form-control";
		$this->future_task->EditCustomAttributes = "";
		$this->future_task->EditValue = $this->future_task->CurrentValue;
		$this->future_task->PlaceHolder = RemoveHtml($this->future_task->caption());

		// last_status
		$this->last_status->EditAttrs["class"] = "form-control";
		$this->last_status->EditCustomAttributes = "";

		// operator
		// datetime
		// a_operator
		// invoice

		$this->invoice->EditAttrs["class"] = "form-control";
		$this->invoice->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->invoice->CurrentValue = HtmlDecode($this->invoice->CurrentValue);
		$this->invoice->EditValue = $this->invoice->CurrentValue;
		$this->invoice->PlaceHolder = RemoveHtml($this->invoice->caption());

		// invoice_date
		$this->invoice_date->EditAttrs["class"] = "form-control";
		$this->invoice_date->EditCustomAttributes = "";
		$this->invoice_date->EditValue = FormatDateTime($this->invoice_date->CurrentValue, 8);
		$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

		// uploads
		$this->uploads->EditAttrs["class"] = "form-control";
		$this->uploads->EditCustomAttributes = "";
		$this->uploads->EditValue = $this->uploads->CurrentValue;
		$this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->hardware_id);
					$doc->exportCaption($this->service_executive);
					$doc->exportCaption($this->entry_time);
					$doc->exportCaption($this->current_reading);
					$doc->exportCaption($this->error_ref);
					$doc->exportCaption($this->service_type);
					$doc->exportCaption($this->complaint);
					$doc->exportCaption($this->observation);
					$doc->exportCaption($this->product_replaced);
					$doc->exportCaption($this->consumable_replaced);
					$doc->exportCaption($this->out_time);
					$doc->exportCaption($this->work_detail);
					$doc->exportCaption($this->future_task);
					$doc->exportCaption($this->last_status);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->invoice);
					$doc->exportCaption($this->invoice_date);
					$doc->exportCaption($this->uploads);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->hardware_id);
					$doc->exportCaption($this->service_executive);
					$doc->exportCaption($this->entry_time);
					$doc->exportCaption($this->current_reading);
					$doc->exportCaption($this->error_ref);
					$doc->exportCaption($this->service_type);
					$doc->exportCaption($this->complaint);
					$doc->exportCaption($this->observation);
					$doc->exportCaption($this->product_replaced);
					$doc->exportCaption($this->consumable_replaced);
					$doc->exportCaption($this->out_time);
					$doc->exportCaption($this->work_detail);
					$doc->exportCaption($this->last_status);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->a_operator);
					$doc->exportCaption($this->invoice);
					$doc->exportCaption($this->invoice_date);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->hardware_id);
						$doc->exportField($this->service_executive);
						$doc->exportField($this->entry_time);
						$doc->exportField($this->current_reading);
						$doc->exportField($this->error_ref);
						$doc->exportField($this->service_type);
						$doc->exportField($this->complaint);
						$doc->exportField($this->observation);
						$doc->exportField($this->product_replaced);
						$doc->exportField($this->consumable_replaced);
						$doc->exportField($this->out_time);
						$doc->exportField($this->work_detail);
						$doc->exportField($this->future_task);
						$doc->exportField($this->last_status);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->invoice);
						$doc->exportField($this->invoice_date);
						$doc->exportField($this->uploads);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->hardware_id);
						$doc->exportField($this->service_executive);
						$doc->exportField($this->entry_time);
						$doc->exportField($this->current_reading);
						$doc->exportField($this->error_ref);
						$doc->exportField($this->service_type);
						$doc->exportField($this->complaint);
						$doc->exportField($this->observation);
						$doc->exportField($this->product_replaced);
						$doc->exportField($this->consumable_replaced);
						$doc->exportField($this->out_time);
						$doc->exportField($this->work_detail);
						$doc->exportField($this->last_status);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->a_operator);
						$doc->exportField($this->invoice);
						$doc->exportField($this->invoice_date);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>