<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class service_report_add extends service_report
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'service_report';

	// Page object name
	public $PageObjName = "service_report_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (service_report)
		if (!isset($GLOBALS["service_report"]) || get_class($GLOBALS["service_report"]) == PROJECT_NAMESPACE . "service_report") {
			$GLOBALS["service_report"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["service_report"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'service_report');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $service_report;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($service_report);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "service_reportview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("service_reportlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->buyer_id->setVisibility();
		$this->hardware_id->setVisibility();
		$this->service_executive->setVisibility();
		$this->entry_time->Visible = FALSE;
		$this->current_reading->setVisibility();
		$this->error_ref->setVisibility();
		$this->service_type->setVisibility();
		$this->complaint->setVisibility();
		$this->observation->setVisibility();
		$this->product_replaced->setVisibility();
		$this->consumable_replaced->setVisibility();
		$this->out_time->setVisibility();
		$this->work_detail->setVisibility();
		$this->future_task->setVisibility();
		$this->last_status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->Visible = FALSE;
		$this->invoice->setVisibility();
		$this->invoice_date->setVisibility();
		$this->uploads->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->hardware_id);
		$this->setupLookupOptions($this->service_executive);
		$this->setupLookupOptions($this->error_ref);
		$this->setupLookupOptions($this->service_type);
		$this->setupLookupOptions($this->complaint);
		$this->setupLookupOptions($this->product_replaced);
		$this->setupLookupOptions($this->consumable_replaced);
		$this->setupLookupOptions($this->last_status);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("service_reportlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "service_reportlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "service_reportview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->buyer_id->CurrentValue = (isset($_COOKIE["CID"]))? $_COOKIE["CID"]:'';
		$this->hardware_id->CurrentValue = (isset($_COOKIE["HI"]))? $_COOKIE["HI"]:'';
		$this->service_executive->CurrentValue = (isset($_COOKIE["SE"]))? $_COOKIE["SE"]:'';
		$this->entry_time->CurrentValue = (isset($_COOKIE["ET"]))? $_COOKIE["ET"]:'';
		$this->current_reading->CurrentValue = (isset($_COOKIE["CR"]))? $_COOKIE["CR"]:'';
		$this->error_ref->CurrentValue = (isset($_COOKIE["ER"]))? $_COOKIE["ER"]:'';
		$this->service_type->CurrentValue = (isset($_COOKIE["ST"]))? $_COOKIE["ST"]:'';
		$this->complaint->CurrentValue = (isset($_COOKIE["CO"]))? $_COOKIE["CO"]:'';
		$this->observation->CurrentValue = (isset($_COOKIE["OB"]))? $_COOKIE["OB"]:'';
		$this->product_replaced->CurrentValue = (isset($_COOKIE["PRE"]))? $_COOKIE["PRE"]:'';
		$this->consumable_replaced->CurrentValue = (isset($_COOKIE["CRE"]))? $_COOKIE["CRE"]:'';
		$this->out_time->CurrentValue = (isset($_COOKIE["OT"]))? $_COOKIE["OT"]:'';
		$this->work_detail->CurrentValue = (isset($_COOKIE["WD"]))? $_COOKIE["WD"]:'';
		$this->future_task->CurrentValue = (isset($_COOKIE["FT"]))? $_COOKIE["FT"]:'';
		$this->last_status->CurrentValue = 4104;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->a_operator->CurrentValue = NULL;
		$this->a_operator->OldValue = $this->a_operator->CurrentValue;
		$this->invoice->CurrentValue = NULL;
		$this->invoice->OldValue = $this->invoice->CurrentValue;
		$this->invoice_date->CurrentValue = NULL;
		$this->invoice_date->OldValue = $this->invoice_date->CurrentValue;
		$this->uploads->CurrentValue = NULL;
		$this->uploads->OldValue = $this->uploads->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'buyer_id' first before field var 'x_buyer_id'
		$val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
		if (!$this->buyer_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_id->setFormValue($val);
		}

		// Check field name 'hardware_id' first before field var 'x_hardware_id'
		$val = $CurrentForm->hasValue("hardware_id") ? $CurrentForm->getValue("hardware_id") : $CurrentForm->getValue("x_hardware_id");
		if (!$this->hardware_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->hardware_id->Visible = FALSE; // Disable update for API request
			else
				$this->hardware_id->setFormValue($val);
		}

		// Check field name 'service_executive' first before field var 'x_service_executive'
		$val = $CurrentForm->hasValue("service_executive") ? $CurrentForm->getValue("service_executive") : $CurrentForm->getValue("x_service_executive");
		if (!$this->service_executive->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->service_executive->Visible = FALSE; // Disable update for API request
			else
				$this->service_executive->setFormValue($val);
		}

		// Check field name 'current_reading' first before field var 'x_current_reading'
		$val = $CurrentForm->hasValue("current_reading") ? $CurrentForm->getValue("current_reading") : $CurrentForm->getValue("x_current_reading");
		if (!$this->current_reading->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->current_reading->Visible = FALSE; // Disable update for API request
			else
				$this->current_reading->setFormValue($val);
		}

		// Check field name 'error_ref' first before field var 'x_error_ref'
		$val = $CurrentForm->hasValue("error_ref") ? $CurrentForm->getValue("error_ref") : $CurrentForm->getValue("x_error_ref");
		if (!$this->error_ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->error_ref->Visible = FALSE; // Disable update for API request
			else
				$this->error_ref->setFormValue($val);
		}

		// Check field name 'service_type' first before field var 'x_service_type'
		$val = $CurrentForm->hasValue("service_type") ? $CurrentForm->getValue("service_type") : $CurrentForm->getValue("x_service_type");
		if (!$this->service_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->service_type->Visible = FALSE; // Disable update for API request
			else
				$this->service_type->setFormValue($val);
		}

		// Check field name 'complaint' first before field var 'x_complaint'
		$val = $CurrentForm->hasValue("complaint") ? $CurrentForm->getValue("complaint") : $CurrentForm->getValue("x_complaint");
		if (!$this->complaint->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->complaint->Visible = FALSE; // Disable update for API request
			else
				$this->complaint->setFormValue($val);
		}

		// Check field name 'observation' first before field var 'x_observation'
		$val = $CurrentForm->hasValue("observation") ? $CurrentForm->getValue("observation") : $CurrentForm->getValue("x_observation");
		if (!$this->observation->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->observation->Visible = FALSE; // Disable update for API request
			else
				$this->observation->setFormValue($val);
		}

		// Check field name 'product_replaced' first before field var 'x_product_replaced'
		$val = $CurrentForm->hasValue("product_replaced") ? $CurrentForm->getValue("product_replaced") : $CurrentForm->getValue("x_product_replaced");
		if (!$this->product_replaced->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_replaced->Visible = FALSE; // Disable update for API request
			else
				$this->product_replaced->setFormValue($val);
		}

		// Check field name 'consumable_replaced' first before field var 'x_consumable_replaced'
		$val = $CurrentForm->hasValue("consumable_replaced") ? $CurrentForm->getValue("consumable_replaced") : $CurrentForm->getValue("x_consumable_replaced");
		if (!$this->consumable_replaced->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->consumable_replaced->Visible = FALSE; // Disable update for API request
			else
				$this->consumable_replaced->setFormValue($val);
		}

		// Check field name 'out_time' first before field var 'x_out_time'
		$val = $CurrentForm->hasValue("out_time") ? $CurrentForm->getValue("out_time") : $CurrentForm->getValue("x_out_time");
		if (!$this->out_time->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->out_time->Visible = FALSE; // Disable update for API request
			else
				$this->out_time->setFormValue($val);
			$this->out_time->CurrentValue = UnFormatDateTime($this->out_time->CurrentValue, 0);
		}

		// Check field name 'work_detail' first before field var 'x_work_detail'
		$val = $CurrentForm->hasValue("work_detail") ? $CurrentForm->getValue("work_detail") : $CurrentForm->getValue("x_work_detail");
		if (!$this->work_detail->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->work_detail->Visible = FALSE; // Disable update for API request
			else
				$this->work_detail->setFormValue($val);
		}

		// Check field name 'future_task' first before field var 'x_future_task'
		$val = $CurrentForm->hasValue("future_task") ? $CurrentForm->getValue("future_task") : $CurrentForm->getValue("x_future_task");
		if (!$this->future_task->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->future_task->Visible = FALSE; // Disable update for API request
			else
				$this->future_task->setFormValue($val);
		}

		// Check field name 'last_status' first before field var 'x_last_status'
		$val = $CurrentForm->hasValue("last_status") ? $CurrentForm->getValue("last_status") : $CurrentForm->getValue("x_last_status");
		if (!$this->last_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->last_status->Visible = FALSE; // Disable update for API request
			else
				$this->last_status->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'invoice' first before field var 'x_invoice'
		$val = $CurrentForm->hasValue("invoice") ? $CurrentForm->getValue("invoice") : $CurrentForm->getValue("x_invoice");
		if (!$this->invoice->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->invoice->Visible = FALSE; // Disable update for API request
			else
				$this->invoice->setFormValue($val);
		}

		// Check field name 'invoice_date' first before field var 'x_invoice_date'
		$val = $CurrentForm->hasValue("invoice_date") ? $CurrentForm->getValue("invoice_date") : $CurrentForm->getValue("x_invoice_date");
		if (!$this->invoice_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->invoice_date->Visible = FALSE; // Disable update for API request
			else
				$this->invoice_date->setFormValue($val);
			$this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, 0);
		}

		// Check field name 'uploads' first before field var 'x_uploads'
		$val = $CurrentForm->hasValue("uploads") ? $CurrentForm->getValue("uploads") : $CurrentForm->getValue("x_uploads");
		if (!$this->uploads->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->uploads->Visible = FALSE; // Disable update for API request
			else
				$this->uploads->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
		$this->hardware_id->CurrentValue = $this->hardware_id->FormValue;
		$this->service_executive->CurrentValue = $this->service_executive->FormValue;
		$this->current_reading->CurrentValue = $this->current_reading->FormValue;
		$this->error_ref->CurrentValue = $this->error_ref->FormValue;
		$this->service_type->CurrentValue = $this->service_type->FormValue;
		$this->complaint->CurrentValue = $this->complaint->FormValue;
		$this->observation->CurrentValue = $this->observation->FormValue;
		$this->product_replaced->CurrentValue = $this->product_replaced->FormValue;
		$this->consumable_replaced->CurrentValue = $this->consumable_replaced->FormValue;
		$this->out_time->CurrentValue = $this->out_time->FormValue;
		$this->out_time->CurrentValue = UnFormatDateTime($this->out_time->CurrentValue, 0);
		$this->work_detail->CurrentValue = $this->work_detail->FormValue;
		$this->future_task->CurrentValue = $this->future_task->FormValue;
		$this->last_status->CurrentValue = $this->last_status->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->invoice->CurrentValue = $this->invoice->FormValue;
		$this->invoice_date->CurrentValue = $this->invoice_date->FormValue;
		$this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, 0);
		$this->uploads->CurrentValue = $this->uploads->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		$this->hardware_id->setDbValue($row['hardware_id']);
		$this->service_executive->setDbValue($row['service_executive']);
		$this->entry_time->setDbValue($row['entry_time']);
		$this->current_reading->setDbValue($row['current_reading']);
		$this->error_ref->setDbValue($row['error_ref']);
		$this->service_type->setDbValue($row['service_type']);
		$this->complaint->setDbValue($row['complaint']);
		$this->observation->setDbValue($row['observation']);
		$this->product_replaced->setDbValue($row['product_replaced']);
		$this->consumable_replaced->setDbValue($row['consumable_replaced']);
		$this->out_time->setDbValue($row['out_time']);
		$this->work_detail->setDbValue($row['work_detail']);
		$this->future_task->setDbValue($row['future_task']);
		$this->last_status->setDbValue($row['last_status']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->a_operator->setDbValue($row['a_operator']);
		$this->invoice->setDbValue($row['invoice']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->uploads->setDbValue($row['uploads']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['buyer_id'] = $this->buyer_id->CurrentValue;
		$row['hardware_id'] = $this->hardware_id->CurrentValue;
		$row['service_executive'] = $this->service_executive->CurrentValue;
		$row['entry_time'] = $this->entry_time->CurrentValue;
		$row['current_reading'] = $this->current_reading->CurrentValue;
		$row['error_ref'] = $this->error_ref->CurrentValue;
		$row['service_type'] = $this->service_type->CurrentValue;
		$row['complaint'] = $this->complaint->CurrentValue;
		$row['observation'] = $this->observation->CurrentValue;
		$row['product_replaced'] = $this->product_replaced->CurrentValue;
		$row['consumable_replaced'] = $this->consumable_replaced->CurrentValue;
		$row['out_time'] = $this->out_time->CurrentValue;
		$row['work_detail'] = $this->work_detail->CurrentValue;
		$row['future_task'] = $this->future_task->CurrentValue;
		$row['last_status'] = $this->last_status->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['a_operator'] = $this->a_operator->CurrentValue;
		$row['invoice'] = $this->invoice->CurrentValue;
		$row['invoice_date'] = $this->invoice_date->CurrentValue;
		$row['uploads'] = $this->uploads->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// buyer_id
		// hardware_id
		// service_executive
		// entry_time
		// current_reading
		// error_ref
		// service_type
		// complaint
		// observation
		// product_replaced
		// consumable_replaced
		// out_time
		// work_detail
		// future_task
		// last_status
		// operator
		// datetime
		// a_operator
		// invoice
		// invoice_date
		// uploads

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// buyer_id
			$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>1000 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// hardware_id
			$curVal = strval($this->hardware_id->CurrentValue);
			if ($curVal <> "") {
				$this->hardware_id->ViewValue = $this->hardware_id->lookupCacheOption($curVal);
				if ($this->hardware_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->hardware_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->hardware_id->ViewValue = $this->hardware_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->hardware_id->ViewValue = $this->hardware_id->CurrentValue;
					}
				}
			} else {
				$this->hardware_id->ViewValue = NULL;
			}
			$this->hardware_id->ViewCustomAttributes = "";

			// service_executive
			$this->service_executive->ViewValue = $this->service_executive->CurrentValue;
			$curVal = strval($this->service_executive->CurrentValue);
			if ($curVal <> "") {
				$this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
				if ($this->service_executive->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->service_executive->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->service_executive->ViewValue = $this->service_executive->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->service_executive->ViewValue = $this->service_executive->CurrentValue;
					}
				}
			} else {
				$this->service_executive->ViewValue = NULL;
			}
			$this->service_executive->ViewCustomAttributes = "";

			// entry_time
			$this->entry_time->ViewValue = $this->entry_time->CurrentValue;
			$this->entry_time->ViewValue = FormatDateTime($this->entry_time->ViewValue, 0);
			$this->entry_time->ViewCustomAttributes = "";

			// current_reading
			$this->current_reading->ViewValue = $this->current_reading->CurrentValue;
			$this->current_reading->ViewValue = FormatNumber($this->current_reading->ViewValue, 0, -2, -2, -2);
			$this->current_reading->ViewCustomAttributes = "";

			// error_ref
			$curVal = strval($this->error_ref->CurrentValue);
			if ($curVal <> "") {
				$this->error_ref->ViewValue = $this->error_ref->lookupCacheOption($curVal);
				if ($this->error_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` !=9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->error_ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatDateTime($rswrk->fields('df'), 0);
						$arwrk[2] = $rswrk->fields('df2');
						$this->error_ref->ViewValue = $this->error_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->error_ref->ViewValue = $this->error_ref->CurrentValue;
					}
				}
			} else {
				$this->error_ref->ViewValue = NULL;
			}
			$this->error_ref->ViewCustomAttributes = "";

			// service_type
			$curVal = strval($this->service_type->CurrentValue);
			if ($curVal <> "") {
				$this->service_type->ViewValue = $this->service_type->lookupCacheOption($curVal);
				if ($this->service_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=11  and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->service_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->service_type->ViewValue = $this->service_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->service_type->ViewValue = $this->service_type->CurrentValue;
					}
				}
			} else {
				$this->service_type->ViewValue = NULL;
			}
			$this->service_type->ViewCustomAttributes = "";

			// complaint
			$curVal = strval($this->complaint->CurrentValue);
			if ($curVal <> "") {
				$this->complaint->ViewValue = $this->complaint->lookupCacheOption($curVal);
				if ($this->complaint->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`item`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`grp` = 21 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->complaint->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->complaint->ViewValue = $this->complaint->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->complaint->ViewValue = $this->complaint->CurrentValue;
					}
				}
			} else {
				$this->complaint->ViewValue = NULL;
			}
			$this->complaint->ViewCustomAttributes = "";

			// observation
			$this->observation->ViewValue = $this->observation->CurrentValue;
			$this->observation->ViewCustomAttributes = "";

			// product_replaced
			$curVal = strval($this->product_replaced->CurrentValue);
			if ($curVal <> "") {
				$this->product_replaced->ViewValue = $this->product_replaced->lookupCacheOption($curVal);
				if ($this->product_replaced->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '3,4,8,10') and FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_replaced->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->product_replaced->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -1, -1, -1);
							$this->product_replaced->ViewValue->add($this->product_replaced->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->product_replaced->ViewValue = $this->product_replaced->CurrentValue;
					}
				}
			} else {
				$this->product_replaced->ViewValue = NULL;
			}
			$this->product_replaced->ViewCustomAttributes = "";

			// consumable_replaced
			$curVal = strval($this->consumable_replaced->CurrentValue);
			if ($curVal <> "") {
				$this->consumable_replaced->ViewValue = $this->consumable_replaced->lookupCacheOption($curVal);
				if ($this->consumable_replaced->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '5,6,7,9') and FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consumable_replaced->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->consumable_replaced->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -1, -1, -1);
							$this->consumable_replaced->ViewValue->add($this->consumable_replaced->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->consumable_replaced->ViewValue = $this->consumable_replaced->CurrentValue;
					}
				}
			} else {
				$this->consumable_replaced->ViewValue = NULL;
			}
			$this->consumable_replaced->ViewCustomAttributes = "";

			// out_time
			$this->out_time->ViewValue = $this->out_time->CurrentValue;
			$this->out_time->ViewValue = FormatDateTime($this->out_time->ViewValue, 0);
			$this->out_time->ViewCustomAttributes = "";

			// work_detail
			$this->work_detail->ViewValue = $this->work_detail->CurrentValue;
			$this->work_detail->ViewCustomAttributes = "";

			// future_task
			$this->future_task->ViewValue = $this->future_task->CurrentValue;
			$this->future_task->ViewCustomAttributes = "";

			// last_status
			$curVal = strval($this->last_status->CurrentValue);
			if ($curVal <> "") {
				$this->last_status->ViewValue = $this->last_status->lookupCacheOption($curVal);
				if ($this->last_status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 41 and `status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->last_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->last_status->ViewValue = $this->last_status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->last_status->ViewValue = $this->last_status->CurrentValue;
					}
				}
			} else {
				$this->last_status->ViewValue = NULL;
			}
			$this->last_status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// invoice
			$this->invoice->ViewValue = $this->invoice->CurrentValue;
			$this->invoice->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// uploads
			$this->uploads->ViewValue = $this->uploads->CurrentValue;
			$this->uploads->ViewCustomAttributes = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// hardware_id
			$this->hardware_id->LinkCustomAttributes = "";
			$this->hardware_id->HrefValue = "";
			$this->hardware_id->TooltipValue = "";

			// service_executive
			$this->service_executive->LinkCustomAttributes = "";
			$this->service_executive->HrefValue = "";
			$this->service_executive->TooltipValue = "";

			// current_reading
			$this->current_reading->LinkCustomAttributes = "";
			$this->current_reading->HrefValue = "";
			$this->current_reading->TooltipValue = "";

			// error_ref
			$this->error_ref->LinkCustomAttributes = "";
			$this->error_ref->HrefValue = "";
			$this->error_ref->TooltipValue = "";

			// service_type
			$this->service_type->LinkCustomAttributes = "";
			$this->service_type->HrefValue = "";
			$this->service_type->TooltipValue = "";

			// complaint
			$this->complaint->LinkCustomAttributes = "";
			$this->complaint->HrefValue = "";
			$this->complaint->TooltipValue = "";

			// observation
			$this->observation->LinkCustomAttributes = "";
			$this->observation->HrefValue = "";
			$this->observation->TooltipValue = "";

			// product_replaced
			$this->product_replaced->LinkCustomAttributes = "";
			$this->product_replaced->HrefValue = "";
			$this->product_replaced->TooltipValue = "";

			// consumable_replaced
			$this->consumable_replaced->LinkCustomAttributes = "";
			$this->consumable_replaced->HrefValue = "";
			$this->consumable_replaced->TooltipValue = "";

			// out_time
			$this->out_time->LinkCustomAttributes = "";
			$this->out_time->HrefValue = "";
			$this->out_time->TooltipValue = "";

			// work_detail
			$this->work_detail->LinkCustomAttributes = "";
			$this->work_detail->HrefValue = "";
			$this->work_detail->TooltipValue = "";

			// future_task
			$this->future_task->LinkCustomAttributes = "";
			$this->future_task->HrefValue = "";
			$this->future_task->TooltipValue = "";

			// last_status
			$this->last_status->LinkCustomAttributes = "";
			$this->last_status->HrefValue = "";
			$this->last_status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// invoice
			$this->invoice->LinkCustomAttributes = "";
			$this->invoice->HrefValue = "";
			$this->invoice->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->HrefValue = "";
			$this->uploads->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$this->buyer_id->EditValue = HtmlEncode($this->buyer_id->CurrentValue);
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>1000 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$arwrk[4] = HtmlEncode($rswrk->fields('df4'));
						$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->EditValue = HtmlEncode($this->buyer_id->CurrentValue);
					}
				}
			} else {
				$this->buyer_id->EditValue = NULL;
			}
			$this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

			// hardware_id
			$this->hardware_id->EditAttrs["class"] = "form-control";
			$this->hardware_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->hardware_id->CurrentValue));
			if ($curVal <> "")
				$this->hardware_id->ViewValue = $this->hardware_id->lookupCacheOption($curVal);
			else
				$this->hardware_id->ViewValue = $this->hardware_id->Lookup !== NULL && is_array($this->hardware_id->Lookup->Options) ? $curVal : NULL;
			if ($this->hardware_id->ViewValue !== NULL) { // Load from cache
				$this->hardware_id->EditValue = array_values($this->hardware_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->hardware_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->hardware_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->hardware_id->EditValue = $arwrk;
			}

			// service_executive
			$this->service_executive->EditAttrs["class"] = "form-control";
			$this->service_executive->EditCustomAttributes = "";
			$this->service_executive->EditValue = HtmlEncode($this->service_executive->CurrentValue);
			$curVal = strval($this->service_executive->CurrentValue);
			if ($curVal <> "") {
				$this->service_executive->EditValue = $this->service_executive->lookupCacheOption($curVal);
				if ($this->service_executive->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->service_executive->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->service_executive->EditValue = $this->service_executive->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->service_executive->EditValue = HtmlEncode($this->service_executive->CurrentValue);
					}
				}
			} else {
				$this->service_executive->EditValue = NULL;
			}
			$this->service_executive->PlaceHolder = RemoveHtml($this->service_executive->caption());

			// current_reading
			$this->current_reading->EditAttrs["class"] = "form-control";
			$this->current_reading->EditCustomAttributes = "";
			$this->current_reading->EditValue = HtmlEncode($this->current_reading->CurrentValue);
			$this->current_reading->PlaceHolder = RemoveHtml($this->current_reading->caption());

			// error_ref
			$this->error_ref->EditAttrs["class"] = "form-control";
			$this->error_ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->error_ref->CurrentValue));
			if ($curVal <> "")
				$this->error_ref->ViewValue = $this->error_ref->lookupCacheOption($curVal);
			else
				$this->error_ref->ViewValue = $this->error_ref->Lookup !== NULL && is_array($this->error_ref->Lookup->Options) ? $curVal : NULL;
			if ($this->error_ref->ViewValue !== NULL) { // Load from cache
				$this->error_ref->EditValue = array_values($this->error_ref->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->error_ref->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` !=9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->error_ref->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatDateTime($arwrk[$i][1], 0);
				}
				$this->error_ref->EditValue = $arwrk;
			}

			// service_type
			$this->service_type->EditAttrs["class"] = "form-control";
			$this->service_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->service_type->CurrentValue));
			if ($curVal <> "")
				$this->service_type->ViewValue = $this->service_type->lookupCacheOption($curVal);
			else
				$this->service_type->ViewValue = $this->service_type->Lookup !== NULL && is_array($this->service_type->Lookup->Options) ? $curVal : NULL;
			if ($this->service_type->ViewValue !== NULL) { // Load from cache
				$this->service_type->EditValue = array_values($this->service_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->service_type->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=11  and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->service_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->service_type->EditValue = $arwrk;
			}

			// complaint
			$this->complaint->EditAttrs["class"] = "form-control";
			$this->complaint->EditCustomAttributes = "";
			$curVal = trim(strval($this->complaint->CurrentValue));
			if ($curVal <> "")
				$this->complaint->ViewValue = $this->complaint->lookupCacheOption($curVal);
			else
				$this->complaint->ViewValue = $this->complaint->Lookup !== NULL && is_array($this->complaint->Lookup->Options) ? $curVal : NULL;
			if ($this->complaint->ViewValue !== NULL) { // Load from cache
				$this->complaint->EditValue = array_values($this->complaint->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`item`" . SearchString("=", $this->complaint->CurrentValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`grp` = 21 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->complaint->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->complaint->EditValue = $arwrk;
			}

			// observation
			$this->observation->EditAttrs["class"] = "form-control";
			$this->observation->EditCustomAttributes = "";
			$this->observation->EditValue = HtmlEncode($this->observation->CurrentValue);
			$this->observation->PlaceHolder = RemoveHtml($this->observation->caption());

			// product_replaced
			$this->product_replaced->EditCustomAttributes = 'selected';
			$curVal = trim(strval($this->product_replaced->CurrentValue));
			if ($curVal <> "")
				$this->product_replaced->ViewValue = $this->product_replaced->lookupCacheOption($curVal);
			else
				$this->product_replaced->ViewValue = $this->product_replaced->Lookup !== NULL && is_array($this->product_replaced->Lookup->Options) ? $curVal : NULL;
			if ($this->product_replaced->ViewValue !== NULL) { // Load from cache
				$this->product_replaced->EditValue = array_values($this->product_replaced->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '3,4,8,10') and FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')"));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_replaced->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 0, -1, -1, -1);
				}
				$this->product_replaced->EditValue = $arwrk;
			}

			// consumable_replaced
			$this->consumable_replaced->EditCustomAttributes = "";
			$curVal = trim(strval($this->consumable_replaced->CurrentValue));
			if ($curVal <> "")
				$this->consumable_replaced->ViewValue = $this->consumable_replaced->lookupCacheOption($curVal);
			else
				$this->consumable_replaced->ViewValue = $this->consumable_replaced->Lookup !== NULL && is_array($this->consumable_replaced->Lookup->Options) ? $curVal : NULL;
			if ($this->consumable_replaced->ViewValue !== NULL) { // Load from cache
				$this->consumable_replaced->EditValue = array_values($this->consumable_replaced->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '5,6,7,9') and FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')"));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->consumable_replaced->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 0, -1, -1, -1);
				}
				$this->consumable_replaced->EditValue = $arwrk;
			}

			// out_time
			$this->out_time->EditAttrs["class"] = "form-control";
			$this->out_time->EditCustomAttributes = "";
			$this->out_time->EditValue = HtmlEncode(FormatDateTime($this->out_time->CurrentValue, 8));
			$this->out_time->PlaceHolder = RemoveHtml($this->out_time->caption());

			// work_detail
			$this->work_detail->EditAttrs["class"] = "form-control";
			$this->work_detail->EditCustomAttributes = "";
			$this->work_detail->EditValue = HtmlEncode($this->work_detail->CurrentValue);
			$this->work_detail->PlaceHolder = RemoveHtml($this->work_detail->caption());

			// future_task
			$this->future_task->EditAttrs["class"] = "form-control";
			$this->future_task->EditCustomAttributes = "";
			$this->future_task->EditValue = HtmlEncode($this->future_task->CurrentValue);
			$this->future_task->PlaceHolder = RemoveHtml($this->future_task->caption());

			// last_status
			$this->last_status->EditAttrs["class"] = "form-control";
			$this->last_status->EditCustomAttributes = "";
			$curVal = trim(strval($this->last_status->CurrentValue));
			if ($curVal <> "")
				$this->last_status->ViewValue = $this->last_status->lookupCacheOption($curVal);
			else
				$this->last_status->ViewValue = $this->last_status->Lookup !== NULL && is_array($this->last_status->Lookup->Options) ? $curVal : NULL;
			if ($this->last_status->ViewValue !== NULL) { // Load from cache
				$this->last_status->EditValue = array_values($this->last_status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->last_status->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 41 and `status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->last_status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->last_status->EditValue = $arwrk;
			}

			// operator
			// datetime
			// invoice

			$this->invoice->EditAttrs["class"] = "form-control";
			$this->invoice->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->invoice->CurrentValue = HtmlDecode($this->invoice->CurrentValue);
			$this->invoice->EditValue = HtmlEncode($this->invoice->CurrentValue);
			$this->invoice->PlaceHolder = RemoveHtml($this->invoice->caption());

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = HtmlEncode(FormatDateTime($this->invoice_date->CurrentValue, 8));
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->EditValue = HtmlEncode($this->uploads->CurrentValue);
			$this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

			// Add refer script
			// buyer_id

			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";

			// hardware_id
			$this->hardware_id->LinkCustomAttributes = "";
			$this->hardware_id->HrefValue = "";

			// service_executive
			$this->service_executive->LinkCustomAttributes = "";
			$this->service_executive->HrefValue = "";

			// current_reading
			$this->current_reading->LinkCustomAttributes = "";
			$this->current_reading->HrefValue = "";

			// error_ref
			$this->error_ref->LinkCustomAttributes = "";
			$this->error_ref->HrefValue = "";

			// service_type
			$this->service_type->LinkCustomAttributes = "";
			$this->service_type->HrefValue = "";

			// complaint
			$this->complaint->LinkCustomAttributes = "";
			$this->complaint->HrefValue = "";

			// observation
			$this->observation->LinkCustomAttributes = "";
			$this->observation->HrefValue = "";

			// product_replaced
			$this->product_replaced->LinkCustomAttributes = "";
			$this->product_replaced->HrefValue = "";

			// consumable_replaced
			$this->consumable_replaced->LinkCustomAttributes = "";
			$this->consumable_replaced->HrefValue = "";

			// out_time
			$this->out_time->LinkCustomAttributes = "";
			$this->out_time->HrefValue = "";

			// work_detail
			$this->work_detail->LinkCustomAttributes = "";
			$this->work_detail->HrefValue = "";

			// future_task
			$this->future_task->LinkCustomAttributes = "";
			$this->future_task->HrefValue = "";

			// last_status
			$this->last_status->LinkCustomAttributes = "";
			$this->last_status->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// invoice
			$this->invoice->LinkCustomAttributes = "";
			$this->invoice->HrefValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->buyer_id->Required) {
			if (!$this->buyer_id->IsDetailKey && $this->buyer_id->FormValue != NULL && $this->buyer_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->buyer_id->FormValue)) {
			AddMessage($FormError, $this->buyer_id->errorMessage());
		}
		if ($this->hardware_id->Required) {
			if (!$this->hardware_id->IsDetailKey && $this->hardware_id->FormValue != NULL && $this->hardware_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->hardware_id->caption(), $this->hardware_id->RequiredErrorMessage));
			}
		}
		if ($this->service_executive->Required) {
			if (!$this->service_executive->IsDetailKey && $this->service_executive->FormValue != NULL && $this->service_executive->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->service_executive->caption(), $this->service_executive->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->service_executive->FormValue)) {
			AddMessage($FormError, $this->service_executive->errorMessage());
		}
		if ($this->entry_time->Required) {
			if (!$this->entry_time->IsDetailKey && $this->entry_time->FormValue != NULL && $this->entry_time->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->entry_time->caption(), $this->entry_time->RequiredErrorMessage));
			}
		}
		if ($this->current_reading->Required) {
			if (!$this->current_reading->IsDetailKey && $this->current_reading->FormValue != NULL && $this->current_reading->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->current_reading->caption(), $this->current_reading->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->current_reading->FormValue)) {
			AddMessage($FormError, $this->current_reading->errorMessage());
		}
		if ($this->error_ref->Required) {
			if (!$this->error_ref->IsDetailKey && $this->error_ref->FormValue != NULL && $this->error_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->error_ref->caption(), $this->error_ref->RequiredErrorMessage));
			}
		}
		if ($this->service_type->Required) {
			if (!$this->service_type->IsDetailKey && $this->service_type->FormValue != NULL && $this->service_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->service_type->caption(), $this->service_type->RequiredErrorMessage));
			}
		}
		if ($this->complaint->Required) {
			if (!$this->complaint->IsDetailKey && $this->complaint->FormValue != NULL && $this->complaint->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->complaint->caption(), $this->complaint->RequiredErrorMessage));
			}
		}
		if ($this->observation->Required) {
			if (!$this->observation->IsDetailKey && $this->observation->FormValue != NULL && $this->observation->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->observation->caption(), $this->observation->RequiredErrorMessage));
			}
		}
		if ($this->product_replaced->Required) {
			if ($this->product_replaced->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_replaced->caption(), $this->product_replaced->RequiredErrorMessage));
			}
		}
		if ($this->consumable_replaced->Required) {
			if ($this->consumable_replaced->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->consumable_replaced->caption(), $this->consumable_replaced->RequiredErrorMessage));
			}
		}
		if ($this->out_time->Required) {
			if (!$this->out_time->IsDetailKey && $this->out_time->FormValue != NULL && $this->out_time->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->out_time->caption(), $this->out_time->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->out_time->FormValue)) {
			AddMessage($FormError, $this->out_time->errorMessage());
		}
		if ($this->work_detail->Required) {
			if (!$this->work_detail->IsDetailKey && $this->work_detail->FormValue != NULL && $this->work_detail->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->work_detail->caption(), $this->work_detail->RequiredErrorMessage));
			}
		}
		if ($this->future_task->Required) {
			if (!$this->future_task->IsDetailKey && $this->future_task->FormValue != NULL && $this->future_task->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->future_task->caption(), $this->future_task->RequiredErrorMessage));
			}
		}
		if ($this->last_status->Required) {
			if (!$this->last_status->IsDetailKey && $this->last_status->FormValue != NULL && $this->last_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->last_status->caption(), $this->last_status->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->a_operator->Required) {
			if (!$this->a_operator->IsDetailKey && $this->a_operator->FormValue != NULL && $this->a_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->a_operator->caption(), $this->a_operator->RequiredErrorMessage));
			}
		}
		if ($this->invoice->Required) {
			if (!$this->invoice->IsDetailKey && $this->invoice->FormValue != NULL && $this->invoice->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice->caption(), $this->invoice->RequiredErrorMessage));
			}
		}
		if ($this->invoice_date->Required) {
			if (!$this->invoice_date->IsDetailKey && $this->invoice_date->FormValue != NULL && $this->invoice_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_date->caption(), $this->invoice_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->invoice_date->FormValue)) {
			AddMessage($FormError, $this->invoice_date->errorMessage());
		}
		if ($this->uploads->Required) {
			if (!$this->uploads->IsDetailKey && $this->uploads->FormValue != NULL && $this->uploads->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// buyer_id
		$this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, 0, FALSE);

		// hardware_id
		$this->hardware_id->setDbValueDef($rsnew, $this->hardware_id->CurrentValue, NULL, FALSE);

		// service_executive
		$this->service_executive->setDbValueDef($rsnew, $this->service_executive->CurrentValue, NULL, FALSE);

		// current_reading
		$this->current_reading->setDbValueDef($rsnew, $this->current_reading->CurrentValue, 0, strval($this->current_reading->CurrentValue) == "");

		// error_ref
		$this->error_ref->setDbValueDef($rsnew, $this->error_ref->CurrentValue, NULL, FALSE);

		// service_type
		$this->service_type->setDbValueDef($rsnew, $this->service_type->CurrentValue, NULL, FALSE);

		// complaint
		$this->complaint->setDbValueDef($rsnew, $this->complaint->CurrentValue, NULL, FALSE);

		// observation
		$this->observation->setDbValueDef($rsnew, $this->observation->CurrentValue, NULL, FALSE);

		// product_replaced
		$this->product_replaced->setDbValueDef($rsnew, $this->product_replaced->CurrentValue, NULL, FALSE);

		// consumable_replaced
		$this->consumable_replaced->setDbValueDef($rsnew, $this->consumable_replaced->CurrentValue, NULL, FALSE);

		// out_time
		$this->out_time->setDbValueDef($rsnew, UnFormatDateTime($this->out_time->CurrentValue, 0), NULL, FALSE);

		// work_detail
		$this->work_detail->setDbValueDef($rsnew, $this->work_detail->CurrentValue, NULL, FALSE);

		// future_task
		$this->future_task->setDbValueDef($rsnew, $this->future_task->CurrentValue, NULL, FALSE);

		// last_status
		$this->last_status->setDbValueDef($rsnew, $this->last_status->CurrentValue, NULL, strval($this->last_status->CurrentValue) == "");

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// invoice
		$this->invoice->setDbValueDef($rsnew, $this->invoice->CurrentValue, NULL, FALSE);

		// invoice_date
		$this->invoice_date->setDbValueDef($rsnew, UnFormatDateTime($this->invoice_date->CurrentValue, 0), NULL, FALSE);

		// uploads
		$this->uploads->setDbValueDef($rsnew, $this->uploads->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("service_reportlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`id`>1000 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_service_executive":
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_error_ref":
					$lookupFilter = function() {
						return "`status` !=9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_service_type":
					$lookupFilter = function() {
						return "`grp`=11  and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_complaint":
					$lookupFilter = function() {
						return "`grp` = 21 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_replaced":
					$lookupFilter = function() {
						return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '3,4,8,10') and FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consumable_replaced":
					$lookupFilter = function() {
						return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '5,6,7,9') and FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_last_status":
					$lookupFilter = function() {
						return "`grp` = 41 and `status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_hardware_id":
							break;
						case "x_service_executive":
							break;
						case "x_error_ref":
							$row[1] = FormatDateTime($row[1], 0);
							$row['df'] = $row[1];
							break;
						case "x_service_type":
							break;
						case "x_complaint":
							break;
						case "x_product_replaced":
							$row[2] = FormatNumber($row[2], 0, -1, -1, -1);
							$row['df2'] = $row[2];
							break;
						case "x_consumable_replaced":
							$row[2] = FormatNumber($row[2], 0, -1, -1, -1);
							$row['df2'] = $row[2];
							break;
						case "x_last_status":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		//$this->complaint->ReadOnly = TRUE;

	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>