<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class service_report_search extends service_report
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'service_report';

	// Page object name
	public $PageObjName = "service_report_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (service_report)
		if (!isset($GLOBALS["service_report"]) || get_class($GLOBALS["service_report"]) == PROJECT_NAMESPACE . "service_report") {
			$GLOBALS["service_report"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["service_report"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'service_report');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $service_report;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($service_report);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "service_reportview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("service_reportlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->buyer_id->setVisibility();
		$this->hardware_id->setVisibility();
		$this->service_executive->setVisibility();
		$this->entry_time->setVisibility();
		$this->current_reading->setVisibility();
		$this->error_ref->setVisibility();
		$this->service_type->setVisibility();
		$this->complaint->setVisibility();
		$this->observation->setVisibility();
		$this->product_replaced->setVisibility();
		$this->consumable_replaced->setVisibility();
		$this->out_time->setVisibility();
		$this->work_detail->setVisibility();
		$this->future_task->setVisibility();
		$this->last_status->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->a_operator->setVisibility();
		$this->invoice->setVisibility();
		$this->invoice_date->setVisibility();
		$this->uploads->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->hardware_id);
		$this->setupLookupOptions($this->service_executive);
		$this->setupLookupOptions($this->error_ref);
		$this->setupLookupOptions($this->service_type);
		$this->setupLookupOptions($this->complaint);
		$this->setupLookupOptions($this->product_replaced);
		$this->setupLookupOptions($this->consumable_replaced);
		$this->setupLookupOptions($this->last_status);
		$this->setupLookupOptions($this->operator);
		$this->setupLookupOptions($this->a_operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "service_reportlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
		$this->buildSearchUrl($srchUrl, $this->hardware_id); // hardware_id
		$this->buildSearchUrl($srchUrl, $this->service_executive); // service_executive
		$this->buildSearchUrl($srchUrl, $this->entry_time); // entry_time
		$this->buildSearchUrl($srchUrl, $this->current_reading); // current_reading
		$this->buildSearchUrl($srchUrl, $this->error_ref); // error_ref
		$this->buildSearchUrl($srchUrl, $this->service_type); // service_type
		$this->buildSearchUrl($srchUrl, $this->complaint); // complaint
		$this->buildSearchUrl($srchUrl, $this->observation); // observation
		$this->buildSearchUrl($srchUrl, $this->product_replaced); // product_replaced
		$this->buildSearchUrl($srchUrl, $this->consumable_replaced); // consumable_replaced
		$this->buildSearchUrl($srchUrl, $this->out_time); // out_time
		$this->buildSearchUrl($srchUrl, $this->work_detail); // work_detail
		$this->buildSearchUrl($srchUrl, $this->future_task); // future_task
		$this->buildSearchUrl($srchUrl, $this->last_status); // last_status
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->a_operator); // a_operator
		$this->buildSearchUrl($srchUrl, $this->invoice); // invoice
		$this->buildSearchUrl($srchUrl, $this->invoice_date); // invoice_date
		$this->buildSearchUrl($srchUrl, $this->uploads); // uploads
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// buyer_id
		if (!$this->isAddOrEdit())
			$this->buyer_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_id"));
		$this->buyer_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_id"));

		// hardware_id
		if (!$this->isAddOrEdit())
			$this->hardware_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_hardware_id"));
		$this->hardware_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_hardware_id"));

		// service_executive
		if (!$this->isAddOrEdit())
			$this->service_executive->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_service_executive"));
		$this->service_executive->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_service_executive"));

		// entry_time
		if (!$this->isAddOrEdit())
			$this->entry_time->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_entry_time"));
		$this->entry_time->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_entry_time"));

		// current_reading
		if (!$this->isAddOrEdit())
			$this->current_reading->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_current_reading"));
		$this->current_reading->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_current_reading"));

		// error_ref
		if (!$this->isAddOrEdit())
			$this->error_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_error_ref"));
		$this->error_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_error_ref"));

		// service_type
		if (!$this->isAddOrEdit())
			$this->service_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_service_type"));
		$this->service_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_service_type"));

		// complaint
		if (!$this->isAddOrEdit())
			$this->complaint->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_complaint"));
		$this->complaint->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_complaint"));

		// observation
		if (!$this->isAddOrEdit())
			$this->observation->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_observation"));
		$this->observation->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_observation"));

		// product_replaced
		if (!$this->isAddOrEdit())
			$this->product_replaced->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_replaced"));
		$this->product_replaced->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_replaced"));
		if (is_array($this->product_replaced->AdvancedSearch->SearchValue))
			$this->product_replaced->AdvancedSearch->SearchValue = implode(",", $this->product_replaced->AdvancedSearch->SearchValue);
		if (is_array($this->product_replaced->AdvancedSearch->SearchValue2))
			$this->product_replaced->AdvancedSearch->SearchValue2 = implode(",", $this->product_replaced->AdvancedSearch->SearchValue2);

		// consumable_replaced
		if (!$this->isAddOrEdit())
			$this->consumable_replaced->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_consumable_replaced"));
		$this->consumable_replaced->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_consumable_replaced"));
		if (is_array($this->consumable_replaced->AdvancedSearch->SearchValue))
			$this->consumable_replaced->AdvancedSearch->SearchValue = implode(",", $this->consumable_replaced->AdvancedSearch->SearchValue);
		if (is_array($this->consumable_replaced->AdvancedSearch->SearchValue2))
			$this->consumable_replaced->AdvancedSearch->SearchValue2 = implode(",", $this->consumable_replaced->AdvancedSearch->SearchValue2);

		// out_time
		if (!$this->isAddOrEdit())
			$this->out_time->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_out_time"));
		$this->out_time->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_out_time"));

		// work_detail
		if (!$this->isAddOrEdit())
			$this->work_detail->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_work_detail"));
		$this->work_detail->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_work_detail"));

		// future_task
		if (!$this->isAddOrEdit())
			$this->future_task->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_future_task"));
		$this->future_task->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_future_task"));

		// last_status
		if (!$this->isAddOrEdit())
			$this->last_status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_last_status"));
		$this->last_status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_last_status"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// a_operator
		if (!$this->isAddOrEdit())
			$this->a_operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_a_operator"));
		$this->a_operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_a_operator"));

		// invoice
		if (!$this->isAddOrEdit())
			$this->invoice->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_invoice"));
		$this->invoice->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_invoice"));

		// invoice_date
		if (!$this->isAddOrEdit())
			$this->invoice_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_invoice_date"));
		$this->invoice_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_invoice_date"));

		// uploads
		if (!$this->isAddOrEdit())
			$this->uploads->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_uploads"));
		$this->uploads->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_uploads"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// buyer_id
		// hardware_id
		// service_executive
		// entry_time
		// current_reading
		// error_ref
		// service_type
		// complaint
		// observation
		// product_replaced
		// consumable_replaced
		// out_time
		// work_detail
		// future_task
		// last_status
		// operator
		// datetime
		// a_operator
		// invoice
		// invoice_date
		// uploads

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// buyer_id
			$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>1000 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// hardware_id
			$curVal = strval($this->hardware_id->CurrentValue);
			if ($curVal <> "") {
				$this->hardware_id->ViewValue = $this->hardware_id->lookupCacheOption($curVal);
				if ($this->hardware_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->hardware_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->hardware_id->ViewValue = $this->hardware_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->hardware_id->ViewValue = $this->hardware_id->CurrentValue;
					}
				}
			} else {
				$this->hardware_id->ViewValue = NULL;
			}
			$this->hardware_id->ViewCustomAttributes = "";

			// service_executive
			$this->service_executive->ViewValue = $this->service_executive->CurrentValue;
			$curVal = strval($this->service_executive->CurrentValue);
			if ($curVal <> "") {
				$this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
				if ($this->service_executive->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->service_executive->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->service_executive->ViewValue = $this->service_executive->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->service_executive->ViewValue = $this->service_executive->CurrentValue;
					}
				}
			} else {
				$this->service_executive->ViewValue = NULL;
			}
			$this->service_executive->ViewCustomAttributes = "";

			// entry_time
			$this->entry_time->ViewValue = $this->entry_time->CurrentValue;
			$this->entry_time->ViewValue = FormatDateTime($this->entry_time->ViewValue, 0);
			$this->entry_time->ViewCustomAttributes = "";

			// current_reading
			$this->current_reading->ViewValue = $this->current_reading->CurrentValue;
			$this->current_reading->ViewValue = FormatNumber($this->current_reading->ViewValue, 0, -2, -2, -2);
			$this->current_reading->ViewCustomAttributes = "";

			// error_ref
			$curVal = strval($this->error_ref->CurrentValue);
			if ($curVal <> "") {
				$this->error_ref->ViewValue = $this->error_ref->lookupCacheOption($curVal);
				if ($this->error_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status` !=9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->error_ref->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatDateTime($rswrk->fields('df'), 0);
						$arwrk[2] = $rswrk->fields('df2');
						$this->error_ref->ViewValue = $this->error_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->error_ref->ViewValue = $this->error_ref->CurrentValue;
					}
				}
			} else {
				$this->error_ref->ViewValue = NULL;
			}
			$this->error_ref->ViewCustomAttributes = "";

			// service_type
			$curVal = strval($this->service_type->CurrentValue);
			if ($curVal <> "") {
				$this->service_type->ViewValue = $this->service_type->lookupCacheOption($curVal);
				if ($this->service_type->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp`=11  and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->service_type->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->service_type->ViewValue = $this->service_type->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->service_type->ViewValue = $this->service_type->CurrentValue;
					}
				}
			} else {
				$this->service_type->ViewValue = NULL;
			}
			$this->service_type->ViewCustomAttributes = "";

			// complaint
			$curVal = strval($this->complaint->CurrentValue);
			if ($curVal <> "") {
				$this->complaint->ViewValue = $this->complaint->lookupCacheOption($curVal);
				if ($this->complaint->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`item`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$lookupFilter = function() {
						return "`grp` = 21 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->complaint->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->complaint->ViewValue = $this->complaint->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->complaint->ViewValue = $this->complaint->CurrentValue;
					}
				}
			} else {
				$this->complaint->ViewValue = NULL;
			}
			$this->complaint->ViewCustomAttributes = "";

			// observation
			$this->observation->ViewValue = $this->observation->CurrentValue;
			$this->observation->ViewCustomAttributes = "";

			// product_replaced
			$curVal = strval($this->product_replaced->CurrentValue);
			if ($curVal <> "") {
				$this->product_replaced->ViewValue = $this->product_replaced->lookupCacheOption($curVal);
				if ($this->product_replaced->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '3,4,8,10') and FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_replaced->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->product_replaced->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -1, -1, -1);
							$this->product_replaced->ViewValue->add($this->product_replaced->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->product_replaced->ViewValue = $this->product_replaced->CurrentValue;
					}
				}
			} else {
				$this->product_replaced->ViewValue = NULL;
			}
			$this->product_replaced->ViewCustomAttributes = "";

			// consumable_replaced
			$curVal = strval($this->consumable_replaced->CurrentValue);
			if ($curVal <> "") {
				$this->consumable_replaced->ViewValue = $this->consumable_replaced->lookupCacheOption($curVal);
				if ($this->consumable_replaced->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$lookupFilter = function() {
						return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '5,6,7,9') and FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consumable_replaced->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->consumable_replaced->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -1, -1, -1);
							$this->consumable_replaced->ViewValue->add($this->consumable_replaced->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->consumable_replaced->ViewValue = $this->consumable_replaced->CurrentValue;
					}
				}
			} else {
				$this->consumable_replaced->ViewValue = NULL;
			}
			$this->consumable_replaced->ViewCustomAttributes = "";

			// out_time
			$this->out_time->ViewValue = $this->out_time->CurrentValue;
			$this->out_time->ViewValue = FormatDateTime($this->out_time->ViewValue, 0);
			$this->out_time->ViewCustomAttributes = "";

			// work_detail
			$this->work_detail->ViewValue = $this->work_detail->CurrentValue;
			$this->work_detail->ViewCustomAttributes = "";

			// future_task
			$this->future_task->ViewValue = $this->future_task->CurrentValue;
			$this->future_task->ViewCustomAttributes = "";

			// last_status
			$curVal = strval($this->last_status->CurrentValue);
			if ($curVal <> "") {
				$this->last_status->ViewValue = $this->last_status->lookupCacheOption($curVal);
				if ($this->last_status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 41 and `status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->last_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->last_status->ViewValue = $this->last_status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->last_status->ViewValue = $this->last_status->CurrentValue;
					}
				}
			} else {
				$this->last_status->ViewValue = NULL;
			}
			$this->last_status->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// a_operator
			$curVal = strval($this->a_operator->CurrentValue);
			if ($curVal <> "") {
				$this->a_operator->ViewValue = $this->a_operator->lookupCacheOption($curVal);
				if ($this->a_operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->a_operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->a_operator->ViewValue = $this->a_operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->a_operator->ViewValue = $this->a_operator->CurrentValue;
					}
				}
			} else {
				$this->a_operator->ViewValue = NULL;
			}
			$this->a_operator->ViewCustomAttributes = "";

			// invoice
			$this->invoice->ViewValue = $this->invoice->CurrentValue;
			$this->invoice->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// uploads
			$this->uploads->ViewValue = $this->uploads->CurrentValue;
			$this->uploads->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// hardware_id
			$this->hardware_id->LinkCustomAttributes = "";
			$this->hardware_id->HrefValue = "";
			$this->hardware_id->TooltipValue = "";

			// service_executive
			$this->service_executive->LinkCustomAttributes = "";
			$this->service_executive->HrefValue = "";
			$this->service_executive->TooltipValue = "";

			// entry_time
			$this->entry_time->LinkCustomAttributes = "";
			$this->entry_time->HrefValue = "";
			$this->entry_time->TooltipValue = "";

			// current_reading
			$this->current_reading->LinkCustomAttributes = "";
			$this->current_reading->HrefValue = "";
			$this->current_reading->TooltipValue = "";

			// error_ref
			$this->error_ref->LinkCustomAttributes = "";
			$this->error_ref->HrefValue = "";
			$this->error_ref->TooltipValue = "";

			// service_type
			$this->service_type->LinkCustomAttributes = "";
			$this->service_type->HrefValue = "";
			$this->service_type->TooltipValue = "";

			// complaint
			$this->complaint->LinkCustomAttributes = "";
			$this->complaint->HrefValue = "";
			$this->complaint->TooltipValue = "";

			// observation
			$this->observation->LinkCustomAttributes = "";
			$this->observation->HrefValue = "";
			$this->observation->TooltipValue = "";

			// product_replaced
			$this->product_replaced->LinkCustomAttributes = "";
			$this->product_replaced->HrefValue = "";
			$this->product_replaced->TooltipValue = "";

			// consumable_replaced
			$this->consumable_replaced->LinkCustomAttributes = "";
			$this->consumable_replaced->HrefValue = "";
			$this->consumable_replaced->TooltipValue = "";

			// out_time
			$this->out_time->LinkCustomAttributes = "";
			$this->out_time->HrefValue = "";
			$this->out_time->TooltipValue = "";

			// work_detail
			$this->work_detail->LinkCustomAttributes = "";
			$this->work_detail->HrefValue = "";
			$this->work_detail->TooltipValue = "";

			// future_task
			$this->future_task->LinkCustomAttributes = "";
			$this->future_task->HrefValue = "";
			$this->future_task->TooltipValue = "";

			// last_status
			$this->last_status->LinkCustomAttributes = "";
			$this->last_status->HrefValue = "";
			$this->last_status->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// a_operator
			$this->a_operator->LinkCustomAttributes = "";
			$this->a_operator->HrefValue = "";
			$this->a_operator->TooltipValue = "";

			// invoice
			$this->invoice->LinkCustomAttributes = "";
			$this->invoice->HrefValue = "";
			$this->invoice->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->HrefValue = "";
			$this->uploads->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$this->buyer_id->EditValue = HtmlEncode($this->buyer_id->AdvancedSearch->SearchValue);
			$curVal = strval($this->buyer_id->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`>1000 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$arwrk[4] = HtmlEncode($rswrk->fields('df4'));
						$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->EditValue = HtmlEncode($this->buyer_id->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->buyer_id->EditValue = NULL;
			}
			$this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

			// hardware_id
			$this->hardware_id->EditAttrs["class"] = "form-control";
			$this->hardware_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->hardware_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->hardware_id->AdvancedSearch->ViewValue = $this->hardware_id->lookupCacheOption($curVal);
			else
				$this->hardware_id->AdvancedSearch->ViewValue = $this->hardware_id->Lookup !== NULL && is_array($this->hardware_id->Lookup->Options) ? $curVal : NULL;
			if ($this->hardware_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->hardware_id->EditValue = array_values($this->hardware_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->hardware_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->hardware_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->hardware_id->EditValue = $arwrk;
			}

			// service_executive
			$this->service_executive->EditAttrs["class"] = "form-control";
			$this->service_executive->EditCustomAttributes = "";
			$this->service_executive->EditValue = HtmlEncode($this->service_executive->AdvancedSearch->SearchValue);
			$curVal = strval($this->service_executive->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->service_executive->EditValue = $this->service_executive->lookupCacheOption($curVal);
				if ($this->service_executive->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->service_executive->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->service_executive->EditValue = $this->service_executive->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->service_executive->EditValue = HtmlEncode($this->service_executive->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->service_executive->EditValue = NULL;
			}
			$this->service_executive->PlaceHolder = RemoveHtml($this->service_executive->caption());

			// entry_time
			$this->entry_time->EditAttrs["class"] = "form-control";
			$this->entry_time->EditCustomAttributes = "";
			$this->entry_time->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->entry_time->AdvancedSearch->SearchValue, 0), 8));
			$this->entry_time->PlaceHolder = RemoveHtml($this->entry_time->caption());

			// current_reading
			$this->current_reading->EditAttrs["class"] = "form-control";
			$this->current_reading->EditCustomAttributes = "";
			$this->current_reading->EditValue = HtmlEncode($this->current_reading->AdvancedSearch->SearchValue);
			$this->current_reading->PlaceHolder = RemoveHtml($this->current_reading->caption());

			// error_ref
			$this->error_ref->EditAttrs["class"] = "form-control";
			$this->error_ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->error_ref->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->error_ref->AdvancedSearch->ViewValue = $this->error_ref->lookupCacheOption($curVal);
			else
				$this->error_ref->AdvancedSearch->ViewValue = $this->error_ref->Lookup !== NULL && is_array($this->error_ref->Lookup->Options) ? $curVal : NULL;
			if ($this->error_ref->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->error_ref->EditValue = array_values($this->error_ref->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->error_ref->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status` !=9";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->error_ref->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatDateTime($arwrk[$i][1], 0);
				}
				$this->error_ref->EditValue = $arwrk;
			}

			// service_type
			$this->service_type->EditAttrs["class"] = "form-control";
			$this->service_type->EditCustomAttributes = "";
			$curVal = trim(strval($this->service_type->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->service_type->AdvancedSearch->ViewValue = $this->service_type->lookupCacheOption($curVal);
			else
				$this->service_type->AdvancedSearch->ViewValue = $this->service_type->Lookup !== NULL && is_array($this->service_type->Lookup->Options) ? $curVal : NULL;
			if ($this->service_type->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->service_type->EditValue = array_values($this->service_type->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->service_type->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp`=11  and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->service_type->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->service_type->EditValue = $arwrk;
			}

			// complaint
			$this->complaint->EditAttrs["class"] = "form-control";
			$this->complaint->EditCustomAttributes = "";
			$curVal = trim(strval($this->complaint->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->complaint->AdvancedSearch->ViewValue = $this->complaint->lookupCacheOption($curVal);
			else
				$this->complaint->AdvancedSearch->ViewValue = $this->complaint->Lookup !== NULL && is_array($this->complaint->Lookup->Options) ? $curVal : NULL;
			if ($this->complaint->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->complaint->EditValue = array_values($this->complaint->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`item`" . SearchString("=", $this->complaint->AdvancedSearch->SearchValue, DATATYPE_STRING, "");
				}
				$lookupFilter = function() {
					return "`grp` = 21 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->complaint->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->complaint->EditValue = $arwrk;
			}

			// observation
			$this->observation->EditAttrs["class"] = "form-control";
			$this->observation->EditCustomAttributes = "";
			$this->observation->EditValue = HtmlEncode($this->observation->AdvancedSearch->SearchValue);
			$this->observation->PlaceHolder = RemoveHtml($this->observation->caption());

			// product_replaced
			$this->product_replaced->EditCustomAttributes = 'selected';
			$curVal = trim(strval($this->product_replaced->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product_replaced->AdvancedSearch->ViewValue = $this->product_replaced->lookupCacheOption($curVal);
			else
				$this->product_replaced->AdvancedSearch->ViewValue = $this->product_replaced->Lookup !== NULL && is_array($this->product_replaced->Lookup->Options) ? $curVal : NULL;
			if ($this->product_replaced->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product_replaced->EditValue = array_values($this->product_replaced->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '3,4,8,10') and FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')"));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_replaced->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 0, -1, -1, -1);
				}
				$this->product_replaced->EditValue = $arwrk;
			}

			// consumable_replaced
			$this->consumable_replaced->EditCustomAttributes = "";
			$curVal = trim(strval($this->consumable_replaced->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->consumable_replaced->AdvancedSearch->ViewValue = $this->consumable_replaced->lookupCacheOption($curVal);
			else
				$this->consumable_replaced->AdvancedSearch->ViewValue = $this->consumable_replaced->Lookup !== NULL && is_array($this->consumable_replaced->Lookup->Options) ? $curVal : NULL;
			if ($this->consumable_replaced->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->consumable_replaced->EditValue = array_values($this->consumable_replaced->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "") $filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
				}
				$lookupFilter = function() {
					return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '5,6,7,9') and FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')"));
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->consumable_replaced->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 0, -1, -1, -1);
				}
				$this->consumable_replaced->EditValue = $arwrk;
			}

			// out_time
			$this->out_time->EditAttrs["class"] = "form-control";
			$this->out_time->EditCustomAttributes = "";
			$this->out_time->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->out_time->AdvancedSearch->SearchValue, 0), 8));
			$this->out_time->PlaceHolder = RemoveHtml($this->out_time->caption());

			// work_detail
			$this->work_detail->EditAttrs["class"] = "form-control";
			$this->work_detail->EditCustomAttributes = "";
			$this->work_detail->EditValue = HtmlEncode($this->work_detail->AdvancedSearch->SearchValue);
			$this->work_detail->PlaceHolder = RemoveHtml($this->work_detail->caption());

			// future_task
			$this->future_task->EditAttrs["class"] = "form-control";
			$this->future_task->EditCustomAttributes = "";
			$this->future_task->EditValue = HtmlEncode($this->future_task->AdvancedSearch->SearchValue);
			$this->future_task->PlaceHolder = RemoveHtml($this->future_task->caption());

			// last_status
			$this->last_status->EditAttrs["class"] = "form-control";
			$this->last_status->EditCustomAttributes = "";
			$curVal = trim(strval($this->last_status->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->last_status->AdvancedSearch->ViewValue = $this->last_status->lookupCacheOption($curVal);
			else
				$this->last_status->AdvancedSearch->ViewValue = $this->last_status->Lookup !== NULL && is_array($this->last_status->Lookup->Options) ? $curVal : NULL;
			if ($this->last_status->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->last_status->EditValue = array_values($this->last_status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->last_status->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 41 and `status` =1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->last_status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->last_status->EditValue = $arwrk;
			}

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// a_operator
			$this->a_operator->EditAttrs["class"] = "form-control";
			$this->a_operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->a_operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->lookupCacheOption($curVal);
			else
				$this->a_operator->AdvancedSearch->ViewValue = $this->a_operator->Lookup !== NULL && is_array($this->a_operator->Lookup->Options) ? $curVal : NULL;
			if ($this->a_operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->a_operator->EditValue = array_values($this->a_operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->a_operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->a_operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->a_operator->EditValue = $arwrk;
			}

			// invoice
			$this->invoice->EditAttrs["class"] = "form-control";
			$this->invoice->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->invoice->AdvancedSearch->SearchValue = HtmlDecode($this->invoice->AdvancedSearch->SearchValue);
			$this->invoice->EditValue = HtmlEncode($this->invoice->AdvancedSearch->SearchValue);
			$this->invoice->PlaceHolder = RemoveHtml($this->invoice->caption());

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue, 0), 8));
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
			$this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->buyer_id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->buyer_id->errorMessage());
		}
		if (!CheckInteger($this->service_executive->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->service_executive->errorMessage());
		}
		if (!CheckDate($this->entry_time->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->entry_time->errorMessage());
		}
		if (!CheckInteger($this->current_reading->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->current_reading->errorMessage());
		}
		if (!CheckDate($this->out_time->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->out_time->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckDate($this->invoice_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->invoice_date->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->buyer_id->AdvancedSearch->load();
		$this->hardware_id->AdvancedSearch->load();
		$this->service_executive->AdvancedSearch->load();
		$this->entry_time->AdvancedSearch->load();
		$this->current_reading->AdvancedSearch->load();
		$this->error_ref->AdvancedSearch->load();
		$this->service_type->AdvancedSearch->load();
		$this->complaint->AdvancedSearch->load();
		$this->observation->AdvancedSearch->load();
		$this->product_replaced->AdvancedSearch->load();
		$this->consumable_replaced->AdvancedSearch->load();
		$this->out_time->AdvancedSearch->load();
		$this->work_detail->AdvancedSearch->load();
		$this->future_task->AdvancedSearch->load();
		$this->last_status->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->a_operator->AdvancedSearch->load();
		$this->invoice->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->uploads->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("service_reportlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`id`>1000 and `status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_service_executive":
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_error_ref":
					$lookupFilter = function() {
						return "`status` !=9";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_service_type":
					$lookupFilter = function() {
						return "`grp`=11  and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_complaint":
					$lookupFilter = function() {
						return "`grp` = 21 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_replaced":
					$lookupFilter = function() {
						return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '3,4,8,10') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '3,4,8,10') and FIND_IN_SET(`id`, '" .$this->product_replaced->CurrentValue . "')"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consumable_replaced":
					$lookupFilter = function() {
						return ((CurrentPageID() == "add")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL" : ((CurrentPageID() == "edit")  ? "FIND_IN_SET(`s_grp`, '5,6,7,9') and `jc_no` IS NULL || FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')" : "FIND_IN_SET(`s_grp`, '5,6,7,9') and FIND_IN_SET(`id`, '" .$this->consumable_replaced->CurrentValue . "')"));
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_last_status":
					$lookupFilter = function() {
						return "`grp` = 41 and `status` =1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_hardware_id":
							break;
						case "x_service_executive":
							break;
						case "x_error_ref":
							$row[1] = FormatDateTime($row[1], 0);
							$row['df'] = $row[1];
							break;
						case "x_service_type":
							break;
						case "x_complaint":
							break;
						case "x_product_replaced":
							$row[2] = FormatNumber($row[2], 0, -1, -1, -1);
							$row['df2'] = $row[2];
							break;
						case "x_consumable_replaced":
							$row[2] = FormatNumber($row[2], 0, -1, -1, -1);
							$row['df2'] = $row[2];
							break;
						case "x_last_status":
							break;
						case "x_operator":
							break;
						case "x_a_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>