<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for service_request
 */
class service_request extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $status;
	public $buyer_id;
	public $product_ref;
	public $current_reading;
	public $product_status;
	public $error;
	public $last_serve;
	public $last_serve_by;
	public $query_by;
	public $service_executive;
	public $Ins_service_executive;
	public $operator;
	public $datetime;
	public $o_operator;
	public $o_datetime;
	public $rid_1;
	public $master_reading;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'service_request';
		$this->TableName = 'service_request';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`service_request`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('service_request', 'service_request', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// status
		$this->status = new DbField('service_request', 'service_request', 'x_status', 'status', '`status`', '`status`', 18, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 'service_request', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 3;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// buyer_id
		$this->buyer_id = new DbField('service_request', 'service_request', 'x_buyer_id', 'buyer_id', '`buyer_id`', '`buyer_id`', 19, -1, FALSE, '`EV__buyer_id`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer_id->Nullable = FALSE; // NOT NULL field
		$this->buyer_id->Required = TRUE; // Required field
		$this->buyer_id->Sortable = TRUE; // Allow sort
		$this->buyer_id->Lookup = new Lookup('buyer_id', 'buyer', FALSE, 'id', ["name","code","mobile","city_name"], [], ["x_product_ref"], [], [], [], [], '`name` ASC', '');
		$this->buyer_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer_id'] = &$this->buyer_id;

		// product_ref
		$this->product_ref = new DbField('service_request', 'service_request', 'x_product_ref', 'product_ref', '`product_ref`', '`product_ref`', 18, -1, FALSE, '`product_ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product_ref->Required = TRUE; // Required field
		$this->product_ref->Sortable = TRUE; // Allow sort
		$this->product_ref->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product_ref->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product_ref->Lookup = new Lookup('product_ref', 'client_hardware_data', FALSE, 'id', ["ref","name_ref","harward_code","serial_no"], ["x_buyer_id"], [], ["partner_id"], ["x_partner_id"], [], [], '', '');
		$this->product_ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product_ref'] = &$this->product_ref;

		// current_reading
		$this->current_reading = new DbField('service_request', 'service_request', 'x_current_reading', 'current_reading', '`current_reading`', '`current_reading`', 19, -1, FALSE, '`current_reading`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->current_reading->Nullable = FALSE; // NOT NULL field
		$this->current_reading->Required = TRUE; // Required field
		$this->current_reading->Sortable = TRUE; // Allow sort
		$this->current_reading->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['current_reading'] = &$this->current_reading;

		// product_status
		$this->product_status = new DbField('service_request', 'service_request', 'x_product_status', 'product_status', '`product_status`', '`product_status`', 2, -1, FALSE, '`product_status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product_status->Sortable = TRUE; // Allow sort
		$this->product_status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product_status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product_status->Lookup = new Lookup('product_status', 'service_misc', FALSE, 'id', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['product_status'] = &$this->product_status;

		// error
		$this->error = new DbField('service_request', 'service_request', 'x_error', 'error', '`error`', '`error`', 201, -1, FALSE, '`error`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->error->Sortable = TRUE; // Allow sort
		$this->fields['error'] = &$this->error;

		// last_serve
		$this->last_serve = new DbField('service_request', 'service_request', 'x_last_serve', 'last_serve', '`last_serve`', CastDateFieldForLike('`last_serve`', 0, "DB"), 135, 0, FALSE, '`last_serve`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->last_serve->Sortable = TRUE; // Allow sort
		$this->last_serve->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['last_serve'] = &$this->last_serve;

		// last_serve_by
		$this->last_serve_by = new DbField('service_request', 'service_request', 'x_last_serve_by', 'last_serve_by', '`last_serve_by`', '`last_serve_by`', 18, -1, FALSE, '`last_serve_by`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->last_serve_by->Sortable = TRUE; // Allow sort
		$this->last_serve_by->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->last_serve_by->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->last_serve_by->Lookup = new Lookup('last_serve_by', 'admin', FALSE, 'id', ["user_name","mobile","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->last_serve_by->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['last_serve_by'] = &$this->last_serve_by;

		// query_by
		$this->query_by = new DbField('service_request', 'service_request', 'x_query_by', 'query_by', '`query_by`', '`query_by`', 200, -1, FALSE, '`query_by`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->query_by->Sortable = TRUE; // Allow sort
		$this->fields['query_by'] = &$this->query_by;

		// service_executive
		$this->service_executive = new DbField('service_request', 'service_request', 'x_service_executive', 'service_executive', '`service_executive`', '`service_executive`', 18, -1, FALSE, '`service_executive`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->service_executive->Nullable = FALSE; // NOT NULL field
		$this->service_executive->Required = TRUE; // Required field
		$this->service_executive->Sortable = TRUE; // Allow sort
		$this->service_executive->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->service_executive->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->service_executive->Lookup = new Lookup('service_executive', 'admin', FALSE, 'id', ["user_name","mobile","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->service_executive->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['service_executive'] = &$this->service_executive;

		// Ins_service_executive
		$this->Ins_service_executive = new DbField('service_request', 'service_request', 'x_Ins_service_executive', 'Ins_service_executive', '`Ins_service_executive`', '`Ins_service_executive`', 201, -1, FALSE, '`Ins_service_executive`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->Ins_service_executive->Nullable = FALSE; // NOT NULL field
		$this->Ins_service_executive->Required = TRUE; // Required field
		$this->Ins_service_executive->Sortable = TRUE; // Allow sort
		$this->fields['Ins_service_executive'] = &$this->Ins_service_executive;

		// operator
		$this->operator = new DbField('service_request', 'service_request', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('service_request', 'service_request', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// o_operator
		$this->o_operator = new DbField('service_request', 'service_request', 'x_o_operator', 'o_operator', '`o_operator`', '`o_operator`', 18, -1, FALSE, '`o_operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->o_operator->Nullable = FALSE; // NOT NULL field
		$this->o_operator->Sortable = TRUE; // Allow sort
		$this->o_operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['o_operator'] = &$this->o_operator;

		// o_datetime
		$this->o_datetime = new DbField('service_request', 'service_request', 'x_o_datetime', 'o_datetime', '`o_datetime`', CastDateFieldForLike('`o_datetime`', 0, "DB"), 135, 0, FALSE, '`o_datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->o_datetime->Nullable = FALSE; // NOT NULL field
		$this->o_datetime->Sortable = TRUE; // Allow sort
		$this->o_datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['o_datetime'] = &$this->o_datetime;

		// rid_1
		$this->rid_1 = new DbField('service_request', 'service_request', 'x_rid_1', 'rid_1', '`rid_1`', '`rid_1`', 200, -1, FALSE, '`rid_1`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid_1->Nullable = FALSE; // NOT NULL field
		$this->rid_1->Sortable = FALSE; // Allow sort
		$this->fields['rid_1'] = &$this->rid_1;

		// master_reading
		$this->master_reading = new DbField('service_request', 'service_request', 'x_master_reading', 'master_reading', '`master_reading`', '`master_reading`', 19, -1, FALSE, '`master_reading`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->master_reading->Nullable = FALSE; // NOT NULL field
		$this->master_reading->Required = TRUE; // Required field
		$this->master_reading->Sortable = TRUE; // Allow sort
		$this->master_reading->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['master_reading'] = &$this->master_reading;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`service_request`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT CONCAT(COALESCE(`name`, ''),'" . ValueSeparator(1, $this->buyer_id) . "',COALESCE(`code`,''),'" . ValueSeparator(2, $this->buyer_id) . "',COALESCE(`mobile`,''),'" . ValueSeparator(3, $this->buyer_id) . "',COALESCE(`city_name`,'')) FROM `buyer` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `service_request`.`buyer_id` LIMIT 1) AS `EV__buyer_id` FROM `service_request`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = (User_Category() == 92) ? "`service_executive` = " .  CurrentUserID() : "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` ASC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->buyer_id->AdvancedSearch->SearchValue <> "" ||
			$this->buyer_id->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->buyer_id->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->buyer_id->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->status->DbValue = $row['status'];
		$this->buyer_id->DbValue = $row['buyer_id'];
		$this->product_ref->DbValue = $row['product_ref'];
		$this->current_reading->DbValue = $row['current_reading'];
		$this->product_status->DbValue = $row['product_status'];
		$this->error->DbValue = $row['error'];
		$this->last_serve->DbValue = $row['last_serve'];
		$this->last_serve_by->DbValue = $row['last_serve_by'];
		$this->query_by->DbValue = $row['query_by'];
		$this->service_executive->DbValue = $row['service_executive'];
		$this->Ins_service_executive->DbValue = $row['Ins_service_executive'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->o_operator->DbValue = $row['o_operator'];
		$this->o_datetime->DbValue = $row['o_datetime'];
		$this->rid_1->DbValue = $row['rid_1'];
		$this->master_reading->DbValue = $row['master_reading'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "service_requestlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "service_requestview.php")
			return $Language->phrase("View");
		elseif ($pageName == "service_requestedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "service_requestadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "service_requestlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("service_requestview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("service_requestview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "service_requestadd.php?" . $this->getUrlParm($parm);
		else
			$url = "service_requestadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("service_requestedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("service_requestadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("service_requestdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->status->setDbValue($rs->fields('status'));
		$this->buyer_id->setDbValue($rs->fields('buyer_id'));
		$this->product_ref->setDbValue($rs->fields('product_ref'));
		$this->current_reading->setDbValue($rs->fields('current_reading'));
		$this->product_status->setDbValue($rs->fields('product_status'));
		$this->error->setDbValue($rs->fields('error'));
		$this->last_serve->setDbValue($rs->fields('last_serve'));
		$this->last_serve_by->setDbValue($rs->fields('last_serve_by'));
		$this->query_by->setDbValue($rs->fields('query_by'));
		$this->service_executive->setDbValue($rs->fields('service_executive'));
		$this->Ins_service_executive->setDbValue($rs->fields('Ins_service_executive'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->o_operator->setDbValue($rs->fields('o_operator'));
		$this->o_datetime->setDbValue($rs->fields('o_datetime'));
		$this->rid_1->setDbValue($rs->fields('rid_1'));
		$this->master_reading->setDbValue($rs->fields('master_reading'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// status
		// buyer_id
		// product_ref
		// current_reading
		// product_status
		// error
		// last_serve
		// last_serve_by
		// query_by
		// service_executive
		// Ins_service_executive
		// operator
		// datetime
		// o_operator
		// o_datetime
		// rid_1

		$this->rid_1->CellCssStyle = "white-space: nowrap;";

		// master_reading
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// buyer_id
		if ($this->buyer_id->VirtualValue <> "") {
			$this->buyer_id->ViewValue = $this->buyer_id->VirtualValue;
		} else {
			$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` > 1000 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->ViewValue = NULL;
		}
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// product_ref
		$curVal = strval($this->product_ref->CurrentValue);
		if ($curVal <> "") {
			$this->product_ref->ViewValue = $this->product_ref->lookupCacheOption($curVal);
			if ($this->product_ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->product_ref->ViewValue = $this->product_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_ref->ViewValue = $this->product_ref->CurrentValue;
				}
			}
		} else {
			$this->product_ref->ViewValue = NULL;
		}
		$this->product_ref->ViewCustomAttributes = "";

		// current_reading
		$this->current_reading->ViewValue = $this->current_reading->CurrentValue;
		$this->current_reading->ViewValue = FormatNumber($this->current_reading->ViewValue, 0, -2, -2, -2);
		$this->current_reading->ViewCustomAttributes = "";

		// product_status
		$curVal = strval($this->product_status->CurrentValue);
		if ($curVal <> "") {
			$this->product_status->ViewValue = $this->product_status->lookupCacheOption($curVal);
			if ($this->product_status->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 21 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_status->ViewValue = $this->product_status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_status->ViewValue = $this->product_status->CurrentValue;
				}
			}
		} else {
			$this->product_status->ViewValue = NULL;
		}
		$this->product_status->ViewCustomAttributes = "";

		// error
		$this->error->ViewValue = $this->error->CurrentValue;
		$this->error->ViewCustomAttributes = "";

		// last_serve
		$this->last_serve->ViewValue = $this->last_serve->CurrentValue;
		$this->last_serve->ViewValue = FormatDateTime($this->last_serve->ViewValue, 0);
		$this->last_serve->ViewCustomAttributes = "";

		// last_serve_by
		$curVal = strval($this->last_serve_by->CurrentValue);
		if ($curVal <> "") {
			$this->last_serve_by->ViewValue = $this->last_serve_by->lookupCacheOption($curVal);
			if ($this->last_serve_by->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "FIND_IN_SET('92', `category`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->last_serve_by->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->last_serve_by->ViewValue = $this->last_serve_by->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->last_serve_by->ViewValue = $this->last_serve_by->CurrentValue;
				}
			}
		} else {
			$this->last_serve_by->ViewValue = NULL;
		}
		$this->last_serve_by->ViewCustomAttributes = "";

		// query_by
		$this->query_by->ViewValue = $this->query_by->CurrentValue;
		$this->query_by->ViewCustomAttributes = "";

		// service_executive
		$curVal = strval($this->service_executive->CurrentValue);
		if ($curVal <> "") {
			$this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
			if ($this->service_executive->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "FIND_IN_SET('92', `category`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->service_executive->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->service_executive->ViewValue = $this->service_executive->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->service_executive->ViewValue = $this->service_executive->CurrentValue;
				}
			}
		} else {
			$this->service_executive->ViewValue = NULL;
		}
		$this->service_executive->ViewCustomAttributes = "";

		// Ins_service_executive
		$this->Ins_service_executive->ViewValue = $this->Ins_service_executive->CurrentValue;
		$this->Ins_service_executive->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// o_operator
		$this->o_operator->ViewValue = $this->o_operator->CurrentValue;
		$this->o_operator->ViewValue = FormatNumber($this->o_operator->ViewValue, 0, -2, -2, -2);
		$this->o_operator->ViewCustomAttributes = "";

		// o_datetime
		$this->o_datetime->ViewValue = $this->o_datetime->CurrentValue;
		$this->o_datetime->ViewValue = FormatDateTime($this->o_datetime->ViewValue, 0);
		$this->o_datetime->ViewCustomAttributes = "";

		// rid_1
		$this->rid_1->ViewValue = $this->rid_1->CurrentValue;
		$this->rid_1->ViewCustomAttributes = "";

		// master_reading
		$this->master_reading->ViewValue = $this->master_reading->CurrentValue;
		$this->master_reading->ViewValue = FormatNumber($this->master_reading->ViewValue, 0, -2, -2, -2);
		$this->master_reading->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// buyer_id
		$this->buyer_id->LinkCustomAttributes = "";
		$this->buyer_id->HrefValue = "";
		$this->buyer_id->TooltipValue = "";

		// product_ref
		$this->product_ref->LinkCustomAttributes = "";
		$this->product_ref->HrefValue = "";
		$this->product_ref->TooltipValue = "";

		// current_reading
		$this->current_reading->LinkCustomAttributes = "";
		$this->current_reading->HrefValue = "";
		$this->current_reading->TooltipValue = "";

		// product_status
		$this->product_status->LinkCustomAttributes = "";
		$this->product_status->HrefValue = "";
		$this->product_status->TooltipValue = "";

		// error
		$this->error->LinkCustomAttributes = "";
		$this->error->HrefValue = "";
		$this->error->TooltipValue = "";

		// last_serve
		$this->last_serve->LinkCustomAttributes = "";
		$this->last_serve->HrefValue = "";
		$this->last_serve->TooltipValue = "";

		// last_serve_by
		$this->last_serve_by->LinkCustomAttributes = "";
		$this->last_serve_by->HrefValue = "";
		$this->last_serve_by->TooltipValue = "";

		// query_by
		$this->query_by->LinkCustomAttributes = "";
		$this->query_by->HrefValue = "";
		$this->query_by->TooltipValue = "";

		// service_executive
		$this->service_executive->LinkCustomAttributes = "";
		$this->service_executive->HrefValue = "";
		$this->service_executive->TooltipValue = "";

		// Ins_service_executive
		$this->Ins_service_executive->LinkCustomAttributes = "";
		$this->Ins_service_executive->HrefValue = "";
		$this->Ins_service_executive->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// o_operator
		$this->o_operator->LinkCustomAttributes = "";
		$this->o_operator->HrefValue = "";
		$this->o_operator->TooltipValue = "";

		// o_datetime
		$this->o_datetime->LinkCustomAttributes = "";
		$this->o_datetime->HrefValue = "";
		$this->o_datetime->TooltipValue = "";

		// rid_1
		$this->rid_1->LinkCustomAttributes = "";
		$this->rid_1->HrefValue = "";
		$this->rid_1->TooltipValue = "";

		// master_reading
		$this->master_reading->LinkCustomAttributes = "";
		$this->master_reading->HrefValue = "";
		$this->master_reading->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->EditValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// buyer_id
		$this->buyer_id->EditAttrs["class"] = "form-control";
		$this->buyer_id->EditCustomAttributes = "";
		if ($this->buyer_id->VirtualValue <> "") {
			$this->buyer_id->EditValue = $this->buyer_id->VirtualValue;
		} else {
			$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
		$curVal = strval($this->buyer_id->CurrentValue);
		if ($curVal <> "") {
			$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
			if ($this->buyer_id->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`id` > 1000 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
				}
			}
		} else {
			$this->buyer_id->EditValue = NULL;
		}
		}
		$this->buyer_id->ViewCustomAttributes = "";

		// product_ref
		$this->product_ref->EditAttrs["class"] = "form-control";
		$this->product_ref->EditCustomAttributes = "";
		$curVal = strval($this->product_ref->CurrentValue);
		if ($curVal <> "") {
			$this->product_ref->EditValue = $this->product_ref->lookupCacheOption($curVal);
			if ($this->product_ref->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = $rswrk->fields('df4');
					$this->product_ref->EditValue = $this->product_ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_ref->EditValue = $this->product_ref->CurrentValue;
				}
			}
		} else {
			$this->product_ref->EditValue = NULL;
		}
		$this->product_ref->ViewCustomAttributes = "";

		// current_reading
		$this->current_reading->EditAttrs["class"] = "form-control";
		$this->current_reading->EditCustomAttributes = "";
		$this->current_reading->EditValue = $this->current_reading->CurrentValue;
		$this->current_reading->PlaceHolder = RemoveHtml($this->current_reading->caption());

		// product_status
		$this->product_status->EditAttrs["class"] = "form-control";
		$this->product_status->EditCustomAttributes = "";
		$curVal = strval($this->product_status->CurrentValue);
		if ($curVal <> "") {
			$this->product_status->EditValue = $this->product_status->lookupCacheOption($curVal);
			if ($this->product_status->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`grp` = 21 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product_status->EditValue = $this->product_status->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product_status->EditValue = $this->product_status->CurrentValue;
				}
			}
		} else {
			$this->product_status->EditValue = NULL;
		}
		$this->product_status->ViewCustomAttributes = "";

		// error
		$this->error->EditAttrs["class"] = "form-control";
		$this->error->EditCustomAttributes = "";
		$this->error->EditValue = $this->error->CurrentValue;
		$this->error->PlaceHolder = RemoveHtml($this->error->caption());

		// last_serve
		$this->last_serve->EditAttrs["class"] = "form-control";
		$this->last_serve->EditCustomAttributes = "";
		$this->last_serve->EditValue = $this->last_serve->CurrentValue;
		$this->last_serve->EditValue = FormatDateTime($this->last_serve->EditValue, 0);
		$this->last_serve->ViewCustomAttributes = "";

		// last_serve_by
		$this->last_serve_by->EditAttrs["class"] = "form-control";
		$this->last_serve_by->EditCustomAttributes = "";
		$curVal = strval($this->last_serve_by->CurrentValue);
		if ($curVal <> "") {
			$this->last_serve_by->EditValue = $this->last_serve_by->lookupCacheOption($curVal);
			if ($this->last_serve_by->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "FIND_IN_SET('92', `category`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->last_serve_by->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->last_serve_by->EditValue = $this->last_serve_by->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->last_serve_by->EditValue = $this->last_serve_by->CurrentValue;
				}
			}
		} else {
			$this->last_serve_by->EditValue = NULL;
		}
		$this->last_serve_by->ViewCustomAttributes = "";

		// query_by
		$this->query_by->EditAttrs["class"] = "form-control";
		$this->query_by->EditCustomAttributes = "";
		$this->query_by->EditValue = $this->query_by->CurrentValue;
		$this->query_by->ViewCustomAttributes = "";

		// service_executive
		$this->service_executive->EditAttrs["class"] = "form-control";
		$this->service_executive->EditCustomAttributes = "";

		// Ins_service_executive
		$this->Ins_service_executive->EditAttrs["class"] = "form-control";
		$this->Ins_service_executive->EditCustomAttributes = "";
		$this->Ins_service_executive->EditValue = $this->Ins_service_executive->CurrentValue;
		$this->Ins_service_executive->PlaceHolder = RemoveHtml($this->Ins_service_executive->caption());

		// operator
		// datetime
		// o_operator
		// o_datetime
		// rid_1

		$this->rid_1->EditAttrs["class"] = "form-control";
		$this->rid_1->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->rid_1->CurrentValue = HtmlDecode($this->rid_1->CurrentValue);
		$this->rid_1->EditValue = $this->rid_1->CurrentValue;
		$this->rid_1->PlaceHolder = RemoveHtml($this->rid_1->caption());

		// master_reading
		$this->master_reading->EditAttrs["class"] = "form-control";
		$this->master_reading->EditCustomAttributes = "";
		$this->master_reading->EditValue = $this->master_reading->CurrentValue;
		$this->master_reading->PlaceHolder = RemoveHtml($this->master_reading->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->product_ref);
					$doc->exportCaption($this->current_reading);
					$doc->exportCaption($this->product_status);
					$doc->exportCaption($this->error);
					$doc->exportCaption($this->last_serve);
					$doc->exportCaption($this->last_serve_by);
					$doc->exportCaption($this->query_by);
					$doc->exportCaption($this->service_executive);
					$doc->exportCaption($this->Ins_service_executive);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->o_operator);
					$doc->exportCaption($this->o_datetime);
					$doc->exportCaption($this->master_reading);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->buyer_id);
					$doc->exportCaption($this->product_ref);
					$doc->exportCaption($this->current_reading);
					$doc->exportCaption($this->product_status);
					$doc->exportCaption($this->last_serve);
					$doc->exportCaption($this->last_serve_by);
					$doc->exportCaption($this->query_by);
					$doc->exportCaption($this->service_executive);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->o_operator);
					$doc->exportCaption($this->o_datetime);
					$doc->exportCaption($this->master_reading);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->status);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->product_ref);
						$doc->exportField($this->current_reading);
						$doc->exportField($this->product_status);
						$doc->exportField($this->error);
						$doc->exportField($this->last_serve);
						$doc->exportField($this->last_serve_by);
						$doc->exportField($this->query_by);
						$doc->exportField($this->service_executive);
						$doc->exportField($this->Ins_service_executive);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->o_operator);
						$doc->exportField($this->o_datetime);
						$doc->exportField($this->master_reading);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->status);
						$doc->exportField($this->buyer_id);
						$doc->exportField($this->product_ref);
						$doc->exportField($this->current_reading);
						$doc->exportField($this->product_status);
						$doc->exportField($this->last_serve);
						$doc->exportField($this->last_serve_by);
						$doc->exportField($this->query_by);
						$doc->exportField($this->service_executive);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->o_operator);
						$doc->exportField($this->o_datetime);
						$doc->exportField($this->master_reading);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>