<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class service_request_add extends service_request
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'service_request';

	// Page object name
	public $PageObjName = "service_request_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (service_request)
		if (!isset($GLOBALS["service_request"]) || get_class($GLOBALS["service_request"]) == PROJECT_NAMESPACE . "service_request") {
			$GLOBALS["service_request"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["service_request"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'service_request');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $service_request;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($service_request);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "service_requestview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("service_requestlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->status->Visible = FALSE;
		$this->buyer_id->setVisibility();
		$this->product_ref->setVisibility();
		$this->current_reading->setVisibility();
		$this->product_status->setVisibility();
		$this->error->setVisibility();
		$this->last_serve->Visible = FALSE;
		$this->last_serve_by->Visible = FALSE;
		$this->query_by->setVisibility();
		$this->service_executive->Visible = FALSE;
		$this->Ins_service_executive->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->o_operator->Visible = FALSE;
		$this->o_datetime->Visible = FALSE;
		$this->rid_1->Visible = FALSE;
		$this->master_reading->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->product_ref);
		$this->setupLookupOptions($this->product_status);
		$this->setupLookupOptions($this->last_serve_by);
		$this->setupLookupOptions($this->service_executive);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("service_requestlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "service_requestlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "service_requestview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->status->CurrentValue = 0;
		$this->buyer_id->CurrentValue = NULL;
		$this->buyer_id->OldValue = $this->buyer_id->CurrentValue;
		$this->product_ref->CurrentValue = NULL;
		$this->product_ref->OldValue = $this->product_ref->CurrentValue;
		$this->current_reading->CurrentValue = NULL;
		$this->current_reading->OldValue = $this->current_reading->CurrentValue;
		$this->product_status->CurrentValue = NULL;
		$this->product_status->OldValue = $this->product_status->CurrentValue;
		$this->error->CurrentValue = NULL;
		$this->error->OldValue = $this->error->CurrentValue;
		$this->last_serve->CurrentValue = NULL;
		$this->last_serve->OldValue = $this->last_serve->CurrentValue;
		$this->last_serve_by->CurrentValue = NULL;
		$this->last_serve_by->OldValue = $this->last_serve_by->CurrentValue;
		$this->query_by->CurrentValue = NULL;
		$this->query_by->OldValue = $this->query_by->CurrentValue;
		$this->service_executive->CurrentValue = NULL;
		$this->service_executive->OldValue = $this->service_executive->CurrentValue;
		$this->Ins_service_executive->CurrentValue = NULL;
		$this->Ins_service_executive->OldValue = $this->Ins_service_executive->CurrentValue;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->o_operator->CurrentValue = NULL;
		$this->o_operator->OldValue = $this->o_operator->CurrentValue;
		$this->o_datetime->CurrentValue = NULL;
		$this->o_datetime->OldValue = $this->o_datetime->CurrentValue;
		$this->rid_1->CurrentValue = "--NA--";
		$this->master_reading->CurrentValue = 0;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'buyer_id' first before field var 'x_buyer_id'
		$val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
		if (!$this->buyer_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_id->setFormValue($val);
		}

		// Check field name 'product_ref' first before field var 'x_product_ref'
		$val = $CurrentForm->hasValue("product_ref") ? $CurrentForm->getValue("product_ref") : $CurrentForm->getValue("x_product_ref");
		if (!$this->product_ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_ref->Visible = FALSE; // Disable update for API request
			else
				$this->product_ref->setFormValue($val);
		}

		// Check field name 'current_reading' first before field var 'x_current_reading'
		$val = $CurrentForm->hasValue("current_reading") ? $CurrentForm->getValue("current_reading") : $CurrentForm->getValue("x_current_reading");
		if (!$this->current_reading->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->current_reading->Visible = FALSE; // Disable update for API request
			else
				$this->current_reading->setFormValue($val);
		}

		// Check field name 'product_status' first before field var 'x_product_status'
		$val = $CurrentForm->hasValue("product_status") ? $CurrentForm->getValue("product_status") : $CurrentForm->getValue("x_product_status");
		if (!$this->product_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_status->Visible = FALSE; // Disable update for API request
			else
				$this->product_status->setFormValue($val);
		}

		// Check field name 'error' first before field var 'x_error'
		$val = $CurrentForm->hasValue("error") ? $CurrentForm->getValue("error") : $CurrentForm->getValue("x_error");
		if (!$this->error->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->error->Visible = FALSE; // Disable update for API request
			else
				$this->error->setFormValue($val);
		}

		// Check field name 'query_by' first before field var 'x_query_by'
		$val = $CurrentForm->hasValue("query_by") ? $CurrentForm->getValue("query_by") : $CurrentForm->getValue("x_query_by");
		if (!$this->query_by->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->query_by->Visible = FALSE; // Disable update for API request
			else
				$this->query_by->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'master_reading' first before field var 'x_master_reading'
		$val = $CurrentForm->hasValue("master_reading") ? $CurrentForm->getValue("master_reading") : $CurrentForm->getValue("x_master_reading");
		if (!$this->master_reading->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->master_reading->Visible = FALSE; // Disable update for API request
			else
				$this->master_reading->setFormValue($val);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
		$this->product_ref->CurrentValue = $this->product_ref->FormValue;
		$this->current_reading->CurrentValue = $this->current_reading->FormValue;
		$this->product_status->CurrentValue = $this->product_status->FormValue;
		$this->error->CurrentValue = $this->error->FormValue;
		$this->query_by->CurrentValue = $this->query_by->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->master_reading->CurrentValue = $this->master_reading->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->status->setDbValue($row['status']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		if (array_key_exists('EV__buyer_id', $rs->fields)) {
			$this->buyer_id->VirtualValue = $rs->fields('EV__buyer_id'); // Set up virtual field value
		} else {
			$this->buyer_id->VirtualValue = ""; // Clear value
		}
		$this->product_ref->setDbValue($row['product_ref']);
		$this->current_reading->setDbValue($row['current_reading']);
		$this->product_status->setDbValue($row['product_status']);
		$this->error->setDbValue($row['error']);
		$this->last_serve->setDbValue($row['last_serve']);
		$this->last_serve_by->setDbValue($row['last_serve_by']);
		$this->query_by->setDbValue($row['query_by']);
		$this->service_executive->setDbValue($row['service_executive']);
		$this->Ins_service_executive->setDbValue($row['Ins_service_executive']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->o_operator->setDbValue($row['o_operator']);
		$this->o_datetime->setDbValue($row['o_datetime']);
		$this->rid_1->setDbValue($row['rid_1']);
		$this->master_reading->setDbValue($row['master_reading']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['buyer_id'] = $this->buyer_id->CurrentValue;
		$row['product_ref'] = $this->product_ref->CurrentValue;
		$row['current_reading'] = $this->current_reading->CurrentValue;
		$row['product_status'] = $this->product_status->CurrentValue;
		$row['error'] = $this->error->CurrentValue;
		$row['last_serve'] = $this->last_serve->CurrentValue;
		$row['last_serve_by'] = $this->last_serve_by->CurrentValue;
		$row['query_by'] = $this->query_by->CurrentValue;
		$row['service_executive'] = $this->service_executive->CurrentValue;
		$row['Ins_service_executive'] = $this->Ins_service_executive->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['o_operator'] = $this->o_operator->CurrentValue;
		$row['o_datetime'] = $this->o_datetime->CurrentValue;
		$row['rid_1'] = $this->rid_1->CurrentValue;
		$row['master_reading'] = $this->master_reading->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// status
		// buyer_id
		// product_ref
		// current_reading
		// product_status
		// error
		// last_serve
		// last_serve_by
		// query_by
		// service_executive
		// Ins_service_executive
		// operator
		// datetime
		// o_operator
		// o_datetime
		// rid_1
		// master_reading

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// buyer_id
			if ($this->buyer_id->VirtualValue <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->VirtualValue;
			} else {
				$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// product_ref
			$curVal = strval($this->product_ref->CurrentValue);
			if ($curVal <> "") {
				$this->product_ref->ViewValue = $this->product_ref->lookupCacheOption($curVal);
				if ($this->product_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->product_ref->ViewValue = $this->product_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_ref->ViewValue = $this->product_ref->CurrentValue;
					}
				}
			} else {
				$this->product_ref->ViewValue = NULL;
			}
			$this->product_ref->ViewCustomAttributes = "";

			// current_reading
			$this->current_reading->ViewValue = $this->current_reading->CurrentValue;
			$this->current_reading->ViewValue = FormatNumber($this->current_reading->ViewValue, 0, -2, -2, -2);
			$this->current_reading->ViewCustomAttributes = "";

			// product_status
			$curVal = strval($this->product_status->CurrentValue);
			if ($curVal <> "") {
				$this->product_status->ViewValue = $this->product_status->lookupCacheOption($curVal);
				if ($this->product_status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 21 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_status->ViewValue = $this->product_status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_status->ViewValue = $this->product_status->CurrentValue;
					}
				}
			} else {
				$this->product_status->ViewValue = NULL;
			}
			$this->product_status->ViewCustomAttributes = "";

			// error
			$this->error->ViewValue = $this->error->CurrentValue;
			$this->error->ViewCustomAttributes = "";

			// last_serve
			$this->last_serve->ViewValue = $this->last_serve->CurrentValue;
			$this->last_serve->ViewValue = FormatDateTime($this->last_serve->ViewValue, 0);
			$this->last_serve->ViewCustomAttributes = "";

			// last_serve_by
			$curVal = strval($this->last_serve_by->CurrentValue);
			if ($curVal <> "") {
				$this->last_serve_by->ViewValue = $this->last_serve_by->lookupCacheOption($curVal);
				if ($this->last_serve_by->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->last_serve_by->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->last_serve_by->ViewValue = $this->last_serve_by->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->last_serve_by->ViewValue = $this->last_serve_by->CurrentValue;
					}
				}
			} else {
				$this->last_serve_by->ViewValue = NULL;
			}
			$this->last_serve_by->ViewCustomAttributes = "";

			// query_by
			$this->query_by->ViewValue = $this->query_by->CurrentValue;
			$this->query_by->ViewCustomAttributes = "";

			// service_executive
			$curVal = strval($this->service_executive->CurrentValue);
			if ($curVal <> "") {
				$this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
				if ($this->service_executive->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->service_executive->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->service_executive->ViewValue = $this->service_executive->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->service_executive->ViewValue = $this->service_executive->CurrentValue;
					}
				}
			} else {
				$this->service_executive->ViewValue = NULL;
			}
			$this->service_executive->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// o_operator
			$this->o_operator->ViewValue = $this->o_operator->CurrentValue;
			$this->o_operator->ViewValue = FormatNumber($this->o_operator->ViewValue, 0, -2, -2, -2);
			$this->o_operator->ViewCustomAttributes = "";

			// o_datetime
			$this->o_datetime->ViewValue = $this->o_datetime->CurrentValue;
			$this->o_datetime->ViewValue = FormatDateTime($this->o_datetime->ViewValue, 0);
			$this->o_datetime->ViewCustomAttributes = "";

			// master_reading
			$this->master_reading->ViewValue = $this->master_reading->CurrentValue;
			$this->master_reading->ViewValue = FormatNumber($this->master_reading->ViewValue, 0, -2, -2, -2);
			$this->master_reading->ViewCustomAttributes = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// product_ref
			$this->product_ref->LinkCustomAttributes = "";
			$this->product_ref->HrefValue = "";
			$this->product_ref->TooltipValue = "";

			// current_reading
			$this->current_reading->LinkCustomAttributes = "";
			$this->current_reading->HrefValue = "";
			$this->current_reading->TooltipValue = "";

			// product_status
			$this->product_status->LinkCustomAttributes = "";
			$this->product_status->HrefValue = "";
			$this->product_status->TooltipValue = "";

			// error
			$this->error->LinkCustomAttributes = "";
			$this->error->HrefValue = "";
			$this->error->TooltipValue = "";

			// query_by
			$this->query_by->LinkCustomAttributes = "";
			$this->query_by->HrefValue = "";
			$this->query_by->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// master_reading
			$this->master_reading->LinkCustomAttributes = "";
			$this->master_reading->HrefValue = "";
			$this->master_reading->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$this->buyer_id->EditValue = HtmlEncode($this->buyer_id->CurrentValue);
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$arwrk[4] = HtmlEncode($rswrk->fields('df4'));
						$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->EditValue = HtmlEncode($this->buyer_id->CurrentValue);
					}
				}
			} else {
				$this->buyer_id->EditValue = NULL;
			}
			$this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

			// product_ref
			$this->product_ref->EditAttrs["class"] = "form-control";
			$this->product_ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_ref->CurrentValue));
			if ($curVal <> "")
				$this->product_ref->ViewValue = $this->product_ref->lookupCacheOption($curVal);
			else
				$this->product_ref->ViewValue = $this->product_ref->Lookup !== NULL && is_array($this->product_ref->Lookup->Options) ? $curVal : NULL;
			if ($this->product_ref->ViewValue !== NULL) { // Load from cache
				$this->product_ref->EditValue = array_values($this->product_ref->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_ref->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product_ref->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_ref->EditValue = $arwrk;
			}

			// current_reading
			$this->current_reading->EditAttrs["class"] = "form-control";
			$this->current_reading->EditCustomAttributes = "";
			$this->current_reading->EditValue = HtmlEncode($this->current_reading->CurrentValue);
			$this->current_reading->PlaceHolder = RemoveHtml($this->current_reading->caption());

			// product_status
			$this->product_status->EditAttrs["class"] = "form-control";
			$this->product_status->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_status->CurrentValue));
			if ($curVal <> "")
				$this->product_status->ViewValue = $this->product_status->lookupCacheOption($curVal);
			else
				$this->product_status->ViewValue = $this->product_status->Lookup !== NULL && is_array($this->product_status->Lookup->Options) ? $curVal : NULL;
			if ($this->product_status->ViewValue !== NULL) { // Load from cache
				$this->product_status->EditValue = array_values($this->product_status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_status->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 21 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_status->EditValue = $arwrk;
			}

			// error
			$this->error->EditAttrs["class"] = "form-control";
			$this->error->EditCustomAttributes = "";
			$this->error->EditValue = HtmlEncode($this->error->CurrentValue);
			$this->error->PlaceHolder = RemoveHtml($this->error->caption());

			// query_by
			$this->query_by->EditAttrs["class"] = "form-control";
			$this->query_by->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->query_by->CurrentValue = HtmlDecode($this->query_by->CurrentValue);
			$this->query_by->EditValue = HtmlEncode($this->query_by->CurrentValue);
			$this->query_by->PlaceHolder = RemoveHtml($this->query_by->caption());

			// operator
			// datetime
			// master_reading

			$this->master_reading->EditAttrs["class"] = "form-control";
			$this->master_reading->EditCustomAttributes = "";
			$this->master_reading->EditValue = HtmlEncode($this->master_reading->CurrentValue);
			$this->master_reading->PlaceHolder = RemoveHtml($this->master_reading->caption());

			// Add refer script
			// buyer_id

			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";

			// product_ref
			$this->product_ref->LinkCustomAttributes = "";
			$this->product_ref->HrefValue = "";

			// current_reading
			$this->current_reading->LinkCustomAttributes = "";
			$this->current_reading->HrefValue = "";

			// product_status
			$this->product_status->LinkCustomAttributes = "";
			$this->product_status->HrefValue = "";

			// error
			$this->error->LinkCustomAttributes = "";
			$this->error->HrefValue = "";

			// query_by
			$this->query_by->LinkCustomAttributes = "";
			$this->query_by->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// master_reading
			$this->master_reading->LinkCustomAttributes = "";
			$this->master_reading->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->buyer_id->Required) {
			if (!$this->buyer_id->IsDetailKey && $this->buyer_id->FormValue != NULL && $this->buyer_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
			}
		}
		if ($this->product_ref->Required) {
			if (!$this->product_ref->IsDetailKey && $this->product_ref->FormValue != NULL && $this->product_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_ref->caption(), $this->product_ref->RequiredErrorMessage));
			}
		}
		if ($this->current_reading->Required) {
			if (!$this->current_reading->IsDetailKey && $this->current_reading->FormValue != NULL && $this->current_reading->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->current_reading->caption(), $this->current_reading->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->current_reading->FormValue)) {
			AddMessage($FormError, $this->current_reading->errorMessage());
		}
		if ($this->product_status->Required) {
			if (!$this->product_status->IsDetailKey && $this->product_status->FormValue != NULL && $this->product_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_status->caption(), $this->product_status->RequiredErrorMessage));
			}
		}
		if ($this->error->Required) {
			if (!$this->error->IsDetailKey && $this->error->FormValue != NULL && $this->error->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->error->caption(), $this->error->RequiredErrorMessage));
			}
		}
		if ($this->last_serve->Required) {
			if (!$this->last_serve->IsDetailKey && $this->last_serve->FormValue != NULL && $this->last_serve->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->last_serve->caption(), $this->last_serve->RequiredErrorMessage));
			}
		}
		if ($this->last_serve_by->Required) {
			if (!$this->last_serve_by->IsDetailKey && $this->last_serve_by->FormValue != NULL && $this->last_serve_by->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->last_serve_by->caption(), $this->last_serve_by->RequiredErrorMessage));
			}
		}
		if ($this->query_by->Required) {
			if (!$this->query_by->IsDetailKey && $this->query_by->FormValue != NULL && $this->query_by->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->query_by->caption(), $this->query_by->RequiredErrorMessage));
			}
		}
		if ($this->service_executive->Required) {
			if (!$this->service_executive->IsDetailKey && $this->service_executive->FormValue != NULL && $this->service_executive->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->service_executive->caption(), $this->service_executive->RequiredErrorMessage));
			}
		}
		if ($this->Ins_service_executive->Required) {
			if (!$this->Ins_service_executive->IsDetailKey && $this->Ins_service_executive->FormValue != NULL && $this->Ins_service_executive->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Ins_service_executive->caption(), $this->Ins_service_executive->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->o_operator->Required) {
			if (!$this->o_operator->IsDetailKey && $this->o_operator->FormValue != NULL && $this->o_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->o_operator->caption(), $this->o_operator->RequiredErrorMessage));
			}
		}
		if ($this->o_datetime->Required) {
			if (!$this->o_datetime->IsDetailKey && $this->o_datetime->FormValue != NULL && $this->o_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->o_datetime->caption(), $this->o_datetime->RequiredErrorMessage));
			}
		}
		if ($this->rid_1->Required) {
			if (!$this->rid_1->IsDetailKey && $this->rid_1->FormValue != NULL && $this->rid_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_1->caption(), $this->rid_1->RequiredErrorMessage));
			}
		}
		if ($this->master_reading->Required) {
			if (!$this->master_reading->IsDetailKey && $this->master_reading->FormValue != NULL && $this->master_reading->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->master_reading->caption(), $this->master_reading->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->master_reading->FormValue)) {
			AddMessage($FormError, $this->master_reading->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// buyer_id
		$this->buyer_id->setDbValueDef($rsnew, $this->buyer_id->CurrentValue, 0, FALSE);

		// product_ref
		$this->product_ref->setDbValueDef($rsnew, $this->product_ref->CurrentValue, NULL, FALSE);

		// current_reading
		$this->current_reading->setDbValueDef($rsnew, $this->current_reading->CurrentValue, 0, FALSE);

		// product_status
		$this->product_status->setDbValueDef($rsnew, $this->product_status->CurrentValue, NULL, strval($this->product_status->CurrentValue) == "");

		// error
		$this->error->setDbValueDef($rsnew, $this->error->CurrentValue, NULL, FALSE);

		// query_by
		$this->query_by->setDbValueDef($rsnew, $this->query_by->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// master_reading
		$this->master_reading->setDbValueDef($rsnew, $this->master_reading->CurrentValue, 0, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("service_requestlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`id` > 1000 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_status":
					$lookupFilter = function() {
						return "`grp` = 21 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_last_serve_by":
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_service_executive":
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_product_ref":
							break;
						case "x_product_status":
							break;
						case "x_last_serve_by":
							break;
						case "x_service_executive":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>