<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class service_request_edit extends service_request
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'service_request';

	// Page object name
	public $PageObjName = "service_request_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (service_request)
		if (!isset($GLOBALS["service_request"]) || get_class($GLOBALS["service_request"]) == PROJECT_NAMESPACE . "service_request") {
			$GLOBALS["service_request"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["service_request"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'service_request');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $service_request;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($service_request);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "service_requestview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("service_requestlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->status->setVisibility();
		$this->buyer_id->setVisibility();
		$this->product_ref->setVisibility();
		$this->current_reading->setVisibility();
		$this->product_status->setVisibility();
		$this->error->setVisibility();
		$this->last_serve->setVisibility();
		$this->last_serve_by->setVisibility();
		$this->query_by->setVisibility();
		$this->service_executive->setVisibility();
		$this->Ins_service_executive->setVisibility();
		$this->operator->Visible = FALSE;
		$this->datetime->Visible = FALSE;
		$this->o_operator->setVisibility();
		$this->o_datetime->setVisibility();
		$this->rid_1->Visible = FALSE;
		$this->master_reading->setVisibility();
		$this->hideFieldsForAddEdit();
		$this->buyer_id->Required = FALSE;
		$this->product_ref->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->product_ref);
		$this->setupLookupOptions($this->product_status);
		$this->setupLookupOptions($this->last_serve_by);
		$this->setupLookupOptions($this->service_executive);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("service_requestlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "service_requestlist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'buyer_id' first before field var 'x_buyer_id'
		$val = $CurrentForm->hasValue("buyer_id") ? $CurrentForm->getValue("buyer_id") : $CurrentForm->getValue("x_buyer_id");
		if (!$this->buyer_id->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer_id->Visible = FALSE; // Disable update for API request
			else
				$this->buyer_id->setFormValue($val);
		}

		// Check field name 'product_ref' first before field var 'x_product_ref'
		$val = $CurrentForm->hasValue("product_ref") ? $CurrentForm->getValue("product_ref") : $CurrentForm->getValue("x_product_ref");
		if (!$this->product_ref->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_ref->Visible = FALSE; // Disable update for API request
			else
				$this->product_ref->setFormValue($val);
		}

		// Check field name 'current_reading' first before field var 'x_current_reading'
		$val = $CurrentForm->hasValue("current_reading") ? $CurrentForm->getValue("current_reading") : $CurrentForm->getValue("x_current_reading");
		if (!$this->current_reading->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->current_reading->Visible = FALSE; // Disable update for API request
			else
				$this->current_reading->setFormValue($val);
		}

		// Check field name 'product_status' first before field var 'x_product_status'
		$val = $CurrentForm->hasValue("product_status") ? $CurrentForm->getValue("product_status") : $CurrentForm->getValue("x_product_status");
		if (!$this->product_status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->product_status->Visible = FALSE; // Disable update for API request
			else
				$this->product_status->setFormValue($val);
		}

		// Check field name 'error' first before field var 'x_error'
		$val = $CurrentForm->hasValue("error") ? $CurrentForm->getValue("error") : $CurrentForm->getValue("x_error");
		if (!$this->error->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->error->Visible = FALSE; // Disable update for API request
			else
				$this->error->setFormValue($val);
		}

		// Check field name 'last_serve' first before field var 'x_last_serve'
		$val = $CurrentForm->hasValue("last_serve") ? $CurrentForm->getValue("last_serve") : $CurrentForm->getValue("x_last_serve");
		if (!$this->last_serve->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->last_serve->Visible = FALSE; // Disable update for API request
			else
				$this->last_serve->setFormValue($val);
			$this->last_serve->CurrentValue = UnFormatDateTime($this->last_serve->CurrentValue, 0);
		}

		// Check field name 'last_serve_by' first before field var 'x_last_serve_by'
		$val = $CurrentForm->hasValue("last_serve_by") ? $CurrentForm->getValue("last_serve_by") : $CurrentForm->getValue("x_last_serve_by");
		if (!$this->last_serve_by->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->last_serve_by->Visible = FALSE; // Disable update for API request
			else
				$this->last_serve_by->setFormValue($val);
		}

		// Check field name 'query_by' first before field var 'x_query_by'
		$val = $CurrentForm->hasValue("query_by") ? $CurrentForm->getValue("query_by") : $CurrentForm->getValue("x_query_by");
		if (!$this->query_by->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->query_by->Visible = FALSE; // Disable update for API request
			else
				$this->query_by->setFormValue($val);
		}

		// Check field name 'service_executive' first before field var 'x_service_executive'
		$val = $CurrentForm->hasValue("service_executive") ? $CurrentForm->getValue("service_executive") : $CurrentForm->getValue("x_service_executive");
		if (!$this->service_executive->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->service_executive->Visible = FALSE; // Disable update for API request
			else
				$this->service_executive->setFormValue($val);
		}

		// Check field name 'Ins_service_executive' first before field var 'x_Ins_service_executive'
		$val = $CurrentForm->hasValue("Ins_service_executive") ? $CurrentForm->getValue("Ins_service_executive") : $CurrentForm->getValue("x_Ins_service_executive");
		if (!$this->Ins_service_executive->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->Ins_service_executive->Visible = FALSE; // Disable update for API request
			else
				$this->Ins_service_executive->setFormValue($val);
		}

		// Check field name 'o_operator' first before field var 'x_o_operator'
		$val = $CurrentForm->hasValue("o_operator") ? $CurrentForm->getValue("o_operator") : $CurrentForm->getValue("x_o_operator");
		if (!$this->o_operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->o_operator->Visible = FALSE; // Disable update for API request
			else
				$this->o_operator->setFormValue($val);
		}

		// Check field name 'o_datetime' first before field var 'x_o_datetime'
		$val = $CurrentForm->hasValue("o_datetime") ? $CurrentForm->getValue("o_datetime") : $CurrentForm->getValue("x_o_datetime");
		if (!$this->o_datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->o_datetime->Visible = FALSE; // Disable update for API request
			else
				$this->o_datetime->setFormValue($val);
			$this->o_datetime->CurrentValue = UnFormatDateTime($this->o_datetime->CurrentValue, 0);
		}

		// Check field name 'master_reading' first before field var 'x_master_reading'
		$val = $CurrentForm->hasValue("master_reading") ? $CurrentForm->getValue("master_reading") : $CurrentForm->getValue("x_master_reading");
		if (!$this->master_reading->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->master_reading->Visible = FALSE; // Disable update for API request
			else
				$this->master_reading->setFormValue($val);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->buyer_id->CurrentValue = $this->buyer_id->FormValue;
		$this->product_ref->CurrentValue = $this->product_ref->FormValue;
		$this->current_reading->CurrentValue = $this->current_reading->FormValue;
		$this->product_status->CurrentValue = $this->product_status->FormValue;
		$this->error->CurrentValue = $this->error->FormValue;
		$this->last_serve->CurrentValue = $this->last_serve->FormValue;
		$this->last_serve->CurrentValue = UnFormatDateTime($this->last_serve->CurrentValue, 0);
		$this->last_serve_by->CurrentValue = $this->last_serve_by->FormValue;
		$this->query_by->CurrentValue = $this->query_by->FormValue;
		$this->service_executive->CurrentValue = $this->service_executive->FormValue;
		$this->Ins_service_executive->CurrentValue = $this->Ins_service_executive->FormValue;
		$this->o_operator->CurrentValue = $this->o_operator->FormValue;
		$this->o_datetime->CurrentValue = $this->o_datetime->FormValue;
		$this->o_datetime->CurrentValue = UnFormatDateTime($this->o_datetime->CurrentValue, 0);
		$this->master_reading->CurrentValue = $this->master_reading->FormValue;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->status->setDbValue($row['status']);
		$this->buyer_id->setDbValue($row['buyer_id']);
		if (array_key_exists('EV__buyer_id', $rs->fields)) {
			$this->buyer_id->VirtualValue = $rs->fields('EV__buyer_id'); // Set up virtual field value
		} else {
			$this->buyer_id->VirtualValue = ""; // Clear value
		}
		$this->product_ref->setDbValue($row['product_ref']);
		$this->current_reading->setDbValue($row['current_reading']);
		$this->product_status->setDbValue($row['product_status']);
		$this->error->setDbValue($row['error']);
		$this->last_serve->setDbValue($row['last_serve']);
		$this->last_serve_by->setDbValue($row['last_serve_by']);
		$this->query_by->setDbValue($row['query_by']);
		$this->service_executive->setDbValue($row['service_executive']);
		$this->Ins_service_executive->setDbValue($row['Ins_service_executive']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->o_operator->setDbValue($row['o_operator']);
		$this->o_datetime->setDbValue($row['o_datetime']);
		$this->rid_1->setDbValue($row['rid_1']);
		$this->master_reading->setDbValue($row['master_reading']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['status'] = NULL;
		$row['buyer_id'] = NULL;
		$row['product_ref'] = NULL;
		$row['current_reading'] = NULL;
		$row['product_status'] = NULL;
		$row['error'] = NULL;
		$row['last_serve'] = NULL;
		$row['last_serve_by'] = NULL;
		$row['query_by'] = NULL;
		$row['service_executive'] = NULL;
		$row['Ins_service_executive'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['o_operator'] = NULL;
		$row['o_datetime'] = NULL;
		$row['rid_1'] = NULL;
		$row['master_reading'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// status
		// buyer_id
		// product_ref
		// current_reading
		// product_status
		// error
		// last_serve
		// last_serve_by
		// query_by
		// service_executive
		// Ins_service_executive
		// operator
		// datetime
		// o_operator
		// o_datetime
		// rid_1
		// master_reading

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// buyer_id
			if ($this->buyer_id->VirtualValue <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->VirtualValue;
			} else {
				$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// product_ref
			$curVal = strval($this->product_ref->CurrentValue);
			if ($curVal <> "") {
				$this->product_ref->ViewValue = $this->product_ref->lookupCacheOption($curVal);
				if ($this->product_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->product_ref->ViewValue = $this->product_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_ref->ViewValue = $this->product_ref->CurrentValue;
					}
				}
			} else {
				$this->product_ref->ViewValue = NULL;
			}
			$this->product_ref->ViewCustomAttributes = "";

			// current_reading
			$this->current_reading->ViewValue = $this->current_reading->CurrentValue;
			$this->current_reading->ViewValue = FormatNumber($this->current_reading->ViewValue, 0, -2, -2, -2);
			$this->current_reading->ViewCustomAttributes = "";

			// product_status
			$curVal = strval($this->product_status->CurrentValue);
			if ($curVal <> "") {
				$this->product_status->ViewValue = $this->product_status->lookupCacheOption($curVal);
				if ($this->product_status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 21 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_status->ViewValue = $this->product_status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_status->ViewValue = $this->product_status->CurrentValue;
					}
				}
			} else {
				$this->product_status->ViewValue = NULL;
			}
			$this->product_status->ViewCustomAttributes = "";

			// error
			$this->error->ViewValue = $this->error->CurrentValue;
			$this->error->ViewCustomAttributes = "";

			// last_serve
			$this->last_serve->ViewValue = $this->last_serve->CurrentValue;
			$this->last_serve->ViewValue = FormatDateTime($this->last_serve->ViewValue, 0);
			$this->last_serve->ViewCustomAttributes = "";

			// last_serve_by
			$curVal = strval($this->last_serve_by->CurrentValue);
			if ($curVal <> "") {
				$this->last_serve_by->ViewValue = $this->last_serve_by->lookupCacheOption($curVal);
				if ($this->last_serve_by->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->last_serve_by->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->last_serve_by->ViewValue = $this->last_serve_by->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->last_serve_by->ViewValue = $this->last_serve_by->CurrentValue;
					}
				}
			} else {
				$this->last_serve_by->ViewValue = NULL;
			}
			$this->last_serve_by->ViewCustomAttributes = "";

			// query_by
			$this->query_by->ViewValue = $this->query_by->CurrentValue;
			$this->query_by->ViewCustomAttributes = "";

			// service_executive
			$curVal = strval($this->service_executive->CurrentValue);
			if ($curVal <> "") {
				$this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
				if ($this->service_executive->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->service_executive->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->service_executive->ViewValue = $this->service_executive->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->service_executive->ViewValue = $this->service_executive->CurrentValue;
					}
				}
			} else {
				$this->service_executive->ViewValue = NULL;
			}
			$this->service_executive->ViewCustomAttributes = "";

			// Ins_service_executive
			$this->Ins_service_executive->ViewValue = $this->Ins_service_executive->CurrentValue;
			$this->Ins_service_executive->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// o_operator
			$this->o_operator->ViewValue = $this->o_operator->CurrentValue;
			$this->o_operator->ViewValue = FormatNumber($this->o_operator->ViewValue, 0, -2, -2, -2);
			$this->o_operator->ViewCustomAttributes = "";

			// o_datetime
			$this->o_datetime->ViewValue = $this->o_datetime->CurrentValue;
			$this->o_datetime->ViewValue = FormatDateTime($this->o_datetime->ViewValue, 0);
			$this->o_datetime->ViewCustomAttributes = "";

			// master_reading
			$this->master_reading->ViewValue = $this->master_reading->CurrentValue;
			$this->master_reading->ViewValue = FormatNumber($this->master_reading->ViewValue, 0, -2, -2, -2);
			$this->master_reading->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// product_ref
			$this->product_ref->LinkCustomAttributes = "";
			$this->product_ref->HrefValue = "";
			$this->product_ref->TooltipValue = "";

			// current_reading
			$this->current_reading->LinkCustomAttributes = "";
			$this->current_reading->HrefValue = "";
			$this->current_reading->TooltipValue = "";

			// product_status
			$this->product_status->LinkCustomAttributes = "";
			$this->product_status->HrefValue = "";
			$this->product_status->TooltipValue = "";

			// error
			$this->error->LinkCustomAttributes = "";
			$this->error->HrefValue = "";
			$this->error->TooltipValue = "";

			// last_serve
			$this->last_serve->LinkCustomAttributes = "";
			$this->last_serve->HrefValue = "";
			$this->last_serve->TooltipValue = "";

			// last_serve_by
			$this->last_serve_by->LinkCustomAttributes = "";
			$this->last_serve_by->HrefValue = "";
			$this->last_serve_by->TooltipValue = "";

			// query_by
			$this->query_by->LinkCustomAttributes = "";
			$this->query_by->HrefValue = "";
			$this->query_by->TooltipValue = "";

			// service_executive
			$this->service_executive->LinkCustomAttributes = "";
			$this->service_executive->HrefValue = "";
			$this->service_executive->TooltipValue = "";

			// Ins_service_executive
			$this->Ins_service_executive->LinkCustomAttributes = "";
			$this->Ins_service_executive->HrefValue = "";
			$this->Ins_service_executive->TooltipValue = "";

			// o_operator
			$this->o_operator->LinkCustomAttributes = "";
			$this->o_operator->HrefValue = "";
			$this->o_operator->TooltipValue = "";

			// o_datetime
			$this->o_datetime->LinkCustomAttributes = "";
			$this->o_datetime->HrefValue = "";
			$this->o_datetime->TooltipValue = "";

			// master_reading
			$this->master_reading->LinkCustomAttributes = "";
			$this->master_reading->HrefValue = "";
			$this->master_reading->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->EditValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			if ($this->buyer_id->VirtualValue <> "") {
				$this->buyer_id->EditValue = $this->buyer_id->VirtualValue;
			} else {
				$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->EditValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->buyer_id->EditValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->EditValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->EditValue = NULL;
			}
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// product_ref
			$this->product_ref->EditAttrs["class"] = "form-control";
			$this->product_ref->EditCustomAttributes = "";
			$curVal = strval($this->product_ref->CurrentValue);
			if ($curVal <> "") {
				$this->product_ref->EditValue = $this->product_ref->lookupCacheOption($curVal);
				if ($this->product_ref->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->product_ref->EditValue = $this->product_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_ref->EditValue = $this->product_ref->CurrentValue;
					}
				}
			} else {
				$this->product_ref->EditValue = NULL;
			}
			$this->product_ref->ViewCustomAttributes = "";

			// current_reading
			$this->current_reading->EditAttrs["class"] = "form-control";
			$this->current_reading->EditCustomAttributes = "";
			$this->current_reading->EditValue = HtmlEncode($this->current_reading->CurrentValue);
			$this->current_reading->PlaceHolder = RemoveHtml($this->current_reading->caption());

			// product_status
			$this->product_status->EditAttrs["class"] = "form-control";
			$this->product_status->EditCustomAttributes = "";
			$curVal = strval($this->product_status->CurrentValue);
			if ($curVal <> "") {
				$this->product_status->EditValue = $this->product_status->lookupCacheOption($curVal);
				if ($this->product_status->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 21 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_status->EditValue = $this->product_status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_status->EditValue = $this->product_status->CurrentValue;
					}
				}
			} else {
				$this->product_status->EditValue = NULL;
			}
			$this->product_status->ViewCustomAttributes = "";

			// error
			$this->error->EditAttrs["class"] = "form-control";
			$this->error->EditCustomAttributes = "";
			$this->error->EditValue = HtmlEncode($this->error->CurrentValue);
			$this->error->PlaceHolder = RemoveHtml($this->error->caption());

			// last_serve
			$this->last_serve->EditAttrs["class"] = "form-control";
			$this->last_serve->EditCustomAttributes = "";
			$this->last_serve->EditValue = $this->last_serve->CurrentValue;
			$this->last_serve->EditValue = FormatDateTime($this->last_serve->EditValue, 0);
			$this->last_serve->ViewCustomAttributes = "";

			// last_serve_by
			$this->last_serve_by->EditAttrs["class"] = "form-control";
			$this->last_serve_by->EditCustomAttributes = "";
			$curVal = strval($this->last_serve_by->CurrentValue);
			if ($curVal <> "") {
				$this->last_serve_by->EditValue = $this->last_serve_by->lookupCacheOption($curVal);
				if ($this->last_serve_by->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->last_serve_by->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->last_serve_by->EditValue = $this->last_serve_by->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->last_serve_by->EditValue = $this->last_serve_by->CurrentValue;
					}
				}
			} else {
				$this->last_serve_by->EditValue = NULL;
			}
			$this->last_serve_by->ViewCustomAttributes = "";

			// query_by
			$this->query_by->EditAttrs["class"] = "form-control";
			$this->query_by->EditCustomAttributes = "";
			$this->query_by->EditValue = $this->query_by->CurrentValue;
			$this->query_by->ViewCustomAttributes = "";

			// service_executive
			$this->service_executive->EditAttrs["class"] = "form-control";
			$this->service_executive->EditCustomAttributes = "";
			$curVal = trim(strval($this->service_executive->CurrentValue));
			if ($curVal <> "")
				$this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
			else
				$this->service_executive->ViewValue = $this->service_executive->Lookup !== NULL && is_array($this->service_executive->Lookup->Options) ? $curVal : NULL;
			if ($this->service_executive->ViewValue !== NULL) { // Load from cache
				$this->service_executive->EditValue = array_values($this->service_executive->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->service_executive->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "FIND_IN_SET('92', `category`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->service_executive->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->service_executive->EditValue = $arwrk;
			}

			// Ins_service_executive
			$this->Ins_service_executive->EditAttrs["class"] = "form-control";
			$this->Ins_service_executive->EditCustomAttributes = "";
			$this->Ins_service_executive->EditValue = HtmlEncode($this->Ins_service_executive->CurrentValue);
			$this->Ins_service_executive->PlaceHolder = RemoveHtml($this->Ins_service_executive->caption());

			// o_operator
			// o_datetime
			// master_reading

			$this->master_reading->EditAttrs["class"] = "form-control";
			$this->master_reading->EditCustomAttributes = "";
			$this->master_reading->EditValue = HtmlEncode($this->master_reading->CurrentValue);
			$this->master_reading->PlaceHolder = RemoveHtml($this->master_reading->caption());

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// product_ref
			$this->product_ref->LinkCustomAttributes = "";
			$this->product_ref->HrefValue = "";
			$this->product_ref->TooltipValue = "";

			// current_reading
			$this->current_reading->LinkCustomAttributes = "";
			$this->current_reading->HrefValue = "";

			// product_status
			$this->product_status->LinkCustomAttributes = "";
			$this->product_status->HrefValue = "";
			$this->product_status->TooltipValue = "";

			// error
			$this->error->LinkCustomAttributes = "";
			$this->error->HrefValue = "";

			// last_serve
			$this->last_serve->LinkCustomAttributes = "";
			$this->last_serve->HrefValue = "";
			$this->last_serve->TooltipValue = "";

			// last_serve_by
			$this->last_serve_by->LinkCustomAttributes = "";
			$this->last_serve_by->HrefValue = "";
			$this->last_serve_by->TooltipValue = "";

			// query_by
			$this->query_by->LinkCustomAttributes = "";
			$this->query_by->HrefValue = "";
			$this->query_by->TooltipValue = "";

			// service_executive
			$this->service_executive->LinkCustomAttributes = "";
			$this->service_executive->HrefValue = "";

			// Ins_service_executive
			$this->Ins_service_executive->LinkCustomAttributes = "";
			$this->Ins_service_executive->HrefValue = "";

			// o_operator
			$this->o_operator->LinkCustomAttributes = "";
			$this->o_operator->HrefValue = "";

			// o_datetime
			$this->o_datetime->LinkCustomAttributes = "";
			$this->o_datetime->HrefValue = "";

			// master_reading
			$this->master_reading->LinkCustomAttributes = "";
			$this->master_reading->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->buyer_id->Required) {
			if (!$this->buyer_id->IsDetailKey && $this->buyer_id->FormValue != NULL && $this->buyer_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer_id->caption(), $this->buyer_id->RequiredErrorMessage));
			}
		}
		if ($this->product_ref->Required) {
			if (!$this->product_ref->IsDetailKey && $this->product_ref->FormValue != NULL && $this->product_ref->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_ref->caption(), $this->product_ref->RequiredErrorMessage));
			}
		}
		if ($this->current_reading->Required) {
			if (!$this->current_reading->IsDetailKey && $this->current_reading->FormValue != NULL && $this->current_reading->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->current_reading->caption(), $this->current_reading->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->current_reading->FormValue)) {
			AddMessage($FormError, $this->current_reading->errorMessage());
		}
		if ($this->product_status->Required) {
			if (!$this->product_status->IsDetailKey && $this->product_status->FormValue != NULL && $this->product_status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product_status->caption(), $this->product_status->RequiredErrorMessage));
			}
		}
		if ($this->error->Required) {
			if (!$this->error->IsDetailKey && $this->error->FormValue != NULL && $this->error->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->error->caption(), $this->error->RequiredErrorMessage));
			}
		}
		if ($this->last_serve->Required) {
			if (!$this->last_serve->IsDetailKey && $this->last_serve->FormValue != NULL && $this->last_serve->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->last_serve->caption(), $this->last_serve->RequiredErrorMessage));
			}
		}
		if ($this->last_serve_by->Required) {
			if (!$this->last_serve_by->IsDetailKey && $this->last_serve_by->FormValue != NULL && $this->last_serve_by->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->last_serve_by->caption(), $this->last_serve_by->RequiredErrorMessage));
			}
		}
		if ($this->query_by->Required) {
			if (!$this->query_by->IsDetailKey && $this->query_by->FormValue != NULL && $this->query_by->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->query_by->caption(), $this->query_by->RequiredErrorMessage));
			}
		}
		if ($this->service_executive->Required) {
			if (!$this->service_executive->IsDetailKey && $this->service_executive->FormValue != NULL && $this->service_executive->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->service_executive->caption(), $this->service_executive->RequiredErrorMessage));
			}
		}
		if ($this->Ins_service_executive->Required) {
			if (!$this->Ins_service_executive->IsDetailKey && $this->Ins_service_executive->FormValue != NULL && $this->Ins_service_executive->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Ins_service_executive->caption(), $this->Ins_service_executive->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->o_operator->Required) {
			if (!$this->o_operator->IsDetailKey && $this->o_operator->FormValue != NULL && $this->o_operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->o_operator->caption(), $this->o_operator->RequiredErrorMessage));
			}
		}
		if ($this->o_datetime->Required) {
			if (!$this->o_datetime->IsDetailKey && $this->o_datetime->FormValue != NULL && $this->o_datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->o_datetime->caption(), $this->o_datetime->RequiredErrorMessage));
			}
		}
		if ($this->rid_1->Required) {
			if (!$this->rid_1->IsDetailKey && $this->rid_1->FormValue != NULL && $this->rid_1->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid_1->caption(), $this->rid_1->RequiredErrorMessage));
			}
		}
		if ($this->master_reading->Required) {
			if (!$this->master_reading->IsDetailKey && $this->master_reading->FormValue != NULL && $this->master_reading->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->master_reading->caption(), $this->master_reading->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->master_reading->FormValue)) {
			AddMessage($FormError, $this->master_reading->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// current_reading
			$this->current_reading->setDbValueDef($rsnew, $this->current_reading->CurrentValue, 0, $this->current_reading->ReadOnly);

			// error
			$this->error->setDbValueDef($rsnew, $this->error->CurrentValue, NULL, $this->error->ReadOnly);

			// service_executive
			$this->service_executive->setDbValueDef($rsnew, $this->service_executive->CurrentValue, 0, $this->service_executive->ReadOnly);

			// Ins_service_executive
			$this->Ins_service_executive->setDbValueDef($rsnew, $this->Ins_service_executive->CurrentValue, "", $this->Ins_service_executive->ReadOnly);

			// o_operator
			$this->o_operator->setDbValueDef($rsnew, CurrentUserID(), 0);
			$rsnew['o_operator'] = &$this->o_operator->DbValue;

			// o_datetime
			$this->o_datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['o_datetime'] = &$this->o_datetime->DbValue;

			// master_reading
			$this->master_reading->setDbValueDef($rsnew, $this->master_reading->CurrentValue, 0, $this->master_reading->ReadOnly);

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("service_requestlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`id` > 1000 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_status":
					$lookupFilter = function() {
						return "`grp` = 21 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_last_serve_by":
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_service_executive":
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_product_ref":
							break;
						case "x_product_status":
							break;
						case "x_last_serve_by":
							break;
						case "x_service_executive":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>