<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class service_request_search extends service_request
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'service_request';

	// Page object name
	public $PageObjName = "service_request_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (service_request)
		if (!isset($GLOBALS["service_request"]) || get_class($GLOBALS["service_request"]) == PROJECT_NAMESPACE . "service_request") {
			$GLOBALS["service_request"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["service_request"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'service_request');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $service_request;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($service_request);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "service_requestview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("service_requestlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->status->setVisibility();
		$this->buyer_id->setVisibility();
		$this->product_ref->setVisibility();
		$this->current_reading->setVisibility();
		$this->product_status->setVisibility();
		$this->error->setVisibility();
		$this->last_serve->setVisibility();
		$this->last_serve_by->setVisibility();
		$this->query_by->setVisibility();
		$this->service_executive->setVisibility();
		$this->Ins_service_executive->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->o_operator->setVisibility();
		$this->o_datetime->setVisibility();
		$this->rid_1->Visible = FALSE;
		$this->master_reading->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->buyer_id);
		$this->setupLookupOptions($this->product_ref);
		$this->setupLookupOptions($this->product_status);
		$this->setupLookupOptions($this->last_serve_by);
		$this->setupLookupOptions($this->service_executive);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "service_requestlist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->buyer_id); // buyer_id
		$this->buildSearchUrl($srchUrl, $this->product_ref); // product_ref
		$this->buildSearchUrl($srchUrl, $this->current_reading); // current_reading
		$this->buildSearchUrl($srchUrl, $this->product_status); // product_status
		$this->buildSearchUrl($srchUrl, $this->error); // error
		$this->buildSearchUrl($srchUrl, $this->last_serve); // last_serve
		$this->buildSearchUrl($srchUrl, $this->last_serve_by); // last_serve_by
		$this->buildSearchUrl($srchUrl, $this->query_by); // query_by
		$this->buildSearchUrl($srchUrl, $this->service_executive); // service_executive
		$this->buildSearchUrl($srchUrl, $this->Ins_service_executive); // Ins_service_executive
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		$this->buildSearchUrl($srchUrl, $this->o_operator); // o_operator
		$this->buildSearchUrl($srchUrl, $this->o_datetime); // o_datetime
		$this->buildSearchUrl($srchUrl, $this->master_reading); // master_reading
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// buyer_id
		if (!$this->isAddOrEdit())
			$this->buyer_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer_id"));
		$this->buyer_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer_id"));

		// product_ref
		if (!$this->isAddOrEdit())
			$this->product_ref->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_ref"));
		$this->product_ref->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_ref"));

		// current_reading
		if (!$this->isAddOrEdit())
			$this->current_reading->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_current_reading"));
		$this->current_reading->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_current_reading"));

		// product_status
		if (!$this->isAddOrEdit())
			$this->product_status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_status"));
		$this->product_status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_status"));

		// error
		if (!$this->isAddOrEdit())
			$this->error->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_error"));
		$this->error->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_error"));

		// last_serve
		if (!$this->isAddOrEdit())
			$this->last_serve->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_last_serve"));
		$this->last_serve->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_last_serve"));

		// last_serve_by
		if (!$this->isAddOrEdit())
			$this->last_serve_by->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_last_serve_by"));
		$this->last_serve_by->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_last_serve_by"));

		// query_by
		if (!$this->isAddOrEdit())
			$this->query_by->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_query_by"));
		$this->query_by->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_query_by"));

		// service_executive
		if (!$this->isAddOrEdit())
			$this->service_executive->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_service_executive"));
		$this->service_executive->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_service_executive"));

		// Ins_service_executive
		if (!$this->isAddOrEdit())
			$this->Ins_service_executive->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Ins_service_executive"));
		$this->Ins_service_executive->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Ins_service_executive"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));

		// o_operator
		if (!$this->isAddOrEdit())
			$this->o_operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_o_operator"));
		$this->o_operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_o_operator"));

		// o_datetime
		if (!$this->isAddOrEdit())
			$this->o_datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_o_datetime"));
		$this->o_datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_o_datetime"));

		// master_reading
		if (!$this->isAddOrEdit())
			$this->master_reading->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_master_reading"));
		$this->master_reading->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_master_reading"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// status
		// buyer_id
		// product_ref
		// current_reading
		// product_status
		// error
		// last_serve
		// last_serve_by
		// query_by
		// service_executive
		// Ins_service_executive
		// operator
		// datetime
		// o_operator
		// o_datetime
		// rid_1
		// master_reading

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// buyer_id
			if ($this->buyer_id->VirtualValue <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->VirtualValue;
			} else {
				$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
			$curVal = strval($this->buyer_id->CurrentValue);
			if ($curVal <> "") {
				$this->buyer_id->ViewValue = $this->buyer_id->lookupCacheOption($curVal);
				if ($this->buyer_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id` > 1000 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->buyer_id->ViewValue = $this->buyer_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer_id->ViewValue = $this->buyer_id->CurrentValue;
					}
				}
			} else {
				$this->buyer_id->ViewValue = NULL;
			}
			}
			$this->buyer_id->ViewCustomAttributes = "";

			// product_ref
			$curVal = strval($this->product_ref->CurrentValue);
			if ($curVal <> "") {
				$this->product_ref->ViewValue = $this->product_ref->lookupCacheOption($curVal);
				if ($this->product_ref->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product_ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = $rswrk->fields('df4');
						$this->product_ref->ViewValue = $this->product_ref->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_ref->ViewValue = $this->product_ref->CurrentValue;
					}
				}
			} else {
				$this->product_ref->ViewValue = NULL;
			}
			$this->product_ref->ViewCustomAttributes = "";

			// current_reading
			$this->current_reading->ViewValue = $this->current_reading->CurrentValue;
			$this->current_reading->ViewValue = FormatNumber($this->current_reading->ViewValue, 0, -2, -2, -2);
			$this->current_reading->ViewCustomAttributes = "";

			// product_status
			$curVal = strval($this->product_status->CurrentValue);
			if ($curVal <> "") {
				$this->product_status->ViewValue = $this->product_status->lookupCacheOption($curVal);
				if ($this->product_status->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`grp` = 21 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->product_status->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product_status->ViewValue = $this->product_status->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product_status->ViewValue = $this->product_status->CurrentValue;
					}
				}
			} else {
				$this->product_status->ViewValue = NULL;
			}
			$this->product_status->ViewCustomAttributes = "";

			// error
			$this->error->ViewValue = $this->error->CurrentValue;
			$this->error->ViewCustomAttributes = "";

			// last_serve
			$this->last_serve->ViewValue = $this->last_serve->CurrentValue;
			$this->last_serve->ViewValue = FormatDateTime($this->last_serve->ViewValue, 0);
			$this->last_serve->ViewCustomAttributes = "";

			// last_serve_by
			$curVal = strval($this->last_serve_by->CurrentValue);
			if ($curVal <> "") {
				$this->last_serve_by->ViewValue = $this->last_serve_by->lookupCacheOption($curVal);
				if ($this->last_serve_by->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->last_serve_by->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->last_serve_by->ViewValue = $this->last_serve_by->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->last_serve_by->ViewValue = $this->last_serve_by->CurrentValue;
					}
				}
			} else {
				$this->last_serve_by->ViewValue = NULL;
			}
			$this->last_serve_by->ViewCustomAttributes = "";

			// query_by
			$this->query_by->ViewValue = $this->query_by->CurrentValue;
			$this->query_by->ViewCustomAttributes = "";

			// service_executive
			$curVal = strval($this->service_executive->CurrentValue);
			if ($curVal <> "") {
				$this->service_executive->ViewValue = $this->service_executive->lookupCacheOption($curVal);
				if ($this->service_executive->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->service_executive->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->service_executive->ViewValue = $this->service_executive->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->service_executive->ViewValue = $this->service_executive->CurrentValue;
					}
				}
			} else {
				$this->service_executive->ViewValue = NULL;
			}
			$this->service_executive->ViewCustomAttributes = "";

			// Ins_service_executive
			$this->Ins_service_executive->ViewValue = $this->Ins_service_executive->CurrentValue;
			$this->Ins_service_executive->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// o_operator
			$this->o_operator->ViewValue = $this->o_operator->CurrentValue;
			$this->o_operator->ViewValue = FormatNumber($this->o_operator->ViewValue, 0, -2, -2, -2);
			$this->o_operator->ViewCustomAttributes = "";

			// o_datetime
			$this->o_datetime->ViewValue = $this->o_datetime->CurrentValue;
			$this->o_datetime->ViewValue = FormatDateTime($this->o_datetime->ViewValue, 0);
			$this->o_datetime->ViewCustomAttributes = "";

			// master_reading
			$this->master_reading->ViewValue = $this->master_reading->CurrentValue;
			$this->master_reading->ViewValue = FormatNumber($this->master_reading->ViewValue, 0, -2, -2, -2);
			$this->master_reading->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// buyer_id
			$this->buyer_id->LinkCustomAttributes = "";
			$this->buyer_id->HrefValue = "";
			$this->buyer_id->TooltipValue = "";

			// product_ref
			$this->product_ref->LinkCustomAttributes = "";
			$this->product_ref->HrefValue = "";
			$this->product_ref->TooltipValue = "";

			// current_reading
			$this->current_reading->LinkCustomAttributes = "";
			$this->current_reading->HrefValue = "";
			$this->current_reading->TooltipValue = "";

			// product_status
			$this->product_status->LinkCustomAttributes = "";
			$this->product_status->HrefValue = "";
			$this->product_status->TooltipValue = "";

			// error
			$this->error->LinkCustomAttributes = "";
			$this->error->HrefValue = "";
			$this->error->TooltipValue = "";

			// last_serve
			$this->last_serve->LinkCustomAttributes = "";
			$this->last_serve->HrefValue = "";
			$this->last_serve->TooltipValue = "";

			// last_serve_by
			$this->last_serve_by->LinkCustomAttributes = "";
			$this->last_serve_by->HrefValue = "";
			$this->last_serve_by->TooltipValue = "";

			// query_by
			$this->query_by->LinkCustomAttributes = "";
			$this->query_by->HrefValue = "";
			$this->query_by->TooltipValue = "";

			// service_executive
			$this->service_executive->LinkCustomAttributes = "";
			$this->service_executive->HrefValue = "";
			$this->service_executive->TooltipValue = "";

			// Ins_service_executive
			$this->Ins_service_executive->LinkCustomAttributes = "";
			$this->Ins_service_executive->HrefValue = "";
			$this->Ins_service_executive->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// o_operator
			$this->o_operator->LinkCustomAttributes = "";
			$this->o_operator->HrefValue = "";
			$this->o_operator->TooltipValue = "";

			// o_datetime
			$this->o_datetime->LinkCustomAttributes = "";
			$this->o_datetime->HrefValue = "";
			$this->o_datetime->TooltipValue = "";

			// master_reading
			$this->master_reading->LinkCustomAttributes = "";
			$this->master_reading->HrefValue = "";
			$this->master_reading->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// buyer_id
			$this->buyer_id->EditAttrs["class"] = "form-control";
			$this->buyer_id->EditCustomAttributes = "";
			$this->buyer_id->EditValue = HtmlEncode($this->buyer_id->AdvancedSearch->SearchValue);
			$this->buyer_id->PlaceHolder = RemoveHtml($this->buyer_id->caption());

			// product_ref
			$this->product_ref->EditAttrs["class"] = "form-control";
			$this->product_ref->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_ref->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product_ref->AdvancedSearch->ViewValue = $this->product_ref->lookupCacheOption($curVal);
			else
				$this->product_ref->AdvancedSearch->ViewValue = $this->product_ref->Lookup !== NULL && is_array($this->product_ref->Lookup->Options) ? $curVal : NULL;
			if ($this->product_ref->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product_ref->EditValue = array_values($this->product_ref->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_ref->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product_ref->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_ref->EditValue = $arwrk;
			}

			// current_reading
			$this->current_reading->EditAttrs["class"] = "form-control";
			$this->current_reading->EditCustomAttributes = "";
			$this->current_reading->EditValue = HtmlEncode($this->current_reading->AdvancedSearch->SearchValue);
			$this->current_reading->PlaceHolder = RemoveHtml($this->current_reading->caption());

			// product_status
			$this->product_status->EditAttrs["class"] = "form-control";
			$this->product_status->EditCustomAttributes = "";
			$curVal = trim(strval($this->product_status->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product_status->AdvancedSearch->ViewValue = $this->product_status->lookupCacheOption($curVal);
			else
				$this->product_status->AdvancedSearch->ViewValue = $this->product_status->Lookup !== NULL && is_array($this->product_status->Lookup->Options) ? $curVal : NULL;
			if ($this->product_status->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product_status->EditValue = array_values($this->product_status->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product_status->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`grp` = 21 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->product_status->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product_status->EditValue = $arwrk;
			}

			// error
			$this->error->EditAttrs["class"] = "form-control";
			$this->error->EditCustomAttributes = "";
			$this->error->EditValue = HtmlEncode($this->error->AdvancedSearch->SearchValue);
			$this->error->PlaceHolder = RemoveHtml($this->error->caption());

			// last_serve
			$this->last_serve->EditAttrs["class"] = "form-control";
			$this->last_serve->EditCustomAttributes = "";
			$this->last_serve->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->last_serve->AdvancedSearch->SearchValue, 0), 8));
			$this->last_serve->PlaceHolder = RemoveHtml($this->last_serve->caption());

			// last_serve_by
			$this->last_serve_by->EditAttrs["class"] = "form-control";
			$this->last_serve_by->EditCustomAttributes = "";
			$curVal = trim(strval($this->last_serve_by->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->last_serve_by->AdvancedSearch->ViewValue = $this->last_serve_by->lookupCacheOption($curVal);
			else
				$this->last_serve_by->AdvancedSearch->ViewValue = $this->last_serve_by->Lookup !== NULL && is_array($this->last_serve_by->Lookup->Options) ? $curVal : NULL;
			if ($this->last_serve_by->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->last_serve_by->EditValue = array_values($this->last_serve_by->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->last_serve_by->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "FIND_IN_SET('92', `category`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->last_serve_by->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->last_serve_by->EditValue = $arwrk;
			}

			// query_by
			$this->query_by->EditAttrs["class"] = "form-control";
			$this->query_by->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->query_by->AdvancedSearch->SearchValue = HtmlDecode($this->query_by->AdvancedSearch->SearchValue);
			$this->query_by->EditValue = HtmlEncode($this->query_by->AdvancedSearch->SearchValue);
			$this->query_by->PlaceHolder = RemoveHtml($this->query_by->caption());

			// service_executive
			$this->service_executive->EditAttrs["class"] = "form-control";
			$this->service_executive->EditCustomAttributes = "";
			$curVal = trim(strval($this->service_executive->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->service_executive->AdvancedSearch->ViewValue = $this->service_executive->lookupCacheOption($curVal);
			else
				$this->service_executive->AdvancedSearch->ViewValue = $this->service_executive->Lookup !== NULL && is_array($this->service_executive->Lookup->Options) ? $curVal : NULL;
			if ($this->service_executive->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->service_executive->EditValue = array_values($this->service_executive->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->service_executive->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "FIND_IN_SET('92', `category`)";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->service_executive->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->service_executive->EditValue = $arwrk;
			}

			// Ins_service_executive
			$this->Ins_service_executive->EditAttrs["class"] = "form-control";
			$this->Ins_service_executive->EditCustomAttributes = "";
			$this->Ins_service_executive->EditValue = HtmlEncode($this->Ins_service_executive->AdvancedSearch->SearchValue);
			$this->Ins_service_executive->PlaceHolder = RemoveHtml($this->Ins_service_executive->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$this->operator->EditValue = HtmlEncode($this->operator->AdvancedSearch->SearchValue);
			$this->operator->PlaceHolder = RemoveHtml($this->operator->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());

			// o_operator
			$this->o_operator->EditAttrs["class"] = "form-control";
			$this->o_operator->EditCustomAttributes = "";
			$this->o_operator->EditValue = HtmlEncode($this->o_operator->AdvancedSearch->SearchValue);
			$this->o_operator->PlaceHolder = RemoveHtml($this->o_operator->caption());

			// o_datetime
			$this->o_datetime->EditAttrs["class"] = "form-control";
			$this->o_datetime->EditCustomAttributes = "";
			$this->o_datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->o_datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->o_datetime->PlaceHolder = RemoveHtml($this->o_datetime->caption());

			// master_reading
			$this->master_reading->EditAttrs["class"] = "form-control";
			$this->master_reading->EditCustomAttributes = "";
			$this->master_reading->EditValue = HtmlEncode($this->master_reading->AdvancedSearch->SearchValue);
			$this->master_reading->PlaceHolder = RemoveHtml($this->master_reading->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->current_reading->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->current_reading->errorMessage());
		}
		if (!CheckDate($this->last_serve->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->last_serve->errorMessage());
		}
		if (!CheckInteger($this->operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->operator->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}
		if (!CheckInteger($this->o_operator->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->o_operator->errorMessage());
		}
		if (!CheckDate($this->o_datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->o_datetime->errorMessage());
		}
		if (!CheckInteger($this->master_reading->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->master_reading->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->buyer_id->AdvancedSearch->load();
		$this->product_ref->AdvancedSearch->load();
		$this->current_reading->AdvancedSearch->load();
		$this->product_status->AdvancedSearch->load();
		$this->error->AdvancedSearch->load();
		$this->last_serve->AdvancedSearch->load();
		$this->last_serve_by->AdvancedSearch->load();
		$this->query_by->AdvancedSearch->load();
		$this->service_executive->AdvancedSearch->load();
		$this->Ins_service_executive->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
		$this->o_operator->AdvancedSearch->load();
		$this->o_datetime->AdvancedSearch->load();
		$this->master_reading->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("service_requestlist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_buyer_id":
					$lookupFilter = function() {
						return "`id` > 1000 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_product_status":
					$lookupFilter = function() {
						return "`grp` = 21 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_last_serve_by":
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_service_executive":
					$lookupFilter = function() {
						return "FIND_IN_SET('92', `category`)";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_buyer_id":
							break;
						case "x_product_ref":
							break;
						case "x_product_status":
							break;
						case "x_last_serve_by":
							break;
						case "x_service_executive":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>