<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for share_transfer
 */
class share_transfer extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $folio_new;
	public $folio_old;
	public $adviser;
	public $quantity;
	public $transfer_date;
	public $share_no_start;
	public $share_no_end;
	public $pan;
	public $aadhaar;
	public $duty_folio_new;
	public $duty_company;
	public $operator;
	public $datetime;
	public $updated;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'share_transfer';
		$this->TableName = 'share_transfer';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`share_transfer`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('share_transfer', 'share_transfer', 'x_id', 'id', '`id`', '`id`', 2, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// folio_new
		$this->folio_new = new DbField('share_transfer', 'share_transfer', 'x_folio_new', 'folio_new', '`folio_new`', '`folio_new`', 2, -1, FALSE, '`EV__folio_new`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->folio_new->Required = TRUE; // Required field
		$this->folio_new->Sortable = TRUE; // Allow sort
		$this->folio_new->Lookup = new Lookup('folio_new', 'investor_info', FALSE, 'id', ["id","name","mobile","qty"], [], [], [], [], [], [], '`name` ASC', '');
		$this->folio_new->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['folio_new'] = &$this->folio_new;

		// folio_old
		$this->folio_old = new DbField('share_transfer', 'share_transfer', 'x_folio_old', 'folio_old', '`folio_old`', '`folio_old`', 2, -1, FALSE, '`EV__folio_old`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->folio_old->Required = TRUE; // Required field
		$this->folio_old->Sortable = TRUE; // Allow sort
		$this->folio_old->Lookup = new Lookup('folio_old', 'investor_info', FALSE, 'id', ["id","name","mobile","qty"], [], [], [], [], [], [], '`name` ASC', '');
		$this->folio_old->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['folio_old'] = &$this->folio_old;

		// adviser
		$this->adviser = new DbField('share_transfer', 'share_transfer', 'x_adviser', 'adviser', '`adviser`', '`adviser`', 2, -1, FALSE, '`adviser`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->adviser->Sortable = TRUE; // Allow sort
		$this->adviser->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->adviser->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->adviser->Lookup = new Lookup('adviser', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->adviser->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['adviser'] = &$this->adviser;

		// quantity
		$this->quantity = new DbField('share_transfer', 'share_transfer', 'x_quantity', 'quantity', '`quantity`', '`quantity`', 2, -1, FALSE, '`quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->quantity->Required = TRUE; // Required field
		$this->quantity->Sortable = TRUE; // Allow sort
		$this->quantity->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['quantity'] = &$this->quantity;

		// transfer_date
		$this->transfer_date = new DbField('share_transfer', 'share_transfer', 'x_transfer_date', 'transfer_date', '`transfer_date`', CastDateFieldForLike('`transfer_date`', 2, "DB"), 133, 2, FALSE, '`transfer_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->transfer_date->Required = TRUE; // Required field
		$this->transfer_date->Sortable = TRUE; // Allow sort
		$this->transfer_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['transfer_date'] = &$this->transfer_date;

		// share_no_start
		$this->share_no_start = new DbField('share_transfer', 'share_transfer', 'x_share_no_start', 'share_no_start', '`share_no_start`', '`share_no_start`', 3, -1, FALSE, '`share_no_start`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->share_no_start->Required = TRUE; // Required field
		$this->share_no_start->Sortable = TRUE; // Allow sort
		$this->share_no_start->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['share_no_start'] = &$this->share_no_start;

		// share_no_end
		$this->share_no_end = new DbField('share_transfer', 'share_transfer', 'x_share_no_end', 'share_no_end', '`share_no_end`', '`share_no_end`', 3, -1, FALSE, '`share_no_end`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->share_no_end->Required = TRUE; // Required field
		$this->share_no_end->Sortable = TRUE; // Allow sort
		$this->share_no_end->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['share_no_end'] = &$this->share_no_end;

		// pan
		$this->pan = new DbField('share_transfer', 'share_transfer', 'x_pan', 'pan', '`pan`', '`pan`', 200, -1, FALSE, '`pan`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->pan->Sortable = TRUE; // Allow sort
		$this->fields['pan'] = &$this->pan;

		// aadhaar
		$this->aadhaar = new DbField('share_transfer', 'share_transfer', 'x_aadhaar', 'aadhaar', '`aadhaar`', '`aadhaar`', 200, -1, FALSE, '`aadhaar`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->aadhaar->Sortable = TRUE; // Allow sort
		$this->fields['aadhaar'] = &$this->aadhaar;

		// duty_folio_new
		$this->duty_folio_new = new DbField('share_transfer', 'share_transfer', 'x_duty_folio_new', 'duty_folio_new', '`duty_folio_new`', '`duty_folio_new`', 131, -1, FALSE, '`duty_folio_new`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->duty_folio_new->Nullable = FALSE; // NOT NULL field
		$this->duty_folio_new->Sortable = TRUE; // Allow sort
		$this->duty_folio_new->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['duty_folio_new'] = &$this->duty_folio_new;

		// duty_company
		$this->duty_company = new DbField('share_transfer', 'share_transfer', 'x_duty_company', 'duty_company', '`duty_company`', '`duty_company`', 131, -1, FALSE, '`duty_company`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->duty_company->Nullable = FALSE; // NOT NULL field
		$this->duty_company->Sortable = TRUE; // Allow sort
		$this->duty_company->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['duty_company'] = &$this->duty_company;

		// operator
		$this->operator = new DbField('share_transfer', 'share_transfer', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('share_transfer', 'share_transfer', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, -1, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['datetime'] = &$this->datetime;

		// updated
		$this->updated = new DbField('share_transfer', 'share_transfer', 'x_updated', 'updated', '`updated`', '`updated`', 16, -1, FALSE, '`updated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->updated->Sortable = FALSE; // Allow sort
		$this->updated->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['updated'] = &$this->updated;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`share_transfer`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->folio_new) . "',COALESCE(`name`,''),'" . ValueSeparator(2, $this->folio_new) . "',COALESCE(`mobile`,''),'" . ValueSeparator(3, $this->folio_new) . "',COALESCE(`qty`,'')) FROM `investor_info` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `share_transfer`.`folio_new` LIMIT 1) AS `EV__folio_new`, (SELECT CONCAT(COALESCE(`id`, ''),'" . ValueSeparator(1, $this->folio_old) . "',COALESCE(`name`,''),'" . ValueSeparator(2, $this->folio_old) . "',COALESCE(`mobile`,''),'" . ValueSeparator(3, $this->folio_old) . "',COALESCE(`qty`,'')) FROM `investor_info` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `share_transfer`.`folio_old` LIMIT 1) AS `EV__folio_old` FROM `share_transfer`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->folio_new->AdvancedSearch->SearchValue <> "" ||
			$this->folio_new->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->folio_new->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->folio_new->VirtualExpression . " "))
			return TRUE;
		if ($this->folio_old->AdvancedSearch->SearchValue <> "" ||
			$this->folio_old->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->folio_old->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->folio_old->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->folio_new->DbValue = $row['folio_new'];
		$this->folio_old->DbValue = $row['folio_old'];
		$this->adviser->DbValue = $row['adviser'];
		$this->quantity->DbValue = $row['quantity'];
		$this->transfer_date->DbValue = $row['transfer_date'];
		$this->share_no_start->DbValue = $row['share_no_start'];
		$this->share_no_end->DbValue = $row['share_no_end'];
		$this->pan->DbValue = $row['pan'];
		$this->aadhaar->DbValue = $row['aadhaar'];
		$this->duty_folio_new->DbValue = $row['duty_folio_new'];
		$this->duty_company->DbValue = $row['duty_company'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->updated->DbValue = $row['updated'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "share_transferlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "share_transferview.php")
			return $Language->phrase("View");
		elseif ($pageName == "share_transferedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "share_transferadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "share_transferlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("share_transferview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("share_transferview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "share_transferadd.php?" . $this->getUrlParm($parm);
		else
			$url = "share_transferadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("share_transferedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("share_transferadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("share_transferdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->folio_new->setDbValue($rs->fields('folio_new'));
		$this->folio_old->setDbValue($rs->fields('folio_old'));
		$this->adviser->setDbValue($rs->fields('adviser'));
		$this->quantity->setDbValue($rs->fields('quantity'));
		$this->transfer_date->setDbValue($rs->fields('transfer_date'));
		$this->share_no_start->setDbValue($rs->fields('share_no_start'));
		$this->share_no_end->setDbValue($rs->fields('share_no_end'));
		$this->pan->setDbValue($rs->fields('pan'));
		$this->aadhaar->setDbValue($rs->fields('aadhaar'));
		$this->duty_folio_new->setDbValue($rs->fields('duty_folio_new'));
		$this->duty_company->setDbValue($rs->fields('duty_company'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->updated->setDbValue($rs->fields('updated'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// folio_new
		// folio_old
		// adviser
		// quantity
		// transfer_date
		// share_no_start
		// share_no_end
		// pan
		// aadhaar
		// duty_folio_new
		// duty_company
		// operator
		// datetime
		// updated

		$this->updated->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// folio_new
		if ($this->folio_new->VirtualValue <> "") {
			$this->folio_new->ViewValue = $this->folio_new->VirtualValue;
		} else {
			$this->folio_new->ViewValue = $this->folio_new->CurrentValue;
		$curVal = strval($this->folio_new->CurrentValue);
		if ($curVal <> "") {
			$this->folio_new->ViewValue = $this->folio_new->lookupCacheOption($curVal);
			if ($this->folio_new->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->folio_new->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2);
					$this->folio_new->ViewValue = $this->folio_new->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->folio_new->ViewValue = $this->folio_new->CurrentValue;
				}
			}
		} else {
			$this->folio_new->ViewValue = NULL;
		}
		}
		$this->folio_new->ViewCustomAttributes = "";

		// folio_old
		if ($this->folio_old->VirtualValue <> "") {
			$this->folio_old->ViewValue = $this->folio_old->VirtualValue;
		} else {
			$this->folio_old->ViewValue = $this->folio_old->CurrentValue;
		$curVal = strval($this->folio_old->CurrentValue);
		if ($curVal <> "") {
			$this->folio_old->ViewValue = $this->folio_old->lookupCacheOption($curVal);
			if ($this->folio_old->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`qty`>0";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->folio_old->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = $rswrk->fields('df3');
					$arwrk[4] = FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2);
					$this->folio_old->ViewValue = $this->folio_old->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->folio_old->ViewValue = $this->folio_old->CurrentValue;
				}
			}
		} else {
			$this->folio_old->ViewValue = NULL;
		}
		}
		$this->folio_old->ViewCustomAttributes = "";

		// adviser
		$curVal = strval($this->adviser->CurrentValue);
		if ($curVal <> "") {
			$this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
			if ($this->adviser->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`userlevel`=1001";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->adviser->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->adviser->ViewValue = $this->adviser->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->adviser->ViewValue = $this->adviser->CurrentValue;
				}
			}
		} else {
			$this->adviser->ViewValue = NULL;
		}
		$this->adviser->ViewCustomAttributes = "";

		// quantity
		$this->quantity->ViewValue = $this->quantity->CurrentValue;
		$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
		$this->quantity->ViewCustomAttributes = "";

		// transfer_date
		$this->transfer_date->ViewValue = $this->transfer_date->CurrentValue;
		$this->transfer_date->ViewValue = FormatDateTime($this->transfer_date->ViewValue, 2);
		$this->transfer_date->ViewCustomAttributes = "";

		// share_no_start
		$this->share_no_start->ViewValue = $this->share_no_start->CurrentValue;
		$this->share_no_start->ViewValue = FormatNumber($this->share_no_start->ViewValue, 0, -2, -2, -2);
		$this->share_no_start->ViewCustomAttributes = "";

		// share_no_end
		$this->share_no_end->ViewValue = $this->share_no_end->CurrentValue;
		$this->share_no_end->ViewValue = FormatNumber($this->share_no_end->ViewValue, 0, -2, -2, -2);
		$this->share_no_end->ViewCustomAttributes = "";

		// pan
		$this->pan->ViewValue = $this->pan->CurrentValue;
		$this->pan->ViewCustomAttributes = "";

		// aadhaar
		$this->aadhaar->ViewValue = $this->aadhaar->CurrentValue;
		$this->aadhaar->ViewCustomAttributes = "";

		// duty_folio_new
		$this->duty_folio_new->ViewValue = $this->duty_folio_new->CurrentValue;
		$this->duty_folio_new->ViewValue = FormatNumber($this->duty_folio_new->ViewValue, 2, -2, -2, -2);
		$this->duty_folio_new->ViewCustomAttributes = "";

		// duty_company
		$this->duty_company->ViewValue = $this->duty_company->CurrentValue;
		$this->duty_company->ViewValue = FormatNumber($this->duty_company->ViewValue, 2, -2, -2, -2);
		$this->duty_company->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewCustomAttributes = "";

		// updated
		$this->updated->ViewValue = $this->updated->CurrentValue;
		$this->updated->ViewValue = FormatNumber($this->updated->ViewValue, 0, -2, -2, -2);
		$this->updated->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// folio_new
		$this->folio_new->LinkCustomAttributes = "";
		$this->folio_new->HrefValue = "";
		$this->folio_new->TooltipValue = "";

		// folio_old
		$this->folio_old->LinkCustomAttributes = "";
		$this->folio_old->HrefValue = "";
		$this->folio_old->TooltipValue = "";

		// adviser
		$this->adviser->LinkCustomAttributes = "";
		$this->adviser->HrefValue = "";
		$this->adviser->TooltipValue = "";

		// quantity
		$this->quantity->LinkCustomAttributes = "";
		$this->quantity->HrefValue = "";
		$this->quantity->TooltipValue = "";

		// transfer_date
		$this->transfer_date->LinkCustomAttributes = "";
		$this->transfer_date->HrefValue = "";
		$this->transfer_date->TooltipValue = "";

		// share_no_start
		$this->share_no_start->LinkCustomAttributes = "";
		$this->share_no_start->HrefValue = "";
		$this->share_no_start->TooltipValue = "";

		// share_no_end
		$this->share_no_end->LinkCustomAttributes = "";
		$this->share_no_end->HrefValue = "";
		$this->share_no_end->TooltipValue = "";

		// pan
		$this->pan->LinkCustomAttributes = "";
		$this->pan->HrefValue = "";
		$this->pan->TooltipValue = "";

		// aadhaar
		$this->aadhaar->LinkCustomAttributes = "";
		$this->aadhaar->HrefValue = "";
		$this->aadhaar->TooltipValue = "";

		// duty_folio_new
		$this->duty_folio_new->LinkCustomAttributes = "";
		$this->duty_folio_new->HrefValue = "";
		$this->duty_folio_new->TooltipValue = "";

		// duty_company
		$this->duty_company->LinkCustomAttributes = "";
		$this->duty_company->HrefValue = "";
		$this->duty_company->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// updated
		$this->updated->LinkCustomAttributes = "";
		$this->updated->HrefValue = "";
		$this->updated->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->EditValue = FormatNumber($this->id->EditValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// folio_new
		$this->folio_new->EditAttrs["class"] = "form-control";
		$this->folio_new->EditCustomAttributes = "";
		$this->folio_new->EditValue = $this->folio_new->CurrentValue;
		$this->folio_new->PlaceHolder = RemoveHtml($this->folio_new->caption());

		// folio_old
		$this->folio_old->EditAttrs["class"] = "form-control";
		$this->folio_old->EditCustomAttributes = "";
		$this->folio_old->EditValue = $this->folio_old->CurrentValue;
		$this->folio_old->PlaceHolder = RemoveHtml($this->folio_old->caption());

		// adviser
		$this->adviser->EditAttrs["class"] = "form-control";
		$this->adviser->EditCustomAttributes = "";

		// quantity
		$this->quantity->EditAttrs["class"] = "form-control";
		$this->quantity->EditCustomAttributes = "";
		$this->quantity->EditValue = $this->quantity->CurrentValue;
		$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

		// transfer_date
		$this->transfer_date->EditAttrs["class"] = "form-control";
		$this->transfer_date->EditCustomAttributes = "";
		$this->transfer_date->EditValue = FormatDateTime($this->transfer_date->CurrentValue, 2);
		$this->transfer_date->PlaceHolder = RemoveHtml($this->transfer_date->caption());

		// share_no_start
		$this->share_no_start->EditAttrs["class"] = "form-control";
		$this->share_no_start->EditCustomAttributes = 'ReadOnly';
		$this->share_no_start->EditValue = $this->share_no_start->CurrentValue;
		$this->share_no_start->PlaceHolder = RemoveHtml($this->share_no_start->caption());

		// share_no_end
		$this->share_no_end->EditAttrs["class"] = "form-control";
		$this->share_no_end->EditCustomAttributes = 'ReadOnly';
		$this->share_no_end->EditValue = $this->share_no_end->CurrentValue;
		$this->share_no_end->PlaceHolder = RemoveHtml($this->share_no_end->caption());

		// pan
		$this->pan->EditAttrs["class"] = "form-control";
		$this->pan->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->pan->CurrentValue = HtmlDecode($this->pan->CurrentValue);
		$this->pan->EditValue = $this->pan->CurrentValue;
		$this->pan->PlaceHolder = RemoveHtml($this->pan->caption());

		// aadhaar
		$this->aadhaar->EditAttrs["class"] = "form-control";
		$this->aadhaar->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->aadhaar->CurrentValue = HtmlDecode($this->aadhaar->CurrentValue);
		$this->aadhaar->EditValue = $this->aadhaar->CurrentValue;
		$this->aadhaar->PlaceHolder = RemoveHtml($this->aadhaar->caption());

		// duty_folio_new
		$this->duty_folio_new->EditAttrs["class"] = "form-control";
		$this->duty_folio_new->EditCustomAttributes = "";
		$this->duty_folio_new->EditValue = $this->duty_folio_new->CurrentValue;
		$this->duty_folio_new->PlaceHolder = RemoveHtml($this->duty_folio_new->caption());
		if (strval($this->duty_folio_new->EditValue) <> "" && is_numeric($this->duty_folio_new->EditValue))
			$this->duty_folio_new->EditValue = FormatNumber($this->duty_folio_new->EditValue, -2, -2, -2, -2);

		// duty_company
		$this->duty_company->EditAttrs["class"] = "form-control";
		$this->duty_company->EditCustomAttributes = "";
		$this->duty_company->EditValue = $this->duty_company->CurrentValue;
		$this->duty_company->PlaceHolder = RemoveHtml($this->duty_company->caption());
		if (strval($this->duty_company->EditValue) <> "" && is_numeric($this->duty_company->EditValue))
			$this->duty_company->EditValue = FormatNumber($this->duty_company->EditValue, -2, -2, -2, -2);

		// operator
		// datetime
		// updated

		$this->updated->EditAttrs["class"] = "form-control";
		$this->updated->EditCustomAttributes = "";
		$this->updated->EditValue = $this->updated->CurrentValue;
		$this->updated->PlaceHolder = RemoveHtml($this->updated->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->quantity->CurrentValue))
				$this->quantity->Total += $this->quantity->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->quantity->CurrentValue = $this->quantity->Total;
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";
			$this->quantity->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->folio_new);
					$doc->exportCaption($this->folio_old);
					$doc->exportCaption($this->adviser);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->transfer_date);
					$doc->exportCaption($this->share_no_start);
					$doc->exportCaption($this->share_no_end);
					$doc->exportCaption($this->pan);
					$doc->exportCaption($this->aadhaar);
					$doc->exportCaption($this->duty_folio_new);
					$doc->exportCaption($this->duty_company);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->updated);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->folio_new);
					$doc->exportCaption($this->folio_old);
					$doc->exportCaption($this->adviser);
					$doc->exportCaption($this->quantity);
					$doc->exportCaption($this->transfer_date);
					$doc->exportCaption($this->share_no_start);
					$doc->exportCaption($this->share_no_end);
					$doc->exportCaption($this->pan);
					$doc->exportCaption($this->aadhaar);
					$doc->exportCaption($this->duty_folio_new);
					$doc->exportCaption($this->duty_company);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->folio_new);
						$doc->exportField($this->folio_old);
						$doc->exportField($this->adviser);
						$doc->exportField($this->quantity);
						$doc->exportField($this->transfer_date);
						$doc->exportField($this->share_no_start);
						$doc->exportField($this->share_no_end);
						$doc->exportField($this->pan);
						$doc->exportField($this->aadhaar);
						$doc->exportField($this->duty_folio_new);
						$doc->exportField($this->duty_company);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->updated);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->folio_new);
						$doc->exportField($this->folio_old);
						$doc->exportField($this->adviser);
						$doc->exportField($this->quantity);
						$doc->exportField($this->transfer_date);
						$doc->exportField($this->share_no_start);
						$doc->exportField($this->share_no_end);
						$doc->exportField($this->pan);
						$doc->exportField($this->aadhaar);
						$doc->exportField($this->duty_folio_new);
						$doc->exportField($this->duty_company);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->id, '');
				$doc->exportAggregate($this->folio_new, '');
				$doc->exportAggregate($this->folio_old, '');
				$doc->exportAggregate($this->adviser, '');
				$doc->exportAggregate($this->quantity, 'TOTAL');
				$doc->exportAggregate($this->transfer_date, '');
				$doc->exportAggregate($this->share_no_start, '');
				$doc->exportAggregate($this->share_no_end, '');
				$doc->exportAggregate($this->pan, '');
				$doc->exportAggregate($this->aadhaar, '');
				$doc->exportAggregate($this->duty_folio_new, '');
				$doc->exportAggregate($this->duty_company, '');
				$doc->exportAggregate($this->operator, '');
				$doc->exportAggregate($this->datetime, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>