<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class share_transfer_add extends share_transfer
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'share_transfer';

	// Page object name
	public $PageObjName = "share_transfer_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (share_transfer)
		if (!isset($GLOBALS["share_transfer"]) || get_class($GLOBALS["share_transfer"]) == PROJECT_NAMESPACE . "share_transfer") {
			$GLOBALS["share_transfer"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["share_transfer"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'share_transfer');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $share_transfer;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($share_transfer);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "share_transferview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("share_transferlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->folio_new->setVisibility();
		$this->folio_old->setVisibility();
		$this->adviser->setVisibility();
		$this->quantity->setVisibility();
		$this->transfer_date->setVisibility();
		$this->share_no_start->setVisibility();
		$this->share_no_end->setVisibility();
		$this->pan->Visible = FALSE;
		$this->aadhaar->Visible = FALSE;
		$this->duty_folio_new->Visible = FALSE;
		$this->duty_company->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->updated->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->folio_new);
		$this->setupLookupOptions($this->folio_old);
		$this->setupLookupOptions($this->adviser);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("share_transferlist.php"); // No matching record, return to list
				}
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "share_transferlist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "share_transferview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->folio_new->CurrentValue = (isset($_GET["FN"]))? $_GET["FN"]:'';
		$this->folio_old->CurrentValue = NULL;
		$this->folio_old->OldValue = $this->folio_old->CurrentValue;
		$this->adviser->CurrentValue = NULL;
		$this->adviser->OldValue = $this->adviser->CurrentValue;
		$this->quantity->CurrentValue = NULL;
		$this->quantity->OldValue = $this->quantity->CurrentValue;
		$this->transfer_date->CurrentValue = CurrentDate();
		$this->share_no_start->CurrentValue = NULL;
		$this->share_no_start->OldValue = $this->share_no_start->CurrentValue;
		$this->share_no_end->CurrentValue = NULL;
		$this->share_no_end->OldValue = $this->share_no_end->CurrentValue;
		$this->pan->CurrentValue = NULL;
		$this->pan->OldValue = $this->pan->CurrentValue;
		$this->aadhaar->CurrentValue = NULL;
		$this->aadhaar->OldValue = $this->aadhaar->CurrentValue;
		$this->duty_folio_new->CurrentValue = 0.00;
		$this->duty_company->CurrentValue = 0.00;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->updated->CurrentValue = 0;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'folio_new' first before field var 'x_folio_new'
		$val = $CurrentForm->hasValue("folio_new") ? $CurrentForm->getValue("folio_new") : $CurrentForm->getValue("x_folio_new");
		if (!$this->folio_new->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->folio_new->Visible = FALSE; // Disable update for API request
			else
				$this->folio_new->setFormValue($val);
		}

		// Check field name 'folio_old' first before field var 'x_folio_old'
		$val = $CurrentForm->hasValue("folio_old") ? $CurrentForm->getValue("folio_old") : $CurrentForm->getValue("x_folio_old");
		if (!$this->folio_old->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->folio_old->Visible = FALSE; // Disable update for API request
			else
				$this->folio_old->setFormValue($val);
		}

		// Check field name 'adviser' first before field var 'x_adviser'
		$val = $CurrentForm->hasValue("adviser") ? $CurrentForm->getValue("adviser") : $CurrentForm->getValue("x_adviser");
		if (!$this->adviser->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->adviser->Visible = FALSE; // Disable update for API request
			else
				$this->adviser->setFormValue($val);
		}

		// Check field name 'quantity' first before field var 'x_quantity'
		$val = $CurrentForm->hasValue("quantity") ? $CurrentForm->getValue("quantity") : $CurrentForm->getValue("x_quantity");
		if (!$this->quantity->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->quantity->Visible = FALSE; // Disable update for API request
			else
				$this->quantity->setFormValue($val);
		}

		// Check field name 'transfer_date' first before field var 'x_transfer_date'
		$val = $CurrentForm->hasValue("transfer_date") ? $CurrentForm->getValue("transfer_date") : $CurrentForm->getValue("x_transfer_date");
		if (!$this->transfer_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->transfer_date->Visible = FALSE; // Disable update for API request
			else
				$this->transfer_date->setFormValue($val);
			$this->transfer_date->CurrentValue = UnFormatDateTime($this->transfer_date->CurrentValue, 2);
		}

		// Check field name 'share_no_start' first before field var 'x_share_no_start'
		$val = $CurrentForm->hasValue("share_no_start") ? $CurrentForm->getValue("share_no_start") : $CurrentForm->getValue("x_share_no_start");
		if (!$this->share_no_start->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->share_no_start->Visible = FALSE; // Disable update for API request
			else
				$this->share_no_start->setFormValue($val);
		}

		// Check field name 'share_no_end' first before field var 'x_share_no_end'
		$val = $CurrentForm->hasValue("share_no_end") ? $CurrentForm->getValue("share_no_end") : $CurrentForm->getValue("x_share_no_end");
		if (!$this->share_no_end->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->share_no_end->Visible = FALSE; // Disable update for API request
			else
				$this->share_no_end->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->folio_new->CurrentValue = $this->folio_new->FormValue;
		$this->folio_old->CurrentValue = $this->folio_old->FormValue;
		$this->adviser->CurrentValue = $this->adviser->FormValue;
		$this->quantity->CurrentValue = $this->quantity->FormValue;
		$this->transfer_date->CurrentValue = $this->transfer_date->FormValue;
		$this->transfer_date->CurrentValue = UnFormatDateTime($this->transfer_date->CurrentValue, 2);
		$this->share_no_start->CurrentValue = $this->share_no_start->FormValue;
		$this->share_no_end->CurrentValue = $this->share_no_end->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->folio_new->setDbValue($row['folio_new']);
		if (array_key_exists('EV__folio_new', $rs->fields)) {
			$this->folio_new->VirtualValue = $rs->fields('EV__folio_new'); // Set up virtual field value
		} else {
			$this->folio_new->VirtualValue = ""; // Clear value
		}
		$this->folio_old->setDbValue($row['folio_old']);
		if (array_key_exists('EV__folio_old', $rs->fields)) {
			$this->folio_old->VirtualValue = $rs->fields('EV__folio_old'); // Set up virtual field value
		} else {
			$this->folio_old->VirtualValue = ""; // Clear value
		}
		$this->adviser->setDbValue($row['adviser']);
		$this->quantity->setDbValue($row['quantity']);
		$this->transfer_date->setDbValue($row['transfer_date']);
		$this->share_no_start->setDbValue($row['share_no_start']);
		$this->share_no_end->setDbValue($row['share_no_end']);
		$this->pan->setDbValue($row['pan']);
		$this->aadhaar->setDbValue($row['aadhaar']);
		$this->duty_folio_new->setDbValue($row['duty_folio_new']);
		$this->duty_company->setDbValue($row['duty_company']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->updated->setDbValue($row['updated']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['folio_new'] = $this->folio_new->CurrentValue;
		$row['folio_old'] = $this->folio_old->CurrentValue;
		$row['adviser'] = $this->adviser->CurrentValue;
		$row['quantity'] = $this->quantity->CurrentValue;
		$row['transfer_date'] = $this->transfer_date->CurrentValue;
		$row['share_no_start'] = $this->share_no_start->CurrentValue;
		$row['share_no_end'] = $this->share_no_end->CurrentValue;
		$row['pan'] = $this->pan->CurrentValue;
		$row['aadhaar'] = $this->aadhaar->CurrentValue;
		$row['duty_folio_new'] = $this->duty_folio_new->CurrentValue;
		$row['duty_company'] = $this->duty_company->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['updated'] = $this->updated->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Call Row_Rendering event

		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// folio_new
		// folio_old
		// adviser
		// quantity
		// transfer_date
		// share_no_start
		// share_no_end
		// pan
		// aadhaar
		// duty_folio_new
		// duty_company
		// operator
		// datetime
		// updated

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
			$this->id->ViewCustomAttributes = "";

			// folio_new
			if ($this->folio_new->VirtualValue <> "") {
				$this->folio_new->ViewValue = $this->folio_new->VirtualValue;
			} else {
				$this->folio_new->ViewValue = $this->folio_new->CurrentValue;
			$curVal = strval($this->folio_new->CurrentValue);
			if ($curVal <> "") {
				$this->folio_new->ViewValue = $this->folio_new->lookupCacheOption($curVal);
				if ($this->folio_new->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->folio_new->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2);
						$this->folio_new->ViewValue = $this->folio_new->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->folio_new->ViewValue = $this->folio_new->CurrentValue;
					}
				}
			} else {
				$this->folio_new->ViewValue = NULL;
			}
			}
			$this->folio_new->ViewCustomAttributes = "";

			// folio_old
			if ($this->folio_old->VirtualValue <> "") {
				$this->folio_old->ViewValue = $this->folio_old->VirtualValue;
			} else {
				$this->folio_old->ViewValue = $this->folio_old->CurrentValue;
			$curVal = strval($this->folio_old->CurrentValue);
			if ($curVal <> "") {
				$this->folio_old->ViewValue = $this->folio_old->lookupCacheOption($curVal);
				if ($this->folio_old->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`qty`>0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->folio_old->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$arwrk[3] = $rswrk->fields('df3');
						$arwrk[4] = FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2);
						$this->folio_old->ViewValue = $this->folio_old->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->folio_old->ViewValue = $this->folio_old->CurrentValue;
					}
				}
			} else {
				$this->folio_old->ViewValue = NULL;
			}
			}
			$this->folio_old->ViewCustomAttributes = "";

			// adviser
			$curVal = strval($this->adviser->CurrentValue);
			if ($curVal <> "") {
				$this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
				if ($this->adviser->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`userlevel`=1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->adviser->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->adviser->ViewValue = $this->adviser->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->adviser->ViewValue = $this->adviser->CurrentValue;
					}
				}
			} else {
				$this->adviser->ViewValue = NULL;
			}
			$this->adviser->ViewCustomAttributes = "";

			// quantity
			$this->quantity->ViewValue = $this->quantity->CurrentValue;
			$this->quantity->ViewValue = FormatNumber($this->quantity->ViewValue, 0, -2, -2, -2);
			$this->quantity->ViewCustomAttributes = "";

			// transfer_date
			$this->transfer_date->ViewValue = $this->transfer_date->CurrentValue;
			$this->transfer_date->ViewValue = FormatDateTime($this->transfer_date->ViewValue, 2);
			$this->transfer_date->ViewCustomAttributes = "";

			// share_no_start
			$this->share_no_start->ViewValue = $this->share_no_start->CurrentValue;
			$this->share_no_start->ViewValue = FormatNumber($this->share_no_start->ViewValue, 0, -2, -2, -2);
			$this->share_no_start->ViewCustomAttributes = "";

			// share_no_end
			$this->share_no_end->ViewValue = $this->share_no_end->CurrentValue;
			$this->share_no_end->ViewValue = FormatNumber($this->share_no_end->ViewValue, 0, -2, -2, -2);
			$this->share_no_end->ViewCustomAttributes = "";

			// pan
			$this->pan->ViewValue = $this->pan->CurrentValue;
			$this->pan->ViewCustomAttributes = "";

			// aadhaar
			$this->aadhaar->ViewValue = $this->aadhaar->CurrentValue;
			$this->aadhaar->ViewCustomAttributes = "";

			// duty_folio_new
			$this->duty_folio_new->ViewValue = $this->duty_folio_new->CurrentValue;
			$this->duty_folio_new->ViewValue = FormatNumber($this->duty_folio_new->ViewValue, 2, -2, -2, -2);
			$this->duty_folio_new->ViewCustomAttributes = "";

			// duty_company
			$this->duty_company->ViewValue = $this->duty_company->CurrentValue;
			$this->duty_company->ViewValue = FormatNumber($this->duty_company->ViewValue, 2, -2, -2, -2);
			$this->duty_company->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewCustomAttributes = "";

			// folio_new
			$this->folio_new->LinkCustomAttributes = "";
			$this->folio_new->HrefValue = "";
			$this->folio_new->TooltipValue = "";

			// folio_old
			$this->folio_old->LinkCustomAttributes = "";
			$this->folio_old->HrefValue = "";
			$this->folio_old->TooltipValue = "";

			// adviser
			$this->adviser->LinkCustomAttributes = "";
			$this->adviser->HrefValue = "";
			$this->adviser->TooltipValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";
			$this->quantity->TooltipValue = "";

			// transfer_date
			$this->transfer_date->LinkCustomAttributes = "";
			$this->transfer_date->HrefValue = "";
			$this->transfer_date->TooltipValue = "";

			// share_no_start
			$this->share_no_start->LinkCustomAttributes = "";
			$this->share_no_start->HrefValue = "";
			$this->share_no_start->TooltipValue = "";

			// share_no_end
			$this->share_no_end->LinkCustomAttributes = "";
			$this->share_no_end->HrefValue = "";
			$this->share_no_end->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// folio_new
			$this->folio_new->EditAttrs["class"] = "form-control";
			$this->folio_new->EditCustomAttributes = "";
			$this->folio_new->EditValue = HtmlEncode($this->folio_new->CurrentValue);
			$curVal = strval($this->folio_new->CurrentValue);
			if ($curVal <> "") {
				$this->folio_new->EditValue = $this->folio_new->lookupCacheOption($curVal);
				if ($this->folio_new->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->folio_new->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$arwrk[4] = HtmlEncode(FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2));
						$this->folio_new->EditValue = $this->folio_new->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->folio_new->EditValue = HtmlEncode($this->folio_new->CurrentValue);
					}
				}
			} else {
				$this->folio_new->EditValue = NULL;
			}
			$this->folio_new->PlaceHolder = RemoveHtml($this->folio_new->caption());

			// folio_old
			$this->folio_old->EditAttrs["class"] = "form-control";
			$this->folio_old->EditCustomAttributes = "";
			$this->folio_old->EditValue = HtmlEncode($this->folio_old->CurrentValue);
			$curVal = strval($this->folio_old->CurrentValue);
			if ($curVal <> "") {
				$this->folio_old->EditValue = $this->folio_old->lookupCacheOption($curVal);
				if ($this->folio_old->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`qty`>0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->folio_old->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$arwrk[2] = HtmlEncode($rswrk->fields('df2'));
						$arwrk[3] = HtmlEncode($rswrk->fields('df3'));
						$arwrk[4] = HtmlEncode(FormatNumber($rswrk->fields('df4'), 0, -2, -2, -2));
						$this->folio_old->EditValue = $this->folio_old->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->folio_old->EditValue = HtmlEncode($this->folio_old->CurrentValue);
					}
				}
			} else {
				$this->folio_old->EditValue = NULL;
			}
			$this->folio_old->PlaceHolder = RemoveHtml($this->folio_old->caption());

			// adviser
			$this->adviser->EditAttrs["class"] = "form-control";
			$this->adviser->EditCustomAttributes = "";
			$curVal = trim(strval($this->adviser->CurrentValue));
			if ($curVal <> "")
				$this->adviser->ViewValue = $this->adviser->lookupCacheOption($curVal);
			else
				$this->adviser->ViewValue = $this->adviser->Lookup !== NULL && is_array($this->adviser->Lookup->Options) ? $curVal : NULL;
			if ($this->adviser->ViewValue !== NULL) { // Load from cache
				$this->adviser->EditValue = array_values($this->adviser->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->adviser->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`userlevel`=1001";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->adviser->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->adviser->EditValue = $arwrk;
			}

			// quantity
			$this->quantity->EditAttrs["class"] = "form-control";
			$this->quantity->EditCustomAttributes = "";
			$this->quantity->EditValue = HtmlEncode($this->quantity->CurrentValue);
			$this->quantity->PlaceHolder = RemoveHtml($this->quantity->caption());

			// transfer_date
			$this->transfer_date->EditAttrs["class"] = "form-control";
			$this->transfer_date->EditCustomAttributes = "";
			$this->transfer_date->EditValue = HtmlEncode(FormatDateTime($this->transfer_date->CurrentValue, 2));
			$this->transfer_date->PlaceHolder = RemoveHtml($this->transfer_date->caption());

			// share_no_start
			$this->share_no_start->EditAttrs["class"] = "form-control";
			$this->share_no_start->EditCustomAttributes = 'ReadOnly';
			$this->share_no_start->EditValue = HtmlEncode($this->share_no_start->CurrentValue);
			$this->share_no_start->PlaceHolder = RemoveHtml($this->share_no_start->caption());

			// share_no_end
			$this->share_no_end->EditAttrs["class"] = "form-control";
			$this->share_no_end->EditCustomAttributes = 'ReadOnly';
			$this->share_no_end->EditValue = HtmlEncode($this->share_no_end->CurrentValue);
			$this->share_no_end->PlaceHolder = RemoveHtml($this->share_no_end->caption());

			// operator
			// datetime
			// Add refer script
			// folio_new

			$this->folio_new->LinkCustomAttributes = "";
			$this->folio_new->HrefValue = "";

			// folio_old
			$this->folio_old->LinkCustomAttributes = "";
			$this->folio_old->HrefValue = "";

			// adviser
			$this->adviser->LinkCustomAttributes = "";
			$this->adviser->HrefValue = "";

			// quantity
			$this->quantity->LinkCustomAttributes = "";
			$this->quantity->HrefValue = "";

			// transfer_date
			$this->transfer_date->LinkCustomAttributes = "";
			$this->transfer_date->HrefValue = "";

			// share_no_start
			$this->share_no_start->LinkCustomAttributes = "";
			$this->share_no_start->HrefValue = "";

			// share_no_end
			$this->share_no_end->LinkCustomAttributes = "";
			$this->share_no_end->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->folio_new->Required) {
			if (!$this->folio_new->IsDetailKey && $this->folio_new->FormValue != NULL && $this->folio_new->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->folio_new->caption(), $this->folio_new->RequiredErrorMessage));
			}
		}
		if ($this->folio_old->Required) {
			if (!$this->folio_old->IsDetailKey && $this->folio_old->FormValue != NULL && $this->folio_old->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->folio_old->caption(), $this->folio_old->RequiredErrorMessage));
			}
		}
		if ($this->adviser->Required) {
			if (!$this->adviser->IsDetailKey && $this->adviser->FormValue != NULL && $this->adviser->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->adviser->caption(), $this->adviser->RequiredErrorMessage));
			}
		}
		if ($this->quantity->Required) {
			if (!$this->quantity->IsDetailKey && $this->quantity->FormValue != NULL && $this->quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->quantity->caption(), $this->quantity->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->quantity->FormValue)) {
			AddMessage($FormError, $this->quantity->errorMessage());
		}
		if ($this->transfer_date->Required) {
			if (!$this->transfer_date->IsDetailKey && $this->transfer_date->FormValue != NULL && $this->transfer_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->transfer_date->caption(), $this->transfer_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->transfer_date->FormValue)) {
			AddMessage($FormError, $this->transfer_date->errorMessage());
		}
		if ($this->share_no_start->Required) {
			if (!$this->share_no_start->IsDetailKey && $this->share_no_start->FormValue != NULL && $this->share_no_start->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->share_no_start->caption(), $this->share_no_start->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->share_no_start->FormValue)) {
			AddMessage($FormError, $this->share_no_start->errorMessage());
		}
		if ($this->share_no_end->Required) {
			if (!$this->share_no_end->IsDetailKey && $this->share_no_end->FormValue != NULL && $this->share_no_end->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->share_no_end->caption(), $this->share_no_end->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->share_no_end->FormValue)) {
			AddMessage($FormError, $this->share_no_end->errorMessage());
		}
		if ($this->pan->Required) {
			if (!$this->pan->IsDetailKey && $this->pan->FormValue != NULL && $this->pan->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->pan->caption(), $this->pan->RequiredErrorMessage));
			}
		}
		if ($this->aadhaar->Required) {
			if (!$this->aadhaar->IsDetailKey && $this->aadhaar->FormValue != NULL && $this->aadhaar->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->aadhaar->caption(), $this->aadhaar->RequiredErrorMessage));
			}
		}
		if ($this->duty_folio_new->Required) {
			if (!$this->duty_folio_new->IsDetailKey && $this->duty_folio_new->FormValue != NULL && $this->duty_folio_new->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->duty_folio_new->caption(), $this->duty_folio_new->RequiredErrorMessage));
			}
		}
		if ($this->duty_company->Required) {
			if (!$this->duty_company->IsDetailKey && $this->duty_company->FormValue != NULL && $this->duty_company->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->duty_company->caption(), $this->duty_company->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->updated->Required) {
			if (!$this->updated->IsDetailKey && $this->updated->FormValue != NULL && $this->updated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->updated->caption(), $this->updated->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// folio_new
		$this->folio_new->setDbValueDef($rsnew, $this->folio_new->CurrentValue, NULL, FALSE);

		// folio_old
		$this->folio_old->setDbValueDef($rsnew, $this->folio_old->CurrentValue, NULL, FALSE);

		// adviser
		$this->adviser->setDbValueDef($rsnew, $this->adviser->CurrentValue, NULL, FALSE);

		// quantity
		$this->quantity->setDbValueDef($rsnew, $this->quantity->CurrentValue, NULL, FALSE);

		// transfer_date
		$this->transfer_date->setDbValueDef($rsnew, UnFormatDateTime($this->transfer_date->CurrentValue, 2), NULL, FALSE);

		// share_no_start
		$this->share_no_start->setDbValueDef($rsnew, $this->share_no_start->CurrentValue, NULL, FALSE);

		// share_no_end
		$this->share_no_end->setDbValueDef($rsnew, $this->share_no_end->CurrentValue, NULL, FALSE);

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("share_transferlist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_folio_old":
					$lookupFilter = function() {
						return "`qty`>0";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_adviser":
					$lookupFilter = function() {
						return "`userlevel`=1001";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_folio_new":
							$row[4] = FormatNumber($row[4], 0, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_folio_old":
							$row[4] = FormatNumber($row[4], 0, -2, -2, -2);
							$row['df4'] = $row[4];
							break;
						case "x_adviser":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>