<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class shop_edit extends shop
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'shop';

	// Page object name
	public $PageObjName = "shop_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (shop)
		if (!isset($GLOBALS["shop"]) || get_class($GLOBALS["shop"]) == PROJECT_NAMESPACE . "shop") {
			$GLOBALS["shop"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["shop"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'shop');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $shop;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($shop);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "shopview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("shoplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->category->Visible = FALSE;
		$this->short_description->setVisibility();
		$this->includes->setVisibility();
		$this->description->setVisibility();
		$this->price->setVisibility();
		$this->discount_coupon->setVisibility();
		$this->discount->setVisibility();
		$this->amount->setVisibility();
		$this->valid_till->setVisibility();
		$this->status->setVisibility();
		$this->_response->setVisibility();
		$this->admin_notes->setVisibility();
		$this->code->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->show_to->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->category);
		$this->setupLookupOptions($this->short_description);
		$this->setupLookupOptions($this->includes);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("shoplist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "shoplist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'short_description' first before field var 'x_short_description'
		$val = $CurrentForm->hasValue("short_description") ? $CurrentForm->getValue("short_description") : $CurrentForm->getValue("x_short_description");
		if (!$this->short_description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->short_description->Visible = FALSE; // Disable update for API request
			else
				$this->short_description->setFormValue($val);
		}

		// Check field name 'includes' first before field var 'x_includes'
		$val = $CurrentForm->hasValue("includes") ? $CurrentForm->getValue("includes") : $CurrentForm->getValue("x_includes");
		if (!$this->includes->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->includes->Visible = FALSE; // Disable update for API request
			else
				$this->includes->setFormValue($val);
		}

		// Check field name 'description' first before field var 'x_description'
		$val = $CurrentForm->hasValue("description") ? $CurrentForm->getValue("description") : $CurrentForm->getValue("x_description");
		if (!$this->description->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->description->Visible = FALSE; // Disable update for API request
			else
				$this->description->setFormValue($val);
		}

		// Check field name 'price' first before field var 'x_price'
		$val = $CurrentForm->hasValue("price") ? $CurrentForm->getValue("price") : $CurrentForm->getValue("x_price");
		if (!$this->price->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->price->Visible = FALSE; // Disable update for API request
			else
				$this->price->setFormValue($val);
		}

		// Check field name 'discount_coupon' first before field var 'x_discount_coupon'
		$val = $CurrentForm->hasValue("discount_coupon") ? $CurrentForm->getValue("discount_coupon") : $CurrentForm->getValue("x_discount_coupon");
		if (!$this->discount_coupon->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->discount_coupon->Visible = FALSE; // Disable update for API request
			else
				$this->discount_coupon->setFormValue($val);
		}

		// Check field name 'discount' first before field var 'x_discount'
		$val = $CurrentForm->hasValue("discount") ? $CurrentForm->getValue("discount") : $CurrentForm->getValue("x_discount");
		if (!$this->discount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->discount->Visible = FALSE; // Disable update for API request
			else
				$this->discount->setFormValue($val);
		}

		// Check field name 'amount' first before field var 'x_amount'
		$val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
		if (!$this->amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount->Visible = FALSE; // Disable update for API request
			else
				$this->amount->setFormValue($val);
		}

		// Check field name 'valid_till' first before field var 'x_valid_till'
		$val = $CurrentForm->hasValue("valid_till") ? $CurrentForm->getValue("valid_till") : $CurrentForm->getValue("x_valid_till");
		if (!$this->valid_till->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->valid_till->Visible = FALSE; // Disable update for API request
			else
				$this->valid_till->setFormValue($val);
			$this->valid_till->CurrentValue = UnFormatDateTime($this->valid_till->CurrentValue, 0);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'response' first before field var 'x__response'
		$val = $CurrentForm->hasValue("response") ? $CurrentForm->getValue("response") : $CurrentForm->getValue("x__response");
		if (!$this->_response->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_response->Visible = FALSE; // Disable update for API request
			else
				$this->_response->setFormValue($val);
		}

		// Check field name 'admin_notes' first before field var 'x_admin_notes'
		$val = $CurrentForm->hasValue("admin_notes") ? $CurrentForm->getValue("admin_notes") : $CurrentForm->getValue("x_admin_notes");
		if (!$this->admin_notes->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->admin_notes->Visible = FALSE; // Disable update for API request
			else
				$this->admin_notes->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->short_description->CurrentValue = $this->short_description->FormValue;
		$this->includes->CurrentValue = $this->includes->FormValue;
		$this->description->CurrentValue = $this->description->FormValue;
		$this->price->CurrentValue = $this->price->FormValue;
		$this->discount_coupon->CurrentValue = $this->discount_coupon->FormValue;
		$this->discount->CurrentValue = $this->discount->FormValue;
		$this->amount->CurrentValue = $this->amount->FormValue;
		$this->valid_till->CurrentValue = $this->valid_till->FormValue;
		$this->valid_till->CurrentValue = UnFormatDateTime($this->valid_till->CurrentValue, 0);
		$this->status->CurrentValue = $this->status->FormValue;
		$this->_response->CurrentValue = $this->_response->FormValue;
		$this->admin_notes->CurrentValue = $this->admin_notes->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->category->setDbValue($row['category']);
		$this->short_description->setDbValue($row['short_description']);
		$this->includes->setDbValue($row['includes']);
		$this->description->setDbValue($row['description']);
		$this->price->setDbValue($row['price']);
		$this->discount_coupon->setDbValue($row['discount_coupon']);
		$this->discount->setDbValue($row['discount']);
		$this->amount->setDbValue($row['amount']);
		$this->valid_till->setDbValue($row['valid_till']);
		$this->status->setDbValue($row['status']);
		$this->_response->setDbValue($row['response']);
		$this->admin_notes->setDbValue($row['admin_notes']);
		$this->code->setDbValue($row['code']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->show_to->setDbValue($row['show_to']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['category'] = NULL;
		$row['short_description'] = NULL;
		$row['includes'] = NULL;
		$row['description'] = NULL;
		$row['price'] = NULL;
		$row['discount_coupon'] = NULL;
		$row['discount'] = NULL;
		$row['amount'] = NULL;
		$row['valid_till'] = NULL;
		$row['status'] = NULL;
		$row['response'] = NULL;
		$row['admin_notes'] = NULL;
		$row['code'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['show_to'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->price->FormValue == $this->price->CurrentValue && is_numeric(ConvertToFloatString($this->price->CurrentValue)))
			$this->price->CurrentValue = ConvertToFloatString($this->price->CurrentValue);

		// Convert decimal values if posted back
		if ($this->discount->FormValue == $this->discount->CurrentValue && is_numeric(ConvertToFloatString($this->discount->CurrentValue)))
			$this->discount->CurrentValue = ConvertToFloatString($this->discount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// category
		// short_description
		// includes
		// description
		// price
		// discount_coupon
		// discount
		// amount
		// valid_till
		// status
		// response
		// admin_notes
		// code
		// operator
		// datetime
		// show_to

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// short_description
			$curVal = strval($this->short_description->CurrentValue);
			if ($curVal <> "") {
				$this->short_description->ViewValue = $this->short_description->lookupCacheOption($curVal);
				if ($this->short_description->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`short_description`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->short_description->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->short_description->ViewValue = $this->short_description->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->short_description->ViewValue = $this->short_description->CurrentValue;
					}
				}
			} else {
				$this->short_description->ViewValue = NULL;
			}
			$this->short_description->CssClass = "font-weight-bold";
			$this->short_description->ViewCustomAttributes = 'Style="color:red"';

			// includes
			$curVal = strval($this->includes->CurrentValue);
			if ($curVal <> "") {
				$this->includes->ViewValue = $this->includes->lookupCacheOption($curVal);
				if ($this->includes->ViewValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->includes->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->includes->ViewValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->includes->ViewValue->add($this->includes->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->includes->ViewValue = $this->includes->CurrentValue;
					}
				}
			} else {
				$this->includes->ViewValue = NULL;
			}
			$this->includes->ViewCustomAttributes = "";

			// description
			$this->description->ViewValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// price
			$this->price->ViewValue = $this->price->CurrentValue;
			$this->price->ViewValue = FormatNumber($this->price->ViewValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// discount_coupon
			$this->discount_coupon->ViewValue = $this->discount_coupon->CurrentValue;
			$this->discount_coupon->ViewCustomAttributes = "";

			// discount
			$this->discount->ViewValue = $this->discount->CurrentValue;
			$this->discount->ViewValue = FormatNumber($this->discount->ViewValue, 0, -2, -2, -2);
			$this->discount->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->CssClass = "font-weight-bold";
			$this->amount->ViewCustomAttributes = "";

			// valid_till
			$this->valid_till->ViewValue = $this->valid_till->CurrentValue;
			$this->valid_till->ViewValue = FormatDateTime($this->valid_till->ViewValue, 0);
			$this->valid_till->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// response
			$this->_response->ViewValue = $this->_response->CurrentValue;
			$this->_response->ViewCustomAttributes = "";

			// admin_notes
			$this->admin_notes->ViewValue = $this->admin_notes->CurrentValue;
			$this->admin_notes->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// short_description
			$this->short_description->LinkCustomAttributes = "";
			$this->short_description->HrefValue = "";
			$this->short_description->TooltipValue = "";

			// includes
			$this->includes->LinkCustomAttributes = "";
			$this->includes->HrefValue = "";
			$this->includes->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// discount_coupon
			$this->discount_coupon->LinkCustomAttributes = "";
			$this->discount_coupon->HrefValue = "";
			$this->discount_coupon->TooltipValue = "";

			// discount
			$this->discount->LinkCustomAttributes = "";
			$this->discount->HrefValue = "";
			$this->discount->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// valid_till
			$this->valid_till->LinkCustomAttributes = "";
			$this->valid_till->HrefValue = "";
			$this->valid_till->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// response
			$this->_response->LinkCustomAttributes = "";
			$this->_response->HrefValue = "";
			$this->_response->TooltipValue = "";

			// admin_notes
			$this->admin_notes->LinkCustomAttributes = "";
			$this->admin_notes->HrefValue = "";
			$this->admin_notes->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// short_description
			$this->short_description->EditAttrs["class"] = "form-control";
			$this->short_description->EditCustomAttributes = "";
			$curVal = strval($this->short_description->CurrentValue);
			if ($curVal <> "") {
				$this->short_description->EditValue = $this->short_description->lookupCacheOption($curVal);
				if ($this->short_description->EditValue === NULL) { // Lookup from database
					$filterWrk = "`short_description`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->short_description->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->short_description->EditValue = $this->short_description->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->short_description->EditValue = $this->short_description->CurrentValue;
					}
				}
			} else {
				$this->short_description->EditValue = NULL;
			}
			$this->short_description->CssClass = "font-weight-bold";
			$this->short_description->ViewCustomAttributes = 'Style="color:red"';

			// includes
			$this->includes->EditAttrs["class"] = "form-control";
			$this->includes->EditCustomAttributes = "";
			$curVal = strval($this->includes->CurrentValue);
			if ($curVal <> "") {
				$this->includes->EditValue = $this->includes->lookupCacheOption($curVal);
				if ($this->includes->EditValue === NULL) { // Lookup from database
					$arwrk = explode(",", $curVal);
					$filterWrk = "";
					foreach ($arwrk as $wrk) {
						if ($filterWrk <> "")
							$filterWrk .= " OR ";
						$filterWrk .= "`id`" . SearchString("=", trim($wrk), DATATYPE_NUMBER, "");
					}
					$sqlWrk = $this->includes->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$this->includes->EditValue = new OptionValues();
						$ari = 0;
						while (!$rswrk->EOF) {
							$arwrk = array();
							$arwrk[1] = $rswrk->fields('df');
							$this->includes->EditValue->add($this->includes->displayValue($arwrk));
							$rswrk->MoveNext();
							$ari++;
						}
						$rswrk->Close();
					} else {
						$this->includes->EditValue = $this->includes->CurrentValue;
					}
				}
			} else {
				$this->includes->EditValue = NULL;
			}
			$this->includes->ViewCustomAttributes = "";

			// description
			$this->description->EditAttrs["class"] = "form-control";
			$this->description->EditCustomAttributes = "";
			$this->description->EditValue = $this->description->CurrentValue;
			$this->description->ViewCustomAttributes = "";

			// price
			$this->price->EditAttrs["class"] = "form-control";
			$this->price->EditCustomAttributes = "";
			$this->price->EditValue = $this->price->CurrentValue;
			$this->price->EditValue = FormatNumber($this->price->EditValue, 2, -2, -2, -2);
			$this->price->ViewCustomAttributes = "";

			// discount_coupon
			$this->discount_coupon->EditAttrs["class"] = "form-control";
			$this->discount_coupon->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->discount_coupon->CurrentValue = HtmlDecode($this->discount_coupon->CurrentValue);
			$this->discount_coupon->EditValue = HtmlEncode($this->discount_coupon->CurrentValue);
			$this->discount_coupon->PlaceHolder = RemoveHtml($this->discount_coupon->caption());

			// discount
			$this->discount->EditAttrs["class"] = "form-control";
			$this->discount->EditCustomAttributes = "";
			$this->discount->EditValue = $this->discount->CurrentValue;
			$this->discount->EditValue = FormatNumber($this->discount->EditValue, 0, -2, -2, -2);
			$this->discount->ViewCustomAttributes = "";

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			$this->amount->EditValue = $this->amount->CurrentValue;
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, 2, -2, -2, -2);
			$this->amount->CssClass = "font-weight-bold";
			$this->amount->ViewCustomAttributes = "";

			// valid_till
			$this->valid_till->EditAttrs["class"] = "form-control";
			$this->valid_till->EditCustomAttributes = "";
			$this->valid_till->EditValue = HtmlEncode(FormatDateTime($this->valid_till->CurrentValue, 8));
			$this->valid_till->PlaceHolder = RemoveHtml($this->valid_till->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// response
			$this->_response->EditAttrs["class"] = "form-control";
			$this->_response->EditCustomAttributes = "";
			$this->_response->EditValue = HtmlEncode($this->_response->CurrentValue);
			$this->_response->PlaceHolder = RemoveHtml($this->_response->caption());

			// admin_notes
			$this->admin_notes->EditAttrs["class"] = "form-control";
			$this->admin_notes->EditCustomAttributes = "";
			$this->admin_notes->EditValue = HtmlEncode($this->admin_notes->CurrentValue);
			$this->admin_notes->PlaceHolder = RemoveHtml($this->admin_notes->caption());

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// short_description
			$this->short_description->LinkCustomAttributes = "";
			$this->short_description->HrefValue = "";
			$this->short_description->TooltipValue = "";

			// includes
			$this->includes->LinkCustomAttributes = "";
			$this->includes->HrefValue = "";
			$this->includes->TooltipValue = "";

			// description
			$this->description->LinkCustomAttributes = "";
			$this->description->HrefValue = "";
			$this->description->TooltipValue = "";

			// price
			$this->price->LinkCustomAttributes = "";
			$this->price->HrefValue = "";
			$this->price->TooltipValue = "";

			// discount_coupon
			$this->discount_coupon->LinkCustomAttributes = "";
			$this->discount_coupon->HrefValue = "";

			// discount
			$this->discount->LinkCustomAttributes = "";
			$this->discount->HrefValue = "";
			$this->discount->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// valid_till
			$this->valid_till->LinkCustomAttributes = "";
			$this->valid_till->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// response
			$this->_response->LinkCustomAttributes = "";
			$this->_response->HrefValue = "";

			// admin_notes
			$this->admin_notes->LinkCustomAttributes = "";
			$this->admin_notes->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->category->Required) {
			if (!$this->category->IsDetailKey && $this->category->FormValue != NULL && $this->category->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->category->caption(), $this->category->RequiredErrorMessage));
			}
		}
		if ($this->short_description->Required) {
			if (!$this->short_description->IsDetailKey && $this->short_description->FormValue != NULL && $this->short_description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->short_description->caption(), $this->short_description->RequiredErrorMessage));
			}
		}
		if ($this->includes->Required) {
			if ($this->includes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->includes->caption(), $this->includes->RequiredErrorMessage));
			}
		}
		if ($this->description->Required) {
			if (!$this->description->IsDetailKey && $this->description->FormValue != NULL && $this->description->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->description->caption(), $this->description->RequiredErrorMessage));
			}
		}
		if ($this->price->Required) {
			if (!$this->price->IsDetailKey && $this->price->FormValue != NULL && $this->price->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->price->caption(), $this->price->RequiredErrorMessage));
			}
		}
		if ($this->discount_coupon->Required) {
			if (!$this->discount_coupon->IsDetailKey && $this->discount_coupon->FormValue != NULL && $this->discount_coupon->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->discount_coupon->caption(), $this->discount_coupon->RequiredErrorMessage));
			}
		}
		if ($this->discount->Required) {
			if (!$this->discount->IsDetailKey && $this->discount->FormValue != NULL && $this->discount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->discount->caption(), $this->discount->RequiredErrorMessage));
			}
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if ($this->valid_till->Required) {
			if (!$this->valid_till->IsDetailKey && $this->valid_till->FormValue != NULL && $this->valid_till->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->valid_till->caption(), $this->valid_till->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->valid_till->FormValue)) {
			AddMessage($FormError, $this->valid_till->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->_response->Required) {
			if (!$this->_response->IsDetailKey && $this->_response->FormValue != NULL && $this->_response->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_response->caption(), $this->_response->RequiredErrorMessage));
			}
		}
		if ($this->admin_notes->Required) {
			if (!$this->admin_notes->IsDetailKey && $this->admin_notes->FormValue != NULL && $this->admin_notes->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->admin_notes->caption(), $this->admin_notes->RequiredErrorMessage));
			}
		}
		if ($this->code->Required) {
			if (!$this->code->IsDetailKey && $this->code->FormValue != NULL && $this->code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->code->caption(), $this->code->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->show_to->Required) {
			if (!$this->show_to->IsDetailKey && $this->show_to->FormValue != NULL && $this->show_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->show_to->caption(), $this->show_to->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$rsnew = [];

			// discount_coupon
			$this->discount_coupon->setDbValueDef($rsnew, $this->discount_coupon->CurrentValue, NULL, $this->discount_coupon->ReadOnly);

			// valid_till
			$this->valid_till->setDbValueDef($rsnew, UnFormatDateTime($this->valid_till->CurrentValue, 0), NULL, $this->valid_till->ReadOnly);

			// status
			$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, $this->status->ReadOnly);

			// response
			$this->_response->setDbValueDef($rsnew, $this->_response->CurrentValue, NULL, $this->_response->ReadOnly);

			// admin_notes
			$this->admin_notes->setDbValueDef($rsnew, $this->admin_notes->CurrentValue, NULL, $this->admin_notes->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), NULL);
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("shoplist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_category":
							break;
						case "x_short_description":
							break;
						case "x_includes":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		if (CurrentUserID() == -1)
		{
			$this->category->Visible = true;
			$this->short_description->Visible = true;
			$this->price->Visible = true;
			$this->discount->Visible = true;
			$this->valid_till->Visible = true;
			$this->status->Visible = true;
			$this->discount_coupon->Visible = true;
			$this->admin_notes->Visible = true;		
			$this->code->Visible = true;

			//$this->category->ReadOnly = False;		
			//$this->short_description->ReadOnly = False;
			//$this->description->ReadOnly = False;
			//$this->includes->ReadOnly = False;
			//$this->price->ReadOnly = False;

		}
		else
		{
			$this->category->Visible = False;
			$this->short_description->Visible = False;
			$this->description->ReadOnly = True;		
			$this->price->Visible = False;
			$this->discount->Visible = False;
			$this->valid_till->Visible = False;
			$this->status->Visible = False;
			$this->discount_coupon->Visible = False;
			$this->admin_notes->Visible = False;
			$this->code->Visible = False;

			//$this->category->ReadOnly = True;		
			//$this->short_description->ReadOnly = True;
			//$this->description->ReadOnly = True;
			//$this->includes->ReadOnly = True;
			//$this->price->ReadOnly = True;

			}
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

			$upi = ExecuteScalar("SELECT `developer_upi_id` FROM `portal_setup` WHERE `id` = 200000");
		$upi_name = ExecuteScalar("SELECT `developer_company` FROM `portal_setup` WHERE `id` = 200000");	
		$str = $this->id->CurrentValue . preg_replace('/[^A-Za-z0-9 !@#$%^&*().]/u','', strip_tags(CompanyName())) . time() . '' ;
		$qr =  'upi://pay?pa='.$upi.'%26pn='.$upi_name.'%26am='.$this->amount->CurrentValue.'%26tncu=INR%26tn='.$str.'%26tr='.$str;
		$pay =  '<a href="'.str_replace("%26","&",$qr).'"><img class="ew-lazy" src="ewbarcode.php?data='.$qr.'&encode=QRCODE&height=150&color=%23000000" alt="UPI Image"><p style="font-size:7px; color:red">Scan/Click to Pay using <br>any mobile UPI app or <br>Direct bank transfer to <br>INTEGER SYSTEMS <br>at IDBI Bank,<br>A/C No: 0105102000024985, <br>IFS Code: IBKL0000105</p></a>';
		$this->amount->Caption='Amount<br><br>'.$pay;
	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>