<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for stock_godown_fp
 */
class stock_godown_fp extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $product;
	public $ref;
	public $rid;
	public $IN;
	public $OUT;
	public $Balance;
	public $packets;
	public $packing_type;
	public $godown;
	public $issue_to;
	public $dated;
	public $operator;
	public $remarks;
	public $item;
	public $id;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'stock_godown_fp';
		$this->TableName = 'stock_godown_fp';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`stock_godown_fp`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// product
		$this->product = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->product->Nullable = FALSE; // NOT NULL field
		$this->product->Required = TRUE; // Required field
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->product->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->product->Lookup = new Lookup('product', 'stock_godown_hs', FALSE, 'product', ["item","","",""], [], [], [], [], [], [], '`product` ASC', '');
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// ref
		$this->ref = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_ref', 'ref', '`ref`', '`ref`', 19, -1, FALSE, '`ref`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ref->Sortable = TRUE; // Allow sort
		$this->ref->Lookup = new Lookup('ref', 'stock_godown_hs', FALSE, 'ref', ["ref","item","OUT",""], [], [], [], [], [], [], '`ref` ASC', '');
		$this->ref->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['ref'] = &$this->ref;

		// rid
		$this->rid = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_rid', 'rid', '`rid`', '`rid`', 18, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->Lookup = new Lookup('rid', 'stock_godown_hs', FALSE, 'rid', ["rid","item","",""], [], [], [], [], [], [], '`rid` ASC', '');
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['rid'] = &$this->rid;

		// IN
		$this->IN = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_IN', 'IN', '`IN`', '`IN`', 131, -1, FALSE, '`IN`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->IN->Sortable = TRUE; // Allow sort
		$this->IN->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->IN->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->IN->Lookup = new Lookup('IN', 'stock_godown_hs', FALSE, 'OUT', ["OUT","","",""], [], [], [], [], [], [], '`OUT` ASC', '');
		$this->IN->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['IN'] = &$this->IN;

		// OUT
		$this->OUT = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_OUT', 'OUT', '`OUT`', '`OUT`', 131, -1, FALSE, '`OUT`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->OUT->Nullable = FALSE; // NOT NULL field
		$this->OUT->Sortable = TRUE; // Allow sort
		$this->OUT->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->OUT->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->OUT->Lookup = new Lookup('OUT', 'process_table_fp', FALSE, 'quantity', ["quantity","","",""], [], [], [], [], [], [], '`quantity` ASC', '');
		$this->OUT->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['OUT'] = &$this->OUT;

		// Balance
		$this->Balance = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_Balance', 'Balance', '`Balance`', '`Balance`', 131, -1, FALSE, '`Balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Balance->Sortable = TRUE; // Allow sort
		$this->Balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Balance'] = &$this->Balance;

		// packets
		$this->packets = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_packets', 'packets', '`packets`', '`packets`', 131, -1, FALSE, '`packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets->Sortable = TRUE; // Allow sort
		$this->packets->Lookup = new Lookup('packets', 'stock_godown_hs', FALSE, 'packets', ["packets","","",""], [], [], [], [], [], [], '`packets` ASC', '');
		$this->packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['packets'] = &$this->packets;

		// packing_type
		$this->packing_type = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 17, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->packing_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->packing_type->Lookup = new Lookup('packing_type', 'packing_type', FALSE, 'id', ["packing","code","",""], [], [], [], [], [], [], '`packing` ASC', '');
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['packing_type'] = &$this->packing_type;

		// godown
		$this->godown = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_godown', 'godown', '`godown`', '`godown`', 17, -1, FALSE, '`godown`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->godown->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->godown->Lookup = new Lookup('godown', 'godown_table', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['godown'] = &$this->godown;

		// issue_to
		$this->issue_to = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_issue_to', 'issue_to', '`issue_to`', '`issue_to`', 2, 0, FALSE, '`issue_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->issue_to->Sortable = TRUE; // Allow sort
		$this->issue_to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->issue_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->issue_to->Lookup = new Lookup('issue_to', 'godown_table', FALSE, 'id', ["name","code","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->issue_to->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['issue_to'] = &$this->issue_to;

		// dated
		$this->dated = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_dated', 'dated', '`dated`', CastDateFieldForLike('`dated`', 0, "DB"), 135, 0, FALSE, '`dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dated->Sortable = TRUE; // Allow sort
		$this->dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dated'] = &$this->dated;

		// operator
		$this->operator = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin_office', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// remarks
		$this->remarks = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// item
		$this->item = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_item', 'item', '`item`', '`item`', 18, -1, FALSE, '`item`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->item->Sortable = TRUE; // Allow sort
		$this->item->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->item->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->item->Lookup = new Lookup('item', 'stock_godown_hs', FALSE, 'item', ["item","","",""], [], [], [], [], [], [], '`item` ASC', '');
		$this->fields['item'] = &$this->item;

		// id
		$this->id = new DbField('stock_godown_fp', 'stock_godown_fp', 'x_id', 'id', '`id`', '`id`', 19, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Sortable = FALSE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`stock_godown_fp`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->product->DbValue = $row['product'];
		$this->ref->DbValue = $row['ref'];
		$this->rid->DbValue = $row['rid'];
		$this->IN->DbValue = $row['IN'];
		$this->OUT->DbValue = $row['OUT'];
		$this->Balance->DbValue = $row['Balance'];
		$this->packets->DbValue = $row['packets'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->godown->DbValue = $row['godown'];
		$this->issue_to->DbValue = $row['issue_to'];
		$this->dated->DbValue = $row['dated'];
		$this->operator->DbValue = $row['operator'];
		$this->remarks->DbValue = $row['remarks'];
		$this->item->DbValue = $row['item'];
		$this->id->DbValue = $row['id'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "stock_godown_fplist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "stock_godown_fpview.php")
			return $Language->phrase("View");
		elseif ($pageName == "stock_godown_fpedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "stock_godown_fpadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "stock_godown_fplist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("stock_godown_fpview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("stock_godown_fpview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "stock_godown_fpadd.php?" . $this->getUrlParm($parm);
		else
			$url = "stock_godown_fpadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("stock_godown_fpedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("stock_godown_fpadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("stock_godown_fpdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->product->setDbValue($rs->fields('product'));
		$this->ref->setDbValue($rs->fields('ref'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->IN->setDbValue($rs->fields('IN'));
		$this->OUT->setDbValue($rs->fields('OUT'));
		$this->Balance->setDbValue($rs->fields('Balance'));
		$this->packets->setDbValue($rs->fields('packets'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->issue_to->setDbValue($rs->fields('issue_to'));
		$this->dated->setDbValue($rs->fields('dated'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->item->setDbValue($rs->fields('item'));
		$this->id->setDbValue($rs->fields('id'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// product
		// ref
		// rid
		// IN
		// OUT
		// Balance
		// packets
		// packing_type
		// godown
		// issue_to
		// dated
		// operator
		// remarks
		// item
		// id

		$this->id->CellCssStyle = "white-space: nowrap;";

		// product
		$curVal = strval($this->product->CurrentValue);
		if ($curVal <> "") {
			$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			if ($this->product->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`product`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->product->ViewValue = $this->product->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->product->ViewValue = $this->product->CurrentValue;
				}
			}
		} else {
			$this->product->ViewValue = NULL;
		}
		$this->product->ViewCustomAttributes = "";

		// ref
		$this->ref->ViewValue = $this->ref->CurrentValue;
		$curVal = strval($this->ref->CurrentValue);
		if ($curVal <> "") {
			$this->ref->ViewValue = $this->ref->lookupCacheOption($curVal);
			if ($this->ref->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`ref`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->ref->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$arwrk[3] = FormatNumber($rswrk->fields('df3'), 2, -2, -2, -2);
					$this->ref->ViewValue = $this->ref->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->ref->ViewValue = $this->ref->CurrentValue;
				}
			}
		} else {
			$this->ref->ViewValue = NULL;
		}
		$this->ref->ViewCustomAttributes = "";

		// rid
		$this->rid->ViewValue = $this->rid->CurrentValue;
		$curVal = strval($this->rid->CurrentValue);
		if ($curVal <> "") {
			$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			if ($this->rid->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`rid`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 0, -2, -2, -2);
					$arwrk[2] = $rswrk->fields('df2');
					$this->rid->ViewValue = $this->rid->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->rid->ViewValue = $this->rid->CurrentValue;
				}
			}
		} else {
			$this->rid->ViewValue = NULL;
		}
		$this->rid->ViewCustomAttributes = "";

		// IN
		$curVal = strval($this->IN->CurrentValue);
		if ($curVal <> "") {
			$this->IN->ViewValue = $this->IN->lookupCacheOption($curVal);
			if ($this->IN->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`OUT`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->IN->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 2, -2, -2, -2);
					$this->IN->ViewValue = $this->IN->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->IN->ViewValue = $this->IN->CurrentValue;
				}
			}
		} else {
			$this->IN->ViewValue = NULL;
		}
		$this->IN->ViewCustomAttributes = "";

		// OUT
		$curVal = strval($this->OUT->CurrentValue);
		if ($curVal <> "") {
			$this->OUT->ViewValue = $this->OUT->lookupCacheOption($curVal);
			if ($this->OUT->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`quantity`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->OUT->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->OUT->ViewValue = $this->OUT->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->OUT->ViewValue = $this->OUT->CurrentValue;
				}
			}
		} else {
			$this->OUT->ViewValue = NULL;
		}
		$this->OUT->ViewCustomAttributes = "";

		// Balance
		$this->Balance->ViewValue = $this->Balance->CurrentValue;
		$this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, 2, -2, -2, -2);
		$this->Balance->ViewCustomAttributes = "";

		// packets
		$this->packets->ViewValue = $this->packets->CurrentValue;
		$curVal = strval($this->packets->CurrentValue);
		if ($curVal <> "") {
			$this->packets->ViewValue = $this->packets->lookupCacheOption($curVal);
			if ($this->packets->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`packets`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->packets->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = FormatNumber($rswrk->fields('df'), 2, -2, -2, -2);
					$this->packets->ViewValue = $this->packets->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packets->ViewValue = $this->packets->CurrentValue;
				}
			}
		} else {
			$this->packets->ViewValue = NULL;
		}
		$this->packets->ViewCustomAttributes = "";

		// packing_type
		$curVal = strval($this->packing_type->CurrentValue);
		if ($curVal <> "") {
			$this->packing_type->ViewValue = $this->packing_type->lookupCacheOption($curVal);
			if ($this->packing_type->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->packing_type->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->packing_type->ViewValue = $this->packing_type->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
				}
			}
		} else {
			$this->packing_type->ViewValue = NULL;
		}
		$this->packing_type->ViewCustomAttributes = "";

		// godown
		$curVal = strval($this->godown->CurrentValue);
		if ($curVal <> "") {
			$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			if ($this->godown->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->godown->ViewValue = $this->godown->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->godown->ViewValue = $this->godown->CurrentValue;
				}
			}
		} else {
			$this->godown->ViewValue = NULL;
		}
		$this->godown->ViewCustomAttributes = "";

		// issue_to
		$curVal = strval($this->issue_to->CurrentValue);
		if ($curVal <> "") {
			$this->issue_to->ViewValue = $this->issue_to->lookupCacheOption($curVal);
			if ($this->issue_to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->issue_to->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->issue_to->ViewValue = $this->issue_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->issue_to->ViewValue = $this->issue_to->CurrentValue;
				}
			}
		} else {
			$this->issue_to->ViewValue = NULL;
		}
		$this->issue_to->ViewCustomAttributes = "";

		// dated
		$this->dated->ViewValue = $this->dated->CurrentValue;
		$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// item
		$curVal = strval($this->item->CurrentValue);
		if ($curVal <> "") {
			$this->item->ViewValue = $this->item->lookupCacheOption($curVal);
			if ($this->item->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`item`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->item->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->item->ViewValue = $this->item->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->item->ViewValue = $this->item->CurrentValue;
				}
			}
		} else {
			$this->item->ViewValue = NULL;
		}
		$this->item->ViewCustomAttributes = "";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewValue = FormatNumber($this->id->ViewValue, 0, -2, -2, -2);
		$this->id->ViewCustomAttributes = "";

		// product
		$this->product->LinkCustomAttributes = "";
		if (!EmptyValue($this->product->CurrentValue)) {
			$this->product->HrefValue = "stock_godown_fplist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
			$this->product->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
		} else {
			$this->product->HrefValue = "";
		}
		$this->product->TooltipValue = "";

		// ref
		$this->ref->LinkCustomAttributes = "";
		if (!EmptyValue($this->ref->CurrentValue)) {
			$this->ref->HrefValue = "stock_godown_fplist.php?x_ref=" . $this->ref->CurrentValue; // Add prefix/suffix
			$this->ref->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->ref->HrefValue = FullUrl($this->ref->HrefValue, "href");
		} else {
			$this->ref->HrefValue = "";
		}
		$this->ref->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		if (!EmptyValue($this->rid->CurrentValue)) {
			$this->rid->HrefValue = "stock_godown_fplist.php?x_rid=" . $this->rid->CurrentValue; // Add prefix/suffix
			$this->rid->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->rid->HrefValue = FullUrl($this->rid->HrefValue, "href");
		} else {
			$this->rid->HrefValue = "";
		}
		$this->rid->TooltipValue = "";

		// IN
		$this->IN->LinkCustomAttributes = "";
		$this->IN->HrefValue = "";
		$this->IN->TooltipValue = "";

		// OUT
		$this->OUT->LinkCustomAttributes = "";
		$this->OUT->HrefValue = "";
		$this->OUT->TooltipValue = "";

		// Balance
		$this->Balance->LinkCustomAttributes = "";
		$this->Balance->HrefValue = "";
		$this->Balance->TooltipValue = "";

		// packets
		$this->packets->LinkCustomAttributes = "";
		$this->packets->HrefValue = "";
		$this->packets->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		if (!EmptyValue($this->packing_type->CurrentValue)) {
			$this->packing_type->HrefValue = "stock_godown_fplist.php?x_packing_type=" . $this->packing_type->CurrentValue; // Add prefix/suffix
			$this->packing_type->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->packing_type->HrefValue = FullUrl($this->packing_type->HrefValue, "href");
		} else {
			$this->packing_type->HrefValue = "";
		}
		$this->packing_type->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		if (!EmptyValue($this->godown->CurrentValue)) {
			$this->godown->HrefValue = "stock_godown_fplist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
			$this->godown->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
		} else {
			$this->godown->HrefValue = "";
		}
		$this->godown->TooltipValue = "";

		// issue_to
		$this->issue_to->LinkCustomAttributes = "";
		if (!EmptyValue($this->issue_to->CurrentValue)) {
			$this->issue_to->HrefValue = "stock_godown_fplist.php?x_issue_to=" . $this->issue_to->CurrentValue; // Add prefix/suffix
			$this->issue_to->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->issue_to->HrefValue = FullUrl($this->issue_to->HrefValue, "href");
		} else {
			$this->issue_to->HrefValue = "";
		}
		$this->issue_to->TooltipValue = "";

		// dated
		$this->dated->LinkCustomAttributes = "";
		$this->dated->HrefValue = "";
		$this->dated->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// item
		$this->item->LinkCustomAttributes = "";
		if (!EmptyValue($this->item->CurrentValue)) {
			$this->item->HrefValue = "stock_godown_fplist.php?x_item=" . $this->item->CurrentValue; // Add prefix/suffix
			$this->item->LinkAttrs["target"] = "_self"; // Add target
			if ($this->isExport()) $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
		} else {
			$this->item->HrefValue = "";
		}
		$this->item->TooltipValue = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";

		// ref
		$this->ref->EditAttrs["class"] = "form-control";
		$this->ref->EditCustomAttributes = "";
		$this->ref->EditValue = $this->ref->CurrentValue;
		$this->ref->PlaceHolder = RemoveHtml($this->ref->caption());

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		$this->rid->EditValue = $this->rid->CurrentValue;
		$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());

		// IN
		$this->IN->EditAttrs["class"] = "form-control";
		$this->IN->EditCustomAttributes = "";

		// OUT
		$this->OUT->EditAttrs["class"] = "form-control";
		$this->OUT->EditCustomAttributes = "";

		// Balance
		$this->Balance->EditAttrs["class"] = "form-control";
		$this->Balance->EditCustomAttributes = "";
		$this->Balance->EditValue = $this->Balance->CurrentValue;
		$this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());
		if (strval($this->Balance->EditValue) <> "" && is_numeric($this->Balance->EditValue))
			$this->Balance->EditValue = FormatNumber($this->Balance->EditValue, -2, -2, -2, -2);

		// packets
		$this->packets->EditAttrs["class"] = "form-control";
		$this->packets->EditCustomAttributes = "";
		$this->packets->EditValue = $this->packets->CurrentValue;
		$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "";

		// issue_to
		$this->issue_to->EditAttrs["class"] = "form-control";
		$this->issue_to->EditCustomAttributes = "";

		// dated
		// operator
		// remarks

		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// item
		$this->item->EditAttrs["class"] = "form-control";
		$this->item->EditCustomAttributes = "";

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->PlaceHolder = RemoveHtml($this->id->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
			if (is_numeric($this->IN->CurrentValue))
				$this->IN->Total += $this->IN->CurrentValue; // Accumulate total
			if (is_numeric($this->OUT->CurrentValue))
				$this->OUT->Total += $this->OUT->CurrentValue; // Accumulate total
			if (is_numeric($this->Balance->CurrentValue))
				$this->Balance->Total += $this->Balance->CurrentValue; // Accumulate total
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{
			$this->IN->CurrentValue = $this->IN->Total;
			$this->IN->ViewValue = $this->IN->CurrentValue;
			$this->IN->ViewCustomAttributes = "";
			$this->IN->HrefValue = ""; // Clear href value
			$this->OUT->CurrentValue = $this->OUT->Total;
			$this->OUT->ViewValue = $this->OUT->CurrentValue;
			$this->OUT->ViewCustomAttributes = "";
			$this->OUT->HrefValue = ""; // Clear href value
			$this->Balance->CurrentValue = $this->Balance->Total;
			$this->Balance->ViewValue = $this->Balance->CurrentValue;
			$this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, 2, -2, -2, -2);
			$this->Balance->ViewCustomAttributes = "";
			$this->Balance->HrefValue = ""; // Clear href value

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->IN);
					$doc->exportCaption($this->OUT);
					$doc->exportCaption($this->Balance);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->item);
				} else {
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->ref);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->IN);
					$doc->exportCaption($this->OUT);
					$doc->exportCaption($this->Balance);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->issue_to);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->item);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);
				$this->aggregateListRowValues(); // Aggregate row values

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->product);
						$doc->exportField($this->ref);
						$doc->exportField($this->rid);
						$doc->exportField($this->IN);
						$doc->exportField($this->OUT);
						$doc->exportField($this->Balance);
						$doc->exportField($this->packets);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->godown);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->dated);
						$doc->exportField($this->operator);
						$doc->exportField($this->remarks);
						$doc->exportField($this->item);
					} else {
						$doc->exportField($this->product);
						$doc->exportField($this->ref);
						$doc->exportField($this->rid);
						$doc->exportField($this->IN);
						$doc->exportField($this->OUT);
						$doc->exportField($this->Balance);
						$doc->exportField($this->packets);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->godown);
						$doc->exportField($this->issue_to);
						$doc->exportField($this->dated);
						$doc->exportField($this->operator);
						$doc->exportField($this->remarks);
						$doc->exportField($this->item);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}

		// Export aggregates (horizontal format only)
		if ($doc->Horizontal) {
			$this->RowType = ROWTYPE_AGGREGATE;
			$this->resetAttributes();
			$this->aggregateListRow();
			if (!$doc->ExportCustom) {
				$doc->beginExportRow(-1);
				$doc->exportAggregate($this->product, '');
				$doc->exportAggregate($this->ref, '');
				$doc->exportAggregate($this->rid, '');
				$doc->exportAggregate($this->IN, 'TOTAL');
				$doc->exportAggregate($this->OUT, 'TOTAL');
				$doc->exportAggregate($this->Balance, 'TOTAL');
				$doc->exportAggregate($this->packets, '');
				$doc->exportAggregate($this->packing_type, '');
				$doc->exportAggregate($this->godown, '');
				$doc->exportAggregate($this->issue_to, '');
				$doc->exportAggregate($this->dated, '');
				$doc->exportAggregate($this->operator, '');
				$doc->exportAggregate($this->remarks, '');
				$doc->exportAggregate($this->item, '');
				$doc->endExportRow();
			}
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>