<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for stock_lcgp_all
 */
class stock_lcgp_all extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $rid;
	public $grp;
	public $s_grp;
	public $product;
	public $product_code_pg;
	public $godown;
	public $company_id;
	public $godown_n;
	public $IN;
	public $OUT;
	public $HOLD;
	public $Balance;
	public $packets;
	public $avg_quantity;
	public $packing_type;
	public $packing_type_n;
	public $lot_no;
	public $product_code;
	public $url;
	public $_40;
	public $age;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 'stock_lcgp_all';
		$this->TableName = 'stock_lcgp_all';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`stock_lcgp_all`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id
		$this->id = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_id', 'id', '`id`', '`id`', 200, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->id->Nullable = FALSE; // NOT NULL field
		$this->id->Required = TRUE; // Required field
		$this->id->Sortable = TRUE; // Allow sort
		$this->fields['id'] = &$this->id;

		// rid
		$this->rid = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_rid', 'rid', '`rid`', '`rid`', 131, -1, FALSE, '`rid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rid->Nullable = FALSE; // NOT NULL field
		$this->rid->Required = TRUE; // Required field
		$this->rid->Sortable = TRUE; // Allow sort
		$this->rid->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['rid'] = &$this->rid;

		// grp
		$this->grp = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_grp', 'grp', '`grp`', '`grp`', 18, -1, FALSE, '`grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->grp->Nullable = FALSE; // NOT NULL field
		$this->grp->Required = TRUE; // Required field
		$this->grp->Sortable = TRUE; // Allow sort
		$this->grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['grp'] = &$this->grp;

		// s_grp
		$this->s_grp = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_s_grp', 's_grp', '`s_grp`', '`s_grp`', 18, -1, FALSE, '`s_grp`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->s_grp->Nullable = FALSE; // NOT NULL field
		$this->s_grp->Required = TRUE; // Required field
		$this->s_grp->Sortable = TRUE; // Allow sort
		$this->s_grp->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['s_grp'] = &$this->s_grp;

		// product
		$this->product = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_product', 'product', '`product`', '`product`', 18, -1, FALSE, '`product`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->product->Sortable = TRUE; // Allow sort
		$this->product->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['product'] = &$this->product;

		// product_code_pg
		$this->product_code_pg = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_product_code_pg', 'product_code_pg', '`product_code_pg`', '`product_code_pg`', 201, -1, FALSE, '`product_code_pg`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->product_code_pg->Sortable = TRUE; // Allow sort
		$this->fields['product_code_pg'] = &$this->product_code_pg;

		// godown
		$this->godown = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_godown', 'godown', '`godown`', '`godown`', 131, -1, FALSE, '`godown`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->godown->Sortable = TRUE; // Allow sort
		$this->godown->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['godown'] = &$this->godown;

		// company_id
		$this->company_id = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_company_id', 'company_id', '`company_id`', '`company_id`', 19, -1, FALSE, '`company_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->company_id->Sortable = TRUE; // Allow sort
		$this->company_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['company_id'] = &$this->company_id;

		// godown_n
		$this->godown_n = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_godown_n', 'godown_n', '`godown_n`', '`godown_n`', 200, -1, FALSE, '`godown_n`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->godown_n->Sortable = TRUE; // Allow sort
		$this->fields['godown_n'] = &$this->godown_n;

		// IN
		$this->IN = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_IN', 'IN', '`IN`', '`IN`', 131, -1, FALSE, '`IN`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->IN->Sortable = TRUE; // Allow sort
		$this->IN->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['IN'] = &$this->IN;

		// OUT
		$this->OUT = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_OUT', 'OUT', '`OUT`', '`OUT`', 131, -1, FALSE, '`OUT`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->OUT->Sortable = TRUE; // Allow sort
		$this->OUT->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['OUT'] = &$this->OUT;

		// HOLD
		$this->HOLD = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_HOLD', 'HOLD', '`HOLD`', '`HOLD`', 131, -1, FALSE, '`HOLD`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->HOLD->Nullable = FALSE; // NOT NULL field
		$this->HOLD->Required = TRUE; // Required field
		$this->HOLD->Sortable = TRUE; // Allow sort
		$this->HOLD->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['HOLD'] = &$this->HOLD;

		// Balance
		$this->Balance = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_Balance', 'Balance', '`Balance`', '`Balance`', 131, -1, FALSE, '`Balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->Balance->Sortable = TRUE; // Allow sort
		$this->Balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['Balance'] = &$this->Balance;

		// packets
		$this->packets = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_packets', 'packets', '`packets`', '`packets`', 5, -1, FALSE, '`packets`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packets->Sortable = TRUE; // Allow sort
		$this->packets->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['packets'] = &$this->packets;

		// avg_quantity
		$this->avg_quantity = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_avg_quantity', 'avg_quantity', '`avg_quantity`', '`avg_quantity`', 5, -1, FALSE, '`avg_quantity`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->avg_quantity->Nullable = FALSE; // NOT NULL field
		$this->avg_quantity->Required = TRUE; // Required field
		$this->avg_quantity->Sortable = TRUE; // Allow sort
		$this->avg_quantity->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['avg_quantity'] = &$this->avg_quantity;

		// packing_type
		$this->packing_type = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 131, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->packing_type->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['packing_type'] = &$this->packing_type;

		// packing_type_n
		$this->packing_type_n = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_packing_type_n', 'packing_type_n', '`packing_type_n`', '`packing_type_n`', 200, -1, FALSE, '`packing_type_n`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packing_type_n->Sortable = TRUE; // Allow sort
		$this->fields['packing_type_n'] = &$this->packing_type_n;

		// lot_no
		$this->lot_no = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_lot_no', 'lot_no', '`lot_no`', '`lot_no`', 200, -1, FALSE, '`lot_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lot_no->Sortable = TRUE; // Allow sort
		$this->fields['lot_no'] = &$this->lot_no;

		// product_code
		$this->product_code = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_product_code', 'product_code', '`product_code`', '`product_code`', 201, -1, FALSE, '`product_code`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->product_code->Sortable = TRUE; // Allow sort
		$this->fields['product_code'] = &$this->product_code;

		// url
		$this->url = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_url', 'url', '`url`', '`url`', 201, -1, FALSE, '`url`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->url->Sortable = TRUE; // Allow sort
		$this->fields['url'] = &$this->url;

		// @
		$this->_40 = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x__40', '@', '`@`', '`@`', 200, -1, FALSE, '`@`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_40->Sortable = TRUE; // Allow sort
		$this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['@'] = &$this->_40;

		// age
		$this->age = new DbField('stock_lcgp_all', 'stock_lcgp_all', 'x_age', 'age', '`age`', '`age`', 200, -1, FALSE, '`age`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->age->Sortable = TRUE; // Allow sort
		$this->fields['age'] = &$this->age;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`stock_lcgp_all`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->rid->DbValue = $row['rid'];
		$this->grp->DbValue = $row['grp'];
		$this->s_grp->DbValue = $row['s_grp'];
		$this->product->DbValue = $row['product'];
		$this->product_code_pg->DbValue = $row['product_code_pg'];
		$this->godown->DbValue = $row['godown'];
		$this->company_id->DbValue = $row['company_id'];
		$this->godown_n->DbValue = $row['godown_n'];
		$this->IN->DbValue = $row['IN'];
		$this->OUT->DbValue = $row['OUT'];
		$this->HOLD->DbValue = $row['HOLD'];
		$this->Balance->DbValue = $row['Balance'];
		$this->packets->DbValue = $row['packets'];
		$this->avg_quantity->DbValue = $row['avg_quantity'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->packing_type_n->DbValue = $row['packing_type_n'];
		$this->lot_no->DbValue = $row['lot_no'];
		$this->product_code->DbValue = $row['product_code'];
		$this->url->DbValue = $row['url'];
		$this->_40->DbValue = $row['@'];
		$this->age->DbValue = $row['age'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "stock_lcgp_alllist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "stock_lcgp_allview.php")
			return $Language->phrase("View");
		elseif ($pageName == "stock_lcgp_alledit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "stock_lcgp_alladd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "stock_lcgp_alllist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("stock_lcgp_allview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("stock_lcgp_allview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "stock_lcgp_alladd.php?" . $this->getUrlParm($parm);
		else
			$url = "stock_lcgp_alladd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("stock_lcgp_alledit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("stock_lcgp_alladd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("stock_lcgp_alldelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->rid->setDbValue($rs->fields('rid'));
		$this->grp->setDbValue($rs->fields('grp'));
		$this->s_grp->setDbValue($rs->fields('s_grp'));
		$this->product->setDbValue($rs->fields('product'));
		$this->product_code_pg->setDbValue($rs->fields('product_code_pg'));
		$this->godown->setDbValue($rs->fields('godown'));
		$this->company_id->setDbValue($rs->fields('company_id'));
		$this->godown_n->setDbValue($rs->fields('godown_n'));
		$this->IN->setDbValue($rs->fields('IN'));
		$this->OUT->setDbValue($rs->fields('OUT'));
		$this->HOLD->setDbValue($rs->fields('HOLD'));
		$this->Balance->setDbValue($rs->fields('Balance'));
		$this->packets->setDbValue($rs->fields('packets'));
		$this->avg_quantity->setDbValue($rs->fields('avg_quantity'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->packing_type_n->setDbValue($rs->fields('packing_type_n'));
		$this->lot_no->setDbValue($rs->fields('lot_no'));
		$this->product_code->setDbValue($rs->fields('product_code'));
		$this->url->setDbValue($rs->fields('url'));
		$this->_40->setDbValue($rs->fields('@'));
		$this->age->setDbValue($rs->fields('age'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// rid
		// grp
		// s_grp
		// product
		// product_code_pg
		// godown
		// company_id
		// godown_n
		// IN
		// OUT
		// HOLD
		// Balance
		// packets
		// avg_quantity
		// packing_type
		// packing_type_n
		// lot_no
		// product_code
		// url
		// @
		// age
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// rid
		$this->rid->ViewValue = $this->rid->CurrentValue;
		$this->rid->ViewValue = FormatNumber($this->rid->ViewValue, 2, -2, -2, -2);
		$this->rid->ViewCustomAttributes = "";

		// grp
		$this->grp->ViewValue = $this->grp->CurrentValue;
		$this->grp->ViewValue = FormatNumber($this->grp->ViewValue, 0, -2, -2, -2);
		$this->grp->ViewCustomAttributes = "";

		// s_grp
		$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
		$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
		$this->s_grp->ViewCustomAttributes = "";

		// product
		$this->product->ViewValue = $this->product->CurrentValue;
		$this->product->ViewValue = FormatNumber($this->product->ViewValue, 0, -2, -2, -2);
		$this->product->ViewCustomAttributes = "";

		// product_code_pg
		$this->product_code_pg->ViewValue = $this->product_code_pg->CurrentValue;
		$this->product_code_pg->ViewCustomAttributes = "";

		// godown
		$this->godown->ViewValue = $this->godown->CurrentValue;
		$this->godown->ViewValue = FormatNumber($this->godown->ViewValue, 2, -2, -2, -2);
		$this->godown->ViewCustomAttributes = "";

		// company_id
		$this->company_id->ViewValue = $this->company_id->CurrentValue;
		$this->company_id->ViewValue = FormatNumber($this->company_id->ViewValue, 0, -2, -2, -2);
		$this->company_id->ViewCustomAttributes = "";

		// godown_n
		$this->godown_n->ViewValue = $this->godown_n->CurrentValue;
		$this->godown_n->ViewCustomAttributes = "";

		// IN
		$this->IN->ViewValue = $this->IN->CurrentValue;
		$this->IN->ViewValue = FormatNumber($this->IN->ViewValue, 2, -2, -2, -2);
		$this->IN->ViewCustomAttributes = "";

		// OUT
		$this->OUT->ViewValue = $this->OUT->CurrentValue;
		$this->OUT->ViewValue = FormatNumber($this->OUT->ViewValue, 2, -2, -2, -2);
		$this->OUT->ViewCustomAttributes = "";

		// HOLD
		$this->HOLD->ViewValue = $this->HOLD->CurrentValue;
		$this->HOLD->ViewValue = FormatNumber($this->HOLD->ViewValue, 2, -2, -2, -2);
		$this->HOLD->ViewCustomAttributes = "";

		// Balance
		$this->Balance->ViewValue = $this->Balance->CurrentValue;
		$this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, 2, -2, -2, -2);
		$this->Balance->ViewCustomAttributes = "";

		// packets
		$this->packets->ViewValue = $this->packets->CurrentValue;
		$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 2, -2, -2, -2);
		$this->packets->ViewCustomAttributes = "";

		// avg_quantity
		$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, 2, -2, -2, -2);
		$this->avg_quantity->ViewCustomAttributes = "";

		// packing_type
		$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
		$this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, 2, -2, -2, -2);
		$this->packing_type->ViewCustomAttributes = "";

		// packing_type_n
		$this->packing_type_n->ViewValue = $this->packing_type_n->CurrentValue;
		$this->packing_type_n->ViewCustomAttributes = "";

		// lot_no
		$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
		$this->lot_no->ViewCustomAttributes = "";

		// product_code
		$this->product_code->ViewValue = $this->product_code->CurrentValue;
		$this->product_code->ViewCustomAttributes = "";

		// url
		$this->url->ViewValue = $this->url->CurrentValue;
		$this->url->ViewCustomAttributes = "";

		// @
		$this->_40->ViewValue = $this->_40->CurrentValue;
		$this->_40->ViewCustomAttributes = "";

		// age
		$this->age->ViewValue = $this->age->CurrentValue;
		$this->age->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// rid
		$this->rid->LinkCustomAttributes = "";
		$this->rid->HrefValue = "";
		$this->rid->TooltipValue = "";

		// grp
		$this->grp->LinkCustomAttributes = "";
		$this->grp->HrefValue = "";
		$this->grp->TooltipValue = "";

		// s_grp
		$this->s_grp->LinkCustomAttributes = "";
		$this->s_grp->HrefValue = "";
		$this->s_grp->TooltipValue = "";

		// product
		$this->product->LinkCustomAttributes = "";
		$this->product->HrefValue = "";
		$this->product->TooltipValue = "";

		// product_code_pg
		$this->product_code_pg->LinkCustomAttributes = "";
		$this->product_code_pg->HrefValue = "";
		$this->product_code_pg->TooltipValue = "";

		// godown
		$this->godown->LinkCustomAttributes = "";
		$this->godown->HrefValue = "";
		$this->godown->TooltipValue = "";

		// company_id
		$this->company_id->LinkCustomAttributes = "";
		$this->company_id->HrefValue = "";
		$this->company_id->TooltipValue = "";

		// godown_n
		$this->godown_n->LinkCustomAttributes = "";
		$this->godown_n->HrefValue = "";
		$this->godown_n->TooltipValue = "";

		// IN
		$this->IN->LinkCustomAttributes = "";
		$this->IN->HrefValue = "";
		$this->IN->TooltipValue = "";

		// OUT
		$this->OUT->LinkCustomAttributes = "";
		$this->OUT->HrefValue = "";
		$this->OUT->TooltipValue = "";

		// HOLD
		$this->HOLD->LinkCustomAttributes = "";
		$this->HOLD->HrefValue = "";
		$this->HOLD->TooltipValue = "";

		// Balance
		$this->Balance->LinkCustomAttributes = "";
		$this->Balance->HrefValue = "";
		$this->Balance->TooltipValue = "";

		// packets
		$this->packets->LinkCustomAttributes = "";
		$this->packets->HrefValue = "";
		$this->packets->TooltipValue = "";

		// avg_quantity
		$this->avg_quantity->LinkCustomAttributes = "";
		$this->avg_quantity->HrefValue = "";
		$this->avg_quantity->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// packing_type_n
		$this->packing_type_n->LinkCustomAttributes = "";
		$this->packing_type_n->HrefValue = "";
		$this->packing_type_n->TooltipValue = "";

		// lot_no
		$this->lot_no->LinkCustomAttributes = "";
		$this->lot_no->HrefValue = "";
		$this->lot_no->TooltipValue = "";

		// product_code
		$this->product_code->LinkCustomAttributes = "";
		$this->product_code->HrefValue = "";
		$this->product_code->TooltipValue = "";

		// url
		$this->url->LinkCustomAttributes = "";
		$this->url->HrefValue = "";
		$this->url->TooltipValue = "";

		// @
		$this->_40->LinkCustomAttributes = "";
		$this->_40->HrefValue = "";
		$this->_40->TooltipValue = "";

		// age
		$this->age->LinkCustomAttributes = "";
		$this->age->HrefValue = "";
		$this->age->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->id->CurrentValue = HtmlDecode($this->id->CurrentValue);
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->PlaceHolder = RemoveHtml($this->id->caption());

		// rid
		$this->rid->EditAttrs["class"] = "form-control";
		$this->rid->EditCustomAttributes = "";
		$this->rid->EditValue = $this->rid->CurrentValue;
		$this->rid->PlaceHolder = RemoveHtml($this->rid->caption());
		if (strval($this->rid->EditValue) <> "" && is_numeric($this->rid->EditValue))
			$this->rid->EditValue = FormatNumber($this->rid->EditValue, -2, -2, -2, -2);

		// grp
		$this->grp->EditAttrs["class"] = "form-control";
		$this->grp->EditCustomAttributes = "";
		$this->grp->EditValue = $this->grp->CurrentValue;
		$this->grp->PlaceHolder = RemoveHtml($this->grp->caption());

		// s_grp
		$this->s_grp->EditAttrs["class"] = "form-control";
		$this->s_grp->EditCustomAttributes = "";
		$this->s_grp->EditValue = $this->s_grp->CurrentValue;
		$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());

		// product
		$this->product->EditAttrs["class"] = "form-control";
		$this->product->EditCustomAttributes = "";
		$this->product->EditValue = $this->product->CurrentValue;
		$this->product->PlaceHolder = RemoveHtml($this->product->caption());

		// product_code_pg
		$this->product_code_pg->EditAttrs["class"] = "form-control";
		$this->product_code_pg->EditCustomAttributes = "";
		$this->product_code_pg->EditValue = $this->product_code_pg->CurrentValue;
		$this->product_code_pg->PlaceHolder = RemoveHtml($this->product_code_pg->caption());

		// godown
		$this->godown->EditAttrs["class"] = "form-control";
		$this->godown->EditCustomAttributes = "";
		$this->godown->EditValue = $this->godown->CurrentValue;
		$this->godown->PlaceHolder = RemoveHtml($this->godown->caption());
		if (strval($this->godown->EditValue) <> "" && is_numeric($this->godown->EditValue))
			$this->godown->EditValue = FormatNumber($this->godown->EditValue, -2, -2, -2, -2);

		// company_id
		$this->company_id->EditAttrs["class"] = "form-control";
		$this->company_id->EditCustomAttributes = "";
		$this->company_id->EditValue = $this->company_id->CurrentValue;
		$this->company_id->PlaceHolder = RemoveHtml($this->company_id->caption());

		// godown_n
		$this->godown_n->EditAttrs["class"] = "form-control";
		$this->godown_n->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->godown_n->CurrentValue = HtmlDecode($this->godown_n->CurrentValue);
		$this->godown_n->EditValue = $this->godown_n->CurrentValue;
		$this->godown_n->PlaceHolder = RemoveHtml($this->godown_n->caption());

		// IN
		$this->IN->EditAttrs["class"] = "form-control";
		$this->IN->EditCustomAttributes = "";
		$this->IN->EditValue = $this->IN->CurrentValue;
		$this->IN->PlaceHolder = RemoveHtml($this->IN->caption());
		if (strval($this->IN->EditValue) <> "" && is_numeric($this->IN->EditValue))
			$this->IN->EditValue = FormatNumber($this->IN->EditValue, -2, -2, -2, -2);

		// OUT
		$this->OUT->EditAttrs["class"] = "form-control";
		$this->OUT->EditCustomAttributes = "";
		$this->OUT->EditValue = $this->OUT->CurrentValue;
		$this->OUT->PlaceHolder = RemoveHtml($this->OUT->caption());
		if (strval($this->OUT->EditValue) <> "" && is_numeric($this->OUT->EditValue))
			$this->OUT->EditValue = FormatNumber($this->OUT->EditValue, -2, -2, -2, -2);

		// HOLD
		$this->HOLD->EditAttrs["class"] = "form-control";
		$this->HOLD->EditCustomAttributes = "";
		$this->HOLD->EditValue = $this->HOLD->CurrentValue;
		$this->HOLD->PlaceHolder = RemoveHtml($this->HOLD->caption());
		if (strval($this->HOLD->EditValue) <> "" && is_numeric($this->HOLD->EditValue))
			$this->HOLD->EditValue = FormatNumber($this->HOLD->EditValue, -2, -2, -2, -2);

		// Balance
		$this->Balance->EditAttrs["class"] = "form-control";
		$this->Balance->EditCustomAttributes = "";
		$this->Balance->EditValue = $this->Balance->CurrentValue;
		$this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());
		if (strval($this->Balance->EditValue) <> "" && is_numeric($this->Balance->EditValue))
			$this->Balance->EditValue = FormatNumber($this->Balance->EditValue, -2, -2, -2, -2);

		// packets
		$this->packets->EditAttrs["class"] = "form-control";
		$this->packets->EditCustomAttributes = "";
		$this->packets->EditValue = $this->packets->CurrentValue;
		$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());
		if (strval($this->packets->EditValue) <> "" && is_numeric($this->packets->EditValue))
			$this->packets->EditValue = FormatNumber($this->packets->EditValue, -2, -2, -2, -2);

		// avg_quantity
		$this->avg_quantity->EditAttrs["class"] = "form-control";
		$this->avg_quantity->EditCustomAttributes = "";
		$this->avg_quantity->EditValue = $this->avg_quantity->CurrentValue;
		$this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());
		if (strval($this->avg_quantity->EditValue) <> "" && is_numeric($this->avg_quantity->EditValue))
			$this->avg_quantity->EditValue = FormatNumber($this->avg_quantity->EditValue, -2, -2, -2, -2);

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";
		$this->packing_type->EditValue = $this->packing_type->CurrentValue;
		$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());
		if (strval($this->packing_type->EditValue) <> "" && is_numeric($this->packing_type->EditValue))
			$this->packing_type->EditValue = FormatNumber($this->packing_type->EditValue, -2, -2, -2, -2);

		// packing_type_n
		$this->packing_type_n->EditAttrs["class"] = "form-control";
		$this->packing_type_n->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->packing_type_n->CurrentValue = HtmlDecode($this->packing_type_n->CurrentValue);
		$this->packing_type_n->EditValue = $this->packing_type_n->CurrentValue;
		$this->packing_type_n->PlaceHolder = RemoveHtml($this->packing_type_n->caption());

		// lot_no
		$this->lot_no->EditAttrs["class"] = "form-control";
		$this->lot_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->lot_no->CurrentValue = HtmlDecode($this->lot_no->CurrentValue);
		$this->lot_no->EditValue = $this->lot_no->CurrentValue;
		$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

		// product_code
		$this->product_code->EditAttrs["class"] = "form-control";
		$this->product_code->EditCustomAttributes = "";
		$this->product_code->EditValue = $this->product_code->CurrentValue;
		$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

		// url
		$this->url->EditAttrs["class"] = "form-control";
		$this->url->EditCustomAttributes = "";
		$this->url->EditValue = $this->url->CurrentValue;
		$this->url->PlaceHolder = RemoveHtml($this->url->caption());

		// @
		$this->_40->EditAttrs["class"] = "form-control";
		$this->_40->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->_40->CurrentValue = HtmlDecode($this->_40->CurrentValue);
		$this->_40->EditValue = $this->_40->CurrentValue;
		$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

		// age
		$this->age->EditAttrs["class"] = "form-control";
		$this->age->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->age->CurrentValue = HtmlDecode($this->age->CurrentValue);
		$this->age->EditValue = $this->age->CurrentValue;
		$this->age->PlaceHolder = RemoveHtml($this->age->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->product_code_pg);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->godown_n);
					$doc->exportCaption($this->IN);
					$doc->exportCaption($this->OUT);
					$doc->exportCaption($this->HOLD);
					$doc->exportCaption($this->Balance);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->avg_quantity);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->packing_type_n);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->product_code);
					$doc->exportCaption($this->url);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->age);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->rid);
					$doc->exportCaption($this->grp);
					$doc->exportCaption($this->s_grp);
					$doc->exportCaption($this->product);
					$doc->exportCaption($this->godown);
					$doc->exportCaption($this->company_id);
					$doc->exportCaption($this->godown_n);
					$doc->exportCaption($this->IN);
					$doc->exportCaption($this->OUT);
					$doc->exportCaption($this->HOLD);
					$doc->exportCaption($this->Balance);
					$doc->exportCaption($this->packets);
					$doc->exportCaption($this->avg_quantity);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->packing_type_n);
					$doc->exportCaption($this->lot_no);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->age);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->rid);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->product_code_pg);
						$doc->exportField($this->godown);
						$doc->exportField($this->company_id);
						$doc->exportField($this->godown_n);
						$doc->exportField($this->IN);
						$doc->exportField($this->OUT);
						$doc->exportField($this->HOLD);
						$doc->exportField($this->Balance);
						$doc->exportField($this->packets);
						$doc->exportField($this->avg_quantity);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->packing_type_n);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->product_code);
						$doc->exportField($this->url);
						$doc->exportField($this->_40);
						$doc->exportField($this->age);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->rid);
						$doc->exportField($this->grp);
						$doc->exportField($this->s_grp);
						$doc->exportField($this->product);
						$doc->exportField($this->godown);
						$doc->exportField($this->company_id);
						$doc->exportField($this->godown_n);
						$doc->exportField($this->IN);
						$doc->exportField($this->OUT);
						$doc->exportField($this->HOLD);
						$doc->exportField($this->Balance);
						$doc->exportField($this->packets);
						$doc->exportField($this->avg_quantity);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->packing_type_n);
						$doc->exportField($this->lot_no);
						$doc->exportField($this->_40);
						$doc->exportField($this->age);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{

		// No binary fields
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>