<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class stock_lcgp_search extends stock_lcgp
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'stock_lcgp';

	// Page object name
	public $PageObjName = "stock_lcgp_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (stock_lcgp)
		if (!isset($GLOBALS["stock_lcgp"]) || get_class($GLOBALS["stock_lcgp"]) == PROJECT_NAMESPACE . "stock_lcgp") {
			$GLOBALS["stock_lcgp"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["stock_lcgp"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Table object (required_material_compiled)
		if (!isset($GLOBALS['required_material_compiled']))
			$GLOBALS['required_material_compiled'] = new required_material_compiled();

		// Table object (required_material_compiled_live)
		if (!isset($GLOBALS['required_material_compiled_live']))
			$GLOBALS['required_material_compiled_live'] = new required_material_compiled_live();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'stock_lcgp');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $stock_lcgp;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($stock_lcgp);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "stock_lcgpview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("stock_lcgplist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->rid->Visible = FALSE;
		$this->grp->setVisibility();
		$this->product->setVisibility();
		$this->product_code_pg->Visible = FALSE;
		$this->product_code->setVisibility();
		$this->godown->setVisibility();
		$this->godown_n->setVisibility();
		$this->IN->setVisibility();
		$this->OUT->setVisibility();
		$this->Balance->setVisibility();
		$this->packets->setVisibility();
		$this->packing_type_n->setVisibility();
		$this->lot_no->setVisibility();
		$this->packing_type->setVisibility();
		$this->url->setVisibility();
		$this->HOLD->setVisibility();
		$this->avg_quantity->setVisibility();
		$this->_40->Visible = FALSE;
		$this->age->setVisibility();
		$this->company_id->setVisibility();
		$this->s_grp->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->grp);
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->company_id);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "stock_lcgplist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->grp); // grp
		$this->buildSearchUrl($srchUrl, $this->product); // product
		$this->buildSearchUrl($srchUrl, $this->product_code); // product_code
		$this->buildSearchUrl($srchUrl, $this->godown); // godown
		$this->buildSearchUrl($srchUrl, $this->godown_n); // godown_n
		$this->buildSearchUrl($srchUrl, $this->IN); // IN
		$this->buildSearchUrl($srchUrl, $this->OUT); // OUT
		$this->buildSearchUrl($srchUrl, $this->Balance); // Balance
		$this->buildSearchUrl($srchUrl, $this->packets); // packets
		$this->buildSearchUrl($srchUrl, $this->packing_type_n); // packing_type_n
		$this->buildSearchUrl($srchUrl, $this->lot_no); // lot_no
		$this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
		$this->buildSearchUrl($srchUrl, $this->url); // url
		$this->buildSearchUrl($srchUrl, $this->HOLD); // HOLD
		$this->buildSearchUrl($srchUrl, $this->avg_quantity); // avg_quantity
		$this->buildSearchUrl($srchUrl, $this->age); // age
		$this->buildSearchUrl($srchUrl, $this->company_id); // company_id
		$this->buildSearchUrl($srchUrl, $this->s_grp); // s_grp
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// grp

		if (!$this->isAddOrEdit())
			$this->grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_grp"));
		$this->grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_grp"));

		// product
		if (!$this->isAddOrEdit())
			$this->product->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product"));
		$this->product->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product"));

		// product_code
		if (!$this->isAddOrEdit())
			$this->product_code->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_product_code"));
		$this->product_code->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_product_code"));

		// godown
		if (!$this->isAddOrEdit())
			$this->godown->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_godown"));
		$this->godown->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_godown"));

		// godown_n
		if (!$this->isAddOrEdit())
			$this->godown_n->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_godown_n"));
		$this->godown_n->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_godown_n"));

		// IN
		if (!$this->isAddOrEdit())
			$this->IN->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_IN"));
		$this->IN->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_IN"));

		// OUT
		if (!$this->isAddOrEdit())
			$this->OUT->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_OUT"));
		$this->OUT->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_OUT"));

		// Balance
		if (!$this->isAddOrEdit())
			$this->Balance->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_Balance"));
		$this->Balance->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_Balance"));
		$this->Balance->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_Balance"));
		$this->Balance->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_Balance"));
		$this->Balance->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_Balance"));

		// packets
		if (!$this->isAddOrEdit())
			$this->packets->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packets"));
		$this->packets->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packets"));

		// packing_type_n
		if (!$this->isAddOrEdit())
			$this->packing_type_n->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packing_type_n"));
		$this->packing_type_n->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packing_type_n"));

		// lot_no
		if (!$this->isAddOrEdit())
			$this->lot_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_lot_no"));
		$this->lot_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_lot_no"));

		// packing_type
		if (!$this->isAddOrEdit())
			$this->packing_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packing_type"));
		$this->packing_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packing_type"));

		// url
		if (!$this->isAddOrEdit())
			$this->url->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_url"));
		$this->url->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_url"));

		// HOLD
		if (!$this->isAddOrEdit())
			$this->HOLD->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_HOLD"));
		$this->HOLD->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_HOLD"));

		// avg_quantity
		if (!$this->isAddOrEdit())
			$this->avg_quantity->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_avg_quantity"));
		$this->avg_quantity->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_avg_quantity"));

		// age
		if (!$this->isAddOrEdit())
			$this->age->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_age"));
		$this->age->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_age"));

		// company_id
		if (!$this->isAddOrEdit())
			$this->company_id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_company_id"));
		$this->company_id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_company_id"));

		// s_grp
		if (!$this->isAddOrEdit())
			$this->s_grp->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_s_grp"));
		$this->s_grp->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_s_grp"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->IN->FormValue == $this->IN->CurrentValue && is_numeric(ConvertToFloatString($this->IN->CurrentValue)))
			$this->IN->CurrentValue = ConvertToFloatString($this->IN->CurrentValue);

		// Convert decimal values if posted back
		if ($this->OUT->FormValue == $this->OUT->CurrentValue && is_numeric(ConvertToFloatString($this->OUT->CurrentValue)))
			$this->OUT->CurrentValue = ConvertToFloatString($this->OUT->CurrentValue);

		// Convert decimal values if posted back
		if ($this->Balance->FormValue == $this->Balance->CurrentValue && is_numeric(ConvertToFloatString($this->Balance->CurrentValue)))
			$this->Balance->CurrentValue = ConvertToFloatString($this->Balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->packets->FormValue == $this->packets->CurrentValue && is_numeric(ConvertToFloatString($this->packets->CurrentValue)))
			$this->packets->CurrentValue = ConvertToFloatString($this->packets->CurrentValue);

		// Convert decimal values if posted back
		if ($this->packing_type->FormValue == $this->packing_type->CurrentValue && is_numeric(ConvertToFloatString($this->packing_type->CurrentValue)))
			$this->packing_type->CurrentValue = ConvertToFloatString($this->packing_type->CurrentValue);

		// Convert decimal values if posted back
		if ($this->HOLD->FormValue == $this->HOLD->CurrentValue && is_numeric(ConvertToFloatString($this->HOLD->CurrentValue)))
			$this->HOLD->CurrentValue = ConvertToFloatString($this->HOLD->CurrentValue);

		// Convert decimal values if posted back
		if ($this->avg_quantity->FormValue == $this->avg_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->avg_quantity->CurrentValue)))
			$this->avg_quantity->CurrentValue = ConvertToFloatString($this->avg_quantity->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// rid
		// grp
		// product
		// product_code_pg
		// product_code
		// godown
		// godown_n
		// IN
		// OUT
		// Balance
		// packets
		// packing_type_n
		// lot_no
		// packing_type
		// url
		// HOLD
		// avg_quantity
		// @
		// age
		// company_id
		// s_grp

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// rid
			$this->rid->ViewValue = $this->rid->CurrentValue;
			$this->rid->ViewValue = FormatNumber($this->rid->ViewValue, 0, -2, -2, -2);
			$this->rid->ViewCustomAttributes = "";

			// grp
			if ($this->grp->VirtualValue <> "") {
				$this->grp->ViewValue = $this->grp->VirtualValue;
			} else {
			$curVal = strval($this->grp->CurrentValue);
			if ($curVal <> "") {
				$this->grp->ViewValue = $this->grp->lookupCacheOption($curVal);
				if ($this->grp->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->grp->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->grp->ViewValue = $this->grp->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->grp->ViewValue = $this->grp->CurrentValue;
					}
				}
			} else {
				$this->grp->ViewValue = NULL;
			}
			}
			$this->grp->ViewCustomAttributes = "";

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// product_code
			$this->product_code->ViewValue = $this->product_code->CurrentValue;
			$this->product_code->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// godown_n
			$this->godown_n->ViewValue = $this->godown_n->CurrentValue;
			$this->godown_n->ViewCustomAttributes = "";

			// IN
			$this->IN->ViewValue = $this->IN->CurrentValue;
			$this->IN->ViewValue = FormatNumber($this->IN->ViewValue, 2, -2, -2, -2);
			$this->IN->ViewCustomAttributes = "";

			// OUT
			$this->OUT->ViewValue = $this->OUT->CurrentValue;
			$this->OUT->ViewValue = FormatNumber($this->OUT->ViewValue, 2, -2, -2, -2);
			$this->OUT->ViewCustomAttributes = "";

			// Balance
			$this->Balance->ViewValue = $this->Balance->CurrentValue;
			$this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, 2, -2, -2, 0);
			$this->Balance->ViewCustomAttributes = "";

			// packets
			$this->packets->ViewValue = $this->packets->CurrentValue;
			$this->packets->ViewValue = FormatNumber($this->packets->ViewValue, 2, -2, -2, -2);
			$this->packets->ViewCustomAttributes = "";

			// packing_type_n
			$this->packing_type_n->ViewValue = $this->packing_type_n->CurrentValue;
			$this->packing_type_n->ViewCustomAttributes = "";

			// lot_no
			$this->lot_no->ViewValue = $this->lot_no->CurrentValue;
			$this->lot_no->ViewCustomAttributes = "";

			// packing_type
			$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
			$this->packing_type->ViewValue = FormatNumber($this->packing_type->ViewValue, 0, -2, -2, -2);
			$this->packing_type->ViewCustomAttributes = "";

			// url
			$this->url->ViewValue = $this->url->CurrentValue;
			$this->url->ViewCustomAttributes = "";

			// HOLD
			$this->HOLD->ViewValue = $this->HOLD->CurrentValue;
			$this->HOLD->ViewValue = FormatNumber($this->HOLD->ViewValue, 2, -2, -2, -2);
			$this->HOLD->ViewCustomAttributes = "";

			// avg_quantity
			$this->avg_quantity->ViewValue = $this->avg_quantity->CurrentValue;
			$this->avg_quantity->ViewValue = FormatNumber($this->avg_quantity->ViewValue, 2, -2, -2, -2);
			$this->avg_quantity->ViewCustomAttributes = "";

			// age
			$this->age->ViewValue = $this->age->CurrentValue;
			$this->age->ViewCustomAttributes = "";

			// company_id
			$curVal = strval($this->company_id->CurrentValue);
			if ($curVal <> "") {
				$this->company_id->ViewValue = $this->company_id->lookupCacheOption($curVal);
				if ($this->company_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`id`< 1000 || `category` = 1 ";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->company_id->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->company_id->ViewValue = $this->company_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->company_id->ViewValue = $this->company_id->CurrentValue;
					}
				}
			} else {
				$this->company_id->ViewValue = NULL;
			}
			$this->company_id->ViewCustomAttributes = "";

			// s_grp
			$this->s_grp->ViewValue = $this->s_grp->CurrentValue;
			$this->s_grp->ViewValue = FormatNumber($this->s_grp->ViewValue, 0, -2, -2, -2);
			$this->s_grp->ViewCustomAttributes = "";

			// grp
			$this->grp->LinkCustomAttributes = "";
			if (!EmptyValue($this->grp->CurrentValue)) {
				$this->grp->HrefValue = "stock_lcgplist.php?x_grp=" . $this->grp->CurrentValue; // Add prefix/suffix
				$this->grp->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->grp->HrefValue = FullUrl($this->grp->HrefValue, "href");
			} else {
				$this->grp->HrefValue = "";
			}
			$this->grp->TooltipValue = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "stock_lcgplist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// product_code
			$this->product_code->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_code->CurrentValue)) {
				$this->product_code->HrefValue = "stock_lcgplist.php?x_product_code=" . $this->product_code->CurrentValue . "&z_product_code=LIKE"; // Add prefix/suffix
				$this->product_code->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->product_code->HrefValue = FullUrl($this->product_code->HrefValue, "href");
			} else {
				$this->product_code->HrefValue = "";
			}
			$this->product_code->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			$this->godown->HrefValue = "";
			$this->godown->TooltipValue = "";

			// godown_n
			$this->godown_n->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown_n->HrefValue = "stock_lcgplist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown_n->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->godown_n->HrefValue = FullUrl($this->godown_n->HrefValue, "href");
			} else {
				$this->godown_n->HrefValue = "";
			}
			$this->godown_n->TooltipValue = "";

			// IN
			$this->IN->LinkCustomAttributes = "";
			$this->IN->HrefValue = "";
			$this->IN->TooltipValue = "";

			// OUT
			$this->OUT->LinkCustomAttributes = "";
			$this->OUT->HrefValue = "";
			$this->OUT->TooltipValue = "";

			// Balance
			$this->Balance->LinkCustomAttributes = "";
			if (!EmptyValue($this->product_code->CurrentValue)) {
				$this->Balance->HrefValue = "stock_lcgpdlist.php?x_product_code=" . $this->product_code->CurrentValue . "&z_product_code=LIKE"; // Add prefix/suffix
				$this->Balance->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->Balance->HrefValue = FullUrl($this->Balance->HrefValue, "href");
			} else {
				$this->Balance->HrefValue = "";
			}
			$this->Balance->TooltipValue = "";

			// packets
			$this->packets->LinkCustomAttributes = "";
			$this->packets->HrefValue = "";
			$this->packets->TooltipValue = "";

			// packing_type_n
			$this->packing_type_n->LinkCustomAttributes = "";
			$this->packing_type_n->HrefValue = "";
			$this->packing_type_n->TooltipValue = "";

			// lot_no
			$this->lot_no->LinkCustomAttributes = "";
			$this->lot_no->HrefValue = "";
			$this->lot_no->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// url
			$this->url->LinkCustomAttributes = "";
			$this->url->HrefValue = "";
			$this->url->TooltipValue = "";

			// HOLD
			$this->HOLD->LinkCustomAttributes = "";
			$this->HOLD->HrefValue = "";
			$this->HOLD->TooltipValue = "";

			// avg_quantity
			$this->avg_quantity->LinkCustomAttributes = "";
			$this->avg_quantity->HrefValue = "";
			$this->avg_quantity->TooltipValue = "";

			// age
			$this->age->LinkCustomAttributes = "";
			$this->age->HrefValue = "";
			$this->age->TooltipValue = "";

			// company_id
			$this->company_id->LinkCustomAttributes = "";
			$this->company_id->HrefValue = "";
			$this->company_id->TooltipValue = "";

			// s_grp
			$this->s_grp->LinkCustomAttributes = "";
			$this->s_grp->HrefValue = "";
			$this->s_grp->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// grp
			$this->grp->EditAttrs["class"] = "form-control";
			$this->grp->EditCustomAttributes = "";
			$curVal = trim(strval($this->grp->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->grp->AdvancedSearch->ViewValue = $this->grp->lookupCacheOption($curVal);
			else
				$this->grp->AdvancedSearch->ViewValue = $this->grp->Lookup !== NULL && is_array($this->grp->Lookup->Options) ? $curVal : NULL;
			if ($this->grp->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->grp->EditValue = array_values($this->grp->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->grp->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->grp->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->grp->EditValue = $arwrk;
			}

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->product->AdvancedSearch->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->AdvancedSearch->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->product->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// product_code
			$this->product_code->EditAttrs["class"] = "form-control";
			$this->product_code->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->product_code->AdvancedSearch->SearchValue = HtmlDecode($this->product_code->AdvancedSearch->SearchValue);
			$this->product_code->EditValue = HtmlEncode($this->product_code->AdvancedSearch->SearchValue);
			$this->product_code->PlaceHolder = RemoveHtml($this->product_code->caption());

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$curVal = trim(strval($this->godown->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->godown->AdvancedSearch->ViewValue = $this->godown->lookupCacheOption($curVal);
			else
				$this->godown->AdvancedSearch->ViewValue = $this->godown->Lookup !== NULL && is_array($this->godown->Lookup->Options) ? $curVal : NULL;
			if ($this->godown->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->godown->EditValue = array_values($this->godown->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->godown->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->godown->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->godown->EditValue = $arwrk;
			}

			// godown_n
			$this->godown_n->EditAttrs["class"] = "form-control";
			$this->godown_n->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->godown_n->AdvancedSearch->SearchValue = HtmlDecode($this->godown_n->AdvancedSearch->SearchValue);
			$this->godown_n->EditValue = HtmlEncode($this->godown_n->AdvancedSearch->SearchValue);
			$this->godown_n->PlaceHolder = RemoveHtml($this->godown_n->caption());

			// IN
			$this->IN->EditAttrs["class"] = "form-control";
			$this->IN->EditCustomAttributes = "";
			$this->IN->EditValue = HtmlEncode($this->IN->AdvancedSearch->SearchValue);
			$this->IN->PlaceHolder = RemoveHtml($this->IN->caption());

			// OUT
			$this->OUT->EditAttrs["class"] = "form-control";
			$this->OUT->EditCustomAttributes = "";
			$this->OUT->EditValue = HtmlEncode($this->OUT->AdvancedSearch->SearchValue);
			$this->OUT->PlaceHolder = RemoveHtml($this->OUT->caption());

			// Balance
			$this->Balance->EditAttrs["class"] = "form-control";
			$this->Balance->EditCustomAttributes = "";
			$this->Balance->EditValue = HtmlEncode($this->Balance->AdvancedSearch->SearchValue);
			$this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());
			$this->Balance->EditAttrs["class"] = "form-control";
			$this->Balance->EditCustomAttributes = "";
			$this->Balance->EditValue2 = HtmlEncode($this->Balance->AdvancedSearch->SearchValue2);
			$this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());

			// packets
			$this->packets->EditAttrs["class"] = "form-control";
			$this->packets->EditCustomAttributes = "";
			$this->packets->EditValue = HtmlEncode($this->packets->AdvancedSearch->SearchValue);
			$this->packets->PlaceHolder = RemoveHtml($this->packets->caption());

			// packing_type_n
			$this->packing_type_n->EditAttrs["class"] = "form-control";
			$this->packing_type_n->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->packing_type_n->AdvancedSearch->SearchValue = HtmlDecode($this->packing_type_n->AdvancedSearch->SearchValue);
			$this->packing_type_n->EditValue = HtmlEncode($this->packing_type_n->AdvancedSearch->SearchValue);
			$this->packing_type_n->PlaceHolder = RemoveHtml($this->packing_type_n->caption());

			// lot_no
			$this->lot_no->EditAttrs["class"] = "form-control";
			$this->lot_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lot_no->AdvancedSearch->SearchValue = HtmlDecode($this->lot_no->AdvancedSearch->SearchValue);
			$this->lot_no->EditValue = HtmlEncode($this->lot_no->AdvancedSearch->SearchValue);
			$this->lot_no->PlaceHolder = RemoveHtml($this->lot_no->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			$this->packing_type->EditValue = HtmlEncode($this->packing_type->AdvancedSearch->SearchValue);
			$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

			// url
			$this->url->EditAttrs["class"] = "form-control";
			$this->url->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->url->AdvancedSearch->SearchValue = HtmlDecode($this->url->AdvancedSearch->SearchValue);
			$this->url->EditValue = HtmlEncode($this->url->AdvancedSearch->SearchValue);
			$this->url->PlaceHolder = RemoveHtml($this->url->caption());

			// HOLD
			$this->HOLD->EditAttrs["class"] = "form-control";
			$this->HOLD->EditCustomAttributes = "";
			$this->HOLD->EditValue = HtmlEncode($this->HOLD->AdvancedSearch->SearchValue);
			$this->HOLD->PlaceHolder = RemoveHtml($this->HOLD->caption());

			// avg_quantity
			$this->avg_quantity->EditAttrs["class"] = "form-control";
			$this->avg_quantity->EditCustomAttributes = "";
			$this->avg_quantity->EditValue = HtmlEncode($this->avg_quantity->AdvancedSearch->SearchValue);
			$this->avg_quantity->PlaceHolder = RemoveHtml($this->avg_quantity->caption());

			// age
			$this->age->EditAttrs["class"] = "form-control";
			$this->age->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->age->AdvancedSearch->SearchValue = HtmlDecode($this->age->AdvancedSearch->SearchValue);
			$this->age->EditValue = HtmlEncode($this->age->AdvancedSearch->SearchValue);
			$this->age->PlaceHolder = RemoveHtml($this->age->caption());

			// company_id
			$this->company_id->EditAttrs["class"] = "form-control";
			$this->company_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->company_id->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->lookupCacheOption($curVal);
			else
				$this->company_id->AdvancedSearch->ViewValue = $this->company_id->Lookup !== NULL && is_array($this->company_id->Lookup->Options) ? $curVal : NULL;
			if ($this->company_id->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->company_id->EditValue = array_values($this->company_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->company_id->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`id`< 1000 || `category` = 1 ";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->company_id->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->company_id->EditValue = $arwrk;
			}

			// s_grp
			$this->s_grp->EditAttrs["class"] = "form-control";
			$this->s_grp->EditCustomAttributes = "";
			$this->s_grp->EditValue = HtmlEncode($this->s_grp->AdvancedSearch->SearchValue);
			$this->s_grp->PlaceHolder = RemoveHtml($this->s_grp->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckNumber($this->IN->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->IN->errorMessage());
		}
		if (!CheckNumber($this->OUT->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->OUT->errorMessage());
		}
		if (!CheckNumber($this->Balance->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->Balance->errorMessage());
		}
		if (!CheckNumber($this->Balance->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->Balance->errorMessage());
		}
		if (!CheckNumber($this->packets->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->packets->errorMessage());
		}
		if (!CheckInteger($this->packing_type->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->packing_type->errorMessage());
		}
		if (!CheckNumber($this->HOLD->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->HOLD->errorMessage());
		}
		if (!CheckNumber($this->avg_quantity->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->avg_quantity->errorMessage());
		}
		if (!CheckInteger($this->age->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->age->errorMessage());
		}
		if (!CheckInteger($this->s_grp->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->s_grp->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->grp->AdvancedSearch->load();
		$this->product->AdvancedSearch->load();
		$this->product_code->AdvancedSearch->load();
		$this->godown->AdvancedSearch->load();
		$this->godown_n->AdvancedSearch->load();
		$this->IN->AdvancedSearch->load();
		$this->OUT->AdvancedSearch->load();
		$this->Balance->AdvancedSearch->load();
		$this->packets->AdvancedSearch->load();
		$this->packing_type_n->AdvancedSearch->load();
		$this->lot_no->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->url->AdvancedSearch->load();
		$this->HOLD->AdvancedSearch->load();
		$this->avg_quantity->AdvancedSearch->load();
		$this->age->AdvancedSearch->load();
		$this->company_id->AdvancedSearch->load();
		$this->s_grp->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("stock_lcgplist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_grp":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_company_id":
					$lookupFilter = function() {
						return "`id`< 1000 || `category` = 1 ";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_grp":
							break;
						case "x_product":
							break;
						case "x_godown":
							break;
						case "x_company_id":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>