<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class stock_material_out_emp_hs_addopt extends stock_material_out_emp_hs
{

	// Page ID
	public $PageID = "addopt";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 'stock_material_out_emp_hs';

	// Page object name
	public $PageObjName = "stock_material_out_emp_hs_addopt";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (stock_material_out_emp_hs)
		if (!isset($GLOBALS["stock_material_out_emp_hs"]) || get_class($GLOBALS["stock_material_out_emp_hs"]) == PROJECT_NAMESPACE . "stock_material_out_emp_hs") {
			$GLOBALS["stock_material_out_emp_hs"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["stock_material_out_emp_hs"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'addopt');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 'stock_material_out_emp_hs');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $stock_material_out_emp_hs;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($stock_material_out_emp_hs);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
	}

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("stock_material_out_emp_hslist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->product->setVisibility();
		$this->jc_no->setVisibility();
		$this->emp_id->setVisibility();
		$this->emp_name->setVisibility();
		$this->rid->setVisibility();
		$this->OUT->setVisibility();
		$this->item->setVisibility();
		$this->item_code->setVisibility();
		$this->IN->setVisibility();
		$this->Balance->setVisibility();
		$this->godown->setVisibility();
		$this->outid->setVisibility();
		$this->Shortage->setVisibility();
		$this->count->setVisibility();
		$this->jc_quantity->setVisibility();
		$this->po->setVisibility();
		$this->batch_no->setVisibility();
		$this->count_received->setVisibility();
		$this->status->setVisibility();
		$this->jc_no_fp->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->product);
		$this->setupLookupOptions($this->jc_no);
		$this->setupLookupOptions($this->emp_id);
		$this->setupLookupOptions($this->emp_name);
		$this->setupLookupOptions($this->rid);
		$this->setupLookupOptions($this->OUT);
		$this->setupLookupOptions($this->item);
		$this->setupLookupOptions($this->item_code);
		$this->setupLookupOptions($this->IN);
		$this->setupLookupOptions($this->godown);
		$this->setupLookupOptions($this->outid);
		set_error_handler(PROJECT_NAMESPACE . "ErrorHandler");

		// Set up Breadcrumb
		//$this->setupBreadcrumb(); // Not used

		$this->loadRowValues(); // Load default values

		// Render row
		$this->RowType = ROWTYPE_ADD; // Render add type
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->product->CurrentValue = NULL;
		$this->product->OldValue = $this->product->CurrentValue;
		$this->jc_no->CurrentValue = NULL;
		$this->jc_no->OldValue = $this->jc_no->CurrentValue;
		$this->emp_id->CurrentValue = NULL;
		$this->emp_id->OldValue = $this->emp_id->CurrentValue;
		$this->emp_name->CurrentValue = NULL;
		$this->emp_name->OldValue = $this->emp_name->CurrentValue;
		$this->rid->CurrentValue = NULL;
		$this->rid->OldValue = $this->rid->CurrentValue;
		$this->OUT->CurrentValue = 0.000;
		$this->item->CurrentValue = NULL;
		$this->item->OldValue = $this->item->CurrentValue;
		$this->item_code->CurrentValue = NULL;
		$this->item_code->OldValue = $this->item_code->CurrentValue;
		$this->IN->CurrentValue = 0.000;
		$this->Balance->CurrentValue = 0.000;
		$this->godown->CurrentValue = NULL;
		$this->godown->OldValue = $this->godown->CurrentValue;
		$this->outid->CurrentValue = 0;
		$this->Shortage->CurrentValue = NULL;
		$this->Shortage->OldValue = $this->Shortage->CurrentValue;
		$this->count->CurrentValue = NULL;
		$this->count->OldValue = $this->count->CurrentValue;
		$this->jc_quantity->CurrentValue = NULL;
		$this->jc_quantity->OldValue = $this->jc_quantity->CurrentValue;
		$this->po->CurrentValue = NULL;
		$this->po->OldValue = $this->po->CurrentValue;
		$this->batch_no->CurrentValue = NULL;
		$this->batch_no->OldValue = $this->batch_no->CurrentValue;
		$this->count_received->CurrentValue = NULL;
		$this->count_received->OldValue = $this->count_received->CurrentValue;
		$this->status->CurrentValue = NULL;
		$this->status->OldValue = $this->status->CurrentValue;
		$this->jc_no_fp->CurrentValue = NULL;
		$this->jc_no_fp->OldValue = $this->jc_no_fp->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'product' first before field var 'x_product'
		$val = $CurrentForm->hasValue("product") ? $CurrentForm->getValue("product") : $CurrentForm->getValue("x_product");
		if (!$this->product->IsDetailKey) {
			$this->product->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'jc_no' first before field var 'x_jc_no'
		$val = $CurrentForm->hasValue("jc_no") ? $CurrentForm->getValue("jc_no") : $CurrentForm->getValue("x_jc_no");
		if (!$this->jc_no->IsDetailKey) {
			$this->jc_no->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'emp_id' first before field var 'x_emp_id'
		$val = $CurrentForm->hasValue("emp_id") ? $CurrentForm->getValue("emp_id") : $CurrentForm->getValue("x_emp_id");
		if (!$this->emp_id->IsDetailKey) {
			$this->emp_id->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'emp_name' first before field var 'x_emp_name'
		$val = $CurrentForm->hasValue("emp_name") ? $CurrentForm->getValue("emp_name") : $CurrentForm->getValue("x_emp_name");
		if (!$this->emp_name->IsDetailKey) {
			$this->emp_name->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'rid' first before field var 'x_rid'
		$val = $CurrentForm->hasValue("rid") ? $CurrentForm->getValue("rid") : $CurrentForm->getValue("x_rid");
		if (!$this->rid->IsDetailKey) {
			$this->rid->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'OUT' first before field var 'x_OUT'
		$val = $CurrentForm->hasValue("OUT") ? $CurrentForm->getValue("OUT") : $CurrentForm->getValue("x_OUT");
		if (!$this->OUT->IsDetailKey) {
			$this->OUT->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'item' first before field var 'x_item'
		$val = $CurrentForm->hasValue("item") ? $CurrentForm->getValue("item") : $CurrentForm->getValue("x_item");
		if (!$this->item->IsDetailKey) {
			$this->item->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'item_code' first before field var 'x_item_code'
		$val = $CurrentForm->hasValue("item_code") ? $CurrentForm->getValue("item_code") : $CurrentForm->getValue("x_item_code");
		if (!$this->item_code->IsDetailKey) {
			$this->item_code->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'IN' first before field var 'x_IN'
		$val = $CurrentForm->hasValue("IN") ? $CurrentForm->getValue("IN") : $CurrentForm->getValue("x_IN");
		if (!$this->IN->IsDetailKey) {
			$this->IN->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'Balance' first before field var 'x_Balance'
		$val = $CurrentForm->hasValue("Balance") ? $CurrentForm->getValue("Balance") : $CurrentForm->getValue("x_Balance");
		if (!$this->Balance->IsDetailKey) {
			$this->Balance->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'godown' first before field var 'x_godown'
		$val = $CurrentForm->hasValue("godown") ? $CurrentForm->getValue("godown") : $CurrentForm->getValue("x_godown");
		if (!$this->godown->IsDetailKey) {
			$this->godown->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'outid' first before field var 'x_outid'
		$val = $CurrentForm->hasValue("outid") ? $CurrentForm->getValue("outid") : $CurrentForm->getValue("x_outid");
		if (!$this->outid->IsDetailKey) {
			$this->outid->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'Shortage' first before field var 'x_Shortage'
		$val = $CurrentForm->hasValue("Shortage") ? $CurrentForm->getValue("Shortage") : $CurrentForm->getValue("x_Shortage");
		if (!$this->Shortage->IsDetailKey) {
			$this->Shortage->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'count' first before field var 'x_count'
		$val = $CurrentForm->hasValue("count") ? $CurrentForm->getValue("count") : $CurrentForm->getValue("x_count");
		if (!$this->count->IsDetailKey) {
			$this->count->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'jc_quantity' first before field var 'x_jc_quantity'
		$val = $CurrentForm->hasValue("jc_quantity") ? $CurrentForm->getValue("jc_quantity") : $CurrentForm->getValue("x_jc_quantity");
		if (!$this->jc_quantity->IsDetailKey) {
			$this->jc_quantity->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'po' first before field var 'x_po'
		$val = $CurrentForm->hasValue("po") ? $CurrentForm->getValue("po") : $CurrentForm->getValue("x_po");
		if (!$this->po->IsDetailKey) {
			$this->po->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'batch_no' first before field var 'x_batch_no'
		$val = $CurrentForm->hasValue("batch_no") ? $CurrentForm->getValue("batch_no") : $CurrentForm->getValue("x_batch_no");
		if (!$this->batch_no->IsDetailKey) {
			$this->batch_no->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'count_received' first before field var 'x_count_received'
		$val = $CurrentForm->hasValue("count_received") ? $CurrentForm->getValue("count_received") : $CurrentForm->getValue("x_count_received");
		if (!$this->count_received->IsDetailKey) {
			$this->count_received->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			$this->status->setFormValue(ConvertFromUtf8($val));
		}

		// Check field name 'jc_no_fp' first before field var 'x_jc_no_fp'
		$val = $CurrentForm->hasValue("jc_no_fp") ? $CurrentForm->getValue("jc_no_fp") : $CurrentForm->getValue("x_jc_no_fp");
		if (!$this->jc_no_fp->IsDetailKey) {
			$this->jc_no_fp->setFormValue(ConvertFromUtf8($val));
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->product->CurrentValue = ConvertToUtf8($this->product->FormValue);
		$this->jc_no->CurrentValue = ConvertToUtf8($this->jc_no->FormValue);
		$this->emp_id->CurrentValue = ConvertToUtf8($this->emp_id->FormValue);
		$this->emp_name->CurrentValue = ConvertToUtf8($this->emp_name->FormValue);
		$this->rid->CurrentValue = ConvertToUtf8($this->rid->FormValue);
		$this->OUT->CurrentValue = ConvertToUtf8($this->OUT->FormValue);
		$this->item->CurrentValue = ConvertToUtf8($this->item->FormValue);
		$this->item_code->CurrentValue = ConvertToUtf8($this->item_code->FormValue);
		$this->IN->CurrentValue = ConvertToUtf8($this->IN->FormValue);
		$this->Balance->CurrentValue = ConvertToUtf8($this->Balance->FormValue);
		$this->godown->CurrentValue = ConvertToUtf8($this->godown->FormValue);
		$this->outid->CurrentValue = ConvertToUtf8($this->outid->FormValue);
		$this->Shortage->CurrentValue = ConvertToUtf8($this->Shortage->FormValue);
		$this->count->CurrentValue = ConvertToUtf8($this->count->FormValue);
		$this->jc_quantity->CurrentValue = ConvertToUtf8($this->jc_quantity->FormValue);
		$this->po->CurrentValue = ConvertToUtf8($this->po->FormValue);
		$this->batch_no->CurrentValue = ConvertToUtf8($this->batch_no->FormValue);
		$this->count_received->CurrentValue = ConvertToUtf8($this->count_received->FormValue);
		$this->status->CurrentValue = ConvertToUtf8($this->status->FormValue);
		$this->jc_no_fp->CurrentValue = ConvertToUtf8($this->jc_no_fp->FormValue);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->product->setDbValue($row['product']);
		$this->jc_no->setDbValue($row['jc_no']);
		$this->emp_id->setDbValue($row['emp_id']);
		$this->emp_name->setDbValue($row['emp_name']);
		$this->rid->setDbValue($row['rid']);
		$this->OUT->setDbValue($row['OUT']);
		$this->item->setDbValue($row['item']);
		$this->item_code->setDbValue($row['item_code']);
		$this->IN->setDbValue($row['IN']);
		$this->Balance->setDbValue($row['Balance']);
		$this->godown->setDbValue($row['godown']);
		$this->outid->setDbValue($row['outid']);
		$this->Shortage->setDbValue($row['Shortage']);
		$this->count->setDbValue($row['count']);
		$this->jc_quantity->setDbValue($row['jc_quantity']);
		$this->po->setDbValue($row['po']);
		$this->batch_no->setDbValue($row['batch_no']);
		$this->count_received->setDbValue($row['count_received']);
		$this->status->setDbValue($row['status']);
		$this->jc_no_fp->setDbValue($row['jc_no_fp']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['product'] = $this->product->CurrentValue;
		$row['jc_no'] = $this->jc_no->CurrentValue;
		$row['emp_id'] = $this->emp_id->CurrentValue;
		$row['emp_name'] = $this->emp_name->CurrentValue;
		$row['rid'] = $this->rid->CurrentValue;
		$row['OUT'] = $this->OUT->CurrentValue;
		$row['item'] = $this->item->CurrentValue;
		$row['item_code'] = $this->item_code->CurrentValue;
		$row['IN'] = $this->IN->CurrentValue;
		$row['Balance'] = $this->Balance->CurrentValue;
		$row['godown'] = $this->godown->CurrentValue;
		$row['outid'] = $this->outid->CurrentValue;
		$row['Shortage'] = $this->Shortage->CurrentValue;
		$row['count'] = $this->count->CurrentValue;
		$row['jc_quantity'] = $this->jc_quantity->CurrentValue;
		$row['po'] = $this->po->CurrentValue;
		$row['batch_no'] = $this->batch_no->CurrentValue;
		$row['count_received'] = $this->count_received->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['jc_no_fp'] = $this->jc_no_fp->CurrentValue;
		return $row;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->Balance->FormValue == $this->Balance->CurrentValue && is_numeric(ConvertToFloatString($this->Balance->CurrentValue)))
			$this->Balance->CurrentValue = ConvertToFloatString($this->Balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->jc_quantity->FormValue == $this->jc_quantity->CurrentValue && is_numeric(ConvertToFloatString($this->jc_quantity->CurrentValue)))
			$this->jc_quantity->CurrentValue = ConvertToFloatString($this->jc_quantity->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// product
		// jc_no
		// emp_id
		// emp_name
		// rid
		// OUT
		// item
		// item_code
		// IN
		// Balance
		// godown
		// outid
		// Shortage
		// count
		// jc_quantity
		// po
		// batch_no
		// count_received
		// status
		// jc_no_fp

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// product
			$curVal = strval($this->product->CurrentValue);
			if ($curVal <> "") {
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
				if ($this->product->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`product`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->product->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->product->ViewValue = $this->product->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->product->ViewValue = $this->product->CurrentValue;
					}
				}
			} else {
				$this->product->ViewValue = NULL;
			}
			$this->product->ViewCustomAttributes = "";

			// jc_no
			$curVal = strval($this->jc_no->CurrentValue);
			if ($curVal <> "") {
				$this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
				if ($this->jc_no->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->jc_no->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->jc_no->ViewValue = $this->jc_no->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->jc_no->ViewValue = $this->jc_no->CurrentValue;
					}
				}
			} else {
				$this->jc_no->ViewValue = NULL;
			}
			$this->jc_no->ViewCustomAttributes = "";

			// emp_id
			$curVal = strval($this->emp_id->CurrentValue);
			if ($curVal <> "") {
				$this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
				if ($this->emp_id->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->emp_id->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = FormatNumber($rswrk->fields('df2'), 0, -2, -2, -2);
						$this->emp_id->ViewValue = $this->emp_id->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->emp_id->ViewValue = $this->emp_id->CurrentValue;
					}
				}
			} else {
				$this->emp_id->ViewValue = NULL;
			}
			$this->emp_id->ViewCustomAttributes = "";

			// emp_name
			$curVal = strval($this->emp_name->CurrentValue);
			if ($curVal <> "") {
				$this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
				if ($this->emp_name->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`user_name`" . SearchString("=", $curVal, DATATYPE_STRING, "");
					$sqlWrk = $this->emp_name->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->emp_name->ViewValue = $this->emp_name->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->emp_name->ViewValue = $this->emp_name->CurrentValue;
					}
				}
			} else {
				$this->emp_name->ViewValue = NULL;
			}
			$this->emp_name->ViewCustomAttributes = "";

			// rid
			$curVal = strval($this->rid->CurrentValue);
			if ($curVal <> "") {
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
				if ($this->rid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->rid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->rid->ViewValue = $this->rid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->rid->ViewValue = $this->rid->CurrentValue;
					}
				}
			} else {
				$this->rid->ViewValue = NULL;
			}
			$this->rid->ViewCustomAttributes = "";

			// OUT
			$curVal = strval($this->OUT->CurrentValue);
			if ($curVal <> "") {
				$this->OUT->ViewValue = $this->OUT->lookupCacheOption($curVal);
				if ($this->OUT->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`quantity`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->OUT->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 2, -2, -2, -2);
						$this->OUT->ViewValue = $this->OUT->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->OUT->ViewValue = $this->OUT->CurrentValue;
					}
				}
			} else {
				$this->OUT->ViewValue = NULL;
			}
			$this->OUT->ViewCustomAttributes = "";

			// item
			$this->item->ViewValue = $this->item->CurrentValue;
			$curVal = strval($this->item->CurrentValue);
			if ($curVal <> "") {
				$this->item->ViewValue = $this->item->lookupCacheOption($curVal);
				if ($this->item->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`item`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->item->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->item->ViewValue = $this->item->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->item->ViewValue = $this->item->CurrentValue;
					}
				}
			} else {
				$this->item->ViewValue = NULL;
			}
			$this->item->ViewCustomAttributes = "";

			// item_code
			$curVal = strval($this->item_code->CurrentValue);
			if ($curVal <> "") {
				$this->item_code->ViewValue = $this->item_code->lookupCacheOption($curVal);
				if ($this->item_code->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`item_code`" . SearchString("=", $curVal, DATATYPE_MEMO, "");
					$sqlWrk = $this->item_code->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->item_code->ViewValue = $this->item_code->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->item_code->ViewValue = $this->item_code->CurrentValue;
					}
				}
			} else {
				$this->item_code->ViewValue = NULL;
			}
			$this->item_code->ViewCustomAttributes = "";

			// IN
			$curVal = strval($this->IN->CurrentValue);
			if ($curVal <> "") {
				$this->IN->ViewValue = $this->IN->lookupCacheOption($curVal);
				if ($this->IN->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`quantity`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->IN->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = FormatNumber($rswrk->fields('df'), 2, -2, -2, -2);
						$this->IN->ViewValue = $this->IN->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->IN->ViewValue = $this->IN->CurrentValue;
					}
				}
			} else {
				$this->IN->ViewValue = NULL;
			}
			$this->IN->ViewCustomAttributes = "";

			// Balance
			$this->Balance->ViewValue = $this->Balance->CurrentValue;
			$this->Balance->ViewValue = FormatNumber($this->Balance->ViewValue, 2, -2, -2, -2);
			$this->Balance->ViewCustomAttributes = "";

			// godown
			$curVal = strval($this->godown->CurrentValue);
			if ($curVal <> "") {
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
				if ($this->godown->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->godown->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->godown->ViewValue = $this->godown->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->godown->ViewValue = $this->godown->CurrentValue;
					}
				}
			} else {
				$this->godown->ViewValue = NULL;
			}
			$this->godown->ViewCustomAttributes = "";

			// outid
			$curVal = strval($this->outid->CurrentValue);
			if ($curVal <> "") {
				$this->outid->ViewValue = $this->outid->lookupCacheOption($curVal);
				if ($this->outid->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->outid->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->outid->ViewValue = $this->outid->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->outid->ViewValue = $this->outid->CurrentValue;
					}
				}
			} else {
				$this->outid->ViewValue = NULL;
			}
			$this->outid->ViewCustomAttributes = "";

			// Shortage
			$this->Shortage->ViewValue = $this->Shortage->CurrentValue;
			$this->Shortage->ViewCustomAttributes = "";

			// count
			$this->count->ViewValue = $this->count->CurrentValue;
			$this->count->ViewValue = FormatNumber($this->count->ViewValue, 0, -2, -2, -2);
			$this->count->ViewCustomAttributes = "";

			// jc_quantity
			$this->jc_quantity->ViewValue = $this->jc_quantity->CurrentValue;
			$this->jc_quantity->ViewValue = FormatNumber($this->jc_quantity->ViewValue, 2, -2, -2, -2);
			$this->jc_quantity->ViewCustomAttributes = "";

			// po
			$this->po->ViewValue = $this->po->CurrentValue;
			$this->po->ViewCustomAttributes = "";

			// batch_no
			$this->batch_no->ViewValue = $this->batch_no->CurrentValue;
			$this->batch_no->ViewCustomAttributes = "";

			// count_received
			$this->count_received->ViewValue = $this->count_received->CurrentValue;
			$this->count_received->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// jc_no_fp
			$this->jc_no_fp->ViewValue = $this->jc_no_fp->CurrentValue;
			$this->jc_no_fp->ViewValue = FormatNumber($this->jc_no_fp->ViewValue, 0, -2, -2, -2);
			$this->jc_no_fp->ViewCustomAttributes = "";

			// product
			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "stock_material_out_emp_hslist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}
			$this->product->TooltipValue = "";

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->jc_no->CurrentValue)) {
				$this->jc_no->HrefValue = "stock_material_out_emp_hslist.php?x_jc_no=" . $this->jc_no->CurrentValue; // Add prefix/suffix
				$this->jc_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->jc_no->HrefValue = FullUrl($this->jc_no->HrefValue, "href");
			} else {
				$this->jc_no->HrefValue = "";
			}
			$this->jc_no->TooltipValue = "";

			// emp_id
			$this->emp_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->emp_id->CurrentValue)) {
				$this->emp_id->HrefValue = "stock_material_out_emp_hslist.php?x_emp_id=" . $this->emp_id->CurrentValue; // Add prefix/suffix
				$this->emp_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->emp_id->HrefValue = FullUrl($this->emp_id->HrefValue, "href");
			} else {
				$this->emp_id->HrefValue = "";
			}
			$this->emp_id->TooltipValue = "";

			// emp_name
			$this->emp_name->LinkCustomAttributes = "";
			if (!EmptyValue($this->emp_name->CurrentValue)) {
				$this->emp_name->HrefValue = "stock_material_out_emp_hslist.php?x_user_name=" . $this->emp_name->CurrentValue; // Add prefix/suffix
				$this->emp_name->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->emp_name->HrefValue = FullUrl($this->emp_name->HrefValue, "href");
			} else {
				$this->emp_name->HrefValue = "";
			}
			$this->emp_name->TooltipValue = "";

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";
			$this->rid->TooltipValue = "";

			// OUT
			$this->OUT->LinkCustomAttributes = "";
			$this->OUT->HrefValue = "";
			$this->OUT->TooltipValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			if (!EmptyValue($this->item->CurrentValue)) {
				$this->item->HrefValue = "stock_material_out_emp_hslist.php?x_item=" . $this->item->CurrentValue; // Add prefix/suffix
				$this->item->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
			} else {
				$this->item->HrefValue = "";
			}
			$this->item->TooltipValue = "";

			// item_code
			$this->item_code->LinkCustomAttributes = "";
			$this->item_code->HrefValue = "";
			$this->item_code->TooltipValue = "";

			// IN
			$this->IN->LinkCustomAttributes = "";
			$this->IN->HrefValue = "";
			$this->IN->TooltipValue = "";

			// Balance
			$this->Balance->LinkCustomAttributes = "";
			$this->Balance->HrefValue = "";
			$this->Balance->TooltipValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "stock_material_out_emp_hslist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}
			$this->godown->TooltipValue = "";

			// outid
			$this->outid->LinkCustomAttributes = "";
			$this->outid->HrefValue = "";
			$this->outid->TooltipValue = "";

			// Shortage
			$this->Shortage->LinkCustomAttributes = "";
			$this->Shortage->HrefValue = "";
			$this->Shortage->TooltipValue = "";

			// count
			$this->count->LinkCustomAttributes = "";
			$this->count->HrefValue = "";
			$this->count->TooltipValue = "";

			// jc_quantity
			$this->jc_quantity->LinkCustomAttributes = "";
			$this->jc_quantity->HrefValue = "";
			$this->jc_quantity->TooltipValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";
			$this->po->TooltipValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";
			$this->batch_no->TooltipValue = "";

			// count_received
			$this->count_received->LinkCustomAttributes = "";
			$this->count_received->HrefValue = "";
			$this->count_received->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// jc_no_fp
			$this->jc_no_fp->LinkCustomAttributes = "";
			$this->jc_no_fp->HrefValue = "";
			$this->jc_no_fp->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// product
			$this->product->EditAttrs["class"] = "form-control";
			$this->product->EditCustomAttributes = "";
			$curVal = trim(strval($this->product->CurrentValue));
			if ($curVal <> "")
				$this->product->ViewValue = $this->product->lookupCacheOption($curVal);
			else
				$this->product->ViewValue = $this->product->Lookup !== NULL && is_array($this->product->Lookup->Options) ? $curVal : NULL;
			if ($this->product->ViewValue !== NULL) { // Load from cache
				$this->product->EditValue = array_values($this->product->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`product`" . SearchString("=", $this->product->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->product->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->product->EditValue = $arwrk;
			}

			// jc_no
			$this->jc_no->EditAttrs["class"] = "form-control";
			$this->jc_no->EditCustomAttributes = "";
			$curVal = trim(strval($this->jc_no->CurrentValue));
			if ($curVal <> "")
				$this->jc_no->ViewValue = $this->jc_no->lookupCacheOption($curVal);
			else
				$this->jc_no->ViewValue = $this->jc_no->Lookup !== NULL && is_array($this->jc_no->Lookup->Options) ? $curVal : NULL;
			if ($this->jc_no->ViewValue !== NULL) { // Load from cache
				$this->jc_no->EditValue = array_values($this->jc_no->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->jc_no->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->jc_no->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->jc_no->EditValue = $arwrk;
			}

			// emp_id
			$this->emp_id->EditAttrs["class"] = "form-control";
			$this->emp_id->EditCustomAttributes = "";
			$curVal = trim(strval($this->emp_id->CurrentValue));
			if ($curVal <> "")
				$this->emp_id->ViewValue = $this->emp_id->lookupCacheOption($curVal);
			else
				$this->emp_id->ViewValue = $this->emp_id->Lookup !== NULL && is_array($this->emp_id->Lookup->Options) ? $curVal : NULL;
			if ($this->emp_id->ViewValue !== NULL) { // Load from cache
				$this->emp_id->EditValue = array_values($this->emp_id->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->emp_id->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->emp_id->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][2] = FormatNumber($arwrk[$i][2], 0, -2, -2, -2);
				}
				$this->emp_id->EditValue = $arwrk;
			}

			// emp_name
			$this->emp_name->EditAttrs["class"] = "form-control";
			$this->emp_name->EditCustomAttributes = "";
			$curVal = trim(strval($this->emp_name->CurrentValue));
			if ($curVal <> "")
				$this->emp_name->ViewValue = $this->emp_name->lookupCacheOption($curVal);
			else
				$this->emp_name->ViewValue = $this->emp_name->Lookup !== NULL && is_array($this->emp_name->Lookup->Options) ? $curVal : NULL;
			if ($this->emp_name->ViewValue !== NULL) { // Load from cache
				$this->emp_name->EditValue = array_values($this->emp_name->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`user_name`" . SearchString("=", $this->emp_name->CurrentValue, DATATYPE_STRING, "");
				}
				$sqlWrk = $this->emp_name->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->emp_name->EditValue = $arwrk;
			}

			// rid
			$this->rid->EditAttrs["class"] = "form-control";
			$this->rid->EditCustomAttributes = "";
			$curVal = trim(strval($this->rid->CurrentValue));
			if ($curVal <> "")
				$this->rid->ViewValue = $this->rid->lookupCacheOption($curVal);
			else
				$this->rid->ViewValue = $this->rid->Lookup !== NULL && is_array($this->rid->Lookup->Options) ? $curVal : NULL;
			if ($this->rid->ViewValue !== NULL) { // Load from cache
				$this->rid->EditValue = array_values($this->rid->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->rid->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->rid->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->rid->EditValue = $arwrk;
			}

			// OUT
			$this->OUT->EditAttrs["class"] = "form-control";
			$this->OUT->EditCustomAttributes = "";
			$curVal = trim(strval($this->OUT->CurrentValue));
			if ($curVal <> "")
				$this->OUT->ViewValue = $this->OUT->lookupCacheOption($curVal);
			else
				$this->OUT->ViewValue = $this->OUT->Lookup !== NULL && is_array($this->OUT->Lookup->Options) ? $curVal : NULL;
			if ($this->OUT->ViewValue !== NULL) { // Load from cache
				$this->OUT->EditValue = array_values($this->OUT->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`quantity`" . SearchString("=", $this->OUT->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->OUT->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 2, -2, -2, -2);
				}
				$this->OUT->EditValue = $arwrk;
			}

			// item
			$this->item->EditAttrs["class"] = "form-control";
			$this->item->EditCustomAttributes = "";
			$this->item->EditValue = HtmlEncode($this->item->CurrentValue);
			$curVal = strval($this->item->CurrentValue);
			if ($curVal <> "") {
				$this->item->EditValue = $this->item->lookupCacheOption($curVal);
				if ($this->item->EditValue === NULL) { // Lookup from database
					$filterWrk = "`item`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->item->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->item->EditValue = $this->item->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->item->EditValue = HtmlEncode($this->item->CurrentValue);
					}
				}
			} else {
				$this->item->EditValue = NULL;
			}
			$this->item->PlaceHolder = RemoveHtml($this->item->caption());

			// item_code
			$this->item_code->EditAttrs["class"] = "form-control";
			$this->item_code->EditCustomAttributes = "";
			$curVal = trim(strval($this->item_code->CurrentValue));
			if ($curVal <> "")
				$this->item_code->ViewValue = $this->item_code->lookupCacheOption($curVal);
			else
				$this->item_code->ViewValue = $this->item_code->Lookup !== NULL && is_array($this->item_code->Lookup->Options) ? $curVal : NULL;
			if ($this->item_code->ViewValue !== NULL) { // Load from cache
				$this->item_code->EditValue = array_values($this->item_code->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`item_code`" . SearchString("=", $this->item_code->CurrentValue, DATATYPE_MEMO, "");
				}
				$sqlWrk = $this->item_code->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->item_code->EditValue = $arwrk;
			}

			// IN
			$this->IN->EditAttrs["class"] = "form-control";
			$this->IN->EditCustomAttributes = "";
			$curVal = trim(strval($this->IN->CurrentValue));
			if ($curVal <> "")
				$this->IN->ViewValue = $this->IN->lookupCacheOption($curVal);
			else
				$this->IN->ViewValue = $this->IN->Lookup !== NULL && is_array($this->IN->Lookup->Options) ? $curVal : NULL;
			if ($this->IN->ViewValue !== NULL) { // Load from cache
				$this->IN->EditValue = array_values($this->IN->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`quantity`" . SearchString("=", $this->IN->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->IN->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$rowcnt = count($arwrk);
				for ($i = 0; $i < $rowcnt; $i++) {
					$arwrk[$i][1] = FormatNumber($arwrk[$i][1], 2, -2, -2, -2);
				}
				$this->IN->EditValue = $arwrk;
			}

			// Balance
			$this->Balance->EditAttrs["class"] = "form-control";
			$this->Balance->EditCustomAttributes = "";
			$this->Balance->EditValue = HtmlEncode($this->Balance->CurrentValue);
			$this->Balance->PlaceHolder = RemoveHtml($this->Balance->caption());
			if (strval($this->Balance->EditValue) <> "" && is_numeric($this->Balance->EditValue))
				$this->Balance->EditValue = FormatNumber($this->Balance->EditValue, -2, -2, -2, -2);

			// godown
			$this->godown->EditAttrs["class"] = "form-control";
			$this->godown->EditCustomAttributes = "";
			$curVal = trim(strval($this->godown->CurrentValue));
			if ($curVal <> "")
				$this->godown->ViewValue = $this->godown->lookupCacheOption($curVal);
			else
				$this->godown->ViewValue = $this->godown->Lookup !== NULL && is_array($this->godown->Lookup->Options) ? $curVal : NULL;
			if ($this->godown->ViewValue !== NULL) { // Load from cache
				$this->godown->EditValue = array_values($this->godown->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->godown->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->godown->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->godown->EditValue = $arwrk;
			}

			// outid
			$this->outid->EditAttrs["class"] = "form-control";
			$this->outid->EditCustomAttributes = "";
			$curVal = trim(strval($this->outid->CurrentValue));
			if ($curVal <> "")
				$this->outid->ViewValue = $this->outid->lookupCacheOption($curVal);
			else
				$this->outid->ViewValue = $this->outid->Lookup !== NULL && is_array($this->outid->Lookup->Options) ? $curVal : NULL;
			if ($this->outid->ViewValue !== NULL) { // Load from cache
				$this->outid->EditValue = array_values($this->outid->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->outid->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->outid->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->outid->EditValue = $arwrk;
			}

			// Shortage
			$this->Shortage->EditAttrs["class"] = "form-control";
			$this->Shortage->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->Shortage->CurrentValue = HtmlDecode($this->Shortage->CurrentValue);
			$this->Shortage->EditValue = HtmlEncode($this->Shortage->CurrentValue);
			$this->Shortage->PlaceHolder = RemoveHtml($this->Shortage->caption());

			// count
			$this->count->EditAttrs["class"] = "form-control";
			$this->count->EditCustomAttributes = "";
			$this->count->EditValue = HtmlEncode($this->count->CurrentValue);
			$this->count->PlaceHolder = RemoveHtml($this->count->caption());

			// jc_quantity
			$this->jc_quantity->EditAttrs["class"] = "form-control";
			$this->jc_quantity->EditCustomAttributes = "";
			$this->jc_quantity->EditValue = HtmlEncode($this->jc_quantity->CurrentValue);
			$this->jc_quantity->PlaceHolder = RemoveHtml($this->jc_quantity->caption());
			if (strval($this->jc_quantity->EditValue) <> "" && is_numeric($this->jc_quantity->EditValue))
				$this->jc_quantity->EditValue = FormatNumber($this->jc_quantity->EditValue, -2, -2, -2, -2);

			// po
			$this->po->EditAttrs["class"] = "form-control";
			$this->po->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->po->CurrentValue = HtmlDecode($this->po->CurrentValue);
			$this->po->EditValue = HtmlEncode($this->po->CurrentValue);
			$this->po->PlaceHolder = RemoveHtml($this->po->caption());

			// batch_no
			$this->batch_no->EditAttrs["class"] = "form-control";
			$this->batch_no->EditCustomAttributes = "";
			$this->batch_no->EditValue = HtmlEncode($this->batch_no->CurrentValue);
			$this->batch_no->PlaceHolder = RemoveHtml($this->batch_no->caption());

			// count_received
			$this->count_received->EditAttrs["class"] = "form-control";
			$this->count_received->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->count_received->CurrentValue = HtmlDecode($this->count_received->CurrentValue);
			$this->count_received->EditValue = HtmlEncode($this->count_received->CurrentValue);
			$this->count_received->PlaceHolder = RemoveHtml($this->count_received->caption());

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// jc_no_fp
			$this->jc_no_fp->EditAttrs["class"] = "form-control";
			$this->jc_no_fp->EditCustomAttributes = "";
			$this->jc_no_fp->EditValue = HtmlEncode($this->jc_no_fp->CurrentValue);
			$this->jc_no_fp->PlaceHolder = RemoveHtml($this->jc_no_fp->caption());

			// Add refer script
			// product

			$this->product->LinkCustomAttributes = "";
			if (!EmptyValue($this->product->CurrentValue)) {
				$this->product->HrefValue = "stock_material_out_emp_hslist.php?x_product=" . $this->product->CurrentValue; // Add prefix/suffix
				$this->product->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->product->HrefValue = FullUrl($this->product->HrefValue, "href");
			} else {
				$this->product->HrefValue = "";
			}

			// jc_no
			$this->jc_no->LinkCustomAttributes = "";
			if (!EmptyValue($this->jc_no->CurrentValue)) {
				$this->jc_no->HrefValue = "stock_material_out_emp_hslist.php?x_jc_no=" . $this->jc_no->CurrentValue; // Add prefix/suffix
				$this->jc_no->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->jc_no->HrefValue = FullUrl($this->jc_no->HrefValue, "href");
			} else {
				$this->jc_no->HrefValue = "";
			}

			// emp_id
			$this->emp_id->LinkCustomAttributes = "";
			if (!EmptyValue($this->emp_id->CurrentValue)) {
				$this->emp_id->HrefValue = "stock_material_out_emp_hslist.php?x_emp_id=" . $this->emp_id->CurrentValue; // Add prefix/suffix
				$this->emp_id->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->emp_id->HrefValue = FullUrl($this->emp_id->HrefValue, "href");
			} else {
				$this->emp_id->HrefValue = "";
			}

			// emp_name
			$this->emp_name->LinkCustomAttributes = "";
			if (!EmptyValue($this->emp_name->CurrentValue)) {
				$this->emp_name->HrefValue = "stock_material_out_emp_hslist.php?x_user_name=" . $this->emp_name->CurrentValue; // Add prefix/suffix
				$this->emp_name->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->emp_name->HrefValue = FullUrl($this->emp_name->HrefValue, "href");
			} else {
				$this->emp_name->HrefValue = "";
			}

			// rid
			$this->rid->LinkCustomAttributes = "";
			$this->rid->HrefValue = "";

			// OUT
			$this->OUT->LinkCustomAttributes = "";
			$this->OUT->HrefValue = "";

			// item
			$this->item->LinkCustomAttributes = "";
			if (!EmptyValue($this->item->CurrentValue)) {
				$this->item->HrefValue = "stock_material_out_emp_hslist.php?x_item=" . $this->item->CurrentValue; // Add prefix/suffix
				$this->item->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->item->HrefValue = FullUrl($this->item->HrefValue, "href");
			} else {
				$this->item->HrefValue = "";
			}

			// item_code
			$this->item_code->LinkCustomAttributes = "";
			$this->item_code->HrefValue = "";

			// IN
			$this->IN->LinkCustomAttributes = "";
			$this->IN->HrefValue = "";

			// Balance
			$this->Balance->LinkCustomAttributes = "";
			$this->Balance->HrefValue = "";

			// godown
			$this->godown->LinkCustomAttributes = "";
			if (!EmptyValue($this->godown->CurrentValue)) {
				$this->godown->HrefValue = "stock_material_out_emp_hslist.php?x_godown=" . $this->godown->CurrentValue; // Add prefix/suffix
				$this->godown->LinkAttrs["target"] = "_self"; // Add target
				if ($this->isExport()) $this->godown->HrefValue = FullUrl($this->godown->HrefValue, "href");
			} else {
				$this->godown->HrefValue = "";
			}

			// outid
			$this->outid->LinkCustomAttributes = "";
			$this->outid->HrefValue = "";

			// Shortage
			$this->Shortage->LinkCustomAttributes = "";
			$this->Shortage->HrefValue = "";

			// count
			$this->count->LinkCustomAttributes = "";
			$this->count->HrefValue = "";

			// jc_quantity
			$this->jc_quantity->LinkCustomAttributes = "";
			$this->jc_quantity->HrefValue = "";

			// po
			$this->po->LinkCustomAttributes = "";
			$this->po->HrefValue = "";

			// batch_no
			$this->batch_no->LinkCustomAttributes = "";
			$this->batch_no->HrefValue = "";

			// count_received
			$this->count_received->LinkCustomAttributes = "";
			$this->count_received->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";

			// jc_no_fp
			$this->jc_no_fp->LinkCustomAttributes = "";
			$this->jc_no_fp->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->product->Required) {
			if (!$this->product->IsDetailKey && $this->product->FormValue != NULL && $this->product->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->product->caption(), $this->product->RequiredErrorMessage));
			}
		}
		if ($this->jc_no->Required) {
			if (!$this->jc_no->IsDetailKey && $this->jc_no->FormValue != NULL && $this->jc_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no->caption(), $this->jc_no->RequiredErrorMessage));
			}
		}
		if ($this->emp_id->Required) {
			if (!$this->emp_id->IsDetailKey && $this->emp_id->FormValue != NULL && $this->emp_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emp_id->caption(), $this->emp_id->RequiredErrorMessage));
			}
		}
		if ($this->emp_name->Required) {
			if (!$this->emp_name->IsDetailKey && $this->emp_name->FormValue != NULL && $this->emp_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->emp_name->caption(), $this->emp_name->RequiredErrorMessage));
			}
		}
		if ($this->rid->Required) {
			if (!$this->rid->IsDetailKey && $this->rid->FormValue != NULL && $this->rid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rid->caption(), $this->rid->RequiredErrorMessage));
			}
		}
		if ($this->OUT->Required) {
			if (!$this->OUT->IsDetailKey && $this->OUT->FormValue != NULL && $this->OUT->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->OUT->caption(), $this->OUT->RequiredErrorMessage));
			}
		}
		if ($this->item->Required) {
			if (!$this->item->IsDetailKey && $this->item->FormValue != NULL && $this->item->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->item->caption(), $this->item->RequiredErrorMessage));
			}
		}
		if ($this->item_code->Required) {
			if (!$this->item_code->IsDetailKey && $this->item_code->FormValue != NULL && $this->item_code->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->item_code->caption(), $this->item_code->RequiredErrorMessage));
			}
		}
		if ($this->IN->Required) {
			if (!$this->IN->IsDetailKey && $this->IN->FormValue != NULL && $this->IN->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->IN->caption(), $this->IN->RequiredErrorMessage));
			}
		}
		if ($this->Balance->Required) {
			if (!$this->Balance->IsDetailKey && $this->Balance->FormValue != NULL && $this->Balance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Balance->caption(), $this->Balance->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->Balance->FormValue)) {
			AddMessage($FormError, $this->Balance->errorMessage());
		}
		if ($this->godown->Required) {
			if (!$this->godown->IsDetailKey && $this->godown->FormValue != NULL && $this->godown->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->godown->caption(), $this->godown->RequiredErrorMessage));
			}
		}
		if ($this->outid->Required) {
			if (!$this->outid->IsDetailKey && $this->outid->FormValue != NULL && $this->outid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->outid->caption(), $this->outid->RequiredErrorMessage));
			}
		}
		if ($this->Shortage->Required) {
			if (!$this->Shortage->IsDetailKey && $this->Shortage->FormValue != NULL && $this->Shortage->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->Shortage->caption(), $this->Shortage->RequiredErrorMessage));
			}
		}
		if ($this->count->Required) {
			if (!$this->count->IsDetailKey && $this->count->FormValue != NULL && $this->count->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->count->caption(), $this->count->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->count->FormValue)) {
			AddMessage($FormError, $this->count->errorMessage());
		}
		if ($this->jc_quantity->Required) {
			if (!$this->jc_quantity->IsDetailKey && $this->jc_quantity->FormValue != NULL && $this->jc_quantity->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_quantity->caption(), $this->jc_quantity->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->jc_quantity->FormValue)) {
			AddMessage($FormError, $this->jc_quantity->errorMessage());
		}
		if ($this->po->Required) {
			if (!$this->po->IsDetailKey && $this->po->FormValue != NULL && $this->po->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->po->caption(), $this->po->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->po->FormValue)) {
			AddMessage($FormError, $this->po->errorMessage());
		}
		if ($this->batch_no->Required) {
			if (!$this->batch_no->IsDetailKey && $this->batch_no->FormValue != NULL && $this->batch_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->batch_no->caption(), $this->batch_no->RequiredErrorMessage));
			}
		}
		if ($this->count_received->Required) {
			if (!$this->count_received->IsDetailKey && $this->count_received->FormValue != NULL && $this->count_received->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->count_received->caption(), $this->count_received->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->count_received->FormValue)) {
			AddMessage($FormError, $this->count_received->errorMessage());
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->jc_no_fp->Required) {
			if (!$this->jc_no_fp->IsDetailKey && $this->jc_no_fp->FormValue != NULL && $this->jc_no_fp->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->jc_no_fp->caption(), $this->jc_no_fp->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->jc_no_fp->FormValue)) {
			AddMessage($FormError, $this->jc_no_fp->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
		}
		$rsnew = [];

		// product
		$this->product->setDbValueDef($rsnew, $this->product->CurrentValue, NULL, FALSE);

		// jc_no
		$this->jc_no->setDbValueDef($rsnew, $this->jc_no->CurrentValue, 0, strval($this->jc_no->CurrentValue) == "");

		// emp_id
		$this->emp_id->setDbValueDef($rsnew, $this->emp_id->CurrentValue, "", FALSE);

		// emp_name
		$this->emp_name->setDbValueDef($rsnew, $this->emp_name->CurrentValue, NULL, FALSE);

		// rid
		$this->rid->setDbValueDef($rsnew, $this->rid->CurrentValue, NULL, FALSE);

		// OUT
		$this->OUT->setDbValueDef($rsnew, $this->OUT->CurrentValue, 0, strval($this->OUT->CurrentValue) == "");

		// item
		$this->item->setDbValueDef($rsnew, $this->item->CurrentValue, NULL, FALSE);

		// item_code
		$this->item_code->setDbValueDef($rsnew, $this->item_code->CurrentValue, NULL, FALSE);

		// IN
		$this->IN->setDbValueDef($rsnew, $this->IN->CurrentValue, NULL, FALSE);

		// Balance
		$this->Balance->setDbValueDef($rsnew, $this->Balance->CurrentValue, NULL, FALSE);

		// godown
		$this->godown->setDbValueDef($rsnew, $this->godown->CurrentValue, NULL, FALSE);

		// outid
		$this->outid->setDbValueDef($rsnew, $this->outid->CurrentValue, 0, strval($this->outid->CurrentValue) == "");

		// Shortage
		$this->Shortage->setDbValueDef($rsnew, $this->Shortage->CurrentValue, NULL, FALSE);

		// count
		$this->count->setDbValueDef($rsnew, $this->count->CurrentValue, NULL, FALSE);

		// jc_quantity
		$this->jc_quantity->setDbValueDef($rsnew, $this->jc_quantity->CurrentValue, NULL, FALSE);

		// po
		$this->po->setDbValueDef($rsnew, $this->po->CurrentValue, NULL, FALSE);

		// batch_no
		$this->batch_no->setDbValueDef($rsnew, $this->batch_no->CurrentValue, NULL, FALSE);

		// count_received
		$this->count_received->setDbValueDef($rsnew, $this->count_received->CurrentValue, NULL, FALSE);

		// status
		$this->status->setDbValueDef($rsnew, $this->status->CurrentValue, NULL, FALSE);

		// jc_no_fp
		$this->jc_no_fp->setDbValueDef($rsnew, $this->jc_no_fp->CurrentValue, NULL, FALSE);

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("stock_material_out_emp_hslist.php"), "", $this->TableVar, TRUE);
		$pageId = "addopt";
		$Breadcrumb->add("addopt", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_product":
							break;
						case "x_jc_no":
							break;
						case "x_emp_id":
							$row[2] = FormatNumber($row[2], 0, -2, -2, -2);
							$row['df2'] = $row[2];
							break;
						case "x_emp_name":
							break;
						case "x_rid":
							break;
						case "x_OUT":
							$row[1] = FormatNumber($row[1], 2, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_item":
							break;
						case "x_item_code":
							break;
						case "x_IN":
							$row[1] = FormatNumber($row[1], 2, -2, -2, -2);
							$row['df'] = $row[1];
							break;
						case "x_godown":
							break;
						case "x_outid":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}
}
?>