<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for t_expenses
 */
class t_expenses extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $trip;
	public $diesal;
	public $border;
	public $rto;
	public $da;
	public $repairing;
	public $toll;
	public $other;
	public $cash_paid;
	public $total;
	public $remarks;
	public $dated;
	public $uploads;
	public $operator;
	public $datetime;
	public $diesal_lt;
	public $def;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 't_expenses';
		$this->TableName = 't_expenses';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`t_expenses`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);

		// id
		$this->id = new DbField('t_expenses', 't_expenses', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// trip
		$this->trip = new DbField('t_expenses', 't_expenses', 'x_trip', 'trip', '`trip`', '`trip`', 2, -1, FALSE, '`trip`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->trip->IsForeignKey = TRUE; // Foreign key field
		$this->trip->Nullable = FALSE; // NOT NULL field
		$this->trip->Required = TRUE; // Required field
		$this->trip->Sortable = TRUE; // Allow sort
		$this->trip->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->trip->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->trip->Lookup = new Lookup('trip', 't_trip_info', FALSE, 'id', ["route_name","","",""], [], [], [], [], ["cash_paid"], ["x_cash_paid"], '`route_name` ASC', '');
		$this->trip->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['trip'] = &$this->trip;

		// diesal
		$this->diesal = new DbField('t_expenses', 't_expenses', 'x_diesal', 'diesal', '`diesal`', '`diesal`', 131, -1, FALSE, '`diesal`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diesal->Nullable = FALSE; // NOT NULL field
		$this->diesal->Sortable = TRUE; // Allow sort
		$this->diesal->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['diesal'] = &$this->diesal;

		// border
		$this->border = new DbField('t_expenses', 't_expenses', 'x_border', 'border', '`border`', '`border`', 131, -1, FALSE, '`border`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->border->Nullable = FALSE; // NOT NULL field
		$this->border->Sortable = TRUE; // Allow sort
		$this->border->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['border'] = &$this->border;

		// rto
		$this->rto = new DbField('t_expenses', 't_expenses', 'x_rto', 'rto', '`rto`', '`rto`', 131, -1, FALSE, '`rto`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->rto->Nullable = FALSE; // NOT NULL field
		$this->rto->Sortable = TRUE; // Allow sort
		$this->rto->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['rto'] = &$this->rto;

		// da
		$this->da = new DbField('t_expenses', 't_expenses', 'x_da', 'da', '`da`', '`da`', 131, -1, FALSE, '`da`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->da->Nullable = FALSE; // NOT NULL field
		$this->da->Sortable = TRUE; // Allow sort
		$this->da->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['da'] = &$this->da;

		// repairing
		$this->repairing = new DbField('t_expenses', 't_expenses', 'x_repairing', 'repairing', '`repairing`', '`repairing`', 131, -1, FALSE, '`repairing`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->repairing->Nullable = FALSE; // NOT NULL field
		$this->repairing->Sortable = TRUE; // Allow sort
		$this->repairing->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['repairing'] = &$this->repairing;

		// toll
		$this->toll = new DbField('t_expenses', 't_expenses', 'x_toll', 'toll', '`toll`', '`toll`', 131, -1, FALSE, '`toll`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->toll->Nullable = FALSE; // NOT NULL field
		$this->toll->Sortable = TRUE; // Allow sort
		$this->toll->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['toll'] = &$this->toll;

		// other
		$this->other = new DbField('t_expenses', 't_expenses', 'x_other', 'other', '`other`', '`other`', 131, -1, FALSE, '`other`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->other->Nullable = FALSE; // NOT NULL field
		$this->other->Sortable = TRUE; // Allow sort
		$this->other->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['other'] = &$this->other;

		// cash_paid
		$this->cash_paid = new DbField('t_expenses', 't_expenses', 'x_cash_paid', 'cash_paid', '0', '0', 20, -1, FALSE, '0', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cash_paid->IsCustom = TRUE; // Custom field
		$this->cash_paid->Sortable = TRUE; // Allow sort
		$this->cash_paid->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cash_paid'] = &$this->cash_paid;

		// total
		$this->total = new DbField('t_expenses', 't_expenses', 'x_total', 'total', '`total`', '`total`', 131, -1, FALSE, '`total`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->total->Nullable = FALSE; // NOT NULL field
		$this->total->Sortable = TRUE; // Allow sort
		$this->total->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['total'] = &$this->total;

		// remarks
		$this->remarks = new DbField('t_expenses', 't_expenses', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 200, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->remarks->Sortable = TRUE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// dated
		$this->dated = new DbField('t_expenses', 't_expenses', 'x_dated', 'dated', '`dated`', CastDateFieldForLike('`dated`', 0, "DB"), 133, 0, FALSE, '`dated`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->dated->Nullable = FALSE; // NOT NULL field
		$this->dated->Required = TRUE; // Required field
		$this->dated->Sortable = TRUE; // Allow sort
		$this->dated->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['dated'] = &$this->dated;

		// uploads
		$this->uploads = new DbField('t_expenses', 't_expenses', 'x_uploads', 'uploads', '`uploads`', '`uploads`', 200, -1, TRUE, '`uploads`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->uploads->Sortable = TRUE; // Allow sort
		$this->uploads->UploadMultiple = TRUE;
		$this->uploads->Upload->UploadMultiple = TRUE;
		$this->uploads->UploadMaxFileCount = 0;
		$this->fields['uploads'] = &$this->uploads;

		// operator
		$this->operator = new DbField('t_expenses', 't_expenses', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('t_expenses', 't_expenses', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// diesal_lt
		$this->diesal_lt = new DbField('t_expenses', 't_expenses', 'x_diesal_lt', 'diesal_lt', '`diesal_lt`', '`diesal_lt`', 131, -1, FALSE, '`diesal_lt`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diesal_lt->Nullable = FALSE; // NOT NULL field
		$this->diesal_lt->Sortable = TRUE; // Allow sort
		$this->diesal_lt->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['diesal_lt'] = &$this->diesal_lt;

		// def
		$this->def = new DbField('t_expenses', 't_expenses', 'x_def', 'def', '`def`', '`def`', 131, -1, FALSE, '`def`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->def->Nullable = FALSE; // NOT NULL field
		$this->def->Sortable = TRUE; // Allow sort
		$this->def->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['def'] = &$this->def;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Current master table name
	public function getCurrentMasterTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE];
	}
	public function setCurrentMasterTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_MASTER_TABLE] = $v;
	}

	// Session master WHERE clause
	public function getMasterFilter()
	{

		// Master filter
		$masterFilter = "";
		if ($this->getCurrentMasterTable() == "t_trip_expenses_report") {
			if ($this->trip->getSessionValue() <> "")
				$masterFilter .= "`trip`=" . QuotedValue($this->trip->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $masterFilter;
	}

	// Session detail WHERE clause
	public function getDetailFilter()
	{

		// Detail filter
		$detailFilter = "";
		if ($this->getCurrentMasterTable() == "t_trip_expenses_report") {
			if ($this->trip->getSessionValue() <> "")
				$detailFilter .= "`trip`=" . QuotedValue($this->trip->getSessionValue(), DATATYPE_NUMBER, "DB");
			else
				return "";
		}
		return $detailFilter;
	}

	// Master filter
	public function sqlMasterFilter_t_trip_expenses_report()
	{
		return "`trip`=@trip@";
	}

	// Detail filter
	public function sqlDetailFilter_t_trip_expenses_report()
	{
		return "`trip`=@trip@";
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`t_expenses`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT *, 0 AS `cash_paid` FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->trip->DbValue = $row['trip'];
		$this->diesal->DbValue = $row['diesal'];
		$this->border->DbValue = $row['border'];
		$this->rto->DbValue = $row['rto'];
		$this->da->DbValue = $row['da'];
		$this->repairing->DbValue = $row['repairing'];
		$this->toll->DbValue = $row['toll'];
		$this->other->DbValue = $row['other'];
		$this->cash_paid->DbValue = $row['cash_paid'];
		$this->total->DbValue = $row['total'];
		$this->remarks->DbValue = $row['remarks'];
		$this->dated->DbValue = $row['dated'];
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->diesal_lt->DbValue = $row['diesal_lt'];
		$this->def->DbValue = $row['def'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->uploads->OldUploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
		$oldFiles = EmptyValue($row['uploads']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['uploads']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "t_expenseslist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "t_expensesview.php")
			return $Language->phrase("View");
		elseif ($pageName == "t_expensesedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "t_expensesadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "t_expenseslist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("t_expensesview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("t_expensesview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "t_expensesadd.php?" . $this->getUrlParm($parm);
		else
			$url = "t_expensesadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("t_expensesedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("t_expensesadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("t_expensesdelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		if ($this->getCurrentMasterTable() == "t_trip_expenses_report" && !ContainsString($url, TABLE_SHOW_MASTER . "=")) {
			$url .= (ContainsString($url, "?") ? "&" : "?") . TABLE_SHOW_MASTER . "=" . $this->getCurrentMasterTable();
			$url .= "&fk_trip=" . urlencode($this->trip->CurrentValue);
		}
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->trip->setDbValue($rs->fields('trip'));
		$this->diesal->setDbValue($rs->fields('diesal'));
		$this->border->setDbValue($rs->fields('border'));
		$this->rto->setDbValue($rs->fields('rto'));
		$this->da->setDbValue($rs->fields('da'));
		$this->repairing->setDbValue($rs->fields('repairing'));
		$this->toll->setDbValue($rs->fields('toll'));
		$this->other->setDbValue($rs->fields('other'));
		$this->cash_paid->setDbValue($rs->fields('cash_paid'));
		$this->total->setDbValue($rs->fields('total'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->dated->setDbValue($rs->fields('dated'));
		$this->uploads->Upload->DbValue = $rs->fields('uploads');
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->diesal_lt->setDbValue($rs->fields('diesal_lt'));
		$this->def->setDbValue($rs->fields('def'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// trip
		// diesal
		// border
		// rto
		// da
		// repairing
		// toll
		// other
		// cash_paid
		// total
		// remarks
		// dated
		// uploads
		// operator
		// datetime
		// diesal_lt
		// def
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// trip
		$curVal = strval($this->trip->CurrentValue);
		if ($curVal <> "") {
			$this->trip->ViewValue = $this->trip->lookupCacheOption($curVal);
			if ($this->trip->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`vehicle_type` =  1 and `status` = 2 and `status` != 3" : "`vehicle_type` =  1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->trip->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->trip->ViewValue = $this->trip->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->trip->ViewValue = $this->trip->CurrentValue;
				}
			}
		} else {
			$this->trip->ViewValue = NULL;
		}
		$this->trip->ViewCustomAttributes = "";

		// diesal
		$this->diesal->ViewValue = $this->diesal->CurrentValue;
		$this->diesal->ViewValue = FormatNumber($this->diesal->ViewValue, 2, -2, -2, -2);
		$this->diesal->ViewCustomAttributes = "";

		// border
		$this->border->ViewValue = $this->border->CurrentValue;
		$this->border->ViewValue = FormatNumber($this->border->ViewValue, 2, -2, -2, -2);
		$this->border->ViewCustomAttributes = "";

		// rto
		$this->rto->ViewValue = $this->rto->CurrentValue;
		$this->rto->ViewValue = FormatNumber($this->rto->ViewValue, 2, -2, -2, -2);
		$this->rto->ViewCustomAttributes = "";

		// da
		$this->da->ViewValue = $this->da->CurrentValue;
		$this->da->ViewValue = FormatNumber($this->da->ViewValue, 2, -2, -2, -2);
		$this->da->ViewCustomAttributes = "";

		// repairing
		$this->repairing->ViewValue = $this->repairing->CurrentValue;
		$this->repairing->ViewValue = FormatNumber($this->repairing->ViewValue, 2, -2, -2, -2);
		$this->repairing->ViewCustomAttributes = "";

		// toll
		$this->toll->ViewValue = $this->toll->CurrentValue;
		$this->toll->ViewValue = FormatNumber($this->toll->ViewValue, 2, -2, -2, -2);
		$this->toll->ViewCustomAttributes = "";

		// other
		$this->other->ViewValue = $this->other->CurrentValue;
		$this->other->ViewValue = FormatNumber($this->other->ViewValue, 2, -2, -2, -2);
		$this->other->ViewCustomAttributes = "";

		// cash_paid
		$this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
		$this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, 0, -2, -2, -2);
		$this->cash_paid->ViewCustomAttributes = "";

		// total
		$this->total->ViewValue = $this->total->CurrentValue;
		$this->total->ViewValue = FormatNumber($this->total->ViewValue, 2, -2, -2, -2);
		$this->total->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// dated
		$this->dated->ViewValue = $this->dated->CurrentValue;
		$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
		$this->dated->ViewCustomAttributes = "";

		// uploads
		$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->ViewValue = "";
		}
		$this->uploads->ViewCustomAttributes = "";

		// operator
		$this->operator->ViewValue = $this->operator->CurrentValue;
		$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// diesal_lt
		$this->diesal_lt->ViewValue = $this->diesal_lt->CurrentValue;
		$this->diesal_lt->ViewValue = FormatNumber($this->diesal_lt->ViewValue, 2, -2, -2, -2);
		$this->diesal_lt->ViewCustomAttributes = "";

		// def
		$this->def->ViewValue = $this->def->CurrentValue;
		$this->def->ViewValue = FormatNumber($this->def->ViewValue, 2, -2, -2, -2);
		$this->def->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// trip
		$this->trip->LinkCustomAttributes = "";
		$this->trip->HrefValue = "";
		$this->trip->TooltipValue = "";

		// diesal
		$this->diesal->LinkCustomAttributes = "";
		$this->diesal->HrefValue = "";
		$this->diesal->TooltipValue = "";

		// border
		$this->border->LinkCustomAttributes = "";
		$this->border->HrefValue = "";
		$this->border->TooltipValue = "";

		// rto
		$this->rto->LinkCustomAttributes = "";
		$this->rto->HrefValue = "";
		$this->rto->TooltipValue = "";

		// da
		$this->da->LinkCustomAttributes = "";
		$this->da->HrefValue = "";
		$this->da->TooltipValue = "";

		// repairing
		$this->repairing->LinkCustomAttributes = "";
		$this->repairing->HrefValue = "";
		$this->repairing->TooltipValue = "";

		// toll
		$this->toll->LinkCustomAttributes = "";
		$this->toll->HrefValue = "";
		$this->toll->TooltipValue = "";

		// other
		$this->other->LinkCustomAttributes = "";
		$this->other->HrefValue = "";
		$this->other->TooltipValue = "";

		// cash_paid
		$this->cash_paid->LinkCustomAttributes = "";
		$this->cash_paid->HrefValue = "";
		$this->cash_paid->TooltipValue = "";

		// total
		$this->total->LinkCustomAttributes = "";
		$this->total->HrefValue = "";
		$this->total->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// dated
		$this->dated->LinkCustomAttributes = "";
		$this->dated->HrefValue = "";
		$this->dated->TooltipValue = "";

		// uploads
		$this->uploads->LinkCustomAttributes = "";
		$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->HrefValue = "%u"; // Add prefix/suffix
			$this->uploads->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
		} else {
			$this->uploads->HrefValue = "";
		}
		$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
		$this->uploads->TooltipValue = "";
		if ($this->uploads->UseColorbox) {
			if (EmptyValue($this->uploads->TooltipValue))
				$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->uploads->LinkAttrs["data-rel"] = "t_expenses_x_uploads";
			AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
		}

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// diesal_lt
		$this->diesal_lt->LinkCustomAttributes = "";
		$this->diesal_lt->HrefValue = "";
		$this->diesal_lt->TooltipValue = "";

		// def
		$this->def->LinkCustomAttributes = "";
		$this->def->HrefValue = "";
		$this->def->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// trip
		$this->trip->EditAttrs["class"] = "form-control";
		$this->trip->EditCustomAttributes = "";
		$curVal = strval($this->trip->CurrentValue);
		if ($curVal <> "") {
			$this->trip->EditValue = $this->trip->lookupCacheOption($curVal);
			if ($this->trip->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`vehicle_type` =  1 and `status` = 2 and `status` != 3" : "`vehicle_type` =  1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->trip->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->trip->EditValue = $this->trip->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->trip->EditValue = $this->trip->CurrentValue;
				}
			}
		} else {
			$this->trip->EditValue = NULL;
		}
		$this->trip->ViewCustomAttributes = "";

		// diesal
		$this->diesal->EditAttrs["class"] = "form-control";
		$this->diesal->EditCustomAttributes = "";
		$this->diesal->EditValue = $this->diesal->CurrentValue;
		$this->diesal->PlaceHolder = RemoveHtml($this->diesal->caption());
		if (strval($this->diesal->EditValue) <> "" && is_numeric($this->diesal->EditValue))
			$this->diesal->EditValue = FormatNumber($this->diesal->EditValue, -2, -2, -2, -2);

		// border
		$this->border->EditAttrs["class"] = "form-control";
		$this->border->EditCustomAttributes = "";
		$this->border->EditValue = $this->border->CurrentValue;
		$this->border->PlaceHolder = RemoveHtml($this->border->caption());
		if (strval($this->border->EditValue) <> "" && is_numeric($this->border->EditValue))
			$this->border->EditValue = FormatNumber($this->border->EditValue, -2, -2, -2, -2);

		// rto
		$this->rto->EditAttrs["class"] = "form-control";
		$this->rto->EditCustomAttributes = "";
		$this->rto->EditValue = $this->rto->CurrentValue;
		$this->rto->PlaceHolder = RemoveHtml($this->rto->caption());
		if (strval($this->rto->EditValue) <> "" && is_numeric($this->rto->EditValue))
			$this->rto->EditValue = FormatNumber($this->rto->EditValue, -2, -2, -2, -2);

		// da
		$this->da->EditAttrs["class"] = "form-control";
		$this->da->EditCustomAttributes = "";
		$this->da->EditValue = $this->da->CurrentValue;
		$this->da->PlaceHolder = RemoveHtml($this->da->caption());
		if (strval($this->da->EditValue) <> "" && is_numeric($this->da->EditValue))
			$this->da->EditValue = FormatNumber($this->da->EditValue, -2, -2, -2, -2);

		// repairing
		$this->repairing->EditAttrs["class"] = "form-control";
		$this->repairing->EditCustomAttributes = "";
		$this->repairing->EditValue = $this->repairing->CurrentValue;
		$this->repairing->PlaceHolder = RemoveHtml($this->repairing->caption());
		if (strval($this->repairing->EditValue) <> "" && is_numeric($this->repairing->EditValue))
			$this->repairing->EditValue = FormatNumber($this->repairing->EditValue, -2, -2, -2, -2);

		// toll
		$this->toll->EditAttrs["class"] = "form-control";
		$this->toll->EditCustomAttributes = "";
		$this->toll->EditValue = $this->toll->CurrentValue;
		$this->toll->PlaceHolder = RemoveHtml($this->toll->caption());
		if (strval($this->toll->EditValue) <> "" && is_numeric($this->toll->EditValue))
			$this->toll->EditValue = FormatNumber($this->toll->EditValue, -2, -2, -2, -2);

		// other
		$this->other->EditAttrs["class"] = "form-control";
		$this->other->EditCustomAttributes = "";
		$this->other->EditValue = $this->other->CurrentValue;
		$this->other->PlaceHolder = RemoveHtml($this->other->caption());
		if (strval($this->other->EditValue) <> "" && is_numeric($this->other->EditValue))
			$this->other->EditValue = FormatNumber($this->other->EditValue, -2, -2, -2, -2);

		// cash_paid
		$this->cash_paid->EditAttrs["class"] = "form-control";
		$this->cash_paid->EditCustomAttributes = 'ReadOnly';
		$this->cash_paid->EditValue = $this->cash_paid->CurrentValue;
		$this->cash_paid->PlaceHolder = RemoveHtml($this->cash_paid->caption());

		// total
		$this->total->EditAttrs["class"] = "form-control";
		$this->total->EditCustomAttributes = 'ReadOnly';
		$this->total->EditValue = $this->total->CurrentValue;
		$this->total->PlaceHolder = RemoveHtml($this->total->caption());
		if (strval($this->total->EditValue) <> "" && is_numeric($this->total->EditValue))
			$this->total->EditValue = FormatNumber($this->total->EditValue, -2, -2, -2, -2);

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// dated
		$this->dated->EditAttrs["class"] = "form-control";
		$this->dated->EditCustomAttributes = "";
		$this->dated->EditValue = FormatDateTime($this->dated->CurrentValue, 8);
		$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

		// uploads
		$this->uploads->EditAttrs["class"] = "form-control";
		$this->uploads->EditCustomAttributes = "";
		$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->EditValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->EditValue = "";
		}
		if (!EmptyValue($this->uploads->CurrentValue))
				$this->uploads->Upload->FileName = $this->uploads->CurrentValue;

		// operator
		// datetime
		// diesal_lt

		$this->diesal_lt->EditAttrs["class"] = "form-control";
		$this->diesal_lt->EditCustomAttributes = "";
		$this->diesal_lt->EditValue = $this->diesal_lt->CurrentValue;
		$this->diesal_lt->PlaceHolder = RemoveHtml($this->diesal_lt->caption());
		if (strval($this->diesal_lt->EditValue) <> "" && is_numeric($this->diesal_lt->EditValue))
			$this->diesal_lt->EditValue = FormatNumber($this->diesal_lt->EditValue, -2, -2, -2, -2);

		// def
		$this->def->EditAttrs["class"] = "form-control";
		$this->def->EditCustomAttributes = "";
		$this->def->EditValue = $this->def->CurrentValue;
		$this->def->PlaceHolder = RemoveHtml($this->def->caption());
		if (strval($this->def->EditValue) <> "" && is_numeric($this->def->EditValue))
			$this->def->EditValue = FormatNumber($this->def->EditValue, -2, -2, -2, -2);

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->trip);
					$doc->exportCaption($this->diesal);
					$doc->exportCaption($this->border);
					$doc->exportCaption($this->rto);
					$doc->exportCaption($this->da);
					$doc->exportCaption($this->repairing);
					$doc->exportCaption($this->toll);
					$doc->exportCaption($this->other);
					$doc->exportCaption($this->cash_paid);
					$doc->exportCaption($this->total);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->uploads);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->diesal_lt);
					$doc->exportCaption($this->def);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->trip);
					$doc->exportCaption($this->diesal);
					$doc->exportCaption($this->border);
					$doc->exportCaption($this->rto);
					$doc->exportCaption($this->da);
					$doc->exportCaption($this->repairing);
					$doc->exportCaption($this->toll);
					$doc->exportCaption($this->other);
					$doc->exportCaption($this->cash_paid);
					$doc->exportCaption($this->total);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->dated);
					$doc->exportCaption($this->uploads);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
					$doc->exportCaption($this->diesal_lt);
					$doc->exportCaption($this->def);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->trip);
						$doc->exportField($this->diesal);
						$doc->exportField($this->border);
						$doc->exportField($this->rto);
						$doc->exportField($this->da);
						$doc->exportField($this->repairing);
						$doc->exportField($this->toll);
						$doc->exportField($this->other);
						$doc->exportField($this->cash_paid);
						$doc->exportField($this->total);
						$doc->exportField($this->remarks);
						$doc->exportField($this->dated);
						$doc->exportField($this->uploads);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->diesal_lt);
						$doc->exportField($this->def);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->trip);
						$doc->exportField($this->diesal);
						$doc->exportField($this->border);
						$doc->exportField($this->rto);
						$doc->exportField($this->da);
						$doc->exportField($this->repairing);
						$doc->exportField($this->toll);
						$doc->exportField($this->other);
						$doc->exportField($this->cash_paid);
						$doc->exportField($this->total);
						$doc->exportField($this->remarks);
						$doc->exportField($this->dated);
						$doc->exportField($this->uploads);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
						$doc->exportField($this->diesal_lt);
						$doc->exportField($this->def);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'uploads') {
			$fldName = "uploads";
			$fileNameFld = "uploads";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>