<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class t_expenses_grid extends t_expenses
{

	// Page ID
	public $PageID = "grid";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 't_expenses';

	// Page object name
	public $PageObjName = "t_expenses_grid";

	// Grid form hidden field names
	public $FormName = "ft_expensesgrid";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$this->FormActionName .= "_" . $this->FormName;
		$this->FormKeyName .= "_" . $this->FormName;
		$this->FormOldKeyName .= "_" . $this->FormName;
		$this->FormBlankRowName .= "_" . $this->FormName;
		$this->FormKeyCountName .= "_" . $this->FormName;
		$GLOBALS["Grid"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (t_expenses)
		if (!isset($GLOBALS["t_expenses"]) || get_class($GLOBALS["t_expenses"]) == PROJECT_NAMESPACE . "t_expenses") {
			$GLOBALS["t_expenses"] = &$this;

			// $GLOBALS["MasterTable"] = &$GLOBALS["Table"];
			// if (!isset($GLOBALS["Table"]))
			// 	$GLOBALS["Table"] = &$GLOBALS["t_expenses"];

		}
		$this->AddUrl = "t_expensesadd.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'grid');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 't_expenses');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Export
		global $EXPORT, $t_expenses;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($t_expenses);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}

//		$GLOBALS["Table"] = &$GLOBALS["MasterTable"];
		unset($GLOBALS["Grid"]);
		if ($url === "")
			return;
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $ShowOtherOptions = FALSE;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();
		$this->id->setVisibility();
		$this->trip->setVisibility();
		$this->diesal->setVisibility();
		$this->border->setVisibility();
		$this->rto->setVisibility();
		$this->da->setVisibility();
		$this->repairing->setVisibility();
		$this->toll->setVisibility();
		$this->other->setVisibility();
		$this->cash_paid->setVisibility();
		$this->total->setVisibility();
		$this->remarks->setVisibility();
		$this->dated->setVisibility();
		$this->uploads->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->diesal_lt->setVisibility();
		$this->def->setVisibility();
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up master detail parameters
		$this->setupMasterParms();

		// Setup other options
		$this->setupOtherOptions();

		// Set up lookup cache
		$this->setupLookupOptions($this->trip);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Show grid delete link for grid add / grid edit
			if ($this->AllowAddDeleteRow) {
				if ($this->isGridAdd() || $this->isGridEdit()) {
					$item = &$this->ListOptions->getItem("griddelete");
					if ($item)
						$item->Visible = TRUE;
				}
			}

			// Set up sorting order
			$this->setupSortOrder();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records

		// Restore master/detail filter
		$this->DbMasterFilter = $this->getMasterFilter(); // Restore master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Restore detail filter
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Load master record
		if ($this->CurrentMode <> "add" && $this->getMasterFilter() <> "" && $this->getCurrentMasterTable() == "t_trip_expenses_report") {
			global $t_trip_expenses_report;
			$rsmaster = $t_trip_expenses_report->loadRs($this->DbMasterFilter);
			$this->MasterRecordExists = ($rsmaster && !$rsmaster->EOF);
			if (!$this->MasterRecordExists) {
				$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record found
				$this->terminate("t_trip_expenses_reportlist.php"); // Return to master page
			} else {
				$t_trip_expenses_report->loadListRowValues($rsmaster);
				$t_trip_expenses_report->RowType = ROWTYPE_MASTER; // Master row
				$t_trip_expenses_report->renderListRow();
				$rsmaster->close();
			}
		}

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}
		if ($this->isGridAdd()) {
			if ($this->CurrentMode == "copy") {
				$selectLimit = $this->UseSelectLimit;
				if ($selectLimit) {
					$this->TotalRecs = $this->listRecordCount();
					$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);
				} else {
					if ($this->Recordset = $this->loadRecordset())
						$this->TotalRecs = $this->Recordset->RecordCount();
				}
				$this->StartRec = 1;
				$this->DisplayRecs = $this->TotalRecs;
			} else {
				$this->CurrentFilter = "0=1";
				$this->StartRec = 1;
				$this->DisplayRecs = $this->GridAddRowCount;
			}
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			$this->DisplayRecs = $this->TotalRecs; // Display all records
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Exit inline mode
	protected function clearInlineMode()
	{
		$this->diesal->FormValue = ""; // Clear form value
		$this->border->FormValue = ""; // Clear form value
		$this->rto->FormValue = ""; // Clear form value
		$this->da->FormValue = ""; // Clear form value
		$this->repairing->FormValue = ""; // Clear form value
		$this->toll->FormValue = ""; // Clear form value
		$this->other->FormValue = ""; // Clear form value
		$this->total->FormValue = ""; // Clear form value
		$this->diesal_lt->FormValue = ""; // Clear form value
		$this->def->FormValue = ""; // Clear form value
		$this->LastAction = $this->CurrentAction; // Save last action
		$this->CurrentAction = ""; // Clear action
		$_SESSION[SESSION_INLINE_MODE] = ""; // Clear inline mode
	}

	// Switch to Grid Add mode
	protected function gridAddMode()
	{
		$this->CurrentAction = "gridadd";
		$_SESSION[SESSION_INLINE_MODE] = "gridadd";
		$this->hideFieldsForAddEdit();
	}

	// Switch to Grid Edit mode
	protected function gridEditMode()
	{
		$this->CurrentAction = "gridedit";
		$_SESSION[SESSION_INLINE_MODE] = "gridedit";
		$this->hideFieldsForAddEdit();
	}

	// Perform update to grid
	public function gridUpdate()
	{
		global $Language, $CurrentForm, $FormError;
		$gridUpdate = TRUE;

		// Get old recordset
		$this->CurrentFilter = $this->buildKeyFilter();
		if ($this->CurrentFilter == "")
			$this->CurrentFilter = "0=1";
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sql)) {
			$rsold = $rs->getRows();
			$rs->close();
		}

		// Call Grid Updating event
		if (!$this->Grid_Updating($rsold)) {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("GridEditCancelled")); // Set grid edit cancelled message
			return FALSE;
		}
		$key = "";

		// Update row index and get row key
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Update all rows based on key
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {
			$CurrentForm->Index = $rowindex;
			$rowkey = strval($CurrentForm->getValue($this->FormKeyName));
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));

			// Load all values and keys
			if ($rowaction <> "insertdelete") { // Skip insert then deleted rows
				$this->loadFormValues(); // Get form values
				if ($rowaction == "" || $rowaction == "edit" || $rowaction == "delete") {
					$gridUpdate = $this->setupKeyValues($rowkey); // Set up key values
				} else {
					$gridUpdate = TRUE;
				}

				// Skip empty row
				if ($rowaction == "insert" && $this->emptyRow()) {

					// No action required
				// Validate form and insert/update/delete record

				} elseif ($gridUpdate) {
					if ($rowaction == "delete") {
						$this->CurrentFilter = $this->getRecordFilter();
						$gridUpdate = $this->deleteRows(); // Delete this row
					} else if (!$this->validateForm()) {
						$gridUpdate = FALSE; // Form error, reset action
						$this->setFailureMessage($FormError);
					} else {
						if ($rowaction == "insert") {
							$gridUpdate = $this->addRow(); // Insert this row
						} else {
							if ($rowkey <> "") {
								$this->SendEmail = FALSE; // Do not send email on update success
								$gridUpdate = $this->editRow(); // Update this row
							}
						} // End update
					}
				}
				if ($gridUpdate) {
					if ($key <> "")
						$key .= ", ";
					$key .= $rowkey;
				} else {
					break;
				}
			}
		}
		if ($gridUpdate) {

			// Get new recordset
			if ($rs = $conn->execute($sql)) {
				$rsnew = $rs->getRows();
				$rs->close();
			}

			// Call Grid_Updated event
			$this->Grid_Updated($rsold, $rsnew);
			$this->clearInlineMode(); // Clear inline edit mode
		} else {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("UpdateFailed")); // Set update failed message
		}
		return $gridUpdate;
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Perform Grid Add
	public function gridInsert()
	{
		global $Language, $CurrentForm, $FormError;
		$rowindex = 1;
		$gridInsert = FALSE;
		$conn = &$this->getConnection();

		// Call Grid Inserting event
		if (!$this->Grid_Inserting()) {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("GridAddCancelled")); // Set grid add cancelled message
			return FALSE;
		}

		// Init key filter
		$wrkfilter = "";
		$addcnt = 0;
		$key = "";

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Insert all rows
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "" && $rowaction <> "insert")
				continue; // Skip
			if ($rowaction == "insert") {
				$this->RowOldKey = strval($CurrentForm->getValue($this->FormOldKeyName));
				$this->loadOldRecord(); // Load old record
			}
			$this->loadFormValues(); // Get form values
			if (!$this->emptyRow()) {
				$addcnt++;
				$this->SendEmail = FALSE; // Do not send email on insert success

				// Validate form
				if (!$this->validateForm()) {
					$gridInsert = FALSE; // Form error, reset action
					$this->setFailureMessage($FormError);
				} else {
					$gridInsert = $this->addRow($this->OldRecordset); // Insert this row
				}
				if ($gridInsert) {
					if ($key <> "")
						$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
					$key .= $this->id->CurrentValue;

					// Add filter for this record
					$filter = $this->getRecordFilter();
					if ($wrkfilter <> "")
						$wrkfilter .= " OR ";
					$wrkfilter .= $filter;
				} else {
					break;
				}
			}
		}
		if ($addcnt == 0) { // No record inserted
			$this->clearInlineMode(); // Clear grid add mode and return
			return TRUE;
		}
		if ($gridInsert) {

			// Get new recordset
			$this->CurrentFilter = $wrkfilter;
			$sql = $this->getCurrentSql();
			if ($rs = $conn->execute($sql)) {
				$rsnew = $rs->getRows();
				$rs->close();
			}

			// Call Grid_Inserted event
			$this->Grid_Inserted($rsnew);
			$this->clearInlineMode(); // Clear grid add mode
		} else {
			if ($this->getFailureMessage() == "")
				$this->setFailureMessage($Language->phrase("InsertFailed")); // Set insert failed message
		}
		return $gridInsert;
	}

	// Check if empty row
	public function emptyRow()
	{
		global $CurrentForm;
		if ($CurrentForm->hasValue("x_trip") && $CurrentForm->hasValue("o_trip") && $this->trip->CurrentValue <> $this->trip->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_diesal") && $CurrentForm->hasValue("o_diesal") && $this->diesal->CurrentValue <> $this->diesal->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_border") && $CurrentForm->hasValue("o_border") && $this->border->CurrentValue <> $this->border->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_rto") && $CurrentForm->hasValue("o_rto") && $this->rto->CurrentValue <> $this->rto->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_da") && $CurrentForm->hasValue("o_da") && $this->da->CurrentValue <> $this->da->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_repairing") && $CurrentForm->hasValue("o_repairing") && $this->repairing->CurrentValue <> $this->repairing->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_toll") && $CurrentForm->hasValue("o_toll") && $this->toll->CurrentValue <> $this->toll->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_other") && $CurrentForm->hasValue("o_other") && $this->other->CurrentValue <> $this->other->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_cash_paid") && $CurrentForm->hasValue("o_cash_paid") && $this->cash_paid->CurrentValue <> $this->cash_paid->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_total") && $CurrentForm->hasValue("o_total") && $this->total->CurrentValue <> $this->total->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_remarks") && $CurrentForm->hasValue("o_remarks") && $this->remarks->CurrentValue <> $this->remarks->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_dated") && $CurrentForm->hasValue("o_dated") && $this->dated->CurrentValue <> $this->dated->OldValue)
			return FALSE;
		if (!EmptyValue($this->uploads->Upload->Value))
			return FALSE;
		if ($CurrentForm->hasValue("x_diesal_lt") && $CurrentForm->hasValue("o_diesal_lt") && $this->diesal_lt->CurrentValue <> $this->diesal_lt->OldValue)
			return FALSE;
		if ($CurrentForm->hasValue("x_def") && $CurrentForm->hasValue("o_def") && $this->def->CurrentValue <> $this->def->OldValue)
			return FALSE;
		return TRUE;
	}

	// Validate grid form
	public function validateGridForm()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;

		// Validate all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else if (!$this->validateForm()) {
					return FALSE;
				}
			}
		}
		return TRUE;
	}

	// Get all form values of the grid
	public function getGridFormValues()
	{
		global $CurrentForm;

		// Get row count
		$CurrentForm->Index = -1;
		$rowcnt = strval($CurrentForm->getValue($this->FormKeyCountName));
		if ($rowcnt == "" || !is_numeric($rowcnt))
			$rowcnt = 0;
		$rows = array();

		// Loop through all records
		for ($rowindex = 1; $rowindex <= $rowcnt; $rowindex++) {

			// Load current row values
			$CurrentForm->Index = $rowindex;
			$rowaction = strval($CurrentForm->getValue($this->FormActionName));
			if ($rowaction <> "delete" && $rowaction <> "insertdelete") {
				$this->loadFormValues(); // Get form values
				if ($rowaction == "insert" && $this->emptyRow()) {

					// Ignore
				} else {
					$rows[] = $this->getFieldValues("FormValue"); // Return row as array
				}
			}
		}
		return $rows; // Return as array of array
	}

	// Restore form values for current row
	public function restoreCurrentRowFormValues($idx)
	{
		global $CurrentForm;

		// Get row based on current index
		$CurrentForm->Index = $idx;
		$this->loadFormValues(); // Load form values
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset master/detail keys
			if ($this->Command == "resetall") {
				$this->setCurrentMasterTable(""); // Clear master table
				$this->DbMasterFilter = "";
				$this->DbDetailFilter = "";
				$this->trip->setSessionValue("");
			}

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// "griddelete"
		if ($this->AllowAddDeleteRow) {
			$item = &$this->ListOptions->add("griddelete");
			$item->CssClass = "text-nowrap";
			$item->OnLeft = TRUE;
			$item->Visible = FALSE; // Default hidden
		}

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "copy"
		$item = &$this->ListOptions->add("copy");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canAdd();
		$item->OnLeft = TRUE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = FALSE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// Set up row action and key
		if (is_numeric($this->RowIndex) && $this->CurrentMode <> "view") {
			$CurrentForm->Index = $this->RowIndex;
			$actionName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormActionName);
			$oldKeyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormOldKeyName);
			$keyName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormKeyName);
			$blankRowName = str_replace("k_", "k" . $this->RowIndex . "_", $this->FormBlankRowName);
			if ($this->RowAction <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $actionName . "\" id=\"" . $actionName . "\" value=\"" . $this->RowAction . "\">";
			if ($CurrentForm->hasValue($this->FormOldKeyName))
				$this->RowOldKey = strval($CurrentForm->getValue($this->FormOldKeyName));
			if ($this->RowOldKey <> "")
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $oldKeyName . "\" id=\"" . $oldKeyName . "\" value=\"" . HtmlEncode($this->RowOldKey) . "\">";
			if ($this->RowAction == "delete") {
				$rowkey = $CurrentForm->getValue($this->FormKeyName);
				$this->setupKeyValues($rowkey);
			}
			if ($this->RowAction == "insert" && $this->isConfirm() && $this->emptyRow())
				$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $blankRowName . "\" id=\"" . $blankRowName . "\" value=\"1\">";
		}

		// "delete"
		if ($this->AllowAddDeleteRow) {
			if ($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") {
				$options = &$this->ListOptions;
				$options->UseButtonGroup = TRUE; // Use button group for grid delete button
				$opt = &$options->Items["griddelete"];
				if (is_numeric($this->RowIndex) && ($this->RowAction == "" || $this->RowAction == "edit")) { // Do not allow delete existing record
					$opt->Body = "&nbsp;";
				} else {
					$opt->Body = "<a class=\"ew-grid-link ew-grid-delete\" title=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("DeleteLink")) . "\" onclick=\"return ew.deleteGridRow(this, " . $this->RowIndex . ");\">" . $Language->phrase("DeleteLink") . "</a>";
				}
			}
		}
		if ($this->CurrentMode == "view") { // View mode

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "copy"
		$opt = &$this->ListOptions->Items["copy"];
		$copycaption = HtmlTitle($Language->phrase("CopyLink"));
		if ($Security->canAdd()) {
			$opt->Body = "<a class=\"ew-row-link ew-copy\" title=\"" . $copycaption . "\" data-caption=\"" . $copycaption . "\" href=\"" . HtmlEncode($this->CopyUrl) . "\">" . $Language->phrase("CopyLink") . "</a>";
		} else {
			$opt->Body = "";
		}
		} // End View mode
		if ($this->CurrentMode == "edit" && is_numeric($this->RowIndex)) {
			$this->MultiSelectKey .= "<input type=\"hidden\" name=\"" . $keyName . "\" id=\"" . $keyName . "\" value=\"" . $this->id->CurrentValue . "\">";
		}
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set record key
	public function setRecordKey(&$key, $rs)
	{
		$key = "";
		if ($key <> "")
			$key .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
		$key .= $rs->fields('id');
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$option = &$this->OtherOptions["addedit"];
		$option->UseDropDownButton = FALSE;
		$option->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$option->UseButtonGroup = TRUE;

		//$option->ButtonClass = ""; // Class for button group
		$item = &$option->add($option->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Add
		if ($this->CurrentMode == "view") { // Check view mode
			$item = &$option->add("add");
			$addcaption = HtmlTitle($Language->phrase("AddLink"));
			$this->AddUrl = $this->getAddUrl();
			$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
			$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		}
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		if (($this->CurrentMode == "add" || $this->CurrentMode == "copy" || $this->CurrentMode == "edit") && !$this->isConfirm()) { // Check add/copy/edit mode
			if ($this->AllowAddDeleteRow) {
				$option = &$options["addedit"];
				$option->UseDropDownButton = FALSE;
				$item = &$option->add("addblankrow");
				$item->Body = "<a class=\"ew-add-edit ew-add-blank-row\" title=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("AddBlankRow")) . "\" href=\"javascript:void(0);\" onclick=\"ew.addGridRow(this);\">" . $Language->phrase("AddBlankRow") . "</a>";
				$item->Visible = $Security->canAdd();
				$this->ShowOtherOptions = $item->Visible;
			}
		}
		if ($this->CurrentMode == "view") { // Check view mode
			$option = &$options["addedit"];
			$item = &$option->getItem("add");
			$this->ShowOtherOptions = $item && $item->Visible;
		}
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->uploads->Upload->Index = $CurrentForm->Index;
		$this->uploads->Upload->uploadFile();
		$this->uploads->CurrentValue = $this->uploads->Upload->FileName;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->trip->CurrentValue = NULL;
		$this->trip->OldValue = $this->trip->CurrentValue;
		$this->diesal->CurrentValue = 0;
		$this->diesal->OldValue = $this->diesal->CurrentValue;
		$this->border->CurrentValue = 0;
		$this->border->OldValue = $this->border->CurrentValue;
		$this->rto->CurrentValue = 0;
		$this->rto->OldValue = $this->rto->CurrentValue;
		$this->da->CurrentValue = 0;
		$this->da->OldValue = $this->da->CurrentValue;
		$this->repairing->CurrentValue = 0;
		$this->repairing->OldValue = $this->repairing->CurrentValue;
		$this->toll->CurrentValue = 0.00;
		$this->toll->OldValue = $this->toll->CurrentValue;
		$this->other->CurrentValue = 0;
		$this->other->OldValue = $this->other->CurrentValue;
		$this->cash_paid->CurrentValue = NULL;
		$this->cash_paid->OldValue = $this->cash_paid->CurrentValue;
		$this->total->CurrentValue = 0.00;
		$this->total->OldValue = $this->total->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->dated->CurrentValue = CurrentDate();
		$this->dated->OldValue = $this->dated->CurrentValue;
		$this->uploads->Upload->DbValue = NULL;
		$this->uploads->OldValue = $this->uploads->Upload->DbValue;
		$this->uploads->Upload->Index = $this->RowIndex;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->diesal_lt->CurrentValue = 0.00;
		$this->diesal_lt->OldValue = $this->diesal_lt->CurrentValue;
		$this->def->CurrentValue = 0.00;
		$this->def->OldValue = $this->def->CurrentValue;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$CurrentForm->FormName = $this->FormName;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey && !$this->isGridAdd() && !$this->isAdd())
			$this->id->setFormValue($val);

		// Check field name 'trip' first before field var 'x_trip'
		$val = $CurrentForm->hasValue("trip") ? $CurrentForm->getValue("trip") : $CurrentForm->getValue("x_trip");
		if (!$this->trip->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->trip->Visible = FALSE; // Disable update for API request
			else
				$this->trip->setFormValue($val);
		}
		$this->trip->setOldValue($CurrentForm->getValue("o_trip"));

		// Check field name 'diesal' first before field var 'x_diesal'
		$val = $CurrentForm->hasValue("diesal") ? $CurrentForm->getValue("diesal") : $CurrentForm->getValue("x_diesal");
		if (!$this->diesal->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diesal->Visible = FALSE; // Disable update for API request
			else
				$this->diesal->setFormValue($val);
		}
		$this->diesal->setOldValue($CurrentForm->getValue("o_diesal"));

		// Check field name 'border' first before field var 'x_border'
		$val = $CurrentForm->hasValue("border") ? $CurrentForm->getValue("border") : $CurrentForm->getValue("x_border");
		if (!$this->border->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->border->Visible = FALSE; // Disable update for API request
			else
				$this->border->setFormValue($val);
		}
		$this->border->setOldValue($CurrentForm->getValue("o_border"));

		// Check field name 'rto' first before field var 'x_rto'
		$val = $CurrentForm->hasValue("rto") ? $CurrentForm->getValue("rto") : $CurrentForm->getValue("x_rto");
		if (!$this->rto->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->rto->Visible = FALSE; // Disable update for API request
			else
				$this->rto->setFormValue($val);
		}
		$this->rto->setOldValue($CurrentForm->getValue("o_rto"));

		// Check field name 'da' first before field var 'x_da'
		$val = $CurrentForm->hasValue("da") ? $CurrentForm->getValue("da") : $CurrentForm->getValue("x_da");
		if (!$this->da->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->da->Visible = FALSE; // Disable update for API request
			else
				$this->da->setFormValue($val);
		}
		$this->da->setOldValue($CurrentForm->getValue("o_da"));

		// Check field name 'repairing' first before field var 'x_repairing'
		$val = $CurrentForm->hasValue("repairing") ? $CurrentForm->getValue("repairing") : $CurrentForm->getValue("x_repairing");
		if (!$this->repairing->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->repairing->Visible = FALSE; // Disable update for API request
			else
				$this->repairing->setFormValue($val);
		}
		$this->repairing->setOldValue($CurrentForm->getValue("o_repairing"));

		// Check field name 'toll' first before field var 'x_toll'
		$val = $CurrentForm->hasValue("toll") ? $CurrentForm->getValue("toll") : $CurrentForm->getValue("x_toll");
		if (!$this->toll->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->toll->Visible = FALSE; // Disable update for API request
			else
				$this->toll->setFormValue($val);
		}
		$this->toll->setOldValue($CurrentForm->getValue("o_toll"));

		// Check field name 'other' first before field var 'x_other'
		$val = $CurrentForm->hasValue("other") ? $CurrentForm->getValue("other") : $CurrentForm->getValue("x_other");
		if (!$this->other->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->other->Visible = FALSE; // Disable update for API request
			else
				$this->other->setFormValue($val);
		}
		$this->other->setOldValue($CurrentForm->getValue("o_other"));

		// Check field name 'cash_paid' first before field var 'x_cash_paid'
		$val = $CurrentForm->hasValue("cash_paid") ? $CurrentForm->getValue("cash_paid") : $CurrentForm->getValue("x_cash_paid");
		if (!$this->cash_paid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cash_paid->Visible = FALSE; // Disable update for API request
			else
				$this->cash_paid->setFormValue($val);
		}
		$this->cash_paid->setOldValue($CurrentForm->getValue("o_cash_paid"));

		// Check field name 'total' first before field var 'x_total'
		$val = $CurrentForm->hasValue("total") ? $CurrentForm->getValue("total") : $CurrentForm->getValue("x_total");
		if (!$this->total->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->total->Visible = FALSE; // Disable update for API request
			else
				$this->total->setFormValue($val);
		}
		$this->total->setOldValue($CurrentForm->getValue("o_total"));

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}
		$this->remarks->setOldValue($CurrentForm->getValue("o_remarks"));

		// Check field name 'dated' first before field var 'x_dated'
		$val = $CurrentForm->hasValue("dated") ? $CurrentForm->getValue("dated") : $CurrentForm->getValue("x_dated");
		if (!$this->dated->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->dated->Visible = FALSE; // Disable update for API request
			else
				$this->dated->setFormValue($val);
			$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		}
		$this->dated->setOldValue($CurrentForm->getValue("o_dated"));

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}
		$this->operator->setOldValue($CurrentForm->getValue("o_operator"));

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
		$this->datetime->setOldValue($CurrentForm->getValue("o_datetime"));

		// Check field name 'diesal_lt' first before field var 'x_diesal_lt'
		$val = $CurrentForm->hasValue("diesal_lt") ? $CurrentForm->getValue("diesal_lt") : $CurrentForm->getValue("x_diesal_lt");
		if (!$this->diesal_lt->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diesal_lt->Visible = FALSE; // Disable update for API request
			else
				$this->diesal_lt->setFormValue($val);
		}
		$this->diesal_lt->setOldValue($CurrentForm->getValue("o_diesal_lt"));

		// Check field name 'def' first before field var 'x_def'
		$val = $CurrentForm->hasValue("def") ? $CurrentForm->getValue("def") : $CurrentForm->getValue("x_def");
		if (!$this->def->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->def->Visible = FALSE; // Disable update for API request
			else
				$this->def->setFormValue($val);
		}
		$this->def->setOldValue($CurrentForm->getValue("o_def"));
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		if (!$this->isGridAdd() && !$this->isAdd())
			$this->id->CurrentValue = $this->id->FormValue;
		$this->trip->CurrentValue = $this->trip->FormValue;
		$this->diesal->CurrentValue = $this->diesal->FormValue;
		$this->border->CurrentValue = $this->border->FormValue;
		$this->rto->CurrentValue = $this->rto->FormValue;
		$this->da->CurrentValue = $this->da->FormValue;
		$this->repairing->CurrentValue = $this->repairing->FormValue;
		$this->toll->CurrentValue = $this->toll->FormValue;
		$this->other->CurrentValue = $this->other->FormValue;
		$this->cash_paid->CurrentValue = $this->cash_paid->FormValue;
		$this->total->CurrentValue = $this->total->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->dated->CurrentValue = $this->dated->FormValue;
		$this->dated->CurrentValue = UnFormatDateTime($this->dated->CurrentValue, 0);
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		$this->diesal_lt->CurrentValue = $this->diesal_lt->FormValue;
		$this->def->CurrentValue = $this->def->FormValue;
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderBy())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->trip->setDbValue($row['trip']);
		$this->diesal->setDbValue($row['diesal']);
		$this->border->setDbValue($row['border']);
		$this->rto->setDbValue($row['rto']);
		$this->da->setDbValue($row['da']);
		$this->repairing->setDbValue($row['repairing']);
		$this->toll->setDbValue($row['toll']);
		$this->other->setDbValue($row['other']);
		$this->cash_paid->setDbValue($row['cash_paid']);
		$this->total->setDbValue($row['total']);
		$this->remarks->setDbValue($row['remarks']);
		$this->dated->setDbValue($row['dated']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->uploads->Upload->Index = $this->RowIndex;
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->diesal_lt->setDbValue($row['diesal_lt']);
		$this->def->setDbValue($row['def']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['trip'] = $this->trip->CurrentValue;
		$row['diesal'] = $this->diesal->CurrentValue;
		$row['border'] = $this->border->CurrentValue;
		$row['rto'] = $this->rto->CurrentValue;
		$row['da'] = $this->da->CurrentValue;
		$row['repairing'] = $this->repairing->CurrentValue;
		$row['toll'] = $this->toll->CurrentValue;
		$row['other'] = $this->other->CurrentValue;
		$row['cash_paid'] = $this->cash_paid->CurrentValue;
		$row['total'] = $this->total->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['dated'] = $this->dated->CurrentValue;
		$row['uploads'] = $this->uploads->Upload->DbValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['diesal_lt'] = $this->diesal_lt->CurrentValue;
		$row['def'] = $this->def->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		$arKeys[] = $this->RowOldKey;
		$cnt = count($arKeys);
		if ($cnt >= 1) {
			if (strval($arKeys[0]) <> "")
				$this->id->CurrentValue = strval($arKeys[0]); // id
			else
				$validKey = FALSE;
		} else {
			$validKey = FALSE;
		}

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->diesal->FormValue == $this->diesal->CurrentValue && is_numeric(ConvertToFloatString($this->diesal->CurrentValue)))
			$this->diesal->CurrentValue = ConvertToFloatString($this->diesal->CurrentValue);

		// Convert decimal values if posted back
		if ($this->border->FormValue == $this->border->CurrentValue && is_numeric(ConvertToFloatString($this->border->CurrentValue)))
			$this->border->CurrentValue = ConvertToFloatString($this->border->CurrentValue);

		// Convert decimal values if posted back
		if ($this->rto->FormValue == $this->rto->CurrentValue && is_numeric(ConvertToFloatString($this->rto->CurrentValue)))
			$this->rto->CurrentValue = ConvertToFloatString($this->rto->CurrentValue);

		// Convert decimal values if posted back
		if ($this->da->FormValue == $this->da->CurrentValue && is_numeric(ConvertToFloatString($this->da->CurrentValue)))
			$this->da->CurrentValue = ConvertToFloatString($this->da->CurrentValue);

		// Convert decimal values if posted back
		if ($this->repairing->FormValue == $this->repairing->CurrentValue && is_numeric(ConvertToFloatString($this->repairing->CurrentValue)))
			$this->repairing->CurrentValue = ConvertToFloatString($this->repairing->CurrentValue);

		// Convert decimal values if posted back
		if ($this->toll->FormValue == $this->toll->CurrentValue && is_numeric(ConvertToFloatString($this->toll->CurrentValue)))
			$this->toll->CurrentValue = ConvertToFloatString($this->toll->CurrentValue);

		// Convert decimal values if posted back
		if ($this->other->FormValue == $this->other->CurrentValue && is_numeric(ConvertToFloatString($this->other->CurrentValue)))
			$this->other->CurrentValue = ConvertToFloatString($this->other->CurrentValue);

		// Convert decimal values if posted back
		if ($this->total->FormValue == $this->total->CurrentValue && is_numeric(ConvertToFloatString($this->total->CurrentValue)))
			$this->total->CurrentValue = ConvertToFloatString($this->total->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_lt->FormValue == $this->diesal_lt->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_lt->CurrentValue)))
			$this->diesal_lt->CurrentValue = ConvertToFloatString($this->diesal_lt->CurrentValue);

		// Convert decimal values if posted back
		if ($this->def->FormValue == $this->def->CurrentValue && is_numeric(ConvertToFloatString($this->def->CurrentValue)))
			$this->def->CurrentValue = ConvertToFloatString($this->def->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// trip
		// diesal
		// border
		// rto
		// da
		// repairing
		// toll
		// other
		// cash_paid
		// total
		// remarks
		// dated
		// uploads
		// operator
		// datetime
		// diesal_lt
		// def

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// trip
			$curVal = strval($this->trip->CurrentValue);
			if ($curVal <> "") {
				$this->trip->ViewValue = $this->trip->lookupCacheOption($curVal);
				if ($this->trip->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`vehicle_type` =  1 and `status` = 2 and `status` != 3" : "`vehicle_type` =  1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->trip->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->trip->ViewValue = $this->trip->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->trip->ViewValue = $this->trip->CurrentValue;
					}
				}
			} else {
				$this->trip->ViewValue = NULL;
			}
			$this->trip->ViewCustomAttributes = "";

			// diesal
			$this->diesal->ViewValue = $this->diesal->CurrentValue;
			$this->diesal->ViewValue = FormatNumber($this->diesal->ViewValue, 2, -2, -2, -2);
			$this->diesal->ViewCustomAttributes = "";

			// border
			$this->border->ViewValue = $this->border->CurrentValue;
			$this->border->ViewValue = FormatNumber($this->border->ViewValue, 2, -2, -2, -2);
			$this->border->ViewCustomAttributes = "";

			// rto
			$this->rto->ViewValue = $this->rto->CurrentValue;
			$this->rto->ViewValue = FormatNumber($this->rto->ViewValue, 2, -2, -2, -2);
			$this->rto->ViewCustomAttributes = "";

			// da
			$this->da->ViewValue = $this->da->CurrentValue;
			$this->da->ViewValue = FormatNumber($this->da->ViewValue, 2, -2, -2, -2);
			$this->da->ViewCustomAttributes = "";

			// repairing
			$this->repairing->ViewValue = $this->repairing->CurrentValue;
			$this->repairing->ViewValue = FormatNumber($this->repairing->ViewValue, 2, -2, -2, -2);
			$this->repairing->ViewCustomAttributes = "";

			// toll
			$this->toll->ViewValue = $this->toll->CurrentValue;
			$this->toll->ViewValue = FormatNumber($this->toll->ViewValue, 2, -2, -2, -2);
			$this->toll->ViewCustomAttributes = "";

			// other
			$this->other->ViewValue = $this->other->CurrentValue;
			$this->other->ViewValue = FormatNumber($this->other->ViewValue, 2, -2, -2, -2);
			$this->other->ViewCustomAttributes = "";

			// cash_paid
			$this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
			$this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, 0, -2, -2, -2);
			$this->cash_paid->ViewCustomAttributes = "";

			// total
			$this->total->ViewValue = $this->total->CurrentValue;
			$this->total->ViewValue = FormatNumber($this->total->ViewValue, 2, -2, -2, -2);
			$this->total->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// dated
			$this->dated->ViewValue = $this->dated->CurrentValue;
			$this->dated->ViewValue = FormatDateTime($this->dated->ViewValue, 0);
			$this->dated->ViewCustomAttributes = "";

			// uploads
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// operator
			$this->operator->ViewValue = $this->operator->CurrentValue;
			$this->operator->ViewValue = FormatNumber($this->operator->ViewValue, 0, -2, -2, -2);
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// diesal_lt
			$this->diesal_lt->ViewValue = $this->diesal_lt->CurrentValue;
			$this->diesal_lt->ViewValue = FormatNumber($this->diesal_lt->ViewValue, 2, -2, -2, -2);
			$this->diesal_lt->ViewCustomAttributes = "";

			// def
			$this->def->ViewValue = $this->def->CurrentValue;
			$this->def->ViewValue = FormatNumber($this->def->ViewValue, 2, -2, -2, -2);
			$this->def->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// trip
			$this->trip->LinkCustomAttributes = "";
			$this->trip->HrefValue = "";
			$this->trip->TooltipValue = "";

			// diesal
			$this->diesal->LinkCustomAttributes = "";
			$this->diesal->HrefValue = "";
			$this->diesal->TooltipValue = "";

			// border
			$this->border->LinkCustomAttributes = "";
			$this->border->HrefValue = "";
			$this->border->TooltipValue = "";

			// rto
			$this->rto->LinkCustomAttributes = "";
			$this->rto->HrefValue = "";
			$this->rto->TooltipValue = "";

			// da
			$this->da->LinkCustomAttributes = "";
			$this->da->HrefValue = "";
			$this->da->TooltipValue = "";

			// repairing
			$this->repairing->LinkCustomAttributes = "";
			$this->repairing->HrefValue = "";
			$this->repairing->TooltipValue = "";

			// toll
			$this->toll->LinkCustomAttributes = "";
			$this->toll->HrefValue = "";
			$this->toll->TooltipValue = "";

			// other
			$this->other->LinkCustomAttributes = "";
			$this->other->HrefValue = "";
			$this->other->TooltipValue = "";

			// cash_paid
			$this->cash_paid->LinkCustomAttributes = "";
			$this->cash_paid->HrefValue = "";
			$this->cash_paid->TooltipValue = "";

			// total
			$this->total->LinkCustomAttributes = "";
			$this->total->HrefValue = "";
			$this->total->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";
			$this->dated->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "t_expenses_x" . $this->RowCnt . "_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";

			// diesal_lt
			$this->diesal_lt->LinkCustomAttributes = "";
			$this->diesal_lt->HrefValue = "";
			$this->diesal_lt->TooltipValue = "";

			// def
			$this->def->LinkCustomAttributes = "";
			$this->def->HrefValue = "";
			$this->def->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// id
			// trip

			$this->trip->EditAttrs["class"] = "form-control";
			$this->trip->EditCustomAttributes = "";
			if ($this->trip->getSessionValue() <> "") {
				$this->trip->CurrentValue = $this->trip->getSessionValue();
				$this->trip->OldValue = $this->trip->CurrentValue;
			$curVal = strval($this->trip->CurrentValue);
			if ($curVal <> "") {
				$this->trip->ViewValue = $this->trip->lookupCacheOption($curVal);
				if ($this->trip->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`vehicle_type` =  1 and `status` = 2 and `status` != 3" : "`vehicle_type` =  1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->trip->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->trip->ViewValue = $this->trip->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->trip->ViewValue = $this->trip->CurrentValue;
					}
				}
			} else {
				$this->trip->ViewValue = NULL;
			}
			$this->trip->ViewCustomAttributes = "";
			} else {
			$curVal = trim(strval($this->trip->CurrentValue));
			if ($curVal <> "")
				$this->trip->ViewValue = $this->trip->lookupCacheOption($curVal);
			else
				$this->trip->ViewValue = $this->trip->Lookup !== NULL && is_array($this->trip->Lookup->Options) ? $curVal : NULL;
			if ($this->trip->ViewValue !== NULL) { // Load from cache
				$this->trip->EditValue = array_values($this->trip->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->trip->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`vehicle_type` =  1 and `status` = 2 and `status` != 3" : "`vehicle_type` =  1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->trip->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->trip->EditValue = $arwrk;
			}
			}

			// diesal
			$this->diesal->EditAttrs["class"] = "form-control";
			$this->diesal->EditCustomAttributes = "";
			$this->diesal->EditValue = HtmlEncode($this->diesal->CurrentValue);
			$this->diesal->PlaceHolder = RemoveHtml($this->diesal->caption());
			if (strval($this->diesal->EditValue) <> "" && is_numeric($this->diesal->EditValue)) {
				$this->diesal->EditValue = FormatNumber($this->diesal->EditValue, -2, -2, -2, -2);
				$this->diesal->OldValue = $this->diesal->EditValue;
			}

			// border
			$this->border->EditAttrs["class"] = "form-control";
			$this->border->EditCustomAttributes = "";
			$this->border->EditValue = HtmlEncode($this->border->CurrentValue);
			$this->border->PlaceHolder = RemoveHtml($this->border->caption());
			if (strval($this->border->EditValue) <> "" && is_numeric($this->border->EditValue)) {
				$this->border->EditValue = FormatNumber($this->border->EditValue, -2, -2, -2, -2);
				$this->border->OldValue = $this->border->EditValue;
			}

			// rto
			$this->rto->EditAttrs["class"] = "form-control";
			$this->rto->EditCustomAttributes = "";
			$this->rto->EditValue = HtmlEncode($this->rto->CurrentValue);
			$this->rto->PlaceHolder = RemoveHtml($this->rto->caption());
			if (strval($this->rto->EditValue) <> "" && is_numeric($this->rto->EditValue)) {
				$this->rto->EditValue = FormatNumber($this->rto->EditValue, -2, -2, -2, -2);
				$this->rto->OldValue = $this->rto->EditValue;
			}

			// da
			$this->da->EditAttrs["class"] = "form-control";
			$this->da->EditCustomAttributes = "";
			$this->da->EditValue = HtmlEncode($this->da->CurrentValue);
			$this->da->PlaceHolder = RemoveHtml($this->da->caption());
			if (strval($this->da->EditValue) <> "" && is_numeric($this->da->EditValue)) {
				$this->da->EditValue = FormatNumber($this->da->EditValue, -2, -2, -2, -2);
				$this->da->OldValue = $this->da->EditValue;
			}

			// repairing
			$this->repairing->EditAttrs["class"] = "form-control";
			$this->repairing->EditCustomAttributes = "";
			$this->repairing->EditValue = HtmlEncode($this->repairing->CurrentValue);
			$this->repairing->PlaceHolder = RemoveHtml($this->repairing->caption());
			if (strval($this->repairing->EditValue) <> "" && is_numeric($this->repairing->EditValue)) {
				$this->repairing->EditValue = FormatNumber($this->repairing->EditValue, -2, -2, -2, -2);
				$this->repairing->OldValue = $this->repairing->EditValue;
			}

			// toll
			$this->toll->EditAttrs["class"] = "form-control";
			$this->toll->EditCustomAttributes = "";
			$this->toll->EditValue = HtmlEncode($this->toll->CurrentValue);
			$this->toll->PlaceHolder = RemoveHtml($this->toll->caption());
			if (strval($this->toll->EditValue) <> "" && is_numeric($this->toll->EditValue)) {
				$this->toll->EditValue = FormatNumber($this->toll->EditValue, -2, -2, -2, -2);
				$this->toll->OldValue = $this->toll->EditValue;
			}

			// other
			$this->other->EditAttrs["class"] = "form-control";
			$this->other->EditCustomAttributes = "";
			$this->other->EditValue = HtmlEncode($this->other->CurrentValue);
			$this->other->PlaceHolder = RemoveHtml($this->other->caption());
			if (strval($this->other->EditValue) <> "" && is_numeric($this->other->EditValue)) {
				$this->other->EditValue = FormatNumber($this->other->EditValue, -2, -2, -2, -2);
				$this->other->OldValue = $this->other->EditValue;
			}

			// cash_paid
			$this->cash_paid->EditAttrs["class"] = "form-control";
			$this->cash_paid->EditCustomAttributes = 'ReadOnly';
			$this->cash_paid->EditValue = HtmlEncode($this->cash_paid->CurrentValue);
			$this->cash_paid->PlaceHolder = RemoveHtml($this->cash_paid->caption());

			// total
			$this->total->EditAttrs["class"] = "form-control";
			$this->total->EditCustomAttributes = 'ReadOnly';
			$this->total->EditValue = HtmlEncode($this->total->CurrentValue);
			$this->total->PlaceHolder = RemoveHtml($this->total->caption());
			if (strval($this->total->EditValue) <> "" && is_numeric($this->total->EditValue)) {
				$this->total->EditValue = FormatNumber($this->total->EditValue, -2, -2, -2, -2);
				$this->total->OldValue = $this->total->EditValue;
			}

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// dated
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, 8));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->EditValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->EditValue = "";
			}
			if (!EmptyValue($this->uploads->CurrentValue))
					$this->uploads->Upload->FileName = $this->uploads->CurrentValue;
			if (is_numeric($this->RowIndex) && !$this->EventCancelled)
				RenderUploadField($this->uploads, $this->RowIndex);

			// operator
			// datetime
			// diesal_lt

			$this->diesal_lt->EditAttrs["class"] = "form-control";
			$this->diesal_lt->EditCustomAttributes = "";
			$this->diesal_lt->EditValue = HtmlEncode($this->diesal_lt->CurrentValue);
			$this->diesal_lt->PlaceHolder = RemoveHtml($this->diesal_lt->caption());
			if (strval($this->diesal_lt->EditValue) <> "" && is_numeric($this->diesal_lt->EditValue)) {
				$this->diesal_lt->EditValue = FormatNumber($this->diesal_lt->EditValue, -2, -2, -2, -2);
				$this->diesal_lt->OldValue = $this->diesal_lt->EditValue;
			}

			// def
			$this->def->EditAttrs["class"] = "form-control";
			$this->def->EditCustomAttributes = "";
			$this->def->EditValue = HtmlEncode($this->def->CurrentValue);
			$this->def->PlaceHolder = RemoveHtml($this->def->caption());
			if (strval($this->def->EditValue) <> "" && is_numeric($this->def->EditValue)) {
				$this->def->EditValue = FormatNumber($this->def->EditValue, -2, -2, -2, -2);
				$this->def->OldValue = $this->def->EditValue;
			}

			// Add refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// trip
			$this->trip->LinkCustomAttributes = "";
			$this->trip->HrefValue = "";

			// diesal
			$this->diesal->LinkCustomAttributes = "";
			$this->diesal->HrefValue = "";

			// border
			$this->border->LinkCustomAttributes = "";
			$this->border->HrefValue = "";

			// rto
			$this->rto->LinkCustomAttributes = "";
			$this->rto->HrefValue = "";

			// da
			$this->da->LinkCustomAttributes = "";
			$this->da->HrefValue = "";

			// repairing
			$this->repairing->LinkCustomAttributes = "";
			$this->repairing->HrefValue = "";

			// toll
			$this->toll->LinkCustomAttributes = "";
			$this->toll->HrefValue = "";

			// other
			$this->other->LinkCustomAttributes = "";
			$this->other->HrefValue = "";

			// cash_paid
			$this->cash_paid->LinkCustomAttributes = "";
			$this->cash_paid->HrefValue = "";

			// total
			$this->total->LinkCustomAttributes = "";
			$this->total->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// diesal_lt
			$this->diesal_lt->LinkCustomAttributes = "";
			$this->diesal_lt->HrefValue = "";

			// def
			$this->def->LinkCustomAttributes = "";
			$this->def->HrefValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// trip
			$this->trip->EditAttrs["class"] = "form-control";
			$this->trip->EditCustomAttributes = "";
			$curVal = strval($this->trip->CurrentValue);
			if ($curVal <> "") {
				$this->trip->EditValue = $this->trip->lookupCacheOption($curVal);
				if ($this->trip->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`vehicle_type` =  1 and `status` = 2 and `status` != 3" : "`vehicle_type` =  1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->trip->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->trip->EditValue = $this->trip->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->trip->EditValue = $this->trip->CurrentValue;
					}
				}
			} else {
				$this->trip->EditValue = NULL;
			}
			$this->trip->ViewCustomAttributes = "";

			// diesal
			$this->diesal->EditAttrs["class"] = "form-control";
			$this->diesal->EditCustomAttributes = "";
			$this->diesal->EditValue = HtmlEncode($this->diesal->CurrentValue);
			$this->diesal->PlaceHolder = RemoveHtml($this->diesal->caption());
			if (strval($this->diesal->EditValue) <> "" && is_numeric($this->diesal->EditValue)) {
				$this->diesal->EditValue = FormatNumber($this->diesal->EditValue, -2, -2, -2, -2);
				$this->diesal->OldValue = $this->diesal->EditValue;
			}

			// border
			$this->border->EditAttrs["class"] = "form-control";
			$this->border->EditCustomAttributes = "";
			$this->border->EditValue = HtmlEncode($this->border->CurrentValue);
			$this->border->PlaceHolder = RemoveHtml($this->border->caption());
			if (strval($this->border->EditValue) <> "" && is_numeric($this->border->EditValue)) {
				$this->border->EditValue = FormatNumber($this->border->EditValue, -2, -2, -2, -2);
				$this->border->OldValue = $this->border->EditValue;
			}

			// rto
			$this->rto->EditAttrs["class"] = "form-control";
			$this->rto->EditCustomAttributes = "";
			$this->rto->EditValue = HtmlEncode($this->rto->CurrentValue);
			$this->rto->PlaceHolder = RemoveHtml($this->rto->caption());
			if (strval($this->rto->EditValue) <> "" && is_numeric($this->rto->EditValue)) {
				$this->rto->EditValue = FormatNumber($this->rto->EditValue, -2, -2, -2, -2);
				$this->rto->OldValue = $this->rto->EditValue;
			}

			// da
			$this->da->EditAttrs["class"] = "form-control";
			$this->da->EditCustomAttributes = "";
			$this->da->EditValue = HtmlEncode($this->da->CurrentValue);
			$this->da->PlaceHolder = RemoveHtml($this->da->caption());
			if (strval($this->da->EditValue) <> "" && is_numeric($this->da->EditValue)) {
				$this->da->EditValue = FormatNumber($this->da->EditValue, -2, -2, -2, -2);
				$this->da->OldValue = $this->da->EditValue;
			}

			// repairing
			$this->repairing->EditAttrs["class"] = "form-control";
			$this->repairing->EditCustomAttributes = "";
			$this->repairing->EditValue = HtmlEncode($this->repairing->CurrentValue);
			$this->repairing->PlaceHolder = RemoveHtml($this->repairing->caption());
			if (strval($this->repairing->EditValue) <> "" && is_numeric($this->repairing->EditValue)) {
				$this->repairing->EditValue = FormatNumber($this->repairing->EditValue, -2, -2, -2, -2);
				$this->repairing->OldValue = $this->repairing->EditValue;
			}

			// toll
			$this->toll->EditAttrs["class"] = "form-control";
			$this->toll->EditCustomAttributes = "";
			$this->toll->EditValue = HtmlEncode($this->toll->CurrentValue);
			$this->toll->PlaceHolder = RemoveHtml($this->toll->caption());
			if (strval($this->toll->EditValue) <> "" && is_numeric($this->toll->EditValue)) {
				$this->toll->EditValue = FormatNumber($this->toll->EditValue, -2, -2, -2, -2);
				$this->toll->OldValue = $this->toll->EditValue;
			}

			// other
			$this->other->EditAttrs["class"] = "form-control";
			$this->other->EditCustomAttributes = "";
			$this->other->EditValue = HtmlEncode($this->other->CurrentValue);
			$this->other->PlaceHolder = RemoveHtml($this->other->caption());
			if (strval($this->other->EditValue) <> "" && is_numeric($this->other->EditValue)) {
				$this->other->EditValue = FormatNumber($this->other->EditValue, -2, -2, -2, -2);
				$this->other->OldValue = $this->other->EditValue;
			}

			// cash_paid
			$this->cash_paid->EditAttrs["class"] = "form-control";
			$this->cash_paid->EditCustomAttributes = 'ReadOnly';
			$this->cash_paid->EditValue = HtmlEncode($this->cash_paid->CurrentValue);
			$this->cash_paid->PlaceHolder = RemoveHtml($this->cash_paid->caption());

			// total
			$this->total->EditAttrs["class"] = "form-control";
			$this->total->EditCustomAttributes = 'ReadOnly';
			$this->total->EditValue = HtmlEncode($this->total->CurrentValue);
			$this->total->PlaceHolder = RemoveHtml($this->total->caption());
			if (strval($this->total->EditValue) <> "" && is_numeric($this->total->EditValue)) {
				$this->total->EditValue = FormatNumber($this->total->EditValue, -2, -2, -2, -2);
				$this->total->OldValue = $this->total->EditValue;
			}

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->remarks->CurrentValue = HtmlDecode($this->remarks->CurrentValue);
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// dated
			$this->dated->EditAttrs["class"] = "form-control";
			$this->dated->EditCustomAttributes = "";
			$this->dated->EditValue = HtmlEncode(FormatDateTime($this->dated->CurrentValue, 8));
			$this->dated->PlaceHolder = RemoveHtml($this->dated->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->EditValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->EditValue = "";
			}
			if (!EmptyValue($this->uploads->CurrentValue))
					$this->uploads->Upload->FileName = $this->uploads->CurrentValue;
			if (is_numeric($this->RowIndex) && !$this->EventCancelled)
				RenderUploadField($this->uploads, $this->RowIndex);

			// operator
			// datetime
			// diesal_lt

			$this->diesal_lt->EditAttrs["class"] = "form-control";
			$this->diesal_lt->EditCustomAttributes = "";
			$this->diesal_lt->EditValue = HtmlEncode($this->diesal_lt->CurrentValue);
			$this->diesal_lt->PlaceHolder = RemoveHtml($this->diesal_lt->caption());
			if (strval($this->diesal_lt->EditValue) <> "" && is_numeric($this->diesal_lt->EditValue)) {
				$this->diesal_lt->EditValue = FormatNumber($this->diesal_lt->EditValue, -2, -2, -2, -2);
				$this->diesal_lt->OldValue = $this->diesal_lt->EditValue;
			}

			// def
			$this->def->EditAttrs["class"] = "form-control";
			$this->def->EditCustomAttributes = "";
			$this->def->EditValue = HtmlEncode($this->def->CurrentValue);
			$this->def->PlaceHolder = RemoveHtml($this->def->caption());
			if (strval($this->def->EditValue) <> "" && is_numeric($this->def->EditValue)) {
				$this->def->EditValue = FormatNumber($this->def->EditValue, -2, -2, -2, -2);
				$this->def->OldValue = $this->def->EditValue;
			}

			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// trip
			$this->trip->LinkCustomAttributes = "";
			$this->trip->HrefValue = "";
			$this->trip->TooltipValue = "";

			// diesal
			$this->diesal->LinkCustomAttributes = "";
			$this->diesal->HrefValue = "";

			// border
			$this->border->LinkCustomAttributes = "";
			$this->border->HrefValue = "";

			// rto
			$this->rto->LinkCustomAttributes = "";
			$this->rto->HrefValue = "";

			// da
			$this->da->LinkCustomAttributes = "";
			$this->da->HrefValue = "";

			// repairing
			$this->repairing->LinkCustomAttributes = "";
			$this->repairing->HrefValue = "";

			// toll
			$this->toll->LinkCustomAttributes = "";
			$this->toll->HrefValue = "";

			// other
			$this->other->LinkCustomAttributes = "";
			$this->other->HrefValue = "";

			// cash_paid
			$this->cash_paid->LinkCustomAttributes = "";
			$this->cash_paid->HrefValue = "";

			// total
			$this->total->LinkCustomAttributes = "";
			$this->total->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// dated
			$this->dated->LinkCustomAttributes = "";
			$this->dated->HrefValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = "%u"; // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";

			// diesal_lt
			$this->diesal_lt->LinkCustomAttributes = "";
			$this->diesal_lt->HrefValue = "";

			// def
			$this->def->LinkCustomAttributes = "";
			$this->def->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->trip->Required) {
			if (!$this->trip->IsDetailKey && $this->trip->FormValue != NULL && $this->trip->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->trip->caption(), $this->trip->RequiredErrorMessage));
			}
		}
		if ($this->diesal->Required) {
			if (!$this->diesal->IsDetailKey && $this->diesal->FormValue != NULL && $this->diesal->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal->caption(), $this->diesal->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->diesal->FormValue)) {
			AddMessage($FormError, $this->diesal->errorMessage());
		}
		if ($this->border->Required) {
			if (!$this->border->IsDetailKey && $this->border->FormValue != NULL && $this->border->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->border->caption(), $this->border->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->border->FormValue)) {
			AddMessage($FormError, $this->border->errorMessage());
		}
		if ($this->rto->Required) {
			if (!$this->rto->IsDetailKey && $this->rto->FormValue != NULL && $this->rto->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->rto->caption(), $this->rto->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->rto->FormValue)) {
			AddMessage($FormError, $this->rto->errorMessage());
		}
		if ($this->da->Required) {
			if (!$this->da->IsDetailKey && $this->da->FormValue != NULL && $this->da->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->da->caption(), $this->da->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->da->FormValue)) {
			AddMessage($FormError, $this->da->errorMessage());
		}
		if ($this->repairing->Required) {
			if (!$this->repairing->IsDetailKey && $this->repairing->FormValue != NULL && $this->repairing->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->repairing->caption(), $this->repairing->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->repairing->FormValue)) {
			AddMessage($FormError, $this->repairing->errorMessage());
		}
		if ($this->toll->Required) {
			if (!$this->toll->IsDetailKey && $this->toll->FormValue != NULL && $this->toll->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->toll->caption(), $this->toll->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->toll->FormValue)) {
			AddMessage($FormError, $this->toll->errorMessage());
		}
		if ($this->other->Required) {
			if (!$this->other->IsDetailKey && $this->other->FormValue != NULL && $this->other->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->other->caption(), $this->other->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->other->FormValue)) {
			AddMessage($FormError, $this->other->errorMessage());
		}
		if ($this->cash_paid->Required) {
			if (!$this->cash_paid->IsDetailKey && $this->cash_paid->FormValue != NULL && $this->cash_paid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cash_paid->caption(), $this->cash_paid->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->cash_paid->FormValue)) {
			AddMessage($FormError, $this->cash_paid->errorMessage());
		}
		if ($this->total->Required) {
			if (!$this->total->IsDetailKey && $this->total->FormValue != NULL && $this->total->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->total->caption(), $this->total->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->total->FormValue)) {
			AddMessage($FormError, $this->total->errorMessage());
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->dated->Required) {
			if (!$this->dated->IsDetailKey && $this->dated->FormValue != NULL && $this->dated->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->dated->caption(), $this->dated->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->dated->FormValue)) {
			AddMessage($FormError, $this->dated->errorMessage());
		}
		if ($this->uploads->Required) {
			if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->diesal_lt->Required) {
			if (!$this->diesal_lt->IsDetailKey && $this->diesal_lt->FormValue != NULL && $this->diesal_lt->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal_lt->caption(), $this->diesal_lt->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->diesal_lt->FormValue)) {
			AddMessage($FormError, $this->diesal_lt->errorMessage());
		}
		if ($this->def->Required) {
			if (!$this->def->IsDetailKey && $this->def->FormValue != NULL && $this->def->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->def->caption(), $this->def->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->def->FormValue)) {
			AddMessage($FormError, $this->def->errorMessage());
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Delete records based on current filter
	protected function deleteRows()
	{
		global $Language, $Security;
		if (!$Security->canDelete()) {
			$this->setFailureMessage($Language->phrase("NoDeletePermission")); // No delete permission
			return FALSE;
		}
		$deleteRows = TRUE;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE) {
			return FALSE;
		} elseif ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
			$rs->close();
			return FALSE;
		}
		$rows = ($rs) ? $rs->getRows() : [];

		// Clone old rows
		$rsold = $rows;
		if ($rs)
			$rs->close();

		// Call row deleting event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$deleteRows = $this->Row_Deleting($row);
				if (!$deleteRows)
					break;
			}
		}
		if ($deleteRows) {
			$key = "";
			foreach ($rsold as $row) {
				$thisKey = "";
				if ($thisKey <> "")
					$thisKey .= $GLOBALS["COMPOSITE_KEY_SEPARATOR"];
				$thisKey .= $row['id'];
				if (DELETE_UPLOADED_FILES) // Delete old files
					$this->deleteUploadedFiles($row);
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				$deleteRows = $this->delete($row); // Delete
				$conn->raiseErrorFn = '';
				if ($deleteRows === FALSE)
					break;
				if ($key <> "")
					$key .= ", ";
				$key .= $thisKey;
			}
		}
		if (!$deleteRows) {

			// Set up error message
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("DeleteCancelled"));
			}
		}

		// Call Row Deleted event
		if ($deleteRows) {
			foreach ($rsold as $row) {
				$this->Row_Deleted($row);
			}
		}

		// Write JSON for API request (Support single row only)
		if (IsApi() && $deleteRows) {
			$row = $this->getRecordsFromRecordset($rsold, TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $deleteRows;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		if ($this->trip->CurrentValue <> "") { // Check field with unique index
			$filterChk = "(`trip` = " . AdjustSql($this->trip->CurrentValue, $this->Dbid) . ")";
			$filterChk .= " AND NOT (" . $filter . ")";
			$this->CurrentFilter = $filterChk;
			$sqlChk = $this->getCurrentSql();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rsChk = $conn->Execute($sqlChk);
			$conn->raiseErrorFn = '';
			if ($rsChk === FALSE) {
				return FALSE;
			} elseif (!$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->trip->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->trip->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
			$rsChk->close();
		}
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->uploads->OldUploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
			$this->uploads->UploadPath = $this->uploads->OldUploadPath;
			$rsnew = [];

			// diesal
			$this->diesal->setDbValueDef($rsnew, $this->diesal->CurrentValue, 0, $this->diesal->ReadOnly);

			// border
			$this->border->setDbValueDef($rsnew, $this->border->CurrentValue, 0, $this->border->ReadOnly);

			// rto
			$this->rto->setDbValueDef($rsnew, $this->rto->CurrentValue, 0, $this->rto->ReadOnly);

			// da
			$this->da->setDbValueDef($rsnew, $this->da->CurrentValue, 0, $this->da->ReadOnly);

			// repairing
			$this->repairing->setDbValueDef($rsnew, $this->repairing->CurrentValue, 0, $this->repairing->ReadOnly);

			// toll
			$this->toll->setDbValueDef($rsnew, $this->toll->CurrentValue, 0, $this->toll->ReadOnly);

			// other
			$this->other->setDbValueDef($rsnew, $this->other->CurrentValue, 0, $this->other->ReadOnly);

			// cash_paid
			$this->cash_paid->setDbValueDef($rsnew, $this->cash_paid->CurrentValue, 0, $this->cash_paid->ReadOnly);

			// total
			$this->total->setDbValueDef($rsnew, $this->total->CurrentValue, 0, $this->total->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// dated
			$this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, 0), CurrentDate(), $this->dated->ReadOnly);

			// uploads
			if ($this->uploads->Visible && !$this->uploads->ReadOnly && !$this->uploads->Upload->KeepFile) {
				$this->uploads->Upload->DbValue = $rsold['uploads']; // Get original value
				if ($this->uploads->Upload->FileName == "") {
					$rsnew['uploads'] = NULL;
				} else {
					$rsnew['uploads'] = $this->uploads->Upload->FileName;
				}
				$this->uploads->ImageWidth = 0; // Resize width
				$this->uploads->ImageHeight = 640; // Resize height
			}

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;

			// diesal_lt
			$this->diesal_lt->setDbValueDef($rsnew, $this->diesal_lt->CurrentValue, 0, $this->diesal_lt->ReadOnly);

			// def
			$this->def->setDbValueDef($rsnew, $this->def->CurrentValue, 0, $this->def->ReadOnly);
			if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
				$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
				$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
				if (!EmptyValue($this->uploads->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1) || file_exists($this->uploads->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file, UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->uploads->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, NULL, $this->uploads->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
						if (!EmptyValue($this->uploads->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->uploads->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['uploads']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->uploads->Upload->resizeAndSaveToFile($this->uploads->ImageWidth, $this->uploads->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// uploads
		if ($this->uploads->Upload->FileToken <> "")
			CleanUploadTempPath($this->uploads->Upload->FileToken, $this->uploads->Upload->Index);
		else
			CleanUploadTempPath($this->uploads, $this->uploads->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;

		// Set up foreign key field value from Session
			if ($this->getCurrentMasterTable() == "t_trip_expenses_report") {
				$this->trip->CurrentValue = $this->trip->getSessionValue();
			}
		if ($this->trip->CurrentValue <> "") { // Check field with unique index
			$filter = "(trip = " . AdjustSql($this->trip->CurrentValue, $this->Dbid) . ")";
			$rsChk = $this->loadRs($filter);
			if ($rsChk && !$rsChk->EOF) {
				$idxErrMsg = str_replace("%f", $this->trip->caption(), $Language->phrase("DupIndex"));
				$idxErrMsg = str_replace("%v", $this->trip->CurrentValue, $idxErrMsg);
				$this->setFailureMessage($idxErrMsg);
				$rsChk->close();
				return FALSE;
			}
		}
		$conn = &$this->getConnection();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->uploads->OldUploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
			$this->uploads->UploadPath = $this->uploads->OldUploadPath;
		}
		$rsnew = [];

		// trip
		$this->trip->setDbValueDef($rsnew, $this->trip->CurrentValue, 0, FALSE);

		// diesal
		$this->diesal->setDbValueDef($rsnew, $this->diesal->CurrentValue, 0, strval($this->diesal->CurrentValue) == "");

		// border
		$this->border->setDbValueDef($rsnew, $this->border->CurrentValue, 0, strval($this->border->CurrentValue) == "");

		// rto
		$this->rto->setDbValueDef($rsnew, $this->rto->CurrentValue, 0, strval($this->rto->CurrentValue) == "");

		// da
		$this->da->setDbValueDef($rsnew, $this->da->CurrentValue, 0, strval($this->da->CurrentValue) == "");

		// repairing
		$this->repairing->setDbValueDef($rsnew, $this->repairing->CurrentValue, 0, strval($this->repairing->CurrentValue) == "");

		// toll
		$this->toll->setDbValueDef($rsnew, $this->toll->CurrentValue, 0, strval($this->toll->CurrentValue) == "");

		// other
		$this->other->setDbValueDef($rsnew, $this->other->CurrentValue, 0, strval($this->other->CurrentValue) == "");

		// cash_paid
		$this->cash_paid->setDbValueDef($rsnew, $this->cash_paid->CurrentValue, 0, FALSE);

		// total
		$this->total->setDbValueDef($rsnew, $this->total->CurrentValue, 0, strval($this->total->CurrentValue) == "");

		// remarks
		$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, FALSE);

		// dated
		$this->dated->setDbValueDef($rsnew, UnFormatDateTime($this->dated->CurrentValue, 0), CurrentDate(), FALSE);

		// uploads
		if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
			$this->uploads->Upload->DbValue = ""; // No need to delete old file
			if ($this->uploads->Upload->FileName == "") {
				$rsnew['uploads'] = NULL;
			} else {
				if ($rsold && $rsold->fields['uploads'] <> "" && $this->uploads->Upload->FileName <> "") {
					$oldFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsold->fields['uploads']);
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->uploads->Upload->FileName);
					$newFileCount = count($newFiles);
					for ($i = 0; $i < $newFileCount; $i++) {
						if ($newFiles[$i] <> "" && in_array($newFiles[$i], $oldFiles)) {
							$tempFile = UniqueFilename($this->uploads->physicalUploadPath(), $newFiles[$i]);
							rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i], UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $tempFile);
							$newFiles[$i] = $tempFile;
						}
					}
					$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				}
				$rsnew['uploads'] = $this->uploads->Upload->FileName;
			}
			$this->uploads->ImageWidth = 0; // Resize width
			$this->uploads->ImageHeight = 640; // Resize height
		}

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// diesal_lt
		$this->diesal_lt->setDbValueDef($rsnew, $this->diesal_lt->CurrentValue, 0, strval($this->diesal_lt->CurrentValue) == "");

		// def
		$this->def->setDbValueDef($rsnew, $this->def->CurrentValue, 0, strval($this->def->CurrentValue) == "");
		if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->trip->CurrentValue . '/expenses/';
			$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
			if (!EmptyValue($this->uploads->Upload->FileName)) {
				$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->FileName));
				$NewFileCount = count($newFiles);
				for ($i = 0; $i < $NewFileCount; $i++) {
					if ($newFiles[$i] <> "") {
						$file = $newFiles[$i];
						if (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file)) {
							if (DELETE_UPLOADED_FILES) {
								$oldFileFound = FALSE;
								$oldFileCount = count($oldFiles);
								for ($j = 0; $j < $oldFileCount; $j++) {
									$oldFile = $oldFiles[$j];
									if ($oldFile == $file) { // Old file found, no need to delete anymore
										unset($oldFiles[$j]);
										$oldFileFound = TRUE;
										break;
									}
								}
								if ($oldFileFound) // No need to check if file exists further
									continue;
							}
							$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file); // Get new file name
							if ($file1 <> $file) { // Rename temp file
								while (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1) || file_exists($this->uploads->physicalUploadPath() . $file1)) // Make sure no file name clash
									$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file1, TRUE); // Use indexed name
								rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file, UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1);
								$newFiles[$i] = $file1;
							}
						}
					}
				}
				$this->uploads->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
				$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
				$this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, NULL, FALSE);
			}
		}

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
				if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
					$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->uploads->Upload->DbValue));
					if (!EmptyValue($this->uploads->Upload->FileName)) {
						$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->uploads->Upload->FileName);
						$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['uploads']);
						$newFileCount = count($newFiles);
						for ($i = 0; $i < $newFileCount; $i++) {
							if ($newFiles[$i] <> "") {
								$file = UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i];
								if (file_exists($file)) {
									if (@$newFiles2[$i] <> "") // Use correct file name
										$newFiles[$i] = $newFiles2[$i];
									if (!$this->uploads->Upload->resizeAndSaveToFile($this->uploads->ImageWidth, $this->uploads->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
										$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
										return FALSE;
									}
								}
							}
						}
					} else {
						$newFiles = array();
					}
					if (DELETE_UPLOADED_FILES) {
						foreach ($oldFiles as $oldFile) {
							if ($oldFile <> "" && !in_array($oldFile, $newFiles))
								@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
						}
					}
				}
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// uploads
		if ($this->uploads->Upload->FileToken <> "")
			CleanUploadTempPath($this->uploads->Upload->FileToken, $this->uploads->Upload->Index);
		else
			CleanUploadTempPath($this->uploads, $this->uploads->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up master/detail based on QueryString
	protected function setupMasterParms()
	{

		// Hide foreign keys
		$masterTblVar = $this->getCurrentMasterTable();
		if ($masterTblVar == "t_trip_expenses_report") {
			$this->trip->Visible = FALSE;
			if ($GLOBALS["t_trip_expenses_report"]->EventCancelled)
				$this->EventCancelled = TRUE;
		}
		$this->DbMasterFilter = $this->getMasterFilter(); // Get master filter
		$this->DbDetailFilter = $this->getDetailFilter(); // Get detail filter
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_trip":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`vehicle_type` =  1 and `status` = 2 and `status` != 3" : "`vehicle_type` =  1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_trip":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

	}
}
?>