<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for t_trip_info
 */
class t_trip_info extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $vehicle_type;
	public $vehicle;
	public $_route;
	public $route_name;
	public $reports_to;
	public $buyer;
	public $b_consignor;
	public $b_consignee;
	public $load_date;
	public $load_weight;
	public $unload_date;
	public $unload_weight;
	public $invoice_no;
	public $invoice_date;
	public $amount;
	public $delivery_pod;
	public $status;
	public $days;
	public $driver;
	public $driver_name;
	public $agent;
	public $comm;
	public $material;
	public $packing_type;
	public $m_hsn;
	public $_40;
	public $lr_no;
	public $km;
	public $freight_type;
	public $freight;
	public $ded_det;
	public $ded_det_remarks;
	public $gst_percent;
	public $gst_amount;
	public $final_amount;
	public $load_km;
	public $unload_km;
	public $delivery_receipt;
	public $delivery_docket;
	public $diesal_op_b;
	public $diesal_required;
	public $diesal_fill;
	public $diesal_amount;
	public $diesal_cl_balance;
	public $vehicle_average;
	public $cash_required;
	public $cash_op_b;
	public $cash_paid;
	public $cash_expenses;
	public $cash_cl_balance;
	public $fasttag_op_b;
	public $fasttag_recharge;
	public $fasttag_expenses;
	public $toll_expenses_cash;
	public $fasttag_cl_balance;
	public $remarks;
	public $uploads;
	public $consignor;
	public $vehicle_freight_comm;
	public $vehicle_freight_type;
	public $vehicle_freight_amount;
	public $vehicle_freight_final;
	public $operator;
	public $datetime;
	public $expenses_id;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 't_trip_info';
		$this->TableName = 't_trip_info';
		$this->TableType = 'TABLE';

		// Update Table
		$this->UpdateTable = "`t_trip_info`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('t_trip_info', 't_trip_info', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->IsForeignKey = TRUE; // Foreign key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// vehicle_type
		$this->vehicle_type = new DbField('t_trip_info', 't_trip_info', 'x_vehicle_type', 'vehicle_type', '`vehicle_type`', '`vehicle_type`', 18, -1, FALSE, '`vehicle_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->vehicle_type->Nullable = FALSE; // NOT NULL field
		$this->vehicle_type->Sortable = TRUE; // Allow sort
		$this->vehicle_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->vehicle_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->vehicle_type->Lookup = new Lookup('vehicle_type', 't_trip_info', FALSE, '', ["","","",""], [], ["x_vehicle"], [], [], [], [], '', '');
		$this->vehicle_type->OptionCount = 2;
		$this->vehicle_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['vehicle_type'] = &$this->vehicle_type;

		// vehicle
		$this->vehicle = new DbField('t_trip_info', 't_trip_info', 'x_vehicle', 'vehicle', '`vehicle`', '`vehicle`', 18, -1, FALSE, '`vehicle`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->vehicle->Nullable = FALSE; // NOT NULL field
		$this->vehicle->Required = TRUE; // Required field
		$this->vehicle->Sortable = TRUE; // Allow sort
		$this->vehicle->Lookup = new Lookup('vehicle', 'vehicle_info', FALSE, 'id', ["no","","",""], ["x_vehicle_type"], [], ["type"], ["x_type"], ["driver_name","vehicle_owner"], ["x_driver","x_consignor"], '`no` ASC', '');
		$this->vehicle->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['vehicle'] = &$this->vehicle;

		// route
		$this->_route = new DbField('t_trip_info', 't_trip_info', 'x__route', 'route', '`route`', '`route`', 18, -1, FALSE, '`route`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_route->IsForeignKey = TRUE; // Foreign key field
		$this->_route->Nullable = FALSE; // NOT NULL field
		$this->_route->Required = TRUE; // Required field
		$this->_route->Sortable = TRUE; // Allow sort
		$this->_route->Lookup = new Lookup('route', 't_route_info', FALSE, 'id', ["route_name","","",""], [], [], [], [], [], [], '`route_name` ASC', '');
		$this->_route->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['route'] = &$this->_route;

		// route_name
		$this->route_name = new DbField('t_trip_info', 't_trip_info', 'x_route_name', 'route_name', '`route_name`', '`route_name`', 200, -1, FALSE, '`route_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->route_name->Sortable = TRUE; // Allow sort
		$this->fields['route_name'] = &$this->route_name;

		// reports_to
		$this->reports_to = new DbField('t_trip_info', 't_trip_info', 'x_reports_to', 'reports_to', '`reports_to`', '`reports_to`', 18, -1, FALSE, '`reports_to`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->reports_to->Sortable = TRUE; // Allow sort
		$this->reports_to->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->reports_to->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->reports_to->Lookup = new Lookup('reports_to', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->reports_to->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['reports_to'] = &$this->reports_to;

		// buyer
		$this->buyer = new DbField('t_trip_info', 't_trip_info', 'x_buyer', 'buyer', '`buyer`', '`buyer`', 18, -1, FALSE, '`buyer`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->buyer->Nullable = FALSE; // NOT NULL field
		$this->buyer->Required = TRUE; // Required field
		$this->buyer->Sortable = TRUE; // Allow sort
		$this->buyer->Lookup = new Lookup('buyer', 'buyer', FALSE, 'id', ["name","","",""], [], [], [], [], ["id","id"], ["x_b_consignor","x_b_consignee"], '`name` ASC', '');
		$this->buyer->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['buyer'] = &$this->buyer;

		// b_consignor
		$this->b_consignor = new DbField('t_trip_info', 't_trip_info', 'x_b_consignor', 'b_consignor', '`b_consignor`', '`b_consignor`', 2, -1, FALSE, '`b_consignor`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_consignor->Required = TRUE; // Required field
		$this->b_consignor->Sortable = TRUE; // Allow sort
		$this->b_consignor->Lookup = new Lookup('b_consignor', 'buyer', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['b_consignor'] = &$this->b_consignor;

		// b_consignee
		$this->b_consignee = new DbField('t_trip_info', 't_trip_info', 'x_b_consignee', 'b_consignee', '`b_consignee`', '`b_consignee`', 2, -1, FALSE, '`b_consignee`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->b_consignee->Required = TRUE; // Required field
		$this->b_consignee->Sortable = TRUE; // Allow sort
		$this->b_consignee->Lookup = new Lookup('b_consignee', 'buyer', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['b_consignee'] = &$this->b_consignee;

		// load_date
		$this->load_date = new DbField('t_trip_info', 't_trip_info', 'x_load_date', 'load_date', '`load_date`', CastDateFieldForLike('`load_date`', 1, "DB"), 135, 1, FALSE, '`load_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->load_date->Nullable = FALSE; // NOT NULL field
		$this->load_date->Required = TRUE; // Required field
		$this->load_date->Sortable = TRUE; // Allow sort
		$this->load_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['load_date'] = &$this->load_date;

		// load_weight
		$this->load_weight = new DbField('t_trip_info', 't_trip_info', 'x_load_weight', 'load_weight', '`load_weight`', '`load_weight`', 18, -1, FALSE, '`load_weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->load_weight->Sortable = TRUE; // Allow sort
		$this->load_weight->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['load_weight'] = &$this->load_weight;

		// unload_date
		$this->unload_date = new DbField('t_trip_info', 't_trip_info', 'x_unload_date', 'unload_date', '`unload_date`', CastDateFieldForLike('`unload_date`', 0, "DB"), 135, 0, FALSE, '`unload_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unload_date->Sortable = TRUE; // Allow sort
		$this->unload_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['unload_date'] = &$this->unload_date;

		// unload_weight
		$this->unload_weight = new DbField('t_trip_info', 't_trip_info', 'x_unload_weight', 'unload_weight', '`unload_weight`', '`unload_weight`', 18, -1, FALSE, '`unload_weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unload_weight->Sortable = TRUE; // Allow sort
		$this->unload_weight->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unload_weight'] = &$this->unload_weight;

		// invoice_no
		$this->invoice_no = new DbField('t_trip_info', 't_trip_info', 'x_invoice_no', 'invoice_no', '`invoice_no`', '`invoice_no`', 18, -1, FALSE, '`invoice_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice_no->Nullable = FALSE; // NOT NULL field
		$this->invoice_no->Sortable = TRUE; // Allow sort
		$this->invoice_no->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['invoice_no'] = &$this->invoice_no;

		// invoice_date
		$this->invoice_date = new DbField('t_trip_info', 't_trip_info', 'x_invoice_date', 'invoice_date', '`invoice_date`', CastDateFieldForLike('`invoice_date`', 0, "DB"), 133, 0, FALSE, '`invoice_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->invoice_date->Sortable = TRUE; // Allow sort
		$this->invoice_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['invoice_date'] = &$this->invoice_date;

		// amount
		$this->amount = new DbField('t_trip_info', 't_trip_info', 'x_amount', 'amount', '`amount`', '`amount`', 131, -1, FALSE, '`amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->amount->Sortable = TRUE; // Allow sort
		$this->amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['amount'] = &$this->amount;

		// delivery_pod
		$this->delivery_pod = new DbField('t_trip_info', 't_trip_info', 'x_delivery_pod', 'delivery_pod', '`delivery_pod`', '`delivery_pod`', 200, -1, FALSE, '`delivery_pod`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->delivery_pod->Sortable = TRUE; // Allow sort
		$this->delivery_pod->Lookup = new Lookup('delivery_pod', 't_trip_info', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->delivery_pod->OptionCount = 3;
		$this->fields['delivery_pod'] = &$this->delivery_pod;

		// status
		$this->status = new DbField('t_trip_info', 't_trip_info', 'x_status', 'status', '`status`', '`status`', 17, -1, FALSE, '`status`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->status->Nullable = FALSE; // NOT NULL field
		$this->status->Required = TRUE; // Required field
		$this->status->Sortable = TRUE; // Allow sort
		$this->status->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->status->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->status->Lookup = new Lookup('status', 't_trip_info', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->status->OptionCount = 4;
		$this->status->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['status'] = &$this->status;

		// days
		$this->days = new DbField('t_trip_info', 't_trip_info', 'x_days', 'days', '`days`', '`days`', 16, -1, FALSE, '`days`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->days->Nullable = FALSE; // NOT NULL field
		$this->days->Required = TRUE; // Required field
		$this->days->Sortable = TRUE; // Allow sort
		$this->days->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['days'] = &$this->days;

		// driver
		$this->driver = new DbField('t_trip_info', 't_trip_info', 'x_driver', 'driver', '`driver`', '`driver`', 2, -1, FALSE, '`driver`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->driver->Sortable = TRUE; // Allow sort
		$this->driver->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->driver->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->driver->Lookup = new Lookup('driver', 't_driver_info', FALSE, 'id', ["name","id","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->fields['driver'] = &$this->driver;

		// driver_name
		$this->driver_name = new DbField('t_trip_info', 't_trip_info', 'x_driver_name', 'driver_name', '`driver_name`', '`driver_name`', 200, -1, FALSE, '`driver_name`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->driver_name->Sortable = TRUE; // Allow sort
		$this->fields['driver_name'] = &$this->driver_name;

		// agent
		$this->agent = new DbField('t_trip_info', 't_trip_info', 'x_agent', 'agent', '`agent`', '`agent`', 18, -1, FALSE, '`EV__agent`', TRUE, TRUE, TRUE, 'FORMATTED TEXT', 'TEXT');
		$this->agent->Sortable = TRUE; // Allow sort
		$this->agent->Lookup = new Lookup('agent', 'buyer', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->agent->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['agent'] = &$this->agent;

		// comm
		$this->comm = new DbField('t_trip_info', 't_trip_info', 'x_comm', 'comm', '`comm`', '`comm`', 131, -1, FALSE, '`comm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->comm->Nullable = FALSE; // NOT NULL field
		$this->comm->Sortable = TRUE; // Allow sort
		$this->comm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['comm'] = &$this->comm;

		// material
		$this->material = new DbField('t_trip_info', 't_trip_info', 'x_material', 'material', '`material`', '`material`', 200, -1, FALSE, '`material`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->material->Nullable = FALSE; // NOT NULL field
		$this->material->Required = TRUE; // Required field
		$this->material->Sortable = TRUE; // Allow sort
		$this->fields['material'] = &$this->material;

		// packing_type
		$this->packing_type = new DbField('t_trip_info', 't_trip_info', 'x_packing_type', 'packing_type', '`packing_type`', '`packing_type`', 200, -1, FALSE, '`packing_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->packing_type->Nullable = FALSE; // NOT NULL field
		$this->packing_type->Required = TRUE; // Required field
		$this->packing_type->Sortable = TRUE; // Allow sort
		$this->fields['packing_type'] = &$this->packing_type;

		// m_hsn
		$this->m_hsn = new DbField('t_trip_info', 't_trip_info', 'x_m_hsn', 'm_hsn', '`m_hsn`', '`m_hsn`', 200, -1, FALSE, '`m_hsn`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->m_hsn->Sortable = TRUE; // Allow sort
		$this->fields['m_hsn'] = &$this->m_hsn;

		// @
		$this->_40 = new DbField('t_trip_info', 't_trip_info', 'x__40', '@', '`@`', '`@`', 131, -1, FALSE, '`@`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->_40->Nullable = FALSE; // NOT NULL field
		$this->_40->Required = TRUE; // Required field
		$this->_40->Sortable = TRUE; // Allow sort
		$this->_40->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['@'] = &$this->_40;

		// lr_no
		$this->lr_no = new DbField('t_trip_info', 't_trip_info', 'x_lr_no', 'lr_no', '`lr_no`', '`lr_no`', 200, -1, FALSE, '`lr_no`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->lr_no->Sortable = TRUE; // Allow sort
		$this->fields['lr_no'] = &$this->lr_no;

		// km
		$this->km = new DbField('t_trip_info', 't_trip_info', 'x_km', 'km', '`km`', '`km`', 131, -1, FALSE, '`km`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->km->Required = TRUE; // Required field
		$this->km->Sortable = TRUE; // Allow sort
		$this->km->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['km'] = &$this->km;

		// freight_type
		$this->freight_type = new DbField('t_trip_info', 't_trip_info', 'x_freight_type', 'freight_type', '`freight_type`', '`freight_type`', 18, -1, FALSE, '`freight_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->freight_type->Nullable = FALSE; // NOT NULL field
		$this->freight_type->Sortable = TRUE; // Allow sort
		$this->freight_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->freight_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->freight_type->Lookup = new Lookup('freight_type', 't_trip_info', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->freight_type->OptionCount = 2;
		$this->freight_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['freight_type'] = &$this->freight_type;

		// freight
		$this->freight = new DbField('t_trip_info', 't_trip_info', 'x_freight', 'freight', '`freight`', '`freight`', 131, -1, FALSE, '`freight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->freight->Nullable = FALSE; // NOT NULL field
		$this->freight->Required = TRUE; // Required field
		$this->freight->Sortable = TRUE; // Allow sort
		$this->freight->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['freight'] = &$this->freight;

		// ded_det
		$this->ded_det = new DbField('t_trip_info', 't_trip_info', 'x_ded_det', 'ded_det', '`ded_det`', '`ded_det`', 131, -1, FALSE, '`ded_det`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ded_det->Nullable = FALSE; // NOT NULL field
		$this->ded_det->Sortable = TRUE; // Allow sort
		$this->ded_det->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['ded_det'] = &$this->ded_det;

		// ded_det_remarks
		$this->ded_det_remarks = new DbField('t_trip_info', 't_trip_info', 'x_ded_det_remarks', 'ded_det_remarks', '`ded_det_remarks`', '`ded_det_remarks`', 200, -1, FALSE, '`ded_det_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ded_det_remarks->Sortable = TRUE; // Allow sort
		$this->fields['ded_det_remarks'] = &$this->ded_det_remarks;

		// gst_percent
		$this->gst_percent = new DbField('t_trip_info', 't_trip_info', 'x_gst_percent', 'gst_percent', '`gst_percent`', '`gst_percent`', 131, -1, FALSE, '`gst_percent`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gst_percent->Nullable = FALSE; // NOT NULL field
		$this->gst_percent->Sortable = TRUE; // Allow sort
		$this->gst_percent->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['gst_percent'] = &$this->gst_percent;

		// gst_amount
		$this->gst_amount = new DbField('t_trip_info', 't_trip_info', 'x_gst_amount', 'gst_amount', '`gst_amount`', '`gst_amount`', 131, -1, FALSE, '`gst_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->gst_amount->Sortable = TRUE; // Allow sort
		$this->gst_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['gst_amount'] = &$this->gst_amount;

		// final_amount
		$this->final_amount = new DbField('t_trip_info', 't_trip_info', 'x_final_amount', 'final_amount', '`final_amount`', '`final_amount`', 131, -1, FALSE, '`final_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->final_amount->Sortable = TRUE; // Allow sort
		$this->final_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['final_amount'] = &$this->final_amount;

		// load_km
		$this->load_km = new DbField('t_trip_info', 't_trip_info', 'x_load_km', 'load_km', '`load_km`', '`load_km`', 3, -1, FALSE, '`load_km`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->load_km->Nullable = FALSE; // NOT NULL field
		$this->load_km->Required = TRUE; // Required field
		$this->load_km->Sortable = TRUE; // Allow sort
		$this->load_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['load_km'] = &$this->load_km;

		// unload_km
		$this->unload_km = new DbField('t_trip_info', 't_trip_info', 'x_unload_km', 'unload_km', '`unload_km`', '`unload_km`', 19, -1, FALSE, '`unload_km`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unload_km->Nullable = FALSE; // NOT NULL field
		$this->unload_km->Sortable = TRUE; // Allow sort
		$this->unload_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unload_km'] = &$this->unload_km;

		// delivery_receipt
		$this->delivery_receipt = new DbField('t_trip_info', 't_trip_info', 'x_delivery_receipt', 'delivery_receipt', '`delivery_receipt`', '`delivery_receipt`', 200, -1, TRUE, '`delivery_receipt`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->delivery_receipt->Sortable = TRUE; // Allow sort
		$this->delivery_receipt->UploadMultiple = TRUE;
		$this->delivery_receipt->Upload->UploadMultiple = TRUE;
		$this->delivery_receipt->UploadMaxFileCount = 0;
		$this->fields['delivery_receipt'] = &$this->delivery_receipt;

		// delivery_docket
		$this->delivery_docket = new DbField('t_trip_info', 't_trip_info', 'x_delivery_docket', 'delivery_docket', '`delivery_docket`', '`delivery_docket`', 200, -1, FALSE, '`delivery_docket`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->delivery_docket->Sortable = TRUE; // Allow sort
		$this->fields['delivery_docket'] = &$this->delivery_docket;

		// diesal_op_b
		$this->diesal_op_b = new DbField('t_trip_info', 't_trip_info', 'x_diesal_op_b', 'diesal_op_b', '`diesal_op_b`', '`diesal_op_b`', 131, -1, FALSE, '`diesal_op_b`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diesal_op_b->Nullable = FALSE; // NOT NULL field
		$this->diesal_op_b->Required = TRUE; // Required field
		$this->diesal_op_b->Sortable = TRUE; // Allow sort
		$this->diesal_op_b->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['diesal_op_b'] = &$this->diesal_op_b;

		// diesal_required
		$this->diesal_required = new DbField('t_trip_info', 't_trip_info', 'x_diesal_required', 'diesal_required', '`diesal_required`', '`diesal_required`', 131, -1, FALSE, '`diesal_required`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diesal_required->Required = TRUE; // Required field
		$this->diesal_required->Sortable = TRUE; // Allow sort
		$this->diesal_required->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['diesal_required'] = &$this->diesal_required;

		// diesal_fill
		$this->diesal_fill = new DbField('t_trip_info', 't_trip_info', 'x_diesal_fill', 'diesal_fill', '`diesal_fill`', '`diesal_fill`', 131, -1, FALSE, '`diesal_fill`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diesal_fill->Nullable = FALSE; // NOT NULL field
		$this->diesal_fill->Required = TRUE; // Required field
		$this->diesal_fill->Sortable = TRUE; // Allow sort
		$this->diesal_fill->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['diesal_fill'] = &$this->diesal_fill;

		// diesal_amount
		$this->diesal_amount = new DbField('t_trip_info', 't_trip_info', 'x_diesal_amount', 'diesal_amount', '`diesal_amount`', '`diesal_amount`', 131, -1, FALSE, '`diesal_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diesal_amount->Nullable = FALSE; // NOT NULL field
		$this->diesal_amount->Sortable = TRUE; // Allow sort
		$this->diesal_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['diesal_amount'] = &$this->diesal_amount;

		// diesal_cl_balance
		$this->diesal_cl_balance = new DbField('t_trip_info', 't_trip_info', 'x_diesal_cl_balance', 'diesal_cl_balance', '`diesal_cl_balance`', '`diesal_cl_balance`', 131, -1, FALSE, '`diesal_cl_balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->diesal_cl_balance->Nullable = FALSE; // NOT NULL field
		$this->diesal_cl_balance->Sortable = TRUE; // Allow sort
		$this->diesal_cl_balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['diesal_cl_balance'] = &$this->diesal_cl_balance;

		// vehicle_average
		$this->vehicle_average = new DbField('t_trip_info', 't_trip_info', 'x_vehicle_average', 'vehicle_average', '`vehicle_average`', '`vehicle_average`', 131, -1, FALSE, '`vehicle_average`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->vehicle_average->Nullable = FALSE; // NOT NULL field
		$this->vehicle_average->Required = TRUE; // Required field
		$this->vehicle_average->Sortable = TRUE; // Allow sort
		$this->vehicle_average->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['vehicle_average'] = &$this->vehicle_average;

		// cash_required
		$this->cash_required = new DbField('t_trip_info', 't_trip_info', 'x_cash_required', 'cash_required', '`cash_required`', '`cash_required`', 131, -1, FALSE, '`cash_required`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cash_required->Required = TRUE; // Required field
		$this->cash_required->Sortable = TRUE; // Allow sort
		$this->cash_required->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cash_required'] = &$this->cash_required;

		// cash_op_b
		$this->cash_op_b = new DbField('t_trip_info', 't_trip_info', 'x_cash_op_b', 'cash_op_b', '`cash_op_b`', '`cash_op_b`', 131, -1, FALSE, '`cash_op_b`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cash_op_b->Nullable = FALSE; // NOT NULL field
		$this->cash_op_b->Required = TRUE; // Required field
		$this->cash_op_b->Sortable = TRUE; // Allow sort
		$this->cash_op_b->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cash_op_b'] = &$this->cash_op_b;

		// cash_paid
		$this->cash_paid = new DbField('t_trip_info', 't_trip_info', 'x_cash_paid', 'cash_paid', '`cash_paid`', '`cash_paid`', 131, -1, FALSE, '`cash_paid`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cash_paid->Nullable = FALSE; // NOT NULL field
		$this->cash_paid->Required = TRUE; // Required field
		$this->cash_paid->Sortable = TRUE; // Allow sort
		$this->cash_paid->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cash_paid'] = &$this->cash_paid;

		// cash_expenses
		$this->cash_expenses = new DbField('t_trip_info', 't_trip_info', 'x_cash_expenses', 'cash_expenses', '`cash_expenses`', '`cash_expenses`', 131, -1, FALSE, '`cash_expenses`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cash_expenses->Nullable = FALSE; // NOT NULL field
		$this->cash_expenses->Sortable = TRUE; // Allow sort
		$this->cash_expenses->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cash_expenses'] = &$this->cash_expenses;

		// cash_cl_balance
		$this->cash_cl_balance = new DbField('t_trip_info', 't_trip_info', 'x_cash_cl_balance', 'cash_cl_balance', '`cash_cl_balance`', '`cash_cl_balance`', 131, -1, FALSE, '`cash_cl_balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->cash_cl_balance->Nullable = FALSE; // NOT NULL field
		$this->cash_cl_balance->Sortable = TRUE; // Allow sort
		$this->cash_cl_balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['cash_cl_balance'] = &$this->cash_cl_balance;

		// fasttag_op_b
		$this->fasttag_op_b = new DbField('t_trip_info', 't_trip_info', 'x_fasttag_op_b', 'fasttag_op_b', '`fasttag_op_b`', '`fasttag_op_b`', 131, -1, FALSE, '`fasttag_op_b`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fasttag_op_b->Sortable = TRUE; // Allow sort
		$this->fasttag_op_b->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['fasttag_op_b'] = &$this->fasttag_op_b;

		// fasttag_recharge
		$this->fasttag_recharge = new DbField('t_trip_info', 't_trip_info', 'x_fasttag_recharge', 'fasttag_recharge', '`fasttag_recharge`', '`fasttag_recharge`', 131, -1, FALSE, '`fasttag_recharge`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fasttag_recharge->Sortable = TRUE; // Allow sort
		$this->fasttag_recharge->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['fasttag_recharge'] = &$this->fasttag_recharge;

		// fasttag_expenses
		$this->fasttag_expenses = new DbField('t_trip_info', 't_trip_info', 'x_fasttag_expenses', 'fasttag_expenses', '`fasttag_expenses`', '`fasttag_expenses`', 131, -1, FALSE, '`fasttag_expenses`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fasttag_expenses->Sortable = TRUE; // Allow sort
		$this->fasttag_expenses->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['fasttag_expenses'] = &$this->fasttag_expenses;

		// toll_expenses_cash
		$this->toll_expenses_cash = new DbField('t_trip_info', 't_trip_info', 'x_toll_expenses_cash', 'toll_expenses_cash', '`toll_expenses_cash`', '`toll_expenses_cash`', 131, -1, FALSE, '`toll_expenses_cash`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->toll_expenses_cash->Sortable = TRUE; // Allow sort
		$this->toll_expenses_cash->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['toll_expenses_cash'] = &$this->toll_expenses_cash;

		// fasttag_cl_balance
		$this->fasttag_cl_balance = new DbField('t_trip_info', 't_trip_info', 'x_fasttag_cl_balance', 'fasttag_cl_balance', '`fasttag_cl_balance`', '`fasttag_cl_balance`', 131, -1, FALSE, '`fasttag_cl_balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fasttag_cl_balance->Sortable = TRUE; // Allow sort
		$this->fasttag_cl_balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['fasttag_cl_balance'] = &$this->fasttag_cl_balance;

		// remarks
		$this->remarks = new DbField('t_trip_info', 't_trip_info', 'x_remarks', 'remarks', '`remarks`', '`remarks`', 201, -1, FALSE, '`remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXTAREA');
		$this->remarks->Sortable = FALSE; // Allow sort
		$this->fields['remarks'] = &$this->remarks;

		// uploads
		$this->uploads = new DbField('t_trip_info', 't_trip_info', 'x_uploads', 'uploads', '`uploads`', '`uploads`', 201, -1, TRUE, '`uploads`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->uploads->Sortable = TRUE; // Allow sort
		$this->fields['uploads'] = &$this->uploads;

		// consignor
		$this->consignor = new DbField('t_trip_info', 't_trip_info', 'x_consignor', 'consignor', '`consignor`', '`consignor`', 19, -1, FALSE, '`consignor`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->consignor->Nullable = FALSE; // NOT NULL field
		$this->consignor->Required = TRUE; // Required field
		$this->consignor->Sortable = TRUE; // Allow sort
		$this->consignor->Lookup = new Lookup('consignor', 'production_partner', FALSE, 'id', ["name","","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->consignor->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['consignor'] = &$this->consignor;

		// vehicle_freight_comm
		$this->vehicle_freight_comm = new DbField('t_trip_info', 't_trip_info', 'x_vehicle_freight_comm', 'vehicle_freight_comm', '`vehicle_freight_comm`', '`vehicle_freight_comm`', 131, -1, FALSE, '`vehicle_freight_comm`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->vehicle_freight_comm->Nullable = FALSE; // NOT NULL field
		$this->vehicle_freight_comm->Sortable = TRUE; // Allow sort
		$this->vehicle_freight_comm->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['vehicle_freight_comm'] = &$this->vehicle_freight_comm;

		// vehicle_freight_type
		$this->vehicle_freight_type = new DbField('t_trip_info', 't_trip_info', 'x_vehicle_freight_type', 'vehicle_freight_type', '`vehicle_freight_type`', '`vehicle_freight_type`', 18, -1, FALSE, '`vehicle_freight_type`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->vehicle_freight_type->Nullable = FALSE; // NOT NULL field
		$this->vehicle_freight_type->Sortable = TRUE; // Allow sort
		$this->vehicle_freight_type->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->vehicle_freight_type->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->vehicle_freight_type->Lookup = new Lookup('vehicle_freight_type', 't_trip_info', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->vehicle_freight_type->OptionCount = 2;
		$this->vehicle_freight_type->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['vehicle_freight_type'] = &$this->vehicle_freight_type;

		// vehicle_freight_amount
		$this->vehicle_freight_amount = new DbField('t_trip_info', 't_trip_info', 'x_vehicle_freight_amount', 'vehicle_freight_amount', '`vehicle_freight_amount`', '`vehicle_freight_amount`', 131, -1, FALSE, '`vehicle_freight_amount`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->vehicle_freight_amount->Nullable = FALSE; // NOT NULL field
		$this->vehicle_freight_amount->Sortable = TRUE; // Allow sort
		$this->vehicle_freight_amount->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['vehicle_freight_amount'] = &$this->vehicle_freight_amount;

		// vehicle_freight_final
		$this->vehicle_freight_final = new DbField('t_trip_info', 't_trip_info', 'x_vehicle_freight_final', 'vehicle_freight_final', '`vehicle_freight_final`', '`vehicle_freight_final`', 131, -1, FALSE, '`vehicle_freight_final`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->vehicle_freight_final->Nullable = FALSE; // NOT NULL field
		$this->vehicle_freight_final->Sortable = TRUE; // Allow sort
		$this->vehicle_freight_final->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['vehicle_freight_final'] = &$this->vehicle_freight_final;

		// operator
		$this->operator = new DbField('t_trip_info', 't_trip_info', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('t_trip_info', 't_trip_info', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;

		// expenses_id
		$this->expenses_id = new DbField('t_trip_info', 't_trip_info', 'x_expenses_id', 'expenses_id', '`expenses_id`', '`expenses_id`', 17, -1, FALSE, '`expenses_id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->expenses_id->Nullable = FALSE; // NOT NULL field
		$this->expenses_id->Sortable = FALSE; // Allow sort
		$this->expenses_id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['expenses_id'] = &$this->expenses_id;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
			$sortFieldList = ($fld->VirtualExpression <> "") ? $fld->VirtualExpression : $sortField;
			if ($ctrl) {
				$orderByList = $this->getSessionOrderByList();
				if (ContainsString($orderByList, $sortFieldList . " " . $lastSort)) {
					$orderByList = str_replace($sortFieldList . " " . $lastSort, $sortFieldList . " " . $thisSort, $orderByList);
				} else {
					if ($orderByList <> "") $orderByList .= ", ";
					$orderByList .= $sortFieldList . " " . $thisSort;
				}
				$this->setSessionOrderByList($orderByList); // Save to Session
			} else {
				$this->setSessionOrderByList($sortFieldList . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Session ORDER BY for List page
	public function getSessionOrderByList()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST];
	}
	public function setSessionOrderByList($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_ORDER_BY_LIST] = $v;
	}

	// Current detail table name
	public function getCurrentDetailTable()
	{
		return @$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE];
	}
	public function setCurrentDetailTable($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_DETAIL_TABLE] = $v;
	}

	// Get detail url
	public function getDetailUrl()
	{

		// Detail url
		$detailUrl = "";
		if ($this->getCurrentDetailTable() == "t_expenses_o") {
			$detailUrl = $GLOBALS["t_expenses_o"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_id=" . urlencode($this->id->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "t_receipt_d") {
			$detailUrl = $GLOBALS["t_receipt_d"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_id=" . urlencode($this->id->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "t_diesal_expenses") {
			$detailUrl = $GLOBALS["t_diesal_expenses"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk_id=" . urlencode($this->id->CurrentValue);
		}
		if ($this->getCurrentDetailTable() == "t_route_info") {
			$detailUrl = $GLOBALS["t_route_info"]->getListUrl() . "?" . TABLE_SHOW_MASTER . "=" . $this->TableVar;
			$detailUrl .= "&fk__route=" . urlencode($this->_route->CurrentValue);
		}
		if ($detailUrl == "")
			$detailUrl = "t_trip_infolist.php";
		return $detailUrl;
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`t_trip_info`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlSelectList() // Select for List page
	{
		$select = "";
		$select = "SELECT * FROM (" .
			"SELECT *, (SELECT `name` FROM `buyer` `TMP_LOOKUPTABLE` WHERE `TMP_LOOKUPTABLE`.`id` = `t_trip_info`.`agent` LIMIT 1) AS `EV__agent` FROM `t_trip_info`" .
			") `TMP_TABLE`";
		return ($this->SqlSelectList <> "") ? $this->SqlSelectList : $select;
	}
	public function sqlSelectList() // For backward compatibility
	{
		return $this->getSqlSelectList();
	}
	public function setSqlSelectList($v)
	{
		$this->SqlSelectList = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "`id` > 0";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		if ($this->useVirtualFields()) {
			$select = $this->getSqlSelectList();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		} else {
			$select = $this->getSqlSelect();
			$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		}
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = ($this->useVirtualFields()) ? $this->getSessionOrderByList() : $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Check if virtual fields is used in SQL
	protected function useVirtualFields()
	{
		$where = $this->UseSessionForListSql ? $this->getSessionWhere() : $this->CurrentFilter;
		$orderBy = $this->UseSessionForListSql ? $this->getSessionOrderByList() : "";
		if ($where <> "")
			$where = " " . str_replace(array("(",")"), array("",""), $where) . " ";
		if ($orderBy <> "")
			$orderBy = " " . str_replace(array("(",")"), array("",""), $orderBy) . " ";
		if ($this->BasicSearch->getKeyword() <> "")
			return TRUE;
		if ($this->agent->AdvancedSearch->SearchValue <> "" ||
			$this->agent->AdvancedSearch->SearchValue2 <> "" ||
			ContainsString($where, " " . $this->agent->VirtualExpression . " "))
			return TRUE;
		if (ContainsString($orderBy, " " . $this->agent->VirtualExpression . " "))
			return TRUE;
		return FALSE;
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		if ($this->useVirtualFields())
			$sql = BuildSelectSql($this->getSqlSelectList(), $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		else
			$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->vehicle_type->DbValue = $row['vehicle_type'];
		$this->vehicle->DbValue = $row['vehicle'];
		$this->_route->DbValue = $row['route'];
		$this->route_name->DbValue = $row['route_name'];
		$this->reports_to->DbValue = $row['reports_to'];
		$this->buyer->DbValue = $row['buyer'];
		$this->b_consignor->DbValue = $row['b_consignor'];
		$this->b_consignee->DbValue = $row['b_consignee'];
		$this->load_date->DbValue = $row['load_date'];
		$this->load_weight->DbValue = $row['load_weight'];
		$this->unload_date->DbValue = $row['unload_date'];
		$this->unload_weight->DbValue = $row['unload_weight'];
		$this->invoice_no->DbValue = $row['invoice_no'];
		$this->invoice_date->DbValue = $row['invoice_date'];
		$this->amount->DbValue = $row['amount'];
		$this->delivery_pod->DbValue = $row['delivery_pod'];
		$this->status->DbValue = $row['status'];
		$this->days->DbValue = $row['days'];
		$this->driver->DbValue = $row['driver'];
		$this->driver_name->DbValue = $row['driver_name'];
		$this->agent->DbValue = $row['agent'];
		$this->comm->DbValue = $row['comm'];
		$this->material->DbValue = $row['material'];
		$this->packing_type->DbValue = $row['packing_type'];
		$this->m_hsn->DbValue = $row['m_hsn'];
		$this->_40->DbValue = $row['@'];
		$this->lr_no->DbValue = $row['lr_no'];
		$this->km->DbValue = $row['km'];
		$this->freight_type->DbValue = $row['freight_type'];
		$this->freight->DbValue = $row['freight'];
		$this->ded_det->DbValue = $row['ded_det'];
		$this->ded_det_remarks->DbValue = $row['ded_det_remarks'];
		$this->gst_percent->DbValue = $row['gst_percent'];
		$this->gst_amount->DbValue = $row['gst_amount'];
		$this->final_amount->DbValue = $row['final_amount'];
		$this->load_km->DbValue = $row['load_km'];
		$this->unload_km->DbValue = $row['unload_km'];
		$this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
		$this->delivery_docket->DbValue = $row['delivery_docket'];
		$this->diesal_op_b->DbValue = $row['diesal_op_b'];
		$this->diesal_required->DbValue = $row['diesal_required'];
		$this->diesal_fill->DbValue = $row['diesal_fill'];
		$this->diesal_amount->DbValue = $row['diesal_amount'];
		$this->diesal_cl_balance->DbValue = $row['diesal_cl_balance'];
		$this->vehicle_average->DbValue = $row['vehicle_average'];
		$this->cash_required->DbValue = $row['cash_required'];
		$this->cash_op_b->DbValue = $row['cash_op_b'];
		$this->cash_paid->DbValue = $row['cash_paid'];
		$this->cash_expenses->DbValue = $row['cash_expenses'];
		$this->cash_cl_balance->DbValue = $row['cash_cl_balance'];
		$this->fasttag_op_b->DbValue = $row['fasttag_op_b'];
		$this->fasttag_recharge->DbValue = $row['fasttag_recharge'];
		$this->fasttag_expenses->DbValue = $row['fasttag_expenses'];
		$this->toll_expenses_cash->DbValue = $row['toll_expenses_cash'];
		$this->fasttag_cl_balance->DbValue = $row['fasttag_cl_balance'];
		$this->remarks->DbValue = $row['remarks'];
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->consignor->DbValue = $row['consignor'];
		$this->vehicle_freight_comm->DbValue = $row['vehicle_freight_comm'];
		$this->vehicle_freight_type->DbValue = $row['vehicle_freight_type'];
		$this->vehicle_freight_amount->DbValue = $row['vehicle_freight_amount'];
		$this->vehicle_freight_final->DbValue = $row['vehicle_freight_final'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
		$this->expenses_id->DbValue = $row['expenses_id'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->delivery_receipt->OldUploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		$oldFiles = EmptyValue($row['delivery_receipt']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['delivery_receipt']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->delivery_receipt->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->delivery_receipt->oldPhysicalUploadPath() . $oldFile);
		}
		$this->uploads->OldUploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		$oldFiles = EmptyValue($row['uploads']) ? [] : [$row['uploads']];
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->uploads->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "t_trip_infolist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "t_trip_infoview.php")
			return $Language->phrase("View");
		elseif ($pageName == "t_trip_infoedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "t_trip_infoadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "t_trip_infolist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("t_trip_infoview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("t_trip_infoview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "t_trip_infoadd.php?" . $this->getUrlParm($parm);
		else
			$url = "t_trip_infoadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("t_trip_infoedit.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("t_trip_infoedit.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("t_trip_infoadd.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("t_trip_infoadd.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("t_trip_infodelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->vehicle_type->setDbValue($rs->fields('vehicle_type'));
		$this->vehicle->setDbValue($rs->fields('vehicle'));
		$this->_route->setDbValue($rs->fields('route'));
		$this->route_name->setDbValue($rs->fields('route_name'));
		$this->reports_to->setDbValue($rs->fields('reports_to'));
		$this->buyer->setDbValue($rs->fields('buyer'));
		$this->b_consignor->setDbValue($rs->fields('b_consignor'));
		$this->b_consignee->setDbValue($rs->fields('b_consignee'));
		$this->load_date->setDbValue($rs->fields('load_date'));
		$this->load_weight->setDbValue($rs->fields('load_weight'));
		$this->unload_date->setDbValue($rs->fields('unload_date'));
		$this->unload_weight->setDbValue($rs->fields('unload_weight'));
		$this->invoice_no->setDbValue($rs->fields('invoice_no'));
		$this->invoice_date->setDbValue($rs->fields('invoice_date'));
		$this->amount->setDbValue($rs->fields('amount'));
		$this->delivery_pod->setDbValue($rs->fields('delivery_pod'));
		$this->status->setDbValue($rs->fields('status'));
		$this->days->setDbValue($rs->fields('days'));
		$this->driver->setDbValue($rs->fields('driver'));
		$this->driver_name->setDbValue($rs->fields('driver_name'));
		$this->agent->setDbValue($rs->fields('agent'));
		$this->comm->setDbValue($rs->fields('comm'));
		$this->material->setDbValue($rs->fields('material'));
		$this->packing_type->setDbValue($rs->fields('packing_type'));
		$this->m_hsn->setDbValue($rs->fields('m_hsn'));
		$this->_40->setDbValue($rs->fields('@'));
		$this->lr_no->setDbValue($rs->fields('lr_no'));
		$this->km->setDbValue($rs->fields('km'));
		$this->freight_type->setDbValue($rs->fields('freight_type'));
		$this->freight->setDbValue($rs->fields('freight'));
		$this->ded_det->setDbValue($rs->fields('ded_det'));
		$this->ded_det_remarks->setDbValue($rs->fields('ded_det_remarks'));
		$this->gst_percent->setDbValue($rs->fields('gst_percent'));
		$this->gst_amount->setDbValue($rs->fields('gst_amount'));
		$this->final_amount->setDbValue($rs->fields('final_amount'));
		$this->load_km->setDbValue($rs->fields('load_km'));
		$this->unload_km->setDbValue($rs->fields('unload_km'));
		$this->delivery_receipt->Upload->DbValue = $rs->fields('delivery_receipt');
		$this->delivery_docket->setDbValue($rs->fields('delivery_docket'));
		$this->diesal_op_b->setDbValue($rs->fields('diesal_op_b'));
		$this->diesal_required->setDbValue($rs->fields('diesal_required'));
		$this->diesal_fill->setDbValue($rs->fields('diesal_fill'));
		$this->diesal_amount->setDbValue($rs->fields('diesal_amount'));
		$this->diesal_cl_balance->setDbValue($rs->fields('diesal_cl_balance'));
		$this->vehicle_average->setDbValue($rs->fields('vehicle_average'));
		$this->cash_required->setDbValue($rs->fields('cash_required'));
		$this->cash_op_b->setDbValue($rs->fields('cash_op_b'));
		$this->cash_paid->setDbValue($rs->fields('cash_paid'));
		$this->cash_expenses->setDbValue($rs->fields('cash_expenses'));
		$this->cash_cl_balance->setDbValue($rs->fields('cash_cl_balance'));
		$this->fasttag_op_b->setDbValue($rs->fields('fasttag_op_b'));
		$this->fasttag_recharge->setDbValue($rs->fields('fasttag_recharge'));
		$this->fasttag_expenses->setDbValue($rs->fields('fasttag_expenses'));
		$this->toll_expenses_cash->setDbValue($rs->fields('toll_expenses_cash'));
		$this->fasttag_cl_balance->setDbValue($rs->fields('fasttag_cl_balance'));
		$this->remarks->setDbValue($rs->fields('remarks'));
		$this->uploads->Upload->DbValue = $rs->fields('uploads');
		$this->consignor->setDbValue($rs->fields('consignor'));
		$this->vehicle_freight_comm->setDbValue($rs->fields('vehicle_freight_comm'));
		$this->vehicle_freight_type->setDbValue($rs->fields('vehicle_freight_type'));
		$this->vehicle_freight_amount->setDbValue($rs->fields('vehicle_freight_amount'));
		$this->vehicle_freight_final->setDbValue($rs->fields('vehicle_freight_final'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
		$this->expenses_id->setDbValue($rs->fields('expenses_id'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// vehicle_type
		// vehicle
		// route
		// route_name
		// reports_to
		// buyer
		// b_consignor
		// b_consignee
		// load_date
		// load_weight
		// unload_date
		// unload_weight
		// invoice_no
		// invoice_date
		// amount
		// delivery_pod
		// status
		// days
		// driver
		// driver_name
		// agent
		// comm
		// material
		// packing_type
		// m_hsn
		// @
		// lr_no
		// km
		// freight_type
		// freight
		// ded_det
		// ded_det_remarks
		// gst_percent
		// gst_amount
		// final_amount
		// load_km
		// unload_km
		// delivery_receipt
		// delivery_docket
		// diesal_op_b
		// diesal_required
		// diesal_fill
		// diesal_amount
		// diesal_cl_balance
		// vehicle_average
		// cash_required
		// cash_op_b
		// cash_paid
		// cash_expenses
		// cash_cl_balance
		// fasttag_op_b
		// fasttag_recharge
		// fasttag_expenses
		// toll_expenses_cash
		// fasttag_cl_balance
		// remarks
		// uploads
		// consignor
		// vehicle_freight_comm
		// vehicle_freight_type
		// vehicle_freight_amount
		// vehicle_freight_final
		// operator
		// datetime
		// expenses_id

		$this->expenses_id->CellCssStyle = "white-space: nowrap;";

		// id
		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// vehicle_type
		if (strval($this->vehicle_type->CurrentValue) <> "") {
			$this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
		} else {
			$this->vehicle_type->ViewValue = NULL;
		}
		$this->vehicle_type->ViewCustomAttributes = "";

		// vehicle
		$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
		$curVal = strval($this->vehicle->CurrentValue);
		if ($curVal <> "") {
			$this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
			if ($this->vehicle->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
				}
			}
		} else {
			$this->vehicle->ViewValue = NULL;
		}
		$this->vehicle->ViewCustomAttributes = "";

		// route
		$this->_route->ViewValue = $this->_route->CurrentValue;
		$curVal = strval($this->_route->CurrentValue);
		if ($curVal <> "") {
			$this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
			if ($this->_route->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->_route->ViewValue = $this->_route->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->_route->ViewValue = $this->_route->CurrentValue;
				}
			}
		} else {
			$this->_route->ViewValue = NULL;
		}
		$this->_route->ViewCustomAttributes = "";

		// route_name
		$this->route_name->ViewValue = $this->route_name->CurrentValue;
		$this->route_name->ViewCustomAttributes = "";

		// reports_to
		$curVal = strval($this->reports_to->CurrentValue);
		if ($curVal <> "") {
			$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			if ($this->reports_to->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`activated`=1 and `userlevel`=1003";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
				}
			}
		} else {
			$this->reports_to->ViewValue = NULL;
		}
		$this->reports_to->ViewCustomAttributes = "";

		// buyer
		$this->buyer->ViewValue = $this->buyer->CurrentValue;
		$curVal = strval($this->buyer->CurrentValue);
		if ($curVal <> "") {
			$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
			if ($this->buyer->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category` = 902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->buyer->ViewValue = $this->buyer->CurrentValue;
				}
			}
		} else {
			$this->buyer->ViewValue = NULL;
		}
		$this->buyer->ViewCustomAttributes = "";

		// b_consignor
		$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
		$curVal = strval($this->b_consignor->CurrentValue);
		if ($curVal <> "") {
			$this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
			if ($this->b_consignor->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category` = 902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
				}
			}
		} else {
			$this->b_consignor->ViewValue = NULL;
		}
		$this->b_consignor->ViewCustomAttributes = "";

		// b_consignee
		$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
		$curVal = strval($this->b_consignee->CurrentValue);
		if ($curVal <> "") {
			$this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
			if ($this->b_consignee->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category` = 902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->b_consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
				}
			}
		} else {
			$this->b_consignee->ViewValue = NULL;
		}
		$this->b_consignee->ViewCustomAttributes = "";

		// load_date
		$this->load_date->ViewValue = $this->load_date->CurrentValue;
		$this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, 1);
		$this->load_date->ViewCustomAttributes = "";

		// load_weight
		$this->load_weight->ViewValue = $this->load_weight->CurrentValue;
		$this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, 0, -2, -2, -2);
		$this->load_weight->ViewCustomAttributes = "";

		// unload_date
		$this->unload_date->ViewValue = $this->unload_date->CurrentValue;
		$this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, 0);
		$this->unload_date->ViewCustomAttributes = "";

		// unload_weight
		$this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
		$this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, 0, -2, -2, -2);
		$this->unload_weight->ViewCustomAttributes = "";

		// invoice_no
		$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
		$this->invoice_no->ViewValue = FormatNumber($this->invoice_no->ViewValue, 0, -2, -2, -2);
		$this->invoice_no->ViewCustomAttributes = "";

		// invoice_date
		$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
		$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
		$this->invoice_date->ViewCustomAttributes = "";

		// amount
		$this->amount->ViewValue = $this->amount->CurrentValue;
		$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// delivery_pod
		if (strval($this->delivery_pod->CurrentValue) <> "") {
			$this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
		} else {
			$this->delivery_pod->ViewValue = NULL;
		}
		$this->delivery_pod->ViewCustomAttributes = "";

		// status
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->ViewValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// days
		$this->days->ViewValue = $this->days->CurrentValue;
		$this->days->ViewValue = FormatNumber($this->days->ViewValue, 0, -2, -2, -2);
		$this->days->ViewCustomAttributes = "";

		// driver
		$curVal = strval($this->driver->CurrentValue);
		if ($curVal <> "") {
			$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
			if ($this->driver->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->driver->ViewValue = $this->driver->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->driver->ViewValue = $this->driver->CurrentValue;
				}
			}
		} else {
			$this->driver->ViewValue = NULL;
		}
		$this->driver->ViewCustomAttributes = "";

		// driver_name
		$this->driver_name->ViewValue = $this->driver_name->CurrentValue;
		$this->driver_name->ViewCustomAttributes = "";

		// agent
		if ($this->agent->VirtualValue <> "") {
			$this->agent->ViewValue = $this->agent->VirtualValue;
		} else {
			$this->agent->ViewValue = $this->agent->CurrentValue;
		$curVal = strval($this->agent->CurrentValue);
		if ($curVal <> "") {
			$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
			if ($this->agent->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category` = 902 and `status` = 1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->agent->ViewValue = $this->agent->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->agent->ViewValue = $this->agent->CurrentValue;
				}
			}
		} else {
			$this->agent->ViewValue = NULL;
		}
		}
		$this->agent->ViewCustomAttributes = "";

		// comm
		$this->comm->ViewValue = $this->comm->CurrentValue;
		$this->comm->ViewValue = FormatNumber($this->comm->ViewValue, 2, -2, -2, -2);
		$this->comm->ViewCustomAttributes = "";

		// material
		$this->material->ViewValue = $this->material->CurrentValue;
		$this->material->ViewCustomAttributes = "";

		// packing_type
		$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
		$this->packing_type->ViewCustomAttributes = "";

		// m_hsn
		$this->m_hsn->ViewValue = $this->m_hsn->CurrentValue;
		$this->m_hsn->ViewCustomAttributes = "";

		// @
		$this->_40->ViewValue = $this->_40->CurrentValue;
		$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 2, -2, -2, -2);
		$this->_40->ViewCustomAttributes = "";

		// lr_no
		$this->lr_no->ViewValue = $this->lr_no->CurrentValue;
		$this->lr_no->ViewCustomAttributes = "";

		// km
		$this->km->ViewValue = $this->km->CurrentValue;
		$this->km->ViewValue = FormatNumber($this->km->ViewValue, 2, -2, -2, -2);
		$this->km->ViewCustomAttributes = "";

		// freight_type
		if (strval($this->freight_type->CurrentValue) <> "") {
			$this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
		} else {
			$this->freight_type->ViewValue = NULL;
		}
		$this->freight_type->ViewCustomAttributes = "";

		// freight
		$this->freight->ViewValue = $this->freight->CurrentValue;
		$this->freight->ViewValue = FormatNumber($this->freight->ViewValue, 2, -2, -2, -2);
		$this->freight->ViewCustomAttributes = "";

		// ded_det
		$this->ded_det->ViewValue = $this->ded_det->CurrentValue;
		$this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, 2, -2, -2, -2);
		$this->ded_det->ViewCustomAttributes = "";

		// ded_det_remarks
		$this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;
		$this->ded_det_remarks->ViewCustomAttributes = "";

		// gst_percent
		$this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
		$this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, 2, -2, -2, -2);
		$this->gst_percent->ViewCustomAttributes = "";

		// gst_amount
		$this->gst_amount->ViewValue = $this->gst_amount->CurrentValue;
		$this->gst_amount->ViewValue = FormatNumber($this->gst_amount->ViewValue, 2, -2, -2, -2);
		$this->gst_amount->ViewCustomAttributes = "";

		// final_amount
		$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
		$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
		$this->final_amount->ViewCustomAttributes = "";

		// load_km
		$this->load_km->ViewValue = $this->load_km->CurrentValue;
		$this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, 0, -2, -2, -2);
		$this->load_km->ViewCustomAttributes = "";

		// unload_km
		$this->unload_km->ViewValue = $this->unload_km->CurrentValue;
		$this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, 0, -2, -2, -2);
		$this->unload_km->ViewCustomAttributes = "";

		// delivery_receipt
		$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
			$this->delivery_receipt->ImageWidth = 0;
			$this->delivery_receipt->ImageHeight = 50;
			$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
			$this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
		} else {
			$this->delivery_receipt->ViewValue = "";
		}
		$this->delivery_receipt->ViewCustomAttributes = "";

		// delivery_docket
		$this->delivery_docket->ViewValue = $this->delivery_docket->CurrentValue;
		$this->delivery_docket->ViewCustomAttributes = "";

		// diesal_op_b
		$this->diesal_op_b->ViewValue = $this->diesal_op_b->CurrentValue;
		$this->diesal_op_b->ViewValue = FormatNumber($this->diesal_op_b->ViewValue, 2, -2, -2, -2);
		$this->diesal_op_b->ViewCustomAttributes = "";

		// diesal_required
		$this->diesal_required->ViewValue = $this->diesal_required->CurrentValue;
		$this->diesal_required->ViewValue = FormatNumber($this->diesal_required->ViewValue, 2, -2, -2, -2);
		$this->diesal_required->ViewCustomAttributes = "";

		// diesal_fill
		$this->diesal_fill->ViewValue = $this->diesal_fill->CurrentValue;
		$this->diesal_fill->ViewValue = FormatNumber($this->diesal_fill->ViewValue, 2, -2, -2, -2);
		$this->diesal_fill->ViewCustomAttributes = "";

		// diesal_amount
		$this->diesal_amount->ViewValue = $this->diesal_amount->CurrentValue;
		$this->diesal_amount->ViewValue = FormatNumber($this->diesal_amount->ViewValue, 2, -2, -2, -2);
		$this->diesal_amount->ViewCustomAttributes = "";

		// diesal_cl_balance
		$this->diesal_cl_balance->ViewValue = $this->diesal_cl_balance->CurrentValue;
		$this->diesal_cl_balance->ViewValue = FormatNumber($this->diesal_cl_balance->ViewValue, 2, -2, -2, -2);
		$this->diesal_cl_balance->ViewCustomAttributes = "";

		// vehicle_average
		$this->vehicle_average->ViewValue = $this->vehicle_average->CurrentValue;
		$this->vehicle_average->ViewValue = FormatNumber($this->vehicle_average->ViewValue, 2, -2, -2, -2);
		$this->vehicle_average->ViewCustomAttributes = "";

		// cash_required
		$this->cash_required->ViewValue = $this->cash_required->CurrentValue;
		$this->cash_required->ViewValue = FormatNumber($this->cash_required->ViewValue, 2, -2, -2, -2);
		$this->cash_required->ViewCustomAttributes = "";

		// cash_op_b
		$this->cash_op_b->ViewValue = $this->cash_op_b->CurrentValue;
		$this->cash_op_b->ViewValue = FormatNumber($this->cash_op_b->ViewValue, 2, -2, -2, -2);
		$this->cash_op_b->ViewCustomAttributes = "";

		// cash_paid
		$this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
		$this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, 2, -2, -2, -2);
		$this->cash_paid->ViewCustomAttributes = "";

		// cash_expenses
		$this->cash_expenses->ViewValue = $this->cash_expenses->CurrentValue;
		$this->cash_expenses->ViewValue = FormatNumber($this->cash_expenses->ViewValue, 2, -2, -2, -2);
		$this->cash_expenses->ViewCustomAttributes = "";

		// cash_cl_balance
		$this->cash_cl_balance->ViewValue = $this->cash_cl_balance->CurrentValue;
		$this->cash_cl_balance->ViewValue = FormatNumber($this->cash_cl_balance->ViewValue, 2, -2, -2, -2);
		$this->cash_cl_balance->ViewCustomAttributes = "";

		// fasttag_op_b
		$this->fasttag_op_b->ViewValue = $this->fasttag_op_b->CurrentValue;
		$this->fasttag_op_b->ViewValue = FormatNumber($this->fasttag_op_b->ViewValue, 2, -2, -2, -2);
		$this->fasttag_op_b->ViewCustomAttributes = "";

		// fasttag_recharge
		$this->fasttag_recharge->ViewValue = $this->fasttag_recharge->CurrentValue;
		$this->fasttag_recharge->ViewValue = FormatNumber($this->fasttag_recharge->ViewValue, 2, -2, -2, -2);
		$this->fasttag_recharge->ViewCustomAttributes = "";

		// fasttag_expenses
		$this->fasttag_expenses->ViewValue = $this->fasttag_expenses->CurrentValue;
		$this->fasttag_expenses->ViewValue = FormatNumber($this->fasttag_expenses->ViewValue, 2, -2, -2, -2);
		$this->fasttag_expenses->ViewCustomAttributes = "";

		// toll_expenses_cash
		$this->toll_expenses_cash->ViewValue = $this->toll_expenses_cash->CurrentValue;
		$this->toll_expenses_cash->ViewValue = FormatNumber($this->toll_expenses_cash->ViewValue, 2, -2, -2, -2);
		$this->toll_expenses_cash->ViewCustomAttributes = "";

		// fasttag_cl_balance
		$this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
		$this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, 2, -2, -2, -2);
		$this->fasttag_cl_balance->ViewCustomAttributes = "";

		// remarks
		$this->remarks->ViewValue = $this->remarks->CurrentValue;
		$this->remarks->ViewCustomAttributes = "";

		// uploads
		$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->ViewValue = "";
		}
		$this->uploads->ViewCustomAttributes = "";

		// consignor
		$this->consignor->ViewValue = $this->consignor->CurrentValue;
		$curVal = strval($this->consignor->CurrentValue);
		if ($curVal <> "") {
			$this->consignor->ViewValue = $this->consignor->lookupCacheOption($curVal);
			if ($this->consignor->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return "`category` = 902";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->consignor->ViewValue = $this->consignor->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->consignor->ViewValue = $this->consignor->CurrentValue;
				}
			}
		} else {
			$this->consignor->ViewValue = NULL;
		}
		$this->consignor->ViewCustomAttributes = "";

		// vehicle_freight_comm
		$this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
		$this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, 2, -2, -2, -2);
		$this->vehicle_freight_comm->ViewCustomAttributes = "";

		// vehicle_freight_type
		if (strval($this->vehicle_freight_type->CurrentValue) <> "") {
			$this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
		} else {
			$this->vehicle_freight_type->ViewValue = NULL;
		}
		$this->vehicle_freight_type->ViewCustomAttributes = "";

		// vehicle_freight_amount
		$this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
		$this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, 2, -2, -2, -2);
		$this->vehicle_freight_amount->ViewCustomAttributes = "";

		// vehicle_freight_final
		$this->vehicle_freight_final->ViewValue = $this->vehicle_freight_final->CurrentValue;
		$this->vehicle_freight_final->ViewValue = FormatNumber($this->vehicle_freight_final->ViewValue, 2, -2, -2, -2);
		$this->vehicle_freight_final->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// expenses_id
		$this->expenses_id->ViewValue = $this->expenses_id->CurrentValue;
		$this->expenses_id->ViewValue = FormatNumber($this->expenses_id->ViewValue, 0, -2, -2, -2);
		$this->expenses_id->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// vehicle_type
		$this->vehicle_type->LinkCustomAttributes = "";
		$this->vehicle_type->HrefValue = "";
		$this->vehicle_type->TooltipValue = "";

		// vehicle
		$this->vehicle->LinkCustomAttributes = "";
		$this->vehicle->HrefValue = "";
		$this->vehicle->TooltipValue = "";

		// route
		$this->_route->LinkCustomAttributes = "";
		$this->_route->HrefValue = "";
		$this->_route->TooltipValue = "";

		// route_name
		$this->route_name->LinkCustomAttributes = "";
		$this->route_name->HrefValue = "";
		$this->route_name->TooltipValue = "";

		// reports_to
		$this->reports_to->LinkCustomAttributes = "";
		$this->reports_to->HrefValue = "";
		$this->reports_to->TooltipValue = "";

		// buyer
		$this->buyer->LinkCustomAttributes = "";
		$this->buyer->HrefValue = "";
		$this->buyer->TooltipValue = "";

		// b_consignor
		$this->b_consignor->LinkCustomAttributes = "";
		$this->b_consignor->HrefValue = "";
		$this->b_consignor->TooltipValue = "";

		// b_consignee
		$this->b_consignee->LinkCustomAttributes = "";
		$this->b_consignee->HrefValue = "";
		$this->b_consignee->TooltipValue = "";

		// load_date
		$this->load_date->LinkCustomAttributes = "";
		$this->load_date->HrefValue = "";
		$this->load_date->TooltipValue = "";

		// load_weight
		$this->load_weight->LinkCustomAttributes = "";
		$this->load_weight->HrefValue = "";
		$this->load_weight->TooltipValue = "";

		// unload_date
		$this->unload_date->LinkCustomAttributes = "";
		$this->unload_date->HrefValue = "";
		$this->unload_date->TooltipValue = "";

		// unload_weight
		$this->unload_weight->LinkCustomAttributes = "";
		$this->unload_weight->HrefValue = "";
		$this->unload_weight->TooltipValue = "";

		// invoice_no
		$this->invoice_no->LinkCustomAttributes = "";
		$this->invoice_no->HrefValue = "";
		$this->invoice_no->TooltipValue = "";

		// invoice_date
		$this->invoice_date->LinkCustomAttributes = "";
		$this->invoice_date->HrefValue = "";
		$this->invoice_date->TooltipValue = "";

		// amount
		$this->amount->LinkCustomAttributes = "";
		$this->amount->HrefValue = "";
		$this->amount->TooltipValue = "";

		// delivery_pod
		$this->delivery_pod->LinkCustomAttributes = "";
		$this->delivery_pod->HrefValue = "";
		$this->delivery_pod->TooltipValue = "";

		// status
		$this->status->LinkCustomAttributes = "";
		$this->status->HrefValue = "";
		$this->status->TooltipValue = "";

		// days
		$this->days->LinkCustomAttributes = "";
		$this->days->HrefValue = "";
		$this->days->TooltipValue = "";

		// driver
		$this->driver->LinkCustomAttributes = "";
		$this->driver->HrefValue = "";
		$this->driver->TooltipValue = "";

		// driver_name
		$this->driver_name->LinkCustomAttributes = "";
		$this->driver_name->HrefValue = "";
		$this->driver_name->TooltipValue = "";

		// agent
		$this->agent->LinkCustomAttributes = "";
		$this->agent->HrefValue = "";
		$this->agent->TooltipValue = "";

		// comm
		$this->comm->LinkCustomAttributes = "";
		$this->comm->HrefValue = "";
		$this->comm->TooltipValue = "";

		// material
		$this->material->LinkCustomAttributes = "";
		$this->material->HrefValue = "";
		$this->material->TooltipValue = "";

		// packing_type
		$this->packing_type->LinkCustomAttributes = "";
		$this->packing_type->HrefValue = "";
		$this->packing_type->TooltipValue = "";

		// m_hsn
		$this->m_hsn->LinkCustomAttributes = "";
		$this->m_hsn->HrefValue = "";
		$this->m_hsn->TooltipValue = "";

		// @
		$this->_40->LinkCustomAttributes = "";
		$this->_40->HrefValue = "";
		$this->_40->TooltipValue = "";

		// lr_no
		$this->lr_no->LinkCustomAttributes = "";
		$this->lr_no->HrefValue = "";
		$this->lr_no->TooltipValue = "";

		// km
		$this->km->LinkCustomAttributes = "";
		$this->km->HrefValue = "";
		$this->km->TooltipValue = "";

		// freight_type
		$this->freight_type->LinkCustomAttributes = "";
		$this->freight_type->HrefValue = "";
		$this->freight_type->TooltipValue = "";

		// freight
		$this->freight->LinkCustomAttributes = "";
		$this->freight->HrefValue = "";
		$this->freight->TooltipValue = "";

		// ded_det
		$this->ded_det->LinkCustomAttributes = "";
		$this->ded_det->HrefValue = "";
		$this->ded_det->TooltipValue = "";

		// ded_det_remarks
		$this->ded_det_remarks->LinkCustomAttributes = "";
		$this->ded_det_remarks->HrefValue = "";
		$this->ded_det_remarks->TooltipValue = "";

		// gst_percent
		$this->gst_percent->LinkCustomAttributes = "";
		$this->gst_percent->HrefValue = "";
		$this->gst_percent->TooltipValue = "";

		// gst_amount
		$this->gst_amount->LinkCustomAttributes = "";
		$this->gst_amount->HrefValue = "";
		$this->gst_amount->TooltipValue = "";

		// final_amount
		$this->final_amount->LinkCustomAttributes = "";
		$this->final_amount->HrefValue = "";
		$this->final_amount->TooltipValue = "";

		// load_km
		$this->load_km->LinkCustomAttributes = "";
		$this->load_km->HrefValue = "";
		$this->load_km->TooltipValue = "";

		// unload_km
		$this->unload_km->LinkCustomAttributes = "";
		$this->unload_km->HrefValue = "";
		$this->unload_km->TooltipValue = "";

		// delivery_receipt
		$this->delivery_receipt->LinkCustomAttributes = "";
		$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
			$this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
			$this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
		} else {
			$this->delivery_receipt->HrefValue = "";
		}
		$this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;
		$this->delivery_receipt->TooltipValue = "";
		if ($this->delivery_receipt->UseColorbox) {
			if (EmptyValue($this->delivery_receipt->TooltipValue))
				$this->delivery_receipt->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->delivery_receipt->LinkAttrs["data-rel"] = "t_trip_info_x_delivery_receipt";
			AppendClass($this->delivery_receipt->LinkAttrs["class"], "ew-lightbox");
		}

		// delivery_docket
		$this->delivery_docket->LinkCustomAttributes = "";
		$this->delivery_docket->HrefValue = "";
		$this->delivery_docket->TooltipValue = "";

		// diesal_op_b
		$this->diesal_op_b->LinkCustomAttributes = "";
		$this->diesal_op_b->HrefValue = "";
		$this->diesal_op_b->TooltipValue = "";

		// diesal_required
		$this->diesal_required->LinkCustomAttributes = "";
		$this->diesal_required->HrefValue = "";
		$this->diesal_required->TooltipValue = "";

		// diesal_fill
		$this->diesal_fill->LinkCustomAttributes = "";
		$this->diesal_fill->HrefValue = "";
		$this->diesal_fill->TooltipValue = "";

		// diesal_amount
		$this->diesal_amount->LinkCustomAttributes = "";
		$this->diesal_amount->HrefValue = "";
		$this->diesal_amount->TooltipValue = "";

		// diesal_cl_balance
		$this->diesal_cl_balance->LinkCustomAttributes = "";
		$this->diesal_cl_balance->HrefValue = "";
		$this->diesal_cl_balance->TooltipValue = "";

		// vehicle_average
		$this->vehicle_average->LinkCustomAttributes = "";
		$this->vehicle_average->HrefValue = "";
		$this->vehicle_average->TooltipValue = "";

		// cash_required
		$this->cash_required->LinkCustomAttributes = "";
		$this->cash_required->HrefValue = "";
		$this->cash_required->TooltipValue = "";

		// cash_op_b
		$this->cash_op_b->LinkCustomAttributes = "";
		$this->cash_op_b->HrefValue = "";
		$this->cash_op_b->TooltipValue = "";

		// cash_paid
		$this->cash_paid->LinkCustomAttributes = "";
		$this->cash_paid->HrefValue = "";
		$this->cash_paid->TooltipValue = "";

		// cash_expenses
		$this->cash_expenses->LinkCustomAttributes = "";
		$this->cash_expenses->HrefValue = "";
		$this->cash_expenses->TooltipValue = "";

		// cash_cl_balance
		$this->cash_cl_balance->LinkCustomAttributes = "";
		$this->cash_cl_balance->HrefValue = "";
		$this->cash_cl_balance->TooltipValue = "";

		// fasttag_op_b
		$this->fasttag_op_b->LinkCustomAttributes = "";
		$this->fasttag_op_b->HrefValue = "";
		$this->fasttag_op_b->TooltipValue = "";

		// fasttag_recharge
		$this->fasttag_recharge->LinkCustomAttributes = "";
		$this->fasttag_recharge->HrefValue = "";
		$this->fasttag_recharge->TooltipValue = "";

		// fasttag_expenses
		$this->fasttag_expenses->LinkCustomAttributes = "";
		$this->fasttag_expenses->HrefValue = "";
		$this->fasttag_expenses->TooltipValue = "";

		// toll_expenses_cash
		$this->toll_expenses_cash->LinkCustomAttributes = "";
		$this->toll_expenses_cash->HrefValue = "";
		$this->toll_expenses_cash->TooltipValue = "";

		// fasttag_cl_balance
		$this->fasttag_cl_balance->LinkCustomAttributes = "";
		$this->fasttag_cl_balance->HrefValue = "";
		$this->fasttag_cl_balance->TooltipValue = "";

		// remarks
		$this->remarks->LinkCustomAttributes = "";
		$this->remarks->HrefValue = "";
		$this->remarks->TooltipValue = "";

		// uploads
		$this->uploads->LinkCustomAttributes = "";
		$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->HrefValue = GetFileUploadUrl($this->uploads, $this->uploads->Upload->DbValue); // Add prefix/suffix
			$this->uploads->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
		} else {
			$this->uploads->HrefValue = "";
		}
		$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
		$this->uploads->TooltipValue = "";
		if ($this->uploads->UseColorbox) {
			if (EmptyValue($this->uploads->TooltipValue))
				$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->uploads->LinkAttrs["data-rel"] = "t_trip_info_x_uploads";
			AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
		}

		// consignor
		$this->consignor->LinkCustomAttributes = "";
		$this->consignor->HrefValue = "";
		$this->consignor->TooltipValue = "";

		// vehicle_freight_comm
		$this->vehicle_freight_comm->LinkCustomAttributes = "";
		$this->vehicle_freight_comm->HrefValue = "";
		$this->vehicle_freight_comm->TooltipValue = "";

		// vehicle_freight_type
		$this->vehicle_freight_type->LinkCustomAttributes = "";
		$this->vehicle_freight_type->HrefValue = "";
		$this->vehicle_freight_type->TooltipValue = "";

		// vehicle_freight_amount
		$this->vehicle_freight_amount->LinkCustomAttributes = "";
		$this->vehicle_freight_amount->HrefValue = "";
		$this->vehicle_freight_amount->TooltipValue = "";

		// vehicle_freight_final
		$this->vehicle_freight_final->LinkCustomAttributes = "";
		$this->vehicle_freight_final->HrefValue = "";
		$this->vehicle_freight_final->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// expenses_id
		$this->expenses_id->LinkCustomAttributes = "";
		$this->expenses_id->HrefValue = "";
		$this->expenses_id->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// vehicle_type
		$this->vehicle_type->EditAttrs["class"] = "form-control";
		$this->vehicle_type->EditCustomAttributes = "";
		$this->vehicle_type->EditValue = $this->vehicle_type->options(TRUE);

		// vehicle
		$this->vehicle->EditAttrs["class"] = "form-control";
		$this->vehicle->EditCustomAttributes = "";
		$this->vehicle->EditValue = $this->vehicle->CurrentValue;
		$curVal = strval($this->vehicle->CurrentValue);
		if ($curVal <> "") {
			$this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
			if ($this->vehicle->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$lookupFilter = function() {
					return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->vehicle->EditValue = $this->vehicle->CurrentValue;
				}
			}
		} else {
			$this->vehicle->EditValue = NULL;
		}
		$this->vehicle->ViewCustomAttributes = "";

		// route
		$this->_route->EditAttrs["class"] = "form-control";
		$this->_route->EditCustomAttributes = "";
		$this->_route->EditValue = $this->_route->CurrentValue;
		$this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

		// route_name
		$this->route_name->EditAttrs["class"] = "form-control";
		$this->route_name->EditCustomAttributes = "";
		$this->route_name->EditValue = $this->route_name->CurrentValue;
		$this->route_name->ViewCustomAttributes = "";

		// reports_to
		$this->reports_to->EditAttrs["class"] = "form-control";
		$this->reports_to->EditCustomAttributes = "";

		// buyer
		$this->buyer->EditAttrs["class"] = "form-control";
		$this->buyer->EditCustomAttributes = "";
		$this->buyer->EditValue = $this->buyer->CurrentValue;
		$this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

		// b_consignor
		$this->b_consignor->EditAttrs["class"] = "form-control";
		$this->b_consignor->EditCustomAttributes = "";
		$this->b_consignor->EditValue = $this->b_consignor->CurrentValue;
		$this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());

		// b_consignee
		$this->b_consignee->EditAttrs["class"] = "form-control";
		$this->b_consignee->EditCustomAttributes = "";
		$this->b_consignee->EditValue = $this->b_consignee->CurrentValue;
		$this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());

		// load_date
		$this->load_date->EditAttrs["class"] = "form-control";
		$this->load_date->EditCustomAttributes = "";
		$this->load_date->EditValue = FormatDateTime($this->load_date->CurrentValue, 8);
		$this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

		// load_weight
		$this->load_weight->EditAttrs["class"] = "form-control";
		$this->load_weight->EditCustomAttributes = "";
		$this->load_weight->EditValue = $this->load_weight->CurrentValue;
		$this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());

		// unload_date
		$this->unload_date->EditAttrs["class"] = "form-control";
		$this->unload_date->EditCustomAttributes = "";
		$this->unload_date->EditValue = FormatDateTime($this->unload_date->CurrentValue, 8);
		$this->unload_date->PlaceHolder = RemoveHtml($this->unload_date->caption());

		// unload_weight
		$this->unload_weight->EditAttrs["class"] = "form-control";
		$this->unload_weight->EditCustomAttributes = "";
		$this->unload_weight->EditValue = $this->unload_weight->CurrentValue;
		$this->unload_weight->PlaceHolder = RemoveHtml($this->unload_weight->caption());

		// invoice_no
		$this->invoice_no->EditAttrs["class"] = "form-control";
		$this->invoice_no->EditCustomAttributes = "";
		$this->invoice_no->EditValue = $this->invoice_no->CurrentValue;
		$this->invoice_no->EditValue = FormatNumber($this->invoice_no->EditValue, 0, -2, -2, -2);
		$this->invoice_no->ViewCustomAttributes = "";

		// invoice_date
		$this->invoice_date->EditAttrs["class"] = "form-control";
		$this->invoice_date->EditCustomAttributes = "";
		$this->invoice_date->EditValue = $this->invoice_date->CurrentValue;
		$this->invoice_date->EditValue = FormatDateTime($this->invoice_date->EditValue, 0);
		$this->invoice_date->ViewCustomAttributes = "";

		// amount
		$this->amount->EditAttrs["class"] = "form-control";
		$this->amount->EditCustomAttributes = "";
		$this->amount->EditValue = $this->amount->CurrentValue;
		$this->amount->EditValue = FormatNumber($this->amount->EditValue, 2, -2, -2, -2);
		$this->amount->ViewCustomAttributes = "";

		// delivery_pod
		$this->delivery_pod->EditCustomAttributes = "";
		$this->delivery_pod->EditValue = $this->delivery_pod->options(FALSE);

		// status
		$this->status->EditAttrs["class"] = "form-control";
		$this->status->EditCustomAttributes = "";
		if (strval($this->status->CurrentValue) <> "") {
			$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
		} else {
			$this->status->EditValue = NULL;
		}
		$this->status->ViewCustomAttributes = "";

		// days
		$this->days->EditAttrs["class"] = "form-control";
		$this->days->EditCustomAttributes = "";
		$this->days->EditValue = $this->days->CurrentValue;
		$this->days->EditValue = FormatNumber($this->days->EditValue, 0, -2, -2, -2);
		$this->days->ViewCustomAttributes = "";

		// driver
		$this->driver->EditAttrs["class"] = "form-control";
		$this->driver->EditCustomAttributes = "";

		// driver_name
		$this->driver_name->EditAttrs["class"] = "form-control";
		$this->driver_name->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
		$this->driver_name->EditValue = $this->driver_name->CurrentValue;
		$this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

		// agent
		$this->agent->EditAttrs["class"] = "form-control";
		$this->agent->EditCustomAttributes = "";
		$this->agent->EditValue = $this->agent->CurrentValue;
		$this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

		// comm
		$this->comm->EditAttrs["class"] = "form-control";
		$this->comm->EditCustomAttributes = "";
		$this->comm->EditValue = $this->comm->CurrentValue;
		$this->comm->PlaceHolder = RemoveHtml($this->comm->caption());
		if (strval($this->comm->EditValue) <> "" && is_numeric($this->comm->EditValue))
			$this->comm->EditValue = FormatNumber($this->comm->EditValue, -2, -2, -2, -2);

		// material
		$this->material->EditAttrs["class"] = "form-control";
		$this->material->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->material->CurrentValue = HtmlDecode($this->material->CurrentValue);
		$this->material->EditValue = $this->material->CurrentValue;
		$this->material->PlaceHolder = RemoveHtml($this->material->caption());

		// packing_type
		$this->packing_type->EditAttrs["class"] = "form-control";
		$this->packing_type->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->packing_type->CurrentValue = HtmlDecode($this->packing_type->CurrentValue);
		$this->packing_type->EditValue = $this->packing_type->CurrentValue;
		$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

		// m_hsn
		$this->m_hsn->EditAttrs["class"] = "form-control";
		$this->m_hsn->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->m_hsn->CurrentValue = HtmlDecode($this->m_hsn->CurrentValue);
		$this->m_hsn->EditValue = $this->m_hsn->CurrentValue;
		$this->m_hsn->PlaceHolder = RemoveHtml($this->m_hsn->caption());

		// @
		$this->_40->EditAttrs["class"] = "form-control";
		$this->_40->EditCustomAttributes = "";
		$this->_40->EditValue = $this->_40->CurrentValue;
		$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
		if (strval($this->_40->EditValue) <> "" && is_numeric($this->_40->EditValue))
			$this->_40->EditValue = FormatNumber($this->_40->EditValue, -2, -2, -2, -2);

		// lr_no
		$this->lr_no->EditAttrs["class"] = "form-control";
		$this->lr_no->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->lr_no->CurrentValue = HtmlDecode($this->lr_no->CurrentValue);
		$this->lr_no->EditValue = $this->lr_no->CurrentValue;
		$this->lr_no->PlaceHolder = RemoveHtml($this->lr_no->caption());

		// km
		$this->km->EditAttrs["class"] = "form-control";
		$this->km->EditCustomAttributes = "";
		$this->km->EditValue = $this->km->CurrentValue;
		$this->km->PlaceHolder = RemoveHtml($this->km->caption());
		if (strval($this->km->EditValue) <> "" && is_numeric($this->km->EditValue))
			$this->km->EditValue = FormatNumber($this->km->EditValue, -2, -2, -2, -2);

		// freight_type
		$this->freight_type->EditAttrs["class"] = "form-control";
		$this->freight_type->EditCustomAttributes = "";
		$this->freight_type->EditValue = $this->freight_type->options(TRUE);

		// freight
		$this->freight->EditAttrs["class"] = "form-control";
		$this->freight->EditCustomAttributes = "";
		$this->freight->EditValue = $this->freight->CurrentValue;
		$this->freight->PlaceHolder = RemoveHtml($this->freight->caption());
		if (strval($this->freight->EditValue) <> "" && is_numeric($this->freight->EditValue))
			$this->freight->EditValue = FormatNumber($this->freight->EditValue, -2, -2, -2, -2);

		// ded_det
		$this->ded_det->EditAttrs["class"] = "form-control";
		$this->ded_det->EditCustomAttributes = "";
		$this->ded_det->EditValue = $this->ded_det->CurrentValue;
		$this->ded_det->PlaceHolder = RemoveHtml($this->ded_det->caption());
		if (strval($this->ded_det->EditValue) <> "" && is_numeric($this->ded_det->EditValue))
			$this->ded_det->EditValue = FormatNumber($this->ded_det->EditValue, -2, -2, -2, -2);

		// ded_det_remarks
		$this->ded_det_remarks->EditAttrs["class"] = "form-control";
		$this->ded_det_remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->ded_det_remarks->CurrentValue = HtmlDecode($this->ded_det_remarks->CurrentValue);
		$this->ded_det_remarks->EditValue = $this->ded_det_remarks->CurrentValue;
		$this->ded_det_remarks->PlaceHolder = RemoveHtml($this->ded_det_remarks->caption());

		// gst_percent
		$this->gst_percent->EditAttrs["class"] = "form-control";
		$this->gst_percent->EditCustomAttributes = "";
		$this->gst_percent->EditValue = $this->gst_percent->CurrentValue;
		$this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());
		if (strval($this->gst_percent->EditValue) <> "" && is_numeric($this->gst_percent->EditValue))
			$this->gst_percent->EditValue = FormatNumber($this->gst_percent->EditValue, -2, -2, -2, -2);

		// gst_amount
		$this->gst_amount->EditAttrs["class"] = "form-control";
		$this->gst_amount->EditCustomAttributes = "";
		$this->gst_amount->EditValue = $this->gst_amount->CurrentValue;
		$this->gst_amount->EditValue = FormatNumber($this->gst_amount->EditValue, 2, -2, -2, -2);
		$this->gst_amount->ViewCustomAttributes = "";

		// final_amount
		$this->final_amount->EditAttrs["class"] = "form-control";
		$this->final_amount->EditCustomAttributes = "";
		$this->final_amount->EditValue = $this->final_amount->CurrentValue;
		$this->final_amount->EditValue = FormatNumber($this->final_amount->EditValue, 2, -2, -2, -2);
		$this->final_amount->ViewCustomAttributes = "";

		// load_km
		$this->load_km->EditAttrs["class"] = "form-control";
		$this->load_km->EditCustomAttributes = "";
		$this->load_km->EditValue = $this->load_km->CurrentValue;
		$this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());

		// unload_km
		$this->unload_km->EditAttrs["class"] = "form-control";
		$this->unload_km->EditCustomAttributes = "";
		$this->unload_km->EditValue = $this->unload_km->CurrentValue;
		$this->unload_km->PlaceHolder = RemoveHtml($this->unload_km->caption());

		// delivery_receipt
		$this->delivery_receipt->EditAttrs["class"] = "form-control";
		$this->delivery_receipt->EditCustomAttributes = "";
		$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
			$this->delivery_receipt->ImageWidth = 0;
			$this->delivery_receipt->ImageHeight = 50;
			$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
			$this->delivery_receipt->EditValue = $this->delivery_receipt->Upload->DbValue;
		} else {
			$this->delivery_receipt->EditValue = "";
		}
		if (!EmptyValue($this->delivery_receipt->CurrentValue))
				$this->delivery_receipt->Upload->FileName = $this->delivery_receipt->CurrentValue;

		// delivery_docket
		$this->delivery_docket->EditAttrs["class"] = "form-control";
		$this->delivery_docket->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->delivery_docket->CurrentValue = HtmlDecode($this->delivery_docket->CurrentValue);
		$this->delivery_docket->EditValue = $this->delivery_docket->CurrentValue;
		$this->delivery_docket->PlaceHolder = RemoveHtml($this->delivery_docket->caption());

		// diesal_op_b
		$this->diesal_op_b->EditAttrs["class"] = "form-control";
		$this->diesal_op_b->EditCustomAttributes = "";
		$this->diesal_op_b->EditValue = $this->diesal_op_b->CurrentValue;
		$this->diesal_op_b->EditValue = FormatNumber($this->diesal_op_b->EditValue, 2, -2, -2, -2);
		$this->diesal_op_b->ViewCustomAttributes = "";

		// diesal_required
		$this->diesal_required->EditAttrs["class"] = "form-control";
		$this->diesal_required->EditCustomAttributes = "";
		$this->diesal_required->EditValue = $this->diesal_required->CurrentValue;
		$this->diesal_required->EditValue = FormatNumber($this->diesal_required->EditValue, 2, -2, -2, -2);
		$this->diesal_required->ViewCustomAttributes = "";

		// diesal_fill
		$this->diesal_fill->EditAttrs["class"] = "form-control";
		$this->diesal_fill->EditCustomAttributes = "";
		$this->diesal_fill->EditValue = $this->diesal_fill->CurrentValue;
		$this->diesal_fill->EditValue = FormatNumber($this->diesal_fill->EditValue, 2, -2, -2, -2);
		$this->diesal_fill->ViewCustomAttributes = "";

		// diesal_amount
		$this->diesal_amount->EditAttrs["class"] = "form-control";
		$this->diesal_amount->EditCustomAttributes = "";
		$this->diesal_amount->EditValue = $this->diesal_amount->CurrentValue;
		$this->diesal_amount->EditValue = FormatNumber($this->diesal_amount->EditValue, 2, -2, -2, -2);
		$this->diesal_amount->ViewCustomAttributes = "";

		// diesal_cl_balance
		$this->diesal_cl_balance->EditAttrs["class"] = "form-control";
		$this->diesal_cl_balance->EditCustomAttributes = "";
		$this->diesal_cl_balance->EditValue = $this->diesal_cl_balance->CurrentValue;
		$this->diesal_cl_balance->EditValue = FormatNumber($this->diesal_cl_balance->EditValue, 2, -2, -2, -2);
		$this->diesal_cl_balance->ViewCustomAttributes = "";

		// vehicle_average
		$this->vehicle_average->EditAttrs["class"] = "form-control";
		$this->vehicle_average->EditCustomAttributes = "";
		$this->vehicle_average->EditValue = $this->vehicle_average->CurrentValue;
		$this->vehicle_average->EditValue = FormatNumber($this->vehicle_average->EditValue, 2, -2, -2, -2);
		$this->vehicle_average->ViewCustomAttributes = "";

		// cash_required
		$this->cash_required->EditAttrs["class"] = "form-control";
		$this->cash_required->EditCustomAttributes = "";
		$this->cash_required->EditValue = $this->cash_required->CurrentValue;
		$this->cash_required->EditValue = FormatNumber($this->cash_required->EditValue, 2, -2, -2, -2);
		$this->cash_required->ViewCustomAttributes = "";

		// cash_op_b
		$this->cash_op_b->EditAttrs["class"] = "form-control";
		$this->cash_op_b->EditCustomAttributes = "";
		$this->cash_op_b->EditValue = $this->cash_op_b->CurrentValue;
		$this->cash_op_b->EditValue = FormatNumber($this->cash_op_b->EditValue, 2, -2, -2, -2);
		$this->cash_op_b->ViewCustomAttributes = "";

		// cash_paid
		$this->cash_paid->EditAttrs["class"] = "form-control";
		$this->cash_paid->EditCustomAttributes = "";
		$this->cash_paid->EditValue = $this->cash_paid->CurrentValue;
		$this->cash_paid->EditValue = FormatNumber($this->cash_paid->EditValue, 2, -2, -2, -2);
		$this->cash_paid->ViewCustomAttributes = "";

		// cash_expenses
		$this->cash_expenses->EditAttrs["class"] = "form-control";
		$this->cash_expenses->EditCustomAttributes = "";
		$this->cash_expenses->EditValue = $this->cash_expenses->CurrentValue;
		$this->cash_expenses->EditValue = FormatNumber($this->cash_expenses->EditValue, 2, -2, -2, -2);
		$this->cash_expenses->ViewCustomAttributes = "";

		// cash_cl_balance
		$this->cash_cl_balance->EditAttrs["class"] = "form-control";
		$this->cash_cl_balance->EditCustomAttributes = "";
		$this->cash_cl_balance->EditValue = $this->cash_cl_balance->CurrentValue;
		$this->cash_cl_balance->EditValue = FormatNumber($this->cash_cl_balance->EditValue, 2, -2, -2, -2);
		$this->cash_cl_balance->ViewCustomAttributes = "";

		// fasttag_op_b
		$this->fasttag_op_b->EditAttrs["class"] = "form-control";
		$this->fasttag_op_b->EditCustomAttributes = "";
		$this->fasttag_op_b->EditValue = $this->fasttag_op_b->CurrentValue;
		$this->fasttag_op_b->EditValue = FormatNumber($this->fasttag_op_b->EditValue, 2, -2, -2, -2);
		$this->fasttag_op_b->ViewCustomAttributes = "";

		// fasttag_recharge
		$this->fasttag_recharge->EditAttrs["class"] = "form-control";
		$this->fasttag_recharge->EditCustomAttributes = "";
		$this->fasttag_recharge->EditValue = $this->fasttag_recharge->CurrentValue;
		$this->fasttag_recharge->EditValue = FormatNumber($this->fasttag_recharge->EditValue, 2, -2, -2, -2);
		$this->fasttag_recharge->ViewCustomAttributes = "";

		// fasttag_expenses
		$this->fasttag_expenses->EditAttrs["class"] = "form-control";
		$this->fasttag_expenses->EditCustomAttributes = "";
		$this->fasttag_expenses->EditValue = $this->fasttag_expenses->CurrentValue;
		$this->fasttag_expenses->EditValue = FormatNumber($this->fasttag_expenses->EditValue, 2, -2, -2, -2);
		$this->fasttag_expenses->ViewCustomAttributes = "";

		// toll_expenses_cash
		$this->toll_expenses_cash->EditAttrs["class"] = "form-control";
		$this->toll_expenses_cash->EditCustomAttributes = "";
		$this->toll_expenses_cash->EditValue = $this->toll_expenses_cash->CurrentValue;
		$this->toll_expenses_cash->EditValue = FormatNumber($this->toll_expenses_cash->EditValue, 2, -2, -2, -2);
		$this->toll_expenses_cash->ViewCustomAttributes = "";

		// fasttag_cl_balance
		$this->fasttag_cl_balance->EditAttrs["class"] = "form-control";
		$this->fasttag_cl_balance->EditCustomAttributes = "";
		$this->fasttag_cl_balance->EditValue = $this->fasttag_cl_balance->CurrentValue;
		$this->fasttag_cl_balance->PlaceHolder = RemoveHtml($this->fasttag_cl_balance->caption());
		if (strval($this->fasttag_cl_balance->EditValue) <> "" && is_numeric($this->fasttag_cl_balance->EditValue))
			$this->fasttag_cl_balance->EditValue = FormatNumber($this->fasttag_cl_balance->EditValue, -2, -2, -2, -2);

		// remarks
		$this->remarks->EditAttrs["class"] = "form-control";
		$this->remarks->EditCustomAttributes = "";
		$this->remarks->EditValue = $this->remarks->CurrentValue;
		$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

		// uploads
		$this->uploads->EditAttrs["class"] = "form-control";
		$this->uploads->EditCustomAttributes = "";
		$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		if (!EmptyValue($this->uploads->Upload->DbValue)) {
			$this->uploads->ImageWidth = 0;
			$this->uploads->ImageHeight = 50;
			$this->uploads->ImageAlt = $this->uploads->alt();
			$this->uploads->EditValue = $this->uploads->Upload->DbValue;
		} else {
			$this->uploads->EditValue = "";
		}
		if (!EmptyValue($this->uploads->CurrentValue))
				$this->uploads->Upload->FileName = $this->uploads->CurrentValue;

		// consignor
		$this->consignor->EditAttrs["class"] = "form-control";
		$this->consignor->EditCustomAttributes = 'ReadOnly';
		$this->consignor->EditValue = $this->consignor->CurrentValue;
		$this->consignor->PlaceHolder = RemoveHtml($this->consignor->caption());

		// vehicle_freight_comm
		$this->vehicle_freight_comm->EditAttrs["class"] = "form-control";
		$this->vehicle_freight_comm->EditCustomAttributes = "";
		$this->vehicle_freight_comm->EditValue = $this->vehicle_freight_comm->CurrentValue;
		$this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());
		if (strval($this->vehicle_freight_comm->EditValue) <> "" && is_numeric($this->vehicle_freight_comm->EditValue))
			$this->vehicle_freight_comm->EditValue = FormatNumber($this->vehicle_freight_comm->EditValue, -2, -2, -2, -2);

		// vehicle_freight_type
		$this->vehicle_freight_type->EditAttrs["class"] = "form-control";
		$this->vehicle_freight_type->EditCustomAttributes = "";
		$this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(TRUE);

		// vehicle_freight_amount
		$this->vehicle_freight_amount->EditAttrs["class"] = "form-control";
		$this->vehicle_freight_amount->EditCustomAttributes = "";
		$this->vehicle_freight_amount->EditValue = $this->vehicle_freight_amount->CurrentValue;
		$this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());
		if (strval($this->vehicle_freight_amount->EditValue) <> "" && is_numeric($this->vehicle_freight_amount->EditValue))
			$this->vehicle_freight_amount->EditValue = FormatNumber($this->vehicle_freight_amount->EditValue, -2, -2, -2, -2);

		// vehicle_freight_final
		$this->vehicle_freight_final->EditAttrs["class"] = "form-control";
		$this->vehicle_freight_final->EditCustomAttributes = "";
		$this->vehicle_freight_final->EditValue = $this->vehicle_freight_final->CurrentValue;
		$this->vehicle_freight_final->EditValue = FormatNumber($this->vehicle_freight_final->EditValue, 2, -2, -2, -2);
		$this->vehicle_freight_final->ViewCustomAttributes = "";

		// operator
		// datetime
		// expenses_id

		$this->expenses_id->EditAttrs["class"] = "form-control";
		$this->expenses_id->EditCustomAttributes = "";
		$this->expenses_id->EditValue = $this->expenses_id->CurrentValue;
		$this->expenses_id->PlaceHolder = RemoveHtml($this->expenses_id->caption());

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->vehicle_type);
					$doc->exportCaption($this->vehicle);
					$doc->exportCaption($this->_route);
					$doc->exportCaption($this->route_name);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->buyer);
					$doc->exportCaption($this->b_consignor);
					$doc->exportCaption($this->b_consignee);
					$doc->exportCaption($this->load_date);
					$doc->exportCaption($this->load_weight);
					$doc->exportCaption($this->unload_date);
					$doc->exportCaption($this->unload_weight);
					$doc->exportCaption($this->invoice_no);
					$doc->exportCaption($this->invoice_date);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->delivery_pod);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->days);
					$doc->exportCaption($this->driver);
					$doc->exportCaption($this->driver_name);
					$doc->exportCaption($this->agent);
					$doc->exportCaption($this->comm);
					$doc->exportCaption($this->material);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->m_hsn);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->lr_no);
					$doc->exportCaption($this->km);
					$doc->exportCaption($this->freight_type);
					$doc->exportCaption($this->freight);
					$doc->exportCaption($this->ded_det);
					$doc->exportCaption($this->ded_det_remarks);
					$doc->exportCaption($this->gst_percent);
					$doc->exportCaption($this->gst_amount);
					$doc->exportCaption($this->final_amount);
					$doc->exportCaption($this->load_km);
					$doc->exportCaption($this->unload_km);
					$doc->exportCaption($this->delivery_receipt);
					$doc->exportCaption($this->delivery_docket);
					$doc->exportCaption($this->diesal_op_b);
					$doc->exportCaption($this->diesal_required);
					$doc->exportCaption($this->diesal_fill);
					$doc->exportCaption($this->diesal_amount);
					$doc->exportCaption($this->diesal_cl_balance);
					$doc->exportCaption($this->vehicle_average);
					$doc->exportCaption($this->cash_required);
					$doc->exportCaption($this->cash_op_b);
					$doc->exportCaption($this->cash_paid);
					$doc->exportCaption($this->cash_expenses);
					$doc->exportCaption($this->cash_cl_balance);
					$doc->exportCaption($this->fasttag_op_b);
					$doc->exportCaption($this->fasttag_recharge);
					$doc->exportCaption($this->fasttag_expenses);
					$doc->exportCaption($this->toll_expenses_cash);
					$doc->exportCaption($this->fasttag_cl_balance);
					$doc->exportCaption($this->remarks);
					$doc->exportCaption($this->uploads);
					$doc->exportCaption($this->consignor);
					$doc->exportCaption($this->vehicle_freight_comm);
					$doc->exportCaption($this->vehicle_freight_type);
					$doc->exportCaption($this->vehicle_freight_amount);
					$doc->exportCaption($this->vehicle_freight_final);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->vehicle_type);
					$doc->exportCaption($this->vehicle);
					$doc->exportCaption($this->_route);
					$doc->exportCaption($this->route_name);
					$doc->exportCaption($this->reports_to);
					$doc->exportCaption($this->buyer);
					$doc->exportCaption($this->b_consignor);
					$doc->exportCaption($this->b_consignee);
					$doc->exportCaption($this->load_date);
					$doc->exportCaption($this->load_weight);
					$doc->exportCaption($this->unload_date);
					$doc->exportCaption($this->unload_weight);
					$doc->exportCaption($this->invoice_no);
					$doc->exportCaption($this->invoice_date);
					$doc->exportCaption($this->amount);
					$doc->exportCaption($this->delivery_pod);
					$doc->exportCaption($this->status);
					$doc->exportCaption($this->days);
					$doc->exportCaption($this->driver);
					$doc->exportCaption($this->driver_name);
					$doc->exportCaption($this->agent);
					$doc->exportCaption($this->comm);
					$doc->exportCaption($this->material);
					$doc->exportCaption($this->packing_type);
					$doc->exportCaption($this->m_hsn);
					$doc->exportCaption($this->_40);
					$doc->exportCaption($this->lr_no);
					$doc->exportCaption($this->km);
					$doc->exportCaption($this->freight_type);
					$doc->exportCaption($this->freight);
					$doc->exportCaption($this->ded_det);
					$doc->exportCaption($this->ded_det_remarks);
					$doc->exportCaption($this->gst_percent);
					$doc->exportCaption($this->gst_amount);
					$doc->exportCaption($this->final_amount);
					$doc->exportCaption($this->load_km);
					$doc->exportCaption($this->unload_km);
					$doc->exportCaption($this->delivery_receipt);
					$doc->exportCaption($this->delivery_docket);
					$doc->exportCaption($this->diesal_op_b);
					$doc->exportCaption($this->diesal_required);
					$doc->exportCaption($this->diesal_fill);
					$doc->exportCaption($this->diesal_amount);
					$doc->exportCaption($this->diesal_cl_balance);
					$doc->exportCaption($this->vehicle_average);
					$doc->exportCaption($this->cash_required);
					$doc->exportCaption($this->cash_op_b);
					$doc->exportCaption($this->cash_paid);
					$doc->exportCaption($this->cash_expenses);
					$doc->exportCaption($this->cash_cl_balance);
					$doc->exportCaption($this->fasttag_op_b);
					$doc->exportCaption($this->fasttag_recharge);
					$doc->exportCaption($this->fasttag_expenses);
					$doc->exportCaption($this->toll_expenses_cash);
					$doc->exportCaption($this->fasttag_cl_balance);
					$doc->exportCaption($this->consignor);
					$doc->exportCaption($this->vehicle_freight_comm);
					$doc->exportCaption($this->vehicle_freight_type);
					$doc->exportCaption($this->vehicle_freight_amount);
					$doc->exportCaption($this->vehicle_freight_final);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->vehicle_type);
						$doc->exportField($this->vehicle);
						$doc->exportField($this->_route);
						$doc->exportField($this->route_name);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->buyer);
						$doc->exportField($this->b_consignor);
						$doc->exportField($this->b_consignee);
						$doc->exportField($this->load_date);
						$doc->exportField($this->load_weight);
						$doc->exportField($this->unload_date);
						$doc->exportField($this->unload_weight);
						$doc->exportField($this->invoice_no);
						$doc->exportField($this->invoice_date);
						$doc->exportField($this->amount);
						$doc->exportField($this->delivery_pod);
						$doc->exportField($this->status);
						$doc->exportField($this->days);
						$doc->exportField($this->driver);
						$doc->exportField($this->driver_name);
						$doc->exportField($this->agent);
						$doc->exportField($this->comm);
						$doc->exportField($this->material);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->m_hsn);
						$doc->exportField($this->_40);
						$doc->exportField($this->lr_no);
						$doc->exportField($this->km);
						$doc->exportField($this->freight_type);
						$doc->exportField($this->freight);
						$doc->exportField($this->ded_det);
						$doc->exportField($this->ded_det_remarks);
						$doc->exportField($this->gst_percent);
						$doc->exportField($this->gst_amount);
						$doc->exportField($this->final_amount);
						$doc->exportField($this->load_km);
						$doc->exportField($this->unload_km);
						$doc->exportField($this->delivery_receipt);
						$doc->exportField($this->delivery_docket);
						$doc->exportField($this->diesal_op_b);
						$doc->exportField($this->diesal_required);
						$doc->exportField($this->diesal_fill);
						$doc->exportField($this->diesal_amount);
						$doc->exportField($this->diesal_cl_balance);
						$doc->exportField($this->vehicle_average);
						$doc->exportField($this->cash_required);
						$doc->exportField($this->cash_op_b);
						$doc->exportField($this->cash_paid);
						$doc->exportField($this->cash_expenses);
						$doc->exportField($this->cash_cl_balance);
						$doc->exportField($this->fasttag_op_b);
						$doc->exportField($this->fasttag_recharge);
						$doc->exportField($this->fasttag_expenses);
						$doc->exportField($this->toll_expenses_cash);
						$doc->exportField($this->fasttag_cl_balance);
						$doc->exportField($this->remarks);
						$doc->exportField($this->uploads);
						$doc->exportField($this->consignor);
						$doc->exportField($this->vehicle_freight_comm);
						$doc->exportField($this->vehicle_freight_type);
						$doc->exportField($this->vehicle_freight_amount);
						$doc->exportField($this->vehicle_freight_final);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->vehicle_type);
						$doc->exportField($this->vehicle);
						$doc->exportField($this->_route);
						$doc->exportField($this->route_name);
						$doc->exportField($this->reports_to);
						$doc->exportField($this->buyer);
						$doc->exportField($this->b_consignor);
						$doc->exportField($this->b_consignee);
						$doc->exportField($this->load_date);
						$doc->exportField($this->load_weight);
						$doc->exportField($this->unload_date);
						$doc->exportField($this->unload_weight);
						$doc->exportField($this->invoice_no);
						$doc->exportField($this->invoice_date);
						$doc->exportField($this->amount);
						$doc->exportField($this->delivery_pod);
						$doc->exportField($this->status);
						$doc->exportField($this->days);
						$doc->exportField($this->driver);
						$doc->exportField($this->driver_name);
						$doc->exportField($this->agent);
						$doc->exportField($this->comm);
						$doc->exportField($this->material);
						$doc->exportField($this->packing_type);
						$doc->exportField($this->m_hsn);
						$doc->exportField($this->_40);
						$doc->exportField($this->lr_no);
						$doc->exportField($this->km);
						$doc->exportField($this->freight_type);
						$doc->exportField($this->freight);
						$doc->exportField($this->ded_det);
						$doc->exportField($this->ded_det_remarks);
						$doc->exportField($this->gst_percent);
						$doc->exportField($this->gst_amount);
						$doc->exportField($this->final_amount);
						$doc->exportField($this->load_km);
						$doc->exportField($this->unload_km);
						$doc->exportField($this->delivery_receipt);
						$doc->exportField($this->delivery_docket);
						$doc->exportField($this->diesal_op_b);
						$doc->exportField($this->diesal_required);
						$doc->exportField($this->diesal_fill);
						$doc->exportField($this->diesal_amount);
						$doc->exportField($this->diesal_cl_balance);
						$doc->exportField($this->vehicle_average);
						$doc->exportField($this->cash_required);
						$doc->exportField($this->cash_op_b);
						$doc->exportField($this->cash_paid);
						$doc->exportField($this->cash_expenses);
						$doc->exportField($this->cash_cl_balance);
						$doc->exportField($this->fasttag_op_b);
						$doc->exportField($this->fasttag_recharge);
						$doc->exportField($this->fasttag_expenses);
						$doc->exportField($this->toll_expenses_cash);
						$doc->exportField($this->fasttag_cl_balance);
						$doc->exportField($this->consignor);
						$doc->exportField($this->vehicle_freight_comm);
						$doc->exportField($this->vehicle_freight_type);
						$doc->exportField($this->vehicle_freight_amount);
						$doc->exportField($this->vehicle_freight_final);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'delivery_receipt') {
			$fldName = "delivery_receipt";
			$fileNameFld = "delivery_receipt";
		} elseif ($fldparm == 'uploads') {
			$fldName = "uploads";
			$fileNameFld = "uploads";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>