<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class t_trip_info_add extends t_trip_info
{

	// Page ID
	public $PageID = "add";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 't_trip_info';

	// Page object name
	public $PageObjName = "t_trip_info_add";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (t_trip_info)
		if (!isset($GLOBALS["t_trip_info"]) || get_class($GLOBALS["t_trip_info"]) == PROJECT_NAMESPACE . "t_trip_info") {
			$GLOBALS["t_trip_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["t_trip_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'add');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $t_trip_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($t_trip_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "t_trip_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-add-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter = "";
	public $DbDetailFilter = "";
	public $StartRec;
	public $Priv = 0;
	public $OldRecordset;
	public $CopyRecord;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canAdd()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("t_trip_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->Visible = FALSE;
		$this->vehicle_type->setVisibility();
		$this->vehicle->setVisibility();
		$this->_route->setVisibility();
		$this->route_name->Visible = FALSE;
		$this->reports_to->setVisibility();
		$this->buyer->setVisibility();
		$this->b_consignor->setVisibility();
		$this->b_consignee->setVisibility();
		$this->load_date->setVisibility();
		$this->load_weight->setVisibility();
		$this->unload_date->Visible = FALSE;
		$this->unload_weight->Visible = FALSE;
		$this->invoice_no->Visible = FALSE;
		$this->invoice_date->Visible = FALSE;
		$this->amount->Visible = FALSE;
		$this->delivery_pod->Visible = FALSE;
		$this->status->Visible = FALSE;
		$this->days->Visible = FALSE;
		$this->driver->setVisibility();
		$this->driver_name->setVisibility();
		$this->agent->setVisibility();
		$this->comm->setVisibility();
		$this->material->setVisibility();
		$this->packing_type->setVisibility();
		$this->m_hsn->setVisibility();
		$this->_40->setVisibility();
		$this->lr_no->Visible = FALSE;
		$this->km->Visible = FALSE;
		$this->freight_type->setVisibility();
		$this->freight->setVisibility();
		$this->ded_det->Visible = FALSE;
		$this->ded_det_remarks->Visible = FALSE;
		$this->gst_percent->setVisibility();
		$this->gst_amount->Visible = FALSE;
		$this->final_amount->Visible = FALSE;
		$this->load_km->setVisibility();
		$this->unload_km->Visible = FALSE;
		$this->delivery_receipt->Visible = FALSE;
		$this->delivery_docket->Visible = FALSE;
		$this->diesal_op_b->Visible = FALSE;
		$this->diesal_required->Visible = FALSE;
		$this->diesal_fill->Visible = FALSE;
		$this->diesal_amount->Visible = FALSE;
		$this->diesal_cl_balance->Visible = FALSE;
		$this->vehicle_average->Visible = FALSE;
		$this->cash_required->Visible = FALSE;
		$this->cash_op_b->Visible = FALSE;
		$this->cash_paid->Visible = FALSE;
		$this->cash_expenses->Visible = FALSE;
		$this->cash_cl_balance->Visible = FALSE;
		$this->fasttag_op_b->Visible = FALSE;
		$this->fasttag_recharge->Visible = FALSE;
		$this->fasttag_expenses->Visible = FALSE;
		$this->toll_expenses_cash->Visible = FALSE;
		$this->fasttag_cl_balance->Visible = FALSE;
		$this->remarks->setVisibility();
		$this->uploads->Visible = FALSE;
		$this->consignor->setVisibility();
		$this->vehicle_freight_comm->setVisibility();
		$this->vehicle_freight_type->setVisibility();
		$this->vehicle_freight_amount->setVisibility();
		$this->vehicle_freight_final->Visible = FALSE;
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->expenses_id->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->vehicle);
		$this->setupLookupOptions($this->_route);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->buyer);
		$this->setupLookupOptions($this->b_consignor);
		$this->setupLookupOptions($this->b_consignee);
		$this->setupLookupOptions($this->driver);
		$this->setupLookupOptions($this->agent);
		$this->setupLookupOptions($this->consignor);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-add-form ew-horizontal";
		$postBack = FALSE;

		// Set up current action
		if (IsApi()) {
			$this->CurrentAction = "insert"; // Add record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get form action
			$postBack = TRUE;
		} else { // Not post back

			// Load key values from QueryString
			$this->CopyRecord = TRUE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$this->setKey("id", $this->id->CurrentValue); // Set up key
			} else {
				$this->setKey("id", ""); // Clear key
				$this->CopyRecord = FALSE;
			}
			if ($this->CopyRecord) {
				$this->CurrentAction = "copy"; // Copy record
			} else {
				$this->CurrentAction = "show"; // Display blank record
			}
		}

		// Load old record / default values
		$loaded = $this->loadOldRecord();

		// Load form values
		if ($postBack) {
			$this->loadFormValues(); // Load form values
		}

		// Set up detail parameters
		$this->setupDetailParms();

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues(); // Restore form values
				$this->setFailureMessage($FormError);
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = "show"; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "copy": // Copy an existing record
				if (!$loaded) { // Record not loaded
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("t_trip_infolist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "insert": // Add new record
				$this->SendEmail = TRUE; // Send email on add success
				if ($this->addRow($this->OldRecordset)) { // Add successful
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("AddSuccess")); // Set up success message
					if ($this->getCurrentDetailTable() <> "") // Master/detail add
						$returnUrl = $this->getDetailUrl();
					else
						$returnUrl = $this->getReturnUrl();
					if (GetPageName($returnUrl) == "t_trip_infolist.php")
						$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
					elseif (GetPageName($returnUrl) == "t_trip_infoview.php")
						$returnUrl = $this->getViewUrl(); // View page, return to View page with keyurl directly
					if (IsApi()) { // Return to caller
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl);
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Add failed, restore form values

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render row based on row type
		$this->RowType = ROWTYPE_ADD; // Render add type

		// Render row
		$this->resetAttributes();
		$this->renderRow();
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
	}

	// Load default values
	protected function loadDefaultValues()
	{
		$this->id->CurrentValue = NULL;
		$this->id->OldValue = $this->id->CurrentValue;
		$this->vehicle_type->CurrentValue = 1;
		$this->vehicle->CurrentValue = NULL;
		$this->vehicle->OldValue = $this->vehicle->CurrentValue;
		$this->_route->CurrentValue = NULL;
		$this->_route->OldValue = $this->_route->CurrentValue;
		$this->route_name->CurrentValue = NULL;
		$this->route_name->OldValue = $this->route_name->CurrentValue;
		$this->reports_to->CurrentValue = 0;
		$this->buyer->CurrentValue = NULL;
		$this->buyer->OldValue = $this->buyer->CurrentValue;
		$this->b_consignor->CurrentValue = NULL;
		$this->b_consignor->OldValue = $this->b_consignor->CurrentValue;
		$this->b_consignee->CurrentValue = NULL;
		$this->b_consignee->OldValue = $this->b_consignee->CurrentValue;
		$this->load_date->CurrentValue = NULL;
		$this->load_date->OldValue = $this->load_date->CurrentValue;
		$this->load_weight->CurrentValue = NULL;
		$this->load_weight->OldValue = $this->load_weight->CurrentValue;
		$this->unload_date->CurrentValue = NULL;
		$this->unload_date->OldValue = $this->unload_date->CurrentValue;
		$this->unload_weight->CurrentValue = 0;
		$this->invoice_no->CurrentValue = 0;
		$this->invoice_date->CurrentValue = NULL;
		$this->invoice_date->OldValue = $this->invoice_date->CurrentValue;
		$this->amount->CurrentValue = 0.00;
		$this->delivery_pod->CurrentValue = 0;
		$this->status->CurrentValue = 0;
		$this->days->CurrentValue = NULL;
		$this->days->OldValue = $this->days->CurrentValue;
		$this->driver->CurrentValue = NULL;
		$this->driver->OldValue = $this->driver->CurrentValue;
		$this->driver_name->CurrentValue = NULL;
		$this->driver_name->OldValue = $this->driver_name->CurrentValue;
		$this->agent->CurrentValue = NULL;
		$this->agent->OldValue = $this->agent->CurrentValue;
		$this->comm->CurrentValue = 0.00;
		$this->material->CurrentValue = NULL;
		$this->material->OldValue = $this->material->CurrentValue;
		$this->packing_type->CurrentValue = NULL;
		$this->packing_type->OldValue = $this->packing_type->CurrentValue;
		$this->m_hsn->CurrentValue = NULL;
		$this->m_hsn->OldValue = $this->m_hsn->CurrentValue;
		$this->_40->CurrentValue = NULL;
		$this->_40->OldValue = $this->_40->CurrentValue;
		$this->lr_no->CurrentValue = NULL;
		$this->lr_no->OldValue = $this->lr_no->CurrentValue;
		$this->km->CurrentValue = NULL;
		$this->km->OldValue = $this->km->CurrentValue;
		$this->freight_type->CurrentValue = 0;
		$this->freight->CurrentValue = NULL;
		$this->freight->OldValue = $this->freight->CurrentValue;
		$this->ded_det->CurrentValue = 0.00;
		$this->ded_det_remarks->CurrentValue = NULL;
		$this->ded_det_remarks->OldValue = $this->ded_det_remarks->CurrentValue;
		$this->gst_percent->CurrentValue = 0.00;
		$this->gst_amount->CurrentValue = 0.00;
		$this->final_amount->CurrentValue = 0.00;
		$this->load_km->CurrentValue = NULL;
		$this->load_km->OldValue = $this->load_km->CurrentValue;
		$this->unload_km->CurrentValue = NULL;
		$this->unload_km->OldValue = $this->unload_km->CurrentValue;
		$this->delivery_receipt->Upload->DbValue = NULL;
		$this->delivery_receipt->OldValue = $this->delivery_receipt->Upload->DbValue;
		$this->delivery_receipt->CurrentValue = NULL; // Clear file related field
		$this->delivery_docket->CurrentValue = NULL;
		$this->delivery_docket->OldValue = $this->delivery_docket->CurrentValue;
		$this->diesal_op_b->CurrentValue = NULL;
		$this->diesal_op_b->OldValue = $this->diesal_op_b->CurrentValue;
		$this->diesal_required->CurrentValue = NULL;
		$this->diesal_required->OldValue = $this->diesal_required->CurrentValue;
		$this->diesal_fill->CurrentValue = NULL;
		$this->diesal_fill->OldValue = $this->diesal_fill->CurrentValue;
		$this->diesal_amount->CurrentValue = 0.00;
		$this->diesal_cl_balance->CurrentValue = 0.00;
		$this->vehicle_average->CurrentValue = NULL;
		$this->vehicle_average->OldValue = $this->vehicle_average->CurrentValue;
		$this->cash_required->CurrentValue = NULL;
		$this->cash_required->OldValue = $this->cash_required->CurrentValue;
		$this->cash_op_b->CurrentValue = NULL;
		$this->cash_op_b->OldValue = $this->cash_op_b->CurrentValue;
		$this->cash_paid->CurrentValue = NULL;
		$this->cash_paid->OldValue = $this->cash_paid->CurrentValue;
		$this->cash_expenses->CurrentValue = 0.00;
		$this->cash_cl_balance->CurrentValue = 0.00;
		$this->fasttag_op_b->CurrentValue = 0.00;
		$this->fasttag_recharge->CurrentValue = 0.00;
		$this->fasttag_expenses->CurrentValue = 0.00;
		$this->toll_expenses_cash->CurrentValue = 0.00;
		$this->fasttag_cl_balance->CurrentValue = NULL;
		$this->fasttag_cl_balance->OldValue = $this->fasttag_cl_balance->CurrentValue;
		$this->remarks->CurrentValue = NULL;
		$this->remarks->OldValue = $this->remarks->CurrentValue;
		$this->uploads->Upload->DbValue = NULL;
		$this->uploads->OldValue = $this->uploads->Upload->DbValue;
		$this->uploads->CurrentValue = NULL; // Clear file related field
		$this->consignor->CurrentValue = NULL;
		$this->consignor->OldValue = $this->consignor->CurrentValue;
		$this->vehicle_freight_comm->CurrentValue = 0.00;
		$this->vehicle_freight_type->CurrentValue = 0;
		$this->vehicle_freight_amount->CurrentValue = NULL;
		$this->vehicle_freight_amount->OldValue = $this->vehicle_freight_amount->CurrentValue;
		$this->vehicle_freight_final->CurrentValue = 0.00;
		$this->operator->CurrentValue = NULL;
		$this->operator->OldValue = $this->operator->CurrentValue;
		$this->datetime->CurrentValue = NULL;
		$this->datetime->OldValue = $this->datetime->CurrentValue;
		$this->expenses_id->CurrentValue = 0;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;

		// Check field name 'vehicle_type' first before field var 'x_vehicle_type'
		$val = $CurrentForm->hasValue("vehicle_type") ? $CurrentForm->getValue("vehicle_type") : $CurrentForm->getValue("x_vehicle_type");
		if (!$this->vehicle_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_type->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_type->setFormValue($val);
		}

		// Check field name 'vehicle' first before field var 'x_vehicle'
		$val = $CurrentForm->hasValue("vehicle") ? $CurrentForm->getValue("vehicle") : $CurrentForm->getValue("x_vehicle");
		if (!$this->vehicle->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle->setFormValue($val);
		}

		// Check field name 'route' first before field var 'x__route'
		$val = $CurrentForm->hasValue("route") ? $CurrentForm->getValue("route") : $CurrentForm->getValue("x__route");
		if (!$this->_route->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_route->Visible = FALSE; // Disable update for API request
			else
				$this->_route->setFormValue($val);
		}

		// Check field name 'reports_to' first before field var 'x_reports_to'
		$val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
		if (!$this->reports_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reports_to->Visible = FALSE; // Disable update for API request
			else
				$this->reports_to->setFormValue($val);
		}

		// Check field name 'buyer' first before field var 'x_buyer'
		$val = $CurrentForm->hasValue("buyer") ? $CurrentForm->getValue("buyer") : $CurrentForm->getValue("x_buyer");
		if (!$this->buyer->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer->Visible = FALSE; // Disable update for API request
			else
				$this->buyer->setFormValue($val);
		}

		// Check field name 'b_consignor' first before field var 'x_b_consignor'
		$val = $CurrentForm->hasValue("b_consignor") ? $CurrentForm->getValue("b_consignor") : $CurrentForm->getValue("x_b_consignor");
		if (!$this->b_consignor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_consignor->Visible = FALSE; // Disable update for API request
			else
				$this->b_consignor->setFormValue($val);
		}

		// Check field name 'b_consignee' first before field var 'x_b_consignee'
		$val = $CurrentForm->hasValue("b_consignee") ? $CurrentForm->getValue("b_consignee") : $CurrentForm->getValue("x_b_consignee");
		if (!$this->b_consignee->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_consignee->Visible = FALSE; // Disable update for API request
			else
				$this->b_consignee->setFormValue($val);
		}

		// Check field name 'load_date' first before field var 'x_load_date'
		$val = $CurrentForm->hasValue("load_date") ? $CurrentForm->getValue("load_date") : $CurrentForm->getValue("x_load_date");
		if (!$this->load_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->load_date->Visible = FALSE; // Disable update for API request
			else
				$this->load_date->setFormValue($val);
			$this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, 1);
		}

		// Check field name 'load_weight' first before field var 'x_load_weight'
		$val = $CurrentForm->hasValue("load_weight") ? $CurrentForm->getValue("load_weight") : $CurrentForm->getValue("x_load_weight");
		if (!$this->load_weight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->load_weight->Visible = FALSE; // Disable update for API request
			else
				$this->load_weight->setFormValue($val);
		}

		// Check field name 'driver' first before field var 'x_driver'
		$val = $CurrentForm->hasValue("driver") ? $CurrentForm->getValue("driver") : $CurrentForm->getValue("x_driver");
		if (!$this->driver->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->driver->Visible = FALSE; // Disable update for API request
			else
				$this->driver->setFormValue($val);
		}

		// Check field name 'driver_name' first before field var 'x_driver_name'
		$val = $CurrentForm->hasValue("driver_name") ? $CurrentForm->getValue("driver_name") : $CurrentForm->getValue("x_driver_name");
		if (!$this->driver_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->driver_name->Visible = FALSE; // Disable update for API request
			else
				$this->driver_name->setFormValue($val);
		}

		// Check field name 'agent' first before field var 'x_agent'
		$val = $CurrentForm->hasValue("agent") ? $CurrentForm->getValue("agent") : $CurrentForm->getValue("x_agent");
		if (!$this->agent->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->agent->Visible = FALSE; // Disable update for API request
			else
				$this->agent->setFormValue($val);
		}

		// Check field name 'comm' first before field var 'x_comm'
		$val = $CurrentForm->hasValue("comm") ? $CurrentForm->getValue("comm") : $CurrentForm->getValue("x_comm");
		if (!$this->comm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->comm->Visible = FALSE; // Disable update for API request
			else
				$this->comm->setFormValue($val);
		}

		// Check field name 'material' first before field var 'x_material'
		$val = $CurrentForm->hasValue("material") ? $CurrentForm->getValue("material") : $CurrentForm->getValue("x_material");
		if (!$this->material->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->material->Visible = FALSE; // Disable update for API request
			else
				$this->material->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'm_hsn' first before field var 'x_m_hsn'
		$val = $CurrentForm->hasValue("m_hsn") ? $CurrentForm->getValue("m_hsn") : $CurrentForm->getValue("x_m_hsn");
		if (!$this->m_hsn->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_hsn->Visible = FALSE; // Disable update for API request
			else
				$this->m_hsn->setFormValue($val);
		}

		// Check field name '@' first before field var 'x__40'
		$val = $CurrentForm->hasValue("@") ? $CurrentForm->getValue("@") : $CurrentForm->getValue("x__40");
		if (!$this->_40->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_40->Visible = FALSE; // Disable update for API request
			else
				$this->_40->setFormValue($val);
		}

		// Check field name 'freight_type' first before field var 'x_freight_type'
		$val = $CurrentForm->hasValue("freight_type") ? $CurrentForm->getValue("freight_type") : $CurrentForm->getValue("x_freight_type");
		if (!$this->freight_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->freight_type->Visible = FALSE; // Disable update for API request
			else
				$this->freight_type->setFormValue($val);
		}

		// Check field name 'freight' first before field var 'x_freight'
		$val = $CurrentForm->hasValue("freight") ? $CurrentForm->getValue("freight") : $CurrentForm->getValue("x_freight");
		if (!$this->freight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->freight->Visible = FALSE; // Disable update for API request
			else
				$this->freight->setFormValue($val);
		}

		// Check field name 'gst_percent' first before field var 'x_gst_percent'
		$val = $CurrentForm->hasValue("gst_percent") ? $CurrentForm->getValue("gst_percent") : $CurrentForm->getValue("x_gst_percent");
		if (!$this->gst_percent->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gst_percent->Visible = FALSE; // Disable update for API request
			else
				$this->gst_percent->setFormValue($val);
		}

		// Check field name 'load_km' first before field var 'x_load_km'
		$val = $CurrentForm->hasValue("load_km") ? $CurrentForm->getValue("load_km") : $CurrentForm->getValue("x_load_km");
		if (!$this->load_km->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->load_km->Visible = FALSE; // Disable update for API request
			else
				$this->load_km->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'consignor' first before field var 'x_consignor'
		$val = $CurrentForm->hasValue("consignor") ? $CurrentForm->getValue("consignor") : $CurrentForm->getValue("x_consignor");
		if (!$this->consignor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->consignor->Visible = FALSE; // Disable update for API request
			else
				$this->consignor->setFormValue($val);
		}

		// Check field name 'vehicle_freight_comm' first before field var 'x_vehicle_freight_comm'
		$val = $CurrentForm->hasValue("vehicle_freight_comm") ? $CurrentForm->getValue("vehicle_freight_comm") : $CurrentForm->getValue("x_vehicle_freight_comm");
		if (!$this->vehicle_freight_comm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_freight_comm->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_freight_comm->setFormValue($val);
		}

		// Check field name 'vehicle_freight_type' first before field var 'x_vehicle_freight_type'
		$val = $CurrentForm->hasValue("vehicle_freight_type") ? $CurrentForm->getValue("vehicle_freight_type") : $CurrentForm->getValue("x_vehicle_freight_type");
		if (!$this->vehicle_freight_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_freight_type->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_freight_type->setFormValue($val);
		}

		// Check field name 'vehicle_freight_amount' first before field var 'x_vehicle_freight_amount'
		$val = $CurrentForm->hasValue("vehicle_freight_amount") ? $CurrentForm->getValue("vehicle_freight_amount") : $CurrentForm->getValue("x_vehicle_freight_amount");
		if (!$this->vehicle_freight_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_freight_amount->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_freight_amount->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->vehicle_type->CurrentValue = $this->vehicle_type->FormValue;
		$this->vehicle->CurrentValue = $this->vehicle->FormValue;
		$this->_route->CurrentValue = $this->_route->FormValue;
		$this->reports_to->CurrentValue = $this->reports_to->FormValue;
		$this->buyer->CurrentValue = $this->buyer->FormValue;
		$this->b_consignor->CurrentValue = $this->b_consignor->FormValue;
		$this->b_consignee->CurrentValue = $this->b_consignee->FormValue;
		$this->load_date->CurrentValue = $this->load_date->FormValue;
		$this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, 1);
		$this->load_weight->CurrentValue = $this->load_weight->FormValue;
		$this->driver->CurrentValue = $this->driver->FormValue;
		$this->driver_name->CurrentValue = $this->driver_name->FormValue;
		$this->agent->CurrentValue = $this->agent->FormValue;
		$this->comm->CurrentValue = $this->comm->FormValue;
		$this->material->CurrentValue = $this->material->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->m_hsn->CurrentValue = $this->m_hsn->FormValue;
		$this->_40->CurrentValue = $this->_40->FormValue;
		$this->freight_type->CurrentValue = $this->freight_type->FormValue;
		$this->freight->CurrentValue = $this->freight->FormValue;
		$this->gst_percent->CurrentValue = $this->gst_percent->FormValue;
		$this->load_km->CurrentValue = $this->load_km->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->consignor->CurrentValue = $this->consignor->FormValue;
		$this->vehicle_freight_comm->CurrentValue = $this->vehicle_freight_comm->FormValue;
		$this->vehicle_freight_type->CurrentValue = $this->vehicle_freight_type->FormValue;
		$this->vehicle_freight_amount->CurrentValue = $this->vehicle_freight_amount->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->vehicle_type->setDbValue($row['vehicle_type']);
		$this->vehicle->setDbValue($row['vehicle']);
		$this->_route->setDbValue($row['route']);
		$this->route_name->setDbValue($row['route_name']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->buyer->setDbValue($row['buyer']);
		$this->b_consignor->setDbValue($row['b_consignor']);
		$this->b_consignee->setDbValue($row['b_consignee']);
		$this->load_date->setDbValue($row['load_date']);
		$this->load_weight->setDbValue($row['load_weight']);
		$this->unload_date->setDbValue($row['unload_date']);
		$this->unload_weight->setDbValue($row['unload_weight']);
		$this->invoice_no->setDbValue($row['invoice_no']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->amount->setDbValue($row['amount']);
		$this->delivery_pod->setDbValue($row['delivery_pod']);
		$this->status->setDbValue($row['status']);
		$this->days->setDbValue($row['days']);
		$this->driver->setDbValue($row['driver']);
		$this->driver_name->setDbValue($row['driver_name']);
		$this->agent->setDbValue($row['agent']);
		if (array_key_exists('EV__agent', $rs->fields)) {
			$this->agent->VirtualValue = $rs->fields('EV__agent'); // Set up virtual field value
		} else {
			$this->agent->VirtualValue = ""; // Clear value
		}
		$this->comm->setDbValue($row['comm']);
		$this->material->setDbValue($row['material']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->m_hsn->setDbValue($row['m_hsn']);
		$this->_40->setDbValue($row['@']);
		$this->lr_no->setDbValue($row['lr_no']);
		$this->km->setDbValue($row['km']);
		$this->freight_type->setDbValue($row['freight_type']);
		$this->freight->setDbValue($row['freight']);
		$this->ded_det->setDbValue($row['ded_det']);
		$this->ded_det_remarks->setDbValue($row['ded_det_remarks']);
		$this->gst_percent->setDbValue($row['gst_percent']);
		$this->gst_amount->setDbValue($row['gst_amount']);
		$this->final_amount->setDbValue($row['final_amount']);
		$this->load_km->setDbValue($row['load_km']);
		$this->unload_km->setDbValue($row['unload_km']);
		$this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
		$this->delivery_receipt->setDbValue($this->delivery_receipt->Upload->DbValue);
		$this->delivery_docket->setDbValue($row['delivery_docket']);
		$this->diesal_op_b->setDbValue($row['diesal_op_b']);
		$this->diesal_required->setDbValue($row['diesal_required']);
		$this->diesal_fill->setDbValue($row['diesal_fill']);
		$this->diesal_amount->setDbValue($row['diesal_amount']);
		$this->diesal_cl_balance->setDbValue($row['diesal_cl_balance']);
		$this->vehicle_average->setDbValue($row['vehicle_average']);
		$this->cash_required->setDbValue($row['cash_required']);
		$this->cash_op_b->setDbValue($row['cash_op_b']);
		$this->cash_paid->setDbValue($row['cash_paid']);
		$this->cash_expenses->setDbValue($row['cash_expenses']);
		$this->cash_cl_balance->setDbValue($row['cash_cl_balance']);
		$this->fasttag_op_b->setDbValue($row['fasttag_op_b']);
		$this->fasttag_recharge->setDbValue($row['fasttag_recharge']);
		$this->fasttag_expenses->setDbValue($row['fasttag_expenses']);
		$this->toll_expenses_cash->setDbValue($row['toll_expenses_cash']);
		$this->fasttag_cl_balance->setDbValue($row['fasttag_cl_balance']);
		$this->remarks->setDbValue($row['remarks']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->consignor->setDbValue($row['consignor']);
		$this->vehicle_freight_comm->setDbValue($row['vehicle_freight_comm']);
		$this->vehicle_freight_type->setDbValue($row['vehicle_freight_type']);
		$this->vehicle_freight_amount->setDbValue($row['vehicle_freight_amount']);
		$this->vehicle_freight_final->setDbValue($row['vehicle_freight_final']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->expenses_id->setDbValue($row['expenses_id']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$this->loadDefaultValues();
		$row = [];
		$row['id'] = $this->id->CurrentValue;
		$row['vehicle_type'] = $this->vehicle_type->CurrentValue;
		$row['vehicle'] = $this->vehicle->CurrentValue;
		$row['route'] = $this->_route->CurrentValue;
		$row['route_name'] = $this->route_name->CurrentValue;
		$row['reports_to'] = $this->reports_to->CurrentValue;
		$row['buyer'] = $this->buyer->CurrentValue;
		$row['b_consignor'] = $this->b_consignor->CurrentValue;
		$row['b_consignee'] = $this->b_consignee->CurrentValue;
		$row['load_date'] = $this->load_date->CurrentValue;
		$row['load_weight'] = $this->load_weight->CurrentValue;
		$row['unload_date'] = $this->unload_date->CurrentValue;
		$row['unload_weight'] = $this->unload_weight->CurrentValue;
		$row['invoice_no'] = $this->invoice_no->CurrentValue;
		$row['invoice_date'] = $this->invoice_date->CurrentValue;
		$row['amount'] = $this->amount->CurrentValue;
		$row['delivery_pod'] = $this->delivery_pod->CurrentValue;
		$row['status'] = $this->status->CurrentValue;
		$row['days'] = $this->days->CurrentValue;
		$row['driver'] = $this->driver->CurrentValue;
		$row['driver_name'] = $this->driver_name->CurrentValue;
		$row['agent'] = $this->agent->CurrentValue;
		$row['comm'] = $this->comm->CurrentValue;
		$row['material'] = $this->material->CurrentValue;
		$row['packing_type'] = $this->packing_type->CurrentValue;
		$row['m_hsn'] = $this->m_hsn->CurrentValue;
		$row['@'] = $this->_40->CurrentValue;
		$row['lr_no'] = $this->lr_no->CurrentValue;
		$row['km'] = $this->km->CurrentValue;
		$row['freight_type'] = $this->freight_type->CurrentValue;
		$row['freight'] = $this->freight->CurrentValue;
		$row['ded_det'] = $this->ded_det->CurrentValue;
		$row['ded_det_remarks'] = $this->ded_det_remarks->CurrentValue;
		$row['gst_percent'] = $this->gst_percent->CurrentValue;
		$row['gst_amount'] = $this->gst_amount->CurrentValue;
		$row['final_amount'] = $this->final_amount->CurrentValue;
		$row['load_km'] = $this->load_km->CurrentValue;
		$row['unload_km'] = $this->unload_km->CurrentValue;
		$row['delivery_receipt'] = $this->delivery_receipt->Upload->DbValue;
		$row['delivery_docket'] = $this->delivery_docket->CurrentValue;
		$row['diesal_op_b'] = $this->diesal_op_b->CurrentValue;
		$row['diesal_required'] = $this->diesal_required->CurrentValue;
		$row['diesal_fill'] = $this->diesal_fill->CurrentValue;
		$row['diesal_amount'] = $this->diesal_amount->CurrentValue;
		$row['diesal_cl_balance'] = $this->diesal_cl_balance->CurrentValue;
		$row['vehicle_average'] = $this->vehicle_average->CurrentValue;
		$row['cash_required'] = $this->cash_required->CurrentValue;
		$row['cash_op_b'] = $this->cash_op_b->CurrentValue;
		$row['cash_paid'] = $this->cash_paid->CurrentValue;
		$row['cash_expenses'] = $this->cash_expenses->CurrentValue;
		$row['cash_cl_balance'] = $this->cash_cl_balance->CurrentValue;
		$row['fasttag_op_b'] = $this->fasttag_op_b->CurrentValue;
		$row['fasttag_recharge'] = $this->fasttag_recharge->CurrentValue;
		$row['fasttag_expenses'] = $this->fasttag_expenses->CurrentValue;
		$row['toll_expenses_cash'] = $this->toll_expenses_cash->CurrentValue;
		$row['fasttag_cl_balance'] = $this->fasttag_cl_balance->CurrentValue;
		$row['remarks'] = $this->remarks->CurrentValue;
		$row['uploads'] = $this->uploads->Upload->DbValue;
		$row['consignor'] = $this->consignor->CurrentValue;
		$row['vehicle_freight_comm'] = $this->vehicle_freight_comm->CurrentValue;
		$row['vehicle_freight_type'] = $this->vehicle_freight_type->CurrentValue;
		$row['vehicle_freight_amount'] = $this->vehicle_freight_amount->CurrentValue;
		$row['vehicle_freight_final'] = $this->vehicle_freight_final->CurrentValue;
		$row['operator'] = $this->operator->CurrentValue;
		$row['datetime'] = $this->datetime->CurrentValue;
		$row['expenses_id'] = $this->expenses_id->CurrentValue;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->comm->FormValue == $this->comm->CurrentValue && is_numeric(ConvertToFloatString($this->comm->CurrentValue)))
			$this->comm->CurrentValue = ConvertToFloatString($this->comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_40->FormValue == $this->_40->CurrentValue && is_numeric(ConvertToFloatString($this->_40->CurrentValue)))
			$this->_40->CurrentValue = ConvertToFloatString($this->_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->freight->FormValue == $this->freight->CurrentValue && is_numeric(ConvertToFloatString($this->freight->CurrentValue)))
			$this->freight->CurrentValue = ConvertToFloatString($this->freight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gst_percent->FormValue == $this->gst_percent->CurrentValue && is_numeric(ConvertToFloatString($this->gst_percent->CurrentValue)))
			$this->gst_percent->CurrentValue = ConvertToFloatString($this->gst_percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_comm->FormValue == $this->vehicle_freight_comm->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_comm->CurrentValue)))
			$this->vehicle_freight_comm->CurrentValue = ConvertToFloatString($this->vehicle_freight_comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_amount->FormValue == $this->vehicle_freight_amount->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_amount->CurrentValue)))
			$this->vehicle_freight_amount->CurrentValue = ConvertToFloatString($this->vehicle_freight_amount->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// vehicle_type
		// vehicle
		// route
		// route_name
		// reports_to
		// buyer
		// b_consignor
		// b_consignee
		// load_date
		// load_weight
		// unload_date
		// unload_weight
		// invoice_no
		// invoice_date
		// amount
		// delivery_pod
		// status
		// days
		// driver
		// driver_name
		// agent
		// comm
		// material
		// packing_type
		// m_hsn
		// @
		// lr_no
		// km
		// freight_type
		// freight
		// ded_det
		// ded_det_remarks
		// gst_percent
		// gst_amount
		// final_amount
		// load_km
		// unload_km
		// delivery_receipt
		// delivery_docket
		// diesal_op_b
		// diesal_required
		// diesal_fill
		// diesal_amount
		// diesal_cl_balance
		// vehicle_average
		// cash_required
		// cash_op_b
		// cash_paid
		// cash_expenses
		// cash_cl_balance
		// fasttag_op_b
		// fasttag_recharge
		// fasttag_expenses
		// toll_expenses_cash
		// fasttag_cl_balance
		// remarks
		// uploads
		// consignor
		// vehicle_freight_comm
		// vehicle_freight_type
		// vehicle_freight_amount
		// vehicle_freight_final
		// operator
		// datetime
		// expenses_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// vehicle_type
			if (strval($this->vehicle_type->CurrentValue) <> "") {
				$this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
			} else {
				$this->vehicle_type->ViewValue = NULL;
			}
			$this->vehicle_type->ViewCustomAttributes = "";

			// vehicle
			$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
			$curVal = strval($this->vehicle->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
					}
				}
			} else {
				$this->vehicle->ViewValue = NULL;
			}
			$this->vehicle->ViewCustomAttributes = "";

			// route
			$this->_route->ViewValue = $this->_route->CurrentValue;
			$curVal = strval($this->_route->CurrentValue);
			if ($curVal <> "") {
				$this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
				if ($this->_route->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->_route->ViewValue = $this->_route->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_route->ViewValue = $this->_route->CurrentValue;
					}
				}
			} else {
				$this->_route->ViewValue = NULL;
			}
			$this->_route->ViewCustomAttributes = "";

			// route_name
			$this->route_name->ViewValue = $this->route_name->CurrentValue;
			$this->route_name->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// buyer
			$this->buyer->ViewValue = $this->buyer->CurrentValue;
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->ViewValue = $this->buyer->CurrentValue;
					}
				}
			} else {
				$this->buyer->ViewValue = NULL;
			}
			$this->buyer->ViewCustomAttributes = "";

			// b_consignor
			$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
			$curVal = strval($this->b_consignor->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
				if ($this->b_consignor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
					}
				}
			} else {
				$this->b_consignor->ViewValue = NULL;
			}
			$this->b_consignor->ViewCustomAttributes = "";

			// b_consignee
			$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
			$curVal = strval($this->b_consignee->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
				if ($this->b_consignee->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
					}
				}
			} else {
				$this->b_consignee->ViewValue = NULL;
			}
			$this->b_consignee->ViewCustomAttributes = "";

			// load_date
			$this->load_date->ViewValue = $this->load_date->CurrentValue;
			$this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, 1);
			$this->load_date->ViewCustomAttributes = "";

			// load_weight
			$this->load_weight->ViewValue = $this->load_weight->CurrentValue;
			$this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, 0, -2, -2, -2);
			$this->load_weight->ViewCustomAttributes = "";

			// unload_date
			$this->unload_date->ViewValue = $this->unload_date->CurrentValue;
			$this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, 0);
			$this->unload_date->ViewCustomAttributes = "";

			// unload_weight
			$this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
			$this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, 0, -2, -2, -2);
			$this->unload_weight->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewValue = FormatNumber($this->invoice_no->ViewValue, 0, -2, -2, -2);
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// delivery_pod
			if (strval($this->delivery_pod->CurrentValue) <> "") {
				$this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
			} else {
				$this->delivery_pod->ViewValue = NULL;
			}
			$this->delivery_pod->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// days
			$this->days->ViewValue = $this->days->CurrentValue;
			$this->days->ViewValue = FormatNumber($this->days->ViewValue, 0, -2, -2, -2);
			$this->days->ViewCustomAttributes = "";

			// driver
			$curVal = strval($this->driver->CurrentValue);
			if ($curVal <> "") {
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
				if ($this->driver->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->driver->ViewValue = $this->driver->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->driver->ViewValue = $this->driver->CurrentValue;
					}
				}
			} else {
				$this->driver->ViewValue = NULL;
			}
			$this->driver->ViewCustomAttributes = "";

			// driver_name
			$this->driver_name->ViewValue = $this->driver_name->CurrentValue;
			$this->driver_name->ViewCustomAttributes = "";

			// agent
			if ($this->agent->VirtualValue <> "") {
				$this->agent->ViewValue = $this->agent->VirtualValue;
			} else {
				$this->agent->ViewValue = $this->agent->CurrentValue;
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->agent->ViewValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->ViewValue = $this->agent->CurrentValue;
					}
				}
			} else {
				$this->agent->ViewValue = NULL;
			}
			}
			$this->agent->ViewCustomAttributes = "";

			// comm
			$this->comm->ViewValue = $this->comm->CurrentValue;
			$this->comm->ViewValue = FormatNumber($this->comm->ViewValue, 2, -2, -2, -2);
			$this->comm->ViewCustomAttributes = "";

			// material
			$this->material->ViewValue = $this->material->CurrentValue;
			$this->material->ViewCustomAttributes = "";

			// packing_type
			$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
			$this->packing_type->ViewCustomAttributes = "";

			// m_hsn
			$this->m_hsn->ViewValue = $this->m_hsn->CurrentValue;
			$this->m_hsn->ViewCustomAttributes = "";

			// @
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 2, -2, -2, -2);
			$this->_40->ViewCustomAttributes = "";

			// lr_no
			$this->lr_no->ViewValue = $this->lr_no->CurrentValue;
			$this->lr_no->ViewCustomAttributes = "";

			// km
			$this->km->ViewValue = $this->km->CurrentValue;
			$this->km->ViewValue = FormatNumber($this->km->ViewValue, 2, -2, -2, -2);
			$this->km->ViewCustomAttributes = "";

			// freight_type
			if (strval($this->freight_type->CurrentValue) <> "") {
				$this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
			} else {
				$this->freight_type->ViewValue = NULL;
			}
			$this->freight_type->ViewCustomAttributes = "";

			// freight
			$this->freight->ViewValue = $this->freight->CurrentValue;
			$this->freight->ViewValue = FormatNumber($this->freight->ViewValue, 2, -2, -2, -2);
			$this->freight->ViewCustomAttributes = "";

			// ded_det
			$this->ded_det->ViewValue = $this->ded_det->CurrentValue;
			$this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, 2, -2, -2, -2);
			$this->ded_det->ViewCustomAttributes = "";

			// ded_det_remarks
			$this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;
			$this->ded_det_remarks->ViewCustomAttributes = "";

			// gst_percent
			$this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
			$this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, 2, -2, -2, -2);
			$this->gst_percent->ViewCustomAttributes = "";

			// gst_amount
			$this->gst_amount->ViewValue = $this->gst_amount->CurrentValue;
			$this->gst_amount->ViewValue = FormatNumber($this->gst_amount->ViewValue, 2, -2, -2, -2);
			$this->gst_amount->ViewCustomAttributes = "";

			// final_amount
			$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
			$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";

			// load_km
			$this->load_km->ViewValue = $this->load_km->CurrentValue;
			$this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, 0, -2, -2, -2);
			$this->load_km->ViewCustomAttributes = "";

			// unload_km
			$this->unload_km->ViewValue = $this->unload_km->CurrentValue;
			$this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, 0, -2, -2, -2);
			$this->unload_km->ViewCustomAttributes = "";

			// delivery_receipt
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->ImageWidth = 0;
				$this->delivery_receipt->ImageHeight = 50;
				$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
				$this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
			} else {
				$this->delivery_receipt->ViewValue = "";
			}
			$this->delivery_receipt->ViewCustomAttributes = "";

			// delivery_docket
			$this->delivery_docket->ViewValue = $this->delivery_docket->CurrentValue;
			$this->delivery_docket->ViewCustomAttributes = "";

			// diesal_op_b
			$this->diesal_op_b->ViewValue = $this->diesal_op_b->CurrentValue;
			$this->diesal_op_b->ViewValue = FormatNumber($this->diesal_op_b->ViewValue, 2, -2, -2, -2);
			$this->diesal_op_b->ViewCustomAttributes = "";

			// diesal_required
			$this->diesal_required->ViewValue = $this->diesal_required->CurrentValue;
			$this->diesal_required->ViewValue = FormatNumber($this->diesal_required->ViewValue, 2, -2, -2, -2);
			$this->diesal_required->ViewCustomAttributes = "";

			// diesal_fill
			$this->diesal_fill->ViewValue = $this->diesal_fill->CurrentValue;
			$this->diesal_fill->ViewValue = FormatNumber($this->diesal_fill->ViewValue, 2, -2, -2, -2);
			$this->diesal_fill->ViewCustomAttributes = "";

			// diesal_amount
			$this->diesal_amount->ViewValue = $this->diesal_amount->CurrentValue;
			$this->diesal_amount->ViewValue = FormatNumber($this->diesal_amount->ViewValue, 2, -2, -2, -2);
			$this->diesal_amount->ViewCustomAttributes = "";

			// diesal_cl_balance
			$this->diesal_cl_balance->ViewValue = $this->diesal_cl_balance->CurrentValue;
			$this->diesal_cl_balance->ViewValue = FormatNumber($this->diesal_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->diesal_cl_balance->ViewCustomAttributes = "";

			// vehicle_average
			$this->vehicle_average->ViewValue = $this->vehicle_average->CurrentValue;
			$this->vehicle_average->ViewValue = FormatNumber($this->vehicle_average->ViewValue, 2, -2, -2, -2);
			$this->vehicle_average->ViewCustomAttributes = "";

			// cash_required
			$this->cash_required->ViewValue = $this->cash_required->CurrentValue;
			$this->cash_required->ViewValue = FormatNumber($this->cash_required->ViewValue, 2, -2, -2, -2);
			$this->cash_required->ViewCustomAttributes = "";

			// cash_op_b
			$this->cash_op_b->ViewValue = $this->cash_op_b->CurrentValue;
			$this->cash_op_b->ViewValue = FormatNumber($this->cash_op_b->ViewValue, 2, -2, -2, -2);
			$this->cash_op_b->ViewCustomAttributes = "";

			// cash_paid
			$this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
			$this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, 2, -2, -2, -2);
			$this->cash_paid->ViewCustomAttributes = "";

			// cash_expenses
			$this->cash_expenses->ViewValue = $this->cash_expenses->CurrentValue;
			$this->cash_expenses->ViewValue = FormatNumber($this->cash_expenses->ViewValue, 2, -2, -2, -2);
			$this->cash_expenses->ViewCustomAttributes = "";

			// cash_cl_balance
			$this->cash_cl_balance->ViewValue = $this->cash_cl_balance->CurrentValue;
			$this->cash_cl_balance->ViewValue = FormatNumber($this->cash_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->cash_cl_balance->ViewCustomAttributes = "";

			// fasttag_op_b
			$this->fasttag_op_b->ViewValue = $this->fasttag_op_b->CurrentValue;
			$this->fasttag_op_b->ViewValue = FormatNumber($this->fasttag_op_b->ViewValue, 2, -2, -2, -2);
			$this->fasttag_op_b->ViewCustomAttributes = "";

			// fasttag_recharge
			$this->fasttag_recharge->ViewValue = $this->fasttag_recharge->CurrentValue;
			$this->fasttag_recharge->ViewValue = FormatNumber($this->fasttag_recharge->ViewValue, 2, -2, -2, -2);
			$this->fasttag_recharge->ViewCustomAttributes = "";

			// fasttag_expenses
			$this->fasttag_expenses->ViewValue = $this->fasttag_expenses->CurrentValue;
			$this->fasttag_expenses->ViewValue = FormatNumber($this->fasttag_expenses->ViewValue, 2, -2, -2, -2);
			$this->fasttag_expenses->ViewCustomAttributes = "";

			// toll_expenses_cash
			$this->toll_expenses_cash->ViewValue = $this->toll_expenses_cash->CurrentValue;
			$this->toll_expenses_cash->ViewValue = FormatNumber($this->toll_expenses_cash->ViewValue, 2, -2, -2, -2);
			$this->toll_expenses_cash->ViewCustomAttributes = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
			$this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->fasttag_cl_balance->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// consignor
			$this->consignor->ViewValue = $this->consignor->CurrentValue;
			$curVal = strval($this->consignor->CurrentValue);
			if ($curVal <> "") {
				$this->consignor->ViewValue = $this->consignor->lookupCacheOption($curVal);
				if ($this->consignor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->consignor->ViewValue = $this->consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignor->ViewValue = $this->consignor->CurrentValue;
					}
				}
			} else {
				$this->consignor->ViewValue = NULL;
			}
			$this->consignor->ViewCustomAttributes = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
			$this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_comm->ViewCustomAttributes = "";

			// vehicle_freight_type
			if (strval($this->vehicle_freight_type->CurrentValue) <> "") {
				$this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
			} else {
				$this->vehicle_freight_type->ViewValue = NULL;
			}
			$this->vehicle_freight_type->ViewCustomAttributes = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
			$this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_amount->ViewCustomAttributes = "";

			// vehicle_freight_final
			$this->vehicle_freight_final->ViewValue = $this->vehicle_freight_final->CurrentValue;
			$this->vehicle_freight_final->ViewValue = FormatNumber($this->vehicle_freight_final->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_final->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// vehicle_type
			$this->vehicle_type->LinkCustomAttributes = "";
			$this->vehicle_type->HrefValue = "";
			$this->vehicle_type->TooltipValue = "";

			// vehicle
			$this->vehicle->LinkCustomAttributes = "";
			$this->vehicle->HrefValue = "";
			$this->vehicle->TooltipValue = "";

			// route
			$this->_route->LinkCustomAttributes = "";
			$this->_route->HrefValue = "";
			$this->_route->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			$this->buyer->HrefValue = "";
			$this->buyer->TooltipValue = "";

			// b_consignor
			$this->b_consignor->LinkCustomAttributes = "";
			$this->b_consignor->HrefValue = "";
			$this->b_consignor->TooltipValue = "";

			// b_consignee
			$this->b_consignee->LinkCustomAttributes = "";
			$this->b_consignee->HrefValue = "";
			$this->b_consignee->TooltipValue = "";

			// load_date
			$this->load_date->LinkCustomAttributes = "";
			$this->load_date->HrefValue = "";
			$this->load_date->TooltipValue = "";

			// load_weight
			$this->load_weight->LinkCustomAttributes = "";
			$this->load_weight->HrefValue = "";
			$this->load_weight->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";
			$this->driver->TooltipValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";
			$this->driver_name->TooltipValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";
			$this->agent->TooltipValue = "";

			// comm
			$this->comm->LinkCustomAttributes = "";
			$this->comm->HrefValue = "";
			$this->comm->TooltipValue = "";

			// material
			$this->material->LinkCustomAttributes = "";
			$this->material->HrefValue = "";
			$this->material->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// m_hsn
			$this->m_hsn->LinkCustomAttributes = "";
			$this->m_hsn->HrefValue = "";
			$this->m_hsn->TooltipValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// freight_type
			$this->freight_type->LinkCustomAttributes = "";
			$this->freight_type->HrefValue = "";
			$this->freight_type->TooltipValue = "";

			// freight
			$this->freight->LinkCustomAttributes = "";
			$this->freight->HrefValue = "";
			$this->freight->TooltipValue = "";

			// gst_percent
			$this->gst_percent->LinkCustomAttributes = "";
			$this->gst_percent->HrefValue = "";
			$this->gst_percent->TooltipValue = "";

			// load_km
			$this->load_km->LinkCustomAttributes = "";
			$this->load_km->HrefValue = "";
			$this->load_km->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// consignor
			$this->consignor->LinkCustomAttributes = "";
			$this->consignor->HrefValue = "";
			$this->consignor->TooltipValue = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->LinkCustomAttributes = "";
			$this->vehicle_freight_comm->HrefValue = "";
			$this->vehicle_freight_comm->TooltipValue = "";

			// vehicle_freight_type
			$this->vehicle_freight_type->LinkCustomAttributes = "";
			$this->vehicle_freight_type->HrefValue = "";
			$this->vehicle_freight_type->TooltipValue = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->LinkCustomAttributes = "";
			$this->vehicle_freight_amount->HrefValue = "";
			$this->vehicle_freight_amount->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_ADD) { // Add row

			// vehicle_type
			$this->vehicle_type->EditAttrs["class"] = "form-control";
			$this->vehicle_type->EditCustomAttributes = "";
			$this->vehicle_type->EditValue = $this->vehicle_type->options(TRUE);

			// vehicle
			$this->vehicle->EditAttrs["class"] = "form-control";
			$this->vehicle->EditCustomAttributes = "";
			$this->vehicle->EditValue = HtmlEncode($this->vehicle->CurrentValue);
			$curVal = strval($this->vehicle->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->EditValue = HtmlEncode($this->vehicle->CurrentValue);
					}
				}
			} else {
				$this->vehicle->EditValue = NULL;
			}
			$this->vehicle->PlaceHolder = RemoveHtml($this->vehicle->caption());

			// route
			$this->_route->EditAttrs["class"] = "form-control";
			$this->_route->EditCustomAttributes = "";
			$this->_route->EditValue = HtmlEncode($this->_route->CurrentValue);
			$curVal = strval($this->_route->CurrentValue);
			if ($curVal <> "") {
				$this->_route->EditValue = $this->_route->lookupCacheOption($curVal);
				if ($this->_route->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->_route->EditValue = $this->_route->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_route->EditValue = HtmlEncode($this->_route->CurrentValue);
					}
				}
			} else {
				$this->_route->EditValue = NULL;
			}
			$this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->reports_to->CurrentValue));
			if ($curVal <> "")
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			else
				$this->reports_to->ViewValue = $this->reports_to->Lookup !== NULL && is_array($this->reports_to->Lookup->Options) ? $curVal : NULL;
			if ($this->reports_to->ViewValue !== NULL) { // Load from cache
				$this->reports_to->EditValue = array_values($this->reports_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->reports_to->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`activated`=1 and `userlevel`=1003";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->reports_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->reports_to->EditValue = $arwrk;
			}

			// buyer
			$this->buyer->EditAttrs["class"] = "form-control";
			$this->buyer->EditCustomAttributes = "";
			$this->buyer->EditValue = HtmlEncode($this->buyer->CurrentValue);
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->EditValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->buyer->EditValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->EditValue = HtmlEncode($this->buyer->CurrentValue);
					}
				}
			} else {
				$this->buyer->EditValue = NULL;
			}
			$this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

			// b_consignor
			$this->b_consignor->EditAttrs["class"] = "form-control";
			$this->b_consignor->EditCustomAttributes = "";
			$this->b_consignor->EditValue = HtmlEncode($this->b_consignor->CurrentValue);
			$curVal = strval($this->b_consignor->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignor->EditValue = $this->b_consignor->lookupCacheOption($curVal);
				if ($this->b_consignor->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->b_consignor->EditValue = $this->b_consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignor->EditValue = HtmlEncode($this->b_consignor->CurrentValue);
					}
				}
			} else {
				$this->b_consignor->EditValue = NULL;
			}
			$this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());

			// b_consignee
			$this->b_consignee->EditAttrs["class"] = "form-control";
			$this->b_consignee->EditCustomAttributes = "";
			$this->b_consignee->EditValue = HtmlEncode($this->b_consignee->CurrentValue);
			$curVal = strval($this->b_consignee->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignee->EditValue = $this->b_consignee->lookupCacheOption($curVal);
				if ($this->b_consignee->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->b_consignee->EditValue = $this->b_consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignee->EditValue = HtmlEncode($this->b_consignee->CurrentValue);
					}
				}
			} else {
				$this->b_consignee->EditValue = NULL;
			}
			$this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());

			// load_date
			$this->load_date->EditAttrs["class"] = "form-control";
			$this->load_date->EditCustomAttributes = "";
			$this->load_date->EditValue = HtmlEncode(FormatDateTime($this->load_date->CurrentValue, 8));
			$this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

			// load_weight
			$this->load_weight->EditAttrs["class"] = "form-control";
			$this->load_weight->EditCustomAttributes = "";
			$this->load_weight->EditValue = HtmlEncode($this->load_weight->CurrentValue);
			$this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());

			// driver
			$this->driver->EditAttrs["class"] = "form-control";
			$this->driver->EditCustomAttributes = "";
			$curVal = trim(strval($this->driver->CurrentValue));
			if ($curVal <> "")
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
			else
				$this->driver->ViewValue = $this->driver->Lookup !== NULL && is_array($this->driver->Lookup->Options) ? $curVal : NULL;
			if ($this->driver->ViewValue !== NULL) { // Load from cache
				$this->driver->EditValue = array_values($this->driver->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->driver->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->driver->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->driver->EditValue = $arwrk;
			}

			// driver_name
			$this->driver_name->EditAttrs["class"] = "form-control";
			$this->driver_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
			$this->driver_name->EditValue = HtmlEncode($this->driver_name->CurrentValue);
			$this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

			// agent
			$this->agent->EditAttrs["class"] = "form-control";
			$this->agent->EditCustomAttributes = "";
			$this->agent->EditValue = HtmlEncode($this->agent->CurrentValue);
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->EditValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->agent->EditValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->EditValue = HtmlEncode($this->agent->CurrentValue);
					}
				}
			} else {
				$this->agent->EditValue = NULL;
			}
			$this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

			// comm
			$this->comm->EditAttrs["class"] = "form-control";
			$this->comm->EditCustomAttributes = "";
			$this->comm->EditValue = HtmlEncode($this->comm->CurrentValue);
			$this->comm->PlaceHolder = RemoveHtml($this->comm->caption());
			if (strval($this->comm->EditValue) <> "" && is_numeric($this->comm->EditValue))
				$this->comm->EditValue = FormatNumber($this->comm->EditValue, -2, -2, -2, -2);

			// material
			$this->material->EditAttrs["class"] = "form-control";
			$this->material->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->material->CurrentValue = HtmlDecode($this->material->CurrentValue);
			$this->material->EditValue = HtmlEncode($this->material->CurrentValue);
			$this->material->PlaceHolder = RemoveHtml($this->material->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->packing_type->CurrentValue = HtmlDecode($this->packing_type->CurrentValue);
			$this->packing_type->EditValue = HtmlEncode($this->packing_type->CurrentValue);
			$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

			// m_hsn
			$this->m_hsn->EditAttrs["class"] = "form-control";
			$this->m_hsn->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->m_hsn->CurrentValue = HtmlDecode($this->m_hsn->CurrentValue);
			$this->m_hsn->EditValue = HtmlEncode($this->m_hsn->CurrentValue);
			$this->m_hsn->PlaceHolder = RemoveHtml($this->m_hsn->caption());

			// @
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			$this->_40->EditValue = HtmlEncode($this->_40->CurrentValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
			if (strval($this->_40->EditValue) <> "" && is_numeric($this->_40->EditValue))
				$this->_40->EditValue = FormatNumber($this->_40->EditValue, -2, -2, -2, -2);

			// freight_type
			$this->freight_type->EditAttrs["class"] = "form-control";
			$this->freight_type->EditCustomAttributes = "";
			$this->freight_type->EditValue = $this->freight_type->options(TRUE);

			// freight
			$this->freight->EditAttrs["class"] = "form-control";
			$this->freight->EditCustomAttributes = "";
			$this->freight->EditValue = HtmlEncode($this->freight->CurrentValue);
			$this->freight->PlaceHolder = RemoveHtml($this->freight->caption());
			if (strval($this->freight->EditValue) <> "" && is_numeric($this->freight->EditValue))
				$this->freight->EditValue = FormatNumber($this->freight->EditValue, -2, -2, -2, -2);

			// gst_percent
			$this->gst_percent->EditAttrs["class"] = "form-control";
			$this->gst_percent->EditCustomAttributes = "";
			$this->gst_percent->EditValue = HtmlEncode($this->gst_percent->CurrentValue);
			$this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());
			if (strval($this->gst_percent->EditValue) <> "" && is_numeric($this->gst_percent->EditValue))
				$this->gst_percent->EditValue = FormatNumber($this->gst_percent->EditValue, -2, -2, -2, -2);

			// load_km
			$this->load_km->EditAttrs["class"] = "form-control";
			$this->load_km->EditCustomAttributes = "";
			$this->load_km->EditValue = HtmlEncode($this->load_km->CurrentValue);
			$this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// consignor
			$this->consignor->EditAttrs["class"] = "form-control";
			$this->consignor->EditCustomAttributes = 'ReadOnly';
			$this->consignor->EditValue = HtmlEncode($this->consignor->CurrentValue);
			$curVal = strval($this->consignor->CurrentValue);
			if ($curVal <> "") {
				$this->consignor->EditValue = $this->consignor->lookupCacheOption($curVal);
				if ($this->consignor->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->consignor->EditValue = $this->consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignor->EditValue = HtmlEncode($this->consignor->CurrentValue);
					}
				}
			} else {
				$this->consignor->EditValue = NULL;
			}
			$this->consignor->PlaceHolder = RemoveHtml($this->consignor->caption());

			// vehicle_freight_comm
			$this->vehicle_freight_comm->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_comm->EditCustomAttributes = "";
			$this->vehicle_freight_comm->EditValue = HtmlEncode($this->vehicle_freight_comm->CurrentValue);
			$this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());
			if (strval($this->vehicle_freight_comm->EditValue) <> "" && is_numeric($this->vehicle_freight_comm->EditValue))
				$this->vehicle_freight_comm->EditValue = FormatNumber($this->vehicle_freight_comm->EditValue, -2, -2, -2, -2);

			// vehicle_freight_type
			$this->vehicle_freight_type->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_type->EditCustomAttributes = "";
			$this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(TRUE);

			// vehicle_freight_amount
			$this->vehicle_freight_amount->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_amount->EditCustomAttributes = "";
			$this->vehicle_freight_amount->EditValue = HtmlEncode($this->vehicle_freight_amount->CurrentValue);
			$this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());
			if (strval($this->vehicle_freight_amount->EditValue) <> "" && is_numeric($this->vehicle_freight_amount->EditValue))
				$this->vehicle_freight_amount->EditValue = FormatNumber($this->vehicle_freight_amount->EditValue, -2, -2, -2, -2);

			// operator
			// datetime
			// Add refer script
			// vehicle_type

			$this->vehicle_type->LinkCustomAttributes = "";
			$this->vehicle_type->HrefValue = "";

			// vehicle
			$this->vehicle->LinkCustomAttributes = "";
			$this->vehicle->HrefValue = "";

			// route
			$this->_route->LinkCustomAttributes = "";
			$this->_route->HrefValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			$this->buyer->HrefValue = "";

			// b_consignor
			$this->b_consignor->LinkCustomAttributes = "";
			$this->b_consignor->HrefValue = "";

			// b_consignee
			$this->b_consignee->LinkCustomAttributes = "";
			$this->b_consignee->HrefValue = "";

			// load_date
			$this->load_date->LinkCustomAttributes = "";
			$this->load_date->HrefValue = "";

			// load_weight
			$this->load_weight->LinkCustomAttributes = "";
			$this->load_weight->HrefValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";

			// comm
			$this->comm->LinkCustomAttributes = "";
			$this->comm->HrefValue = "";

			// material
			$this->material->LinkCustomAttributes = "";
			$this->material->HrefValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// m_hsn
			$this->m_hsn->LinkCustomAttributes = "";
			$this->m_hsn->HrefValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";

			// freight_type
			$this->freight_type->LinkCustomAttributes = "";
			$this->freight_type->HrefValue = "";

			// freight
			$this->freight->LinkCustomAttributes = "";
			$this->freight->HrefValue = "";

			// gst_percent
			$this->gst_percent->LinkCustomAttributes = "";
			$this->gst_percent->HrefValue = "";

			// load_km
			$this->load_km->LinkCustomAttributes = "";
			$this->load_km->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// consignor
			$this->consignor->LinkCustomAttributes = "";
			$this->consignor->HrefValue = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->LinkCustomAttributes = "";
			$this->vehicle_freight_comm->HrefValue = "";

			// vehicle_freight_type
			$this->vehicle_freight_type->LinkCustomAttributes = "";
			$this->vehicle_freight_type->HrefValue = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->LinkCustomAttributes = "";
			$this->vehicle_freight_amount->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->vehicle_type->Required) {
			if (!$this->vehicle_type->IsDetailKey && $this->vehicle_type->FormValue != NULL && $this->vehicle_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_type->caption(), $this->vehicle_type->RequiredErrorMessage));
			}
		}
		if ($this->vehicle->Required) {
			if (!$this->vehicle->IsDetailKey && $this->vehicle->FormValue != NULL && $this->vehicle->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle->caption(), $this->vehicle->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->vehicle->FormValue)) {
			AddMessage($FormError, $this->vehicle->errorMessage());
		}
		if ($this->_route->Required) {
			if (!$this->_route->IsDetailKey && $this->_route->FormValue != NULL && $this->_route->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_route->caption(), $this->_route->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->_route->FormValue)) {
			AddMessage($FormError, $this->_route->errorMessage());
		}
		if ($this->route_name->Required) {
			if (!$this->route_name->IsDetailKey && $this->route_name->FormValue != NULL && $this->route_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->route_name->caption(), $this->route_name->RequiredErrorMessage));
			}
		}
		if ($this->reports_to->Required) {
			if (!$this->reports_to->IsDetailKey && $this->reports_to->FormValue != NULL && $this->reports_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
			}
		}
		if ($this->buyer->Required) {
			if (!$this->buyer->IsDetailKey && $this->buyer->FormValue != NULL && $this->buyer->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer->caption(), $this->buyer->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->buyer->FormValue)) {
			AddMessage($FormError, $this->buyer->errorMessage());
		}
		if ($this->b_consignor->Required) {
			if (!$this->b_consignor->IsDetailKey && $this->b_consignor->FormValue != NULL && $this->b_consignor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_consignor->caption(), $this->b_consignor->RequiredErrorMessage));
			}
		}
		if ($this->b_consignee->Required) {
			if (!$this->b_consignee->IsDetailKey && $this->b_consignee->FormValue != NULL && $this->b_consignee->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_consignee->caption(), $this->b_consignee->RequiredErrorMessage));
			}
		}
		if ($this->load_date->Required) {
			if (!$this->load_date->IsDetailKey && $this->load_date->FormValue != NULL && $this->load_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_date->caption(), $this->load_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->load_date->FormValue)) {
			AddMessage($FormError, $this->load_date->errorMessage());
		}
		if ($this->load_weight->Required) {
			if (!$this->load_weight->IsDetailKey && $this->load_weight->FormValue != NULL && $this->load_weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_weight->caption(), $this->load_weight->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->load_weight->FormValue)) {
			AddMessage($FormError, $this->load_weight->errorMessage());
		}
		if ($this->unload_date->Required) {
			if (!$this->unload_date->IsDetailKey && $this->unload_date->FormValue != NULL && $this->unload_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_date->caption(), $this->unload_date->RequiredErrorMessage));
			}
		}
		if ($this->unload_weight->Required) {
			if (!$this->unload_weight->IsDetailKey && $this->unload_weight->FormValue != NULL && $this->unload_weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_weight->caption(), $this->unload_weight->RequiredErrorMessage));
			}
		}
		if ($this->invoice_no->Required) {
			if (!$this->invoice_no->IsDetailKey && $this->invoice_no->FormValue != NULL && $this->invoice_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_no->caption(), $this->invoice_no->RequiredErrorMessage));
			}
		}
		if ($this->invoice_date->Required) {
			if (!$this->invoice_date->IsDetailKey && $this->invoice_date->FormValue != NULL && $this->invoice_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_date->caption(), $this->invoice_date->RequiredErrorMessage));
			}
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if ($this->delivery_pod->Required) {
			if ($this->delivery_pod->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_pod->caption(), $this->delivery_pod->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->days->Required) {
			if (!$this->days->IsDetailKey && $this->days->FormValue != NULL && $this->days->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->days->caption(), $this->days->RequiredErrorMessage));
			}
		}
		if ($this->driver->Required) {
			if (!$this->driver->IsDetailKey && $this->driver->FormValue != NULL && $this->driver->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver->caption(), $this->driver->RequiredErrorMessage));
			}
		}
		if ($this->driver_name->Required) {
			if (!$this->driver_name->IsDetailKey && $this->driver_name->FormValue != NULL && $this->driver_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver_name->caption(), $this->driver_name->RequiredErrorMessage));
			}
		}
		if ($this->agent->Required) {
			if (!$this->agent->IsDetailKey && $this->agent->FormValue != NULL && $this->agent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->agent->caption(), $this->agent->RequiredErrorMessage));
			}
		}
		if ($this->comm->Required) {
			if (!$this->comm->IsDetailKey && $this->comm->FormValue != NULL && $this->comm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->comm->caption(), $this->comm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->comm->FormValue)) {
			AddMessage($FormError, $this->comm->errorMessage());
		}
		if ($this->material->Required) {
			if (!$this->material->IsDetailKey && $this->material->FormValue != NULL && $this->material->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material->caption(), $this->material->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->m_hsn->Required) {
			if (!$this->m_hsn->IsDetailKey && $this->m_hsn->FormValue != NULL && $this->m_hsn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_hsn->caption(), $this->m_hsn->RequiredErrorMessage));
			}
		}
		if ($this->_40->Required) {
			if (!$this->_40->IsDetailKey && $this->_40->FormValue != NULL && $this->_40->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->_40->FormValue)) {
			AddMessage($FormError, $this->_40->errorMessage());
		}
		if ($this->lr_no->Required) {
			if (!$this->lr_no->IsDetailKey && $this->lr_no->FormValue != NULL && $this->lr_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lr_no->caption(), $this->lr_no->RequiredErrorMessage));
			}
		}
		if ($this->km->Required) {
			if (!$this->km->IsDetailKey && $this->km->FormValue != NULL && $this->km->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->km->caption(), $this->km->RequiredErrorMessage));
			}
		}
		if ($this->freight_type->Required) {
			if (!$this->freight_type->IsDetailKey && $this->freight_type->FormValue != NULL && $this->freight_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->freight_type->caption(), $this->freight_type->RequiredErrorMessage));
			}
		}
		if ($this->freight->Required) {
			if (!$this->freight->IsDetailKey && $this->freight->FormValue != NULL && $this->freight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->freight->caption(), $this->freight->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->freight->FormValue)) {
			AddMessage($FormError, $this->freight->errorMessage());
		}
		if ($this->ded_det->Required) {
			if (!$this->ded_det->IsDetailKey && $this->ded_det->FormValue != NULL && $this->ded_det->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ded_det->caption(), $this->ded_det->RequiredErrorMessage));
			}
		}
		if ($this->ded_det_remarks->Required) {
			if (!$this->ded_det_remarks->IsDetailKey && $this->ded_det_remarks->FormValue != NULL && $this->ded_det_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ded_det_remarks->caption(), $this->ded_det_remarks->RequiredErrorMessage));
			}
		}
		if ($this->gst_percent->Required) {
			if (!$this->gst_percent->IsDetailKey && $this->gst_percent->FormValue != NULL && $this->gst_percent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gst_percent->caption(), $this->gst_percent->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->gst_percent->FormValue)) {
			AddMessage($FormError, $this->gst_percent->errorMessage());
		}
		if ($this->gst_amount->Required) {
			if (!$this->gst_amount->IsDetailKey && $this->gst_amount->FormValue != NULL && $this->gst_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gst_amount->caption(), $this->gst_amount->RequiredErrorMessage));
			}
		}
		if ($this->final_amount->Required) {
			if (!$this->final_amount->IsDetailKey && $this->final_amount->FormValue != NULL && $this->final_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->final_amount->caption(), $this->final_amount->RequiredErrorMessage));
			}
		}
		if ($this->load_km->Required) {
			if (!$this->load_km->IsDetailKey && $this->load_km->FormValue != NULL && $this->load_km->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_km->caption(), $this->load_km->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->load_km->FormValue)) {
			AddMessage($FormError, $this->load_km->errorMessage());
		}
		if ($this->unload_km->Required) {
			if (!$this->unload_km->IsDetailKey && $this->unload_km->FormValue != NULL && $this->unload_km->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_km->caption(), $this->unload_km->RequiredErrorMessage));
			}
		}
		if ($this->delivery_receipt->Required) {
			if ($this->delivery_receipt->Upload->FileName == "" && !$this->delivery_receipt->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->delivery_receipt->caption(), $this->delivery_receipt->RequiredErrorMessage));
			}
		}
		if ($this->delivery_docket->Required) {
			if (!$this->delivery_docket->IsDetailKey && $this->delivery_docket->FormValue != NULL && $this->delivery_docket->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_docket->caption(), $this->delivery_docket->RequiredErrorMessage));
			}
		}
		if ($this->diesal_op_b->Required) {
			if (!$this->diesal_op_b->IsDetailKey && $this->diesal_op_b->FormValue != NULL && $this->diesal_op_b->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal_op_b->caption(), $this->diesal_op_b->RequiredErrorMessage));
			}
		}
		if ($this->diesal_required->Required) {
			if (!$this->diesal_required->IsDetailKey && $this->diesal_required->FormValue != NULL && $this->diesal_required->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal_required->caption(), $this->diesal_required->RequiredErrorMessage));
			}
		}
		if ($this->diesal_fill->Required) {
			if (!$this->diesal_fill->IsDetailKey && $this->diesal_fill->FormValue != NULL && $this->diesal_fill->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal_fill->caption(), $this->diesal_fill->RequiredErrorMessage));
			}
		}
		if ($this->diesal_amount->Required) {
			if (!$this->diesal_amount->IsDetailKey && $this->diesal_amount->FormValue != NULL && $this->diesal_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal_amount->caption(), $this->diesal_amount->RequiredErrorMessage));
			}
		}
		if ($this->diesal_cl_balance->Required) {
			if (!$this->diesal_cl_balance->IsDetailKey && $this->diesal_cl_balance->FormValue != NULL && $this->diesal_cl_balance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal_cl_balance->caption(), $this->diesal_cl_balance->RequiredErrorMessage));
			}
		}
		if ($this->vehicle_average->Required) {
			if (!$this->vehicle_average->IsDetailKey && $this->vehicle_average->FormValue != NULL && $this->vehicle_average->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_average->caption(), $this->vehicle_average->RequiredErrorMessage));
			}
		}
		if ($this->cash_required->Required) {
			if (!$this->cash_required->IsDetailKey && $this->cash_required->FormValue != NULL && $this->cash_required->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cash_required->caption(), $this->cash_required->RequiredErrorMessage));
			}
		}
		if ($this->cash_op_b->Required) {
			if (!$this->cash_op_b->IsDetailKey && $this->cash_op_b->FormValue != NULL && $this->cash_op_b->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cash_op_b->caption(), $this->cash_op_b->RequiredErrorMessage));
			}
		}
		if ($this->cash_paid->Required) {
			if (!$this->cash_paid->IsDetailKey && $this->cash_paid->FormValue != NULL && $this->cash_paid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cash_paid->caption(), $this->cash_paid->RequiredErrorMessage));
			}
		}
		if ($this->cash_expenses->Required) {
			if (!$this->cash_expenses->IsDetailKey && $this->cash_expenses->FormValue != NULL && $this->cash_expenses->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cash_expenses->caption(), $this->cash_expenses->RequiredErrorMessage));
			}
		}
		if ($this->cash_cl_balance->Required) {
			if (!$this->cash_cl_balance->IsDetailKey && $this->cash_cl_balance->FormValue != NULL && $this->cash_cl_balance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cash_cl_balance->caption(), $this->cash_cl_balance->RequiredErrorMessage));
			}
		}
		if ($this->fasttag_op_b->Required) {
			if (!$this->fasttag_op_b->IsDetailKey && $this->fasttag_op_b->FormValue != NULL && $this->fasttag_op_b->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fasttag_op_b->caption(), $this->fasttag_op_b->RequiredErrorMessage));
			}
		}
		if ($this->fasttag_recharge->Required) {
			if (!$this->fasttag_recharge->IsDetailKey && $this->fasttag_recharge->FormValue != NULL && $this->fasttag_recharge->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fasttag_recharge->caption(), $this->fasttag_recharge->RequiredErrorMessage));
			}
		}
		if ($this->fasttag_expenses->Required) {
			if (!$this->fasttag_expenses->IsDetailKey && $this->fasttag_expenses->FormValue != NULL && $this->fasttag_expenses->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fasttag_expenses->caption(), $this->fasttag_expenses->RequiredErrorMessage));
			}
		}
		if ($this->toll_expenses_cash->Required) {
			if (!$this->toll_expenses_cash->IsDetailKey && $this->toll_expenses_cash->FormValue != NULL && $this->toll_expenses_cash->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->toll_expenses_cash->caption(), $this->toll_expenses_cash->RequiredErrorMessage));
			}
		}
		if ($this->fasttag_cl_balance->Required) {
			if (!$this->fasttag_cl_balance->IsDetailKey && $this->fasttag_cl_balance->FormValue != NULL && $this->fasttag_cl_balance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fasttag_cl_balance->caption(), $this->fasttag_cl_balance->RequiredErrorMessage));
			}
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->uploads->Required) {
			if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}
		if ($this->consignor->Required) {
			if (!$this->consignor->IsDetailKey && $this->consignor->FormValue != NULL && $this->consignor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->consignor->caption(), $this->consignor->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->consignor->FormValue)) {
			AddMessage($FormError, $this->consignor->errorMessage());
		}
		if ($this->vehicle_freight_comm->Required) {
			if (!$this->vehicle_freight_comm->IsDetailKey && $this->vehicle_freight_comm->FormValue != NULL && $this->vehicle_freight_comm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_freight_comm->caption(), $this->vehicle_freight_comm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->vehicle_freight_comm->FormValue)) {
			AddMessage($FormError, $this->vehicle_freight_comm->errorMessage());
		}
		if ($this->vehicle_freight_type->Required) {
			if (!$this->vehicle_freight_type->IsDetailKey && $this->vehicle_freight_type->FormValue != NULL && $this->vehicle_freight_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_freight_type->caption(), $this->vehicle_freight_type->RequiredErrorMessage));
			}
		}
		if ($this->vehicle_freight_amount->Required) {
			if (!$this->vehicle_freight_amount->IsDetailKey && $this->vehicle_freight_amount->FormValue != NULL && $this->vehicle_freight_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_freight_amount->caption(), $this->vehicle_freight_amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->vehicle_freight_amount->FormValue)) {
			AddMessage($FormError, $this->vehicle_freight_amount->errorMessage());
		}
		if ($this->vehicle_freight_final->Required) {
			if (!$this->vehicle_freight_final->IsDetailKey && $this->vehicle_freight_final->FormValue != NULL && $this->vehicle_freight_final->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_freight_final->caption(), $this->vehicle_freight_final->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->expenses_id->Required) {
			if (!$this->expenses_id->IsDetailKey && $this->expenses_id->FormValue != NULL && $this->expenses_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->expenses_id->caption(), $this->expenses_id->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("t_expenses_o", $detailTblVar) && $GLOBALS["t_expenses_o"]->DetailAdd) {
			if (!isset($GLOBALS["t_expenses_o_grid"]))
				$GLOBALS["t_expenses_o_grid"] = new t_expenses_o_grid(); // Get detail page object
			$GLOBALS["t_expenses_o_grid"]->validateGridForm();
		}
		if (in_array("t_receipt_d", $detailTblVar) && $GLOBALS["t_receipt_d"]->DetailAdd) {
			if (!isset($GLOBALS["t_receipt_d_grid"]))
				$GLOBALS["t_receipt_d_grid"] = new t_receipt_d_grid(); // Get detail page object
			$GLOBALS["t_receipt_d_grid"]->validateGridForm();
		}
		if (in_array("t_diesal_expenses", $detailTblVar) && $GLOBALS["t_diesal_expenses"]->DetailAdd) {
			if (!isset($GLOBALS["t_diesal_expenses_grid"]))
				$GLOBALS["t_diesal_expenses_grid"] = new t_diesal_expenses_grid(); // Get detail page object
			$GLOBALS["t_diesal_expenses_grid"]->validateGridForm();
		}
		if (in_array("t_route_info", $detailTblVar) && $GLOBALS["t_route_info"]->DetailAdd) {
			if (!isset($GLOBALS["t_route_info_grid"]))
				$GLOBALS["t_route_info_grid"] = new t_route_info_grid(); // Get detail page object
			$GLOBALS["t_route_info_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Add record
	protected function addRow($rsold = NULL)
	{
		global $Language, $Security;
		$conn = &$this->getConnection();

		// Begin transaction
		if ($this->getCurrentDetailTable() <> "")
			$conn->beginTrans();

		// Load db values from rsold
		$this->loadDbValues($rsold);
		if ($rsold) {
			$this->delivery_receipt->OldUploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			$this->delivery_receipt->UploadPath = $this->delivery_receipt->OldUploadPath;
			$this->uploads->OldUploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			$this->uploads->UploadPath = $this->uploads->OldUploadPath;
		}
		$rsnew = [];

		// vehicle_type
		$this->vehicle_type->setDbValueDef($rsnew, $this->vehicle_type->CurrentValue, 0, strval($this->vehicle_type->CurrentValue) == "");

		// vehicle
		$this->vehicle->setDbValueDef($rsnew, $this->vehicle->CurrentValue, 0, FALSE);

		// route
		$this->_route->setDbValueDef($rsnew, $this->_route->CurrentValue, 0, FALSE);

		// reports_to
		$this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, NULL, strval($this->reports_to->CurrentValue) == "");

		// buyer
		$this->buyer->setDbValueDef($rsnew, $this->buyer->CurrentValue, 0, FALSE);

		// b_consignor
		$this->b_consignor->setDbValueDef($rsnew, $this->b_consignor->CurrentValue, NULL, FALSE);

		// b_consignee
		$this->b_consignee->setDbValueDef($rsnew, $this->b_consignee->CurrentValue, NULL, FALSE);

		// load_date
		$this->load_date->setDbValueDef($rsnew, UnFormatDateTime($this->load_date->CurrentValue, 1), CurrentDate(), FALSE);

		// load_weight
		$this->load_weight->setDbValueDef($rsnew, $this->load_weight->CurrentValue, NULL, FALSE);

		// driver
		$this->driver->setDbValueDef($rsnew, $this->driver->CurrentValue, NULL, FALSE);

		// driver_name
		$this->driver_name->setDbValueDef($rsnew, $this->driver_name->CurrentValue, NULL, FALSE);

		// agent
		$this->agent->setDbValueDef($rsnew, $this->agent->CurrentValue, NULL, FALSE);

		// comm
		$this->comm->setDbValueDef($rsnew, $this->comm->CurrentValue, 0, strval($this->comm->CurrentValue) == "");

		// material
		$this->material->setDbValueDef($rsnew, $this->material->CurrentValue, "", FALSE);

		// packing_type
		$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, "", FALSE);

		// m_hsn
		$this->m_hsn->setDbValueDef($rsnew, $this->m_hsn->CurrentValue, NULL, FALSE);

		// @
		$this->_40->setDbValueDef($rsnew, $this->_40->CurrentValue, 0, FALSE);

		// freight_type
		$this->freight_type->setDbValueDef($rsnew, $this->freight_type->CurrentValue, 0, strval($this->freight_type->CurrentValue) == "");

		// freight
		$this->freight->setDbValueDef($rsnew, $this->freight->CurrentValue, 0, FALSE);

		// gst_percent
		$this->gst_percent->setDbValueDef($rsnew, $this->gst_percent->CurrentValue, 0, strval($this->gst_percent->CurrentValue) == "");

		// load_km
		$this->load_km->setDbValueDef($rsnew, $this->load_km->CurrentValue, 0, strval($this->load_km->CurrentValue) == "");

		// remarks
		$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, FALSE);

		// consignor
		$this->consignor->setDbValueDef($rsnew, $this->consignor->CurrentValue, 0, FALSE);

		// vehicle_freight_comm
		$this->vehicle_freight_comm->setDbValueDef($rsnew, $this->vehicle_freight_comm->CurrentValue, 0, strval($this->vehicle_freight_comm->CurrentValue) == "");

		// vehicle_freight_type
		$this->vehicle_freight_type->setDbValueDef($rsnew, $this->vehicle_freight_type->CurrentValue, 0, strval($this->vehicle_freight_type->CurrentValue) == "");

		// vehicle_freight_amount
		$this->vehicle_freight_amount->setDbValueDef($rsnew, $this->vehicle_freight_amount->CurrentValue, 0, strval($this->vehicle_freight_amount->CurrentValue) == "");

		// operator
		$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
		$rsnew['operator'] = &$this->operator->DbValue;

		// datetime
		$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
		$rsnew['datetime'] = &$this->datetime->DbValue;

		// Call Row Inserting event
		$rs = ($rsold) ? $rsold->fields : NULL;
		$insertRow = $this->Row_Inserting($rs, $rsnew);
		if ($insertRow) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$addRow = $this->insert($rsnew);
			$conn->raiseErrorFn = '';
			if ($addRow) {
			}
		} else {
			if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

				// Use the message, do nothing
			} elseif ($this->CancelMessage <> "") {
				$this->setFailureMessage($this->CancelMessage);
				$this->CancelMessage = "";
			} else {
				$this->setFailureMessage($Language->phrase("InsertCancelled"));
			}
			$addRow = FALSE;
		}

		// Add detail records
		if ($addRow) {
			$detailTblVar = explode(",", $this->getCurrentDetailTable());
			if (in_array("t_expenses_o", $detailTblVar) && $GLOBALS["t_expenses_o"]->DetailAdd) {
				$GLOBALS["t_expenses_o"]->trip->setSessionValue($this->id->CurrentValue); // Set master key
				if (!isset($GLOBALS["t_expenses_o_grid"]))
					$GLOBALS["t_expenses_o_grid"] = new t_expenses_o_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "t_expenses_o"); // Load user level of detail table
				$addRow = $GLOBALS["t_expenses_o_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow)
					$GLOBALS["t_expenses_o"]->trip->setSessionValue(""); // Clear master key if insert failed
			}
			if (in_array("t_receipt_d", $detailTblVar) && $GLOBALS["t_receipt_d"]->DetailAdd) {
				$GLOBALS["t_receipt_d"]->trip->setSessionValue($this->id->CurrentValue); // Set master key
				if (!isset($GLOBALS["t_receipt_d_grid"]))
					$GLOBALS["t_receipt_d_grid"] = new t_receipt_d_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "t_receipt_d"); // Load user level of detail table
				$addRow = $GLOBALS["t_receipt_d_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow)
					$GLOBALS["t_receipt_d"]->trip->setSessionValue(""); // Clear master key if insert failed
			}
			if (in_array("t_diesal_expenses", $detailTblVar) && $GLOBALS["t_diesal_expenses"]->DetailAdd) {
				$GLOBALS["t_diesal_expenses"]->trip->setSessionValue($this->id->CurrentValue); // Set master key
				if (!isset($GLOBALS["t_diesal_expenses_grid"]))
					$GLOBALS["t_diesal_expenses_grid"] = new t_diesal_expenses_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "t_diesal_expenses"); // Load user level of detail table
				$addRow = $GLOBALS["t_diesal_expenses_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow)
					$GLOBALS["t_diesal_expenses"]->trip->setSessionValue(""); // Clear master key if insert failed
			}
			if (in_array("t_route_info", $detailTblVar) && $GLOBALS["t_route_info"]->DetailAdd) {
				$GLOBALS["t_route_info"]->id->setSessionValue($this->_route->CurrentValue); // Set master key
				if (!isset($GLOBALS["t_route_info_grid"]))
					$GLOBALS["t_route_info_grid"] = new t_route_info_grid(); // Get detail page object
				$Security->loadCurrentUserLevel($this->ProjectID . "t_route_info"); // Load user level of detail table
				$addRow = $GLOBALS["t_route_info_grid"]->gridInsert();
				$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
				if (!$addRow)
					$GLOBALS["t_route_info"]->id->setSessionValue(""); // Clear master key if insert failed
			}
		}

		// Commit/Rollback transaction
		if ($this->getCurrentDetailTable() <> "") {
			if ($addRow) {
				$conn->commitTrans(); // Commit transaction
			} else {
				$conn->rollbackTrans(); // Rollback transaction
			}
		}
		if ($addRow) {

			// Call Row Inserted event
			$rs = ($rsold) ? $rsold->fields : NULL;
			$this->Row_Inserted($rs, $rsnew);
		}

		// Write JSON for API request
		if (IsApi() && $addRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $addRow;
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		if (Get(TABLE_SHOW_DETAIL) !== NULL) {
			$detailTblVar = Get(TABLE_SHOW_DETAIL);
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar <> "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("t_expenses_o", $detailTblVar)) {
				if (!isset($GLOBALS["t_expenses_o_grid"]))
					$GLOBALS["t_expenses_o_grid"] = new t_expenses_o_grid();
				if ($GLOBALS["t_expenses_o_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["t_expenses_o_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["t_expenses_o_grid"]->CurrentMode = "add";
					$GLOBALS["t_expenses_o_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["t_expenses_o_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_expenses_o_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_expenses_o_grid"]->trip->IsDetailKey = TRUE;
					$GLOBALS["t_expenses_o_grid"]->trip->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["t_expenses_o_grid"]->trip->setSessionValue($GLOBALS["t_expenses_o_grid"]->trip->CurrentValue);
				}
			}
			if (in_array("t_receipt_d", $detailTblVar)) {
				if (!isset($GLOBALS["t_receipt_d_grid"]))
					$GLOBALS["t_receipt_d_grid"] = new t_receipt_d_grid();
				if ($GLOBALS["t_receipt_d_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["t_receipt_d_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["t_receipt_d_grid"]->CurrentMode = "add";
					$GLOBALS["t_receipt_d_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["t_receipt_d_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_receipt_d_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_receipt_d_grid"]->trip->IsDetailKey = TRUE;
					$GLOBALS["t_receipt_d_grid"]->trip->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["t_receipt_d_grid"]->trip->setSessionValue($GLOBALS["t_receipt_d_grid"]->trip->CurrentValue);
				}
			}
			if (in_array("t_diesal_expenses", $detailTblVar)) {
				if (!isset($GLOBALS["t_diesal_expenses_grid"]))
					$GLOBALS["t_diesal_expenses_grid"] = new t_diesal_expenses_grid();
				if ($GLOBALS["t_diesal_expenses_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["t_diesal_expenses_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["t_diesal_expenses_grid"]->CurrentMode = "add";
					$GLOBALS["t_diesal_expenses_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["t_diesal_expenses_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_diesal_expenses_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_diesal_expenses_grid"]->trip->IsDetailKey = TRUE;
					$GLOBALS["t_diesal_expenses_grid"]->trip->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["t_diesal_expenses_grid"]->trip->setSessionValue($GLOBALS["t_diesal_expenses_grid"]->trip->CurrentValue);
				}
			}
			if (in_array("t_route_info", $detailTblVar)) {
				if (!isset($GLOBALS["t_route_info_grid"]))
					$GLOBALS["t_route_info_grid"] = new t_route_info_grid();
				if ($GLOBALS["t_route_info_grid"]->DetailAdd) {
					if ($this->CopyRecord)
						$GLOBALS["t_route_info_grid"]->CurrentMode = "copy";
					else
						$GLOBALS["t_route_info_grid"]->CurrentMode = "add";
					$GLOBALS["t_route_info_grid"]->CurrentAction = "gridadd";

					// Save current master table to detail table
					$GLOBALS["t_route_info_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_route_info_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_route_info_grid"]->id->IsDetailKey = TRUE;
					$GLOBALS["t_route_info_grid"]->id->CurrentValue = $this->_route->CurrentValue;
					$GLOBALS["t_route_info_grid"]->id->setSessionValue($GLOBALS["t_route_info_grid"]->id->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("t_trip_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = ($this->isCopy()) ? "Copy" : "Add";
		$Breadcrumb->add("add", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_vehicle":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x__route":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_reports_to":
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyer":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignor":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignee":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_driver":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignor":
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_vehicle":
							break;
						case "x__route":
							break;
						case "x_reports_to":
							break;
						case "x_buyer":
							break;
						case "x_b_consignor":
							break;
						case "x_b_consignee":
							break;
						case "x_driver":
							break;
						case "x_agent":
							break;
						case "x_consignor":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'t_trip_info');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>