<?php
namespace PHPMaker2019\fibre;

/**
 * Table class for t_trip_info_d_unload
 */
class t_trip_info_d_unload extends DbTable
{
	protected $SqlFrom = "";
	protected $SqlSelect = "";
	protected $SqlSelectList = "";
	protected $SqlWhere = "";
	protected $SqlGroupBy = "";
	protected $SqlHaving = "";
	protected $SqlOrderBy = "";
	public $UseSessionForListSql = TRUE;

	// Column CSS classes
	public $LeftColumnClass = "col-sm-2 col-form-label ew-label";
	public $RightColumnClass = "col-sm-10";
	public $OffsetColumnClass = "col-sm-10 offset-sm-2";
	public $TableLeftColumnClass = "w-col-2";

	// Export
	public $ExportDoc;

	// Fields
	public $id;
	public $load_date;
	public $trip_info;
	public $driver;
	public $unload_km;
	public $load_weight;
	public $unload_weight;
	public $unload_date;
	public $ded_det;
	public $ded_det_remarks;
	public $fasttag_cl_balance;
	public $delivery_receipt;
	public $delivery_pod;
	public $operator;
	public $datetime;

	// Constructor
	public function __construct()
	{
		global $Language, $CurrentLanguage;

		// Language object
		if (!isset($Language))
			$Language = new Language();
		$this->TableVar = 't_trip_info_d_unload';
		$this->TableName = 't_trip_info_d_unload';
		$this->TableType = 'VIEW';

		// Update Table
		$this->UpdateTable = "`t_trip_info_d_unload`";
		$this->Dbid = 'DB';
		$this->ExportAll = TRUE;
		$this->ExportPageBreakCount = 0; // Page break per every n record (PDF only)
		$this->ExportPageOrientation = "portrait"; // Page orientation (PDF only)
		$this->ExportPageSize = "a4"; // Page size (PDF only)
		$this->ExportExcelPageOrientation = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::ORIENTATION_DEFAULT; // Page orientation (PhpSpreadsheet only)
		$this->ExportExcelPageSize = \PhpOffice\PhpSpreadsheet\Worksheet\PageSetup::PAPERSIZE_A4; // Page size (PhpSpreadsheet only)
		$this->ExportWordPageOrientation = "portrait"; // Page orientation (PHPWord only)
		$this->ExportWordColumnWidth = NULL; // Cell width (PHPWord only)
		$this->DetailAdd = FALSE; // Allow detail add
		$this->DetailEdit = FALSE; // Allow detail edit
		$this->DetailView = FALSE; // Allow detail view
		$this->ShowMultipleDetails = FALSE; // Show multiple details
		$this->GridAddRowCount = 5;
		$this->AllowAddDeleteRow = TRUE; // Allow add/delete row
		$this->UserIDAllowSecurity = 0; // User ID Allow
		$this->BasicSearch = new BasicSearch($this->TableVar);
		$this->BasicSearch->TypeDefault = "OR";

		// id
		$this->id = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_id', 'id', '`id`', '`id`', 18, -1, FALSE, '`id`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'NO');
		$this->id->IsAutoIncrement = TRUE; // Autoincrement field
		$this->id->IsPrimaryKey = TRUE; // Primary key field
		$this->id->Sortable = TRUE; // Allow sort
		$this->id->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['id'] = &$this->id;

		// load_date
		$this->load_date = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_load_date', 'load_date', '`load_date`', CastDateFieldForLike('`load_date`', 2, "DB"), 135, 2, FALSE, '`load_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->load_date->Nullable = FALSE; // NOT NULL field
		$this->load_date->Required = TRUE; // Required field
		$this->load_date->Sortable = TRUE; // Allow sort
		$this->load_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['load_date'] = &$this->load_date;

		// trip_info
		$this->trip_info = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_trip_info', 'trip_info', '`trip_info`', '`trip_info`', 18, -1, FALSE, '`trip_info`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->trip_info->IsAutoIncrement = TRUE; // Autoincrement field
		$this->trip_info->Sortable = TRUE; // Allow sort
		$this->trip_info->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->trip_info->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->trip_info->Lookup = new Lookup('trip_info', 't_trip_info', FALSE, 'id', ["route_name","","",""], [], [], [], [], [], [], '`route_name` ASC', '');
		$this->trip_info->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['trip_info'] = &$this->trip_info;

		// driver
		$this->driver = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_driver', 'driver', '`driver`', '`driver`', 2, -1, FALSE, '`driver`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->driver->Sortable = TRUE; // Allow sort
		$this->driver->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->driver->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->driver->Lookup = new Lookup('driver', 't_driver_info', FALSE, 'id', ["name","mobile","",""], [], [], [], [], [], [], '`name` ASC', '');
		$this->driver->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['driver'] = &$this->driver;

		// unload_km
		$this->unload_km = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_unload_km', 'unload_km', '`unload_km`', '`unload_km`', 19, -1, FALSE, '`unload_km`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unload_km->Nullable = FALSE; // NOT NULL field
		$this->unload_km->Sortable = TRUE; // Allow sort
		$this->unload_km->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unload_km'] = &$this->unload_km;

		// load_weight
		$this->load_weight = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_load_weight', 'load_weight', '`load_weight`', '`load_weight`', 18, -1, FALSE, '`load_weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->load_weight->Sortable = TRUE; // Allow sort
		$this->load_weight->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['load_weight'] = &$this->load_weight;

		// unload_weight
		$this->unload_weight = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_unload_weight', 'unload_weight', '`unload_weight`', '`unload_weight`', 18, -1, FALSE, '`unload_weight`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unload_weight->Sortable = TRUE; // Allow sort
		$this->unload_weight->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['unload_weight'] = &$this->unload_weight;

		// unload_date
		$this->unload_date = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_unload_date', 'unload_date', '`unload_date`', CastDateFieldForLike('`unload_date`', 0, "DB"), 135, 0, FALSE, '`unload_date`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->unload_date->Sortable = TRUE; // Allow sort
		$this->unload_date->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['unload_date'] = &$this->unload_date;

		// ded_det
		$this->ded_det = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_ded_det', 'ded_det', '`ded_det`', '`ded_det`', 131, -1, FALSE, '`ded_det`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ded_det->Nullable = FALSE; // NOT NULL field
		$this->ded_det->Sortable = TRUE; // Allow sort
		$this->ded_det->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['ded_det'] = &$this->ded_det;

		// ded_det_remarks
		$this->ded_det_remarks = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_ded_det_remarks', 'ded_det_remarks', '`ded_det_remarks`', '`ded_det_remarks`', 200, -1, FALSE, '`ded_det_remarks`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->ded_det_remarks->Sortable = TRUE; // Allow sort
		$this->fields['ded_det_remarks'] = &$this->ded_det_remarks;

		// fasttag_cl_balance
		$this->fasttag_cl_balance = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_fasttag_cl_balance', 'fasttag_cl_balance', '`fasttag_cl_balance`', '`fasttag_cl_balance`', 131, -1, FALSE, '`fasttag_cl_balance`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->fasttag_cl_balance->Sortable = TRUE; // Allow sort
		$this->fasttag_cl_balance->DefaultErrorMessage = $Language->phrase("IncorrectFloat");
		$this->fields['fasttag_cl_balance'] = &$this->fasttag_cl_balance;

		// delivery_receipt
		$this->delivery_receipt = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_delivery_receipt', 'delivery_receipt', '`delivery_receipt`', '`delivery_receipt`', 200, -1, TRUE, '`delivery_receipt`', FALSE, FALSE, FALSE, 'IMAGE', 'FILE');
		$this->delivery_receipt->Sortable = TRUE; // Allow sort
		$this->delivery_receipt->UploadMultiple = TRUE;
		$this->delivery_receipt->Upload->UploadMultiple = TRUE;
		$this->delivery_receipt->UploadMaxFileCount = 0;
		$this->fields['delivery_receipt'] = &$this->delivery_receipt;

		// delivery_pod
		$this->delivery_pod = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_delivery_pod', 'delivery_pod', '`delivery_pod`', '`delivery_pod`', 200, -1, FALSE, '`delivery_pod`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'RADIO');
		$this->delivery_pod->Required = TRUE; // Required field
		$this->delivery_pod->Sortable = TRUE; // Allow sort
		$this->delivery_pod->Lookup = new Lookup('delivery_pod', 't_trip_info_d_unload', FALSE, '', ["","","",""], [], [], [], [], [], [], '', '');
		$this->delivery_pod->OptionCount = 3;
		$this->fields['delivery_pod'] = &$this->delivery_pod;

		// operator
		$this->operator = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_operator', 'operator', '`operator`', '`operator`', 2, -1, FALSE, '`operator`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'SELECT');
		$this->operator->Sortable = TRUE; // Allow sort
		$this->operator->UsePleaseSelect = TRUE; // Use PleaseSelect by default
		$this->operator->PleaseSelectText = $Language->phrase("PleaseSelect"); // PleaseSelect text
		$this->operator->Lookup = new Lookup('operator', 'admin', FALSE, 'id', ["user_name","","",""], [], [], [], [], [], [], '`user_name` ASC', '');
		$this->operator->DefaultErrorMessage = $Language->phrase("IncorrectInteger");
		$this->fields['operator'] = &$this->operator;

		// datetime
		$this->datetime = new DbField('t_trip_info_d_unload', 't_trip_info_d_unload', 'x_datetime', 'datetime', '`datetime`', CastDateFieldForLike('`datetime`', 0, "DB"), 135, 0, FALSE, '`datetime`', FALSE, FALSE, FALSE, 'FORMATTED TEXT', 'TEXT');
		$this->datetime->Nullable = FALSE; // NOT NULL field
		$this->datetime->Sortable = TRUE; // Allow sort
		$this->datetime->DefaultErrorMessage = str_replace("%s", $GLOBALS["DATE_FORMAT"], $Language->phrase("IncorrectDate"));
		$this->fields['datetime'] = &$this->datetime;
	}

	// Field Visibility
	public function getFieldVisibility($fldParm)
	{
		global $Security;
		return $this->$fldParm->Visible; // Returns original value
	}

	// Set left column class (must be predefined col-*-* classes of Bootstrap grid system)
	function setLeftColumnClass($class)
	{
		if (preg_match('/^col\-(\w+)\-(\d+)$/', $class, $match)) {
			$this->LeftColumnClass = $class . " col-form-label ew-label";
			$this->RightColumnClass = "col-" . $match[1] . "-" . strval(12 - (int)$match[2]);
			$this->OffsetColumnClass = $this->RightColumnClass . " " . str_replace("col-", "offset-", $class);
			$this->TableLeftColumnClass = preg_replace('/^col-\w+-(\d+)$/', "w-col-$1", $class); // Change to w-col-*
		}
	}

	// Multiple column sort
	public function updateSort(&$fld, $ctrl)
	{
		if ($this->CurrentOrder == $fld->Name) {
			$sortField = $fld->Expression;
			$lastSort = $fld->getSort();
			if ($this->CurrentOrderType == "ASC" || $this->CurrentOrderType == "DESC") {
				$thisSort = $this->CurrentOrderType;
			} else {
				$thisSort = ($lastSort == "ASC") ? "DESC" : "ASC";
			}
			$fld->setSort($thisSort);
			if ($ctrl) {
				$orderBy = $this->getSessionOrderBy();
				if (ContainsString($orderBy, $sortField . " " . $lastSort)) {
					$orderBy = str_replace($sortField . " " . $lastSort, $sortField . " " . $thisSort, $orderBy);
				} else {
					if ($orderBy <> "")
						$orderBy .= ", ";
					$orderBy .= $sortField . " " . $thisSort;
				}
				$this->setSessionOrderBy($orderBy); // Save to Session
			} else {
				$this->setSessionOrderBy($sortField . " " . $thisSort); // Save to Session
			}
		} else {
			if (!$ctrl)
				$fld->setSort("");
		}
	}

	// Table level SQL
	public function getSqlFrom() // From
	{
		return ($this->SqlFrom <> "") ? $this->SqlFrom : "`t_trip_info_d_unload`";
	}
	public function sqlFrom() // For backward compatibility
	{
		return $this->getSqlFrom();
	}
	public function setSqlFrom($v)
	{
		$this->SqlFrom = $v;
	}
	public function getSqlSelect() // Select
	{
		return ($this->SqlSelect <> "") ? $this->SqlSelect : "SELECT * FROM " . $this->getSqlFrom();
	}
	public function sqlSelect() // For backward compatibility
	{
		return $this->getSqlSelect();
	}
	public function setSqlSelect($v)
	{
		$this->SqlSelect = $v;
	}
	public function getSqlWhere() // Where
	{
		$where = ($this->SqlWhere <> "") ? $this->SqlWhere : "";
		$this->TableFilter = "`id`>0";
		AddFilter($where, $this->TableFilter);
		return $where;
	}
	public function sqlWhere() // For backward compatibility
	{
		return $this->getSqlWhere();
	}
	public function setSqlWhere($v)
	{
		$this->SqlWhere = $v;
	}
	public function getSqlGroupBy() // Group By
	{
		return ($this->SqlGroupBy <> "") ? $this->SqlGroupBy : "";
	}
	public function sqlGroupBy() // For backward compatibility
	{
		return $this->getSqlGroupBy();
	}
	public function setSqlGroupBy($v)
	{
		$this->SqlGroupBy = $v;
	}
	public function getSqlHaving() // Having
	{
		return ($this->SqlHaving <> "") ? $this->SqlHaving : "";
	}
	public function sqlHaving() // For backward compatibility
	{
		return $this->getSqlHaving();
	}
	public function setSqlHaving($v)
	{
		$this->SqlHaving = $v;
	}
	public function getSqlOrderBy() // Order By
	{
		return ($this->SqlOrderBy <> "") ? $this->SqlOrderBy : "`id` DESC";
	}
	public function sqlOrderBy() // For backward compatibility
	{
		return $this->getSqlOrderBy();
	}
	public function setSqlOrderBy($v)
	{
		$this->SqlOrderBy = $v;
	}

	// Apply User ID filters
	public function applyUserIDFilters($filter)
	{
		return $filter;
	}

	// Check if User ID security allows view all
	public function userIDAllow($id = "")
	{
		$allow = USER_ID_ALLOW;
		switch ($id) {
			case "add":
			case "copy":
			case "gridadd":
			case "register":
			case "addopt":
				return (($allow & 1) == 1);
			case "edit":
			case "gridedit":
			case "update":
			case "changepwd":
			case "forgotpwd":
				return (($allow & 4) == 4);
			case "delete":
				return (($allow & 2) == 2);
			case "view":
				return (($allow & 8) == 8);
			case "search":
				return (($allow & 8) == 8);
			default:
				return (($allow & 8) == 8);
		}
	}

	// Get SQL
	public function getSql($where, $orderBy = "")
	{
		return BuildSelectSql($this->getSqlSelect(), $this->getSqlWhere(),
			$this->getSqlGroupBy(), $this->getSqlHaving(), $this->getSqlOrderBy(),
			$where, $orderBy);
	}

	// Table SQL
	public function getCurrentSql()
	{
		$filter = $this->CurrentFilter;
		$filter = $this->applyUserIDFilters($filter);
		$sort = $this->getSessionOrderBy();
		return $this->getSql($filter, $sort);
	}

	// Table SQL with List page filter
	public function getListSql()
	{
		$filter = $this->UseSessionForListSql ? $this->getSessionWhere() : "";
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->getSqlSelect();
		$sort = $this->UseSessionForListSql ? $this->getSessionOrderBy() : "";
		return BuildSelectSql($select, $this->getSqlWhere(), $this->getSqlGroupBy(),
			$this->getSqlHaving(), $this->getSqlOrderBy(), $filter, $sort);
	}

	// Get ORDER BY clause
	public function getOrderBy()
	{
		$sort = $this->getSessionOrderBy();
		return BuildSelectSql("", "", "", "", $this->getSqlOrderBy(), "", $sort);
	}

	// Get record count
	public function getRecordCount($sql)
	{
		$cnt = -1;
		$rs = NULL;
		$sql = preg_replace('/\/\*BeginOrderBy\*\/[\s\S]+\/\*EndOrderBy\*\//', "", $sql); // Remove ORDER BY clause (MSSQL)
		$pattern = '/^SELECT\s([\s\S]+)\sFROM\s/i';

		// Skip Custom View / SubQuery and SELECT DISTINCT
		if (($this->TableType == 'TABLE' || $this->TableType == 'VIEW' || $this->TableType == 'LINKTABLE') &&
			preg_match($pattern, $sql) && !preg_match('/\(\s*(SELECT[^)]+)\)/i', $sql) && !preg_match('/^\s*select\s+distinct\s+/i', $sql)) {
			$sqlwrk = "SELECT COUNT(*) FROM " . preg_replace($pattern, "", $sql);
		} else {
			$sqlwrk = "SELECT COUNT(*) FROM (" . $sql . ") COUNT_TABLE";
		}
		$conn = &$this->getConnection();
		if ($rs = $conn->execute($sqlwrk)) {
			if (!$rs->EOF && $rs->FieldCount() > 0) {
				$cnt = $rs->fields[0];
				$rs->close();
			}
			return (int)$cnt;
		}

		// Unable to get count, get record count directly
		if ($rs = $conn->execute($sql)) {
			$cnt = $rs->RecordCount();
			$rs->close();
			return (int)$cnt;
		}
		return $cnt;
	}

	// Get record count based on filter (for detail record count in master table pages)
	public function loadRecordCount($filter)
	{
		$origFilter = $this->CurrentFilter;
		$this->CurrentFilter = $filter;
		$this->Recordset_Selecting($this->CurrentFilter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $this->CurrentFilter, "");
		$cnt = $this->getRecordCount($sql);
		$this->CurrentFilter = $origFilter;
		return $cnt;
	}

	// Get record count (for current List page)
	public function listRecordCount()
	{
		$filter = $this->getSessionWhere();
		AddFilter($filter, $this->CurrentFilter);
		$filter = $this->applyUserIDFilters($filter);
		$this->Recordset_Selecting($filter);
		$select = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlSelect() : "SELECT * FROM " . $this->getSqlFrom();
		$groupBy = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlGroupBy() : "";
		$having = $this->TableType == 'CUSTOMVIEW' ? $this->getSqlHaving() : "";
		$sql = BuildSelectSql($select, $this->getSqlWhere(), $groupBy, $having, "", $filter, "");
		$cnt = $this->getRecordCount($sql);
		return $cnt;
	}

	// INSERT statement
	protected function insertSql(&$rs)
	{
		$names = "";
		$values = "";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom)
				continue;
			$names .= $this->fields[$name]->Expression . ",";
			$values .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$names = preg_replace('/,+$/', "", $names);
		$values = preg_replace('/,+$/', "", $values);
		return "INSERT INTO " . $this->UpdateTable . " ($names) VALUES ($values)";
	}

	// Insert
	public function insert(&$rs)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->insertSql($rs));
		if ($success) {

			// Get insert id if necessary
			$this->id->setDbValue($conn->insert_ID());
			$rs['id'] = $this->id->DbValue;

			// Get insert id if necessary
			$this->trip_info->setDbValue($conn->insert_ID());
			$rs['trip_info'] = $this->trip_info->DbValue;
		}
		return $success;
	}

	// UPDATE statement
	protected function updateSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "UPDATE " . $this->UpdateTable . " SET ";
		foreach ($rs as $name => $value) {
			if (!isset($this->fields[$name]) || $this->fields[$name]->IsCustom || $this->fields[$name]->IsPrimaryKey)
				continue;
			$sql .= $this->fields[$name]->Expression . "=";
			$sql .= QuotedValue($value, $this->fields[$name]->DataType, $this->Dbid) . ",";
		}
		$sql = preg_replace('/,+$/', "", $sql);
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= " WHERE " . $filter;
		return $sql;
	}

	// Update
	public function update(&$rs, $where = "", $rsold = NULL, $curfilter = TRUE)
	{
		$conn = &$this->getConnection();
		$success = $conn->execute($this->updateSql($rs, $where, $curfilter));
		return $success;
	}

	// DELETE statement
	protected function deleteSql(&$rs, $where = "", $curfilter = TRUE)
	{
		$sql = "DELETE FROM " . $this->UpdateTable . " WHERE ";
		if (is_array($where))
			$where = $this->arrayToFilter($where);
		if ($rs) {
			if (array_key_exists('id', $rs))
				AddFilter($where, QuotedName('id', $this->Dbid) . '=' . QuotedValue($rs['id'], $this->id->DataType, $this->Dbid));
		}
		$filter = ($curfilter) ? $this->CurrentFilter : "";
		AddFilter($filter, $where);
		if ($filter <> "")
			$sql .= $filter;
		else
			$sql .= "0=1"; // Avoid delete
		return $sql;
	}

	// Delete
	public function delete(&$rs, $where = "", $curfilter = FALSE)
	{
		$success = TRUE;
		$conn = &$this->getConnection();
		if ($success)
			$success = $conn->execute($this->deleteSql($rs, $where, $curfilter));
		return $success;
	}

	// Load DbValue from recordset or array
	protected function loadDbValues(&$rs)
	{
		if (!$rs || !is_array($rs) && $rs->EOF)
			return;
		$row = is_array($rs) ? $rs : $rs->fields;
		$this->id->DbValue = $row['id'];
		$this->load_date->DbValue = $row['load_date'];
		$this->trip_info->DbValue = $row['trip_info'];
		$this->driver->DbValue = $row['driver'];
		$this->unload_km->DbValue = $row['unload_km'];
		$this->load_weight->DbValue = $row['load_weight'];
		$this->unload_weight->DbValue = $row['unload_weight'];
		$this->unload_date->DbValue = $row['unload_date'];
		$this->ded_det->DbValue = $row['ded_det'];
		$this->ded_det_remarks->DbValue = $row['ded_det_remarks'];
		$this->fasttag_cl_balance->DbValue = $row['fasttag_cl_balance'];
		$this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
		$this->delivery_pod->DbValue = $row['delivery_pod'];
		$this->operator->DbValue = $row['operator'];
		$this->datetime->DbValue = $row['datetime'];
	}

	// Delete uploaded files
	public function deleteUploadedFiles($row)
	{
		$this->loadDbValues($row);
		$this->delivery_receipt->OldUploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		$oldFiles = EmptyValue($row['delivery_receipt']) ? [] : explode(MULTIPLE_UPLOAD_SEPARATOR, $row['delivery_receipt']);
		foreach ($oldFiles as $oldFile) {
			if (file_exists($this->delivery_receipt->oldPhysicalUploadPath() . $oldFile))
				@unlink($this->delivery_receipt->oldPhysicalUploadPath() . $oldFile);
		}
	}

	// Record filter WHERE clause
	protected function sqlKeyFilter()
	{
		return "`id` = @id@";
	}

	// Get record filter
	public function getRecordFilter($row = NULL)
	{
		$keyFilter = $this->sqlKeyFilter();
		$val = is_array($row) ? (array_key_exists('id', $row) ? $row['id'] : NULL) : $this->id->CurrentValue;
		if (!is_numeric($val))
			return "0=1"; // Invalid key
		if ($val == NULL)
			return "0=1"; // Invalid key
		else
			$keyFilter = str_replace("@id@", AdjustSql($val, $this->Dbid), $keyFilter); // Replace key value
		return $keyFilter;
	}

	// Return page URL
	public function getReturnUrl()
	{
		$name = PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL;

		// Get referer URL automatically
		if (ServerVar("HTTP_REFERER") <> "" && ReferPageName() <> CurrentPageName() && ReferPageName() <> "login.php") // Referer not same page or login page
			$_SESSION[$name] = ServerVar("HTTP_REFERER"); // Save to Session
		if (@$_SESSION[$name] <> "") {
			return $_SESSION[$name];
		} else {
			return "t_trip_info_d_unloadlist.php";
		}
	}
	public function setReturnUrl($v)
	{
		$_SESSION[PROJECT_NAME . "_" . $this->TableVar . "_" . TABLE_RETURN_URL] = $v;
	}

	// Get modal caption
	public function getModalCaption($pageName)
	{
		global $Language;
		if ($pageName == "t_trip_info_d_unloadview.php")
			return $Language->phrase("View");
		elseif ($pageName == "t_trip_info_d_unloadedit.php")
			return $Language->phrase("Edit");
		elseif ($pageName == "t_trip_info_d_unloadadd.php")
			return $Language->phrase("Add");
		else
			return "";
	}

	// List URL
	public function getListUrl()
	{
		return "t_trip_info_d_unloadlist.php";
	}

	// View URL
	public function getViewUrl($parm = "")
	{
		if ($parm <> "")
			$url = $this->keyUrl("t_trip_info_d_unloadview.php", $this->getUrlParm($parm));
		else
			$url = $this->keyUrl("t_trip_info_d_unloadview.php", $this->getUrlParm(TABLE_SHOW_DETAIL . "="));
		return $this->addMasterUrl($url);
	}

	// Add URL
	public function getAddUrl($parm = "")
	{
		if ($parm <> "")
			$url = "t_trip_info_d_unloadadd.php?" . $this->getUrlParm($parm);
		else
			$url = "t_trip_info_d_unloadadd.php";
		return $this->addMasterUrl($url);
	}

	// Edit URL
	public function getEditUrl($parm = "")
	{
		$url = $this->keyUrl("t_trip_info_d_unloadedit.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline edit URL
	public function getInlineEditUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=edit"));
		return $this->addMasterUrl($url);
	}

	// Copy URL
	public function getCopyUrl($parm = "")
	{
		$url = $this->keyUrl("t_trip_info_d_unloadadd.php", $this->getUrlParm($parm));
		return $this->addMasterUrl($url);
	}

	// Inline copy URL
	public function getInlineCopyUrl()
	{
		$url = $this->keyUrl(CurrentPageName(), $this->getUrlParm("action=copy"));
		return $this->addMasterUrl($url);
	}

	// Delete URL
	public function getDeleteUrl()
	{
		return $this->keyUrl("t_trip_info_d_unloaddelete.php", $this->getUrlParm());
	}

	// Add master url
	public function addMasterUrl($url)
	{
		return $url;
	}
	public function keyToJson($htmlEncode = FALSE)
	{
		$json = "";
		$json .= "id:" . JsonEncode($this->id->CurrentValue, "number");
		$json = "{" . $json . "}";
		if ($htmlEncode)
			$json = HtmlEncode($json);
		return $json;
	}

	// Add key value to URL
	public function keyUrl($url, $parm = "")
	{
		$url = $url . "?";
		if ($parm <> "")
			$url .= $parm . "&";
		if ($this->id->CurrentValue != NULL) {
			$url .= "id=" . urlencode($this->id->CurrentValue);
		} else {
			return "javascript:ew.alert(ew.language.phrase('InvalidRecord'));";
		}
		return $url;
	}

	// Sort URL
	public function sortUrl(&$fld)
	{
		if ($this->CurrentAction || $this->isExport() ||
			in_array($fld->Type, array(128, 204, 205))) { // Unsortable data type
				return "";
		} elseif ($fld->Sortable) {
			$urlParm = $this->getUrlParm("order=" . urlencode($fld->Name) . "&amp;ordertype=" . $fld->reverseSort());
			return $this->addMasterUrl(CurrentPageName() . "?" . $urlParm);
		} else {
			return "";
		}
	}

	// Get record keys from Post/Get/Session
	public function getRecordKeys()
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$arKeys = array();
		$arKey = array();
		if (Param("key_m") !== NULL) {
			$arKeys = Param("key_m");
			$cnt = count($arKeys);
		} else {
			if (Param("id") !== NULL)
				$arKeys[] = Param("id");
			elseif (IsApi() && Key(0) !== NULL)
				$arKeys[] = Key(0);
			elseif (IsApi() && Route(2) !== NULL)
				$arKeys[] = Route(2);
			else
				$arKeys = NULL; // Do not setup

			//return $arKeys; // Do not return yet, so the values will also be checked by the following code
		}

		// Check keys
		$ar = array();
		if (is_array($arKeys)) {
			foreach ($arKeys as $key) {
				if (!is_numeric($key))
					continue;
				$ar[] = $key;
			}
		}
		return $ar;
	}

	// Get filter from record keys
	public function getFilterFromRecordKeys()
	{
		$arKeys = $this->getRecordKeys();
		$keyFilter = "";
		foreach ($arKeys as $key) {
			if ($keyFilter <> "") $keyFilter .= " OR ";
			$this->id->CurrentValue = $key;
			$keyFilter .= "(" . $this->getRecordFilter() . ")";
		}
		return $keyFilter;
	}

	// Load rows based on filter
	public function &loadRs($filter)
	{

		// Set up filter (WHERE Clause)
		$sql = $this->getSql($filter);
		$conn = &$this->getConnection();
		$rs = $conn->execute($sql);
		return $rs;
	}

	// Load row values from recordset
	public function loadListRowValues(&$rs)
	{
		$this->id->setDbValue($rs->fields('id'));
		$this->load_date->setDbValue($rs->fields('load_date'));
		$this->trip_info->setDbValue($rs->fields('trip_info'));
		$this->driver->setDbValue($rs->fields('driver'));
		$this->unload_km->setDbValue($rs->fields('unload_km'));
		$this->load_weight->setDbValue($rs->fields('load_weight'));
		$this->unload_weight->setDbValue($rs->fields('unload_weight'));
		$this->unload_date->setDbValue($rs->fields('unload_date'));
		$this->ded_det->setDbValue($rs->fields('ded_det'));
		$this->ded_det_remarks->setDbValue($rs->fields('ded_det_remarks'));
		$this->fasttag_cl_balance->setDbValue($rs->fields('fasttag_cl_balance'));
		$this->delivery_receipt->Upload->DbValue = $rs->fields('delivery_receipt');
		$this->delivery_pod->setDbValue($rs->fields('delivery_pod'));
		$this->operator->setDbValue($rs->fields('operator'));
		$this->datetime->setDbValue($rs->fields('datetime'));
	}

	// Render list row values
	public function renderListRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// Common render codes
		// id
		// load_date
		// trip_info
		// driver
		// unload_km
		// load_weight
		// unload_weight
		// unload_date
		// ded_det
		// ded_det_remarks
		// fasttag_cl_balance
		// delivery_receipt
		// delivery_pod
		// operator
		// datetime
		// id

		$this->id->ViewValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// load_date
		$this->load_date->ViewValue = $this->load_date->CurrentValue;
		$this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, 2);
		$this->load_date->ViewCustomAttributes = "";

		// trip_info
		$curVal = strval($this->trip_info->CurrentValue);
		if ($curVal <> "") {
			$this->trip_info->ViewValue = $this->trip_info->lookupCacheOption($curVal);
			if ($this->trip_info->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->trip_info->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->trip_info->ViewValue = $this->trip_info->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->trip_info->ViewValue = $this->trip_info->CurrentValue;
				}
			}
		} else {
			$this->trip_info->ViewValue = NULL;
		}
		$this->trip_info->ViewCustomAttributes = "";

		// driver
		$curVal = strval($this->driver->CurrentValue);
		if ($curVal <> "") {
			$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
			if ($this->driver->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$arwrk[2] = $rswrk->fields('df2');
					$this->driver->ViewValue = $this->driver->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->driver->ViewValue = $this->driver->CurrentValue;
				}
			}
		} else {
			$this->driver->ViewValue = NULL;
		}
		$this->driver->ViewCustomAttributes = "";

		// unload_km
		$this->unload_km->ViewValue = $this->unload_km->CurrentValue;
		$this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, 0, -2, -2, -2);
		$this->unload_km->ViewCustomAttributes = "";

		// load_weight
		$this->load_weight->ViewValue = $this->load_weight->CurrentValue;
		$this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, 0, -2, -2, -2);
		$this->load_weight->ViewCustomAttributes = "";

		// unload_weight
		$this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
		$this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, 0, -2, -2, -2);
		$this->unload_weight->ViewCustomAttributes = "";

		// unload_date
		$this->unload_date->ViewValue = $this->unload_date->CurrentValue;
		$this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, 0);
		$this->unload_date->ViewCustomAttributes = "";

		// ded_det
		$this->ded_det->ViewValue = $this->ded_det->CurrentValue;
		$this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, 2, -2, -2, -2);
		$this->ded_det->ViewCustomAttributes = "";

		// ded_det_remarks
		$this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;
		$this->ded_det_remarks->ViewCustomAttributes = "";

		// fasttag_cl_balance
		$this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
		$this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, 2, -2, -2, -2);
		$this->fasttag_cl_balance->ViewCustomAttributes = "";

		// delivery_receipt
		$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
			$this->delivery_receipt->ImageWidth = 0;
			$this->delivery_receipt->ImageHeight = 50;
			$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
			$this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
		} else {
			$this->delivery_receipt->ViewValue = "";
		}
		$this->delivery_receipt->ViewCustomAttributes = "";

		// delivery_pod
		if (strval($this->delivery_pod->CurrentValue) <> "") {
			$this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
		} else {
			$this->delivery_pod->ViewValue = NULL;
		}
		$this->delivery_pod->ViewCustomAttributes = "";

		// operator
		$curVal = strval($this->operator->CurrentValue);
		if ($curVal <> "") {
			$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
			if ($this->operator->ViewValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->operator->ViewValue = $this->operator->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->operator->ViewValue = $this->operator->CurrentValue;
				}
			}
		} else {
			$this->operator->ViewValue = NULL;
		}
		$this->operator->ViewCustomAttributes = "";

		// datetime
		$this->datetime->ViewValue = $this->datetime->CurrentValue;
		$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
		$this->datetime->ViewCustomAttributes = "";

		// id
		$this->id->LinkCustomAttributes = "";
		$this->id->HrefValue = "";
		$this->id->TooltipValue = "";

		// load_date
		$this->load_date->LinkCustomAttributes = "";
		$this->load_date->HrefValue = "";
		$this->load_date->TooltipValue = "";

		// trip_info
		$this->trip_info->LinkCustomAttributes = "";
		$this->trip_info->HrefValue = "";
		$this->trip_info->TooltipValue = "";

		// driver
		$this->driver->LinkCustomAttributes = "";
		$this->driver->HrefValue = "";
		$this->driver->TooltipValue = "";

		// unload_km
		$this->unload_km->LinkCustomAttributes = "";
		$this->unload_km->HrefValue = "";
		$this->unload_km->TooltipValue = "";

		// load_weight
		$this->load_weight->LinkCustomAttributes = "";
		$this->load_weight->HrefValue = "";
		$this->load_weight->TooltipValue = "";

		// unload_weight
		$this->unload_weight->LinkCustomAttributes = "";
		$this->unload_weight->HrefValue = "";
		$this->unload_weight->TooltipValue = "";

		// unload_date
		$this->unload_date->LinkCustomAttributes = "";
		$this->unload_date->HrefValue = "";
		$this->unload_date->TooltipValue = "";

		// ded_det
		$this->ded_det->LinkCustomAttributes = "";
		$this->ded_det->HrefValue = "";
		$this->ded_det->TooltipValue = "";

		// ded_det_remarks
		$this->ded_det_remarks->LinkCustomAttributes = "";
		$this->ded_det_remarks->HrefValue = "";
		$this->ded_det_remarks->TooltipValue = "";

		// fasttag_cl_balance
		$this->fasttag_cl_balance->LinkCustomAttributes = "";
		$this->fasttag_cl_balance->HrefValue = "";
		$this->fasttag_cl_balance->TooltipValue = "";

		// delivery_receipt
		$this->delivery_receipt->LinkCustomAttributes = "";
		$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
			$this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
			$this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
			if ($this->isExport()) $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
		} else {
			$this->delivery_receipt->HrefValue = "";
		}
		$this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;
		$this->delivery_receipt->TooltipValue = "";
		if ($this->delivery_receipt->UseColorbox) {
			if (EmptyValue($this->delivery_receipt->TooltipValue))
				$this->delivery_receipt->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
			$this->delivery_receipt->LinkAttrs["data-rel"] = "t_trip_info_d_unload_x_delivery_receipt";
			AppendClass($this->delivery_receipt->LinkAttrs["class"], "ew-lightbox");
		}

		// delivery_pod
		$this->delivery_pod->LinkCustomAttributes = "";
		$this->delivery_pod->HrefValue = "";
		$this->delivery_pod->TooltipValue = "";

		// operator
		$this->operator->LinkCustomAttributes = "";
		$this->operator->HrefValue = "";
		$this->operator->TooltipValue = "";

		// datetime
		$this->datetime->LinkCustomAttributes = "";
		$this->datetime->HrefValue = "";
		$this->datetime->TooltipValue = "";

		// Call Row Rendered event
		$this->Row_Rendered();

		// Save data for Custom Template
		$this->Rows[] = $this->customTemplateFieldValues();
	}

	// Render edit row values
	public function renderEditRow()
	{
		global $Security, $CurrentLanguage, $Language;

		// Call Row Rendering event
		$this->Row_Rendering();

		// id
		$this->id->EditAttrs["class"] = "form-control";
		$this->id->EditCustomAttributes = "";
		$this->id->EditValue = $this->id->CurrentValue;
		$this->id->ViewCustomAttributes = "";

		// load_date
		$this->load_date->EditAttrs["class"] = "form-control";
		$this->load_date->EditCustomAttributes = "";
		$this->load_date->EditValue = FormatDateTime($this->load_date->CurrentValue, 2);
		$this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

		// trip_info
		$this->trip_info->EditAttrs["class"] = "form-control";
		$this->trip_info->EditCustomAttributes = "";
		$curVal = strval($this->trip_info->CurrentValue);
		if ($curVal <> "") {
			$this->trip_info->EditValue = $this->trip_info->lookupCacheOption($curVal);
			if ($this->trip_info->EditValue === NULL) { // Lookup from database
				$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
				$sqlWrk = $this->trip_info->Lookup->getSql(FALSE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				if ($rswrk && !$rswrk->EOF) { // Lookup values found
					$arwrk = array();
					$arwrk[1] = $rswrk->fields('df');
					$this->trip_info->EditValue = $this->trip_info->displayValue($arwrk);
					$rswrk->Close();
				} else {
					$this->trip_info->EditValue = $this->trip_info->CurrentValue;
				}
			}
		} else {
			$this->trip_info->EditValue = NULL;
		}
		$this->trip_info->ViewCustomAttributes = "";

		// driver
		$this->driver->EditAttrs["class"] = "form-control";
		$this->driver->EditCustomAttributes = "";

		// unload_km
		$this->unload_km->EditAttrs["class"] = "form-control";
		$this->unload_km->EditCustomAttributes = "";
		$this->unload_km->EditValue = $this->unload_km->CurrentValue;
		$this->unload_km->PlaceHolder = RemoveHtml($this->unload_km->caption());

		// load_weight
		$this->load_weight->EditAttrs["class"] = "form-control";
		$this->load_weight->EditCustomAttributes = "";
		$this->load_weight->EditValue = $this->load_weight->CurrentValue;
		$this->load_weight->EditValue = FormatNumber($this->load_weight->EditValue, 0, -2, -2, -2);
		$this->load_weight->ViewCustomAttributes = "";

		// unload_weight
		$this->unload_weight->EditAttrs["class"] = "form-control";
		$this->unload_weight->EditCustomAttributes = "";
		$this->unload_weight->EditValue = $this->unload_weight->CurrentValue;
		$this->unload_weight->PlaceHolder = RemoveHtml($this->unload_weight->caption());

		// unload_date
		$this->unload_date->EditAttrs["class"] = "form-control";
		$this->unload_date->EditCustomAttributes = "";
		$this->unload_date->EditValue = FormatDateTime($this->unload_date->CurrentValue, 8);
		$this->unload_date->PlaceHolder = RemoveHtml($this->unload_date->caption());

		// ded_det
		$this->ded_det->EditAttrs["class"] = "form-control";
		$this->ded_det->EditCustomAttributes = "";
		$this->ded_det->EditValue = $this->ded_det->CurrentValue;
		$this->ded_det->PlaceHolder = RemoveHtml($this->ded_det->caption());
		if (strval($this->ded_det->EditValue) <> "" && is_numeric($this->ded_det->EditValue))
			$this->ded_det->EditValue = FormatNumber($this->ded_det->EditValue, -2, -2, -2, -2);

		// ded_det_remarks
		$this->ded_det_remarks->EditAttrs["class"] = "form-control";
		$this->ded_det_remarks->EditCustomAttributes = "";
		if (REMOVE_XSS)
			$this->ded_det_remarks->CurrentValue = HtmlDecode($this->ded_det_remarks->CurrentValue);
		$this->ded_det_remarks->EditValue = $this->ded_det_remarks->CurrentValue;
		$this->ded_det_remarks->PlaceHolder = RemoveHtml($this->ded_det_remarks->caption());

		// fasttag_cl_balance
		$this->fasttag_cl_balance->EditAttrs["class"] = "form-control";
		$this->fasttag_cl_balance->EditCustomAttributes = "";
		$this->fasttag_cl_balance->EditValue = $this->fasttag_cl_balance->CurrentValue;
		$this->fasttag_cl_balance->PlaceHolder = RemoveHtml($this->fasttag_cl_balance->caption());
		if (strval($this->fasttag_cl_balance->EditValue) <> "" && is_numeric($this->fasttag_cl_balance->EditValue))
			$this->fasttag_cl_balance->EditValue = FormatNumber($this->fasttag_cl_balance->EditValue, -2, -2, -2, -2);

		// delivery_receipt
		$this->delivery_receipt->EditAttrs["class"] = "form-control";
		$this->delivery_receipt->EditCustomAttributes = "";
		$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
		if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
			$this->delivery_receipt->ImageWidth = 0;
			$this->delivery_receipt->ImageHeight = 50;
			$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
			$this->delivery_receipt->EditValue = $this->delivery_receipt->Upload->DbValue;
		} else {
			$this->delivery_receipt->EditValue = "";
		}
		if (!EmptyValue($this->delivery_receipt->CurrentValue))
				$this->delivery_receipt->Upload->FileName = $this->delivery_receipt->CurrentValue;

		// delivery_pod
		$this->delivery_pod->EditCustomAttributes = "";
		$this->delivery_pod->EditValue = $this->delivery_pod->options(FALSE);

		// operator
		// datetime
		// Call Row Rendered event

		$this->Row_Rendered();
	}

	// Aggregate list row values
	public function aggregateListRowValues()
	{
	}

	// Aggregate list row (for rendering)
	public function aggregateListRow()
	{

		// Call Row Rendered event
		$this->Row_Rendered();
	}

	// Export data in HTML/CSV/Word/Excel/Email/PDF format
	public function exportDocument($doc, $recordset, $startRec = 1, $stopRec = 1, $exportPageType = "")
	{
		if (!$recordset || !$doc)
			return;
		if (!$doc->ExportCustom) {

			// Write header
			$doc->exportTableHeader();
			if ($doc->Horizontal) { // Horizontal format, write header
				$doc->beginExportRow();
				if ($exportPageType == "view") {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->load_date);
					$doc->exportCaption($this->trip_info);
					$doc->exportCaption($this->driver);
					$doc->exportCaption($this->unload_km);
					$doc->exportCaption($this->load_weight);
					$doc->exportCaption($this->unload_weight);
					$doc->exportCaption($this->unload_date);
					$doc->exportCaption($this->ded_det);
					$doc->exportCaption($this->ded_det_remarks);
					$doc->exportCaption($this->fasttag_cl_balance);
					$doc->exportCaption($this->delivery_receipt);
					$doc->exportCaption($this->delivery_pod);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				} else {
					$doc->exportCaption($this->id);
					$doc->exportCaption($this->load_date);
					$doc->exportCaption($this->trip_info);
					$doc->exportCaption($this->driver);
					$doc->exportCaption($this->unload_km);
					$doc->exportCaption($this->load_weight);
					$doc->exportCaption($this->unload_weight);
					$doc->exportCaption($this->unload_date);
					$doc->exportCaption($this->ded_det);
					$doc->exportCaption($this->ded_det_remarks);
					$doc->exportCaption($this->fasttag_cl_balance);
					$doc->exportCaption($this->delivery_receipt);
					$doc->exportCaption($this->delivery_pod);
					$doc->exportCaption($this->operator);
					$doc->exportCaption($this->datetime);
				}
				$doc->endExportRow();
			}
		}

		// Move to first record
		$recCnt = $startRec - 1;
		if (!$recordset->EOF) {
			$recordset->moveFirst();
			if ($startRec > 1)
				$recordset->move($startRec - 1);
		}
		while (!$recordset->EOF && $recCnt < $stopRec) {
			$recCnt++;
			if ($recCnt >= $startRec) {
				$rowCnt = $recCnt - $startRec + 1;

				// Page break
				if ($this->ExportPageBreakCount > 0) {
					if ($rowCnt > 1 && ($rowCnt - 1) % $this->ExportPageBreakCount == 0)
						$doc->exportPageBreak();
				}
				$this->loadListRowValues($recordset);

				// Render row
				$this->RowType = ROWTYPE_VIEW; // Render view
				$this->resetAttributes();
				$this->renderListRow();
				if (!$doc->ExportCustom) {
					$doc->beginExportRow($rowCnt); // Allow CSS styles if enabled
					if ($exportPageType == "view") {
						$doc->exportField($this->id);
						$doc->exportField($this->load_date);
						$doc->exportField($this->trip_info);
						$doc->exportField($this->driver);
						$doc->exportField($this->unload_km);
						$doc->exportField($this->load_weight);
						$doc->exportField($this->unload_weight);
						$doc->exportField($this->unload_date);
						$doc->exportField($this->ded_det);
						$doc->exportField($this->ded_det_remarks);
						$doc->exportField($this->fasttag_cl_balance);
						$doc->exportField($this->delivery_receipt);
						$doc->exportField($this->delivery_pod);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					} else {
						$doc->exportField($this->id);
						$doc->exportField($this->load_date);
						$doc->exportField($this->trip_info);
						$doc->exportField($this->driver);
						$doc->exportField($this->unload_km);
						$doc->exportField($this->load_weight);
						$doc->exportField($this->unload_weight);
						$doc->exportField($this->unload_date);
						$doc->exportField($this->ded_det);
						$doc->exportField($this->ded_det_remarks);
						$doc->exportField($this->fasttag_cl_balance);
						$doc->exportField($this->delivery_receipt);
						$doc->exportField($this->delivery_pod);
						$doc->exportField($this->operator);
						$doc->exportField($this->datetime);
					}
					$doc->endExportRow($rowCnt);
				}
			}

			// Call Row Export server event
			if ($doc->ExportCustom)
				$this->Row_Export($recordset->fields);
			$recordset->moveNext();
		}
		if (!$doc->ExportCustom) {
			$doc->exportTableFooter();
		}
	}

	// Lookup data from table
	public function lookup()
	{
		global $Language, $LANGUAGE_FOLDER, $PROJECT_ID;
		if (!isset($Language))
			$Language = new Language($LANGUAGE_FOLDER, Post("language", ""));
		global $Security, $RequestSecurity;

		// Check token first
		$func = PROJECT_NAMESPACE . "CheckToken";
		$validRequest = FALSE;
		if (is_callable($func) && Post(TOKEN_NAME) !== NULL) {
			$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			if ($validRequest) {
				if (!isset($Security)) {
					if (session_status() !== PHP_SESSION_ACTIVE)
						session_start(); // Init session data
					$Security = new AdvancedSecurity();
					if ($Security->isLoggedIn()) $Security->TablePermission_Loading();
					$Security->loadCurrentUserLevel($PROJECT_ID . $this->TableName);
					if ($Security->isLoggedIn()) $Security->TablePermission_Loaded();
					$validRequest = $Security->canList(); // List permission
					if ($validRequest) {
						$Security->UserID_Loading();
						$Security->loadUserID();
						$Security->UserID_Loaded();
					}
				}
			}
		} else {

			// User profile
			$UserProfile = new UserProfile();

			// Security
			$Security = new AdvancedSecurity();
			if (is_array($RequestSecurity)) // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
			$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel(CurrentProjectID() . $this->TableName);
			$Security->TablePermission_Loaded();
			$validRequest = $Security->canList(); // List permission
		}

		// Reject invalid request
		//if (!$validRequest)
		//	return FALSE;
		// Load lookup parameters

		$distinct = ConvertToBool(Post("distinct"));
		$linkField = Post("linkField");
		$displayFields = Post("displayFields");
		$parentFields = Post("parentFields");
		if (!is_array($parentFields))
			$parentFields = [];
		$childFields = Post("childFields");
		if (!is_array($childFields))
			$childFields = [];
		$filterFields = Post("filterFields");
		if (!is_array($filterFields))
			$filterFields = [];
		$filterFieldVars = Post("filterFieldVars");
		if (!is_array($filterFieldVars))
			$filterFieldVars = [];
		$filterOperators = Post("filterOperators");
		if (!is_array($filterOperators))
			$filterOperators = [];
		$autoFillSourceFields = Post("autoFillSourceFields");
		if (!is_array($autoFillSourceFields))
			$autoFillSourceFields = [];
		$formatAutoFill = FALSE;
		$lookupType = Post("ajax", "unknown");
		$pageSize = -1;
		$offset = -1;
		$searchValue = "";
		if (SameText($lookupType, "modal")) {
			$searchValue = Post("sv", "");
			$pageSize = Post("recperpage", 10);
			$offset = Post("start", 0);
		} elseif (SameText($lookupType, "autosuggest")) {
			$searchValue = Get("q", "");
			$pageSize = Param("n", -1);
			$pageSize = is_numeric($pageSize) ? (int)$pageSize : -1;
			if ($pageSize <= 0)
				$pageSize = AUTO_SUGGEST_MAX_ENTRIES;
			$start = Param("start", -1);
			$start = is_numeric($start) ? (int)$start : -1;
			$page = Param("page", -1);
			$page = is_numeric($page) ? (int)$page : -1;
			$offset = $start >= 0 ? $start : ($page > 0 && $pageSize > 0 ? ($page - 1) * $pageSize : 0);
		}
		$userSelect = Decrypt(Post("s", ""));
		$userFilter = Decrypt(Post("f", ""));
		$userOrderBy = Decrypt(Post("o", ""));
		$keys = Post("keys");

		// Selected records from modal, skip parent/filter fields and show all records
		if ($keys !== NULL) {
			$parentFields = [];
			$filterFields = [];
			$filterFieldVars = [];
			$offset = 0;
			$pageSize = 0;
		}

		// Create lookup object and output JSON
		$lookup = new Lookup($linkField, $this->TableVar, $distinct, $linkField, $displayFields, $parentFields, $childFields, $filterFields, $filterFieldVars, $autoFillSourceFields);
		foreach ($filterFields as $i => $filterField) { // Set up filter operators
			if (@$filterOperators[$i] <> "")
				$lookup->setFilterOperator($filterField, $filterOperators[$i]);
		}
		$lookup->LookupType = $lookupType; // Lookup type
		if ($keys !== NULL) { // Selected records from modal
			if (is_array($keys))
				$keys = implode(LOOKUP_FILTER_VALUE_SEPARATOR, $keys);
			$lookup->FilterValues[] = $keys; // Lookup values
		} else { // Lookup values
			$lookup->FilterValues[] = Post("v0", Post("lookupValue", ""));
		}
		$cnt = is_array($filterFields) ? count($filterFields) : 0;
		for ($i = 1; $i <= $cnt; $i++)
			$lookup->FilterValues[] = Post("v" . $i, "");
		$lookup->SearchValue = $searchValue;
		$lookup->PageSize = $pageSize;
		$lookup->Offset = $offset;
		if ($userSelect <> "")
			$lookup->UserSelect = $userSelect;
		if ($userFilter <> "")
			$lookup->UserFilter = $userFilter;
		if ($userOrderBy <> "")
			$lookup->UserOrderBy = $userOrderBy;
		$lookup->toJson();
	}

	// Get file data
	public function getFileData($fldparm, $key, $resize, $width = THUMBNAIL_DEFAULT_WIDTH, $height = THUMBNAIL_DEFAULT_HEIGHT)
	{
		global $COMPOSITE_KEY_SEPARATOR;

		// Set up field name / file name field / file type field
		$fldName = "";
		$fileNameFld = "";
		$fileTypeFld = "";
		if ($fldparm == 'delivery_receipt') {
			$fldName = "delivery_receipt";
			$fileNameFld = "delivery_receipt";
		} else {
			return FALSE; // Incorrect field
		}

		// Set up key values
		$ar = explode($COMPOSITE_KEY_SEPARATOR, $key);
		if (count($ar) == 1) {
			$this->id->CurrentValue = $ar[0];
		} else {
			return FALSE; // Incorrect key
		}

		// Set up filter (WHERE Clause)
		$filter = $this->getRecordFilter();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$dbtype = GetConnectionType($this->Dbid);
		if (($rs = $conn->execute($sql)) && !$rs->EOF) {
			$val = $rs->fields($fldName);
			if (!EmptyValue($val)) {
				$fld = $this->fields[$fldName];

				// Binary data
				if ($fld->DataType == DATATYPE_BLOB) {
					if ($dbtype <> "MYSQL") {
						if (is_array($val) || is_object($val)) // Byte array
							$val = BytesToString($val);
					}
					if ($resize)
						ResizeBinary($val, $width, $height);

					// Write file type
					if ($fileTypeFld <> "" && !EmptyValue($rs->fields($fileTypeFld))) {
						AddHeader("Content-type", $rs->fields($fileTypeFld));
					} else {
						AddHeader("Content-type", ContentType($val));
					}

					// Write file name
					if ($fileNameFld <> "" && !EmptyValue($rs->fields($fileNameFld)))
						AddHeader("Content-Disposition", "attachment; filename=\"" . $rs->fields($fileNameFld) . "\"");

					// Write file data
					if (StartsString("PK", $val) && ContainsString($val, "[Content_Types].xml") &&
						ContainsString($val, "_rels") && ContainsString($val, "docProps")) { // Fix Office 2007 documents
						if (!EndsString("\0\0\0", $val)) // Not ends with 3 or 4 \0
							$val .= "\0\0\0\0";
					}

					// Clear output buffer
					if (ob_get_length())
						ob_end_clean();

					// Write binary data
					Write($val);

				// Upload to folder
				} else {
					if ($fld->UploadMultiple)
						$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
					else
						$files = [$val];
					$data = [];
					$ar = [];
					foreach ($files as $file) {
						if (!EmptyValue($file))
							$ar[$file] = FullUrl($fld->hrefPath() . $file);
					}
					$data[$fld->Param] = $ar;
					WriteJson($data);
				}
			}
			$rs->close();
			return TRUE;
		}
		return FALSE;
	}

	// Table level events
	// Recordset Selecting event
	function Recordset_Selecting(&$filter) {

		// Enter your code here
	}

	// Recordset Selected event
	function Recordset_Selected(&$rs) {

		//echo "Recordset Selected";
	}

	// Recordset Search Validated event
	function Recordset_SearchValidated() {

		// Example:
		//$this->MyField1->AdvancedSearch->SearchValue = "your search criteria"; // Search value

	}

	// Recordset Searching event
	function Recordset_Searching(&$filter) {

		// Enter your code here
	}

	// Row_Selecting event
	function Row_Selecting(&$filter) {

		// Enter your code here
	}

	// Row Selected event
	function Row_Selected(&$rs) {

		//echo "Row Selected";
	}

	// Row Inserting event
	function Row_Inserting($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Inserted event
	function Row_Inserted($rsold, &$rsnew) {

		//echo "Row Inserted"
	}

	// Row Updating event
	function Row_Updating($rsold, &$rsnew) {

		// Enter your code here
		// To cancel, set return value to FALSE

		return TRUE;
	}

	// Row Updated event
	function Row_Updated($rsold, &$rsnew) {

		//echo "Row Updated";
	}

	// Row Update Conflict event
	function Row_UpdateConflict($rsold, &$rsnew) {

		// Enter your code here
		// To ignore conflict, set return value to FALSE

		return TRUE;
	}

	// Grid Inserting event
	function Grid_Inserting() {

		// Enter your code here
		// To reject grid insert, set return value to FALSE

		return TRUE;
	}

	// Grid Inserted event
	function Grid_Inserted($rsnew) {

		//echo "Grid Inserted";
	}

	// Grid Updating event
	function Grid_Updating($rsold) {

		// Enter your code here
		// To reject grid update, set return value to FALSE

		return TRUE;
	}

	// Grid Updated event
	function Grid_Updated($rsold, $rsnew) {

		//echo "Grid Updated";
	}

	// Row Deleting event
	function Row_Deleting(&$rs) {

		// Enter your code here
		// To cancel, set return value to False

		return TRUE;
	}

	// Row Deleted event
	function Row_Deleted(&$rs) {

		//echo "Row Deleted";
	}

	// Email Sending event
	function Email_Sending($email, &$args) {

		//var_dump($email); var_dump($args); exit();
		return TRUE;
	}

	// Lookup Selecting event
	function Lookup_Selecting($fld, &$filter) {

		//var_dump($fld->Name, $fld->Lookup, $filter); // Uncomment to view the filter
		// Enter your code here

	}

	// Row Rendering event
	function Row_Rendering() {

		// Enter your code here
	}

	// Row Rendered event
	function Row_Rendered() {

		// To view properties of field class, use:
		//var_dump($this-><FieldName>);

	}

	// User ID Filtering event
	function UserID_Filtering(&$filter) {

		// Enter your code here
	}
}
?>