<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class t_trip_info_d_unload_edit extends t_trip_info_d_unload
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 't_trip_info_d_unload';

	// Page object name
	public $PageObjName = "t_trip_info_d_unload_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (t_trip_info_d_unload)
		if (!isset($GLOBALS["t_trip_info_d_unload"]) || get_class($GLOBALS["t_trip_info_d_unload"]) == PROJECT_NAMESPACE . "t_trip_info_d_unload") {
			$GLOBALS["t_trip_info_d_unload"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["t_trip_info_d_unload"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_info_d_unload');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $t_trip_info_d_unload;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($t_trip_info_d_unload);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "t_trip_info_d_unloadview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->trip_info->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("t_trip_info_d_unloadlist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->load_date->setVisibility();
		$this->trip_info->setVisibility();
		$this->driver->setVisibility();
		$this->unload_km->setVisibility();
		$this->load_weight->setVisibility();
		$this->unload_weight->setVisibility();
		$this->unload_date->setVisibility();
		$this->ded_det->setVisibility();
		$this->ded_det_remarks->setVisibility();
		$this->fasttag_cl_balance->setVisibility();
		$this->delivery_receipt->setVisibility();
		$this->delivery_pod->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->trip_info);
		$this->setupLookupOptions($this->driver);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("t_trip_info_d_unloadlist.php"); // No matching record, return to list
				}
				break;
			case "update": // Update
				$returnUrl = 'autoprogramme.php?apcid=c5866e93cab1776890fe343c9e7063fb&ti=' . $this->id->CurrentValue . '';
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->delivery_receipt->Upload->Index = $CurrentForm->Index;
		$this->delivery_receipt->Upload->uploadFile();
		$this->delivery_receipt->CurrentValue = $this->delivery_receipt->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'load_date' first before field var 'x_load_date'
		$val = $CurrentForm->hasValue("load_date") ? $CurrentForm->getValue("load_date") : $CurrentForm->getValue("x_load_date");
		if (!$this->load_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->load_date->Visible = FALSE; // Disable update for API request
			else
				$this->load_date->setFormValue($val);
			$this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, 2);
		}

		// Check field name 'trip_info' first before field var 'x_trip_info'
		$val = $CurrentForm->hasValue("trip_info") ? $CurrentForm->getValue("trip_info") : $CurrentForm->getValue("x_trip_info");
		if (!$this->trip_info->IsDetailKey)
			$this->trip_info->setFormValue($val);

		// Check field name 'driver' first before field var 'x_driver'
		$val = $CurrentForm->hasValue("driver") ? $CurrentForm->getValue("driver") : $CurrentForm->getValue("x_driver");
		if (!$this->driver->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->driver->Visible = FALSE; // Disable update for API request
			else
				$this->driver->setFormValue($val);
		}

		// Check field name 'unload_km' first before field var 'x_unload_km'
		$val = $CurrentForm->hasValue("unload_km") ? $CurrentForm->getValue("unload_km") : $CurrentForm->getValue("x_unload_km");
		if (!$this->unload_km->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unload_km->Visible = FALSE; // Disable update for API request
			else
				$this->unload_km->setFormValue($val);
		}

		// Check field name 'load_weight' first before field var 'x_load_weight'
		$val = $CurrentForm->hasValue("load_weight") ? $CurrentForm->getValue("load_weight") : $CurrentForm->getValue("x_load_weight");
		if (!$this->load_weight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->load_weight->Visible = FALSE; // Disable update for API request
			else
				$this->load_weight->setFormValue($val);
		}

		// Check field name 'unload_weight' first before field var 'x_unload_weight'
		$val = $CurrentForm->hasValue("unload_weight") ? $CurrentForm->getValue("unload_weight") : $CurrentForm->getValue("x_unload_weight");
		if (!$this->unload_weight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unload_weight->Visible = FALSE; // Disable update for API request
			else
				$this->unload_weight->setFormValue($val);
		}

		// Check field name 'unload_date' first before field var 'x_unload_date'
		$val = $CurrentForm->hasValue("unload_date") ? $CurrentForm->getValue("unload_date") : $CurrentForm->getValue("x_unload_date");
		if (!$this->unload_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unload_date->Visible = FALSE; // Disable update for API request
			else
				$this->unload_date->setFormValue($val);
			$this->unload_date->CurrentValue = UnFormatDateTime($this->unload_date->CurrentValue, 0);
		}

		// Check field name 'ded_det' first before field var 'x_ded_det'
		$val = $CurrentForm->hasValue("ded_det") ? $CurrentForm->getValue("ded_det") : $CurrentForm->getValue("x_ded_det");
		if (!$this->ded_det->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ded_det->Visible = FALSE; // Disable update for API request
			else
				$this->ded_det->setFormValue($val);
		}

		// Check field name 'ded_det_remarks' first before field var 'x_ded_det_remarks'
		$val = $CurrentForm->hasValue("ded_det_remarks") ? $CurrentForm->getValue("ded_det_remarks") : $CurrentForm->getValue("x_ded_det_remarks");
		if (!$this->ded_det_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ded_det_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->ded_det_remarks->setFormValue($val);
		}

		// Check field name 'fasttag_cl_balance' first before field var 'x_fasttag_cl_balance'
		$val = $CurrentForm->hasValue("fasttag_cl_balance") ? $CurrentForm->getValue("fasttag_cl_balance") : $CurrentForm->getValue("x_fasttag_cl_balance");
		if (!$this->fasttag_cl_balance->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fasttag_cl_balance->Visible = FALSE; // Disable update for API request
			else
				$this->fasttag_cl_balance->setFormValue($val);
		}

		// Check field name 'delivery_pod' first before field var 'x_delivery_pod'
		$val = $CurrentForm->hasValue("delivery_pod") ? $CurrentForm->getValue("delivery_pod") : $CurrentForm->getValue("x_delivery_pod");
		if (!$this->delivery_pod->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery_pod->Visible = FALSE; // Disable update for API request
			else
				$this->delivery_pod->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->load_date->CurrentValue = $this->load_date->FormValue;
		$this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, 2);
		$this->trip_info->CurrentValue = $this->trip_info->FormValue;
		$this->driver->CurrentValue = $this->driver->FormValue;
		$this->unload_km->CurrentValue = $this->unload_km->FormValue;
		$this->load_weight->CurrentValue = $this->load_weight->FormValue;
		$this->unload_weight->CurrentValue = $this->unload_weight->FormValue;
		$this->unload_date->CurrentValue = $this->unload_date->FormValue;
		$this->unload_date->CurrentValue = UnFormatDateTime($this->unload_date->CurrentValue, 0);
		$this->ded_det->CurrentValue = $this->ded_det->FormValue;
		$this->ded_det_remarks->CurrentValue = $this->ded_det_remarks->FormValue;
		$this->fasttag_cl_balance->CurrentValue = $this->fasttag_cl_balance->FormValue;
		$this->delivery_pod->CurrentValue = $this->delivery_pod->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->load_date->setDbValue($row['load_date']);
		$this->trip_info->setDbValue($row['trip_info']);
		$this->driver->setDbValue($row['driver']);
		$this->unload_km->setDbValue($row['unload_km']);
		$this->load_weight->setDbValue($row['load_weight']);
		$this->unload_weight->setDbValue($row['unload_weight']);
		$this->unload_date->setDbValue($row['unload_date']);
		$this->ded_det->setDbValue($row['ded_det']);
		$this->ded_det_remarks->setDbValue($row['ded_det_remarks']);
		$this->fasttag_cl_balance->setDbValue($row['fasttag_cl_balance']);
		$this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
		$this->delivery_receipt->setDbValue($this->delivery_receipt->Upload->DbValue);
		$this->delivery_pod->setDbValue($row['delivery_pod']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['load_date'] = NULL;
		$row['trip_info'] = NULL;
		$row['driver'] = NULL;
		$row['unload_km'] = NULL;
		$row['load_weight'] = NULL;
		$row['unload_weight'] = NULL;
		$row['unload_date'] = NULL;
		$row['ded_det'] = NULL;
		$row['ded_det_remarks'] = NULL;
		$row['fasttag_cl_balance'] = NULL;
		$row['delivery_receipt'] = NULL;
		$row['delivery_pod'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->ded_det->FormValue == $this->ded_det->CurrentValue && is_numeric(ConvertToFloatString($this->ded_det->CurrentValue)))
			$this->ded_det->CurrentValue = ConvertToFloatString($this->ded_det->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_cl_balance->FormValue == $this->fasttag_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_cl_balance->CurrentValue)))
			$this->fasttag_cl_balance->CurrentValue = ConvertToFloatString($this->fasttag_cl_balance->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// load_date
		// trip_info
		// driver
		// unload_km
		// load_weight
		// unload_weight
		// unload_date
		// ded_det
		// ded_det_remarks
		// fasttag_cl_balance
		// delivery_receipt
		// delivery_pod
		// operator
		// datetime

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// load_date
			$this->load_date->ViewValue = $this->load_date->CurrentValue;
			$this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, 2);
			$this->load_date->ViewCustomAttributes = "";

			// trip_info
			$curVal = strval($this->trip_info->CurrentValue);
			if ($curVal <> "") {
				$this->trip_info->ViewValue = $this->trip_info->lookupCacheOption($curVal);
				if ($this->trip_info->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->trip_info->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->trip_info->ViewValue = $this->trip_info->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->trip_info->ViewValue = $this->trip_info->CurrentValue;
					}
				}
			} else {
				$this->trip_info->ViewValue = NULL;
			}
			$this->trip_info->ViewCustomAttributes = "";

			// driver
			$curVal = strval($this->driver->CurrentValue);
			if ($curVal <> "") {
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
				if ($this->driver->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->driver->ViewValue = $this->driver->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->driver->ViewValue = $this->driver->CurrentValue;
					}
				}
			} else {
				$this->driver->ViewValue = NULL;
			}
			$this->driver->ViewCustomAttributes = "";

			// unload_km
			$this->unload_km->ViewValue = $this->unload_km->CurrentValue;
			$this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, 0, -2, -2, -2);
			$this->unload_km->ViewCustomAttributes = "";

			// load_weight
			$this->load_weight->ViewValue = $this->load_weight->CurrentValue;
			$this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, 0, -2, -2, -2);
			$this->load_weight->ViewCustomAttributes = "";

			// unload_weight
			$this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
			$this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, 0, -2, -2, -2);
			$this->unload_weight->ViewCustomAttributes = "";

			// unload_date
			$this->unload_date->ViewValue = $this->unload_date->CurrentValue;
			$this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, 0);
			$this->unload_date->ViewCustomAttributes = "";

			// ded_det
			$this->ded_det->ViewValue = $this->ded_det->CurrentValue;
			$this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, 2, -2, -2, -2);
			$this->ded_det->ViewCustomAttributes = "";

			// ded_det_remarks
			$this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;
			$this->ded_det_remarks->ViewCustomAttributes = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
			$this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->fasttag_cl_balance->ViewCustomAttributes = "";

			// delivery_receipt
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->ImageWidth = 0;
				$this->delivery_receipt->ImageHeight = 50;
				$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
				$this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
			} else {
				$this->delivery_receipt->ViewValue = "";
			}
			$this->delivery_receipt->ViewCustomAttributes = "";

			// delivery_pod
			if (strval($this->delivery_pod->CurrentValue) <> "") {
				$this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
			} else {
				$this->delivery_pod->ViewValue = NULL;
			}
			$this->delivery_pod->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// load_date
			$this->load_date->LinkCustomAttributes = "";
			$this->load_date->HrefValue = "";
			$this->load_date->TooltipValue = "";

			// trip_info
			$this->trip_info->LinkCustomAttributes = "";
			$this->trip_info->HrefValue = "";
			$this->trip_info->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";
			$this->driver->TooltipValue = "";

			// unload_km
			$this->unload_km->LinkCustomAttributes = "";
			$this->unload_km->HrefValue = "";
			$this->unload_km->TooltipValue = "";

			// load_weight
			$this->load_weight->LinkCustomAttributes = "";
			$this->load_weight->HrefValue = "";
			$this->load_weight->TooltipValue = "";

			// unload_weight
			$this->unload_weight->LinkCustomAttributes = "";
			$this->unload_weight->HrefValue = "";
			$this->unload_weight->TooltipValue = "";

			// unload_date
			$this->unload_date->LinkCustomAttributes = "";
			$this->unload_date->HrefValue = "";
			$this->unload_date->TooltipValue = "";

			// ded_det
			$this->ded_det->LinkCustomAttributes = "";
			$this->ded_det->HrefValue = "";
			$this->ded_det->TooltipValue = "";

			// ded_det_remarks
			$this->ded_det_remarks->LinkCustomAttributes = "";
			$this->ded_det_remarks->HrefValue = "";
			$this->ded_det_remarks->TooltipValue = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->LinkCustomAttributes = "";
			$this->fasttag_cl_balance->HrefValue = "";
			$this->fasttag_cl_balance->TooltipValue = "";

			// delivery_receipt
			$this->delivery_receipt->LinkCustomAttributes = "";
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
				$this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
			} else {
				$this->delivery_receipt->HrefValue = "";
			}
			$this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;
			$this->delivery_receipt->TooltipValue = "";
			if ($this->delivery_receipt->UseColorbox) {
				if (EmptyValue($this->delivery_receipt->TooltipValue))
					$this->delivery_receipt->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->delivery_receipt->LinkAttrs["data-rel"] = "t_trip_info_d_unload_x_delivery_receipt";
				AppendClass($this->delivery_receipt->LinkAttrs["class"], "ew-lightbox");
			}

			// delivery_pod
			$this->delivery_pod->LinkCustomAttributes = "";
			$this->delivery_pod->HrefValue = "";
			$this->delivery_pod->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// load_date
			$this->load_date->EditAttrs["class"] = "form-control";
			$this->load_date->EditCustomAttributes = "";
			$this->load_date->EditValue = HtmlEncode(FormatDateTime($this->load_date->CurrentValue, 2));
			$this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

			// trip_info
			$this->trip_info->EditAttrs["class"] = "form-control";
			$this->trip_info->EditCustomAttributes = "";
			$curVal = strval($this->trip_info->CurrentValue);
			if ($curVal <> "") {
				$this->trip_info->EditValue = $this->trip_info->lookupCacheOption($curVal);
				if ($this->trip_info->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->trip_info->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->trip_info->EditValue = $this->trip_info->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->trip_info->EditValue = $this->trip_info->CurrentValue;
					}
				}
			} else {
				$this->trip_info->EditValue = NULL;
			}
			$this->trip_info->ViewCustomAttributes = "";

			// driver
			$this->driver->EditAttrs["class"] = "form-control";
			$this->driver->EditCustomAttributes = "";
			$curVal = trim(strval($this->driver->CurrentValue));
			if ($curVal <> "")
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
			else
				$this->driver->ViewValue = $this->driver->Lookup !== NULL && is_array($this->driver->Lookup->Options) ? $curVal : NULL;
			if ($this->driver->ViewValue !== NULL) { // Load from cache
				$this->driver->EditValue = array_values($this->driver->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->driver->CurrentValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->driver->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->driver->EditValue = $arwrk;
			}

			// unload_km
			$this->unload_km->EditAttrs["class"] = "form-control";
			$this->unload_km->EditCustomAttributes = "";
			$this->unload_km->EditValue = HtmlEncode($this->unload_km->CurrentValue);
			$this->unload_km->PlaceHolder = RemoveHtml($this->unload_km->caption());

			// load_weight
			$this->load_weight->EditAttrs["class"] = "form-control";
			$this->load_weight->EditCustomAttributes = "";
			$this->load_weight->EditValue = $this->load_weight->CurrentValue;
			$this->load_weight->EditValue = FormatNumber($this->load_weight->EditValue, 0, -2, -2, -2);
			$this->load_weight->ViewCustomAttributes = "";

			// unload_weight
			$this->unload_weight->EditAttrs["class"] = "form-control";
			$this->unload_weight->EditCustomAttributes = "";
			$this->unload_weight->EditValue = HtmlEncode($this->unload_weight->CurrentValue);
			$this->unload_weight->PlaceHolder = RemoveHtml($this->unload_weight->caption());

			// unload_date
			$this->unload_date->EditAttrs["class"] = "form-control";
			$this->unload_date->EditCustomAttributes = "";
			$this->unload_date->EditValue = HtmlEncode(FormatDateTime($this->unload_date->CurrentValue, 8));
			$this->unload_date->PlaceHolder = RemoveHtml($this->unload_date->caption());

			// ded_det
			$this->ded_det->EditAttrs["class"] = "form-control";
			$this->ded_det->EditCustomAttributes = "";
			$this->ded_det->EditValue = HtmlEncode($this->ded_det->CurrentValue);
			$this->ded_det->PlaceHolder = RemoveHtml($this->ded_det->caption());
			if (strval($this->ded_det->EditValue) <> "" && is_numeric($this->ded_det->EditValue))
				$this->ded_det->EditValue = FormatNumber($this->ded_det->EditValue, -2, -2, -2, -2);

			// ded_det_remarks
			$this->ded_det_remarks->EditAttrs["class"] = "form-control";
			$this->ded_det_remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ded_det_remarks->CurrentValue = HtmlDecode($this->ded_det_remarks->CurrentValue);
			$this->ded_det_remarks->EditValue = HtmlEncode($this->ded_det_remarks->CurrentValue);
			$this->ded_det_remarks->PlaceHolder = RemoveHtml($this->ded_det_remarks->caption());

			// fasttag_cl_balance
			$this->fasttag_cl_balance->EditAttrs["class"] = "form-control";
			$this->fasttag_cl_balance->EditCustomAttributes = "";
			$this->fasttag_cl_balance->EditValue = HtmlEncode($this->fasttag_cl_balance->CurrentValue);
			$this->fasttag_cl_balance->PlaceHolder = RemoveHtml($this->fasttag_cl_balance->caption());
			if (strval($this->fasttag_cl_balance->EditValue) <> "" && is_numeric($this->fasttag_cl_balance->EditValue))
				$this->fasttag_cl_balance->EditValue = FormatNumber($this->fasttag_cl_balance->EditValue, -2, -2, -2, -2);

			// delivery_receipt
			$this->delivery_receipt->EditAttrs["class"] = "form-control";
			$this->delivery_receipt->EditCustomAttributes = "";
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->ImageWidth = 0;
				$this->delivery_receipt->ImageHeight = 50;
				$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
				$this->delivery_receipt->EditValue = $this->delivery_receipt->Upload->DbValue;
			} else {
				$this->delivery_receipt->EditValue = "";
			}
			if (!EmptyValue($this->delivery_receipt->CurrentValue))
					$this->delivery_receipt->Upload->FileName = $this->delivery_receipt->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->delivery_receipt);

			// delivery_pod
			$this->delivery_pod->EditCustomAttributes = "";
			$this->delivery_pod->EditValue = $this->delivery_pod->options(FALSE);

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// load_date
			$this->load_date->LinkCustomAttributes = "";
			$this->load_date->HrefValue = "";

			// trip_info
			$this->trip_info->LinkCustomAttributes = "";
			$this->trip_info->HrefValue = "";
			$this->trip_info->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";

			// unload_km
			$this->unload_km->LinkCustomAttributes = "";
			$this->unload_km->HrefValue = "";

			// load_weight
			$this->load_weight->LinkCustomAttributes = "";
			$this->load_weight->HrefValue = "";
			$this->load_weight->TooltipValue = "";

			// unload_weight
			$this->unload_weight->LinkCustomAttributes = "";
			$this->unload_weight->HrefValue = "";

			// unload_date
			$this->unload_date->LinkCustomAttributes = "";
			$this->unload_date->HrefValue = "";

			// ded_det
			$this->ded_det->LinkCustomAttributes = "";
			$this->ded_det->HrefValue = "";

			// ded_det_remarks
			$this->ded_det_remarks->LinkCustomAttributes = "";
			$this->ded_det_remarks->HrefValue = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->LinkCustomAttributes = "";
			$this->fasttag_cl_balance->HrefValue = "";

			// delivery_receipt
			$this->delivery_receipt->LinkCustomAttributes = "";
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
				$this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
			} else {
				$this->delivery_receipt->HrefValue = "";
			}
			$this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;

			// delivery_pod
			$this->delivery_pod->LinkCustomAttributes = "";
			$this->delivery_pod->HrefValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->load_date->Required) {
			if (!$this->load_date->IsDetailKey && $this->load_date->FormValue != NULL && $this->load_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_date->caption(), $this->load_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->load_date->FormValue)) {
			AddMessage($FormError, $this->load_date->errorMessage());
		}
		if ($this->trip_info->Required) {
			if (!$this->trip_info->IsDetailKey && $this->trip_info->FormValue != NULL && $this->trip_info->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->trip_info->caption(), $this->trip_info->RequiredErrorMessage));
			}
		}
		if ($this->driver->Required) {
			if (!$this->driver->IsDetailKey && $this->driver->FormValue != NULL && $this->driver->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver->caption(), $this->driver->RequiredErrorMessage));
			}
		}
		if ($this->unload_km->Required) {
			if (!$this->unload_km->IsDetailKey && $this->unload_km->FormValue != NULL && $this->unload_km->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_km->caption(), $this->unload_km->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->unload_km->FormValue)) {
			AddMessage($FormError, $this->unload_km->errorMessage());
		}
		if ($this->load_weight->Required) {
			if (!$this->load_weight->IsDetailKey && $this->load_weight->FormValue != NULL && $this->load_weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_weight->caption(), $this->load_weight->RequiredErrorMessage));
			}
		}
		if ($this->unload_weight->Required) {
			if (!$this->unload_weight->IsDetailKey && $this->unload_weight->FormValue != NULL && $this->unload_weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_weight->caption(), $this->unload_weight->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->unload_weight->FormValue)) {
			AddMessage($FormError, $this->unload_weight->errorMessage());
		}
		if ($this->unload_date->Required) {
			if (!$this->unload_date->IsDetailKey && $this->unload_date->FormValue != NULL && $this->unload_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_date->caption(), $this->unload_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->unload_date->FormValue)) {
			AddMessage($FormError, $this->unload_date->errorMessage());
		}
		if ($this->ded_det->Required) {
			if (!$this->ded_det->IsDetailKey && $this->ded_det->FormValue != NULL && $this->ded_det->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ded_det->caption(), $this->ded_det->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->ded_det->FormValue)) {
			AddMessage($FormError, $this->ded_det->errorMessage());
		}
		if ($this->ded_det_remarks->Required) {
			if (!$this->ded_det_remarks->IsDetailKey && $this->ded_det_remarks->FormValue != NULL && $this->ded_det_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ded_det_remarks->caption(), $this->ded_det_remarks->RequiredErrorMessage));
			}
		}
		if ($this->fasttag_cl_balance->Required) {
			if (!$this->fasttag_cl_balance->IsDetailKey && $this->fasttag_cl_balance->FormValue != NULL && $this->fasttag_cl_balance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fasttag_cl_balance->caption(), $this->fasttag_cl_balance->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->fasttag_cl_balance->FormValue)) {
			AddMessage($FormError, $this->fasttag_cl_balance->errorMessage());
		}
		if ($this->delivery_receipt->Required) {
			if ($this->delivery_receipt->Upload->FileName == "" && !$this->delivery_receipt->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->delivery_receipt->caption(), $this->delivery_receipt->RequiredErrorMessage));
			}
		}
		if ($this->delivery_pod->Required) {
			if ($this->delivery_pod->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_pod->caption(), $this->delivery_pod->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->delivery_receipt->OldUploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			$this->delivery_receipt->UploadPath = $this->delivery_receipt->OldUploadPath;
			$rsnew = [];

			// load_date
			$this->load_date->setDbValueDef($rsnew, UnFormatDateTime($this->load_date->CurrentValue, 2), CurrentDate(), $this->load_date->ReadOnly);

			// driver
			$this->driver->setDbValueDef($rsnew, $this->driver->CurrentValue, NULL, $this->driver->ReadOnly);

			// unload_km
			$this->unload_km->setDbValueDef($rsnew, $this->unload_km->CurrentValue, 0, $this->unload_km->ReadOnly);

			// unload_weight
			$this->unload_weight->setDbValueDef($rsnew, $this->unload_weight->CurrentValue, NULL, $this->unload_weight->ReadOnly);

			// unload_date
			$this->unload_date->setDbValueDef($rsnew, UnFormatDateTime($this->unload_date->CurrentValue, 0), NULL, $this->unload_date->ReadOnly);

			// ded_det
			$this->ded_det->setDbValueDef($rsnew, $this->ded_det->CurrentValue, 0, $this->ded_det->ReadOnly);

			// ded_det_remarks
			$this->ded_det_remarks->setDbValueDef($rsnew, $this->ded_det_remarks->CurrentValue, NULL, $this->ded_det_remarks->ReadOnly);

			// fasttag_cl_balance
			$this->fasttag_cl_balance->setDbValueDef($rsnew, $this->fasttag_cl_balance->CurrentValue, NULL, $this->fasttag_cl_balance->ReadOnly);

			// delivery_receipt
			if ($this->delivery_receipt->Visible && !$this->delivery_receipt->ReadOnly && !$this->delivery_receipt->Upload->KeepFile) {
				$this->delivery_receipt->Upload->DbValue = $rsold['delivery_receipt']; // Get original value
				if ($this->delivery_receipt->Upload->FileName == "") {
					$rsnew['delivery_receipt'] = NULL;
				} else {
					$rsnew['delivery_receipt'] = $this->delivery_receipt->Upload->FileName;
				}
				$this->delivery_receipt->ImageWidth = 0; // Resize width
				$this->delivery_receipt->ImageHeight = 640; // Resize height
			}

			// delivery_pod
			$this->delivery_pod->setDbValueDef($rsnew, $this->delivery_pod->CurrentValue, NULL, $this->delivery_pod->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;
			if ($this->delivery_receipt->Visible && !$this->delivery_receipt->Upload->KeepFile) {
				$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
				$oldFiles = EmptyValue($this->delivery_receipt->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->delivery_receipt->Upload->DbValue));
				if (!EmptyValue($this->delivery_receipt->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->delivery_receipt->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->delivery_receipt->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index) . $file1) || file_exists($this->delivery_receipt->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->delivery_receipt->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index) . $file, UploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->delivery_receipt->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->delivery_receipt->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->delivery_receipt->setDbValueDef($rsnew, $this->delivery_receipt->Upload->FileName, NULL, $this->delivery_receipt->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->delivery_receipt->Visible && !$this->delivery_receipt->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->delivery_receipt->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->delivery_receipt->Upload->DbValue));
						if (!EmptyValue($this->delivery_receipt->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->delivery_receipt->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['delivery_receipt']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->delivery_receipt->Upload->resizeAndSaveToFile($this->delivery_receipt->ImageWidth, $this->delivery_receipt->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->delivery_receipt->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// delivery_receipt
		if ($this->delivery_receipt->Upload->FileToken <> "")
			CleanUploadTempPath($this->delivery_receipt->Upload->FileToken, $this->delivery_receipt->Upload->Index);
		else
			CleanUploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("t_trip_info_d_unloadlist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_trip_info":
							break;
						case "x_driver":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>