<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class t_trip_info_edit extends t_trip_info
{

	// Page ID
	public $PageID = "edit";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 't_trip_info';

	// Page object name
	public $PageObjName = "t_trip_info_edit";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (t_trip_info)
		if (!isset($GLOBALS["t_trip_info"]) || get_class($GLOBALS["t_trip_info"]) == PROJECT_NAMESPACE . "t_trip_info") {
			$GLOBALS["t_trip_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["t_trip_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'edit');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $t_trip_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($t_trip_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "t_trip_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-edit-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $DbMasterFilter;
	public $DbDetailFilter;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canEdit()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("t_trip_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->vehicle_type->setVisibility();
		$this->vehicle->setVisibility();
		$this->_route->setVisibility();
		$this->route_name->setVisibility();
		$this->reports_to->setVisibility();
		$this->buyer->setVisibility();
		$this->b_consignor->setVisibility();
		$this->b_consignee->setVisibility();
		$this->load_date->setVisibility();
		$this->load_weight->setVisibility();
		$this->unload_date->setVisibility();
		$this->unload_weight->setVisibility();
		$this->invoice_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->amount->setVisibility();
		$this->delivery_pod->setVisibility();
		$this->status->setVisibility();
		$this->days->setVisibility();
		$this->driver->setVisibility();
		$this->driver_name->setVisibility();
		$this->agent->setVisibility();
		$this->comm->setVisibility();
		$this->material->setVisibility();
		$this->packing_type->setVisibility();
		$this->m_hsn->setVisibility();
		$this->_40->setVisibility();
		$this->lr_no->setVisibility();
		$this->km->setVisibility();
		$this->freight_type->setVisibility();
		$this->freight->setVisibility();
		$this->ded_det->setVisibility();
		$this->ded_det_remarks->setVisibility();
		$this->gst_percent->setVisibility();
		$this->gst_amount->setVisibility();
		$this->final_amount->setVisibility();
		$this->load_km->setVisibility();
		$this->unload_km->setVisibility();
		$this->delivery_receipt->setVisibility();
		$this->delivery_docket->setVisibility();
		$this->diesal_op_b->setVisibility();
		$this->diesal_required->setVisibility();
		$this->diesal_fill->setVisibility();
		$this->diesal_amount->setVisibility();
		$this->diesal_cl_balance->setVisibility();
		$this->vehicle_average->setVisibility();
		$this->cash_required->setVisibility();
		$this->cash_op_b->setVisibility();
		$this->cash_paid->setVisibility();
		$this->cash_expenses->setVisibility();
		$this->cash_cl_balance->setVisibility();
		$this->fasttag_op_b->setVisibility();
		$this->fasttag_recharge->setVisibility();
		$this->fasttag_expenses->setVisibility();
		$this->toll_expenses_cash->setVisibility();
		$this->fasttag_cl_balance->setVisibility();
		$this->remarks->setVisibility();
		$this->uploads->setVisibility();
		$this->consignor->setVisibility();
		$this->vehicle_freight_comm->setVisibility();
		$this->vehicle_freight_type->setVisibility();
		$this->vehicle_freight_amount->setVisibility();
		$this->vehicle_freight_final->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->expenses_id->Visible = FALSE;
		$this->hideFieldsForAddEdit();
		$this->vehicle->Required = FALSE;
		$this->status->Required = FALSE;
		$this->days->Required = FALSE;
		$this->diesal_op_b->Required = FALSE;
		$this->diesal_required->Required = FALSE;
		$this->diesal_fill->Required = FALSE;
		$this->vehicle_average->Required = FALSE;
		$this->cash_required->Required = FALSE;
		$this->cash_op_b->Required = FALSE;
		$this->cash_paid->Required = FALSE;

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->vehicle);
		$this->setupLookupOptions($this->_route);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->buyer);
		$this->setupLookupOptions($this->b_consignor);
		$this->setupLookupOptions($this->b_consignee);
		$this->setupLookupOptions($this->driver);
		$this->setupLookupOptions($this->agent);
		$this->setupLookupOptions($this->consignor);
		$this->setupLookupOptions($this->operator);

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		$this->FormClassName = "ew-form ew-edit-form ew-horizontal";
		$loaded = FALSE;
		$postBack = FALSE;

		// Set up current action and primary key
		if (IsApi()) {
			$this->CurrentAction = "update"; // Update record directly
			$postBack = TRUE;
		} elseif (Post("action") !== NULL) {
			$this->CurrentAction = Post("action"); // Get action code
			if (!$this->isShow()) // Not reload record, handle as postback
				$postBack = TRUE;

			// Load key from Form
			if ($CurrentForm->hasValue("x_id")) {
				$this->id->setFormValue($CurrentForm->getValue("x_id"));
			}
		} else {
			$this->CurrentAction = "show"; // Default action is display

			// Load key from QueryString
			$loadByQuery = FALSE;
			if (Get("id") !== NULL) {
				$this->id->setQueryStringValue(Get("id"));
				$loadByQuery = TRUE;
			} else {
				$this->id->CurrentValue = NULL;
			}
		}

		// Load current record
		$loaded = $this->loadRow();

		// Process form if post back
		if ($postBack) {
			$this->loadFormValues(); // Get form values

			// Set up detail parameters
			$this->setupDetailParms();
		}

		// Validate form if post back
		if ($postBack) {
			if (!$this->validateForm()) {
				$this->setFailureMessage($FormError);
				$this->EventCancelled = TRUE; // Event cancelled
				$this->restoreFormValues();
				if (IsApi()) {
					$this->terminate();
					return;
				} else {
					$this->CurrentAction = ""; // Form error, reset action
				}
			}
		}

		// Perform current action
		switch ($this->CurrentAction) {
			case "show": // Get a record to display
				if (!$loaded) { // Load record based on key
					if ($this->getFailureMessage() == "")
						$this->setFailureMessage($Language->phrase("NoRecord")); // No record found
					$this->terminate("t_trip_infolist.php"); // No matching record, return to list
				}

				// Set up detail parameters
				$this->setupDetailParms();
				break;
			case "update": // Update
				if ($this->getCurrentDetailTable() <> "") // Master/detail edit
					$returnUrl = $this->getViewUrl(TABLE_SHOW_DETAIL . "=" . $this->getCurrentDetailTable()); // Master/Detail view page
				else
					$returnUrl = $this->getReturnUrl();
				if (GetPageName($returnUrl) == "t_trip_infolist.php")
					$returnUrl = $this->addMasterUrl($returnUrl); // List page, return to List page with correct master key if necessary
				$this->SendEmail = TRUE; // Send email on update success
				if ($this->editRow()) { // Update record based on key
					if ($this->getSuccessMessage() == "")
						$this->setSuccessMessage($Language->phrase("UpdateSuccess")); // Update success
					if (IsApi()) {
						$this->terminate(TRUE);
						return;
					} else {
						$this->terminate($returnUrl); // Return to caller
					}
				} elseif (IsApi()) { // API request, return
					$this->terminate();
					return;
				} elseif ($this->getFailureMessage() == $Language->phrase("NoRecord")) {
					$this->terminate($returnUrl); // Return to caller
				} else {
					$this->EventCancelled = TRUE; // Event cancelled
					$this->restoreFormValues(); // Restore form values if update failed

					// Set up detail parameters
					$this->setupDetailParms();
				}
		}

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Render the record
		$this->RowType = ROWTYPE_EDIT; // Render as Edit
		$this->resetAttributes();
		$this->renderRow();
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Get upload files
	protected function getUploadFiles()
	{
		global $CurrentForm, $Language;
		$this->delivery_receipt->Upload->Index = $CurrentForm->Index;
		$this->delivery_receipt->Upload->uploadFile();
		$this->delivery_receipt->CurrentValue = $this->delivery_receipt->Upload->FileName;
		$this->uploads->Upload->Index = $CurrentForm->Index;
		$this->uploads->Upload->uploadFile();
		$this->uploads->CurrentValue = $this->uploads->Upload->FileName;
	}

	// Load form values
	protected function loadFormValues()
	{

		// Load from form
		global $CurrentForm;
		$this->getUploadFiles(); // Get upload files

		// Check field name 'id' first before field var 'x_id'
		$val = $CurrentForm->hasValue("id") ? $CurrentForm->getValue("id") : $CurrentForm->getValue("x_id");
		if (!$this->id->IsDetailKey)
			$this->id->setFormValue($val);

		// Check field name 'vehicle_type' first before field var 'x_vehicle_type'
		$val = $CurrentForm->hasValue("vehicle_type") ? $CurrentForm->getValue("vehicle_type") : $CurrentForm->getValue("x_vehicle_type");
		if (!$this->vehicle_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_type->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_type->setFormValue($val);
		}

		// Check field name 'vehicle' first before field var 'x_vehicle'
		$val = $CurrentForm->hasValue("vehicle") ? $CurrentForm->getValue("vehicle") : $CurrentForm->getValue("x_vehicle");
		if (!$this->vehicle->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle->setFormValue($val);
		}

		// Check field name 'route' first before field var 'x__route'
		$val = $CurrentForm->hasValue("route") ? $CurrentForm->getValue("route") : $CurrentForm->getValue("x__route");
		if (!$this->_route->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_route->Visible = FALSE; // Disable update for API request
			else
				$this->_route->setFormValue($val);
		}

		// Check field name 'route_name' first before field var 'x_route_name'
		$val = $CurrentForm->hasValue("route_name") ? $CurrentForm->getValue("route_name") : $CurrentForm->getValue("x_route_name");
		if (!$this->route_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->route_name->Visible = FALSE; // Disable update for API request
			else
				$this->route_name->setFormValue($val);
		}

		// Check field name 'reports_to' first before field var 'x_reports_to'
		$val = $CurrentForm->hasValue("reports_to") ? $CurrentForm->getValue("reports_to") : $CurrentForm->getValue("x_reports_to");
		if (!$this->reports_to->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->reports_to->Visible = FALSE; // Disable update for API request
			else
				$this->reports_to->setFormValue($val);
		}

		// Check field name 'buyer' first before field var 'x_buyer'
		$val = $CurrentForm->hasValue("buyer") ? $CurrentForm->getValue("buyer") : $CurrentForm->getValue("x_buyer");
		if (!$this->buyer->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->buyer->Visible = FALSE; // Disable update for API request
			else
				$this->buyer->setFormValue($val);
		}

		// Check field name 'b_consignor' first before field var 'x_b_consignor'
		$val = $CurrentForm->hasValue("b_consignor") ? $CurrentForm->getValue("b_consignor") : $CurrentForm->getValue("x_b_consignor");
		if (!$this->b_consignor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_consignor->Visible = FALSE; // Disable update for API request
			else
				$this->b_consignor->setFormValue($val);
		}

		// Check field name 'b_consignee' first before field var 'x_b_consignee'
		$val = $CurrentForm->hasValue("b_consignee") ? $CurrentForm->getValue("b_consignee") : $CurrentForm->getValue("x_b_consignee");
		if (!$this->b_consignee->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->b_consignee->Visible = FALSE; // Disable update for API request
			else
				$this->b_consignee->setFormValue($val);
		}

		// Check field name 'load_date' first before field var 'x_load_date'
		$val = $CurrentForm->hasValue("load_date") ? $CurrentForm->getValue("load_date") : $CurrentForm->getValue("x_load_date");
		if (!$this->load_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->load_date->Visible = FALSE; // Disable update for API request
			else
				$this->load_date->setFormValue($val);
			$this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, 1);
		}

		// Check field name 'load_weight' first before field var 'x_load_weight'
		$val = $CurrentForm->hasValue("load_weight") ? $CurrentForm->getValue("load_weight") : $CurrentForm->getValue("x_load_weight");
		if (!$this->load_weight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->load_weight->Visible = FALSE; // Disable update for API request
			else
				$this->load_weight->setFormValue($val);
		}

		// Check field name 'unload_date' first before field var 'x_unload_date'
		$val = $CurrentForm->hasValue("unload_date") ? $CurrentForm->getValue("unload_date") : $CurrentForm->getValue("x_unload_date");
		if (!$this->unload_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unload_date->Visible = FALSE; // Disable update for API request
			else
				$this->unload_date->setFormValue($val);
			$this->unload_date->CurrentValue = UnFormatDateTime($this->unload_date->CurrentValue, 0);
		}

		// Check field name 'unload_weight' first before field var 'x_unload_weight'
		$val = $CurrentForm->hasValue("unload_weight") ? $CurrentForm->getValue("unload_weight") : $CurrentForm->getValue("x_unload_weight");
		if (!$this->unload_weight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unload_weight->Visible = FALSE; // Disable update for API request
			else
				$this->unload_weight->setFormValue($val);
		}

		// Check field name 'invoice_no' first before field var 'x_invoice_no'
		$val = $CurrentForm->hasValue("invoice_no") ? $CurrentForm->getValue("invoice_no") : $CurrentForm->getValue("x_invoice_no");
		if (!$this->invoice_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->invoice_no->Visible = FALSE; // Disable update for API request
			else
				$this->invoice_no->setFormValue($val);
		}

		// Check field name 'invoice_date' first before field var 'x_invoice_date'
		$val = $CurrentForm->hasValue("invoice_date") ? $CurrentForm->getValue("invoice_date") : $CurrentForm->getValue("x_invoice_date");
		if (!$this->invoice_date->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->invoice_date->Visible = FALSE; // Disable update for API request
			else
				$this->invoice_date->setFormValue($val);
			$this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, 0);
		}

		// Check field name 'amount' first before field var 'x_amount'
		$val = $CurrentForm->hasValue("amount") ? $CurrentForm->getValue("amount") : $CurrentForm->getValue("x_amount");
		if (!$this->amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->amount->Visible = FALSE; // Disable update for API request
			else
				$this->amount->setFormValue($val);
		}

		// Check field name 'delivery_pod' first before field var 'x_delivery_pod'
		$val = $CurrentForm->hasValue("delivery_pod") ? $CurrentForm->getValue("delivery_pod") : $CurrentForm->getValue("x_delivery_pod");
		if (!$this->delivery_pod->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery_pod->Visible = FALSE; // Disable update for API request
			else
				$this->delivery_pod->setFormValue($val);
		}

		// Check field name 'status' first before field var 'x_status'
		$val = $CurrentForm->hasValue("status") ? $CurrentForm->getValue("status") : $CurrentForm->getValue("x_status");
		if (!$this->status->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->status->Visible = FALSE; // Disable update for API request
			else
				$this->status->setFormValue($val);
		}

		// Check field name 'days' first before field var 'x_days'
		$val = $CurrentForm->hasValue("days") ? $CurrentForm->getValue("days") : $CurrentForm->getValue("x_days");
		if (!$this->days->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->days->Visible = FALSE; // Disable update for API request
			else
				$this->days->setFormValue($val);
		}

		// Check field name 'driver' first before field var 'x_driver'
		$val = $CurrentForm->hasValue("driver") ? $CurrentForm->getValue("driver") : $CurrentForm->getValue("x_driver");
		if (!$this->driver->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->driver->Visible = FALSE; // Disable update for API request
			else
				$this->driver->setFormValue($val);
		}

		// Check field name 'driver_name' first before field var 'x_driver_name'
		$val = $CurrentForm->hasValue("driver_name") ? $CurrentForm->getValue("driver_name") : $CurrentForm->getValue("x_driver_name");
		if (!$this->driver_name->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->driver_name->Visible = FALSE; // Disable update for API request
			else
				$this->driver_name->setFormValue($val);
		}

		// Check field name 'agent' first before field var 'x_agent'
		$val = $CurrentForm->hasValue("agent") ? $CurrentForm->getValue("agent") : $CurrentForm->getValue("x_agent");
		if (!$this->agent->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->agent->Visible = FALSE; // Disable update for API request
			else
				$this->agent->setFormValue($val);
		}

		// Check field name 'comm' first before field var 'x_comm'
		$val = $CurrentForm->hasValue("comm") ? $CurrentForm->getValue("comm") : $CurrentForm->getValue("x_comm");
		if (!$this->comm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->comm->Visible = FALSE; // Disable update for API request
			else
				$this->comm->setFormValue($val);
		}

		// Check field name 'material' first before field var 'x_material'
		$val = $CurrentForm->hasValue("material") ? $CurrentForm->getValue("material") : $CurrentForm->getValue("x_material");
		if (!$this->material->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->material->Visible = FALSE; // Disable update for API request
			else
				$this->material->setFormValue($val);
		}

		// Check field name 'packing_type' first before field var 'x_packing_type'
		$val = $CurrentForm->hasValue("packing_type") ? $CurrentForm->getValue("packing_type") : $CurrentForm->getValue("x_packing_type");
		if (!$this->packing_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->packing_type->Visible = FALSE; // Disable update for API request
			else
				$this->packing_type->setFormValue($val);
		}

		// Check field name 'm_hsn' first before field var 'x_m_hsn'
		$val = $CurrentForm->hasValue("m_hsn") ? $CurrentForm->getValue("m_hsn") : $CurrentForm->getValue("x_m_hsn");
		if (!$this->m_hsn->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->m_hsn->Visible = FALSE; // Disable update for API request
			else
				$this->m_hsn->setFormValue($val);
		}

		// Check field name '@' first before field var 'x__40'
		$val = $CurrentForm->hasValue("@") ? $CurrentForm->getValue("@") : $CurrentForm->getValue("x__40");
		if (!$this->_40->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->_40->Visible = FALSE; // Disable update for API request
			else
				$this->_40->setFormValue($val);
		}

		// Check field name 'lr_no' first before field var 'x_lr_no'
		$val = $CurrentForm->hasValue("lr_no") ? $CurrentForm->getValue("lr_no") : $CurrentForm->getValue("x_lr_no");
		if (!$this->lr_no->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->lr_no->Visible = FALSE; // Disable update for API request
			else
				$this->lr_no->setFormValue($val);
		}

		// Check field name 'km' first before field var 'x_km'
		$val = $CurrentForm->hasValue("km") ? $CurrentForm->getValue("km") : $CurrentForm->getValue("x_km");
		if (!$this->km->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->km->Visible = FALSE; // Disable update for API request
			else
				$this->km->setFormValue($val);
		}

		// Check field name 'freight_type' first before field var 'x_freight_type'
		$val = $CurrentForm->hasValue("freight_type") ? $CurrentForm->getValue("freight_type") : $CurrentForm->getValue("x_freight_type");
		if (!$this->freight_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->freight_type->Visible = FALSE; // Disable update for API request
			else
				$this->freight_type->setFormValue($val);
		}

		// Check field name 'freight' first before field var 'x_freight'
		$val = $CurrentForm->hasValue("freight") ? $CurrentForm->getValue("freight") : $CurrentForm->getValue("x_freight");
		if (!$this->freight->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->freight->Visible = FALSE; // Disable update for API request
			else
				$this->freight->setFormValue($val);
		}

		// Check field name 'ded_det' first before field var 'x_ded_det'
		$val = $CurrentForm->hasValue("ded_det") ? $CurrentForm->getValue("ded_det") : $CurrentForm->getValue("x_ded_det");
		if (!$this->ded_det->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ded_det->Visible = FALSE; // Disable update for API request
			else
				$this->ded_det->setFormValue($val);
		}

		// Check field name 'ded_det_remarks' first before field var 'x_ded_det_remarks'
		$val = $CurrentForm->hasValue("ded_det_remarks") ? $CurrentForm->getValue("ded_det_remarks") : $CurrentForm->getValue("x_ded_det_remarks");
		if (!$this->ded_det_remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->ded_det_remarks->Visible = FALSE; // Disable update for API request
			else
				$this->ded_det_remarks->setFormValue($val);
		}

		// Check field name 'gst_percent' first before field var 'x_gst_percent'
		$val = $CurrentForm->hasValue("gst_percent") ? $CurrentForm->getValue("gst_percent") : $CurrentForm->getValue("x_gst_percent");
		if (!$this->gst_percent->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gst_percent->Visible = FALSE; // Disable update for API request
			else
				$this->gst_percent->setFormValue($val);
		}

		// Check field name 'gst_amount' first before field var 'x_gst_amount'
		$val = $CurrentForm->hasValue("gst_amount") ? $CurrentForm->getValue("gst_amount") : $CurrentForm->getValue("x_gst_amount");
		if (!$this->gst_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->gst_amount->Visible = FALSE; // Disable update for API request
			else
				$this->gst_amount->setFormValue($val);
		}

		// Check field name 'final_amount' first before field var 'x_final_amount'
		$val = $CurrentForm->hasValue("final_amount") ? $CurrentForm->getValue("final_amount") : $CurrentForm->getValue("x_final_amount");
		if (!$this->final_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->final_amount->Visible = FALSE; // Disable update for API request
			else
				$this->final_amount->setFormValue($val);
		}

		// Check field name 'load_km' first before field var 'x_load_km'
		$val = $CurrentForm->hasValue("load_km") ? $CurrentForm->getValue("load_km") : $CurrentForm->getValue("x_load_km");
		if (!$this->load_km->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->load_km->Visible = FALSE; // Disable update for API request
			else
				$this->load_km->setFormValue($val);
		}

		// Check field name 'unload_km' first before field var 'x_unload_km'
		$val = $CurrentForm->hasValue("unload_km") ? $CurrentForm->getValue("unload_km") : $CurrentForm->getValue("x_unload_km");
		if (!$this->unload_km->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->unload_km->Visible = FALSE; // Disable update for API request
			else
				$this->unload_km->setFormValue($val);
		}

		// Check field name 'delivery_docket' first before field var 'x_delivery_docket'
		$val = $CurrentForm->hasValue("delivery_docket") ? $CurrentForm->getValue("delivery_docket") : $CurrentForm->getValue("x_delivery_docket");
		if (!$this->delivery_docket->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->delivery_docket->Visible = FALSE; // Disable update for API request
			else
				$this->delivery_docket->setFormValue($val);
		}

		// Check field name 'diesal_op_b' first before field var 'x_diesal_op_b'
		$val = $CurrentForm->hasValue("diesal_op_b") ? $CurrentForm->getValue("diesal_op_b") : $CurrentForm->getValue("x_diesal_op_b");
		if (!$this->diesal_op_b->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diesal_op_b->Visible = FALSE; // Disable update for API request
			else
				$this->diesal_op_b->setFormValue($val);
		}

		// Check field name 'diesal_required' first before field var 'x_diesal_required'
		$val = $CurrentForm->hasValue("diesal_required") ? $CurrentForm->getValue("diesal_required") : $CurrentForm->getValue("x_diesal_required");
		if (!$this->diesal_required->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diesal_required->Visible = FALSE; // Disable update for API request
			else
				$this->diesal_required->setFormValue($val);
		}

		// Check field name 'diesal_fill' first before field var 'x_diesal_fill'
		$val = $CurrentForm->hasValue("diesal_fill") ? $CurrentForm->getValue("diesal_fill") : $CurrentForm->getValue("x_diesal_fill");
		if (!$this->diesal_fill->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diesal_fill->Visible = FALSE; // Disable update for API request
			else
				$this->diesal_fill->setFormValue($val);
		}

		// Check field name 'diesal_amount' first before field var 'x_diesal_amount'
		$val = $CurrentForm->hasValue("diesal_amount") ? $CurrentForm->getValue("diesal_amount") : $CurrentForm->getValue("x_diesal_amount");
		if (!$this->diesal_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diesal_amount->Visible = FALSE; // Disable update for API request
			else
				$this->diesal_amount->setFormValue($val);
		}

		// Check field name 'diesal_cl_balance' first before field var 'x_diesal_cl_balance'
		$val = $CurrentForm->hasValue("diesal_cl_balance") ? $CurrentForm->getValue("diesal_cl_balance") : $CurrentForm->getValue("x_diesal_cl_balance");
		if (!$this->diesal_cl_balance->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->diesal_cl_balance->Visible = FALSE; // Disable update for API request
			else
				$this->diesal_cl_balance->setFormValue($val);
		}

		// Check field name 'vehicle_average' first before field var 'x_vehicle_average'
		$val = $CurrentForm->hasValue("vehicle_average") ? $CurrentForm->getValue("vehicle_average") : $CurrentForm->getValue("x_vehicle_average");
		if (!$this->vehicle_average->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_average->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_average->setFormValue($val);
		}

		// Check field name 'cash_required' first before field var 'x_cash_required'
		$val = $CurrentForm->hasValue("cash_required") ? $CurrentForm->getValue("cash_required") : $CurrentForm->getValue("x_cash_required");
		if (!$this->cash_required->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cash_required->Visible = FALSE; // Disable update for API request
			else
				$this->cash_required->setFormValue($val);
		}

		// Check field name 'cash_op_b' first before field var 'x_cash_op_b'
		$val = $CurrentForm->hasValue("cash_op_b") ? $CurrentForm->getValue("cash_op_b") : $CurrentForm->getValue("x_cash_op_b");
		if (!$this->cash_op_b->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cash_op_b->Visible = FALSE; // Disable update for API request
			else
				$this->cash_op_b->setFormValue($val);
		}

		// Check field name 'cash_paid' first before field var 'x_cash_paid'
		$val = $CurrentForm->hasValue("cash_paid") ? $CurrentForm->getValue("cash_paid") : $CurrentForm->getValue("x_cash_paid");
		if (!$this->cash_paid->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cash_paid->Visible = FALSE; // Disable update for API request
			else
				$this->cash_paid->setFormValue($val);
		}

		// Check field name 'cash_expenses' first before field var 'x_cash_expenses'
		$val = $CurrentForm->hasValue("cash_expenses") ? $CurrentForm->getValue("cash_expenses") : $CurrentForm->getValue("x_cash_expenses");
		if (!$this->cash_expenses->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cash_expenses->Visible = FALSE; // Disable update for API request
			else
				$this->cash_expenses->setFormValue($val);
		}

		// Check field name 'cash_cl_balance' first before field var 'x_cash_cl_balance'
		$val = $CurrentForm->hasValue("cash_cl_balance") ? $CurrentForm->getValue("cash_cl_balance") : $CurrentForm->getValue("x_cash_cl_balance");
		if (!$this->cash_cl_balance->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->cash_cl_balance->Visible = FALSE; // Disable update for API request
			else
				$this->cash_cl_balance->setFormValue($val);
		}

		// Check field name 'fasttag_op_b' first before field var 'x_fasttag_op_b'
		$val = $CurrentForm->hasValue("fasttag_op_b") ? $CurrentForm->getValue("fasttag_op_b") : $CurrentForm->getValue("x_fasttag_op_b");
		if (!$this->fasttag_op_b->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fasttag_op_b->Visible = FALSE; // Disable update for API request
			else
				$this->fasttag_op_b->setFormValue($val);
		}

		// Check field name 'fasttag_recharge' first before field var 'x_fasttag_recharge'
		$val = $CurrentForm->hasValue("fasttag_recharge") ? $CurrentForm->getValue("fasttag_recharge") : $CurrentForm->getValue("x_fasttag_recharge");
		if (!$this->fasttag_recharge->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fasttag_recharge->Visible = FALSE; // Disable update for API request
			else
				$this->fasttag_recharge->setFormValue($val);
		}

		// Check field name 'fasttag_expenses' first before field var 'x_fasttag_expenses'
		$val = $CurrentForm->hasValue("fasttag_expenses") ? $CurrentForm->getValue("fasttag_expenses") : $CurrentForm->getValue("x_fasttag_expenses");
		if (!$this->fasttag_expenses->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fasttag_expenses->Visible = FALSE; // Disable update for API request
			else
				$this->fasttag_expenses->setFormValue($val);
		}

		// Check field name 'toll_expenses_cash' first before field var 'x_toll_expenses_cash'
		$val = $CurrentForm->hasValue("toll_expenses_cash") ? $CurrentForm->getValue("toll_expenses_cash") : $CurrentForm->getValue("x_toll_expenses_cash");
		if (!$this->toll_expenses_cash->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->toll_expenses_cash->Visible = FALSE; // Disable update for API request
			else
				$this->toll_expenses_cash->setFormValue($val);
		}

		// Check field name 'fasttag_cl_balance' first before field var 'x_fasttag_cl_balance'
		$val = $CurrentForm->hasValue("fasttag_cl_balance") ? $CurrentForm->getValue("fasttag_cl_balance") : $CurrentForm->getValue("x_fasttag_cl_balance");
		if (!$this->fasttag_cl_balance->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->fasttag_cl_balance->Visible = FALSE; // Disable update for API request
			else
				$this->fasttag_cl_balance->setFormValue($val);
		}

		// Check field name 'remarks' first before field var 'x_remarks'
		$val = $CurrentForm->hasValue("remarks") ? $CurrentForm->getValue("remarks") : $CurrentForm->getValue("x_remarks");
		if (!$this->remarks->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->remarks->Visible = FALSE; // Disable update for API request
			else
				$this->remarks->setFormValue($val);
		}

		// Check field name 'consignor' first before field var 'x_consignor'
		$val = $CurrentForm->hasValue("consignor") ? $CurrentForm->getValue("consignor") : $CurrentForm->getValue("x_consignor");
		if (!$this->consignor->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->consignor->Visible = FALSE; // Disable update for API request
			else
				$this->consignor->setFormValue($val);
		}

		// Check field name 'vehicle_freight_comm' first before field var 'x_vehicle_freight_comm'
		$val = $CurrentForm->hasValue("vehicle_freight_comm") ? $CurrentForm->getValue("vehicle_freight_comm") : $CurrentForm->getValue("x_vehicle_freight_comm");
		if (!$this->vehicle_freight_comm->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_freight_comm->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_freight_comm->setFormValue($val);
		}

		// Check field name 'vehicle_freight_type' first before field var 'x_vehicle_freight_type'
		$val = $CurrentForm->hasValue("vehicle_freight_type") ? $CurrentForm->getValue("vehicle_freight_type") : $CurrentForm->getValue("x_vehicle_freight_type");
		if (!$this->vehicle_freight_type->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_freight_type->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_freight_type->setFormValue($val);
		}

		// Check field name 'vehicle_freight_amount' first before field var 'x_vehicle_freight_amount'
		$val = $CurrentForm->hasValue("vehicle_freight_amount") ? $CurrentForm->getValue("vehicle_freight_amount") : $CurrentForm->getValue("x_vehicle_freight_amount");
		if (!$this->vehicle_freight_amount->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_freight_amount->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_freight_amount->setFormValue($val);
		}

		// Check field name 'vehicle_freight_final' first before field var 'x_vehicle_freight_final'
		$val = $CurrentForm->hasValue("vehicle_freight_final") ? $CurrentForm->getValue("vehicle_freight_final") : $CurrentForm->getValue("x_vehicle_freight_final");
		if (!$this->vehicle_freight_final->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->vehicle_freight_final->Visible = FALSE; // Disable update for API request
			else
				$this->vehicle_freight_final->setFormValue($val);
		}

		// Check field name 'operator' first before field var 'x_operator'
		$val = $CurrentForm->hasValue("operator") ? $CurrentForm->getValue("operator") : $CurrentForm->getValue("x_operator");
		if (!$this->operator->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->operator->Visible = FALSE; // Disable update for API request
			else
				$this->operator->setFormValue($val);
		}

		// Check field name 'datetime' first before field var 'x_datetime'
		$val = $CurrentForm->hasValue("datetime") ? $CurrentForm->getValue("datetime") : $CurrentForm->getValue("x_datetime");
		if (!$this->datetime->IsDetailKey) {
			if (IsApi() && $val == NULL)
				$this->datetime->Visible = FALSE; // Disable update for API request
			else
				$this->datetime->setFormValue($val);
			$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
		}
	}

	// Restore form values
	public function restoreFormValues()
	{
		global $CurrentForm;
		$this->id->CurrentValue = $this->id->FormValue;
		$this->vehicle_type->CurrentValue = $this->vehicle_type->FormValue;
		$this->vehicle->CurrentValue = $this->vehicle->FormValue;
		$this->_route->CurrentValue = $this->_route->FormValue;
		$this->route_name->CurrentValue = $this->route_name->FormValue;
		$this->reports_to->CurrentValue = $this->reports_to->FormValue;
		$this->buyer->CurrentValue = $this->buyer->FormValue;
		$this->b_consignor->CurrentValue = $this->b_consignor->FormValue;
		$this->b_consignee->CurrentValue = $this->b_consignee->FormValue;
		$this->load_date->CurrentValue = $this->load_date->FormValue;
		$this->load_date->CurrentValue = UnFormatDateTime($this->load_date->CurrentValue, 1);
		$this->load_weight->CurrentValue = $this->load_weight->FormValue;
		$this->unload_date->CurrentValue = $this->unload_date->FormValue;
		$this->unload_date->CurrentValue = UnFormatDateTime($this->unload_date->CurrentValue, 0);
		$this->unload_weight->CurrentValue = $this->unload_weight->FormValue;
		$this->invoice_no->CurrentValue = $this->invoice_no->FormValue;
		$this->invoice_date->CurrentValue = $this->invoice_date->FormValue;
		$this->invoice_date->CurrentValue = UnFormatDateTime($this->invoice_date->CurrentValue, 0);
		$this->amount->CurrentValue = $this->amount->FormValue;
		$this->delivery_pod->CurrentValue = $this->delivery_pod->FormValue;
		$this->status->CurrentValue = $this->status->FormValue;
		$this->days->CurrentValue = $this->days->FormValue;
		$this->driver->CurrentValue = $this->driver->FormValue;
		$this->driver_name->CurrentValue = $this->driver_name->FormValue;
		$this->agent->CurrentValue = $this->agent->FormValue;
		$this->comm->CurrentValue = $this->comm->FormValue;
		$this->material->CurrentValue = $this->material->FormValue;
		$this->packing_type->CurrentValue = $this->packing_type->FormValue;
		$this->m_hsn->CurrentValue = $this->m_hsn->FormValue;
		$this->_40->CurrentValue = $this->_40->FormValue;
		$this->lr_no->CurrentValue = $this->lr_no->FormValue;
		$this->km->CurrentValue = $this->km->FormValue;
		$this->freight_type->CurrentValue = $this->freight_type->FormValue;
		$this->freight->CurrentValue = $this->freight->FormValue;
		$this->ded_det->CurrentValue = $this->ded_det->FormValue;
		$this->ded_det_remarks->CurrentValue = $this->ded_det_remarks->FormValue;
		$this->gst_percent->CurrentValue = $this->gst_percent->FormValue;
		$this->gst_amount->CurrentValue = $this->gst_amount->FormValue;
		$this->final_amount->CurrentValue = $this->final_amount->FormValue;
		$this->load_km->CurrentValue = $this->load_km->FormValue;
		$this->unload_km->CurrentValue = $this->unload_km->FormValue;
		$this->delivery_docket->CurrentValue = $this->delivery_docket->FormValue;
		$this->diesal_op_b->CurrentValue = $this->diesal_op_b->FormValue;
		$this->diesal_required->CurrentValue = $this->diesal_required->FormValue;
		$this->diesal_fill->CurrentValue = $this->diesal_fill->FormValue;
		$this->diesal_amount->CurrentValue = $this->diesal_amount->FormValue;
		$this->diesal_cl_balance->CurrentValue = $this->diesal_cl_balance->FormValue;
		$this->vehicle_average->CurrentValue = $this->vehicle_average->FormValue;
		$this->cash_required->CurrentValue = $this->cash_required->FormValue;
		$this->cash_op_b->CurrentValue = $this->cash_op_b->FormValue;
		$this->cash_paid->CurrentValue = $this->cash_paid->FormValue;
		$this->cash_expenses->CurrentValue = $this->cash_expenses->FormValue;
		$this->cash_cl_balance->CurrentValue = $this->cash_cl_balance->FormValue;
		$this->fasttag_op_b->CurrentValue = $this->fasttag_op_b->FormValue;
		$this->fasttag_recharge->CurrentValue = $this->fasttag_recharge->FormValue;
		$this->fasttag_expenses->CurrentValue = $this->fasttag_expenses->FormValue;
		$this->toll_expenses_cash->CurrentValue = $this->toll_expenses_cash->FormValue;
		$this->fasttag_cl_balance->CurrentValue = $this->fasttag_cl_balance->FormValue;
		$this->remarks->CurrentValue = $this->remarks->FormValue;
		$this->consignor->CurrentValue = $this->consignor->FormValue;
		$this->vehicle_freight_comm->CurrentValue = $this->vehicle_freight_comm->FormValue;
		$this->vehicle_freight_type->CurrentValue = $this->vehicle_freight_type->FormValue;
		$this->vehicle_freight_amount->CurrentValue = $this->vehicle_freight_amount->FormValue;
		$this->vehicle_freight_final->CurrentValue = $this->vehicle_freight_final->FormValue;
		$this->operator->CurrentValue = $this->operator->FormValue;
		$this->datetime->CurrentValue = $this->datetime->FormValue;
		$this->datetime->CurrentValue = UnFormatDateTime($this->datetime->CurrentValue, 0);
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->vehicle_type->setDbValue($row['vehicle_type']);
		$this->vehicle->setDbValue($row['vehicle']);
		$this->_route->setDbValue($row['route']);
		$this->route_name->setDbValue($row['route_name']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->buyer->setDbValue($row['buyer']);
		$this->b_consignor->setDbValue($row['b_consignor']);
		$this->b_consignee->setDbValue($row['b_consignee']);
		$this->load_date->setDbValue($row['load_date']);
		$this->load_weight->setDbValue($row['load_weight']);
		$this->unload_date->setDbValue($row['unload_date']);
		$this->unload_weight->setDbValue($row['unload_weight']);
		$this->invoice_no->setDbValue($row['invoice_no']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->amount->setDbValue($row['amount']);
		$this->delivery_pod->setDbValue($row['delivery_pod']);
		$this->status->setDbValue($row['status']);
		$this->days->setDbValue($row['days']);
		$this->driver->setDbValue($row['driver']);
		$this->driver_name->setDbValue($row['driver_name']);
		$this->agent->setDbValue($row['agent']);
		if (array_key_exists('EV__agent', $rs->fields)) {
			$this->agent->VirtualValue = $rs->fields('EV__agent'); // Set up virtual field value
		} else {
			$this->agent->VirtualValue = ""; // Clear value
		}
		$this->comm->setDbValue($row['comm']);
		$this->material->setDbValue($row['material']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->m_hsn->setDbValue($row['m_hsn']);
		$this->_40->setDbValue($row['@']);
		$this->lr_no->setDbValue($row['lr_no']);
		$this->km->setDbValue($row['km']);
		$this->freight_type->setDbValue($row['freight_type']);
		$this->freight->setDbValue($row['freight']);
		$this->ded_det->setDbValue($row['ded_det']);
		$this->ded_det_remarks->setDbValue($row['ded_det_remarks']);
		$this->gst_percent->setDbValue($row['gst_percent']);
		$this->gst_amount->setDbValue($row['gst_amount']);
		$this->final_amount->setDbValue($row['final_amount']);
		$this->load_km->setDbValue($row['load_km']);
		$this->unload_km->setDbValue($row['unload_km']);
		$this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
		$this->delivery_receipt->setDbValue($this->delivery_receipt->Upload->DbValue);
		$this->delivery_docket->setDbValue($row['delivery_docket']);
		$this->diesal_op_b->setDbValue($row['diesal_op_b']);
		$this->diesal_required->setDbValue($row['diesal_required']);
		$this->diesal_fill->setDbValue($row['diesal_fill']);
		$this->diesal_amount->setDbValue($row['diesal_amount']);
		$this->diesal_cl_balance->setDbValue($row['diesal_cl_balance']);
		$this->vehicle_average->setDbValue($row['vehicle_average']);
		$this->cash_required->setDbValue($row['cash_required']);
		$this->cash_op_b->setDbValue($row['cash_op_b']);
		$this->cash_paid->setDbValue($row['cash_paid']);
		$this->cash_expenses->setDbValue($row['cash_expenses']);
		$this->cash_cl_balance->setDbValue($row['cash_cl_balance']);
		$this->fasttag_op_b->setDbValue($row['fasttag_op_b']);
		$this->fasttag_recharge->setDbValue($row['fasttag_recharge']);
		$this->fasttag_expenses->setDbValue($row['fasttag_expenses']);
		$this->toll_expenses_cash->setDbValue($row['toll_expenses_cash']);
		$this->fasttag_cl_balance->setDbValue($row['fasttag_cl_balance']);
		$this->remarks->setDbValue($row['remarks']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->consignor->setDbValue($row['consignor']);
		$this->vehicle_freight_comm->setDbValue($row['vehicle_freight_comm']);
		$this->vehicle_freight_type->setDbValue($row['vehicle_freight_type']);
		$this->vehicle_freight_amount->setDbValue($row['vehicle_freight_amount']);
		$this->vehicle_freight_final->setDbValue($row['vehicle_freight_final']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->expenses_id->setDbValue($row['expenses_id']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['vehicle_type'] = NULL;
		$row['vehicle'] = NULL;
		$row['route'] = NULL;
		$row['route_name'] = NULL;
		$row['reports_to'] = NULL;
		$row['buyer'] = NULL;
		$row['b_consignor'] = NULL;
		$row['b_consignee'] = NULL;
		$row['load_date'] = NULL;
		$row['load_weight'] = NULL;
		$row['unload_date'] = NULL;
		$row['unload_weight'] = NULL;
		$row['invoice_no'] = NULL;
		$row['invoice_date'] = NULL;
		$row['amount'] = NULL;
		$row['delivery_pod'] = NULL;
		$row['status'] = NULL;
		$row['days'] = NULL;
		$row['driver'] = NULL;
		$row['driver_name'] = NULL;
		$row['agent'] = NULL;
		$row['comm'] = NULL;
		$row['material'] = NULL;
		$row['packing_type'] = NULL;
		$row['m_hsn'] = NULL;
		$row['@'] = NULL;
		$row['lr_no'] = NULL;
		$row['km'] = NULL;
		$row['freight_type'] = NULL;
		$row['freight'] = NULL;
		$row['ded_det'] = NULL;
		$row['ded_det_remarks'] = NULL;
		$row['gst_percent'] = NULL;
		$row['gst_amount'] = NULL;
		$row['final_amount'] = NULL;
		$row['load_km'] = NULL;
		$row['unload_km'] = NULL;
		$row['delivery_receipt'] = NULL;
		$row['delivery_docket'] = NULL;
		$row['diesal_op_b'] = NULL;
		$row['diesal_required'] = NULL;
		$row['diesal_fill'] = NULL;
		$row['diesal_amount'] = NULL;
		$row['diesal_cl_balance'] = NULL;
		$row['vehicle_average'] = NULL;
		$row['cash_required'] = NULL;
		$row['cash_op_b'] = NULL;
		$row['cash_paid'] = NULL;
		$row['cash_expenses'] = NULL;
		$row['cash_cl_balance'] = NULL;
		$row['fasttag_op_b'] = NULL;
		$row['fasttag_recharge'] = NULL;
		$row['fasttag_expenses'] = NULL;
		$row['toll_expenses_cash'] = NULL;
		$row['fasttag_cl_balance'] = NULL;
		$row['remarks'] = NULL;
		$row['uploads'] = NULL;
		$row['consignor'] = NULL;
		$row['vehicle_freight_comm'] = NULL;
		$row['vehicle_freight_type'] = NULL;
		$row['vehicle_freight_amount'] = NULL;
		$row['vehicle_freight_final'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['expenses_id'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->comm->FormValue == $this->comm->CurrentValue && is_numeric(ConvertToFloatString($this->comm->CurrentValue)))
			$this->comm->CurrentValue = ConvertToFloatString($this->comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_40->FormValue == $this->_40->CurrentValue && is_numeric(ConvertToFloatString($this->_40->CurrentValue)))
			$this->_40->CurrentValue = ConvertToFloatString($this->_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->km->FormValue == $this->km->CurrentValue && is_numeric(ConvertToFloatString($this->km->CurrentValue)))
			$this->km->CurrentValue = ConvertToFloatString($this->km->CurrentValue);

		// Convert decimal values if posted back
		if ($this->freight->FormValue == $this->freight->CurrentValue && is_numeric(ConvertToFloatString($this->freight->CurrentValue)))
			$this->freight->CurrentValue = ConvertToFloatString($this->freight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ded_det->FormValue == $this->ded_det->CurrentValue && is_numeric(ConvertToFloatString($this->ded_det->CurrentValue)))
			$this->ded_det->CurrentValue = ConvertToFloatString($this->ded_det->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gst_percent->FormValue == $this->gst_percent->CurrentValue && is_numeric(ConvertToFloatString($this->gst_percent->CurrentValue)))
			$this->gst_percent->CurrentValue = ConvertToFloatString($this->gst_percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gst_amount->FormValue == $this->gst_amount->CurrentValue && is_numeric(ConvertToFloatString($this->gst_amount->CurrentValue)))
			$this->gst_amount->CurrentValue = ConvertToFloatString($this->gst_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->final_amount->FormValue == $this->final_amount->CurrentValue && is_numeric(ConvertToFloatString($this->final_amount->CurrentValue)))
			$this->final_amount->CurrentValue = ConvertToFloatString($this->final_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_op_b->FormValue == $this->diesal_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_op_b->CurrentValue)))
			$this->diesal_op_b->CurrentValue = ConvertToFloatString($this->diesal_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_required->FormValue == $this->diesal_required->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_required->CurrentValue)))
			$this->diesal_required->CurrentValue = ConvertToFloatString($this->diesal_required->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_fill->FormValue == $this->diesal_fill->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_fill->CurrentValue)))
			$this->diesal_fill->CurrentValue = ConvertToFloatString($this->diesal_fill->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_amount->FormValue == $this->diesal_amount->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_amount->CurrentValue)))
			$this->diesal_amount->CurrentValue = ConvertToFloatString($this->diesal_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_cl_balance->FormValue == $this->diesal_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_cl_balance->CurrentValue)))
			$this->diesal_cl_balance->CurrentValue = ConvertToFloatString($this->diesal_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_average->FormValue == $this->vehicle_average->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_average->CurrentValue)))
			$this->vehicle_average->CurrentValue = ConvertToFloatString($this->vehicle_average->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_required->FormValue == $this->cash_required->CurrentValue && is_numeric(ConvertToFloatString($this->cash_required->CurrentValue)))
			$this->cash_required->CurrentValue = ConvertToFloatString($this->cash_required->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_op_b->FormValue == $this->cash_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->cash_op_b->CurrentValue)))
			$this->cash_op_b->CurrentValue = ConvertToFloatString($this->cash_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_paid->FormValue == $this->cash_paid->CurrentValue && is_numeric(ConvertToFloatString($this->cash_paid->CurrentValue)))
			$this->cash_paid->CurrentValue = ConvertToFloatString($this->cash_paid->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_expenses->FormValue == $this->cash_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->cash_expenses->CurrentValue)))
			$this->cash_expenses->CurrentValue = ConvertToFloatString($this->cash_expenses->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_cl_balance->FormValue == $this->cash_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->cash_cl_balance->CurrentValue)))
			$this->cash_cl_balance->CurrentValue = ConvertToFloatString($this->cash_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_op_b->FormValue == $this->fasttag_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_op_b->CurrentValue)))
			$this->fasttag_op_b->CurrentValue = ConvertToFloatString($this->fasttag_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_recharge->FormValue == $this->fasttag_recharge->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_recharge->CurrentValue)))
			$this->fasttag_recharge->CurrentValue = ConvertToFloatString($this->fasttag_recharge->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_expenses->FormValue == $this->fasttag_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_expenses->CurrentValue)))
			$this->fasttag_expenses->CurrentValue = ConvertToFloatString($this->fasttag_expenses->CurrentValue);

		// Convert decimal values if posted back
		if ($this->toll_expenses_cash->FormValue == $this->toll_expenses_cash->CurrentValue && is_numeric(ConvertToFloatString($this->toll_expenses_cash->CurrentValue)))
			$this->toll_expenses_cash->CurrentValue = ConvertToFloatString($this->toll_expenses_cash->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_cl_balance->FormValue == $this->fasttag_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_cl_balance->CurrentValue)))
			$this->fasttag_cl_balance->CurrentValue = ConvertToFloatString($this->fasttag_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_comm->FormValue == $this->vehicle_freight_comm->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_comm->CurrentValue)))
			$this->vehicle_freight_comm->CurrentValue = ConvertToFloatString($this->vehicle_freight_comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_amount->FormValue == $this->vehicle_freight_amount->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_amount->CurrentValue)))
			$this->vehicle_freight_amount->CurrentValue = ConvertToFloatString($this->vehicle_freight_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_final->FormValue == $this->vehicle_freight_final->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_final->CurrentValue)))
			$this->vehicle_freight_final->CurrentValue = ConvertToFloatString($this->vehicle_freight_final->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// vehicle_type
		// vehicle
		// route
		// route_name
		// reports_to
		// buyer
		// b_consignor
		// b_consignee
		// load_date
		// load_weight
		// unload_date
		// unload_weight
		// invoice_no
		// invoice_date
		// amount
		// delivery_pod
		// status
		// days
		// driver
		// driver_name
		// agent
		// comm
		// material
		// packing_type
		// m_hsn
		// @
		// lr_no
		// km
		// freight_type
		// freight
		// ded_det
		// ded_det_remarks
		// gst_percent
		// gst_amount
		// final_amount
		// load_km
		// unload_km
		// delivery_receipt
		// delivery_docket
		// diesal_op_b
		// diesal_required
		// diesal_fill
		// diesal_amount
		// diesal_cl_balance
		// vehicle_average
		// cash_required
		// cash_op_b
		// cash_paid
		// cash_expenses
		// cash_cl_balance
		// fasttag_op_b
		// fasttag_recharge
		// fasttag_expenses
		// toll_expenses_cash
		// fasttag_cl_balance
		// remarks
		// uploads
		// consignor
		// vehicle_freight_comm
		// vehicle_freight_type
		// vehicle_freight_amount
		// vehicle_freight_final
		// operator
		// datetime
		// expenses_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// vehicle_type
			if (strval($this->vehicle_type->CurrentValue) <> "") {
				$this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
			} else {
				$this->vehicle_type->ViewValue = NULL;
			}
			$this->vehicle_type->ViewCustomAttributes = "";

			// vehicle
			$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
			$curVal = strval($this->vehicle->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
					}
				}
			} else {
				$this->vehicle->ViewValue = NULL;
			}
			$this->vehicle->ViewCustomAttributes = "";

			// route
			$this->_route->ViewValue = $this->_route->CurrentValue;
			$curVal = strval($this->_route->CurrentValue);
			if ($curVal <> "") {
				$this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
				if ($this->_route->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->_route->ViewValue = $this->_route->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_route->ViewValue = $this->_route->CurrentValue;
					}
				}
			} else {
				$this->_route->ViewValue = NULL;
			}
			$this->_route->ViewCustomAttributes = "";

			// route_name
			$this->route_name->ViewValue = $this->route_name->CurrentValue;
			$this->route_name->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// buyer
			$this->buyer->ViewValue = $this->buyer->CurrentValue;
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->ViewValue = $this->buyer->CurrentValue;
					}
				}
			} else {
				$this->buyer->ViewValue = NULL;
			}
			$this->buyer->ViewCustomAttributes = "";

			// b_consignor
			$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
			$curVal = strval($this->b_consignor->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
				if ($this->b_consignor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
					}
				}
			} else {
				$this->b_consignor->ViewValue = NULL;
			}
			$this->b_consignor->ViewCustomAttributes = "";

			// b_consignee
			$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
			$curVal = strval($this->b_consignee->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
				if ($this->b_consignee->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
					}
				}
			} else {
				$this->b_consignee->ViewValue = NULL;
			}
			$this->b_consignee->ViewCustomAttributes = "";

			// load_date
			$this->load_date->ViewValue = $this->load_date->CurrentValue;
			$this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, 1);
			$this->load_date->ViewCustomAttributes = "";

			// load_weight
			$this->load_weight->ViewValue = $this->load_weight->CurrentValue;
			$this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, 0, -2, -2, -2);
			$this->load_weight->ViewCustomAttributes = "";

			// unload_date
			$this->unload_date->ViewValue = $this->unload_date->CurrentValue;
			$this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, 0);
			$this->unload_date->ViewCustomAttributes = "";

			// unload_weight
			$this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
			$this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, 0, -2, -2, -2);
			$this->unload_weight->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewValue = FormatNumber($this->invoice_no->ViewValue, 0, -2, -2, -2);
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// delivery_pod
			if (strval($this->delivery_pod->CurrentValue) <> "") {
				$this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
			} else {
				$this->delivery_pod->ViewValue = NULL;
			}
			$this->delivery_pod->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// days
			$this->days->ViewValue = $this->days->CurrentValue;
			$this->days->ViewValue = FormatNumber($this->days->ViewValue, 0, -2, -2, -2);
			$this->days->ViewCustomAttributes = "";

			// driver
			$curVal = strval($this->driver->CurrentValue);
			if ($curVal <> "") {
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
				if ($this->driver->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->driver->ViewValue = $this->driver->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->driver->ViewValue = $this->driver->CurrentValue;
					}
				}
			} else {
				$this->driver->ViewValue = NULL;
			}
			$this->driver->ViewCustomAttributes = "";

			// driver_name
			$this->driver_name->ViewValue = $this->driver_name->CurrentValue;
			$this->driver_name->ViewCustomAttributes = "";

			// agent
			if ($this->agent->VirtualValue <> "") {
				$this->agent->ViewValue = $this->agent->VirtualValue;
			} else {
				$this->agent->ViewValue = $this->agent->CurrentValue;
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->agent->ViewValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->ViewValue = $this->agent->CurrentValue;
					}
				}
			} else {
				$this->agent->ViewValue = NULL;
			}
			}
			$this->agent->ViewCustomAttributes = "";

			// comm
			$this->comm->ViewValue = $this->comm->CurrentValue;
			$this->comm->ViewValue = FormatNumber($this->comm->ViewValue, 2, -2, -2, -2);
			$this->comm->ViewCustomAttributes = "";

			// material
			$this->material->ViewValue = $this->material->CurrentValue;
			$this->material->ViewCustomAttributes = "";

			// packing_type
			$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
			$this->packing_type->ViewCustomAttributes = "";

			// m_hsn
			$this->m_hsn->ViewValue = $this->m_hsn->CurrentValue;
			$this->m_hsn->ViewCustomAttributes = "";

			// @
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 2, -2, -2, -2);
			$this->_40->ViewCustomAttributes = "";

			// lr_no
			$this->lr_no->ViewValue = $this->lr_no->CurrentValue;
			$this->lr_no->ViewCustomAttributes = "";

			// km
			$this->km->ViewValue = $this->km->CurrentValue;
			$this->km->ViewValue = FormatNumber($this->km->ViewValue, 2, -2, -2, -2);
			$this->km->ViewCustomAttributes = "";

			// freight_type
			if (strval($this->freight_type->CurrentValue) <> "") {
				$this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
			} else {
				$this->freight_type->ViewValue = NULL;
			}
			$this->freight_type->ViewCustomAttributes = "";

			// freight
			$this->freight->ViewValue = $this->freight->CurrentValue;
			$this->freight->ViewValue = FormatNumber($this->freight->ViewValue, 2, -2, -2, -2);
			$this->freight->ViewCustomAttributes = "";

			// ded_det
			$this->ded_det->ViewValue = $this->ded_det->CurrentValue;
			$this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, 2, -2, -2, -2);
			$this->ded_det->ViewCustomAttributes = "";

			// ded_det_remarks
			$this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;
			$this->ded_det_remarks->ViewCustomAttributes = "";

			// gst_percent
			$this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
			$this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, 2, -2, -2, -2);
			$this->gst_percent->ViewCustomAttributes = "";

			// gst_amount
			$this->gst_amount->ViewValue = $this->gst_amount->CurrentValue;
			$this->gst_amount->ViewValue = FormatNumber($this->gst_amount->ViewValue, 2, -2, -2, -2);
			$this->gst_amount->ViewCustomAttributes = "";

			// final_amount
			$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
			$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";

			// load_km
			$this->load_km->ViewValue = $this->load_km->CurrentValue;
			$this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, 0, -2, -2, -2);
			$this->load_km->ViewCustomAttributes = "";

			// unload_km
			$this->unload_km->ViewValue = $this->unload_km->CurrentValue;
			$this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, 0, -2, -2, -2);
			$this->unload_km->ViewCustomAttributes = "";

			// delivery_receipt
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->ImageWidth = 0;
				$this->delivery_receipt->ImageHeight = 50;
				$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
				$this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
			} else {
				$this->delivery_receipt->ViewValue = "";
			}
			$this->delivery_receipt->ViewCustomAttributes = "";

			// delivery_docket
			$this->delivery_docket->ViewValue = $this->delivery_docket->CurrentValue;
			$this->delivery_docket->ViewCustomAttributes = "";

			// diesal_op_b
			$this->diesal_op_b->ViewValue = $this->diesal_op_b->CurrentValue;
			$this->diesal_op_b->ViewValue = FormatNumber($this->diesal_op_b->ViewValue, 2, -2, -2, -2);
			$this->diesal_op_b->ViewCustomAttributes = "";

			// diesal_required
			$this->diesal_required->ViewValue = $this->diesal_required->CurrentValue;
			$this->diesal_required->ViewValue = FormatNumber($this->diesal_required->ViewValue, 2, -2, -2, -2);
			$this->diesal_required->ViewCustomAttributes = "";

			// diesal_fill
			$this->diesal_fill->ViewValue = $this->diesal_fill->CurrentValue;
			$this->diesal_fill->ViewValue = FormatNumber($this->diesal_fill->ViewValue, 2, -2, -2, -2);
			$this->diesal_fill->ViewCustomAttributes = "";

			// diesal_amount
			$this->diesal_amount->ViewValue = $this->diesal_amount->CurrentValue;
			$this->diesal_amount->ViewValue = FormatNumber($this->diesal_amount->ViewValue, 2, -2, -2, -2);
			$this->diesal_amount->ViewCustomAttributes = "";

			// diesal_cl_balance
			$this->diesal_cl_balance->ViewValue = $this->diesal_cl_balance->CurrentValue;
			$this->diesal_cl_balance->ViewValue = FormatNumber($this->diesal_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->diesal_cl_balance->ViewCustomAttributes = "";

			// vehicle_average
			$this->vehicle_average->ViewValue = $this->vehicle_average->CurrentValue;
			$this->vehicle_average->ViewValue = FormatNumber($this->vehicle_average->ViewValue, 2, -2, -2, -2);
			$this->vehicle_average->ViewCustomAttributes = "";

			// cash_required
			$this->cash_required->ViewValue = $this->cash_required->CurrentValue;
			$this->cash_required->ViewValue = FormatNumber($this->cash_required->ViewValue, 2, -2, -2, -2);
			$this->cash_required->ViewCustomAttributes = "";

			// cash_op_b
			$this->cash_op_b->ViewValue = $this->cash_op_b->CurrentValue;
			$this->cash_op_b->ViewValue = FormatNumber($this->cash_op_b->ViewValue, 2, -2, -2, -2);
			$this->cash_op_b->ViewCustomAttributes = "";

			// cash_paid
			$this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
			$this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, 2, -2, -2, -2);
			$this->cash_paid->ViewCustomAttributes = "";

			// cash_expenses
			$this->cash_expenses->ViewValue = $this->cash_expenses->CurrentValue;
			$this->cash_expenses->ViewValue = FormatNumber($this->cash_expenses->ViewValue, 2, -2, -2, -2);
			$this->cash_expenses->ViewCustomAttributes = "";

			// cash_cl_balance
			$this->cash_cl_balance->ViewValue = $this->cash_cl_balance->CurrentValue;
			$this->cash_cl_balance->ViewValue = FormatNumber($this->cash_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->cash_cl_balance->ViewCustomAttributes = "";

			// fasttag_op_b
			$this->fasttag_op_b->ViewValue = $this->fasttag_op_b->CurrentValue;
			$this->fasttag_op_b->ViewValue = FormatNumber($this->fasttag_op_b->ViewValue, 2, -2, -2, -2);
			$this->fasttag_op_b->ViewCustomAttributes = "";

			// fasttag_recharge
			$this->fasttag_recharge->ViewValue = $this->fasttag_recharge->CurrentValue;
			$this->fasttag_recharge->ViewValue = FormatNumber($this->fasttag_recharge->ViewValue, 2, -2, -2, -2);
			$this->fasttag_recharge->ViewCustomAttributes = "";

			// fasttag_expenses
			$this->fasttag_expenses->ViewValue = $this->fasttag_expenses->CurrentValue;
			$this->fasttag_expenses->ViewValue = FormatNumber($this->fasttag_expenses->ViewValue, 2, -2, -2, -2);
			$this->fasttag_expenses->ViewCustomAttributes = "";

			// toll_expenses_cash
			$this->toll_expenses_cash->ViewValue = $this->toll_expenses_cash->CurrentValue;
			$this->toll_expenses_cash->ViewValue = FormatNumber($this->toll_expenses_cash->ViewValue, 2, -2, -2, -2);
			$this->toll_expenses_cash->ViewCustomAttributes = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
			$this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->fasttag_cl_balance->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// uploads
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// consignor
			$this->consignor->ViewValue = $this->consignor->CurrentValue;
			$curVal = strval($this->consignor->CurrentValue);
			if ($curVal <> "") {
				$this->consignor->ViewValue = $this->consignor->lookupCacheOption($curVal);
				if ($this->consignor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->consignor->ViewValue = $this->consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignor->ViewValue = $this->consignor->CurrentValue;
					}
				}
			} else {
				$this->consignor->ViewValue = NULL;
			}
			$this->consignor->ViewCustomAttributes = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
			$this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_comm->ViewCustomAttributes = "";

			// vehicle_freight_type
			if (strval($this->vehicle_freight_type->CurrentValue) <> "") {
				$this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
			} else {
				$this->vehicle_freight_type->ViewValue = NULL;
			}
			$this->vehicle_freight_type->ViewCustomAttributes = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
			$this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_amount->ViewCustomAttributes = "";

			// vehicle_freight_final
			$this->vehicle_freight_final->ViewValue = $this->vehicle_freight_final->CurrentValue;
			$this->vehicle_freight_final->ViewValue = FormatNumber($this->vehicle_freight_final->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_final->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// vehicle_type
			$this->vehicle_type->LinkCustomAttributes = "";
			$this->vehicle_type->HrefValue = "";
			$this->vehicle_type->TooltipValue = "";

			// vehicle
			$this->vehicle->LinkCustomAttributes = "";
			$this->vehicle->HrefValue = "";
			$this->vehicle->TooltipValue = "";

			// route
			$this->_route->LinkCustomAttributes = "";
			$this->_route->HrefValue = "";
			$this->_route->TooltipValue = "";

			// route_name
			$this->route_name->LinkCustomAttributes = "";
			$this->route_name->HrefValue = "";
			$this->route_name->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			$this->buyer->HrefValue = "";
			$this->buyer->TooltipValue = "";

			// b_consignor
			$this->b_consignor->LinkCustomAttributes = "";
			$this->b_consignor->HrefValue = "";
			$this->b_consignor->TooltipValue = "";

			// b_consignee
			$this->b_consignee->LinkCustomAttributes = "";
			$this->b_consignee->HrefValue = "";
			$this->b_consignee->TooltipValue = "";

			// load_date
			$this->load_date->LinkCustomAttributes = "";
			$this->load_date->HrefValue = "";
			$this->load_date->TooltipValue = "";

			// load_weight
			$this->load_weight->LinkCustomAttributes = "";
			$this->load_weight->HrefValue = "";
			$this->load_weight->TooltipValue = "";

			// unload_date
			$this->unload_date->LinkCustomAttributes = "";
			$this->unload_date->HrefValue = "";
			$this->unload_date->TooltipValue = "";

			// unload_weight
			$this->unload_weight->LinkCustomAttributes = "";
			$this->unload_weight->HrefValue = "";
			$this->unload_weight->TooltipValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";
			$this->invoice_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// delivery_pod
			$this->delivery_pod->LinkCustomAttributes = "";
			$this->delivery_pod->HrefValue = "";
			$this->delivery_pod->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// days
			$this->days->LinkCustomAttributes = "";
			$this->days->HrefValue = "";
			$this->days->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";
			$this->driver->TooltipValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";
			$this->driver_name->TooltipValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";
			$this->agent->TooltipValue = "";

			// comm
			$this->comm->LinkCustomAttributes = "";
			$this->comm->HrefValue = "";
			$this->comm->TooltipValue = "";

			// material
			$this->material->LinkCustomAttributes = "";
			$this->material->HrefValue = "";
			$this->material->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// m_hsn
			$this->m_hsn->LinkCustomAttributes = "";
			$this->m_hsn->HrefValue = "";
			$this->m_hsn->TooltipValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// lr_no
			$this->lr_no->LinkCustomAttributes = "";
			$this->lr_no->HrefValue = "";
			$this->lr_no->TooltipValue = "";

			// km
			$this->km->LinkCustomAttributes = "";
			$this->km->HrefValue = "";
			$this->km->TooltipValue = "";

			// freight_type
			$this->freight_type->LinkCustomAttributes = "";
			$this->freight_type->HrefValue = "";
			$this->freight_type->TooltipValue = "";

			// freight
			$this->freight->LinkCustomAttributes = "";
			$this->freight->HrefValue = "";
			$this->freight->TooltipValue = "";

			// ded_det
			$this->ded_det->LinkCustomAttributes = "";
			$this->ded_det->HrefValue = "";
			$this->ded_det->TooltipValue = "";

			// ded_det_remarks
			$this->ded_det_remarks->LinkCustomAttributes = "";
			$this->ded_det_remarks->HrefValue = "";
			$this->ded_det_remarks->TooltipValue = "";

			// gst_percent
			$this->gst_percent->LinkCustomAttributes = "";
			$this->gst_percent->HrefValue = "";
			$this->gst_percent->TooltipValue = "";

			// gst_amount
			$this->gst_amount->LinkCustomAttributes = "";
			$this->gst_amount->HrefValue = "";
			$this->gst_amount->TooltipValue = "";

			// final_amount
			$this->final_amount->LinkCustomAttributes = "";
			$this->final_amount->HrefValue = "";
			$this->final_amount->TooltipValue = "";

			// load_km
			$this->load_km->LinkCustomAttributes = "";
			$this->load_km->HrefValue = "";
			$this->load_km->TooltipValue = "";

			// unload_km
			$this->unload_km->LinkCustomAttributes = "";
			$this->unload_km->HrefValue = "";
			$this->unload_km->TooltipValue = "";

			// delivery_receipt
			$this->delivery_receipt->LinkCustomAttributes = "";
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
				$this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
			} else {
				$this->delivery_receipt->HrefValue = "";
			}
			$this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;
			$this->delivery_receipt->TooltipValue = "";
			if ($this->delivery_receipt->UseColorbox) {
				if (EmptyValue($this->delivery_receipt->TooltipValue))
					$this->delivery_receipt->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->delivery_receipt->LinkAttrs["data-rel"] = "t_trip_info_x_delivery_receipt";
				AppendClass($this->delivery_receipt->LinkAttrs["class"], "ew-lightbox");
			}

			// delivery_docket
			$this->delivery_docket->LinkCustomAttributes = "";
			$this->delivery_docket->HrefValue = "";
			$this->delivery_docket->TooltipValue = "";

			// diesal_op_b
			$this->diesal_op_b->LinkCustomAttributes = "";
			$this->diesal_op_b->HrefValue = "";
			$this->diesal_op_b->TooltipValue = "";

			// diesal_required
			$this->diesal_required->LinkCustomAttributes = "";
			$this->diesal_required->HrefValue = "";
			$this->diesal_required->TooltipValue = "";

			// diesal_fill
			$this->diesal_fill->LinkCustomAttributes = "";
			$this->diesal_fill->HrefValue = "";
			$this->diesal_fill->TooltipValue = "";

			// diesal_amount
			$this->diesal_amount->LinkCustomAttributes = "";
			$this->diesal_amount->HrefValue = "";
			$this->diesal_amount->TooltipValue = "";

			// diesal_cl_balance
			$this->diesal_cl_balance->LinkCustomAttributes = "";
			$this->diesal_cl_balance->HrefValue = "";
			$this->diesal_cl_balance->TooltipValue = "";

			// vehicle_average
			$this->vehicle_average->LinkCustomAttributes = "";
			$this->vehicle_average->HrefValue = "";
			$this->vehicle_average->TooltipValue = "";

			// cash_required
			$this->cash_required->LinkCustomAttributes = "";
			$this->cash_required->HrefValue = "";
			$this->cash_required->TooltipValue = "";

			// cash_op_b
			$this->cash_op_b->LinkCustomAttributes = "";
			$this->cash_op_b->HrefValue = "";
			$this->cash_op_b->TooltipValue = "";

			// cash_paid
			$this->cash_paid->LinkCustomAttributes = "";
			$this->cash_paid->HrefValue = "";
			$this->cash_paid->TooltipValue = "";

			// cash_expenses
			$this->cash_expenses->LinkCustomAttributes = "";
			$this->cash_expenses->HrefValue = "";
			$this->cash_expenses->TooltipValue = "";

			// cash_cl_balance
			$this->cash_cl_balance->LinkCustomAttributes = "";
			$this->cash_cl_balance->HrefValue = "";
			$this->cash_cl_balance->TooltipValue = "";

			// fasttag_op_b
			$this->fasttag_op_b->LinkCustomAttributes = "";
			$this->fasttag_op_b->HrefValue = "";
			$this->fasttag_op_b->TooltipValue = "";

			// fasttag_recharge
			$this->fasttag_recharge->LinkCustomAttributes = "";
			$this->fasttag_recharge->HrefValue = "";
			$this->fasttag_recharge->TooltipValue = "";

			// fasttag_expenses
			$this->fasttag_expenses->LinkCustomAttributes = "";
			$this->fasttag_expenses->HrefValue = "";
			$this->fasttag_expenses->TooltipValue = "";

			// toll_expenses_cash
			$this->toll_expenses_cash->LinkCustomAttributes = "";
			$this->toll_expenses_cash->HrefValue = "";
			$this->toll_expenses_cash->TooltipValue = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->LinkCustomAttributes = "";
			$this->fasttag_cl_balance->HrefValue = "";
			$this->fasttag_cl_balance->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = GetFileUploadUrl($this->uploads, $this->uploads->Upload->DbValue); // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "t_trip_info_x_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// consignor
			$this->consignor->LinkCustomAttributes = "";
			$this->consignor->HrefValue = "";
			$this->consignor->TooltipValue = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->LinkCustomAttributes = "";
			$this->vehicle_freight_comm->HrefValue = "";
			$this->vehicle_freight_comm->TooltipValue = "";

			// vehicle_freight_type
			$this->vehicle_freight_type->LinkCustomAttributes = "";
			$this->vehicle_freight_type->HrefValue = "";
			$this->vehicle_freight_type->TooltipValue = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->LinkCustomAttributes = "";
			$this->vehicle_freight_amount->HrefValue = "";
			$this->vehicle_freight_amount->TooltipValue = "";

			// vehicle_freight_final
			$this->vehicle_freight_final->LinkCustomAttributes = "";
			$this->vehicle_freight_final->HrefValue = "";
			$this->vehicle_freight_final->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_EDIT) { // Edit row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// vehicle_type
			$this->vehicle_type->EditAttrs["class"] = "form-control";
			$this->vehicle_type->EditCustomAttributes = "";
			$this->vehicle_type->EditValue = $this->vehicle_type->options(TRUE);

			// vehicle
			$this->vehicle->EditAttrs["class"] = "form-control";
			$this->vehicle->EditCustomAttributes = "";
			$this->vehicle->EditValue = $this->vehicle->CurrentValue;
			$curVal = strval($this->vehicle->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->EditValue = $this->vehicle->CurrentValue;
					}
				}
			} else {
				$this->vehicle->EditValue = NULL;
			}
			$this->vehicle->ViewCustomAttributes = "";

			// route
			$this->_route->EditAttrs["class"] = "form-control";
			$this->_route->EditCustomAttributes = "";
			$this->_route->EditValue = HtmlEncode($this->_route->CurrentValue);
			$curVal = strval($this->_route->CurrentValue);
			if ($curVal <> "") {
				$this->_route->EditValue = $this->_route->lookupCacheOption($curVal);
				if ($this->_route->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->_route->EditValue = $this->_route->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_route->EditValue = HtmlEncode($this->_route->CurrentValue);
					}
				}
			} else {
				$this->_route->EditValue = NULL;
			}
			$this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

			// route_name
			$this->route_name->EditAttrs["class"] = "form-control";
			$this->route_name->EditCustomAttributes = "";
			$this->route_name->EditValue = $this->route_name->CurrentValue;
			$this->route_name->ViewCustomAttributes = "";

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->reports_to->CurrentValue));
			if ($curVal <> "")
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			else
				$this->reports_to->ViewValue = $this->reports_to->Lookup !== NULL && is_array($this->reports_to->Lookup->Options) ? $curVal : NULL;
			if ($this->reports_to->ViewValue !== NULL) { // Load from cache
				$this->reports_to->EditValue = array_values($this->reports_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->reports_to->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`activated`=1 and `userlevel`=1003";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->reports_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->reports_to->EditValue = $arwrk;
			}

			// buyer
			$this->buyer->EditAttrs["class"] = "form-control";
			$this->buyer->EditCustomAttributes = "";
			$this->buyer->EditValue = HtmlEncode($this->buyer->CurrentValue);
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->EditValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->buyer->EditValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->EditValue = HtmlEncode($this->buyer->CurrentValue);
					}
				}
			} else {
				$this->buyer->EditValue = NULL;
			}
			$this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

			// b_consignor
			$this->b_consignor->EditAttrs["class"] = "form-control";
			$this->b_consignor->EditCustomAttributes = "";
			$this->b_consignor->EditValue = HtmlEncode($this->b_consignor->CurrentValue);
			$curVal = strval($this->b_consignor->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignor->EditValue = $this->b_consignor->lookupCacheOption($curVal);
				if ($this->b_consignor->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->b_consignor->EditValue = $this->b_consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignor->EditValue = HtmlEncode($this->b_consignor->CurrentValue);
					}
				}
			} else {
				$this->b_consignor->EditValue = NULL;
			}
			$this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());

			// b_consignee
			$this->b_consignee->EditAttrs["class"] = "form-control";
			$this->b_consignee->EditCustomAttributes = "";
			$this->b_consignee->EditValue = HtmlEncode($this->b_consignee->CurrentValue);
			$curVal = strval($this->b_consignee->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignee->EditValue = $this->b_consignee->lookupCacheOption($curVal);
				if ($this->b_consignee->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->b_consignee->EditValue = $this->b_consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignee->EditValue = HtmlEncode($this->b_consignee->CurrentValue);
					}
				}
			} else {
				$this->b_consignee->EditValue = NULL;
			}
			$this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());

			// load_date
			$this->load_date->EditAttrs["class"] = "form-control";
			$this->load_date->EditCustomAttributes = "";
			$this->load_date->EditValue = HtmlEncode(FormatDateTime($this->load_date->CurrentValue, 8));
			$this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

			// load_weight
			$this->load_weight->EditAttrs["class"] = "form-control";
			$this->load_weight->EditCustomAttributes = "";
			$this->load_weight->EditValue = HtmlEncode($this->load_weight->CurrentValue);
			$this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());

			// unload_date
			$this->unload_date->EditAttrs["class"] = "form-control";
			$this->unload_date->EditCustomAttributes = "";
			$this->unload_date->EditValue = HtmlEncode(FormatDateTime($this->unload_date->CurrentValue, 8));
			$this->unload_date->PlaceHolder = RemoveHtml($this->unload_date->caption());

			// unload_weight
			$this->unload_weight->EditAttrs["class"] = "form-control";
			$this->unload_weight->EditCustomAttributes = "";
			$this->unload_weight->EditValue = HtmlEncode($this->unload_weight->CurrentValue);
			$this->unload_weight->PlaceHolder = RemoveHtml($this->unload_weight->caption());

			// invoice_no
			$this->invoice_no->EditAttrs["class"] = "form-control";
			$this->invoice_no->EditCustomAttributes = "";
			$this->invoice_no->EditValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->EditValue = FormatNumber($this->invoice_no->EditValue, 0, -2, -2, -2);
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->EditValue = FormatDateTime($this->invoice_date->EditValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			$this->amount->EditValue = $this->amount->CurrentValue;
			$this->amount->EditValue = FormatNumber($this->amount->EditValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// delivery_pod
			$this->delivery_pod->EditCustomAttributes = "";
			$this->delivery_pod->EditValue = $this->delivery_pod->options(FALSE);

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->EditValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->EditValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// days
			$this->days->EditAttrs["class"] = "form-control";
			$this->days->EditCustomAttributes = "";
			$this->days->EditValue = $this->days->CurrentValue;
			$this->days->EditValue = FormatNumber($this->days->EditValue, 0, -2, -2, -2);
			$this->days->ViewCustomAttributes = "";

			// driver
			$this->driver->EditAttrs["class"] = "form-control";
			$this->driver->EditCustomAttributes = "";
			$curVal = trim(strval($this->driver->CurrentValue));
			if ($curVal <> "")
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
			else
				$this->driver->ViewValue = $this->driver->Lookup !== NULL && is_array($this->driver->Lookup->Options) ? $curVal : NULL;
			if ($this->driver->ViewValue !== NULL) { // Load from cache
				$this->driver->EditValue = array_values($this->driver->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->driver->CurrentValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->driver->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->driver->EditValue = $arwrk;
			}

			// driver_name
			$this->driver_name->EditAttrs["class"] = "form-control";
			$this->driver_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->driver_name->CurrentValue = HtmlDecode($this->driver_name->CurrentValue);
			$this->driver_name->EditValue = HtmlEncode($this->driver_name->CurrentValue);
			$this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

			// agent
			$this->agent->EditAttrs["class"] = "form-control";
			$this->agent->EditCustomAttributes = "";
			$this->agent->EditValue = HtmlEncode($this->agent->CurrentValue);
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->EditValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->agent->EditValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->EditValue = HtmlEncode($this->agent->CurrentValue);
					}
				}
			} else {
				$this->agent->EditValue = NULL;
			}
			$this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

			// comm
			$this->comm->EditAttrs["class"] = "form-control";
			$this->comm->EditCustomAttributes = "";
			$this->comm->EditValue = HtmlEncode($this->comm->CurrentValue);
			$this->comm->PlaceHolder = RemoveHtml($this->comm->caption());
			if (strval($this->comm->EditValue) <> "" && is_numeric($this->comm->EditValue))
				$this->comm->EditValue = FormatNumber($this->comm->EditValue, -2, -2, -2, -2);

			// material
			$this->material->EditAttrs["class"] = "form-control";
			$this->material->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->material->CurrentValue = HtmlDecode($this->material->CurrentValue);
			$this->material->EditValue = HtmlEncode($this->material->CurrentValue);
			$this->material->PlaceHolder = RemoveHtml($this->material->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->packing_type->CurrentValue = HtmlDecode($this->packing_type->CurrentValue);
			$this->packing_type->EditValue = HtmlEncode($this->packing_type->CurrentValue);
			$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

			// m_hsn
			$this->m_hsn->EditAttrs["class"] = "form-control";
			$this->m_hsn->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->m_hsn->CurrentValue = HtmlDecode($this->m_hsn->CurrentValue);
			$this->m_hsn->EditValue = HtmlEncode($this->m_hsn->CurrentValue);
			$this->m_hsn->PlaceHolder = RemoveHtml($this->m_hsn->caption());

			// @
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			$this->_40->EditValue = HtmlEncode($this->_40->CurrentValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());
			if (strval($this->_40->EditValue) <> "" && is_numeric($this->_40->EditValue))
				$this->_40->EditValue = FormatNumber($this->_40->EditValue, -2, -2, -2, -2);

			// lr_no
			$this->lr_no->EditAttrs["class"] = "form-control";
			$this->lr_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lr_no->CurrentValue = HtmlDecode($this->lr_no->CurrentValue);
			$this->lr_no->EditValue = HtmlEncode($this->lr_no->CurrentValue);
			$this->lr_no->PlaceHolder = RemoveHtml($this->lr_no->caption());

			// km
			$this->km->EditAttrs["class"] = "form-control";
			$this->km->EditCustomAttributes = "";
			$this->km->EditValue = HtmlEncode($this->km->CurrentValue);
			$this->km->PlaceHolder = RemoveHtml($this->km->caption());
			if (strval($this->km->EditValue) <> "" && is_numeric($this->km->EditValue))
				$this->km->EditValue = FormatNumber($this->km->EditValue, -2, -2, -2, -2);

			// freight_type
			$this->freight_type->EditAttrs["class"] = "form-control";
			$this->freight_type->EditCustomAttributes = "";
			$this->freight_type->EditValue = $this->freight_type->options(TRUE);

			// freight
			$this->freight->EditAttrs["class"] = "form-control";
			$this->freight->EditCustomAttributes = "";
			$this->freight->EditValue = HtmlEncode($this->freight->CurrentValue);
			$this->freight->PlaceHolder = RemoveHtml($this->freight->caption());
			if (strval($this->freight->EditValue) <> "" && is_numeric($this->freight->EditValue))
				$this->freight->EditValue = FormatNumber($this->freight->EditValue, -2, -2, -2, -2);

			// ded_det
			$this->ded_det->EditAttrs["class"] = "form-control";
			$this->ded_det->EditCustomAttributes = "";
			$this->ded_det->EditValue = HtmlEncode($this->ded_det->CurrentValue);
			$this->ded_det->PlaceHolder = RemoveHtml($this->ded_det->caption());
			if (strval($this->ded_det->EditValue) <> "" && is_numeric($this->ded_det->EditValue))
				$this->ded_det->EditValue = FormatNumber($this->ded_det->EditValue, -2, -2, -2, -2);

			// ded_det_remarks
			$this->ded_det_remarks->EditAttrs["class"] = "form-control";
			$this->ded_det_remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ded_det_remarks->CurrentValue = HtmlDecode($this->ded_det_remarks->CurrentValue);
			$this->ded_det_remarks->EditValue = HtmlEncode($this->ded_det_remarks->CurrentValue);
			$this->ded_det_remarks->PlaceHolder = RemoveHtml($this->ded_det_remarks->caption());

			// gst_percent
			$this->gst_percent->EditAttrs["class"] = "form-control";
			$this->gst_percent->EditCustomAttributes = "";
			$this->gst_percent->EditValue = HtmlEncode($this->gst_percent->CurrentValue);
			$this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());
			if (strval($this->gst_percent->EditValue) <> "" && is_numeric($this->gst_percent->EditValue))
				$this->gst_percent->EditValue = FormatNumber($this->gst_percent->EditValue, -2, -2, -2, -2);

			// gst_amount
			$this->gst_amount->EditAttrs["class"] = "form-control";
			$this->gst_amount->EditCustomAttributes = "";
			$this->gst_amount->EditValue = $this->gst_amount->CurrentValue;
			$this->gst_amount->EditValue = FormatNumber($this->gst_amount->EditValue, 2, -2, -2, -2);
			$this->gst_amount->ViewCustomAttributes = "";

			// final_amount
			$this->final_amount->EditAttrs["class"] = "form-control";
			$this->final_amount->EditCustomAttributes = "";
			$this->final_amount->EditValue = $this->final_amount->CurrentValue;
			$this->final_amount->EditValue = FormatNumber($this->final_amount->EditValue, 2, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";

			// load_km
			$this->load_km->EditAttrs["class"] = "form-control";
			$this->load_km->EditCustomAttributes = "";
			$this->load_km->EditValue = HtmlEncode($this->load_km->CurrentValue);
			$this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());

			// unload_km
			$this->unload_km->EditAttrs["class"] = "form-control";
			$this->unload_km->EditCustomAttributes = "";
			$this->unload_km->EditValue = HtmlEncode($this->unload_km->CurrentValue);
			$this->unload_km->PlaceHolder = RemoveHtml($this->unload_km->caption());

			// delivery_receipt
			$this->delivery_receipt->EditAttrs["class"] = "form-control";
			$this->delivery_receipt->EditCustomAttributes = "";
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->ImageWidth = 0;
				$this->delivery_receipt->ImageHeight = 50;
				$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
				$this->delivery_receipt->EditValue = $this->delivery_receipt->Upload->DbValue;
			} else {
				$this->delivery_receipt->EditValue = "";
			}
			if (!EmptyValue($this->delivery_receipt->CurrentValue))
					$this->delivery_receipt->Upload->FileName = $this->delivery_receipt->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->delivery_receipt);

			// delivery_docket
			$this->delivery_docket->EditAttrs["class"] = "form-control";
			$this->delivery_docket->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->delivery_docket->CurrentValue = HtmlDecode($this->delivery_docket->CurrentValue);
			$this->delivery_docket->EditValue = HtmlEncode($this->delivery_docket->CurrentValue);
			$this->delivery_docket->PlaceHolder = RemoveHtml($this->delivery_docket->caption());

			// diesal_op_b
			$this->diesal_op_b->EditAttrs["class"] = "form-control";
			$this->diesal_op_b->EditCustomAttributes = "";
			$this->diesal_op_b->EditValue = $this->diesal_op_b->CurrentValue;
			$this->diesal_op_b->EditValue = FormatNumber($this->diesal_op_b->EditValue, 2, -2, -2, -2);
			$this->diesal_op_b->ViewCustomAttributes = "";

			// diesal_required
			$this->diesal_required->EditAttrs["class"] = "form-control";
			$this->diesal_required->EditCustomAttributes = "";
			$this->diesal_required->EditValue = $this->diesal_required->CurrentValue;
			$this->diesal_required->EditValue = FormatNumber($this->diesal_required->EditValue, 2, -2, -2, -2);
			$this->diesal_required->ViewCustomAttributes = "";

			// diesal_fill
			$this->diesal_fill->EditAttrs["class"] = "form-control";
			$this->diesal_fill->EditCustomAttributes = "";
			$this->diesal_fill->EditValue = $this->diesal_fill->CurrentValue;
			$this->diesal_fill->EditValue = FormatNumber($this->diesal_fill->EditValue, 2, -2, -2, -2);
			$this->diesal_fill->ViewCustomAttributes = "";

			// diesal_amount
			$this->diesal_amount->EditAttrs["class"] = "form-control";
			$this->diesal_amount->EditCustomAttributes = "";
			$this->diesal_amount->EditValue = $this->diesal_amount->CurrentValue;
			$this->diesal_amount->EditValue = FormatNumber($this->diesal_amount->EditValue, 2, -2, -2, -2);
			$this->diesal_amount->ViewCustomAttributes = "";

			// diesal_cl_balance
			$this->diesal_cl_balance->EditAttrs["class"] = "form-control";
			$this->diesal_cl_balance->EditCustomAttributes = "";
			$this->diesal_cl_balance->EditValue = $this->diesal_cl_balance->CurrentValue;
			$this->diesal_cl_balance->EditValue = FormatNumber($this->diesal_cl_balance->EditValue, 2, -2, -2, -2);
			$this->diesal_cl_balance->ViewCustomAttributes = "";

			// vehicle_average
			$this->vehicle_average->EditAttrs["class"] = "form-control";
			$this->vehicle_average->EditCustomAttributes = "";
			$this->vehicle_average->EditValue = $this->vehicle_average->CurrentValue;
			$this->vehicle_average->EditValue = FormatNumber($this->vehicle_average->EditValue, 2, -2, -2, -2);
			$this->vehicle_average->ViewCustomAttributes = "";

			// cash_required
			$this->cash_required->EditAttrs["class"] = "form-control";
			$this->cash_required->EditCustomAttributes = "";
			$this->cash_required->EditValue = $this->cash_required->CurrentValue;
			$this->cash_required->EditValue = FormatNumber($this->cash_required->EditValue, 2, -2, -2, -2);
			$this->cash_required->ViewCustomAttributes = "";

			// cash_op_b
			$this->cash_op_b->EditAttrs["class"] = "form-control";
			$this->cash_op_b->EditCustomAttributes = "";
			$this->cash_op_b->EditValue = $this->cash_op_b->CurrentValue;
			$this->cash_op_b->EditValue = FormatNumber($this->cash_op_b->EditValue, 2, -2, -2, -2);
			$this->cash_op_b->ViewCustomAttributes = "";

			// cash_paid
			$this->cash_paid->EditAttrs["class"] = "form-control";
			$this->cash_paid->EditCustomAttributes = "";
			$this->cash_paid->EditValue = $this->cash_paid->CurrentValue;
			$this->cash_paid->EditValue = FormatNumber($this->cash_paid->EditValue, 2, -2, -2, -2);
			$this->cash_paid->ViewCustomAttributes = "";

			// cash_expenses
			$this->cash_expenses->EditAttrs["class"] = "form-control";
			$this->cash_expenses->EditCustomAttributes = "";
			$this->cash_expenses->EditValue = $this->cash_expenses->CurrentValue;
			$this->cash_expenses->EditValue = FormatNumber($this->cash_expenses->EditValue, 2, -2, -2, -2);
			$this->cash_expenses->ViewCustomAttributes = "";

			// cash_cl_balance
			$this->cash_cl_balance->EditAttrs["class"] = "form-control";
			$this->cash_cl_balance->EditCustomAttributes = "";
			$this->cash_cl_balance->EditValue = $this->cash_cl_balance->CurrentValue;
			$this->cash_cl_balance->EditValue = FormatNumber($this->cash_cl_balance->EditValue, 2, -2, -2, -2);
			$this->cash_cl_balance->ViewCustomAttributes = "";

			// fasttag_op_b
			$this->fasttag_op_b->EditAttrs["class"] = "form-control";
			$this->fasttag_op_b->EditCustomAttributes = "";
			$this->fasttag_op_b->EditValue = $this->fasttag_op_b->CurrentValue;
			$this->fasttag_op_b->EditValue = FormatNumber($this->fasttag_op_b->EditValue, 2, -2, -2, -2);
			$this->fasttag_op_b->ViewCustomAttributes = "";

			// fasttag_recharge
			$this->fasttag_recharge->EditAttrs["class"] = "form-control";
			$this->fasttag_recharge->EditCustomAttributes = "";
			$this->fasttag_recharge->EditValue = $this->fasttag_recharge->CurrentValue;
			$this->fasttag_recharge->EditValue = FormatNumber($this->fasttag_recharge->EditValue, 2, -2, -2, -2);
			$this->fasttag_recharge->ViewCustomAttributes = "";

			// fasttag_expenses
			$this->fasttag_expenses->EditAttrs["class"] = "form-control";
			$this->fasttag_expenses->EditCustomAttributes = "";
			$this->fasttag_expenses->EditValue = $this->fasttag_expenses->CurrentValue;
			$this->fasttag_expenses->EditValue = FormatNumber($this->fasttag_expenses->EditValue, 2, -2, -2, -2);
			$this->fasttag_expenses->ViewCustomAttributes = "";

			// toll_expenses_cash
			$this->toll_expenses_cash->EditAttrs["class"] = "form-control";
			$this->toll_expenses_cash->EditCustomAttributes = "";
			$this->toll_expenses_cash->EditValue = $this->toll_expenses_cash->CurrentValue;
			$this->toll_expenses_cash->EditValue = FormatNumber($this->toll_expenses_cash->EditValue, 2, -2, -2, -2);
			$this->toll_expenses_cash->ViewCustomAttributes = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->EditAttrs["class"] = "form-control";
			$this->fasttag_cl_balance->EditCustomAttributes = "";
			$this->fasttag_cl_balance->EditValue = HtmlEncode($this->fasttag_cl_balance->CurrentValue);
			$this->fasttag_cl_balance->PlaceHolder = RemoveHtml($this->fasttag_cl_balance->caption());
			if (strval($this->fasttag_cl_balance->EditValue) <> "" && is_numeric($this->fasttag_cl_balance->EditValue))
				$this->fasttag_cl_balance->EditValue = FormatNumber($this->fasttag_cl_balance->EditValue, -2, -2, -2, -2);

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->CurrentValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->EditValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->EditValue = "";
			}
			if (!EmptyValue($this->uploads->CurrentValue))
					$this->uploads->Upload->FileName = $this->uploads->CurrentValue;
			if ($this->isShow() && !$this->EventCancelled)
				RenderUploadField($this->uploads);

			// consignor
			$this->consignor->EditAttrs["class"] = "form-control";
			$this->consignor->EditCustomAttributes = 'ReadOnly';
			$this->consignor->EditValue = HtmlEncode($this->consignor->CurrentValue);
			$curVal = strval($this->consignor->CurrentValue);
			if ($curVal <> "") {
				$this->consignor->EditValue = $this->consignor->lookupCacheOption($curVal);
				if ($this->consignor->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->consignor->EditValue = $this->consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignor->EditValue = HtmlEncode($this->consignor->CurrentValue);
					}
				}
			} else {
				$this->consignor->EditValue = NULL;
			}
			$this->consignor->PlaceHolder = RemoveHtml($this->consignor->caption());

			// vehicle_freight_comm
			$this->vehicle_freight_comm->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_comm->EditCustomAttributes = "";
			$this->vehicle_freight_comm->EditValue = HtmlEncode($this->vehicle_freight_comm->CurrentValue);
			$this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());
			if (strval($this->vehicle_freight_comm->EditValue) <> "" && is_numeric($this->vehicle_freight_comm->EditValue))
				$this->vehicle_freight_comm->EditValue = FormatNumber($this->vehicle_freight_comm->EditValue, -2, -2, -2, -2);

			// vehicle_freight_type
			$this->vehicle_freight_type->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_type->EditCustomAttributes = "";
			$this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(TRUE);

			// vehicle_freight_amount
			$this->vehicle_freight_amount->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_amount->EditCustomAttributes = "";
			$this->vehicle_freight_amount->EditValue = HtmlEncode($this->vehicle_freight_amount->CurrentValue);
			$this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());
			if (strval($this->vehicle_freight_amount->EditValue) <> "" && is_numeric($this->vehicle_freight_amount->EditValue))
				$this->vehicle_freight_amount->EditValue = FormatNumber($this->vehicle_freight_amount->EditValue, -2, -2, -2, -2);

			// vehicle_freight_final
			$this->vehicle_freight_final->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_final->EditCustomAttributes = "";
			$this->vehicle_freight_final->EditValue = $this->vehicle_freight_final->CurrentValue;
			$this->vehicle_freight_final->EditValue = FormatNumber($this->vehicle_freight_final->EditValue, 2, -2, -2, -2);
			$this->vehicle_freight_final->ViewCustomAttributes = "";

			// operator
			// datetime
			// Edit refer script
			// id

			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";

			// vehicle_type
			$this->vehicle_type->LinkCustomAttributes = "";
			$this->vehicle_type->HrefValue = "";

			// vehicle
			$this->vehicle->LinkCustomAttributes = "";
			$this->vehicle->HrefValue = "";
			$this->vehicle->TooltipValue = "";

			// route
			$this->_route->LinkCustomAttributes = "";
			$this->_route->HrefValue = "";

			// route_name
			$this->route_name->LinkCustomAttributes = "";
			$this->route_name->HrefValue = "";
			$this->route_name->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			$this->buyer->HrefValue = "";

			// b_consignor
			$this->b_consignor->LinkCustomAttributes = "";
			$this->b_consignor->HrefValue = "";

			// b_consignee
			$this->b_consignee->LinkCustomAttributes = "";
			$this->b_consignee->HrefValue = "";

			// load_date
			$this->load_date->LinkCustomAttributes = "";
			$this->load_date->HrefValue = "";

			// load_weight
			$this->load_weight->LinkCustomAttributes = "";
			$this->load_weight->HrefValue = "";

			// unload_date
			$this->unload_date->LinkCustomAttributes = "";
			$this->unload_date->HrefValue = "";

			// unload_weight
			$this->unload_weight->LinkCustomAttributes = "";
			$this->unload_weight->HrefValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";
			$this->invoice_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// delivery_pod
			$this->delivery_pod->LinkCustomAttributes = "";
			$this->delivery_pod->HrefValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// days
			$this->days->LinkCustomAttributes = "";
			$this->days->HrefValue = "";
			$this->days->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";

			// comm
			$this->comm->LinkCustomAttributes = "";
			$this->comm->HrefValue = "";

			// material
			$this->material->LinkCustomAttributes = "";
			$this->material->HrefValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";

			// m_hsn
			$this->m_hsn->LinkCustomAttributes = "";
			$this->m_hsn->HrefValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";

			// lr_no
			$this->lr_no->LinkCustomAttributes = "";
			$this->lr_no->HrefValue = "";

			// km
			$this->km->LinkCustomAttributes = "";
			$this->km->HrefValue = "";

			// freight_type
			$this->freight_type->LinkCustomAttributes = "";
			$this->freight_type->HrefValue = "";

			// freight
			$this->freight->LinkCustomAttributes = "";
			$this->freight->HrefValue = "";

			// ded_det
			$this->ded_det->LinkCustomAttributes = "";
			$this->ded_det->HrefValue = "";

			// ded_det_remarks
			$this->ded_det_remarks->LinkCustomAttributes = "";
			$this->ded_det_remarks->HrefValue = "";

			// gst_percent
			$this->gst_percent->LinkCustomAttributes = "";
			$this->gst_percent->HrefValue = "";

			// gst_amount
			$this->gst_amount->LinkCustomAttributes = "";
			$this->gst_amount->HrefValue = "";
			$this->gst_amount->TooltipValue = "";

			// final_amount
			$this->final_amount->LinkCustomAttributes = "";
			$this->final_amount->HrefValue = "";
			$this->final_amount->TooltipValue = "";

			// load_km
			$this->load_km->LinkCustomAttributes = "";
			$this->load_km->HrefValue = "";

			// unload_km
			$this->unload_km->LinkCustomAttributes = "";
			$this->unload_km->HrefValue = "";

			// delivery_receipt
			$this->delivery_receipt->LinkCustomAttributes = "";
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
				$this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
			} else {
				$this->delivery_receipt->HrefValue = "";
			}
			$this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;

			// delivery_docket
			$this->delivery_docket->LinkCustomAttributes = "";
			$this->delivery_docket->HrefValue = "";

			// diesal_op_b
			$this->diesal_op_b->LinkCustomAttributes = "";
			$this->diesal_op_b->HrefValue = "";
			$this->diesal_op_b->TooltipValue = "";

			// diesal_required
			$this->diesal_required->LinkCustomAttributes = "";
			$this->diesal_required->HrefValue = "";
			$this->diesal_required->TooltipValue = "";

			// diesal_fill
			$this->diesal_fill->LinkCustomAttributes = "";
			$this->diesal_fill->HrefValue = "";
			$this->diesal_fill->TooltipValue = "";

			// diesal_amount
			$this->diesal_amount->LinkCustomAttributes = "";
			$this->diesal_amount->HrefValue = "";
			$this->diesal_amount->TooltipValue = "";

			// diesal_cl_balance
			$this->diesal_cl_balance->LinkCustomAttributes = "";
			$this->diesal_cl_balance->HrefValue = "";
			$this->diesal_cl_balance->TooltipValue = "";

			// vehicle_average
			$this->vehicle_average->LinkCustomAttributes = "";
			$this->vehicle_average->HrefValue = "";
			$this->vehicle_average->TooltipValue = "";

			// cash_required
			$this->cash_required->LinkCustomAttributes = "";
			$this->cash_required->HrefValue = "";
			$this->cash_required->TooltipValue = "";

			// cash_op_b
			$this->cash_op_b->LinkCustomAttributes = "";
			$this->cash_op_b->HrefValue = "";
			$this->cash_op_b->TooltipValue = "";

			// cash_paid
			$this->cash_paid->LinkCustomAttributes = "";
			$this->cash_paid->HrefValue = "";
			$this->cash_paid->TooltipValue = "";

			// cash_expenses
			$this->cash_expenses->LinkCustomAttributes = "";
			$this->cash_expenses->HrefValue = "";
			$this->cash_expenses->TooltipValue = "";

			// cash_cl_balance
			$this->cash_cl_balance->LinkCustomAttributes = "";
			$this->cash_cl_balance->HrefValue = "";
			$this->cash_cl_balance->TooltipValue = "";

			// fasttag_op_b
			$this->fasttag_op_b->LinkCustomAttributes = "";
			$this->fasttag_op_b->HrefValue = "";
			$this->fasttag_op_b->TooltipValue = "";

			// fasttag_recharge
			$this->fasttag_recharge->LinkCustomAttributes = "";
			$this->fasttag_recharge->HrefValue = "";
			$this->fasttag_recharge->TooltipValue = "";

			// fasttag_expenses
			$this->fasttag_expenses->LinkCustomAttributes = "";
			$this->fasttag_expenses->HrefValue = "";
			$this->fasttag_expenses->TooltipValue = "";

			// toll_expenses_cash
			$this->toll_expenses_cash->LinkCustomAttributes = "";
			$this->toll_expenses_cash->HrefValue = "";
			$this->toll_expenses_cash->TooltipValue = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->LinkCustomAttributes = "";
			$this->fasttag_cl_balance->HrefValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = GetFileUploadUrl($this->uploads, $this->uploads->Upload->DbValue); // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;

			// consignor
			$this->consignor->LinkCustomAttributes = "";
			$this->consignor->HrefValue = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->LinkCustomAttributes = "";
			$this->vehicle_freight_comm->HrefValue = "";

			// vehicle_freight_type
			$this->vehicle_freight_type->LinkCustomAttributes = "";
			$this->vehicle_freight_type->HrefValue = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->LinkCustomAttributes = "";
			$this->vehicle_freight_amount->HrefValue = "";

			// vehicle_freight_final
			$this->vehicle_freight_final->LinkCustomAttributes = "";
			$this->vehicle_freight_final->HrefValue = "";
			$this->vehicle_freight_final->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate form
	protected function validateForm()
	{
		global $Language, $FormError;

		// Initialize form error message
		$FormError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return ($FormError == "");
		if ($this->id->Required) {
			if (!$this->id->IsDetailKey && $this->id->FormValue != NULL && $this->id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->id->caption(), $this->id->RequiredErrorMessage));
			}
		}
		if ($this->vehicle_type->Required) {
			if (!$this->vehicle_type->IsDetailKey && $this->vehicle_type->FormValue != NULL && $this->vehicle_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_type->caption(), $this->vehicle_type->RequiredErrorMessage));
			}
		}
		if ($this->vehicle->Required) {
			if (!$this->vehicle->IsDetailKey && $this->vehicle->FormValue != NULL && $this->vehicle->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle->caption(), $this->vehicle->RequiredErrorMessage));
			}
		}
		if ($this->_route->Required) {
			if (!$this->_route->IsDetailKey && $this->_route->FormValue != NULL && $this->_route->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_route->caption(), $this->_route->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->_route->FormValue)) {
			AddMessage($FormError, $this->_route->errorMessage());
		}
		if ($this->route_name->Required) {
			if (!$this->route_name->IsDetailKey && $this->route_name->FormValue != NULL && $this->route_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->route_name->caption(), $this->route_name->RequiredErrorMessage));
			}
		}
		if ($this->reports_to->Required) {
			if (!$this->reports_to->IsDetailKey && $this->reports_to->FormValue != NULL && $this->reports_to->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->reports_to->caption(), $this->reports_to->RequiredErrorMessage));
			}
		}
		if ($this->buyer->Required) {
			if (!$this->buyer->IsDetailKey && $this->buyer->FormValue != NULL && $this->buyer->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->buyer->caption(), $this->buyer->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->buyer->FormValue)) {
			AddMessage($FormError, $this->buyer->errorMessage());
		}
		if ($this->b_consignor->Required) {
			if (!$this->b_consignor->IsDetailKey && $this->b_consignor->FormValue != NULL && $this->b_consignor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_consignor->caption(), $this->b_consignor->RequiredErrorMessage));
			}
		}
		if ($this->b_consignee->Required) {
			if (!$this->b_consignee->IsDetailKey && $this->b_consignee->FormValue != NULL && $this->b_consignee->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->b_consignee->caption(), $this->b_consignee->RequiredErrorMessage));
			}
		}
		if ($this->load_date->Required) {
			if (!$this->load_date->IsDetailKey && $this->load_date->FormValue != NULL && $this->load_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_date->caption(), $this->load_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->load_date->FormValue)) {
			AddMessage($FormError, $this->load_date->errorMessage());
		}
		if ($this->load_weight->Required) {
			if (!$this->load_weight->IsDetailKey && $this->load_weight->FormValue != NULL && $this->load_weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_weight->caption(), $this->load_weight->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->load_weight->FormValue)) {
			AddMessage($FormError, $this->load_weight->errorMessage());
		}
		if ($this->unload_date->Required) {
			if (!$this->unload_date->IsDetailKey && $this->unload_date->FormValue != NULL && $this->unload_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_date->caption(), $this->unload_date->RequiredErrorMessage));
			}
		}
		if (!CheckDate($this->unload_date->FormValue)) {
			AddMessage($FormError, $this->unload_date->errorMessage());
		}
		if ($this->unload_weight->Required) {
			if (!$this->unload_weight->IsDetailKey && $this->unload_weight->FormValue != NULL && $this->unload_weight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_weight->caption(), $this->unload_weight->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->unload_weight->FormValue)) {
			AddMessage($FormError, $this->unload_weight->errorMessage());
		}
		if ($this->invoice_no->Required) {
			if (!$this->invoice_no->IsDetailKey && $this->invoice_no->FormValue != NULL && $this->invoice_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_no->caption(), $this->invoice_no->RequiredErrorMessage));
			}
		}
		if ($this->invoice_date->Required) {
			if (!$this->invoice_date->IsDetailKey && $this->invoice_date->FormValue != NULL && $this->invoice_date->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->invoice_date->caption(), $this->invoice_date->RequiredErrorMessage));
			}
		}
		if ($this->amount->Required) {
			if (!$this->amount->IsDetailKey && $this->amount->FormValue != NULL && $this->amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->amount->caption(), $this->amount->RequiredErrorMessage));
			}
		}
		if ($this->delivery_pod->Required) {
			if ($this->delivery_pod->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_pod->caption(), $this->delivery_pod->RequiredErrorMessage));
			}
		}
		if ($this->status->Required) {
			if (!$this->status->IsDetailKey && $this->status->FormValue != NULL && $this->status->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->status->caption(), $this->status->RequiredErrorMessage));
			}
		}
		if ($this->days->Required) {
			if (!$this->days->IsDetailKey && $this->days->FormValue != NULL && $this->days->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->days->caption(), $this->days->RequiredErrorMessage));
			}
		}
		if ($this->driver->Required) {
			if (!$this->driver->IsDetailKey && $this->driver->FormValue != NULL && $this->driver->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver->caption(), $this->driver->RequiredErrorMessage));
			}
		}
		if ($this->driver_name->Required) {
			if (!$this->driver_name->IsDetailKey && $this->driver_name->FormValue != NULL && $this->driver_name->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->driver_name->caption(), $this->driver_name->RequiredErrorMessage));
			}
		}
		if ($this->agent->Required) {
			if (!$this->agent->IsDetailKey && $this->agent->FormValue != NULL && $this->agent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->agent->caption(), $this->agent->RequiredErrorMessage));
			}
		}
		if ($this->comm->Required) {
			if (!$this->comm->IsDetailKey && $this->comm->FormValue != NULL && $this->comm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->comm->caption(), $this->comm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->comm->FormValue)) {
			AddMessage($FormError, $this->comm->errorMessage());
		}
		if ($this->material->Required) {
			if (!$this->material->IsDetailKey && $this->material->FormValue != NULL && $this->material->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->material->caption(), $this->material->RequiredErrorMessage));
			}
		}
		if ($this->packing_type->Required) {
			if (!$this->packing_type->IsDetailKey && $this->packing_type->FormValue != NULL && $this->packing_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->packing_type->caption(), $this->packing_type->RequiredErrorMessage));
			}
		}
		if ($this->m_hsn->Required) {
			if (!$this->m_hsn->IsDetailKey && $this->m_hsn->FormValue != NULL && $this->m_hsn->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->m_hsn->caption(), $this->m_hsn->RequiredErrorMessage));
			}
		}
		if ($this->_40->Required) {
			if (!$this->_40->IsDetailKey && $this->_40->FormValue != NULL && $this->_40->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->_40->caption(), $this->_40->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->_40->FormValue)) {
			AddMessage($FormError, $this->_40->errorMessage());
		}
		if ($this->lr_no->Required) {
			if (!$this->lr_no->IsDetailKey && $this->lr_no->FormValue != NULL && $this->lr_no->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->lr_no->caption(), $this->lr_no->RequiredErrorMessage));
			}
		}
		if ($this->km->Required) {
			if (!$this->km->IsDetailKey && $this->km->FormValue != NULL && $this->km->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->km->caption(), $this->km->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->km->FormValue)) {
			AddMessage($FormError, $this->km->errorMessage());
		}
		if ($this->freight_type->Required) {
			if (!$this->freight_type->IsDetailKey && $this->freight_type->FormValue != NULL && $this->freight_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->freight_type->caption(), $this->freight_type->RequiredErrorMessage));
			}
		}
		if ($this->freight->Required) {
			if (!$this->freight->IsDetailKey && $this->freight->FormValue != NULL && $this->freight->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->freight->caption(), $this->freight->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->freight->FormValue)) {
			AddMessage($FormError, $this->freight->errorMessage());
		}
		if ($this->ded_det->Required) {
			if (!$this->ded_det->IsDetailKey && $this->ded_det->FormValue != NULL && $this->ded_det->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ded_det->caption(), $this->ded_det->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->ded_det->FormValue)) {
			AddMessage($FormError, $this->ded_det->errorMessage());
		}
		if ($this->ded_det_remarks->Required) {
			if (!$this->ded_det_remarks->IsDetailKey && $this->ded_det_remarks->FormValue != NULL && $this->ded_det_remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->ded_det_remarks->caption(), $this->ded_det_remarks->RequiredErrorMessage));
			}
		}
		if ($this->gst_percent->Required) {
			if (!$this->gst_percent->IsDetailKey && $this->gst_percent->FormValue != NULL && $this->gst_percent->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gst_percent->caption(), $this->gst_percent->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->gst_percent->FormValue)) {
			AddMessage($FormError, $this->gst_percent->errorMessage());
		}
		if ($this->gst_amount->Required) {
			if (!$this->gst_amount->IsDetailKey && $this->gst_amount->FormValue != NULL && $this->gst_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->gst_amount->caption(), $this->gst_amount->RequiredErrorMessage));
			}
		}
		if ($this->final_amount->Required) {
			if (!$this->final_amount->IsDetailKey && $this->final_amount->FormValue != NULL && $this->final_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->final_amount->caption(), $this->final_amount->RequiredErrorMessage));
			}
		}
		if ($this->load_km->Required) {
			if (!$this->load_km->IsDetailKey && $this->load_km->FormValue != NULL && $this->load_km->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->load_km->caption(), $this->load_km->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->load_km->FormValue)) {
			AddMessage($FormError, $this->load_km->errorMessage());
		}
		if ($this->unload_km->Required) {
			if (!$this->unload_km->IsDetailKey && $this->unload_km->FormValue != NULL && $this->unload_km->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->unload_km->caption(), $this->unload_km->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->unload_km->FormValue)) {
			AddMessage($FormError, $this->unload_km->errorMessage());
		}
		if ($this->delivery_receipt->Required) {
			if ($this->delivery_receipt->Upload->FileName == "" && !$this->delivery_receipt->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->delivery_receipt->caption(), $this->delivery_receipt->RequiredErrorMessage));
			}
		}
		if ($this->delivery_docket->Required) {
			if (!$this->delivery_docket->IsDetailKey && $this->delivery_docket->FormValue != NULL && $this->delivery_docket->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->delivery_docket->caption(), $this->delivery_docket->RequiredErrorMessage));
			}
		}
		if ($this->diesal_op_b->Required) {
			if (!$this->diesal_op_b->IsDetailKey && $this->diesal_op_b->FormValue != NULL && $this->diesal_op_b->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal_op_b->caption(), $this->diesal_op_b->RequiredErrorMessage));
			}
		}
		if ($this->diesal_required->Required) {
			if (!$this->diesal_required->IsDetailKey && $this->diesal_required->FormValue != NULL && $this->diesal_required->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal_required->caption(), $this->diesal_required->RequiredErrorMessage));
			}
		}
		if ($this->diesal_fill->Required) {
			if (!$this->diesal_fill->IsDetailKey && $this->diesal_fill->FormValue != NULL && $this->diesal_fill->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal_fill->caption(), $this->diesal_fill->RequiredErrorMessage));
			}
		}
		if ($this->diesal_amount->Required) {
			if (!$this->diesal_amount->IsDetailKey && $this->diesal_amount->FormValue != NULL && $this->diesal_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal_amount->caption(), $this->diesal_amount->RequiredErrorMessage));
			}
		}
		if ($this->diesal_cl_balance->Required) {
			if (!$this->diesal_cl_balance->IsDetailKey && $this->diesal_cl_balance->FormValue != NULL && $this->diesal_cl_balance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->diesal_cl_balance->caption(), $this->diesal_cl_balance->RequiredErrorMessage));
			}
		}
		if ($this->vehicle_average->Required) {
			if (!$this->vehicle_average->IsDetailKey && $this->vehicle_average->FormValue != NULL && $this->vehicle_average->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_average->caption(), $this->vehicle_average->RequiredErrorMessage));
			}
		}
		if ($this->cash_required->Required) {
			if (!$this->cash_required->IsDetailKey && $this->cash_required->FormValue != NULL && $this->cash_required->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cash_required->caption(), $this->cash_required->RequiredErrorMessage));
			}
		}
		if ($this->cash_op_b->Required) {
			if (!$this->cash_op_b->IsDetailKey && $this->cash_op_b->FormValue != NULL && $this->cash_op_b->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cash_op_b->caption(), $this->cash_op_b->RequiredErrorMessage));
			}
		}
		if ($this->cash_paid->Required) {
			if (!$this->cash_paid->IsDetailKey && $this->cash_paid->FormValue != NULL && $this->cash_paid->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cash_paid->caption(), $this->cash_paid->RequiredErrorMessage));
			}
		}
		if ($this->cash_expenses->Required) {
			if (!$this->cash_expenses->IsDetailKey && $this->cash_expenses->FormValue != NULL && $this->cash_expenses->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cash_expenses->caption(), $this->cash_expenses->RequiredErrorMessage));
			}
		}
		if ($this->cash_cl_balance->Required) {
			if (!$this->cash_cl_balance->IsDetailKey && $this->cash_cl_balance->FormValue != NULL && $this->cash_cl_balance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->cash_cl_balance->caption(), $this->cash_cl_balance->RequiredErrorMessage));
			}
		}
		if ($this->fasttag_op_b->Required) {
			if (!$this->fasttag_op_b->IsDetailKey && $this->fasttag_op_b->FormValue != NULL && $this->fasttag_op_b->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fasttag_op_b->caption(), $this->fasttag_op_b->RequiredErrorMessage));
			}
		}
		if ($this->fasttag_recharge->Required) {
			if (!$this->fasttag_recharge->IsDetailKey && $this->fasttag_recharge->FormValue != NULL && $this->fasttag_recharge->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fasttag_recharge->caption(), $this->fasttag_recharge->RequiredErrorMessage));
			}
		}
		if ($this->fasttag_expenses->Required) {
			if (!$this->fasttag_expenses->IsDetailKey && $this->fasttag_expenses->FormValue != NULL && $this->fasttag_expenses->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fasttag_expenses->caption(), $this->fasttag_expenses->RequiredErrorMessage));
			}
		}
		if ($this->toll_expenses_cash->Required) {
			if (!$this->toll_expenses_cash->IsDetailKey && $this->toll_expenses_cash->FormValue != NULL && $this->toll_expenses_cash->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->toll_expenses_cash->caption(), $this->toll_expenses_cash->RequiredErrorMessage));
			}
		}
		if ($this->fasttag_cl_balance->Required) {
			if (!$this->fasttag_cl_balance->IsDetailKey && $this->fasttag_cl_balance->FormValue != NULL && $this->fasttag_cl_balance->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->fasttag_cl_balance->caption(), $this->fasttag_cl_balance->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->fasttag_cl_balance->FormValue)) {
			AddMessage($FormError, $this->fasttag_cl_balance->errorMessage());
		}
		if ($this->remarks->Required) {
			if (!$this->remarks->IsDetailKey && $this->remarks->FormValue != NULL && $this->remarks->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->remarks->caption(), $this->remarks->RequiredErrorMessage));
			}
		}
		if ($this->uploads->Required) {
			if ($this->uploads->Upload->FileName == "" && !$this->uploads->Upload->KeepFile) {
				AddMessage($FormError, str_replace("%s", $this->uploads->caption(), $this->uploads->RequiredErrorMessage));
			}
		}
		if ($this->consignor->Required) {
			if (!$this->consignor->IsDetailKey && $this->consignor->FormValue != NULL && $this->consignor->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->consignor->caption(), $this->consignor->RequiredErrorMessage));
			}
		}
		if (!CheckInteger($this->consignor->FormValue)) {
			AddMessage($FormError, $this->consignor->errorMessage());
		}
		if ($this->vehicle_freight_comm->Required) {
			if (!$this->vehicle_freight_comm->IsDetailKey && $this->vehicle_freight_comm->FormValue != NULL && $this->vehicle_freight_comm->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_freight_comm->caption(), $this->vehicle_freight_comm->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->vehicle_freight_comm->FormValue)) {
			AddMessage($FormError, $this->vehicle_freight_comm->errorMessage());
		}
		if ($this->vehicle_freight_type->Required) {
			if (!$this->vehicle_freight_type->IsDetailKey && $this->vehicle_freight_type->FormValue != NULL && $this->vehicle_freight_type->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_freight_type->caption(), $this->vehicle_freight_type->RequiredErrorMessage));
			}
		}
		if ($this->vehicle_freight_amount->Required) {
			if (!$this->vehicle_freight_amount->IsDetailKey && $this->vehicle_freight_amount->FormValue != NULL && $this->vehicle_freight_amount->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_freight_amount->caption(), $this->vehicle_freight_amount->RequiredErrorMessage));
			}
		}
		if (!CheckNumber($this->vehicle_freight_amount->FormValue)) {
			AddMessage($FormError, $this->vehicle_freight_amount->errorMessage());
		}
		if ($this->vehicle_freight_final->Required) {
			if (!$this->vehicle_freight_final->IsDetailKey && $this->vehicle_freight_final->FormValue != NULL && $this->vehicle_freight_final->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->vehicle_freight_final->caption(), $this->vehicle_freight_final->RequiredErrorMessage));
			}
		}
		if ($this->operator->Required) {
			if (!$this->operator->IsDetailKey && $this->operator->FormValue != NULL && $this->operator->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->operator->caption(), $this->operator->RequiredErrorMessage));
			}
		}
		if ($this->datetime->Required) {
			if (!$this->datetime->IsDetailKey && $this->datetime->FormValue != NULL && $this->datetime->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->datetime->caption(), $this->datetime->RequiredErrorMessage));
			}
		}
		if ($this->expenses_id->Required) {
			if (!$this->expenses_id->IsDetailKey && $this->expenses_id->FormValue != NULL && $this->expenses_id->FormValue == "") {
				AddMessage($FormError, str_replace("%s", $this->expenses_id->caption(), $this->expenses_id->RequiredErrorMessage));
			}
		}

		// Validate detail grid
		$detailTblVar = explode(",", $this->getCurrentDetailTable());
		if (in_array("t_expenses_o", $detailTblVar) && $GLOBALS["t_expenses_o"]->DetailEdit) {
			if (!isset($GLOBALS["t_expenses_o_grid"]))
				$GLOBALS["t_expenses_o_grid"] = new t_expenses_o_grid(); // Get detail page object
			$GLOBALS["t_expenses_o_grid"]->validateGridForm();
		}
		if (in_array("t_receipt_d", $detailTblVar) && $GLOBALS["t_receipt_d"]->DetailEdit) {
			if (!isset($GLOBALS["t_receipt_d_grid"]))
				$GLOBALS["t_receipt_d_grid"] = new t_receipt_d_grid(); // Get detail page object
			$GLOBALS["t_receipt_d_grid"]->validateGridForm();
		}
		if (in_array("t_diesal_expenses", $detailTblVar) && $GLOBALS["t_diesal_expenses"]->DetailEdit) {
			if (!isset($GLOBALS["t_diesal_expenses_grid"]))
				$GLOBALS["t_diesal_expenses_grid"] = new t_diesal_expenses_grid(); // Get detail page object
			$GLOBALS["t_diesal_expenses_grid"]->validateGridForm();
		}
		if (in_array("t_route_info", $detailTblVar) && $GLOBALS["t_route_info"]->DetailEdit) {
			if (!isset($GLOBALS["t_route_info_grid"]))
				$GLOBALS["t_route_info_grid"] = new t_route_info_grid(); // Get detail page object
			$GLOBALS["t_route_info_grid"]->validateGridForm();
		}

		// Return validate result
		$validateForm = ($FormError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateForm = $validateForm && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($FormError, $formCustomError);
		}
		return $validateForm;
	}

	// Update record based on key values
	protected function editRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();
		$filter = $this->applyUserIDFilters($filter);
		$conn = &$this->getConnection();
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
		$rs = $conn->execute($sql);
		$conn->raiseErrorFn = '';
		if ($rs === FALSE)
			return FALSE;
		if ($rs->EOF) {
			$this->setFailureMessage($Language->phrase("NoRecord")); // Set no record message
			$editRow = FALSE; // Update Failed
		} else {

			// Begin transaction
			if ($this->getCurrentDetailTable() <> "")
				$conn->beginTrans();

			// Save old values
			$rsold = &$rs->fields;
			$this->loadDbValues($rsold);
			$this->delivery_receipt->OldUploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			$this->delivery_receipt->UploadPath = $this->delivery_receipt->OldUploadPath;
			$this->uploads->OldUploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			$this->uploads->UploadPath = $this->uploads->OldUploadPath;
			$rsnew = [];

			// vehicle_type
			$this->vehicle_type->setDbValueDef($rsnew, $this->vehicle_type->CurrentValue, 0, $this->vehicle_type->ReadOnly);

			// route
			$this->_route->setDbValueDef($rsnew, $this->_route->CurrentValue, 0, $this->_route->ReadOnly);

			// reports_to
			$this->reports_to->setDbValueDef($rsnew, $this->reports_to->CurrentValue, NULL, $this->reports_to->ReadOnly);

			// buyer
			$this->buyer->setDbValueDef($rsnew, $this->buyer->CurrentValue, 0, $this->buyer->ReadOnly);

			// b_consignor
			$this->b_consignor->setDbValueDef($rsnew, $this->b_consignor->CurrentValue, NULL, $this->b_consignor->ReadOnly);

			// b_consignee
			$this->b_consignee->setDbValueDef($rsnew, $this->b_consignee->CurrentValue, NULL, $this->b_consignee->ReadOnly);

			// load_date
			$this->load_date->setDbValueDef($rsnew, UnFormatDateTime($this->load_date->CurrentValue, 1), CurrentDate(), $this->load_date->ReadOnly);

			// load_weight
			$this->load_weight->setDbValueDef($rsnew, $this->load_weight->CurrentValue, NULL, $this->load_weight->ReadOnly);

			// unload_date
			$this->unload_date->setDbValueDef($rsnew, UnFormatDateTime($this->unload_date->CurrentValue, 0), NULL, $this->unload_date->ReadOnly);

			// unload_weight
			$this->unload_weight->setDbValueDef($rsnew, $this->unload_weight->CurrentValue, NULL, $this->unload_weight->ReadOnly);

			// delivery_pod
			$this->delivery_pod->setDbValueDef($rsnew, $this->delivery_pod->CurrentValue, NULL, $this->delivery_pod->ReadOnly);

			// driver
			$this->driver->setDbValueDef($rsnew, $this->driver->CurrentValue, NULL, $this->driver->ReadOnly);

			// driver_name
			$this->driver_name->setDbValueDef($rsnew, $this->driver_name->CurrentValue, NULL, $this->driver_name->ReadOnly);

			// agent
			$this->agent->setDbValueDef($rsnew, $this->agent->CurrentValue, NULL, $this->agent->ReadOnly);

			// comm
			$this->comm->setDbValueDef($rsnew, $this->comm->CurrentValue, 0, $this->comm->ReadOnly);

			// material
			$this->material->setDbValueDef($rsnew, $this->material->CurrentValue, "", $this->material->ReadOnly);

			// packing_type
			$this->packing_type->setDbValueDef($rsnew, $this->packing_type->CurrentValue, "", $this->packing_type->ReadOnly);

			// m_hsn
			$this->m_hsn->setDbValueDef($rsnew, $this->m_hsn->CurrentValue, NULL, $this->m_hsn->ReadOnly);

			// @
			$this->_40->setDbValueDef($rsnew, $this->_40->CurrentValue, 0, $this->_40->ReadOnly);

			// lr_no
			$this->lr_no->setDbValueDef($rsnew, $this->lr_no->CurrentValue, NULL, $this->lr_no->ReadOnly);

			// km
			$this->km->setDbValueDef($rsnew, $this->km->CurrentValue, NULL, $this->km->ReadOnly);

			// freight_type
			$this->freight_type->setDbValueDef($rsnew, $this->freight_type->CurrentValue, 0, $this->freight_type->ReadOnly);

			// freight
			$this->freight->setDbValueDef($rsnew, $this->freight->CurrentValue, 0, $this->freight->ReadOnly);

			// ded_det
			$this->ded_det->setDbValueDef($rsnew, $this->ded_det->CurrentValue, 0, $this->ded_det->ReadOnly);

			// ded_det_remarks
			$this->ded_det_remarks->setDbValueDef($rsnew, $this->ded_det_remarks->CurrentValue, NULL, $this->ded_det_remarks->ReadOnly);

			// gst_percent
			$this->gst_percent->setDbValueDef($rsnew, $this->gst_percent->CurrentValue, 0, $this->gst_percent->ReadOnly);

			// load_km
			$this->load_km->setDbValueDef($rsnew, $this->load_km->CurrentValue, 0, $this->load_km->ReadOnly);

			// unload_km
			$this->unload_km->setDbValueDef($rsnew, $this->unload_km->CurrentValue, 0, $this->unload_km->ReadOnly);

			// delivery_receipt
			if ($this->delivery_receipt->Visible && !$this->delivery_receipt->ReadOnly && !$this->delivery_receipt->Upload->KeepFile) {
				$this->delivery_receipt->Upload->DbValue = $rsold['delivery_receipt']; // Get original value
				if ($this->delivery_receipt->Upload->FileName == "") {
					$rsnew['delivery_receipt'] = NULL;
				} else {
					$rsnew['delivery_receipt'] = $this->delivery_receipt->Upload->FileName;
				}
				$this->delivery_receipt->ImageWidth = 0; // Resize width
				$this->delivery_receipt->ImageHeight = 640; // Resize height
			}

			// delivery_docket
			$this->delivery_docket->setDbValueDef($rsnew, $this->delivery_docket->CurrentValue, NULL, $this->delivery_docket->ReadOnly);

			// fasttag_cl_balance
			$this->fasttag_cl_balance->setDbValueDef($rsnew, $this->fasttag_cl_balance->CurrentValue, NULL, $this->fasttag_cl_balance->ReadOnly);

			// remarks
			$this->remarks->setDbValueDef($rsnew, $this->remarks->CurrentValue, NULL, $this->remarks->ReadOnly);

			// uploads
			if ($this->uploads->Visible && !$this->uploads->ReadOnly && !$this->uploads->Upload->KeepFile) {
				$this->uploads->Upload->DbValue = $rsold['uploads']; // Get original value
				if ($this->uploads->Upload->FileName == "") {
					$rsnew['uploads'] = NULL;
				} else {
					$rsnew['uploads'] = $this->uploads->Upload->FileName;
				}
				$this->uploads->ImageWidth = 0; // Resize width
				$this->uploads->ImageHeight = 640; // Resize height
			}

			// consignor
			$this->consignor->setDbValueDef($rsnew, $this->consignor->CurrentValue, 0, $this->consignor->ReadOnly);

			// vehicle_freight_comm
			$this->vehicle_freight_comm->setDbValueDef($rsnew, $this->vehicle_freight_comm->CurrentValue, 0, $this->vehicle_freight_comm->ReadOnly);

			// vehicle_freight_type
			$this->vehicle_freight_type->setDbValueDef($rsnew, $this->vehicle_freight_type->CurrentValue, 0, $this->vehicle_freight_type->ReadOnly);

			// vehicle_freight_amount
			$this->vehicle_freight_amount->setDbValueDef($rsnew, $this->vehicle_freight_amount->CurrentValue, 0, $this->vehicle_freight_amount->ReadOnly);

			// operator
			$this->operator->setDbValueDef($rsnew, CurrentUserID(), NULL);
			$rsnew['operator'] = &$this->operator->DbValue;

			// datetime
			$this->datetime->setDbValueDef($rsnew, CurrentDateTime(), CurrentDate());
			$rsnew['datetime'] = &$this->datetime->DbValue;
			if ($this->delivery_receipt->Visible && !$this->delivery_receipt->Upload->KeepFile) {
				$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
				$oldFiles = EmptyValue($this->delivery_receipt->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->delivery_receipt->Upload->DbValue));
				if (!EmptyValue($this->delivery_receipt->Upload->FileName)) {
					$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->delivery_receipt->Upload->FileName));
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->delivery_receipt->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index) . $file1) || file_exists($this->delivery_receipt->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->delivery_receipt->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index) . $file, UploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->delivery_receipt->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->delivery_receipt->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->delivery_receipt->setDbValueDef($rsnew, $this->delivery_receipt->Upload->FileName, NULL, $this->delivery_receipt->ReadOnly);
				}
			}
			if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
				$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
				$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : array($this->uploads->Upload->DbValue);
				if (!EmptyValue($this->uploads->Upload->FileName)) {
					$newFiles = array($this->uploads->Upload->FileName);
					$NewFileCount = count($newFiles);
					for ($i = 0; $i < $NewFileCount; $i++) {
						if ($newFiles[$i] <> "") {
							$file = $newFiles[$i];
							if (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file)) {
								if (DELETE_UPLOADED_FILES) {
									$oldFileFound = FALSE;
									$oldFileCount = count($oldFiles);
									for ($j = 0; $j < $oldFileCount; $j++) {
										$oldFile = $oldFiles[$j];
										if ($oldFile == $file) { // Old file found, no need to delete anymore
											unset($oldFiles[$j]);
											$oldFileFound = TRUE;
											break;
										}
									}
									if ($oldFileFound) // No need to check if file exists further
										continue;
								}
								$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file); // Get new file name
								if ($file1 <> $file) { // Rename temp file
									while (file_exists(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1) || file_exists($this->uploads->physicalUploadPath() . $file1)) // Make sure no file name clash
										$file1 = UniqueFilename($this->uploads->physicalUploadPath(), $file1, TRUE); // Use indexed name
									rename(UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file, UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $file1);
									$newFiles[$i] = $file1;
								}
							}
						}
					}
					$this->uploads->Upload->DbValue = empty($oldFiles) ? "" : implode(MULTIPLE_UPLOAD_SEPARATOR, $oldFiles);
					$this->uploads->Upload->FileName = implode(MULTIPLE_UPLOAD_SEPARATOR, $newFiles);
					$this->uploads->setDbValueDef($rsnew, $this->uploads->Upload->FileName, NULL, $this->uploads->ReadOnly);
				}
			}

			// Call Row Updating event
			$updateRow = $this->Row_Updating($rsold, $rsnew);
			if ($updateRow) {
				$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
				if (count($rsnew) > 0)
					$editRow = $this->update($rsnew, "", $rsold);
				else
					$editRow = TRUE; // No field to update
				$conn->raiseErrorFn = '';
				if ($editRow) {
					if ($this->delivery_receipt->Visible && !$this->delivery_receipt->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->delivery_receipt->Upload->DbValue) ? array() : explode(MULTIPLE_UPLOAD_SEPARATOR, strval($this->delivery_receipt->Upload->DbValue));
						if (!EmptyValue($this->delivery_receipt->Upload->FileName)) {
							$newFiles = explode(MULTIPLE_UPLOAD_SEPARATOR, $this->delivery_receipt->Upload->FileName);
							$newFiles2 = explode(MULTIPLE_UPLOAD_SEPARATOR, $rsnew['delivery_receipt']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->delivery_receipt->Upload->resizeAndSaveToFile($this->delivery_receipt->ImageWidth, $this->delivery_receipt->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->delivery_receipt->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
					if ($this->uploads->Visible && !$this->uploads->Upload->KeepFile) {
						$oldFiles = EmptyValue($this->uploads->Upload->DbValue) ? array() : array($this->uploads->Upload->DbValue);
						if (!EmptyValue($this->uploads->Upload->FileName)) {
							$newFiles = array($this->uploads->Upload->FileName);
							$newFiles2 = array($rsnew['uploads']);
							$newFileCount = count($newFiles);
							for ($i = 0; $i < $newFileCount; $i++) {
								if ($newFiles[$i] <> "") {
									$file = UploadTempPath($this->uploads, $this->uploads->Upload->Index) . $newFiles[$i];
									if (file_exists($file)) {
										if (@$newFiles2[$i] <> "") // Use correct file name
											$newFiles[$i] = $newFiles2[$i];
										if (!$this->uploads->Upload->resizeAndSaveToFile($this->uploads->ImageWidth, $this->uploads->ImageHeight, THUMBNAIL_DEFAULT_QUALITY, $newFiles[$i], TRUE, $i)) {
											$this->setFailureMessage($Language->phrase("UploadErrMsg7"));
											return FALSE;
										}
									}
								}
							}
						} else {
							$newFiles = array();
						}
						if (DELETE_UPLOADED_FILES) {
							foreach ($oldFiles as $oldFile) {
								if ($oldFile <> "" && !in_array($oldFile, $newFiles))
									@unlink($this->uploads->oldPhysicalUploadPath() . $oldFile);
							}
						}
					}
				}

				// Update detail records
				$detailTblVar = explode(",", $this->getCurrentDetailTable());
				if ($editRow) {
					if (in_array("t_expenses_o", $detailTblVar) && $GLOBALS["t_expenses_o"]->DetailEdit) {
						if (!isset($GLOBALS["t_expenses_o_grid"]))
							$GLOBALS["t_expenses_o_grid"] = new t_expenses_o_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "t_expenses_o"); // Load user level of detail table
						$editRow = $GLOBALS["t_expenses_o_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}
				if ($editRow) {
					if (in_array("t_receipt_d", $detailTblVar) && $GLOBALS["t_receipt_d"]->DetailEdit) {
						if (!isset($GLOBALS["t_receipt_d_grid"]))
							$GLOBALS["t_receipt_d_grid"] = new t_receipt_d_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "t_receipt_d"); // Load user level of detail table
						$editRow = $GLOBALS["t_receipt_d_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}
				if ($editRow) {
					if (in_array("t_diesal_expenses", $detailTblVar) && $GLOBALS["t_diesal_expenses"]->DetailEdit) {
						if (!isset($GLOBALS["t_diesal_expenses_grid"]))
							$GLOBALS["t_diesal_expenses_grid"] = new t_diesal_expenses_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "t_diesal_expenses"); // Load user level of detail table
						$editRow = $GLOBALS["t_diesal_expenses_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}
				if ($editRow) {
					if (in_array("t_route_info", $detailTblVar) && $GLOBALS["t_route_info"]->DetailEdit) {
						if (!isset($GLOBALS["t_route_info_grid"]))
							$GLOBALS["t_route_info_grid"] = new t_route_info_grid(); // Get detail page object
						$Security->loadCurrentUserLevel($this->ProjectID . "t_route_info"); // Load user level of detail table
						$editRow = $GLOBALS["t_route_info_grid"]->gridUpdate();
						$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName); // Restore user level of master table
					}
				}

				// Commit/Rollback transaction
				if ($this->getCurrentDetailTable() <> "") {
					if ($editRow) {
						$conn->commitTrans(); // Commit transaction
					} else {
						$conn->rollbackTrans(); // Rollback transaction
					}
				}
			} else {
				if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

					// Use the message, do nothing
				} elseif ($this->CancelMessage <> "") {
					$this->setFailureMessage($this->CancelMessage);
					$this->CancelMessage = "";
				} else {
					$this->setFailureMessage($Language->phrase("UpdateCancelled"));
				}
				$editRow = FALSE;
			}
		}

		// Call Row_Updated event
		if ($editRow)
			$this->Row_Updated($rsold, $rsnew);
		$rs->close();

		// delivery_receipt
		if ($this->delivery_receipt->Upload->FileToken <> "")
			CleanUploadTempPath($this->delivery_receipt->Upload->FileToken, $this->delivery_receipt->Upload->Index);
		else
			CleanUploadTempPath($this->delivery_receipt, $this->delivery_receipt->Upload->Index);

		// uploads
		if ($this->uploads->Upload->FileToken <> "")
			CleanUploadTempPath($this->uploads->Upload->FileToken, $this->uploads->Upload->Index);
		else
			CleanUploadTempPath($this->uploads, $this->uploads->Upload->Index);

		// Write JSON for API request
		if (IsApi() && $editRow) {
			$row = $this->getRecordsFromRecordset([$rsnew], TRUE);
			WriteJson(["success" => TRUE, $this->TableVar => $row]);
		}
		return $editRow;
	}

	// Set up detail parms based on QueryString
	protected function setupDetailParms()
	{

		// Get the keys for master table
		if (Get(TABLE_SHOW_DETAIL) !== NULL) {
			$detailTblVar = Get(TABLE_SHOW_DETAIL);
			$this->setCurrentDetailTable($detailTblVar);
		} else {
			$detailTblVar = $this->getCurrentDetailTable();
		}
		if ($detailTblVar <> "") {
			$detailTblVar = explode(",", $detailTblVar);
			if (in_array("t_expenses_o", $detailTblVar)) {
				if (!isset($GLOBALS["t_expenses_o_grid"]))
					$GLOBALS["t_expenses_o_grid"] = new t_expenses_o_grid();
				if ($GLOBALS["t_expenses_o_grid"]->DetailEdit) {
					$GLOBALS["t_expenses_o_grid"]->CurrentMode = "edit";
					$GLOBALS["t_expenses_o_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["t_expenses_o_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_expenses_o_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_expenses_o_grid"]->trip->IsDetailKey = TRUE;
					$GLOBALS["t_expenses_o_grid"]->trip->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["t_expenses_o_grid"]->trip->setSessionValue($GLOBALS["t_expenses_o_grid"]->trip->CurrentValue);
				}
			}
			if (in_array("t_receipt_d", $detailTblVar)) {
				if (!isset($GLOBALS["t_receipt_d_grid"]))
					$GLOBALS["t_receipt_d_grid"] = new t_receipt_d_grid();
				if ($GLOBALS["t_receipt_d_grid"]->DetailEdit) {
					$GLOBALS["t_receipt_d_grid"]->CurrentMode = "edit";
					$GLOBALS["t_receipt_d_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["t_receipt_d_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_receipt_d_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_receipt_d_grid"]->trip->IsDetailKey = TRUE;
					$GLOBALS["t_receipt_d_grid"]->trip->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["t_receipt_d_grid"]->trip->setSessionValue($GLOBALS["t_receipt_d_grid"]->trip->CurrentValue);
				}
			}
			if (in_array("t_diesal_expenses", $detailTblVar)) {
				if (!isset($GLOBALS["t_diesal_expenses_grid"]))
					$GLOBALS["t_diesal_expenses_grid"] = new t_diesal_expenses_grid();
				if ($GLOBALS["t_diesal_expenses_grid"]->DetailEdit) {
					$GLOBALS["t_diesal_expenses_grid"]->CurrentMode = "edit";
					$GLOBALS["t_diesal_expenses_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["t_diesal_expenses_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_diesal_expenses_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_diesal_expenses_grid"]->trip->IsDetailKey = TRUE;
					$GLOBALS["t_diesal_expenses_grid"]->trip->CurrentValue = $this->id->CurrentValue;
					$GLOBALS["t_diesal_expenses_grid"]->trip->setSessionValue($GLOBALS["t_diesal_expenses_grid"]->trip->CurrentValue);
				}
			}
			if (in_array("t_route_info", $detailTblVar)) {
				if (!isset($GLOBALS["t_route_info_grid"]))
					$GLOBALS["t_route_info_grid"] = new t_route_info_grid();
				if ($GLOBALS["t_route_info_grid"]->DetailEdit) {
					$GLOBALS["t_route_info_grid"]->CurrentMode = "edit";
					$GLOBALS["t_route_info_grid"]->CurrentAction = "gridedit";

					// Save current master table to detail table
					$GLOBALS["t_route_info_grid"]->setCurrentMasterTable($this->TableVar);
					$GLOBALS["t_route_info_grid"]->setStartRecordNumber(1);
					$GLOBALS["t_route_info_grid"]->id->IsDetailKey = TRUE;
					$GLOBALS["t_route_info_grid"]->id->CurrentValue = $this->_route->CurrentValue;
					$GLOBALS["t_route_info_grid"]->id->setSessionValue($GLOBALS["t_route_info_grid"]->id->CurrentValue);
				}
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("t_trip_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = "edit";
		$Breadcrumb->add("edit", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_vehicle":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x__route":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_reports_to":
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyer":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignor":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignee":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_driver":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignor":
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_vehicle":
							break;
						case "x__route":
							break;
						case "x_reports_to":
							break;
						case "x_buyer":
							break;
						case "x_b_consignor":
							break;
						case "x_b_consignee":
							break;
						case "x_driver":
							break;
						case "x_agent":
							break;
						case "x_consignor":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'t_trip_info');
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>