<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class t_trip_info_list extends t_trip_info
{

	// Page ID
	public $PageID = "list";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 't_trip_info';

	// Page object name
	public $PageObjName = "t_trip_info_list";

	// Grid form hidden field names
	public $FormName = "ft_trip_infolist";
	public $FormActionName = "k_action";
	public $FormKeyName = "k_key";
	public $FormOldKeyName = "k_oldkey";
	public $FormBlankRowName = "k_blankrow";
	public $FormKeyCountName = "key_count";

	// Page URLs
	public $AddUrl;
	public $EditUrl;
	public $CopyUrl;
	public $DeleteUrl;
	public $ViewUrl;
	public $ListUrl;
	public $CancelUrl;

	// Export URLs
	public $ExportPrintUrl;
	public $ExportHtmlUrl;
	public $ExportExcelUrl;
	public $ExportWordUrl;
	public $ExportXmlUrl;
	public $ExportCsvUrl;
	public $ExportPdfUrl;

	// Custom export
	public $ExportExcelCustom = FALSE;
	public $ExportWordCustom = FALSE;
	public $ExportPdfCustom = FALSE;
	public $ExportEmailCustom = FALSE;

	// Update URLs
	public $InlineAddUrl;
	public $InlineCopyUrl;
	public $InlineEditUrl;
	public $GridAddUrl;
	public $GridEditUrl;
	public $MultiDeleteUrl;
	public $MultiUpdateUrl;

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (t_trip_info)
		if (!isset($GLOBALS["t_trip_info"]) || get_class($GLOBALS["t_trip_info"]) == PROJECT_NAMESPACE . "t_trip_info") {
			$GLOBALS["t_trip_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["t_trip_info"];
		}

		// Initialize URLs
		$this->ExportPrintUrl = $this->pageUrl() . "export=print";
		$this->ExportExcelUrl = $this->pageUrl() . "export=excel";
		$this->ExportWordUrl = $this->pageUrl() . "export=word";
		$this->ExportHtmlUrl = $this->pageUrl() . "export=html";
		$this->ExportXmlUrl = $this->pageUrl() . "export=xml";
		$this->ExportCsvUrl = $this->pageUrl() . "export=csv";
		$this->ExportPdfUrl = $this->pageUrl() . "export=pdf";
		$this->AddUrl = "t_trip_infoadd.php?" . TABLE_SHOW_DETAIL . "=";
		$this->InlineAddUrl = $this->pageUrl() . "action=add";
		$this->GridAddUrl = $this->pageUrl() . "action=gridadd";
		$this->GridEditUrl = $this->pageUrl() . "action=gridedit";
		$this->MultiDeleteUrl = "t_trip_infodelete.php";
		$this->MultiUpdateUrl = "t_trip_infoupdate.php";
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'list');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}

		// List options
		$this->ListOptions = new ListOptions();
		$this->ListOptions->TableVar = $this->TableVar;

		// Export options
		$this->ExportOptions = new ListOptions();
		$this->ExportOptions->Tag = "div";
		$this->ExportOptions->TagClassName = "ew-export-option";

		// Import options
		$this->ImportOptions = new ListOptions();
		$this->ImportOptions->Tag = "div";
		$this->ImportOptions->TagClassName = "ew-import-option";

		// Other options
		if (!$this->OtherOptions)
			$this->OtherOptions = new ListOptionsArray();
		$this->OtherOptions["addedit"] = new ListOptions();
		$this->OtherOptions["addedit"]->Tag = "div";
		$this->OtherOptions["addedit"]->TagClassName = "ew-add-edit-option";
		$this->OtherOptions["detail"] = new ListOptions();
		$this->OtherOptions["detail"]->Tag = "div";
		$this->OtherOptions["detail"]->TagClassName = "ew-detail-option";
		$this->OtherOptions["action"] = new ListOptions();
		$this->OtherOptions["action"]->Tag = "div";
		$this->OtherOptions["action"]->TagClassName = "ew-action-option";

		// Filter options
		$this->FilterOptions = new ListOptions();
		$this->FilterOptions->Tag = "div";
		$this->FilterOptions->TagClassName = "ew-filter-option ft_trip_infolistsrch";

		// List actions
		$this->ListActions = new ListActions();
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $t_trip_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($t_trip_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();
			SaveDebugMessage();
			AddHeader("Location", $url);
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->operator->Visible = FALSE;
		if ($this->isAddOrEdit())
			$this->datetime->Visible = FALSE;
	}

	// Class variables
	public $ListOptions; // List options
	public $ExportOptions; // Export options
	public $SearchOptions; // Search options
	public $OtherOptions; // Other options
	public $FilterOptions; // Filter options
	public $ImportOptions; // Import options
	public $ListActions; // List actions
	public $SelectedCount = 0;
	public $SelectedIndex = 0;
	public $DisplayRecs = 20;
	public $StartRec;
	public $StopRec;
	public $TotalRecs = 0;
	public $RecRange = 10;
	public $Pager;
	public $AutoHidePager = AUTO_HIDE_PAGER;
	public $AutoHidePageSizeSelector = AUTO_HIDE_PAGE_SIZE_SELECTOR;
	public $DefaultSearchWhere = ""; // Default search WHERE clause
	public $SearchWhere = ""; // Search WHERE clause
	public $RecCnt = 0; // Record count
	public $EditRowCnt;
	public $StartRowCnt = 1;
	public $RowCnt = 0;
	public $Attrs = array(); // Row attributes and cell attributes
	public $RowIndex = 0; // Row index
	public $KeyCount = 0; // Key count
	public $RowAction = ""; // Row action
	public $RowOldKey = ""; // Row old key (for copy)
	public $MultiColumnClass = "col-sm";
	public $MultiColumnEditClass = "w-100";
	public $DbMasterFilter = ""; // Master filter
	public $DbDetailFilter = ""; // Detail filter
	public $MasterRecordExists;
	public $MultiSelectKey;
	public $Command;
	public $RestoreSearch = FALSE;
	public $DetailPages;
	public $OldRecordset;

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$FormError, $SearchError, $EXPORT;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canList()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				$this->terminate(GetUrl("index.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Get export parameters
		$custom = "";
		if (Param("export") !== NULL) {
			$this->Export = Param("export");
			$custom = Param("custom", "");
		} elseif (IsPost()) {
			if (Post("exporttype") !== NULL)
				$this->Export = Post("exporttype");
			$custom = Post("custom", "");
		} elseif (Get("cmd") == "json") {
			$this->Export = Get("cmd");
		} else {
			$this->setExportReturnUrl(CurrentUrl());
		}
		$ExportFileName = $this->TableVar; // Get export file, used in header

		// Get custom export parameters
		if ($this->isExport() && $custom <> "") {
			$this->CustomExport = $this->Export;
			$this->Export = "print";
		}
		$CustomExportType = $this->CustomExport;
		$ExportType = $this->Export; // Get export parameter, used in header

		// Update Export URLs
		if (defined(PROJECT_NAMESPACE . "USE_PHPEXCEL"))
			$this->ExportExcelCustom = FALSE;
		if ($this->ExportExcelCustom)
			$this->ExportExcelUrl .= "&amp;custom=1";
		if (defined(PROJECT_NAMESPACE . "USE_PHPWORD"))
			$this->ExportWordCustom = FALSE;
		if ($this->ExportWordCustom)
			$this->ExportWordUrl .= "&amp;custom=1";
		if ($this->ExportPdfCustom)
			$this->ExportPdfUrl .= "&amp;custom=1";
		$this->CurrentAction = Param("action"); // Set up current action

		// Get grid add count
		$gridaddcnt = Get(TABLE_GRID_ADD_ROW_COUNT, "");
		if (is_numeric($gridaddcnt) && $gridaddcnt > 0)
			$this->GridAddRowCount = $gridaddcnt;

		// Set up list options
		$this->setupListOptions();

		// Setup export options
		$this->setupExportOptions();
		$this->id->setVisibility();
		$this->vehicle_type->setVisibility();
		$this->vehicle->setVisibility();
		$this->_route->Visible = FALSE;
		$this->route_name->setVisibility();
		$this->reports_to->setVisibility();
		$this->buyer->setVisibility();
		$this->b_consignor->setVisibility();
		$this->b_consignee->setVisibility();
		$this->load_date->setVisibility();
		$this->load_weight->setVisibility();
		$this->unload_date->setVisibility();
		$this->unload_weight->setVisibility();
		$this->invoice_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->amount->setVisibility();
		$this->delivery_pod->setVisibility();
		$this->status->setVisibility();
		$this->days->setVisibility();
		$this->driver->setVisibility();
		$this->driver_name->setVisibility();
		$this->agent->setVisibility();
		$this->comm->setVisibility();
		$this->material->setVisibility();
		$this->packing_type->setVisibility();
		$this->m_hsn->setVisibility();
		$this->_40->setVisibility();
		$this->lr_no->setVisibility();
		$this->km->setVisibility();
		$this->freight_type->setVisibility();
		$this->freight->setVisibility();
		$this->ded_det->setVisibility();
		$this->ded_det_remarks->setVisibility();
		$this->gst_percent->setVisibility();
		$this->gst_amount->setVisibility();
		$this->final_amount->setVisibility();
		$this->load_km->setVisibility();
		$this->unload_km->setVisibility();
		$this->delivery_receipt->setVisibility();
		$this->delivery_docket->setVisibility();
		$this->diesal_op_b->setVisibility();
		$this->diesal_required->setVisibility();
		$this->diesal_fill->setVisibility();
		$this->diesal_amount->setVisibility();
		$this->diesal_cl_balance->setVisibility();
		$this->vehicle_average->setVisibility();
		$this->cash_required->setVisibility();
		$this->cash_op_b->setVisibility();
		$this->cash_paid->setVisibility();
		$this->cash_expenses->setVisibility();
		$this->cash_cl_balance->setVisibility();
		$this->fasttag_op_b->setVisibility();
		$this->fasttag_recharge->setVisibility();
		$this->fasttag_expenses->setVisibility();
		$this->toll_expenses_cash->setVisibility();
		$this->fasttag_cl_balance->setVisibility();
		$this->remarks->Visible = FALSE;
		$this->uploads->Visible = FALSE;
		$this->consignor->setVisibility();
		$this->vehicle_freight_comm->setVisibility();
		$this->vehicle_freight_type->setVisibility();
		$this->vehicle_freight_amount->setVisibility();
		$this->vehicle_freight_final->setVisibility();
		$this->operator->Visible = FALSE;
		$this->datetime->setVisibility();
		$this->expenses_id->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Setup other options
		$this->setupOtherOptions();

		// Set up custom action (compatible with old version)
		foreach ($this->CustomActions as $name => $action)
			$this->ListActions->add($name, $action);

		// Show checkbox column if multiple action
		foreach ($this->ListActions->Items as $listaction) {
			if ($listaction->Select == ACTION_MULTIPLE && $listaction->Allow) {
				$this->ListOptions->Items["checkbox"]->Visible = TRUE;
				break;
			}
		}

		// Set up lookup cache
		$this->setupLookupOptions($this->vehicle);
		$this->setupLookupOptions($this->_route);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->buyer);
		$this->setupLookupOptions($this->b_consignor);
		$this->setupLookupOptions($this->b_consignee);
		$this->setupLookupOptions($this->driver);
		$this->setupLookupOptions($this->agent);
		$this->setupLookupOptions($this->consignor);
		$this->setupLookupOptions($this->operator);

		// Search filters
		$srchAdvanced = ""; // Advanced search filter
		$srchBasic = ""; // Basic search filter
		$filter = "";

		// Get command
		$this->Command = strtolower(Get("cmd"));
		if ($this->isPageRequest()) { // Validate request

			// Process list action first
			if ($this->processListAction()) // Ajax request
				$this->terminate();

			// Set up records per page
			$this->setupDisplayRecs();

			// Handle reset command
			$this->resetCmd();

			// Set up Breadcrumb
			if (!$this->isExport())
				$this->setupBreadcrumb();

			// Hide list options
			if ($this->isExport()) {
				$this->ListOptions->hideAllOptions(array("sequence"));
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			} elseif ($this->isGridAdd() || $this->isGridEdit()) {
				$this->ListOptions->hideAllOptions();
				$this->ListOptions->UseDropDownButton = FALSE; // Disable drop down button
				$this->ListOptions->UseButtonGroup = FALSE; // Disable button group
			}

			// Hide options
			if ($this->isExport() || $this->CurrentAction) {
				$this->ExportOptions->hideAllOptions();
				$this->FilterOptions->hideAllOptions();
				$this->ImportOptions->hideAllOptions();
			}

			// Hide other options
			if ($this->isExport())
				$this->OtherOptions->hideAllOptions();

			// Get default search criteria
			AddFilter($this->DefaultSearchWhere, $this->basicSearchWhere(TRUE));
			AddFilter($this->DefaultSearchWhere, $this->advancedSearchWhere(TRUE));

			// Get basic search values
			$this->loadBasicSearchValues();

			// Get and validate search values for advanced search
			$this->loadSearchValues(); // Get search values

			// Process filter list
			if ($this->processFilterList())
				$this->terminate();
			if (!$this->validateSearch())
				$this->setFailureMessage($SearchError);

			// Restore search parms from Session if not searching / reset / export
			if (($this->isExport() || $this->Command <> "search" && $this->Command <> "reset" && $this->Command <> "resetall") && $this->Command <> "json" && $this->checkSearchParms())
				$this->restoreSearchParms();

			// Call Recordset SearchValidated event
			$this->Recordset_SearchValidated();

			// Set up sorting order
			$this->setupSortOrder();

			// Get basic search criteria
			if ($SearchError == "")
				$srchBasic = $this->basicSearchWhere();

			// Get search criteria for advanced search
			if ($SearchError == "")
				$srchAdvanced = $this->advancedSearchWhere();
		}

		// Restore display records
		if ($this->Command <> "json" && $this->getRecordsPerPage() <> "") {
			$this->DisplayRecs = $this->getRecordsPerPage(); // Restore from Session
		} else {
			$this->DisplayRecs = 20; // Load default
		}

		// Load Sorting Order
		if ($this->Command <> "json")
			$this->loadSortOrder();

		// Load search default if no existing search criteria
		if (!$this->checkSearchParms()) {

			// Load basic search from default
			$this->BasicSearch->loadDefault();
			if ($this->BasicSearch->Keyword != "")
				$srchBasic = $this->basicSearchWhere();

			// Load advanced search from default
			if ($this->loadAdvancedSearchDefault()) {
				$srchAdvanced = $this->advancedSearchWhere();
			}
		}

		// Build search criteria
		AddFilter($this->SearchWhere, $srchAdvanced);
		AddFilter($this->SearchWhere, $srchBasic);

		// Call Recordset_Searching event
		$this->Recordset_Searching($this->SearchWhere);

		// Save search criteria
		if ($this->Command == "search" && !$this->RestoreSearch) {
			$this->setSearchWhere($this->SearchWhere); // Save to Session
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->Command <> "json") {
			$this->SearchWhere = $this->getSearchWhere();
		}

		// Build filter
		$filter = "";
		if (!$Security->canList())
			$filter = "(0=1)"; // Filter all records
		AddFilter($filter, $this->DbDetailFilter);
		AddFilter($filter, $this->SearchWhere);

		// Set up filter
		if ($this->Command == "json") {
			$this->UseSessionForListSql = FALSE; // Do not use session for ListSQL
			$this->CurrentFilter = $filter;
		} else {
			$this->setSessionWhere($filter);
			$this->CurrentFilter = "";
		}

		// Export data only
		if (!$this->CustomExport && in_array($this->Export, array_keys($EXPORT))) {
			$this->exportData();
			$this->terminate();
		}
		if ($this->isGridAdd()) {
			$this->CurrentFilter = "0=1";
			$this->StartRec = 1;
			$this->DisplayRecs = $this->GridAddRowCount;
			$this->TotalRecs = $this->DisplayRecs;
			$this->StopRec = $this->DisplayRecs;
		} else {
			$selectLimit = $this->UseSelectLimit;
			if ($selectLimit) {
				$this->TotalRecs = $this->listRecordCount();
			} else {
				if ($this->Recordset = $this->loadRecordset())
					$this->TotalRecs = $this->Recordset->RecordCount();
			}
			$this->StartRec = 1;
			if ($this->DisplayRecs <= 0 || ($this->isExport() && $this->ExportAll)) // Display all records
				$this->DisplayRecs = $this->TotalRecs;
			if (!($this->isExport() && $this->ExportAll)) // Set up start record position
				$this->setupStartRec();
			if ($selectLimit)
				$this->Recordset = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs);

			// Set no record found message
			if (!$this->CurrentAction && $this->TotalRecs == 0) {
				if (!$Security->canList())
					$this->setWarningMessage(DeniedMessage());
				if ($this->SearchWhere == "0=101")
					$this->setWarningMessage($Language->phrase("EnterSearchCriteria"));
				else
					$this->setWarningMessage($Language->phrase("NoRecord"));
			}
		}

		// Search options
		$this->setupSearchOptions();

		// Normal return
		if (IsApi()) {
			$rows = $this->getRecordsFromRecordset($this->Recordset);
			$this->Recordset->close();
			WriteJson(["success" => TRUE, $this->TableVar => $rows, "totalRecordCount" => $this->TotalRecs]);
			$this->terminate(TRUE);
		}
	}

	// Set up number of records displayed per page
	protected function setupDisplayRecs()
	{
		$wrk = Get(TABLE_REC_PER_PAGE, "");
		if ($wrk <> "") {
			if (is_numeric($wrk)) {
				$this->DisplayRecs = (int)$wrk;
			} else {
				if (SameText($wrk, "all")) { // Display all records
					$this->DisplayRecs = -1;
				} else {
					$this->DisplayRecs = 20; // Non-numeric, load default
				}
			}
			$this->setRecordsPerPage($this->DisplayRecs); // Save to Session

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Build filter for all keys
	protected function buildKeyFilter()
	{
		global $CurrentForm;
		$wrkFilter = "";

		// Update row index and get row key
		$rowindex = 1;
		$CurrentForm->Index = $rowindex;
		$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		while ($thisKey <> "") {
			if ($this->setupKeyValues($thisKey)) {
				$filter = $this->getRecordFilter();
				if ($wrkFilter <> "")
					$wrkFilter .= " OR ";
				$wrkFilter .= $filter;
			} else {
				$wrkFilter = "0=1";
				break;
			}

			// Update row index and get row key
			$rowindex++; // Next row
			$CurrentForm->Index = $rowindex;
			$thisKey = strval($CurrentForm->getValue($this->FormKeyName));
		}
		return $wrkFilter;
	}

	// Set up key values
	protected function setupKeyValues($key)
	{
		$arKeyFlds = explode($GLOBALS["COMPOSITE_KEY_SEPARATOR"], $key);
		if (count($arKeyFlds) >= 1) {
			$this->id->setFormValue($arKeyFlds[0]);
			if (!is_numeric($this->id->FormValue))
				return FALSE;
		}
		return TRUE;
	}

	// Get list of filters
	public function getFilterList()
	{
		global $UserProfile;

		// Initialize
		$filterList = "";
		$savedFilterList = "";

		// Load server side filters
		if (SEARCH_FILTER_OPTION == "Server" && isset($UserProfile))
			$savedFilterList = $UserProfile->getSearchFilters(CurrentUserName(), "ft_trip_infolistsrch");
		$filterList = Concat($filterList, $this->id->AdvancedSearch->toJson(), ","); // Field id
		$filterList = Concat($filterList, $this->vehicle_type->AdvancedSearch->toJson(), ","); // Field vehicle_type
		$filterList = Concat($filterList, $this->vehicle->AdvancedSearch->toJson(), ","); // Field vehicle
		$filterList = Concat($filterList, $this->_route->AdvancedSearch->toJson(), ","); // Field route
		$filterList = Concat($filterList, $this->route_name->AdvancedSearch->toJson(), ","); // Field route_name
		$filterList = Concat($filterList, $this->reports_to->AdvancedSearch->toJson(), ","); // Field reports_to
		$filterList = Concat($filterList, $this->buyer->AdvancedSearch->toJson(), ","); // Field buyer
		$filterList = Concat($filterList, $this->b_consignor->AdvancedSearch->toJson(), ","); // Field b_consignor
		$filterList = Concat($filterList, $this->b_consignee->AdvancedSearch->toJson(), ","); // Field b_consignee
		$filterList = Concat($filterList, $this->load_date->AdvancedSearch->toJson(), ","); // Field load_date
		$filterList = Concat($filterList, $this->load_weight->AdvancedSearch->toJson(), ","); // Field load_weight
		$filterList = Concat($filterList, $this->unload_date->AdvancedSearch->toJson(), ","); // Field unload_date
		$filterList = Concat($filterList, $this->unload_weight->AdvancedSearch->toJson(), ","); // Field unload_weight
		$filterList = Concat($filterList, $this->invoice_no->AdvancedSearch->toJson(), ","); // Field invoice_no
		$filterList = Concat($filterList, $this->invoice_date->AdvancedSearch->toJson(), ","); // Field invoice_date
		$filterList = Concat($filterList, $this->amount->AdvancedSearch->toJson(), ","); // Field amount
		$filterList = Concat($filterList, $this->delivery_pod->AdvancedSearch->toJson(), ","); // Field delivery_pod
		$filterList = Concat($filterList, $this->status->AdvancedSearch->toJson(), ","); // Field status
		$filterList = Concat($filterList, $this->days->AdvancedSearch->toJson(), ","); // Field days
		$filterList = Concat($filterList, $this->driver->AdvancedSearch->toJson(), ","); // Field driver
		$filterList = Concat($filterList, $this->driver_name->AdvancedSearch->toJson(), ","); // Field driver_name
		$filterList = Concat($filterList, $this->agent->AdvancedSearch->toJson(), ","); // Field agent
		$filterList = Concat($filterList, $this->comm->AdvancedSearch->toJson(), ","); // Field comm
		$filterList = Concat($filterList, $this->material->AdvancedSearch->toJson(), ","); // Field material
		$filterList = Concat($filterList, $this->packing_type->AdvancedSearch->toJson(), ","); // Field packing_type
		$filterList = Concat($filterList, $this->m_hsn->AdvancedSearch->toJson(), ","); // Field m_hsn
		$filterList = Concat($filterList, $this->_40->AdvancedSearch->toJson(), ","); // Field @
		$filterList = Concat($filterList, $this->lr_no->AdvancedSearch->toJson(), ","); // Field lr_no
		$filterList = Concat($filterList, $this->km->AdvancedSearch->toJson(), ","); // Field km
		$filterList = Concat($filterList, $this->freight_type->AdvancedSearch->toJson(), ","); // Field freight_type
		$filterList = Concat($filterList, $this->freight->AdvancedSearch->toJson(), ","); // Field freight
		$filterList = Concat($filterList, $this->ded_det->AdvancedSearch->toJson(), ","); // Field ded_det
		$filterList = Concat($filterList, $this->ded_det_remarks->AdvancedSearch->toJson(), ","); // Field ded_det_remarks
		$filterList = Concat($filterList, $this->gst_percent->AdvancedSearch->toJson(), ","); // Field gst_percent
		$filterList = Concat($filterList, $this->gst_amount->AdvancedSearch->toJson(), ","); // Field gst_amount
		$filterList = Concat($filterList, $this->final_amount->AdvancedSearch->toJson(), ","); // Field final_amount
		$filterList = Concat($filterList, $this->load_km->AdvancedSearch->toJson(), ","); // Field load_km
		$filterList = Concat($filterList, $this->unload_km->AdvancedSearch->toJson(), ","); // Field unload_km
		$filterList = Concat($filterList, $this->delivery_receipt->AdvancedSearch->toJson(), ","); // Field delivery_receipt
		$filterList = Concat($filterList, $this->delivery_docket->AdvancedSearch->toJson(), ","); // Field delivery_docket
		$filterList = Concat($filterList, $this->diesal_op_b->AdvancedSearch->toJson(), ","); // Field diesal_op_b
		$filterList = Concat($filterList, $this->diesal_required->AdvancedSearch->toJson(), ","); // Field diesal_required
		$filterList = Concat($filterList, $this->diesal_fill->AdvancedSearch->toJson(), ","); // Field diesal_fill
		$filterList = Concat($filterList, $this->diesal_amount->AdvancedSearch->toJson(), ","); // Field diesal_amount
		$filterList = Concat($filterList, $this->diesal_cl_balance->AdvancedSearch->toJson(), ","); // Field diesal_cl_balance
		$filterList = Concat($filterList, $this->vehicle_average->AdvancedSearch->toJson(), ","); // Field vehicle_average
		$filterList = Concat($filterList, $this->cash_required->AdvancedSearch->toJson(), ","); // Field cash_required
		$filterList = Concat($filterList, $this->cash_op_b->AdvancedSearch->toJson(), ","); // Field cash_op_b
		$filterList = Concat($filterList, $this->cash_paid->AdvancedSearch->toJson(), ","); // Field cash_paid
		$filterList = Concat($filterList, $this->cash_expenses->AdvancedSearch->toJson(), ","); // Field cash_expenses
		$filterList = Concat($filterList, $this->cash_cl_balance->AdvancedSearch->toJson(), ","); // Field cash_cl_balance
		$filterList = Concat($filterList, $this->fasttag_op_b->AdvancedSearch->toJson(), ","); // Field fasttag_op_b
		$filterList = Concat($filterList, $this->fasttag_recharge->AdvancedSearch->toJson(), ","); // Field fasttag_recharge
		$filterList = Concat($filterList, $this->fasttag_expenses->AdvancedSearch->toJson(), ","); // Field fasttag_expenses
		$filterList = Concat($filterList, $this->toll_expenses_cash->AdvancedSearch->toJson(), ","); // Field toll_expenses_cash
		$filterList = Concat($filterList, $this->fasttag_cl_balance->AdvancedSearch->toJson(), ","); // Field fasttag_cl_balance
		$filterList = Concat($filterList, $this->remarks->AdvancedSearch->toJson(), ","); // Field remarks
		$filterList = Concat($filterList, $this->uploads->AdvancedSearch->toJson(), ","); // Field uploads
		$filterList = Concat($filterList, $this->consignor->AdvancedSearch->toJson(), ","); // Field consignor
		$filterList = Concat($filterList, $this->vehicle_freight_comm->AdvancedSearch->toJson(), ","); // Field vehicle_freight_comm
		$filterList = Concat($filterList, $this->vehicle_freight_type->AdvancedSearch->toJson(), ","); // Field vehicle_freight_type
		$filterList = Concat($filterList, $this->vehicle_freight_amount->AdvancedSearch->toJson(), ","); // Field vehicle_freight_amount
		$filterList = Concat($filterList, $this->vehicle_freight_final->AdvancedSearch->toJson(), ","); // Field vehicle_freight_final
		$filterList = Concat($filterList, $this->operator->AdvancedSearch->toJson(), ","); // Field operator
		$filterList = Concat($filterList, $this->datetime->AdvancedSearch->toJson(), ","); // Field datetime
		if ($this->BasicSearch->Keyword <> "") {
			$wrk = "\"" . TABLE_BASIC_SEARCH . "\":\"" . JsEncode($this->BasicSearch->Keyword) . "\",\"" . TABLE_BASIC_SEARCH_TYPE . "\":\"" . JsEncode($this->BasicSearch->Type) . "\"";
			$filterList = Concat($filterList, $wrk, ",");
		}

		// Return filter list in JSON
		if ($filterList <> "")
			$filterList = "\"data\":{" . $filterList . "}";
		if ($savedFilterList <> "")
			$filterList = Concat($filterList, "\"filters\":" . $savedFilterList, ",");
		return ($filterList <> "") ? "{" . $filterList . "}" : "null";
	}

	// Process filter list
	protected function processFilterList()
	{
		global $UserProfile;
		if (Post("ajax") == "savefilters") { // Save filter request (Ajax)
			$filters = Post("filters");
			$UserProfile->setSearchFilters(CurrentUserName(), "ft_trip_infolistsrch", $filters);
			WriteJson([["success" => TRUE]]); // Success
			return TRUE;
		} elseif (Post("cmd") == "resetfilter") {
			$this->restoreFilterList();
		}
		return FALSE;
	}

	// Restore list of filters
	protected function restoreFilterList()
	{

		// Return if not reset filter
		if (Post("cmd") !== "resetfilter")
			return FALSE;
		$filter = json_decode(Post("filter"), TRUE);
		$this->Command = "search";

		// Field id
		$this->id->AdvancedSearch->SearchValue = @$filter["x_id"];
		$this->id->AdvancedSearch->SearchOperator = @$filter["z_id"];
		$this->id->AdvancedSearch->SearchCondition = @$filter["v_id"];
		$this->id->AdvancedSearch->SearchValue2 = @$filter["y_id"];
		$this->id->AdvancedSearch->SearchOperator2 = @$filter["w_id"];
		$this->id->AdvancedSearch->save();

		// Field vehicle_type
		$this->vehicle_type->AdvancedSearch->SearchValue = @$filter["x_vehicle_type"];
		$this->vehicle_type->AdvancedSearch->SearchOperator = @$filter["z_vehicle_type"];
		$this->vehicle_type->AdvancedSearch->SearchCondition = @$filter["v_vehicle_type"];
		$this->vehicle_type->AdvancedSearch->SearchValue2 = @$filter["y_vehicle_type"];
		$this->vehicle_type->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle_type"];
		$this->vehicle_type->AdvancedSearch->save();

		// Field vehicle
		$this->vehicle->AdvancedSearch->SearchValue = @$filter["x_vehicle"];
		$this->vehicle->AdvancedSearch->SearchOperator = @$filter["z_vehicle"];
		$this->vehicle->AdvancedSearch->SearchCondition = @$filter["v_vehicle"];
		$this->vehicle->AdvancedSearch->SearchValue2 = @$filter["y_vehicle"];
		$this->vehicle->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle"];
		$this->vehicle->AdvancedSearch->save();

		// Field route
		$this->_route->AdvancedSearch->SearchValue = @$filter["x__route"];
		$this->_route->AdvancedSearch->SearchOperator = @$filter["z__route"];
		$this->_route->AdvancedSearch->SearchCondition = @$filter["v__route"];
		$this->_route->AdvancedSearch->SearchValue2 = @$filter["y__route"];
		$this->_route->AdvancedSearch->SearchOperator2 = @$filter["w__route"];
		$this->_route->AdvancedSearch->save();

		// Field route_name
		$this->route_name->AdvancedSearch->SearchValue = @$filter["x_route_name"];
		$this->route_name->AdvancedSearch->SearchOperator = @$filter["z_route_name"];
		$this->route_name->AdvancedSearch->SearchCondition = @$filter["v_route_name"];
		$this->route_name->AdvancedSearch->SearchValue2 = @$filter["y_route_name"];
		$this->route_name->AdvancedSearch->SearchOperator2 = @$filter["w_route_name"];
		$this->route_name->AdvancedSearch->save();

		// Field reports_to
		$this->reports_to->AdvancedSearch->SearchValue = @$filter["x_reports_to"];
		$this->reports_to->AdvancedSearch->SearchOperator = @$filter["z_reports_to"];
		$this->reports_to->AdvancedSearch->SearchCondition = @$filter["v_reports_to"];
		$this->reports_to->AdvancedSearch->SearchValue2 = @$filter["y_reports_to"];
		$this->reports_to->AdvancedSearch->SearchOperator2 = @$filter["w_reports_to"];
		$this->reports_to->AdvancedSearch->save();

		// Field buyer
		$this->buyer->AdvancedSearch->SearchValue = @$filter["x_buyer"];
		$this->buyer->AdvancedSearch->SearchOperator = @$filter["z_buyer"];
		$this->buyer->AdvancedSearch->SearchCondition = @$filter["v_buyer"];
		$this->buyer->AdvancedSearch->SearchValue2 = @$filter["y_buyer"];
		$this->buyer->AdvancedSearch->SearchOperator2 = @$filter["w_buyer"];
		$this->buyer->AdvancedSearch->save();

		// Field b_consignor
		$this->b_consignor->AdvancedSearch->SearchValue = @$filter["x_b_consignor"];
		$this->b_consignor->AdvancedSearch->SearchOperator = @$filter["z_b_consignor"];
		$this->b_consignor->AdvancedSearch->SearchCondition = @$filter["v_b_consignor"];
		$this->b_consignor->AdvancedSearch->SearchValue2 = @$filter["y_b_consignor"];
		$this->b_consignor->AdvancedSearch->SearchOperator2 = @$filter["w_b_consignor"];
		$this->b_consignor->AdvancedSearch->save();

		// Field b_consignee
		$this->b_consignee->AdvancedSearch->SearchValue = @$filter["x_b_consignee"];
		$this->b_consignee->AdvancedSearch->SearchOperator = @$filter["z_b_consignee"];
		$this->b_consignee->AdvancedSearch->SearchCondition = @$filter["v_b_consignee"];
		$this->b_consignee->AdvancedSearch->SearchValue2 = @$filter["y_b_consignee"];
		$this->b_consignee->AdvancedSearch->SearchOperator2 = @$filter["w_b_consignee"];
		$this->b_consignee->AdvancedSearch->save();

		// Field load_date
		$this->load_date->AdvancedSearch->SearchValue = @$filter["x_load_date"];
		$this->load_date->AdvancedSearch->SearchOperator = @$filter["z_load_date"];
		$this->load_date->AdvancedSearch->SearchCondition = @$filter["v_load_date"];
		$this->load_date->AdvancedSearch->SearchValue2 = @$filter["y_load_date"];
		$this->load_date->AdvancedSearch->SearchOperator2 = @$filter["w_load_date"];
		$this->load_date->AdvancedSearch->save();

		// Field load_weight
		$this->load_weight->AdvancedSearch->SearchValue = @$filter["x_load_weight"];
		$this->load_weight->AdvancedSearch->SearchOperator = @$filter["z_load_weight"];
		$this->load_weight->AdvancedSearch->SearchCondition = @$filter["v_load_weight"];
		$this->load_weight->AdvancedSearch->SearchValue2 = @$filter["y_load_weight"];
		$this->load_weight->AdvancedSearch->SearchOperator2 = @$filter["w_load_weight"];
		$this->load_weight->AdvancedSearch->save();

		// Field unload_date
		$this->unload_date->AdvancedSearch->SearchValue = @$filter["x_unload_date"];
		$this->unload_date->AdvancedSearch->SearchOperator = @$filter["z_unload_date"];
		$this->unload_date->AdvancedSearch->SearchCondition = @$filter["v_unload_date"];
		$this->unload_date->AdvancedSearch->SearchValue2 = @$filter["y_unload_date"];
		$this->unload_date->AdvancedSearch->SearchOperator2 = @$filter["w_unload_date"];
		$this->unload_date->AdvancedSearch->save();

		// Field unload_weight
		$this->unload_weight->AdvancedSearch->SearchValue = @$filter["x_unload_weight"];
		$this->unload_weight->AdvancedSearch->SearchOperator = @$filter["z_unload_weight"];
		$this->unload_weight->AdvancedSearch->SearchCondition = @$filter["v_unload_weight"];
		$this->unload_weight->AdvancedSearch->SearchValue2 = @$filter["y_unload_weight"];
		$this->unload_weight->AdvancedSearch->SearchOperator2 = @$filter["w_unload_weight"];
		$this->unload_weight->AdvancedSearch->save();

		// Field invoice_no
		$this->invoice_no->AdvancedSearch->SearchValue = @$filter["x_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchOperator = @$filter["z_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchCondition = @$filter["v_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchValue2 = @$filter["y_invoice_no"];
		$this->invoice_no->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_no"];
		$this->invoice_no->AdvancedSearch->save();

		// Field invoice_date
		$this->invoice_date->AdvancedSearch->SearchValue = @$filter["x_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchOperator = @$filter["z_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchCondition = @$filter["v_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchValue2 = @$filter["y_invoice_date"];
		$this->invoice_date->AdvancedSearch->SearchOperator2 = @$filter["w_invoice_date"];
		$this->invoice_date->AdvancedSearch->save();

		// Field amount
		$this->amount->AdvancedSearch->SearchValue = @$filter["x_amount"];
		$this->amount->AdvancedSearch->SearchOperator = @$filter["z_amount"];
		$this->amount->AdvancedSearch->SearchCondition = @$filter["v_amount"];
		$this->amount->AdvancedSearch->SearchValue2 = @$filter["y_amount"];
		$this->amount->AdvancedSearch->SearchOperator2 = @$filter["w_amount"];
		$this->amount->AdvancedSearch->save();

		// Field delivery_pod
		$this->delivery_pod->AdvancedSearch->SearchValue = @$filter["x_delivery_pod"];
		$this->delivery_pod->AdvancedSearch->SearchOperator = @$filter["z_delivery_pod"];
		$this->delivery_pod->AdvancedSearch->SearchCondition = @$filter["v_delivery_pod"];
		$this->delivery_pod->AdvancedSearch->SearchValue2 = @$filter["y_delivery_pod"];
		$this->delivery_pod->AdvancedSearch->SearchOperator2 = @$filter["w_delivery_pod"];
		$this->delivery_pod->AdvancedSearch->save();

		// Field status
		$this->status->AdvancedSearch->SearchValue = @$filter["x_status"];
		$this->status->AdvancedSearch->SearchOperator = @$filter["z_status"];
		$this->status->AdvancedSearch->SearchCondition = @$filter["v_status"];
		$this->status->AdvancedSearch->SearchValue2 = @$filter["y_status"];
		$this->status->AdvancedSearch->SearchOperator2 = @$filter["w_status"];
		$this->status->AdvancedSearch->save();

		// Field days
		$this->days->AdvancedSearch->SearchValue = @$filter["x_days"];
		$this->days->AdvancedSearch->SearchOperator = @$filter["z_days"];
		$this->days->AdvancedSearch->SearchCondition = @$filter["v_days"];
		$this->days->AdvancedSearch->SearchValue2 = @$filter["y_days"];
		$this->days->AdvancedSearch->SearchOperator2 = @$filter["w_days"];
		$this->days->AdvancedSearch->save();

		// Field driver
		$this->driver->AdvancedSearch->SearchValue = @$filter["x_driver"];
		$this->driver->AdvancedSearch->SearchOperator = @$filter["z_driver"];
		$this->driver->AdvancedSearch->SearchCondition = @$filter["v_driver"];
		$this->driver->AdvancedSearch->SearchValue2 = @$filter["y_driver"];
		$this->driver->AdvancedSearch->SearchOperator2 = @$filter["w_driver"];
		$this->driver->AdvancedSearch->save();

		// Field driver_name
		$this->driver_name->AdvancedSearch->SearchValue = @$filter["x_driver_name"];
		$this->driver_name->AdvancedSearch->SearchOperator = @$filter["z_driver_name"];
		$this->driver_name->AdvancedSearch->SearchCondition = @$filter["v_driver_name"];
		$this->driver_name->AdvancedSearch->SearchValue2 = @$filter["y_driver_name"];
		$this->driver_name->AdvancedSearch->SearchOperator2 = @$filter["w_driver_name"];
		$this->driver_name->AdvancedSearch->save();

		// Field agent
		$this->agent->AdvancedSearch->SearchValue = @$filter["x_agent"];
		$this->agent->AdvancedSearch->SearchOperator = @$filter["z_agent"];
		$this->agent->AdvancedSearch->SearchCondition = @$filter["v_agent"];
		$this->agent->AdvancedSearch->SearchValue2 = @$filter["y_agent"];
		$this->agent->AdvancedSearch->SearchOperator2 = @$filter["w_agent"];
		$this->agent->AdvancedSearch->save();

		// Field comm
		$this->comm->AdvancedSearch->SearchValue = @$filter["x_comm"];
		$this->comm->AdvancedSearch->SearchOperator = @$filter["z_comm"];
		$this->comm->AdvancedSearch->SearchCondition = @$filter["v_comm"];
		$this->comm->AdvancedSearch->SearchValue2 = @$filter["y_comm"];
		$this->comm->AdvancedSearch->SearchOperator2 = @$filter["w_comm"];
		$this->comm->AdvancedSearch->save();

		// Field material
		$this->material->AdvancedSearch->SearchValue = @$filter["x_material"];
		$this->material->AdvancedSearch->SearchOperator = @$filter["z_material"];
		$this->material->AdvancedSearch->SearchCondition = @$filter["v_material"];
		$this->material->AdvancedSearch->SearchValue2 = @$filter["y_material"];
		$this->material->AdvancedSearch->SearchOperator2 = @$filter["w_material"];
		$this->material->AdvancedSearch->save();

		// Field packing_type
		$this->packing_type->AdvancedSearch->SearchValue = @$filter["x_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator = @$filter["z_packing_type"];
		$this->packing_type->AdvancedSearch->SearchCondition = @$filter["v_packing_type"];
		$this->packing_type->AdvancedSearch->SearchValue2 = @$filter["y_packing_type"];
		$this->packing_type->AdvancedSearch->SearchOperator2 = @$filter["w_packing_type"];
		$this->packing_type->AdvancedSearch->save();

		// Field m_hsn
		$this->m_hsn->AdvancedSearch->SearchValue = @$filter["x_m_hsn"];
		$this->m_hsn->AdvancedSearch->SearchOperator = @$filter["z_m_hsn"];
		$this->m_hsn->AdvancedSearch->SearchCondition = @$filter["v_m_hsn"];
		$this->m_hsn->AdvancedSearch->SearchValue2 = @$filter["y_m_hsn"];
		$this->m_hsn->AdvancedSearch->SearchOperator2 = @$filter["w_m_hsn"];
		$this->m_hsn->AdvancedSearch->save();

		// Field @
		$this->_40->AdvancedSearch->SearchValue = @$filter["x__40"];
		$this->_40->AdvancedSearch->SearchOperator = @$filter["z__40"];
		$this->_40->AdvancedSearch->SearchCondition = @$filter["v__40"];
		$this->_40->AdvancedSearch->SearchValue2 = @$filter["y__40"];
		$this->_40->AdvancedSearch->SearchOperator2 = @$filter["w__40"];
		$this->_40->AdvancedSearch->save();

		// Field lr_no
		$this->lr_no->AdvancedSearch->SearchValue = @$filter["x_lr_no"];
		$this->lr_no->AdvancedSearch->SearchOperator = @$filter["z_lr_no"];
		$this->lr_no->AdvancedSearch->SearchCondition = @$filter["v_lr_no"];
		$this->lr_no->AdvancedSearch->SearchValue2 = @$filter["y_lr_no"];
		$this->lr_no->AdvancedSearch->SearchOperator2 = @$filter["w_lr_no"];
		$this->lr_no->AdvancedSearch->save();

		// Field km
		$this->km->AdvancedSearch->SearchValue = @$filter["x_km"];
		$this->km->AdvancedSearch->SearchOperator = @$filter["z_km"];
		$this->km->AdvancedSearch->SearchCondition = @$filter["v_km"];
		$this->km->AdvancedSearch->SearchValue2 = @$filter["y_km"];
		$this->km->AdvancedSearch->SearchOperator2 = @$filter["w_km"];
		$this->km->AdvancedSearch->save();

		// Field freight_type
		$this->freight_type->AdvancedSearch->SearchValue = @$filter["x_freight_type"];
		$this->freight_type->AdvancedSearch->SearchOperator = @$filter["z_freight_type"];
		$this->freight_type->AdvancedSearch->SearchCondition = @$filter["v_freight_type"];
		$this->freight_type->AdvancedSearch->SearchValue2 = @$filter["y_freight_type"];
		$this->freight_type->AdvancedSearch->SearchOperator2 = @$filter["w_freight_type"];
		$this->freight_type->AdvancedSearch->save();

		// Field freight
		$this->freight->AdvancedSearch->SearchValue = @$filter["x_freight"];
		$this->freight->AdvancedSearch->SearchOperator = @$filter["z_freight"];
		$this->freight->AdvancedSearch->SearchCondition = @$filter["v_freight"];
		$this->freight->AdvancedSearch->SearchValue2 = @$filter["y_freight"];
		$this->freight->AdvancedSearch->SearchOperator2 = @$filter["w_freight"];
		$this->freight->AdvancedSearch->save();

		// Field ded_det
		$this->ded_det->AdvancedSearch->SearchValue = @$filter["x_ded_det"];
		$this->ded_det->AdvancedSearch->SearchOperator = @$filter["z_ded_det"];
		$this->ded_det->AdvancedSearch->SearchCondition = @$filter["v_ded_det"];
		$this->ded_det->AdvancedSearch->SearchValue2 = @$filter["y_ded_det"];
		$this->ded_det->AdvancedSearch->SearchOperator2 = @$filter["w_ded_det"];
		$this->ded_det->AdvancedSearch->save();

		// Field ded_det_remarks
		$this->ded_det_remarks->AdvancedSearch->SearchValue = @$filter["x_ded_det_remarks"];
		$this->ded_det_remarks->AdvancedSearch->SearchOperator = @$filter["z_ded_det_remarks"];
		$this->ded_det_remarks->AdvancedSearch->SearchCondition = @$filter["v_ded_det_remarks"];
		$this->ded_det_remarks->AdvancedSearch->SearchValue2 = @$filter["y_ded_det_remarks"];
		$this->ded_det_remarks->AdvancedSearch->SearchOperator2 = @$filter["w_ded_det_remarks"];
		$this->ded_det_remarks->AdvancedSearch->save();

		// Field gst_percent
		$this->gst_percent->AdvancedSearch->SearchValue = @$filter["x_gst_percent"];
		$this->gst_percent->AdvancedSearch->SearchOperator = @$filter["z_gst_percent"];
		$this->gst_percent->AdvancedSearch->SearchCondition = @$filter["v_gst_percent"];
		$this->gst_percent->AdvancedSearch->SearchValue2 = @$filter["y_gst_percent"];
		$this->gst_percent->AdvancedSearch->SearchOperator2 = @$filter["w_gst_percent"];
		$this->gst_percent->AdvancedSearch->save();

		// Field gst_amount
		$this->gst_amount->AdvancedSearch->SearchValue = @$filter["x_gst_amount"];
		$this->gst_amount->AdvancedSearch->SearchOperator = @$filter["z_gst_amount"];
		$this->gst_amount->AdvancedSearch->SearchCondition = @$filter["v_gst_amount"];
		$this->gst_amount->AdvancedSearch->SearchValue2 = @$filter["y_gst_amount"];
		$this->gst_amount->AdvancedSearch->SearchOperator2 = @$filter["w_gst_amount"];
		$this->gst_amount->AdvancedSearch->save();

		// Field final_amount
		$this->final_amount->AdvancedSearch->SearchValue = @$filter["x_final_amount"];
		$this->final_amount->AdvancedSearch->SearchOperator = @$filter["z_final_amount"];
		$this->final_amount->AdvancedSearch->SearchCondition = @$filter["v_final_amount"];
		$this->final_amount->AdvancedSearch->SearchValue2 = @$filter["y_final_amount"];
		$this->final_amount->AdvancedSearch->SearchOperator2 = @$filter["w_final_amount"];
		$this->final_amount->AdvancedSearch->save();

		// Field load_km
		$this->load_km->AdvancedSearch->SearchValue = @$filter["x_load_km"];
		$this->load_km->AdvancedSearch->SearchOperator = @$filter["z_load_km"];
		$this->load_km->AdvancedSearch->SearchCondition = @$filter["v_load_km"];
		$this->load_km->AdvancedSearch->SearchValue2 = @$filter["y_load_km"];
		$this->load_km->AdvancedSearch->SearchOperator2 = @$filter["w_load_km"];
		$this->load_km->AdvancedSearch->save();

		// Field unload_km
		$this->unload_km->AdvancedSearch->SearchValue = @$filter["x_unload_km"];
		$this->unload_km->AdvancedSearch->SearchOperator = @$filter["z_unload_km"];
		$this->unload_km->AdvancedSearch->SearchCondition = @$filter["v_unload_km"];
		$this->unload_km->AdvancedSearch->SearchValue2 = @$filter["y_unload_km"];
		$this->unload_km->AdvancedSearch->SearchOperator2 = @$filter["w_unload_km"];
		$this->unload_km->AdvancedSearch->save();

		// Field delivery_receipt
		$this->delivery_receipt->AdvancedSearch->SearchValue = @$filter["x_delivery_receipt"];
		$this->delivery_receipt->AdvancedSearch->SearchOperator = @$filter["z_delivery_receipt"];
		$this->delivery_receipt->AdvancedSearch->SearchCondition = @$filter["v_delivery_receipt"];
		$this->delivery_receipt->AdvancedSearch->SearchValue2 = @$filter["y_delivery_receipt"];
		$this->delivery_receipt->AdvancedSearch->SearchOperator2 = @$filter["w_delivery_receipt"];
		$this->delivery_receipt->AdvancedSearch->save();

		// Field delivery_docket
		$this->delivery_docket->AdvancedSearch->SearchValue = @$filter["x_delivery_docket"];
		$this->delivery_docket->AdvancedSearch->SearchOperator = @$filter["z_delivery_docket"];
		$this->delivery_docket->AdvancedSearch->SearchCondition = @$filter["v_delivery_docket"];
		$this->delivery_docket->AdvancedSearch->SearchValue2 = @$filter["y_delivery_docket"];
		$this->delivery_docket->AdvancedSearch->SearchOperator2 = @$filter["w_delivery_docket"];
		$this->delivery_docket->AdvancedSearch->save();

		// Field diesal_op_b
		$this->diesal_op_b->AdvancedSearch->SearchValue = @$filter["x_diesal_op_b"];
		$this->diesal_op_b->AdvancedSearch->SearchOperator = @$filter["z_diesal_op_b"];
		$this->diesal_op_b->AdvancedSearch->SearchCondition = @$filter["v_diesal_op_b"];
		$this->diesal_op_b->AdvancedSearch->SearchValue2 = @$filter["y_diesal_op_b"];
		$this->diesal_op_b->AdvancedSearch->SearchOperator2 = @$filter["w_diesal_op_b"];
		$this->diesal_op_b->AdvancedSearch->save();

		// Field diesal_required
		$this->diesal_required->AdvancedSearch->SearchValue = @$filter["x_diesal_required"];
		$this->diesal_required->AdvancedSearch->SearchOperator = @$filter["z_diesal_required"];
		$this->diesal_required->AdvancedSearch->SearchCondition = @$filter["v_diesal_required"];
		$this->diesal_required->AdvancedSearch->SearchValue2 = @$filter["y_diesal_required"];
		$this->diesal_required->AdvancedSearch->SearchOperator2 = @$filter["w_diesal_required"];
		$this->diesal_required->AdvancedSearch->save();

		// Field diesal_fill
		$this->diesal_fill->AdvancedSearch->SearchValue = @$filter["x_diesal_fill"];
		$this->diesal_fill->AdvancedSearch->SearchOperator = @$filter["z_diesal_fill"];
		$this->diesal_fill->AdvancedSearch->SearchCondition = @$filter["v_diesal_fill"];
		$this->diesal_fill->AdvancedSearch->SearchValue2 = @$filter["y_diesal_fill"];
		$this->diesal_fill->AdvancedSearch->SearchOperator2 = @$filter["w_diesal_fill"];
		$this->diesal_fill->AdvancedSearch->save();

		// Field diesal_amount
		$this->diesal_amount->AdvancedSearch->SearchValue = @$filter["x_diesal_amount"];
		$this->diesal_amount->AdvancedSearch->SearchOperator = @$filter["z_diesal_amount"];
		$this->diesal_amount->AdvancedSearch->SearchCondition = @$filter["v_diesal_amount"];
		$this->diesal_amount->AdvancedSearch->SearchValue2 = @$filter["y_diesal_amount"];
		$this->diesal_amount->AdvancedSearch->SearchOperator2 = @$filter["w_diesal_amount"];
		$this->diesal_amount->AdvancedSearch->save();

		// Field diesal_cl_balance
		$this->diesal_cl_balance->AdvancedSearch->SearchValue = @$filter["x_diesal_cl_balance"];
		$this->diesal_cl_balance->AdvancedSearch->SearchOperator = @$filter["z_diesal_cl_balance"];
		$this->diesal_cl_balance->AdvancedSearch->SearchCondition = @$filter["v_diesal_cl_balance"];
		$this->diesal_cl_balance->AdvancedSearch->SearchValue2 = @$filter["y_diesal_cl_balance"];
		$this->diesal_cl_balance->AdvancedSearch->SearchOperator2 = @$filter["w_diesal_cl_balance"];
		$this->diesal_cl_balance->AdvancedSearch->save();

		// Field vehicle_average
		$this->vehicle_average->AdvancedSearch->SearchValue = @$filter["x_vehicle_average"];
		$this->vehicle_average->AdvancedSearch->SearchOperator = @$filter["z_vehicle_average"];
		$this->vehicle_average->AdvancedSearch->SearchCondition = @$filter["v_vehicle_average"];
		$this->vehicle_average->AdvancedSearch->SearchValue2 = @$filter["y_vehicle_average"];
		$this->vehicle_average->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle_average"];
		$this->vehicle_average->AdvancedSearch->save();

		// Field cash_required
		$this->cash_required->AdvancedSearch->SearchValue = @$filter["x_cash_required"];
		$this->cash_required->AdvancedSearch->SearchOperator = @$filter["z_cash_required"];
		$this->cash_required->AdvancedSearch->SearchCondition = @$filter["v_cash_required"];
		$this->cash_required->AdvancedSearch->SearchValue2 = @$filter["y_cash_required"];
		$this->cash_required->AdvancedSearch->SearchOperator2 = @$filter["w_cash_required"];
		$this->cash_required->AdvancedSearch->save();

		// Field cash_op_b
		$this->cash_op_b->AdvancedSearch->SearchValue = @$filter["x_cash_op_b"];
		$this->cash_op_b->AdvancedSearch->SearchOperator = @$filter["z_cash_op_b"];
		$this->cash_op_b->AdvancedSearch->SearchCondition = @$filter["v_cash_op_b"];
		$this->cash_op_b->AdvancedSearch->SearchValue2 = @$filter["y_cash_op_b"];
		$this->cash_op_b->AdvancedSearch->SearchOperator2 = @$filter["w_cash_op_b"];
		$this->cash_op_b->AdvancedSearch->save();

		// Field cash_paid
		$this->cash_paid->AdvancedSearch->SearchValue = @$filter["x_cash_paid"];
		$this->cash_paid->AdvancedSearch->SearchOperator = @$filter["z_cash_paid"];
		$this->cash_paid->AdvancedSearch->SearchCondition = @$filter["v_cash_paid"];
		$this->cash_paid->AdvancedSearch->SearchValue2 = @$filter["y_cash_paid"];
		$this->cash_paid->AdvancedSearch->SearchOperator2 = @$filter["w_cash_paid"];
		$this->cash_paid->AdvancedSearch->save();

		// Field cash_expenses
		$this->cash_expenses->AdvancedSearch->SearchValue = @$filter["x_cash_expenses"];
		$this->cash_expenses->AdvancedSearch->SearchOperator = @$filter["z_cash_expenses"];
		$this->cash_expenses->AdvancedSearch->SearchCondition = @$filter["v_cash_expenses"];
		$this->cash_expenses->AdvancedSearch->SearchValue2 = @$filter["y_cash_expenses"];
		$this->cash_expenses->AdvancedSearch->SearchOperator2 = @$filter["w_cash_expenses"];
		$this->cash_expenses->AdvancedSearch->save();

		// Field cash_cl_balance
		$this->cash_cl_balance->AdvancedSearch->SearchValue = @$filter["x_cash_cl_balance"];
		$this->cash_cl_balance->AdvancedSearch->SearchOperator = @$filter["z_cash_cl_balance"];
		$this->cash_cl_balance->AdvancedSearch->SearchCondition = @$filter["v_cash_cl_balance"];
		$this->cash_cl_balance->AdvancedSearch->SearchValue2 = @$filter["y_cash_cl_balance"];
		$this->cash_cl_balance->AdvancedSearch->SearchOperator2 = @$filter["w_cash_cl_balance"];
		$this->cash_cl_balance->AdvancedSearch->save();

		// Field fasttag_op_b
		$this->fasttag_op_b->AdvancedSearch->SearchValue = @$filter["x_fasttag_op_b"];
		$this->fasttag_op_b->AdvancedSearch->SearchOperator = @$filter["z_fasttag_op_b"];
		$this->fasttag_op_b->AdvancedSearch->SearchCondition = @$filter["v_fasttag_op_b"];
		$this->fasttag_op_b->AdvancedSearch->SearchValue2 = @$filter["y_fasttag_op_b"];
		$this->fasttag_op_b->AdvancedSearch->SearchOperator2 = @$filter["w_fasttag_op_b"];
		$this->fasttag_op_b->AdvancedSearch->save();

		// Field fasttag_recharge
		$this->fasttag_recharge->AdvancedSearch->SearchValue = @$filter["x_fasttag_recharge"];
		$this->fasttag_recharge->AdvancedSearch->SearchOperator = @$filter["z_fasttag_recharge"];
		$this->fasttag_recharge->AdvancedSearch->SearchCondition = @$filter["v_fasttag_recharge"];
		$this->fasttag_recharge->AdvancedSearch->SearchValue2 = @$filter["y_fasttag_recharge"];
		$this->fasttag_recharge->AdvancedSearch->SearchOperator2 = @$filter["w_fasttag_recharge"];
		$this->fasttag_recharge->AdvancedSearch->save();

		// Field fasttag_expenses
		$this->fasttag_expenses->AdvancedSearch->SearchValue = @$filter["x_fasttag_expenses"];
		$this->fasttag_expenses->AdvancedSearch->SearchOperator = @$filter["z_fasttag_expenses"];
		$this->fasttag_expenses->AdvancedSearch->SearchCondition = @$filter["v_fasttag_expenses"];
		$this->fasttag_expenses->AdvancedSearch->SearchValue2 = @$filter["y_fasttag_expenses"];
		$this->fasttag_expenses->AdvancedSearch->SearchOperator2 = @$filter["w_fasttag_expenses"];
		$this->fasttag_expenses->AdvancedSearch->save();

		// Field toll_expenses_cash
		$this->toll_expenses_cash->AdvancedSearch->SearchValue = @$filter["x_toll_expenses_cash"];
		$this->toll_expenses_cash->AdvancedSearch->SearchOperator = @$filter["z_toll_expenses_cash"];
		$this->toll_expenses_cash->AdvancedSearch->SearchCondition = @$filter["v_toll_expenses_cash"];
		$this->toll_expenses_cash->AdvancedSearch->SearchValue2 = @$filter["y_toll_expenses_cash"];
		$this->toll_expenses_cash->AdvancedSearch->SearchOperator2 = @$filter["w_toll_expenses_cash"];
		$this->toll_expenses_cash->AdvancedSearch->save();

		// Field fasttag_cl_balance
		$this->fasttag_cl_balance->AdvancedSearch->SearchValue = @$filter["x_fasttag_cl_balance"];
		$this->fasttag_cl_balance->AdvancedSearch->SearchOperator = @$filter["z_fasttag_cl_balance"];
		$this->fasttag_cl_balance->AdvancedSearch->SearchCondition = @$filter["v_fasttag_cl_balance"];
		$this->fasttag_cl_balance->AdvancedSearch->SearchValue2 = @$filter["y_fasttag_cl_balance"];
		$this->fasttag_cl_balance->AdvancedSearch->SearchOperator2 = @$filter["w_fasttag_cl_balance"];
		$this->fasttag_cl_balance->AdvancedSearch->save();

		// Field remarks
		$this->remarks->AdvancedSearch->SearchValue = @$filter["x_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator = @$filter["z_remarks"];
		$this->remarks->AdvancedSearch->SearchCondition = @$filter["v_remarks"];
		$this->remarks->AdvancedSearch->SearchValue2 = @$filter["y_remarks"];
		$this->remarks->AdvancedSearch->SearchOperator2 = @$filter["w_remarks"];
		$this->remarks->AdvancedSearch->save();

		// Field uploads
		$this->uploads->AdvancedSearch->SearchValue = @$filter["x_uploads"];
		$this->uploads->AdvancedSearch->SearchOperator = @$filter["z_uploads"];
		$this->uploads->AdvancedSearch->SearchCondition = @$filter["v_uploads"];
		$this->uploads->AdvancedSearch->SearchValue2 = @$filter["y_uploads"];
		$this->uploads->AdvancedSearch->SearchOperator2 = @$filter["w_uploads"];
		$this->uploads->AdvancedSearch->save();

		// Field consignor
		$this->consignor->AdvancedSearch->SearchValue = @$filter["x_consignor"];
		$this->consignor->AdvancedSearch->SearchOperator = @$filter["z_consignor"];
		$this->consignor->AdvancedSearch->SearchCondition = @$filter["v_consignor"];
		$this->consignor->AdvancedSearch->SearchValue2 = @$filter["y_consignor"];
		$this->consignor->AdvancedSearch->SearchOperator2 = @$filter["w_consignor"];
		$this->consignor->AdvancedSearch->save();

		// Field vehicle_freight_comm
		$this->vehicle_freight_comm->AdvancedSearch->SearchValue = @$filter["x_vehicle_freight_comm"];
		$this->vehicle_freight_comm->AdvancedSearch->SearchOperator = @$filter["z_vehicle_freight_comm"];
		$this->vehicle_freight_comm->AdvancedSearch->SearchCondition = @$filter["v_vehicle_freight_comm"];
		$this->vehicle_freight_comm->AdvancedSearch->SearchValue2 = @$filter["y_vehicle_freight_comm"];
		$this->vehicle_freight_comm->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle_freight_comm"];
		$this->vehicle_freight_comm->AdvancedSearch->save();

		// Field vehicle_freight_type
		$this->vehicle_freight_type->AdvancedSearch->SearchValue = @$filter["x_vehicle_freight_type"];
		$this->vehicle_freight_type->AdvancedSearch->SearchOperator = @$filter["z_vehicle_freight_type"];
		$this->vehicle_freight_type->AdvancedSearch->SearchCondition = @$filter["v_vehicle_freight_type"];
		$this->vehicle_freight_type->AdvancedSearch->SearchValue2 = @$filter["y_vehicle_freight_type"];
		$this->vehicle_freight_type->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle_freight_type"];
		$this->vehicle_freight_type->AdvancedSearch->save();

		// Field vehicle_freight_amount
		$this->vehicle_freight_amount->AdvancedSearch->SearchValue = @$filter["x_vehicle_freight_amount"];
		$this->vehicle_freight_amount->AdvancedSearch->SearchOperator = @$filter["z_vehicle_freight_amount"];
		$this->vehicle_freight_amount->AdvancedSearch->SearchCondition = @$filter["v_vehicle_freight_amount"];
		$this->vehicle_freight_amount->AdvancedSearch->SearchValue2 = @$filter["y_vehicle_freight_amount"];
		$this->vehicle_freight_amount->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle_freight_amount"];
		$this->vehicle_freight_amount->AdvancedSearch->save();

		// Field vehicle_freight_final
		$this->vehicle_freight_final->AdvancedSearch->SearchValue = @$filter["x_vehicle_freight_final"];
		$this->vehicle_freight_final->AdvancedSearch->SearchOperator = @$filter["z_vehicle_freight_final"];
		$this->vehicle_freight_final->AdvancedSearch->SearchCondition = @$filter["v_vehicle_freight_final"];
		$this->vehicle_freight_final->AdvancedSearch->SearchValue2 = @$filter["y_vehicle_freight_final"];
		$this->vehicle_freight_final->AdvancedSearch->SearchOperator2 = @$filter["w_vehicle_freight_final"];
		$this->vehicle_freight_final->AdvancedSearch->save();

		// Field operator
		$this->operator->AdvancedSearch->SearchValue = @$filter["x_operator"];
		$this->operator->AdvancedSearch->SearchOperator = @$filter["z_operator"];
		$this->operator->AdvancedSearch->SearchCondition = @$filter["v_operator"];
		$this->operator->AdvancedSearch->SearchValue2 = @$filter["y_operator"];
		$this->operator->AdvancedSearch->SearchOperator2 = @$filter["w_operator"];
		$this->operator->AdvancedSearch->save();

		// Field datetime
		$this->datetime->AdvancedSearch->SearchValue = @$filter["x_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator = @$filter["z_datetime"];
		$this->datetime->AdvancedSearch->SearchCondition = @$filter["v_datetime"];
		$this->datetime->AdvancedSearch->SearchValue2 = @$filter["y_datetime"];
		$this->datetime->AdvancedSearch->SearchOperator2 = @$filter["w_datetime"];
		$this->datetime->AdvancedSearch->save();
		$this->BasicSearch->setKeyword(@$filter[TABLE_BASIC_SEARCH]);
		$this->BasicSearch->setType(@$filter[TABLE_BASIC_SEARCH_TYPE]);
	}

	// Advanced search WHERE clause based on QueryString
	protected function advancedSearchWhere($default = FALSE)
	{
		global $Security;
		$where = "";
		if (!$Security->canSearch())
			return "";
		$this->buildSearchSql($where, $this->id, $default, FALSE); // id
		$this->buildSearchSql($where, $this->vehicle_type, $default, FALSE); // vehicle_type
		$this->buildSearchSql($where, $this->vehicle, $default, FALSE); // vehicle
		$this->buildSearchSql($where, $this->_route, $default, FALSE); // route
		$this->buildSearchSql($where, $this->route_name, $default, FALSE); // route_name
		$this->buildSearchSql($where, $this->reports_to, $default, FALSE); // reports_to
		$this->buildSearchSql($where, $this->buyer, $default, FALSE); // buyer
		$this->buildSearchSql($where, $this->b_consignor, $default, FALSE); // b_consignor
		$this->buildSearchSql($where, $this->b_consignee, $default, FALSE); // b_consignee
		$this->buildSearchSql($where, $this->load_date, $default, FALSE); // load_date
		$this->buildSearchSql($where, $this->load_weight, $default, FALSE); // load_weight
		$this->buildSearchSql($where, $this->unload_date, $default, FALSE); // unload_date
		$this->buildSearchSql($where, $this->unload_weight, $default, FALSE); // unload_weight
		$this->buildSearchSql($where, $this->invoice_no, $default, FALSE); // invoice_no
		$this->buildSearchSql($where, $this->invoice_date, $default, FALSE); // invoice_date
		$this->buildSearchSql($where, $this->amount, $default, FALSE); // amount
		$this->buildSearchSql($where, $this->delivery_pod, $default, FALSE); // delivery_pod
		$this->buildSearchSql($where, $this->status, $default, FALSE); // status
		$this->buildSearchSql($where, $this->days, $default, FALSE); // days
		$this->buildSearchSql($where, $this->driver, $default, FALSE); // driver
		$this->buildSearchSql($where, $this->driver_name, $default, FALSE); // driver_name
		$this->buildSearchSql($where, $this->agent, $default, FALSE); // agent
		$this->buildSearchSql($where, $this->comm, $default, FALSE); // comm
		$this->buildSearchSql($where, $this->material, $default, FALSE); // material
		$this->buildSearchSql($where, $this->packing_type, $default, FALSE); // packing_type
		$this->buildSearchSql($where, $this->m_hsn, $default, FALSE); // m_hsn
		$this->buildSearchSql($where, $this->_40, $default, FALSE); // @
		$this->buildSearchSql($where, $this->lr_no, $default, FALSE); // lr_no
		$this->buildSearchSql($where, $this->km, $default, FALSE); // km
		$this->buildSearchSql($where, $this->freight_type, $default, FALSE); // freight_type
		$this->buildSearchSql($where, $this->freight, $default, FALSE); // freight
		$this->buildSearchSql($where, $this->ded_det, $default, FALSE); // ded_det
		$this->buildSearchSql($where, $this->ded_det_remarks, $default, FALSE); // ded_det_remarks
		$this->buildSearchSql($where, $this->gst_percent, $default, FALSE); // gst_percent
		$this->buildSearchSql($where, $this->gst_amount, $default, FALSE); // gst_amount
		$this->buildSearchSql($where, $this->final_amount, $default, FALSE); // final_amount
		$this->buildSearchSql($where, $this->load_km, $default, FALSE); // load_km
		$this->buildSearchSql($where, $this->unload_km, $default, FALSE); // unload_km
		$this->buildSearchSql($where, $this->delivery_receipt, $default, FALSE); // delivery_receipt
		$this->buildSearchSql($where, $this->delivery_docket, $default, FALSE); // delivery_docket
		$this->buildSearchSql($where, $this->diesal_op_b, $default, FALSE); // diesal_op_b
		$this->buildSearchSql($where, $this->diesal_required, $default, FALSE); // diesal_required
		$this->buildSearchSql($where, $this->diesal_fill, $default, FALSE); // diesal_fill
		$this->buildSearchSql($where, $this->diesal_amount, $default, FALSE); // diesal_amount
		$this->buildSearchSql($where, $this->diesal_cl_balance, $default, FALSE); // diesal_cl_balance
		$this->buildSearchSql($where, $this->vehicle_average, $default, FALSE); // vehicle_average
		$this->buildSearchSql($where, $this->cash_required, $default, FALSE); // cash_required
		$this->buildSearchSql($where, $this->cash_op_b, $default, FALSE); // cash_op_b
		$this->buildSearchSql($where, $this->cash_paid, $default, FALSE); // cash_paid
		$this->buildSearchSql($where, $this->cash_expenses, $default, FALSE); // cash_expenses
		$this->buildSearchSql($where, $this->cash_cl_balance, $default, FALSE); // cash_cl_balance
		$this->buildSearchSql($where, $this->fasttag_op_b, $default, FALSE); // fasttag_op_b
		$this->buildSearchSql($where, $this->fasttag_recharge, $default, FALSE); // fasttag_recharge
		$this->buildSearchSql($where, $this->fasttag_expenses, $default, FALSE); // fasttag_expenses
		$this->buildSearchSql($where, $this->toll_expenses_cash, $default, FALSE); // toll_expenses_cash
		$this->buildSearchSql($where, $this->fasttag_cl_balance, $default, FALSE); // fasttag_cl_balance
		$this->buildSearchSql($where, $this->remarks, $default, FALSE); // remarks
		$this->buildSearchSql($where, $this->uploads, $default, FALSE); // uploads
		$this->buildSearchSql($where, $this->consignor, $default, FALSE); // consignor
		$this->buildSearchSql($where, $this->vehicle_freight_comm, $default, FALSE); // vehicle_freight_comm
		$this->buildSearchSql($where, $this->vehicle_freight_type, $default, FALSE); // vehicle_freight_type
		$this->buildSearchSql($where, $this->vehicle_freight_amount, $default, FALSE); // vehicle_freight_amount
		$this->buildSearchSql($where, $this->vehicle_freight_final, $default, FALSE); // vehicle_freight_final
		$this->buildSearchSql($where, $this->operator, $default, FALSE); // operator
		$this->buildSearchSql($where, $this->datetime, $default, FALSE); // datetime

		// Set up search parm
		if (!$default && $where <> "" && in_array($this->Command, array("", "reset", "resetall"))) {
			$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->id->AdvancedSearch->save(); // id
			$this->vehicle_type->AdvancedSearch->save(); // vehicle_type
			$this->vehicle->AdvancedSearch->save(); // vehicle
			$this->_route->AdvancedSearch->save(); // route
			$this->route_name->AdvancedSearch->save(); // route_name
			$this->reports_to->AdvancedSearch->save(); // reports_to
			$this->buyer->AdvancedSearch->save(); // buyer
			$this->b_consignor->AdvancedSearch->save(); // b_consignor
			$this->b_consignee->AdvancedSearch->save(); // b_consignee
			$this->load_date->AdvancedSearch->save(); // load_date
			$this->load_weight->AdvancedSearch->save(); // load_weight
			$this->unload_date->AdvancedSearch->save(); // unload_date
			$this->unload_weight->AdvancedSearch->save(); // unload_weight
			$this->invoice_no->AdvancedSearch->save(); // invoice_no
			$this->invoice_date->AdvancedSearch->save(); // invoice_date
			$this->amount->AdvancedSearch->save(); // amount
			$this->delivery_pod->AdvancedSearch->save(); // delivery_pod
			$this->status->AdvancedSearch->save(); // status
			$this->days->AdvancedSearch->save(); // days
			$this->driver->AdvancedSearch->save(); // driver
			$this->driver_name->AdvancedSearch->save(); // driver_name
			$this->agent->AdvancedSearch->save(); // agent
			$this->comm->AdvancedSearch->save(); // comm
			$this->material->AdvancedSearch->save(); // material
			$this->packing_type->AdvancedSearch->save(); // packing_type
			$this->m_hsn->AdvancedSearch->save(); // m_hsn
			$this->_40->AdvancedSearch->save(); // @
			$this->lr_no->AdvancedSearch->save(); // lr_no
			$this->km->AdvancedSearch->save(); // km
			$this->freight_type->AdvancedSearch->save(); // freight_type
			$this->freight->AdvancedSearch->save(); // freight
			$this->ded_det->AdvancedSearch->save(); // ded_det
			$this->ded_det_remarks->AdvancedSearch->save(); // ded_det_remarks
			$this->gst_percent->AdvancedSearch->save(); // gst_percent
			$this->gst_amount->AdvancedSearch->save(); // gst_amount
			$this->final_amount->AdvancedSearch->save(); // final_amount
			$this->load_km->AdvancedSearch->save(); // load_km
			$this->unload_km->AdvancedSearch->save(); // unload_km
			$this->delivery_receipt->AdvancedSearch->save(); // delivery_receipt
			$this->delivery_docket->AdvancedSearch->save(); // delivery_docket
			$this->diesal_op_b->AdvancedSearch->save(); // diesal_op_b
			$this->diesal_required->AdvancedSearch->save(); // diesal_required
			$this->diesal_fill->AdvancedSearch->save(); // diesal_fill
			$this->diesal_amount->AdvancedSearch->save(); // diesal_amount
			$this->diesal_cl_balance->AdvancedSearch->save(); // diesal_cl_balance
			$this->vehicle_average->AdvancedSearch->save(); // vehicle_average
			$this->cash_required->AdvancedSearch->save(); // cash_required
			$this->cash_op_b->AdvancedSearch->save(); // cash_op_b
			$this->cash_paid->AdvancedSearch->save(); // cash_paid
			$this->cash_expenses->AdvancedSearch->save(); // cash_expenses
			$this->cash_cl_balance->AdvancedSearch->save(); // cash_cl_balance
			$this->fasttag_op_b->AdvancedSearch->save(); // fasttag_op_b
			$this->fasttag_recharge->AdvancedSearch->save(); // fasttag_recharge
			$this->fasttag_expenses->AdvancedSearch->save(); // fasttag_expenses
			$this->toll_expenses_cash->AdvancedSearch->save(); // toll_expenses_cash
			$this->fasttag_cl_balance->AdvancedSearch->save(); // fasttag_cl_balance
			$this->remarks->AdvancedSearch->save(); // remarks
			$this->uploads->AdvancedSearch->save(); // uploads
			$this->consignor->AdvancedSearch->save(); // consignor
			$this->vehicle_freight_comm->AdvancedSearch->save(); // vehicle_freight_comm
			$this->vehicle_freight_type->AdvancedSearch->save(); // vehicle_freight_type
			$this->vehicle_freight_amount->AdvancedSearch->save(); // vehicle_freight_amount
			$this->vehicle_freight_final->AdvancedSearch->save(); // vehicle_freight_final
			$this->operator->AdvancedSearch->save(); // operator
			$this->datetime->AdvancedSearch->save(); // datetime
		}
		return $where;
	}

	// Build search SQL
	protected function buildSearchSql(&$where, &$fld, $default, $multiValue)
	{
		$fldParm = $fld->Param;
		$fldVal = ($default) ? $fld->AdvancedSearch->SearchValueDefault : $fld->AdvancedSearch->SearchValue;
		$fldOpr = ($default) ? $fld->AdvancedSearch->SearchOperatorDefault : $fld->AdvancedSearch->SearchOperator;
		$fldCond = ($default) ? $fld->AdvancedSearch->SearchConditionDefault : $fld->AdvancedSearch->SearchCondition;
		$fldVal2 = ($default) ? $fld->AdvancedSearch->SearchValue2Default : $fld->AdvancedSearch->SearchValue2;
		$fldOpr2 = ($default) ? $fld->AdvancedSearch->SearchOperator2Default : $fld->AdvancedSearch->SearchOperator2;
		$wrk = "";
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		if ($fldOpr == "")
			$fldOpr = "=";
		$fldOpr2 = strtoupper(trim($fldOpr2));
		if ($fldOpr2 == "")
			$fldOpr2 = "=";
		if (SEARCH_MULTI_VALUE_OPTION == 1)
			$multiValue = FALSE;
		if ($multiValue) {
			$wrk1 = ($fldVal <> "") ? GetMultiSearchSql($fld, $fldOpr, $fldVal, $this->Dbid) : ""; // Field value 1
			$wrk2 = ($fldVal2 <> "") ? GetMultiSearchSql($fld, $fldOpr2, $fldVal2, $this->Dbid) : ""; // Field value 2
			$wrk = $wrk1; // Build final SQL
			if ($wrk2 <> "")
				$wrk = ($wrk <> "") ? "($wrk) $fldCond ($wrk2)" : $wrk2;
		} else {
			$fldVal = $this->convertSearchValue($fld, $fldVal);
			$fldVal2 = $this->convertSearchValue($fld, $fldVal2);
			$wrk = GetSearchSql($fld, $fldVal, $fldOpr, $fldCond, $fldVal2, $fldOpr2, $this->Dbid);
		}
		AddFilter($where, $wrk);
	}

	// Convert search value
	protected function convertSearchValue(&$fld, $fldVal)
	{
		if ($fldVal == NULL_VALUE || $fldVal == NOT_NULL_VALUE)
			return $fldVal;
		$value = $fldVal;
		if ($fld->DataType == DATATYPE_BOOLEAN) {
			if ($fldVal <> "")
				$value = (SameText($fldVal, "1") || SameText($fldVal, "y") || SameText($fldVal, "t")) ? $fld->TrueValue : $fld->FalseValue;
		} elseif ($fld->DataType == DATATYPE_DATE || $fld->DataType == DATATYPE_TIME) {
			if ($fldVal <> "")
				$value = UnFormatDateTime($fldVal, $fld->DateTimeFormat);
		}
		return $value;
	}

	// Return basic search SQL
	protected function basicSearchSql($arKeywords, $type)
	{
		$where = "";
		$this->buildBasicSearchSql($where, $this->id, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->route_name, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->buyer, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_consignor, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->b_consignee, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->agent, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->packing_type, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->m_hsn, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->lr_no, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->ded_det_remarks, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->delivery_receipt, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->delivery_docket, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->remarks, $arKeywords, $type);
		$this->buildBasicSearchSql($where, $this->uploads, $arKeywords, $type);
		return $where;
	}

	// Build basic search SQL
	protected function buildBasicSearchSql(&$where, &$fld, $arKeywords, $type)
	{
		global $BASIC_SEARCH_IGNORE_PATTERN;
		$defCond = ($type == "OR") ? "OR" : "AND";
		$arSql = array(); // Array for SQL parts
		$arCond = array(); // Array for search conditions
		$cnt = count($arKeywords);
		$j = 0; // Number of SQL parts
		for ($i = 0; $i < $cnt; $i++) {
			$keyword = $arKeywords[$i];
			$keyword = trim($keyword);
			if ($BASIC_SEARCH_IGNORE_PATTERN <> "") {
				$keyword = preg_replace($BASIC_SEARCH_IGNORE_PATTERN, "\\", $keyword);
				$ar = explode("\\", $keyword);
			} else {
				$ar = array($keyword);
			}
			foreach ($ar as $keyword) {
				if ($keyword <> "") {
					$wrk = "";
					if ($keyword == "OR" && $type == "") {
						if ($j > 0)
							$arCond[$j - 1] = "OR";
					} elseif ($keyword == NULL_VALUE) {
						$wrk = $fld->Expression . " IS NULL";
					} elseif ($keyword == NOT_NULL_VALUE) {
						$wrk = $fld->Expression . " IS NOT NULL";
					} elseif ($fld->IsVirtual) {
						$wrk = $fld->VirtualExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					} elseif ($fld->DataType != DATATYPE_NUMBER || is_numeric($keyword)) {
						$wrk = $fld->BasicSearchExpression . Like(QuotedValue("%" . $keyword . "%", DATATYPE_STRING, $this->Dbid), $this->Dbid);
					}
					if ($wrk <> "") {
						$arSql[$j] = $wrk;
						$arCond[$j] = $defCond;
						$j += 1;
					}
				}
			}
		}
		$cnt = count($arSql);
		$quoted = FALSE;
		$sql = "";
		if ($cnt > 0) {
			for ($i = 0; $i < $cnt - 1; $i++) {
				if ($arCond[$i] == "OR") {
					if (!$quoted)
						$sql .= "(";
					$quoted = TRUE;
				}
				$sql .= $arSql[$i];
				if ($quoted && $arCond[$i] <> "OR") {
					$sql .= ")";
					$quoted = FALSE;
				}
				$sql .= " " . $arCond[$i] . " ";
			}
			$sql .= $arSql[$cnt - 1];
			if ($quoted)
				$sql .= ")";
		}
		if ($sql <> "") {
			if ($where <> "")
				$where .= " OR ";
			$where .= "(" . $sql . ")";
		}
	}

	// Return basic search WHERE clause based on search keyword and type
	protected function basicSearchWhere($default = FALSE)
	{
		global $Security;
		$searchStr = "";
		if (!$Security->canSearch())
			return "";
		$searchKeyword = ($default) ? $this->BasicSearch->KeywordDefault : $this->BasicSearch->Keyword;
		$searchType = ($default) ? $this->BasicSearch->TypeDefault : $this->BasicSearch->Type;

		// Get search SQL
		if ($searchKeyword <> "") {
			$ar = $this->BasicSearch->keywordList($default);

			// Search keyword in any fields
			if (($searchType == "OR" || $searchType == "AND") && $this->BasicSearch->BasicSearchAnyFields) {
				foreach ($ar as $keyword) {
					if ($keyword <> "") {
						if ($searchStr <> "")
							$searchStr .= " " . $searchType . " ";
						$searchStr .= "(" . $this->basicSearchSql(array($keyword), $searchType) . ")";
					}
				}
			} else {
				$searchStr = $this->basicSearchSql($ar, $searchType);
			}
			if (!$default && in_array($this->Command, array("", "reset", "resetall")))
				$this->Command = "search";
		}
		if (!$default && $this->Command == "search") {
			$this->BasicSearch->setKeyword($searchKeyword);
			$this->BasicSearch->setType($searchType);
		}
		return $searchStr;
	}

	// Check if search parm exists
	protected function checkSearchParms()
	{

		// Check basic search
		if ($this->BasicSearch->issetSession())
			return TRUE;
		if ($this->id->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_route->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->route_name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->reports_to->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->buyer->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_consignor->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->b_consignee->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->load_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->load_weight->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->unload_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->unload_weight->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->invoice_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->invoice_date->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->delivery_pod->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->status->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->days->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->driver->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->driver_name->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->agent->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->comm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->material->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->packing_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->m_hsn->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->_40->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->lr_no->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->km->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->freight_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->freight->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ded_det->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->ded_det_remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->gst_percent->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->gst_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->final_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->load_km->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->unload_km->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->delivery_receipt->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->delivery_docket->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->diesal_op_b->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->diesal_required->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->diesal_fill->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->diesal_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->diesal_cl_balance->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle_average->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cash_required->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cash_op_b->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cash_paid->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cash_expenses->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->cash_cl_balance->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->fasttag_op_b->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->fasttag_recharge->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->fasttag_expenses->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->toll_expenses_cash->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->fasttag_cl_balance->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->remarks->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->uploads->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->consignor->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle_freight_comm->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle_freight_type->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle_freight_amount->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->vehicle_freight_final->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->operator->AdvancedSearch->issetSession())
			return TRUE;
		if ($this->datetime->AdvancedSearch->issetSession())
			return TRUE;
		return FALSE;
	}

	// Clear all search parameters
	protected function resetSearchParms()
	{

		// Clear search WHERE clause
		$this->SearchWhere = "";
		$this->setSearchWhere($this->SearchWhere);

		// Clear basic search parameters
		$this->resetBasicSearchParms();

		// Clear advanced search parameters
		$this->resetAdvancedSearchParms();
	}

	// Load advanced search default values
	protected function loadAdvancedSearchDefault()
	{
		return FALSE;
	}

	// Clear all basic search parameters
	protected function resetBasicSearchParms()
	{
		$this->BasicSearch->unsetSession();
	}

	// Clear all advanced search parameters
	protected function resetAdvancedSearchParms()
	{
		$this->id->AdvancedSearch->unsetSession();
		$this->vehicle_type->AdvancedSearch->unsetSession();
		$this->vehicle->AdvancedSearch->unsetSession();
		$this->_route->AdvancedSearch->unsetSession();
		$this->route_name->AdvancedSearch->unsetSession();
		$this->reports_to->AdvancedSearch->unsetSession();
		$this->buyer->AdvancedSearch->unsetSession();
		$this->b_consignor->AdvancedSearch->unsetSession();
		$this->b_consignee->AdvancedSearch->unsetSession();
		$this->load_date->AdvancedSearch->unsetSession();
		$this->load_weight->AdvancedSearch->unsetSession();
		$this->unload_date->AdvancedSearch->unsetSession();
		$this->unload_weight->AdvancedSearch->unsetSession();
		$this->invoice_no->AdvancedSearch->unsetSession();
		$this->invoice_date->AdvancedSearch->unsetSession();
		$this->amount->AdvancedSearch->unsetSession();
		$this->delivery_pod->AdvancedSearch->unsetSession();
		$this->status->AdvancedSearch->unsetSession();
		$this->days->AdvancedSearch->unsetSession();
		$this->driver->AdvancedSearch->unsetSession();
		$this->driver_name->AdvancedSearch->unsetSession();
		$this->agent->AdvancedSearch->unsetSession();
		$this->comm->AdvancedSearch->unsetSession();
		$this->material->AdvancedSearch->unsetSession();
		$this->packing_type->AdvancedSearch->unsetSession();
		$this->m_hsn->AdvancedSearch->unsetSession();
		$this->_40->AdvancedSearch->unsetSession();
		$this->lr_no->AdvancedSearch->unsetSession();
		$this->km->AdvancedSearch->unsetSession();
		$this->freight_type->AdvancedSearch->unsetSession();
		$this->freight->AdvancedSearch->unsetSession();
		$this->ded_det->AdvancedSearch->unsetSession();
		$this->ded_det_remarks->AdvancedSearch->unsetSession();
		$this->gst_percent->AdvancedSearch->unsetSession();
		$this->gst_amount->AdvancedSearch->unsetSession();
		$this->final_amount->AdvancedSearch->unsetSession();
		$this->load_km->AdvancedSearch->unsetSession();
		$this->unload_km->AdvancedSearch->unsetSession();
		$this->delivery_receipt->AdvancedSearch->unsetSession();
		$this->delivery_docket->AdvancedSearch->unsetSession();
		$this->diesal_op_b->AdvancedSearch->unsetSession();
		$this->diesal_required->AdvancedSearch->unsetSession();
		$this->diesal_fill->AdvancedSearch->unsetSession();
		$this->diesal_amount->AdvancedSearch->unsetSession();
		$this->diesal_cl_balance->AdvancedSearch->unsetSession();
		$this->vehicle_average->AdvancedSearch->unsetSession();
		$this->cash_required->AdvancedSearch->unsetSession();
		$this->cash_op_b->AdvancedSearch->unsetSession();
		$this->cash_paid->AdvancedSearch->unsetSession();
		$this->cash_expenses->AdvancedSearch->unsetSession();
		$this->cash_cl_balance->AdvancedSearch->unsetSession();
		$this->fasttag_op_b->AdvancedSearch->unsetSession();
		$this->fasttag_recharge->AdvancedSearch->unsetSession();
		$this->fasttag_expenses->AdvancedSearch->unsetSession();
		$this->toll_expenses_cash->AdvancedSearch->unsetSession();
		$this->fasttag_cl_balance->AdvancedSearch->unsetSession();
		$this->remarks->AdvancedSearch->unsetSession();
		$this->uploads->AdvancedSearch->unsetSession();
		$this->consignor->AdvancedSearch->unsetSession();
		$this->vehicle_freight_comm->AdvancedSearch->unsetSession();
		$this->vehicle_freight_type->AdvancedSearch->unsetSession();
		$this->vehicle_freight_amount->AdvancedSearch->unsetSession();
		$this->vehicle_freight_final->AdvancedSearch->unsetSession();
		$this->operator->AdvancedSearch->unsetSession();
		$this->datetime->AdvancedSearch->unsetSession();
	}

	// Restore all search parameters
	protected function restoreSearchParms()
	{
		$this->RestoreSearch = TRUE;

		// Restore basic search values
		$this->BasicSearch->load();

		// Restore advanced search values
		$this->id->AdvancedSearch->load();
		$this->vehicle_type->AdvancedSearch->load();
		$this->vehicle->AdvancedSearch->load();
		$this->_route->AdvancedSearch->load();
		$this->route_name->AdvancedSearch->load();
		$this->reports_to->AdvancedSearch->load();
		$this->buyer->AdvancedSearch->load();
		$this->b_consignor->AdvancedSearch->load();
		$this->b_consignee->AdvancedSearch->load();
		$this->load_date->AdvancedSearch->load();
		$this->load_weight->AdvancedSearch->load();
		$this->unload_date->AdvancedSearch->load();
		$this->unload_weight->AdvancedSearch->load();
		$this->invoice_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->delivery_pod->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->days->AdvancedSearch->load();
		$this->driver->AdvancedSearch->load();
		$this->driver_name->AdvancedSearch->load();
		$this->agent->AdvancedSearch->load();
		$this->comm->AdvancedSearch->load();
		$this->material->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->m_hsn->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->lr_no->AdvancedSearch->load();
		$this->km->AdvancedSearch->load();
		$this->freight_type->AdvancedSearch->load();
		$this->freight->AdvancedSearch->load();
		$this->ded_det->AdvancedSearch->load();
		$this->ded_det_remarks->AdvancedSearch->load();
		$this->gst_percent->AdvancedSearch->load();
		$this->gst_amount->AdvancedSearch->load();
		$this->final_amount->AdvancedSearch->load();
		$this->load_km->AdvancedSearch->load();
		$this->unload_km->AdvancedSearch->load();
		$this->delivery_receipt->AdvancedSearch->load();
		$this->delivery_docket->AdvancedSearch->load();
		$this->diesal_op_b->AdvancedSearch->load();
		$this->diesal_required->AdvancedSearch->load();
		$this->diesal_fill->AdvancedSearch->load();
		$this->diesal_amount->AdvancedSearch->load();
		$this->diesal_cl_balance->AdvancedSearch->load();
		$this->vehicle_average->AdvancedSearch->load();
		$this->cash_required->AdvancedSearch->load();
		$this->cash_op_b->AdvancedSearch->load();
		$this->cash_paid->AdvancedSearch->load();
		$this->cash_expenses->AdvancedSearch->load();
		$this->cash_cl_balance->AdvancedSearch->load();
		$this->fasttag_op_b->AdvancedSearch->load();
		$this->fasttag_recharge->AdvancedSearch->load();
		$this->fasttag_expenses->AdvancedSearch->load();
		$this->toll_expenses_cash->AdvancedSearch->load();
		$this->fasttag_cl_balance->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->uploads->AdvancedSearch->load();
		$this->consignor->AdvancedSearch->load();
		$this->vehicle_freight_comm->AdvancedSearch->load();
		$this->vehicle_freight_type->AdvancedSearch->load();
		$this->vehicle_freight_amount->AdvancedSearch->load();
		$this->vehicle_freight_final->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Set up sort parameters
	protected function setupSortOrder()
	{

		// Check for Ctrl pressed
		$ctrl = Get("ctrl") !== NULL;

		// Check for "order" parameter
		if (Get("order") !== NULL) {
			$this->CurrentOrder = Get("order");
			$this->CurrentOrderType = Get("ordertype", "");
			$this->updateSort($this->id, $ctrl); // id
			$this->updateSort($this->vehicle_type, $ctrl); // vehicle_type
			$this->updateSort($this->vehicle, $ctrl); // vehicle
			$this->updateSort($this->route_name, $ctrl); // route_name
			$this->updateSort($this->reports_to, $ctrl); // reports_to
			$this->updateSort($this->buyer, $ctrl); // buyer
			$this->updateSort($this->b_consignor, $ctrl); // b_consignor
			$this->updateSort($this->b_consignee, $ctrl); // b_consignee
			$this->updateSort($this->load_date, $ctrl); // load_date
			$this->updateSort($this->load_weight, $ctrl); // load_weight
			$this->updateSort($this->unload_date, $ctrl); // unload_date
			$this->updateSort($this->unload_weight, $ctrl); // unload_weight
			$this->updateSort($this->invoice_no, $ctrl); // invoice_no
			$this->updateSort($this->invoice_date, $ctrl); // invoice_date
			$this->updateSort($this->amount, $ctrl); // amount
			$this->updateSort($this->delivery_pod, $ctrl); // delivery_pod
			$this->updateSort($this->status, $ctrl); // status
			$this->updateSort($this->days, $ctrl); // days
			$this->updateSort($this->driver, $ctrl); // driver
			$this->updateSort($this->driver_name, $ctrl); // driver_name
			$this->updateSort($this->agent, $ctrl); // agent
			$this->updateSort($this->comm, $ctrl); // comm
			$this->updateSort($this->material, $ctrl); // material
			$this->updateSort($this->packing_type, $ctrl); // packing_type
			$this->updateSort($this->m_hsn, $ctrl); // m_hsn
			$this->updateSort($this->_40, $ctrl); // @
			$this->updateSort($this->lr_no, $ctrl); // lr_no
			$this->updateSort($this->km, $ctrl); // km
			$this->updateSort($this->freight_type, $ctrl); // freight_type
			$this->updateSort($this->freight, $ctrl); // freight
			$this->updateSort($this->ded_det, $ctrl); // ded_det
			$this->updateSort($this->ded_det_remarks, $ctrl); // ded_det_remarks
			$this->updateSort($this->gst_percent, $ctrl); // gst_percent
			$this->updateSort($this->gst_amount, $ctrl); // gst_amount
			$this->updateSort($this->final_amount, $ctrl); // final_amount
			$this->updateSort($this->load_km, $ctrl); // load_km
			$this->updateSort($this->unload_km, $ctrl); // unload_km
			$this->updateSort($this->delivery_receipt, $ctrl); // delivery_receipt
			$this->updateSort($this->delivery_docket, $ctrl); // delivery_docket
			$this->updateSort($this->diesal_op_b, $ctrl); // diesal_op_b
			$this->updateSort($this->diesal_required, $ctrl); // diesal_required
			$this->updateSort($this->diesal_fill, $ctrl); // diesal_fill
			$this->updateSort($this->diesal_amount, $ctrl); // diesal_amount
			$this->updateSort($this->diesal_cl_balance, $ctrl); // diesal_cl_balance
			$this->updateSort($this->vehicle_average, $ctrl); // vehicle_average
			$this->updateSort($this->cash_required, $ctrl); // cash_required
			$this->updateSort($this->cash_op_b, $ctrl); // cash_op_b
			$this->updateSort($this->cash_paid, $ctrl); // cash_paid
			$this->updateSort($this->cash_expenses, $ctrl); // cash_expenses
			$this->updateSort($this->cash_cl_balance, $ctrl); // cash_cl_balance
			$this->updateSort($this->fasttag_op_b, $ctrl); // fasttag_op_b
			$this->updateSort($this->fasttag_recharge, $ctrl); // fasttag_recharge
			$this->updateSort($this->fasttag_expenses, $ctrl); // fasttag_expenses
			$this->updateSort($this->toll_expenses_cash, $ctrl); // toll_expenses_cash
			$this->updateSort($this->fasttag_cl_balance, $ctrl); // fasttag_cl_balance
			$this->updateSort($this->consignor, $ctrl); // consignor
			$this->updateSort($this->vehicle_freight_comm, $ctrl); // vehicle_freight_comm
			$this->updateSort($this->vehicle_freight_type, $ctrl); // vehicle_freight_type
			$this->updateSort($this->vehicle_freight_amount, $ctrl); // vehicle_freight_amount
			$this->updateSort($this->vehicle_freight_final, $ctrl); // vehicle_freight_final
			$this->updateSort($this->datetime, $ctrl); // datetime
			$this->setStartRecordNumber(1); // Reset start position
		}
	}

	// Load sort order parameters
	protected function loadSortOrder()
	{
		$orderBy = $this->getSessionOrderBy(); // Get ORDER BY from Session
		if ($orderBy == "") {
			if ($this->getSqlOrderBy() <> "") {
				$orderBy = $this->getSqlOrderBy();
				$this->setSessionOrderBy($orderBy);
				$this->id->setSort("DESC");
			}
		}
	}

	// Reset command
	// - cmd=reset (Reset search parameters)
	// - cmd=resetall (Reset search and master/detail parameters)
	// - cmd=resetsort (Reset sort parameters)

	protected function resetCmd()
	{

		// Check if reset command
		if (substr($this->Command,0,5) == "reset") {

			// Reset search criteria
			if ($this->Command == "reset" || $this->Command == "resetall")
				$this->resetSearchParms();

			// Reset sorting order
			if ($this->Command == "resetsort") {
				$orderBy = "";
				$this->setSessionOrderBy($orderBy);
				$this->setSessionOrderByList($orderBy);
				$this->id->setSort("");
				$this->vehicle_type->setSort("");
				$this->vehicle->setSort("");
				$this->route_name->setSort("");
				$this->reports_to->setSort("");
				$this->buyer->setSort("");
				$this->b_consignor->setSort("");
				$this->b_consignee->setSort("");
				$this->load_date->setSort("");
				$this->load_weight->setSort("");
				$this->unload_date->setSort("");
				$this->unload_weight->setSort("");
				$this->invoice_no->setSort("");
				$this->invoice_date->setSort("");
				$this->amount->setSort("");
				$this->delivery_pod->setSort("");
				$this->status->setSort("");
				$this->days->setSort("");
				$this->driver->setSort("");
				$this->driver_name->setSort("");
				$this->agent->setSort("");
				$this->comm->setSort("");
				$this->material->setSort("");
				$this->packing_type->setSort("");
				$this->m_hsn->setSort("");
				$this->_40->setSort("");
				$this->lr_no->setSort("");
				$this->km->setSort("");
				$this->freight_type->setSort("");
				$this->freight->setSort("");
				$this->ded_det->setSort("");
				$this->ded_det_remarks->setSort("");
				$this->gst_percent->setSort("");
				$this->gst_amount->setSort("");
				$this->final_amount->setSort("");
				$this->load_km->setSort("");
				$this->unload_km->setSort("");
				$this->delivery_receipt->setSort("");
				$this->delivery_docket->setSort("");
				$this->diesal_op_b->setSort("");
				$this->diesal_required->setSort("");
				$this->diesal_fill->setSort("");
				$this->diesal_amount->setSort("");
				$this->diesal_cl_balance->setSort("");
				$this->vehicle_average->setSort("");
				$this->cash_required->setSort("");
				$this->cash_op_b->setSort("");
				$this->cash_paid->setSort("");
				$this->cash_expenses->setSort("");
				$this->cash_cl_balance->setSort("");
				$this->fasttag_op_b->setSort("");
				$this->fasttag_recharge->setSort("");
				$this->fasttag_expenses->setSort("");
				$this->toll_expenses_cash->setSort("");
				$this->fasttag_cl_balance->setSort("");
				$this->consignor->setSort("");
				$this->vehicle_freight_comm->setSort("");
				$this->vehicle_freight_type->setSort("");
				$this->vehicle_freight_amount->setSort("");
				$this->vehicle_freight_final->setSort("");
				$this->datetime->setSort("");
			}

			// Reset start position
			$this->StartRec = 1;
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Set up list options
	protected function setupListOptions()
	{
		global $Security, $Language;

		// Add group option item
		$item = &$this->ListOptions->add($this->ListOptions->GroupOptionName);
		$item->Body = "";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;

		// "view"
		$item = &$this->ListOptions->add("view");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canView();
		$item->OnLeft = TRUE;

		// "edit"
		$item = &$this->ListOptions->add("edit");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->canEdit();
		$item->OnLeft = TRUE;

		// "detail_t_expenses_o"
		$item = &$this->ListOptions->add("detail_t_expenses_o");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->allowList(CurrentProjectID() . 't_expenses_o') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["t_expenses_o_grid"]))
			$GLOBALS["t_expenses_o_grid"] = new t_expenses_o_grid();

		// "detail_t_receipt_d"
		$item = &$this->ListOptions->add("detail_t_receipt_d");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->allowList(CurrentProjectID() . 't_receipt_d') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["t_receipt_d_grid"]))
			$GLOBALS["t_receipt_d_grid"] = new t_receipt_d_grid();

		// "detail_t_diesal_expenses"
		$item = &$this->ListOptions->add("detail_t_diesal_expenses");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->allowList(CurrentProjectID() . 't_diesal_expenses') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["t_diesal_expenses_grid"]))
			$GLOBALS["t_diesal_expenses_grid"] = new t_diesal_expenses_grid();

		// "detail_t_route_info"
		$item = &$this->ListOptions->add("detail_t_route_info");
		$item->CssClass = "text-nowrap";
		$item->Visible = $Security->allowList(CurrentProjectID() . 't_route_info') && !$this->ShowMultipleDetails;
		$item->OnLeft = TRUE;
		$item->ShowInButtonGroup = FALSE;
		if (!isset($GLOBALS["t_route_info_grid"]))
			$GLOBALS["t_route_info_grid"] = new t_route_info_grid();

		// Multiple details
		if ($this->ShowMultipleDetails) {
			$item = &$this->ListOptions->add("details");
			$item->CssClass = "text-nowrap";
			$item->Visible = $this->ShowMultipleDetails;
			$item->OnLeft = TRUE;
			$item->ShowInButtonGroup = FALSE;
		}

		// Set up detail pages
		$pages = new SubPages();
		$pages->add("t_expenses_o");
		$pages->add("t_receipt_d");
		$pages->add("t_diesal_expenses");
		$pages->add("t_route_info");
		$this->DetailPages = $pages;

		// List actions
		$item = &$this->ListOptions->add("listactions");
		$item->CssClass = "text-nowrap";
		$item->OnLeft = TRUE;
		$item->Visible = FALSE;
		$item->ShowInButtonGroup = FALSE;
		$item->ShowInDropDown = FALSE;

		// "checkbox"
		$item = &$this->ListOptions->add("checkbox");
		$item->Visible = FALSE;
		$item->OnLeft = TRUE;
		$item->Header = "<input type=\"checkbox\" name=\"key\" id=\"key\" onclick=\"ew.selectAllKey(this);\">";
		$item->moveTo(0);
		$item->ShowInDropDown = FALSE;
		$item->ShowInButtonGroup = FALSE;

		// Drop down button for ListOptions
		$this->ListOptions->UseDropDownButton = FALSE;
		$this->ListOptions->DropDownButtonPhrase = $Language->phrase("ButtonListOptions");
		$this->ListOptions->UseButtonGroup = TRUE;
		if ($this->ListOptions->UseButtonGroup && IsMobile())
			$this->ListOptions->UseDropDownButton = TRUE;

		//$this->ListOptions->ButtonClass = ""; // Class for button group
		// Call ListOptions_Load event

		$this->ListOptions_Load();
		$this->setupListOptionsExt();
		$item = &$this->ListOptions->getItem($this->ListOptions->GroupOptionName);
		$item->Visible = $this->ListOptions->groupOptionVisible();
	}

	// Render list options
	public function renderListOptions()
	{
		global $Security, $Language, $CurrentForm;
		$this->ListOptions->loadDefault();

		// Call ListOptions_Rendering event
		$this->ListOptions_Rendering();

		// "view"
		$opt = &$this->ListOptions->Items["view"];
		$viewcaption = HtmlTitle($Language->phrase("ViewLink"));
		if ($Security->canView()) {
			$opt->Body = "<a class=\"ew-row-link ew-view\" title=\"" . $viewcaption . "\" data-caption=\"" . $viewcaption . "\" href=\"" . HtmlEncode($this->ViewUrl) . "\">" . $Language->phrase("ViewLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// "edit"
		$opt = &$this->ListOptions->Items["edit"];
		$editcaption = HtmlTitle($Language->phrase("EditLink"));
		if ($Security->canEdit()) {
			$opt->Body = "<a class=\"ew-row-link ew-edit\" title=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" data-caption=\"" . HtmlTitle($Language->phrase("EditLink")) . "\" href=\"" . HtmlEncode($this->EditUrl) . "\">" . $Language->phrase("EditLink") . "</a>";
		} else {
			$opt->Body = "";
		}

		// Set up list action buttons
		$opt = &$this->ListOptions->getItem("listactions");
		if ($opt && !$this->isExport() && !$this->CurrentAction) {
			$body = "";
			$links = array();
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_SINGLE && $listaction->Allow) {
					$action = $listaction->Action;
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode(str_replace(" ew-icon", "", $listaction->Icon)) . "\" data-caption=\"" . HtmlTitle($caption) . "\"></i> " : "";
					$links[] = "<li><a class=\"dropdown-item ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . $listaction->Caption . "</a></li>";
					if (count($links) == 1) // Single button
						$body = "<a class=\"ew-action ew-list-action\" data-action=\"" . HtmlEncode($action) . "\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({key:" . $this->keyToJson(TRUE) . "}," . $listaction->toJson(TRUE) . "));return false;\">" . $Language->phrase("ListActionButton") . "</a>";
				}
			}
			if (count($links) > 1) { // More than one buttons, use dropdown
				$body = "<button class=\"dropdown-toggle btn btn-default ew-actions\" title=\"" . HtmlTitle($Language->phrase("ListActionButton")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("ListActionButton") . "</button>";
				$content = "";
				foreach ($links as $link)
					$content .= "<li>" . $link . "</li>";
				$body .= "<ul class=\"dropdown-menu" . ($opt->OnLeft ? "" : " dropdown-menu-right") . "\">". $content . "</ul>";
				$body = "<div class=\"btn-group btn-group-sm\">" . $body . "</div>";
			}
			if (count($links) > 0) {
				$opt->Body = $body;
				$opt->Visible = TRUE;
			}
		}
		$detailViewTblVar = "";
		$detailCopyTblVar = "";
		$detailEditTblVar = "";

		// "detail_t_expenses_o"
		$opt = &$this->ListOptions->Items["detail_t_expenses_o"];
		if ($Security->allowList(CurrentProjectID() . 't_expenses_o')) {
			$body = $Language->phrase("DetailLink") . $Language->TablePhrase("t_expenses_o", "TblCaption");
			$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("t_expenses_olist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["t_expenses_o_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_expenses_o')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(TABLE_SHOW_DETAIL . "=t_expenses_o");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailViewTblVar <> "")
					$detailViewTblVar .= ",";
				$detailViewTblVar .= "t_expenses_o";
			}
			if ($GLOBALS["t_expenses_o_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_expenses_o')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(TABLE_SHOW_DETAIL . "=t_expenses_o");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailEditTblVar <> "")
					$detailEditTblVar .= ",";
				$detailEditTblVar .= "t_expenses_o";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
			$opt->Body = $body;
			if ($this->ShowMultipleDetails)
				$opt->Visible = FALSE;
		}

		// "detail_t_receipt_d"
		$opt = &$this->ListOptions->Items["detail_t_receipt_d"];
		if ($Security->allowList(CurrentProjectID() . 't_receipt_d')) {
			$body = $Language->phrase("DetailLink") . $Language->TablePhrase("t_receipt_d", "TblCaption");
			$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("t_receipt_dlist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["t_receipt_d_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_receipt_d')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(TABLE_SHOW_DETAIL . "=t_receipt_d");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailViewTblVar <> "")
					$detailViewTblVar .= ",";
				$detailViewTblVar .= "t_receipt_d";
			}
			if ($GLOBALS["t_receipt_d_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_receipt_d')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(TABLE_SHOW_DETAIL . "=t_receipt_d");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailEditTblVar <> "")
					$detailEditTblVar .= ",";
				$detailEditTblVar .= "t_receipt_d";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
			$opt->Body = $body;
			if ($this->ShowMultipleDetails)
				$opt->Visible = FALSE;
		}

		// "detail_t_diesal_expenses"
		$opt = &$this->ListOptions->Items["detail_t_diesal_expenses"];
		if ($Security->allowList(CurrentProjectID() . 't_diesal_expenses')) {
			$body = $Language->phrase("DetailLink") . $Language->TablePhrase("t_diesal_expenses", "TblCaption");
			$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("t_diesal_expenseslist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["t_diesal_expenses_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_diesal_expenses')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(TABLE_SHOW_DETAIL . "=t_diesal_expenses");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailViewTblVar <> "")
					$detailViewTblVar .= ",";
				$detailViewTblVar .= "t_diesal_expenses";
			}
			if ($GLOBALS["t_diesal_expenses_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_diesal_expenses')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(TABLE_SHOW_DETAIL . "=t_diesal_expenses");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailEditTblVar <> "")
					$detailEditTblVar .= ",";
				$detailEditTblVar .= "t_diesal_expenses";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
			$opt->Body = $body;
			if ($this->ShowMultipleDetails)
				$opt->Visible = FALSE;
		}

		// "detail_t_route_info"
		$opt = &$this->ListOptions->Items["detail_t_route_info"];
		if ($Security->allowList(CurrentProjectID() . 't_route_info')) {
			$body = $Language->phrase("DetailLink") . $Language->TablePhrase("t_route_info", "TblCaption");
			$body = "<a class=\"btn btn-default ew-row-link ew-detail\" data-action=\"list\" href=\"" . HtmlEncode("t_route_infolist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk__route=" . urlencode(strval($this->_route->CurrentValue)) . "") . "\">" . $body . "</a>";
			$links = "";
			if ($GLOBALS["t_route_info_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_route_info')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(TABLE_SHOW_DETAIL . "=t_route_info");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailViewTblVar <> "")
					$detailViewTblVar .= ",";
				$detailViewTblVar .= "t_route_info";
			}
			if ($GLOBALS["t_route_info_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_route_info')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(TABLE_SHOW_DETAIL . "=t_route_info");
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . HtmlImageAndText($caption) . "</a></li>";
				if ($detailEditTblVar <> "")
					$detailEditTblVar .= ",";
				$detailEditTblVar .= "t_route_info";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-detail\" data-toggle=\"dropdown\"></button>";
				$body .= "<ul class=\"dropdown-menu\">". $links . "</ul>";
			}
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">" . $body . "</div>";
			$opt->Body = $body;
			if ($this->ShowMultipleDetails)
				$opt->Visible = FALSE;
		}
		if ($this->ShowMultipleDetails) {
			$body = "<div class=\"btn-group btn-group-sm ew-btn-group\">";
			$links = "";
			if ($detailViewTblVar <> "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-view\" data-action=\"view\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailViewLink")) . "\" href=\"" . HtmlEncode($this->getViewUrl(TABLE_SHOW_DETAIL . "=" . $detailViewTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailViewLink")) . "</a></li>";
			}
			if ($detailEditTblVar <> "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-edit\" data-action=\"edit\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailEditLink")) . "\" href=\"" . HtmlEncode($this->getEditUrl(TABLE_SHOW_DETAIL . "=" . $detailEditTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailEditLink")) . "</a></li>";
			}
			if ($detailCopyTblVar <> "") {
				$links .= "<li><a class=\"dropdown-item ew-row-link ew-detail-copy\" data-action=\"add\" data-caption=\"" . HtmlTitle($Language->phrase("MasterDetailCopyLink")) . "\" href=\"" . HtmlEncode($this->GetCopyUrl(TABLE_SHOW_DETAIL . "=" . $detailCopyTblVar)) . "\">" . HtmlImageAndText($Language->phrase("MasterDetailCopyLink")) . "</a></li>";
			}
			if ($links <> "") {
				$body .= "<button class=\"dropdown-toggle btn btn-default ew-master-detail\" title=\"" . HtmlTitle($Language->phrase("MultipleMasterDetails")) . "\" data-toggle=\"dropdown\">" . $Language->phrase("MultipleMasterDetails") . "</button>";
				$body .= "<ul class=\"dropdown-menu ew-menu\">". $links . "</ul>";
			}
			$body .= "</div>";

			// Multiple details
			$opt = &$this->ListOptions->Items["details"];
			$opt->Body = $body;
		}

		// "checkbox"
		$opt = &$this->ListOptions->Items["checkbox"];
		$opt->Body = "<input type=\"checkbox\" name=\"key_m[]\" class=\"ew-multi-select\" value=\"" . HtmlEncode($this->id->CurrentValue) . "\" onclick=\"ew.clickMultiCheckbox(event);\">";
		$this->renderListOptionsExt();

		// Call ListOptions_Rendered event
		$this->ListOptions_Rendered();
	}

	// Set up other options
	protected function setupOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
		$option = $options["addedit"];

		// Add
		$item = &$option->add("add");
		$addcaption = HtmlTitle($Language->phrase("AddLink"));
		$item->Body = "<a class=\"ew-add-edit ew-add\" title=\"" . $addcaption . "\" data-caption=\"" . $addcaption . "\" href=\"" . HtmlEncode($this->AddUrl) . "\">" . $Language->phrase("AddLink") . "</a>";
		$item->Visible = ($this->AddUrl <> "" && $Security->canAdd());
		$option = $options["detail"];
		$detailTableLink = "";
		$item = &$option->add("detailadd_t_expenses_o");
		$url = $this->getAddUrl(TABLE_SHOW_DETAIL . "=t_expenses_o");
		$caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $GLOBALS["t_expenses_o"]->tableCaption();
		$item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a>";
		$item->Visible = ($GLOBALS["t_expenses_o"]->DetailAdd && $Security->allowAdd(CurrentProjectID() . 't_expenses_o') && $Security->canAdd());
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "t_expenses_o";
		}
		$item = &$option->add("detailadd_t_receipt_d");
		$url = $this->getAddUrl(TABLE_SHOW_DETAIL . "=t_receipt_d");
		$caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $GLOBALS["t_receipt_d"]->tableCaption();
		$item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a>";
		$item->Visible = ($GLOBALS["t_receipt_d"]->DetailAdd && $Security->allowAdd(CurrentProjectID() . 't_receipt_d') && $Security->canAdd());
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "t_receipt_d";
		}
		$item = &$option->add("detailadd_t_diesal_expenses");
		$url = $this->getAddUrl(TABLE_SHOW_DETAIL . "=t_diesal_expenses");
		$caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $GLOBALS["t_diesal_expenses"]->tableCaption();
		$item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a>";
		$item->Visible = ($GLOBALS["t_diesal_expenses"]->DetailAdd && $Security->allowAdd(CurrentProjectID() . 't_diesal_expenses') && $Security->canAdd());
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "t_diesal_expenses";
		}
		$item = &$option->add("detailadd_t_route_info");
		$url = $this->getAddUrl(TABLE_SHOW_DETAIL . "=t_route_info");
		$caption = $Language->phrase("Add") . "&nbsp;" . $this->tableCaption() . "/" . $GLOBALS["t_route_info"]->tableCaption();
		$item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a>";
		$item->Visible = ($GLOBALS["t_route_info"]->DetailAdd && $Security->allowAdd(CurrentProjectID() . 't_route_info') && $Security->canAdd());
		if ($item->Visible) {
			if ($detailTableLink <> "")
				$detailTableLink .= ",";
			$detailTableLink .= "t_route_info";
		}

		// Add multiple details
		if ($this->ShowMultipleDetails) {
			$item = &$option->add("detailsadd");
			$url = $this->getAddUrl(TABLE_SHOW_DETAIL . "=" . $detailTableLink);
			$caption = $Language->phrase("AddMasterDetailLink");
			$item->Body = "<a class=\"ew-detail-add-group ew-detail-add\" title=\"" . HtmlTitle($caption) . "\" data-caption=\"" . HtmlTitle($caption) . "\" href=\"" . HtmlEncode($url) . "\">" . $caption . "</a>";
			$item->Visible = ($detailTableLink <> "" && $Security->canAdd());

			// Hide single master/detail items
			$ar = explode(",", $detailTableLink);
			$cnt = count($ar);
			for ($i = 0; $i < $cnt; $i++) {
				if ($item = &$option->getItem("detailadd_" . $ar[$i]))
					$item->Visible = FALSE;
			}
		}
		$option = $options["action"];

		// Set up options default
		foreach ($options as &$option) {
			$option->UseDropDownButton = TRUE;
			$option->UseButtonGroup = TRUE;

			//$option->ButtonClass = ""; // Class for button group
			$item = &$option->add($option->GroupOptionName);
			$item->Body = "";
			$item->Visible = FALSE;
		}
		$options["addedit"]->DropDownButtonPhrase = $Language->phrase("ButtonAddEdit");
		$options["detail"]->DropDownButtonPhrase = $Language->phrase("ButtonDetails");
		$options["action"]->DropDownButtonPhrase = $Language->phrase("ButtonActions");

		// Filter button
		$item = &$this->FilterOptions->add("savecurrentfilter");
		$item->Body = "<a class=\"ew-save-filter\" data-form=\"ft_trip_infolistsrch\" href=\"#\">" . $Language->phrase("SaveCurrentFilter") . "</a>";
		$item->Visible = TRUE;
		$item = &$this->FilterOptions->add("deletefilter");
		$item->Body = "<a class=\"ew-delete-filter\" data-form=\"ft_trip_infolistsrch\" href=\"#\">" . $Language->phrase("DeleteFilter") . "</a>";
		$item->Visible = TRUE;
		$this->FilterOptions->UseDropDownButton = TRUE;
		$this->FilterOptions->UseButtonGroup = !$this->FilterOptions->UseDropDownButton;
		$this->FilterOptions->DropDownButtonPhrase = $Language->phrase("Filters");

		// Add group option item
		$item = &$this->FilterOptions->add($this->FilterOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	// Render other options
	public function renderOtherOptions()
	{
		global $Language, $Security;
		$options = &$this->OtherOptions;
			$option = &$options["action"];

			// Set up list action buttons
			foreach ($this->ListActions->Items as $listaction) {
				if ($listaction->Select == ACTION_MULTIPLE) {
					$item = &$option->add("custom_" . $listaction->Action);
					$caption = $listaction->Caption;
					$icon = ($listaction->Icon <> "") ? "<i class=\"" . HtmlEncode($listaction->Icon) . "\" data-caption=\"" . HtmlEncode($caption) . "\"></i> " . $caption : $caption;
					$item->Body = "<a class=\"ew-action ew-list-action\" title=\"" . HtmlEncode($caption) . "\" data-caption=\"" . HtmlEncode($caption) . "\" href=\"\" onclick=\"ew.submitAction(event,jQuery.extend({f:document.ft_trip_infolist}," . $listaction->toJson(TRUE) . "));return false;\">" . $icon . "</a>";
					$item->Visible = $listaction->Allow;
				}
			}

			// Hide grid edit and other options
			if ($this->TotalRecs <= 0) {
				$option = &$options["addedit"];
				$item = &$option->getItem("gridedit");
				if ($item) $item->Visible = FALSE;
				$option = &$options["action"];
				$option->hideAllOptions();
			}
	}

	// Process list action
	protected function processListAction()
	{
		global $Language, $Security;
		$userlist = "";
		$user = "";
		$filter = $this->getFilterFromRecordKeys();
		$userAction = Post("useraction", "");
		if ($filter <> "" && $userAction <> "") {

			// Check permission first
			$actionCaption = $userAction;
			if (array_key_exists($userAction, $this->ListActions->Items)) {
				$actionCaption = $this->ListActions->Items[$userAction]->Caption;
				if (!$this->ListActions->Items[$userAction]->Allow) {
					$errmsg = str_replace('%s', $actionCaption, $Language->phrase("CustomActionNotAllowed"));
					if (Post("ajax") == $userAction) // Ajax
						echo "<p class=\"text-danger\">" . $errmsg . "</p>";
					else
						$this->setFailureMessage($errmsg);
					return FALSE;
				}
			}
			$this->CurrentFilter = $filter;
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			$rs = $conn->execute($sql);
			$conn->raiseErrorFn = '';
			$this->CurrentAction = $userAction;

			// Call row action event
			if ($rs && !$rs->EOF) {
				$conn->beginTrans();
				$this->SelectedCount = $rs->RecordCount();
				$this->SelectedIndex = 0;
				while (!$rs->EOF) {
					$this->SelectedIndex++;
					$row = $rs->fields;
					$processed = $this->Row_CustomAction($userAction, $row);
					if (!$processed)
						break;
					$rs->moveNext();
				}
				if ($processed) {
					$conn->commitTrans(); // Commit the changes
					if ($this->getSuccessMessage() == "" && !ob_get_length()) // No output
						$this->setSuccessMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionCompleted"))); // Set up success message
				} else {
					$conn->rollbackTrans(); // Rollback changes

					// Set up error message
					if ($this->getSuccessMessage() <> "" || $this->getFailureMessage() <> "") {

						// Use the message, do nothing
					} elseif ($this->CancelMessage <> "") {
						$this->setFailureMessage($this->CancelMessage);
						$this->CancelMessage = "";
					} else {
						$this->setFailureMessage(str_replace('%s', $actionCaption, $Language->phrase("CustomActionFailed")));
					}
				}
			}
			if ($rs)
				$rs->close();
			$this->CurrentAction = ""; // Clear action
			if (Post("ajax") == $userAction) { // Ajax
				if ($this->getSuccessMessage() <> "") {
					echo "<p class=\"text-success\">" . $this->getSuccessMessage() . "</p>";
					$this->clearSuccessMessage(); // Clear message
				}
				if ($this->getFailureMessage() <> "") {
					echo "<p class=\"text-danger\">" . $this->getFailureMessage() . "</p>";
					$this->clearFailureMessage(); // Clear message
				}
				return TRUE;
			}
		}
		return FALSE; // Not ajax request
	}

	// Set up search options
	protected function setupSearchOptions()
	{
		global $Language;
		$this->SearchOptions = new ListOptions();
		$this->SearchOptions->Tag = "div";
		$this->SearchOptions->TagClassName = "ew-search-option";

		// Search button
		$item = &$this->SearchOptions->add("searchtoggle");
		$searchToggleClass = ($this->SearchWhere <> "") ? " active" : "";
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-search-toggle" . $searchToggleClass . "\" title=\"" . $Language->phrase("SearchPanel") . "\" data-caption=\"" . $Language->phrase("SearchPanel") . "\" data-toggle=\"button\" data-form=\"ft_trip_infolistsrch\">" . $Language->phrase("SearchLink") . "</button>";
		$item->Visible = TRUE;

		// Show all button
		$item = &$this->SearchOptions->add("showall");
		$item->Body = "<a class=\"btn btn-default ew-show-all\" title=\"" . $Language->phrase("ShowAll") . "\" data-caption=\"" . $Language->phrase("ShowAll") . "\" href=\"" . $this->pageUrl() . "cmd=reset\">" . $Language->phrase("ShowAllBtn") . "</a>";
		$item->Visible = ($this->SearchWhere <> $this->DefaultSearchWhere && $this->SearchWhere <> "0=101");

		// Advanced search button
		$item = &$this->SearchOptions->add("advancedsearch");
		if (IsMobile())
			$item->Body = "<a class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" href=\"t_trip_infosrch.php\">" . $Language->phrase("AdvancedSearchBtn") . "</a>";
		else
			$item->Body = "<button type=\"button\" class=\"btn btn-default ew-advanced-search\" title=\"" . $Language->phrase("AdvancedSearch") . "\" data-table=\"t_trip_info\" data-caption=\"" . $Language->phrase("AdvancedSearch") . "\" onclick=\"ew.modalDialogShow({lnk:this,btn:'SearchBtn',url:'t_trip_infosrch.php'});\">" . $Language->phrase("AdvancedSearchBtn") . "</button>";
		$item->Visible = TRUE;

		// Search highlight button
		$item = &$this->SearchOptions->add("searchhighlight");
		$item->Body = "<button type=\"button\" class=\"btn btn-default ew-highlight active\" title=\"" . $Language->phrase("Highlight") . "\" data-caption=\"" . $Language->phrase("Highlight") . "\" data-toggle=\"button\" data-form=\"ft_trip_infolistsrch\" data-name=\"" . $this->highlightName() . "\">" . $Language->phrase("HighlightBtn") . "</button>";
		$item->Visible = ($this->SearchWhere <> "" && $this->TotalRecs > 0);

		// Button group for search
		$this->SearchOptions->UseDropDownButton = FALSE;
		$this->SearchOptions->UseButtonGroup = TRUE;
		$this->SearchOptions->DropDownButtonPhrase = $Language->phrase("ButtonSearch");

		// Add group option item
		$item = &$this->SearchOptions->add($this->SearchOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;

		// Hide search options
		if ($this->isExport() || $this->CurrentAction)
			$this->SearchOptions->hideAllOptions();
		global $Security;
		if (!$Security->canSearch()) {
			$this->SearchOptions->hideAllOptions();
			$this->FilterOptions->hideAllOptions();
		}
	}
	protected function setupListOptionsExt()
	{
		global $Security, $Language;

		// Hide detail items for dropdown if necessary
		$this->ListOptions->hideDetailItemsForDropDown();
	}
	protected function renderListOptionsExt()
	{
		global $Security, $Language;
		$links = "";
		$btngrps = "";
		$sqlwrk = "`trip`=" . AdjustSql($this->id->CurrentValue, $this->Dbid) . "";

		// Column "detail_t_expenses_o"
		if ($this->DetailPages->Items["t_expenses_o"]->Visible) {
			$link = "";
			$option = &$this->ListOptions->Items["detail_t_expenses_o"];
			$url = "t_expenses_opreview.php?t=t_trip_info&f=" . Encrypt($sqlwrk);
			$btngrp = "<div data-table=\"t_expenses_o\" data-url=\"" . $url . "\" class=\"btn-group btn-group-sm\">";
			if ($Security->allowList(CurrentProjectID() . 't_expenses_o')) {
				$label = $Language->TablePhrase("t_expenses_o", "TblCaption");
				$link = "<li class=\"nav-item\"><a href=\"#\" class=\"nav-link\" data-toggle=\"tab\" data-table=\"t_expenses_o\" data-url=\"" . $url . "\">" . $label . "</a></li>";
				$links .= $link;
				$detaillnk = JsEncodeAttribute("t_expenses_olist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . $Language->TablePhrase("t_expenses_o", "TblCaption") . "\" onclick=\"window.location='" . $detaillnk . "'\">" . $Language->phrase("MasterDetailListLink") . "</button>";
			}
			if (!isset($GLOBALS["t_expenses_o_grid"]))
				$GLOBALS["t_expenses_o_grid"] = new t_expenses_o_grid();
			if ($GLOBALS["t_expenses_o_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_expenses_o')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(TABLE_SHOW_DETAIL . "=t_expenses_o");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" onclick=\"window.location='" . HtmlEncode($url) . "'\">" . $caption . "</button>";
			}
			if ($GLOBALS["t_expenses_o_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_expenses_o')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(TABLE_SHOW_DETAIL . "=t_expenses_o");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" onclick=\"window.location='" . HtmlEncode($url) . "'\">" . $caption . "</button>";
			}
			$btngrp .= "</div>";
			if ($link <> "") {
				$btngrps .= $btngrp;
				$option->Body .= "<div class=\"d-none ew-preview\">" . $link . $btngrp . "</div>";
			}
		}
		$sqlwrk = "`trip`=" . AdjustSql($this->id->CurrentValue, $this->Dbid) . "";

		// Column "detail_t_receipt_d"
		if ($this->DetailPages->Items["t_receipt_d"]->Visible) {
			$link = "";
			$option = &$this->ListOptions->Items["detail_t_receipt_d"];
			$url = "t_receipt_dpreview.php?t=t_trip_info&f=" . Encrypt($sqlwrk);
			$btngrp = "<div data-table=\"t_receipt_d\" data-url=\"" . $url . "\" class=\"btn-group btn-group-sm\">";
			if ($Security->allowList(CurrentProjectID() . 't_receipt_d')) {
				$label = $Language->TablePhrase("t_receipt_d", "TblCaption");
				$link = "<li class=\"nav-item\"><a href=\"#\" class=\"nav-link\" data-toggle=\"tab\" data-table=\"t_receipt_d\" data-url=\"" . $url . "\">" . $label . "</a></li>";
				$links .= $link;
				$detaillnk = JsEncodeAttribute("t_receipt_dlist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . $Language->TablePhrase("t_receipt_d", "TblCaption") . "\" onclick=\"window.location='" . $detaillnk . "'\">" . $Language->phrase("MasterDetailListLink") . "</button>";
			}
			if (!isset($GLOBALS["t_receipt_d_grid"]))
				$GLOBALS["t_receipt_d_grid"] = new t_receipt_d_grid();
			if ($GLOBALS["t_receipt_d_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_receipt_d')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(TABLE_SHOW_DETAIL . "=t_receipt_d");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" onclick=\"window.location='" . HtmlEncode($url) . "'\">" . $caption . "</button>";
			}
			if ($GLOBALS["t_receipt_d_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_receipt_d')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(TABLE_SHOW_DETAIL . "=t_receipt_d");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" onclick=\"window.location='" . HtmlEncode($url) . "'\">" . $caption . "</button>";
			}
			$btngrp .= "</div>";
			if ($link <> "") {
				$btngrps .= $btngrp;
				$option->Body .= "<div class=\"d-none ew-preview\">" . $link . $btngrp . "</div>";
			}
		}
		$sqlwrk = "`trip`=" . AdjustSql($this->id->CurrentValue, $this->Dbid) . "";

		// Column "detail_t_diesal_expenses"
		if ($this->DetailPages->Items["t_diesal_expenses"]->Visible) {
			$link = "";
			$option = &$this->ListOptions->Items["detail_t_diesal_expenses"];
			$url = "t_diesal_expensespreview.php?t=t_trip_info&f=" . Encrypt($sqlwrk);
			$btngrp = "<div data-table=\"t_diesal_expenses\" data-url=\"" . $url . "\" class=\"btn-group btn-group-sm\">";
			if ($Security->allowList(CurrentProjectID() . 't_diesal_expenses')) {
				$label = $Language->TablePhrase("t_diesal_expenses", "TblCaption");
				$link = "<li class=\"nav-item\"><a href=\"#\" class=\"nav-link\" data-toggle=\"tab\" data-table=\"t_diesal_expenses\" data-url=\"" . $url . "\">" . $label . "</a></li>";
				$links .= $link;
				$detaillnk = JsEncodeAttribute("t_diesal_expenseslist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk_id=" . urlencode(strval($this->id->CurrentValue)) . "");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . $Language->TablePhrase("t_diesal_expenses", "TblCaption") . "\" onclick=\"window.location='" . $detaillnk . "'\">" . $Language->phrase("MasterDetailListLink") . "</button>";
			}
			if (!isset($GLOBALS["t_diesal_expenses_grid"]))
				$GLOBALS["t_diesal_expenses_grid"] = new t_diesal_expenses_grid();
			if ($GLOBALS["t_diesal_expenses_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_diesal_expenses')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(TABLE_SHOW_DETAIL . "=t_diesal_expenses");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" onclick=\"window.location='" . HtmlEncode($url) . "'\">" . $caption . "</button>";
			}
			if ($GLOBALS["t_diesal_expenses_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_diesal_expenses')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(TABLE_SHOW_DETAIL . "=t_diesal_expenses");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" onclick=\"window.location='" . HtmlEncode($url) . "'\">" . $caption . "</button>";
			}
			$btngrp .= "</div>";
			if ($link <> "") {
				$btngrps .= $btngrp;
				$option->Body .= "<div class=\"d-none ew-preview\">" . $link . $btngrp . "</div>";
			}
		}
		$sqlwrk = "`id`=" . AdjustSql($this->_route->CurrentValue, $this->Dbid) . "";

		// Column "detail_t_route_info"
		if ($this->DetailPages->Items["t_route_info"]->Visible) {
			$link = "";
			$option = &$this->ListOptions->Items["detail_t_route_info"];
			$url = "t_route_infopreview.php?t=t_trip_info&f=" . Encrypt($sqlwrk);
			$btngrp = "<div data-table=\"t_route_info\" data-url=\"" . $url . "\" class=\"btn-group btn-group-sm\">";
			if ($Security->allowList(CurrentProjectID() . 't_route_info')) {
				$label = $Language->TablePhrase("t_route_info", "TblCaption");
				$link = "<li class=\"nav-item\"><a href=\"#\" class=\"nav-link\" data-toggle=\"tab\" data-table=\"t_route_info\" data-url=\"" . $url . "\">" . $label . "</a></li>";
				$links .= $link;
				$detaillnk = JsEncodeAttribute("t_route_infolist.php?" . TABLE_SHOW_MASTER . "=t_trip_info&fk__route=" . urlencode(strval($this->_route->CurrentValue)) . "");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . $Language->TablePhrase("t_route_info", "TblCaption") . "\" onclick=\"window.location='" . $detaillnk . "'\">" . $Language->phrase("MasterDetailListLink") . "</button>";
			}
			if (!isset($GLOBALS["t_route_info_grid"]))
				$GLOBALS["t_route_info_grid"] = new t_route_info_grid();
			if ($GLOBALS["t_route_info_grid"]->DetailView && $Security->canView() && $Security->allowView(CurrentProjectID() . 't_route_info')) {
				$caption = $Language->phrase("MasterDetailViewLink");
				$url = $this->getViewUrl(TABLE_SHOW_DETAIL . "=t_route_info");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" onclick=\"window.location='" . HtmlEncode($url) . "'\">" . $caption . "</button>";
			}
			if ($GLOBALS["t_route_info_grid"]->DetailEdit && $Security->canEdit() && $Security->allowEdit(CurrentProjectID() . 't_route_info')) {
				$caption = $Language->phrase("MasterDetailEditLink");
				$url = $this->getEditUrl(TABLE_SHOW_DETAIL . "=t_route_info");
				$btngrp .= "<button type=\"button\" class=\"btn btn-default\" title=\"" . HtmlTitle($caption) . "\" onclick=\"window.location='" . HtmlEncode($url) . "'\">" . $caption . "</button>";
			}
			$btngrp .= "</div>";
			if ($link <> "") {
				$btngrps .= $btngrp;
				$option->Body .= "<div class=\"d-none ew-preview\">" . $link . $btngrp . "</div>";
			}
		}

		// Hide detail items if necessary
		$this->ListOptions->hideDetailItemsForDropDown();

		// Column "preview"
		$option = &$this->ListOptions->getItem("preview");
		if (!$option) { // Add preview column
			$option = &$this->ListOptions->add("preview");
			$option->OnLeft = TRUE;
			if ($option->OnLeft) {
				$option->moveTo($this->ListOptions->itemPos("checkbox") + 1);
			} else {
				$option->moveTo($this->ListOptions->itemPos("checkbox"));
			}
			$option->Visible = !($this->isExport() || $this->isGridAdd() || $this->isGridEdit());
			$option->ShowInDropDown = FALSE;
			$option->ShowInButtonGroup = FALSE;
		}
		if ($option) {
			$option->Body = "<i class=\"ew-preview-row-btn ew-icon icon-expand\"></i>";
			$option->Body .= "<div class=\"d-none ew-preview\">" . $links . $btngrps . "</div>";
			if ($option->Visible)
				$option->Visible = $links <> "";
		}

		// Column "details" (Multiple details)
		$option = &$this->ListOptions->getItem("details");
		if ($option) {
			$option->Body .= "<div class=\"d-none ew-preview\">" . $links . $btngrps . "</div>";
			if ($option->Visible)
				$option->Visible = $links <> "";
		}
	}

	// Set up starting record parameters
	public function setupStartRec()
	{
		if ($this->DisplayRecs == 0)
			return;
		if ($this->isPageRequest()) { // Validate request
			if (Get(TABLE_START_REC) !== NULL) { // Check for "start" parameter
				$this->StartRec = Get(TABLE_START_REC);
				$this->setStartRecordNumber($this->StartRec);
			} elseif (Get(TABLE_PAGE_NO) !== NULL) {
				$pageNo = Get(TABLE_PAGE_NO);
				if (is_numeric($pageNo)) {
					$this->StartRec = ($pageNo - 1) * $this->DisplayRecs + 1;
					if ($this->StartRec <= 0) {
						$this->StartRec = 1;
					} elseif ($this->StartRec >= (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1) {
						$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1;
					}
					$this->setStartRecordNumber($this->StartRec);
				}
			}
		}
		$this->StartRec = $this->getStartRecordNumber();

		// Check if correct start record counter
		if (!is_numeric($this->StartRec) || $this->StartRec == "") { // Avoid invalid start record counter
			$this->StartRec = 1; // Reset start record counter
			$this->setStartRecordNumber($this->StartRec);
		} elseif ($this->StartRec > $this->TotalRecs) { // Avoid starting record > total records
			$this->StartRec = (int)(($this->TotalRecs - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to last page first record
			$this->setStartRecordNumber($this->StartRec);
		} elseif (($this->StartRec - 1) % $this->DisplayRecs <> 0) {
			$this->StartRec = (int)(($this->StartRec - 1)/$this->DisplayRecs) * $this->DisplayRecs + 1; // Point to page boundary
			$this->setStartRecordNumber($this->StartRec);
		}
	}

	// Load basic search values
	protected function loadBasicSearchValues()
	{
		$this->BasicSearch->setKeyword(Get(TABLE_BASIC_SEARCH, ""), FALSE);
		if ($this->BasicSearch->Keyword <> "" && $this->Command == "")
			$this->Command = "search";
		$this->BasicSearch->setType(Get(TABLE_BASIC_SEARCH_TYPE, ""), FALSE);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue(Get("x_id", Get("id", "")));
		if ($this->id->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->id->AdvancedSearch->setSearchOperator(Get("z_id", ""));

		// vehicle_type
		if (!$this->isAddOrEdit())
			$this->vehicle_type->AdvancedSearch->setSearchValue(Get("x_vehicle_type", Get("vehicle_type", "")));
		if ($this->vehicle_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle_type->AdvancedSearch->setSearchOperator(Get("z_vehicle_type", ""));

		// vehicle
		if (!$this->isAddOrEdit())
			$this->vehicle->AdvancedSearch->setSearchValue(Get("x_vehicle", Get("vehicle", "")));
		if ($this->vehicle->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle->AdvancedSearch->setSearchOperator(Get("z_vehicle", ""));

		// route
		if (!$this->isAddOrEdit())
			$this->_route->AdvancedSearch->setSearchValue(Get("x__route", Get("_route", "")));
		if ($this->_route->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_route->AdvancedSearch->setSearchOperator(Get("z__route", ""));

		// route_name
		if (!$this->isAddOrEdit())
			$this->route_name->AdvancedSearch->setSearchValue(Get("x_route_name", Get("route_name", "")));
		if ($this->route_name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->route_name->AdvancedSearch->setSearchOperator(Get("z_route_name", ""));

		// reports_to
		if (!$this->isAddOrEdit())
			$this->reports_to->AdvancedSearch->setSearchValue(Get("x_reports_to", Get("reports_to", "")));
		if ($this->reports_to->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->reports_to->AdvancedSearch->setSearchOperator(Get("z_reports_to", ""));

		// buyer
		if (!$this->isAddOrEdit())
			$this->buyer->AdvancedSearch->setSearchValue(Get("x_buyer", Get("buyer", "")));
		if ($this->buyer->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->buyer->AdvancedSearch->setSearchOperator(Get("z_buyer", ""));

		// b_consignor
		if (!$this->isAddOrEdit())
			$this->b_consignor->AdvancedSearch->setSearchValue(Get("x_b_consignor", Get("b_consignor", "")));
		if ($this->b_consignor->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_consignor->AdvancedSearch->setSearchOperator(Get("z_b_consignor", ""));
		$this->b_consignor->AdvancedSearch->setSearchCondition(Get("v_b_consignor", ""));
		$this->b_consignor->AdvancedSearch->setSearchValue2(Get("y_b_consignor", ""));
		if ($this->b_consignor->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_consignor->AdvancedSearch->setSearchOperator2(Get("w_b_consignor", ""));

		// b_consignee
		if (!$this->isAddOrEdit())
			$this->b_consignee->AdvancedSearch->setSearchValue(Get("x_b_consignee", Get("b_consignee", "")));
		if ($this->b_consignee->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_consignee->AdvancedSearch->setSearchOperator(Get("z_b_consignee", ""));
		$this->b_consignee->AdvancedSearch->setSearchCondition(Get("v_b_consignee", ""));
		$this->b_consignee->AdvancedSearch->setSearchValue2(Get("y_b_consignee", ""));
		if ($this->b_consignee->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->b_consignee->AdvancedSearch->setSearchOperator2(Get("w_b_consignee", ""));

		// load_date
		if (!$this->isAddOrEdit())
			$this->load_date->AdvancedSearch->setSearchValue(Get("x_load_date", Get("load_date", "")));
		if ($this->load_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->load_date->AdvancedSearch->setSearchOperator(Get("z_load_date", ""));

		// load_weight
		if (!$this->isAddOrEdit())
			$this->load_weight->AdvancedSearch->setSearchValue(Get("x_load_weight", Get("load_weight", "")));
		if ($this->load_weight->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->load_weight->AdvancedSearch->setSearchOperator(Get("z_load_weight", ""));

		// unload_date
		if (!$this->isAddOrEdit())
			$this->unload_date->AdvancedSearch->setSearchValue(Get("x_unload_date", Get("unload_date", "")));
		if ($this->unload_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->unload_date->AdvancedSearch->setSearchOperator(Get("z_unload_date", ""));

		// unload_weight
		if (!$this->isAddOrEdit())
			$this->unload_weight->AdvancedSearch->setSearchValue(Get("x_unload_weight", Get("unload_weight", "")));
		if ($this->unload_weight->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->unload_weight->AdvancedSearch->setSearchOperator(Get("z_unload_weight", ""));

		// invoice_no
		if (!$this->isAddOrEdit())
			$this->invoice_no->AdvancedSearch->setSearchValue(Get("x_invoice_no", Get("invoice_no", "")));
		if ($this->invoice_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->invoice_no->AdvancedSearch->setSearchOperator(Get("z_invoice_no", ""));

		// invoice_date
		if (!$this->isAddOrEdit())
			$this->invoice_date->AdvancedSearch->setSearchValue(Get("x_invoice_date", Get("invoice_date", "")));
		if ($this->invoice_date->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->invoice_date->AdvancedSearch->setSearchOperator(Get("z_invoice_date", ""));
		$this->invoice_date->AdvancedSearch->setSearchCondition(Get("v_invoice_date", ""));
		$this->invoice_date->AdvancedSearch->setSearchValue2(Get("y_invoice_date", ""));
		if ($this->invoice_date->AdvancedSearch->SearchValue2 <> "" && $this->Command == "")
			$this->Command = "search";
		$this->invoice_date->AdvancedSearch->setSearchOperator2(Get("w_invoice_date", ""));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue(Get("x_amount", Get("amount", "")));
		if ($this->amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->amount->AdvancedSearch->setSearchOperator(Get("z_amount", ""));

		// delivery_pod
		if (!$this->isAddOrEdit())
			$this->delivery_pod->AdvancedSearch->setSearchValue(Get("x_delivery_pod", Get("delivery_pod", "")));
		if ($this->delivery_pod->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->delivery_pod->AdvancedSearch->setSearchOperator(Get("z_delivery_pod", ""));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue(Get("x_status", Get("status", "")));
		if ($this->status->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->status->AdvancedSearch->setSearchOperator(Get("z_status", ""));

		// days
		if (!$this->isAddOrEdit())
			$this->days->AdvancedSearch->setSearchValue(Get("x_days", Get("days", "")));
		if ($this->days->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->days->AdvancedSearch->setSearchOperator(Get("z_days", ""));

		// driver
		if (!$this->isAddOrEdit())
			$this->driver->AdvancedSearch->setSearchValue(Get("x_driver", Get("driver", "")));
		if ($this->driver->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->driver->AdvancedSearch->setSearchOperator(Get("z_driver", ""));

		// driver_name
		if (!$this->isAddOrEdit())
			$this->driver_name->AdvancedSearch->setSearchValue(Get("x_driver_name", Get("driver_name", "")));
		if ($this->driver_name->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->driver_name->AdvancedSearch->setSearchOperator(Get("z_driver_name", ""));

		// agent
		if (!$this->isAddOrEdit())
			$this->agent->AdvancedSearch->setSearchValue(Get("x_agent", Get("agent", "")));
		if ($this->agent->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->agent->AdvancedSearch->setSearchOperator(Get("z_agent", ""));

		// comm
		if (!$this->isAddOrEdit())
			$this->comm->AdvancedSearch->setSearchValue(Get("x_comm", Get("comm", "")));
		if ($this->comm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->comm->AdvancedSearch->setSearchOperator(Get("z_comm", ""));

		// material
		if (!$this->isAddOrEdit())
			$this->material->AdvancedSearch->setSearchValue(Get("x_material", Get("material", "")));
		if ($this->material->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->material->AdvancedSearch->setSearchOperator(Get("z_material", ""));

		// packing_type
		if (!$this->isAddOrEdit())
			$this->packing_type->AdvancedSearch->setSearchValue(Get("x_packing_type", Get("packing_type", "")));
		if ($this->packing_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->packing_type->AdvancedSearch->setSearchOperator(Get("z_packing_type", ""));

		// m_hsn
		if (!$this->isAddOrEdit())
			$this->m_hsn->AdvancedSearch->setSearchValue(Get("x_m_hsn", Get("m_hsn", "")));
		if ($this->m_hsn->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->m_hsn->AdvancedSearch->setSearchOperator(Get("z_m_hsn", ""));

		// @
		if (!$this->isAddOrEdit())
			$this->_40->AdvancedSearch->setSearchValue(Get("x__40", Get("_40", "")));
		if ($this->_40->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->_40->AdvancedSearch->setSearchOperator(Get("z__40", ""));

		// lr_no
		if (!$this->isAddOrEdit())
			$this->lr_no->AdvancedSearch->setSearchValue(Get("x_lr_no", Get("lr_no", "")));
		if ($this->lr_no->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->lr_no->AdvancedSearch->setSearchOperator(Get("z_lr_no", ""));

		// km
		if (!$this->isAddOrEdit())
			$this->km->AdvancedSearch->setSearchValue(Get("x_km", Get("km", "")));
		if ($this->km->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->km->AdvancedSearch->setSearchOperator(Get("z_km", ""));

		// freight_type
		if (!$this->isAddOrEdit())
			$this->freight_type->AdvancedSearch->setSearchValue(Get("x_freight_type", Get("freight_type", "")));
		if ($this->freight_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->freight_type->AdvancedSearch->setSearchOperator(Get("z_freight_type", ""));

		// freight
		if (!$this->isAddOrEdit())
			$this->freight->AdvancedSearch->setSearchValue(Get("x_freight", Get("freight", "")));
		if ($this->freight->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->freight->AdvancedSearch->setSearchOperator(Get("z_freight", ""));

		// ded_det
		if (!$this->isAddOrEdit())
			$this->ded_det->AdvancedSearch->setSearchValue(Get("x_ded_det", Get("ded_det", "")));
		if ($this->ded_det->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ded_det->AdvancedSearch->setSearchOperator(Get("z_ded_det", ""));

		// ded_det_remarks
		if (!$this->isAddOrEdit())
			$this->ded_det_remarks->AdvancedSearch->setSearchValue(Get("x_ded_det_remarks", Get("ded_det_remarks", "")));
		if ($this->ded_det_remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->ded_det_remarks->AdvancedSearch->setSearchOperator(Get("z_ded_det_remarks", ""));

		// gst_percent
		if (!$this->isAddOrEdit())
			$this->gst_percent->AdvancedSearch->setSearchValue(Get("x_gst_percent", Get("gst_percent", "")));
		if ($this->gst_percent->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gst_percent->AdvancedSearch->setSearchOperator(Get("z_gst_percent", ""));

		// gst_amount
		if (!$this->isAddOrEdit())
			$this->gst_amount->AdvancedSearch->setSearchValue(Get("x_gst_amount", Get("gst_amount", "")));
		if ($this->gst_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->gst_amount->AdvancedSearch->setSearchOperator(Get("z_gst_amount", ""));

		// final_amount
		if (!$this->isAddOrEdit())
			$this->final_amount->AdvancedSearch->setSearchValue(Get("x_final_amount", Get("final_amount", "")));
		if ($this->final_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->final_amount->AdvancedSearch->setSearchOperator(Get("z_final_amount", ""));

		// load_km
		if (!$this->isAddOrEdit())
			$this->load_km->AdvancedSearch->setSearchValue(Get("x_load_km", Get("load_km", "")));
		if ($this->load_km->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->load_km->AdvancedSearch->setSearchOperator(Get("z_load_km", ""));

		// unload_km
		if (!$this->isAddOrEdit())
			$this->unload_km->AdvancedSearch->setSearchValue(Get("x_unload_km", Get("unload_km", "")));
		if ($this->unload_km->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->unload_km->AdvancedSearch->setSearchOperator(Get("z_unload_km", ""));

		// delivery_receipt
		if (!$this->isAddOrEdit())
			$this->delivery_receipt->AdvancedSearch->setSearchValue(Get("x_delivery_receipt", Get("delivery_receipt", "")));
		if ($this->delivery_receipt->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->delivery_receipt->AdvancedSearch->setSearchOperator(Get("z_delivery_receipt", ""));

		// delivery_docket
		if (!$this->isAddOrEdit())
			$this->delivery_docket->AdvancedSearch->setSearchValue(Get("x_delivery_docket", Get("delivery_docket", "")));
		if ($this->delivery_docket->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->delivery_docket->AdvancedSearch->setSearchOperator(Get("z_delivery_docket", ""));

		// diesal_op_b
		if (!$this->isAddOrEdit())
			$this->diesal_op_b->AdvancedSearch->setSearchValue(Get("x_diesal_op_b", Get("diesal_op_b", "")));
		if ($this->diesal_op_b->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->diesal_op_b->AdvancedSearch->setSearchOperator(Get("z_diesal_op_b", ""));

		// diesal_required
		if (!$this->isAddOrEdit())
			$this->diesal_required->AdvancedSearch->setSearchValue(Get("x_diesal_required", Get("diesal_required", "")));
		if ($this->diesal_required->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->diesal_required->AdvancedSearch->setSearchOperator(Get("z_diesal_required", ""));

		// diesal_fill
		if (!$this->isAddOrEdit())
			$this->diesal_fill->AdvancedSearch->setSearchValue(Get("x_diesal_fill", Get("diesal_fill", "")));
		if ($this->diesal_fill->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->diesal_fill->AdvancedSearch->setSearchOperator(Get("z_diesal_fill", ""));

		// diesal_amount
		if (!$this->isAddOrEdit())
			$this->diesal_amount->AdvancedSearch->setSearchValue(Get("x_diesal_amount", Get("diesal_amount", "")));
		if ($this->diesal_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->diesal_amount->AdvancedSearch->setSearchOperator(Get("z_diesal_amount", ""));

		// diesal_cl_balance
		if (!$this->isAddOrEdit())
			$this->diesal_cl_balance->AdvancedSearch->setSearchValue(Get("x_diesal_cl_balance", Get("diesal_cl_balance", "")));
		if ($this->diesal_cl_balance->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->diesal_cl_balance->AdvancedSearch->setSearchOperator(Get("z_diesal_cl_balance", ""));

		// vehicle_average
		if (!$this->isAddOrEdit())
			$this->vehicle_average->AdvancedSearch->setSearchValue(Get("x_vehicle_average", Get("vehicle_average", "")));
		if ($this->vehicle_average->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle_average->AdvancedSearch->setSearchOperator(Get("z_vehicle_average", ""));

		// cash_required
		if (!$this->isAddOrEdit())
			$this->cash_required->AdvancedSearch->setSearchValue(Get("x_cash_required", Get("cash_required", "")));
		if ($this->cash_required->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cash_required->AdvancedSearch->setSearchOperator(Get("z_cash_required", ""));

		// cash_op_b
		if (!$this->isAddOrEdit())
			$this->cash_op_b->AdvancedSearch->setSearchValue(Get("x_cash_op_b", Get("cash_op_b", "")));
		if ($this->cash_op_b->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cash_op_b->AdvancedSearch->setSearchOperator(Get("z_cash_op_b", ""));

		// cash_paid
		if (!$this->isAddOrEdit())
			$this->cash_paid->AdvancedSearch->setSearchValue(Get("x_cash_paid", Get("cash_paid", "")));
		if ($this->cash_paid->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cash_paid->AdvancedSearch->setSearchOperator(Get("z_cash_paid", ""));

		// cash_expenses
		if (!$this->isAddOrEdit())
			$this->cash_expenses->AdvancedSearch->setSearchValue(Get("x_cash_expenses", Get("cash_expenses", "")));
		if ($this->cash_expenses->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cash_expenses->AdvancedSearch->setSearchOperator(Get("z_cash_expenses", ""));

		// cash_cl_balance
		if (!$this->isAddOrEdit())
			$this->cash_cl_balance->AdvancedSearch->setSearchValue(Get("x_cash_cl_balance", Get("cash_cl_balance", "")));
		if ($this->cash_cl_balance->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->cash_cl_balance->AdvancedSearch->setSearchOperator(Get("z_cash_cl_balance", ""));

		// fasttag_op_b
		if (!$this->isAddOrEdit())
			$this->fasttag_op_b->AdvancedSearch->setSearchValue(Get("x_fasttag_op_b", Get("fasttag_op_b", "")));
		if ($this->fasttag_op_b->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->fasttag_op_b->AdvancedSearch->setSearchOperator(Get("z_fasttag_op_b", ""));

		// fasttag_recharge
		if (!$this->isAddOrEdit())
			$this->fasttag_recharge->AdvancedSearch->setSearchValue(Get("x_fasttag_recharge", Get("fasttag_recharge", "")));
		if ($this->fasttag_recharge->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->fasttag_recharge->AdvancedSearch->setSearchOperator(Get("z_fasttag_recharge", ""));

		// fasttag_expenses
		if (!$this->isAddOrEdit())
			$this->fasttag_expenses->AdvancedSearch->setSearchValue(Get("x_fasttag_expenses", Get("fasttag_expenses", "")));
		if ($this->fasttag_expenses->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->fasttag_expenses->AdvancedSearch->setSearchOperator(Get("z_fasttag_expenses", ""));

		// toll_expenses_cash
		if (!$this->isAddOrEdit())
			$this->toll_expenses_cash->AdvancedSearch->setSearchValue(Get("x_toll_expenses_cash", Get("toll_expenses_cash", "")));
		if ($this->toll_expenses_cash->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->toll_expenses_cash->AdvancedSearch->setSearchOperator(Get("z_toll_expenses_cash", ""));

		// fasttag_cl_balance
		if (!$this->isAddOrEdit())
			$this->fasttag_cl_balance->AdvancedSearch->setSearchValue(Get("x_fasttag_cl_balance", Get("fasttag_cl_balance", "")));
		if ($this->fasttag_cl_balance->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->fasttag_cl_balance->AdvancedSearch->setSearchOperator(Get("z_fasttag_cl_balance", ""));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue(Get("x_remarks", Get("remarks", "")));
		if ($this->remarks->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->remarks->AdvancedSearch->setSearchOperator(Get("z_remarks", ""));

		// uploads
		if (!$this->isAddOrEdit())
			$this->uploads->AdvancedSearch->setSearchValue(Get("x_uploads", Get("uploads", "")));
		if ($this->uploads->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->uploads->AdvancedSearch->setSearchOperator(Get("z_uploads", ""));

		// consignor
		if (!$this->isAddOrEdit())
			$this->consignor->AdvancedSearch->setSearchValue(Get("x_consignor", Get("consignor", "")));
		if ($this->consignor->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->consignor->AdvancedSearch->setSearchOperator(Get("z_consignor", ""));

		// vehicle_freight_comm
		if (!$this->isAddOrEdit())
			$this->vehicle_freight_comm->AdvancedSearch->setSearchValue(Get("x_vehicle_freight_comm", Get("vehicle_freight_comm", "")));
		if ($this->vehicle_freight_comm->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle_freight_comm->AdvancedSearch->setSearchOperator(Get("z_vehicle_freight_comm", ""));

		// vehicle_freight_type
		if (!$this->isAddOrEdit())
			$this->vehicle_freight_type->AdvancedSearch->setSearchValue(Get("x_vehicle_freight_type", Get("vehicle_freight_type", "")));
		if ($this->vehicle_freight_type->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle_freight_type->AdvancedSearch->setSearchOperator(Get("z_vehicle_freight_type", ""));

		// vehicle_freight_amount
		if (!$this->isAddOrEdit())
			$this->vehicle_freight_amount->AdvancedSearch->setSearchValue(Get("x_vehicle_freight_amount", Get("vehicle_freight_amount", "")));
		if ($this->vehicle_freight_amount->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle_freight_amount->AdvancedSearch->setSearchOperator(Get("z_vehicle_freight_amount", ""));

		// vehicle_freight_final
		if (!$this->isAddOrEdit())
			$this->vehicle_freight_final->AdvancedSearch->setSearchValue(Get("x_vehicle_freight_final", Get("vehicle_freight_final", "")));
		if ($this->vehicle_freight_final->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->vehicle_freight_final->AdvancedSearch->setSearchOperator(Get("z_vehicle_freight_final", ""));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue(Get("x_operator", Get("operator", "")));
		if ($this->operator->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->operator->AdvancedSearch->setSearchOperator(Get("z_operator", ""));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue(Get("x_datetime", Get("datetime", "")));
		if ($this->datetime->AdvancedSearch->SearchValue <> "" && $this->Command == "")
			$this->Command = "search";
		$this->datetime->AdvancedSearch->setSearchOperator(Get("z_datetime", ""));
	}

	// Load recordset
	public function loadRecordset($offset = -1, $rowcnt = -1)
	{

		// Load List page SQL
		$sql = $this->getListSql();
		$conn = &$this->getConnection();

		// Load recordset
		$dbtype = GetConnectionType($this->Dbid);
		if ($this->UseSelectLimit) {
			$conn->raiseErrorFn = $GLOBALS["ERROR_FUNC"];
			if ($dbtype == "MSSQL") {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset, ["_hasOrderBy" => trim($this->getOrderBy()) || trim($this->getSessionOrderByList())]);
			} else {
				$rs = $conn->selectLimit($sql, $rowcnt, $offset);
			}
			$conn->raiseErrorFn = '';
		} else {
			$rs = LoadRecordset($sql, $conn);
		}

		// Call Recordset Selected event
		$this->Recordset_Selected($rs);
		return $rs;
	}

	// Load row based on key values
	public function loadRow()
	{
		global $Security, $Language;
		$filter = $this->getRecordFilter();

		// Call Row Selecting event
		$this->Row_Selecting($filter);

		// Load SQL based on filter
		$this->CurrentFilter = $filter;
		$sql = $this->getCurrentSql();
		$conn = &$this->getConnection();
		$res = FALSE;
		$rs = LoadRecordset($sql, $conn);
		if ($rs && !$rs->EOF) {
			$res = TRUE;
			$this->loadRowValues($rs); // Load row values
			$rs->close();
		}
		return $res;
	}

	// Load row values from recordset
	public function loadRowValues($rs = NULL)
	{
		if ($rs && !$rs->EOF)
			$row = $rs->fields;
		else
			$row = $this->newRow();

		// Call Row Selected event
		$this->Row_Selected($row);
		if (!$rs || $rs->EOF)
			return;
		$this->id->setDbValue($row['id']);
		$this->vehicle_type->setDbValue($row['vehicle_type']);
		$this->vehicle->setDbValue($row['vehicle']);
		$this->_route->setDbValue($row['route']);
		$this->route_name->setDbValue($row['route_name']);
		$this->reports_to->setDbValue($row['reports_to']);
		$this->buyer->setDbValue($row['buyer']);
		$this->b_consignor->setDbValue($row['b_consignor']);
		$this->b_consignee->setDbValue($row['b_consignee']);
		$this->load_date->setDbValue($row['load_date']);
		$this->load_weight->setDbValue($row['load_weight']);
		$this->unload_date->setDbValue($row['unload_date']);
		$this->unload_weight->setDbValue($row['unload_weight']);
		$this->invoice_no->setDbValue($row['invoice_no']);
		$this->invoice_date->setDbValue($row['invoice_date']);
		$this->amount->setDbValue($row['amount']);
		$this->delivery_pod->setDbValue($row['delivery_pod']);
		$this->status->setDbValue($row['status']);
		$this->days->setDbValue($row['days']);
		$this->driver->setDbValue($row['driver']);
		$this->driver_name->setDbValue($row['driver_name']);
		$this->agent->setDbValue($row['agent']);
		if (array_key_exists('EV__agent', $rs->fields)) {
			$this->agent->VirtualValue = $rs->fields('EV__agent'); // Set up virtual field value
		} else {
			$this->agent->VirtualValue = ""; // Clear value
		}
		$this->comm->setDbValue($row['comm']);
		$this->material->setDbValue($row['material']);
		$this->packing_type->setDbValue($row['packing_type']);
		$this->m_hsn->setDbValue($row['m_hsn']);
		$this->_40->setDbValue($row['@']);
		$this->lr_no->setDbValue($row['lr_no']);
		$this->km->setDbValue($row['km']);
		$this->freight_type->setDbValue($row['freight_type']);
		$this->freight->setDbValue($row['freight']);
		$this->ded_det->setDbValue($row['ded_det']);
		$this->ded_det_remarks->setDbValue($row['ded_det_remarks']);
		$this->gst_percent->setDbValue($row['gst_percent']);
		$this->gst_amount->setDbValue($row['gst_amount']);
		$this->final_amount->setDbValue($row['final_amount']);
		$this->load_km->setDbValue($row['load_km']);
		$this->unload_km->setDbValue($row['unload_km']);
		$this->delivery_receipt->Upload->DbValue = $row['delivery_receipt'];
		$this->delivery_receipt->setDbValue($this->delivery_receipt->Upload->DbValue);
		$this->delivery_docket->setDbValue($row['delivery_docket']);
		$this->diesal_op_b->setDbValue($row['diesal_op_b']);
		$this->diesal_required->setDbValue($row['diesal_required']);
		$this->diesal_fill->setDbValue($row['diesal_fill']);
		$this->diesal_amount->setDbValue($row['diesal_amount']);
		$this->diesal_cl_balance->setDbValue($row['diesal_cl_balance']);
		$this->vehicle_average->setDbValue($row['vehicle_average']);
		$this->cash_required->setDbValue($row['cash_required']);
		$this->cash_op_b->setDbValue($row['cash_op_b']);
		$this->cash_paid->setDbValue($row['cash_paid']);
		$this->cash_expenses->setDbValue($row['cash_expenses']);
		$this->cash_cl_balance->setDbValue($row['cash_cl_balance']);
		$this->fasttag_op_b->setDbValue($row['fasttag_op_b']);
		$this->fasttag_recharge->setDbValue($row['fasttag_recharge']);
		$this->fasttag_expenses->setDbValue($row['fasttag_expenses']);
		$this->toll_expenses_cash->setDbValue($row['toll_expenses_cash']);
		$this->fasttag_cl_balance->setDbValue($row['fasttag_cl_balance']);
		$this->remarks->setDbValue($row['remarks']);
		$this->uploads->Upload->DbValue = $row['uploads'];
		$this->uploads->setDbValue($this->uploads->Upload->DbValue);
		$this->consignor->setDbValue($row['consignor']);
		$this->vehicle_freight_comm->setDbValue($row['vehicle_freight_comm']);
		$this->vehicle_freight_type->setDbValue($row['vehicle_freight_type']);
		$this->vehicle_freight_amount->setDbValue($row['vehicle_freight_amount']);
		$this->vehicle_freight_final->setDbValue($row['vehicle_freight_final']);
		$this->operator->setDbValue($row['operator']);
		$this->datetime->setDbValue($row['datetime']);
		$this->expenses_id->setDbValue($row['expenses_id']);
	}

	// Return a row with default values
	protected function newRow()
	{
		$row = [];
		$row['id'] = NULL;
		$row['vehicle_type'] = NULL;
		$row['vehicle'] = NULL;
		$row['route'] = NULL;
		$row['route_name'] = NULL;
		$row['reports_to'] = NULL;
		$row['buyer'] = NULL;
		$row['b_consignor'] = NULL;
		$row['b_consignee'] = NULL;
		$row['load_date'] = NULL;
		$row['load_weight'] = NULL;
		$row['unload_date'] = NULL;
		$row['unload_weight'] = NULL;
		$row['invoice_no'] = NULL;
		$row['invoice_date'] = NULL;
		$row['amount'] = NULL;
		$row['delivery_pod'] = NULL;
		$row['status'] = NULL;
		$row['days'] = NULL;
		$row['driver'] = NULL;
		$row['driver_name'] = NULL;
		$row['agent'] = NULL;
		$row['comm'] = NULL;
		$row['material'] = NULL;
		$row['packing_type'] = NULL;
		$row['m_hsn'] = NULL;
		$row['@'] = NULL;
		$row['lr_no'] = NULL;
		$row['km'] = NULL;
		$row['freight_type'] = NULL;
		$row['freight'] = NULL;
		$row['ded_det'] = NULL;
		$row['ded_det_remarks'] = NULL;
		$row['gst_percent'] = NULL;
		$row['gst_amount'] = NULL;
		$row['final_amount'] = NULL;
		$row['load_km'] = NULL;
		$row['unload_km'] = NULL;
		$row['delivery_receipt'] = NULL;
		$row['delivery_docket'] = NULL;
		$row['diesal_op_b'] = NULL;
		$row['diesal_required'] = NULL;
		$row['diesal_fill'] = NULL;
		$row['diesal_amount'] = NULL;
		$row['diesal_cl_balance'] = NULL;
		$row['vehicle_average'] = NULL;
		$row['cash_required'] = NULL;
		$row['cash_op_b'] = NULL;
		$row['cash_paid'] = NULL;
		$row['cash_expenses'] = NULL;
		$row['cash_cl_balance'] = NULL;
		$row['fasttag_op_b'] = NULL;
		$row['fasttag_recharge'] = NULL;
		$row['fasttag_expenses'] = NULL;
		$row['toll_expenses_cash'] = NULL;
		$row['fasttag_cl_balance'] = NULL;
		$row['remarks'] = NULL;
		$row['uploads'] = NULL;
		$row['consignor'] = NULL;
		$row['vehicle_freight_comm'] = NULL;
		$row['vehicle_freight_type'] = NULL;
		$row['vehicle_freight_amount'] = NULL;
		$row['vehicle_freight_final'] = NULL;
		$row['operator'] = NULL;
		$row['datetime'] = NULL;
		$row['expenses_id'] = NULL;
		return $row;
	}

	// Load old record
	protected function loadOldRecord()
	{

		// Load key values from Session
		$validKey = TRUE;
		if (strval($this->getKey("id")) <> "")
			$this->id->CurrentValue = $this->getKey("id"); // id
		else
			$validKey = FALSE;

		// Load old record
		$this->OldRecordset = NULL;
		if ($validKey) {
			$this->CurrentFilter = $this->getRecordFilter();
			$sql = $this->getCurrentSql();
			$conn = &$this->getConnection();
			$this->OldRecordset = LoadRecordset($sql, $conn);
		}
		$this->loadRowValues($this->OldRecordset); // Load row values
		return $validKey;
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		$this->ViewUrl = $this->getViewUrl();
		$this->EditUrl = $this->getEditUrl();
		$this->InlineEditUrl = $this->getInlineEditUrl();
		$this->CopyUrl = $this->getCopyUrl();
		$this->InlineCopyUrl = $this->getInlineCopyUrl();
		$this->DeleteUrl = $this->getDeleteUrl();

		// Convert decimal values if posted back
		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->comm->FormValue == $this->comm->CurrentValue && is_numeric(ConvertToFloatString($this->comm->CurrentValue)))
			$this->comm->CurrentValue = ConvertToFloatString($this->comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_40->FormValue == $this->_40->CurrentValue && is_numeric(ConvertToFloatString($this->_40->CurrentValue)))
			$this->_40->CurrentValue = ConvertToFloatString($this->_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->km->FormValue == $this->km->CurrentValue && is_numeric(ConvertToFloatString($this->km->CurrentValue)))
			$this->km->CurrentValue = ConvertToFloatString($this->km->CurrentValue);

		// Convert decimal values if posted back
		if ($this->freight->FormValue == $this->freight->CurrentValue && is_numeric(ConvertToFloatString($this->freight->CurrentValue)))
			$this->freight->CurrentValue = ConvertToFloatString($this->freight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ded_det->FormValue == $this->ded_det->CurrentValue && is_numeric(ConvertToFloatString($this->ded_det->CurrentValue)))
			$this->ded_det->CurrentValue = ConvertToFloatString($this->ded_det->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gst_percent->FormValue == $this->gst_percent->CurrentValue && is_numeric(ConvertToFloatString($this->gst_percent->CurrentValue)))
			$this->gst_percent->CurrentValue = ConvertToFloatString($this->gst_percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gst_amount->FormValue == $this->gst_amount->CurrentValue && is_numeric(ConvertToFloatString($this->gst_amount->CurrentValue)))
			$this->gst_amount->CurrentValue = ConvertToFloatString($this->gst_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->final_amount->FormValue == $this->final_amount->CurrentValue && is_numeric(ConvertToFloatString($this->final_amount->CurrentValue)))
			$this->final_amount->CurrentValue = ConvertToFloatString($this->final_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_op_b->FormValue == $this->diesal_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_op_b->CurrentValue)))
			$this->diesal_op_b->CurrentValue = ConvertToFloatString($this->diesal_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_required->FormValue == $this->diesal_required->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_required->CurrentValue)))
			$this->diesal_required->CurrentValue = ConvertToFloatString($this->diesal_required->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_fill->FormValue == $this->diesal_fill->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_fill->CurrentValue)))
			$this->diesal_fill->CurrentValue = ConvertToFloatString($this->diesal_fill->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_amount->FormValue == $this->diesal_amount->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_amount->CurrentValue)))
			$this->diesal_amount->CurrentValue = ConvertToFloatString($this->diesal_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_cl_balance->FormValue == $this->diesal_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_cl_balance->CurrentValue)))
			$this->diesal_cl_balance->CurrentValue = ConvertToFloatString($this->diesal_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_average->FormValue == $this->vehicle_average->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_average->CurrentValue)))
			$this->vehicle_average->CurrentValue = ConvertToFloatString($this->vehicle_average->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_required->FormValue == $this->cash_required->CurrentValue && is_numeric(ConvertToFloatString($this->cash_required->CurrentValue)))
			$this->cash_required->CurrentValue = ConvertToFloatString($this->cash_required->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_op_b->FormValue == $this->cash_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->cash_op_b->CurrentValue)))
			$this->cash_op_b->CurrentValue = ConvertToFloatString($this->cash_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_paid->FormValue == $this->cash_paid->CurrentValue && is_numeric(ConvertToFloatString($this->cash_paid->CurrentValue)))
			$this->cash_paid->CurrentValue = ConvertToFloatString($this->cash_paid->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_expenses->FormValue == $this->cash_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->cash_expenses->CurrentValue)))
			$this->cash_expenses->CurrentValue = ConvertToFloatString($this->cash_expenses->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_cl_balance->FormValue == $this->cash_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->cash_cl_balance->CurrentValue)))
			$this->cash_cl_balance->CurrentValue = ConvertToFloatString($this->cash_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_op_b->FormValue == $this->fasttag_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_op_b->CurrentValue)))
			$this->fasttag_op_b->CurrentValue = ConvertToFloatString($this->fasttag_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_recharge->FormValue == $this->fasttag_recharge->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_recharge->CurrentValue)))
			$this->fasttag_recharge->CurrentValue = ConvertToFloatString($this->fasttag_recharge->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_expenses->FormValue == $this->fasttag_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_expenses->CurrentValue)))
			$this->fasttag_expenses->CurrentValue = ConvertToFloatString($this->fasttag_expenses->CurrentValue);

		// Convert decimal values if posted back
		if ($this->toll_expenses_cash->FormValue == $this->toll_expenses_cash->CurrentValue && is_numeric(ConvertToFloatString($this->toll_expenses_cash->CurrentValue)))
			$this->toll_expenses_cash->CurrentValue = ConvertToFloatString($this->toll_expenses_cash->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_cl_balance->FormValue == $this->fasttag_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_cl_balance->CurrentValue)))
			$this->fasttag_cl_balance->CurrentValue = ConvertToFloatString($this->fasttag_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_comm->FormValue == $this->vehicle_freight_comm->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_comm->CurrentValue)))
			$this->vehicle_freight_comm->CurrentValue = ConvertToFloatString($this->vehicle_freight_comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_amount->FormValue == $this->vehicle_freight_amount->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_amount->CurrentValue)))
			$this->vehicle_freight_amount->CurrentValue = ConvertToFloatString($this->vehicle_freight_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_final->FormValue == $this->vehicle_freight_final->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_final->CurrentValue)))
			$this->vehicle_freight_final->CurrentValue = ConvertToFloatString($this->vehicle_freight_final->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// vehicle_type
		// vehicle
		// route
		// route_name
		// reports_to
		// buyer
		// b_consignor
		// b_consignee
		// load_date
		// load_weight
		// unload_date
		// unload_weight
		// invoice_no
		// invoice_date
		// amount
		// delivery_pod
		// status
		// days
		// driver
		// driver_name
		// agent
		// comm
		// material
		// packing_type
		// m_hsn
		// @
		// lr_no
		// km
		// freight_type
		// freight
		// ded_det
		// ded_det_remarks
		// gst_percent
		// gst_amount
		// final_amount
		// load_km
		// unload_km
		// delivery_receipt
		// delivery_docket
		// diesal_op_b
		// diesal_required
		// diesal_fill
		// diesal_amount
		// diesal_cl_balance
		// vehicle_average
		// cash_required
		// cash_op_b
		// cash_paid
		// cash_expenses
		// cash_cl_balance
		// fasttag_op_b
		// fasttag_recharge
		// fasttag_expenses
		// toll_expenses_cash
		// fasttag_cl_balance
		// remarks
		// uploads
		// consignor
		// vehicle_freight_comm
		// vehicle_freight_type
		// vehicle_freight_amount
		// vehicle_freight_final
		// operator
		// datetime
		// expenses_id

		$this->expenses_id->CellCssStyle = "white-space: nowrap;";
		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// vehicle_type
			if (strval($this->vehicle_type->CurrentValue) <> "") {
				$this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
			} else {
				$this->vehicle_type->ViewValue = NULL;
			}
			$this->vehicle_type->ViewCustomAttributes = "";

			// vehicle
			$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
			$curVal = strval($this->vehicle->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
					}
				}
			} else {
				$this->vehicle->ViewValue = NULL;
			}
			$this->vehicle->ViewCustomAttributes = "";

			// route
			$this->_route->ViewValue = $this->_route->CurrentValue;
			$curVal = strval($this->_route->CurrentValue);
			if ($curVal <> "") {
				$this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
				if ($this->_route->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->_route->ViewValue = $this->_route->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_route->ViewValue = $this->_route->CurrentValue;
					}
				}
			} else {
				$this->_route->ViewValue = NULL;
			}
			$this->_route->ViewCustomAttributes = "";

			// route_name
			$this->route_name->ViewValue = $this->route_name->CurrentValue;
			$this->route_name->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// buyer
			$this->buyer->ViewValue = $this->buyer->CurrentValue;
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->ViewValue = $this->buyer->CurrentValue;
					}
				}
			} else {
				$this->buyer->ViewValue = NULL;
			}
			$this->buyer->ViewCustomAttributes = "";

			// b_consignor
			$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
			$curVal = strval($this->b_consignor->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
				if ($this->b_consignor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
					}
				}
			} else {
				$this->b_consignor->ViewValue = NULL;
			}
			$this->b_consignor->ViewCustomAttributes = "";

			// b_consignee
			$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
			$curVal = strval($this->b_consignee->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
				if ($this->b_consignee->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
					}
				}
			} else {
				$this->b_consignee->ViewValue = NULL;
			}
			$this->b_consignee->ViewCustomAttributes = "";

			// load_date
			$this->load_date->ViewValue = $this->load_date->CurrentValue;
			$this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, 1);
			$this->load_date->ViewCustomAttributes = "";

			// load_weight
			$this->load_weight->ViewValue = $this->load_weight->CurrentValue;
			$this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, 0, -2, -2, -2);
			$this->load_weight->ViewCustomAttributes = "";

			// unload_date
			$this->unload_date->ViewValue = $this->unload_date->CurrentValue;
			$this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, 0);
			$this->unload_date->ViewCustomAttributes = "";

			// unload_weight
			$this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
			$this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, 0, -2, -2, -2);
			$this->unload_weight->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewValue = FormatNumber($this->invoice_no->ViewValue, 0, -2, -2, -2);
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// delivery_pod
			if (strval($this->delivery_pod->CurrentValue) <> "") {
				$this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
			} else {
				$this->delivery_pod->ViewValue = NULL;
			}
			$this->delivery_pod->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// days
			$this->days->ViewValue = $this->days->CurrentValue;
			$this->days->ViewValue = FormatNumber($this->days->ViewValue, 0, -2, -2, -2);
			$this->days->ViewCustomAttributes = "";

			// driver
			$curVal = strval($this->driver->CurrentValue);
			if ($curVal <> "") {
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
				if ($this->driver->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->driver->ViewValue = $this->driver->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->driver->ViewValue = $this->driver->CurrentValue;
					}
				}
			} else {
				$this->driver->ViewValue = NULL;
			}
			$this->driver->ViewCustomAttributes = "";

			// driver_name
			$this->driver_name->ViewValue = $this->driver_name->CurrentValue;
			$this->driver_name->ViewCustomAttributes = "";

			// agent
			if ($this->agent->VirtualValue <> "") {
				$this->agent->ViewValue = $this->agent->VirtualValue;
			} else {
				$this->agent->ViewValue = $this->agent->CurrentValue;
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->agent->ViewValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->ViewValue = $this->agent->CurrentValue;
					}
				}
			} else {
				$this->agent->ViewValue = NULL;
			}
			}
			$this->agent->ViewCustomAttributes = "";

			// comm
			$this->comm->ViewValue = $this->comm->CurrentValue;
			$this->comm->ViewValue = FormatNumber($this->comm->ViewValue, 2, -2, -2, -2);
			$this->comm->ViewCustomAttributes = "";

			// material
			$this->material->ViewValue = $this->material->CurrentValue;
			$this->material->ViewCustomAttributes = "";

			// packing_type
			$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
			$this->packing_type->ViewCustomAttributes = "";

			// m_hsn
			$this->m_hsn->ViewValue = $this->m_hsn->CurrentValue;
			$this->m_hsn->ViewCustomAttributes = "";

			// @
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 2, -2, -2, -2);
			$this->_40->ViewCustomAttributes = "";

			// lr_no
			$this->lr_no->ViewValue = $this->lr_no->CurrentValue;
			$this->lr_no->ViewCustomAttributes = "";

			// km
			$this->km->ViewValue = $this->km->CurrentValue;
			$this->km->ViewValue = FormatNumber($this->km->ViewValue, 2, -2, -2, -2);
			$this->km->ViewCustomAttributes = "";

			// freight_type
			if (strval($this->freight_type->CurrentValue) <> "") {
				$this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
			} else {
				$this->freight_type->ViewValue = NULL;
			}
			$this->freight_type->ViewCustomAttributes = "";

			// freight
			$this->freight->ViewValue = $this->freight->CurrentValue;
			$this->freight->ViewValue = FormatNumber($this->freight->ViewValue, 2, -2, -2, -2);
			$this->freight->ViewCustomAttributes = "";

			// ded_det
			$this->ded_det->ViewValue = $this->ded_det->CurrentValue;
			$this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, 2, -2, -2, -2);
			$this->ded_det->ViewCustomAttributes = "";

			// ded_det_remarks
			$this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;
			$this->ded_det_remarks->ViewCustomAttributes = "";

			// gst_percent
			$this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
			$this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, 2, -2, -2, -2);
			$this->gst_percent->ViewCustomAttributes = "";

			// gst_amount
			$this->gst_amount->ViewValue = $this->gst_amount->CurrentValue;
			$this->gst_amount->ViewValue = FormatNumber($this->gst_amount->ViewValue, 2, -2, -2, -2);
			$this->gst_amount->ViewCustomAttributes = "";

			// final_amount
			$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
			$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";

			// load_km
			$this->load_km->ViewValue = $this->load_km->CurrentValue;
			$this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, 0, -2, -2, -2);
			$this->load_km->ViewCustomAttributes = "";

			// unload_km
			$this->unload_km->ViewValue = $this->unload_km->CurrentValue;
			$this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, 0, -2, -2, -2);
			$this->unload_km->ViewCustomAttributes = "";

			// delivery_receipt
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->ImageWidth = 0;
				$this->delivery_receipt->ImageHeight = 50;
				$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
				$this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
			} else {
				$this->delivery_receipt->ViewValue = "";
			}
			$this->delivery_receipt->ViewCustomAttributes = "";

			// delivery_docket
			$this->delivery_docket->ViewValue = $this->delivery_docket->CurrentValue;
			$this->delivery_docket->ViewCustomAttributes = "";

			// diesal_op_b
			$this->diesal_op_b->ViewValue = $this->diesal_op_b->CurrentValue;
			$this->diesal_op_b->ViewValue = FormatNumber($this->diesal_op_b->ViewValue, 2, -2, -2, -2);
			$this->diesal_op_b->ViewCustomAttributes = "";

			// diesal_required
			$this->diesal_required->ViewValue = $this->diesal_required->CurrentValue;
			$this->diesal_required->ViewValue = FormatNumber($this->diesal_required->ViewValue, 2, -2, -2, -2);
			$this->diesal_required->ViewCustomAttributes = "";

			// diesal_fill
			$this->diesal_fill->ViewValue = $this->diesal_fill->CurrentValue;
			$this->diesal_fill->ViewValue = FormatNumber($this->diesal_fill->ViewValue, 2, -2, -2, -2);
			$this->diesal_fill->ViewCustomAttributes = "";

			// diesal_amount
			$this->diesal_amount->ViewValue = $this->diesal_amount->CurrentValue;
			$this->diesal_amount->ViewValue = FormatNumber($this->diesal_amount->ViewValue, 2, -2, -2, -2);
			$this->diesal_amount->ViewCustomAttributes = "";

			// diesal_cl_balance
			$this->diesal_cl_balance->ViewValue = $this->diesal_cl_balance->CurrentValue;
			$this->diesal_cl_balance->ViewValue = FormatNumber($this->diesal_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->diesal_cl_balance->ViewCustomAttributes = "";

			// vehicle_average
			$this->vehicle_average->ViewValue = $this->vehicle_average->CurrentValue;
			$this->vehicle_average->ViewValue = FormatNumber($this->vehicle_average->ViewValue, 2, -2, -2, -2);
			$this->vehicle_average->ViewCustomAttributes = "";

			// cash_required
			$this->cash_required->ViewValue = $this->cash_required->CurrentValue;
			$this->cash_required->ViewValue = FormatNumber($this->cash_required->ViewValue, 2, -2, -2, -2);
			$this->cash_required->ViewCustomAttributes = "";

			// cash_op_b
			$this->cash_op_b->ViewValue = $this->cash_op_b->CurrentValue;
			$this->cash_op_b->ViewValue = FormatNumber($this->cash_op_b->ViewValue, 2, -2, -2, -2);
			$this->cash_op_b->ViewCustomAttributes = "";

			// cash_paid
			$this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
			$this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, 2, -2, -2, -2);
			$this->cash_paid->ViewCustomAttributes = "";

			// cash_expenses
			$this->cash_expenses->ViewValue = $this->cash_expenses->CurrentValue;
			$this->cash_expenses->ViewValue = FormatNumber($this->cash_expenses->ViewValue, 2, -2, -2, -2);
			$this->cash_expenses->ViewCustomAttributes = "";

			// cash_cl_balance
			$this->cash_cl_balance->ViewValue = $this->cash_cl_balance->CurrentValue;
			$this->cash_cl_balance->ViewValue = FormatNumber($this->cash_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->cash_cl_balance->ViewCustomAttributes = "";

			// fasttag_op_b
			$this->fasttag_op_b->ViewValue = $this->fasttag_op_b->CurrentValue;
			$this->fasttag_op_b->ViewValue = FormatNumber($this->fasttag_op_b->ViewValue, 2, -2, -2, -2);
			$this->fasttag_op_b->ViewCustomAttributes = "";

			// fasttag_recharge
			$this->fasttag_recharge->ViewValue = $this->fasttag_recharge->CurrentValue;
			$this->fasttag_recharge->ViewValue = FormatNumber($this->fasttag_recharge->ViewValue, 2, -2, -2, -2);
			$this->fasttag_recharge->ViewCustomAttributes = "";

			// fasttag_expenses
			$this->fasttag_expenses->ViewValue = $this->fasttag_expenses->CurrentValue;
			$this->fasttag_expenses->ViewValue = FormatNumber($this->fasttag_expenses->ViewValue, 2, -2, -2, -2);
			$this->fasttag_expenses->ViewCustomAttributes = "";

			// toll_expenses_cash
			$this->toll_expenses_cash->ViewValue = $this->toll_expenses_cash->CurrentValue;
			$this->toll_expenses_cash->ViewValue = FormatNumber($this->toll_expenses_cash->ViewValue, 2, -2, -2, -2);
			$this->toll_expenses_cash->ViewCustomAttributes = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
			$this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->fasttag_cl_balance->ViewCustomAttributes = "";

			// consignor
			$this->consignor->ViewValue = $this->consignor->CurrentValue;
			$curVal = strval($this->consignor->CurrentValue);
			if ($curVal <> "") {
				$this->consignor->ViewValue = $this->consignor->lookupCacheOption($curVal);
				if ($this->consignor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->consignor->ViewValue = $this->consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignor->ViewValue = $this->consignor->CurrentValue;
					}
				}
			} else {
				$this->consignor->ViewValue = NULL;
			}
			$this->consignor->ViewCustomAttributes = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
			$this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_comm->ViewCustomAttributes = "";

			// vehicle_freight_type
			if (strval($this->vehicle_freight_type->CurrentValue) <> "") {
				$this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
			} else {
				$this->vehicle_freight_type->ViewValue = NULL;
			}
			$this->vehicle_freight_type->ViewCustomAttributes = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
			$this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_amount->ViewCustomAttributes = "";

			// vehicle_freight_final
			$this->vehicle_freight_final->ViewValue = $this->vehicle_freight_final->CurrentValue;
			$this->vehicle_freight_final->ViewValue = FormatNumber($this->vehicle_freight_final->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_final->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";
			if (!$this->isExport())
				$this->id->ViewValue = $this->highlightValue($this->id);

			// vehicle_type
			$this->vehicle_type->LinkCustomAttributes = "";
			$this->vehicle_type->HrefValue = "";
			$this->vehicle_type->TooltipValue = "";

			// vehicle
			$this->vehicle->LinkCustomAttributes = "";
			$this->vehicle->HrefValue = "";
			$this->vehicle->TooltipValue = "";

			// route_name
			$this->route_name->LinkCustomAttributes = "";
			$this->route_name->HrefValue = "";
			$this->route_name->TooltipValue = "";
			if (!$this->isExport())
				$this->route_name->ViewValue = $this->highlightValue($this->route_name);

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			$this->buyer->HrefValue = "";
			$this->buyer->TooltipValue = "";

			// b_consignor
			$this->b_consignor->LinkCustomAttributes = "";
			$this->b_consignor->HrefValue = "";
			$this->b_consignor->TooltipValue = "";
			if (!$this->isExport())
				$this->b_consignor->ViewValue = $this->highlightValue($this->b_consignor);

			// b_consignee
			$this->b_consignee->LinkCustomAttributes = "";
			$this->b_consignee->HrefValue = "";
			$this->b_consignee->TooltipValue = "";
			if (!$this->isExport())
				$this->b_consignee->ViewValue = $this->highlightValue($this->b_consignee);

			// load_date
			$this->load_date->LinkCustomAttributes = "";
			$this->load_date->HrefValue = "";
			$this->load_date->TooltipValue = "";

			// load_weight
			$this->load_weight->LinkCustomAttributes = "";
			$this->load_weight->HrefValue = "";
			$this->load_weight->TooltipValue = "";

			// unload_date
			$this->unload_date->LinkCustomAttributes = "";
			$this->unload_date->HrefValue = "";
			$this->unload_date->TooltipValue = "";

			// unload_weight
			$this->unload_weight->LinkCustomAttributes = "";
			$this->unload_weight->HrefValue = "";
			$this->unload_weight->TooltipValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";
			$this->invoice_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// delivery_pod
			$this->delivery_pod->LinkCustomAttributes = "";
			$this->delivery_pod->HrefValue = "";
			$this->delivery_pod->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// days
			$this->days->LinkCustomAttributes = "";
			$this->days->HrefValue = "";
			$this->days->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";
			$this->driver->TooltipValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";
			$this->driver_name->TooltipValue = "";
			if (!$this->isExport())
				$this->driver_name->ViewValue = $this->highlightValue($this->driver_name);

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";
			$this->agent->TooltipValue = "";

			// comm
			$this->comm->LinkCustomAttributes = "";
			$this->comm->HrefValue = "";
			$this->comm->TooltipValue = "";

			// material
			$this->material->LinkCustomAttributes = "";
			$this->material->HrefValue = "";
			$this->material->TooltipValue = "";
			if (!$this->isExport())
				$this->material->ViewValue = $this->highlightValue($this->material);

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";
			if (!$this->isExport())
				$this->packing_type->ViewValue = $this->highlightValue($this->packing_type);

			// m_hsn
			$this->m_hsn->LinkCustomAttributes = "";
			$this->m_hsn->HrefValue = "";
			$this->m_hsn->TooltipValue = "";
			if (!$this->isExport())
				$this->m_hsn->ViewValue = $this->highlightValue($this->m_hsn);

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// lr_no
			$this->lr_no->LinkCustomAttributes = "";
			$this->lr_no->HrefValue = "";
			$this->lr_no->TooltipValue = "";
			if (!$this->isExport())
				$this->lr_no->ViewValue = $this->highlightValue($this->lr_no);

			// km
			$this->km->LinkCustomAttributes = "";
			$this->km->HrefValue = "";
			$this->km->TooltipValue = "";

			// freight_type
			$this->freight_type->LinkCustomAttributes = "";
			$this->freight_type->HrefValue = "";
			$this->freight_type->TooltipValue = "";

			// freight
			$this->freight->LinkCustomAttributes = "";
			$this->freight->HrefValue = "";
			$this->freight->TooltipValue = "";

			// ded_det
			$this->ded_det->LinkCustomAttributes = "";
			$this->ded_det->HrefValue = "";
			$this->ded_det->TooltipValue = "";

			// ded_det_remarks
			$this->ded_det_remarks->LinkCustomAttributes = "";
			$this->ded_det_remarks->HrefValue = "";
			$this->ded_det_remarks->TooltipValue = "";
			if (!$this->isExport())
				$this->ded_det_remarks->ViewValue = $this->highlightValue($this->ded_det_remarks);

			// gst_percent
			$this->gst_percent->LinkCustomAttributes = "";
			$this->gst_percent->HrefValue = "";
			$this->gst_percent->TooltipValue = "";

			// gst_amount
			$this->gst_amount->LinkCustomAttributes = "";
			$this->gst_amount->HrefValue = "";
			$this->gst_amount->TooltipValue = "";

			// final_amount
			$this->final_amount->LinkCustomAttributes = "";
			$this->final_amount->HrefValue = "";
			$this->final_amount->TooltipValue = "";

			// load_km
			$this->load_km->LinkCustomAttributes = "";
			$this->load_km->HrefValue = "";
			$this->load_km->TooltipValue = "";

			// unload_km
			$this->unload_km->LinkCustomAttributes = "";
			$this->unload_km->HrefValue = "";
			$this->unload_km->TooltipValue = "";

			// delivery_receipt
			$this->delivery_receipt->LinkCustomAttributes = "";
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
				$this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
			} else {
				$this->delivery_receipt->HrefValue = "";
			}
			$this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;
			$this->delivery_receipt->TooltipValue = "";
			if ($this->delivery_receipt->UseColorbox) {
				if (EmptyValue($this->delivery_receipt->TooltipValue))
					$this->delivery_receipt->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->delivery_receipt->LinkAttrs["data-rel"] = "t_trip_info_x" . $this->RowCnt . "_delivery_receipt";
				AppendClass($this->delivery_receipt->LinkAttrs["class"], "ew-lightbox");
			}

			// delivery_docket
			$this->delivery_docket->LinkCustomAttributes = "";
			$this->delivery_docket->HrefValue = "";
			$this->delivery_docket->TooltipValue = "";
			if (!$this->isExport())
				$this->delivery_docket->ViewValue = $this->highlightValue($this->delivery_docket);

			// diesal_op_b
			$this->diesal_op_b->LinkCustomAttributes = "";
			$this->diesal_op_b->HrefValue = "";
			$this->diesal_op_b->TooltipValue = "";

			// diesal_required
			$this->diesal_required->LinkCustomAttributes = "";
			$this->diesal_required->HrefValue = "";
			$this->diesal_required->TooltipValue = "";

			// diesal_fill
			$this->diesal_fill->LinkCustomAttributes = "";
			$this->diesal_fill->HrefValue = "";
			$this->diesal_fill->TooltipValue = "";

			// diesal_amount
			$this->diesal_amount->LinkCustomAttributes = "";
			$this->diesal_amount->HrefValue = "";
			$this->diesal_amount->TooltipValue = "";

			// diesal_cl_balance
			$this->diesal_cl_balance->LinkCustomAttributes = "";
			$this->diesal_cl_balance->HrefValue = "";
			$this->diesal_cl_balance->TooltipValue = "";

			// vehicle_average
			$this->vehicle_average->LinkCustomAttributes = "";
			$this->vehicle_average->HrefValue = "";
			$this->vehicle_average->TooltipValue = "";

			// cash_required
			$this->cash_required->LinkCustomAttributes = "";
			$this->cash_required->HrefValue = "";
			$this->cash_required->TooltipValue = "";

			// cash_op_b
			$this->cash_op_b->LinkCustomAttributes = "";
			$this->cash_op_b->HrefValue = "";
			$this->cash_op_b->TooltipValue = "";

			// cash_paid
			$this->cash_paid->LinkCustomAttributes = "";
			$this->cash_paid->HrefValue = "";
			$this->cash_paid->TooltipValue = "";

			// cash_expenses
			$this->cash_expenses->LinkCustomAttributes = "";
			$this->cash_expenses->HrefValue = "";
			$this->cash_expenses->TooltipValue = "";

			// cash_cl_balance
			$this->cash_cl_balance->LinkCustomAttributes = "";
			$this->cash_cl_balance->HrefValue = "";
			$this->cash_cl_balance->TooltipValue = "";

			// fasttag_op_b
			$this->fasttag_op_b->LinkCustomAttributes = "";
			$this->fasttag_op_b->HrefValue = "";
			$this->fasttag_op_b->TooltipValue = "";

			// fasttag_recharge
			$this->fasttag_recharge->LinkCustomAttributes = "";
			$this->fasttag_recharge->HrefValue = "";
			$this->fasttag_recharge->TooltipValue = "";

			// fasttag_expenses
			$this->fasttag_expenses->LinkCustomAttributes = "";
			$this->fasttag_expenses->HrefValue = "";
			$this->fasttag_expenses->TooltipValue = "";

			// toll_expenses_cash
			$this->toll_expenses_cash->LinkCustomAttributes = "";
			$this->toll_expenses_cash->HrefValue = "";
			$this->toll_expenses_cash->TooltipValue = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->LinkCustomAttributes = "";
			$this->fasttag_cl_balance->HrefValue = "";
			$this->fasttag_cl_balance->TooltipValue = "";

			// consignor
			$this->consignor->LinkCustomAttributes = "";
			$this->consignor->HrefValue = "";
			$this->consignor->TooltipValue = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->LinkCustomAttributes = "";
			$this->vehicle_freight_comm->HrefValue = "";
			$this->vehicle_freight_comm->TooltipValue = "";

			// vehicle_freight_type
			$this->vehicle_freight_type->LinkCustomAttributes = "";
			$this->vehicle_freight_type->HrefValue = "";
			$this->vehicle_freight_type->TooltipValue = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->LinkCustomAttributes = "";
			$this->vehicle_freight_amount->HrefValue = "";
			$this->vehicle_freight_amount->TooltipValue = "";

			// vehicle_freight_final
			$this->vehicle_freight_final->LinkCustomAttributes = "";
			$this->vehicle_freight_final->HrefValue = "";
			$this->vehicle_freight_final->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// vehicle_type
			$this->vehicle_type->EditAttrs["class"] = "form-control";
			$this->vehicle_type->EditCustomAttributes = "";
			$this->vehicle_type->EditValue = $this->vehicle_type->options(TRUE);

			// vehicle
			$this->vehicle->EditAttrs["class"] = "form-control";
			$this->vehicle->EditCustomAttributes = "";
			$this->vehicle->EditValue = HtmlEncode($this->vehicle->AdvancedSearch->SearchValue);
			$curVal = strval($this->vehicle->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->EditValue = HtmlEncode($this->vehicle->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->vehicle->EditValue = NULL;
			}
			$this->vehicle->PlaceHolder = RemoveHtml($this->vehicle->caption());

			// route_name
			$this->route_name->EditAttrs["class"] = "form-control";
			$this->route_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->route_name->AdvancedSearch->SearchValue = HtmlDecode($this->route_name->AdvancedSearch->SearchValue);
			$this->route_name->EditValue = HtmlEncode($this->route_name->AdvancedSearch->SearchValue);
			$this->route_name->PlaceHolder = RemoveHtml($this->route_name->caption());

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";

			// buyer
			$this->buyer->EditAttrs["class"] = "form-control";
			$this->buyer->EditCustomAttributes = "";
			$this->buyer->EditValue = HtmlEncode($this->buyer->AdvancedSearch->SearchValue);
			$curVal = strval($this->buyer->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->buyer->EditValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->buyer->EditValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->EditValue = HtmlEncode($this->buyer->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->buyer->EditValue = NULL;
			}
			$this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

			// b_consignor
			$this->b_consignor->EditAttrs["class"] = "form-control";
			$this->b_consignor->EditCustomAttributes = "";
			$this->b_consignor->EditValue = HtmlEncode($this->b_consignor->AdvancedSearch->SearchValue);
			$this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());
			$this->b_consignor->EditAttrs["class"] = "form-control";
			$this->b_consignor->EditCustomAttributes = "";
			$this->b_consignor->EditValue2 = HtmlEncode($this->b_consignor->AdvancedSearch->SearchValue2);
			$this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());

			// b_consignee
			$this->b_consignee->EditAttrs["class"] = "form-control";
			$this->b_consignee->EditCustomAttributes = "";
			$this->b_consignee->EditValue = HtmlEncode($this->b_consignee->AdvancedSearch->SearchValue);
			$this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());
			$this->b_consignee->EditAttrs["class"] = "form-control";
			$this->b_consignee->EditCustomAttributes = "";
			$this->b_consignee->EditValue2 = HtmlEncode($this->b_consignee->AdvancedSearch->SearchValue2);
			$this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());

			// load_date
			$this->load_date->EditAttrs["class"] = "form-control";
			$this->load_date->EditCustomAttributes = "";
			$this->load_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->load_date->AdvancedSearch->SearchValue, 1), 8));
			$this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

			// load_weight
			$this->load_weight->EditAttrs["class"] = "form-control";
			$this->load_weight->EditCustomAttributes = "";
			$this->load_weight->EditValue = HtmlEncode($this->load_weight->AdvancedSearch->SearchValue);
			$this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());

			// unload_date
			$this->unload_date->EditAttrs["class"] = "form-control";
			$this->unload_date->EditCustomAttributes = "";
			$this->unload_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->unload_date->AdvancedSearch->SearchValue, 0), 8));
			$this->unload_date->PlaceHolder = RemoveHtml($this->unload_date->caption());

			// unload_weight
			$this->unload_weight->EditAttrs["class"] = "form-control";
			$this->unload_weight->EditCustomAttributes = "";
			$this->unload_weight->EditValue = HtmlEncode($this->unload_weight->AdvancedSearch->SearchValue);
			$this->unload_weight->PlaceHolder = RemoveHtml($this->unload_weight->caption());

			// invoice_no
			$this->invoice_no->EditAttrs["class"] = "form-control";
			$this->invoice_no->EditCustomAttributes = "";
			$this->invoice_no->EditValue = HtmlEncode($this->invoice_no->AdvancedSearch->SearchValue);
			$this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue, 0), 8));
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue2, 0), 8));
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// delivery_pod
			$this->delivery_pod->EditCustomAttributes = "";
			$this->delivery_pod->EditValue = $this->delivery_pod->options(FALSE);

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// days
			$this->days->EditAttrs["class"] = "form-control";
			$this->days->EditCustomAttributes = "";
			$this->days->EditValue = HtmlEncode($this->days->AdvancedSearch->SearchValue);
			$this->days->PlaceHolder = RemoveHtml($this->days->caption());

			// driver
			$this->driver->EditAttrs["class"] = "form-control";
			$this->driver->EditCustomAttributes = "";

			// driver_name
			$this->driver_name->EditAttrs["class"] = "form-control";
			$this->driver_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->driver_name->AdvancedSearch->SearchValue = HtmlDecode($this->driver_name->AdvancedSearch->SearchValue);
			$this->driver_name->EditValue = HtmlEncode($this->driver_name->AdvancedSearch->SearchValue);
			$this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

			// agent
			$this->agent->EditAttrs["class"] = "form-control";
			$this->agent->EditCustomAttributes = "";
			$this->agent->EditValue = HtmlEncode($this->agent->AdvancedSearch->SearchValue);
			$this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

			// comm
			$this->comm->EditAttrs["class"] = "form-control";
			$this->comm->EditCustomAttributes = "";
			$this->comm->EditValue = HtmlEncode($this->comm->AdvancedSearch->SearchValue);
			$this->comm->PlaceHolder = RemoveHtml($this->comm->caption());

			// material
			$this->material->EditAttrs["class"] = "form-control";
			$this->material->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->material->AdvancedSearch->SearchValue = HtmlDecode($this->material->AdvancedSearch->SearchValue);
			$this->material->EditValue = HtmlEncode($this->material->AdvancedSearch->SearchValue);
			$this->material->PlaceHolder = RemoveHtml($this->material->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->packing_type->AdvancedSearch->SearchValue = HtmlDecode($this->packing_type->AdvancedSearch->SearchValue);
			$this->packing_type->EditValue = HtmlEncode($this->packing_type->AdvancedSearch->SearchValue);
			$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

			// m_hsn
			$this->m_hsn->EditAttrs["class"] = "form-control";
			$this->m_hsn->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->m_hsn->AdvancedSearch->SearchValue = HtmlDecode($this->m_hsn->AdvancedSearch->SearchValue);
			$this->m_hsn->EditValue = HtmlEncode($this->m_hsn->AdvancedSearch->SearchValue);
			$this->m_hsn->PlaceHolder = RemoveHtml($this->m_hsn->caption());

			// @
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			$this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

			// lr_no
			$this->lr_no->EditAttrs["class"] = "form-control";
			$this->lr_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lr_no->AdvancedSearch->SearchValue = HtmlDecode($this->lr_no->AdvancedSearch->SearchValue);
			$this->lr_no->EditValue = HtmlEncode($this->lr_no->AdvancedSearch->SearchValue);
			$this->lr_no->PlaceHolder = RemoveHtml($this->lr_no->caption());

			// km
			$this->km->EditAttrs["class"] = "form-control";
			$this->km->EditCustomAttributes = "";
			$this->km->EditValue = HtmlEncode($this->km->AdvancedSearch->SearchValue);
			$this->km->PlaceHolder = RemoveHtml($this->km->caption());

			// freight_type
			$this->freight_type->EditAttrs["class"] = "form-control";
			$this->freight_type->EditCustomAttributes = "";
			$this->freight_type->EditValue = $this->freight_type->options(TRUE);

			// freight
			$this->freight->EditAttrs["class"] = "form-control";
			$this->freight->EditCustomAttributes = "";
			$this->freight->EditValue = HtmlEncode($this->freight->AdvancedSearch->SearchValue);
			$this->freight->PlaceHolder = RemoveHtml($this->freight->caption());

			// ded_det
			$this->ded_det->EditAttrs["class"] = "form-control";
			$this->ded_det->EditCustomAttributes = "";
			$this->ded_det->EditValue = HtmlEncode($this->ded_det->AdvancedSearch->SearchValue);
			$this->ded_det->PlaceHolder = RemoveHtml($this->ded_det->caption());

			// ded_det_remarks
			$this->ded_det_remarks->EditAttrs["class"] = "form-control";
			$this->ded_det_remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ded_det_remarks->AdvancedSearch->SearchValue = HtmlDecode($this->ded_det_remarks->AdvancedSearch->SearchValue);
			$this->ded_det_remarks->EditValue = HtmlEncode($this->ded_det_remarks->AdvancedSearch->SearchValue);
			$this->ded_det_remarks->PlaceHolder = RemoveHtml($this->ded_det_remarks->caption());

			// gst_percent
			$this->gst_percent->EditAttrs["class"] = "form-control";
			$this->gst_percent->EditCustomAttributes = "";
			$this->gst_percent->EditValue = HtmlEncode($this->gst_percent->AdvancedSearch->SearchValue);
			$this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());

			// gst_amount
			$this->gst_amount->EditAttrs["class"] = "form-control";
			$this->gst_amount->EditCustomAttributes = "";
			$this->gst_amount->EditValue = HtmlEncode($this->gst_amount->AdvancedSearch->SearchValue);
			$this->gst_amount->PlaceHolder = RemoveHtml($this->gst_amount->caption());

			// final_amount
			$this->final_amount->EditAttrs["class"] = "form-control";
			$this->final_amount->EditCustomAttributes = "";
			$this->final_amount->EditValue = HtmlEncode($this->final_amount->AdvancedSearch->SearchValue);
			$this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());

			// load_km
			$this->load_km->EditAttrs["class"] = "form-control";
			$this->load_km->EditCustomAttributes = "";
			$this->load_km->EditValue = HtmlEncode($this->load_km->AdvancedSearch->SearchValue);
			$this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());

			// unload_km
			$this->unload_km->EditAttrs["class"] = "form-control";
			$this->unload_km->EditCustomAttributes = "";
			$this->unload_km->EditValue = HtmlEncode($this->unload_km->AdvancedSearch->SearchValue);
			$this->unload_km->PlaceHolder = RemoveHtml($this->unload_km->caption());

			// delivery_receipt
			$this->delivery_receipt->EditAttrs["class"] = "form-control";
			$this->delivery_receipt->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->delivery_receipt->AdvancedSearch->SearchValue = HtmlDecode($this->delivery_receipt->AdvancedSearch->SearchValue);
			$this->delivery_receipt->EditValue = HtmlEncode($this->delivery_receipt->AdvancedSearch->SearchValue);
			$this->delivery_receipt->PlaceHolder = RemoveHtml($this->delivery_receipt->caption());

			// delivery_docket
			$this->delivery_docket->EditAttrs["class"] = "form-control";
			$this->delivery_docket->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->delivery_docket->AdvancedSearch->SearchValue = HtmlDecode($this->delivery_docket->AdvancedSearch->SearchValue);
			$this->delivery_docket->EditValue = HtmlEncode($this->delivery_docket->AdvancedSearch->SearchValue);
			$this->delivery_docket->PlaceHolder = RemoveHtml($this->delivery_docket->caption());

			// diesal_op_b
			$this->diesal_op_b->EditAttrs["class"] = "form-control";
			$this->diesal_op_b->EditCustomAttributes = "";
			$this->diesal_op_b->EditValue = HtmlEncode($this->diesal_op_b->AdvancedSearch->SearchValue);
			$this->diesal_op_b->PlaceHolder = RemoveHtml($this->diesal_op_b->caption());

			// diesal_required
			$this->diesal_required->EditAttrs["class"] = "form-control";
			$this->diesal_required->EditCustomAttributes = "";
			$this->diesal_required->EditValue = HtmlEncode($this->diesal_required->AdvancedSearch->SearchValue);
			$this->diesal_required->PlaceHolder = RemoveHtml($this->diesal_required->caption());

			// diesal_fill
			$this->diesal_fill->EditAttrs["class"] = "form-control";
			$this->diesal_fill->EditCustomAttributes = "";
			$this->diesal_fill->EditValue = HtmlEncode($this->diesal_fill->AdvancedSearch->SearchValue);
			$this->diesal_fill->PlaceHolder = RemoveHtml($this->diesal_fill->caption());

			// diesal_amount
			$this->diesal_amount->EditAttrs["class"] = "form-control";
			$this->diesal_amount->EditCustomAttributes = "";
			$this->diesal_amount->EditValue = HtmlEncode($this->diesal_amount->AdvancedSearch->SearchValue);
			$this->diesal_amount->PlaceHolder = RemoveHtml($this->diesal_amount->caption());

			// diesal_cl_balance
			$this->diesal_cl_balance->EditAttrs["class"] = "form-control";
			$this->diesal_cl_balance->EditCustomAttributes = "";
			$this->diesal_cl_balance->EditValue = HtmlEncode($this->diesal_cl_balance->AdvancedSearch->SearchValue);
			$this->diesal_cl_balance->PlaceHolder = RemoveHtml($this->diesal_cl_balance->caption());

			// vehicle_average
			$this->vehicle_average->EditAttrs["class"] = "form-control";
			$this->vehicle_average->EditCustomAttributes = "";
			$this->vehicle_average->EditValue = HtmlEncode($this->vehicle_average->AdvancedSearch->SearchValue);
			$this->vehicle_average->PlaceHolder = RemoveHtml($this->vehicle_average->caption());

			// cash_required
			$this->cash_required->EditAttrs["class"] = "form-control";
			$this->cash_required->EditCustomAttributes = "";
			$this->cash_required->EditValue = HtmlEncode($this->cash_required->AdvancedSearch->SearchValue);
			$this->cash_required->PlaceHolder = RemoveHtml($this->cash_required->caption());

			// cash_op_b
			$this->cash_op_b->EditAttrs["class"] = "form-control";
			$this->cash_op_b->EditCustomAttributes = "";
			$this->cash_op_b->EditValue = HtmlEncode($this->cash_op_b->AdvancedSearch->SearchValue);
			$this->cash_op_b->PlaceHolder = RemoveHtml($this->cash_op_b->caption());

			// cash_paid
			$this->cash_paid->EditAttrs["class"] = "form-control";
			$this->cash_paid->EditCustomAttributes = "";
			$this->cash_paid->EditValue = HtmlEncode($this->cash_paid->AdvancedSearch->SearchValue);
			$this->cash_paid->PlaceHolder = RemoveHtml($this->cash_paid->caption());

			// cash_expenses
			$this->cash_expenses->EditAttrs["class"] = "form-control";
			$this->cash_expenses->EditCustomAttributes = "";
			$this->cash_expenses->EditValue = HtmlEncode($this->cash_expenses->AdvancedSearch->SearchValue);
			$this->cash_expenses->PlaceHolder = RemoveHtml($this->cash_expenses->caption());

			// cash_cl_balance
			$this->cash_cl_balance->EditAttrs["class"] = "form-control";
			$this->cash_cl_balance->EditCustomAttributes = "";
			$this->cash_cl_balance->EditValue = HtmlEncode($this->cash_cl_balance->AdvancedSearch->SearchValue);
			$this->cash_cl_balance->PlaceHolder = RemoveHtml($this->cash_cl_balance->caption());

			// fasttag_op_b
			$this->fasttag_op_b->EditAttrs["class"] = "form-control";
			$this->fasttag_op_b->EditCustomAttributes = "";
			$this->fasttag_op_b->EditValue = HtmlEncode($this->fasttag_op_b->AdvancedSearch->SearchValue);
			$this->fasttag_op_b->PlaceHolder = RemoveHtml($this->fasttag_op_b->caption());

			// fasttag_recharge
			$this->fasttag_recharge->EditAttrs["class"] = "form-control";
			$this->fasttag_recharge->EditCustomAttributes = "";
			$this->fasttag_recharge->EditValue = HtmlEncode($this->fasttag_recharge->AdvancedSearch->SearchValue);
			$this->fasttag_recharge->PlaceHolder = RemoveHtml($this->fasttag_recharge->caption());

			// fasttag_expenses
			$this->fasttag_expenses->EditAttrs["class"] = "form-control";
			$this->fasttag_expenses->EditCustomAttributes = "";
			$this->fasttag_expenses->EditValue = HtmlEncode($this->fasttag_expenses->AdvancedSearch->SearchValue);
			$this->fasttag_expenses->PlaceHolder = RemoveHtml($this->fasttag_expenses->caption());

			// toll_expenses_cash
			$this->toll_expenses_cash->EditAttrs["class"] = "form-control";
			$this->toll_expenses_cash->EditCustomAttributes = "";
			$this->toll_expenses_cash->EditValue = HtmlEncode($this->toll_expenses_cash->AdvancedSearch->SearchValue);
			$this->toll_expenses_cash->PlaceHolder = RemoveHtml($this->toll_expenses_cash->caption());

			// fasttag_cl_balance
			$this->fasttag_cl_balance->EditAttrs["class"] = "form-control";
			$this->fasttag_cl_balance->EditCustomAttributes = "";
			$this->fasttag_cl_balance->EditValue = HtmlEncode($this->fasttag_cl_balance->AdvancedSearch->SearchValue);
			$this->fasttag_cl_balance->PlaceHolder = RemoveHtml($this->fasttag_cl_balance->caption());

			// consignor
			$this->consignor->EditAttrs["class"] = "form-control";
			$this->consignor->EditCustomAttributes = 'ReadOnly';
			$this->consignor->EditValue = HtmlEncode($this->consignor->AdvancedSearch->SearchValue);
			$this->consignor->PlaceHolder = RemoveHtml($this->consignor->caption());

			// vehicle_freight_comm
			$this->vehicle_freight_comm->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_comm->EditCustomAttributes = "";
			$this->vehicle_freight_comm->EditValue = HtmlEncode($this->vehicle_freight_comm->AdvancedSearch->SearchValue);
			$this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());

			// vehicle_freight_type
			$this->vehicle_freight_type->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_type->EditCustomAttributes = "";
			$this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(TRUE);

			// vehicle_freight_amount
			$this->vehicle_freight_amount->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_amount->EditCustomAttributes = "";
			$this->vehicle_freight_amount->EditValue = HtmlEncode($this->vehicle_freight_amount->AdvancedSearch->SearchValue);
			$this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());

			// vehicle_freight_final
			$this->vehicle_freight_final->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_final->EditCustomAttributes = "";
			$this->vehicle_freight_final->EditValue = HtmlEncode($this->vehicle_freight_final->AdvancedSearch->SearchValue);
			$this->vehicle_freight_final->PlaceHolder = RemoveHtml($this->vehicle_freight_final->caption());

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->vehicle->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->vehicle->errorMessage());
		}
		if (!CheckInteger($this->buyer->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->buyer->errorMessage());
		}
		if (!CheckDate($this->load_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->load_date->errorMessage());
		}
		if (!CheckDate($this->unload_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->unload_date->errorMessage());
		}
		if (!CheckDate($this->invoice_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->invoice_date->errorMessage());
		}
		if (!CheckDate($this->invoice_date->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->invoice_date->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->vehicle_type->AdvancedSearch->load();
		$this->vehicle->AdvancedSearch->load();
		$this->_route->AdvancedSearch->load();
		$this->route_name->AdvancedSearch->load();
		$this->reports_to->AdvancedSearch->load();
		$this->buyer->AdvancedSearch->load();
		$this->b_consignor->AdvancedSearch->load();
		$this->b_consignee->AdvancedSearch->load();
		$this->load_date->AdvancedSearch->load();
		$this->load_weight->AdvancedSearch->load();
		$this->unload_date->AdvancedSearch->load();
		$this->unload_weight->AdvancedSearch->load();
		$this->invoice_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->delivery_pod->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->days->AdvancedSearch->load();
		$this->driver->AdvancedSearch->load();
		$this->driver_name->AdvancedSearch->load();
		$this->agent->AdvancedSearch->load();
		$this->comm->AdvancedSearch->load();
		$this->material->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->m_hsn->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->lr_no->AdvancedSearch->load();
		$this->km->AdvancedSearch->load();
		$this->freight_type->AdvancedSearch->load();
		$this->freight->AdvancedSearch->load();
		$this->ded_det->AdvancedSearch->load();
		$this->ded_det_remarks->AdvancedSearch->load();
		$this->gst_percent->AdvancedSearch->load();
		$this->gst_amount->AdvancedSearch->load();
		$this->final_amount->AdvancedSearch->load();
		$this->load_km->AdvancedSearch->load();
		$this->unload_km->AdvancedSearch->load();
		$this->delivery_receipt->AdvancedSearch->load();
		$this->delivery_docket->AdvancedSearch->load();
		$this->diesal_op_b->AdvancedSearch->load();
		$this->diesal_required->AdvancedSearch->load();
		$this->diesal_fill->AdvancedSearch->load();
		$this->diesal_amount->AdvancedSearch->load();
		$this->diesal_cl_balance->AdvancedSearch->load();
		$this->vehicle_average->AdvancedSearch->load();
		$this->cash_required->AdvancedSearch->load();
		$this->cash_op_b->AdvancedSearch->load();
		$this->cash_paid->AdvancedSearch->load();
		$this->cash_expenses->AdvancedSearch->load();
		$this->cash_cl_balance->AdvancedSearch->load();
		$this->fasttag_op_b->AdvancedSearch->load();
		$this->fasttag_recharge->AdvancedSearch->load();
		$this->fasttag_expenses->AdvancedSearch->load();
		$this->toll_expenses_cash->AdvancedSearch->load();
		$this->fasttag_cl_balance->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->uploads->AdvancedSearch->load();
		$this->consignor->AdvancedSearch->load();
		$this->vehicle_freight_comm->AdvancedSearch->load();
		$this->vehicle_freight_type->AdvancedSearch->load();
		$this->vehicle_freight_amount->AdvancedSearch->load();
		$this->vehicle_freight_final->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Get export HTML tag
	protected function getExportTag($type, $custom = FALSE)
	{
		global $Language;
		if (SameText($type, "excel")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" onclick=\"ew.export(document.ft_trip_infolist,'" . $this->ExportExcelUrl . "','excel',true);\">" . $Language->phrase("ExportToExcel") . "</a>";
			else
				return "<a href=\"" . $this->ExportExcelUrl . "\" class=\"ew-export-link ew-excel\" title=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToExcelText")) . "\">" . $Language->phrase("ExportToExcel") . "</a>";
		} elseif (SameText($type, "word")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" onclick=\"ew.export(document.ft_trip_infolist,'" . $this->ExportWordUrl . "','word',true);\">" . $Language->phrase("ExportToWord") . "</a>";
			else
				return "<a href=\"" . $this->ExportWordUrl . "\" class=\"ew-export-link ew-word\" title=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToWordText")) . "\">" . $Language->phrase("ExportToWord") . "</a>";
		} elseif (SameText($type, "pdf")) {
			if ($custom)
				return "<a href=\"javascript:void(0);\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" onclick=\"ew.export(document.ft_trip_infolist,'" . $this->ExportPdfUrl . "','pdf',true);\">" . $Language->phrase("ExportToPDF") . "</a>";
			else
				return "<a href=\"" . $this->ExportPdfUrl . "\" class=\"ew-export-link ew-pdf\" title=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToPDFText")) . "\">" . $Language->phrase("ExportToPDF") . "</a>";
		} elseif (SameText($type, "html")) {
			return "<a href=\"" . $this->ExportHtmlUrl . "\" class=\"ew-export-link ew-html\" title=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToHtmlText")) . "\">" . $Language->phrase("ExportToHtml") . "</a>";
		} elseif (SameText($type, "xml")) {
			return "<a href=\"" . $this->ExportXmlUrl . "\" class=\"ew-export-link ew-xml\" title=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToXmlText")) . "\">" . $Language->phrase("ExportToXml") . "</a>";
		} elseif (SameText($type, "csv")) {
			return "<a href=\"" . $this->ExportCsvUrl . "\" class=\"ew-export-link ew-csv\" title=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("ExportToCsvText")) . "\">" . $Language->phrase("ExportToCsv") . "</a>";
		} elseif (SameText($type, "print")) {
			return "<a href=\"" . $this->ExportPrintUrl . "\" class=\"ew-export-link ew-print\" title=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\" data-caption=\"" . HtmlEncode($Language->phrase("PrinterFriendlyText")) . "\">" . $Language->phrase("PrinterFriendly") . "</a>";
		}
	}

	// Set up export options
	protected function setupExportOptions()
	{
		global $Language;

		// Printer friendly
		$item = &$this->ExportOptions->add("print");
		$item->Body = $this->getExportTag("print");
		$item->Visible = TRUE;

		// Export to Excel
		$item = &$this->ExportOptions->add("excel");
		$item->Body = $this->getExportTag("excel");
		$item->Visible = TRUE;

		// Export to Word
		$item = &$this->ExportOptions->add("word");
		$item->Body = $this->getExportTag("word");
		$item->Visible = FALSE;

		// Export to Html
		$item = &$this->ExportOptions->add("html");
		$item->Body = $this->getExportTag("html");
		$item->Visible = FALSE;

		// Export to Xml
		$item = &$this->ExportOptions->add("xml");
		$item->Body = $this->getExportTag("xml");
		$item->Visible = FALSE;

		// Export to Csv
		$item = &$this->ExportOptions->add("csv");
		$item->Body = $this->getExportTag("csv");
		$item->Visible = TRUE;

		// Export to Pdf
		$item = &$this->ExportOptions->add("pdf");
		$item->Body = $this->getExportTag("pdf");
		$item->Visible = TRUE;

		// Export to Email
		$item = &$this->ExportOptions->add("email");
		$url = "";
		$item->Body = "<button id=\"emf_t_trip_info\" class=\"ew-export-link ew-email\" title=\"" . $Language->phrase("ExportToEmailText") . "\" data-caption=\"" . $Language->phrase("ExportToEmailText") . "\" onclick=\"ew.emailDialogShow({lnk:'emf_t_trip_info',hdr:ew.language.phrase('ExportToEmailText'),f:document.ft_trip_infolist,sel:false" . $url . "});\">" . $Language->phrase("ExportToEmail") . "</button>";
		$item->Visible = FALSE;

		// Drop down button for export
		$this->ExportOptions->UseButtonGroup = TRUE;
		$this->ExportOptions->UseDropDownButton = TRUE;
		if ($this->ExportOptions->UseButtonGroup && IsMobile())
			$this->ExportOptions->UseDropDownButton = TRUE;
		$this->ExportOptions->DropDownButtonPhrase = $Language->phrase("ButtonExport");

		// Add group option item
		$item = &$this->ExportOptions->add($this->ExportOptions->GroupOptionName);
		$item->Body = "";
		$item->Visible = FALSE;
	}

	/**
	 * Export data in HTML/CSV/Word/Excel/XML/Email/PDF format
	 *
	 * @param boolean $return Return the data rather than output it
	 * @return mixed 
	 */
	public function exportData($return = FALSE)
	{
		global $Language;
		$utf8 = SameText(PROJECT_CHARSET, "utf-8");
		$selectLimit = $this->UseSelectLimit;

		// Load recordset
		if ($selectLimit) {
			$this->TotalRecs = $this->listRecordCount();
		} else {
			if (!$this->Recordset)
				$this->Recordset = $this->loadRecordset();
			$rs = &$this->Recordset;
			if ($rs)
				$this->TotalRecs = $rs->RecordCount();
		}
		$this->StartRec = 1;

		// Export all
		if ($this->ExportAll) {
			set_time_limit(EXPORT_ALL_TIME_LIMIT);
			$this->DisplayRecs = $this->TotalRecs;
			$this->StopRec = $this->TotalRecs;
		} else { // Export one page only
			$this->setupStartRec(); // Set up start record position

			// Set the last record to display
			if ($this->DisplayRecs <= 0) {
				$this->StopRec = $this->TotalRecs;
			} else {
				$this->StopRec = $this->StartRec + $this->DisplayRecs - 1;
			}
		}
		if ($selectLimit)
			$rs = $this->loadRecordset($this->StartRec - 1, $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs);
		$this->ExportDoc = GetExportDocument($this, "h");
		$doc = &$this->ExportDoc;
		if (!$doc)
			$this->setFailureMessage($Language->phrase("ExportClassNotFound")); // Export class not found
		if (!$rs || !$doc) {
			RemoveHeader("Content-Type"); // Remove header
			RemoveHeader("Content-Disposition");
			$this->showMessage();
			return;
		}
		if ($selectLimit) {
			$this->StartRec = 1;
			$this->StopRec = $this->DisplayRecs <= 0 ? $this->TotalRecs : $this->DisplayRecs;
		}

		// Call Page Exporting server event
		$this->ExportDoc->ExportCustom = !$this->Page_Exporting();
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		$doc->Text .= $header;
		$this->exportDocument($doc, $rs, $this->StartRec, $this->StopRec, "");
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		$doc->Text .= $footer;

		// Close recordset
		$rs->close();

		// Call Page Exported server event
		$this->Page_Exported();

		// Export header and footer
		$doc->exportHeaderAndFooter();

		// Clean output buffer (without destroying output buffer)
		$buffer = ob_get_contents(); // Save the output buffer
		if (!DEBUG_ENABLED && $buffer)
			ob_clean();

		// Write debug message if enabled
		if (DEBUG_ENABLED && !$this->isExport("pdf"))
			echo GetDebugMessage();

		// Output data
		if ($this->isExport("email")) {

			// Export-to-email disabled
		} else {
			$doc->export();
			if ($return) {
				RemoveHeader("Content-Type"); // Remove header
				RemoveHeader("Content-Disposition");
				$content = ob_get_contents();
				if ($content)
					ob_clean();
				if ($buffer)
					echo $buffer; // Resume the output buffer
				return $content;
			}
		}
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$url = preg_replace('/\?cmd=reset(all){0,1}$/i', '', $url); // Remove cmd=reset / cmd=resetall
		$Breadcrumb->add("list", $this->TableVar, $url, "", $this->TableVar, TRUE);
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_vehicle":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x__route":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_reports_to":
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyer":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignor":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignee":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_driver":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignor":
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_vehicle":
							break;
						case "x__route":
							break;
						case "x_reports_to":
							break;
						case "x_buyer":
							break;
						case "x_b_consignor":
							break;
						case "x_b_consignee":
							break;
						case "x_driver":
							break;
						case "x_agent":
							break;
						case "x_consignor":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'t_trip_info');	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}

	// ListOptions Load event
	function ListOptions_Load() {

		// Example:
		//$opt = &$this->ListOptions->Add("new");
		//$opt->Header = "xxx";
		//$opt->OnLeft = TRUE; // Link on left
		//$opt->MoveTo(0); // Move to first column

	}

	// ListOptions Rendering event
	function ListOptions_Rendering() {

		//$GLOBALS["xxx_grid"]->DetailAdd = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailEdit = (...condition...); // Set to TRUE or FALSE conditionally
		//$GLOBALS["xxx_grid"]->DetailView = (...condition...); // Set to TRUE or FALSE conditionally

	}

	// ListOptions Rendered event
	function ListOptions_Rendered() {

		// Example:
		//$this->ListOptions->Items["new"]->Body = "xxx";

		$bpdf = '.p_uploads/trip_documents/'.$this->id->CurrentValue.'/Bilty_'.$this->id->CurrentValue.'.pdf';
		IF (file_exists($bpdf))
		{
		$this->ListOptions->Add("ReGenerate Bilti");
		$this->ListOptions->Items["ReGenerate Bilti"]->MoveTo(11);
		$this->ListOptions->Items["ReGenerate Bilti"]->Body =
			'<a href="autoprogramme.php?apcid=1a0a283bfe7c549dee6c638a05200e32&bi=' . $this->id->CurrentValue . '" data-original-title ="ReGenerate Bilti"><i data-phrase="ReGenerate Bilti"  class="fa fa-plus-circle ew-icon" style="color:red" ></i></a>';
		$this->ListOptions->Add("Download Bilti");
		$this->ListOptions->Items["Download Bilti"]->MoveTo(12);
		$this->ListOptions->Items["Download Bilti"]->Body =
			'<a href='.$bpdf.' data-original-title ="Download Bilti" download><i data-phrase="Download Bilti"  class="fa fa-file-pdf-o fa-2x" style="color:orange"></i></a>';		
		}
		else
		{
		$this->ListOptions->Add("Generate Bilti");
		$this->ListOptions->Items["Generate Bilti"]->MoveTo(10);	
		$this->ListOptions->Items["Generate Bilti"]->Body =
			'<a href="autoprogramme.php?apcid=1a0a283bfe7c549dee6c638a05200e32&bi=' . $this->id->CurrentValue . '" data-original-title ="Generate Bilti"><i data-phrase="Generate Bilti"  class="fa fa-plus-circle ew-icon" style="color:green" ></i></a>';
		}
		IF ($this->invoice_no->CurrentValue == 0)
		{
		$this->ListOptions->Add("Generate Invoice");
		$this->ListOptions->Items["Generate Invoice"]->MoveTo(13);	
		$this->ListOptions->Items["Generate Invoice"]->Body =
			'<a href="autoprogramme.php?apcid=c5866e93cab1776890fe343c9e7063fb&ti=' . $this->id->CurrentValue . '" data-original-title ="Generate Invoice"><i data-phrase="Generate Invoice"  class="fa fa-plus-circle ew-icon" style="color:green" ></i></a>';
		}
		IF ($this->invoice_no->CurrentValue > 0)
		{
		$this->ListOptions->Add("ReGenerate Invoice");
		$this->ListOptions->Items["ReGenerate Invoice"]->MoveTo(14);
		$this->ListOptions->Items["ReGenerate Invoice"]->Body =
			'<a href="autoprogramme.php?apcid=c5866e93cab1776890fe343c9e7063fb&ti=' . $this->id->CurrentValue . '" data-original-title ="ReGenerate Invoice"><i data-phrase="ReGenerate Invoice"  class="fa fa-plus-circle ew-icon" style="color:red"></i></a>';
		}
		$pdf = '.p_uploads/trip_documents/'.$this->id->CurrentValue.'/'.$this->invoice_no->CurrentValue.'.pdf';
		IF (($this->invoice_no->CurrentValue > 0) && (file_exists($pdf)))
		{
		$this->ListOptions->Add("Download Invoice");
		$this->ListOptions->Items["Download Invoice"]->MoveTo(15);	
		$this->ListOptions->Items["Download Invoice"]->Body =
			'<a href='.$pdf.' data-original-title ="Download Invoice" download><i data-phrase="Download Invoice"  class="fa fa-file-pdf-o fa-2x" style="color:Blue" ></i></a>';
		}
	}

	// Row Custom Action event
	function Row_CustomAction($action, $row) {

		// Return FALSE to abort
		return TRUE;
	}

	// Page Exporting event
	// $this->ExportDoc = export document object
	function Page_Exporting() {

		//$this->ExportDoc->Text = "my header"; // Export header
		//return FALSE; // Return FALSE to skip default export and use Row_Export event

		return TRUE; // Return TRUE to use default export and skip Row_Export event
	}

	// Row Export event
	// $this->ExportDoc = export document object
	function Row_Export($rs) {

		//$this->ExportDoc->Text .= "my content"; // Build HTML with field value: $rs["MyField"] or $this->MyField->ViewValue
	}

	// Page Exported event
	// $this->ExportDoc = export document object
	function Page_Exported() {

		//$this->ExportDoc->Text .= "my footer"; // Export footer
		//echo $this->ExportDoc->Text;

	}

	// Page Importing event
	function Page_Importing($reader, &$options) {

		//var_dump($reader); // Import data reader
		//var_dump($options); // Show all options for importing
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Row Import event
	function Row_Import(&$row, $cnt) {

		//echo $cnt; // Import record count
		//var_dump($row); // Import row
		//return FALSE; // Return FALSE to skip import

		return TRUE;
	}

	// Page Imported event
	function Page_Imported($reader, $results) {

		//var_dump($reader); // Import data reader
		//var_dump($results); // Import results

	}
}
?>