<?php
namespace PHPMaker2019\fibre;

/**
 * Page class
 */
class t_trip_info_search extends t_trip_info
{

	// Page ID
	public $PageID = "search";

	// Project ID
	public $ProjectID = "{35519383-E854-4896-B7FE-F1EF427E7E68}";

	// Table name
	public $TableName = 't_trip_info';

	// Page object name
	public $PageObjName = "t_trip_info_search";

	// Page headings
	public $Heading = "";
	public $Subheading = "";
	public $PageHeader;
	public $PageFooter;

	// Token
	public $Token = "";
	public $TokenTimeout = 0;
	public $CheckToken = CHECK_TOKEN;

	// Messages
	private $_message = "";
	private $_failureMessage = "";
	private $_successMessage = "";
	private $_warningMessage = "";

	// Page URL
	private $_pageUrl = "";

	// Page heading
	public function pageHeading()
	{
		global $Language;
		if ($this->Heading <> "")
			return $this->Heading;
		if (method_exists($this, "tableCaption"))
			return $this->tableCaption();
		return "";
	}

	// Page subheading
	public function pageSubheading()
	{
		global $Language;
		if ($this->Subheading <> "")
			return $this->Subheading;
		if ($this->TableName)
			return $Language->phrase($this->PageID);
		return "";
	}

	// Page name
	public function pageName()
	{
		return CurrentPageName();
	}

	// Page URL
	public function pageUrl()
	{
		if ($this->_pageUrl == "") {
			$this->_pageUrl = CurrentPageName() . "?";
			if ($this->UseTokenInUrl)
				$this->_pageUrl .= "t=" . $this->TableVar . "&"; // Add page token
		}
		return $this->_pageUrl;
	}

	// Get message
	public function getMessage()
	{
		return isset($_SESSION[SESSION_MESSAGE]) ? $_SESSION[SESSION_MESSAGE] : $this->_message;
	}

	// Set message
	public function setMessage($v)
	{
		AddMessage($this->_message, $v);
		$_SESSION[SESSION_MESSAGE] = $this->_message;
	}

	// Get failure message
	public function getFailureMessage()
	{
		return isset($_SESSION[SESSION_FAILURE_MESSAGE]) ? $_SESSION[SESSION_FAILURE_MESSAGE] : $this->_failureMessage;
	}

	// Set failure message
	public function setFailureMessage($v)
	{
		AddMessage($this->_failureMessage, $v);
		$_SESSION[SESSION_FAILURE_MESSAGE] = $this->_failureMessage;
	}

	// Get success message
	public function getSuccessMessage()
	{
		return isset($_SESSION[SESSION_SUCCESS_MESSAGE]) ? $_SESSION[SESSION_SUCCESS_MESSAGE] : $this->_successMessage;
	}

	// Set success message
	public function setSuccessMessage($v)
	{
		AddMessage($this->_successMessage, $v);
		$_SESSION[SESSION_SUCCESS_MESSAGE] = $this->_successMessage;
	}

	// Get warning message
	public function getWarningMessage()
	{
		return isset($_SESSION[SESSION_WARNING_MESSAGE]) ? $_SESSION[SESSION_WARNING_MESSAGE] : $this->_warningMessage;
	}

	// Set warning message
	public function setWarningMessage($v)
	{
		AddMessage($this->_warningMessage, $v);
		$_SESSION[SESSION_WARNING_MESSAGE] = $this->_warningMessage;
	}

	// Clear message
	public function clearMessage()
	{
		$this->_message = "";
		$_SESSION[SESSION_MESSAGE] = "";
	}

	// Clear failure message
	public function clearFailureMessage()
	{
		$this->_failureMessage = "";
		$_SESSION[SESSION_FAILURE_MESSAGE] = "";
	}

	// Clear success message
	public function clearSuccessMessage()
	{
		$this->_successMessage = "";
		$_SESSION[SESSION_SUCCESS_MESSAGE] = "";
	}

	// Clear warning message
	public function clearWarningMessage()
	{
		$this->_warningMessage = "";
		$_SESSION[SESSION_WARNING_MESSAGE] = "";
	}

	// Clear messages
	public function clearMessages()
	{
		$this->clearMessage();
		$this->clearFailureMessage();
		$this->clearSuccessMessage();
		$this->clearWarningMessage();
	}

	// Show message
	public function showMessage()
	{
		$hidden = FALSE;
		$html = "";

		// Message
		$message = $this->getMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($message, "");
		if ($message <> "") { // Message in Session, display
			if (!$hidden)
				$message = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $message;
			$html .= '<div class="alert alert-info alert-dismissible ew-info"><i class="icon fa fa-info"></i>' . $message . '</div>';
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($warningMessage, "warning");
		if ($warningMessage <> "") { // Message in Session, display
			if (!$hidden)
				$warningMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $warningMessage;
			$html .= '<div class="alert alert-warning alert-dismissible ew-warning"><i class="icon fa fa-warning"></i>' . $warningMessage . '</div>';
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($successMessage, "success");
		if ($successMessage <> "") { // Message in Session, display
			if (!$hidden)
				$successMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $successMessage;
			$html .= '<div class="alert alert-success alert-dismissible ew-success"><i class="icon fa fa-check"></i>' . $successMessage . '</div>';
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$errorMessage = $this->getFailureMessage();
		if (method_exists($this, "Message_Showing"))
			$this->Message_Showing($errorMessage, "failure");
		if ($errorMessage <> "") { // Message in Session, display
			if (!$hidden)
				$errorMessage = '<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>' . $errorMessage;
			$html .= '<div class="alert alert-danger alert-dismissible ew-error"><i class="icon fa fa-ban"></i>' . $errorMessage . '</div>';
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		echo '<div class="ew-message-dialog' . (($hidden) ? ' d-none' : "") . '">' . $html . '</div>';
	}

	// Get message as array
	public function getMessages()
	{
		$ar = array();

		// Message
		$message = $this->getMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($message, "");

		if ($message <> "") { // Message in Session, display
			$ar["message"] = $message;
			$_SESSION[SESSION_MESSAGE] = ""; // Clear message in Session
		}

		// Warning message
		$warningMessage = $this->getWarningMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($warningMessage, "warning");

		if ($warningMessage <> "") { // Message in Session, display
			$ar["warningMessage"] = $warningMessage;
			$_SESSION[SESSION_WARNING_MESSAGE] = ""; // Clear message in Session
		}

		// Success message
		$successMessage = $this->getSuccessMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($successMessage, "success");

		if ($successMessage <> "") { // Message in Session, display
			$ar["successMessage"] = $successMessage;
			$_SESSION[SESSION_SUCCESS_MESSAGE] = ""; // Clear message in Session
		}

		// Failure message
		$failureMessage = $this->getFailureMessage();

		//if (method_exists($this, "Message_Showing"))
		//	$this->Message_Showing($failureMessage, "failure");

		if ($failureMessage <> "") { // Message in Session, display
			$ar["failureMessage"] = $failureMessage;
			$_SESSION[SESSION_FAILURE_MESSAGE] = ""; // Clear message in Session
		}
		return $ar;
	}

	// Show Page Header
	public function showPageHeader()
	{
		$header = $this->PageHeader;
		$this->Page_DataRendering($header);
		if ($header <> "") { // Header exists, display
			echo '<p id="ew-page-header">' . $header . '</p>';
		}
	}

	// Show Page Footer
	public function showPageFooter()
	{
		$footer = $this->PageFooter;
		$this->Page_DataRendered($footer);
		if ($footer <> "") { // Footer exists, display
			echo '<p id="ew-page-footer">' . $footer . '</p>';
		}
	}

	// Validate page request
	protected function isPageRequest()
	{
		global $CurrentForm;
		if ($this->UseTokenInUrl) {
			if ($CurrentForm)
				return ($this->TableVar == $CurrentForm->getValue("t"));
			if (Get("t") !== NULL)
				return ($this->TableVar == Get("t"));
		}
		return TRUE;
	}

	// Valid Post
	protected function validPost()
	{
		if (!$this->CheckToken || !IsPost() || IsApi())
			return TRUE;
		if (Post(TOKEN_NAME) === NULL)
			return FALSE;
		$fn = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
		if (is_callable($fn))
			return $fn(Post(TOKEN_NAME), $this->TokenTimeout);
		return FALSE;
	}

	// Create Token
	public function createToken()
	{
		global $CurrentToken;
		$fn = PROJECT_NAMESPACE . CREATE_TOKEN_FUNC; // Always create token, required by API file/lookup request
		if ($this->Token == "" && is_callable($fn)) // Create token
			$this->Token = $fn();
		$CurrentToken = $this->Token; // Save to global variable
	}

	// Constructor
	public function __construct()
	{
		global $Language, $COMPOSITE_KEY_SEPARATOR;
		global $UserTable, $UserTableConn;

		// Initialize
		$GLOBALS["Page"] = &$this;
		$this->TokenTimeout = SessionTimeoutTime();

		// Language object
		if (!isset($Language))
			$Language = new Language();

		// Parent constuctor
		parent::__construct();

		// Table object (t_trip_info)
		if (!isset($GLOBALS["t_trip_info"]) || get_class($GLOBALS["t_trip_info"]) == PROJECT_NAMESPACE . "t_trip_info") {
			$GLOBALS["t_trip_info"] = &$this;
			$GLOBALS["Table"] = &$GLOBALS["t_trip_info"];
		}
		$this->CancelUrl = $this->pageUrl() . "action=cancel";

		// Table object (admin)
		if (!isset($GLOBALS['admin']))
			$GLOBALS['admin'] = new admin();

		// Page ID
		if (!defined(PROJECT_NAMESPACE . "PAGE_ID"))
			define(PROJECT_NAMESPACE . "PAGE_ID", 'search');

		// Table name (for backward compatibility)
		if (!defined(PROJECT_NAMESPACE . "TABLE_NAME"))
			define(PROJECT_NAMESPACE . "TABLE_NAME", 't_trip_info');

		// Start timer
		if (!isset($GLOBALS["DebugTimer"]))
			$GLOBALS["DebugTimer"] = new Timer();

		// Debug message
		LoadDebugMessage();

		// Open connection
		if (!isset($GLOBALS["Conn"]))
			$GLOBALS["Conn"] = &$this->getConnection();

		// User table object (admin)
		if (!isset($UserTable)) {
			$UserTable = new admin();
			$UserTableConn = Conn($UserTable->Dbid);
		}
	}

	// Terminate page
	public function terminate($url = "")
	{
		global $ExportFileName, $TempImages;

		// Page Unload event
		$this->Page_Unload();

		// Global Page Unloaded event (in userfn*.php)
		Page_Unloaded();

		// Export
		global $EXPORT, $t_trip_info;
		if ($this->CustomExport && $this->CustomExport == $this->Export && array_key_exists($this->CustomExport, $EXPORT)) {
				$content = ob_get_contents();
			if ($ExportFileName == "")
				$ExportFileName = $this->TableVar;
			$class = PROJECT_NAMESPACE . $EXPORT[$this->CustomExport];
			if (class_exists($class)) {
				$doc = new $class($t_trip_info);
				$doc->Text = @$content;
				if ($this->isExport("email"))
					echo $this->exportEmail($doc->Text);
				else
					$doc->export();
				DeleteTempImages(); // Delete temp images
				exit();
			}
		}
		if (!IsApi())
			$this->Page_Redirecting($url);

		// Close connection
		CloseConnections();

		// Return for API
		if (IsApi()) {
			$res = $url === TRUE;
			if (!$res) // Show error
				WriteJson(array_merge(["success" => FALSE], $this->getMessages()));
			return;
		}

		// Go to URL if specified
		if ($url <> "") {
			if (!DEBUG_ENABLED && ob_get_length())
				ob_end_clean();

			// Handle modal response
			if ($this->IsModal) { // Show as modal
				$row = array("url" => $url, "modal" => "1");
				$pageName = GetPageName($url);
				if ($pageName != $this->getListUrl()) { // Not List page
					$row["caption"] = $this->getModalCaption($pageName);
					if ($pageName == "t_trip_infoview.php")
						$row["view"] = "1";
				} else { // List page should not be shown as modal => error
					$row["error"] = $this->getFailureMessage();
					$this->clearFailureMessage();
				}
				WriteJson($row);
			} else {
				SaveDebugMessage();
				AddHeader("Location", $url);
			}
		}
		exit();
	}

	// Get records from recordset
	protected function getRecordsFromRecordset($rs, $current = FALSE)
	{
		$rows = array();
		if (is_object($rs)) { // Recordset
			while ($rs && !$rs->EOF) {
				$this->loadRowValues($rs); // Set up DbValue/CurrentValue
				$row = $this->getRecordFromArray($rs->fields);
				if ($current)
					return $row;
				else
					$rows[] = $row;
				$rs->moveNext();
			}
		} elseif (is_array($rs)) {
			foreach ($rs as $ar) {
				$row = $this->getRecordFromArray($ar);
				if ($current)
					return $row;
				else
					$rows[] = $row;
			}
		}
		return $rows;
	}

	// Get record from array
	protected function getRecordFromArray($ar)
	{
		$row = array();
		if (is_array($ar)) {
			foreach ($ar as $fldname => $val) {
				if (array_key_exists($fldname, $this->fields) && ($this->fields[$fldname]->Visible || $this->fields[$fldname]->IsPrimaryKey)) { // Primary key or Visible
					$fld = &$this->fields[$fldname];
					if ($fld->HtmlTag == "FILE") { // Upload field
						if (EmptyValue($val)) {
							$row[$fldname] = NULL;
						} else {
							if ($fld->DataType == DATATYPE_BLOB) {

								//$url = FullUrl($fld->TableVar . "/" . API_FILE_ACTION . "/" . $fld->Param . "/" . rawurlencode($this->getRecordKeyValue($ar))); // URL rewrite format
								$url = FullUrl(GetPageName(API_URL) . "?" . API_OBJECT_NAME . "=" . $fld->TableVar . "&" . API_ACTION_NAME . "=" . API_FILE_ACTION . "&" . API_FIELD_NAME . "=" . $fld->Param . "&" . API_KEY_NAME . "=" . rawurlencode($this->getRecordKeyValue($ar))); // Query string format
								$row[$fldname] = ["mimeType" => ContentType($val), "url" => $url];
							} elseif (!$fld->UploadMultiple || !ContainsString($val, MULTIPLE_UPLOAD_SEPARATOR)) { // Single file
								$row[$fldname] = ["mimeType" => MimeContentType($val), "url" => FullUrl($fld->hrefPath() . $val)];
							} else { // Multiple files
								$files = explode(MULTIPLE_UPLOAD_SEPARATOR, $val);
								$ar = [];
								foreach ($files as $file) {
									if (!EmptyValue($file))
										$ar[] = ["type" => MimeContentType($file), "url" => FullUrl($fld->hrefPath() . $file)];
								}
								$row[$fldname] = $ar;
							}
						}
					} else {
						$row[$fldname] = $val;
					}
				}
			}
		}
		return $row;
	}

	// Get record key value from array
	protected function getRecordKeyValue($ar)
	{
		global $COMPOSITE_KEY_SEPARATOR;
		$key = "";
		if (is_array($ar)) {
			$key .= @$ar['id'];
		}
		return $key;
	}

	/**
	 * Hide fields for add/edit
	 *
	 * @return void
	 */
	protected function hideFieldsForAddEdit()
	{
		if ($this->isAdd() || $this->isCopy() || $this->isGridAdd())
			$this->id->Visible = FALSE;
	}
	public $FormClassName = "ew-horizontal ew-form ew-search-form";
	public $IsModal = FALSE;
	public $IsMobileOrModal = FALSE;
	public $MultiPages; // Multi pages object

	//
	// Page run
	//

	public function run()
	{
		global $ExportType, $CustomExportType, $ExportFileName, $UserProfile, $Language, $Security, $RequestSecurity, $CurrentForm,
			$SearchError, $SkipHeaderFooter;

		// Init Session data for API request if token found
		if (IsApi() && session_status() !== PHP_SESSION_ACTIVE) {
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Param(TOKEN_NAME) !== NULL && $func(Param(TOKEN_NAME), SessionTimeoutTime()))
				session_start();
		}

		// Is modal
		$this->IsModal = (Param("modal") == "1");

		// User profile
		$UserProfile = new UserProfile();

		// Security
		$Security = new AdvancedSecurity();
		$validRequest = FALSE;

		// Check security for API request
		If (IsApi()) {

			// Check token first
			$func = PROJECT_NAMESPACE . CHECK_TOKEN_FUNC;
			if (is_callable($func) && Post(TOKEN_NAME) !== NULL)
				$validRequest = $func(Post(TOKEN_NAME), SessionTimeoutTime());
			elseif (is_array($RequestSecurity) && @$RequestSecurity["username"] <> "") // Login user for API request
				$Security->loginUser(@$RequestSecurity["username"], @$RequestSecurity["userid"], @$RequestSecurity["parentuserid"], @$RequestSecurity["userlevelid"]);
		}
		if (!$validRequest) {
			if (!$Security->isLoggedIn())
				$Security->autoLogin();
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loading();
			$Security->loadCurrentUserLevel($this->ProjectID . $this->TableName);
			if ($Security->isLoggedIn())
				$Security->TablePermission_Loaded();
			if (!$Security->canSearch()) {
				$Security->saveLastUrl();
				$this->setFailureMessage(DeniedMessage()); // Set no permission
				if ($Security->canList())
					$this->terminate(GetUrl("t_trip_infolist.php"));
				else
					$this->terminate(GetUrl("login.php"));
				return;
			}
			if ($Security->isLoggedIn()) {
				$Security->UserID_Loading();
				$Security->loadUserID();
				$Security->UserID_Loaded();
			}
		}

		// Create form object
		$CurrentForm = new HttpForm();
		$this->CurrentAction = Param("action"); // Set up current action
		$this->id->setVisibility();
		$this->vehicle_type->setVisibility();
		$this->vehicle->setVisibility();
		$this->_route->setVisibility();
		$this->route_name->setVisibility();
		$this->reports_to->setVisibility();
		$this->buyer->setVisibility();
		$this->b_consignor->setVisibility();
		$this->b_consignee->setVisibility();
		$this->load_date->setVisibility();
		$this->load_weight->setVisibility();
		$this->unload_date->setVisibility();
		$this->unload_weight->setVisibility();
		$this->invoice_no->setVisibility();
		$this->invoice_date->setVisibility();
		$this->amount->setVisibility();
		$this->delivery_pod->setVisibility();
		$this->status->setVisibility();
		$this->days->setVisibility();
		$this->driver->setVisibility();
		$this->driver_name->setVisibility();
		$this->agent->setVisibility();
		$this->comm->setVisibility();
		$this->material->setVisibility();
		$this->packing_type->setVisibility();
		$this->m_hsn->setVisibility();
		$this->_40->setVisibility();
		$this->lr_no->setVisibility();
		$this->km->setVisibility();
		$this->freight_type->setVisibility();
		$this->freight->setVisibility();
		$this->ded_det->setVisibility();
		$this->ded_det_remarks->setVisibility();
		$this->gst_percent->setVisibility();
		$this->gst_amount->setVisibility();
		$this->final_amount->setVisibility();
		$this->load_km->setVisibility();
		$this->unload_km->setVisibility();
		$this->delivery_receipt->setVisibility();
		$this->delivery_docket->setVisibility();
		$this->diesal_op_b->setVisibility();
		$this->diesal_required->setVisibility();
		$this->diesal_fill->setVisibility();
		$this->diesal_amount->setVisibility();
		$this->diesal_cl_balance->setVisibility();
		$this->vehicle_average->setVisibility();
		$this->cash_required->setVisibility();
		$this->cash_op_b->setVisibility();
		$this->cash_paid->setVisibility();
		$this->cash_expenses->setVisibility();
		$this->cash_cl_balance->setVisibility();
		$this->fasttag_op_b->setVisibility();
		$this->fasttag_recharge->setVisibility();
		$this->fasttag_expenses->setVisibility();
		$this->toll_expenses_cash->setVisibility();
		$this->fasttag_cl_balance->setVisibility();
		$this->remarks->setVisibility();
		$this->uploads->setVisibility();
		$this->consignor->setVisibility();
		$this->vehicle_freight_comm->setVisibility();
		$this->vehicle_freight_type->setVisibility();
		$this->vehicle_freight_amount->setVisibility();
		$this->vehicle_freight_final->setVisibility();
		$this->operator->setVisibility();
		$this->datetime->setVisibility();
		$this->expenses_id->Visible = FALSE;
		$this->hideFieldsForAddEdit();

		// Do not use lookup cache
		$this->setUseLookupCache(FALSE);

		// Set up multi page object
		$this->setupMultiPages();

		// Global Page Loading event (in userfn*.php)
		Page_Loading();

		// Page Load event
		$this->Page_Load();

		// Check token
		if (!$this->validPost()) {
			Write($Language->phrase("InvalidPostRequest"));
			$this->terminate();
		}

		// Create Token
		$this->createToken();

		// Set up lookup cache
		$this->setupLookupOptions($this->vehicle);
		$this->setupLookupOptions($this->_route);
		$this->setupLookupOptions($this->reports_to);
		$this->setupLookupOptions($this->buyer);
		$this->setupLookupOptions($this->b_consignor);
		$this->setupLookupOptions($this->b_consignee);
		$this->setupLookupOptions($this->driver);
		$this->setupLookupOptions($this->agent);
		$this->setupLookupOptions($this->consignor);
		$this->setupLookupOptions($this->operator);

		// Set up Breadcrumb
		$this->setupBreadcrumb();

		// Check modal
		if ($this->IsModal)
			$SkipHeaderFooter = TRUE;
		$this->IsMobileOrModal = IsMobile() || $this->IsModal;
		if ($this->isPageRequest()) { // Validate request

			// Get action
			$this->CurrentAction = Post("action");
			if ($this->isSearch()) {

				// Build search string for advanced search, remove blank field
				$this->loadSearchValues(); // Get search values
				if ($this->validateSearch()) {
					$srchStr = $this->buildAdvancedSearch();
				} else {
					$srchStr = "";
					$this->setFailureMessage($SearchError);
				}
				if ($srchStr <> "") {
					$srchStr = $this->getUrlParm($srchStr);
					$srchStr = "t_trip_infolist.php" . "?" . $srchStr;
					$this->terminate($srchStr); // Go to list page
				}
			}
		}

		// Restore search settings from Session
		if ($SearchError == "")
			$this->loadAdvancedSearch();

		// Render row for search
		$this->RowType = ROWTYPE_SEARCH;
		$this->resetAttributes();
		$this->renderRow();
	}

	// Build advanced search
	protected function buildAdvancedSearch()
	{
		$srchUrl = "";
		$this->buildSearchUrl($srchUrl, $this->id); // id
		$this->buildSearchUrl($srchUrl, $this->vehicle_type); // vehicle_type
		$this->buildSearchUrl($srchUrl, $this->vehicle); // vehicle
		$this->buildSearchUrl($srchUrl, $this->_route); // route
		$this->buildSearchUrl($srchUrl, $this->route_name); // route_name
		$this->buildSearchUrl($srchUrl, $this->reports_to); // reports_to
		$this->buildSearchUrl($srchUrl, $this->buyer); // buyer
		$this->buildSearchUrl($srchUrl, $this->b_consignor); // b_consignor
		$this->buildSearchUrl($srchUrl, $this->b_consignee); // b_consignee
		$this->buildSearchUrl($srchUrl, $this->load_date); // load_date
		$this->buildSearchUrl($srchUrl, $this->load_weight); // load_weight
		$this->buildSearchUrl($srchUrl, $this->unload_date); // unload_date
		$this->buildSearchUrl($srchUrl, $this->unload_weight); // unload_weight
		$this->buildSearchUrl($srchUrl, $this->invoice_no); // invoice_no
		$this->buildSearchUrl($srchUrl, $this->invoice_date); // invoice_date
		$this->buildSearchUrl($srchUrl, $this->amount); // amount
		$this->buildSearchUrl($srchUrl, $this->delivery_pod); // delivery_pod
		$this->buildSearchUrl($srchUrl, $this->status); // status
		$this->buildSearchUrl($srchUrl, $this->days); // days
		$this->buildSearchUrl($srchUrl, $this->driver); // driver
		$this->buildSearchUrl($srchUrl, $this->driver_name); // driver_name
		$this->buildSearchUrl($srchUrl, $this->agent); // agent
		$this->buildSearchUrl($srchUrl, $this->comm); // comm
		$this->buildSearchUrl($srchUrl, $this->material); // material
		$this->buildSearchUrl($srchUrl, $this->packing_type); // packing_type
		$this->buildSearchUrl($srchUrl, $this->m_hsn); // m_hsn
		$this->buildSearchUrl($srchUrl, $this->_40); // @
		$this->buildSearchUrl($srchUrl, $this->lr_no); // lr_no
		$this->buildSearchUrl($srchUrl, $this->km); // km
		$this->buildSearchUrl($srchUrl, $this->freight_type); // freight_type
		$this->buildSearchUrl($srchUrl, $this->freight); // freight
		$this->buildSearchUrl($srchUrl, $this->ded_det); // ded_det
		$this->buildSearchUrl($srchUrl, $this->ded_det_remarks); // ded_det_remarks
		$this->buildSearchUrl($srchUrl, $this->gst_percent); // gst_percent
		$this->buildSearchUrl($srchUrl, $this->gst_amount); // gst_amount
		$this->buildSearchUrl($srchUrl, $this->final_amount); // final_amount
		$this->buildSearchUrl($srchUrl, $this->load_km); // load_km
		$this->buildSearchUrl($srchUrl, $this->unload_km); // unload_km
		$this->buildSearchUrl($srchUrl, $this->delivery_receipt); // delivery_receipt
		$this->buildSearchUrl($srchUrl, $this->delivery_docket); // delivery_docket
		$this->buildSearchUrl($srchUrl, $this->diesal_op_b); // diesal_op_b
		$this->buildSearchUrl($srchUrl, $this->diesal_required); // diesal_required
		$this->buildSearchUrl($srchUrl, $this->diesal_fill); // diesal_fill
		$this->buildSearchUrl($srchUrl, $this->diesal_amount); // diesal_amount
		$this->buildSearchUrl($srchUrl, $this->diesal_cl_balance); // diesal_cl_balance
		$this->buildSearchUrl($srchUrl, $this->vehicle_average); // vehicle_average
		$this->buildSearchUrl($srchUrl, $this->cash_required); // cash_required
		$this->buildSearchUrl($srchUrl, $this->cash_op_b); // cash_op_b
		$this->buildSearchUrl($srchUrl, $this->cash_paid); // cash_paid
		$this->buildSearchUrl($srchUrl, $this->cash_expenses); // cash_expenses
		$this->buildSearchUrl($srchUrl, $this->cash_cl_balance); // cash_cl_balance
		$this->buildSearchUrl($srchUrl, $this->fasttag_op_b); // fasttag_op_b
		$this->buildSearchUrl($srchUrl, $this->fasttag_recharge); // fasttag_recharge
		$this->buildSearchUrl($srchUrl, $this->fasttag_expenses); // fasttag_expenses
		$this->buildSearchUrl($srchUrl, $this->toll_expenses_cash); // toll_expenses_cash
		$this->buildSearchUrl($srchUrl, $this->fasttag_cl_balance); // fasttag_cl_balance
		$this->buildSearchUrl($srchUrl, $this->remarks); // remarks
		$this->buildSearchUrl($srchUrl, $this->uploads); // uploads
		$this->buildSearchUrl($srchUrl, $this->consignor); // consignor
		$this->buildSearchUrl($srchUrl, $this->vehicle_freight_comm); // vehicle_freight_comm
		$this->buildSearchUrl($srchUrl, $this->vehicle_freight_type); // vehicle_freight_type
		$this->buildSearchUrl($srchUrl, $this->vehicle_freight_amount); // vehicle_freight_amount
		$this->buildSearchUrl($srchUrl, $this->vehicle_freight_final); // vehicle_freight_final
		$this->buildSearchUrl($srchUrl, $this->operator); // operator
		$this->buildSearchUrl($srchUrl, $this->datetime); // datetime
		if ($srchUrl <> "")
			$srchUrl .= "&";
		$srchUrl .= "cmd=search";
		return $srchUrl;
	}

	// Build search URL
	protected function buildSearchUrl(&$url, &$fld, $oprOnly = FALSE)
	{
		global $CurrentForm;
		$wrk = "";
		$fldParm = $fld->Param;
		$fldVal = $CurrentForm->getValue("x_$fldParm");
		$fldOpr = $CurrentForm->getValue("z_$fldParm");
		$fldCond = $CurrentForm->getValue("v_$fldParm");
		$fldVal2 = $CurrentForm->getValue("y_$fldParm");
		$fldOpr2 = $CurrentForm->getValue("w_$fldParm");
		if (is_array($fldVal))
			$fldVal = implode(",", $fldVal);
		if (is_array($fldVal2))
			$fldVal2 = implode(",", $fldVal2);
		$fldOpr = strtoupper(trim($fldOpr));
		$fldDataType = ($fld->IsVirtual) ? DATATYPE_STRING : $fld->DataType;
		if ($fldOpr == "BETWEEN") {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal) && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal <> "" && $fldVal2 <> "" && $isValidValue) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			}
		} else {
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal));
			if ($fldVal <> "" && $isValidValue && IsValidOpr($fldOpr, $fldDataType)) {
				$wrk = "x_" . $fldParm . "=" . urlencode($fldVal) .
					"&z_" . $fldParm . "=" . urlencode($fldOpr);
			} elseif ($fldOpr == "IS NULL" || $fldOpr == "IS NOT NULL" || ($fldOpr <> "" && $oprOnly && IsValidOpr($fldOpr, $fldDataType))) {
				$wrk = "z_" . $fldParm . "=" . urlencode($fldOpr);
			}
			$isValidValue = ($fldDataType <> DATATYPE_NUMBER) ||
				($fldDataType == DATATYPE_NUMBER && $this->searchValueIsNumeric($fld, $fldVal2));
			if ($fldVal2 <> "" && $isValidValue && IsValidOpr($fldOpr2, $fldDataType)) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "y_" . $fldParm . "=" . urlencode($fldVal2) .
					"&w_" . $fldParm . "=" . urlencode($fldOpr2);
			} elseif ($fldOpr2 == "IS NULL" || $fldOpr2 == "IS NOT NULL" || ($fldOpr2 <> "" && $oprOnly && IsValidOpr($fldOpr2, $fldDataType))) {
				if ($wrk <> "")
					$wrk .= "&v_" . $fldParm . "=" . urlencode($fldCond) . "&";
				$wrk .= "w_" . $fldParm . "=" . urlencode($fldOpr2);
			}
		}
		if ($wrk <> "") {
			if ($url <> "")
				$url .= "&";
			$url .= $wrk;
		}
	}
	protected function searchValueIsNumeric($fld, $value)
	{
		if (IsFloatFormat($fld->Type))
			$value = ConvertToFloatString($value);
		return is_numeric($value);
	}

	// Load search values for validation
	protected function loadSearchValues()
	{
		global $CurrentForm;

		// Load search values
		// id

		if (!$this->isAddOrEdit())
			$this->id->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_id"));
		$this->id->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_id"));

		// vehicle_type
		if (!$this->isAddOrEdit())
			$this->vehicle_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_vehicle_type"));
		$this->vehicle_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_vehicle_type"));

		// vehicle
		if (!$this->isAddOrEdit())
			$this->vehicle->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_vehicle"));
		$this->vehicle->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_vehicle"));

		// route
		if (!$this->isAddOrEdit())
			$this->_route->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__route"));
		$this->_route->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__route"));

		// route_name
		if (!$this->isAddOrEdit())
			$this->route_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_route_name"));
		$this->route_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_route_name"));

		// reports_to
		if (!$this->isAddOrEdit())
			$this->reports_to->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_reports_to"));
		$this->reports_to->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_reports_to"));

		// buyer
		if (!$this->isAddOrEdit())
			$this->buyer->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_buyer"));
		$this->buyer->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_buyer"));

		// b_consignor
		if (!$this->isAddOrEdit())
			$this->b_consignor->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_consignor"));
		$this->b_consignor->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_consignor"));
		$this->b_consignor->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_b_consignor"));
		$this->b_consignor->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_b_consignor"));
		$this->b_consignor->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_b_consignor"));

		// b_consignee
		if (!$this->isAddOrEdit())
			$this->b_consignee->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_b_consignee"));
		$this->b_consignee->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_b_consignee"));
		$this->b_consignee->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_b_consignee"));
		$this->b_consignee->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_b_consignee"));
		$this->b_consignee->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_b_consignee"));

		// load_date
		if (!$this->isAddOrEdit())
			$this->load_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_load_date"));
		$this->load_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_load_date"));

		// load_weight
		if (!$this->isAddOrEdit())
			$this->load_weight->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_load_weight"));
		$this->load_weight->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_load_weight"));

		// unload_date
		if (!$this->isAddOrEdit())
			$this->unload_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_unload_date"));
		$this->unload_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_unload_date"));

		// unload_weight
		if (!$this->isAddOrEdit())
			$this->unload_weight->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_unload_weight"));
		$this->unload_weight->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_unload_weight"));

		// invoice_no
		if (!$this->isAddOrEdit())
			$this->invoice_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_invoice_no"));
		$this->invoice_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_invoice_no"));

		// invoice_date
		if (!$this->isAddOrEdit())
			$this->invoice_date->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_invoice_date"));
		$this->invoice_date->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_invoice_date"));
		$this->invoice_date->AdvancedSearch->setSearchCondition($CurrentForm->getValue("v_invoice_date"));
		$this->invoice_date->AdvancedSearch->setSearchValue2($CurrentForm->getValue("y_invoice_date"));
		$this->invoice_date->AdvancedSearch->setSearchOperator2($CurrentForm->getValue("w_invoice_date"));

		// amount
		if (!$this->isAddOrEdit())
			$this->amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_amount"));
		$this->amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_amount"));

		// delivery_pod
		if (!$this->isAddOrEdit())
			$this->delivery_pod->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_delivery_pod"));
		$this->delivery_pod->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_delivery_pod"));

		// status
		if (!$this->isAddOrEdit())
			$this->status->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_status"));
		$this->status->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_status"));

		// days
		if (!$this->isAddOrEdit())
			$this->days->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_days"));
		$this->days->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_days"));

		// driver
		if (!$this->isAddOrEdit())
			$this->driver->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_driver"));
		$this->driver->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_driver"));

		// driver_name
		if (!$this->isAddOrEdit())
			$this->driver_name->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_driver_name"));
		$this->driver_name->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_driver_name"));

		// agent
		if (!$this->isAddOrEdit())
			$this->agent->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_agent"));
		$this->agent->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_agent"));

		// comm
		if (!$this->isAddOrEdit())
			$this->comm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_comm"));
		$this->comm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_comm"));

		// material
		if (!$this->isAddOrEdit())
			$this->material->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_material"));
		$this->material->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_material"));

		// packing_type
		if (!$this->isAddOrEdit())
			$this->packing_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_packing_type"));
		$this->packing_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_packing_type"));

		// m_hsn
		if (!$this->isAddOrEdit())
			$this->m_hsn->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_m_hsn"));
		$this->m_hsn->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_m_hsn"));

		// @
		if (!$this->isAddOrEdit())
			$this->_40->AdvancedSearch->setSearchValue($CurrentForm->getValue("x__40"));
		$this->_40->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z__40"));

		// lr_no
		if (!$this->isAddOrEdit())
			$this->lr_no->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_lr_no"));
		$this->lr_no->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_lr_no"));

		// km
		if (!$this->isAddOrEdit())
			$this->km->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_km"));
		$this->km->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_km"));

		// freight_type
		if (!$this->isAddOrEdit())
			$this->freight_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_freight_type"));
		$this->freight_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_freight_type"));

		// freight
		if (!$this->isAddOrEdit())
			$this->freight->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_freight"));
		$this->freight->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_freight"));

		// ded_det
		if (!$this->isAddOrEdit())
			$this->ded_det->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ded_det"));
		$this->ded_det->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ded_det"));

		// ded_det_remarks
		if (!$this->isAddOrEdit())
			$this->ded_det_remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_ded_det_remarks"));
		$this->ded_det_remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_ded_det_remarks"));

		// gst_percent
		if (!$this->isAddOrEdit())
			$this->gst_percent->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gst_percent"));
		$this->gst_percent->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gst_percent"));

		// gst_amount
		if (!$this->isAddOrEdit())
			$this->gst_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_gst_amount"));
		$this->gst_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_gst_amount"));

		// final_amount
		if (!$this->isAddOrEdit())
			$this->final_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_final_amount"));
		$this->final_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_final_amount"));

		// load_km
		if (!$this->isAddOrEdit())
			$this->load_km->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_load_km"));
		$this->load_km->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_load_km"));

		// unload_km
		if (!$this->isAddOrEdit())
			$this->unload_km->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_unload_km"));
		$this->unload_km->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_unload_km"));

		// delivery_receipt
		if (!$this->isAddOrEdit())
			$this->delivery_receipt->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_delivery_receipt"));
		$this->delivery_receipt->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_delivery_receipt"));

		// delivery_docket
		if (!$this->isAddOrEdit())
			$this->delivery_docket->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_delivery_docket"));
		$this->delivery_docket->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_delivery_docket"));

		// diesal_op_b
		if (!$this->isAddOrEdit())
			$this->diesal_op_b->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_diesal_op_b"));
		$this->diesal_op_b->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_diesal_op_b"));

		// diesal_required
		if (!$this->isAddOrEdit())
			$this->diesal_required->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_diesal_required"));
		$this->diesal_required->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_diesal_required"));

		// diesal_fill
		if (!$this->isAddOrEdit())
			$this->diesal_fill->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_diesal_fill"));
		$this->diesal_fill->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_diesal_fill"));

		// diesal_amount
		if (!$this->isAddOrEdit())
			$this->diesal_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_diesal_amount"));
		$this->diesal_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_diesal_amount"));

		// diesal_cl_balance
		if (!$this->isAddOrEdit())
			$this->diesal_cl_balance->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_diesal_cl_balance"));
		$this->diesal_cl_balance->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_diesal_cl_balance"));

		// vehicle_average
		if (!$this->isAddOrEdit())
			$this->vehicle_average->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_vehicle_average"));
		$this->vehicle_average->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_vehicle_average"));

		// cash_required
		if (!$this->isAddOrEdit())
			$this->cash_required->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cash_required"));
		$this->cash_required->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cash_required"));

		// cash_op_b
		if (!$this->isAddOrEdit())
			$this->cash_op_b->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cash_op_b"));
		$this->cash_op_b->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cash_op_b"));

		// cash_paid
		if (!$this->isAddOrEdit())
			$this->cash_paid->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cash_paid"));
		$this->cash_paid->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cash_paid"));

		// cash_expenses
		if (!$this->isAddOrEdit())
			$this->cash_expenses->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cash_expenses"));
		$this->cash_expenses->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cash_expenses"));

		// cash_cl_balance
		if (!$this->isAddOrEdit())
			$this->cash_cl_balance->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_cash_cl_balance"));
		$this->cash_cl_balance->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_cash_cl_balance"));

		// fasttag_op_b
		if (!$this->isAddOrEdit())
			$this->fasttag_op_b->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_fasttag_op_b"));
		$this->fasttag_op_b->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_fasttag_op_b"));

		// fasttag_recharge
		if (!$this->isAddOrEdit())
			$this->fasttag_recharge->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_fasttag_recharge"));
		$this->fasttag_recharge->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_fasttag_recharge"));

		// fasttag_expenses
		if (!$this->isAddOrEdit())
			$this->fasttag_expenses->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_fasttag_expenses"));
		$this->fasttag_expenses->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_fasttag_expenses"));

		// toll_expenses_cash
		if (!$this->isAddOrEdit())
			$this->toll_expenses_cash->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_toll_expenses_cash"));
		$this->toll_expenses_cash->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_toll_expenses_cash"));

		// fasttag_cl_balance
		if (!$this->isAddOrEdit())
			$this->fasttag_cl_balance->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_fasttag_cl_balance"));
		$this->fasttag_cl_balance->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_fasttag_cl_balance"));

		// remarks
		if (!$this->isAddOrEdit())
			$this->remarks->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_remarks"));
		$this->remarks->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_remarks"));

		// uploads
		if (!$this->isAddOrEdit())
			$this->uploads->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_uploads"));
		$this->uploads->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_uploads"));

		// consignor
		if (!$this->isAddOrEdit())
			$this->consignor->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_consignor"));
		$this->consignor->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_consignor"));

		// vehicle_freight_comm
		if (!$this->isAddOrEdit())
			$this->vehicle_freight_comm->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_vehicle_freight_comm"));
		$this->vehicle_freight_comm->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_vehicle_freight_comm"));

		// vehicle_freight_type
		if (!$this->isAddOrEdit())
			$this->vehicle_freight_type->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_vehicle_freight_type"));
		$this->vehicle_freight_type->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_vehicle_freight_type"));

		// vehicle_freight_amount
		if (!$this->isAddOrEdit())
			$this->vehicle_freight_amount->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_vehicle_freight_amount"));
		$this->vehicle_freight_amount->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_vehicle_freight_amount"));

		// vehicle_freight_final
		if (!$this->isAddOrEdit())
			$this->vehicle_freight_final->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_vehicle_freight_final"));
		$this->vehicle_freight_final->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_vehicle_freight_final"));

		// operator
		if (!$this->isAddOrEdit())
			$this->operator->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_operator"));
		$this->operator->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_operator"));

		// datetime
		if (!$this->isAddOrEdit())
			$this->datetime->AdvancedSearch->setSearchValue($CurrentForm->getValue("x_datetime"));
		$this->datetime->AdvancedSearch->setSearchOperator($CurrentForm->getValue("z_datetime"));
	}

	// Render row values based on field settings
	public function renderRow()
	{
		global $Security, $Language, $CurrentLanguage;

		// Initialize URLs
		// Convert decimal values if posted back

		if ($this->amount->FormValue == $this->amount->CurrentValue && is_numeric(ConvertToFloatString($this->amount->CurrentValue)))
			$this->amount->CurrentValue = ConvertToFloatString($this->amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->comm->FormValue == $this->comm->CurrentValue && is_numeric(ConvertToFloatString($this->comm->CurrentValue)))
			$this->comm->CurrentValue = ConvertToFloatString($this->comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->_40->FormValue == $this->_40->CurrentValue && is_numeric(ConvertToFloatString($this->_40->CurrentValue)))
			$this->_40->CurrentValue = ConvertToFloatString($this->_40->CurrentValue);

		// Convert decimal values if posted back
		if ($this->km->FormValue == $this->km->CurrentValue && is_numeric(ConvertToFloatString($this->km->CurrentValue)))
			$this->km->CurrentValue = ConvertToFloatString($this->km->CurrentValue);

		// Convert decimal values if posted back
		if ($this->freight->FormValue == $this->freight->CurrentValue && is_numeric(ConvertToFloatString($this->freight->CurrentValue)))
			$this->freight->CurrentValue = ConvertToFloatString($this->freight->CurrentValue);

		// Convert decimal values if posted back
		if ($this->ded_det->FormValue == $this->ded_det->CurrentValue && is_numeric(ConvertToFloatString($this->ded_det->CurrentValue)))
			$this->ded_det->CurrentValue = ConvertToFloatString($this->ded_det->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gst_percent->FormValue == $this->gst_percent->CurrentValue && is_numeric(ConvertToFloatString($this->gst_percent->CurrentValue)))
			$this->gst_percent->CurrentValue = ConvertToFloatString($this->gst_percent->CurrentValue);

		// Convert decimal values if posted back
		if ($this->gst_amount->FormValue == $this->gst_amount->CurrentValue && is_numeric(ConvertToFloatString($this->gst_amount->CurrentValue)))
			$this->gst_amount->CurrentValue = ConvertToFloatString($this->gst_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->final_amount->FormValue == $this->final_amount->CurrentValue && is_numeric(ConvertToFloatString($this->final_amount->CurrentValue)))
			$this->final_amount->CurrentValue = ConvertToFloatString($this->final_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_op_b->FormValue == $this->diesal_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_op_b->CurrentValue)))
			$this->diesal_op_b->CurrentValue = ConvertToFloatString($this->diesal_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_required->FormValue == $this->diesal_required->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_required->CurrentValue)))
			$this->diesal_required->CurrentValue = ConvertToFloatString($this->diesal_required->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_fill->FormValue == $this->diesal_fill->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_fill->CurrentValue)))
			$this->diesal_fill->CurrentValue = ConvertToFloatString($this->diesal_fill->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_amount->FormValue == $this->diesal_amount->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_amount->CurrentValue)))
			$this->diesal_amount->CurrentValue = ConvertToFloatString($this->diesal_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->diesal_cl_balance->FormValue == $this->diesal_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->diesal_cl_balance->CurrentValue)))
			$this->diesal_cl_balance->CurrentValue = ConvertToFloatString($this->diesal_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_average->FormValue == $this->vehicle_average->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_average->CurrentValue)))
			$this->vehicle_average->CurrentValue = ConvertToFloatString($this->vehicle_average->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_required->FormValue == $this->cash_required->CurrentValue && is_numeric(ConvertToFloatString($this->cash_required->CurrentValue)))
			$this->cash_required->CurrentValue = ConvertToFloatString($this->cash_required->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_op_b->FormValue == $this->cash_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->cash_op_b->CurrentValue)))
			$this->cash_op_b->CurrentValue = ConvertToFloatString($this->cash_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_paid->FormValue == $this->cash_paid->CurrentValue && is_numeric(ConvertToFloatString($this->cash_paid->CurrentValue)))
			$this->cash_paid->CurrentValue = ConvertToFloatString($this->cash_paid->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_expenses->FormValue == $this->cash_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->cash_expenses->CurrentValue)))
			$this->cash_expenses->CurrentValue = ConvertToFloatString($this->cash_expenses->CurrentValue);

		// Convert decimal values if posted back
		if ($this->cash_cl_balance->FormValue == $this->cash_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->cash_cl_balance->CurrentValue)))
			$this->cash_cl_balance->CurrentValue = ConvertToFloatString($this->cash_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_op_b->FormValue == $this->fasttag_op_b->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_op_b->CurrentValue)))
			$this->fasttag_op_b->CurrentValue = ConvertToFloatString($this->fasttag_op_b->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_recharge->FormValue == $this->fasttag_recharge->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_recharge->CurrentValue)))
			$this->fasttag_recharge->CurrentValue = ConvertToFloatString($this->fasttag_recharge->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_expenses->FormValue == $this->fasttag_expenses->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_expenses->CurrentValue)))
			$this->fasttag_expenses->CurrentValue = ConvertToFloatString($this->fasttag_expenses->CurrentValue);

		// Convert decimal values if posted back
		if ($this->toll_expenses_cash->FormValue == $this->toll_expenses_cash->CurrentValue && is_numeric(ConvertToFloatString($this->toll_expenses_cash->CurrentValue)))
			$this->toll_expenses_cash->CurrentValue = ConvertToFloatString($this->toll_expenses_cash->CurrentValue);

		// Convert decimal values if posted back
		if ($this->fasttag_cl_balance->FormValue == $this->fasttag_cl_balance->CurrentValue && is_numeric(ConvertToFloatString($this->fasttag_cl_balance->CurrentValue)))
			$this->fasttag_cl_balance->CurrentValue = ConvertToFloatString($this->fasttag_cl_balance->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_comm->FormValue == $this->vehicle_freight_comm->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_comm->CurrentValue)))
			$this->vehicle_freight_comm->CurrentValue = ConvertToFloatString($this->vehicle_freight_comm->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_amount->FormValue == $this->vehicle_freight_amount->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_amount->CurrentValue)))
			$this->vehicle_freight_amount->CurrentValue = ConvertToFloatString($this->vehicle_freight_amount->CurrentValue);

		// Convert decimal values if posted back
		if ($this->vehicle_freight_final->FormValue == $this->vehicle_freight_final->CurrentValue && is_numeric(ConvertToFloatString($this->vehicle_freight_final->CurrentValue)))
			$this->vehicle_freight_final->CurrentValue = ConvertToFloatString($this->vehicle_freight_final->CurrentValue);

		// Call Row_Rendering event
		$this->Row_Rendering();

		// Common render codes for all row types
		// id
		// vehicle_type
		// vehicle
		// route
		// route_name
		// reports_to
		// buyer
		// b_consignor
		// b_consignee
		// load_date
		// load_weight
		// unload_date
		// unload_weight
		// invoice_no
		// invoice_date
		// amount
		// delivery_pod
		// status
		// days
		// driver
		// driver_name
		// agent
		// comm
		// material
		// packing_type
		// m_hsn
		// @
		// lr_no
		// km
		// freight_type
		// freight
		// ded_det
		// ded_det_remarks
		// gst_percent
		// gst_amount
		// final_amount
		// load_km
		// unload_km
		// delivery_receipt
		// delivery_docket
		// diesal_op_b
		// diesal_required
		// diesal_fill
		// diesal_amount
		// diesal_cl_balance
		// vehicle_average
		// cash_required
		// cash_op_b
		// cash_paid
		// cash_expenses
		// cash_cl_balance
		// fasttag_op_b
		// fasttag_recharge
		// fasttag_expenses
		// toll_expenses_cash
		// fasttag_cl_balance
		// remarks
		// uploads
		// consignor
		// vehicle_freight_comm
		// vehicle_freight_type
		// vehicle_freight_amount
		// vehicle_freight_final
		// operator
		// datetime
		// expenses_id

		if ($this->RowType == ROWTYPE_VIEW) { // View row

			// id
			$this->id->ViewValue = $this->id->CurrentValue;
			$this->id->ViewCustomAttributes = "";

			// vehicle_type
			if (strval($this->vehicle_type->CurrentValue) <> "") {
				$this->vehicle_type->ViewValue = $this->vehicle_type->optionCaption($this->vehicle_type->CurrentValue);
			} else {
				$this->vehicle_type->ViewValue = NULL;
			}
			$this->vehicle_type->ViewCustomAttributes = "";

			// vehicle
			$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
			$curVal = strval($this->vehicle->CurrentValue);
			if ($curVal <> "") {
				$this->vehicle->ViewValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->vehicle->ViewValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->ViewValue = $this->vehicle->CurrentValue;
					}
				}
			} else {
				$this->vehicle->ViewValue = NULL;
			}
			$this->vehicle->ViewCustomAttributes = "";

			// route
			$this->_route->ViewValue = $this->_route->CurrentValue;
			$curVal = strval($this->_route->CurrentValue);
			if ($curVal <> "") {
				$this->_route->ViewValue = $this->_route->lookupCacheOption($curVal);
				if ($this->_route->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->_route->ViewValue = $this->_route->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_route->ViewValue = $this->_route->CurrentValue;
					}
				}
			} else {
				$this->_route->ViewValue = NULL;
			}
			$this->_route->ViewCustomAttributes = "";

			// route_name
			$this->route_name->ViewValue = $this->route_name->CurrentValue;
			$this->route_name->ViewCustomAttributes = "";

			// reports_to
			$curVal = strval($this->reports_to->CurrentValue);
			if ($curVal <> "") {
				$this->reports_to->ViewValue = $this->reports_to->lookupCacheOption($curVal);
				if ($this->reports_to->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->reports_to->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->reports_to->ViewValue = $this->reports_to->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->reports_to->ViewValue = $this->reports_to->CurrentValue;
					}
				}
			} else {
				$this->reports_to->ViewValue = NULL;
			}
			$this->reports_to->ViewCustomAttributes = "";

			// buyer
			$this->buyer->ViewValue = $this->buyer->CurrentValue;
			$curVal = strval($this->buyer->CurrentValue);
			if ($curVal <> "") {
				$this->buyer->ViewValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->buyer->ViewValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->ViewValue = $this->buyer->CurrentValue;
					}
				}
			} else {
				$this->buyer->ViewValue = NULL;
			}
			$this->buyer->ViewCustomAttributes = "";

			// b_consignor
			$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
			$curVal = strval($this->b_consignor->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignor->ViewValue = $this->b_consignor->lookupCacheOption($curVal);
				if ($this->b_consignor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignor->ViewValue = $this->b_consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignor->ViewValue = $this->b_consignor->CurrentValue;
					}
				}
			} else {
				$this->b_consignor->ViewValue = NULL;
			}
			$this->b_consignor->ViewCustomAttributes = "";

			// b_consignee
			$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
			$curVal = strval($this->b_consignee->CurrentValue);
			if ($curVal <> "") {
				$this->b_consignee->ViewValue = $this->b_consignee->lookupCacheOption($curVal);
				if ($this->b_consignee->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->b_consignee->ViewValue = $this->b_consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignee->ViewValue = $this->b_consignee->CurrentValue;
					}
				}
			} else {
				$this->b_consignee->ViewValue = NULL;
			}
			$this->b_consignee->ViewCustomAttributes = "";

			// load_date
			$this->load_date->ViewValue = $this->load_date->CurrentValue;
			$this->load_date->ViewValue = FormatDateTime($this->load_date->ViewValue, 1);
			$this->load_date->ViewCustomAttributes = "";

			// load_weight
			$this->load_weight->ViewValue = $this->load_weight->CurrentValue;
			$this->load_weight->ViewValue = FormatNumber($this->load_weight->ViewValue, 0, -2, -2, -2);
			$this->load_weight->ViewCustomAttributes = "";

			// unload_date
			$this->unload_date->ViewValue = $this->unload_date->CurrentValue;
			$this->unload_date->ViewValue = FormatDateTime($this->unload_date->ViewValue, 0);
			$this->unload_date->ViewCustomAttributes = "";

			// unload_weight
			$this->unload_weight->ViewValue = $this->unload_weight->CurrentValue;
			$this->unload_weight->ViewValue = FormatNumber($this->unload_weight->ViewValue, 0, -2, -2, -2);
			$this->unload_weight->ViewCustomAttributes = "";

			// invoice_no
			$this->invoice_no->ViewValue = $this->invoice_no->CurrentValue;
			$this->invoice_no->ViewValue = FormatNumber($this->invoice_no->ViewValue, 0, -2, -2, -2);
			$this->invoice_no->ViewCustomAttributes = "";

			// invoice_date
			$this->invoice_date->ViewValue = $this->invoice_date->CurrentValue;
			$this->invoice_date->ViewValue = FormatDateTime($this->invoice_date->ViewValue, 0);
			$this->invoice_date->ViewCustomAttributes = "";

			// amount
			$this->amount->ViewValue = $this->amount->CurrentValue;
			$this->amount->ViewValue = FormatNumber($this->amount->ViewValue, 2, -2, -2, -2);
			$this->amount->ViewCustomAttributes = "";

			// delivery_pod
			if (strval($this->delivery_pod->CurrentValue) <> "") {
				$this->delivery_pod->ViewValue = $this->delivery_pod->optionCaption($this->delivery_pod->CurrentValue);
			} else {
				$this->delivery_pod->ViewValue = NULL;
			}
			$this->delivery_pod->ViewCustomAttributes = "";

			// status
			if (strval($this->status->CurrentValue) <> "") {
				$this->status->ViewValue = $this->status->optionCaption($this->status->CurrentValue);
			} else {
				$this->status->ViewValue = NULL;
			}
			$this->status->ViewCustomAttributes = "";

			// days
			$this->days->ViewValue = $this->days->CurrentValue;
			$this->days->ViewValue = FormatNumber($this->days->ViewValue, 0, -2, -2, -2);
			$this->days->ViewCustomAttributes = "";

			// driver
			$curVal = strval($this->driver->CurrentValue);
			if ($curVal <> "") {
				$this->driver->ViewValue = $this->driver->lookupCacheOption($curVal);
				if ($this->driver->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->driver->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$arwrk[2] = $rswrk->fields('df2');
						$this->driver->ViewValue = $this->driver->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->driver->ViewValue = $this->driver->CurrentValue;
					}
				}
			} else {
				$this->driver->ViewValue = NULL;
			}
			$this->driver->ViewCustomAttributes = "";

			// driver_name
			$this->driver_name->ViewValue = $this->driver_name->CurrentValue;
			$this->driver_name->ViewCustomAttributes = "";

			// agent
			if ($this->agent->VirtualValue <> "") {
				$this->agent->ViewValue = $this->agent->VirtualValue;
			} else {
				$this->agent->ViewValue = $this->agent->CurrentValue;
			$curVal = strval($this->agent->CurrentValue);
			if ($curVal <> "") {
				$this->agent->ViewValue = $this->agent->lookupCacheOption($curVal);
				if ($this->agent->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->agent->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->agent->ViewValue = $this->agent->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->agent->ViewValue = $this->agent->CurrentValue;
					}
				}
			} else {
				$this->agent->ViewValue = NULL;
			}
			}
			$this->agent->ViewCustomAttributes = "";

			// comm
			$this->comm->ViewValue = $this->comm->CurrentValue;
			$this->comm->ViewValue = FormatNumber($this->comm->ViewValue, 2, -2, -2, -2);
			$this->comm->ViewCustomAttributes = "";

			// material
			$this->material->ViewValue = $this->material->CurrentValue;
			$this->material->ViewCustomAttributes = "";

			// packing_type
			$this->packing_type->ViewValue = $this->packing_type->CurrentValue;
			$this->packing_type->ViewCustomAttributes = "";

			// m_hsn
			$this->m_hsn->ViewValue = $this->m_hsn->CurrentValue;
			$this->m_hsn->ViewCustomAttributes = "";

			// @
			$this->_40->ViewValue = $this->_40->CurrentValue;
			$this->_40->ViewValue = FormatNumber($this->_40->ViewValue, 2, -2, -2, -2);
			$this->_40->ViewCustomAttributes = "";

			// lr_no
			$this->lr_no->ViewValue = $this->lr_no->CurrentValue;
			$this->lr_no->ViewCustomAttributes = "";

			// km
			$this->km->ViewValue = $this->km->CurrentValue;
			$this->km->ViewValue = FormatNumber($this->km->ViewValue, 2, -2, -2, -2);
			$this->km->ViewCustomAttributes = "";

			// freight_type
			if (strval($this->freight_type->CurrentValue) <> "") {
				$this->freight_type->ViewValue = $this->freight_type->optionCaption($this->freight_type->CurrentValue);
			} else {
				$this->freight_type->ViewValue = NULL;
			}
			$this->freight_type->ViewCustomAttributes = "";

			// freight
			$this->freight->ViewValue = $this->freight->CurrentValue;
			$this->freight->ViewValue = FormatNumber($this->freight->ViewValue, 2, -2, -2, -2);
			$this->freight->ViewCustomAttributes = "";

			// ded_det
			$this->ded_det->ViewValue = $this->ded_det->CurrentValue;
			$this->ded_det->ViewValue = FormatNumber($this->ded_det->ViewValue, 2, -2, -2, -2);
			$this->ded_det->ViewCustomAttributes = "";

			// ded_det_remarks
			$this->ded_det_remarks->ViewValue = $this->ded_det_remarks->CurrentValue;
			$this->ded_det_remarks->ViewCustomAttributes = "";

			// gst_percent
			$this->gst_percent->ViewValue = $this->gst_percent->CurrentValue;
			$this->gst_percent->ViewValue = FormatNumber($this->gst_percent->ViewValue, 2, -2, -2, -2);
			$this->gst_percent->ViewCustomAttributes = "";

			// gst_amount
			$this->gst_amount->ViewValue = $this->gst_amount->CurrentValue;
			$this->gst_amount->ViewValue = FormatNumber($this->gst_amount->ViewValue, 2, -2, -2, -2);
			$this->gst_amount->ViewCustomAttributes = "";

			// final_amount
			$this->final_amount->ViewValue = $this->final_amount->CurrentValue;
			$this->final_amount->ViewValue = FormatNumber($this->final_amount->ViewValue, 2, -2, -2, -2);
			$this->final_amount->ViewCustomAttributes = "";

			// load_km
			$this->load_km->ViewValue = $this->load_km->CurrentValue;
			$this->load_km->ViewValue = FormatNumber($this->load_km->ViewValue, 0, -2, -2, -2);
			$this->load_km->ViewCustomAttributes = "";

			// unload_km
			$this->unload_km->ViewValue = $this->unload_km->CurrentValue;
			$this->unload_km->ViewValue = FormatNumber($this->unload_km->ViewValue, 0, -2, -2, -2);
			$this->unload_km->ViewCustomAttributes = "";

			// delivery_receipt
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->ImageWidth = 0;
				$this->delivery_receipt->ImageHeight = 50;
				$this->delivery_receipt->ImageAlt = $this->delivery_receipt->alt();
				$this->delivery_receipt->ViewValue = $this->delivery_receipt->Upload->DbValue;
			} else {
				$this->delivery_receipt->ViewValue = "";
			}
			$this->delivery_receipt->ViewCustomAttributes = "";

			// delivery_docket
			$this->delivery_docket->ViewValue = $this->delivery_docket->CurrentValue;
			$this->delivery_docket->ViewCustomAttributes = "";

			// diesal_op_b
			$this->diesal_op_b->ViewValue = $this->diesal_op_b->CurrentValue;
			$this->diesal_op_b->ViewValue = FormatNumber($this->diesal_op_b->ViewValue, 2, -2, -2, -2);
			$this->diesal_op_b->ViewCustomAttributes = "";

			// diesal_required
			$this->diesal_required->ViewValue = $this->diesal_required->CurrentValue;
			$this->diesal_required->ViewValue = FormatNumber($this->diesal_required->ViewValue, 2, -2, -2, -2);
			$this->diesal_required->ViewCustomAttributes = "";

			// diesal_fill
			$this->diesal_fill->ViewValue = $this->diesal_fill->CurrentValue;
			$this->diesal_fill->ViewValue = FormatNumber($this->diesal_fill->ViewValue, 2, -2, -2, -2);
			$this->diesal_fill->ViewCustomAttributes = "";

			// diesal_amount
			$this->diesal_amount->ViewValue = $this->diesal_amount->CurrentValue;
			$this->diesal_amount->ViewValue = FormatNumber($this->diesal_amount->ViewValue, 2, -2, -2, -2);
			$this->diesal_amount->ViewCustomAttributes = "";

			// diesal_cl_balance
			$this->diesal_cl_balance->ViewValue = $this->diesal_cl_balance->CurrentValue;
			$this->diesal_cl_balance->ViewValue = FormatNumber($this->diesal_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->diesal_cl_balance->ViewCustomAttributes = "";

			// vehicle_average
			$this->vehicle_average->ViewValue = $this->vehicle_average->CurrentValue;
			$this->vehicle_average->ViewValue = FormatNumber($this->vehicle_average->ViewValue, 2, -2, -2, -2);
			$this->vehicle_average->ViewCustomAttributes = "";

			// cash_required
			$this->cash_required->ViewValue = $this->cash_required->CurrentValue;
			$this->cash_required->ViewValue = FormatNumber($this->cash_required->ViewValue, 2, -2, -2, -2);
			$this->cash_required->ViewCustomAttributes = "";

			// cash_op_b
			$this->cash_op_b->ViewValue = $this->cash_op_b->CurrentValue;
			$this->cash_op_b->ViewValue = FormatNumber($this->cash_op_b->ViewValue, 2, -2, -2, -2);
			$this->cash_op_b->ViewCustomAttributes = "";

			// cash_paid
			$this->cash_paid->ViewValue = $this->cash_paid->CurrentValue;
			$this->cash_paid->ViewValue = FormatNumber($this->cash_paid->ViewValue, 2, -2, -2, -2);
			$this->cash_paid->ViewCustomAttributes = "";

			// cash_expenses
			$this->cash_expenses->ViewValue = $this->cash_expenses->CurrentValue;
			$this->cash_expenses->ViewValue = FormatNumber($this->cash_expenses->ViewValue, 2, -2, -2, -2);
			$this->cash_expenses->ViewCustomAttributes = "";

			// cash_cl_balance
			$this->cash_cl_balance->ViewValue = $this->cash_cl_balance->CurrentValue;
			$this->cash_cl_balance->ViewValue = FormatNumber($this->cash_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->cash_cl_balance->ViewCustomAttributes = "";

			// fasttag_op_b
			$this->fasttag_op_b->ViewValue = $this->fasttag_op_b->CurrentValue;
			$this->fasttag_op_b->ViewValue = FormatNumber($this->fasttag_op_b->ViewValue, 2, -2, -2, -2);
			$this->fasttag_op_b->ViewCustomAttributes = "";

			// fasttag_recharge
			$this->fasttag_recharge->ViewValue = $this->fasttag_recharge->CurrentValue;
			$this->fasttag_recharge->ViewValue = FormatNumber($this->fasttag_recharge->ViewValue, 2, -2, -2, -2);
			$this->fasttag_recharge->ViewCustomAttributes = "";

			// fasttag_expenses
			$this->fasttag_expenses->ViewValue = $this->fasttag_expenses->CurrentValue;
			$this->fasttag_expenses->ViewValue = FormatNumber($this->fasttag_expenses->ViewValue, 2, -2, -2, -2);
			$this->fasttag_expenses->ViewCustomAttributes = "";

			// toll_expenses_cash
			$this->toll_expenses_cash->ViewValue = $this->toll_expenses_cash->CurrentValue;
			$this->toll_expenses_cash->ViewValue = FormatNumber($this->toll_expenses_cash->ViewValue, 2, -2, -2, -2);
			$this->toll_expenses_cash->ViewCustomAttributes = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->ViewValue = $this->fasttag_cl_balance->CurrentValue;
			$this->fasttag_cl_balance->ViewValue = FormatNumber($this->fasttag_cl_balance->ViewValue, 2, -2, -2, -2);
			$this->fasttag_cl_balance->ViewCustomAttributes = "";

			// remarks
			$this->remarks->ViewValue = $this->remarks->CurrentValue;
			$this->remarks->ViewCustomAttributes = "";

			// uploads
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->ImageWidth = 0;
				$this->uploads->ImageHeight = 50;
				$this->uploads->ImageAlt = $this->uploads->alt();
				$this->uploads->ViewValue = $this->uploads->Upload->DbValue;
			} else {
				$this->uploads->ViewValue = "";
			}
			$this->uploads->ViewCustomAttributes = "";

			// consignor
			$this->consignor->ViewValue = $this->consignor->CurrentValue;
			$curVal = strval($this->consignor->CurrentValue);
			if ($curVal <> "") {
				$this->consignor->ViewValue = $this->consignor->lookupCacheOption($curVal);
				if ($this->consignor->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->consignor->ViewValue = $this->consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignor->ViewValue = $this->consignor->CurrentValue;
					}
				}
			} else {
				$this->consignor->ViewValue = NULL;
			}
			$this->consignor->ViewCustomAttributes = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->ViewValue = $this->vehicle_freight_comm->CurrentValue;
			$this->vehicle_freight_comm->ViewValue = FormatNumber($this->vehicle_freight_comm->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_comm->ViewCustomAttributes = "";

			// vehicle_freight_type
			if (strval($this->vehicle_freight_type->CurrentValue) <> "") {
				$this->vehicle_freight_type->ViewValue = $this->vehicle_freight_type->optionCaption($this->vehicle_freight_type->CurrentValue);
			} else {
				$this->vehicle_freight_type->ViewValue = NULL;
			}
			$this->vehicle_freight_type->ViewCustomAttributes = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->ViewValue = $this->vehicle_freight_amount->CurrentValue;
			$this->vehicle_freight_amount->ViewValue = FormatNumber($this->vehicle_freight_amount->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_amount->ViewCustomAttributes = "";

			// vehicle_freight_final
			$this->vehicle_freight_final->ViewValue = $this->vehicle_freight_final->CurrentValue;
			$this->vehicle_freight_final->ViewValue = FormatNumber($this->vehicle_freight_final->ViewValue, 2, -2, -2, -2);
			$this->vehicle_freight_final->ViewCustomAttributes = "";

			// operator
			$curVal = strval($this->operator->CurrentValue);
			if ($curVal <> "") {
				$this->operator->ViewValue = $this->operator->lookupCacheOption($curVal);
				if ($this->operator->ViewValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$sqlWrk = $this->operator->Lookup->getSql(FALSE, $filterWrk, '', $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = $rswrk->fields('df');
						$this->operator->ViewValue = $this->operator->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->operator->ViewValue = $this->operator->CurrentValue;
					}
				}
			} else {
				$this->operator->ViewValue = NULL;
			}
			$this->operator->ViewCustomAttributes = "";

			// datetime
			$this->datetime->ViewValue = $this->datetime->CurrentValue;
			$this->datetime->ViewValue = FormatDateTime($this->datetime->ViewValue, 0);
			$this->datetime->ViewCustomAttributes = "";

			// id
			$this->id->LinkCustomAttributes = "";
			$this->id->HrefValue = "";
			$this->id->TooltipValue = "";

			// vehicle_type
			$this->vehicle_type->LinkCustomAttributes = "";
			$this->vehicle_type->HrefValue = "";
			$this->vehicle_type->TooltipValue = "";

			// vehicle
			$this->vehicle->LinkCustomAttributes = "";
			$this->vehicle->HrefValue = "";
			$this->vehicle->TooltipValue = "";

			// route
			$this->_route->LinkCustomAttributes = "";
			$this->_route->HrefValue = "";
			$this->_route->TooltipValue = "";

			// route_name
			$this->route_name->LinkCustomAttributes = "";
			$this->route_name->HrefValue = "";
			$this->route_name->TooltipValue = "";

			// reports_to
			$this->reports_to->LinkCustomAttributes = "";
			$this->reports_to->HrefValue = "";
			$this->reports_to->TooltipValue = "";

			// buyer
			$this->buyer->LinkCustomAttributes = "";
			$this->buyer->HrefValue = "";
			$this->buyer->TooltipValue = "";

			// b_consignor
			$this->b_consignor->LinkCustomAttributes = "";
			$this->b_consignor->HrefValue = "";
			$this->b_consignor->TooltipValue = "";

			// b_consignee
			$this->b_consignee->LinkCustomAttributes = "";
			$this->b_consignee->HrefValue = "";
			$this->b_consignee->TooltipValue = "";

			// load_date
			$this->load_date->LinkCustomAttributes = "";
			$this->load_date->HrefValue = "";
			$this->load_date->TooltipValue = "";

			// load_weight
			$this->load_weight->LinkCustomAttributes = "";
			$this->load_weight->HrefValue = "";
			$this->load_weight->TooltipValue = "";

			// unload_date
			$this->unload_date->LinkCustomAttributes = "";
			$this->unload_date->HrefValue = "";
			$this->unload_date->TooltipValue = "";

			// unload_weight
			$this->unload_weight->LinkCustomAttributes = "";
			$this->unload_weight->HrefValue = "";
			$this->unload_weight->TooltipValue = "";

			// invoice_no
			$this->invoice_no->LinkCustomAttributes = "";
			$this->invoice_no->HrefValue = "";
			$this->invoice_no->TooltipValue = "";

			// invoice_date
			$this->invoice_date->LinkCustomAttributes = "";
			$this->invoice_date->HrefValue = "";
			$this->invoice_date->TooltipValue = "";

			// amount
			$this->amount->LinkCustomAttributes = "";
			$this->amount->HrefValue = "";
			$this->amount->TooltipValue = "";

			// delivery_pod
			$this->delivery_pod->LinkCustomAttributes = "";
			$this->delivery_pod->HrefValue = "";
			$this->delivery_pod->TooltipValue = "";

			// status
			$this->status->LinkCustomAttributes = "";
			$this->status->HrefValue = "";
			$this->status->TooltipValue = "";

			// days
			$this->days->LinkCustomAttributes = "";
			$this->days->HrefValue = "";
			$this->days->TooltipValue = "";

			// driver
			$this->driver->LinkCustomAttributes = "";
			$this->driver->HrefValue = "";
			$this->driver->TooltipValue = "";

			// driver_name
			$this->driver_name->LinkCustomAttributes = "";
			$this->driver_name->HrefValue = "";
			$this->driver_name->TooltipValue = "";

			// agent
			$this->agent->LinkCustomAttributes = "";
			$this->agent->HrefValue = "";
			$this->agent->TooltipValue = "";

			// comm
			$this->comm->LinkCustomAttributes = "";
			$this->comm->HrefValue = "";
			$this->comm->TooltipValue = "";

			// material
			$this->material->LinkCustomAttributes = "";
			$this->material->HrefValue = "";
			$this->material->TooltipValue = "";

			// packing_type
			$this->packing_type->LinkCustomAttributes = "";
			$this->packing_type->HrefValue = "";
			$this->packing_type->TooltipValue = "";

			// m_hsn
			$this->m_hsn->LinkCustomAttributes = "";
			$this->m_hsn->HrefValue = "";
			$this->m_hsn->TooltipValue = "";

			// @
			$this->_40->LinkCustomAttributes = "";
			$this->_40->HrefValue = "";
			$this->_40->TooltipValue = "";

			// lr_no
			$this->lr_no->LinkCustomAttributes = "";
			$this->lr_no->HrefValue = "";
			$this->lr_no->TooltipValue = "";

			// km
			$this->km->LinkCustomAttributes = "";
			$this->km->HrefValue = "";
			$this->km->TooltipValue = "";

			// freight_type
			$this->freight_type->LinkCustomAttributes = "";
			$this->freight_type->HrefValue = "";
			$this->freight_type->TooltipValue = "";

			// freight
			$this->freight->LinkCustomAttributes = "";
			$this->freight->HrefValue = "";
			$this->freight->TooltipValue = "";

			// ded_det
			$this->ded_det->LinkCustomAttributes = "";
			$this->ded_det->HrefValue = "";
			$this->ded_det->TooltipValue = "";

			// ded_det_remarks
			$this->ded_det_remarks->LinkCustomAttributes = "";
			$this->ded_det_remarks->HrefValue = "";
			$this->ded_det_remarks->TooltipValue = "";

			// gst_percent
			$this->gst_percent->LinkCustomAttributes = "";
			$this->gst_percent->HrefValue = "";
			$this->gst_percent->TooltipValue = "";

			// gst_amount
			$this->gst_amount->LinkCustomAttributes = "";
			$this->gst_amount->HrefValue = "";
			$this->gst_amount->TooltipValue = "";

			// final_amount
			$this->final_amount->LinkCustomAttributes = "";
			$this->final_amount->HrefValue = "";
			$this->final_amount->TooltipValue = "";

			// load_km
			$this->load_km->LinkCustomAttributes = "";
			$this->load_km->HrefValue = "";
			$this->load_km->TooltipValue = "";

			// unload_km
			$this->unload_km->LinkCustomAttributes = "";
			$this->unload_km->HrefValue = "";
			$this->unload_km->TooltipValue = "";

			// delivery_receipt
			$this->delivery_receipt->LinkCustomAttributes = "";
			$this->delivery_receipt->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->delivery_receipt->Upload->DbValue)) {
				$this->delivery_receipt->HrefValue = "%u"; // Add prefix/suffix
				$this->delivery_receipt->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->delivery_receipt->HrefValue = FullUrl($this->delivery_receipt->HrefValue, "href");
			} else {
				$this->delivery_receipt->HrefValue = "";
			}
			$this->delivery_receipt->ExportHrefValue = $this->delivery_receipt->UploadPath . $this->delivery_receipt->Upload->DbValue;
			$this->delivery_receipt->TooltipValue = "";
			if ($this->delivery_receipt->UseColorbox) {
				if (EmptyValue($this->delivery_receipt->TooltipValue))
					$this->delivery_receipt->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->delivery_receipt->LinkAttrs["data-rel"] = "t_trip_info_x_delivery_receipt";
				AppendClass($this->delivery_receipt->LinkAttrs["class"], "ew-lightbox");
			}

			// delivery_docket
			$this->delivery_docket->LinkCustomAttributes = "";
			$this->delivery_docket->HrefValue = "";
			$this->delivery_docket->TooltipValue = "";

			// diesal_op_b
			$this->diesal_op_b->LinkCustomAttributes = "";
			$this->diesal_op_b->HrefValue = "";
			$this->diesal_op_b->TooltipValue = "";

			// diesal_required
			$this->diesal_required->LinkCustomAttributes = "";
			$this->diesal_required->HrefValue = "";
			$this->diesal_required->TooltipValue = "";

			// diesal_fill
			$this->diesal_fill->LinkCustomAttributes = "";
			$this->diesal_fill->HrefValue = "";
			$this->diesal_fill->TooltipValue = "";

			// diesal_amount
			$this->diesal_amount->LinkCustomAttributes = "";
			$this->diesal_amount->HrefValue = "";
			$this->diesal_amount->TooltipValue = "";

			// diesal_cl_balance
			$this->diesal_cl_balance->LinkCustomAttributes = "";
			$this->diesal_cl_balance->HrefValue = "";
			$this->diesal_cl_balance->TooltipValue = "";

			// vehicle_average
			$this->vehicle_average->LinkCustomAttributes = "";
			$this->vehicle_average->HrefValue = "";
			$this->vehicle_average->TooltipValue = "";

			// cash_required
			$this->cash_required->LinkCustomAttributes = "";
			$this->cash_required->HrefValue = "";
			$this->cash_required->TooltipValue = "";

			// cash_op_b
			$this->cash_op_b->LinkCustomAttributes = "";
			$this->cash_op_b->HrefValue = "";
			$this->cash_op_b->TooltipValue = "";

			// cash_paid
			$this->cash_paid->LinkCustomAttributes = "";
			$this->cash_paid->HrefValue = "";
			$this->cash_paid->TooltipValue = "";

			// cash_expenses
			$this->cash_expenses->LinkCustomAttributes = "";
			$this->cash_expenses->HrefValue = "";
			$this->cash_expenses->TooltipValue = "";

			// cash_cl_balance
			$this->cash_cl_balance->LinkCustomAttributes = "";
			$this->cash_cl_balance->HrefValue = "";
			$this->cash_cl_balance->TooltipValue = "";

			// fasttag_op_b
			$this->fasttag_op_b->LinkCustomAttributes = "";
			$this->fasttag_op_b->HrefValue = "";
			$this->fasttag_op_b->TooltipValue = "";

			// fasttag_recharge
			$this->fasttag_recharge->LinkCustomAttributes = "";
			$this->fasttag_recharge->HrefValue = "";
			$this->fasttag_recharge->TooltipValue = "";

			// fasttag_expenses
			$this->fasttag_expenses->LinkCustomAttributes = "";
			$this->fasttag_expenses->HrefValue = "";
			$this->fasttag_expenses->TooltipValue = "";

			// toll_expenses_cash
			$this->toll_expenses_cash->LinkCustomAttributes = "";
			$this->toll_expenses_cash->HrefValue = "";
			$this->toll_expenses_cash->TooltipValue = "";

			// fasttag_cl_balance
			$this->fasttag_cl_balance->LinkCustomAttributes = "";
			$this->fasttag_cl_balance->HrefValue = "";
			$this->fasttag_cl_balance->TooltipValue = "";

			// remarks
			$this->remarks->LinkCustomAttributes = "";
			$this->remarks->HrefValue = "";
			$this->remarks->TooltipValue = "";

			// uploads
			$this->uploads->LinkCustomAttributes = "";
			$this->uploads->UploadPath = '.p_uploads/trip_documents/' . $this->id->CurrentValue . '/';
			if (!EmptyValue($this->uploads->Upload->DbValue)) {
				$this->uploads->HrefValue = GetFileUploadUrl($this->uploads, $this->uploads->Upload->DbValue); // Add prefix/suffix
				$this->uploads->LinkAttrs["target"] = ""; // Add target
				if ($this->isExport()) $this->uploads->HrefValue = FullUrl($this->uploads->HrefValue, "href");
			} else {
				$this->uploads->HrefValue = "";
			}
			$this->uploads->ExportHrefValue = $this->uploads->UploadPath . $this->uploads->Upload->DbValue;
			$this->uploads->TooltipValue = "";
			if ($this->uploads->UseColorbox) {
				if (EmptyValue($this->uploads->TooltipValue))
					$this->uploads->LinkAttrs["title"] = $Language->phrase("ViewImageGallery");
				$this->uploads->LinkAttrs["data-rel"] = "t_trip_info_x_uploads";
				AppendClass($this->uploads->LinkAttrs["class"], "ew-lightbox");
			}

			// consignor
			$this->consignor->LinkCustomAttributes = "";
			$this->consignor->HrefValue = "";
			$this->consignor->TooltipValue = "";

			// vehicle_freight_comm
			$this->vehicle_freight_comm->LinkCustomAttributes = "";
			$this->vehicle_freight_comm->HrefValue = "";
			$this->vehicle_freight_comm->TooltipValue = "";

			// vehicle_freight_type
			$this->vehicle_freight_type->LinkCustomAttributes = "";
			$this->vehicle_freight_type->HrefValue = "";
			$this->vehicle_freight_type->TooltipValue = "";

			// vehicle_freight_amount
			$this->vehicle_freight_amount->LinkCustomAttributes = "";
			$this->vehicle_freight_amount->HrefValue = "";
			$this->vehicle_freight_amount->TooltipValue = "";

			// vehicle_freight_final
			$this->vehicle_freight_final->LinkCustomAttributes = "";
			$this->vehicle_freight_final->HrefValue = "";
			$this->vehicle_freight_final->TooltipValue = "";

			// operator
			$this->operator->LinkCustomAttributes = "";
			$this->operator->HrefValue = "";
			$this->operator->TooltipValue = "";

			// datetime
			$this->datetime->LinkCustomAttributes = "";
			$this->datetime->HrefValue = "";
			$this->datetime->TooltipValue = "";
		} elseif ($this->RowType == ROWTYPE_SEARCH) { // Search row

			// id
			$this->id->EditAttrs["class"] = "form-control";
			$this->id->EditCustomAttributes = "";
			$this->id->EditValue = HtmlEncode($this->id->AdvancedSearch->SearchValue);
			$this->id->PlaceHolder = RemoveHtml($this->id->caption());

			// vehicle_type
			$this->vehicle_type->EditAttrs["class"] = "form-control";
			$this->vehicle_type->EditCustomAttributes = "";
			$this->vehicle_type->EditValue = $this->vehicle_type->options(TRUE);

			// vehicle
			$this->vehicle->EditAttrs["class"] = "form-control";
			$this->vehicle->EditCustomAttributes = "";
			$this->vehicle->EditValue = HtmlEncode($this->vehicle->AdvancedSearch->SearchValue);
			$curVal = strval($this->vehicle->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->vehicle->EditValue = $this->vehicle->lookupCacheOption($curVal);
				if ($this->vehicle->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->vehicle->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->vehicle->EditValue = $this->vehicle->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->vehicle->EditValue = HtmlEncode($this->vehicle->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->vehicle->EditValue = NULL;
			}
			$this->vehicle->PlaceHolder = RemoveHtml($this->vehicle->caption());

			// route
			$this->_route->EditAttrs["class"] = "form-control";
			$this->_route->EditCustomAttributes = "";
			$this->_route->EditValue = HtmlEncode($this->_route->AdvancedSearch->SearchValue);
			$curVal = strval($this->_route->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->_route->EditValue = $this->_route->lookupCacheOption($curVal);
				if ($this->_route->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->_route->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->_route->EditValue = $this->_route->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->_route->EditValue = HtmlEncode($this->_route->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->_route->EditValue = NULL;
			}
			$this->_route->PlaceHolder = RemoveHtml($this->_route->caption());

			// route_name
			$this->route_name->EditAttrs["class"] = "form-control";
			$this->route_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->route_name->AdvancedSearch->SearchValue = HtmlDecode($this->route_name->AdvancedSearch->SearchValue);
			$this->route_name->EditValue = HtmlEncode($this->route_name->AdvancedSearch->SearchValue);
			$this->route_name->PlaceHolder = RemoveHtml($this->route_name->caption());

			// reports_to
			$this->reports_to->EditAttrs["class"] = "form-control";
			$this->reports_to->EditCustomAttributes = "";
			$curVal = trim(strval($this->reports_to->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->lookupCacheOption($curVal);
			else
				$this->reports_to->AdvancedSearch->ViewValue = $this->reports_to->Lookup !== NULL && is_array($this->reports_to->Lookup->Options) ? $curVal : NULL;
			if ($this->reports_to->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->reports_to->EditValue = array_values($this->reports_to->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->reports_to->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`activated`=1 and `userlevel`=1003";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->reports_to->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->reports_to->EditValue = $arwrk;
			}

			// buyer
			$this->buyer->EditAttrs["class"] = "form-control";
			$this->buyer->EditCustomAttributes = "";
			$this->buyer->EditValue = HtmlEncode($this->buyer->AdvancedSearch->SearchValue);
			$curVal = strval($this->buyer->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->buyer->EditValue = $this->buyer->lookupCacheOption($curVal);
				if ($this->buyer->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->buyer->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->buyer->EditValue = $this->buyer->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->buyer->EditValue = HtmlEncode($this->buyer->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->buyer->EditValue = NULL;
			}
			$this->buyer->PlaceHolder = RemoveHtml($this->buyer->caption());

			// b_consignor
			$this->b_consignor->EditAttrs["class"] = "form-control";
			$this->b_consignor->EditCustomAttributes = "";
			$this->b_consignor->EditValue = HtmlEncode($this->b_consignor->AdvancedSearch->SearchValue);
			$curVal = strval($this->b_consignor->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->b_consignor->EditValue = $this->b_consignor->lookupCacheOption($curVal);
				if ($this->b_consignor->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->b_consignor->EditValue = $this->b_consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignor->EditValue = HtmlEncode($this->b_consignor->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->b_consignor->EditValue = NULL;
			}
			$this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());
			$this->b_consignor->EditAttrs["class"] = "form-control";
			$this->b_consignor->EditCustomAttributes = "";
			$this->b_consignor->EditValue2 = HtmlEncode($this->b_consignor->AdvancedSearch->SearchValue2);
			$curVal = strval($this->b_consignor->AdvancedSearch->SearchValue2);
			if ($curVal <> "") {
				$this->b_consignor->EditValue2 = $this->b_consignor->lookupCacheOption($curVal);
				if ($this->b_consignor->EditValue2 === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->b_consignor->EditValue2 = $this->b_consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignor->EditValue2 = HtmlEncode($this->b_consignor->AdvancedSearch->SearchValue2);
					}
				}
			} else {
				$this->b_consignor->EditValue2 = NULL;
			}
			$this->b_consignor->PlaceHolder = RemoveHtml($this->b_consignor->caption());

			// b_consignee
			$this->b_consignee->EditAttrs["class"] = "form-control";
			$this->b_consignee->EditCustomAttributes = "";
			$this->b_consignee->EditValue = HtmlEncode($this->b_consignee->AdvancedSearch->SearchValue);
			$curVal = strval($this->b_consignee->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->b_consignee->EditValue = $this->b_consignee->lookupCacheOption($curVal);
				if ($this->b_consignee->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->b_consignee->EditValue = $this->b_consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignee->EditValue = HtmlEncode($this->b_consignee->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->b_consignee->EditValue = NULL;
			}
			$this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());
			$this->b_consignee->EditAttrs["class"] = "form-control";
			$this->b_consignee->EditCustomAttributes = "";
			$this->b_consignee->EditValue2 = HtmlEncode($this->b_consignee->AdvancedSearch->SearchValue2);
			$curVal = strval($this->b_consignee->AdvancedSearch->SearchValue2);
			if ($curVal <> "") {
				$this->b_consignee->EditValue2 = $this->b_consignee->lookupCacheOption($curVal);
				if ($this->b_consignee->EditValue2 === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->b_consignee->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->b_consignee->EditValue2 = $this->b_consignee->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->b_consignee->EditValue2 = HtmlEncode($this->b_consignee->AdvancedSearch->SearchValue2);
					}
				}
			} else {
				$this->b_consignee->EditValue2 = NULL;
			}
			$this->b_consignee->PlaceHolder = RemoveHtml($this->b_consignee->caption());

			// load_date
			$this->load_date->EditAttrs["class"] = "form-control";
			$this->load_date->EditCustomAttributes = "";
			$this->load_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->load_date->AdvancedSearch->SearchValue, 1), 8));
			$this->load_date->PlaceHolder = RemoveHtml($this->load_date->caption());

			// load_weight
			$this->load_weight->EditAttrs["class"] = "form-control";
			$this->load_weight->EditCustomAttributes = "";
			$this->load_weight->EditValue = HtmlEncode($this->load_weight->AdvancedSearch->SearchValue);
			$this->load_weight->PlaceHolder = RemoveHtml($this->load_weight->caption());

			// unload_date
			$this->unload_date->EditAttrs["class"] = "form-control";
			$this->unload_date->EditCustomAttributes = "";
			$this->unload_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->unload_date->AdvancedSearch->SearchValue, 0), 8));
			$this->unload_date->PlaceHolder = RemoveHtml($this->unload_date->caption());

			// unload_weight
			$this->unload_weight->EditAttrs["class"] = "form-control";
			$this->unload_weight->EditCustomAttributes = "";
			$this->unload_weight->EditValue = HtmlEncode($this->unload_weight->AdvancedSearch->SearchValue);
			$this->unload_weight->PlaceHolder = RemoveHtml($this->unload_weight->caption());

			// invoice_no
			$this->invoice_no->EditAttrs["class"] = "form-control";
			$this->invoice_no->EditCustomAttributes = "";
			$this->invoice_no->EditValue = HtmlEncode($this->invoice_no->AdvancedSearch->SearchValue);
			$this->invoice_no->PlaceHolder = RemoveHtml($this->invoice_no->caption());

			// invoice_date
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue, 0), 8));
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());
			$this->invoice_date->EditAttrs["class"] = "form-control";
			$this->invoice_date->EditCustomAttributes = "";
			$this->invoice_date->EditValue2 = HtmlEncode(FormatDateTime(UnFormatDateTime($this->invoice_date->AdvancedSearch->SearchValue2, 0), 8));
			$this->invoice_date->PlaceHolder = RemoveHtml($this->invoice_date->caption());

			// amount
			$this->amount->EditAttrs["class"] = "form-control";
			$this->amount->EditCustomAttributes = "";
			$this->amount->EditValue = HtmlEncode($this->amount->AdvancedSearch->SearchValue);
			$this->amount->PlaceHolder = RemoveHtml($this->amount->caption());

			// delivery_pod
			$this->delivery_pod->EditCustomAttributes = "";
			$this->delivery_pod->EditValue = $this->delivery_pod->options(FALSE);

			// status
			$this->status->EditAttrs["class"] = "form-control";
			$this->status->EditCustomAttributes = "";
			$this->status->EditValue = $this->status->options(TRUE);

			// days
			$this->days->EditAttrs["class"] = "form-control";
			$this->days->EditCustomAttributes = "";
			$this->days->EditValue = HtmlEncode($this->days->AdvancedSearch->SearchValue);
			$this->days->PlaceHolder = RemoveHtml($this->days->caption());

			// driver
			$this->driver->EditAttrs["class"] = "form-control";
			$this->driver->EditCustomAttributes = "";
			$curVal = trim(strval($this->driver->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->driver->AdvancedSearch->ViewValue = $this->driver->lookupCacheOption($curVal);
			else
				$this->driver->AdvancedSearch->ViewValue = $this->driver->Lookup !== NULL && is_array($this->driver->Lookup->Options) ? $curVal : NULL;
			if ($this->driver->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->driver->EditValue = array_values($this->driver->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->driver->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$lookupFilter = function() {
					return "`status`=1";
				};
				$lookupFilter = $lookupFilter->bindTo($this);
				$sqlWrk = $this->driver->Lookup->getSql(TRUE, $filterWrk, $lookupFilter, $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->driver->EditValue = $arwrk;
			}

			// driver_name
			$this->driver_name->EditAttrs["class"] = "form-control";
			$this->driver_name->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->driver_name->AdvancedSearch->SearchValue = HtmlDecode($this->driver_name->AdvancedSearch->SearchValue);
			$this->driver_name->EditValue = HtmlEncode($this->driver_name->AdvancedSearch->SearchValue);
			$this->driver_name->PlaceHolder = RemoveHtml($this->driver_name->caption());

			// agent
			$this->agent->EditAttrs["class"] = "form-control";
			$this->agent->EditCustomAttributes = "";
			$this->agent->EditValue = HtmlEncode($this->agent->AdvancedSearch->SearchValue);
			$this->agent->PlaceHolder = RemoveHtml($this->agent->caption());

			// comm
			$this->comm->EditAttrs["class"] = "form-control";
			$this->comm->EditCustomAttributes = "";
			$this->comm->EditValue = HtmlEncode($this->comm->AdvancedSearch->SearchValue);
			$this->comm->PlaceHolder = RemoveHtml($this->comm->caption());

			// material
			$this->material->EditAttrs["class"] = "form-control";
			$this->material->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->material->AdvancedSearch->SearchValue = HtmlDecode($this->material->AdvancedSearch->SearchValue);
			$this->material->EditValue = HtmlEncode($this->material->AdvancedSearch->SearchValue);
			$this->material->PlaceHolder = RemoveHtml($this->material->caption());

			// packing_type
			$this->packing_type->EditAttrs["class"] = "form-control";
			$this->packing_type->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->packing_type->AdvancedSearch->SearchValue = HtmlDecode($this->packing_type->AdvancedSearch->SearchValue);
			$this->packing_type->EditValue = HtmlEncode($this->packing_type->AdvancedSearch->SearchValue);
			$this->packing_type->PlaceHolder = RemoveHtml($this->packing_type->caption());

			// m_hsn
			$this->m_hsn->EditAttrs["class"] = "form-control";
			$this->m_hsn->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->m_hsn->AdvancedSearch->SearchValue = HtmlDecode($this->m_hsn->AdvancedSearch->SearchValue);
			$this->m_hsn->EditValue = HtmlEncode($this->m_hsn->AdvancedSearch->SearchValue);
			$this->m_hsn->PlaceHolder = RemoveHtml($this->m_hsn->caption());

			// @
			$this->_40->EditAttrs["class"] = "form-control";
			$this->_40->EditCustomAttributes = "";
			$this->_40->EditValue = HtmlEncode($this->_40->AdvancedSearch->SearchValue);
			$this->_40->PlaceHolder = RemoveHtml($this->_40->caption());

			// lr_no
			$this->lr_no->EditAttrs["class"] = "form-control";
			$this->lr_no->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->lr_no->AdvancedSearch->SearchValue = HtmlDecode($this->lr_no->AdvancedSearch->SearchValue);
			$this->lr_no->EditValue = HtmlEncode($this->lr_no->AdvancedSearch->SearchValue);
			$this->lr_no->PlaceHolder = RemoveHtml($this->lr_no->caption());

			// km
			$this->km->EditAttrs["class"] = "form-control";
			$this->km->EditCustomAttributes = "";
			$this->km->EditValue = HtmlEncode($this->km->AdvancedSearch->SearchValue);
			$this->km->PlaceHolder = RemoveHtml($this->km->caption());

			// freight_type
			$this->freight_type->EditAttrs["class"] = "form-control";
			$this->freight_type->EditCustomAttributes = "";
			$this->freight_type->EditValue = $this->freight_type->options(TRUE);

			// freight
			$this->freight->EditAttrs["class"] = "form-control";
			$this->freight->EditCustomAttributes = "";
			$this->freight->EditValue = HtmlEncode($this->freight->AdvancedSearch->SearchValue);
			$this->freight->PlaceHolder = RemoveHtml($this->freight->caption());

			// ded_det
			$this->ded_det->EditAttrs["class"] = "form-control";
			$this->ded_det->EditCustomAttributes = "";
			$this->ded_det->EditValue = HtmlEncode($this->ded_det->AdvancedSearch->SearchValue);
			$this->ded_det->PlaceHolder = RemoveHtml($this->ded_det->caption());

			// ded_det_remarks
			$this->ded_det_remarks->EditAttrs["class"] = "form-control";
			$this->ded_det_remarks->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->ded_det_remarks->AdvancedSearch->SearchValue = HtmlDecode($this->ded_det_remarks->AdvancedSearch->SearchValue);
			$this->ded_det_remarks->EditValue = HtmlEncode($this->ded_det_remarks->AdvancedSearch->SearchValue);
			$this->ded_det_remarks->PlaceHolder = RemoveHtml($this->ded_det_remarks->caption());

			// gst_percent
			$this->gst_percent->EditAttrs["class"] = "form-control";
			$this->gst_percent->EditCustomAttributes = "";
			$this->gst_percent->EditValue = HtmlEncode($this->gst_percent->AdvancedSearch->SearchValue);
			$this->gst_percent->PlaceHolder = RemoveHtml($this->gst_percent->caption());

			// gst_amount
			$this->gst_amount->EditAttrs["class"] = "form-control";
			$this->gst_amount->EditCustomAttributes = "";
			$this->gst_amount->EditValue = HtmlEncode($this->gst_amount->AdvancedSearch->SearchValue);
			$this->gst_amount->PlaceHolder = RemoveHtml($this->gst_amount->caption());

			// final_amount
			$this->final_amount->EditAttrs["class"] = "form-control";
			$this->final_amount->EditCustomAttributes = "";
			$this->final_amount->EditValue = HtmlEncode($this->final_amount->AdvancedSearch->SearchValue);
			$this->final_amount->PlaceHolder = RemoveHtml($this->final_amount->caption());

			// load_km
			$this->load_km->EditAttrs["class"] = "form-control";
			$this->load_km->EditCustomAttributes = "";
			$this->load_km->EditValue = HtmlEncode($this->load_km->AdvancedSearch->SearchValue);
			$this->load_km->PlaceHolder = RemoveHtml($this->load_km->caption());

			// unload_km
			$this->unload_km->EditAttrs["class"] = "form-control";
			$this->unload_km->EditCustomAttributes = "";
			$this->unload_km->EditValue = HtmlEncode($this->unload_km->AdvancedSearch->SearchValue);
			$this->unload_km->PlaceHolder = RemoveHtml($this->unload_km->caption());

			// delivery_receipt
			$this->delivery_receipt->EditAttrs["class"] = "form-control";
			$this->delivery_receipt->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->delivery_receipt->AdvancedSearch->SearchValue = HtmlDecode($this->delivery_receipt->AdvancedSearch->SearchValue);
			$this->delivery_receipt->EditValue = HtmlEncode($this->delivery_receipt->AdvancedSearch->SearchValue);
			$this->delivery_receipt->PlaceHolder = RemoveHtml($this->delivery_receipt->caption());

			// delivery_docket
			$this->delivery_docket->EditAttrs["class"] = "form-control";
			$this->delivery_docket->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->delivery_docket->AdvancedSearch->SearchValue = HtmlDecode($this->delivery_docket->AdvancedSearch->SearchValue);
			$this->delivery_docket->EditValue = HtmlEncode($this->delivery_docket->AdvancedSearch->SearchValue);
			$this->delivery_docket->PlaceHolder = RemoveHtml($this->delivery_docket->caption());

			// diesal_op_b
			$this->diesal_op_b->EditAttrs["class"] = "form-control";
			$this->diesal_op_b->EditCustomAttributes = "";
			$this->diesal_op_b->EditValue = HtmlEncode($this->diesal_op_b->AdvancedSearch->SearchValue);
			$this->diesal_op_b->PlaceHolder = RemoveHtml($this->diesal_op_b->caption());

			// diesal_required
			$this->diesal_required->EditAttrs["class"] = "form-control";
			$this->diesal_required->EditCustomAttributes = "";
			$this->diesal_required->EditValue = HtmlEncode($this->diesal_required->AdvancedSearch->SearchValue);
			$this->diesal_required->PlaceHolder = RemoveHtml($this->diesal_required->caption());

			// diesal_fill
			$this->diesal_fill->EditAttrs["class"] = "form-control";
			$this->diesal_fill->EditCustomAttributes = "";
			$this->diesal_fill->EditValue = HtmlEncode($this->diesal_fill->AdvancedSearch->SearchValue);
			$this->diesal_fill->PlaceHolder = RemoveHtml($this->diesal_fill->caption());

			// diesal_amount
			$this->diesal_amount->EditAttrs["class"] = "form-control";
			$this->diesal_amount->EditCustomAttributes = "";
			$this->diesal_amount->EditValue = HtmlEncode($this->diesal_amount->AdvancedSearch->SearchValue);
			$this->diesal_amount->PlaceHolder = RemoveHtml($this->diesal_amount->caption());

			// diesal_cl_balance
			$this->diesal_cl_balance->EditAttrs["class"] = "form-control";
			$this->diesal_cl_balance->EditCustomAttributes = "";
			$this->diesal_cl_balance->EditValue = HtmlEncode($this->diesal_cl_balance->AdvancedSearch->SearchValue);
			$this->diesal_cl_balance->PlaceHolder = RemoveHtml($this->diesal_cl_balance->caption());

			// vehicle_average
			$this->vehicle_average->EditAttrs["class"] = "form-control";
			$this->vehicle_average->EditCustomAttributes = "";
			$this->vehicle_average->EditValue = HtmlEncode($this->vehicle_average->AdvancedSearch->SearchValue);
			$this->vehicle_average->PlaceHolder = RemoveHtml($this->vehicle_average->caption());

			// cash_required
			$this->cash_required->EditAttrs["class"] = "form-control";
			$this->cash_required->EditCustomAttributes = "";
			$this->cash_required->EditValue = HtmlEncode($this->cash_required->AdvancedSearch->SearchValue);
			$this->cash_required->PlaceHolder = RemoveHtml($this->cash_required->caption());

			// cash_op_b
			$this->cash_op_b->EditAttrs["class"] = "form-control";
			$this->cash_op_b->EditCustomAttributes = "";
			$this->cash_op_b->EditValue = HtmlEncode($this->cash_op_b->AdvancedSearch->SearchValue);
			$this->cash_op_b->PlaceHolder = RemoveHtml($this->cash_op_b->caption());

			// cash_paid
			$this->cash_paid->EditAttrs["class"] = "form-control";
			$this->cash_paid->EditCustomAttributes = "";
			$this->cash_paid->EditValue = HtmlEncode($this->cash_paid->AdvancedSearch->SearchValue);
			$this->cash_paid->PlaceHolder = RemoveHtml($this->cash_paid->caption());

			// cash_expenses
			$this->cash_expenses->EditAttrs["class"] = "form-control";
			$this->cash_expenses->EditCustomAttributes = "";
			$this->cash_expenses->EditValue = HtmlEncode($this->cash_expenses->AdvancedSearch->SearchValue);
			$this->cash_expenses->PlaceHolder = RemoveHtml($this->cash_expenses->caption());

			// cash_cl_balance
			$this->cash_cl_balance->EditAttrs["class"] = "form-control";
			$this->cash_cl_balance->EditCustomAttributes = "";
			$this->cash_cl_balance->EditValue = HtmlEncode($this->cash_cl_balance->AdvancedSearch->SearchValue);
			$this->cash_cl_balance->PlaceHolder = RemoveHtml($this->cash_cl_balance->caption());

			// fasttag_op_b
			$this->fasttag_op_b->EditAttrs["class"] = "form-control";
			$this->fasttag_op_b->EditCustomAttributes = "";
			$this->fasttag_op_b->EditValue = HtmlEncode($this->fasttag_op_b->AdvancedSearch->SearchValue);
			$this->fasttag_op_b->PlaceHolder = RemoveHtml($this->fasttag_op_b->caption());

			// fasttag_recharge
			$this->fasttag_recharge->EditAttrs["class"] = "form-control";
			$this->fasttag_recharge->EditCustomAttributes = "";
			$this->fasttag_recharge->EditValue = HtmlEncode($this->fasttag_recharge->AdvancedSearch->SearchValue);
			$this->fasttag_recharge->PlaceHolder = RemoveHtml($this->fasttag_recharge->caption());

			// fasttag_expenses
			$this->fasttag_expenses->EditAttrs["class"] = "form-control";
			$this->fasttag_expenses->EditCustomAttributes = "";
			$this->fasttag_expenses->EditValue = HtmlEncode($this->fasttag_expenses->AdvancedSearch->SearchValue);
			$this->fasttag_expenses->PlaceHolder = RemoveHtml($this->fasttag_expenses->caption());

			// toll_expenses_cash
			$this->toll_expenses_cash->EditAttrs["class"] = "form-control";
			$this->toll_expenses_cash->EditCustomAttributes = "";
			$this->toll_expenses_cash->EditValue = HtmlEncode($this->toll_expenses_cash->AdvancedSearch->SearchValue);
			$this->toll_expenses_cash->PlaceHolder = RemoveHtml($this->toll_expenses_cash->caption());

			// fasttag_cl_balance
			$this->fasttag_cl_balance->EditAttrs["class"] = "form-control";
			$this->fasttag_cl_balance->EditCustomAttributes = "";
			$this->fasttag_cl_balance->EditValue = HtmlEncode($this->fasttag_cl_balance->AdvancedSearch->SearchValue);
			$this->fasttag_cl_balance->PlaceHolder = RemoveHtml($this->fasttag_cl_balance->caption());

			// remarks
			$this->remarks->EditAttrs["class"] = "form-control";
			$this->remarks->EditCustomAttributes = "";
			$this->remarks->EditValue = HtmlEncode($this->remarks->AdvancedSearch->SearchValue);
			$this->remarks->PlaceHolder = RemoveHtml($this->remarks->caption());

			// uploads
			$this->uploads->EditAttrs["class"] = "form-control";
			$this->uploads->EditCustomAttributes = "";
			if (REMOVE_XSS)
				$this->uploads->AdvancedSearch->SearchValue = HtmlDecode($this->uploads->AdvancedSearch->SearchValue);
			$this->uploads->EditValue = HtmlEncode($this->uploads->AdvancedSearch->SearchValue);
			$this->uploads->PlaceHolder = RemoveHtml($this->uploads->caption());

			// consignor
			$this->consignor->EditAttrs["class"] = "form-control";
			$this->consignor->EditCustomAttributes = 'ReadOnly';
			$this->consignor->EditValue = HtmlEncode($this->consignor->AdvancedSearch->SearchValue);
			$curVal = strval($this->consignor->AdvancedSearch->SearchValue);
			if ($curVal <> "") {
				$this->consignor->EditValue = $this->consignor->lookupCacheOption($curVal);
				if ($this->consignor->EditValue === NULL) { // Lookup from database
					$filterWrk = "`id`" . SearchString("=", $curVal, DATATYPE_NUMBER, "");
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					$sqlWrk = $this->consignor->Lookup->getSql(FALSE, $filterWrk, $lookupFilter, $this);
					$rswrk = Conn()->execute($sqlWrk);
					if ($rswrk && !$rswrk->EOF) { // Lookup values found
						$arwrk = array();
						$arwrk[1] = HtmlEncode($rswrk->fields('df'));
						$this->consignor->EditValue = $this->consignor->displayValue($arwrk);
						$rswrk->Close();
					} else {
						$this->consignor->EditValue = HtmlEncode($this->consignor->AdvancedSearch->SearchValue);
					}
				}
			} else {
				$this->consignor->EditValue = NULL;
			}
			$this->consignor->PlaceHolder = RemoveHtml($this->consignor->caption());

			// vehicle_freight_comm
			$this->vehicle_freight_comm->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_comm->EditCustomAttributes = "";
			$this->vehicle_freight_comm->EditValue = HtmlEncode($this->vehicle_freight_comm->AdvancedSearch->SearchValue);
			$this->vehicle_freight_comm->PlaceHolder = RemoveHtml($this->vehicle_freight_comm->caption());

			// vehicle_freight_type
			$this->vehicle_freight_type->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_type->EditCustomAttributes = "";
			$this->vehicle_freight_type->EditValue = $this->vehicle_freight_type->options(TRUE);

			// vehicle_freight_amount
			$this->vehicle_freight_amount->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_amount->EditCustomAttributes = "";
			$this->vehicle_freight_amount->EditValue = HtmlEncode($this->vehicle_freight_amount->AdvancedSearch->SearchValue);
			$this->vehicle_freight_amount->PlaceHolder = RemoveHtml($this->vehicle_freight_amount->caption());

			// vehicle_freight_final
			$this->vehicle_freight_final->EditAttrs["class"] = "form-control";
			$this->vehicle_freight_final->EditCustomAttributes = "";
			$this->vehicle_freight_final->EditValue = HtmlEncode($this->vehicle_freight_final->AdvancedSearch->SearchValue);
			$this->vehicle_freight_final->PlaceHolder = RemoveHtml($this->vehicle_freight_final->caption());

			// operator
			$this->operator->EditAttrs["class"] = "form-control";
			$this->operator->EditCustomAttributes = "";
			$curVal = trim(strval($this->operator->AdvancedSearch->SearchValue));
			if ($curVal <> "")
				$this->operator->AdvancedSearch->ViewValue = $this->operator->lookupCacheOption($curVal);
			else
				$this->operator->AdvancedSearch->ViewValue = $this->operator->Lookup !== NULL && is_array($this->operator->Lookup->Options) ? $curVal : NULL;
			if ($this->operator->AdvancedSearch->ViewValue !== NULL) { // Load from cache
				$this->operator->EditValue = array_values($this->operator->Lookup->Options);
			} else { // Lookup from database
				if ($curVal == "") {
					$filterWrk = "0=1";
				} else {
					$filterWrk = "`id`" . SearchString("=", $this->operator->AdvancedSearch->SearchValue, DATATYPE_NUMBER, "");
				}
				$sqlWrk = $this->operator->Lookup->getSql(TRUE, $filterWrk, '', $this);
				$rswrk = Conn()->execute($sqlWrk);
				$arwrk = ($rswrk) ? $rswrk->GetRows() : array();
				if ($rswrk) $rswrk->Close();
				$this->operator->EditValue = $arwrk;
			}

			// datetime
			$this->datetime->EditAttrs["class"] = "form-control";
			$this->datetime->EditCustomAttributes = "";
			$this->datetime->EditValue = HtmlEncode(FormatDateTime(UnFormatDateTime($this->datetime->AdvancedSearch->SearchValue, 0), 8));
			$this->datetime->PlaceHolder = RemoveHtml($this->datetime->caption());
		}
		if ($this->RowType == ROWTYPE_ADD || $this->RowType == ROWTYPE_EDIT || $this->RowType == ROWTYPE_SEARCH) // Add/Edit/Search row
			$this->setupFieldTitles();

		// Call Row Rendered event
		if ($this->RowType <> ROWTYPE_AGGREGATEINIT)
			$this->Row_Rendered();
	}

	// Validate search
	protected function validateSearch()
	{
		global $SearchError;

		// Initialize
		$SearchError = "";

		// Check if validation required
		if (!SERVER_VALIDATE)
			return TRUE;
		if (!CheckInteger($this->id->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->id->errorMessage());
		}
		if (!CheckInteger($this->vehicle->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->vehicle->errorMessage());
		}
		if (!CheckInteger($this->_route->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_route->errorMessage());
		}
		if (!CheckInteger($this->buyer->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->buyer->errorMessage());
		}
		if (!CheckDate($this->load_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->load_date->errorMessage());
		}
		if (!CheckInteger($this->load_weight->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->load_weight->errorMessage());
		}
		if (!CheckDate($this->unload_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->unload_date->errorMessage());
		}
		if (!CheckInteger($this->unload_weight->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->unload_weight->errorMessage());
		}
		if (!CheckInteger($this->invoice_no->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->invoice_no->errorMessage());
		}
		if (!CheckDate($this->invoice_date->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->invoice_date->errorMessage());
		}
		if (!CheckDate($this->invoice_date->AdvancedSearch->SearchValue2)) {
			AddMessage($SearchError, $this->invoice_date->errorMessage());
		}
		if (!CheckNumber($this->amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->amount->errorMessage());
		}
		if (!CheckInteger($this->days->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->days->errorMessage());
		}
		if (!CheckNumber($this->comm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->comm->errorMessage());
		}
		if (!CheckNumber($this->_40->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->_40->errorMessage());
		}
		if (!CheckNumber($this->km->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->km->errorMessage());
		}
		if (!CheckNumber($this->freight->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->freight->errorMessage());
		}
		if (!CheckNumber($this->ded_det->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->ded_det->errorMessage());
		}
		if (!CheckNumber($this->gst_percent->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->gst_percent->errorMessage());
		}
		if (!CheckNumber($this->gst_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->gst_amount->errorMessage());
		}
		if (!CheckNumber($this->final_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->final_amount->errorMessage());
		}
		if (!CheckInteger($this->load_km->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->load_km->errorMessage());
		}
		if (!CheckInteger($this->unload_km->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->unload_km->errorMessage());
		}
		if (!CheckNumber($this->diesal_op_b->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->diesal_op_b->errorMessage());
		}
		if (!CheckNumber($this->diesal_required->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->diesal_required->errorMessage());
		}
		if (!CheckNumber($this->diesal_fill->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->diesal_fill->errorMessage());
		}
		if (!CheckNumber($this->diesal_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->diesal_amount->errorMessage());
		}
		if (!CheckNumber($this->diesal_cl_balance->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->diesal_cl_balance->errorMessage());
		}
		if (!CheckNumber($this->vehicle_average->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->vehicle_average->errorMessage());
		}
		if (!CheckNumber($this->cash_required->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->cash_required->errorMessage());
		}
		if (!CheckNumber($this->cash_op_b->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->cash_op_b->errorMessage());
		}
		if (!CheckNumber($this->cash_paid->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->cash_paid->errorMessage());
		}
		if (!CheckNumber($this->cash_expenses->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->cash_expenses->errorMessage());
		}
		if (!CheckNumber($this->cash_cl_balance->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->cash_cl_balance->errorMessage());
		}
		if (!CheckNumber($this->fasttag_op_b->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->fasttag_op_b->errorMessage());
		}
		if (!CheckNumber($this->fasttag_recharge->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->fasttag_recharge->errorMessage());
		}
		if (!CheckNumber($this->fasttag_expenses->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->fasttag_expenses->errorMessage());
		}
		if (!CheckNumber($this->toll_expenses_cash->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->toll_expenses_cash->errorMessage());
		}
		if (!CheckNumber($this->fasttag_cl_balance->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->fasttag_cl_balance->errorMessage());
		}
		if (!CheckInteger($this->consignor->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->consignor->errorMessage());
		}
		if (!CheckNumber($this->vehicle_freight_comm->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->vehicle_freight_comm->errorMessage());
		}
		if (!CheckNumber($this->vehicle_freight_amount->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->vehicle_freight_amount->errorMessage());
		}
		if (!CheckNumber($this->vehicle_freight_final->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->vehicle_freight_final->errorMessage());
		}
		if (!CheckDate($this->datetime->AdvancedSearch->SearchValue)) {
			AddMessage($SearchError, $this->datetime->errorMessage());
		}

		// Return validate result
		$validateSearch = ($SearchError == "");

		// Call Form_CustomValidate event
		$formCustomError = "";
		$validateSearch = $validateSearch && $this->Form_CustomValidate($formCustomError);
		if ($formCustomError <> "") {
			AddMessage($SearchError, $formCustomError);
		}
		return $validateSearch;
	}

	// Load advanced search
	public function loadAdvancedSearch()
	{
		$this->id->AdvancedSearch->load();
		$this->vehicle_type->AdvancedSearch->load();
		$this->vehicle->AdvancedSearch->load();
		$this->_route->AdvancedSearch->load();
		$this->route_name->AdvancedSearch->load();
		$this->reports_to->AdvancedSearch->load();
		$this->buyer->AdvancedSearch->load();
		$this->b_consignor->AdvancedSearch->load();
		$this->b_consignee->AdvancedSearch->load();
		$this->load_date->AdvancedSearch->load();
		$this->load_weight->AdvancedSearch->load();
		$this->unload_date->AdvancedSearch->load();
		$this->unload_weight->AdvancedSearch->load();
		$this->invoice_no->AdvancedSearch->load();
		$this->invoice_date->AdvancedSearch->load();
		$this->amount->AdvancedSearch->load();
		$this->delivery_pod->AdvancedSearch->load();
		$this->status->AdvancedSearch->load();
		$this->days->AdvancedSearch->load();
		$this->driver->AdvancedSearch->load();
		$this->driver_name->AdvancedSearch->load();
		$this->agent->AdvancedSearch->load();
		$this->comm->AdvancedSearch->load();
		$this->material->AdvancedSearch->load();
		$this->packing_type->AdvancedSearch->load();
		$this->m_hsn->AdvancedSearch->load();
		$this->_40->AdvancedSearch->load();
		$this->lr_no->AdvancedSearch->load();
		$this->km->AdvancedSearch->load();
		$this->freight_type->AdvancedSearch->load();
		$this->freight->AdvancedSearch->load();
		$this->ded_det->AdvancedSearch->load();
		$this->ded_det_remarks->AdvancedSearch->load();
		$this->gst_percent->AdvancedSearch->load();
		$this->gst_amount->AdvancedSearch->load();
		$this->final_amount->AdvancedSearch->load();
		$this->load_km->AdvancedSearch->load();
		$this->unload_km->AdvancedSearch->load();
		$this->delivery_receipt->AdvancedSearch->load();
		$this->delivery_docket->AdvancedSearch->load();
		$this->diesal_op_b->AdvancedSearch->load();
		$this->diesal_required->AdvancedSearch->load();
		$this->diesal_fill->AdvancedSearch->load();
		$this->diesal_amount->AdvancedSearch->load();
		$this->diesal_cl_balance->AdvancedSearch->load();
		$this->vehicle_average->AdvancedSearch->load();
		$this->cash_required->AdvancedSearch->load();
		$this->cash_op_b->AdvancedSearch->load();
		$this->cash_paid->AdvancedSearch->load();
		$this->cash_expenses->AdvancedSearch->load();
		$this->cash_cl_balance->AdvancedSearch->load();
		$this->fasttag_op_b->AdvancedSearch->load();
		$this->fasttag_recharge->AdvancedSearch->load();
		$this->fasttag_expenses->AdvancedSearch->load();
		$this->toll_expenses_cash->AdvancedSearch->load();
		$this->fasttag_cl_balance->AdvancedSearch->load();
		$this->remarks->AdvancedSearch->load();
		$this->uploads->AdvancedSearch->load();
		$this->consignor->AdvancedSearch->load();
		$this->vehicle_freight_comm->AdvancedSearch->load();
		$this->vehicle_freight_type->AdvancedSearch->load();
		$this->vehicle_freight_amount->AdvancedSearch->load();
		$this->vehicle_freight_final->AdvancedSearch->load();
		$this->operator->AdvancedSearch->load();
		$this->datetime->AdvancedSearch->load();
	}

	// Set up Breadcrumb
	protected function setupBreadcrumb()
	{
		global $Breadcrumb, $Language;
		$Breadcrumb = new Breadcrumb();
		$url = substr(CurrentUrl(), strrpos(CurrentUrl(), "/")+1);
		$Breadcrumb->add("list", $this->TableVar, $this->addMasterUrl("t_trip_infolist.php"), "", $this->TableVar, TRUE);
		$pageId = "search";
		$Breadcrumb->add("search", $pageId, $url);
	}

	// Set up multi pages
	protected function setupMultiPages()
	{
		$pages = new SubPages();
		$pages->Parent = "#" . $this->PageObjName;
		$pages->add(0);
		$pages->add(1);
		$pages->add(2);
		$pages->add(3);
		$pages->add(4);
		$pages->add(5);
		$pages->add(6);
		$pages->add(7);
		$this->MultiPages = $pages;
	}

	// Setup lookup options
	public function setupLookupOptions($fld)
	{
		if ($fld->Lookup !== NULL && $fld->Lookup->Options === NULL) {

			// No need to check any more
			$fld->Lookup->Options = [];

			// Set up lookup SQL
			switch ($fld->FieldVar) {
				case "x_vehicle":
					$lookupFilter = function() {
						return (CurrentPageID() == "add") ? "`status`=1 and `running_status` = 0" : "";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x__route":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_reports_to":
					$lookupFilter = function() {
						return "`activated`=1 and `userlevel`=1003";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_buyer":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignor":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_b_consignee":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_driver":
					$lookupFilter = function() {
						return "`status`=1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_agent":
					$lookupFilter = function() {
						return "`category` = 902 and `status` = 1";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				case "x_consignor":
					$lookupFilter = function() {
						return "`category` = 902";
					};
					$lookupFilter = $lookupFilter->bindTo($this);
					break;
				default:
					$lookupFilter = "";
					break;
			}

			// Always call to Lookup->getSql so that user can setup Lookup->Options in Lookup_Selecting server event
			$sql = $fld->Lookup->getSql(FALSE, "", $lookupFilter, $this);

			// Set up lookup cache
			if ($fld->UseLookupCache && $sql <> "" && count($fld->Lookup->ParentFields) == 0 && count($fld->Lookup->Options) == 0) {
				$conn = &$this->getConnection();
				$totalCnt = $this->getRecordCount($sql);
				if ($totalCnt > $fld->LookupCacheCount) // Total count > cache count, do not cache
					return;
				$rs = $conn->execute($sql);
				$ar = [];
				while ($rs && !$rs->EOF) {
					$row = &$rs->fields;

					// Format the field values
					switch ($fld->FieldVar) {
						case "x_vehicle":
							break;
						case "x__route":
							break;
						case "x_reports_to":
							break;
						case "x_buyer":
							break;
						case "x_b_consignor":
							break;
						case "x_b_consignee":
							break;
						case "x_driver":
							break;
						case "x_agent":
							break;
						case "x_consignor":
							break;
						case "x_operator":
							break;
					}
					$ar[strval($row[0])] = $row;
					$rs->moveNext();
				}
				if ($rs)
					$rs->close();
				$fld->Lookup->Options = $ar;
			}
		}
	}

	// Page Load event
	function Page_Load() {

		//echo "Page Load";
	}

	// Page Unload event
	function Page_Unload() {

		//echo "Page Unload";
	}

	// Page Redirecting event
	function Page_Redirecting(&$url) {

		// Example:
		//$url = "your URL";

	}

	// Message Showing event
	// $type = ''|'success'|'failure'|'warning'
	function Message_Showing(&$msg, $type) {
		if ($type == 'success') {

			//$msg = "your success message";
		} elseif ($type == 'failure') {

			//$msg = "your failure message";
		} elseif ($type == 'warning') {

			//$msg = "your warning message";
		} else {

			//$msg = "your message";
		}
	}

	// Page Render event
	function Page_Render() {

		//echo "Page Render";
		PageFieldValidate($this,'t_trip_info');	
	}

	// Page Data Rendering event
	function Page_DataRendering(&$header) {

		// Example:
		//$header = "your header";

	}

	// Page Data Rendered event
	function Page_DataRendered(&$footer) {

		// Example:
		//$footer = "your footer";

	}

	// Form Custom Validate event
	function Form_CustomValidate(&$customError) {

		// Return error message in CustomError
		return TRUE;
	}
}
?>